(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     77516,       2633]
NotebookOptionsPosition[     63744,       2142]
NotebookOutlinePosition[     64992,       2178]
CellTagsIndexPosition[     64906,       2173]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Complex Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/ComplexNumbers"], 
          "Numerical Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Complex Numbers\"\>", 
       2->"\<\"Numerical Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ConjugateTranspose" :> 
          Documentation`HelpLookup["paclet:ref/ConjugateTranspose"], 
          "ComplexExpand" :> 
          Documentation`HelpLookup["paclet:ref/ComplexExpand"], "Transpose" :> 
          Documentation`HelpLookup["paclet:ref/Transpose"], "Arg" :> 
          Documentation`HelpLookup["paclet:ref/Arg"], "Im" :> 
          Documentation`HelpLookup["paclet:ref/Im"], "Complex" :> 
          Documentation`HelpLookup["paclet:ref/Complex"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ConjugateTranspose\"\>", 
       2->"\<\"ComplexExpand\"\>", 3->"\<\"Transpose\"\>", 4->"\<\"Arg\"\>", 
       5->"\<\"Im\"\>", 6->"\<\"Complex\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Complex Numbers" :> 
          Documentation`HelpLookup["paclet:guide/ComplexNumbers"], 
          "Functions of Complex Variables" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsOfComplexVariables"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Complex Numbers\"\>", 
       2->"\<\"Functions of Complex Variables\"\>", 
       3->"\<\"Mathematical Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Conjugate", "ObjectName",
 CellID->1017],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Conjugate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Conjugate"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]or ",
     Cell[BoxData[
      RowBox[{
       StyleBox["z", "TI"], "\[Conjugate]"}]], "InlineFormula"],
     " gives the complex conjugate of the complex number ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14932]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData["\[Conjugate]"], "InlineFormula"],
 " can be entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]co\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]conj\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 Cell[TextData[ButtonBox["\\[Conjugate]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Conjugate"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->1806544984],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Conjugate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Conjugate"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->68986605],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->350882971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Conjugate", "[", 
  RowBox[{"1", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->95755613],

Cell[BoxData[
 RowBox[{"1", "-", "\[ImaginaryI]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->127444275]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->257461101],

Cell[TextData[{
 "Use ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]conj\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " to conjugate expressions:"
}], "ExampleText",
 CellID->278954348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "+", "I"}], ")"}], "\[Conjugate]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->63189110],

Cell[BoxData[
 RowBox[{"1", "-", "\[ImaginaryI]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->128686839]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19314],

Cell["Find complex conjugate of complex exponentials:", "ExampleText",
 CellID->940006917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Conjugate", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", " ", 
    RowBox[{"Pi", "/", "4"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->437451417],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "4"]}]]], "Output",
 ImageSize->{33, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->357076259]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->83300291],

Cell["Find complex conjugate of explicit algebraic numbers:", "ExampleText",
 CellID->499246908],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"5", "+", 
     RowBox[{"3", 
      RowBox[{"#", "^", "2"}]}], "+", 
     RowBox[{"5", 
      RowBox[{"#", "^", "6"}]}]}], "&"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->104839367],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"5", "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     RowBox[{"5", " ", 
      SuperscriptBox["#1", "6"]}]}], "&"}], ",", "4"}], "]"}]], "Output",
 ImageSize->{166, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->215138010]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Conjugate", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->151358529],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"5", "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     RowBox[{"5", " ", 
      SuperscriptBox["#1", "6"]}]}], "&"}], ",", "3"}], "]"}]], "Output",
 ImageSize->{166, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->319703696]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"N", "[", "%", "]"}], ",", " ", 
   RowBox[{"N", "[", "%%", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->128258745],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.8961947612414779`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.8961947612414779`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{217, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1674683]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22555028],

Cell["\<\
The precision of the output does not track the precision of the input:\
\>", "ExampleText",
 CellID->7608671],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Conjugate", "[", 
  RowBox[{"2", "-", 
   RowBox[{"1.6", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->145762535],

Cell[BoxData[
 RowBox[{"2", "+", 
  RowBox[{"1.6`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->727627582]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Conjugate", "[", 
  RowBox[{"2", "-", 
   RowBox[{"1.60000000000000000000000", "I"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->300351414],

Cell[BoxData[
 RowBox[{"2", "+", 
  RowBox[{"1.6`23.204119982655925", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{203, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->230938058]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->83450702],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Conjugate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Conjugate"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->131251659],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Conjugate", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "-", "I"}], ",", "0", ",", 
    RowBox[{"1", "+", "I"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->45148376],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "+", "\[ImaginaryI]"}], ",", "0", ",", 
   RowBox[{"1", "-", "\[ImaginaryI]"}]}], "}"}]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->978020921]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->663157772],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->557944228],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Conjugate", "[", "z", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->113182839],

Cell[BoxData[
 FormBox[
  SuperscriptBox["z", "\[Conjugate]"], TraditionalForm]], "Output",
 ImageSize->{13, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->628396117]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18651],

Cell["Infinite arguments give symbolic results:", "ExampleText",
 CellID->130666687],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Conjugate", "[", 
  RowBox[{"I", " ", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->115831509],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox[
    RowBox[{"-", "\[ImaginaryI]"}],
    "DirectedInfinityCoefficient",
    Editable->True], " ", "\[Infinity]"}],
  DirectedInfinity,
  Editable->False]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137131083]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Conjugate", "[", "ComplexInfinity", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->154551590],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->345243014]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22044],

Cell["\<\
Define a scalar product for complex\[Hyphen]valued lists:\
\>", "ExampleText",
 CellID->16707187],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[LeftAngleBracket]", 
   RowBox[{"a_", "\[VerticalSeparator]", "b_"}], "\[RightAngleBracket]"}], ":=",
   
  RowBox[{
   RowBox[{"Conjugate", "[", "a", "]"}], ".", "b"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->575622698],

Cell["Apply the definition:", "ExampleText",
 CellID->53513827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[LeftAngleBracket]", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "I"}], "}"}], "\[VerticalSeparator]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "I"}], ",", "2"}], "}"}]}], 
  "\[RightAngleBracket]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->496351007],

Cell[BoxData[
 RowBox[{"-", "\[ImaginaryI]"}]], "Output",
 ImageSize->{20, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->146628533]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->446526964],

Cell["\<\
Rewrite a complex-valued rational function into one with real denominator:\
\>", "ExampleText",
 CellID->12543191],

Cell[BoxData[
 RowBox[{
  RowBox[{"toRealDenominator", "[", "rat_", "]"}], " ", ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"c", " ", "=", " ", 
      RowBox[{"ComplexExpand", "[", 
       RowBox[{"Conjugate", "[", 
        RowBox[{"Denominator", "[", "rat", "]"}], "]"}], "]"}]}], "}"}], ",", 
    
    RowBox[{
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"Numerator", "[", "rat", "]"}], " ", "c"}], "]"}], "/", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"Denominator", "[", "rat", "]"}], " ", "c"}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->72452010],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"toRealDenominator", "[", 
  RowBox[{"1", "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "^", "2"}], " ", "+", " ", 
     RowBox[{"3", " ", "I", " ", "x"}], " ", "-", " ", "2", "+", 
     RowBox[{"4", "I"}]}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7967233],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "-", 
     RowBox[{"4", " ", "\[ImaginaryI]"}]}], ")"}], "-", 
   RowBox[{"3", " ", "\[ImaginaryI]", " ", "x"}], "+", 
   SuperscriptBox["x", "2"]}], 
  RowBox[{"20", "+", 
   RowBox[{"24", " ", "x"}], "+", 
   RowBox[{"5", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   SuperscriptBox["x", "4"]}]]], "Output",
 ImageSize->{134, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->144508969]
}, Open  ]],

Cell["Recover the original fraction:", "ExampleText",
 CellID->13339967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cancel", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->341946284],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     RowBox[{"4", " ", "\[ImaginaryI]"}]}], ")"}], "+", 
   RowBox[{"3", " ", "\[ImaginaryI]", " ", "x"}], "+", 
   SuperscriptBox["x", "2"]}]]], "Output",
 ImageSize->{134, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->495156264]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->524378705],

Cell["\<\
Implement a M\[ODoubleDot]bius transformation:\
\>", "ExampleText",
 CellID->78872524],

Cell[BoxData[
 RowBox[{
  RowBox[{"M\[ODoubleDot]biusTransformation", "[", 
   RowBox[{"a_", ",", "z_"}], "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"z", " ", "-", " ", "a"}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"1", " ", "-", " ", 
     RowBox[{
      RowBox[{"Conjugate", "[", "a", "]"}], " ", "z"}]}], ")"}]}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->368729815],

Cell["Plot the images of concentric circles:", "ExampleText",
 CellID->852928892],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", " ", "=", " ", 
   RowBox[{"1", "+", 
    RowBox[{"2", "I"}]}]}], ";"}], "\n", 
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Re", "[", 
         RowBox[{"M\[ODoubleDot]biusTransformation", "[", 
          RowBox[{"a", ",", 
           RowBox[{"\[Rho]", " ", 
            RowBox[{"Exp", "[", 
             RowBox[{"I", " ", "\[Phi]"}], "]"}]}]}], "]"}], "]"}], ",", 
        RowBox[{"Im", "[", 
         RowBox[{"M\[ODoubleDot]biusTransformation", "[", 
          RowBox[{"a", ",", 
           RowBox[{"\[Rho]", " ", 
            RowBox[{"Exp", "[", 
             RowBox[{"I", " ", "\[Phi]"}], "]"}]}]}], "]"}], "]"}]}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"\[Rho]", ",", "0", ",", "1", ",", 
        RowBox[{"1", "/", "10"}]}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", " ", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->12238834],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 190},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->302080214]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->458323469],

Cell[TextData[{
 "Write a real\[Hyphen]valued function as a function of ",
 Cell[BoxData["z"], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SuperscriptBox["z", "\[Conjugate]"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->220515],

Cell[BoxData[
 RowBox[{
  RowBox[{"toCCForm", "[", 
   RowBox[{"f_", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x_", ",", " ", "y_"}], "}"}], ",", " ", "z_"}], "]"}], " ", ":=",
   " ", 
  RowBox[{"f", " ", "/.", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", " ", "\[Rule]", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", " ", "+", " ", 
         RowBox[{"Conjugate", "[", "z", "]"}]}], ")"}], "/", "2"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", " ", "-", " ", 
         RowBox[{"Conjugate", "[", "z", "]"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "I"}], ")"}]}]}]}], "}"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->83517641],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"toCCForm", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "3"], "-", 
     RowBox[{"3", " ", "x", " ", 
      SuperscriptBox["y", "2"]}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", " ", "y"}], "}"}], ",", " ", "z"}], "]"}], " ", "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10649759],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["z", "3"], "+", 
    SuperscriptBox[
     RowBox[{"Conjugate", "[", "z", "]"}], "3"]}], ")"}]}]], "Output",
 ImageSize->{147, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->149165527]
}, Open  ]],

Cell[TextData[{
 "Holomorphic functions are independent of ",
 Cell[BoxData[
  SuperscriptBox["z", "\[Conjugate]"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->562603645],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"toCCForm", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "3"], "-", 
     RowBox[{"3", " ", "x", " ", 
      SuperscriptBox["y", "2"]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["x", "2"], " ", "y"}], "-", 
        SuperscriptBox["y", "3"]}], ")"}]}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", " ", "y"}], "}"}], ",", " ", "z"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->294239349],

Cell[BoxData[
 SuperscriptBox["z", "3"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->439622124]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->170050148],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Conjugate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Conjugate"]], "InlineFormula"],
 " to describe geometric regions:"
}], "ExampleText",
 CellID->66815487],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"z", "=", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}]}], "}"}], ",", 
   RowBox[{"RegionPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Abs", "[", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"Conjugate", "[", "z", "]"}], " ", 
         RowBox[{"Re", "[", "z", "]"}]}], " ", "+", " ", 
        RowBox[{"z", " ", 
         RowBox[{"Im", "[", "z", "]"}]}]}], " ", "]"}], " ", "<", "1"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->498522773],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7133502]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11258],

Cell["Some transformations are performed automatically:", "ExampleText",
 CellID->176903800],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Conjugate", "[", 
  RowBox[{"1", "/", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->468186532],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"Conjugate", "[", "z", "]"}]]], "Output",
 ImageSize->{93, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87716303]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Conjugate", "[", 
  RowBox[{"Re", "[", "z", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->224564430],

Cell[BoxData[
 RowBox[{"Re", "[", "z", "]"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->145303132]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Conjugate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Conjugate"]], "InlineFormula"],
 " is its own inverse:"
}], "ExampleText",
 CellID->327331737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Conjugate", "[", 
  RowBox[{"Conjugate", "[", "z", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->207820506],

Cell[BoxData["z"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->260157550]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7207464],

Cell[TextData[{
 "Simplify expressions containing ",
 Cell[BoxData[
  ButtonBox["Conjugate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Conjugate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->156104183],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"z", " ", 
  RowBox[{"Conjugate", "[", "z", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->507143826],

Cell[BoxData[
 RowBox[{"z", " ", 
  RowBox[{"Conjugate", "[", "z", "]"}]}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13028964]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17151640],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"Abs", "[", "z", "]"}], "2"]], "Output",
 ImageSize->{52, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16993763]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Conjugate", "[", 
   RowBox[{"z1", " ", "z2"}], "]"}], "-", 
  RowBox[{
   RowBox[{"Conjugate", "[", "z1", "]"}], 
   RowBox[{"Conjugate", "[", "z2", "]"}], " "}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->135751961],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Conjugate", "[", "z1", "]"}]}], " ", 
   RowBox[{"Conjugate", "[", "z2", "]"}]}], "+", 
  RowBox[{"Conjugate", "[", 
   RowBox[{"z1", " ", "z2"}], "]"}]}]], "Output",
 ImageSize->{318, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->497409532]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->99941626],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->94438583]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->670578482],

Cell["Assume real\[Hyphen]valued variables:", "ExampleText",
 CellID->161006112],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Conjugate", "[", 
  RowBox[{"x", " ", "+", " ", 
   RowBox[{"I", " ", "y"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->777868659],

Cell[BoxData[
 RowBox[{
  RowBox[{"Conjugate", "[", "x", "]"}], "-", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"Conjugate", "[", "y", "]"}]}]}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2414121]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->509334846],

Cell[BoxData[
 RowBox[{"x", "-", 
  RowBox[{"\[ImaginaryI]", " ", "y"}]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->418073021]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->138892865],

Cell["\<\
Assume generic complex\[Hyphen]valued variables:\
\>", "ExampleText",
 CellID->174507125],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{
   RowBox[{"Conjugate", "[", "z", "]"}], ",", " ", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->388904146],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "\[ImaginaryI]"}], " ", 
   RowBox[{"Im", "[", "z", "]"}]}], "+", 
  RowBox[{"Re", "[", "z", "]"}]}]], "Output",
 ImageSize->{106, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13989828]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{
   RowBox[{"Conjugate", "[", 
    RowBox[{"Sqrt", "[", "z", "]"}], "]"}], ",", " ", "z"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->53583142],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cos", "[", 
    FractionBox[
     RowBox[{"Arg", "[", "z", "]"}], "2"], "]"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Im", "[", "z", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"Re", "[", "z", "]"}], "2"]}], ")"}], 
    RowBox[{"1", "/", "4"}]]}], "-", 
  RowBox[{"\[ImaginaryI]", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Im", "[", "z", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"Re", "[", "z", "]"}], "2"]}], ")"}], 
    RowBox[{"1", "/", "4"}]], " ", 
   RowBox[{"Sin", "[", 
    FractionBox[
     RowBox[{"Arg", "[", "z", "]"}], "2"], "]"}]}]}]], "Output",
 ImageSize->{443, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->70331526]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->338796853],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Conjugate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Conjugate"]], "InlineFormula"],
 " as an option value in ",
 Cell[BoxData[
  ButtonBox["ComplexExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexExpand"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->32909595],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{
   RowBox[{"Re", "[", "x", "]"}], ",", "x", ",", 
   RowBox[{"TargetFunctions", "->", 
    RowBox[{"{", "Conjugate", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->483112540],

Cell[BoxData[
 RowBox[{
  FractionBox["x", "2"], "+", 
  FractionBox[
   RowBox[{"Conjugate", "[", "x", "]"}], "2"]}]], "Output",
 ImageSize->{116, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->225390870]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->169632290],

Cell["\<\
Integrate along a line in the complex plane, symbolically and numerically:\
\>", "ExampleText",
 CellID->24372534],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Conjugate", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "I"}], ",", 
     RowBox[{"Pi", "+", "I"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->802410761],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "3"], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", "\[Pi]"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"6", " ", "\[ImaginaryI]"}]}], ")"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "-", 
         RowBox[{"3", " ", "\[ImaginaryI]"}]}], ")"}], "+", "\[Pi]"}], ")"}], 
     " ", "\[Pi]"}]}], ")"}]}]], "Output",
 ImageSize->{246, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->265557752]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->281035873],

Cell[BoxData[
 RowBox[{"7.860499573176812`", "\[InvisibleSpace]", "-", 
  RowBox[{"5.869604401089358`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->157653745]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Conjugate", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "I"}], ",", 
     RowBox[{"Pi", "+", "I"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->437845925],

Cell[BoxData[
 RowBox[{"7.860499573176836`", "\[InvisibleSpace]", "-", 
  RowBox[{"5.869604401089363`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->254277729]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->546200930],

Cell["Find Hermitian conjugate of a matrix:", "ExampleText",
 CellID->379616352],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"RandomComplex", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "-", "I"}], ",", 
       RowBox[{"1", "+", "I"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87950186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Conjugate", "[", 
   RowBox[{"Transpose", "[", "m", "]"}], "]"}], "//", "MatrixForm"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->623724976],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"0.00364402902678318`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.7049198773124283`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{
       RowBox[{"-", "0.32269266359207593`"}], "+", 
       RowBox[{"0.27606738344241144`", " ", "\[ImaginaryI]"}]}]},
     {
      RowBox[{
       RowBox[{"-", "0.9196823591450394`"}], "-", 
       RowBox[{"0.0419815991196546`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{"0.0986565309100591`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.15156979867964226`", " ", "\[ImaginaryI]"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{327, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->5849898]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ConjugateTranspose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ConjugateTranspose"]], "InlineFormula"],
 " instead:"
}], "ExampleText",
 CellID->9837120],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ConjugateTranspose", "[", "m", "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->89462256],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"0.00364402902678318`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.7049198773124283`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{
       RowBox[{"-", "0.32269266359207593`"}], "+", 
       RowBox[{"0.27606738344241144`", " ", "\[ImaginaryI]"}]}]},
     {
      RowBox[{
       RowBox[{"-", "0.9196823591450394`"}], "-", 
       RowBox[{"0.0419815991196546`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{"0.0986565309100591`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.15156979867964226`", " ", "\[ImaginaryI]"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{327, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->29292843]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->335],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Conjugate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Conjugate"]], "InlineFormula"],
 " does not always propagate into arguments:"
}], "ExampleText",
 CellID->286543425],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Conjugate", "[", 
  RowBox[{"Sin", "[", "z", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->629948037],

Cell[BoxData[
 RowBox[{"Conjugate", "[", 
  RowBox[{"Sin", "[", "z", "]"}], "]"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->93222360]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Conjugate", "[", 
  RowBox[{"Exp", "[", "z", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->367581135],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"Conjugate", "[", "z", "]"}]]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->88597629]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->74260846],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Conjugate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Conjugate"]], "InlineFormula"],
 " can stay unevaluated for numeric arguments:"
}], "ExampleText",
 CellID->417578785],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Conjugate", "[", 
  RowBox[{"ArcSin", "[", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "-", 
     RowBox[{"2", " ", "E"}], "-", 
     RowBox[{"E", "^", "2"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "E"}], ")"}], "^", "2"}]}], ")"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->516418613],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(ArcSin[\\(\\(1 + \\(\\(2\\\\ \
\[ExponentialE]\\)\\) + \[ExponentialE]\\^2 - \\((1 + \[ExponentialE])\\)\\^2\
\\)\\)]\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->104173076],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(ArcSin[\\(\\(1 + \\(\\(2\\\\ \
\[ExponentialE]\\)\\) + \[ExponentialE]\\^2 - \\((1 + \[ExponentialE])\\)\\^2\
\\)\\)]\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->200565515],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Conjugate", "[", 
   RowBox[{"ArcSin", "[", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "\[ExponentialE]"}], "+", 
     SuperscriptBox["\[ExponentialE]", "2"], "-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "\[ExponentialE]"}], ")"}], "2"]}], "]"}], 
   "]"}]}]], "Output",
 ImageSize->{266, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55753333]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->470587102],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->115301190]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23648432],

Cell[TextData[{
 "Machine\[Hyphen]precision numeric evaluation of ",
 Cell[BoxData[
  ButtonBox["Conjugate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Conjugate"]], "InlineFormula"],
 " can give wrong results:"
}], "ExampleText",
 CellID->193663414],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Conjugate", "[", 
  RowBox[{"ArcSin", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      RowBox[{"2", " ", "E"}], "-", 
      RowBox[{"E", "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "E"}], ")"}], "^", "2"}]}], ")"}], "+", 
    RowBox[{"10", "^", 
     RowBox[{"-", "20"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->864028282],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"ArcSin", "[", 
   RowBox[{
    FractionBox["99999999999999999999", "100000000000000000000"], "+", 
    RowBox[{"2", " ", "\[ExponentialE]"}], "+", 
    SuperscriptBox["\[ExponentialE]", "2"], "-", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "\[ExponentialE]"}], ")"}], "2"]}], "]"}]}]], "Output",\

 ImageSize->{346, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->189755489]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->507321614],

Cell[BoxData[
 RowBox[{"-", "8.881784197001252`*^-16"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->109793854]
}, Open  ]],

Cell["Use arbitrary precision evaluation instead:", "ExampleText",
 CellID->25665735],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"%%", ",", " ", "20"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->77304453],

Cell[BoxData["1.`20.*^-20"], "Output",
 ImageSize->{192, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->523745426]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->114575124],

Cell[TextData[{
 "Differentiating ",
 Cell[BoxData[
  ButtonBox["Conjugate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Conjugate"]], "InlineFormula"],
 " is not possible:"
}], "ExampleText",
 CellID->71408410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"Conjugate", "[", "t", "]"}], ",", " ", "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->176154837],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["Conjugate", "\[Prime]",
   MultilineFunction->None], "[", "t", "]"}]], "Output",
 ImageSize->{92, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->57943020]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19090],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ConjugateTranspose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ConjugateTranspose"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComplexExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComplexExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Transpose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Transpose"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Arg",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arg"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Im",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Im"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Complex",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Complex"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19497]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13169],

Cell[TextData[ButtonBox["Complex Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ComplexNumbers"]], "Tutorials",
 CellID->23831],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalFunctions"]], "Tutorials",
 CellID->20040]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->26488],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/ComplexConjugate.html"], 
   None}], "IT"]], "RelatedLinks",
 CellID->224553111],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ComplexComponents/Conjugate/"], 
   None}]], "RelatedLinks",
 CellID->720032862]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->705360912],

Cell[TextData[ButtonBox["Complex Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComplexNumbers"]], "MoreAbout",
 CellID->76514187],

Cell[TextData[ButtonBox["Functions of Complex Variables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsOfComplexVariables"]], "MoreAbout",
 CellID->756333452],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->8930427]
}, Open  ]],

Cell["New in 1  |  Last modified in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Conjugate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 29, 56.0733752}", "context" -> "System`", 
    "keywords" -> {"complex conjugate"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Conjugate[z] or z\\[Conjugate] gives the complex conjugate of the \
complex number z. ", "synonyms" -> {"conj", "adjoint"}, "title" -> 
    "Conjugate", "type" -> "Symbol", "uri" -> "ref/Conjugate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5459, 171, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->68986605]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 64764, 2166}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2711, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3334, 88, 46, 1, 70, "ObjectName",
 CellID->1017],
Cell[3383, 91, 682, 22, 70, "Usage",
 CellID->14932]
}, Open  ]],
Cell[CellGroupData[{
Cell[4102, 118, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4580, 135, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4703, 141, 513, 16, 70, "Notes",
 CellID->1806544984],
Cell[5219, 159, 203, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[5459, 171, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->68986605],
Cell[CellGroupData[{
Cell[5843, 185, 148, 5, 70, "ExampleSection",
 CellID->350882971],
Cell[CellGroupData[{
Cell[6016, 194, 127, 4, 28, "Input",
 CellID->95755613],
Cell[6146, 200, 192, 6, 36, "Output",
 CellID->127444275]
}, Open  ]],
Cell[6353, 209, 125, 3, 70, "ExampleDelimiter",
 CellID->257461101],
Cell[6481, 214, 210, 7, 70, "ExampleText",
 CellID->278954348],
Cell[CellGroupData[{
Cell[6716, 225, 144, 5, 28, "Input",
 CellID->63189110],
Cell[6863, 232, 192, 6, 36, "Output",
 CellID->128686839]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7104, 244, 216, 7, 70, "ExampleSection",
 CellID->19314],
Cell[7323, 253, 90, 1, 70, "ExampleText",
 CellID->940006917],
Cell[CellGroupData[{
Cell[7438, 258, 185, 6, 70, "Input",
 CellID->437451417],
Cell[7626, 266, 276, 9, 44, "Output",
 CellID->357076259]
}, Open  ]],
Cell[7917, 278, 124, 3, 70, "ExampleDelimiter",
 CellID->83300291],
Cell[8044, 283, 96, 1, 70, "ExampleText",
 CellID->499246908],
Cell[CellGroupData[{
Cell[8165, 288, 273, 10, 70, "Input",
 CellID->104839367],
Cell[8441, 300, 376, 13, 39, "Output",
 CellID->215138010]
}, Open  ]],
Cell[CellGroupData[{
Cell[8854, 318, 105, 3, 70, "Input",
 CellID->151358529],
Cell[8962, 323, 376, 13, 39, "Output",
 CellID->319703696]
}, Open  ]],
Cell[CellGroupData[{
Cell[9375, 341, 179, 6, 70, "Input",
 CellID->128258745],
Cell[9557, 349, 409, 12, 36, "Output",
 CellID->1674683]
}, Open  ]],
Cell[9981, 364, 124, 3, 70, "ExampleDelimiter",
 CellID->22555028],
Cell[10108, 369, 119, 3, 70, "ExampleText",
 CellID->7608671],
Cell[CellGroupData[{
Cell[10252, 376, 149, 5, 70, "Input",
 CellID->145762535],
Cell[10404, 383, 218, 7, 36, "Output",
 CellID->727627582]
}, Open  ]],
Cell[CellGroupData[{
Cell[10659, 395, 171, 5, 70, "Input",
 CellID->300351414],
Cell[10833, 402, 237, 7, 36, "Output",
 CellID->230938058]
}, Open  ]],
Cell[11085, 412, 124, 3, 70, "ExampleDelimiter",
 CellID->83450702],
Cell[11212, 417, 212, 7, 70, "ExampleText",
 CellID->131251659],
Cell[CellGroupData[{
Cell[11449, 428, 232, 8, 70, "Input",
 CellID->45148376],
Cell[11684, 438, 306, 10, 36, "Output",
 CellID->978020921]
}, Open  ]],
Cell[12005, 451, 125, 3, 70, "ExampleDelimiter",
 CellID->663157772],
Cell[12133, 456, 203, 7, 70, "ExampleText",
 CellID->557944228],
Cell[CellGroupData[{
Cell[12361, 467, 143, 4, 70, "Input",
 CellID->113182839],
Cell[12507, 473, 238, 7, 50, "Output",
 CellID->628396117]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12794, 486, 239, 7, 70, "ExampleSection",
 CellID->18651],
Cell[13036, 495, 84, 1, 70, "ExampleText",
 CellID->130666687],
Cell[CellGroupData[{
Cell[13145, 500, 135, 4, 70, "Input",
 CellID->115831509],
Cell[13283, 506, 339, 13, 36, "Output",
 CellID->137131083]
}, Open  ]],
Cell[CellGroupData[{
Cell[13659, 524, 119, 3, 70, "Input",
 CellID->154551590],
Cell[13781, 529, 173, 5, 36, "Output",
 CellID->345243014]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14003, 540, 223, 7, 70, "ExampleSection",
 CellID->22044],
Cell[14229, 549, 107, 3, 70, "ExampleText",
 CellID->16707187],
Cell[14339, 554, 261, 8, 70, "Input",
 CellID->575622698],
Cell[14603, 564, 63, 1, 70, "ExampleText",
 CellID->53513827],
Cell[CellGroupData[{
Cell[14691, 569, 293, 10, 70, "Input",
 CellID->496351007],
Cell[14987, 581, 187, 6, 36, "Output",
 CellID->146628533]
}, Open  ]],
Cell[15189, 590, 125, 3, 70, "ExampleDelimiter",
 CellID->446526964],
Cell[15317, 595, 124, 3, 70, "ExampleText",
 CellID->12543191],
Cell[15444, 600, 639, 20, 70, "Input",
 CellID->72452010],
Cell[CellGroupData[{
Cell[16108, 624, 306, 9, 70, "Input",
 CellID->7967233],
Cell[16417, 635, 535, 18, 56, "Output",
 CellID->144508969]
}, Open  ]],
Cell[16967, 656, 72, 1, 70, "ExampleText",
 CellID->13339967],
Cell[CellGroupData[{
Cell[17064, 661, 102, 3, 70, "Input",
 CellID->341946284],
Cell[17169, 666, 391, 13, 54, "Output",
 CellID->495156264]
}, Open  ]],
Cell[17575, 682, 125, 3, 70, "ExampleDelimiter",
 CellID->524378705],
Cell[17703, 687, 96, 3, 70, "ExampleText",
 CellID->78872524],
Cell[17802, 692, 397, 13, 70, "Input",
 CellID->368729815],
Cell[18202, 707, 81, 1, 70, "ExampleText",
 CellID->852928892],
Cell[CellGroupData[{
Cell[18308, 712, 1094, 32, 70, "Input",
 CellID->12238834],
Cell[19405, 746, 13027, 218, 70, "Output",
 Evaluatable->False,
 CellID->302080214]
}, Open  ]],
Cell[32447, 967, 125, 3, 70, "ExampleDelimiter",
 CellID->458323469],
Cell[32575, 972, 236, 8, 70, "ExampleText",
 CellID->220515],
Cell[32814, 982, 727, 23, 70, "Input",
 CellID->83517641],
Cell[CellGroupData[{
Cell[33566, 1009, 358, 12, 70, "Input",
 CellID->10649759],
Cell[33927, 1023, 340, 12, 51, "Output",
 CellID->149165527]
}, Open  ]],
Cell[34282, 1038, 178, 6, 70, "ExampleText",
 CellID->562603645],
Cell[CellGroupData[{
Cell[34485, 1048, 557, 18, 70, "Input",
 CellID->294239349],
Cell[35045, 1068, 181, 6, 36, "Output",
 CellID->439622124]
}, Open  ]],
Cell[35241, 1077, 125, 3, 70, "ExampleDelimiter",
 CellID->170050148],
Cell[35369, 1082, 218, 8, 70, "ExampleText",
 CellID->66815487],
Cell[CellGroupData[{
Cell[35612, 1094, 763, 25, 70, "Input",
 CellID->498522773],
Cell[36378, 1121, 2817, 50, 70, "Output",
 Evaluatable->False,
 CellID->7133502]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39244, 1177, 233, 7, 70, "ExampleSection",
 CellID->11258],
Cell[39480, 1186, 92, 1, 70, "ExampleText",
 CellID->176903800],
Cell[CellGroupData[{
Cell[39597, 1191, 128, 4, 70, "Input",
 CellID->468186532],
Cell[39728, 1197, 213, 7, 53, "Output",
 CellID->87716303]
}, Open  ]],
Cell[CellGroupData[{
Cell[39978, 1209, 134, 4, 70, "Input",
 CellID->224564430],
Cell[40115, 1215, 186, 6, 36, "Output",
 CellID->145303132]
}, Open  ]],
Cell[40316, 1224, 199, 7, 70, "ExampleText",
 CellID->327331737],
Cell[CellGroupData[{
Cell[40540, 1235, 141, 4, 70, "Input",
 CellID->207820506],
Cell[40684, 1241, 158, 5, 36, "Output",
 CellID->260157550]
}, Open  ]],
Cell[40857, 1249, 123, 3, 70, "ExampleDelimiter",
 CellID->7207464],
Cell[40983, 1254, 217, 8, 70, "ExampleText",
 CellID->156104183],
Cell[CellGroupData[{
Cell[41225, 1266, 128, 4, 70, "Input",
 CellID->507143826],
Cell[41356, 1272, 215, 7, 36, "Output",
 CellID->13028964]
}, Open  ]],
Cell[CellGroupData[{
Cell[41608, 1284, 107, 3, 70, "Input",
 CellID->17151640],
Cell[41718, 1289, 210, 7, 36, "Output",
 CellID->16993763]
}, Open  ]],
Cell[CellGroupData[{
Cell[41965, 1301, 253, 8, 70, "Input",
 CellID->135751961],
Cell[42221, 1311, 362, 12, 36, "Output",
 CellID->497409532]
}, Open  ]],
Cell[CellGroupData[{
Cell[42620, 1328, 107, 3, 70, "Input",
 CellID->99941626],
Cell[42730, 1333, 157, 5, 36, "Output",
 CellID->94438583]
}, Open  ]],
Cell[42902, 1341, 125, 3, 70, "ExampleDelimiter",
 CellID->670578482],
Cell[43030, 1346, 80, 1, 70, "ExampleText",
 CellID->161006112],
Cell[CellGroupData[{
Cell[43135, 1351, 162, 5, 70, "Input",
 CellID->777868659],
Cell[43300, 1358, 287, 9, 36, "Output",
 CellID->2414121]
}, Open  ]],
Cell[CellGroupData[{
Cell[43624, 1372, 109, 3, 70, "Input",
 CellID->509334846],
Cell[43736, 1377, 215, 7, 36, "Output",
 CellID->418073021]
}, Open  ]],
Cell[43966, 1387, 125, 3, 70, "ExampleDelimiter",
 CellID->138892865],
Cell[44094, 1392, 99, 3, 70, "ExampleText",
 CellID->174507125],
Cell[CellGroupData[{
Cell[44218, 1399, 174, 5, 70, "Input",
 CellID->388904146],
Cell[44395, 1406, 293, 10, 36, "Output",
 CellID->13989828]
}, Open  ]],
Cell[CellGroupData[{
Cell[44725, 1421, 206, 6, 70, "Input",
 CellID->53583142],
Cell[44934, 1429, 872, 30, 51, "Output",
 CellID->70331526]
}, Open  ]],
Cell[45821, 1462, 125, 3, 70, "ExampleDelimiter",
 CellID->338796853],
Cell[45949, 1467, 345, 13, 70, "ExampleText",
 CellID->32909595],
Cell[CellGroupData[{
Cell[46319, 1484, 244, 7, 70, "Input",
 CellID->483112540],
Cell[46566, 1493, 260, 9, 51, "Output",
 CellID->225390870]
}, Open  ]],
Cell[46841, 1505, 125, 3, 70, "ExampleDelimiter",
 CellID->169632290],
Cell[46969, 1510, 124, 3, 70, "ExampleText",
 CellID->24372534],
Cell[CellGroupData[{
Cell[47118, 1517, 324, 11, 70, "Input",
 CellID->802410761],
Cell[47445, 1530, 616, 22, 51, "Output",
 CellID->265557752]
}, Open  ]],
Cell[CellGroupData[{
Cell[48098, 1557, 97, 3, 70, "Input",
 CellID->281035873],
Cell[48198, 1562, 271, 7, 36, "Output",
 CellID->157653745]
}, Open  ]],
Cell[CellGroupData[{
Cell[48506, 1574, 325, 11, 70, "Input",
 CellID->437845925],
Cell[48834, 1587, 271, 7, 36, "Output",
 CellID->254277729]
}, Open  ]],
Cell[49120, 1597, 125, 3, 70, "ExampleDelimiter",
 CellID->546200930],
Cell[49248, 1602, 80, 1, 70, "ExampleText",
 CellID->379616352],
Cell[49331, 1605, 371, 13, 70, "Input",
 CellID->87950186],
Cell[CellGroupData[{
Cell[49727, 1622, 177, 6, 70, "Input",
 CellID->623724976],
Cell[49907, 1630, 1228, 32, 63, "Output",
 CellID->5849898]
}, Open  ]],
Cell[51150, 1665, 213, 8, 70, "ExampleText",
 CellID->9837120],
Cell[CellGroupData[{
Cell[51388, 1677, 149, 5, 70, "Input",
 CellID->89462256],
Cell[51540, 1684, 1229, 32, 63, "Output",
 CellID->29292843]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[52818, 1722, 224, 7, 70, "ExampleSection",
 CellID->335],
Cell[53045, 1731, 221, 7, 70, "ExampleText",
 CellID->286543425],
Cell[CellGroupData[{
Cell[53291, 1742, 135, 4, 70, "Input",
 CellID->629948037],
Cell[53429, 1748, 223, 7, 36, "Output",
 CellID->93222360]
}, Open  ]],
Cell[CellGroupData[{
Cell[53689, 1760, 135, 4, 70, "Input",
 CellID->367581135],
Cell[53827, 1766, 230, 7, 36, "Output",
 CellID->88597629]
}, Open  ]],
Cell[54072, 1776, 124, 3, 70, "ExampleDelimiter",
 CellID->74260846],
Cell[54199, 1781, 223, 7, 70, "ExampleText",
 CellID->417578785],
Cell[CellGroupData[{
Cell[54447, 1792, 364, 13, 70, "Input",
 CellID->516418613],
Cell[54814, 1807, 532, 10, 70, "Message",
 CellID->104173076],
Cell[55349, 1819, 532, 10, 70, "Message",
 CellID->200565515],
Cell[55884, 1831, 471, 15, 39, "Output",
 CellID->55753333]
}, Open  ]],
Cell[CellGroupData[{
Cell[56392, 1851, 104, 3, 70, "Input",
 CellID->470587102],
Cell[56499, 1856, 158, 5, 36, "Output",
 CellID->115301190]
}, Open  ]],
Cell[56672, 1864, 124, 3, 70, "ExampleDelimiter",
 CellID->23648432],
Cell[56799, 1869, 256, 8, 70, "ExampleText",
 CellID->193663414],
Cell[CellGroupData[{
Cell[57080, 1881, 441, 15, 70, "Input",
 CellID->864028282],
Cell[57524, 1898, 489, 15, 51, "Output",
 CellID->189755489]
}, Open  ]],
Cell[CellGroupData[{
Cell[58050, 1918, 97, 3, 70, "Input",
 CellID->507321614],
Cell[58150, 1923, 198, 6, 36, "Output",
 CellID->109793854]
}, Open  ]],
Cell[58363, 1932, 85, 1, 70, "ExampleText",
 CellID->25665735],
Cell[CellGroupData[{
Cell[58473, 1937, 126, 4, 70, "Input",
 CellID->77304453],
Cell[58602, 1943, 169, 5, 36, "Output",
 CellID->523745426]
}, Open  ]],
Cell[58786, 1951, 125, 3, 70, "ExampleDelimiter",
 CellID->114575124],
Cell[58914, 1956, 216, 8, 70, "ExampleText",
 CellID->71408410],
Cell[CellGroupData[{
Cell[59155, 1968, 162, 5, 70, "Input",
 CellID->176154837],
Cell[59320, 1975, 251, 8, 36, "Output",
 CellID->57943020]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[59632, 1990, 311, 9, 70, "SeeAlsoSection",
 CellID->19090],
Cell[59946, 2001, 1439, 53, 70, "SeeAlso",
 CellID->19497]
}, Open  ]],
Cell[CellGroupData[{
Cell[61422, 2059, 314, 9, 70, "TutorialsSection",
 CellID->13169],
Cell[61739, 2070, 140, 3, 70, "Tutorials",
 CellID->23831],
Cell[61882, 2075, 148, 3, 70, "Tutorials",
 CellID->20040]
}, Open  ]],
Cell[CellGroupData[{
Cell[62067, 2083, 321, 9, 70, "RelatedLinksSection",
 CellID->26488],
Cell[62391, 2094, 207, 5, 70, "RelatedLinks",
 CellID->224553111],
Cell[62601, 2101, 219, 5, 70, "RelatedLinks",
 CellID->720032862]
}, Open  ]],
Cell[CellGroupData[{
Cell[62857, 2111, 319, 9, 70, "MoreAboutSection",
 CellID->705360912],
Cell[63179, 2122, 140, 3, 70, "MoreAbout",
 CellID->76514187],
Cell[63322, 2127, 169, 3, 70, "MoreAbout",
 CellID->756333452],
Cell[63494, 2132, 153, 3, 70, "MoreAbout",
 CellID->8930427]
}, Open  ]],
Cell[63662, 2138, 52, 0, 70, "History"],
Cell[63717, 2140, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

