(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     45056,       1512]
NotebookOptionsPosition[     37822,       1257]
NotebookOutlinePosition[     39134,       1294]
CellTagsIndexPosition[     39048,       1289]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Matrix Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/BasicMatrixOperations"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Basic Matrix Operations\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Conjugate" :> Documentation`HelpLookup["paclet:ref/Conjugate"],
           "Transpose" :> Documentation`HelpLookup["paclet:ref/Transpose"], 
          "Inverse" :> Documentation`HelpLookup["paclet:ref/Inverse"], 
          "HermitianMatrixQ" :> 
          Documentation`HelpLookup["paclet:ref/HermitianMatrixQ"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Conjugate\"\>", 
       2->"\<\"Transpose\"\>", 3->"\<\"Inverse\"\>", 
       4->"\<\"HermitianMatrixQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Complex Numbers" :> 
          Documentation`HelpLookup["paclet:guide/ComplexNumbers"], 
          "Matrix Operations" :> 
          Documentation`HelpLookup["paclet:guide/MatrixOperations"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Complex Numbers\"\>", 
       2->"\<\"Matrix Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ConjugateTranspose", "ObjectName",
 CellID->2670],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ConjugateTranspose",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ConjugateTranspose"], "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]or ",
     Cell[BoxData[
      FormBox[
       SuperscriptBox["m", "\[ConjugateTranspose]"], TraditionalForm]], 
      "InlineMath"],
     " gives the conjugate transpose of ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26428]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ConjugateTranspose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ConjugateTranspose"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Conjugate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Conjugate"], "[", 
   RowBox[{
    ButtonBox["Transpose",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Transpose"], "[", 
    StyleBox["m", "TI"], "]"}], "]"}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->285582147,
  ButtonNote->"285582147"]
}], "Notes",
 CellID->28027],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[ConjugateTranspose]", TraditionalForm]], "InlineMath"],
 " can be entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]ct\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 Cell[BoxData["\\[ConjugateTranspose]"], "InlineCharacterName"],
 "."
}], "Notes",
 CellID->4084],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ConjugateTranspose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ConjugateTranspose"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " can also be given as ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["m", "\[HermitianConjugate]"], TraditionalForm]], 
  "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["\[HermitianConjugate]", TraditionalForm]], "InlineMath"],
 " can be entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]hc\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 Cell[BoxData["\\[HermitianConjugate]"], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->10075]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->273113814],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->85122419],

Cell["Conjugate transpose of a complex-valued matrix:", "ExampleText",
 CellID->769296498],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"2", " ", "I"}], ",", "3"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3", "+", 
        RowBox[{"4", " ", "I"}]}], ",", "5", ",", "I"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->317527725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->90337760],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVU1vwjAMDTSBbjChCdFx4IC0E/v4G9uJ4w4cK0CCA9oE/H8vTjKI3lxm
cV6lNn3uq1/sOM68Pm7Wu/q4XdbT9339tdkuD9O3z703FS1jzMrfk7Hx7+Tf
wr0i8mN8On4WbA2X+QBsA8sKVoYl2Mtk5+9dP94mXCWMaoXoPVjdCQeOMV1g
3QDOfTO/J3p5ABZ6lWcksVyKp+PHDngdAH+kUi2EbDZFeMIX86SZC6q0xblw
hG2BHSK3Z/xbv0+xBsZX6SJrAF5cWok+8Kpk16lYMZP3oFXBX48q3y7FP2zI
INephfyQUHOy98U/K1tDXsIZnfdm3oOwXzTXeY5npNljcq/R76wcPwEuQQv3
M/6vU3kG/FfXuE7l5cJ3VrmjuCfktcEujP3vFfBPV8a5604dZMkrPxKtulPE
pmg5K1JF9kg+VaM33UkdT3XT+gbgsyjv\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->600971031]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ConjugateTranspose", "[", "m", "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->619130972],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", 
      RowBox[{"3", "-", 
       RowBox[{"4", " ", "\[ImaginaryI]"}]}]},
     {
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]"}], "5"},
     {"3", 
      RowBox[{"-", "\[ImaginaryI]"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{96, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->307431982]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->332441747],

Cell[TextData[{
 "Enter using ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]ct\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ":"
}], "ExampleText",
 CellID->18569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"2", "+", "I"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "}"}], 
  "\[ConjugateTranspose]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2807],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "-", "\[ImaginaryI]"}], ",", "4"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{129, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->140931756]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2363],

Cell["Conjugate transpose a sparse array:", "ExampleText",
 CellID->37242249],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", " ", "=", " ", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", " ", "i_"}], "}"}], "\[Rule]", "1"}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", " ", "j_"}], "}"}], "/;", 
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"i", "-", "j"}], "]"}], "\[Equal]", "1"}]}], "\[Rule]", 
       RowBox[{"i", " ", "+", " ", 
        RowBox[{"j", " ", "I"}]}]}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->408654767],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "13", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 13, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->185222882]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "s", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->137421671],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWTFvEzEUvtzlmoYKlVIQbCkgKCEtP6MVAz8iqpDaAYFKh2wZM2a8MT8h
440ZM2aMxEDGdMuY0dg+u+c8ns825wsZiJQ823lnf+/5+X32+XP37vrL1+7d
zVX35PK2+/365urHycW3W9oU1YIguKffTy8DWia0xL/3hFCp/sbsNxqNRoR/
gp+83u/3RT3iWnVenM/naZqyIqtHtMNXQnaA3Of6bMSsl33Rzp5rUNmkMqby
rRx9NpvB0ZIkUTHED71xnSBooa1th9YGQNkE9VipM/3H4P8M/Xq97vV6OfpI
tmYGZNaUQn8Oxo2E9xi+PSr3DDjf8fpgMKCgWDF8wBlOp9PYO74Yqxd6X4+a
BhwNu03UPDaWy6Uf734geMxyr9bzui3ifJWoiPMV5QexOu5TgIv5O9bio0GQ
Lfd/hu8F+P+UbK73GoorJvqcw6aJjRIi83gg2tugP3yUX/+1NP4+F1LNNkSs
E9mu5vYzS/2GFRqXqKwmH/nptendWhbXjAXqwu+uLOb6fDUW+GdnP736t5Zn
Ry2vsCKrw0yGWWjuSa412JN/qzpghGOARO5ZoA3wuSeIBfFWEB+iWpCrTHif
WeHEcmsoeouQNSg57KOiVw/wffYucsmuasF5gP6UOykmVW7T7RnhOeeRqL+3
QuMSvXCl/x2n+cmRB2gvpyVsfgNGlNkD7iVMGdL15FS9JXDXgOX+6nch/u1k
KwjbfaOnqgL7Opp+zKex6ufuCNR1nAbn6BAglVnFP+IW2mrHbHguUG1m9ecl
MMNse0SK2U6eII6J/mRnn113lYO2ryV3+hiHqCzX1ujBE5xkOXkiL8N2rvnQ
jsHKZEV8BPuIx3azJqvgG5TNXTCe/auxADKu6/x0DM9v3yIsml0sOrN4Hju9
+bcE5kOG1IaPdDzmH6F+r2Bewzhr4fxTdo1KlilioSK2cs9+u8oNLlrD4dBC
K79bUrWSJFmtVoTkbNQielZSz2CQbaTMZnuxWIzHY1ZU326naSpumOBqhbFY
PXPgrdm7+clkgtx2UEcJm0zopa9M5yRfeGkEbNwpwZs7yH8mb5vYxRfuPEZz
3CGNENfoMJ1uyuNld4whnX3uWeHP3L91A17dWzg/uP64oxX4sqs5G3zlc3wR
uhxHhk5m9NdCshsjm4wuJWd+cW8e1H4D7o9buw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{232, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->152798362]
}, Open  ]],

Cell["The conjugate transpose is sparse:", "ExampleText",
 CellID->60816758],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"st", " ", "=", " ", 
  RowBox[{"ConjugateTranspose", "[", "s", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->556641905],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "13", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 13, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->16369314]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "st", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->224950764],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWT9vGjEUPzgOkkYR/xo1Y5Y2hZB+jFYd+iFQVCkZqlZpBjZGRsYb+QiM
NzIyMjKyVKIbUhZG189nx+bF5s53voShkYj/YPv9/N7z+/nhb/2H2+8/+g93
N/2LL/f9X7d3N78vPv+8p11+yfO8R/r5eu7ROqE19nkkhJbq/wD++5PJhLA/
7w9rD4dD3vbZqAqrLpfLKIqgCm2fLniFymte1nlZpWWNlse0DGj5XkhbLBZ4
9TAMVZkwnIg/Wvc6Fr3XbJmnXu9UO6qmjIL2KZoVo91ut4PBQKL1RW8MOEaf
Cy30Vr1YDwHXloojSMD5gbVHoxEFBdXyE87yfD4PnOB73tvOhJI6EHWjXZTM
9uv12o02u2wZKdfzGiT2xqNUCKWXqwjliciP8ArhaCAccGoCIz5q5Pi4vhq+
c9S+JLvnt6TFFRBzzChzKRVkJaie8O87aD29lL//RyXou81L8BM1NncN39dS
ScvvdbbxJNsqx853g7nG5/oEyRDVqwn7sJ1f/A6ysWW2VdzvBvwc4kWTTVR5
IGkH4gQkzyzeBnUkEbxBxwld1G4Z5rlHrO9tIvnvLPG2U+HcF9vA9iYO6ZGY
Y1qGcUeppB9qxH89jgGrgiuImxa+9/eIPi94w9sfU0mz8c66treYGHaiHXWZ
Y0/4lIgboW1mYJtZuN+JepeE6suwvPt99JBE8HQcQUycssslTcNM95ixNzdR
W9w0MGZ8/8faFvPcI7Y5y5hZMGr9rLMcmDHrNHmJT5Vgm09EZjamcemj36Fy
wMuPEtGsTuRNWZfJNND3gm2E/dLpXb1/QzUbs+RhKf0506+YzpPxnsQtEfcn
RTdT7pK0TvE7wrHOlvnrCfOL30ELtZPySJH34GiN5xWP3MQXSTo38VPxiNMx
jM0Z1vNMHsxwRsG+4Bf7WEfctfexk30UPFQusBk1Ho9TjJJvIeqoMAw3mw1U
Bft0iGQhYJe3RJ+TxtZdrVbT6RSq6q+2URTxlxDskemyaxsv0/fGvynPZjPN
r/J0wxwzRmfKT3CUdIWPWm7nbQO/GKn3f6jirKMovUnfkbjK1KJYX7rswS0e
eKsqU2sxzXB9SP1UkHxdnhs4w/HsLY/jiZ94dHjyv0btQyPlxmhwpMR8dUb0
J5lZkb+beqV/bTo/sA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{242, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->142314291]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->504583866],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ConjugateTranspose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ConjugateTranspose"]], "InlineFormula"],
 " works for symbolic matrices:"
}], "ExampleText",
 CellID->787831017],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ct", " ", "=", " ", 
  RowBox[{"ConjugateTranspose", "[", 
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["a", "##"], " ", "+", " ", 
       RowBox[{
        SubscriptBox["b", "##"], "I"}]}], "&"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->337739984],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Conjugate", "[", 
       SubscriptBox["a", 
        RowBox[{"1", ",", "1"}]], "]"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"Conjugate", "[", 
        SubscriptBox["b", 
         RowBox[{"1", ",", "1"}]], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"Conjugate", "[", 
       SubscriptBox["a", 
        RowBox[{"2", ",", "1"}]], "]"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"Conjugate", "[", 
        SubscriptBox["b", 
         RowBox[{"2", ",", "1"}]], "]"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Conjugate", "[", 
       SubscriptBox["a", 
        RowBox[{"1", ",", "2"}]], "]"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"Conjugate", "[", 
        SubscriptBox["b", 
         RowBox[{"1", ",", "2"}]], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"Conjugate", "[", 
       SubscriptBox["a", 
        RowBox[{"2", ",", "2"}]], "]"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"Conjugate", "[", 
        SubscriptBox["b", 
         RowBox[{"2", ",", "2"}]], "]"}]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{489, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14060423]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ComplexExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexExpand"]], "InlineFormula"],
 " assumes all variables are real:"
}], "ExampleText",
 CellID->31308798],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", "ct", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->207051980],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNV9tOwkAQ3d6oGgUlQY0aWy+JD8bEr4AX+QZtiAk8GA3y/3WnaaGcTnen
RQUSytznzOzsbhkni+n7R7KYTZJ4NE++prPJdzz8nGuR5yjlvCqleudK06mm
su9VmqbKIyr7qEfgry36J4s+sugH9FA+SJEP9SPQrAtykkUGHcq6+kGsx9jG
Bh3KEN+BCa+/lOcZYqMWY69hrljfGLW2vmZejavzirYsc2la3YmsKLZLY8jl
rFjfiqw6TGbKgbjZOlY908S91aJjwr9mif2oWoSWvrui1SE9N+sYneYozCcl
YGYD7TFv3R7cNI9tRvf+qV7pmfPX9cpWPbOq7ARuzcr8cYlf7pzGUYr9FW4R
A9dFwrS/Q30qMO1an6rThjPO3hOtcgdwzrWv5JD1ciE2nhZBjqGTSjBIopX5
o1Z9QiwFxnZ9wmhdUWWYqxkGWzS8kXGenMxOcrP5eTY3Xw367Ysxlr16eTSu
f/Kodd5YMb4fYC14Tsl2e513t6a2bZ4p7W6wmEHoquoJdbGRdx94XK3NsF3+
Krb2b4XERmnp/PNX2VX2z85sMbB0yZ4japyjXbXPwL8Af2qpBP3HFn8epW1f
PDB6moBhjfwM5CfCeCNhPP7fIJFvAko5Px0+b3o=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{351, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->196376187]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9010],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ConjugateTranspose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ConjugateTranspose"]], "InlineFormula"],
 " works similarly to ",
 Cell[BoxData[
  ButtonBox["Transpose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Transpose"]], "InlineFormula"],
 " for tensors:"
}], "ExampleText",
 CellID->149103044],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"j", " ", "=", " ", "0"}], "}"}], ",", " ", 
   RowBox[{"t", " ", "=", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"++", "j"}], ")"}], " ", "+", " ", 
       RowBox[{"I", 
        RowBox[{"(", 
         RowBox[{"++", "j"}], ")"}]}]}], ",", " ", 
      RowBox[{"{", "2", "}"}], ",", 
      RowBox[{"{", "3", "}"}], ",", 
      RowBox[{"{", "4", "}"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->558374899],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"3", "+", 
        RowBox[{"4", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"5", "+", 
        RowBox[{"6", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"7", "+", 
        RowBox[{"8", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"9", "+", 
        RowBox[{"10", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"11", "+", 
        RowBox[{"12", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"13", "+", 
        RowBox[{"14", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"15", "+", 
        RowBox[{"16", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"17", "+", 
        RowBox[{"18", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"19", "+", 
        RowBox[{"20", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"21", "+", 
        RowBox[{"22", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"23", "+", 
        RowBox[{"24", " ", "\[ImaginaryI]"}]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"25", "+", 
        RowBox[{"26", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"27", "+", 
        RowBox[{"28", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"29", "+", 
        RowBox[{"30", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"31", "+", 
        RowBox[{"32", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"33", "+", 
        RowBox[{"34", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"35", "+", 
        RowBox[{"36", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"37", "+", 
        RowBox[{"38", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"39", "+", 
        RowBox[{"40", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"41", "+", 
        RowBox[{"42", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"43", "+", 
        RowBox[{"44", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"45", "+", 
        RowBox[{"46", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"47", "+", 
        RowBox[{"48", " ", "\[ImaginaryI]"}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{559, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->118105997]
}, Open  ]],

Cell["Conjugate and transpose the first two dimensions:", "ExampleText",
 CellID->593040952],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConjugateTranspose", "[", "t", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->232928924],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{548, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->686352230]
}, Open  ]],

Cell["Conjugate and transpose the first and third dimensions:", "ExampleText",
 CellID->11656041],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConjugateTranspose", "[", 
  RowBox[{"t", ",", " ", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->332360407],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{422, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->215595549]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27489],

Cell[TextData[{
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " is a random complex matrix:"
}], "ExampleText",
 CellID->156778642],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"RandomComplex", "[", 
    RowBox[{
     RowBox[{"1", " ", "+", " ", "I"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"4", ",", "4"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->399195910],

Cell[TextData[{
 "Find the ",
 Cell[BoxData[
  ButtonBox["QRDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/QRDecomposition"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->232478536],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"q", ",", " ", "r"}], "}"}], " ", "=", " ", 
   RowBox[{"QRDecomposition", "[", "m", "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->215663014],

Cell[TextData[{
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 " is unitary, so its inverse is ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["q", "\[ConjugateTranspose]"], TraditionalForm]], 
  "InlineMath"]
}], "ExampleText",
 CellID->2166444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{"q", ".", 
   SuperscriptBox["q", "\[ConjugateTranspose]"]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->484140835],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.9999999999999996`", ",", "0", ",", "0", ",", "0"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"0", ",", "0.9999999999999999`", ",", "0", ",", "0"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1.0000000000000004`", ",", "0"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0.9999999999999994`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{382, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->345460243]
}, Open  ]],

Cell[TextData[{
 "Reconstruct ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " from the decomposition:"
}], "ExampleText",
 CellID->578212078],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox["q", "\[ConjugateTranspose]"], ".", "r"}], "-", "m"}], "//",
   "Chop"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->634056112],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{354, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->79341761]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18240],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ConjugateTranspose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ConjugateTranspose"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Conjugate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Conjugate"], "[", 
   RowBox[{
    ButtonBox["Transpose",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Transpose"], "[", 
    StyleBox["m", "TI"], "]"}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->285582147],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"RandomComplex", "[", 
    RowBox[{
     RowBox[{"1", " ", "+", " ", "I"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->91073299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ConjugateTranspose", "[", "m", "]"}], " ", "-", " ", 
  RowBox[{"Conjugate", "[", 
   RowBox[{"Transpose", "[", "m", "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->355129296],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWMlOg1AUvUwFJ6gLa3fyE+rGuNSVH0Eak3ZhNLXfZD8T30NomsPlTWBt
TZvQx53OPXfIW/BSrOavb8VqMSvy52XxMV/MPvOn96VQBR6R90VE2ZTEeyne
qkf+1uIhCuV/0OjKlnwL8oPG/xTku57xtvmDqqpA4yVZ+UJ8ZKKlHlncW/p3
4SMP34ittEsxrFETsI/AHoszpjZuDH4njjjID/kgX9c8+8I3MsyTDDQnty2p
vKKNXMXQZkORS6T03u6A1EdbjM2i3HJgfRyqus7+HA6zztCpzkQZ1X9n9Fvt
a7wCNueZOKMmR8uaApOU9Tq3whgBrwsjnnY5/p4nv0WYIxtgJsgT5+6V7nce
1tyn+6kTFu5+ZsTbLdf+8e6zRW6zM7trjtt0iLz/1zZdsdrm/uW7P1HGuHVZ
jbk7Hup+8FNVx+x+ejcW3Zo4dYnH+v28fL25hS/m5aeh+wohvaR4XZ9jsKe1
ftphx2lfduB3xQ+F38U/09hNvhD8CGuDN/K+AXXqZgY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{422, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->484064669]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->71706700],

Cell["\<\
The product of a matrix and its conjugate transpose is Hermitian:\
\>", "ExampleText",
 CellID->955783036],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"RandomComplex", "[", 
    RowBox[{
     RowBox[{"1", " ", "+", " ", "I"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->130392316],

Cell[TextData[{
 Cell[BoxData[
  FormBox["h", TraditionalForm]], "InlineMath"],
 " is the matrix product of ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["m", "\[ConjugateTranspose]"], TraditionalForm]], 
  "InlineMath"],
 ".  "
}], "ExampleText",
 CellID->520537508],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", " ", "=", " ", 
   RowBox[{"m", ".", 
    SuperscriptBox["m", "\[ConjugateTranspose]"]}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->156431854],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["h", "\[ConjugateTranspose]"], "\[LongEqual]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"m", ".", 
       SuperscriptBox["m", "\[ConjugateTranspose]"]}], ")"}], 
     "\[ConjugateTranspose]"], "\[LongEqual]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox["m", "\[ConjugateTranspose]"], ")"}], 
      "\[ConjugateTranspose]"], ".", 
     SuperscriptBox["m", "\[ConjugateTranspose]"]}], "\[LongEqual]", 
    RowBox[{"m", ".", 
     SuperscriptBox["m", "\[ConjugateTranspose]"]}], "\[LongEqual]", "h"}], 
   TraditionalForm]], "InlineMath"],
 " so ",
 Cell[BoxData[
  FormBox["h", TraditionalForm]], "InlineMath"],
 " is Hermitian:"
}], "ExampleText",
 CellID->180921928],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", " ", "\[Equal]", " ", 
  SuperscriptBox["h", "\[ConjugateTranspose]"]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->87018138],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->129826253]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23847],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Conjugate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Conjugate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Transpose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Transpose"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inverse",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inverse"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HermitianMatrixQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HermitianMatrixQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32604]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18786],

Cell[TextData[ButtonBox["Basic Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicMatrixOperations"]], "Tutorials",
 CellID->15498]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->234055393],

Cell[TextData[ButtonBox["Complex Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComplexNumbers"]], "MoreAbout",
 CellID->797636052],

Cell[TextData[ButtonBox["Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixOperations"]], "MoreAbout",
 CellID->675210633]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ConjugateTranspose - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 29, 57.1515278}", "context" -> "System`", 
    "keywords" -> {"Hermitian conjugate", "Hermitian transpose"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ConjugateTranspose[m] or m^\\[ConjugateTranspose] gives the conjugate \
transpose of m. ", "synonyms" -> {"conjugate transpose"}, "title" -> 
    "ConjugateTranspose", "type" -> "Symbol", "uri" -> 
    "ref/ConjugateTranspose"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5861, 195, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->273113814]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 38905, 1282}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2201, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2824, 80, 55, 1, 70, "ObjectName",
 CellID->2670],
Cell[2882, 83, 719, 23, 70, "Usage",
 CellID->26428]
}, Open  ]],
Cell[CellGroupData[{
Cell[3638, 111, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4116, 128, 668, 24, 70, "Notes",
 CellID->28027],
Cell[4787, 154, 345, 11, 70, "Notes",
 CellID->4084],
Cell[5135, 167, 689, 23, 70, "Notes",
 CellID->10075]
}, Closed]],
Cell[CellGroupData[{
Cell[5861, 195, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->273113814],
Cell[CellGroupData[{
Cell[6246, 209, 147, 5, 70, "ExampleSection",
 CellID->85122419],
Cell[6396, 216, 90, 1, 70, "ExampleText",
 CellID->769296498],
Cell[6489, 219, 378, 14, 70, "Input",
 CellID->317527725],
Cell[CellGroupData[{
Cell[6892, 237, 101, 3, 28, "Input",
 CellID->90337760],
Cell[6996, 242, 683, 15, 63, "Output",
 Evaluatable->False,
 CellID->600971031]
}, Open  ]],
Cell[CellGroupData[{
Cell[7716, 262, 150, 5, 28, "Input",
 CellID->619130972],
Cell[7869, 269, 905, 28, 78, "Output",
 CellID->307431982]
}, Open  ]],
Cell[8789, 300, 125, 3, 70, "ExampleDelimiter",
 CellID->332441747],
Cell[8917, 305, 187, 7, 70, "ExampleText",
 CellID->18569],
Cell[CellGroupData[{
Cell[9129, 316, 281, 11, 70, "Input",
 CellID->2807],
Cell[9413, 329, 343, 13, 36, "Output",
 CellID->140931756]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9805, 348, 215, 7, 70, "ExampleSection",
 CellID->2363],
Cell[10023, 357, 77, 1, 70, "ExampleText",
 CellID->37242249],
Cell[CellGroupData[{
Cell[10125, 362, 672, 21, 70, "Input",
 CellID->408654767],
Cell[10800, 385, 481, 17, 36, "Output",
 CellID->185222882]
}, Open  ]],
Cell[CellGroupData[{
Cell[11318, 407, 106, 3, 70, "Input",
 CellID->137421671],
Cell[11427, 412, 1423, 27, 70, "Output",
 Evaluatable->False,
 CellID->152798362]
}, Open  ]],
Cell[12865, 442, 76, 1, 70, "ExampleText",
 CellID->60816758],
Cell[CellGroupData[{
Cell[12966, 447, 148, 4, 70, "Input",
 CellID->556641905],
Cell[13117, 453, 480, 17, 36, "Output",
 CellID->16369314]
}, Open  ]],
Cell[CellGroupData[{
Cell[13634, 475, 107, 3, 70, "Input",
 CellID->224950764],
Cell[13744, 480, 1403, 27, 70, "Output",
 Evaluatable->False,
 CellID->142314291]
}, Open  ]],
Cell[15162, 510, 125, 3, 70, "ExampleDelimiter",
 CellID->504583866],
Cell[15290, 515, 226, 7, 70, "ExampleText",
 CellID->787831017],
Cell[CellGroupData[{
Cell[15541, 526, 402, 13, 70, "Input",
 CellID->337739984],
Cell[15946, 541, 1341, 43, 54, "Output",
 CellID->14060423]
}, Open  ]],
Cell[17302, 587, 218, 7, 70, "ExampleText",
 CellID->31308798],
Cell[CellGroupData[{
Cell[17545, 598, 110, 3, 70, "Input",
 CellID->207051980],
Cell[17658, 603, 862, 18, 70, "Output",
 Evaluatable->False,
 CellID->196376187]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18569, 627, 238, 7, 70, "ExampleSection",
 CellID->9010],
Cell[18810, 636, 356, 12, 70, "ExampleText",
 CellID->149103044],
Cell[CellGroupData[{
Cell[19191, 652, 556, 18, 70, "Input",
 CellID->558374899],
Cell[19750, 672, 2458, 72, 71, "Output",
 CellID->118105997]
}, Open  ]],
Cell[22223, 747, 92, 1, 70, "ExampleText",
 CellID->593040952],
Cell[CellGroupData[{
Cell[22340, 752, 114, 3, 70, "Input",
 CellID->232928924],
Cell[22457, 757, 2473, 45, 70, "Output",
 Evaluatable->False,
 CellID->686352230]
}, Open  ]],
Cell[24945, 805, 97, 1, 70, "ExampleText",
 CellID->11656041],
Cell[CellGroupData[{
Cell[25067, 810, 201, 6, 70, "Input",
 CellID->332360407],
Cell[25271, 818, 2452, 44, 70, "Output",
 Evaluatable->False,
 CellID->215595549]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27772, 868, 223, 7, 70, "ExampleSection",
 CellID->27489],
Cell[27998, 877, 150, 5, 70, "ExampleText",
 CellID->156778642],
Cell[28151, 884, 280, 9, 70, "Input",
 CellID->399195910],
Cell[28434, 895, 279, 11, 70, "ExampleText",
 CellID->232478536],
Cell[28716, 908, 217, 7, 70, "Input",
 CellID->215663014],
Cell[28936, 917, 263, 9, 70, "ExampleText",
 CellID->2166444],
Cell[CellGroupData[{
Cell[29224, 930, 168, 5, 70, "Input",
 CellID->484140835],
Cell[29395, 937, 587, 19, 36, "Output",
 CellID->345460243]
}, Open  ]],
Cell[29997, 959, 163, 6, 70, "ExampleText",
 CellID->578212078],
Cell[CellGroupData[{
Cell[30185, 969, 192, 7, 70, "Input",
 CellID->634056112],
Cell[30380, 978, 499, 15, 36, "Output",
 CellID->79341761]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30928, 999, 233, 7, 70, "ExampleSection",
 CellID->18240],
Cell[31164, 1008, 611, 21, 70, "ExampleText",
 CellID->285582147],
Cell[31778, 1031, 279, 9, 70, "Input",
 CellID->91073299],
Cell[CellGroupData[{
Cell[32082, 1044, 220, 6, 70, "Input",
 CellID->355129296],
Cell[32305, 1052, 744, 16, 70, "Output",
 Evaluatable->False,
 CellID->484064669]
}, Open  ]],
Cell[33064, 1071, 124, 3, 70, "ExampleDelimiter",
 CellID->71706700],
Cell[33191, 1076, 116, 3, 70, "ExampleText",
 CellID->955783036],
Cell[33310, 1081, 280, 9, 70, "Input",
 CellID->130392316],
Cell[33593, 1092, 342, 13, 70, "ExampleText",
 CellID->520537508],
Cell[33938, 1107, 190, 6, 70, "Input",
 CellID->156431854],
Cell[34131, 1115, 785, 24, 70, "ExampleText",
 CellID->180921928],
Cell[CellGroupData[{
Cell[34941, 1143, 152, 4, 70, "Input",
 CellID->87018138],
Cell[35096, 1149, 161, 5, 36, "Output",
 CellID->129826253]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35318, 1161, 311, 9, 70, "SeeAlsoSection",
 CellID->23847],
Cell[35632, 1172, 959, 35, 70, "SeeAlso",
 CellID->32604]
}, Open  ]],
Cell[CellGroupData[{
Cell[36628, 1212, 314, 9, 70, "TutorialsSection",
 CellID->18786],
Cell[36945, 1223, 155, 3, 70, "Tutorials",
 CellID->15498]
}, Open  ]],
Cell[CellGroupData[{
Cell[37137, 1231, 319, 9, 70, "MoreAboutSection",
 CellID->234055393],
Cell[37459, 1242, 141, 3, 70, "MoreAbout",
 CellID->797636052],
Cell[37603, 1247, 145, 3, 70, "MoreAbout",
 CellID->675210633]
}, Open  ]],
Cell[37763, 1253, 29, 0, 70, "History"],
Cell[37795, 1255, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

