(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19331,        767]
NotebookOptionsPosition[     14566,        603]
NotebookOutlinePosition[     15934,        642]
CellTagsIndexPosition[     15849,        637]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Total Derivatives" :> 
          Documentation`HelpLookup["paclet:tutorial/TotalDerivatives"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Total Derivatives\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"D" :> Documentation`HelpLookup["paclet:ref/D"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"D\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Constants", "ObjectName",
 CellID->7516],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Constants",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Constants"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Dt",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Dt"]], "InlineFormula"],
     " which gives a list of objects to be taken as constants. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27726]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " appears in the list of ",
 Cell[BoxData[
  ButtonBox["Constants",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Constants"]], "InlineFormula"],
 ", then both ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dt"], "[", 
   StyleBox["f", "TI"], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dt"], "[", 
   RowBox[{
    StyleBox["f", "TI"], "[", 
    StyleBox["\[Ellipsis]", "TR"], "]"}], "]"}]], "InlineFormula"],
 " are taken to be zero. "
}], "Notes",
 CellID->28666]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->67602343],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->102875226],

Cell[TextData[{
 "Here both ",
 StyleBox["a", "TI"],
 " and ",
 StyleBox["b", "TI"],
 " are assumed to depend on ",
 StyleBox["x", "TI"],
 ":"
}], "ExampleText",
 CellID->172100040],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"x", "^", "2"}]}], "+", "b"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->236167361],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "a", " ", "x"}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"Dt", "[", 
    RowBox[{"a", ",", "x"}], "]"}]}], "+", 
  RowBox[{"Dt", "[", 
   RowBox[{"b", ",", "x"}], "]"}]}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4379477]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->286845599],

Cell[TextData[{
 "Specify that ",
 StyleBox["a", "TI"],
 " does not depend on ",
 StyleBox["x", "TI"],
 " using the ",
 Cell[BoxData[
  ButtonBox["Constants",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Constants"]], "InlineFormula"],
 " option:"
}], "ExampleText",
 CellID->74845108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"x", "^", "2"}]}], "+", "b"}], ",", "x", ",", 
   RowBox[{"Constants", " ", "\[Rule]", " ", 
    RowBox[{"{", "a", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->374128652],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "a", " ", "x"}], "+", 
  RowBox[{"Dt", "[", 
   RowBox[{"b", ",", "x", ",", 
    RowBox[{"Constants", "\[Rule]", 
     RowBox[{"{", "a", "}"}]}]}], "]"}]}]], "Output",
 ImageSize->{208, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->217532161]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->193331787],

Cell[TextData[{
 "Specify that both ",
 StyleBox["a", "TI"],
 " and ",
 StyleBox["b", "TI"],
 " are independent of ",
 StyleBox["x", "TI"],
 ":"
}], "ExampleText",
 CellID->167227828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"x", "^", "2"}]}], "+", "b"}], ",", "x", ",", 
   RowBox[{"Constants", " ", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{"a", ",", " ", "b"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->157896829],

Cell[BoxData[
 RowBox[{"2", " ", "a", " ", "x"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->129892129]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20415],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["TagSet",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagSet"]], "InlineFormula"],
 " to prescribe a constant:"
}], "ExampleText",
 CellID->653339082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"y", "/:", 
  RowBox[{"Dt", "[", 
   RowBox[{"y", ",", "x"}], "]"}], "=", "0"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->192633779],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->695568865]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], " ", "y"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->183715917],

Cell[BoxData[
 RowBox[{"2", " ", "x", " ", "y"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->514372243]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->762995565],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["SetAttributes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetAttributes"]], "InlineFormula"],
 " to prescribe a constant:"
}], "ExampleText",
 CellID->389344728],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"a", ",", "Constant"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->230304608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{
   RowBox[{"a", " ", 
    RowBox[{"x", "^", "2"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3582258],

Cell[BoxData[
 RowBox[{"2", " ", "a", " ", "x"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->531770055]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->663252850],

Cell[TextData[{
 "For a contant ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " any expression ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " is also assumed to be constant: "
}], "ExampleText",
 CellID->734495445],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], " ", 
    RowBox[{"f", "[", "x", "]"}]}], ",", "x", ",", 
   RowBox[{"Constants", " ", "\[Rule]", " ", 
    RowBox[{"{", "f", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->505401589],

Cell[BoxData[
 RowBox[{"2", " ", "x", " ", 
  RowBox[{"f", "[", "x", "]"}]}]], "Output",
 ImageSize->{52, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8154203]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23941],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Constants",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Constants"]], "InlineFormula"],
 " allows ",
 Cell[BoxData[
  ButtonBox["Dt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dt"]], "InlineFormula"],
 " to emulate ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->252662062],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Dt", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"x", "^", "2"}]}], "+", "b"}], ",", "x", ",", 
     RowBox[{"Constants", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"x", "^", "2"}]}], "+", "b"}], ",", "x"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->624858263],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", "a", " ", "x"}], ",", 
   RowBox[{"2", " ", "a", " ", "x"}]}], "}"}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->427266133]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->234518603],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NonConstants",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NonConstants"]], "InlineFormula"],
 " allows ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 " to emulate ",
 Cell[BoxData[
  ButtonBox["Dt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dt"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->791938067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Dt", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"x", "^", "2"}]}], "+", "b"}], ",", "x"}], "]"}], ",", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"x", "^", "2"}]}], "+", "b"}], ",", "x", ",", 
     RowBox[{"NonConstants", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57345850],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", "a", " ", "x"}], "+", 
    RowBox[{
     SuperscriptBox["x", "2"], " ", 
     RowBox[{"Dt", "[", 
      RowBox[{"a", ",", "x"}], "]"}]}], "+", 
    RowBox[{"Dt", "[", 
     RowBox[{"b", ",", "x"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "a", " ", "x"}], "+", 
    RowBox[{
     SuperscriptBox["x", "2"], " ", 
     RowBox[{"D", "[", 
      RowBox[{"a", ",", "x", ",", 
       RowBox[{"NonConstants", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"a", ",", "b"}], "}"}]}]}], "]"}]}], "+", 
    RowBox[{"D", "[", 
     RowBox[{"b", ",", "x", ",", 
      RowBox[{"NonConstants", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}]}]}], "]"}]}]}], "}"}]], "Output",
 ImageSize->{479, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->459920192]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5686],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->6021]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29087],

Cell[TextData[ButtonBox["Total Derivatives",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TotalDerivatives"]], "Tutorials",
 CellID->27681]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Constants - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 30, 3.5423164}", "context" -> "System`", 
    "keywords" -> {
     "dependent functions", "dependent variables in differentiation", 
      "differentiation variables", 
      "implicit dependencies in differentiation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Constants is an option for Dt which gives a list of objects to be taken \
as constants. ", "synonyms" -> {}, "title" -> "Constants", "type" -> "Symbol",
     "uri" -> "ref/Constants"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3617, 131, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->67602343]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15707, 630}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1112, 29, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1735, 56, 46, 1, 70, "ObjectName",
 CellID->7516],
Cell[1784, 59, 591, 18, 70, "Usage",
 CellID->27726]
}, Open  ]],
Cell[CellGroupData[{
Cell[2412, 82, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2890, 99, 690, 27, 70, "Notes",
 CellID->28666]
}, Closed]],
Cell[CellGroupData[{
Cell[3617, 131, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->67602343],
Cell[CellGroupData[{
Cell[4001, 145, 148, 5, 70, "ExampleSection",
 CellID->102875226],
Cell[4152, 152, 181, 9, 70, "ExampleText",
 CellID->172100040],
Cell[CellGroupData[{
Cell[4358, 165, 196, 7, 28, "Input",
 CellID->236167361],
Cell[4557, 174, 378, 13, 36, "Output",
 CellID->4379477]
}, Open  ]],
Cell[4950, 190, 125, 3, 70, "ExampleDelimiter",
 CellID->286845599],
Cell[5078, 195, 289, 12, 70, "ExampleText",
 CellID->74845108],
Cell[CellGroupData[{
Cell[5392, 211, 279, 9, 70, "Input",
 CellID->374128652],
Cell[5674, 222, 342, 11, 36, "Output",
 CellID->217532161]
}, Open  ]],
Cell[6031, 236, 125, 3, 70, "ExampleDelimiter",
 CellID->193331787],
Cell[6159, 241, 183, 9, 70, "ExampleText",
 CellID->167227828],
Cell[CellGroupData[{
Cell[6367, 254, 310, 10, 70, "Input",
 CellID->157896829],
Cell[6680, 266, 190, 6, 36, "Output",
 CellID->129892129]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6919, 278, 216, 7, 70, "ExampleSection",
 CellID->20415],
Cell[7138, 287, 207, 8, 70, "ExampleText",
 CellID->653339082],
Cell[CellGroupData[{
Cell[7370, 299, 156, 5, 70, "Input",
 CellID->192633779],
Cell[7529, 306, 158, 5, 36, "Output",
 CellID->695568865]
}, Open  ]],
Cell[CellGroupData[{
Cell[7724, 316, 170, 6, 70, "Input",
 CellID->183715917],
Cell[7897, 324, 190, 6, 36, "Output",
 CellID->514372243]
}, Open  ]],
Cell[8102, 333, 125, 3, 70, "ExampleDelimiter",
 CellID->762995565],
Cell[8230, 338, 221, 8, 70, "ExampleText",
 CellID->389344728],
Cell[8454, 348, 139, 4, 70, "Input",
 CellID->230304608],
Cell[CellGroupData[{
Cell[8618, 356, 168, 6, 70, "Input",
 CellID->3582258],
Cell[8789, 364, 190, 6, 36, "Output",
 CellID->531770055]
}, Open  ]],
Cell[8994, 373, 125, 3, 70, "ExampleDelimiter",
 CellID->663252850],
Cell[9122, 378, 297, 11, 70, "ExampleText",
 CellID->734495445],
Cell[CellGroupData[{
Cell[9444, 393, 283, 9, 70, "Input",
 CellID->505401589],
Cell[9730, 404, 216, 7, 36, "Output",
 CellID->8154203]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9995, 417, 233, 7, 70, "ExampleSection",
 CellID->23941],
Cell[10231, 426, 423, 17, 70, "ExampleText",
 CellID->252662062],
Cell[CellGroupData[{
Cell[10679, 447, 494, 18, 70, "Input",
 CellID->624858263],
Cell[11176, 467, 271, 9, 36, "Output",
 CellID->427266133]
}, Open  ]],
Cell[11462, 479, 125, 3, 70, "ExampleDelimiter",
 CellID->234518603],
Cell[11590, 484, 429, 17, 70, "ExampleText",
 CellID->791938067],
Cell[CellGroupData[{
Cell[12044, 505, 493, 17, 70, "Input",
 CellID->57345850],
Cell[12540, 524, 901, 29, 58, "Output",
 CellID->459920192]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13502, 560, 310, 9, 70, "SeeAlsoSection",
 CellID->5686],
Cell[13815, 571, 181, 6, 70, "SeeAlso",
 CellID->6021]
}, Open  ]],
Cell[CellGroupData[{
Cell[14033, 582, 314, 9, 70, "TutorialsSection",
 CellID->29087],
Cell[14350, 593, 144, 3, 70, "Tutorials",
 CellID->27681]
}, Open  ]],
Cell[14509, 599, 27, 0, 70, "History"],
Cell[14539, 601, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

