(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7705,        280]
NotebookOptionsPosition[      5094,        196]
NotebookOutlinePosition[      6513,        235]
CellTagsIndexPosition[      6429,        230]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"FileNames" :> Documentation`HelpLookup["paclet:ref/FileNames"], 
         "$Path" :> Documentation`HelpLookup["paclet:ref/$Path"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"FileNames\"\>", 
      2->"\<\"$Path\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ContextToFileName", "ObjectName",
 CellID->189],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ContextToFileName",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ContextToFileName"], "[", "\"\<\!\(\*
StyleBox[\"context\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the string specifying the file name that is by \
convention associated with a particular context."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16100]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "In typical cases, ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"name`\", \"TI\"]\)\>\""], "InlineFormula"],
 " is taken to be associated with the file ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\).m\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->19812]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->36016380],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->33366472],

Cell["\<\
Give the file with extension .m that would be associated with a context:\
\>", "ExampleText",
 CellID->27038298],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContextToFileName", "[", "\"\<context`\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->373321940],

Cell[BoxData["\<\"context.m\"\>"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40264312]
}, Open  ]],

Cell["Longer context qualifiers correspond with directories:", "ExampleText",
 CellID->294183305],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContextToFileName", "[", "\"\<d1`d2`d2`context`\>\"", 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->682933227],

Cell[BoxData["\<\"d1\\\\d2\\\\d2\\\\context.m\"\>"], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->116034351]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28633],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileNames",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileNames"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Path",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Path"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29891]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ContextToFileName - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 30, 4.9329770}", "context" -> "System`", 
    "keywords" -> {
     "context to string", "correspondence of paths and contexts", 
      "correspondence of files and contexts"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ContextToFileName[\"context\"] gives the string specifying the file name \
that is by convention associated with a particular context.", 
    "synonyms" -> {"context to file name"}, "title" -> "ContextToFileName", 
    "type" -> "Symbol", "uri" -> "ref/ContextToFileName"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2742, 97, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->36016380]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6288, 223}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 645, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1268, 42, 53, 1, 70, "ObjectName",
 CellID->189],
Cell[1324, 45, 585, 16, 70, "Usage",
 CellID->16100]
}, Open  ]],
Cell[CellGroupData[{
Cell[1946, 66, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2424, 83, 281, 9, 70, "Notes",
 CellID->19812]
}, Closed]],
Cell[CellGroupData[{
Cell[2742, 97, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->36016380],
Cell[CellGroupData[{
Cell[3126, 111, 147, 5, 70, "ExampleSection",
 CellID->33366472],
Cell[3276, 118, 122, 3, 70, "ExampleText",
 CellID->27038298],
Cell[CellGroupData[{
Cell[3423, 125, 128, 3, 28, "Input",
 CellID->373321940],
Cell[3554, 130, 173, 5, 36, "Output",
 CellID->40264312]
}, Open  ]],
Cell[3742, 138, 97, 1, 70, "ExampleText",
 CellID->294183305],
Cell[CellGroupData[{
Cell[3864, 143, 140, 4, 28, "Input",
 CellID->682933227],
Cell[4007, 149, 193, 5, 36, "Output",
 CellID->116034351]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4261, 161, 311, 9, 70, "SeeAlsoSection",
 CellID->28633],
Cell[4575, 172, 447, 17, 70, "SeeAlso",
 CellID->29891]
}, Open  ]],
Cell[5037, 192, 27, 0, 70, "History"],
Cell[5067, 194, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

