(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15559,        590]
NotebookOptionsPosition[     12017,        468]
NotebookOutlinePosition[     13252,        504]
CellTagsIndexPosition[     13167,        499]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Loops and Control Structures" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LoopsAndControlStructures"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Loops and Control Structures\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Break" :> Documentation`HelpLookup["paclet:ref/Break"], "Goto" :> 
          Documentation`HelpLookup["paclet:ref/Goto"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Break\"\>", 
       2->"\<\"Goto\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Flow Control" :> 
          Documentation`HelpLookup["paclet:guide/FlowControl"], 
          "Looping Constructs" :> 
          Documentation`HelpLookup["paclet:guide/LoopingConstructs"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Flow Control\"\>", 
       2->"\<\"Looping Constructs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Continue", "ObjectName",
 CellID->10861],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Continue",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Continue"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]exits to the nearest enclosing ",
     Cell[BoxData[
      ButtonBox["Do",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Do"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["For",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/For"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      ButtonBox["While",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/While"]], "InlineFormula"],
     " in a procedural program. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22431]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Continue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Continue"], "[", "]"}]], "InlineFormula"],
 " takes effect as soon as it is evaluated, even if it appears inside other \
functions. "
}], "Notes",
 CellID->29082],

Cell[TextData[{
 "The function of ",
 Cell[BoxData[
  ButtonBox["Continue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Continue"]], "InlineFormula"],
 " can also be achieved using ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12455]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->318580683],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->138881473],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"r", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"EvenQ", "[", "i", "]"}], ",", 
       RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
     RowBox[{"r", "+=", "i"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "10"}], "}"}]}], "]"}], ";", "r"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->29272958],

Cell[BoxData["25"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->597907647]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18318],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Continue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Continue"]], "InlineFormula"],
 " inside a ",
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 " loop:"
}], "ExampleText",
 CellID->543218860],

Cell[BoxData[{
 RowBox[{
  RowBox[{"r", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"EvenQ", "[", "i", "]"}], ",", 
       RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
     RowBox[{"r", "+=", "i"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "10"}], "}"}]}], "]"}], ";", "r"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->255382227],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Continue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Continue"]], "InlineFormula"],
 " inside a ",
 Cell[BoxData[
  ButtonBox["For",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/For"]], "InlineFormula"],
 " loop:"
}], "ExampleText",
 CellID->215643373],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"r", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"i", "=", "1"}], ",", 
    RowBox[{"i", "\[LessEqual]", "10"}], ",", 
    RowBox[{"i", "++"}], ",", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"EvenQ", "[", "i", "]"}], ",", 
       RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
     RowBox[{"r", "+=", "i"}]}]}], "]"}], ";", "r"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->23830935],

Cell[BoxData["25"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->329997027]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Continue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Continue"]], "InlineFormula"],
 " inside a ",
 Cell[BoxData[
  ButtonBox["While",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/While"]], "InlineFormula"],
 " loop:"
}], "ExampleText",
 CellID->85550864],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"r", "=", "0"}], ";", 
  RowBox[{"i", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"i", "<", "10"}], ",", 
    RowBox[{
     RowBox[{"i", "++"}], ";", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"EvenQ", "[", "i", "]"}], ",", 
       RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
     RowBox[{"r", "+=", "i"}]}]}], "]"}], ";", "r"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->42569787],

Cell[BoxData["25"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->502397]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29859],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Break",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Break"]], "InlineFormula"],
 " exits the loop:"
}], "ExampleText",
 CellID->121964176],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"i", "=", "1"}], ",", 
    RowBox[{"i", "\[LessEqual]", "10"}], ",", 
    RowBox[{"i", "++"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"i", ">", "2"}], ",", 
      RowBox[{"Break", "[", "]"}]}], "]"}]}], "]"}], ";", "i"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13899219],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102033390]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17296],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Break",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Break"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Goto",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Goto"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26281]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14197],

Cell[TextData[ButtonBox["Loops and Control Structures",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LoopsAndControlStructures"]], "Tutorials",
 CellID->22106]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Flow Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FlowControl"]], "MoreAbout",
 CellID->376529135],

Cell[TextData[ButtonBox["Looping Constructs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LoopingConstructs"]], "MoreAbout",
 CellID->334080904]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Continue - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 30, 11.1675116}", "context" -> "System`", 
    "keywords" -> {"loops", "flow of control"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Continue[] exits to the nearest enclosing Do, For or While in a \
procedural program. ", "synonyms" -> {}, "title" -> "Continue", "type" -> 
    "Symbol", "uri" -> "ref/Continue"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4795, 164, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->318580683]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13024, 492}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1949, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2572, 76, 46, 1, 70, "ObjectName",
 CellID->10861],
Cell[2621, 79, 880, 29, 70, "Usage",
 CellID->22431]
}, Open  ]],
Cell[CellGroupData[{
Cell[3538, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4016, 130, 280, 9, 70, "Notes",
 CellID->29082],
Cell[4299, 141, 459, 18, 70, "Notes",
 CellID->12455]
}, Closed]],
Cell[CellGroupData[{
Cell[4795, 164, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->318580683],
Cell[CellGroupData[{
Cell[5180, 178, 148, 5, 70, "ExampleSection",
 CellID->138881473],
Cell[CellGroupData[{
Cell[5353, 187, 432, 15, 47, "Input",
 CellID->29272958],
Cell[5788, 204, 159, 5, 36, "Output",
 CellID->597907647]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5996, 215, 216, 7, 70, "ExampleSection",
 CellID->18318],
Cell[6215, 224, 314, 13, 70, "ExampleText",
 CellID->543218860],
Cell[6532, 239, 433, 15, 70, "Input",
 CellID->255382227],
Cell[6968, 256, 316, 13, 70, "ExampleText",
 CellID->215643373],
Cell[CellGroupData[{
Cell[7309, 273, 484, 16, 70, "Input",
 CellID->23830935],
Cell[7796, 291, 159, 5, 36, "Output",
 CellID->329997027]
}, Open  ]],
Cell[7970, 299, 319, 13, 70, "ExampleText",
 CellID->85550864],
Cell[CellGroupData[{
Cell[8314, 316, 474, 16, 70, "Input",
 CellID->42569787],
Cell[8791, 334, 156, 5, 36, "Output",
 CellID->502397]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8996, 345, 233, 7, 70, "ExampleSection",
 CellID->29859],
Cell[9232, 354, 187, 7, 70, "ExampleText",
 CellID->121964176],
Cell[CellGroupData[{
Cell[9444, 365, 363, 12, 70, "Input",
 CellID->13899219],
Cell[9810, 379, 158, 5, 36, "Output",
 CellID->102033390]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10029, 391, 311, 9, 70, "SeeAlsoSection",
 CellID->17296],
Cell[10343, 402, 437, 17, 70, "SeeAlso",
 CellID->26281]
}, Open  ]],
Cell[CellGroupData[{
Cell[10817, 424, 314, 9, 70, "TutorialsSection",
 CellID->14197],
Cell[11134, 435, 164, 3, 70, "Tutorials",
 CellID->22106]
}, Open  ]],
Cell[CellGroupData[{
Cell[11335, 443, 299, 8, 70, "MoreAboutSection"],
Cell[11637, 453, 135, 3, 70, "MoreAbout",
 CellID->376529135],
Cell[11775, 458, 147, 3, 70, "MoreAbout",
 CellID->334080904]
}, Open  ]],
Cell[11937, 464, 50, 0, 70, "History"],
Cell[11990, 466, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

