(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37896,       1411]
NotebookOptionsPosition[     30016,       1128]
NotebookOutlinePosition[     31634,       1170]
CellTagsIndexPosition[     31548,       1165]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Convergents" :> 
          Documentation`HelpLookup["paclet:ref/Convergents"], 
          "FromContinuedFraction" :> 
          Documentation`HelpLookup["paclet:ref/FromContinuedFraction"], 
          "QuadraticIrrationalQ" :> 
          Documentation`HelpLookup["paclet:ref/QuadraticIrrationalQ"], 
          "IntegerDigits" :> 
          Documentation`HelpLookup["paclet:ref/IntegerDigits"], "Rationalize" :> 
          Documentation`HelpLookup["paclet:ref/Rationalize"], "Khinchin" :> 
          Documentation`HelpLookup["paclet:ref/Khinchin"], "RealDigits" :> 
          Documentation`HelpLookup["paclet:ref/RealDigits"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Convergents\"\>", 
       2->"\<\"FromContinuedFraction\"\>", 3->"\<\"QuadraticIrrationalQ\"\>", 
       4->"\<\"IntegerDigits\"\>", 5->"\<\"Rationalize\"\>", 
       6->"\<\"Khinchin\"\>", 7->"\<\"RealDigits\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Numbers" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicNumbers"], 
          "Continued Fractions & Rational Approximations" :> 
          Documentation`HelpLookup[
           "paclet:guide/ContinuedFractionsAndRationalApproximations"], 
          "Number Recognition" :> 
          Documentation`HelpLookup["paclet:guide/NumberRecognition"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Algebraic Numbers\"\>", 
       2->"\<\"Continued Fractions & Rational Approximations\"\>", 
       3->"\<\"Number Recognition\"\>", 
       4->"\<\"Number Theory\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ContinuedFraction", "ObjectName",
 CellID->3523],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ContinuedFraction",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ContinuedFraction"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a list of the first ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " terms in the continued fraction representation of\[NonBreakingSpace]",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ContinuedFraction",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ContinuedFraction"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a list of all terms that can be obtained \
given the precision of\[NonBreakingSpace]",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->31758]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The continued fraction representation ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["2", "TR"]], ",", 
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["3", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " corresponds to the expression ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["a", "TI"], 
    StyleBox["1", "TR"]], "+", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["2", "TR"]], "+", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox[
          StyleBox["a", "TI"], 
          StyleBox["3", "TR"]], "+", 
         StyleBox["\[Ellipsis]", "TR"]}], ")"}]}]}], ")"}]}]}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->12105],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " can be either an exact or an inexact number. "
}], "Notes",
 CellID->29621],

Cell[TextData[{
 "For exact numbers, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ContinuedFraction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContinuedFraction"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " can be used if ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is rational, or is a quadratic irrational. "
}], "Notes",
 CellID->17095],

Cell[TextData[{
 "For quadratic irrationals, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ContinuedFraction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContinuedFraction"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " returns a result of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["b", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["b", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]], "InlineFormula"],
 ", corresponding to an infinite sequence of terms, starting with the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", and followed by cyclic repetitions of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["b", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->11191,
  ButtonNote->"11191"]
}], "Notes",
 CellID->7296],

Cell[TextData[{
 "Since the continued fraction representation for a rational number has only \
a limited number of terms, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ContinuedFraction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContinuedFraction"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " may yield a list with less than ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " elements in this case. "
}], "Notes",
 CellID->9916],

Cell[TextData[{
 "For terminating continued fractions, ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["\[Ellipsis]", "TR"], ",", 
    StyleBox["k", "TI"]}], "}"}]], "InlineFormula"],
 " is always equivalent to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["\[Ellipsis]", "TR"], ",", 
    RowBox[{
     StyleBox["k", "TI"], "-", "1"}], ",", "1"}], "}"}]], "InlineFormula"],
 "; ",
 Cell[BoxData[
  ButtonBox["ContinuedFraction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContinuedFraction"]], "InlineFormula"],
 " returns the first of these forms. "
}], "Notes",
 CellID->15678],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FromContinuedFraction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FromContinuedFraction"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " reconstructs a number from the result of ",
 Cell[BoxData[
  ButtonBox["ContinuedFraction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContinuedFraction"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10178]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->359039355],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->167824805],

Cell["\<\
20 terms in the continued fraction for \[Pi]:\
\>", "ExampleText",
 CellID->24676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{"Pi", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27753],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "7", ",", "15", ",", "1", ",", "292", ",", "1", ",", "1", ",", 
   "1", ",", "2", ",", "1", ",", "3", ",", "1", ",", "14", ",", "2", ",", "1",
    ",", "1", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}]], "Output",
 ImageSize->{399, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20899]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15565],

Cell["Rational number:", "ExampleText",
 CellID->3093],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{"47", "/", "17"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13608],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1", ",", "3", ",", "4"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6172]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", "+", 
  RowBox[{"1", "/", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"1", "/", "4"}]}], ")"}]}]}], ")"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11243],

Cell[BoxData[
 FractionBox["47", "17"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29929]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", "+", 
  FractionBox["1", 
   RowBox[{"1", "+", 
    FractionBox["1", 
     RowBox[{"3", "+", 
      FractionBox["1", "4"]}]]}]]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->7514],

Cell[BoxData[
 FractionBox["47", "17"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->10168]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5055],

Cell["Quadratic irrational (recurring continued fraction):", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->11191],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{"Sqrt", "[", "13", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5973],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "6"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8922]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "13", "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6748],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "1", ",", "1", ",", "1", ",", "1", ",", "6", ",", "1", ",", "1", 
   ",", "1", ",", "1", ",", "6", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
   "6", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{371, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5651]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10986],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ContinuedFraction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContinuedFraction"]], "InlineFormula"],
 " stops when it runs out of precision:"
}], "ExampleText",
 CellID->2144],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{"N", "[", "Pi", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16446],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "7", ",", "15", ",", "1", ",", "292", ",", "1", ",", "1", ",", 
   "1", ",", "2", ",", "1", ",", "3", ",", "1", ",", "14"}], "}"}]], "Output",\

 ImageSize->{272, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31577]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{"N", "[", 
   RowBox[{"Pi", ",", "20"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26517],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "7", ",", "15", ",", "1", ",", "292", ",", "1", ",", "1", ",", 
   "1", ",", "2", ",", "1", ",", "3", ",", "1", ",", "14", ",", "2", ",", "1",
    ",", "1", ",", "2", ",", "2", ",", "2"}], "}"}]], "Output",
 ImageSize->{381, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->14629]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5874],

Cell[TextData[{
 "The continued fractions for ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " roots of ",
 Cell[BoxData["\[ExponentialE]"], "InlineFormula"],
 " are very regular:"
}], "ExampleText",
 CellID->15791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "E", "]"}], ",", "25"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15469],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "1", ",", "1", ",", "5", ",", "1", ",", "1", ",", "9", 
   ",", "1", ",", "1", ",", "13", ",", "1", ",", "1", ",", "17", ",", "1", 
   ",", "1", ",", "21", ",", "1", ",", "1", ",", "25", ",", "1", ",", "1", 
   ",", "29", ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{497, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22912]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8146],

Cell["\<\
Geometric mean of the first 1000 continued fraction terms in \[Pi]:\
\>", "ExampleText",
 CellID->30693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Apply", "[", 
    RowBox[{"Times", ",", 
     RowBox[{"ContinuedFraction", "[", 
      RowBox[{"Pi", ",", "1000"}], "]"}]}], "]"}], "^", 
   RowBox[{"(", 
    RowBox[{"1", "/", "1000"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9091],

Cell[BoxData["2.665625529320344`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9815]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "Khinchin", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26949],

Cell[BoxData["2.6854520010653062`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26857]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20640],

Cell["An almost-integer:", "ExampleText",
 CellID->26052],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"Pi", " ", 
     RowBox[{"Sqrt", "[", "163", "]"}]}], "]"}], ",", "10"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->236],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "262537412640768743", ",", "1", ",", "1333462407511", ",", "1", ",", "8", 
   ",", "1", ",", "1", ",", "5", ",", "1", ",", "4"}], "}"}]], "Output",
 ImageSize->{411, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8551]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"Pi", " ", 
     RowBox[{"Sqrt", "[", "163", "]"}]}], "]"}], ",", "50"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->9487],

Cell[BoxData["2.\
62537412640768743999999999999250072597198185688879353856337336991`50.*^17"], \
"Output",
 ImageSize->{397, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31226]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28162],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FromContinuedFraction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FromContinuedFraction"]], "InlineFormula"],
 " is effectively the inverse of ",
 Cell[BoxData[
  ButtonBox["ContinuedFraction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContinuedFraction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->16955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{"Pi", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23183],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "7", ",", "15", ",", "1", ",", "292", ",", "1", ",", "1", ",", 
   "1", ",", "2", ",", "1", ",", "3", ",", "1", ",", "14", ",", "2", ",", "1",
    ",", "1", ",", "2", ",", "2", ",", "2", ",", "2"}], "}"}]], "Output",
 ImageSize->{399, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8394]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromContinuedFraction", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30180],

Cell[BoxData[
 FractionBox["14885392687", "4738167652"]], "Output",
 ImageSize->{92, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16097]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->3065],

Cell[BoxData["3.141592653589793`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->27065]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2513],

Cell["Explicit representation using nested fractional parts:", "ExampleText",
 CellID->9261],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Floor", "[", 
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"FractionalPart", "[", "#", "]"}]}], "&"}], ",", "Pi", ",", 
    "20"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12578],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "7", ",", "15", ",", "1", ",", "292", ",", "1", ",", "1", ",", 
   "1", ",", "2", ",", "1", ",", "3", ",", "1", ",", "14", ",", "2", ",", "1",
    ",", "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "1"}], 
  "}"}]], "Output",
 ImageSize->{417, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21078]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{"Pi", ",", "21"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16878],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "7", ",", "15", ",", "1", ",", "292", ",", "1", ",", "1", ",", 
   "1", ",", "2", ",", "1", ",", "3", ",", "1", ",", "14", ",", "2", ",", "1",
    ",", "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "1"}], 
  "}"}]], "Output",
 ImageSize->{417, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->14140]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24750],

Cell["Objects showing regularity in their continued fractions:", "ExampleText",
 CellID->6149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{
   RowBox[{"Coth", "[", "1", "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3333],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "3", ",", "5", ",", "7", ",", "9", ",", "11", ",", "13", ",", 
   "15", ",", "17", ",", "19", ",", "21", ",", "23", ",", "25", ",", "27", 
   ",", "29", ",", "31", ",", "33", ",", "35", ",", "37", ",", "39"}], 
  "}"}]], "Output",
 ImageSize->{476, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13865]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"BesselI", "[", 
     RowBox[{"0", ",", "1"}], "]"}], "/", 
    RowBox[{"BesselI", "[", 
     RowBox[{"1", ",", "1"}], "]"}]}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22214],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "4", ",", "6", ",", "8", ",", "10", ",", "12", ",", "14", ",", 
   "16", ",", "18", ",", "20", ",", "22", ",", "24", ",", "26", ",", "28", 
   ",", "30", ",", "32", ",", "34", ",", "36", ",", "38", ",", "40"}], 
  "}"}]], "Output",
 ImageSize->{483, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17282]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"BesselI", "[", 
     RowBox[{"1", ",", "2"}], "]"}], "/", 
    RowBox[{"BesselI", "[", 
     RowBox[{"0", ",", "2"}], "]"}]}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->27007],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", 
   ",", "8", ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", "14", 
   ",", "15", ",", "16", ",", "17", ",", "18", ",", "19"}], "}"}]], "Output",
 ImageSize->{441, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->27432]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14007],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Convergents",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Convergents"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromContinuedFraction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FromContinuedFraction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["QuadraticIrrationalQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/QuadraticIrrationalQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerDigits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rationalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rationalize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Khinchin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Khinchin"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RealDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RealDigits"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23729]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13579],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->25058]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->27577],

Cell[TextData[{
 ButtonBox["Demonstrations with ContinuedFraction",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
ContinuedFraction"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#15177"], None}]], "RelatedLinks",
 CellID->12750],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
ContinuedFraction"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->78954618],

Cell[TextData[ButtonBox["Algebraic Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumbers"]], "MoreAbout",
 CellID->168123252],

Cell[TextData[ButtonBox["Continued Fractions & Rational Approximations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ContinuedFractionsAndRationalApproximations"]], "MoreAbout",
 CellID->96920365],

Cell[TextData[ButtonBox["Number Recognition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberRecognition"]], "MoreAbout",
 CellID->130845357],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->381869201]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ContinuedFraction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 30, 10.7768766}", "context" -> "System`", 
    "keywords" -> {
     "approximation", "fraction expansion", "infinite fraction", 
      "number representation", "partial quotients", "quadratic irrationals", 
      "rational approximation", "recursive fraction", "representation", 
      "surds"}, "index" -> True, "label" -> "Built-in Mathematica Symbol", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "ContinuedFraction[x, n] generates a list of the first n terms in the \
continued fraction representation of x. ContinuedFraction[x] generates a list \
of all terms that can be obtained given the precision of x. ", 
    "synonyms" -> {"continued fraction"}, "title" -> "ContinuedFraction", 
    "type" -> "Symbol", "uri" -> "ref/ContinuedFraction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9806, 323, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->359039355]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 31405, 1158}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3067, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3690, 95, 54, 1, 70, "ObjectName",
 CellID->3523],
Cell[3747, 98, 1209, 36, 70, "Usage",
 CellID->31758]
}, Open  ]],
Cell[CellGroupData[{
Cell[4993, 139, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5471, 156, 950, 37, 70, "Notes",
 CellID->12105],
Cell[6424, 195, 151, 5, 70, "Notes",
 CellID->29621],
Cell[6578, 202, 382, 13, 70, "Notes",
 CellID->17095],
Cell[6963, 217, 1246, 44, 70, "Notes",
 CellID->7296],
Cell[8212, 263, 509, 16, 70, "Notes",
 CellID->9916],
Cell[8724, 281, 609, 21, 70, "Notes",
 CellID->15678],
Cell[9336, 304, 433, 14, 70, "Notes",
 CellID->10178]
}, Closed]],
Cell[CellGroupData[{
Cell[9806, 323, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->359039355],
Cell[CellGroupData[{
Cell[10191, 337, 148, 5, 70, "ExampleSection",
 CellID->167824805],
Cell[10342, 344, 92, 3, 70, "ExampleText",
 CellID->24676],
Cell[CellGroupData[{
Cell[10459, 351, 134, 4, 28, "Input",
 CellID->27753],
Cell[10596, 357, 395, 10, 36, "Output",
 CellID->20899]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11040, 373, 216, 7, 70, "ExampleSection",
 CellID->15565],
Cell[11259, 382, 54, 1, 70, "ExampleText",
 CellID->3093],
Cell[CellGroupData[{
Cell[11338, 387, 134, 4, 70, "Input",
 CellID->13608],
Cell[11475, 393, 218, 7, 36, "Output",
 CellID->6172]
}, Open  ]],
Cell[CellGroupData[{
Cell[11730, 405, 270, 10, 70, "Input",
 CellID->11243],
Cell[12003, 417, 176, 6, 51, "Output",
 CellID->29929]
}, Open  ]],
Cell[CellGroupData[{
Cell[12216, 428, 206, 8, 70, "Input",
 CellID->7514],
Cell[12425, 438, 176, 6, 51, "Output",
 CellID->10168]
}, Open  ]],
Cell[12616, 447, 120, 3, 70, "ExampleDelimiter",
 CellID->5055],
Cell[12739, 452, 139, 2, 70, "ExampleText",
 CellID->11191],
Cell[CellGroupData[{
Cell[12903, 458, 140, 4, 70, "Input",
 CellID->5973],
Cell[13046, 464, 281, 10, 36, "Output",
 CellID->8922]
}, Open  ]],
Cell[CellGroupData[{
Cell[13364, 479, 165, 5, 70, "Input",
 CellID->6748],
Cell[13532, 486, 390, 10, 36, "Output",
 CellID->5651]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13971, 502, 239, 7, 70, "ExampleSection",
 CellID->10986],
Cell[14213, 511, 227, 7, 70, "ExampleText",
 CellID->2144],
Cell[CellGroupData[{
Cell[14465, 522, 138, 4, 70, "Input",
 CellID->16446],
Cell[14606, 528, 323, 10, 36, "Output",
 CellID->31577]
}, Open  ]],
Cell[CellGroupData[{
Cell[14966, 543, 163, 5, 70, "Input",
 CellID->26517],
Cell[15132, 550, 385, 10, 36, "Output",
 CellID->14629]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15566, 566, 222, 7, 70, "ExampleSection",
 CellID->5874],
Cell[15791, 575, 311, 11, 70, "ExampleText",
 CellID->15791],
Cell[CellGroupData[{
Cell[16127, 590, 165, 5, 70, "Input",
 CellID->15469],
Cell[16295, 597, 450, 11, 36, "Output",
 CellID->22912]
}, Open  ]],
Cell[16760, 611, 120, 3, 70, "ExampleDelimiter",
 CellID->8146],
Cell[16883, 616, 114, 3, 70, "ExampleText",
 CellID->30693],
Cell[CellGroupData[{
Cell[17022, 623, 307, 10, 70, "Input",
 CellID->9091],
Cell[17332, 635, 170, 5, 36, "Output",
 CellID->9815]
}, Open  ]],
Cell[CellGroupData[{
Cell[17539, 645, 100, 3, 70, "Input",
 CellID->26949],
Cell[17642, 650, 172, 5, 36, "Output",
 CellID->26857]
}, Open  ]],
Cell[17829, 658, 121, 3, 70, "ExampleDelimiter",
 CellID->20640],
Cell[17953, 663, 57, 1, 70, "ExampleText",
 CellID->26052],
Cell[CellGroupData[{
Cell[18035, 668, 226, 8, 70, "Input",
 CellID->236],
Cell[18264, 678, 315, 9, 36, "Output",
 CellID->8551]
}, Open  ]],
Cell[CellGroupData[{
Cell[18616, 692, 211, 8, 70, "Input",
 CellID->9487],
Cell[18830, 702, 233, 7, 36, "Output",
 CellID->31226]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19112, 715, 233, 7, 70, "ExampleSection",
 CellID->28162],
Cell[19348, 724, 373, 12, 70, "ExampleText",
 CellID->16955],
Cell[CellGroupData[{
Cell[19746, 740, 134, 4, 70, "Input",
 CellID->23183],
Cell[19883, 746, 394, 10, 36, "Output",
 CellID->8394]
}, Open  ]],
Cell[CellGroupData[{
Cell[20314, 761, 113, 3, 70, "Input",
 CellID->30180],
Cell[20430, 766, 193, 6, 51, "Output",
 CellID->16097]
}, Open  ]],
Cell[CellGroupData[{
Cell[20660, 777, 92, 3, 70, "Input",
 CellID->3065],
Cell[20755, 782, 171, 5, 36, "Output",
 CellID->27065]
}, Open  ]],
Cell[20941, 790, 120, 3, 70, "ExampleDelimiter",
 CellID->2513],
Cell[21064, 795, 92, 1, 70, "ExampleText",
 CellID->9261],
Cell[CellGroupData[{
Cell[21181, 800, 264, 9, 70, "Input",
 CellID->12578],
Cell[21448, 811, 408, 11, 36, "Output",
 CellID->21078]
}, Open  ]],
Cell[CellGroupData[{
Cell[21893, 827, 134, 4, 70, "Input",
 CellID->16878],
Cell[22030, 833, 408, 11, 36, "Output",
 CellID->14140]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22487, 850, 224, 7, 70, "ExampleSection",
 CellID->24750],
Cell[22714, 859, 94, 1, 70, "ExampleText",
 CellID->6149],
Cell[CellGroupData[{
Cell[22833, 864, 164, 5, 70, "Input",
 CellID->3333],
Cell[23000, 871, 409, 11, 36, "Output",
 CellID->13865]
}, Open  ]],
Cell[CellGroupData[{
Cell[23446, 887, 281, 9, 70, "Input",
 CellID->22214],
Cell[23730, 898, 410, 11, 36, "Output",
 CellID->17282]
}, Open  ]],
Cell[CellGroupData[{
Cell[24177, 914, 281, 9, 70, "Input",
 CellID->27007],
Cell[24461, 925, 401, 10, 36, "Output",
 CellID->27432]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24923, 942, 311, 9, 70, "SeeAlsoSection",
 CellID->14007],
Cell[25237, 953, 1752, 62, 70, "SeeAlso",
 CellID->23729]
}, Open  ]],
Cell[CellGroupData[{
Cell[27026, 1020, 314, 9, 70, "TutorialsSection",
 CellID->13579],
Cell[27343, 1031, 198, 4, 70, "Tutorials",
 CellID->25058]
}, Open  ]],
Cell[CellGroupData[{
Cell[27578, 1040, 321, 9, 70, "RelatedLinksSection",
 CellID->27577],
Cell[27902, 1051, 376, 12, 70, "RelatedLinks"],
Cell[28281, 1065, 267, 6, 70, "RelatedLinks",
 CellID->12750],
Cell[28551, 1073, 395, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28983, 1091, 318, 9, 70, "MoreAboutSection",
 CellID->78954618],
Cell[29304, 1102, 145, 3, 70, "MoreAbout",
 CellID->168123252],
Cell[29452, 1107, 202, 4, 70, "MoreAbout",
 CellID->96920365],
Cell[29657, 1113, 147, 3, 70, "MoreAbout",
 CellID->130845357],
Cell[29807, 1118, 137, 3, 70, "MoreAbout",
 CellID->381869201]
}, Open  ]],
Cell[29959, 1124, 27, 0, 70, "History"],
Cell[29989, 1126, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

