(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    168711,       3079]
NotebookOptionsPosition[    165585,       2979]
NotebookOutlinePosition[    166960,       3017]
CellTagsIndexPosition[    166873,       3012]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ContourStyle" :> 
          Documentation`HelpLookup["paclet:ref/ContourStyle"], "Contours" :> 
          Documentation`HelpLookup["paclet:ref/Contours"], "ContourShading" :> 
          Documentation`HelpLookup["paclet:ref/ContourShading"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ContourStyle\"\>", 
       2->"\<\"Contours\"\>", 
       3->"\<\"ContourShading\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Plotting Options" :> 
          Documentation`HelpLookup["paclet:guide/PlottingOptions"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Plotting Options\"\>", 
       2->"\<\"New in 6.0: Graphics & Visualization Options\"\>", 
       3->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ContourLabels", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ContourLabels",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ContourLabels"]], "InlineFormula"],
     "\[LineSeparator]is an option for contour plots which specifies how to \
label contours. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8681]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ContourLabels", "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 " does no labeling. ",
 Cell[BoxData[
  RowBox[{"ContourLabels", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " labels all contours. "
}], "Notes",
 CellID->3652],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ContourLabels", "->", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 " specifies that the label for each contour should be ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8753],

Cell[TextData[{
 "The label can be any expression or graphic, and can include constructs such \
as ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->24033],

Cell["\<\
The positions of contour labels are determined automatically to optimize \
readability. \
\>", "Notes",
 CellID->32029]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->89245298],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->50676642],

Cell["Automatically put labels on contour lines:", "ExampleText",
 CellID->7229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"x", "/", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"ContourLabels", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->485537423],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyFvXd8ztf7Px5F1SpSq/beKvYKVxCjNrVK7VmNrbUVRWsVMWvTWLUVJW5O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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlL1uE1EQha/XXnu9K/HTIEGRCMVUsfgJYLrQ8AQUpEeKkJIoRgIHQk1D
B09AoiCBjBLcYbtxHiH81ATxDDQWDefTGUQxunfnzpyZc+7cvfywf387Symt
y+qyu2VKq7L9RkozHRzL/sg/zFM6aKb0O3l9J1vWWU920nAM6xfZQi2lDWFs
lv7ek72VbSfjTQLza5HS05bjb1Up3dT3KPc5cWPZnbrrUWsWtYgHc54b97Xq
vJHV9P2sLUzZqfKm8n2WdXLz4Zy8xcr90dsvxW00XbMpf0u2S5z8j3S+Jv89
7bt176eZ4xfVw0wYI/W/nLtP8rqZMcHrJ/cHD7hPghP+7+L6rTD2unD6wrlY
c/5hbp2PgzM58+idGM6PZJe0X8p9TvyKev9Q2M99kUP8KOLBHkSv6EnN94Vj
4LQZvE4L90dv4B9GLbivxd1NQgv2zMLH3JisfA9DQ2LAPIl5In4cvNBkRz1c
KB3DOmh5T95eaE48OsJxP+aJXHRHa/Skx6XQ7YF6/1E4l36GoQMYw4g5Cl7d
wCcXnIY0rFfW6arW65UxzgtvofK8P1aPk9KaoBna/Zujacw3tZkZ+J6pnN8L
Xy90YEbRgXl+rpl90TYO83ol+rmm3KKwtp3gSN158IITvk7Eg/8yd40bvKnK
XM9qPVf5jDtfiXvfVc1X8m9xh+I1Ll2bOYInteiRXtF8Vf6s9NvoKfd22/f0
pOX3DBdif0Y8b4y7px/e+k7bMcxgN/v/P+Gbfa5e2oXP4J1V5o7OWzGfn4Qz
aLsGs3YQ8/YXSW6ZZw==
         "],
         VertexColors->None], 
        PolygonBox[{{1909, 2358, 928, 287}, {1839, 2623, 1185, 110}, {2819, 
         2055, 823, 1397}, {2422, 2423, 991, 286}, {2622, 2704, 1281, 1185}, {
         1968, 2424, 994, 1323}, {2705, 2662, 1184, 1281}, {2099, 2865, 1454, 
         1456}, {2745, 2746, 1316, 282}, {2426, 2952, 1643, 994}, {2953, 1910,
          287, 1644}, {2864, 2863, 555, 1451}, {2667, 1907, 286, 1233}, {2867,
          2866, 282, 1454}, {2818, 2820, 1397, 555}, {2562, 2134, 599, 
         1127}, {2846, 2847, 1233, 566}, {2270, 2271, 836, 599}, {2149, 2751, 
         1323, 111}, {2421, 1839, 110, 992}, {2420, 1967, 992, 991}, {2259, 
         2042, 812, 836}, {2952, 2425, 1644, 1643}, {2823, 2821, 556, 1401}, {
         2055, 2822, 1401, 823}, {2357, 2110, 1127, 928}, {2744, 2149, 111, 
         1317}, {2098, 2862, 1451, 281}, {2057, 2868, 1456, 556}, {2662, 2661,
          281, 1184}, {2042, 2831, 1412, 812}, {2743, 1963, 1317, 1316}, {
         2832, 2830, 566, 1412}},
         VertexColors->None]}]}, 
     {RGBColor[0.35646522433036154`, 0.1670299737215969, 0.6180353120507475], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmGuMVdUVx8+999xzz7nXsdoGkUcAhZrYRPABkpSEoYDxgzQIohExAsKg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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllF1o12UUx5//7//bfm8tW0JRF7p5sZHgzG0qONBadTWk9pKQC53ipBW1
aK/ZTWmvVDhTyStDhJKpzLty4FtCU0yFFswmFGXRLjRvaip04efL9+IL5zzf
c85znvPy1G7t73gjCiH0gBi8mYRwJA3h0XIIL0BcykI4CGLINWAIeQKbvaUQ
puC/y0M4ij6G/hd6DfJN/F/Cvwv8Aj8DpuCfqwjhZ7jfwHq4cezrsb+WmxtG
/6QI4W3uuAE/wn0R3FrsP4SbASdz56jc6vAZwn4EtFSGcLrsuxVTsZRDhl4h
G2xHwSyxH+ZsNfwFsAN9FOwr+c5K5CQzt52zamwfxH8XvmPgH/TbYDdcC9gJ
9y74DN9ucjiM7yz3X4dbSYwe5PcKc+285wN83wevB9ts1tvRLxL7Avw55LOg
BLcF/0H8f0J/hvjT8K9iv5h4e7B/Ef4buH5snkd+BJuvuL8L/FByz9Zivy53
r3o5+w/7HzP38gnOrqBvgb8Y+8576A3wX6o/oDH1HYq9Q3dgO5y4N6PgBtwf
qXOdBeuQO/R+5I8j5/I5+qaSc1KuvcS4HDvnefha3rOf92yMLbcnjqWzemy/
x2YF3EegGbkPmwrqeYh459HPgUWRbaqQHwDPwlVx1o7cmXk2lMO3xJvMPTua
2Z7cPVDtVYM9yGO5a6UchzP3QLX/nRjXMvdYvW3lLOW9y8nnGPEGwTy+d0Ab
XHXkXWqEn6jwTjUhrwDvRD5TbwfU49g9fhKuoXCtFfNX+A2pZ18781ruGVDv
5fOKuMy5zHFWxjcGA/gujVyLpzL3UjUZhqvjvqbYO/M3/nOpd1U1HMR2JPNb
teOyVQ9Ue/ksg+vl7EDZM9KG3In/1ZJnWr35IvHuqEcPoS8AReQdSpArC+em
nWzCt7nwbqom06n/CP0N8jlBrDO5/xbt6BJsW8Ep7Ldx9m/qmdYsK4eWzDuq
3fxab0JfDD4t+w+qQb6VmtPOPl14ZjWrihkV7ql6qRrqrXfxeTn2mx8nl8dy
9/Y4+DPzDGt21XPtcl/qXminFyJfh19W9p+j3Vid2Fc7Mo78VuZZ1p8yifx/
4tmVz6LCf5D+Hu38Hfjlmd/ezX0rkVfJv+w/UrluT8wp59uZ/yD9PR1gc+Iz
yarJUOKd1i4rxn3kn73j
         "],
         VertexColors->None]}]}, 
     {RGBColor[
      0.45433895698580096`, 0.33720596253959007`, 0.7556086833779742], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l3+slmUZx5/zvud9n+d5X9tUtiSzlEoOtWWncjMNVwamhIuONDEcCmdI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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlm1olmUUx+/teZ7d93Xf9aGCWiZu62W9gEtKSKygF8uZps6BW+vNrTW1
ctnUViD0ZlLpkqZmRaWW0dtW0Ic+RGU2c0FRGuTmMqGcaEkFGdncdP3+/Pfh
wDn3/5xznetc5+WuaHpwXmtxFEXPQ3loZhxFVVBTLop+BNgLX5uYL0HhWIii
CuQa5APoNIN/gTwJ/kXoPeSl6AzA74e2gz0LnYZ+FXIn2NfonIAfgvYhnwk+
Dd83QgPIk+Qj8rd34JfwrU+6UHnK+dBTYOvwWYnt5eAvg71UiKLxWRSdB9UX
RVEH8ivYdyCvKImiNr5NQL4V+Suw+/ExC/6WzL56CsZmZuals5WzfoPmw58B
PQn2BPQn8TXg83ewOnzWgdVDK8BqiedT4pkKfjdYGfJzOdsolm3I+4scU0r8
3yOXglcRwwvgfwfzr4KvQm7BRw79JuSFyN3YPIavYc4rBZvNt10F52Qt8jzs
P1N+kZuDY1Rsu/n2DfK3UCP8Xfi4B9sO/A3i/wg6jcgXoj8Cfgj5/Mw5Vm43
QXn4HXojfF8BlXHeSfQfAOsh5g1ge5BX5+1jEPkQdLFi47xm/F2lN4E/is0p
nQWNL7aPLegeQJ4FH2NTju4RzqzFVw02E8B/4NvNBed0H7r9qbFpfJsLvgb8
Tu6zE8qQn0mcq3b0L4L/FZoDPz3ns+rQ6cn5zB2JdYSppkdkCy2CXwxtwff7
6J9DbO1Fzr1yoLvrDXTX4/hsKfjOlfDV4HMi5+R08Il864B/BH9v4XsbdDa+
2vExGexD5DXob0RnBrYV0E6wpeg3qPdi57KLb+/C/8W328F+EiG/wRkB2ww6
jDwKviTnmO8A2xqc20CMl3HepanPjtG5nvvckPmt9UYLwdqCe/k7bLrw99BY
f/+sGgr2KV+9yLNT94x65eO875oG5153Pitxz6vXb4KqwWvx+QF8N/QwZ7dn
7p25nL82cY2qNlXzreg2p54FytkFqWtWtao3Px7cM+oVzYSD4IOpfavGy8Ef
z9y7DZpf+F8WfJdG/FfDz4A+Qq5D/xTnnYv9SuwvgRboPOha8A3kbBH2ixPz
KyPn+srUb6ec9yLvgo5GrnHNiqmxc6OZMT1xT6gX3gQfQr4uuDZaoFL4e4N7
91HiuRr+j8Sx681VW7s575qCa6wNX8uhKSW+Qz3686Go4Bovw3Zc5tmomNYr
X7HvqpncGpwT5aIfuV+zN/huad61eTJxL6hGNetVg6o91YRm9duxbTWzVYsD
sW1Vk08nrlHV5n/c91jiHaPdsgD9w4lnjGaLen6iZmFwLjQDI+46GjzL1ZPq
jU2Ja1c9ot21KrFv7bBxqXOs3OoNN4J/nngXDfGtCF/Fwb2lnTGM/onUuR4F
X5Z5Z2hXKKfDumtw7WqnTUFel1j3Pu085F9S94Jm/MHEPate1czRbouxX57z
jlMvdcfepcrfP4lzolxoRuvtXoNyeb/hbfCd6G/WfdWTiXewdq9qsg9+deK7
aaf0xt652rWqkb3Etif2bJTPycE9rt6Wz5rgHaLdoR2m3Z2N9a/uuxn+9eDd
sT3n3h5BvzJvnR7kL4N7VzuiS7MyeFaW5sd2aWxeO1W7qiO2L+2sf1P3nHpN
M7ST/K/PvAv1z1ESnAPdXTn8JPhNFJti0CzRm+gtNFO0K/pS7wbtjP8BpzMo
5Q==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5522126896412403, 0.5073819513575831, 0.8931820547052008], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmGmMltUVx595t+d9npcEE0ykhQGn0CbtlybKJtqy+WGQQijoQFlMLTRt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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlllsVVUUhs/tvb1nKAkmmgBCgTIY9cUgowVNGB4oCFRQitKSCDgkQAHx
jQiIINBCoQJlVkwYVECLKEJAGVtUVEAcEiIBIhajUlQIQdui35+fh3Wy1v7X
WnufvaZdMHH66PKcIAi2QRmoRxIEt+MgmIRQDW2E3wQdTQdBGfiAvCBYFwbB
zFQQ7MsNghr010JZ+CmsnYmCYCp4EU4HYdMd7Az0KPh+8HbYd0RnGHgla7OR
h6DfE99Ds3zQbQKfCz6Z/X9Gvgh+F3wx+ps5y9tQPb6nor4H3UegV9HvytpE
+ElQBXsNBp+M7nPQa2AbkTuD5bPncnwdx+cX+P8U/32Re0NFyJcT79UavBP6
ZeCLsR/OHnOwHYu8AV9Pct7HkYdDA5GPYpNGvxn7KfDToKGJfcpXFToTwBuR
y8DmcMahnG0B/nbjvxZ6BuxZ5GvoLkN+DP55/F9H/z3WroPfgLpkrPMh/nZD
m+Dbcb5RYC+i34L+x+gsRf4OGojcojOguxGfs9j7fMqx7hM5lor5Ivga8Glg
Z6Hu4H9DTykfdEbwX8B/A+uM3A/fH4B3AF8LnYh8B/r33uAXwNdBIfIIaKf2
Rv8yZ63GRzO6LVCntGNeDdYF/QX4usXag/BrwEfzfxWsdda/IB/H13zk88hV
yln44az1gu8J/Z6yz3z4jtA88LkZx74A+5KMc2Al+33OmfalHIMeYPejvwT8
XfBt8Nuhu+F3KObwYxLfdS/0b2HbLfbddMvY9oHEZ5WP9yPXlGqpIzrtdVfQ
IvhW5E8R9jnI09P+x/WJa0q1pDu7DrYr9F3pzD8krknV4iDw28gt0KDAOVfM
fnXo70X/W854BH4Ua6fhd7M2i/9/Geqbdc4ux7YSmpTyHf6E/hb8t4IfmWvb
Q6zVpuyjIfE/6OxjwN9C3gB+kvO3Rn4J30Wxc1l7rILvhs7CjHvAfYl7gnrB
Wfytxvb1yLmmnKvGfiW0Keuc6wB/b55rrwr79eh+iX2fXPeMttgXJM4F3cEb
ea5x1bZ8/AHWiE4p+uOhNYlzRrminvUrWD/05+G/IO1Y/sNa9zv5rty+ipyf
cY7vjN0DVPvzwUvB6iLngmJ6Avl04n9TTtXGrnnVunyoNgtD9yLV6Cfge6EB
Kdf0fvibd+5DZyiBHxe5VnU/M/H9CvaF8Ocyjt2yxLWtGHbFfjzyMeQVnKc+
dE2plvqzX398fRS5V95Af2TinqFeoZ5WCn8Q/GZgH+L3xc5trf2Iv1M6b8Zn
rECuwOYWchM+x8Kv5h/rsu7BxeieCZ2rB8API/+rHoX8EDaDkYdA5WAP478J
bAV7ts2xThK5BykW2nOJalPxxPcx6Cryqsi1qRhvBmsTOzanoBLwp6Ej2G5G
/0DonqBe0CvXvWRYnnu3espi/V/iu9Ie10LnkHJHPbsc39tZq0q5h3UCGxz6
7Oox60PXhGpBNaTZtUw9LsczrAz7S4lrazY23yf+J/2LevTWyD1Ivecezj8d
/cngX2E7Ah/NsWemZqXu7GDoGabZpZqYFnoGa/ZqxtZEnomahVnWylXfkX3L
Z9fEMVTsVKMTYp9RZ9OMHQc+AfyvtO9wCVg+VJnymmJfGTq2yoEU2ELkPWn3
NPXyJyL3IvX0ceAlsWe33hQzwQ6H7k1/6ryazZFnZX3WuaQYKnbKqSvo7ogd
W/X4BuQLoXurZtIl+CuJe1MD8lJ87dLMTzsGK/VeSDyrNDOP46su9qxVTbWN
naPKTb0ZxqNfGtmXZuYh+M8i12IT/k4mftPoLaM3xFbkLYlntWbGWs7zJvK5
lN9M74SOqWKpHNLboj7yrNQb4wV8LY7sW2fOD31Huhv1dN1t+zz3Qt1x38gz
WbNYPawwck9TL9ObaEbknFeuN8on8tbQuaA3mmI5I7nTS1Lu5f/Ffnupp7fR
eSPbagboLaIeot6hN8nX6H4Tu9eoh+lfLyae9fpn1bJiqliqpv8HNCRgmw==

         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6272460091966561, 0.6294719910534027, 0.9109446392011545], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHmM1dUVx38z89683+8+sDpsKkWURSqxw2DAYm01qaBtAnEZGLAQEzFB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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlW1ol2UUxu/9//v7PM+93rBsoalMoyiKKHqZFi5yuYQi9+KcuSLnhwhr
Olhay9wyqI18CRRzYn2paVouTacJs1m0PmTql4qoaJqZGmofrFkyo9/F1YcL
zvWcl/s85z7n3GVNi2qacyGEDlAM1qch9CQhdBWFcBzFviyEf+AReUE+hK/R
r4dfhN8H70TujCH8hfMwuIi+AXyP/mn0G9C/jf6yQgiXgz50FXwbIf4N6F+A
LwVNnF3Apw15Gchy/lZdEkINaCl2jkfJ5xiogpdj8xi6WaAZ3oJ+M2c9QPxL
xB/DeYewnUm8QeWLzUT0E8D76A/zrR55NhhAdwC8gf30xLrz5LcDfhY+jP0Q
385iew5+AV6MvgE+N9r3DOfXkksdaIWvgU/l7HXwLaPQ49MKX5L6X2vRTyb+
4cy53ca3xegWgTuCczyN7nfwCPoK9B3o2lP/q2pUhm4Q3IW+DN5ILvOiY91C
fnciN2L/E3wtNufh++A3oWuiPl/yL0ei724v510iViXf5sObwCn4ycz/ohyG
kH/OfBe6g5FMiYTwaJF9NqaOId/IGVuJvQ2UctZ2TH8j9pvU41Xq8Qs+76Lb
En1XK1Rj5KPRvdKGfS/yR2AcvB9eghyj7153fhXyldG1UY/s5ew+MAo+Gf54
dI1Um8/h88jvCJiWd03UG3sy26pH9iP3Z76bW/l2IrqGql0NOVyNPBo8mPMd
1yDXgv3I/aAOeZCYx8P/3/jfr6JrsY3/24W8G0wk1kHVA/kkqIO/hk0ptbkO
dBZ8xgzkKjAAr8T+M+IthEfqV028LnJthzfAu/BvRH995ljK4VPkgcz/Mibn
2vwZffeqUSn2T+D/XcE9V488BxyCvwO/V70Gv5343fBx8Gb4zfCH8F9JrFVg
hPiN6F9EbgOn4KXw5cjt4Az8Rvgu/HeDFfhuha8kn1Wgl3zvDu6lSrA9755q
xfd58Cv+uIW3kDeAAvkthP9B/ueiZ1MzWY48BeTyntlpiXeOdo3O/Bv+SebZ
0E5bi24nmJS3zxfoTsPr856pncTaEX1X6sEPkT+I7kX1tHbZe/BrCt5pPdE9
rV7Wt43I3dG9rJyXIi+Jro3+6Vvkb6JrdwH+CnJHdC1Us2XIL0XXTjXVru1K
bKudq93aDb+i4B2r3t4E/zfnHs+l7lH15jPo7+fu7uHb8px9xiM/i/3oIu98
7c51qXebdugs5OrUu2E26EUeSjy7inFQvZ+4t8fCn0OekFpWzM3wBanfkkmc
twb71dF3p55pQV4c3bs/wvcg94EfgmdEu2p+4tnVzprK/byc2LYn794dSDwL
6uGZ8IdL3OuamdWp3yS9RapJFf4zMs+Sek53rZiKpTufnvkN0O5XD76Ofjj1
26c371rFLvFsaEY/Tl1j1VY9NFezWOLZ0AxpdspT737NkGZnbOpdqBk6lnjH
aLdoB2iWn0z8lmimtStPJJ497Uy9JVNSz47elKfgg4nvZqjgt0w1V631pmlX
HIBXBO+MOanfcL3deqPHJ44hX9n8B+KICsE=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.699205849886277, 0.7450914320029793, 0.9125851019295395], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmH2wVWUVxvc595yzz9kX+U5BwMk/KhGuJXfQQEhM5l7gxofQVGr5NdOE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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlsV1UQxV//i29zAWQHE/lgAikgQmIUW0GRFqiFgnuMICREBEXDvgoF
6xYUETASQBCUqIhIQTQVEHHDIotrXHBDBdqC0Eok0S/+Ts7/wyRz75mZe9/c
MzOv27iHRk3OBEGwEckh65MguDoMgsfQW+WDYFMUBDORvzFqlw2CFDxClrN+
GIdX0V9HOmL7aFEQnMd3HvbnwIux78W6FPxFbCcQcwv6VqQr9o9j3xbbJHGs
EuyXxkHwIT61YGeIMTINgonYNKDX4/NG4jN1VifWt4HfgRxCfwGb/WBzkUbi
9WOvGn0+Mhz7v9hrIn418RuxHcH6U7AZyHH0vth/jr4wse01rDdy9kHs9+K/
D1kDthqZybdsxuYd8HeR1tz9GHvlxB+MnAXbmrX+NHIu6715+M5CKop8x9n4
fh06t8rxH+gnwXeANWAzCfwE/pU533kS+o3YrGL9LT6tsb2V7z/AXZ8HrwQb
xN6mnO9Yq1jI5eBPEK+aeN9h0wnff7C/GKwPMVeiT8FnJOudkb+ljnVnsKrE
eg0+XfEdw3lHiTcUmxHor0WOt5+9feCHsP8i4zfcDbYi9FniQy3xWlj/B5Zn
/RH4Z6xboffLOjdzkIacczQVfTryJ+thrI/hvyA0H4blfPaCyPF1B731AuR0
zm/eH30xcoZ1FesN+FZgfwD7L7G/EGxUam4pB60S70mfqvjyRUbnzfHt6M3I
vXnnVNz8mTsNyflO4tZR9iqyfq+zrJuRas7eRr6q0MsTc0c19ib6WWRM3jWh
b7so8VsonmqtKnVuVXNzItek+KIauxl8Xeha3Y7PNLD1kfPZAn6Sux1HBmbM
oZew3YBPG+xbsHkWrCw2V88jvfEdzXnfg+/gzpWshyM1+Jcjt6TmpL5NnJuA
7wOxuViD/cTYe9K/Ya8PtuPwOZF3DY3m7HuQ/hnX+xyw+2Pbjud+A1hfj/TA
tg6f+tAcETdUY0PBBiNL8P8AfBVYHTbrivymy0NzrriQn57YlrH3MravIKsj
70lPsXkGrI697oV8zVLvCr1WPSpX4oy4opwVp+aUuKSYXcR95AbwMuwb+JYO
rAewHs73lKIXJf425XAN67XIFPRref/jwnVf8FFZv90uYvTK+Q13o7+nmBnv
laV+M73VXs7/Cf03ZGjOOR0PXhq6nzeD9wT7PXatCH8QvAl8Pvdvc0EQ3JW6
h6p3Hs67F80t9G9xTLU5PXJudB/V/pWRuaEeoLe9InQv0BuPAbs7NNdV47r7
+0jvnL9hD3qATd+s91RbnSPnTjXWHbxHbG6I75WJOS5uqyf2BTsVu3eL0wsj
z5ziQj/7NfZMkb9yIu43xn4L2TeGzoG+XTmKiX1T5LPUP+4DP1J4v9XIQfDB
7B3We+Xde1dG7l3qweLeQOLtypuDHcHaqGfpPGzagnVEngIflDFX7kyda3Gm
hHVpaq4rhrhzSeLeoztcmrjHq7cr5iOJZ5xmm3rcHs5fHHpWbuH8JbFnmGaX
Zo6+ZQJ4fSFez8g1IO6Lg+L6jML7ivMzE/dc9VrNxPapv0F3f1I9EmxF4lmu
GTNZvSg1dhqbX2JzUlxTT1RtLQ1dS4qv3riIdVPGPbKEWNcha3P+R9gI9lzk
2SeOLkr8Bsq9erhm1VWx30Y9+iuwI6Fn878599LNif8N1FNb0N9GuqGPRcqI
3TVyL9OPj3pJeepaUk/RW7cPnUu9+anQNaVaUg//mFifJO6dYZG5PCR1LxKn
p4G1U78p8szamXgGa/bqDv24+8TQvsrBtsT/RPoXugz8R+L9EPluOzLOzbLQ
36YczU78z6J/Fc3IeWBjI9uqZ6qXaGZrVqunlGvWh+4tmsm3p34zvZX+mTTL
3kp8tmbauMQ1ploRZzqk5rS4LA5rNnQJ3bs0I/4Ha+ZYog==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7702957313957156, 0.8495539836864707, 0.9105972072033353], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmH+QVmUVx+/73n3fe+/7JksJTCZTmREolKyVNgbpJCyGYODADGRB0QS4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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllnusz3UYxz+/8/39fC8nl5VzNrFKwuEQZtHKicI5xXEdm9zT5nAYRSxk
K9dWGzoI53DQaag1qRRm01zyB9GFP+i2SE2x5ZLa2tp6vff+470978/zfJ/P
5bl920+bO3pOUQjhHZAH85MQ5oExyBGKG3EIE8DPyP/mQjiFvBN9Hn4Y3jkN
oSvYEIVQB4ah+xFUI5/B5g/sx4OfkG9h3ycLoW8m5yHchI9CHglK0XdkrRZf
i4pDqGwWwnl4P3wNgKfIK7AZAx8LzvNtDfgL+w7wZzn8OLAHXgpew741/A7y
Jvafk7PNTuQ1+HsZ/4tZa8HezcFg5Hq+WYL+Av6eRr6I/a/Ik8Be9h7J2hbk
x7HZHnym3+Bt4IOD7zCB/caDGvgC9FORp4CF8CXwRdivxX6K3hKk7H0h9n3m
st9I5D7gEvwD+Nt8exr+Obwl35djX2BtHvKb6I/jrxw8A+8FKpGngkucZRco
wbaR78+iezWy7jswJLLNbORl6Kvwvw2sQV6QOLY64xq+P87a39jfiRzLCnA7
55gei20j3WOFENbDlyS+m+LTDbk7770b3aO8QQnnHwQ/Ap/J+fvBK8AZbKeB
1/F1CB838Pen8gm5N7iIbjf2vVOfWWfdhv4rdA2sFaHrj8/dyJdZu5pzjkXw
dfCjyC+CIchdwGTk85x/GnvPgOex38paJ+wHJY6F8vkL9LWx9+pVsK8t2OTy
9rkWeTlrY3J+o3r4ZnA0ZxvF5kri3FGMBnL3AfDavN+gK3IZa43oZnOeHey3
HX8Lc86BG+jPwQvYT8Tme+UmGBU5hiWJa1BnrcRmGN9fBWML9qFaUA4o9qqJ
EcjDQRXPcyBybo/D/47gHH8wcU2pluoKruV2iXNJNa3aeQN9U8411Iiuo3IG
fQv0x9n7RObYrQuOXQM8KziG/fm+oti1fJi1regqwQs52+RTx0yxUo4vxvZJ
fHyIr6pm7g0zU8vqEbuQ30td64q5fFVlrh35fAp5YObcqYWXcd4O+KjX3uAs
vr/NXFuK2T/of0j9lqrJang/9Tz231fkWIxOnDuKyWx8/R67l7XiPBPgTxT7
bt+ApsQ5qty8hz1eiW0j3WV8TEQuZa0v/s+xNgL57tS9YiVr3ZAncb6T7LUx
8tufzJyLisE1+PXUuasaLlfvjF1rDXwzXb0IrIh8h9XIczP3thns/zy8B3xt
3j2iZ+YzaG+t1SD3St0bVSNnuE8X+Hr4f8Gz4CDoFHkmKLfb4mNp3jmu2OXg
0/OOYevMPUC1r5zrjn4DPCq4B1TD09S9Uz2zSr0rc29Rj72M7pfUb6GevTFz
jBVb+Zic+Yw6m96sTLFJXDuaaS35thU4VeSZoN7xNTYDCu4h5/j+rdi9SGtt
0O8FbfN+wwp8DU8823Sn1dgOS11Lh8D7Oh9rpehKwEfwW/D7ke8D+1PPWM3W
9vCPdRf4vmCbKci3sX8g75n7MPwEvDm+58PLUvco1bticCX2ntpLNd9TZ4ud
a6rJVcifpN7rU/UA9Bti92bl9yOZc1i5qzuuhK9QTXKeevhWxTP23ndFPksP
1l4q8pmOxM5h5a56YLvYPUG9QDbqVc8lznX1rO7q3Yl97Sn4rnojvY3ufB3+
Logiz5gD2H6W+N9AOSbdzdj/IrLRrO2WeRZq5s7SfEj976A3vZi45lXrmun3
xr6j7qYeeDB2TagW6nOe7UMT/xtoxg9FVw32R36TVYp1bFvlUFfu3rnYvbuJ
PYakfnO9tb7R7NOddVfNwIfgmxP3xgZ4eeqeq16rf6hlnG155tpVT2iXuQep
96imvsT3ptS5pn+CWfBjiWe/Zohm21L4nSLPuNOaxYnjrTX1vs6J91YPbML+
Wux/s1zk2dul2HfRDFYu1yXWKaf/BxpEPrs=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8349205523261927, 0.8711046394774511, 0.8816453453388922], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl2uMVdUVx8+959x7zr632mYoJlo/tFhh7oCP8FISZrRgI5lSaIxTXx1b
HSvaIlNpILFQrC1CU4z2kQAqGiWhAk2KqH2YaNPUNoKSRsUaoZrw8oPtMIEB
am2s9v/rfxE/7Oy911l77bXX47/W+dzNw1ctqWdZdlsty3LNI9ps0nqexvoi
y0YbWXaO5hHNRzVW1LxnfbcOfKXpbz/X2WM1r+GZLvo0jeXifSllWU+ZZQPi
ydpZNlnrr2o5v8qyc1tZtkd3XivaoPZv1y17NOQ8oTu2agyJf3fsWQ9IZp/G
Ma0frVlvdF4lOb3JZ76sea32N4i+obDevxD/FtFXtq3zLt25W2Om+Puly/mi
Pym+P+jMkob1XKrv39U4rjseE+3xhu/kjhcb1udyfZ+rs+vq/g5fJZ7Nwc96
S91vhedv0mGKdLtVZwd13yMN63+1aBMl52eivyv5v9K4R+sdhWXCs6luO92h
cadowxoT69Z3OHQ+veft++WHfRpTm7bxO2Fn3nxnnO2uWR56Pl/zW6/TvFc8
Zxf2LfOzhd9xr3Rcq3FL02OoaV07+r61aXncyTrVPG8LOvP2pt/Bu7E375oT
scRdvJU3ow+++H3utyyQ3RYm76+Qvx6QDlvFt1BnFzR9ZnvctaHus9eI9/qa
9UPP87Xu6Nyzpf24Is7Af1jzoXhPd9gI+zyQew1thvi7tJ6g9YvSZbfGzMJy
Xmn4XfdpvVs8b0r+Tfp+IXHOXrZfUVqHd7R/XXyf1fpPon+79Htv1zwk/obW
H4o+TucXi/dG/Kdxv9bjRTtLY5l4Kt1X1h1LyNucW+a5mt+rW4dO7jeg/9M6
t6a0f2doXqCxWmcv0p1D+nZA9DMKz9D7G77z+YgB/I+PsDm+I1Z/rXNnJ+cs
uLAzcg19v9a0rbANcYd9Orqzv3Tu3CL+N0RbGnH7X+2v0XpN27bADtA+DDq2
+U8y/aPc34iN0cAo8vwzLefkusCzwYgxcuv9ZJ0rnVsU32/WPccDT5gHYo2N
t4adP6jbpm9GLk+N2M4K2x/dmNnfJPpzGlc2bOd5Da/BQDARbEQ37NIVtt1F
nNbtu4sbxjTi8zLdPzsZ+47kjht4Vub20TCYoHc9olHpHU9prEzmI+ZHAkOw
zUjgNvhMvBLzc2WnUva6Q/vFheeLRJ8keT1t49doyCFufyD5S1vGp99pvUZ3
Hc2dN9gZe/Y1bAdsckHDvOjwsvjXJ/tym+ZfanQVln00eMBU9CA2TjT9pjHN
368cN9APaX5CZ8eJb5Lm8fo2q+7Yv1Dn78rti9lN50Wv5r5YfzP3fk/NfOjH
vRMkY3KyD7DN9Khf5B7YRMxfXlgOMrAldOoI9/SG/B9Kzo8q597s0nUO3N8W
mAcGnky+j7vQg/PEDPgKL/F1nmzfXTlGj0XMpcj3Trxve/gRucQXcUYsPRmY
uCNqN3Uav1MHr4scgbc/+P+PoQ3nPXFHbuBHYp133F7zHl2IgTML5wOxR23/
e8uxPamy3vCtyu1bcGCj6J9vW+7+6A2IPfRbEHWhE2tyk3lhrKdF7SJfsPfc
sDmyx4V88mDZabzSXf8qbSfOTo+7Fuv+GS33NYejboEhR/B75foHVpFn9BqD
ubGeHH1N5/5aOq6x3/roJ4aiXmwKjAK/wCJkH446cq/OngO+FMbDg4GJxBV+
xafE7pHIa2IB3xIP9B3PJNdjcIIZf82inyptB3CG+jMQfQK2pI6spU6Wzl1q
ILWQ3oC+gDV6Hgo9sQMxciLiBP0OhC3+LP1faBmTJoCLyfWAO7mb2vpHfd+p
u6aI5wv6PicZe66Qzce3nEfEJ/zoORLYRCzh607oTS78JXe8QespbB9q9Y+T
8XBT9D7wbxTtoWSsuV7zDcnnx4i36DPHCtsePSc33XOAU+TWvsivpHPzxb+c
HNF8KhmPr4z8AMM/JdonNb6X+/yhsBt5Pzvw5LjkdZeOnYf19o1tY9dg9AvE
1UOiPahxkvOSN7nls/jo0tATm3067PZPyfxH5e/4Zyx8dErfT0Wcd9EXla4J
y6NGYcO3xLO/5Vyf0rKNsM/U6AlTYOCuiL1vSa/flMZRequ3S2PD13XuG+nj
noaZ3J8v2pc0fps73+lxyMET0UPzlgMR89TT70jmcDv8ULo34sy7pfNzffSP
nfA7OLsn3oK++yOXv9hy/4dul2ie2TK2jUZuroiec1/wD8h+V1fuMx4t3T8t
C9wD81ZHHo2F/Ve3nLfHI3ZOBJ2+hneCOScjX8gbbH9xy/ZH7qqww0ei1dru
y8lxeh36HPZLovemF+tPjrGq8Jt5Lzg3J3CiJ+oQNsnFWyTjAzi/I3oberuJ
0Yf0RT1CFmvqFrXpvMq1h7pDHN8VNfd10d5I5ntL83uVde1Jrq+n8WlW9Gnd
9AaV/29e0vyyxqXEUfL/3kD0fjeG3/cm34F8fAAvPQY4Mhj94ebQhzjkH5Ec
Jn/B2bvD5uBid7yxN2Qh52D0xtw1IXCcXDsYOMb+Nd1/hmReVjhH6NGJ5fsj
N8nzT+j7q/xbRlxQ54jzDcRp6X6T/vFo9JBdEQ/4nLzcGbr+tLSf8NEizbcm
/0utk/yfVK6dQ1E3wMBpEdtTY2yJ/8T72u636J/2aj5W+V2d6OWxx6KG44Oc
IQ+fC7wCi49EvGEn7MWaWvdC1LvhluvEaP5x3897H0x+A/rTF5wZ9tgW/3Tk
1Ps6+++W77+qsn7oRv91QfRgxNms6Gkfi//medFTEOvE+d6og+TsJckYRCx8
EP8u6EOt47+dendPsl2wCXUeHAQD8Wtv9K7MffFeMHVm5O//AIxkHME=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlW1olmUUx+899/Psvq/7Lqtp0Itf8gXdXCrRZoLOcgWxTEM0m2IvzhzR
bDVIqqlQ6hYphUVOrRntQy56IcveKKKycssRlilZFiH6wUyZmmhv2u/Pvw8H
zrn+55zrus7rVYtaZz9QiKJoHVSELk2j6ECIosVxFE0G2JZEUTvyIeTqUhQd
gz8OVaK8Hv3t4I8jHwG/GvwX5LX4+AfbIehcBDYEehT8Meg8+DnwFvgq8L3I
I8CfRm7A/jT8SPD52PdxVgnfkEXRW+h2g7fB34DOa7HvvAV5GPJK+G3oDODv
eeR/dRfUBL+Fs4fLouhXaBz61dCXYAPIOf6/Q2cathO4sw6+K0e3PIoG+d96
8Enod4E/h9wJPxJ/n2B7irPL0W+G9uCvnbNvwDYGB7OO9zYgz8ZHP1gTx71g
r0IVRb/pA/A1yL9jf1z/gR/B2cdg7yGfwXYutK/gnOwHO4t8L3yKj3bk1sy2
o7FpwH5GsG0j8gr+shn6g//cBs0CuxVaoLtj/2VmMK8/fQXfg/8K5Br8T1Fs
0elF3gq15s6JcjEOf6OR5ySuBeXobvQvgVrx1R87912Jc6kamIo8HfudJfu8
BuyuYN112L8B38jZh4otdBl/m88du9FvR74icQ4U+xPQU/h6HRoeu+Z+gy9B
14HNix2rPfi8vuiYfQu/hLM23lvHWT9yHzQXuRb5bOYaVW02c+fYxDFRLBZi
fxr5I+wrFf+Cc9WBzcmicyZ+dea36Ux/mQINFPyn4WBXQmsLPtuH7716U+Q3
LoBPofvKXKPj0a3BfjX4AHI5cj33L0W3BSqHP89ZK299qORYPAGdKTgmSeYa
V23L5kL43fifWnTNd8Bfqx7G/7HYvf428uHYPV+lfENbeM/Lyjl4VfBsUI+q
dt9PbKsaLnHfitS1rvfVIL8Z3BsbkDfm7ln16knqZzvYO8G1egJ/m8AXIZ8q
d82qF6cF15568ii2RxL7auQ9MxLXkGpnWexZ0J04VpoJylUT8jOxc/YI/iYj
P8v76vHXidwBlbh/MfKwzDWnWlsGrdJ7Es+CO8vdG22p36oeqQe/MbeucqrY
XpC6thRj1bpyplio5qvx1ZC6dpTzbmxfyB2LFKyIfSl4Nt0DzeTsJux7i66B
ifATMs+y5dw/Cvxo6lq/HXxQb0tdq5o5yu3FwbNXOVZtheBYqcYGg/+ov2kG
T0dekzsWmrHq5Yrgu9TT9+NvLHgPf0n1htwzRrNFMVXv7QzuJfXgytQ10fL/
fO3Evit4NmsG/QX/N7Sw6Bxot/yZufe0Y4Q9mHvWSOdJ5C/AJ5Zck0ODc6pc
aqeotz/NvKvU4z/BH4BuLrnHX9K8zzyb5yH/mHkHafdIR7X3Yu5cqAYPZt5p
2mWzwDcE+5DtOe6bA/+15k3sGb0r9Z/1V51pdt2B/c8FzzDVYh94beyaXJV6
pmuWq2e1u3Yl9q0dthR8o+pF/QX+LthnvGk8vnpi89rB2r06O4zuIc2Hgu/c
kdmHbBWzzfjfFFxb2lHL4VvQ+b7oni/jvVHuWtJM2Rq8A7X7hqLzCvLBxLx2
WH/qGaTZoz9VwY/JPStUI/uRf0i9m5r1psQxVSxV0zvAPk9dS3rzKGzHpNbV
n5cE7wTtAu3Y2swzQL2vnay3TwqOhf7wH1SLIQ8=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8995453732566697, 0.8926552952684316, 0.8526934834744491], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl1uMX1UVxs//cs75n3NgJogZDKQwUzpjnLSGJlQYtYUZg4mQNEL7YFJx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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlFmIjWEYx9/znXN8mzHGFMWNZVBDomzHvpe5mKxFyTBMzSgziBjOMPZC
1Nj3EheDFDIuLMkFxiRZx75dIFIowgV+T/+5eOpZ/+/zPluX0qoplZ5zbi6U
gr4HzvXynatGWZJEHzp3GHlpwrnX0ObYuY3QaWxlrZx7HjlXiH0F/hPTzp3A
fzryLsDyoH34HoT8Fgwf/7G8UYd/Boz92A5Ak8G6g9yA33V8PmDfh/838ErR
TQVrGjQPWwVyCXwT9AP+B7r5vP2d/At8/cFynwFtIH5dKKzPyCuwP8I+Hv4J
8Vt5e30oWzVyCqzByJt5vxz5C/xvaDb8JOgw/odi5Wp/2ga/Fvte8Bfxhw7E
r/SFtTKlWmSgmqRqUu23+MAfR5cl9hy63cQfg/KR/5JfvqeYHeCPwz8XeS34
Z/G9hvzeU0xtSw729gTkEVZ/6Bqx9VCILYJWUZ9+xLwBeyb0FL4YezHxA6Dt
5FOf0lvjI/H2ZkBsLv7ZtDCGgT0yFPZw3muPLQ+fTdh2ptWLn+CVpdWTk9gX
I08BqyMxCXz/4dMTeRH2HOTWsXJbg/wJ/8+BetfN0yy6WL42k0Pg22KvRb4I
LYlUA/v7O3K+grzE5gXfQssJuQ4qx34X+59QM2SzMwcqAKtzrNxnEfML2+9I
vbYebMG+FXpF/DJSWRNqhmx2PpLjGOTRod62nVgA1qBQvQxaadaW49+c0sxV
gr0w0lum6x+oRlabLLpn2F5E2qUmmwfw2kFtPNXY/nYK/05J/bGGt2pD5bIn
oVqXR/qr1fyCr5wsF5vRbKwdtd20nctYvlANvg1p9a4I/BueelhltY9Vqwp0
A+EHBMrVZqIRrJuhejUopd7EsXppPbqN7VYoWyalW2E64+1mfIXvGuqvtuO9
bT+tpinlYLOajLSLNrOPkZuhU55q0ifSjbLbZDP8GP4h1N8Tht2KTbFuld2M
e9haE9/X0w699LVjtlvWY9sduzl2a2yHDOsB1JwQZnd8iyLV4khat6EHuqNp
3Qjjp/mymc56NThWba1nw/Ff7Wt37AbaX94G2kX702rs5331shG5EdutQLfN
dmY9/LpAs2g5jSKX0ZF8bcbtdmVC3Ra7YZexnQGvLqGbegn5aqTdMJ31fmis
XbIZyAH7fqjbbDX6D3PFxpk=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNkz1rVGEQhd+9eze7917FL9BGwYiQWC0YP5LdRht/gJ1NCkGwyS5+gB8Q
NSpY2Km/IDEWEYRN1GazgvsfNrbaGPAXSBo9D2dAi+GdO3dmzpkz7zt9vX+1
l6WUbsjqsq1mSo+KlHb1sT6V0jvZWSV8bKQ0I/udfM7K7srfbDhnoPNkldLp
Vkpv5C/LOnXXdqIXPrXDzH2OlSk9EN6pWkojxdaUt5i5F/nkbGfOB2uc+ftP
xEfh8/+r7E7wof54zf5W4x//T7ITij/TfC/FtS+MQzqPinNXOXXxudYyB7jQ
H25LU/bB/FX3CZ+2/BcN167m5gEH/EFoNQ5u/CuFVVTWZhha0OeeNJgId7pm
reZCHzDBhgOcwGNe9N3JjUvd/aZrye1FPjz5hiuxfsQnuWvJR2PwwGKH67HH
V9LhtSyTvydby63n29w+M3Kuho+u6DsXcxKn5zdx25FdEcZY/T6LZ1t5BxRr
Vd4L/9qxd/pngYdmk+DJTr7HXibxDx0OKtapjEtsHPFu5OET/1k3z6fa+/PC
2qDBJDScCf7cjcvieak0l6oyBv0vyl+oPOuGYuda1uSLcoel38Mg9CLerVxD
Pvt5XHiWHy3rwtwPm34D7IUdsS+4LSh3vvAdRC9i3JMnii0Xngfbjblm423C
nzgzg0WPvHQfNIUbu2HXm/Eu3ovL7aZr92IGcvaJ+37Zir4P6zxS+a7fVL9b
Tc+4JL9XWkt22A39ubeL/73TcdyLuXiH3I35ytjgwv9MvAXu40rcJXA2Qmc4
jkrnf5C/XbrmvP5fqPzO/wJRzp6Q
         "],
         VertexColors->None], 
        PolygonBox[{{2564, 2563, 606, 931}, {1974, 2434, 1002, 1327}, {2749, 
         2750, 1320, 285}, {2707, 2665, 1187, 1282}, {2747, 1966, 1321, 
         1320}, {2748, 2151, 116, 1321}, {2436, 2954, 1646, 1002}, {2100, 
         2869, 1458, 284}, {2624, 2706, 1282, 1188}, {2873, 2872, 285, 
         1461}, {2870, 2063, 562, 1459}, {2869, 2101, 1459, 1458}, {2429, 
         1971, 999, 998}, {2272, 2273, 838, 606}, {2954, 2435, 1647, 1646}, {
         2835, 2833, 571, 1415}, {2829, 2827, 563, 1409}, {1913, 2361, 931, 
         290}, {2665, 2664, 284, 1187}, {2824, 2826, 1405, 562}, {2262, 2045, 
         815, 838}, {2825, 2062, 826, 1405}, {2151, 2754, 1327, 116}, {2045, 
         2834, 1415, 815}, {2670, 1911, 289, 1238}, {2431, 2432, 998, 289}, {
         2955, 1914, 290, 1647}, {1841, 2625, 1188, 115}, {2430, 1841, 115, 
         999}, {2874, 2875, 1461, 563}, {2084, 2669, 1238, 1428}, {2070, 2848,
          1428, 571}, {2062, 2828, 1409, 826}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2875, 2871, 2873, 2872, 2219, 1906, 2749, 2750, 2747, 1966, 
         2748, 2151, 2754, 1974, 2434, 2436, 2954, 2435, 2955, 1914, 2583, 
         1913, 2361, 2360, 2564, 2563, 2137, 2272, 2273, 2263, 2262, 2045, 
         2834, 2835, 2833, 2070, 2848, 2084, 2669, 2670, 1911, 2261, 1912, 
         2431, 2432, 2429, 1971, 2430, 1841, 2625, 2624, 2706, 2707, 2665, 
         2664, 1905, 2218, 2100, 2869, 2101, 2870, 2063, 2824, 2826, 2825, 
         2062, 2828, 2829, 2827, 2064, 2874, 2875}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2053, 2503, 2505, 2504, 2506, 1834, 2779, 2780, 2778, 2005, 
         2338, 2544, 2947, 1890, 2545, 2389, 2366, 2967, 2367, 2364, 1918, 
         2365, 2114, 2566, 2115, 2567, 2059, 2514, 2061, 2512, 2060, 2513, 
         2150, 2752, 1969, 2427, 1970, 2428, 2668, 2359, 2922, 1973, 2753, 
         1972, 2433, 2956, 1920, 2674, 2369, 2370, 2949, 2951, 2950, 1897, 
         2659, 2554, 2555, 2928, 2927, 2089, 2634, 2853, 1876, 2854, 2553, 
         2541, 2542, 2809, 2808, 2047, 2302, 2323, 2936, 1849, 1877, 2469, 
         2940, 2941, 2970, 2969, 2402, 2972, 2973, 2971, 2968, 2635, 2324, 
         1949, 2401, 2606, 1845, 1870, 2629, 2628, 2959, 2013, 2786, 2014, 
         2187, 2186, 2220, 2178, 2179, 2009, 2296, 2515, 2516, 2518, 2517, 
         1836, 2122, 2038, 2805, 2037, 2235, 1891, 2248, 2249, 2054, 2815, 
         2817, 2816, 1835, 2290, 1828, 2283, 2282, 2053}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2693, 2692, 2694, 1826, 2379, 2380, 2378, 1926, 2483, 2484, 
         2163, 2162, 2210, 2502, 1832, 2289, 2288, 2003, 2130, 1866, 1833, 
         2173, 2565, 2174, 2251, 2250, 2132, 2133, 2295, 2524, 2069, 2343, 
         2346, 2347, 2082, 2548, 2083, 2549, 1943, 2318, 2319, 2320, 1844, 
         2438, 1975, 2437, 1976, 2439, 2671, 1915, 2264, 2265, 2088, 2851, 
         2087, 2852, 2200, 2157, 2755, 2756, 2440, 1977, 2857, 2858, 2855, 
         2090, 2856, 1899, 2242, 2243, 2091, 2276, 2277, 2141, 1880, 2906, 
         2584, 2580, 2581, 2884, 2883, 2112, 2587, 2588, 2124, 1852, 1881, 
         2477, 2406, 2407, 2329, 2478, 2613, 2924, 2025, 2795, 2614, 2615, 
         2193, 2471, 2018, 2470, 2473, 2472, 2326, 2325, 1950, 2403, 2607, 
         2608, 1871, 2322, 2321, 2400, 2399, 1842, 1868, 2313, 2312, 2395, 
         2394, 2604, 2603, 2309, 2308, 2307, 1936, 2457, 2458, 2456, 1998, 
         2770, 2207, 2454, 1995, 2453, 1996, 2455, 1927, 2381, 2383, 2382, 
         1827, 2695, 1818, 2693}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2691, 2618, 2859, 1862, 2860, 2203, 2092, 2861, 2093, 2205, 
         2204, 1819, 2910, 2094, 1988, 2095, 2911, 1820, 2206, 1829, 2914, 
         2096, 1997, 2211, 1999, 2459, 2000, 2771, 1937, 2619, 2620, 2621, 
         1837, 2708, 2709, 2626, 2627, 1869, 1843, 2715, 2716, 2630, 2631, 
         1872, 1846, 2720, 1951, 2636, 2637, 2792, 2020, 2474, 2019, 2194, 
         1955, 2027, 2925, 2026, 1882, 1853, 2917, 2028, 1956, 2033, 2032, 
         1883, 2143, 2035, 2481, 2034, 2482, 2197, 1858, 2411, 2412, 2408, 
         2410, 2937, 2409, 2938, 1857, 2561, 2109, 2126, 2125, 2269, 2076, 
         2118, 2144, 2266, 2267, 2120, 2145, 1916, 2907, 2878, 2879, 2877, 
         2108, 2880, 1978, 2201, 1851, 2123, 1954, 2722, 1953, 2958, 2442, 
         2758, 2757, 1898, 2355, 2156, 1922, 2268, 1921, 2539, 2540, 2354, 
         2658, 1896, 2256, 1895, 2353, 2352, 2574, 2573, 1919, 2530, 2531, 
         2348, 2653, 2654, 2253, 2345, 2344, 2342, 2116, 2569, 2008, 2177, 
         1940, 2237, 1939, 2171, 2004, 2169, 1935, 2234, 1934, 2165, 1993, 
         2244, 1994, 2209, 2232, 2231, 2230, 2641, 2640, 2330, 2049, 2278, 
         1817, 1863, 2766, 1986, 2446, 1987, 2447, 1923, 1982, 2908, 1814, 
         1861, 2765, 2690, 2691}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1813, 2676, 2677, 2675, 2679, 2678, 2759, 2681, 2682, 2680, 
         2684, 2683, 2760, 2686, 2687, 2685, 2689, 2688, 2764, 2444, 2445, 
         2373, 2375, 2374, 2448, 2886, 2887, 2885, 2889, 2888, 2048, 2494, 
         2495, 2491, 2493, 2492, 2208, 2164, 2166, 2036, 2168, 2167, 2214, 
         2170, 2172, 2039, 2176, 2175, 2217, 2895, 2896, 2568, 2571, 2570, 
         2068, 2528, 2529, 2525, 2527, 2526, 2154, 2897, 2898, 2572, 2576, 
         2575, 2071, 2537, 2538, 2534, 2536, 2535, 2155, 2899, 2900, 2577, 
         2579, 2578, 2072, 2839, 2840, 2836, 2838, 2837, 2158, 2902, 2903, 
         2901, 2905, 2904, 2073, 2075, 2926, 2074, 2799, 2729, 2730, 2728, 
         2732, 2731, 2800, 2734, 2735, 2733, 2737, 2736, 2801, 2739, 2740, 
         2738, 2742, 2741, 2802}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2372, 2304, 2556, 2939, 1860, 2557, 2202, 2762, 1980, 2761, 
         1981, 2763, 2841, 2078, 1901, 2257, 1900, 2077, 1957, 2198, 2146, 
         2147, 1958, 2645, 2646, 2965, 2647, 2649, 2648, 1886, 2943, 2441, 
         2333, 2672, 2673, 1917, 2362, 2281, 2500, 2501, 2337, 2650, 1889, 
         2233, 2803, 2804, 2485, 2487, 2486, 2121, 2509, 2510, 2339, 2651, 
         2652, 2236, 2488, 2040, 2340, 2041, 2489, 2294, 2183, 1942, 2252, 
         2135, 2136, 2298, 2190, 1948, 2255, 2139, 2140, 2610, 2789, 2017, 
         2791, 2790, 2331, 2332, 1884, 2245, 2644, 2643, 2642, 2050, 2226, 
         2225, 2195, 2617, 2616, 2479, 2029, 2480, 2142, 2798, 2031, 2796, 
         2030, 2797, 2196, 1856, 2726, 2727, 2723, 2725, 2724, 1855, 2229, 
         1854, 2918, 2107, 2228, 2227, 2105, 2964, 2106, 2024, 2104, 2929, 
         2103, 2224, 2021, 2960, 2022, 2015, 2222, 2609, 2558, 2102, 2876, 
         1945, 2717, 1944, 2718, 2784, 2783, 2713, 2714, 2710, 2712, 2711, 
         2781, 2702, 2703, 2699, 2701, 2700, 2772, 2773, 2697, 1929, 2696, 
         1928, 2767, 1990, 2449, 2594, 2129, 2128, 1989, 2912, 1821, 2161, 
         1984, 2923, 1985, 2127, 1983, 2909, 1815, 2159, 2160, 1979, 2589, 
         2590, 2591, 1859, 2443, 2371, 2372}],
        RowBox[{"-", "0.1`"}]],
       Annotation[#, -0.1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2113, 2890, 2892, 2891, 2893, 1822, 2931, 2932, 2930, 2377, 
         2376, 1924, 2451, 1992, 2450, 1991, 2768, 1864, 2598, 2597, 2769, 
         2452, 2596, 2913, 2595, 1930, 2698, 1931, 2384, 2001, 2774, 2460, 
         2461, 2390, 2392, 2391, 2782, 2464, 2465, 2396, 2398, 2397, 2785, 
         2012, 2468, 2957, 1946, 2719, 1947, 2559, 2560, 2299, 2300, 2301, 
         2223, 2612, 2611, 2303, 2023, 2475, 1952, 2327, 2476, 2942, 1878, 
         2793, 2721, 2638, 2639, 2920, 1850, 1879, 2794, 2404, 2405, 2328, 
         2496, 2810, 2811, 2192, 2966, 2191, 1848, 1875, 2632, 2633, 2788, 
         2787, 2016, 2189, 2915, 2188, 2221, 2919, 2184, 2315, 2185, 2239, 
         2238, 1941, 2182, 2007, 2511, 2058, 2341, 2546, 2961, 2963, 2962, 
         2080, 2845, 2081, 2547, 1965, 2417, 1964, 2419, 2148, 2414, 1959, 
         2413, 1960, 2415, 2660, 1902, 2212, 2213, 2097, 2600, 2601, 2602, 
         2199, 1825, 1865, 2306, 2305, 1925, 2843, 2844, 2842, 2079, 1885, 
         2246, 2247, 2051, 2812, 2814, 2813, 1823, 2894, 1816, 2593, 2592, 
         2113}],
        RowBox[{"-", "0.2`"}]],
       Annotation[#, -0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2052, 2497, 2499, 2498, 2599, 1830, 2934, 2935, 2933, 2387, 
         2385, 1932, 2386, 1933, 2388, 2463, 2462, 2507, 2508, 2293, 2292, 
         2291, 2006, 2131, 1867, 1838, 2180, 2181, 2011, 2466, 2010, 2467, 
         2520, 2519, 2152, 2153, 2117, 2655, 2656, 2657, 2254, 1892, 2240, 
         2241, 2085, 2274, 2275, 2138, 1873, 2849, 2550, 2532, 2533, 2807, 
         2806, 2046, 2585, 2586, 2119, 2916, 1847, 1874, 2111, 2881, 2882, 
         2850, 2086, 2351, 2551, 2948, 1894, 2552, 1893, 2349, 2350, 2297, 
         2368, 2316, 2317, 2605, 2314, 2044, 2490, 2043, 2523, 2067, 2521, 
         2066, 2522, 1840, 2311, 2310, 2393, 1938, 2921, 2356, 2663, 2418, 
         1962, 2416, 1961, 2287, 2286, 2363, 2285, 2336, 2944, 2946, 2945, 
         1888, 2543, 1887, 2335, 2334, 2002, 2775, 2777, 2776, 1831, 2284, 
         1824, 2280, 2279, 2052}],
        RowBox[{"-", "0.3`"}]],
       Annotation[#, -0.3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2099, 2865, 2867, 2866, 2216, 1904, 2745, 2746, 2743, 1963, 
         2744, 2149, 2751, 1968, 2424, 2426, 2952, 2425, 2953, 1910, 2582, 
         1909, 2358, 2357, 2110, 2562, 2134, 2270, 2271, 2260, 2259, 2042, 
         2831, 2832, 2830, 2065, 2846, 2847, 2666, 2667, 1907, 2258, 1908, 
         2422, 2423, 2420, 1967, 2421, 1839, 2623, 2622, 2704, 2705, 2662, 
         2661, 1903, 2215, 2098, 2862, 2864, 2863, 2056, 2818, 2820, 2819, 
         2055, 2822, 2823, 2821, 2057, 2868, 2099}],
        RowBox[{"-", "0.4`"}]],
       Annotation[#, -0.4, "Tooltip"]& ]}, {}, {}}, {InsetBox[
      RowBox[{"-", "0.4`"}], 2974], InsetBox[
      RowBox[{"-", "0.3`"}], 2975], InsetBox[
      RowBox[{"-", "0.2`"}], 2976], InsetBox[
      RowBox[{"-", "0.1`"}], 2977], InsetBox["0", 2978], 
     InsetBox["0.1`", 2979], InsetBox["0.2`", 2980], InsetBox["0.3`", 2981], 
     InsetBox["0.4`", 2982]}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-2, 2}, {-2, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 227},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1618560632]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11595711],

Cell["Customize the appearance of the labels:", "ExampleText",
 CellID->1615586547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"x", "/", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"ContourLabels", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Framed", "[", "#3", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"#1", ",", "#2"}], "}"}], ",", 
        RowBox[{"Background", "\[Rule]", "White"}]}], "]"}], "&"}], ")"}]}]}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1792196667],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyFvXd8ztf7Px5F1SpSq/beKvYKVxCjNrVK7VmNrbUVRWsVMWvTWLUVJW5O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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlL1uE1EQha/XXnu9K/HTIEGRCMVUsfgJYLrQ8AQUpEeKkJIoRgIHQk1D
B09AoiCBjBLcYbtxHiH81ATxDDQWDefTGUQxunfnzpyZc+7cvfywf387Symt
y+qyu2VKq7L9RkozHRzL/sg/zFM6aKb0O3l9J1vWWU920nAM6xfZQi2lDWFs
lv7ek72VbSfjTQLza5HS05bjb1Up3dT3KPc5cWPZnbrrUWsWtYgHc54b97Xq
vJHV9P2sLUzZqfKm8n2WdXLz4Zy8xcr90dsvxW00XbMpf0u2S5z8j3S+Jv89
7bt176eZ4xfVw0wYI/W/nLtP8rqZMcHrJ/cHD7hPghP+7+L6rTD2unD6wrlY
c/5hbp2PgzM58+idGM6PZJe0X8p9TvyKev9Q2M99kUP8KOLBHkSv6EnN94Vj
4LQZvE4L90dv4B9GLbivxd1NQgv2zMLH3JisfA9DQ2LAPIl5In4cvNBkRz1c
KB3DOmh5T95eaE48OsJxP+aJXHRHa/Skx6XQ7YF6/1E4l36GoQMYw4g5Cl7d
wCcXnIY0rFfW6arW65UxzgtvofK8P1aPk9KaoBna/Zujacw3tZkZ+J6pnN8L
Xy90YEbRgXl+rpl90TYO83ol+rmm3KKwtp3gSN158IITvk7Eg/8yd40bvKnK
XM9qPVf5jDtfiXvfVc1X8m9xh+I1Ll2bOYInteiRXtF8Vf6s9NvoKfd22/f0
pOX3DBdif0Y8b4y7px/e+k7bMcxgN/v/P+Gbfa5e2oXP4J1V5o7OWzGfn4Qz
aLsGs3YQ8/YXSW6ZZw==
         "],
         VertexColors->None], 
        PolygonBox[{{1909, 2358, 928, 287}, {1839, 2623, 1185, 110}, {2819, 
         2055, 823, 1397}, {2422, 2423, 991, 286}, {2622, 2704, 1281, 1185}, {
         1968, 2424, 994, 1323}, {2705, 2662, 1184, 1281}, {2099, 2865, 1454, 
         1456}, {2745, 2746, 1316, 282}, {2426, 2952, 1643, 994}, {2953, 1910,
          287, 1644}, {2864, 2863, 555, 1451}, {2667, 1907, 286, 1233}, {2867,
          2866, 282, 1454}, {2818, 2820, 1397, 555}, {2562, 2134, 599, 
         1127}, {2846, 2847, 1233, 566}, {2270, 2271, 836, 599}, {2149, 2751, 
         1323, 111}, {2421, 1839, 110, 992}, {2420, 1967, 992, 991}, {2259, 
         2042, 812, 836}, {2952, 2425, 1644, 1643}, {2823, 2821, 556, 1401}, {
         2055, 2822, 1401, 823}, {2357, 2110, 1127, 928}, {2744, 2149, 111, 
         1317}, {2098, 2862, 1451, 281}, {2057, 2868, 1456, 556}, {2662, 2661,
          281, 1184}, {2042, 2831, 1412, 812}, {2743, 1963, 1317, 1316}, {
         2832, 2830, 566, 1412}},
         VertexColors->None]}]}, 
     {RGBColor[0.35646522433036154`, 0.1670299737215969, 0.6180353120507475], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmGuMVdUVx8+999xzz7nXsdoGkUcAhZrYRPABkpSEoYDxgzQIohExAsKg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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllF1o12UUx5//7//bfm8tW0JRF7p5sZHgzG0qONBadTWk9pKQC53ipBW1
aK/ZTWmvVDhTyStDhJKpzLty4FtCU0yFFswmFGXRLjRvaip04efL9+IL5zzf
c85znvPy1G7t73gjCiH0gBi8mYRwJA3h0XIIL0BcykI4CGLINWAIeQKbvaUQ
puC/y0M4ij6G/hd6DfJN/F/Cvwv8Aj8DpuCfqwjhZ7jfwHq4cezrsb+WmxtG
/6QI4W3uuAE/wn0R3FrsP4SbASdz56jc6vAZwn4EtFSGcLrsuxVTsZRDhl4h
G2xHwSyxH+ZsNfwFsAN9FOwr+c5K5CQzt52zamwfxH8XvmPgH/TbYDdcC9gJ
9y74DN9ucjiM7yz3X4dbSYwe5PcKc+285wN83wevB9ts1tvRLxL7Avw55LOg
BLcF/0H8f0J/hvjT8K9iv5h4e7B/Ef4buH5snkd+BJuvuL8L/FByz9Zivy53
r3o5+w/7HzP38gnOrqBvgb8Y+8576A3wX6o/oDH1HYq9Q3dgO5y4N6PgBtwf
qXOdBeuQO/R+5I8j5/I5+qaSc1KuvcS4HDvnefha3rOf92yMLbcnjqWzemy/
x2YF3EegGbkPmwrqeYh459HPgUWRbaqQHwDPwlVx1o7cmXk2lMO3xJvMPTua
2Z7cPVDtVYM9yGO5a6UchzP3QLX/nRjXMvdYvW3lLOW9y8nnGPEGwTy+d0Ab
XHXkXWqEn6jwTjUhrwDvRD5TbwfU49g9fhKuoXCtFfNX+A2pZ18781ruGVDv
5fOKuMy5zHFWxjcGA/gujVyLpzL3UjUZhqvjvqbYO/M3/nOpd1U1HMR2JPNb
teOyVQ9Ue/ksg+vl7EDZM9KG3In/1ZJnWr35IvHuqEcPoS8AReQdSpArC+em
nWzCt7nwbqom06n/CP0N8jlBrDO5/xbt6BJsW8Ep7Ldx9m/qmdYsK4eWzDuq
3fxab0JfDD4t+w+qQb6VmtPOPl14ZjWrihkV7ql6qRrqrXfxeTn2mx8nl8dy
9/Y4+DPzDGt21XPtcl/qXminFyJfh19W9p+j3Vid2Fc7Mo78VuZZ1p8yifx/
4tmVz6LCf5D+Hu38Hfjlmd/ezX0rkVfJv+w/UrluT8wp59uZ/yD9PR1gc+Iz
yarJUOKd1i4rxn3kn73j
         "],
         VertexColors->None]}]}, 
     {RGBColor[
      0.45433895698580096`, 0.33720596253959007`, 0.7556086833779742], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l3+slmUZx5/zvud9n+d5X9tUtiSzlEoOtWWncjMNVwamhIuONDEcCmdI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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlm1olmUUx+/teZ7d93Xf9aGCWiZu62W9gEtKSKygF8uZps6BW+vNrTW1
ctnUViD0ZlLpkqZmRaWW0dtW0Ic+RGU2c0FRGuTmMqGcaEkFGdncdP3+/Pfh
wDn3/5xznetc5+WuaHpwXmtxFEXPQ3loZhxFVVBTLop+BNgLX5uYL0HhWIii
CuQa5APoNIN/gTwJ/kXoPeSl6AzA74e2gz0LnYZ+FXIn2NfonIAfgvYhnwk+
Dd83QgPIk+Qj8rd34JfwrU+6UHnK+dBTYOvwWYnt5eAvg71UiKLxWRSdB9UX
RVEH8ivYdyCvKImiNr5NQL4V+Suw+/ExC/6WzL56CsZmZuals5WzfoPmw58B
PQn2BPQn8TXg83ewOnzWgdVDK8BqiedT4pkKfjdYGfJzOdsolm3I+4scU0r8
3yOXglcRwwvgfwfzr4KvQm7BRw79JuSFyN3YPIavYc4rBZvNt10F52Qt8jzs
P1N+kZuDY1Rsu/n2DfK3UCP8Xfi4B9sO/A3i/wg6jcgXoj8Cfgj5/Mw5Vm43
QXn4HXojfF8BlXHeSfQfAOsh5g1ge5BX5+1jEPkQdLFi47xm/F2lN4E/is0p
nQWNL7aPLegeQJ4FH2NTju4RzqzFVw02E8B/4NvNBed0H7r9qbFpfJsLvgb8
Tu6zE8qQn0mcq3b0L4L/FZoDPz3ns+rQ6cn5zB2JdYSppkdkCy2CXwxtwff7
6J9DbO1Fzr1yoLvrDXTX4/hsKfjOlfDV4HMi5+R08Il864B/BH9v4XsbdDa+
2vExGexD5DXob0RnBrYV0E6wpeg3qPdi57KLb+/C/8W328F+EiG/wRkB2ww6
jDwKviTnmO8A2xqc20CMl3HepanPjtG5nvvckPmt9UYLwdqCe/k7bLrw99BY
f/+sGgr2KV+9yLNT94x65eO875oG5153Pitxz6vXb4KqwWvx+QF8N/QwZ7dn
7p25nL82cY2qNlXzreg2p54FytkFqWtWtao3Px7cM+oVzYSD4IOpfavGy8Ef
z9y7DZpf+F8WfJdG/FfDz4A+Qq5D/xTnnYv9SuwvgRboPOha8A3kbBH2ixPz
KyPn+srUb6ec9yLvgo5GrnHNiqmxc6OZMT1xT6gX3gQfQr4uuDZaoFL4e4N7
91HiuRr+j8Sx681VW7s575qCa6wNX8uhKSW+Qz3686Go4Bovw3Zc5tmomNYr
X7HvqpncGpwT5aIfuV+zN/huad61eTJxL6hGNetVg6o91YRm9duxbTWzVYsD
sW1Vk08nrlHV5n/c91jiHaPdsgD9w4lnjGaLen6iZmFwLjQDI+46GjzL1ZPq
jU2Ja1c9ot21KrFv7bBxqXOs3OoNN4J/nngXDfGtCF/Fwb2lnTGM/onUuR4F
X5Z5Z2hXKKfDumtw7WqnTUFel1j3Pu085F9S94Jm/MHEPate1czRbouxX57z
jlMvdcfepcrfP4lzolxoRuvtXoNyeb/hbfCd6G/WfdWTiXewdq9qsg9+deK7
aaf0xt652rWqkb3Etif2bJTPycE9rt6Wz5rgHaLdoR2m3Z2N9a/uuxn+9eDd
sT3n3h5BvzJvnR7kL4N7VzuiS7MyeFaW5sd2aWxeO1W7qiO2L+2sf1P3nHpN
M7ST/K/PvAv1z1ESnAPdXTn8JPhNFJti0CzRm+gtNFO0K/pS7wbtjP8BpzMo
5Q==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5522126896412403, 0.5073819513575831, 0.8931820547052008], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmGmMltUVx595t+d9npcEE0ykhQGn0CbtlybKJtqy+WGQQijoQFlMLTRt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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlllsVVUUhs/tvb1nKAkmmgBCgTIY9cUgowVNGB4oCFRQitKSCDgkQAHx
jQiIINBCoQJlVkwYVECLKEJAGVtUVEAcEiIBIhajUlQIQdui35+fh3Wy1v7X
WnufvaZdMHH66PKcIAi2QRmoRxIEt+MgmIRQDW2E3wQdTQdBGfiAvCBYFwbB
zFQQ7MsNghr010JZ+CmsnYmCYCp4EU4HYdMd7Az0KPh+8HbYd0RnGHgla7OR
h6DfE99Ds3zQbQKfCz6Z/X9Gvgh+F3wx+ps5y9tQPb6nor4H3UegV9HvytpE
+ElQBXsNBp+M7nPQa2AbkTuD5bPncnwdx+cX+P8U/32Re0NFyJcT79UavBP6
ZeCLsR/OHnOwHYu8AV9Pct7HkYdDA5GPYpNGvxn7KfDToKGJfcpXFToTwBuR
y8DmcMahnG0B/nbjvxZ6BuxZ5GvoLkN+DP55/F9H/z3WroPfgLpkrPMh/nZD
m+Dbcb5RYC+i34L+x+gsRf4OGojcojOguxGfs9j7fMqx7hM5lor5Ivga8Glg
Z6Hu4H9DTykfdEbwX8B/A+uM3A/fH4B3AF8LnYh8B/r33uAXwNdBIfIIaKf2
Rv8yZ63GRzO6LVCntGNeDdYF/QX4usXag/BrwEfzfxWsdda/IB/H13zk88hV
yln44az1gu8J/Z6yz3z4jtA88LkZx74A+5KMc2Al+33OmfalHIMeYPejvwT8
XfBt8Nuhu+F3KObwYxLfdS/0b2HbLfbddMvY9oHEZ5WP9yPXlGqpIzrtdVfQ
IvhW5E8R9jnI09P+x/WJa0q1pDu7DrYr9F3pzD8krknV4iDw28gt0KDAOVfM
fnXo70X/W854BH4Ua6fhd7M2i/9/Geqbdc4ux7YSmpTyHf6E/hb8t4IfmWvb
Q6zVpuyjIfE/6OxjwN9C3gB+kvO3Rn4J30Wxc1l7rILvhs7CjHvAfYl7gnrB
Wfytxvb1yLmmnKvGfiW0Keuc6wB/b55rrwr79eh+iX2fXPeMttgXJM4F3cEb
ea5x1bZ8/AHWiE4p+uOhNYlzRrminvUrWD/05+G/IO1Y/sNa9zv5rty+ipyf
cY7vjN0DVPvzwUvB6iLngmJ6Avl04n9TTtXGrnnVunyoNgtD9yLV6Cfge6EB
Kdf0fvibd+5DZyiBHxe5VnU/M/H9CvaF8Ocyjt2yxLWtGHbFfjzyMeQVnKc+
dE2plvqzX398fRS5V95Af2TinqFeoZ5WCn8Q/GZgH+L3xc5trf2Iv1M6b8Zn
rECuwOYWchM+x8Kv5h/rsu7BxeieCZ2rB8API/+rHoX8EDaDkYdA5WAP478J
bAV7ts2xThK5BykW2nOJalPxxPcx6Cryqsi1qRhvBmsTOzanoBLwp6Ej2G5G
/0DonqBe0CvXvWRYnnu3espi/V/iu9Ie10LnkHJHPbsc39tZq0q5h3UCGxz6
7Oox60PXhGpBNaTZtUw9LsczrAz7S4lrazY23yf+J/2LevTWyD1Ivecezj8d
/cngX2E7Ah/NsWemZqXu7GDoGabZpZqYFnoGa/ZqxtZEnomahVnWylXfkX3L
Z9fEMVTsVKMTYp9RZ9OMHQc+AfyvtO9wCVg+VJnymmJfGTq2yoEU2ELkPWn3
NPXyJyL3IvX0ceAlsWe33hQzwQ6H7k1/6ryazZFnZX3WuaQYKnbKqSvo7ogd
W/X4BuQLoXurZtIl+CuJe1MD8lJ87dLMTzsGK/VeSDyrNDOP46su9qxVTbWN
naPKTb0ZxqNfGtmXZuYh+M8i12IT/k4mftPoLaM3xFbkLYlntWbGWs7zJvK5
lN9M74SOqWKpHNLboj7yrNQb4wV8LY7sW2fOD31Huhv1dN1t+zz3Qt1x38gz
WbNYPawwck9TL9ObaEbknFeuN8on8tbQuaA3mmI5I7nTS1Lu5f/Ffnupp7fR
eSPbagboLaIeot6hN8nX6H4Tu9eoh+lfLyae9fpn1bJiqliqpv8HNCRgmw==

         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6272460091966561, 0.6294719910534027, 0.9109446392011545], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHmM1dUVx38z89683+8+sDpsKkWURSqxw2DAYm01qaBtAnEZGLAQEzFB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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlW1ol2UUxu/9//v7PM+93rBsoalMoyiKKHqZFi5yuYQi9+KcuSLnhwhr
Olhay9wyqI18CRRzYn2paVouTacJs1m0PmTql4qoaJqZGmofrFkyo9/F1YcL
zvWcl/s85z7n3GVNi2qacyGEDlAM1qch9CQhdBWFcBzFviyEf+AReUE+hK/R
r4dfhN8H70TujCH8hfMwuIi+AXyP/mn0G9C/jf6yQgiXgz50FXwbIf4N6F+A
LwVNnF3Apw15Gchy/lZdEkINaCl2jkfJ5xiogpdj8xi6WaAZ3oJ+M2c9QPxL
xB/DeYewnUm8QeWLzUT0E8D76A/zrR55NhhAdwC8gf30xLrz5LcDfhY+jP0Q
385iew5+AV6MvgE+N9r3DOfXkksdaIWvgU/l7HXwLaPQ49MKX5L6X2vRTyb+
4cy53ca3xegWgTuCczyN7nfwCPoK9B3o2lP/q2pUhm4Q3IW+DN5ILvOiY91C
fnciN2L/E3wtNufh++A3oWuiPl/yL0ei724v510iViXf5sObwCn4ycz/ohyG
kH/OfBe6g5FMiYTwaJF9NqaOId/IGVuJvQ2UctZ2TH8j9pvU41Xq8Qs+76Lb
En1XK1Rj5KPRvdKGfS/yR2AcvB9eghyj7153fhXyldG1UY/s5ew+MAo+Gf54
dI1Um8/h88jvCJiWd03UG3sy26pH9iP3Z76bW/l2IrqGql0NOVyNPBo8mPMd
1yDXgv3I/aAOeZCYx8P/3/jfr6JrsY3/24W8G0wk1kHVA/kkqIO/hk0ptbkO
dBZ8xgzkKjAAr8T+M+IthEfqV028LnJthzfAu/BvRH995ljK4VPkgcz/Mibn
2vwZffeqUSn2T+D/XcE9V488BxyCvwO/V70Gv5343fBx8Gb4zfCH8F9JrFVg
hPiN6F9EbgOn4KXw5cjt4Az8Rvgu/HeDFfhuha8kn1Wgl3zvDu6lSrA9755q
xfd58Cv+uIW3kDeAAvkthP9B/ueiZ1MzWY48BeTyntlpiXeOdo3O/Bv+SebZ
0E5bi24nmJS3zxfoTsPr856pncTaEX1X6sEPkT+I7kX1tHbZe/BrCt5pPdE9
rV7Wt43I3dG9rJyXIi+Jro3+6Vvkb6JrdwH+CnJHdC1Us2XIL0XXTjXVru1K
bKudq93aDb+i4B2r3t4E/zfnHs+l7lH15jPo7+fu7uHb8px9xiM/i/3oIu98
7c51qXebdugs5OrUu2E26EUeSjy7inFQvZ+4t8fCn0OekFpWzM3wBanfkkmc
twb71dF3p55pQV4c3bs/wvcg94EfgmdEu2p+4tnVzprK/byc2LYn794dSDwL
6uGZ8IdL3OuamdWp3yS9RapJFf4zMs+Sek53rZiKpTufnvkN0O5XD76Ofjj1
26c371rFLvFsaEY/Tl1j1VY9NFezWOLZ0AxpdspT737NkGZnbOpdqBk6lnjH
aLdoB2iWn0z8lmimtStPJJ497Uy9JVNSz47elKfgg4nvZqjgt0w1V631pmlX
HIBXBO+MOanfcL3deqPHJ44hX9n8B+KICsE=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.699205849886277, 0.7450914320029793, 0.9125851019295395], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmH2wVWUVxvc595yzz9kX+U5BwMk/KhGuJXfQQEhM5l7gxofQVGr5NdOE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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlsV1UQxV//i29zAWQHE/lgAikgQmIUW0GRFqiFgnuMICREBEXDvgoF
6xYUETASQBCUqIhIQTQVEHHDIotrXHBDBdqC0Eok0S/+Ts7/wyRz75mZe9/c
MzOv27iHRk3OBEGwEckh65MguDoMgsfQW+WDYFMUBDORvzFqlw2CFDxClrN+
GIdX0V9HOmL7aFEQnMd3HvbnwIux78W6FPxFbCcQcwv6VqQr9o9j3xbbJHGs
EuyXxkHwIT61YGeIMTINgonYNKDX4/NG4jN1VifWt4HfgRxCfwGb/WBzkUbi
9WOvGn0+Mhz7v9hrIn418RuxHcH6U7AZyHH0vth/jr4wse01rDdy9kHs9+K/
D1kDthqZybdsxuYd8HeR1tz9GHvlxB+MnAXbmrX+NHIu6715+M5CKop8x9n4
fh06t8rxH+gnwXeANWAzCfwE/pU533kS+o3YrGL9LT6tsb2V7z/AXZ8HrwQb
xN6mnO9Yq1jI5eBPEK+aeN9h0wnff7C/GKwPMVeiT8FnJOudkb+ljnVnsKrE
eg0+XfEdw3lHiTcUmxHor0WOt5+9feCHsP8i4zfcDbYi9FniQy3xWlj/B5Zn
/RH4Z6xboffLOjdzkIacczQVfTryJ+thrI/hvyA0H4blfPaCyPF1B731AuR0
zm/eH30xcoZ1FesN+FZgfwD7L7G/EGxUam4pB60S70mfqvjyRUbnzfHt6M3I
vXnnVNz8mTsNyflO4tZR9iqyfq+zrJuRas7eRr6q0MsTc0c19ib6WWRM3jWh
b7so8VsonmqtKnVuVXNzItek+KIauxl8Xeha3Y7PNLD1kfPZAn6Sux1HBmbM
oZew3YBPG+xbsHkWrCw2V88jvfEdzXnfg+/gzpWshyM1+Jcjt6TmpL5NnJuA
7wOxuViD/cTYe9K/Ya8PtuPwOZF3DY3m7HuQ/hnX+xyw+2Pbjud+A1hfj/TA
tg6f+tAcETdUY0PBBiNL8P8AfBVYHTbrivymy0NzrriQn57YlrH3MravIKsj
70lPsXkGrI697oV8zVLvCr1WPSpX4oy4opwVp+aUuKSYXcR95AbwMuwb+JYO
rAewHs73lKIXJf425XAN67XIFPRref/jwnVf8FFZv90uYvTK+Q13o7+nmBnv
laV+M73VXs7/Cf03ZGjOOR0PXhq6nzeD9wT7PXatCH8QvAl8Pvdvc0EQ3JW6
h6p3Hs67F80t9G9xTLU5PXJudB/V/pWRuaEeoLe9InQv0BuPAbs7NNdV47r7
+0jvnL9hD3qATd+s91RbnSPnTjXWHbxHbG6I75WJOS5uqyf2BTsVu3eL0wsj
z5ziQj/7NfZMkb9yIu43xn4L2TeGzoG+XTmKiX1T5LPUP+4DP1J4v9XIQfDB
7B3We+Xde1dG7l3qweLeQOLtypuDHcHaqGfpPGzagnVEngIflDFX7kyda3Gm
hHVpaq4rhrhzSeLeoztcmrjHq7cr5iOJZ5xmm3rcHs5fHHpWbuH8JbFnmGaX
Zo6+ZQJ4fSFez8g1IO6Lg+L6jML7ivMzE/dc9VrNxPapv0F3f1I9EmxF4lmu
GTNZvSg1dhqbX2JzUlxTT1RtLQ1dS4qv3riIdVPGPbKEWNcha3P+R9gI9lzk
2SeOLkr8Bsq9erhm1VWx30Y9+iuwI6Fn878599LNif8N1FNb0N9GuqGPRcqI
3TVyL9OPj3pJeepaUk/RW7cPnUu9+anQNaVaUg//mFifJO6dYZG5PCR1LxKn
p4G1U78p8szamXgGa/bqDv24+8TQvsrBtsT/RPoXugz8R+L9EPluOzLOzbLQ
36YczU78z6J/Fc3IeWBjI9uqZ6qXaGZrVqunlGvWh+4tmsm3p34zvZX+mTTL
3kp8tmbauMQ1ploRZzqk5rS4LA5rNnQJ3bs0I/4Ha+ZYog==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7702957313957156, 0.8495539836864707, 0.9105972072033353], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmH+QVmUVx+/73n3fe+/7JksJTCZTmREolKyVNgbpJCyGYODADGRB0QS4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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllnusz3UYxz+/8/39fC8nl5VzNrFKwuEQZtHKicI5xXEdm9zT5nAYRSxk
K9dWGzoI53DQaag1qRRm01zyB9GFP+i2SE2x5ZLa2tp6vff+470978/zfJ/P
5bl920+bO3pOUQjhHZAH85MQ5oExyBGKG3EIE8DPyP/mQjiFvBN9Hn4Y3jkN
oSvYEIVQB4ah+xFUI5/B5g/sx4OfkG9h3ycLoW8m5yHchI9CHglK0XdkrRZf
i4pDqGwWwnl4P3wNgKfIK7AZAx8LzvNtDfgL+w7wZzn8OLAHXgpew741/A7y
Jvafk7PNTuQ1+HsZ/4tZa8HezcFg5Hq+WYL+Av6eRr6I/a/Ik8Be9h7J2hbk
x7HZHnym3+Bt4IOD7zCB/caDGvgC9FORp4CF8CXwRdivxX6K3hKk7H0h9n3m
st9I5D7gEvwD+Nt8exr+Obwl35djX2BtHvKb6I/jrxw8A+8FKpGngkucZRco
wbaR78+iezWy7jswJLLNbORl6Kvwvw2sQV6QOLY64xq+P87a39jfiRzLCnA7
55gei20j3WOFENbDlyS+m+LTDbk7770b3aO8QQnnHwQ/Ap/J+fvBK8AZbKeB
1/F1CB838Pen8gm5N7iIbjf2vVOfWWfdhv4rdA2sFaHrj8/dyJdZu5pzjkXw
dfCjyC+CIchdwGTk85x/GnvPgOex38paJ+wHJY6F8vkL9LWx9+pVsK8t2OTy
9rkWeTlrY3J+o3r4ZnA0ZxvF5kri3FGMBnL3AfDavN+gK3IZa43oZnOeHey3
HX8Lc86BG+jPwQvYT8Tme+UmGBU5hiWJa1BnrcRmGN9fBWML9qFaUA4o9qqJ
EcjDQRXPcyBybo/D/47gHH8wcU2pluoKruV2iXNJNa3aeQN9U8411Iiuo3IG
fQv0x9n7RObYrQuOXQM8KziG/fm+oti1fJi1regqwQs52+RTx0yxUo4vxvZJ
fHyIr6pm7g0zU8vqEbuQ30td64q5fFVlrh35fAp5YObcqYWXcd4O+KjX3uAs
vr/NXFuK2T/of0j9lqrJang/9Tz231fkWIxOnDuKyWx8/R67l7XiPBPgTxT7
bt+ApsQ5qty8hz1eiW0j3WV8TEQuZa0v/s+xNgL57tS9YiVr3ZAncb6T7LUx
8tufzJyLisE1+PXUuasaLlfvjF1rDXwzXb0IrIh8h9XIczP3thns/zy8B3xt
3j2iZ+YzaG+t1SD3St0bVSNnuE8X+Hr4f8Gz4CDoFHkmKLfb4mNp3jmu2OXg
0/OOYevMPUC1r5zrjn4DPCq4B1TD09S9Uz2zSr0rc29Rj72M7pfUb6GevTFz
jBVb+Zic+Yw6m96sTLFJXDuaaS35thU4VeSZoN7xNTYDCu4h5/j+rdi9SGtt
0O8FbfN+wwp8DU8823Sn1dgOS11Lh8D7Oh9rpehKwEfwW/D7ke8D+1PPWM3W
9vCPdRf4vmCbKci3sX8g75n7MPwEvDm+58PLUvco1bticCX2ntpLNd9TZ4ud
a6rJVcifpN7rU/UA9Bti92bl9yOZc1i5qzuuhK9QTXKeevhWxTP23ndFPksP
1l4q8pmOxM5h5a56YLvYPUG9QDbqVc8lznX1rO7q3Yl97Sn4rnojvY3ufB3+
Logiz5gD2H6W+N9AOSbdzdj/IrLRrO2WeRZq5s7SfEj976A3vZi45lXrmun3
xr6j7qYeeDB2TagW6nOe7UMT/xtoxg9FVw32R36TVYp1bFvlUFfu3rnYvbuJ
PYakfnO9tb7R7NOddVfNwIfgmxP3xgZ4eeqeq16rf6hlnG155tpVT2iXuQep
96imvsT3ptS5pn+CWfBjiWe/Zohm21L4nSLPuNOaxYnjrTX1vs6J91YPbML+
Wux/s1zk2dul2HfRDFYu1yXWKaf/BxpEPrs=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8349205523261927, 0.8711046394774511, 0.8816453453388922], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl2uMVdUVx8+959x7zr632mYoJlo/tFhh7oCP8FISZrRgI5lSaIxTXx1b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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlW1olmUUx+899/Psvq/7Lqtp0Itf8gXdXCrRZoLOcgWxTEM0m2IvzhzR
bDVIqqlQ6hYphUVOrRntQy56IcveKKKycssRlilZFiH6wUyZmmhv2u/Pvw8H
zrn+55zrus7rVYtaZz9QiKJoHVSELk2j6ECIosVxFE0G2JZEUTvyIeTqUhQd
gz8OVaK8Hv3t4I8jHwG/GvwX5LX4+AfbIehcBDYEehT8Meg8+DnwFvgq8L3I
I8CfRm7A/jT8SPD52PdxVgnfkEXRW+h2g7fB34DOa7HvvAV5GPJK+G3oDODv
eeR/dRfUBL+Fs4fLouhXaBz61dCXYAPIOf6/Q2cathO4sw6+K0e3PIoG+d96
8Enod4E/h9wJPxJ/n2B7irPL0W+G9uCvnbNvwDYGB7OO9zYgz8ZHP1gTx71g
r0IVRb/pA/A1yL9jf1z/gR/B2cdg7yGfwXYutK/gnOwHO4t8L3yKj3bk1sy2
o7FpwH5GsG0j8gr+shn6g//cBs0CuxVaoLtj/2VmMK8/fQXfg/8K5Br8T1Fs
0elF3gq15s6JcjEOf6OR5ySuBeXobvQvgVrx1R87912Jc6kamIo8HfudJfu8
BuyuYN112L8B38jZh4otdBl/m88du9FvR74icQ4U+xPQU/h6HRoeu+Z+gy9B
14HNix2rPfi8vuiYfQu/hLM23lvHWT9yHzQXuRb5bOYaVW02c+fYxDFRLBZi
fxr5I+wrFf+Cc9WBzcmicyZ+dea36Ux/mQINFPyn4WBXQmsLPtuH7716U+Q3
LoBPofvKXKPj0a3BfjX4AHI5cj33L0W3BSqHP89ZK299qORYPAGdKTgmSeYa
V23L5kL43fifWnTNd8Bfqx7G/7HYvf428uHYPV+lfENbeM/Lyjl4VfBsUI+q
dt9PbKsaLnHfitS1rvfVIL8Z3BsbkDfm7ln16knqZzvYO8G1egJ/m8AXIZ8q
d82qF6cF15568ii2RxL7auQ9MxLXkGpnWexZ0J04VpoJylUT8jOxc/YI/iYj
P8v76vHXidwBlbh/MfKwzDWnWlsGrdJ7Es+CO8vdG22p36oeqQe/MbeucqrY
XpC6thRj1bpyplio5qvx1ZC6dpTzbmxfyB2LFKyIfSl4Nt0DzeTsJux7i66B
ifATMs+y5dw/Cvxo6lq/HXxQb0tdq5o5yu3FwbNXOVZtheBYqcYGg/+ov2kG
T0dekzsWmrHq5Yrgu9TT9+NvLHgPf0n1htwzRrNFMVXv7QzuJfXgytQ10fL/
fO3Evit4NmsG/QX/N7Sw6Bxot/yZufe0Y4Q9mHvWSOdJ5C/AJ5Zck0ODc6pc
aqeotz/NvKvU4z/BH4BuLrnHX9K8zzyb5yH/mHkHafdIR7X3Yu5cqAYPZt5p
2mWzwDcE+5DtOe6bA/+15k3sGb0r9Z/1V51pdt2B/c8FzzDVYh94beyaXJV6
pmuWq2e1u3Yl9q0dthR8o+pF/QX+LthnvGk8vnpi89rB2r06O4zuIc2Hgu/c
kdmHbBWzzfjfFFxb2lHL4VvQ+b7oni/jvVHuWtJM2Rq8A7X7hqLzCvLBxLx2
WH/qGaTZoz9VwY/JPStUI/uRf0i9m5r1psQxVSxV0zvAPk9dS3rzKGzHpNbV
n5cE7wTtAu3Y2swzQL2vnay3TwqOhf7wH1SLIQ8=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8995453732566697, 0.8926552952684316, 0.8526934834744491], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl1uMX1UVxs//cs75n3NgJogZDKQwUzpjnLSGJlQYtYUZg4mQNEL7YFJx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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlFmIjWEYx9/znXN8mzHGFMWNZVBDomzHvpe5mKxFyTBMzSgziBjOMPZC
1Nj3EheDFDIuLMkFxiRZx75dIFIowgV+T/+5eOpZ/+/zPluX0qoplZ5zbi6U
gr4HzvXynatGWZJEHzp3GHlpwrnX0ObYuY3QaWxlrZx7HjlXiH0F/hPTzp3A
fzryLsDyoH34HoT8Fgwf/7G8UYd/Boz92A5Ak8G6g9yA33V8PmDfh/838ErR
TQVrGjQPWwVyCXwT9AP+B7r5vP2d/At8/cFynwFtIH5dKKzPyCuwP8I+Hv4J
8Vt5e30oWzVyCqzByJt5vxz5C/xvaDb8JOgw/odi5Wp/2ga/Fvte8Bfxhw7E
r/SFtTKlWmSgmqRqUu23+MAfR5cl9hy63cQfg/KR/5JfvqeYHeCPwz8XeS34
Z/G9hvzeU0xtSw729gTkEVZ/6Bqx9VCILYJWUZ9+xLwBeyb0FL4YezHxA6Dt
5FOf0lvjI/H2ZkBsLv7ZtDCGgT0yFPZw3muPLQ+fTdh2ptWLn+CVpdWTk9gX
I08BqyMxCXz/4dMTeRH2HOTWsXJbg/wJ/8+BetfN0yy6WL42k0Pg22KvRb4I
LYlUA/v7O3K+grzE5gXfQssJuQ4qx34X+59QM2SzMwcqAKtzrNxnEfML2+9I
vbYebMG+FXpF/DJSWRNqhmx2PpLjGOTRod62nVgA1qBQvQxaadaW49+c0sxV
gr0w0lum6x+oRlabLLpn2F5E2qUmmwfw2kFtPNXY/nYK/05J/bGGt2pD5bIn
oVqXR/qr1fyCr5wsF5vRbKwdtd20nctYvlANvg1p9a4I/BueelhltY9Vqwp0
A+EHBMrVZqIRrJuhejUopd7EsXppPbqN7VYoWyalW2E64+1mfIXvGuqvtuO9
bT+tpinlYLOajLSLNrOPkZuhU55q0ifSjbLbZDP8GP4h1N8Tht2KTbFuld2M
e9haE9/X0w699LVjtlvWY9sduzl2a2yHDOsB1JwQZnd8iyLV4khat6EHuqNp
3Qjjp/mymc56NThWba1nw/Ff7Wt37AbaX94G2kX702rs5331shG5EdutQLfN
dmY9/LpAs2g5jSKX0ZF8bcbtdmVC3Ra7YZexnQGvLqGbegn5aqTdMJ31fmis
XbIZyAH7fqjbbDX6D3PFxpk=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNkz1rVGEQhd+9eze7917FL9BGwYiQWC0YP5LdRht/gJ1NCkGwyS5+gB8Q
NSpY2Km/IDEWEYRN1GazgvsfNrbaGPAXSBo9D2dAi+GdO3dmzpkz7zt9vX+1
l6WUbsjqsq1mSo+KlHb1sT6V0jvZWSV8bKQ0I/udfM7K7srfbDhnoPNkldLp
Vkpv5C/LOnXXdqIXPrXDzH2OlSk9EN6pWkojxdaUt5i5F/nkbGfOB2uc+ftP
xEfh8/+r7E7wof54zf5W4x//T7ITij/TfC/FtS+MQzqPinNXOXXxudYyB7jQ
H25LU/bB/FX3CZ+2/BcN167m5gEH/EFoNQ5u/CuFVVTWZhha0OeeNJgId7pm
reZCHzDBhgOcwGNe9N3JjUvd/aZrye1FPjz5hiuxfsQnuWvJR2PwwGKH67HH
V9LhtSyTvydby63n29w+M3Kuho+u6DsXcxKn5zdx25FdEcZY/T6LZ1t5BxRr
Vd4L/9qxd/pngYdmk+DJTr7HXibxDx0OKtapjEtsHPFu5OET/1k3z6fa+/PC
2qDBJDScCf7cjcvieak0l6oyBv0vyl+oPOuGYuda1uSLcoel38Mg9CLerVxD
Pvt5XHiWHy3rwtwPm34D7IUdsS+4LSh3vvAdRC9i3JMnii0Xngfbjblm423C
nzgzg0WPvHQfNIUbu2HXm/Eu3ovL7aZr92IGcvaJ+37Zir4P6zxS+a7fVL9b
Tc+4JL9XWkt22A39ubeL/73TcdyLuXiH3I35ytjgwv9MvAXu40rcJXA2Qmc4
jkrnf5C/XbrmvP5fqPzO/wJRzp6Q
         "],
         VertexColors->None], 
        PolygonBox[{{2564, 2563, 606, 931}, {1974, 2434, 1002, 1327}, {2749, 
         2750, 1320, 285}, {2707, 2665, 1187, 1282}, {2747, 1966, 1321, 
         1320}, {2748, 2151, 116, 1321}, {2436, 2954, 1646, 1002}, {2100, 
         2869, 1458, 284}, {2624, 2706, 1282, 1188}, {2873, 2872, 285, 
         1461}, {2870, 2063, 562, 1459}, {2869, 2101, 1459, 1458}, {2429, 
         1971, 999, 998}, {2272, 2273, 838, 606}, {2954, 2435, 1647, 1646}, {
         2835, 2833, 571, 1415}, {2829, 2827, 563, 1409}, {1913, 2361, 931, 
         290}, {2665, 2664, 284, 1187}, {2824, 2826, 1405, 562}, {2262, 2045, 
         815, 838}, {2825, 2062, 826, 1405}, {2151, 2754, 1327, 116}, {2045, 
         2834, 1415, 815}, {2670, 1911, 289, 1238}, {2431, 2432, 998, 289}, {
         2955, 1914, 290, 1647}, {1841, 2625, 1188, 115}, {2430, 1841, 115, 
         999}, {2874, 2875, 1461, 563}, {2084, 2669, 1238, 1428}, {2070, 2848,
          1428, 571}, {2062, 2828, 1409, 826}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2875, 2871, 2873, 2872, 2219, 1906, 2749, 2750, 2747, 1966, 
         2748, 2151, 2754, 1974, 2434, 2436, 2954, 2435, 2955, 1914, 2583, 
         1913, 2361, 2360, 2564, 2563, 2137, 2272, 2273, 2263, 2262, 2045, 
         2834, 2835, 2833, 2070, 2848, 2084, 2669, 2670, 1911, 2261, 1912, 
         2431, 2432, 2429, 1971, 2430, 1841, 2625, 2624, 2706, 2707, 2665, 
         2664, 1905, 2218, 2100, 2869, 2101, 2870, 2063, 2824, 2826, 2825, 
         2062, 2828, 2829, 2827, 2064, 2874, 2875}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2053, 2503, 2505, 2504, 2506, 1834, 2779, 2780, 2778, 2005, 
         2338, 2544, 2947, 1890, 2545, 2389, 2366, 2967, 2367, 2364, 1918, 
         2365, 2114, 2566, 2115, 2567, 2059, 2514, 2061, 2512, 2060, 2513, 
         2150, 2752, 1969, 2427, 1970, 2428, 2668, 2359, 2922, 1973, 2753, 
         1972, 2433, 2956, 1920, 2674, 2369, 2370, 2949, 2951, 2950, 1897, 
         2659, 2554, 2555, 2928, 2927, 2089, 2634, 2853, 1876, 2854, 2553, 
         2541, 2542, 2809, 2808, 2047, 2302, 2323, 2936, 1849, 1877, 2469, 
         2940, 2941, 2970, 2969, 2402, 2972, 2973, 2971, 2968, 2635, 2324, 
         1949, 2401, 2606, 1845, 1870, 2629, 2628, 2959, 2013, 2786, 2014, 
         2187, 2186, 2220, 2178, 2179, 2009, 2296, 2515, 2516, 2518, 2517, 
         1836, 2122, 2038, 2805, 2037, 2235, 1891, 2248, 2249, 2054, 2815, 
         2817, 2816, 1835, 2290, 1828, 2283, 2282, 2053}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2693, 2692, 2694, 1826, 2379, 2380, 2378, 1926, 2483, 2484, 
         2163, 2162, 2210, 2502, 1832, 2289, 2288, 2003, 2130, 1866, 1833, 
         2173, 2565, 2174, 2251, 2250, 2132, 2133, 2295, 2524, 2069, 2343, 
         2346, 2347, 2082, 2548, 2083, 2549, 1943, 2318, 2319, 2320, 1844, 
         2438, 1975, 2437, 1976, 2439, 2671, 1915, 2264, 2265, 2088, 2851, 
         2087, 2852, 2200, 2157, 2755, 2756, 2440, 1977, 2857, 2858, 2855, 
         2090, 2856, 1899, 2242, 2243, 2091, 2276, 2277, 2141, 1880, 2906, 
         2584, 2580, 2581, 2884, 2883, 2112, 2587, 2588, 2124, 1852, 1881, 
         2477, 2406, 2407, 2329, 2478, 2613, 2924, 2025, 2795, 2614, 2615, 
         2193, 2471, 2018, 2470, 2473, 2472, 2326, 2325, 1950, 2403, 2607, 
         2608, 1871, 2322, 2321, 2400, 2399, 1842, 1868, 2313, 2312, 2395, 
         2394, 2604, 2603, 2309, 2308, 2307, 1936, 2457, 2458, 2456, 1998, 
         2770, 2207, 2454, 1995, 2453, 1996, 2455, 1927, 2381, 2383, 2382, 
         1827, 2695, 1818, 2693}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2691, 2618, 2859, 1862, 2860, 2203, 2092, 2861, 2093, 2205, 
         2204, 1819, 2910, 2094, 1988, 2095, 2911, 1820, 2206, 1829, 2914, 
         2096, 1997, 2211, 1999, 2459, 2000, 2771, 1937, 2619, 2620, 2621, 
         1837, 2708, 2709, 2626, 2627, 1869, 1843, 2715, 2716, 2630, 2631, 
         1872, 1846, 2720, 1951, 2636, 2637, 2792, 2020, 2474, 2019, 2194, 
         1955, 2027, 2925, 2026, 1882, 1853, 2917, 2028, 1956, 2033, 2032, 
         1883, 2143, 2035, 2481, 2034, 2482, 2197, 1858, 2411, 2412, 2408, 
         2410, 2937, 2409, 2938, 1857, 2561, 2109, 2126, 2125, 2269, 2076, 
         2118, 2144, 2266, 2267, 2120, 2145, 1916, 2907, 2878, 2879, 2877, 
         2108, 2880, 1978, 2201, 1851, 2123, 1954, 2722, 1953, 2958, 2442, 
         2758, 2757, 1898, 2355, 2156, 1922, 2268, 1921, 2539, 2540, 2354, 
         2658, 1896, 2256, 1895, 2353, 2352, 2574, 2573, 1919, 2530, 2531, 
         2348, 2653, 2654, 2253, 2345, 2344, 2342, 2116, 2569, 2008, 2177, 
         1940, 2237, 1939, 2171, 2004, 2169, 1935, 2234, 1934, 2165, 1993, 
         2244, 1994, 2209, 2232, 2231, 2230, 2641, 2640, 2330, 2049, 2278, 
         1817, 1863, 2766, 1986, 2446, 1987, 2447, 1923, 1982, 2908, 1814, 
         1861, 2765, 2690, 2691}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1813, 2676, 2677, 2675, 2679, 2678, 2759, 2681, 2682, 2680, 
         2684, 2683, 2760, 2686, 2687, 2685, 2689, 2688, 2764, 2444, 2445, 
         2373, 2375, 2374, 2448, 2886, 2887, 2885, 2889, 2888, 2048, 2494, 
         2495, 2491, 2493, 2492, 2208, 2164, 2166, 2036, 2168, 2167, 2214, 
         2170, 2172, 2039, 2176, 2175, 2217, 2895, 2896, 2568, 2571, 2570, 
         2068, 2528, 2529, 2525, 2527, 2526, 2154, 2897, 2898, 2572, 2576, 
         2575, 2071, 2537, 2538, 2534, 2536, 2535, 2155, 2899, 2900, 2577, 
         2579, 2578, 2072, 2839, 2840, 2836, 2838, 2837, 2158, 2902, 2903, 
         2901, 2905, 2904, 2073, 2075, 2926, 2074, 2799, 2729, 2730, 2728, 
         2732, 2731, 2800, 2734, 2735, 2733, 2737, 2736, 2801, 2739, 2740, 
         2738, 2742, 2741, 2802}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2372, 2304, 2556, 2939, 1860, 2557, 2202, 2762, 1980, 2761, 
         1981, 2763, 2841, 2078, 1901, 2257, 1900, 2077, 1957, 2198, 2146, 
         2147, 1958, 2645, 2646, 2965, 2647, 2649, 2648, 1886, 2943, 2441, 
         2333, 2672, 2673, 1917, 2362, 2281, 2500, 2501, 2337, 2650, 1889, 
         2233, 2803, 2804, 2485, 2487, 2486, 2121, 2509, 2510, 2339, 2651, 
         2652, 2236, 2488, 2040, 2340, 2041, 2489, 2294, 2183, 1942, 2252, 
         2135, 2136, 2298, 2190, 1948, 2255, 2139, 2140, 2610, 2789, 2017, 
         2791, 2790, 2331, 2332, 1884, 2245, 2644, 2643, 2642, 2050, 2226, 
         2225, 2195, 2617, 2616, 2479, 2029, 2480, 2142, 2798, 2031, 2796, 
         2030, 2797, 2196, 1856, 2726, 2727, 2723, 2725, 2724, 1855, 2229, 
         1854, 2918, 2107, 2228, 2227, 2105, 2964, 2106, 2024, 2104, 2929, 
         2103, 2224, 2021, 2960, 2022, 2015, 2222, 2609, 2558, 2102, 2876, 
         1945, 2717, 1944, 2718, 2784, 2783, 2713, 2714, 2710, 2712, 2711, 
         2781, 2702, 2703, 2699, 2701, 2700, 2772, 2773, 2697, 1929, 2696, 
         1928, 2767, 1990, 2449, 2594, 2129, 2128, 1989, 2912, 1821, 2161, 
         1984, 2923, 1985, 2127, 1983, 2909, 1815, 2159, 2160, 1979, 2589, 
         2590, 2591, 1859, 2443, 2371, 2372}],
        RowBox[{"-", "0.1`"}]],
       Annotation[#, -0.1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2113, 2890, 2892, 2891, 2893, 1822, 2931, 2932, 2930, 2377, 
         2376, 1924, 2451, 1992, 2450, 1991, 2768, 1864, 2598, 2597, 2769, 
         2452, 2596, 2913, 2595, 1930, 2698, 1931, 2384, 2001, 2774, 2460, 
         2461, 2390, 2392, 2391, 2782, 2464, 2465, 2396, 2398, 2397, 2785, 
         2012, 2468, 2957, 1946, 2719, 1947, 2559, 2560, 2299, 2300, 2301, 
         2223, 2612, 2611, 2303, 2023, 2475, 1952, 2327, 2476, 2942, 1878, 
         2793, 2721, 2638, 2639, 2920, 1850, 1879, 2794, 2404, 2405, 2328, 
         2496, 2810, 2811, 2192, 2966, 2191, 1848, 1875, 2632, 2633, 2788, 
         2787, 2016, 2189, 2915, 2188, 2221, 2919, 2184, 2315, 2185, 2239, 
         2238, 1941, 2182, 2007, 2511, 2058, 2341, 2546, 2961, 2963, 2962, 
         2080, 2845, 2081, 2547, 1965, 2417, 1964, 2419, 2148, 2414, 1959, 
         2413, 1960, 2415, 2660, 1902, 2212, 2213, 2097, 2600, 2601, 2602, 
         2199, 1825, 1865, 2306, 2305, 1925, 2843, 2844, 2842, 2079, 1885, 
         2246, 2247, 2051, 2812, 2814, 2813, 1823, 2894, 1816, 2593, 2592, 
         2113}],
        RowBox[{"-", "0.2`"}]],
       Annotation[#, -0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2052, 2497, 2499, 2498, 2599, 1830, 2934, 2935, 2933, 2387, 
         2385, 1932, 2386, 1933, 2388, 2463, 2462, 2507, 2508, 2293, 2292, 
         2291, 2006, 2131, 1867, 1838, 2180, 2181, 2011, 2466, 2010, 2467, 
         2520, 2519, 2152, 2153, 2117, 2655, 2656, 2657, 2254, 1892, 2240, 
         2241, 2085, 2274, 2275, 2138, 1873, 2849, 2550, 2532, 2533, 2807, 
         2806, 2046, 2585, 2586, 2119, 2916, 1847, 1874, 2111, 2881, 2882, 
         2850, 2086, 2351, 2551, 2948, 1894, 2552, 1893, 2349, 2350, 2297, 
         2368, 2316, 2317, 2605, 2314, 2044, 2490, 2043, 2523, 2067, 2521, 
         2066, 2522, 1840, 2311, 2310, 2393, 1938, 2921, 2356, 2663, 2418, 
         1962, 2416, 1961, 2287, 2286, 2363, 2285, 2336, 2944, 2946, 2945, 
         1888, 2543, 1887, 2335, 2334, 2002, 2775, 2777, 2776, 1831, 2284, 
         1824, 2280, 2279, 2052}],
        RowBox[{"-", "0.3`"}]],
       Annotation[#, -0.3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2099, 2865, 2867, 2866, 2216, 1904, 2745, 2746, 2743, 1963, 
         2744, 2149, 2751, 1968, 2424, 2426, 2952, 2425, 2953, 1910, 2582, 
         1909, 2358, 2357, 2110, 2562, 2134, 2270, 2271, 2260, 2259, 2042, 
         2831, 2832, 2830, 2065, 2846, 2847, 2666, 2667, 1907, 2258, 1908, 
         2422, 2423, 2420, 1967, 2421, 1839, 2623, 2622, 2704, 2705, 2662, 
         2661, 1903, 2215, 2098, 2862, 2864, 2863, 2056, 2818, 2820, 2819, 
         2055, 2822, 2823, 2821, 2057, 2868, 2099}],
        RowBox[{"-", "0.4`"}]],
       Annotation[#, -0.4, "Tooltip"]& ]}, {}, {}}, {InsetBox[
      FrameBox[
       RowBox[{"-", "0.4`"}],
       StripOnInput->False], {-0.7142857142857146, 0.2619620305747855},
      Background->GrayLevel[1]], InsetBox[
      FrameBox[
       RowBox[{"-", "0.3`"}],
       StripOnInput->False], {-0.690443939445296, -0.5952703462689904},
      Background->GrayLevel[1]], InsetBox[
      FrameBox[
       RowBox[{"-", "0.2`"}],
       StripOnInput->False], {-1.383787929097488, -0.1428571428571433},
      Background->GrayLevel[1]], InsetBox[
      FrameBox[
       RowBox[{"-", "0.1`"}],
       StripOnInput->False], {-0.7142857142857146, 1.2106466363240407`},
      Background->GrayLevel[1]], InsetBox[
      FrameBox["0",
       StripOnInput->False], {-1.0694348283734151`*^-16, -1.9999999999999996`},
      
      Background->GrayLevel[1]], InsetBox[
      FrameBox["0.1`",
       StripOnInput->False], {1.6798671049639664`, -0.034418609321747486`},
      Background->GrayLevel[1]], InsetBox[
      FrameBox["0.2`",
       StripOnInput->False], {0.597403080221706, 0.8571428571428567},
      Background->GrayLevel[1]], InsetBox[
      FrameBox["0.3`",
       StripOnInput->False], {0.46177204657716064`, -0.46679938199426796`},
      Background->GrayLevel[1]], InsetBox[
      FrameBox["0.4`",
       StripOnInput->False], {0.8480797085905086, 0.1785714285714281},
      Background->GrayLevel[1]]}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-2, 2}, {-2, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 227},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1062434588]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11420],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ContourStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContourStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Contours",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Contours"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ContourShading",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContourShading"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15814]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->313631071],

Cell[TextData[ButtonBox["Plotting Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingOptions"]], "MoreAbout",
 CellID->817235835],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->516963501],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->24802480]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ContourLabels - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 30, 12.0894102}", "context" -> "System`", 
    "keywords" -> {
     "contour labels", "labeling contours", "labeling contour lines", 
      "annotating contour lines", "automatic contour labeling"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ContourLabels is an option for contour plots which specifies how to \
label contours. ", "synonyms" -> {"contour labels"}, "title" -> 
    "ContourLabels", "type" -> "Symbol", "uri" -> "ref/ContourLabels"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6211, 196, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->89245298]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 166731, 3005}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1814, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2437, 69, 1578, 37, 70, "ObjectNameGrid"],
Cell[4018, 108, 464, 14, 70, "Usage",
 CellID->8681]
}, Open  ]],
Cell[CellGroupData[{
Cell[4519, 127, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4997, 144, 403, 14, 70, "Notes",
 CellID->3652],
Cell[5403, 160, 384, 14, 70, "Notes",
 CellID->8753],
Cell[5790, 176, 252, 9, 70, "Notes",
 CellID->24033],
Cell[6045, 187, 129, 4, 70, "Notes",
 CellID->32029]
}, Closed]],
Cell[CellGroupData[{
Cell[6211, 196, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->89245298],
Cell[CellGroupData[{
Cell[6595, 210, 147, 5, 70, "ExampleSection",
 CellID->50676642],
Cell[6745, 217, 80, 1, 70, "ExampleText",
 CellID->7229],
Cell[CellGroupData[{
Cell[6850, 222, 496, 16, 28, "Input",
 CellID->485537423],
Cell[7349, 240, 77069, 1296, 248, "Output",
 CellID->1618560632]
}, Open  ]],
Cell[84433, 1539, 124, 3, 70, "ExampleDelimiter",
 CellID->11595711],
Cell[84560, 1544, 83, 1, 70, "ExampleText",
 CellID->1615586547],
Cell[CellGroupData[{
Cell[84668, 1549, 760, 25, 70, "Input",
 CellID->1792196667],
Cell[85431, 1576, 78108, 1322, 70, "Output",
 CellID->1062434588]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[163600, 2905, 311, 9, 70, "SeeAlsoSection",
 CellID->11420],
Cell[163914, 2916, 716, 26, 70, "SeeAlso",
 CellID->15814]
}, Open  ]],
Cell[CellGroupData[{
Cell[164667, 2947, 319, 9, 70, "MoreAboutSection",
 CellID->313631071],
Cell[164989, 2958, 143, 3, 70, "MoreAbout",
 CellID->817235835],
Cell[165135, 2963, 197, 4, 70, "MoreAbout",
 CellID->516963501],
Cell[165335, 2969, 178, 3, 70, "MoreAbout",
 CellID->24802480]
}, Open  ]],
Cell[165528, 2975, 27, 0, 70, "History"],
Cell[165558, 2977, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

