(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[  29825718,     500990]
NotebookOptionsPosition[  29783216,     499595]
NotebookOutlinePosition[  29785056,     499640]
CellTagsIndexPosition[  29784965,     499635]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Density and Contour Plots" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DensityAndContourPlots"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Density and Contour Plots\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DensityPlot" :> 
          Documentation`HelpLookup["paclet:ref/DensityPlot"], 
          "ListContourPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListContourPlot"], 
          "RegionPlot" :> Documentation`HelpLookup["paclet:ref/RegionPlot"], 
          "Plot3D" :> Documentation`HelpLookup["paclet:ref/Plot3D"], 
          "ContourPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/ContourPlot3D"], 
          "MeshFunctions" :> 
          Documentation`HelpLookup["paclet:ref/MeshFunctions"], 
          "ContourLabels" :> 
          Documentation`HelpLookup["paclet:ref/ContourLabels"], 
          "ContourShading" :> 
          Documentation`HelpLookup["paclet:ref/ContourShading"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DensityPlot\"\>", 
       2->"\<\"ListContourPlot\"\>", 3->"\<\"RegionPlot\"\>", 
       4->"\<\"Plot3D\"\>", 5->"\<\"ContourPlot3D\"\>", 
       6->"\<\"MeshFunctions\"\>", 7->"\<\"ContourLabels\"\>", 
       8->"\<\"ContourShading\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Visualization" :> 
          Documentation`HelpLookup["paclet:guide/FunctionVisualization"], 
          "New in 6.0: Function Visualization" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FunctionVisualization"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Function Visualization\"\>", 
       2->"\<\"New in 6.0: Function Visualization\"\>", 
       3->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ContourPlot", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ContourPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ContourPlot"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["y", "TI"], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a contour plot of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " as a function of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ContourPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ContourPlot"], "[", 
       RowBox[{
        RowBox[{
         StyleBox["f", "TI"], "==", 
         StyleBox["g", "TI"]}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["y", "TI"], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots contour lines for which ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "=", 
       StyleBox["g", "TI"]}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ContourPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ContourPlot"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox[
            StyleBox["f", "TI"], 
            StyleBox["1", "TR"]], "==", 
           SubscriptBox[
            StyleBox["g", "TI"], 
            StyleBox["1", "TR"]]}], ",", 
          RowBox[{
           SubscriptBox[
            StyleBox["f", "TI"], 
            StyleBox["2", "TR"]], "==", 
           SubscriptBox[
            StyleBox["g", "TI"], 
            StyleBox["2", "TR"]]}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["y", "TI"], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots several contour lines. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->13063]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot"]], "InlineFormula"],
 " by default generates colorized grayscale output, in which larger values \
are shown lighter. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->21547],

Cell[TextData[{
 "At positions where ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " does not evaluate to a real number, holes are left so that the background \
to the contour plot shows through. "
}], "Notes",
 CellID->30502],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot"]], "InlineFormula"],
 " treats the variables ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " as local, effectively using ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->29617],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ", and evaluates the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["f", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["g", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " only after assigning specific numerical values to ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9099],

Cell[TextData[{
 "In some cases it may be more efficient to use ",
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 " to evaluate the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["f", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["g", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " symbolically before specific numerical values are assigned to ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->25023],

Cell[TextData[{
 "The plot is left blank in any regions where ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " evaluates to ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->5705],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", with the following additions and changes: "
}], "Notes",
 CellID->17226],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AspectRatio",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AspectRatio"], "1", Cell[
    "ratio of height to width ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["BoundaryStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BoundaryStyle"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "how to draw ",
     Cell[BoxData[
      ButtonBox["RegionFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RegionFunction"]], "InlineFormula"],
     " boundaries "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ClippingStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ClippingStyle"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "how to draw values clipped by ",
     Cell[BoxData[
      ButtonBox["PlotRange",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ColorFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to color regions between contour lines ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ColorFunctionScaling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunctionScaling"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether to scale the argument to ",
     Cell[BoxData[
      ButtonBox["ColorFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ContourLabels",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ContourLabels"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "how to label contour levels ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Contours",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Contours"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how many or what contours to use ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ContourShading",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ContourShading"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to shade regions between contours ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ContourStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ContourStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the style for contour lines ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["EvaluationMonitor",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EvaluationMonitor"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "expression to evaluate at every function evaluation", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["Exclusions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Exclusions"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"]}]], "InlineFormula"],
     " curves to exclude"
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ExclusionsStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ExclusionsStyle"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "what to draw at excluded curves", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Frame",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Frame"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to put a frame around the plot ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FrameTicks",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameTicks"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "frame tick marks ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["MaxRecursion",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MaxRecursion"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the maximum number of recursive subdivisions allowed ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["Mesh",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Mesh"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "how many mesh lines in each direction to draw ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["MeshFunctions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshFunctions"], 
    RowBox[{"{", "}"}], Cell[
    "how to determine the placement of mesh lines ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["MeshStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the style for mesh lines ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the method to use for refining contours ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["PerformanceGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PerformanceGoal"], 
    ButtonBox["$PerformanceGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$PerformanceGoal"], Cell[
    "aspects of performance to try to optimize", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotPoints",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotPoints"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the initial number of sample points in each direction ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["PlotRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRange"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Full",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Full"], ",", 
      ButtonBox["Full",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Full"], ",", 
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]}], "}"}], Cell[TextData[{
     "the range of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " or other values to include "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["PlotRangeClipping",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRangeClipping"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to clip at the plot range ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["PlotRangePadding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRangePadding"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how much to pad the range of values ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["RegionFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RegionFunction"], 
    RowBox[{"(", 
     RowBox[{
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"], "&"}], ")"}], Cell[
    "how to determine whether a point should be included", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MachinePrecision"], Cell[
    "the precision used in internal computations ", "TableText"]}
  },
  GridBoxAlignment->{"Columns" -> {Left, Left, {Left}}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True}}}},
 CellID->31203],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ContourShading",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContourShading"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", shading is used for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ContourPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContourPlot"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " but not for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ContourPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContourPlot"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["f", "TI"], "==", 
     StyleBox["g", "TI"]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->30048],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ContourPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContourPlot"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["f", "TI"], 
        StyleBox["1", "TR"]], "==", 
       SubscriptBox[
        StyleBox["g", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["f", "TI"], 
        StyleBox["2", "TR"]], "==", 
       SubscriptBox[
        StyleBox["g", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " superimposes the contour lines associated with all of the equalities ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["f", "TI"], 
    StyleBox["i", "TI"]], "==", 
   SubscriptBox[
    StyleBox["g", "TI"], 
    StyleBox["i", "TI"]]}]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->21051],

Cell[TextData[{
 "In determining how to color regions between contour levels, ",
 Cell[BoxData[
  ButtonBox["ContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot"]], "InlineFormula"],
 " looks first at any explicit setting given for ",
 Cell[BoxData[
  ButtonBox["ContourShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourShading"]], "InlineFormula"],
 ", then at the setting for ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->1570],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot"]], "InlineFormula"],
 " initially evaluates ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " at a grid of equally spaced sample points specified by ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 ". Then it uses an adaptive algorithm to subdivide at most ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 " times to generate smooth contours. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->8636],

Cell[TextData[{
 "You should realize that since it uses only a finite number of sample \
points, it is possible for ",
 Cell[BoxData[
  ButtonBox["ContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot"]], "InlineFormula"],
 " to miss features of your functions. To check your results, you should try \
increasing the settings for ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9458],

Cell[TextData[{
 "With some settings for ",
 Cell[BoxData[
  ButtonBox["PerformanceGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PerformanceGoal"]], "InlineFormula"],
 ", other specific option settings may be overridden."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->76985586],

Cell[TextData[{
 "The arguments supplied to functions in ",
 Cell[BoxData[
  ButtonBox["MeshFunctions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshFunctions"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RegionFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionFunction"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->25967],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " is supplied with a single argument, given by default by the average of the \
scaled values of ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " for each pair of successive contour levels. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->8456],

Cell[TextData[{
 "With the default settings ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exclusions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exclusions"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ExclusionsStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExclusionsStyle"], "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot"]], "InlineFormula"],
 " breaks continuity in its sampling at any discontinuity curve it detects. \
The discontinuity is immediately visible only if it jumps out of a particular \
contour level."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->131709506],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{
    ButtonBox["GraphicsComplex",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GraphicsComplex"], "[", 
    StyleBox["data", "TI"], "]"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->9405]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->146537779],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->18036949],

Cell["Plot the contours of a function: ", "ExampleText",
 CellID->29358],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "+", 
    RowBox[{"Cos", "[", "y", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18467],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyc3X/Q31lWF/ike9Kd7kn35EnyTDo9mZ6ku9PpUIqLoC6O5fdhHbHcRVeE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   "], {{{}, 
     {RGBColor[0.3441169110780499, 0.14555959182307163`, 0.6006782639620051], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3ecVdW1x8+dBmGYAWWcJCKTizOMd+rFgbmDmXEGFCkKFrBGQSzPRrNg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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwlmHl01dURx2/CUiWQUhNCKRhfSCK8bL/4SII0MQEKKEtQdlGBAha17FVZ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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4455187332341498, 0.32186997546921486`, 0.7432107918860154], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHd8VVX29g+OaRcDkXYjJgw3BUxyw00guZeYkIAduyP2wd4BwTbO2AYU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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwlmgd41NXSxv96pWRDQATZEA0fQeSa3YQlkGxYNiZYaNIJSJMqSi8qNkTp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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5469205553902498, 0.49818035911535813`, 0.8857433198100256], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFnXd4VVXWxq80A0p6IERUMIMhuYE0uEm4IQGlI1XEjgJSFbANNhwVbIN0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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmwd0VNUTxp8CEtCEkJAQgiBYSbKEbAq7S8ImIN0CIoJSlCJVqSpFwQKI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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6259490281195165, 0.6273881033512626, 0.9109150720273521], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxEnXd4VcXWxk9ChyQQSIHkBNKAJJBKMQnkJGCv14Zib2BFsWFv1y6CBRFB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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtnAmcztX3x7+WEGMba2bBoJrFzDwzZszM88w8g4o2RbKVyr5EsoQSKpLs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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7005028309634166, 0.7471753197051194, 0.9126146691033419], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnQd4VcX29g8h1ISWAiZIOglJJB1zUk6KYqNYsAFi7/3axQoognrtDRsW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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtnAd0lNXz9x+aKCCBkFACJKGThCS7SSDZkM0GsSG9qdgLIKiIglKld1AU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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7737900624999999, 0.85071925, 0.90903175], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFnXd8lUUWhq8oQgISkhuSGwgJSQiRhARy05shVuwFu9gVpaooKij23nXt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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtm3d81NXy/j8qCASkJCEhJCGETpINyabsbsiyVOkiggpIFyvNSxEE9GJB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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8407444374999999, 0.87304675, 0.87903625], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnXd4VVXWxi81CSXUFCQQCOkNQnLvxUBoYhv7jF3UsevYC+pgwYq9lxkF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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmndglUXWxt/QkpCbIKQBuWn0lBtyQ+5NCAlJaHZFVyyISLPiLlhgXXtZ
OyBFd1cB29oAQUFQkariIs2yFixI7yCKgID1+z3fs39M8p57Zs6cOVPOmedM
4Ygx5/+lSRAEn/GnGf8LqoKgTTwIumcHwbC2QdChIgjuLwqC6xOCoH96ECRG
g+A+6LHQh5KCoB/0rh5BcG5mEIxuQ/2aIGhVHASntAqCxpwgSENeHr/V8j0Q
eR8hu1NpEBQlB8EvrYPgvZIg2F0XBGvyg2A28hZSv1MkCP7RMghWhoLgyeog
GNIYBO90pQ50uvSj7KDuYmQk0f92+j+d/nPp/1n6rm0IgkEd0Bn65vIgOLVX
ECwLB8EYfjtA27389lQibdoFQSZ9z6C/a1OgGd/f4F0YC4KZWYyR+v3gr4a/
BP5HaUFwAv07UHpin1rG82/kNYc/Fn13018z6G+xT394AyjHqPs8dDXfPSm/
Qv9C6YLuMyjfofv07kHwSUYQXMQYnuV7GX0+ij3+Xkj/jKVJWRCEGfsQ9HkR
+cn0N47+WqYGwdOMtxd1LoA3hv4T4R9H/zz0O139Yes+2C+pSxBcQ5un4P9W
6u8t1E+G3od+Z1D3TMpM6F/gXw3/IPyn0ect9HkQfe5Bn2fhN6H/MfAD+p8B
fYz6I6B3Ur8GXfbC/wF7/QmdUuGHKJuYr0WMN4W5qGHMZzYPgruYk9+wRTGl
N/o20P/vfLdmvRSxXhqhE2gbUObT/jnaD2K+d9N+ILYaT3/nYptM+qygrwfQ
cQ76PlCPTdF1JuV56HfR/1/wHoTOwhbDmON/0f+PnVizyBoKnYe8dczBSfo/
hf670X8d/bfQ/FIW0/8s+p/G2N6sc19DGOOfoTfXBsGEPPYJvx2n/U+UMHUf
p6xjff9G/UPwliKjCbJ+ZH5yGG8/5GdrrTKGSvSPUfYgazwyWyG7N+uxBeO9
l/m5mv22j/br0S0bndPYrBXYryft+6P/QNqeR7mC74t7Mr/tGRf0nxnvUNr/
gBk3dcPu8M+DfwX88+Hvor+bIt4LjzGGTdDXQu9hPs9Dx3p0XwH9GvqchT79
6e/ycq/Fy6QzulRSMrBnJuvhK8Z+Bf0loW8h4ytnvL3QeRT2HAM9Fn2WMKZJ
8HeizxjokdRvCr0degb7/TJ+W8V+38Ca74HsCsq3jDeE/PacR8Oof4zx1KFP
Arwh7IENyL+G+XuAvpry24im6MJvTejrNuoPRv4W7Pch/PbwC5FXhf3CfD9A
+zq+b6d9GXSEsgZ+E/prSvs7aT8iwWfODtp3hP8Y/D/R5hPsVY195mKvSdhr
J/QN0Kdiz2myJ/a4hfYX0r4j429O2+H0N4Pz5Tr6O4a8cn7biLyrwt7Ls1i/
7xd6Tz8GPxH+eMazl/FUoc/30JewXoex/tP5vhF5ebQdj7yZ1G/Jb/dT/2iO
z8L5yNtQ6DNxK/wC+LfQ3zm06cp3F8pc6GPYO4z8ndDnIL8R+TnQa9E/Ff9Q
zHpuA70S+niC13gIejTz9QVzdxL7bGO8y+Efgd+V8UaYr3XQabQfmO69eg7r
PdrBezYLuhPr6T78Rb9074UlrLmJ+d4TubS/m/ajkNcA/yD6l6DfUvS9DP2L
4b8PPwH5Z8s/qS32P4f1Wg/dDvoF6Bugz4QuoP5d1B+JvL7QyfCnRryXX+R8
b8d4VsNv3sRndAr0tYzvM8Z3lPHt09lA/6/S/+Cwxz6F+g8n2AY/l3vPaa+9
Qf1XaP8X6M3QCdCbsc9L1H+B+p2xT1f0mQn9BPQZ6DMAe7TABl2Zi8u1v9g/
lVW2/UZKOvo+ib5Xo+8radbtEdrfkWAdfyv3ntJeWq4zi/6vg/5SuuHzOkTt
c+RrzmF+J1D/Ns7kI4zlAfqroq8BrKeb0G0cJQN9OlLnLuanD/qV0v4Q7S+m
/UVtPJdv1Pns05zmyz/TfihtL6eMoO+51dZlG3v6J+1Xncms1WHIeLDYe1B7
750sn8U6Y3S26Ey+MeIzSmfTLvZUJ+w3mTZnom8N+61F7yBYUOazJwEd28Hf
hw79qdsD/vUR70ntxW38tg1db6P+Ouw7H/s1MvZFyLuT9m8hsyPn9SWVQfA2
fV9A+7egt6LfqdARxn879VdR/6UWttk/kfUC49uJ7K+xwU3F3pPai4XwlyDr
n5z36xjbW7nIQN4V/LYKeYORv5GxftHg2OZM/FEffGlu1HvvHPpbTd3ptN9A
+7dp34SxfK0YBNtOgC7j+4+4fWW/XO/Nm6iTluc92q/cPkK+IS3TsdQT1V7L
iqmGQ8+p9tr8BrpWvoUx3ovuF3OmP8r4/l1t233I+B6G3sweODvsmK039dtT
fwr0o9RfBj8Z+k7opALOBPS/E/2Xov829MvCPgnQg6AvoEym/nPI34r8j5B3
Gm3fpE5SC8dsmdgrxvhOVTxDCUFHofvIf1L+xPgOsofOwN7tGN878Leh02l8
V6Xbl0yv9tkkn3Ibfd+B/B6aG/qvwN7JUceOjdTPYz2tR6ca1kNv1tPfqX8/
9Wuov4L6p8BfBb8Uflf4d8C/C3512GO8C/rv0D2hl0HXoM8x1twWxvYL++8N
bPcmpS38Z/Jti2zqd2xlmyyEdyM22Av/afijSjznmutJlNXQJ5G3G95CxjQZ
+94dc19T4T8OfV/Muj4GvYG662ocK8yiTQ59JcMfAv9Syirk7afOx/DmIu9X
vp8vs+/7lv3xivYTdbbDO9TaY23Fb5Fsj1mywsW2hWRuZa1tofzBer6Y9Xwn
vD+o05H6lWH78hPoMzpsnz6S+Xmd+bkU+TuZnznI3kF/m6F/UfyJLvupPyTs
Mf/B+IKY185RZH7A/t5X57WjGP1V2uZjrwWMfSFlFu2P0P7KsGOwJ6H3QF8S
9pxcT//Lmf/p7JXdnJHfoPvXDY49BqL/Dr63U5KxxxDoZfS/nBKm/w/ofz66
J7MmWrDWD7OG98G7Pea19TX9/4P+Xqz22fUV/W1A3x/rfFasSLGuW3QfaGud
tXbuof3yLK+hYvpexxofy9rp38G+aRxtWuXZRx1VbFtm3/1pmtd2IvK6ZXuN
N6Vus1qvnR3sidfgHcVG32Hf75nPAniFtbZVSpZjn++xz/CwY6A1jGctpSu8
Dci8Ffm/ol8h392pMw95h5C3F3lN2T89seUPyBhMXyOYv6HY96Vq+571zG8p
9achYyBt65ExAP3XR2yL/6a57duMZ0qGZaTTfgDjz+Vs2Yf9M6ifgr0TC3xn
Uyz0FvUnZzgm+o3YdnKRfWOI+Kcv9ttN+2n0fyn2249v2AM9PdEx2q/Uf7jI
vj8lx77t3/inzzPs4/6pWI3xfsj4r0bn49jmJ8q1Ya/hQ3x/RxkWts3yGF+0
yrFun1yPNZ/fqrI95t+R1Q7+JfB7wH8X200lPnuJ+GwWNmxB3b3aX/Crch1b
N+U8uDnsGPtG6j9U77tNH+0R5LWq8t26gvpptP1OOkBXQ2fDy6Lspu4S4odq
7LFT8X2K7wzd4ZVROsL7lBLhuwGdR9P+OkqJYg9KAbxPKJ11P6e043sDpa6H
fYZ8hc7Ek3xf3d13qZHY78/Y5gTnczrx6Dzsm0vbcJWxg5W0L+Q7G30rsM9w
+suETqX/QXxfSKnvYR8j36IzeTq6L2UNTMp3DKS74udFXju6M06p9x1Id58X
C409JBc7NhAG0QX5Vfx2Od9XIv8E879Y/rcjPifHd79PinzX1x2wFfRS+Bvh
d4VuW2WMQ9iG5vBVxjqZPl8o9BwWsDY/Yj32Rtez6fMx+u4u/8z4LmAOd9F2
J+VCvi8KO5YJw49lO6bZzlyHmeOzoUcxf18w1g01vqssZMxti20z2aoT8kNx
n7E6W0toM4LvN7F3UoYxjPegb0Xm4bBjlgD95pX5LrWbMR5l/exGXh/2Qpj2
d9N3qLd99xDmaAv9/436qzlf5lJ/F7IKSnw3vCrXZ98z9DG2jc/AltBLqd8x
1Xs0CXoRdLtUY0LypffT58os+9Rh7O9Z1Y6Vv+R8eCxmm8lWa6lzA/29A70y
1T5xCrK2YY/zw/ZZGcXGrIRVFSD/ceh/IWO9YknqTJVvwka16HsudLO4zzCd
XV347Tz6H0hpivyULtTh+xzKyZAxk3FlngPZ/jba/CPmPiT7/2M6vs9AxxVh
xywt+G5OuQX6Vko7vttSJocdIzXhO4Hy17D39Ngy+2j5ZrXpylpbzvq9kvOp
gTX8ZMxnkM4exYCD0O0CShH6htFvasxj1NjWwO9C+2W0H0n73rQ/CX8P9unL
/OYrXqLt+ZSutG9H+y7Y4+e4sY6+zGeGzh/q96N+OfVzoLtWea80wk9F9xDl
nrBjxCS+E3vZNrdTquj/M/ofT//ndjBWmFfh2EqY4QS+x6FvJ+pu4rce7Oev
GuxrZ3OH/pl4bFuDfa0wqKPQmxscSwhjEnZzYdTYjzCcctp/3uDY+UX43eHX
RO17+uO/ukC3ZLwfw5/EnEagq6O+O0fhF0InwV8Hfwj8ztCRqO8293Fm7S8y
RiZsbGeasadr2PPNWhuDyinxntVe7UadebQ/O2rs8Wz4u7Dfzrixh1s47zLg
vYfMPxJ8puaXeE9pLxXRfni5MSphUzpDdBdfqRg43XfyS/HFgylL+F6aaez1
MvRp0toYbAHtO0Z9t2vT1L6zf9TYrHxoEmdVcr3vXmNa+y5dSvk95Du17rZF
itFCvuNOZ30eZ31+lubfmmHvvo3eK8I8hYV0ohwKGRMRtlBI2RUyxjCV9gcV
X6a5jrC/XsIcUo0BPgJ/r2KANLeJCTtp9Nqc09LYQ0mF70LCIHrDP63Ra39B
S999O8E/Nd134DmMNafC2NkJjrt8xlpQb190c2vf1btUGOvVnV3YWmGFsQdh
bMJ6whXGDoT5aK6KKox9ac4UK3arMJagmFHYUn6F78bCmE4td8yiWEVnns7W
icz/qmyfsdpbI6EnZnuPdWV/Tot57zYnpiuIO4ZQ7KCYQXefDOb/tGzfgUrY
D0MqPfcFrJemVb5j6m4pzHlUD9/5dNfTHbsJZ+tj2Gxoim1Uiq6r0DnAluem
+yxqKPde1ZmkvT1Ie6yD9/gC6s/FfmvwbQnIWwS9CPoT6GbQSVW+o+puKgz5
wXpjjMIWZ1BnDt9nRo1Nn5lp37SYOp8X2kfprv0xY2zf1nfuEdDDKe9If0pe
le+QujsKU8iocoyt2FoxQlz+HPul5hmzKK2yTWVLxTCK1erKHTsrZlvOekvr
bV+hNajYrbbcZ61iuK3EwmOx12TaP0rphb0n0t8BdOmEvFeou0frDd3P4rfF
fD/EefYu85fKbyfo+yfKFYnG4HcztiaUznyX6oyl/9H0OZf44WbO/HLkpbJe
vupkTKIMOiQ8rZN9rrCMK2k/JduYxhFkH6aMSDSGPJ/+L6H/VcgL6L8pdRMo
tye6T92VU1g/fbN9Z5YvGlzuWFg+SbFIz3L7CsUk1T3sw+S7FFO3pX0W5d5E
x2gd+S6kPJHoHEgK38mKQaCLodOF31PuTnQOqYTvIsqMRGP8wsr/gn0n5hkz
F/YZpSSlGgMVVpjHeilJNmZ4DfZaU2es92VhYtCr6hz7TAkZ620m/ChkzPdW
xnMbZW2OMSthvTmU90LGfIWNpvRwW2GkwlaThAGHjLHeSdu7KB/TfnzItj4W
c2wkmz8I7yHKphxjluPR50v0eSnNfQibbyt8MmSM/nr4H8F/Ns2/bWEtba20
L9AddwffOyudy9Id+0XG/hLlbb6PB8aOE6C/TTKGvIm631Y6l6LflqHL8hpj
TbNCjrVPUi4POebuR/+v0f/mNP8mrHd3jWNPYb5aqz/HHBtozb6P7P9UOtch
HTT37ePG0rQGNLeZcccGmuNRzOWOKufytnIer9F9Ju5cmHIm3YUv9DLWdYD6
U6FPqTWWczX8obTfRPufab+R9k2hn6tyLkk5pvep/2jcuSrlgDrDX1RlLEI5
whLot6t8l326pddaJO67pdacch+fKh/T1jkQ5Ro2Que3dc5hoWxJyWD/vpbk
tZwadyytNa291DzuWFF7aqXOJkq+Yj/qP8j3Q5S9nAUDoKfwPZXyA/R50C8z
d1/GfVbvDJz7+Dbus0Q5kJbo/1KVc23K6WlvdY4b29QeE1b4GXRuW2OGe9RX
pXOjO5H/JvLeovzI918TjIW3he6UbEw8V7nAmHNROZRmOhspE/k+Tptivkti
vvupTWe+u1D2a7/ofsZ3h5jvfvnJ9h2ZUfPkQxZrrUYt616NR/fzOmMh8jnt
leuK+a7YPtm5gdZRfytHsJXY5Yt6Y/drWaMR6pbFnBvtTInxHaf8GPKZsIr6
r9Y7FzCT+lF4FTFj48opvwd/Tr2x/Rnw34d+vd6562eg72Y/bK8z1v4RMj+A
vwT+aTpf4P8H+k3oAdDPQc/E1k9RijmfrtKe5PsE5X3afp9kLD8tap4wfWH5
qdDDk4zpH6Tud5W+e+8R5qK1Icwu2ZjJYvnOSuc2F0g+632+1iD9H05yrqJZ
1HOtnMUR6h6t9N1ZGI5yI82jlq0cya/wfqM8kOw1odx9y6h1VQ6/jvW2mvXW
CvnzleOlv7lxYzfCCMbS9vpK53YD6DD+bwP87unGCJ5H1gtR67qDKq3hr9X+
SDcm0A/565GfCf2m4nnkL4DfBvqnJOcGf8fftEhyjlC5vF/K3ZdyejfR97hK
57ZVZxvtZ8eNBSqH/AS8JyndUm1j5f5voE5iut8AjIZ3LWUN32szffeZTPs1
2b4DKTd6ZblzK8qRnlrsnIdyHd1C9s3X1RirkI++j+/7a5xL/JKSwPpppE1u
yDn55mWWobbK2YgnDEXYiepkcxZfgU0+TncM/9+4bSjb5VDnDmTfThkXcg7z
Zr7/Srkn3z79gnJj3MK2P8ffTIjY58vXK8f1fMQxiGIP5biWQ38NXZbhnO0X
cfsU+ZI8+luHbQ4W+e7fjTNsXMR3Mt3FlHMeE3EMpNhHObizoo55FOvojq/c
8Vnlzu0rhzwo5jcWeluhnOYe2qdjg8MpfgNQzPq4rtJzoTP3YNwYnbA5YVSK
3R6P+a6vGO4A/JZxxxLl8LfqLC91LlEY6WjuegvLHctPlD7YfzrjeS3NMcDn
ijdKPVadmVOx5bQa50735Birmdfd2JAwmweKHKMpNpOPzma8/UodG9cg/1r6
e73cd6WHoRuoexL+99Qfio6HoZ9ERiV0jPK98NC496724DfaO6XO/SpnUwFd
VurcuGKyI9A/xr03dCYfov9SbDg73Wu6Dt4R6h+g/iXUL4A/oNS51L7oE4ff
u9S5RN0RvmHtXRaxL9UZPpvxvlz/v7OQ8aYVG2MTtrY3xXOlnJ1ydZqzN7gv
jCL+3NPVGMNTjG0a83c40z5N308XOXem3y4tdg5euXfFXFvgraBObpYx8nXo
l15q36MzYmG1MX9h/cIghhU7J65cuGKq9dRvV2pfo5hgArIeoezPdAz+MN/T
ioxF7YOeWuTf9C0f/AX0G9CZWfbp+t5YZGxcv82HPqXCubxToF+HblfhXFGb
LO+9Pr2cC9QeHFjmM0B7X29glFvKj9r2yjF1Q9eRlb6rKMZQrjAr6rWjnOE7
+JohZcYelOPZEfEcyPbCYIdq/SL/SI7fqHSssE+XL5cPOlDkPau9Kgx+cLHv
ZLqLrabNvGrnWJVbVY5Ctt9Km01pnoMPdZ8stS/VGX5hmd+c6K2JMFTlpnVn
1l1ZOWphJcJAhH0IM1HuWDGMYhflkHVXEcYibEV3lleqnUNU7lAYmu4uwliE
regOM7vaGJ+wPeWEbkD/b9C/e4ZzYIns/aSYc1EnWL+XFfuOqbulYvCLyryH
tXf1JurlaucUlEsQRreNsb7LmAuyHJPpe3uRc1f6TdiOMBFhIcJ4Olc4ZlGs
Ip//N2TfUmNb3ov8eeyVV+odW+jOq7dEs7v7Lqs3Rb/FjLkLa1cOZGbMORLl
RpQjCOLG+IXtK+c1uNF3Ct0lstC5Xy/3qb4WCz+LG/MX1q+czSlxY/jC7pVj
W6n8f8TYmHxqbtyYnLA4Yca7Kv53x1b8ic3ujTlHptyYckj7K/6HScE/Hf5V
cceoik11pxwVdwyr2FWYxLIG54SUCxLmfQv6PkL7+zsYQ56BLebV+e46Fns8
EXNOTLkwYa6n9/IbOr2dEyY6Je6YWbGyfPA7jCceMbajGGcFdDRi7E4xyX+g
ayOOTeTjD6D/JOFLGc7xzqXvxjJjdVrj43o5p6pc6j69YYh5TWktCWPW2XFT
id/m6AwRdtYJelC2MbRPhG+W2hcLg+jZw5imsEzloDT2B2N+myAbHI07x6rc
qt70/RB3Dla5V/mAD9C/PmJsSjFPnfKhyJiYaExF2EZJic9yYRzaC5+xxo4X
ek9MpP+dFZ7Lg5QVUecolZscgQ3XCcuNOLZSTCrb7Kvw3MpGlzb6Tqi7YIeu
joWqSuyrFBO93eCcoHKBynnsrnCf6kuYxmLleyK+SynGXYDu10fta4V5dosb
MxZWLExdscb18ilhxxzyxfKJ8oXyyW8ztrfqHVsL8/mc70/rHetrzOuL/KZS
bymFAb5Q5DeTeiv5OnRf5mZ73Niq3jRsqfWbRL1FFIagXO7eGr/FUU734jLL
UFvd6f9b5DeGelsoDHJHkd9I6m2k7sSbi/xmU281v4beE3dOULlA5eC21fpN
pt5iChOajz2uizoWEOY6voffGOptoXKGCxjba/W+a+jN1Rt8L6z3XUKY2ZdF
fgOot3/CVCcUOeZRrCMM4YYe3mPaW3oTqrcWW2r8VktvLsrjfvOhtx7KKent
hN5o6G2G3lA8FPObHr3lESY1u8wYtrBrYSzKhR+t8Vsz5cT1Nq9PsXNVeqOn
3M1zxY41lcPpj/13xI1NK+e8NOo3fHq7p5z9duGZEd/9dUdTbq222G8nlGOb
FPcdW3drYaB6G9Kyl99+6o3Ifvj74n7bqDuRcj039fJeVs5HvnFGjd+yyUeu
5HsFZXbIOYSP+f6oxnc5veFbVOM3FHo7oTW5lO8lNcaO9EZOb3WUk1cuXm92
9Panby+fxXoD9EyZ14TWgjBxvT04UOO3ZnqDoNzT9hq//VMOSrHSomrvTcVM
/wdFxQe7
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.9076988125, 0.8953742499999999, 0.84904075], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3l8VdW1x0/uvbkMJgiKxpEbBjOSG2K4JyEhEOf2vbZWbK2fju+hOLX1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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3l01NUVxx8hSICQIImENZMECE5khkwnM0kmTEG2/uPSasXW41KX2loW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         "],
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{11066, 15861, 11930, 15079, 15080, 15081, 13096, 13097, 
         11932, 15862, 11931, 15863, 10712, 14082, 13810, 13811, 13809, 13813,
          13812, 14310, 13965, 13966, 13492, 13493, 10710, 13494, 10711, 
         15860, 11928, 15859, 11929, 13095, 13094, 15078, 15077, 15076, 12345,
          16422, 12477}],
        "1.5`"],
       Annotation[#, 1.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{11123, 16265, 12203, 16263, 12202, 16264, 12363, 14673, 
         12364, 16442, 11752, 15726, 11751, 10771, 14111, 10770, 16528, 14110,
          13561, 13695, 13694, 10880, 13839, 13840, 13838, 14061, 14060, 
         14845, 10640, 15635, 11674, 15634, 11675, 15804, 11862, 16407, 11861,
          15803, 11631, 15584, 11632, 15585, 12193, 15805, 11863, 14994, 
         14995, 14996, 13063, 13064, 11865, 15806, 11864, 10661, 14069, 10660,
          16503, 14068, 13461, 13701, 13700, 10886, 13702, 13703, 13575, 
         13576, 10779, 13577, 10780, 15888, 11972, 15887, 11973, 13117, 13116,
          15118, 15117, 15116, 12373, 16445, 12511}],
        "1.5`"],
       Annotation[#, 1.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{11137, 15884, 11965, 15113, 15114, 15115, 13114, 13115, 
         11967, 15885, 11966, 15886, 10772, 14112, 13842, 13843, 13841, 13845,
          13844, 14312, 13923, 13924, 13448, 13449, 10642, 13450, 10643, 
         15839, 11897, 15838, 11898, 12334, 16652, 12333, 12600, 12599, 13295,
          11960, 13112, 15110, 15109, 11888, 15821, 15051, 15052, 13079, 
         13080, 11890, 15822, 11889, 15823, 10631, 14054, 13826, 13827, 13825,
          13829, 13828, 10875, 13820, 13821, 13819, 14095, 14094, 14878, 
         10761, 15878, 11954, 15877, 11955, 13109, 13108, 15107, 15106, 15105,
          12352, 16439, 12500}],
        "1.5`"],
       Annotation[#, 1.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{11202, 16274, 12207, 16272, 12206, 16273, 12389, 14680, 
         12390, 16454, 11782, 15757, 11781, 10823, 14135, 10822, 16547, 14134,
          13623, 13717, 13716, 10900, 13871, 13872, 13870, 14079, 14078, 
         14865, 10709, 15686, 11724, 15685, 11725, 15858, 11927, 14501, 11926,
          14502, 11635, 15589, 11636, 14315, 12520}],
        "1.5`"],
       Annotation[#, 1.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{11203, 15846, 11914, 15070, 15071, 15072, 13088, 13089, 
         11916, 15847, 11915, 15848, 10700, 14072, 13858, 13859, 13857, 13861,
          13860, 10896, 13852, 13853, 13851, 14119, 14118, 14903, 10812, 
         15902, 11980, 15901, 11981, 13119, 13118, 15130, 15129, 15128, 12378,
          16451, 12518}],
        "1.5`"],
       Annotation[#, 1.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{11204, 15850, 11921, 15073, 15074, 15075, 13091, 13092, 
         11923, 15851, 11922, 15852, 10706, 14077, 13866, 13867, 13865, 13869,
          13868, 10899, 13855, 13856, 13854, 14129, 14128, 14907, 10818, 
         15904, 11983, 15903, 11984, 12385, 16662, 12384, 12630, 12629, 13286,
          12137, 16757, 12466, 12657, 16491, 12468, 16158, 16159, 16160, 
         13305, 12136, 13163, 12382, 16453, 12383, 16452, 11778, 15750, 11777,
          10817, 14125, 10816, 16544, 14124, 13607, 13715, 13714, 10898, 
         13863, 13864, 13862, 14074, 14073, 14864, 10705, 15684, 11719, 15683,
          11720, 15849, 11920, 14498, 11919, 14499, 11633, 15588, 11634, 
         14314, 12519}],
        "1.5`"],
       Annotation[#, 1.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{11207, 15865, 11935, 15082, 15083, 15084, 13099, 13100, 
         11937, 15866, 11936, 10718, 14084, 10717, 16511, 14083, 13499, 13719,
          13718, 10901, 13720, 13721, 13501, 13502, 10719, 13503, 10720, 
         15789, 11841, 15788, 11842, 12321, 16648, 12320, 12579, 12578, 13293,
          12187, 13170, 12188, 15790, 11843, 14955, 14956, 14957, 13048, 
         13049, 11845, 15791, 11844, 15792, 10723, 14087, 13815, 13816, 13814,
          13818, 13817, 14311, 13968, 13969, 13504, 13505, 10721, 13506, 
         10722, 15868, 11940, 15867, 11941, 13102, 13101, 15087, 15086, 15085,
          12348, 16423, 12478}],
        "1.5`"],
       Annotation[#, 1.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{11211, 15869, 11945, 15091, 15092, 15093, 13104, 13105, 
         11947, 15870, 11946, 10730, 14089, 10729, 16514, 14088, 13511, 13723,
          13722, 10903, 13724, 13725, 13513, 13514, 10731, 13515, 10732, 
         15872, 11950, 15871, 11951, 13107, 13106, 15096, 15095, 15094, 12349,
          16426, 12491}],
        "1.5`"],
       Annotation[#, 1.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{15799, 11855, 16405, 11854, 15798, 11629, 15582, 11630, 
         15583, 12191, 15800, 11856, 14981, 14982, 14983, 13059, 13060, 11858,
          15801, 11857, 10651, 14065, 10650, 16501, 14064, 13456, 13697, 
         13696, 10884, 13698, 13699, 13567, 13568, 10774, 13569, 10775, 15809,
          11868, 15808, 11869, 12326, 16650, 12325, 12589, 12588, 13294, 
         12195, 13174, 12196, 15810, 11870, 15003, 15004, 15005, 13066, 13067,
          11872, 15811, 11871, 15812, 10776, 14113, 13847, 13848, 13846, 
         13850, 13849, 14313, 13926, 13927, 13457, 13458, 10654, 13459, 10655,
          15841, 11900, 15840, 11901, 12336, 16653, 12335, 12602, 12601, 
         13296, 11962, 13113, 15112, 15111, 11893, 15830, 15053, 15054, 13082,
          13083, 11895, 15831, 11894, 15832, 10636, 14059, 13834, 13835, 
         13833, 13837, 13836, 10879, 13823, 13824, 13822, 14105, 14104, 14882,
          10767, 15880, 11957, 15879, 11958, 12359, 16659, 12358, 12613, 
         12612, 13285, 12125, 16756, 12465, 12652, 16490, 12467, 16135, 16136,
          16137, 13302, 12124, 13156, 12356, 16441, 12357, 16440, 11748, 
         15713, 11747, 10766, 14101, 10765, 16527, 14100, 13545, 13693, 13692,
          10878, 13831, 13832, 13830, 14056, 14055, 14844, 10634, 15625, 
         11666, 15624, 11667, 15799}],
        "1.5`"],
       Annotation[#, 1.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2667, 11044, 13402, 13403, 13404, 11307, 14040, 12712, 16748,
          12713, 11065, 13422, 14503, 16734, 14504, 11933, 16718, 16719, 
         16706, 11516, 15538, 11517, 14238, 11045, 13967, 11205, 13495, 14080,
          14081, 11357, 13498, 13497, 13496, 11206, 12709, 12708, 14034, 
         11303, 14033, 14032, 13401, 11043, 2012}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{10553, 14798, 11576, 15569, 11124, 13451, 13452, 13453, 
         11323, 14045, 12731, 16752, 12732, 11136, 13463, 14515, 16739, 14516,
          11968, 16722, 16723, 16711, 11573, 15568, 11574, 14273, 11125, 
         14001, 11255, 13562, 14062, 14063, 11353, 13565, 13564, 13563, 11256,
          12728, 12727, 12835, 11319, 16311, 12230, 16308, 16310, 16309, 
         12981, 10845, 14976, 14975, 16730, 1534, 14973, 14974, 10844, 13057, 
         10843, 14972, 14971, 12323, 16404, 11315, 12831, 10620, 12546, 11236,
          13537, 14052, 14053, 11351, 13536, 13535, 13534, 11235, 13995, 
         11109, 13994, 11233, 13530, 14092, 14093, 11363, 13533, 13532, 13531,
          11234, 12545, 10618, 14044, 11311, 14043, 14042, 15362, 11108, 
         15364, 15363, 16570, 16569, 14840}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2787, 11036, 15330, 11035, 16684, 14050, 11331, 15476, 10688,
          12562, 11284, 13599, 14070, 14071, 11355, 13598, 13597, 13596, 
         11283, 14027, 11184, 14026, 11281, 13592, 14116, 14117, 11376, 13595,
          13594, 13593, 11282, 12561, 10686, 14049, 11327, 14048, 14047, 
         15391, 11183, 15393, 15392, 16573, 16572, 14863}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2055, 11020, 13873, 11019, 13874, 11310, 14041, 10597, 12542,
          11081, 13427, 13428, 13429, 11949, 14246, 11529, 14245, 11530, 
         14247, 11064, 14237, 11515, 15537, 11514, 16609, 16611, 16610, 11948,
          14510, 16738, 14509, 13512, 11212, 12541, 16751, 10595, 14039, 
         11306, 13420, 13419, 13418, 11063, 13888, 11513}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{11054, 15337, 11055, 15338, 11053, 13413, 14036, 14037, 
         11305, 14038, 12710, 12711, 11210, 13508, 13509, 13510, 11358, 14086,
          14085, 13507, 11209, 13970, 11056, 14243, 11525, 15541, 11524, 
         16707, 16721, 16720, 11942, 14508, 16737, 14507, 13426, 11074, 12716,
          16750, 12715, 12827, 11309, 15591, 11638, 15590, 11637, 12940, 
         10869, 15040, 15039, 1651, 16731, 15037, 15038, 10868, 13075, 10867, 
         15036, 15035, 11881, 15817, 11308, 12826, 10592, 12539, 11073, 13423,
          13424, 13425, 11939, 14241, 11522, 14240, 11523, 14242, 11052, 
         14236, 11509, 15531, 11508, 16606, 16608, 16607, 11938, 14506, 16736,
          14505, 13500, 11208, 12538, 16749, 10590, 14035, 11304, 13411, 
         13410, 13409, 11051, 13885, 11507}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{11153, 15375, 11154, 15376, 11029, 13877, 11028, 13878, 
         11326, 14046, 10663, 12558, 11152, 13468, 13469, 13470, 11971, 14283,
          11587, 14282, 11588, 14284, 11135, 14272, 11572, 15567, 11571, 
         16601, 16603, 16602, 11904, 14492, 16733, 14491, 13574, 11260, 12556,
          16747, 10641, 12838, 11322, 15637, 11676, 15636, 15883, 15882, 
         11964, 10914, 16551, 12372, 12371, 13036, 13035, 13198, 13033, 13034,
          12462, 12621, 10913, 16444, 16305, 16306, 16304, 12229, 16307, 
         11318, 12834, 10630, 12554, 11254, 13558, 13559, 13560, 11896, 14265,
          11562, 14264, 11563, 14266, 12528, 14000, 11252, 13554, 13555, 
         13556, 11371, 14109, 14108, 13557, 11253, 12551, 10629, 12830, 11314,
          12553, 12552, 13282, 11122, 12782, 11564}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{11621, 12823, 11200, 13284, 12572, 12573, 11330, 12843, 
         10698, 12571, 11301, 13619, 14132, 14133, 11383, 13618, 13617, 13616,
          11300, 14031, 12536, 14307, 11620, 14305, 11619, 14306, 11925, 
         13622, 13621, 13620, 11302, 12574, 10699, 12845, 11334, 12576, 12575,
          13281, 11201, 12825, 13491}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{13489, 12816, 11192, 13280, 12566, 12567, 11332, 12844, 
         10692, 12565, 11291, 13604, 13605, 13606, 11918, 14299, 11613, 14298,
          11614, 14300, 12535, 14028, 11289, 13600, 13601, 13602, 11379, 
         14123, 14122, 13603, 11290, 12564, 10691, 12841, 11328, 15679, 11711,
          15678, 11710, 13018, 10865, 15029, 15028, 15219, 15218, 10945, 
         15220, 15221, 15030, 15031, 10866, 13019, 16340, 16341, 16339, 12256,
          16342, 11329, 12842, 10693, 12568, 11293, 13609, 13610, 13611, 
         11380, 14127, 14126, 13608, 11292, 14029, 11193, 14030, 11294, 13612,
          13613, 13614, 11356, 14076, 14075, 13615, 11295, 12569, 10695, 
         15477, 11333, 14051, 16685, 11039, 15333, 11040, 15580, 11626, 14826,
          14827}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{13547, 11245, 12549, 10625, 12829, 11313, 16303, 12228, 
         16300, 16302, 16301, 12978, 10842, 14970, 14969, 15172, 15171, 10933,
          15169, 15170, 14967, 14968, 10841, 12977, 11660, 15622, 11661, 
         15623, 11312, 12828, 10623, 12547, 11242, 13541, 14098, 14099, 11366,
          13540, 13539, 13538, 11241, 13996, 12527, 14261, 11557, 14259, 
         11556, 14260, 11892, 13544, 13543, 13542, 11243, 12548, 10624, 12832,
          11316, 16299, 12227, 16296, 16298, 16297, 16443, 10911, 12619, 
         12459, 13029, 13028, 13197, 13030, 13031, 12460, 12620, 10912, 15881,
          14513, 14514, 15627, 15626, 11668, 14338, 11320, 12836, 10635, 
         16746, 12555, 11257, 13566, 14489, 16732, 14490, 11899, 16598, 16599,
          16597, 11568, 15559, 11569, 14271, 11128, 14279, 11581, 14277, 
         11580, 14278, 11969, 13466, 13465, 13464, 11144, 12557, 10653, 12839,
          11324, 15842, 11905, 15055, 15056, 10887, 13084, 10888, 13704, 
         12427, 15226, 15227, 10947, 13269, 10946, 13268, 10948, 15229, 15228,
          12428, 13705, 10889, 12985, 11684, 15640, 11685, 15641, 11325, 
         12840, 12734, 16753, 12735, 11145, 13467, 14517, 16740, 14518, 11970,
          16724, 16725, 16712, 11582, 15570, 11583, 14280, 11130, 14002, 
         11258, 13570, 14066, 14067, 11354, 13573, 13572, 13571, 11259, 12730,
          12729, 12837, 11321, 16315, 12232, 16312, 16314, 16313, 12983, 
         10850, 13654, 12409, 15177, 15178, 10936, 13172, 13173, 13171, 10935,
          15176, 15175, 12408, 13653, 10849, 13061, 10848, 14985, 14984, 
         12324, 16406, 11317, 12833, 10627, 12550, 11247, 13553, 14057, 14058,
          11352, 13552, 13551, 13550, 11246, 13998, 11116, 13997, 11244, 
         13546, 14102, 14103, 11367, 13549, 13548, 13547}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{11505, 13883, 11046, 13405, 13406, 15758, 11784, 14911, 
         14912, 13040, 11783, 16372, 12306, 16370, 12305, 16371, 10568, 10535,
          14750, 14749, 16203, 16202, 11504, 15690, 15691, 15687, 15689, 
         15688, 10588, 15593, 15594, 15592, 15596, 15595, 11639, 16276, 16277,
          16275, 12208, 10570, 14755, 14754, 14753, 12186, 16206, 11518, 
         12892, 14920, 14919, 11793, 15762, 14450, 15348, 15351, 15350, 15349,
          13431, 16568, 14828}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{11511, 13886, 11057, 13414, 13415, 15760, 11789, 14915, 
         14916, 13041, 11788, 16375, 12308, 16373, 12307, 16374, 10569, 10536,
          14752, 14751, 16205, 16204, 11510, 15696, 15697, 15693, 15695, 
         15694, 10593, 15600, 15601, 15599, 15603, 15602, 11641, 16279, 16280,
          16278, 12209, 10572, 14759, 14758, 16207, 12189, 16726, 15543, 
         15544, 15542, 12309, 16378, 16380, 16379, 13204, 15610, 15609, 15608,
          12452, 13178, 13177, 12955, 13644, 13643, 14479, 11850, 13749, 
         15150, 15149, 11849, 15794, 14964, 14965, 12952, 13175, 13176, 12953,
          11646, 13203, 16376, 16377, 15764, 11796, 15547, 15548, 14452, 
         11795, 14451, 11794, 15763, 12750, 14317, 14318, 14316, 14320, 14319,
          11640, 14322, 14323, 14321, 15598, 15597, 10591, 14354, 14355, 
         14353, 14357, 14356, 11726, 14634, 14635, 14633, 16344, 16343, 12749,
          14445, 11785, 14444, 11786, 14446, 11506, 12890, 14914, 14913, 
         11787, 15759, 12537, 13287, 11047, 12746, 13408}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{11536, 13911, 11097, 13433, 13434, 15766, 11799, 14921, 
         14922, 12895, 11535, 14454, 11798, 14453, 11797, 15765, 12756, 14325,
          14326, 14324, 14328, 14327, 11642, 14330, 14331, 14329, 15605, 
         15604, 10596, 14359, 14360, 14358, 14362, 14361, 11731, 14637, 14638,
          14636, 16347, 16346, 12755, 14448, 11790, 14447, 11791, 14449, 
         11512, 12891, 14918, 14917, 11792, 15761, 12540, 13288, 11059, 12752,
          13417}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{11539, 13914, 11102, 13435, 13436, 15767, 11800, 14923, 
         14924, 12896, 11537, 14252, 11538, 13339, 13340, 13341, 12771, 10545,
          14776, 13342, 14618, 14617, 11552, 14364, 14365, 14363, 15708, 
         15707, 10619, 14367, 14368, 14366, 14370, 14369, 11553, 14255, 14256,
          13343, 13344, 10546, 12772, 14788, 14787, 16233, 12190, 16647, 
         14267, 15555, 14268, 12311, 14666, 14668, 14667, 13206, 15621, 15620,
          15619, 12453, 13182, 13181, 13227, 13228, 12366, 12365, 13229, 
         11753, 12458, 12282, 13027, 11754, 13283, 12617, 12618, 13231, 13230,
          13185, 13186, 13043, 11811, 14748, 13624, 13042, 11810, 16386, 
         12314, 16384, 12313, 16385, 10578, 10551, 14792, 14791, 16236, 16235,
          11567, 15730, 15731, 15727, 15729, 15728, 10644, 15645, 15646, 
         15644, 15648, 15647, 11689, 16317, 16318, 16316, 12237, 10580, 14797,
          14796, 14795, 12194, 16239, 11575, 12904, 14932, 14931, 11821, 
         15776, 14466, 15377, 15380, 15379, 15378, 13472, 16571, 14847}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{11594, 13953, 11171, 13475, 13476, 15778, 11826, 14934, 
         14935, 12909, 11593, 14469, 11825, 14468, 11824, 15777, 12792, 14340,
          14341, 14339, 14343, 14342, 11693, 14345, 14346, 14344, 15663, 
         15662, 10662, 14398, 14399, 14397, 14401, 14400, 11758, 14652, 14653,
          14651, 16362, 16361, 12786, 14464, 11818, 14463, 11819, 14465, 
         15561, 15560, 11820, 15775, 16391, 16390, 13208, 15633, 15632, 15631,
          12454, 13188, 13187, 12984, 13658, 13657, 14481, 11860, 13758, 
         15180, 15179, 11859, 15802, 14992, 14993, 13062, 10854, 13656, 13655,
          16593, 11809, 15771, 14929, 12901, 11560, 14270, 11566, 13352, 
         13353, 13354, 12783, 14390, 14391, 14389, 14393, 14392, 11750, 14395,
          14396, 14394, 15725, 15724, 12724, 14385, 14386, 14384, 14388, 
         14387, 11561, 14262, 14263, 13347, 13348, 10550, 12781, 14459, 11805,
          14458, 11806, 14460, 11659, 12973, 14927, 14926, 11807, 15769, 
         11024, 13289, 11025, 12722, 13443}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{11597, 13956, 11176, 13477, 13478, 15779, 11827, 14936, 
         14937, 12910, 11595, 14289, 11596, 13362, 13363, 13364, 12809, 10562,
          14814, 13367, 14622, 14621, 11609, 14403, 14404, 14402, 15746, 
         15745, 10687, 14406, 14407, 14405, 14409, 14408, 11610, 14294, 14295,
          13368, 13369, 10563, 12810, 14823, 14822, 13377, 12198, 14625, 
         11622, 12920, 14942, 14941, 11835, 15783, 12563, 13291, 11191, 12811,
          13488}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{11624, 13881, 11038, 15332, 11037, 15331, 16715, 11836, 
         15784, 14943, 12914, 11611, 14308, 11623, 13378, 13379, 13380, 12815,
          14416, 14417, 14415, 14419, 14418, 11776, 14421, 14422, 14420, 
         15749, 15748, 12742, 14411, 14412, 14410, 14414, 14413, 11612, 14296,
          14297, 13370, 13371, 10564, 12814, 14471, 11828, 14470, 11829, 
         14472, 11706, 13011, 14938, 15780, 11830, 16594, 15066, 10895, 13087,
          15069, 15068, 15067, 11913, 15845, 12254, 13012, 11707, 13216, 
         12341, 12342, 13215, 13214, 13191, 13192, 13008, 11702, 13210, 16398,
          16399, 15781, 11831, 15577, 15578, 14291, 16590, 11603, 14292, 
         13365, 13366, 12817, 10565, 14818, 13372, 14624, 14623, 11615, 14424,
          14425, 14423, 15752, 15751, 10694, 14427, 14428, 14426, 14430, 
         14429, 11616, 14301, 14302, 13373, 13374, 10566, 12818, 14825, 14824,
          13381, 12199, 14626, 11625, 12921, 14945, 14944, 11837, 15785, 
         12570, 13292, 11199, 12819, 13490}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{11628, 13882, 11042, 15335, 11041, 15334, 16716, 11838, 
         15786, 14946, 12918, 11617, 14309, 11627, 13382, 13383, 13384, 12824,
          14437, 14438, 14436, 14440, 14439, 11780, 14442, 14443, 14441, 
         15756, 15755, 12743, 14432, 14433, 14431, 14435, 14434, 11618, 14303,
          14304, 13375, 13376, 10567, 12822, 14474, 11832, 14473, 11833, 
         14475, 11709, 13014, 14940, 14939, 11834, 15782, 11032, 13290, 11033,
          12741, 13483}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl1MlvDVAUx/FjSsxLMdTQ4b3X13pFW0FVsKgVQWvaVVpjhVqYZy3Cxk5M
JTZiTlBqQ6uGGmJK8A9YUFNigY0YPi8W3/7Oved3zz3nvveaW9dYva5HRAz2
p740Ii8TcWdSRIYmyiOSSKF7QkR6ckQRCjEWxXjHV0LHIYOl0yJq0cpfYJ1A
PlJIZmP+a+pfR666eShLR3zg3yI/rCRiMx1Ot9KD/Bf1Naci4pi6I+y/nBHx
yHpbUcSQsoin4id4jEb5Z3yd4yIuOXfI+VM86fF6R4v4JLZjB87x7OM5Ih4i
n+P8c/WH2WuvjKiaqRdxh7htSsQtfNRruZ7viG+jfnpEHZJ8y929AnVYhno0
8a6iq7ESa9CAFH+nuvfQrk4HJvJ+Ur9L/BAN6p4xy2J9POTrwgMM1etvub/4
g6P6P6xeq3n2iHfjKq5hHu9cXBd/5rki/qVmN++X7Bn78+1Vo8ad1UggiV0+
g7Q3mTrRvvf94UyhdR9vlMPfi46gvWmN3ifjqXNPsE5fa1Hqjh3m3Ymt2I5t
OMNbRIuRRgZjcZn/rnOd6MALvS7ifaXmS6y3d9beEm/yxlu8xWuM1scAfQzC
QBw3V7l6ZSjFOfkD9vbjgTkazLQaR8y43EyPxbVTfbfoMusuZ86b+QLu86fc
XYjm7PddvpJvodxPuRLr/u4c5Y6+dCTtR3/4LPPUyUcuEijARTOmaCGSuGTd
YsaN4k3YgC3YjK9yH8zcjff4bfZv6p7K1nNvS7YGPZ2tTb/rp0JvU5Cy3qnf
An3noy37fddzM27yz5GfZeY2v6UqOtv6hv298k3o6a1q5RaoVYNXZhrDc4Jn
XsX//xn/AGXxtZw=
         "]],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwt1nmQz3Ucx/EPqzSoyZJr0joj9y5lD/c0mkquivrDilFTKWHd61jHSivH
RixyJUpTbkXN5FhHU4NFOXbRuCZhXWsdCT2+U3885zXvz+f9eV/fz+e3W7Pv
B90HlAgh9CgZwgV6n+bVCyGe9m4fwq3WISxqEkJKsxDKs5Npg+YhZCWEMBVn
moZwFmPbhXDsqRA68f+yVQhfYQW+xko0aBjCdme34Q/njjUIYXh8CP1ahDCC
HmdPt55rfwc683+1rbrQHa/gZRxDsTyZ8l2Q9zwmJoWQgfHIEWcCnS9WIz6N
0RBN0QRr9FKiTQjd9NeaHmOfwJ/2zqGb88fZXelgdVTW88CH+RpSLr0WxZNz
jZpv8EuvE8JNWoRiXLR/nSbIHyNGpdohFDQOIR9txYsVrw2Nkfu+uQTzuqbe
IqTpa6Vzg+lV9hWs0O9yFDqzF3vQj89ZsTPUkGl+k+kF9knr52kmu4v1N5zr
g17ojVScQrlo1uq8oY9ifCTPZHyIVHtT6BqxDqjtIPbjd/yGbH3sdubHWs6p
M4XfFDpAvJn2ZiDZfra5JNGNahmu5qr6zjC/THNPjTFXsT7nuwxLMcT5NOSI
1UbMuXQw+1cxltg/al6HcBgT1XiETqDz1boA89CxfAizxZ+h93vs6XIX8XlH
vGt0GnukezWDXmf3t15MZ7KXOtPd98ixX0utCcneAJ60P956XdqM3RTlU0J4
FMuslVdHLCqyKyAW19Q7Vn/t4kKox6edPPXpbP0EsyiyP87+XHMo8tby3a1i
ejFR7/o9Lt4J5Ef3EwXIVeN6ugHr1bAOa1GD/2prcdGdpOuwFolytpRzgZx3
5PsbPeWuqLcetAqfJDUs5/OgOA9go5kfcG4DLcWOQZ77si96c86cwkmk8bnr
XI6avjW3xbSUuV2K7jxdxO5pPd25auyRdARG4QraOrtYXWXFKoNPfKtZmIFs
zMRRsZaYx1KkPe0uYBB26aO9unfSDjRPrR347qPpYu6wnosu5nGb3Zn+rJ7J
8lTT+zZ3sIo7cq6cOduf5q1mq6cTv/nu7Et0q/Mn6Sj7e8RNFn8v3Wa9nZzb
6Saz2YwfUJdfHdTyu3iY7xGUlu8hLLLeRvxkfq1pIk1CbbWsM5uJ4q2ln6mx
BB3kbEm6kP2NGc6l/zg30PodOoe90n5L5xIRxCqBVeorSVfTArXvjX4r6dvR
b58zzXBUfUewV6xKvn/lGqC39FNKrfP4Npejvf0E+pz7myHHTfurothYg8ei
+46BfHo6M85vwWu0mnynfa/97vNh830kekfi3pZ7lzm/ab676WXxriDbmTgx
npFvqHhpGILBKC3WMrm+wHIMtzYMp7zFzuiChtYboboYWewnaGN2E8wyo67W
Fpvhx/JftfeuPIfVcwTdrGdZv2z9BTO5Qqeyp1t/0blO0ZuP3n/Ur70x7O3e
di62YSd24BBS1Dqezw39FKMVe6H+FmEQ+1PfpLXcc+gOs/rF/mJ7lcw2Pea/
38Tq7uUZvpvNZ7RYH6lxDK1uho8ji53o3EEzGGG+ec6m8W1kvaz9htFvrD5W
ybM6+r3jW4Rp0TsTp6Y+ytAaNA6pzvfCW9Ed1Pc5e32d+4tOYk8yh3H0DLuP
9dN0LLs3/7tmcQ+F3uklvKevy/R9ukXOn6L/B9jjkI4xGI3l4sSrJwHN0CK6
b1irj5L66mUO8ebRQn+FNK+s++3v52Vxmzp7kF9/d6hj9Ibtv67vSnqpjEI+
k9R0iVZlV0F9dj0M08swtRfooZc4W8xqK563PiR6F9Y7mF0+HRr1aL1O9P0R
K04FFIg7nP29770J32FdKXdBjed906P2nxU7n15k51q/+///VP8CVBqtEA==

         "]],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl1WlsVlUQxvHDDkoFYoyhGLGVrSVSkX1rQSRREcXKVuCTUhZFCgJFYwto
RLpSlwJFQ6CvKEYrSIKYIH5TuwAmQFFoC7Jrot0MewL1d+OHf5/OnDkzc+ae
e9+El7PSl7ULIZz35y79YEAI0yaFsGhICFUTQoj1DaGSPp0cwqOpIfRD5tgQ
FuAVHBeXwJf8SAiJdMgTIfyZFMI7E609FsIxJPn/ycQQBtGUYSEUi/nX3la0
4K+UEE6nqZ/gf3tnqvfN+BD2oALfYi9GDtbT4/rBOTnO6ylnaAivDw8hl15g
l/BXW6/BbPHz5Z1D59IMzMOZqJY6efppUrsRG8aEkB8fwnt0lxx7R6uL2IgQ
yrETp5xltt4eNJM2+4eKy1LnGXmm4ln8Yx5NyO4nL52lp0Qx3cx0RXex5vwd
rRW7zPo+fQf1m9ntaBvfa+a4FIvxKpZguFpd5Zqr/h/6yKDn6F3za0MYZz5y
jEBH8e2st8d157mBt/RbIceb9Cr7Gh7WUw+z2W0eTXo8geNYGD1Dtd7V20az
zadN7Av8jTSPPZ1/kX2LsQALkYmL6CXmMr3pPJfoLbpEX0n2JaPeHajDfvnq
9FiP0ziDBmxzrmp7lttTot/x4jbR+6xttRZHy2iBcxeiCCeduRYH5H/Bvul4
Hul4MZqJfNWeZ1F7d4MmxOmR/wfzbrVnLT3FXke/lPuI+Gx2TN009ctpH3W/
sBZPd9PPrW9w1glifzf/atTgF1ShEuvd295iBupxEBLM/G0zn8ZfaoYfqX3D
+nPmcZ1+yE7nr/McTmOp2jf5P+aP8c+yb7v9I+UagWRrhXxJdDh7GGayZ+Ai
isykGBX8X+Mr9NJvHl9Pmk8LUYBRag2WZ7NzXXO+q9FzMI8r7Cp6Rw/D9NTD
GU65w3XucqNZpskzX0y+d3weLZIjXr4++C16NqjFYTl68x3yDPZ1CKGvPPfw
d8P35pul/gHald0F48x5LCqcd5vad+VdJaaNfsLeYx7ltLP11fyd6E72QZpv
XwHGyzMBk+1JpU/Rcj3GOUd3nLGvAf3NfxS7p55G01K97oruiV7LOvru0Svs
5Gh21vuI20iro3eB73Z0z6I7ZmY1yGGfcJbJctfSXPYF64etteirFY1oRhPO
itvsndyCUpRhK3pEPSFm/xS9t3qfcrEWOViPddE3zixieuni7M3Rt4J+xt7L
/2n0jWGv4b8k12VcxzH7juNec+mOQ/o8KebH6F1jx0Wzi2aIhzy3OfY84NwZ
9E707cF2fY3T1xj7BjhfC3sg7Y8ktLIH0Z+ib4mZNrDz6PvYYZ6VA83VPfqZ
lrsT+835frVqrE+KfjeQiolIw1F1Cs2lCAXYhGK011MHlIkZqp+/nWsVVmMl
1iAbMXM4Gz13HJTrdnTf9bbFnErpLXYjf731BqwVf9R79CtqcASHsUhMvNik
6B3EVHck02zewErscKYVztHZ2Yutb0IJZujvJWTam2V9nd/N5bRTyv/fpf8A
nYphnQ==
         "]],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{254, 3237, 16595, 11880, 12751, 11943, 9307, 11944, 11728, 
         12262, 16512, 10725, 12869, 10724, 15699, 15700, 15698, 11727, 16550,
          10902, 12114, 15307, 15292, 15293, 15289, 15291, 15290, 15481, 
         10726, 14868, 14869, 16672, 11058, 15398, 13416, 12666, 10975, 13124,
          10974, 12665, 13386, 12486, 12485, 12894, 10976, 12667, 13432, 
         15408, 15409, 14876, 14877, 10743, 15493, 10742, 14875, 14874, 15407,
          15406, 15581, 12002, 10834, 16619, 16618, 12003, 11999, 12001, 
         16617, 12000, 12848, 10744, 8970, 11734, 11733, 15702, 826, 317, 
         1016, 15704, 11741, 12272, 11740, 16523, 16522, 10756, 12851, 12403, 
         16664, 12404, 12024, 12026, 16621, 16622, 10840, 12025, 10839, 15795,
          8064, 337, 13437, 13438, 12673, 10982, 13152, 12495, 12496, 11115, 
         12502, 12501, 13141, 10988, 12679, 13446, 15431, 11117, 14884, 14883,
          10768, 11369, 15496, 15497, 15294, 15296, 15295, 10851, 12035, 
         10852, 16548, 12034, 15981, 8315, 15982, 12853, 10637, 16495, 11670, 
         11669, 15628, 1059, 652}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl1G1o1WUYx/FrvqxeOAoU1HQvMradPZjb2ePZOWcz3BaZCkaWIVu6J4ci
1YRFi7KEngRRCEukcsp8hFCw0jZdlDpUFJTCpBGR9kZtYUQsV5+DL7773df/
vu7r+t3X+f9X0L5h+fq8iCjyZ1EyIlUc0UjraRM9sCDisYaI+ThZHTGMb3Cl
NOJregLH8RW+xAM1EcWFETMrImZgf1XEEB4siZiw/ydu4w/cwRH1C+sjLui3
Xb+LdAf9pzZid2XE6oSazperW4ansQQNzqUwsTDi8fKISutNRRGzMxFz8K3z
oziNdbyOpfgti/hIzx7xq2r3YRMeUaPP2VesP1Tr7bqId7AF79r7OR0xji18
tvEzqeZO+TXiH/mtoj/Qatrl7s/qE/KnIQ8rxFPm9x8mcQ//Yqdebby2IyUv
jQYk5J+2P4phnMIIXlc7q8dvemXojdxvRT/mZQ/va3ibblYV5rMQ69CbU7Pp
wV/uktUza/2JM5+JP0eTuBEP+72OmU3Ss7s8DMn9xe+2V9xo3YRB6z1ox0vY
5tm43u+Z1fs5PKvUM4l8XtbyNGh/l35P8vp77r2iN+kiOuBOZ9ztLL7HGM5h
pr4DT0S8gU/1OI8yuUsxxNub5rQZb2GC5xecWYXn8DxWoltunR7X9KqlP9F6
eio376x3ibckz0d5+47vGutqVGGjfq/p3Y97mML83LeA63I387fPsxO8bPVO
NfPQ7J4taMWkvWfUXWzdq1aRmsVIYNT5L+z18/IUDy97n5aIS8SXeSyml2iC
drhDpbskUYFqVOEh/Ze6+zIcMuvDSMi9mvue6F7xII6pcRR58sudW4ASlKEU
L8q9zVNav1s0Q+/QYTOqM6Nm/h4VH+FvhO8C63mYiy73KtCv1d50+fnocZdu
dCFjJgd9d7+a0QdmlBY3mEcaGfxtRi3Opqw71Zql5mzMyfXX67C9Pt4X89Ch
Xmft/f9R/wPE3cro
         "]],
        RowBox[{"-", "0.5`"}]],
       Annotation[#, -0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl1F9olmUYx/EryAgiD8rMFJTMsswt9za3ubb3nbX2553uH4Xikc7UWm7L
DmSbCgqmFZOioyg0glybElMJolDmcuqBYGkkHSRNUDQ7yU2d+6P2eejgu991
P/d9X9fvup7n3dNNbY2tD0REjj81BRGvvxhRTctpln6XF5FOR2QwWBRxCidx
OTfiZ3oC/RjAcTyyRK4XImbmRzyFg4URB/BoTsRt+6MYwS3cRJ/8qZKI8+p9
od5v9Es6Xhzx1eKI1QvldD8lbx7qUI8y9zIYfjni+UURBeKOBRGzyyLm4JT7
JzGIFl7PlEYcfSniczU3WnfI3YkteEKOdnfbxZ/ItfuViA/xET62N5SJuITd
fDbxMynnXXTzeZHfb+ifdD9t1vsUZx/CXbXu4x5WqT1BJ3EH4xjDWl479NOJ
6ZiBJ5Fy/rr9f3AVf+MaJuyNYwzFSyP+VbeCrxu0T/0Hed6vj7f5nGluRc4V
ogWtCebUglF9Vem1QrxX793W3ybPrCsxzbv7wZwKPRvlpdfZK97hAetqcRa9
4h6sw3p85tmQ2l087EGXZ0sSn5jFSzNP3fb3qZfleYTnKjqcfHN0p9n94jv7
FWdxHucwR93tqYgd+FqNc1jkbAN6edtp1rvwQTJznt9yZx3WYC2a8K6zaTX+
UquUDtEMHTD/tDnW8lbK8/e8nea7TJxBGpvV26b2VtxHJN+cGc3HRfEu/no8
P8bLp95RDQ/1+mxAIybtvSlvnbg18S5nHlI44f4Re1t4WcbDZt/VG9YF1hd4
zKe/08V0gx5q9VKH5WhAPaaqv0LvK3HIrA8j19k/+FuQzMi6Bz/J8SMedr7a
vSwqUIXKZE7ODvNUqd4NWkVHaL8ZlZhRlr9nrQ/xN5DMQDwfz6FZX/PUW2bv
Mecfx/t62YT3UGkmh/0Gr5rRHjOqsH7VPF5DOcbNqMbdpeJ35Jor5zOYh+Nq
9SW/T96reWiVr634//9X/wEbeNa9
         "]],
        RowBox[{"-", "0.5`"}]],
       Annotation[#, -0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl1FtM1nUcx/Ev6qaSitZEnblpVyoeAjUVPDyeuksQ8EYOYYU8IIm66Uqb
bTxON9BVVhBu3rQmB928yKwsxogudBGkpqAXHi8sD1feNJfl65kXbz6/7+/w
/X5+39//YdY7DcU7MiJirj/1b0QczImooym6nXbnRnywKuJD/LEs4jIuYczC
iAE6iN/wO/oxbnnEijkRCxZHzMfAUmvYMD9ipLVRCIxABnrl37Qi4pl636r3
Hz1Lswoi2pfwNC/iNedX27sKpdiMQuc24smiiNzXIwqMm+dGzExEzMKVfF5x
CakFEfdWRgzxfILHRnGz3EdwFDPkaHK2yfhzuT5V+zMcwyfWHq2OeIwjfO7g
J9v8N/ZXiseIy+loWkG73H2rOpPsfwUvo0qcRSdiHCZgPI6r9R6v1VgrXo91
SNh/V7/v4Rbu4DZ65a5VY7JaSZpN62g7L5287xLP1qt1+rMWe7AXO/WmAf+4
S5maxcYdzpwVf4dScQkmp99LbxLmxtp3Bv97tx/E5cYV+N74HGpRh1ZzD9Vu
0ZPWdN/MrVdzA+bwspunLuud6r3P61TxdjqF1tNf3Okvd/sb9/EQD1Cs7qG8
iMP4Wo3bSNi7Baf1pyn9HmjGDPEpZ06jA13oxCl7q9TIVOtt+hLdSvv0O7HG
dySu4bmHt8H0fYxrkURKvZTajciyNhF5epSLm+m+8TdobVjtL3xT7+rbNves
QRLj7amXt9r4Y7nK5axAJfqtdVtr5KWEh5O+0Xb87LvPEJ+nQX+iHe7Q6C4p
DKtzA9fxpvrT9fhVLPRuV+lKe5/yl0/nmcvBr96gDwX2X3NuCFdwFX+izd5M
Pg753e1U7zDdRY/zc8B8ER9FPJ/n9yLfJcbF2IT97pWjXtLaVD2dhjbnvkIr
yvSkx+/uXz06ptYWcbl+VKASY+WrcbbMeJ9cb8m5EYW4YO1Hax/xUMjDl/K1
5L/4H/Uce3/N3Q==
         "]],
        RowBox[{"-", "0.5`"}]],
       Annotation[#, -0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl1F1M1XUcx/GvMa02IHPLx3IpV2mpiJWiAacLpLtgKKAXxUFxNeHwEOqF
zrVgqyUPRSjqQs3N+QCbdwIqY642H+YKL3wo03y4RPFCq3XBep158T6f3/f/
+/6+38/ve/7nLEimyuqnRMQiHy3vRexZHNFMv6Vf0NHciI6CiE78tTLiPu5h
xtKIO/Qu/sCfuI2sVREFb0XkrohYht/ej/gVa9+JeMney5iKFzENF9SvWBPx
wtsR5/XLoCP0tdURx9+NqBPnOJ+QW4T1qECpcx/jaV7EimURa9I+F0UsLJKP
W/kRN3EDbUsiHn7gGc99PLaKO9XuwneYr0a7sx3WPWp16/0DetBl73FhxATa
+UzxM8vzY/I3ibPESZpJa2i/u9fqM0/+G3gdm8Vz6FzMxGzMwkG9anndgmJx
CdaiWP6EeT/BOB7jES6qndLjTb3q6QLaQE/ycor3FvHy9KzNpxjbsQPNZtOE
/9wlqWeF9SlnhsTDqBJXYqbva8xsEp5lyzuNDPF5cY31JpyzPoutqEOvZ+N6
95rJfnzvWYmeHyGPl2089dvv16+Z1xxxI11Im+gld3rmbn/jKf7FP6j0vny9
POIbHNXjARJyN2LAfNrNqRMdyBEPO3MWZzCEQQykvws9XtFrM51Ot9CfzTuR
8C6l58jzKG9jfDdaNyCFNv3a9G7Fq/ZmpN8zM8rDXetB/sbs/a73Xu9UrTnV
u2cKDciWk1K3zvpLtarVTKIGV+2N2PuKl3IeBryj9eKN4mniKjqVbqAn3KHP
XQ7hRxzBYZTo3+juTbhp1rdQKHeSv9X0mngMN9S4jg/l73fuAPaiF/twVG6W
/Q6/90zaSbPpBTMqNKMyPip4PsffFb43WFehErvca4l+n9ubK38efnKXIziM
pJn84nc3aUbdZlQt/tQ8qpFEpnqfOfuJ9U61ytVch/W4nH7P7O3mpZSHPvUO
5T//j/ofry/PyA==
         "]],
        RowBox[{"-", "0.5`"}]],
       Annotation[#, -0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{13746, 11389, 14140, 12543, 14136, 11386, 13744, 14137, 
         14138, 11387, 13743, 13742, 13741, 11385, 12748, 12747, 13895, 11070,
          13894, 13893, 15308, 11017, 15310, 15309, 16561, 16560, 15145, 
         13884, 16742, 11049, 15336, 11048, 16686, 13889, 11067, 15340, 10571,
          12521, 11520, 13307, 11519, 14239, 12469, 13309, 13308, 11989, 
         14682, 14683, 14681, 12395, 16455, 13123, 15264, 15263, 15262, 12170,
          16173, 11643, 14220, 11469, 13784, 14221, 14222, 11470, 13783, 
         13782, 13781, 11468, 12523, 10574, 14763, 14762, 13904, 11082, 13903,
          11083, 13905, 15234, 13785, 15314, 15315, 11021, 13875, 13387, 
         13388, 14770, 14771, 12763, 12764, 11541, 13319, 11540, 14253, 12473,
          13321, 13320, 12119, 14694, 14695, 14693, 12430, 16477, 13151, 
         15276, 15275, 15274, 12182, 16192, 11650, 12878, 11432, 13266, 12642,
          12643, 11436, 12444, 16556, 10961, 13166, 10962, 16178, 16179, 
         16177, 12174, 14607, 14606, 13920, 11111, 13919, 11112, 14194, 11434,
          14192, 11433, 14193, 11435, 14195, 11114, 15365, 11113, 16690, 
         14777, 14778, 14779, 12773, 12774, 11439, 13777, 14197, 14198, 11440,
          12081, 16627, 12080, 13140, 10957, 16552, 12175, 13805, 12872, 
         11406, 13252, 12634, 12635, 12018, 14535, 16708, 11542, 15549, 11543,
          12766, 12765, 13987, 11225, 13907, 11089, 13906, 11090, 14147, 
         11393, 14145, 11392, 14146, 11394, 14148, 11088, 15354, 11087, 16688,
          13977, 11215, 15402, 12758, 12759, 11388, 13745, 14141, 14142, 
         11390, 13748, 13747, 13746}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{13755, 11400, 14153, 12544, 14149, 11397, 13753, 14150, 
         14151, 11398, 13752, 13751, 13750, 11396, 12754, 12753, 13902, 11078,
          13901, 13900, 15311, 11018, 15313, 15312, 16563, 16562, 15151, 
         13887, 16743, 11061, 15339, 11060, 16687, 13896, 11075, 15344, 10573,
          12522, 11527, 13310, 11526, 14244, 12470, 13312, 13311, 12005, 
         14685, 14686, 14684, 12397, 16456, 13125, 15267, 15266, 15265, 12171,
          16174, 11647, 14224, 11474, 13789, 14225, 14226, 11475, 13788, 
         13787, 13786, 11473, 12524, 10575, 14767, 14766, 13909, 11091, 13908,
          11092, 13910, 15235, 13790, 15316, 15317, 11022, 13876, 13389, 
         13390, 14772, 14773, 12767, 12768, 11548, 13322, 11547, 14254, 12474,
          13324, 13323, 12123, 14697, 14698, 14696, 12432, 16478, 13153, 
         15279, 15278, 15277, 12183, 16193, 11653, 12880, 11441, 13267, 12644,
          12645, 11445, 12445, 16557, 10963, 13167, 10964, 16181, 16182, 
         16180, 12176, 14609, 14608, 13922, 11118, 13921, 11119, 14201, 11443,
          14199, 11442, 14200, 11444, 14202, 11121, 15366, 11120, 16691, 
         14784, 14785, 14786, 12779, 12780, 11448, 13778, 14204, 14205, 11449,
          12087, 16628, 12086, 13144, 10958, 16553, 12177, 13806, 12873, 
         11407, 13254, 12636, 12637, 12030, 14536, 16710, 11549, 15552, 11550,
          12770, 12769, 13993, 11230, 13913, 11100, 13912, 11101, 14160, 
         11404, 14158, 11403, 14159, 11405, 14161, 11099, 15357, 11098, 16689,
          13984, 11220, 15411, 12761, 12762, 11399, 13754, 14154, 14155, 
         11401, 13757, 13756, 13755}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{13764, 11413, 14168, 12559, 14164, 11410, 13762, 14165, 
         14166, 11411, 13761, 13760, 13759, 11409, 12788, 12787, 13935, 11141,
          13934, 13933, 15320, 11026, 15322, 15321, 16565, 16564, 15195, 
         13925, 16744, 11127, 15367, 11126, 16692, 13929, 11138, 15369, 10581,
          12529, 11578, 13313, 11577, 14274, 12471, 13315, 13314, 12041, 
         14688, 14689, 14687, 12414, 16469, 13131, 15270, 15269, 15268, 12172,
          16175, 11694, 14228, 11479, 13796, 14229, 14230, 11480, 13795, 
         13794, 13793, 11478, 12531, 10584, 14804, 14803, 13946, 11156, 13945,
          11157, 13947, 15246, 13797, 15326, 15327, 11030, 13879, 13395, 
         13396, 14810, 14811, 12801, 12802, 11599, 13325, 11598, 14290, 12475,
          13327, 13326, 12130, 14704, 14705, 14703, 12436, 16479, 13159, 
         15282, 15281, 15280, 12184, 16197, 11700, 12882, 11450, 13270, 12646,
          12647, 11454, 12446, 16558, 10965, 13168, 10966, 16184, 16185, 
         16183, 12178, 14611, 14610, 13962, 11187, 13961, 11188, 14208, 11452,
          14206, 11451, 14207, 11453, 14209, 11190, 15394, 11189, 16696, 
         14815, 14816, 14817, 12812, 12813, 11457, 13779, 14211, 14212, 11458,
          12101, 16631, 12100, 13147, 10959, 16554, 12179, 13807, 12876, 
         11430, 13262, 12638, 12639, 12062, 14564, 16713, 11600, 15576, 11601,
          12804, 12803, 14022, 11273, 13949, 11163, 13948, 11164, 14175, 
         11417, 14173, 11416, 14174, 11418, 14176, 11162, 15383, 11161, 16694,
          14009, 11263, 15443, 12795, 12796, 11412, 13763, 14169, 14170, 
         11414, 13766, 13765, 13764}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{13774, 11424, 14181, 12560, 14177, 11421, 13772, 14178, 
         14179, 11422, 13771, 13770, 13769, 11420, 12791, 12790, 13944, 11149,
          13943, 13942, 15323, 11027, 15325, 15324, 16567, 16566, 15200, 
         13928, 16745, 11133, 15368, 11132, 16693, 13938, 11146, 15371, 10583,
          12530, 11585, 13316, 11584, 14281, 12472, 13318, 13317, 12051, 
         14691, 14692, 14690, 12416, 16470, 13133, 15273, 15272, 15271, 12173,
          16176, 11697, 14232, 11484, 13801, 14233, 14234, 11485, 13800, 
         13799, 13798, 11483, 12532, 10585, 14807, 14806, 13951, 11166, 13950,
          11167, 13952, 15247, 13802, 15328, 15329, 11031, 13880, 13397, 
         13398, 14812, 14813, 12805, 12806, 11605, 13328, 11604, 14293, 12476,
          13330, 13329, 12135, 14707, 14708, 14706, 12438, 16480, 13160, 
         15285, 15284, 15283, 12185, 16201, 11703, 12884, 11459, 13271, 12648,
          12649, 11463, 12447, 16559, 10967, 13169, 10968, 16187, 16188, 
         16186, 12180, 14613, 14612, 13964, 11195, 13963, 11196, 14215, 11461,
          14213, 11460, 14214, 11462, 14216, 11198, 15395, 11197, 16697, 
         14819, 14820, 14821, 12820, 12821, 11466, 13780, 14218, 14219, 11467,
          12107, 16632, 12106, 13150, 10960, 16555, 12181, 13808, 12877, 
         11431, 13264, 12640, 12641, 12068, 14565, 16714, 11606, 15579, 11607,
          12808, 12807, 14025, 11278, 13955, 11174, 13954, 11175, 14188, 
         11428, 14186, 11427, 14187, 11429, 14189, 11173, 15386, 11172, 16695,
          14019, 11268, 15448, 12799, 12800, 11423, 13773, 14182, 14183, 
         11425, 13776, 13775, 13774}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{12947, 11993, 15915, 11992, 15916, 15923, 15922, 14139, 
         10739, 13519, 13518, 13974, 13973, 14332, 13975, 13976, 13520, 14143,
          16516, 10740, 14144, 15931, 15932, 15930, 11994, 15929, 11995, 
         12951, 12950, 16285, 12212, 16284, 12213, 16286, 11391, 16460, 12400,
          15155, 15156, 15157, 13126, 13127, 12016, 15958, 12015, 15959, 
         15966, 15965, 14162, 10754, 13527, 13526, 13986, 13985, 14335, 12146,
          16639, 12147, 11655, 12224, 16492, 10609, 12879, 10608, 16069, 
         12078, 16068, 12079, 13139, 13138, 15223, 15222, 16067, 12077, 15258,
          10949, 15359, 11105, 15358, 11104, 15518, 11488, 16581, 11489, 
         11438, 15502, 11437, 15503, 10606, 14196, 10607, 13440, 13439, 13916,
          13915, 14334, 12158, 16643, 12159, 11737, 12271, 16521, 10753, 
         12886, 10752, 16122, 12115, 16121, 12116, 12949, 12948, 16162, 12154,
          16161, 12155, 16163, 10953, 15353, 11085, 15352, 11084, 15522, 
         11496, 16585, 11497, 11472, 15510, 11471, 15511, 10737, 14223, 10738,
          13517, 13516, 13638, 16676, 13637, 16677, 10829, 12138, 16635, 
         12139, 11732, 12265, 16515, 10736, 12870, 15913, 15914, 15912, 11990,
          15911, 11991, 12945, 12944, 16282, 12210, 16281, 12211, 16283, 
         11384, 15607, 11645, 15606, 11644, 12946, 12947}],
        RowBox[{"-", "1.5`"}]],
       Annotation[#, -1.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{12959, 12009, 15940, 12008, 15941, 15948, 15947, 14152, 
         10748, 13524, 13523, 13981, 13980, 14333, 13982, 13983, 13525, 14156,
          16519, 10749, 14157, 15956, 15957, 15955, 12010, 15954, 12011, 
         12963, 12962, 16291, 12216, 16290, 12217, 16292, 11402, 16461, 12405,
          15162, 15163, 15164, 13128, 13129, 12028, 15967, 12027, 15968, 
         15975, 15974, 14163, 10759, 13529, 13528, 13992, 13991, 14337, 12148,
          16640, 12149, 11658, 12226, 16493, 10615, 12881, 10614, 16077, 
         12084, 16076, 12085, 13143, 13142, 15225, 15224, 16075, 12083, 15259,
          10950, 15361, 11107, 15360, 11106, 15519, 11490, 16582, 11491, 
         11447, 15504, 11446, 15505, 10612, 14203, 10613, 13442, 13441, 13918,
          13917, 14336, 12160, 16644, 12161, 11742, 12273, 16524, 10758, 
         12887, 10757, 16132, 12120, 16131, 12121, 12961, 12960, 16165, 12156,
          16164, 12157, 16166, 10954, 15356, 11094, 15355, 11093, 15523, 
         11498, 16586, 11499, 11477, 15512, 11476, 15513, 10746, 14227, 10747,
          13522, 13521, 13646, 16678, 13645, 16679, 10835, 12140, 16636, 
         12141, 11735, 12268, 16518, 10745, 12871, 15938, 15939, 15937, 12006,
          15936, 12007, 12957, 12956, 16288, 12214, 16287, 12215, 16289, 
         11395, 15612, 11649, 15611, 11648, 12958, 12959}],
        RowBox[{"-", "1.5`"}]],
       Annotation[#, -1.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{12990, 12045, 15998, 12044, 15999, 16001, 16000, 14167, 
         10787, 13581, 13580, 14006, 14005, 14347, 14007, 14008, 13582, 14171,
          16531, 10788, 14172, 16006, 16007, 16005, 12046, 16004, 12047, 
         12994, 12993, 16326, 12241, 16325, 12242, 16327, 11415, 16473, 12418,
          15204, 15205, 15206, 13134, 13135, 12060, 16038, 12059, 16039, 
         16046, 16045, 14190, 10806, 13589, 13588, 14021, 14020, 14350, 12150,
          16641, 12151, 11705, 12253, 16504, 10675, 12883, 10674, 16102, 
         12098, 16101, 12099, 13146, 13145, 15231, 15230, 16100, 12097, 15260,
          10951, 15388, 11179, 15387, 11178, 15520, 11492, 16583, 11493, 
         11456, 15506, 11455, 15507, 10672, 14210, 10673, 13480, 13479, 13958,
          13957, 14349, 12166, 16645, 12167, 11769, 12293, 16538, 10805, 
         12888, 10804, 16139, 12126, 16138, 12127, 12992, 12991, 16168, 12162,
          16167, 12163, 16169, 10955, 15382, 11159, 15381, 11158, 15524, 
         11500, 16587, 11501, 11482, 15514, 11481, 15515, 10785, 14231, 10786,
          13579, 13578, 13668, 16680, 13667, 16681, 10859, 12142, 16637, 
         12143, 11761, 12287, 16530, 10784, 12874, 15996, 15997, 15995, 12042,
          15994, 12043, 12988, 12987, 16323, 12239, 16322, 12240, 16324, 
         11408, 15665, 11696, 15664, 11695, 12989, 12990}],
        RowBox[{"-", "1.5`"}]],
       Annotation[#, -1.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{13000, 12055, 16020, 12054, 16021, 16028, 16027, 14180, 
         10799, 13586, 13585, 14016, 14015, 14348, 14017, 14018, 13587, 14184,
          16535, 10800, 14185, 16036, 16037, 16035, 12056, 16034, 12057, 
         13004, 13003, 16332, 12245, 16331, 12246, 16333, 11426, 16474, 12420,
          15211, 15212, 15213, 13136, 13137, 12066, 16053, 12065, 16054, 
         16061, 16060, 14191, 10810, 13591, 13590, 14024, 14023, 14352, 12152,
          16642, 12153, 11708, 12255, 16505, 10683, 12885, 10682, 16115, 
         12104, 16114, 12105, 13149, 13148, 15233, 15232, 16113, 12103, 15261,
          10952, 15390, 11182, 15389, 11181, 15521, 11494, 16584, 11495, 
         11465, 15508, 11464, 15509, 10680, 14217, 10681, 13482, 13481, 13960,
          13959, 14351, 12168, 16646, 12169, 11772, 12294, 16540, 10809, 
         12889, 10808, 16149, 12131, 16148, 12132, 13002, 13001, 16171, 12164,
          16170, 12165, 16172, 10956, 15385, 11169, 15384, 11168, 15525, 
         11502, 16588, 11503, 11487, 15516, 11486, 15517, 10797, 14235, 10798,
          13584, 13583, 13676, 16682, 13675, 16683, 10861, 12144, 16638, 
         12145, 11766, 12289, 16534, 10796, 12875, 16018, 16019, 16017, 12052,
          16016, 12053, 12998, 12997, 16329, 12243, 16328, 12244, 16330, 
         11419, 15670, 11699, 15669, 11698, 12999, 13000}],
        RowBox[{"-", "1.5`"}]],
       Annotation[#, -1.5, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  ImageMargins->0.,
  ImageSize->Small,
  PlotRange->
   NCache[{{0, 4 Pi}, {0, 4 Pi}}, {{0, 12.566370614359172`}, {
     0, 12.566370614359172`}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->770387655]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->329450293],

Cell["Plot an equation: ", "ExampleText",
 CellID->2437665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "+", 
     RowBox[{"Cos", "[", "y", "]"}]}], "\[Equal]", 
    RowBox[{"1", "/", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19169],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdmnlYVdXbho+alVp2mA8IhwPCAUwxxTGtvVQ0csA0nDPHHHAAtHLIIf2R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   "], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     TooltipBox[
      LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
       19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
        37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49}],
      RowBox[{
        RowBox[{
          RowBox[{"Cos", "[", "x", "]"}], "+", 
          RowBox[{"Cos", "[", "y", "]"}]}], "\[Equal]", 
        FractionBox["1", "2"]}]], 
     TooltipBox[
      LineBox[{50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65,
        66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 
       83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 
       100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 
       114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
       128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 
       142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 
       156, 157}],
      RowBox[{
        RowBox[{
          RowBox[{"Cos", "[", "x", "]"}], "+", 
          RowBox[{"Cos", "[", "y", "]"}]}], "\[Equal]", 
        FractionBox["1", "2"]}]], 
     TooltipBox[
      LineBox[{158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 
       170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 
       184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 
       198, 199, 200, 201, 202, 203, 204, 205, 206}],
      RowBox[{
        RowBox[{
          RowBox[{"Cos", "[", "x", "]"}], "+", 
          RowBox[{"Cos", "[", "y", "]"}]}], "\[Equal]", 
        FractionBox["1", "2"]}]], 
     TooltipBox[
      LineBox[{207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 
       219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 
       233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 
       247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 
       261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 
       275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 
       289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 
       303, 304, 305, 306, 307, 308, 309, 310, 311}],
      RowBox[{
        RowBox[{
          RowBox[{"Cos", "[", "x", "]"}], "+", 
          RowBox[{"Cos", "[", "y", "]"}]}], "\[Equal]", 
        FractionBox["1", "2"]}]], 
     TooltipBox[
      LineBox[{312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 
       324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 
       338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 
       352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 
       366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379, 
       380, 381, 382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393, 
       394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404, 405, 406, 407, 
       408, 409, 410, 411, 412, 413, 414}],
      RowBox[{
        RowBox[{
          RowBox[{"Cos", "[", "x", "]"}], "+", 
          RowBox[{"Cos", "[", "y", "]"}]}], "\[Equal]", 
        FractionBox["1", "2"]}]], 
     TooltipBox[
      LineBox[{415, 416, 417, 418, 419, 420, 421, 422, 423, 424, 425, 426, 
       427, 428, 429, 430, 431, 432, 433, 434, 435, 436, 437, 438, 439, 440, 
       441, 442, 443, 444, 445, 446, 447, 448, 449, 450, 451, 452, 453, 454, 
       455, 456, 457, 458}],
      RowBox[{
        RowBox[{
          RowBox[{"Cos", "[", "x", "]"}], "+", 
          RowBox[{"Cos", "[", "y", "]"}]}], "\[Equal]", 
        FractionBox["1", "2"]}]], 
     TooltipBox[
      LineBox[{459, 460, 461, 462, 463, 464, 465, 466, 467, 468, 469, 470, 
       471, 472, 473, 474, 475, 476, 477, 478, 479, 480, 481, 482, 483, 484, 
       485, 486, 487, 488, 489, 490, 491, 492, 493, 494, 495, 496, 497, 498, 
       499, 500, 501, 502, 503, 504, 505, 506, 507, 508, 509, 510, 511, 512, 
       513, 514, 515, 516, 517, 518, 519, 520, 521, 522, 523, 524, 525, 526, 
       527, 528, 529, 530, 531, 532, 533, 534, 535, 536, 537, 538, 539, 540, 
       541, 542, 543, 544, 545, 546, 547, 548, 549, 550, 551, 552, 553, 554, 
       555, 556, 557, 558, 559}],
      RowBox[{
        RowBox[{
          RowBox[{"Cos", "[", "x", "]"}], "+", 
          RowBox[{"Cos", "[", "y", "]"}]}], "\[Equal]", 
        FractionBox["1", "2"]}]], 
     TooltipBox[
      LineBox[{560, 561, 562, 563, 564, 565, 566, 567, 568, 569, 570, 571, 
       572, 573, 574, 575, 576, 577, 578, 579, 580, 581, 582, 583, 584, 585, 
       586, 587, 588, 589, 590, 591, 592, 593, 594, 595, 596, 597, 598, 599, 
       600, 601, 602, 603, 604, 605}],
      RowBox[{
        RowBox[{
          RowBox[{"Cos", "[", "x", "]"}], "+", 
          RowBox[{"Cos", "[", "y", "]"}]}], "\[Equal]", 
        FractionBox["1", "2"]}]], 
     TooltipBox[
      LineBox[{606, 607, 608, 609, 610, 611, 612, 613, 614, 615, 616, 617, 
       618, 619, 620, 621, 622, 623, 624, 625, 626, 627, 628, 629, 630, 631, 
       632, 633, 634, 635, 636, 637, 638, 639, 640, 641, 642, 643, 644, 645, 
       646, 647, 648, 649, 650, 651, 652, 653, 654, 655, 656, 657, 658, 659, 
       660, 661, 662, 663, 664, 665, 666, 667, 668, 669, 670, 671, 672, 673, 
       674, 675, 676, 677, 678, 679, 680, 681, 682, 683, 684, 685, 686, 687, 
       688, 689, 690, 691, 692, 693, 694, 695, 696, 697, 698, 699, 700, 701, 
       702, 703, 704, 705, 706, 707, 708, 709, 710, 711, 712, 713, 714, 715, 
       716, 717, 718, 719, 720, 721, 722, 723, 724, 725, 726, 727, 728, 729, 
       730, 731, 732, 733, 734, 735, 736, 737, 738, 739, 740, 741, 742, 743, 
       744, 745, 746, 747, 748, 749, 750, 751, 752, 753, 754, 755, 756, 757, 
       758, 759, 760, 761, 762, 763, 764, 765, 766, 767, 768, 769, 770, 771, 
       772, 773, 774, 775, 776, 777, 778, 779, 780, 781, 782, 783, 784, 785, 
       786, 787, 788, 789, 790, 791, 792, 793, 794, 795, 796, 797, 798, 799, 
       800, 801, 802, 803, 804, 805, 806, 807, 808, 809, 810, 811, 812, 813, 
       814, 815, 816, 817, 818, 819, 820, 821, 822, 823, 824, 825, 826, 827, 
       828, 829, 830, 831, 832, 833, 834, 835}],
      RowBox[{
        RowBox[{
          RowBox[{"Cos", "[", "x", "]"}], "+", 
          RowBox[{"Cos", "[", "y", "]"}]}], "\[Equal]", 
        FractionBox["1", "2"]}]]}}],
  AspectRatio->1,
  Frame->True,
  FrameTicks->True,
  Method->{},
  PlotRange->{{0, 4 Pi}, {0, 4 Pi}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15724]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->690317286],

Cell["Plot several equations:", "ExampleText",
 CellID->1773672102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Abs", "[", 
       RowBox[{
        RowBox[{"Sin", "[", "x", "]"}], 
        RowBox[{"Sin", "[", "y", "]"}]}], "]"}], "\[Equal]", "0.5"}], ",", 
     RowBox[{
      RowBox[{"Abs", "[", 
       RowBox[{
        RowBox[{"Cos", "[", "x", "]"}], 
        RowBox[{"Cos", "[", "y", "]"}]}], "]"}], "\[Equal]", "0.5"}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1022546428],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx1nHdcVEe0x3fZpcQuUewtYolYY4tGndGo2I0Qe8USe6/RxIg1ahRBBcyz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   "], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     TagBox[
      TooltipBox[
       LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
         19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 
        36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 
        53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
        70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
        87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 
        103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 
        117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 
        131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 
        145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155}],
       RowBox[{
         RowBox[{"Abs", "[", 
           RowBox[{
             RowBox[{"Sin", "[", "x", "]"}], " ", 
             RowBox[{"Sin", "[", "y", "]"}]}], "]"}], "\[Equal]", "0.5`"}]],
      Annotation[#, Abs[Sin[$CellContext`x] Sin[$CellContext`y]] == 0.5, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       LineBox[{156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 
        168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 
        182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 
        196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 
        210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 
        224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 
        238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 
        252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 
        266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 
        280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 
        294, 295, 296, 297, 298, 299}],
       RowBox[{
         RowBox[{"Abs", "[", 
           RowBox[{
             RowBox[{"Sin", "[", "x", "]"}], " ", 
             RowBox[{"Sin", "[", "y", "]"}]}], "]"}], "\[Equal]", "0.5`"}]],
      Annotation[#, Abs[Sin[$CellContext`x] Sin[$CellContext`y]] == 0.5, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       LineBox[{300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 
        312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 
        326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 
        340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 
        354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 
        368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379, 380, 381, 
        382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393, 394, 395, 
        396, 397, 398, 399, 400, 401, 402, 403, 404, 405, 406, 407, 408, 409, 
        410, 411, 412, 413, 414, 415, 416, 417, 418, 419, 420, 421, 422, 423, 
        424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 434, 435, 436, 437, 
        438, 439, 440, 441, 442, 443, 444, 445, 446, 447, 448, 449, 450, 
        451}],
       RowBox[{
         RowBox[{"Abs", "[", 
           RowBox[{
             RowBox[{"Sin", "[", "x", "]"}], " ", 
             RowBox[{"Sin", "[", "y", "]"}]}], "]"}], "\[Equal]", "0.5`"}]],
      Annotation[#, Abs[Sin[$CellContext`x] Sin[$CellContext`y]] == 0.5, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       LineBox[{452, 453, 454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 
        464, 465, 466, 467, 468, 469, 470, 471, 472, 473, 474, 475, 476, 477, 
        478, 479, 480, 481, 482, 483, 484, 485, 486, 487, 488, 489, 490, 491, 
        492, 493, 494, 495, 496, 497, 498, 499, 500, 501, 502, 503, 504, 505, 
        506, 507, 508, 509, 510, 511, 512, 513, 514, 515, 516, 517, 518, 519, 
        520, 521, 522, 523, 524, 525, 526, 527, 528, 529, 530, 531, 532, 533, 
        534, 535, 536, 537, 538, 539, 540, 541, 542, 543, 544, 545, 546, 547, 
        548, 549, 550, 551, 552, 553, 554, 555, 556, 557, 558, 559, 560, 561, 
        562, 563, 564, 565, 566, 567, 568, 569, 570, 571, 572, 573, 574, 575, 
        576, 577, 578, 579, 580, 581, 582, 583, 584, 585, 586, 587, 588, 589, 
        590, 591, 592, 593, 594, 595, 596}],
       RowBox[{
         RowBox[{"Abs", "[", 
           RowBox[{
             RowBox[{"Sin", "[", "x", "]"}], " ", 
             RowBox[{"Sin", "[", "y", "]"}]}], "]"}], "\[Equal]", "0.5`"}]],
      Annotation[#, Abs[Sin[$CellContext`x] Sin[$CellContext`y]] == 0.5, 
       "Tooltip"]& ]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], 
     TagBox[
      TooltipBox[
       LineBox[{597, 598, 599, 600, 601, 602, 603, 604, 605, 606, 607, 608, 
        609, 610, 611, 612, 613, 614, 615, 616, 617, 618, 619, 620, 621, 622, 
        623, 624, 625, 626, 627, 628, 629}],
       RowBox[{
         RowBox[{"Abs", "[", 
           RowBox[{
             RowBox[{"Cos", "[", "x", "]"}], " ", 
             RowBox[{"Cos", "[", "y", "]"}]}], "]"}], "\[Equal]", "0.5`"}]],
      Annotation[#, Abs[Cos[$CellContext`x] Cos[$CellContext`y]] == 0.5, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       LineBox[{630, 631, 632, 633, 634, 635, 636, 637, 638, 639, 640, 641, 
        642, 643, 644, 645, 646, 647, 648, 649, 650, 651, 652, 653, 654, 655, 
        656, 657, 658, 659, 660, 661, 662, 663, 664, 665, 666, 667}],
       RowBox[{
         RowBox[{"Abs", "[", 
           RowBox[{
             RowBox[{"Cos", "[", "x", "]"}], " ", 
             RowBox[{"Cos", "[", "y", "]"}]}], "]"}], "\[Equal]", "0.5`"}]],
      Annotation[#, Abs[Cos[$CellContext`x] Cos[$CellContext`y]] == 0.5, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       LineBox[{668, 669, 670, 671, 672, 673, 674, 675, 676, 677, 678, 679, 
        680, 681, 682, 683, 684, 685, 686, 687, 688, 689, 690, 691, 692, 693, 
        694, 695, 696, 697, 698, 699, 700, 701, 702, 703, 704, 705, 706, 707, 
        708, 709, 710}],
       RowBox[{
         RowBox[{"Abs", "[", 
           RowBox[{
             RowBox[{"Cos", "[", "x", "]"}], " ", 
             RowBox[{"Cos", "[", "y", "]"}]}], "]"}], "\[Equal]", "0.5`"}]],
      Annotation[#, Abs[Cos[$CellContext`x] Cos[$CellContext`y]] == 0.5, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       LineBox[{711, 712, 713, 714, 715, 716, 717, 718, 719, 720, 721, 722, 
        723, 724, 725, 726, 727, 728, 729, 730, 731, 732, 733, 734, 735, 736, 
        737, 738, 739, 740, 741, 742, 743, 744, 745, 746, 747, 748, 749, 750, 
        751, 752, 753, 754, 755, 756, 757, 758, 759, 760}],
       RowBox[{
         RowBox[{"Abs", "[", 
           RowBox[{
             RowBox[{"Cos", "[", "x", "]"}], " ", 
             RowBox[{"Cos", "[", "y", "]"}]}], "]"}], "\[Equal]", "0.5`"}]],
      Annotation[#, Abs[Cos[$CellContext`x] Cos[$CellContext`y]] == 0.5, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       LineBox[{761, 762, 763, 764, 765, 766, 767, 768, 769, 770, 771, 772, 
        773, 774, 775, 776, 777, 778, 779, 780, 781, 782, 783, 784, 785, 786, 
        787, 788, 789, 790, 791, 792, 793, 794, 795, 796, 797, 798, 799, 800, 
        801, 802, 803, 804, 805, 806, 807, 808, 809, 810, 811, 812, 813, 814, 
        815, 816, 817, 818, 819, 820, 821, 822, 823, 824, 825, 826, 827, 828, 
        829, 830, 831, 832, 833, 834, 835, 836, 837, 838, 839, 840, 841, 842, 
        843, 844}],
       RowBox[{
         RowBox[{"Abs", "[", 
           RowBox[{
             RowBox[{"Cos", "[", "x", "]"}], " ", 
             RowBox[{"Cos", "[", "y", "]"}]}], "]"}], "\[Equal]", "0.5`"}]],
      Annotation[#, Abs[Cos[$CellContext`x] Cos[$CellContext`y]] == 0.5, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       LineBox[{845, 846, 847, 848, 849, 850, 851, 852, 853, 854, 855, 856, 
        857, 858, 859, 860, 861, 862, 863, 864, 865, 866, 867, 868, 869, 870, 
        871, 872, 873, 874, 875, 876, 877, 878, 879, 880, 881, 882, 883, 884, 
        885, 886, 887, 888, 889, 890, 891, 892, 893, 894, 895, 896, 897, 898, 
        899, 900, 901, 902, 903, 904, 905, 906, 907, 908, 909, 910, 911, 912, 
        913, 914, 915, 916, 917, 918, 919, 920, 921, 922, 923, 924, 925, 
        926}],
       RowBox[{
         RowBox[{"Abs", "[", 
           RowBox[{
             RowBox[{"Cos", "[", "x", "]"}], " ", 
             RowBox[{"Cos", "[", "y", "]"}]}], "]"}], "\[Equal]", "0.5`"}]],
      Annotation[#, Abs[Cos[$CellContext`x] Cos[$CellContext`y]] == 0.5, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       LineBox[{927, 928, 929, 930, 931, 932, 933, 934, 935, 936, 937, 938, 
        939, 940, 941, 942, 943, 944, 945, 946, 947, 948, 949, 950, 951, 952, 
        953, 954, 955, 956, 957, 958, 959, 960, 961, 962, 963, 964, 965, 966, 
        967, 968, 969, 970, 971, 972, 973, 974, 975, 976, 977, 978, 979, 980, 
        981, 982, 983, 984, 985, 986, 987, 988, 989, 990, 991, 992, 993, 994, 
        995, 996, 997, 998, 999, 1000, 1001, 1002, 1003, 1004, 1005, 1006, 
        1007, 1008, 1009, 1010, 1011, 1012, 1013, 1014, 1015, 1016, 1017, 
        1018, 1019}],
       RowBox[{
         RowBox[{"Abs", "[", 
           RowBox[{
             RowBox[{"Cos", "[", "x", "]"}], " ", 
             RowBox[{"Cos", "[", "y", "]"}]}], "]"}], "\[Equal]", "0.5`"}]],
      Annotation[#, Abs[Cos[$CellContext`x] Cos[$CellContext`y]] == 0.5, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       LineBox[{1020, 1021, 1022, 1023, 1024, 1025, 1026, 1027, 1028, 1029, 
        1030, 1031, 1032, 1033, 1034, 1035, 1036, 1037, 1038, 1039, 1040, 
        1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 
        1052, 1053, 1054, 1055, 1056, 1057, 1058, 1059, 1060, 1061, 1062, 
        1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071, 1072, 1073, 
        1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 
        1085, 1086, 1087, 1088, 1089, 1090, 1091, 1092}],
       RowBox[{
         RowBox[{"Abs", "[", 
           RowBox[{
             RowBox[{"Cos", "[", "x", "]"}], " ", 
             RowBox[{"Cos", "[", "y", "]"}]}], "]"}], "\[Equal]", "0.5`"}]],
      Annotation[#, Abs[Cos[$CellContext`x] Cos[$CellContext`y]] == 0.5, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       LineBox[{1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 
        1103, 1104, 1105, 1106, 1107, 1108, 1109, 1110, 1111, 1112, 1113, 
        1114, 1115, 1116, 1117, 1118, 1119, 1120, 1121, 1122, 1123, 1124, 
        1125, 1126, 1127, 1128, 1129, 1130, 1131, 1132, 1133, 1134, 1135, 
        1136, 1137, 1138, 1139, 1140, 1141, 1142, 1143, 1144, 1145, 1146, 
        1147, 1148, 1149, 1150, 1151, 1152, 1153, 1154, 1155, 1156, 1157, 
        1158, 1159, 1160, 1161, 1162, 1163, 1164, 1165, 1166, 1167, 1168, 
        1169, 1170, 1171, 1172, 1173, 1174, 1175, 1176, 1177, 1178, 1179, 
        1180, 1181, 1182, 1183, 1184, 1185, 1186, 1187, 1188, 1189, 1190, 
        1191, 1192, 1193, 1194, 1195, 1196, 1197, 1198, 1199, 1200, 1201, 
        1202, 1203, 1204, 1205, 1206, 1207, 1208, 1209, 1210, 1211, 1212, 
        1213, 1214, 1215, 1216, 1217, 1218, 1219, 1220, 1221, 1222, 1223, 
        1224, 1225, 1226, 1227, 1228, 1229, 1230, 1231, 1232, 1233, 1234, 
        1235, 1236, 1237, 1238, 1239, 1240, 1241, 1242, 1243, 1244, 1245, 
        1246, 1247, 1248, 1249, 1250, 1251, 1252, 1253, 1254, 1255, 1256, 
        1257, 1258, 1259, 1260, 1261, 1262, 1263, 1264, 1265, 1266, 1267, 
        1268}],
       RowBox[{
         RowBox[{"Abs", "[", 
           RowBox[{
             RowBox[{"Cos", "[", "x", "]"}], " ", 
             RowBox[{"Cos", "[", "y", "]"}]}], "]"}], "\[Equal]", "0.5`"}]],
      Annotation[#, Abs[Cos[$CellContext`x] Cos[$CellContext`y]] == 0.5, 
       "Tooltip"]& ]}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-3, 3}, {-3, 3}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1226731995]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(14)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29383],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Sampling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->36463964],

Cell["More points are sampled where the function changes quickly:", \
"ExampleText",
 CellID->144475885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1365410381],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->355494898]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->114887495],

Cell["The plot range is selected automatically:", "ExampleText",
 CellID->802413399],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->805944501],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyVvXm8jdUX+O9j+CglpTmENEhKISpqN5KSKQ0aDU0KGZqIBhKVoaIkRaLh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   "], {{{}, 
     {RGBColor[
      0.37570495084458755`, 0.20048266215305438`, 0.6450790751541138], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgm0lMWVx6vf6379dffrfsi+iIAbLoALYGTHJWNcAIMi4AIImEQRBDdQ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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnlsVVUQxi/0vb7nPe++IkJUCETWCqgg4hKBABoVhCIBiwjRssliSwkF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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5402828525337626, 0.4866391864591631, 0.8764132254623412], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3m8lePax9faa+31rL2etVZIhnKQdhmKMjVQB5VCmVJ0OIdEc/SeTPEi
JwqZX1M6Mp1XKhxTqNA2T284hsxtFckQ4chUnPf33ddvf/LH/XnudT/3fF/3
df2u3/WstsMnDDq1JpPJfJPPZHJ6vpnNZN5S2lv5eWkm07escr0rt8hk8vr9
L1VuoXxJ+aXKV5SvVf515acVM5lNlVYmmczn6qOn0vHqp6o6RdV5U3U2Ub6i
/DvKf6b3q5V6KG2m8s1VvlzlJ2si76hsotqO0fN7PWcqlVRnrt4/oDRcdfrq
3WiVLy5kMvsp/6nyF2v8rNIqzWG0+ttL879cdTdV26p+v6u2hVz0MUJtvtXa
eirtq/R1NZP5Ummh2j6iOvP0/nSltE5jK+2u/Dq9P7iUyVyt9hMrmcxL+t1e
4z+ld62VlmkObfR8V8+9MjHeo/pdr/Sk6j6tNE39f6bnxZrbjrWZzG76vVjv
T2CtKj9I/V+pdv9Wvp/y05VfojGmKXVW6qi57KI0VPX/oHdrMrFXyzTnkn6/
q/Il2Xj/jcob9DzR+WtVp63q/Kx8Xn1sofxsvWvU+pfo3ctKF2qfnlVqUL6X
1thT6SvN81A9D9R81iu/ndodrXQ269XzEKXByo9XXwfUxHmNVt0pabwboLaH
KP2ktvchR0p/1Jhn6Kw66P3hmWi3g9uerHe/eK5HZmM8xtpccx6h/PZKd6v/
2drDdjXR7xq16aX0pMa5RO/OK8SZ8H5Ptd1f7/ZT6qx0itq9q7SJ2m2u+nPL
Mf4PnLHSQKVayczLldj3f2ou6/X+F6UDNOf9ldYj397Xy5X2Vr29lB5RWU5t
7yrFPO/JxfxZx1Sd9THZOLNfVX6z8hOUf17jPKc0Re2/Vt9fKY1V/mSVDVQ/
AzXnkcoPUX4rlY9R/jDlD1P5evXZS/2fnwnZn+U+b9Uer1S91bm4n+wD+7FA
qcPvZLUxE/vznt639+92fn+A0qnam2lKm2qvxvk+st4LVdZS/der/BLkRfn/
01j31cS9/bfqLNX8vlLZTUotVH6lyjsqTUd2lbpm4r4tSOLst9PatlXasibO
Hlm+KRN38TSlG5Wvz4ecczfHa9yOmsdVudBb21h3bVUTuow7OCIXOuVg/d6t
EPv/pfefsx6g9Erz/VP5k9mQY/JjvQ5ksmVdnCd6I+vntEzs/bBs7P/n6vMw
pUOVWksGdtb86pRPtL45NSEv22v+2+WjDffqJeU/VJ2T8nGnkJUN2ZAvZGZr
9bOj+qlVnQ9U5ws95yttq/LOKt9c+THWaejHVr7TzK+t6pyoOufp/Q7Kj1D+
EuV3Uf5a5d9T/kr1uZZ7hy6pifuMTt5Rdc5RndmqU28du0pr/CIb+n2fbOj6
pXoep/IOqn+W6t+p+jspfxU2QvknVOdxpUb121l1V2Tivv8g/XZnKcb7UfnV
yt+v/Gaq+4xldGE29C5tnrYeJY9+P4Q1Kt9a+ZVq14Xzr4k5Mp9Ptbcvam23
aw6HF8Jm9KEPzW2i5naDfj+m8kVK92GHdHe6K12ufCfVOUDy/E1t9LvCd+Gj
mlgHMtzed4S7gy7rpnSFyparj4plHT2LHCPD7DtyiW142/KKjLbXWKdpPjeq
bGf0YTHsYrsWYcOwXzsrf3Ua7Toqf4Py7yt/h/bsmHLclynoau1j90L0Nd33
Af2E/ufO7qy92imJ8/6L6v65GmXcM+7UDNXZUBt3tZ/ya9TPl7Yr/9T6Ziq/
TPkPs7HGXbKxTvLdVP9jzeEmzek2zeFQy3UdtlJjPOy70TMJGeUOnVkMG4B8
ZS27yO2zKpvkeo3ZmE9H64BcTeiBFRpre629IR92jPIbMoELGBNsgBy3sW2q
1/1tVxf7+5/a0IO9sVPag5OVOmu8gt7X1sXY5+dCHrGfu2uMLkoP5cJG3J4N
ezQ2ibvKb/QD9445tM+HHeDcFxfj/jfb+MU+iy6Wb2SrvfUy8rRLLrBVM27g
iezVFaL+Ecp/Z33aaH3S4HM+Qeu4XfvyJ9U9U/nTlHpp7AGluG/sxVLfE+7I
0ELoQNbyvvqZp37nWi/+4PLbnccmvq61TPCa31T+Df+mzgbrqzlujw36Qfkf
lc7LhF34KRe2ATwFrgKz7WiZ75YNWXs1H7r9Tc13chpYDCzwWj7kdHQudCO6
9ymt9dI0sMvzadghbNCJ+bg3rPMd5W9V/hal7uqzq1IxCXu4pbEB57aF5adf
PvTWVpYpykdmA/dw/7dW+of28y7JXmtwiOY+T6m37zbtsDtgBGSaed6rMe+p
xj0oaM9n1GzEvjz7Z0KnoluR1b6F+E1+Vi7yYOmPi1EH3Us/YOijwHXZyNPf
Ms2/Rukl7q7G+5vqjcLuaW+2V3oAu6t921vpM63pbuy4sfdktRundsOVv19l
z6WBmabnA/Oivx/W2htLgTPQ62BV5t+qLsYCn4Gp6QO8cIv6v071/6ix+mjM
3krfKr+/nvsprVV+oMa5WvvTQ2OvKIYOvUztL80H/gWPcG77+OyuqAmszNiv
lwIrU2+8xupgW4ncIX/Y3bdKgd1Zw2vKz1fqpz4f0vgPKo3TvPfUc49K2I37
9PxR/Vyr8TtpvC6FwH+XqnxTjXGvyk9Uf8Oq8f5AlT0E1s2HXGNLke3+Kn9U
5YerfJXW9AnYDiyoftqqbUb9tkzC5l0D5s/F3b4R3VoMe4Cs9FY/m5dDB6/T
+++VZqn8GPXTXv0k6ueicmAy8NiEUqyTNQ4oBkYEe36UhM1p8u/ygQvBhP3z
YQ+xSR/kwra8bT2KL4YurVjvo+exvW/b/vJc6vx7vnP83i0X/iK+0b2awz3F
8NWWJ2FvuSPcc7Ad+vx1cLL9rkmqe1Yx8Bo4kXHBisjmUzWB0ZAtnuA05Ok1
+wwv5kJPYMsm5sJHYg2XJIHzLssEDltinTkliTw6qp/2snc1zuRQPQegM5PQ
Wa94LDD3Ve53kuZ3ViFw22M6i4u052fq9yFq119pS7U9Ts+r8J1U/mESvuar
2bDJr9oWLCgGjmnGPc9Y53PfnraNYA2MOdH4/Cnbi8658Keph33KWV9x/19Q
GkWf+bBJTXtTEzYGu3KuZLOLMeQ4PXerxNpOTwOX3GiZQDbAEtNVfn4p7vhf
08BSN3gvaIdfc5H6uFCpB7pAaz9B9deq/AGV3a80phBYFcyKbmzSE7k4y5zO
8UjrIPb+cO8/mAPsAd74QmWDNfaj+FLqe1gaZwrWm2BeABlClsALb+fDD6H9
ANW9KQ09s0j9HKv8ZPWzSu8H+G4hv9gOcOTpmu9pSh0055FpYGhw3Kg08Bn1
HswFvgbPf1eIvtFdlIEhsM0z7AOBD9/Kx75uY7nmHbI903VYI88Zzm8GBizF
nWnSwbk4a/Qddww5mKA6L1fDv9/K2Iu9wLfgDiA7yOVz+Mf6/YzqPqd0aRLv
8I+442Ag+IisfrdRnyNLYZeP1vMvadwRsNJI46XZ2ps7K6EbkaGncuHT9tD7
laXQvehjfBh08nzVfVjp1ELY7SnlsN2vYMPT8IFOV7vuyg9C10iXdq0LrqKr
2uRy4Y8NT8O3YY/vgEuohO/1lZ5rKoEzwTIH5wK3rDduONJrHeH1jtTzJOef
19jP5qPs55qoj3zuWgxZxbd60m3xJXmOdNvh7gf/Avnjd5O91j4M0vzuT2Iu
/T2fcUlgR36fr/fdKsEx7KL9OCGNe8S6WQd3ea32ZCiym41xhntc9MsW9n/Q
W32tu7A1K20jhhRizeiNXBpcHnoZfgSsAF7aoS78mv72s9AnYM978qEvyJfT
4O+auTts0FHGotgt/AXGo/xa62Z0Nb40WPU710G2v/JdeA8eTP3eoTkvKkYd
MC36G10Ffqa/dR7rV9X9WntxILhJcztC6We9K6TBRWLPWqTB9zFvcA3cItgG
nnJeOerAOS03ntmUs8kHtqtLg98Ef6Mz4cNGW9f+y7byg5rgSuBJHi/Eb/Jt
6qIP/JQkDd4TzhM/jCd2bA/jMmxTjfsn/4vqD9e6dsoG/llm3wodvdT4h3N6
yfr8Mesq9ps+lnie7AUYG6wNDgXHYu+vTMMn53dee/CFxrpefVyThm+JXwnO
ft32d3k+ymh7lGRzkFJWa12p81qhdJ/27AiVHa70W234e/gPcE0z1edH1ZC/
Phrr5jQwD21WgW2ygQXB5fyGy4DTuAu7p/6ma25zlb+ds/a9PieJJ7zKZSp/
Mo25XpcGlwHuuD4N3xjsgg/5gLH3GvU3XP08ityWgkd+wH4d/h12eI9y6Pcm
biQN7gbeJue9ROcMKgVPQRt4nVaVqIOOA2eCKeBg8Znxl8Ej/EaW5ydRzm8w
1YfWyXAl4C0w1Ip8rGOpsQl9om/pC7/odGOu910HLqrgtcJB1doGrdPcvk+D
1wFHdDGWQE8szG7kM+BV4GGuNnbgLoyW7I2yf9xovxT/aJXW/bnWfx2xgLrw
RWf6HnV2P006JBvyf4HqdkrNpRRDl6JTsWnYPGR7ZTFsJbLeR/32VuqaD0zT
2uNuUxf3am4xcCP4lTvSPR99oUPgC9u4PnxuM7ZarTl/Wo29v0hzWVQJ/b1c
ZYelcYfeUX6qyvcpxFmwv2Dbm/3Ehz26EDp0vvFWB+9nt0Ks5Q++p+1cDmcI
74PuWuS5gXVZGzYfW088ZJNy6IVyEr4/e408HWCdOd3YuZ3Pq979w8+AL+Bd
2BeeYHL2j/0G2/dR+da58D+JFcB5wk+CEU5NAydgYyjHLsBHDnWdTnWBieG6
4SqQazDqC2o7vhIcLbK5xO/AxCe4zvDfYXM4XfYC7hRenDx7gn4CSzdzxGNc
5x3N+e1i4PRX3Qd9ts2HnW/wWONdf04peHbuwS1a06xy6BP8STgE7swLvjf4
Fz1Vp1AOXIg/DE4GHx6U36inmzCuz6gxCQ6ec95TbfdW2tI2HL5joG0gthB7
95yxA7hgqtZxUTF4xy/8Hl8e3HNKIWIixMdmZAMnDDRPyW/s/POlsPXgqdnG
VMTWKMPPgostmT+Br4FzwR/fJh84jPpnp8Hh0n6uzu5upf9K4h1lyDf6eq7b
TkqDw+UetCZWVgo/9L18lFGfeozFvVjnPPvQuxhxEfbn3XzEDOFc4C3gL+Ar
2I9ZxkU8b3H5KuexC3+WfB2nlBZiL9gT8NQZ+CmV+A2fBYeIfGPDuDPIxLV6
/z+V4DaJ8XD2nPsY6x5swePF4DyIyRBHQ8aJBYCpGozf/qQ+hioVC/F+vevA
NcCPw7GAi7dOAxtj0+s93uNq90Ql/EL8Kjh6zuNWld1WCV1ytGRwSDlij+jQ
teYK5lVDzthDbPqLxgbsI/aTvWKfbvW+wQe0NCcwx+fIWeBnwh9dlw0fBlk5
zjwe+BdOD5zLeln3+9WwqdhTZGo/6/OZ2EylIwox7iyfETgNzq5JNrQP26Tm
s3QmnyYho5/o+XESXNME27y+lve+2Y1cFviFu4Ft5h134krvcX/zWj18d07R
WNtV44ye1bM+DT8Fu/egbd/aanBDxBzQAY/4/tdXY67Mk32a572amURMBW56
ajnsFjr0BpWfmkQ9MDjvweHwqnCmtyn/hcb/PA3O7GHjGOrwfMj5i5LA9cjR
eap7l3H+jSofng85xD7y5GzgmecbC6GfHrIM75WGX4RPtLvvPmdUScJ+gEd3
8rkgk/i0rzgW2WRz8mEX4LGWOI6M3BELQPYeUt+/YR8LEcfoY1vMHYBbAnsv
xF+uhlxN13MgGC8Tdhh7jM6kLbGQnTnnSnxDkDPfAe+BTj9I5QfDr9VGu25u
y53rUI0xKevueEof16FPdMv3tdHngarfrxK/Gwoxd+QNfmFP4v96Pqb+Hle6
IAl+gCfy+LPazdaat0VW9H6x0t+S4PvuyAfmg5eFl0YO8aN5jy8Nt9nL/GbH
NLA7mGSq+ju+GrLR23vInImb9na+q3EOZ4GOglsFz/MkPs25v1QJfYGuKHj/
kdsurkM7bA7vVntfe3pvE7fhvDhb9oXzhW/AzmHb8FHwd/D3eL/YdeDoGryH
6ADK0Rv4dvCa+G5wnPPNc/bXeh9Mo6+GYsQ54A7e9hNMAK4gPgHPNtS/yYMf
S8aQ3SxryMAJSZw/80cnYBfRC/g68DOUP0xMII3fFyaBVcDJxMl3r0SbY0sR
wyN+B/+6wBwsnDBP6v9C3L8UcWd8HThQuC58AGIA+E/E2DtXgvMbWRvn3rTX
YKFqyBnyBN/SFOfKRV34sIVgzjR8VHA3a+buPlGIuCN8Du3W1IY/sI/G2bcS
v9kb6hPrwW9gHeAZ2uFzNpoLhSvDx6ZskyR80bHSY+PK4ROAA/saC2JD4J+x
HTxXWf9+bF56lt9/7DroNfg4xqkvx/3n7hPX6OPYBtiG+uhpviGZXAhf9FLt
29OV+P1GGt98oBf6+NsJ9Bj67/t8xLvBY8QOiL8QI5npeCHc6iTr2/2NMWhL
zHOo4559PR/K8TlXmWN/w/Xhfqj7fDXqE2sk5oj+hF+GZ55o/HmpuS/8Guq0
9vNM59Gbk4ob25HHLyB+8LW/2eB7oDMd0xymfXhPY6/LBF95ttLFyu+ruSzA
7mZjjr09f97j6+LnEos82/khHo+x4HHh+NHtQ7Svn1SjzWdpxGzQJXw/8rVj
UvP8PUlv78mbxmlgwTcdv7vE95Y7y+83vG/kifmdk4l5vuG24C9itMRnx7oO
8b/fNP5fS8GPoefQfdhTYgfEdPD7LtT7hZKN0wtRtqK40R9c4bgPfuFK55cl
wZvj242ojSf+3VBz78jGZe4fX4hYBzEPdDu8PHXAPE1cp/0LMA3YHCwBVuc3
2AYeDjuNjZ5imYSLeE1ljeXQ4XBvtAXDcN7sLf7XessoOLNZDyJLcFuTHCOY
5H1DBujvpFL0iS+FHkNH0u4dt6XsQvtiYJ/xpZgz+7TSPBF4FjwBhpjmtRPr
GWZ9i0+3sBgxBuJMfPeCn4AfsCGJ/WKv4FDhXOBZKOMdOgQu4bpK8AnwIdfa
PsLZXGebdYd5OMqnuk/GvUBtf9O81yRxR3gih9urbGkpYl7guFHVWO9ajfOP
NPretRJ2mrnNK4W+RlfjPzIWnD82nhhns/4gz3nBFe+RxHyJ4/3kWB66Ep8B
fwGsCmYlRtao91+mcU/5HmlREj48cof8rfNZ4xNyZ7nj3O9V9oN+tU/U3XXw
GeEXiZvCj8DlwmVzl/l2he+0qA+n8nMa+zhGezC2GvMGc3Z1/R8LsffYyrHa
g2HliHPlzY2DM2vdP2V8b8J7eCfsMjw98Rd4ROKp8AnwHY8WIpY9F765GmtG
H59knQwXRRydeMjLxNXT0NmDkuACe6vPb+H/0+BziR3xPRZxoFPg+Pk+oxD8
DJwBsfGnqnGunCn3+MNkIzb80PuMHA/3HF5Vf+Mq8T0gnAVP1occwC/AAyDL
7D/fccExLPDZEU84txzr4bseuCNwF3zMtp4PbVfXho8GHiKe3d8+FxgTO9Kx
NmwbfC3v8S3wMcBIyAB2BNk5sRTzP0fP79LAdej+RsvV9UmMxTzZj+09BzDI
V9VY01HKP5aGXR+chB8MBgBjLU5ijos9B/JXes7MB26YOeIz9ioHHkU3Mpf/
LsV84HPZB/gonsud72C7hTwT225hn2IT7LbmVvWZZ3zu8FVwhHBhxyfBAYMP
ic0nljd8E9pRn3bUJ0/fFfdPXAA+C73N/PewH40/vYfXAm9JnIN9AP92sc7h
ubvz+Ezk8Zd+rY0+mQ846kfjTGwmthOenP62cp9lz4e5MXfWMMfz+tVcW/Oc
8CXBs3BS8FHwUuTRtW2NdYdZBhdaDjlz5Ixz5xsS4g1gcOKi3aqxV3C89V7v
bx6X+cO/MSd4NrhZ9hGdCY5Bhpu/22QNzd8Qlb2Wv1fCh8e27adx9q8GRiTO
TEyVmNEc+INS4J0tdNYHVWNf4I2pB1eMjKxIAq/CO/PNHxwU/j15fARi+x87
zxP/nxgNbeBAkbHdzL00cTGuTx10ORgZfc43vJPtW7VxW7AueAr5BIPxjfen
1tsrLMP4X3D8J5nn5/0qzxPeijz6dpGxN33eZBtAHbD9j8b3qX0TZCPRfjxZ
Cl8aGehsf42928L7g8whi/jpb2DTqhEHboVvVI268DnEk+B02vgM8J05Z+oi
Y+hj5AOdjL1u6TrYyQOrce6jtL7RlfAzNqQR22C9G1R2byl8iy72EZkPfscW
lvNRtv8djCE7+C4wJ37Dzb5YjW+b2Gc4IjBag3H4UOMovofK/87u5P3dG9/i
tfX3ePDS8PbEAo7QPGeDXTR2jd7PScMPIx5KXfhU4qG5usCS8PLE4/H5sOl8
V4RfwLffrfz9dxv1c1cavunVWvs1cAGFwKH0A16FJ6ypC6wKJ8Z7+CXmRVyB
fQabYhuwC3yvgP1u/t4EGw6uAz9v4xjEYeXgkeGQqdvN9fEL+E4cfI7u/tJY
g2+aBvh7A3hOYl5wafeo7NBy1OuhfNc0fDTkb43ln+/JwTFw5OiLNp4z+JF1
gSHh/vi+gW8H4Gtbl4OXI1bJ9z3EUfgeqexvktjvU5LYc2LS+ADsFXZzL4+F
31n2/x3gv+DBOCviJNMcKyEGTGy43j4LuJb58H0lcSBsKLEWOHH4cPxS7Aq6
iu+nNvM3VI94XGSPs93cZ40/DOdCjOwu7eGcasyDb+32MW7B10NW8FuJtc1N
Ir62THUbq/F7tPk1uLUnSvFN/zRjRfA9ssQcif3D3bOOWsszezPB+7PBvhAY
Hw4aLgkeExu8g+UcX4o2+EfoC86P9SHb490Pez/O+498/tH7hs4d7HsKz7+Z
uX5iN/DU8M/oWt6hr5AjuLAmnFIXfdJ/J9fHj5iVRiyWfcJP7Wz5ZGzuGXww
HAqcC7wKnA62vJ95QuozLvx3F+cZiztGe97v5nJ8dXhU7PC5xGXKoVta+kyJ
0RD3gJce7Lvc0md9heq/WIm5EePmmwSwAHHg/cuB54lTMRZ+ejd/ows2Jp5N
rBpcM60UuAfMwzcb2BtszVDvI/4I+8oeYneITfS1TjjGdVjLXj477gL4ZZDt
adO39S2ib75tyZYDJ8Azz0qCa56h/T6gHH7ZxFL4w/jCxGyJ72I/ubu9fO7E
X4ibw0lzbp0ck8CfWm2f6i18pWqMcU45YpncrW5wwtWQoQWV+N8OuprY+999
7uiVM6qhW/pUg7fFpjAH9EhPy3vB+8l+HOg9IVbSyXu4tX1+OB/O+Z5C+Gj4
p50sb8SUiBU1xU+19m8qUQ/9UPA31aeW4hsO9p9vsu4rhO+AbYFbByPNAj9X
4h2xm109h49UtrwSugj/qaYY8Sg473p/1w3+Batjb3fw997EpHPmmG6wz0ie
2N+98PGV8BORi2mWjS7l+KYKnwP8NNWxPMYFf4A9wC/U517Cz8DXctbENn+y
fwrGxr6AT2hPDAzeANxBP+AS/HviBJw733vuYg6fO3ReKe4Rfj1+dXPMljzy
jN5nH/mmBu4WDhfedob7gh/+1txlT+s47DpxH/xUbBj+7PHEf6oxD/Tr3eaL
sHvYP/Rt2d9sYxdYB3sCZwKme9xnhK/ZYP6XM+FsGn1GxCewTYdYFww2TwJv
DM4F7yw0RuE9sVL4xqbvUvMRx4DDoA4yzL0hTjPPcnuK68OTDbGu4HuiRR63
nfZzcinWi8zx3zviC8jNzt7z5pg6+hxeZ565nZPNwXG+3AnWi5/KtyAjzEdR
d67ro8PwG5FH/ud3if/rl3i9YH72ZJH3hzWztmbcvcBrnFCO/1/Bo8HnwaFw
LvTR4H6Qrx6WMfwD/AR8Le7Tsb5TxERGW+bhHdmLy+zDgQs7WJ7B8fD/yBB5
8Pxs63G+M6Eu/YNFW5nP4j2cEzKKX38HHE4lxmZdo1yf+5r13eGOwMPBN8LL
kee+NKSBscBXfF//v8ai8DqjzcUdVg1sDa6+mP/6VQJfsP93W1Y503bGIfAz
Q5t1Sy5kF7llffd6veC4scZ7tKu33sD+XObvkca5DvvG2vDn6XNKKfhxZO//
AfeZlG4=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHm8znUWx3/3eZ57H/1+z+9HaBQzxUyoNFExXGvW68qWwqTFlqxRkSlL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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6675178174985833, 0.6941775812447515, 0.9118627123915737], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgnUVcWRx9/3tvt49737GdyQRSEoLuiZyaJCRMHI5g4iIptbRhwdRgQ1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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHnclmMWx+/3eZ77fXIvV5Ql6jXtIgyGFDLSrtBKe2+WLGNKZCwlIdQM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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7858816693527109, 0.8547514786931049, 0.903614720965669], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgu0VlW1x7/z+M752N/aG8FELB8D1HgdXgJehnUrra7KtTIkuppo0FPv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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHeUVdUVxu+8eW9muHPuRZJQLEDAuOhtBMNSs2zJ0pBCGcTQJEIigSyC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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8945504320249139, 0.8909896154625634, 0.8549312126701458], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHeUVdUVxh/DezPv3Hn3oSbRqIktlUQUa1Y0WbFEY4kF1CWIJUGWoEhR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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3m0V1UVxy+Pd3+Pc3/33qdNpBWIWUurxyCKia1CDVLQFNBAEStAEZFJ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         "],
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwt1MlTD2AYB/CXC6IsB8tFMi5mEPkbOHDB1bhkGxnKIcTEOKpIRWmzxMku
JgfKxTZKskXRiIpSdrLL551x+PR93+d93ue3l5KeuWzjsBDCDH+GjQ2hLTGE
dkoSQngyOoTimPYHx4RQQTlVjNRbKd/qadKzISmESfry1G4w3n4C16yvs4X1
+rbGGXEeZTTpaSTZnCpZTTmVVJDlzhyPlcpsctxfzRqWO1srt5szwtk2mUOG
WUnq89US5QO1++wxby/3rIOzFjmNvXqazXoqL8tf8jc/SdU/hxdmZjvLVVtg
XSgb4121IfuZ9oFC+yK5j4XqO+NrV3tpvVked2eH2j1aaFALaq9kmsfpkSn2
0zng/KF8xGTrKWwwJzfOYCeNaivc+e7ubet1XKKOIc6qn+MMtZxnuhnpciUn
zDjJKTr055j1R/2Z9S5u2z+WXbEuu+Vf+UZ/P9+tf/CN2e7NosP8Sn19znuZ
MNw92UOFerfzz/q/8IlBvvI6vg98tO7U90E+j5+L/jq5yH4x7fZtvOeQ/mqq
aPbYd0hRPyprOMQRDvPe3QtcpJZb3GSzu1vZQjbr3B+jPpr9lFBMsrOpPPVc
+u2fyQFZr79BXiU7zoufg7NO9QxZGj9LxnkOY5lPIknkqeezSt9z/a/i+0AP
ffRyRb1d3tGTLwtocmcovl5ZIPNptr7LKOcJ8XPRn2mfxSbq1U5zhlPxu8Fc
v4M05rFLf4k5+ymmlAPxd+3xl8ilFMTfUfze8079IY9YZtbSONOMVvvd1hPj
9zO+R/ZfrQepUT9GKWXxd+K8y3lR/J45b2Xg//+if4R1vTQ=
         "]],
        "8"],
       Annotation[#, 8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl1HlMz3Ecx/FvyVHKMZSjGKEiDSsz5v6L2RwRUSiMvyTZ5L6vjfnL8Zdj
2PjHMvcxt9Hm2BxlkyPXhmXlbK48vvPHs+fn9T4+32+/9atrYdHEBRFBEAz0
Y1WLIBjSPAiW80qswEP5bGwQnMNsFKIgzDFB0Fw/Fs0Qg2hMUh+DyXHOSFbr
hvNqc+xdwVVcxzVUun+N/lqsxjB5HQ/leP1b7tjOnbgjfronU/8XN5FrOJr/
cFP+zc04w357btLSHWpt7Nzmcnf1UD8oH8Iz5+fYo5ekt5s7cxeMx7jwHdz1
xOwmXsD9eBH35yIuxkKU2K1Vq0MVzshj7Z/lXvq9McOzZmKc2g55PBfIs9BP
7otytTX2qvEKb/AapepHzB3FMnNLMdhzOsiDuJ2ZS85L1EtxWD6E/fa68QGu
1/+BM/qncSDsI9I5Co3RCC3NxPvsWnEmJ4efJ7eWEziQs8xFcJzaZ3cnuGeE
nBG+B6dzHwxAFm6rPbWzjTfySN7Ko3gTb8Hm8DNy11u1d7iGqxht/7J6hGdF
IleehglqyfJD50d4gAo8xkW9+XwHd3Ef95Cnvt5zNiDR7nD3J3G1+nfnXPSS
09EbM+zko06/kVzLsdzAMfw3/C5wPvLMTccpRLg/QIP6Prk775b34KlzFXbZ
TdTbyTX8CWn6qeHfploKZ/m8+4TvyInIVUuSc3gqpmCe2RK7i7EI0eaKeSFu
hs8Id9ABndARndEO8WiL9kjAcfNl9sr4OL/EC8yVs8PvOCaG895hMleqf9Bf
Kw/0O2VztjwJx5xrzXxGHfaafc/7+KvZLzgpn0BP54t2buidD/9H8AXOUW/K
P+RUrg+/4/yRG+t95yj+FvY5DSnI8ewvqIj5/7/tH2+8nxQ=
         "]],
        "6"],
       Annotation[#, 6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl1FdsTmEYwPFjJ7YaCZVoE+OCO6OtPdraqjVq7x3amBdWjKKExLqwZ7Q2
Qc2ILbgpTSS4MIoYsUds8Xvj4v/932e8zznf+53zxY/KzsgqEUVRuo+9laPo
UaUoeowniKsYRfFIrxBFe9R6cx7v4Kecwfv4APajqbg56lWJomY8o3wUJXKc
OIlbYKa+WZiOhNDDefya+3IB9+NnvIvbuo+d/I7f4g0OqR1EEVq7vy2u80H+
PXbrfS7/Su6H9Qu8xFFcw2z5TzyHr3MuLth3Eblybc1bxu14OV+Wv4Tl+hbJ
zZUrxfM4hxejunoMzrruIH3l+KL6ArmFmCiehEPWh3EE3/R9x2d9Xcw4Y30W
meIRfEX/NVxFffF4noAxGIexGK43gRPRAi2RhGL5EmaWxF57O/MpPo3+akPD
d9Y3jO/wfE5wT/M4n/OwByPVRmCudVk+b28Zv+Ut8SrrG3wT27ED0+T+mjGV
Z7tmTvhO8ueQI9dQrhEahHMTn5E/jcX6rmKKXD3Xmcyb5TfhFE6iWP4Jtunb
av82rNeXxC2RoicVydivJ1muU3g2Qj824ZH9m/kx9+JU9QI+iTQMtHcAGqpn
coNw9rjvOnXVa/jusTxOXJuri+vwPXEds2KRL07h43wCPdHbrDT0QpHeNWb2
kF/N3XkjNqCDfR1RIzxTSEQCtoZn1t6P4XcJz7N9y+RzcUdchCO4jUI8lB9t
TzZnYSmWYIFcE/VY992Yf2KU3E/zYqxXWv8O7xf/4oPhPVBrH64X3o/wHqCa
WTGoZk8btarhPeWu3Ec9A+mIl4vDXXNSOBUdkYxOWBHOAT3DOSAt/C6oaU5X
7obOqCXuEmIeYu5gDMIDc7/KfcF68TqsxVC9Q3BM/Y/4eHguOTP8F+GXWlao
hf8VruA83vMA8fVwBurZXIgTKK1ewA+xXU+xWU+xUdzKORTqz6/8///zHw5w
u4k=
         "]],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl1FdsT2EcxvGjNh3mBRcSe1MzQcXeVEJsUWq0tGpvQUpJKva6NquKmAmx
Su0VUju4tMeFFSPi88bF9/+c5/d73nHOef+nduqMIVkloiga7GdEbBTtqhBF
+2gBPUBLV4yiuIQoKkNjUAqxfEnaB73lvsRH0X16DxXUEvTL056IR2U+gVYM
c6ESH0v7op8x34x/QItRTa2KflVaYP3DavvpHppHd9Pr8jcwOy6K5mAu2ui1
RbpxdY1PozewBU34rXQztqMpv43uwAI04BfS+ViMhvwimoOWqMUn0qVoa60l
dDfdhZ1IsZdxyLG3zvawmp5TP4s1sk/1lqgvxW3+Do7iFm7inn472faIR3Xr
5cd4lvSNuRrJ5NGS/H66DLlqV2SvYi3f1dy5tIi/jExzZuCI66MorV8GScYl
0wu0EGvxTG45LaYPw7vARL6LcV3D/cl3o82sP9oae/ReybzGc7zEC0xS7y7X
A+ONmUYzcFc9K9yrzAyaqNcSH/h8/j39hI/Bm/+XMQdovky18DzQWK6m9ZvQ
d3ql9L7SQfSg2hkM5UfhbcjgEPobOwB90A99cUlmmHHDUSQzgX9PX4Z3pTae
/2kvT1xPx0X+NX6oDaEjMUG2tv2k0vrhzKAG34BmGpMR7h8xavvCfNZtjovm
uIRCpISzKdMUma5bhOcVzhxNNmYqTUcazsufw1j9JL4zOqATOmJQuCdMcT05
nD3ZMxgj3zr8P5CIeXwrOlB2Ep2IVHzg/+j9xiZ+IzZgjDlG4zTq2We23En1
E8iWTef34rv+AFor/K/pV36dM/yZFqgdC98L9W58r/Dewh6wGjl4rP4If7Ei
5NWOY7lsXeueUu+EJGSrr8QqJOhVQrnwrfGsy4bvjjFzwnvh59KZmI16/Cza
Q38jbcxvouuwAY349eEM60+mdfgp4fmZvxWyrDc9/LdwzT6uYmTs/+/mP+mf
qzs=
         "]],
        "2"],
       Annotation[#, 2, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-1, 1}, {-1, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->224531991]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->315796764],

Cell["Areas where the function becomes nonreal are excluded:", "ExampleText",
 CellID->47974615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1020115110],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJzUvXm8T9X3+C9RaJIGhFIpeUejpIFNk6FMoUmKlEpRKUqDJCQkbiVSoVwz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   "], {{{}, 
     {RGBColor[0.33397672886243995`, 0.1279285534584573, 0.5864250111696041], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3e4VcXVxs+9XLjnwJ6zD/fcexMVFGJDjYklKhbEXkEpUlTAaEQBsQEa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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwlmHeU1NUVx387W2ZmYefNTllrFCIILMYkGpUOsoBIh2UpQYoEkC5iL4lI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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4150981865873199, 0.26897686037537194`, 0.7004510335088123], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHeYVFW2xaurU3VX07f6VsAcEBx9pjGnmXEcB7NjxgiIIAZADKBgQDE7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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmnnA1WMWx3/3vtt9W+7v3vu792aLVjOhSdYJI2YkbRPatKM0UmlRCaPs
DEaIQtFijdKmaFev0r5qp0S0U2HQOp/vfOeP532f8zvnOc95tvOc831u1dt7
33x3PAiCC/lTyP+fUkGQywVBu9IgqMO3t8IguCUTBKUFQTAD+pdsEIzm20fU
d/PtTGQrU7oh/z3fHoJfBX6qOAjmJ4JgCvr65oNgW7kgaE4H38BbFgXBsRJk
afNv+FXhdygKgiT8m+BdhI5etJ1LaYjuGyivIDsY+7Ylg+BS6KegR8Voj76v
kK8BfS5lNbyVlGnYlqbP++H/FfsD6OHYVxfe93yrCF2TPtvQ3y2U/tizgP7u
QNeP9LEY3W9D34bsAOzbg65zad8H2X7YfDn0i7Spjb4vkR+N/AP0v4N6B3S8
Qdu69PGf0DbLVvW5nrYxdDxA30MYb5z2nyDzmeaWsor6Cvgn0d0FfYs1Ntqs
pV6eciPyR5F5k/o4yhPo7od9X2HPBIY5iLEeh19I/wNYgwrU+6PjI+imyD+N
/H7outR3Yc8c+N/T3xnwm/GtDX2dmw6CC7BvEvwm0DPRn6sQBCOhK6P/CG16
oft0yh50DUKmPv3Xpv2H8G5Fppx0M55XoG+GTkBPhl6G/D3I10M+ifwy6ifh
96C//szH9fAbUM5G/jFsKmW8iZznvjJ0eerz0bkKehNlHPXWtN9HfTqlArY+
hs626G9DmYt8M+gT9HWc0op6U8Z3I/19SB9DkW/Ot8PM3ZXlsYf5uYNvU2nb
jzWbii3t6GMQutdj33jpZ76+o+3PyO+GdxF9PFHqPXkS3hK+tad+MfZ+TX0u
3/axng9qfqHnI3+S+kB0bqHvkpznfjb9TYLuQx9b6L8p/V0Oby9tIvrbAd0f
fnvsT1Pfzrcr4V9FeUb7gfYr4S1Gvitrs4Yx3sPc3Iu+H9G3EHoNdC90rIe/
jtKV+jXwn4G/AH2vUj+L9llsK2N8E5mP+/j2K/wq6J8NrzjnvbSfOTvC/Izi
21Tkq8lHUA9y3stllD/ofPDtKPXN2FwTehv0b9Ah8ks1X5SjJfYJs6n3DL03
9kKPpu+/0UdljR97lsP/Hvr8Up+RTxnvu8i3YyyLGN9Z6H8BulmxfVJV6iPR
sZq2Z9DnUdpO4dun1N/FnirIfwF9CLo8fVwBXY8yKPCcPoJ8dfiV0FfGep4N
bw30nrh9Rkfmbw3fokL7nDHwboJ+q9Q+cpbODjrOgH8aZ2g69Q7I3AfvC75N
ZTx3hT7bO9FXh7ZXM6YGjGUw376Ftw6ZAvp+GPpT2v+Db0Pi1jmY9elNH5tY
nzHYXJW2LaFHQ/eI+exmaXN6oc/wPuo/UC7SWUVHOeovas8hX58+DmQtI558
xPnYcwHlPurvor+Ieil9/I6+Jnz7BP0Z5E+DzlTwXDfMei9ozj9Bthf21mP+
5jKmS2h/cc626sz0gXcVe/IU/T1PGcV4BqJjfzmfyVHoaqrzBK+h5hh9Q7B3
G/pmyociu45vleCVqD/kOyF/P/IbCu37KkJPT9gHTqV+jG8/x70HJtF2BvoO
om8G+pZAPw69HXoF9HfI7qJcE/MeTWHrfnS8gO0VkXlWe41vO9E1ltKO+v20
31jsPbmWsbZi/frSNmJMZ8JPycclvKe+oD4AHS/RtoA5a6D9mLTvG0EfdyG/
GX5v1ZGvCX0upTL1G7BpI7yBSfumw+j4XWeJ8ifa16bsQP/2rO8G3ZHPI78S
/insuQB6fdJ9qq+HkV9BvQP2Ty3wnq4PPZg2r6D7RWQaQzfS/RvznayzOFR3
bMJnUnNzNfznSz1HT6KrkvwHugooneHPpM3iuNdoVmQfKd+4B5tKkC2ltGSu
jmJDz4zPgPZ+D8bckfoM2i+M+wxtZL0qQ7ei/82s132af8qZyCax8fPIMYdi
jd/Qvwd6C3Qf6DNps5X6DcxB1wL7pLNkG3Qn2raAXxFbknnfJR8whz21nylt
Cz0Hf0/5jtHdIp9+LPQdrbtZPkB39UDs6V/sO7s5vOU6s9CjoT9A9xPYtEex
Avv3feg7kN+reAB6mu6epH3FAr7dAD0cGz9DvoV8ELIDKFn0FWDPqqx9iHxH
RJmAvm7wDyD7K/r66m7E/hB9X6BjIvxndT9p/PDL4N2bcezwOfP5LfUHkDnO
+DdC10X/auypVOAY7QX01ZAPKPSddDDrGEixj3xMCnsf1Ryi+wDzNxB6AzK1
C7znP5YvTPqsKgZSrLNUZ7bUMU973b+6Y+jrdcq7ke8g3T0bWM9DyM+CH0O2
Ju2XY3/3jM/KKuztlPIZ1NmTjt7wtiCTKfAabETfI9hXHvvm076l7mb0Xwr/
Mso86pch/5cixxx52leipGl7pe5b9N9G+0h7jzEsRP5y5K/WXRt3bLU78l5T
jPW49hvtY+geBb8H9CeSKfGYZdvrjOfrhG1cgj1t6aMndIIxtKCvz6DHUH+D
0hr5PcjUoV4z5tjh0aR9tWKIRdorlMvhbaePv+btU+VLn4U/XPsVe3bLF8a9
t3agr2o577Fa0FfAr4p8F2z4PLSPkW9RjjAP2WGK8cs5xjoGfYrSGPoI7Zcr
V9AZpO/O8FdAz8LmeczPrdCDoK9B/1f0/TJlBrzxyG9SLFDku20i+hsV+o5b
pFgI/ZuRXUt5FPp62u+gPpLyrc5v5LNeS/4I3nu038d67aVUhD+b+bk2Zp/V
QPEFpT36h6K/HvXLKVdDPwb9leIXSm90D0Fn26z3pPbiSMoCxSo5x6KrKUuh
VzOGtdjekf6/gv5jzrGOYqBlio9ofwltO8G/kPoq7BkU8xrfju1dKI/S1yOU
E4rdQ5/9/91ZkedQc3cQ/in400PHWu9h8+f0dUvKsbvOZIbxF2sNE87JvqP9
LkqR4pGEfecG7N1UZB8ag45rv1C/jPIhvDeRX09f05FZhP7WKcfOtaDnIXsH
/Q+OO8ZYKf+Qte95kW9x5rKYchNz+TtttsLrg019sOWcUvuSNXzLltqnKFd8
LGlfq5xxHfVCbLhDa80ctaevaVmfVcXkt0K/jX1flNgHrED2V+gLsH019pXP
+07RXdIKfSnsLwt9NrWHJlDvhD0Hqc+mVIT/aei13Mp4TuS8p7WXG9E+Q/2z
0HtvG/zVkXM25WqB5oz611nnohcjM5m++6G/L+P9ARvnwOui+y7umOlY5D2j
vaI7uyDrPaK9oTXIKvdlDtZp7/Ht48hnSmfpO74V5j3HmtsbsW9F0neM7pbu
tB8LryZtusPfVd6xxLfQuYRjCuVCS5M+28qJfqJ+GJkqBQr28Bm6f/k2PeaY
6FDOd4juDuXArXU36s6ifQfG1AR9f8777DSnff20c07lmtcXObZ9Erp1oWNc
5YLLGXNY6pywJ7b1ovwR3lraHKD/5rSJYj7Dqi+jrCzyN+UG12UduyhHaAVv
OmUW/IMM4S10NZOPDLyHb04751GuU4gNv0X2ofKd2jNF1O/Cvn/T/mf4HaCn
UD6G3ouO47TdgU1fY0s/xrsCujPjvR/+IOQHZJ3TKZdTzPky9TOzjiXuYXy/
ZJxjKrc8go5mtG1C6ULb4fAvYe6/ROZLeLV1P9K+Gv3XKLKPOgxvAd9+1H6i
nKdciNIt4TXoJCwlb1vGo28L8lspn9D+fPkQ6otS7vuw+qDtn7LeK8ox38K2
RfS3BPkwZt9UB36PhH1UoLminA//EH20oD4haV/Shm+XQjfNeyxXQX/D/O6k
ZBPecyMZ3+GssSPljOLN4lvjUsskaDsCfQcKHQMOk/9Iey2EmZxUbKM7t8h3
zFHof0IfKnCMOULy6Nut3If9PlznQ2cSegZ005RzMuVioxQD0P+DwmcY2lD2
xzLmZzllBXNTBfv6RsZ8hPUMKzHWsTvr2FmYx4Po3px17K4YWbFEwLctMccU
+ZxzfuX6wgQaoPuR0HfVNtpcB/0Q9Ktx32EHkO+T8t4XJtYz5Zxdubru+EPU
z0O+Wtw5y9qM94z2inL61sLP0sbKlHMcyTgnVC6oPVOdekHevkJnrEbaPku+
SjG/1rY789G5xGv8N9r/E/6IuDE05X7Hc/aFygFHpnwn6i6UzxB29Drt5xQZ
Q2qBPS0p2+PGFLpSr4PM0MB33PnUV+WM1dVB/gT6GtP+WZ1f9L9KfSIy04p8
hk/Bn8a32jHnhI9Cl8vbt3fRnZv2mdVZ1Z6oBm8oMin5csouxvMdZQ1z0TLm
vXRd3ne/9lQr6h+mjL0oxjoN+qmUc5dW8LtBT04Zy5wmTETxc8rY5X7F6Glj
EsIiFusM5Y3ZCKsRJvU+4+8E/4fAMc7YpOdAYy9TvEP97rSxFvkE5bbrKRuK
nOP2kH9KG+uRD12ads6qXFU+cS761kKvo95EPk33LXT/mH2EfFtTynNF9nGq
x+EfLvS33Unn1Mql58QcK1VAx7UJx0z9kL0n7bXRGmituiA/qZzXTFjCvLTH
IkxhgPpO++5WH5VY69Nyji2EOc9MGyMQNqCYcDb1xqxPI9ZnAfRW6G1p5x4v
xRxrTlQOV+KY86O0MQFhAfL5GmvftH2Txjw5/f8cv8g+XHPfWTFCgddgA3u7
Kvb8FDcG9LDw2bzXUjJ3w59HfwdKfEe1o+21ecfOndC3CXpz2thaF/q7Ftvv
C4016849RP26nO9SYZoN0HV9ZOxJPmJbxneK7hJhGseo/yvlu2kvpRGyjSnv
F9qnyTcqJlAsIB9ZmHMOpNxHPvRs+gvRWUH5L+USYUHwLy40xtoQXTdEjhXl
E49TP0Gpm/AZWZD1G4Cw/wT6csotKfGYcx7lJm9QdiacozwcOqZTLKcY8i/I
9hM+EjemI+znSWxcV2oMSL7roDCUYvuwGtSrZ3zXCNNQrtEWmXvjzjkUe2xW
zlbsGGQ0fdXLONaQDbKtF6VnsW28knrv0FjSncz31cq9oYfFnWMsSDpGUWyi
M7UqbcxUWKli9vrCS0PnIltpfwb06Rnnesqxa8I7C/o06mdQqlKvkjEWI8xB
bwG/CmOK+02gKG8fJd+kGLizzj+lQaHv9HbU20bGJoUpfpByDqDYX5hsWco5
n3I9YXqvh8YI/ocNIH8ec7sj9NuDMLrbhQ0mjbUqxuwq7CPpWFYx+gT0/YS9
h4qdU72Nrlr014Ox7kXnW4odoL+E3gP9HvWRScdSiiFOoK+Fzkuhc+Rq8KtG
fiupic0vJ40RChtcDf0m+v4gjBPZ3ehrnPo/Zsj9+1qBsahVkWNnYVJT4f8H
+37Cvpt159PfOOS/L+87qH3eMYZii3eYj3NoW4VSrcR7XHu/cmhsTmdAa1Uj
9FuF1ky5wjuRsQPlDHrbeS1pbEJvPNuRrZVzbqM1HAb9HjJHhIVD/yv0nGmu
Ritnpd4pa6xgGt9ujvyGpberHuh/jvH8kPTdI8xlSOg50Vzozr8ndIyu2Fx7
tGPWb1J6i9Ib0hOh10Rr8bpyFr3HKN8otk94OzSGJOzoY+WAoTEfYT0zoefr
7s8YO/uMMX2A7jtDn+3NJcZau4f2xcJcb4delTKWoZj2lqzfBPQWIMxmJ/Q3
wk9LjImOY2xl6DwMXQy9iPqbSdcls0axU+i3oXjCseQI9GcLHFMKi9uPzNkJ
Y3JzIr8BCPvXm8nXkWM6xXLCDKdFxsyFlQtTuCn0G4HeBpQj6q1iTsrYmN4s
tuccoyo2FaaxNuscVbmpck6tbdeM3y61xrrLOuYdO+tOmxQaIxM2NjfuvTgw
cuymPTmLsZbPGjuvr/cbeG/w7ajyV+ybEHnONde6s4SNHgiNpQojfVy5Ut53
rTCycciOpQyIO+fri+wY+DvL26d+nHZOoVxCMVY3YaNJ56J6E3ga3ul53x3K
8aeja0bkXHFXie+y+ZGxA91pT2FP9ci+Uj5aWNTMyFisMCn13T+yL5QN1YV1
hMaadWe+GvpNTG9hUxTDRo65FWsLo9Vd/lRobFZ3egvo10LL6k2wJfQboX2Z
3vBaQY8N/ZYnTLQL9O2KB2LOSRpRfzL0WRCGtprxdqW/KeX8ZtcQ/mOhsTX5
nCbQT4c+q8Lo9TZWjzmsX+Q3sr/Dfyn02RYGNpq5nBIZK9MaNof/cmhsTG9+
elvSmdJZ0htTU/jPhMb+5TNvgh4R+q1TGO6d0P+gdIs5JtPZFUYpbFJn+DZ4
k0PvLb2Zro18ZnRW9OajWLxJ0r5VMflC9lpZ1ntLGHUPxn5X3m+zwhzr6m1T
61niNyy9ZctHyTfpTbt5ZExRWKJkesHrmXcupDlpmLSPlW+VT+2IfR+ExkaE
EbeBfjP0bwGEKXeGnhj6rfdHSlvod0L7Iv1moDu67szb1wtDfT80xixsuQPj
b4/8+NC+ShjMQelKO/bTna635oVpx9J6c16Ycg6s3Fd32FLqSzKOdZWzrY/8
BiDsX2/go6HHRL6LhOGdE/o3CvptgjAZvY2OSRo71xvpJtpuzDj3U86ht5wO
GduqN53V1FdlnEsrhzgV+c1Xb73C9N5B/oq8f1sgDHEf/f2S8tutfF610G+K
ekvUm4D27pqUcwntYb3lT0v57tOb/tSkY07FmorR+tL3pLyxJGFoD6SM0Qmb
U4z0UMoYqrBTYQj75Esjv53Lx96Y8pu33roVYwkbTGccKwojFNZflnRuJMz/
B/bKjznnxvJJ98O7LTIWqhxufMoYq7BVxXQX0ne/yLmycurP0b8ka98jDHpx
yhiEsAfd8St1N+d8VypHfCZpzEhYkd5YnkkZ0xOWJ8zlBG2XpvxbAWHuAX2t
S/m3FIpJnguNAQv7Vc5SSj2RtW/WHaW3t7Mzjt30Bve+fruQd26nmOy/wMcG
fw==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4962196443121998, 0.4100251672922865, 0.8144770558480205], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHe8lcXxxs/lXm455+be00UBpUkTaVKCJmpsgAgISI1K0V8Eo0hRUIqC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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXe8znUbx3/OvM/Rc4/fPVTmOYishCgqJRlZGQmv7AaVkWMWD0qR0KAy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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5737613661287864, 0.5435370519035629, 0.9097253540741592], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgeUldW1x78pl/vNnVl3bvnuVUkQEUSGaiXYUIoapUQTY+wCFmyAaIKI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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHeUVuURxu82dlmSr977UQQpSllYlyJLCR0EpPdY0AgIoVmCiUgAsQAK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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6334044084039064, 0.6393668249866483, 0.911085031734951], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mHmMldUZxr8B7tyZO/TOXeabsgi2iRXZhRlEWWSmtFaK2IKk2tLaxJbF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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlslVUQhk/3e4u597tf73dlLZooCJQWbFkioK01UayYQBpFMf4gsgmC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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6930474506790265, 0.7351965980697338, 0.912444709395743], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1uIVlUUx49+l5kzo9+c832ez1ILyiKiu5VpOqD1UGMQaJbkpSDJskIr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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlUtsVVUUhnd7H+29tb3nnNvT2lJNjBonGoVq2sY0aXWgODChQQzBRwIB
rcZWBFvFiRWNFJVHK4YCxUR5+OAhlKJBqo1BE00cGx2gGASlJlZFxQHg9+d3
sHL2Ov+/1t57vfY1S/t7+ipDCC8iWWRBXQhNcQgNuRBuqwrhtSSEchTCK/kQ
1iOP1YfQi3xTEcKvcNrKIbQj3XCfz/AP21HkJPgs+EL8NaNfyfp2OI+y7kXu
Qu+G/wjrbvy/weZ9/NuWhrAT+bEQwhrwIvtXI8eq+bL/KrB+ZAHYNJyXwM7E
PssQ+EGwlez5Nf5mwcfQWznfs/C/Rx9H/4n9vsh6jw3YZ0shnK7wHQ+gt+Bv
MbHYh94D917sl3H2y/DngG3HxynWzey5qM7/tFYMDoB9kHrvYfasB6vG/zn8
L8w4FhvBvy04JsI2suereXMOgXVGtr0KPAf+VOq71uacm93w3847R6+zXs4Z
PuE+m/m3E/xNZAT7OhK7GKwWTg3YfM5Xj+8XwF/Oec+9qXOo3P3MHuvA2uFM
go3AuYH1dOq798MZA/9XAjbLeevwPR57L+1RkbiGVDuV6JMNIRxFbq4JYRD7
FO7T+PsMfxE+AvyUO17E1yrwUfSGyLGayjp3t5ZdO8phF/YP4/9o1jV0E9xR
/DWxHgA/jn0X/zZlXFOtrPfz733Osh/pQP+Q89ReEcJaOCvQf8D+2mII1yNj
cFfgfxrbLfCH4b7Hv0sVvoP2bkOyVT5DhrMdAz8O91LetbkS+bTgGl0Ktw99
Cr2F6w7hL49NF1gBf0+CLYPzcdY22/F1NWd6EDxWfrnvFuSejHtqM/zT4Cfg
f6cYqlYS14Y45+H+g1xA/w1+CXwd+Efw52d89pnYvak7HOY82xLnMkdMnsF/
qeS9T+D/DPYHE8eughyfRN+NdOJvAjnHeiZyLHOV7q2tqXtNPbakzjFSbN5C
bwM/gr8vWQ9hs5X9JxKvp2qci+Vwris6J09g34O0c9bPs85dR9m9oRyehz+o
HiW2nfCbSvYpX4VK5/JOpKXKOVWsO5GkyjFPys6RchPz7xd87UndCzrjQ6yr
I8+qiYJni3pKvaQZ06DZkjpW98M5GzlmitVz6JOJY6TYqKd2RZ55mnWKYQb8
XWQvWCbvWVSOnSvNpAnucqTBuVFNiKuYKBay+R1uAZsZuD3g74DfGLmXVCN/
g9+hGVXlmihw3iJSjX43nH3w50Y+q3roQuweUO2rx1XbhcSzVzX+l3q95Np6
AJvh2DNDs2IUuVjnGldt640Yx3cr+mHicwvnWVPvHCk3mum9xK428llUowXV
Pv8OFWwzgO/B2LWjnt4ANpK69lejJ5HfKL1N6rGzYI/z76uMa6iR9WDqWXIf
/+agn0rd60synvXrY59dM1+x0ozSbFLM/lD/JZ6ti+DPI3Zzy541qkm9DX+m
rj29ER3Yx8pJzjHWrI3Lri3NXN2tGLmWdEfNpnmR3xrNqGLJe2ov5bRcdo6V
W9XsHvi7Es9ivQGXwSoTz1rNUL0FXUhjld+EZuzXxv/flX8D7L86dSw0gxvL
rmHVrmw2pY6xYqs3akfqN1lvsd68HfjKJq5VzUTdVW+w3l7d+T9xfwt5
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7526904929541466, 0.8310263711528191, 0.9138043870565348], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1uIVWUYhpfOzN7utffsWXvtvSbQIvS+C60safQite4cEXM8ESWpaWkI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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllElsTWEUx0/fcK+n7et7975bojbsidZY2k0r7GhEIoaFiKk1LgwLY6hQ
oaaEEPOQUFUsTK0xFhL2NiIixDwmpgWJ38l/cZLz//7nO9/5zjRk3oppy1Nm
NhfJIJcSswtIe9rsc84sLJhtjcw2BWabkSvoozi7jN6DLMJ2f9HsSNbsFvZ5
uBhcAW6H76g2u46EFWbnwc3wd/BxD/1+oLv7kMNZ+ejBXyM23/H1FVkGrorN
phDPbfC6kllNldkN7vb1M1sIPx+ZDH8TfgR3L+L/Avwr8Cm4k8hs/vYavJH7
FfA5+Nvcn+Mc8rTMrBt+DfpqZCj2D8B7sU3w2Yn9biRHLJXgXs9NaDYAfVUi
24fILuyXJoq1I1Astdh0BYrpOH89hpzlr+eyiqWP/DRWKKaB/K07Ue6zgbhy
bBaZbKrwtR28FW4b0okeczY1rZz3gOvA68E14Dy4ElloejNAD5FMoJy0kY+3
xPMRrquf9DdIpelsP7bV+NuL/R5kTt5sIjloCRXTB2zfe71NNfTeuYh8yqmH
GrCP4MvhCtxJ+9vIGfB07hwsKmeeq2OcXebulUS195hPo59JVLs0jfoL+9/I
r6xq5L4XJKq9v9GH3us9k1KMw4i9lnjHoj/D5jzceHAz+AP4KPe7IvWmx/QD
nKcGv7N6IxupJl4Lz9lL/K1NVOv39MxV9EHw/VPq2RL8Hu5UcbeF/6/k/zOQ
Sbz3hAEb6bMD/yijGnWjD+B+KqUecf1Aolj9bJ/Xi7N3ZerBenz1j9V7XqN/
4NaSapfmbAw4iKUTgnUlisHf9ppcxd+7gnLpM9wK/wL8vEw9fSDSH/1vXvMm
fJ0oqlenhMrdR/jHGeVwAnh9SbP4hftJrJ7xXinBl2LNkM9OHGp2N5Q0ez7D
EXwxVq56M8plPbgpVE4r0ScQ/yD+Us5ZB7HsLKq3t3CnjfiXJOI8R74LFifa
Rb4TImJdnsi3z8g15mk4Z/ND7aSv+PpWVO/5G56LHZFmy3Pyl7fbI+0+3xEN
sf7sf/Wajo61E30XNoDrwNPy6m3vufqCes57zf/0BXw30u7zHp0JNyvR7vEZ
8l0beI/ktHN91n2n+i71mffd2QT+k9MO9d1YiDVbviPfFrQDffd5j5WKqonX
wnvyJ3gw/KFAPX4Nf+MKyqXX9D8gvsRx
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.80726725, 0.8618830000000001, 0.894034], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lc1vlFUUxm+nM/MyDkzfmfYajcTq/4AbWkqiIzWUjQISsUYofjQI6B6m
MdgUEtSINrhVWCFiFPloaaqpbliyYQUbSTAqEQ0uCAmJPD+f4+Lmvffcc57z
9Zz7Pj317ksHKimlc1r9Woc7KdXKlGbqKX2o/Yl2Sjf7UioGUjquc6umVaR0
XbJB6X8i2ZA2W2X8hHQODqXUFOCi5KPCWRLOXdlM9Bsnl7ZB/82cUqdtnDGd
D0r3mnQuVH1mP95MaVPTPo9J9kjd+COtlNbIcLXkpxu2lVo6ou9i1f7m5Kcp
f4clG9F3QefL2m/pdx6PS/+CYnhKMUwn24G3JWI5FPF8qvu3pXdD+8v6Lmnd
k89Z4T1QHHVhrWi/ST5+ls3f0v+r7by/kO6XWrek/46+e7HX/pDqNKL4n5e/
F7WGpfuZ/G7Q6glDofzXg17EQB0XtVYp96VHFWfHteiXz/c7jvW2cDcLa7ds
v5XsGeH3hPeB9oX0Nmq/Xf4rpWs2UVh/SvqldAdYOm9v+m61fHULxwgmfaCu
gkunhXM22+esYq8VlpP/T1plxfmwPyD5eele1PpH+uPSXSububhHD/2rVe/R
pz9whB4t150r/Se2bU3HfaJmGb1blvPnlNe8zl19f9R5RTbPlr5DXlTsk3zh
WKUwz+jDaPQCzJWIfzjw2dMzYoIbrDntf+lzT+AUmPggB+InPvwhb3bcM3L4
VysV5iozxBn+zwU2+cLX2cCnZ/ALPtwIfWzpAzrUvBDAqkH3gHiZD2ryhur9
ltalhuvejZ7SY+YJv8RPTeAVnJoZcpzMHXrM7PmG9fFF32ZCf03huIn5a/l5
bMA5EyM+wW8Gh4iHvLkjb2q7HD3dKMWxQXPuTDa34NVv6t13cnql6nditGVM
/COb1P5jyT/S+rzmWdkQ70ZXipMtzxYy+o28XnoeqOvZhuXcw/392TmDc6bh
mq8Txmst13whm8fUkhjma67DLt3vyq4PccAh8iU39vAHznZjjqhTreNanZLd
Sa1fhXm87beGPv+u7x+8I7Lfl/0W04u24j+m/dG6bagDsfB2wR84U4ULg643
faN/1PxJ4e1smZPM2XDENp3NFXoG175puCZ9ivPlbNvd+r6ejTUb7zm+eON4
czm/ULgm9OVV6U5mY8ER4kWfeSMnciyUR50V9uSAznxwDJydwnglu1dw71bU
vjfk/w38ek85fZVdW2pMf6ZjRnizqBvzCKeoObLxkJ+T3Z+l54JacUcfmYnF
mGvi481Chu6lbH3qBZ/JpR5zBD512hO1Wi/9iwJc0P0P+t4p/Ubw1hAr8fMG
3m/43QBjbfCKmfg+ey52ZPeVnu5oOWfypVYL8V/gn0V94Sp84638f97H4x+K
z20h3xx7cOg7PYfzE/EP4J43kn6NxdvGfw/urCv9j+H/MpXNlevRX+pBDHCz
F318CAEu9EY=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllElPFFEUhZ+0VUXbUFRX83Yq+h9wIxAWgJrIRo2CiAbaOMTxBzAJMWhE
TYgEl04rRUwcoLvtOG9cunGlG000ThGjC2N04Xe4i5t6991zzx1frS+e3H6i
xjnXjaxEpvLObUycK4fOzQTOjafco89lnRvhbrSRL5LDaRX6Qe/cAaSAbwnM
Ethn+LzAloCJ0E+jh3C1Z5z7hl5Br2KvxT5GvAjnIAIHpgb7GPYh7DfhOw73
MeT9CucawOzmvC92boFk57EHYCPxg4/g+wLfNPIW/BJ8R8BHDc7FnKvgF1PL
QbFVYwfnx9y9gm+G/A6BP+ytFnFk8J3EPgH2HXorufYQf5B6u8jnFtg55GvW
7pqIXQX/CHwTMcuc13JXxPaQu7vozcQcIdZLYrZyLnFXCa0n9+G6h9SR31b4
1+B7Ff0D/Kvhu8L5BvIRfRSOC9jPI7PYLiO9sfkIuxn/ebC3vfVGOS5yXlCN
5PMLvZdzn7detsE3i+8P5GdgPe+g3k5kG1yXsIepxRC3er4O7MW8xRZnCa6y
N27VcJ3zp8RqVc7XvNWg3FXTXrh2ept1Dv+n8HeB/4P+HP62gu2kdnELMevR
65Bu/Osi611LYr1VD3fB1YM4bG/If1NinOLSTmo2udR2VzMaJH5LbFwVcgzg
bo4tF3Fs4Pw5b7tUg16LfYA7KJZ3tj+2mWvW6tE45zwxz8I9GdguZ9CHQ9vp
VvBJwXZZb0a7rBji1k73e5uJZnEna7Pt1JsKbcZVbzPRLH5jP5daDcr9TGi9
Oept19Wjaewe/x0ZewNBYm96+S0jffi2F2zXtKNxwWpQ7vXc/cU+kRr2Nf3M
JfZm9Vb1Job4Fww32lvQP+G7ZuEtN72pf/jv8VaL/gFLectZuWrHnqT2z9C/
QjXuB1v0NrsH+Eyl9gb19tTTU6nlpFzU0wGwg96wmsl/JXubtg==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8608307500000001, 0.879745, 0.8700376], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VE1rU1EQnTTvkabF9L4bsi31H6QitCaVqiRRwW4EFQShtis3FhQ3trbW
hRbaJG5i61/oUm3TguDXVpRKV/6GgiC6cqHneKaLm7l3cufMmXNn3sm5hat3
B8zsAVYeq4WfQmr2PWe2XzGbDmZd+Abh2y2aNbDPELAFu4D7B4lZz/crmdkw
7jdxnkPsfEUx48NmR/DdwZ0N3GlninmD2DrsIXL1E8UxL/NP+v4H8N5F5XmR
l2WuTtnsUxTudlH8iMXzpuei/ZaI798Rs4fIOwFfgH0UlecI+LvYf07E85Rz
XcKdEazEcYk/BMxV+ErIPZMXx5d5+adg01QaMm7ZY++XzJ5n4sHc9LHeP/A/
joq5DA6LUVi8t+Uad2C/4nwC+zb2XxLVdQO6Xq+obvJ+hv/m4a8Dpw+cNfKH
zQVxZN2LXnvmWMTJguphLafBJ0VduYLZJfg/RulX83ci51XyDaq151h8C+pW
HVafMDc5kQ9rPePvm4f+64gfSlXHhnO4hjpulZRjBf8PBOVkn7En2AP38P/5
srSYhr2J8xXwnIUdLOve24q0pn7kQnzqxrXm+jSB/T6qj9hr5ILybQ+xfazf
0PM27CzWTlE5RlNhsS/GvUZypU7si3wQ7/+cg/q7530x4b3B81gqvQplzUnT
daE+7JlzZc1b1/t+0mMt6C15ToLegPqPAmMvil/tWGMTV/pYd8OxiEPLnKyX
GrSCdGCd1K/hPd7wvOyjqSDtnka9H/Xa4Uxj/SqKK7VmrtR5kAO51B2n6rrx
rbczzS3n60nUDDBuOWoGqNmHqJk/8Hk5dP58G/bN8Rz8LKrWV+DyuqIzNW57
X5LrjNfbch0y16fqfC5k+hbwO9CBHcuEwd6/GNT/6/CdLWvGNh2bsezFrvcY
9V7zfS0ohvc77mPvEZeakV8jU08TYz/qG8SZ+Qd3bqBX
         "],
         VertexColors->None], 
        PolygonBox[{{4731, 4095, 823, 921}, {4107, 4742, 1290, 837}, {4736, 
         4099, 826, 1285}, {4733, 4096, 824, 1287}, {4158, 4420, 1231, 910}, {
         5556, 5560, 2549, 909}, {4803, 4168, 919, 1004}, {4333, 5554, 2546, 
         1230}, {4097, 4734, 921, 824}, {3677, 3636, 1793, 1204}, {4872, 4871,
          837, 1207}, {4159, 5770, 2866, 911}, {4869, 4868, 827, 1793}, {5559,
          4333, 1230, 2549}, {4792, 4155, 904, 1310}, {4493, 4494, 1312, 
         917}, {4790, 4154, 903, 1228}, {4868, 5463, 2474, 827}, {4496, 4495, 
         920, 1234}, {3841, 5474, 2486, 1288}, {4384, 5557, 2548, 1312}, {
         5475, 5471, 836, 2486}, {5770, 4522, 1004, 2866}, {4478, 4477, 825, 
         1284}, {4166, 4801, 1233, 918}, {4108, 4418, 1287, 838}, {4799, 4164,
          917, 1233}, {4167, 5564, 1234, 919}, {4747, 4113, 845, 1290}, {5462,
          3841, 1288, 2474}, {5555, 4926, 908, 2546}, {3674, 4382, 1310, 
         1868}, {4929, 4928, 911, 1231}, {4926, 4927, 1868, 908}, {5558, 5556,
          909, 2548}, {5471, 5473, 2485, 836}, {5472, 3680, 1207, 2485}, {
         4098, 5461, 1204, 826}, {4101, 4738, 1285, 828}, {4475, 4476, 1284, 
         823}, {4156, 4793, 1228, 904}},
         VertexColors->None]}]}, 
     {RGBColor[0.91439425, 0.8976069999999999, 0.8460411999999999], EdgeForm[
      None], GraphicsGroupBox[{
        PolygonBox[{{356, 402, 113}, {1658, 1656, 130}, {198, 1732, 197}, {
         1969, 1455, 197}, {2550, 1869, 1429}, {221, 356, 197}, {221, 1429, 
         106}, {1733, 1969, 197}, {1409, 199, 2}, {357, 330, 131}, {1732, 
         1733, 197}, {356, 405, 198}, {330, 403, 199}, {2554, 1732, 112}, {
         1734, 1658, 130}, {405, 356, 113}, {1656, 131, 130}, {4168, 4803, 
         1733}, {330, 199, 130}, {5770, 4159, 1455}, {330, 357, 1}, {4734, 
         4097, 1658}, {1429, 221, 197}, {1732, 198, 112}, {356, 198, 197}, {
         4477, 4478, 1411}, {1429, 1869, 106}, {1655, 1734, 130}, {4495, 4496,
          1432}, {4928, 4929, 1869}, {4095, 4731, 1655}, {1656, 1657, 9}, {
         5564, 4167, 2554}, {1455, 2550, 1429}, {131, 1656, 9}, {1409, 1655, 
         130}, {4096, 4733, 1657}, {4476, 4475, 1410}, {402, 356, 221}, {4522,
          5770, 1455}, {131, 330, 130}, {4420, 4158, 1354}, {1410, 1409, 2}, {
         199, 1409, 130}, {1455, 1429, 197}, {4418, 4108, 1352}, {403, 330, 
         1}},
         VertexColors->None], 
        PolygonBox[{{4803, 5006, 1969, 1733}, {4169, 4734, 1658, 1734}, {5006,
          4522, 1455, 1969}, {4097, 4732, 1656, 1658}, {4167, 4802, 1732, 
         2554}, {4731, 4169, 1734, 1655}, {4475, 4474, 1409, 1410}, {4496, 
         3699, 112, 1432}, {4929, 3698, 106, 1869}, {4478, 4367, 2, 1411}, {
         4733, 4368, 9, 1657}, {4474, 4095, 1655, 1409}, {4732, 4096, 1657, 
         1656}, {3698, 4420, 1354, 106}, {4159, 5561, 2550, 1455}, {3699, 
         5564, 2554, 112}, {4802, 4168, 1733, 1732}, {4368, 4418, 1352, 9}, {
         5561, 4928, 1869, 2550}, {4367, 4476, 1410, 2}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4108, 4418, 4368, 4733, 4096, 4732, 4097, 4734, 4169, 4731, 
         4095, 4474, 4475, 4476, 4367, 4478, 4477}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4158, 4420, 3698, 4929, 4928, 5561, 4159, 5770, 4522, 5006, 
         4803, 4168, 4802, 4167, 5564, 3699, 4496, 4495}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4100, 4737, 4101, 4738, 3835, 4736, 4099, 4735, 4098, 5461, 
         3677, 3636, 4869, 4868, 5463, 5462, 3841, 5474, 5475, 5471, 5473, 
         5472, 3680, 4872, 4871, 4479, 4107, 4742, 3843, 4747, 4113, 4481, 
         4878}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4165, 4800, 4166, 4801, 4335, 4799, 4164, 4492, 4493, 4494, 
         4384, 5557, 5558, 5556, 5560, 5559, 4333, 5554, 5555, 4926, 4927, 
         3674, 4382, 4792, 4155, 4791, 4156, 4793, 4332, 4790, 4154, 4491, 
         4925}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4102, 4739, 4103, 4740, 3836, 5467, 5468, 5464, 5466, 5465, 
         3678, 3637, 4585, 4586, 4497, 4498, 5479, 5480, 5476, 5478, 5477, 
         4370, 3644, 4880, 4879, 5485, 5484, 4748, 4502, 4592, 4591, 4746, 
         3681, 3643, 4877, 4876, 5483, 5482, 3847, 4753, 4117, 4752, 4884}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4162, 4797, 4163, 4798, 4334, 5562, 5563, 4931, 4932, 3676, 
         4383, 4795, 4619, 5819, 4620, 5246, 5245, 3867, 5243, 5244, 4923, 
         4924, 3671, 3696, 5546, 5547, 5545, 5549, 5548, 3864, 4613, 4615, 
         4614, 3672, 4381, 5536, 5537, 5535, 5539, 5538, 4328, 4785, 4148, 
         4784, 4917}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3638, 4870, 5761, 3837, 5225, 5226, 4583, 4582, 4741, 4369, 
         3641, 4874, 4873, 4109, 5481, 4319, 4744, 4111, 4743, 4110, 4371, 
         3844, 4750, 4115, 4749, 4114, 5486, 3682, 4882, 4881, 4482, 4116, 
         4751, 3848, 4372, 4885, 4754, 4118, 4755, 4321, 5495, 4119, 5492, 
         5494, 5493, 4373, 3650, 4598, 4599, 4596, 3854, 4597, 4124}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4142, 5813, 5814, 5769, 4778, 4508, 4612, 4611, 4777, 3693, 
         3666, 4914, 4913, 4141, 5523, 3863, 4780, 4145, 4779, 4144, 4327, 
         4326, 4783, 4147, 4781, 4146, 4782, 4380, 4490, 4489, 4488, 4152, 
         4789, 4330, 4331, 4922, 5544, 4153, 5815, 4921, 3866, 5553, 4157, 
         5550, 5552, 5551, 3697, 3673, 4621, 4622, 4509, 4510, 4511, 4930}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3707, 4966, 4203, 5607, 4197, 5600, 4198, 5601, 4123, 4483, 
         4890, 3651, 3686, 4761, 4600, 4601, 4505, 4762, 5810, 5812, 5811, 
         4125, 5499, 4126, 4763, 3855, 5496, 5497, 4886, 4887, 3648, 3685, 
         4756, 4757, 4594, 3850, 4504, 4939, 4503, 3849, 4593, 4883, 3645, 
         3683, 5488, 5489, 5487, 5491, 5490, 3845, 4745, 4112, 4480, 4875, 
         4501, 4500, 4499, 4588, 4587, 3639, 3679, 4416, 4417, 4457, 4456, 
         4104, 5470, 4106, 5469, 4105, 5683, 4253, 4838, 4252}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4215, 5620, 5619, 4942, 4178, 5568, 4135, 4772, 4774, 4773, 
         4377, 3665, 4609, 4610, 4607, 3861, 4608, 4912, 4487, 4140, 4776, 
         4324, 5521, 5522, 5518, 5520, 5519, 4378, 3668, 4916, 4915, 5529, 
         5528, 4325, 5533, 5534, 5530, 5532, 5531, 4379, 3670, 4920, 4919, 
         5543, 5542, 4329, 4788, 4151, 4786, 4150, 4787, 5784, 3865, 5242, 
         4616, 4618, 4617, 4794, 4867, 3675, 5735, 4310, 4471, 4470, 4160, 
         4796, 4309, 5771, 4161, 4455, 4260, 5776, 4261, 4318}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3653, 4894, 5789, 3885, 5252, 3886, 4652, 5013, 5012, 5272, 
         5271, 3857, 4603, 3858, 4604, 3816, 5253, 3887, 4967, 4968, 3708, 
         5273, 4605, 4606, 4575, 3817, 4574, 4818, 4819, 4820, 4516, 4969, 
         4970, 4439, 4440, 4206, 5609, 5611, 5610, 3654, 5613, 5501, 5502, 
         5500, 4128, 5503, 4323, 4765, 4127, 4764, 4891, 4892, 4374, 4759, 
         4121, 4758, 4122, 4760, 4322, 5498, 4120, 4888, 4889, 3649, 5595, 
         4360, 5593, 5594, 5592, 4194, 4433, 4432, 4514, 4513, 4512, 4847, 
         4846, 3812, 4572, 3813, 4573, 4590, 4589, 5266, 3703, 4956, 4955, 
         3881, 5251, 4311, 4584, 3839, 5229, 3838, 5227, 5228, 5265, 5264, 
         5007, 4649, 3879, 4647, 3878, 4648, 4664, 4663}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3663, 4908, 5790, 3900, 5260, 3901, 4656, 5019, 5018, 5285, 
         5284, 4992, 4991, 3899, 5259, 4316, 5258, 3898, 4989, 4990, 3721, 
         5283, 3720, 5282, 5223, 3826, 5222, 3825, 5685, 5686, 4841, 4257, 
         4842, 4422, 4423, 4214, 5618, 4213, 4365, 3691, 3662, 4907, 4906, 
         4134, 5513, 3860, 5516, 4138, 5514, 4137, 5515, 3692, 4911, 4910, 
         4909, 4139, 5517, 3862, 5527, 4143, 5524, 5526, 5525, 3694, 3667, 
         5623, 5624, 5622, 4217, 4425, 4424, 5569, 4180, 4804, 5571, 5570, 
         4918, 5224, 3830, 5760, 5000, 5001, 3725, 5289, 3726, 5003, 5002, 
         3904, 5263, 3833, 4657, 3905, 4520, 4521, 5290, 5291, 5021, 5022, 
         4660, 3907, 4658, 3906, 4659, 4662, 4661}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3810, 5424, 4069, 5153, 5154, 5155, 4246, 5670, 4192, 5590, 
         4193, 5591, 3908, 5694, 4263, 5691, 5693, 5692, 4430, 3749, 5077, 
         5076, 5649, 5648, 4829, 5292, 5295, 5294, 5293, 4550, 4551, 3751, 
         4448, 3752, 5080, 5079, 5651, 5650, 4343, 5652, 5653, 5084, 5085, 
         5086, 4449, 5083, 5082, 5081, 4230, 4404, 4403, 4281, 5777, 4282, 
         4280, 5705, 5706, 5702, 5704, 5703, 3728, 5379, 3727, 5009, 5008, 
         3909, 4320, 3684, 3646, 4651, 3883, 4650, 3884, 5269, 3911, 5267, 
         3910, 5268, 3851, 5233, 5235, 5234, 4595, 5215, 3814, 5758, 4515, 
         4965, 4767, 4129, 4766, 5505, 5504, 3687, 3652, 4893, 4484, 5506, 
         4130, 5768, 4517, 4979, 4576, 3819, 5217, 3818, 5240, 5241, 5238, 
         3859, 5239, 3914, 5274, 3915, 5275, 3889, 4653, 3888, 5254, 4362, 
         3688, 4506, 4131, 5507, 5509, 5508, 5662, 3729, 5711, 5712, 5710, 
         5714, 5713, 4286, 4288, 5778, 4287, 3657, 4314, 4285, 5105, 5106, 
         5107, 4451, 5110, 5109, 5108, 5661, 5660, 4344, 5658, 5659, 5103, 
         5104, 3760, 4450, 3759, 5102, 4577, 3821, 5220, 3820, 5218, 5219, 
         5100, 5101, 3758, 4436, 4201, 5605, 4202, 5606, 3913, 5604, 4200, 
         5602, 4199, 5603, 4250, 5160, 5159, 5158, 4072, 5430, 4338}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3834, 5454, 4084, 5205, 5206, 5207, 4085, 5204, 5203, 5202, 
         4083, 5453, 3924, 5589, 4191, 5586, 5588, 5587, 5682, 3801, 5201, 
         5200, 5452, 5451, 3831, 4580, 3832, 4581, 4806, 4805, 4426, 3800, 
         5199, 5198, 5681, 5680, 4346, 5678, 5679, 5195, 5196, 5197, 4454, 
         5194, 5193, 5192, 4249, 4317, 3669, 3695, 4259, 4258, 4858, 4859, 
         4855, 4857, 4856, 3732, 5677, 4833, 4834, 5541, 5540, 4149, 4398, 
         4397, 4366, 4396, 3902, 4472, 3903, 5288, 3923, 5287, 3922, 4995, 
         4994, 4993, 5262, 5261, 3828, 4578, 3829, 4579, 4179, 4775, 4136, 
         4485, 4486, 3664, 4376, 4769, 4770, 4768, 4133, 4771, 4177, 4364, 
         3824, 4473, 4315, 5255, 5256, 4986, 4987, 4988, 3917, 5280, 3918, 
         5281, 3896, 4654, 3895, 5257, 3661, 4393, 4394, 3919, 5016, 5017, 
         3730, 5437, 3731, 4295, 5720, 5722, 5721, 4256, 4866, 4308, 4507, 
         4940, 4941, 4391, 4392, 4296, 5171, 5172, 5173, 4453, 5176, 5175, 
         5174, 5672, 5671, 4345, 5673, 5674, 5177, 5178, 3792, 4421, 4839, 
         4840, 4655, 3897, 4518, 4519, 5440, 5441, 5179, 5180, 3793, 4248, 
         5675, 5676, 5577, 4186, 5578, 3920, 5442, 4078, 5181, 5182, 5183, 
         4089, 5186, 5185, 5184, 4079, 5443, 4342}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV0Udsz2Ecx/GnRo90mt1VB5uLmfagw0pordY6EAejLdpaUeugghsitMZB
SEiMhDggUSMklA5VJNaRGrUSsV+/w/v/fj7f5/v7Ps/v989cWllSERNCSPdz
t1cIHfEhPMV1VCWEsKFPCCfUGxNDqJZr0A8D0B9X7PXhvkhEMpJQjg+9Q7hm
zlVMk3fLdeY9kVOTQmjnXfIO9efyGj3n5LV8nn+oX+B18hFOl7fry+AEtVjr
eE6Te3Mqx3En5yaH8J7zeCt36K3lp/yGH3MNt/F6bueX3qWUDzsrRW2b9Wzv
PQdNcn+zqvWUyMUYY380Hqk1cwuaooyHGKk/1zvW2a8y81JcCKvklXihNtH+
JIzDBIzHaHuzzJ6Je3KZZ0ZF8/SP5ENyk/UW896503d5rL631sPtj8AD+zPV
7vMBfZW+yTNzj9o7huMYr3ZWbZ79+RiiNhTDov9BfS1iEJCDFWZNR5Z7ZWK5
vk/yQc8uib6p9Rxn/nWPEv7Ds/m1etDf6p7/nNnGMXIL7/dsrNkV3DP6Lnpn
oJt1d9SgGq1qPbjBc6ecVWz2cc9Mts5Hm/0CZz3mQrkAXXry1b6qfbau1d9u
Xe/cMvsLsQBL5BZ9c82eF/2nzimSp6AQ0zAVTzy72l45Lnum2ry9annyHu40
6z3e4SM+4JX6Il6M+WaXokYtzbxmd1ogl2GH/Uy53swi6w49X7hBrYvr+TPv
U/8e/X/yNz7BxWb94ln8k9f7xg3mZFnv1JPNA9XirNM4R07hQZzKX/imd2jE
DZyO7qW+2Tsu4jPyLfUN1tfM3ci/1S5at7n7pqgX6chERtTnnjk8GFnRWchG
BU7au2PebSyTl6Id/wGKI6EW
         "]],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV00lsjVEYxvGvKEpiarWstLURGxK1NofQRlKpBJ3bhERnG0qNETMJ0RKi
pkWLGlpqgZWFztpEDFUqaZtIUHaGTn7fTf73eYfnvOfc7zs3Ibc4tSgi8PHV
PQ0zg+Aj3qBvVhDsjQ2Cl+rRMUHQLx9AO16jA0umB8EH2o16a2qig+AKf5r4
CR6jAQdmmMszTHvpKdqm/pv/DzaLv84OggL1Tv1C2kWTzO+hB+WNPLW8d5Ap
zsJh9cAZD9EIWmnveHpaPo+eoQm0mH43v4TutL4AhZhvxnj9CRiHiYjEEb4p
dComIQqTUWV+jDmX6E3rb4Rnd8ZBtZ8okhejQn+x2WXiUpSgzMxfPKV0i94j
nnIzz8oHxYnic+Jh3hHUq23lW6G+Ele9g2R7VepVYYy3gaeMZxdG5SNYr5bH
n4FMpKNNPYu20lzaQbNpO82hcdaPeM7N4f60hY7SazRJvzp8nvaMx1rzt6kt
tSaZpmADnvEUqxWhjmeP2nO1C9acx7rw7H5Dr2fwGZv47vEN6PXjJO9ca4bo
CewW39VP5cuXLw/z8Py8ecjHIr1ynhxxNj6Z24M0e1XLr+OifqRaFO8wHcEQ
xjCK/WauNnsNVuGpPDG8X+E9Q0Z459SW6eXROfQ4jaXHaFx4R/j/mbVP/pdW
0Ay19PA94yEeoDG8A57rQuf7QWvl32hNeD/pRp4WNKMJR9U/q/f5De/D/6P8
vvotZ7qNFPFlvbrwWeIdz1ssML+FtuJV+F7RhC94wd/F24kd8u1ow39g/6A0

         "]],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV00dwjWEUxvE3YXRJpGBH9JaFHrGw0usgeokuWiwwbHQ7ZcEwY2wxSNSE
FBKJBGEwo0avI8pGG0bU37d48j/nOed9vjf3fjd1bs74FTEhhDR/hsWF8Cg+
hA4pITzGjniV1wWf6jvhE+yMG/hz1SXJIczD81jBS8TCliGMSAhhOy6mbOrX
IoRSe02cLcOmmG8/Dsv1zfAiNseN/PnqC7IWYClW8pKxSNZI2TtwCS2l/rIr
7MU7ewkTsMB+ElbpW2AlJuIm/kJ1maxFeBGreClYLGuU7J24jJZTuuwBdNnu
DbxJt6ha/ysphDr6SVf0KfK/Ol8ua7H+GD+X8mg3v9R8NF7AMViGk+21jD5n
/GvvHwXnr+nrYSzFUGs7reibc9lma9ztgHvv0Y+lXfpxOMXspP2pmJEYQld1
tb1R7pxpXiljElZhXztd8Vl0B3ut6If6if00/nN1N+xB3Wkzf6CcLbjS807I
OU6Z6kqcgJdwIqba++L55frPWIFfMRfzKMfOejkZ9ppSb/l9qBfVem7f6B00
/x69h+7Vgd6qe0Y70f/m/CE5/XFA9D1F74Wccmfu4G3awKvVZzlbp9+q30Zb
KCF6v2i/+Wr9HPVneY3kN6b3vocP9JEemr3DWnpL5/UN7Ty0v1p2c/0qbIYN
+CV42N4hOkhZ+mLzT/brmxfrX/Jf0Wuq0S/x2WTTdfcs0tfYHeRuI8yH00rn
G/D3uesL/VGzIt5s3jmchYW4jn9OHeM5hRgb/a54Ac9G75idAvyHGfxhsoZS
TvSu8ffKf64/YnaWN5OXjzOwANfyz6h/q/PxD5bxfuFp/U88hXWYzh8iazCt
0Af+Zvn3o88myuFN553CaXga1/Dvq9u57wNsj6W8VLynb4N3sS2+wf+ozLKh

         "]],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1FdslmUYxvGHBIIItOAKMhRCixoSDzkRVIaicTHUQmpFTOFAkGUVKiQQ
pK2KKEOGJqBtKaulAxDaIi10fJ30a0FMCBvEcWQM89Dfc3D1f1/Xdb/v9/Tp
l476cPGMRb1CCLP9OJsawpyHQjiIvz8WQhuVmz+QjXwkhLlYyd83V+BB/TcP
h7CBsnSlsnOyViozvy8bbDcT9/P3zPuwTD9fdsacgcX4m6yFdptnyZ60Oxv3
8HfNJViqz/dZBfSOrlB2VpagIvO7slS7b+Mu/pZ5Jx7Qz5P1mKfjdjwja6Yd
5hmyJ+zOxB/5f80/4H79Op+VR2/ptsp6ZE20zTxNlmL3Tfye/8e8Bffps2VJ
87BHQxhBw2kTXz84hAW6hXQjnsO7e6ibNvN/e8eKQSH8hRv50/IuSkbyndhB
f+q/4/f6rIHm4ykhDMA9/LfyG+aEvRa6zrdjG7XSTd0fdMeZruF1apI3U7H3
DJUXYSPfQP30D1CNLNv5a7E//yBtdtY6WaFsLHZ5NkmnKUvXjdW6TnyP78BM
TLM7zrmuescGvIRX6DLl2Z+gz8dlfp/D9g/RXXeWwNvYjHew3c48O0k+G7tx
PlZiFS2Nf0M7470vPd4VpdCAmOtTMQcz9RtxNL8png+Peq7FeWfxCczAMfZ2
yo/hVn6Y8w6Pdy2bHM9sr4FvpHJ3V0G7dM/Kf8IqvjLedbxz+k/egq30i/wo
HYt/Y3dyBA/TIfqIT9hJ85ltuICvltdQLV3lT+CvdJwWxr+5vU/ineMivk5e
Tyepk6913hqqpo/5Amf5kkbr0+g597tY3uEu6miJebxsiPdNwGXx+2heij/H
e/TMp/SCbnnsZPW0wvyirLfd5zEnfu/j2bBQn+6ZMTRRlxu/87KT9Ll5kuxx
u5NxVfy/ZF6JRfrPPLOcXtKtlXXJTtEX5pdlfexOwTX8efNqLNY/5Zmnaapu
nSwpa6A88yuyoXZfxQL+gjkfd8ffwzO59Lpuvaxb1hj/B5rfkPW1+xp+zV80
f4Ul+mc8044n6H9LqNtT
         "]],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  Method->{"TransparentPolygonMesh" -> True},
  PlotRange->{{-1, 1}, {-1, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1566923866]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->395589314],

Cell["\<\
The surface is split when there are discontinuities in the function:\
\>", "ExampleText",
 CellID->84736396],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"ArcSin", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], ")"}], "^", "3"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->362858612],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyEnXmc19Me/8u+XVdFllJc2Ql1UXGdka0Ukn0JRSrZSrK0IFtJKG6yFEJK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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmH2Q1VUZx8/ehd29u9xdLrAX9t7L7t7lPYWIF50pFGVLBxmMJQJKBgtp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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllWto1nUUx086cdsj2WN7nql79tx8umwtWbopVNqF3glhF7ZFsm5KLmu+
iuwmThtdSEqIubDcLILC0lpEQWhBUSsqZ7S1UMkyw5iR23QIavX58n1x4Hf+
55zvuZ9/4f71t3dOi4hHoTJoSy5iM/RxRcQn0M58xPOZiFWVES8mIt6tjTiK
fAX8IPx7yPZnI94pj5iF/gPzI1rTEY8AthR+eSqie27EHbMi5l8ScRzbP6Ch
GcYs1US0oN+EbjPUgv0H1RHbkxEvgXkY3SPQTejeCPURz9X4m5gZsRX/Fch6
oNEKx/Av8S0uRJy6OALVeKwKGZSbHbFnekQjsuMITmH7DzovZJyjcnsLzF3w
k+B14qsdzMK8iDuJbw7xXAotI97n4PPg1ZDPFPIS+EexHcX/ALG9AcYU79eh
erDOQxvBqwLvL+QnoGXENlnuWDYQc99sx6Ta9PKtK+EapXlXQ7dg30WjOtGd
qnWsz6JzL/rt0Bi628C/j1rfkHJsLdT8HPk+VYpYWeV+FIntburbm3SNa6n3
p+jfxvsHYtqOrzXgb0o4hoexP4PNYJlzUq5vol9MOufTOeekXFSzRt6PY99P
PmeQX4T9Sexb4V8jnrXUazDl3vaAcV0x4tqisQrwU8TzXdqzop6N5Zyzcl1d
6Vm6DPt1ZZ6pHvz9hHwN9hvAXAB+Gzo3o3uMb0O821PuTTeY55FnwW+kFoug
08S2ruBYleM36Hag83K5a7QU2UJ8NFCbCeZlH/w4Nl+UuWd6r0J+Rbm/nSPe
Ab6lKtxzzWY7/IHwjL7C+2TOuWxmHkewnQ510NuDmhn819GfNL5TSdfyBD05
m3BN68nn65RrN4B9F3ij4C2sNMZW6vd2tWdVOR7KegbU+xHwL8zzTmgXtHPq
fS/ffkx6Bo7B98F/hGwcvgHfh4jhW/TH8TGU9Q3Q7n8J3lmwh7OOfQk2v2P/
KvZ7E8asQ7cFjKL6R/xX1bpn6pVqVsM+9VfbVj2V7SZyfD9hjPVzPdOaZd2U
PPId+BgJ76Sw68FckLCPtQXfAO2+Zq6B9z0578aV+NtPvWbkfatqwPs54xuj
23Kg0r1XDZS7ZmAOusm8e6Ua70x5xjRb6lErsn0ZYymGRfj/k2+TCd8gzc41
Bd8azZBuWTFre920X6rcU/VSN2UCrCPE/CTyu+Db4D/M+paswP7vjHdKu9SG
fEfJPVD9vieuQtY1V621Uyup72LmfZgab2T+h2tdE9VCO6Nb+kTGvdRNPcj8
XJ72bmiHmsFugr4qc0z9+Huw5F3dje5q3ttKnlvN66/ktwW8p6f5Zuk29ed9
q3Wj9G8Zy3iW9I/ZRXzXp42nm6Lb80zO/x7doAvwh7OeXWHu1q1NOxfNSF3O
N1a3dTi8K0sK3lXtzGfaxbx7myGH39DtzviW6h+m2e4ouJaa8f+o4a1V/hct
hybRfajgf4FqoN6qR+qNejwT/vOMsbXzTdyy5qJroR7/D14zGUM=
         "],
         VertexColors->None], PolygonBox[{{6098, 5458, 4229, 1776, 5137}},
         VertexColors->None]}]}, 
     {RGBColor[
      0.40132155638280137`, 0.24502302103537946`, 0.6810863131559426], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3ecV9W1xS/MDMP0GZjf9PnNDGISpYQmCr4IKkYleUHFSlFAfYIUFfCp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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHeU1dURx6/swhbK25VXFn37CmBUpOjSFHIUo2jAnCSgiAYQBVRQiggG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         "],
         VertexColors->None], 
        PolygonBox[{{9314, 8757, 4372, 5532, 5113}, {8768, 8767, 6500, 6499, 
         4491}, {8777, 9313, 5111, 6563, 4599}, {8287, 8288, 2862, 5074, 
         5278}, {8339, 8338, 6143, 5068, 2937}, {8740, 8741, 3692, 5084, 
         5464}},
         VertexColors->None]}]}, 
     {RGBColor[0.5204022492794406, 0.45207218645505687`, 0.8484686325719819], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFm3fYltWRxp8P+Hrv9S0fYBZ1pUh1d0NJVkBNpNkwQbEbEzXFtiqgK2Ci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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHeUlsUVxoe2u+yi30f2K7vwVcRIkeYiGj1BUBM5kaOAWCAiCFhiKIoo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         "],
         VertexColors->None], 
        PolygonBox[{{7981, 7401, 1206, 6120, 5210}, {7693, 8690, 5395, 6220, 
         1990}},
         VertexColors->None]}]}, 
     {RGBColor[0.6194499977487211, 0.6169459699198296, 0.9107669141521851], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFnHmc1uP6x5+ZmppptnqeJpqZZ2ae55uoHDvHD0dEoVBRSaUi2aNU9sqa
kqWkxZF9PSRkz9pCJY4lImWNxOFYEyV+n3efa17nj+/rez/3cy/XvV3L57ru
b+6kc445uzCVSj3UPJVqone/TCr1Z0kqdXZBKnV5PpU6Ikmlvk2nUqc0S6VO
0zNZhRcq/1rlj1DZeXo30++7lb6xMpW6Wu0sLUql3i1Lpe7Te5LK76r0LmWu
O7rY7dDeVap7bLtU6im1f38ulWqpZ4XK/Vd0XKOyJ+v9faT76j086tHOJhE7
SulPlN6g/67Wu7fer6qtCzP+bxe1vZ1oG90ylVqj93Pq7x79d4h+jy1Xuaap
1PTaVOqmulTqJLU3WOUn6PlhO427PpXqoWeM5mKE2rpeZdeqj1Eq95Hes9RX
J5UdoHaPV3tnqMxixqv8kaWp1Dml/s1cQOvHQTP0Up/2XtV/a/itNh4VbfeL
toZS16H8Aco7UH2s1Jh2r3QftH+Y1ubsmJNbNGflehaXeZ6mRP4/NabF2VTq
Es13g8axVuM8VGO5XWUr9Lyq8s/o//caUqnxavcxpa/Me95OFG1D9IxUWwdW
pFL/0FMnuh5Q2eNVd5bSz6n8B/p9ucp/WOQ2TtT4pun/Uj0vqv271fdM5U8U
PceJhhlqf5JouEH/t9DznMrcqXelnuVlXsNJsY7nq4/zSj1HReq/qZ69VObD
Qs/ZVZqDIzQvh+vpojav1lzdLHqGaw5nqL0yPQtj3z0qGkaoTvvmpmc7pU/Q
M0PppWpnLeum9Bmi//Zm3mfML8+ImM/9oy513tLzpp72qvea5uE4zfVK/R6p
+ufoGV/g9WfOdtDvX0TbMpXZJFqPF417K90v5fc+kf5OZU5V+iOV+UPpfpqv
7TSWxzVnl+h3b86l3jP1O6v0BLVdoPld39T7Y27Gv5/W3t1Ja71Ie3KLyl/T
4DO9SenX1P7vKvu90j+K7hVK/6z0r+rrYJV5S23fq9/TlP5R7z80h3OUHqt6
x+jZqHGdr3NzXrn3cCuNv7X6bKn3FM1PRulKpStbeB6mqnxW5aYV+Lws0H+1
KtNO7zNV5nul/6vnfPX7D/X3gej5Qe9h6vc69fuX0qNEW4PSG9Xnzqp3gdq5
SOtdFf32FF0T8/5dqbFfWiN+pbG/3krj1fNBC59Z1maS6Jit9yw9Z+n5TW2O
1lNb6Lyr9f9MtX+k+jxaz/nqJ2nivcJ+a93U+490P/Wb1xx2EA0Nevep835o
p/JDCt3WyaKlY3Uq9TfR9mG53x0K3e76YtddINqv0DiHaIzDtW4nqp19VfcN
5d+p/GuV/4ryhyi/o/pvIT6wm+rurHaWbp9Knd5aZ1jt/VHofpep7gSVHa7n
aaV76Nxcp3oZPXepv31Ud4jem+MMsP+L22ic1W63e73Hw1i26P/3o81XlPeN
nvmck7baO1U6K5rfAvGnl0XrmRmvL2sLf6KPQdRX+n3twXGqO1jt39HMZ4xy
7JW08ir0Hqy1Hxo85yCd2c569lD+obE+M7Qu+xU6XaY2N+m9UU+R0utE/7Ga
6+u17iUab7GeA1X/c+UfU+Nxwe9e0TNdbdboXV3mtUDm3BtyZ57onK/nVp2t
JZr7QayB6Jqt37ur7BmiYUuB08cVeH5+1XOx0qNV7lw9i/V7fBPnX63yZ6ud
2Vq/G9LmH/8J/tNH4zpafe5f6Lm4PXgOvKqjzlLnAvNK5uu5IvP3RXqmKV0n
et/V87N+v6r2rxOdBRmfy2zIpseLnS4vsHy4OWTED9oXD4ielNo+uKnp2aGp
98HGoLmPxnuw0nvquUzzcSV8X3l9S/3f7CLvNfYcvI6xbol90lv/99IzUWWO
0PtwPZcrPTTKU6ZYtFyt5ynRc77avrDB9X5HxmlP7y56LtI+vETPvBLz3B2a
m0bmED7emEea+fy90L9J/0vtPaznZrU5Su9zG0xLtfbq9Zqre7Q/EtXfisxK
Wf7cHTII2XhryMc/owxl2R+v6ZlZ5L62i723UufvXdG8Br6o/8eW+cx00Hp/
id6g9AVNnT5P74GF3rvUZe5nxvzXq16dnne0d9qobpWeka1cb33UrS53ulzP
CxrPgyGzFqvsnRnrB+hLq0XjcL0H6r/n1Ne3Sq8scJrxXql2rtBzinjjUToz
E/it9l/SuKv1rBcd7TVXZ2muHtGadNJ576hnR9HzmdpZpHZ+UDvLdL721flq
09LrBG0VzczrVuuphm7RNjbt832CnoVqo2up5cBzwS9eVV7/Up+dpWrz72qz
Sm0mouFk0XC9aLi7xOvRTs/zaucrPTso3bnE7x6hEw0PWT9F4yjR80yZ/28X
ZWrKPY/wzHaxtj1ibpLYDzWcFT1fwzNy/k36bp21z9DVNNf76Pfeeoo1b09p
DIdorh9TGznRfKLKdxXNF5RbXqLzdUx7T9ymsXZSOy+pndPUzkfF1p3QoVi3
D2PtZmmPztTzEvuu1HovY5uhvBvhfSpzm9oZrL4mqp3ji63DoMvcoaez0hcV
Wc9EX0JujWvmPtA3Nqjdr+CHyp8b9eBj/1Z7WT0/6r/fxLPniF/c39xr+2Xs
vZ4qd22h99ojKpvR8zZ7N2feBF8aCa9XvYEq31Vzc4PKD025z3eUN7XQ4+A9
LOX3tEjvrXGdJB51Jbq8xntBheX00QWuQ5n/pNzmEL3HlVvvbbQbrg3bYZDq
D0x7vy4vMi3YJHmVL2nq/p5qa75zlZ6yFtYLrlc/R2rcD9dbPt2jMZ2FDFb+
1gKfJfbJb5FmXJO1ngNF92b2eqH1AHSA2ap7puqeUGBetUPwru7q9ynJ0IO1
H75Qva+wT7SOz6repXqeV/lK0bCUp7n58ZcFzq8WP7tU+2zLdrYx0DGxC7BT
vm3uNYff7hA6z1zRcIZoGFhg2wIbDVukQeOt17Na6St0HuY09975MW3dkDkb
r3pTRN/EtG0J9LwjCrxnHmpmOf+2aL9PZW4U/ZPU1+mqc3yB5wGejUxZpbLv
NbM+lajPfAvrc+gktIGeMKRx3lS+ocTyH1k/TXM1Vc9yzdUG9fOh+pitvj5R
+sy8+cFazcki7ddPdFY+TqxXoVOhW/TW00ttTlIbazTni9ROF9E4oNb53Qu8
lkODT5KGZ07Tvpuq5wlsK70n67kz9uHmAu835o80e5K548yxN6aor2v0LIa3
ibYBenYUbV/r2VBqGT9X++uhetO3TjSfI5qXaCyjSz1P6JnoW481s+49U+3N
aGvd9lyVPVF13lD5e/ROaU7O03hvF/+sFP9crf08XWU/1XhXtLJOgnx/Ve2c
q9+jWlkvYp+cGzZLvol1NsqcpH33uuZnr6aWRa83d/p09XWk9l5H9fVh4rVn
3Ter3zNrrNOvUX5T5d+m/K7i44e2NA9ELiIf0QHgjeSf1NT2PHbaiNB/SHfT
kC5saV2QfVBSaZlQq9/3ip7plbaV4cGDgw/zHhJpaPo6ZdlRrnF0kZx+TbR9
qro3KK9XsfvZNfpC36Svz0RDJTp24BXgBOAF2P6UJf9JzdPnGt9TGud89XNB
YB+crdFKt6q0fKjJ2I7Fhh2XMaZykNo7TPR8qfU6G/s943O2pcxyGHk8oIn7
2TVoWKG+bldfk2I+v08bK7i4pcsjuydVWodAf+Dswutot1foruitc9RGX63d
Farbu952DrbIA1rrn7LWMbDn72xuXfwW5U8BN1Cb5ze1HCC9KWvZwO/VavOS
vOeVPuH596vfw9XPThrjDhrTFu2Ns2pM2+Eqf6j++zptvXFZ8Af2xdD43bXc
ej/8+C7Og2gcq+cWPTeX2J58lLNSa93pTLX5f6L1LZXdSWM7RWN+tMi6NTo2
OjB2FHgPcvk0nePeoX/vHvumi2gYrHb6a07aZnyG9qj2OaJcz2gny95Bb23i
PNLzm1p+IEd2j7VAJ2I9pqRtQ7NnsAG6038L1+sZ7Tyjfvro+Y/q7Kj/v9De
3FvtdEG3LjAecqDo/aPE+uNl2IXiJwPV7vvYE0XGWCZqvo/IWvduojl+R2PZ
V2WuUNleWevtZcqfpN/HKr9c6b00b2+mLTOR68jNVKSHh4xFfv+odP8Cp+GT
6CzYc2A+LdXOKVqPc0u9T9gj6Idvip7u6ncyfF7po7O2v5DdFcGTsQFJI8fB
D9KBIRSDe4n+/UTnfMm5RGv9keZmSp3tW2zbFipzjMZyVMYyqTLaaab8zap7
qPJXqt+jsrabninyuX8q7GB0JvSeEuZB7RzJOVb5Hio/pch7f13W43lENDTo
90StQY1+VzexDQi/HxD6wMW1pg/almhtv9B7kJ4/Cjx3zNtirePL+u961ftC
73UFrr9Oe/JzPUv1LFKZF8pMQyvRdqrmdqzm9lut+311ls97KL1W+fdmrPed
VmxbYJL+35K3flyhulM0rv4Z29+X1nnNuum/rmnr3OBq6K5gb2+UGp9F1+T8
fBQ60l8FlnnsDeTZbaHDw1ewB5gHdGd0aHRp9Mz+xdY1N0dd5ONlomvfxGd/
Rqn1HPbPGP0eomcQdrfGvizs9IVKP1nm/fws9nzM41SNY33etGLzHFNsPQiM
CEwKXGgV8jFrHrigzPX/VN3lzLHSBaL1JqWn63k+sIElkc86/BXjRR/jPHAW
GAf5G0OfOaC5dRr2AnuCvTdV4xuqPTRZc/42slLpy5T+Al6op0m5zxZt/or+
oN915d5Ht4nmW/VcXGSZ36m55SE2IvjjNhxVZX8Rndkyy0P4DjLxlzbGm8CY
VsaeY7/9WzQcpzZna34/Vv+X15q/X4uNovSZKnNjhcv/FPrP1ki/F/2irzaU
m1Zoe11tfqw2H9S4VqAD6Kztk3HZA4LOAdHOiaFf/Ro61T7lxl4+LfG+Yf/A
KzgnX8TcouOi6zI/K7EF6Ev09y70PFPvS/hukc/PT4GLUH9OqW106qNjMYec
x/fK7JNgrzfXuXhLNO8tmmep7Ql6di00L6xOzA//o/dRyp+k9Okq31zlW6j8
es1bez1FGkdzlXlEZbor/4YK7wP4JDoUuhRY5Wcq203zfJbS76r8YyrfM+N9
zH6m/A9l5pH8bqEyS1RmVMa4E9gJc/Se8s9T/irkido8XG2eE/y5OvbeO2Cn
KjM3HTwl1nFRzjoH+gYYMfJifWAR0Im+B7YGZlaj9yX4BBqM94ARghVeUmAc
4/1i8/gd2pnXwGfex3YtNv43IrBV8Lr/5q0noSOd2sJybwE6XoOxNnC2G0XX
qgbbwZ8XG7PYVGD+QR728NpStwk2CwY7ItoHyyUNba+r7Ipir+O7ousQzcVf
YDCtrPcxLnSvznqeL/ZagsejKzZoLL3yltWjVa9E9ByWsb2N/oVe+lKx54h2
nhZfWV9vPoeOAc42GTtFbfRT/bKM6Ya3wTfeUp9vlpvnwU/hq/DDXUqMg4OB
z1Xdh/KmDV31l7ame4ryrs3bTvpGfX5db33jANG8G/MrHnC32r5LTw+13Vdj
X561jwJfSpfQH+ZJftWzZ1r6THQM3oLdDF6Lj+PYOuO82BzYechT5Cp6PHIT
+XmrxvdvtXMzGEzO/g98H+wB1h/dlXNKPfZkO/Gl6dJtlqv+KpX/l8o/XWlb
qH2pcc4Paq2Don8eozl5oti6VrrE8/GYnh807r803n9kjL9tDNsSfI51x/aC
z6BbMN7mOo9jyq23Fza3nEc+ol/0Dp1jqNo/qMB6CPUOirlqLzrmFxujg5bH
gx7WmTT6Z8/Q+8jfW2N6sM7tTtZY21TbDmH9lsfew1d1l/p7KPqmP+YHv8XO
IbPAA8FkwRbRefFzkM85RfeDn5ykcW0t8e+TtRZHaB8sU9s3a27+mTeu8aTe
49H12ePlLo9cxK7tHnwYH+/W8PPerHm5vYlx45GRxn/zm9qYmvd+BbMcGLYh
8w1ewJyDR00PHOck7dudqq0jjUobP4aX/6p2atDllP9O2ryc/cy56hx7b43a
WVZh+duv3G3UoYeqXhvVb62xJPgCSjxGfC+96sP/ovwJyv9Z7ZzR2n4R8D3w
yvZ6rlK6uo3XhnVhvNgR+Kd4/zPSXXRGHq/xOr2i9VxS5/Uvae3zw9npX/w/
rA6dGbwJHOwF0ThQa3GrxvaY9vMbqrsw9s7C2DNT2wAuWmbjV7gnePHv5eYv
E1Vmf7WzX53nib3zUuwfsBTwJHgd9jq20qTgyfBjcOYrVfcY0TA0YxxoSolt
zzENxsHBwJdqPWcmtkdv1xyeWu/x/5y2vxaaNur/Y/PmT+kWtrugf0ypsQnw
RHQWfKDIGWTfltADTwk85D1ku8ZxQ96+roMr3R72Pj4NfBvfhO7xZ+h1h6nN
buX2Hw4UvXvhXyv1PExu4bl4RbQV5233dtBYP1X6EeS45vwXpa/TOPqW278C
X326zPgNsvWACvsCmTfsK+wsZM1OamdNzrb4pS1t/xOjAA+5Pnx+xAF8qfIj
RPN9LSzPGCM468WB+/yp//8qNmaV1bzW19s3vYfGsme9+U1ztY3vZbnKPFvu
fcT+wXbGbgafZP8zBrAU+BB8EB44JfYbuNNSzcN39aYDn9if0S/7NVPifcfc
PJF4foo0xp/qLW/on/LQwJnELmbvwf82BP+8X/P5fZ3Hc0Qb26jYp/R3Sowd
XjEq+Ea7cuO6nEfqgN9Bz0K10yrv35Q/N+YfO6dn6Hg/qL0++v/YEu8R1g15
ujn2E+NlP78aePZRqntkhX0grAcygT0G1gAdpI/X//311Jbbb4PO/2Xw7aPD
7j5Hc7NRc3JQxr61l8JmQ34dF3rpNl9+6B7wxZuDN96iMV2k+h2oq/f+ddat
0PvRI7D3Dwp5hHxh3CMDZ/sidB32Hv6Ps0MG45c5NXSk26M8c/tb3hgQ+A/1
1hXbzkJX+jzS6IH0hc4P78W2GlxgHeTS0EOwIzjjYCacc9Lo6o+I/jx4ltr/
Ve99tFd+S9uGPiqxHb2z3jvpv2eUbhr6+2rWS3vj1mrz2LTqLdFeP1VlnlfZ
iejugVFgL6Fzji+3jsB48RG9Xma/dpXqvqu6Z2fME+8J2sBcGScyK6syW1Vm
DGXa2UcOrjNevPn7GuMubZX/veg+IGP6sGvZ0yWi5ey8fWXYqbTJvF2lvFaJ
+V9WbbfVs1prMEu858W8fUfzQwdBH0B/BIvh941px02An1+tsn3Vzq/wde35
B/POrxU9Oc6hyl2mufqh2j589NazQ3dFpwZLg48Xi/aH85Zz+E4XhY0NBnFE
7MkdaTPnOKdbVf49PZ+pfPuQj7+kPM/4RdhL/1fiPpAVjH1l6ACNMUnEcoBr
Y6Ntw5wKjRcj6/H5XBDyBTuDfYbNgv77VejAt7TwHKE3PRHxVfCUDprLL2ut
06HrweeQ9firj0vss4YHkM/+xD4Ay4Rm/GxPJva14cNhbhg79gjzBjb+KjpP
Ysz1rTLb8dg8rGFNrCN27cqwgx5qsG8Yv/DGGOPVYdfDY7D38aniy8YX1jOx
LYEdcZTm/Hb1t5v6Ok3jviNrubi+lW2Mb1rati8st+7NG3xnm4wMPkSacsQn
PBS6NbyGcdWE3oxOiP2GDfpAkWVCj9Djm5Zb14bPgiV8HnjC5jLjHI3xdrwp
f1/UJ320xtINn1Hadh62DPwZe33/wDFeUpkhGuP9obsdHPobvgj+Z+45w6vC
jwOf3j9sH/DOFoFBX5Wzjx//ProNcTb0h38JeXlH4G9rw/ezNfLACtCxaRO9
+mXRswxdVnM+SHOWCxkDxtw4NzwPxByBWZ8YMSSHaKy3cIbTxjvI5/8PtXar
6x3fhk1GHnzy4gbHIhCHgJ7A2eBcYHfOCv5/TvB/dEXO7+wm//t/dpxldDR4
POXPDvuUvcpeJBaJfsG/wcLAwdpUGd8E2yzX/zUtLJfR238NzPfX0Nu32Saa
1w2BPzAXK0Pm9tVYn8h7Lt5H99dY6ku9vqwXvPTSBtv22PV7JY7jJIaTfXFN
3nvj8gbHfBDvMUD8anm19eiu7cwr4ZPTwmZANt1KHFm96d4H3bWdfYVzIoZk
ZMr8/P3g//iyiXVB91us8meozQX4eZVun7VvB//zWzn7oIkRXBBYKLEJC3OO
T8Dn/HDOfmcwDGwT7CN8kr8VGoNhf81t9FGWmUeAGeF7HBTl4ePUhbcTLzA5
55gBnqcDlyFW8bqcaVkmOm8SzW0y5pO/Ba8gPmBD4LrwEGxO7E3iEGflHIsI
PeRTntiDPyP+4JJSzw1nCr60KeysrVEGTAO/8e+F/4vT+T1oJtZyes7xloOC
HupiL2yO8thrW6MdbDnkEvjD7lqr8XnLY2wqMF/wCXyw2+yNlGN2sDXY05vD
DmGf11fYv9zosxkS5emfNWCM8FHmAr8fa0A+NLIf3489uZ/WuyZt/QG/zbAS
08E8PRjtXB3tQwMYBPg9sRbEj2BLNMZP3RH7CiyqNvCoGo2xR846PZgpuCr+
vkZfI/YneAj54ITQODf6Je/RKE96fpSBF84Ifri79sPIvOOOH0kba38ucBD6
R89ZVWb8EbrrRE8/ld+p0n7CZ2Is8IoTYm7xr87J28eKL6w8eAL6LHYIsXkV
GcdyEtdHbAbxN+AnxEqAkYGPwXtIw396qc15avNw1WspmTaszj7dC3XGN1Qb
BwMbRX6gM/2kcfXOW9ckBvOkxHGY/24r+Sf7ujvroPO6U2L8YWFL+yvRe3fW
705pxy08WmLaiAvKKq86bd8buOl5ibHTr6QjdKq3DbBznE/OJm9iBYgNwC8J
ryZOm7iFXNggfdTesdEub9pAt18rnrWmlekai79R/b0pPnt+meO0mLea8P91
SRkXGBy/wVQYG+NCDyYOFxwKmwlbi7XAd3R/iX0vG8uMyeMfR+dEN6ZNYjlP
qXU8J3Huw7KOdceWxe7CngXrQW/iLOObXZ63fxad/dnQ2z/TPK0UT15Rahwf
nxg40b0ljouCl+ysumWq+5D+w7dAXWQ3eDu64ccFfkMb9AzXXKyqcSzAh6HL
oyd/p/yzWmvOI96K9uEb36rtO/TskTFmAv9HDoA9Yktjy3xUaqx2cRPjEM/l
jUVsw8NjHX9rZWyGOKIzJfsGVDtWmdju1TFvxGitij2zpsT0QRt2x4dB/7EN
jtHnPIC7/FFr7OWQUu8Z9hHvdtEvcolYFmTTQUqPE22fKb13O+uR6JDwmVkh
xz/QnP83a52lldpo2cJyH5/GgNAn8R/g98Ce2rOd7xhwv4A4e+x+Ygm6q49D
WxlTwq6alPeeOlXtjxX9O6BPKj2v3r5rMBD6Yg7hpb8GP2e92wc2yP+VQQ+8
AT85MUsVLfyb9KU6199XO26il9Z0YY3PbE5jSif2q2Mn4//Hhm5dabo/C52H
NrfxkJSxN/BI7Ev0EGxMMC2woWlhH0MPOs9N6qtI89y1lX32owPDJN5jW6xH
gWPGx0Y+/IUYPmyx3TQ/3cWrJ2QsA5AFyKuXS61fMDZs6qGxH4i9aQg+0FVj
ulDn7QtiVTSX2+v3LhmXPTHKbyGepd6/92/nGBriZ+YH7ozOmQqdF1wipzaG
583Xj1d6utIt1eac7RxTAr4LRlEfNHBXY2ze8fjIWPKRs/ixixKf24vrjXfD
q5kP8A7m5G+qW553HP+uShflHdMJrWuC/rzaeFb5gzKO4eKuBvbbwYlj94nb
B/tpxB3xVeJXw6eG7oxsB6fd5ssoMeYzNrFsQC7g2weHw74jHgY7ARuBmLuj
ox3iqztHnAxxNKtCriHfSBNz8w42BHpSxjIFvxtyBQwG/ytz+27IRMrjr3st
8BkwhgWJcYb5ifkaPI26lCEGr7E/2ga3Ia6Z+Drw4+WBIVN2RZQnlhKfOzj1
y4HzUJ747scTY7HohW+F/bg5fIXQ9nzojcTOgVW8EXgFb37DV/n/7ShTHfnE
lk+sdDnK3J021g+mj69yUWBND2i/98667Bka6516zqhx7Bm+b3BVfNPEI+Pv
wwcL3g3Wja/8lfBZE9PIGmP7Y1+yTqwRa8hvMGRifq8MTACc6cqIAeYOTXGU
Zw2Ya9ZoWeBmzCH668sxb/jJ18Q8M+ek2WfM66Iog9+FeMbv0q63MHTjn8LP
fk5g/qSpS1/Lw++/PHwB0ED/y2KMS8JPT93lkQ9t8AZwVeQy/m94HvPP/GGD
Ej9ADFnn2M/LIs6C9ucG3gR2ty76hZ6BFZ5r5hmfxrDW9kkQm4E9AmaN35a4
Anzo/CbdP94LIn9B2DCkwQSw1/EFN2IEYALExDYNe479RkwC8uWGiD9kD4Bj
gJX3j/f0wM23YTIVxispS5rzC/ZQGH1hK9I+/t+nw7YhPpMYk5si/oH/iwJf
wJd4TcQ6jotYcfYMZ4Oy0EbdF8MuAzeEZ8PPiKFDlrCXiE95NnGMCvrufcEn
wdbRx/GtgheAG3CfBZwafZj7ek+E/QWdX8Tegv/ge3w6sf/xlnrfmUEfAGN7
JjH+ROzhw4n9lsQooJ9wRw9++HmsL7S/EGeWOXgh1pT1Xxf7Y2nE5Jwc430+
yl8g3ePQWt8HIc4PPR4d/vOoS/v4IcBmwXrHoavU2hbGnmRc+CM4e8ztf4Pf
lsS9FTBufA+cIWx/1uHblHUaYlyQm2ADpNGTt2EEkd6mA6eNpW8MDAHfX4fE
8bLEyrK2rDE6G7gJaTAi3ndGerTmtiO4sOavM7JVc/ph2rwN3JbzRcxa89b2
CzA/nA3mkFi8/RLH46HfgMEQn7QgyrBn4AnEQsGTN0Qa/gCtxEfcrjpXVPlO
F/e5uF/BvQLuFHDu4X3whFciDd9AZv4tsdycJhq6J+Y/q6MuNOPz3BS4Cj4s
sDnOYG2kOe/XqN7xamtO2nkDIz9bbr8CZQtVprbedhhYHfMI9gKeAD4MpoDN
0Dmw4mEVTuNvJfaOsuBY2HS0iW8JXbZ/pOmDNLbeRtHSJ2+8eVypbQhw9Q3K
25E1zXh8zBH8r33iGGjin1nTu2Ot+0esALSCga2qNR7VKeYIuXa56h2tdien
7VNtiJgfMLQVLYyjwXtuDB5FfClxWvDYGaq7TvPeLGPfOzH76Bjca+yS+G4j
9hP56JbcGUYHJ36LONsxUX6g+j8w8R64MPz4+OCII/i5rf2Bo8Cs9KzU/rhA
5Y+us14JJgE2MSnleNrxwbvAlSdEmrwJ4YdAF/o98MlxieMjWR/iiovizin4
5e9B2wCVSbKW5/xH/Bz2MrjpxYmx04MSxw8ROwR+1inuzqCvUB5ewZg444yL
vKLI75b4Lihz9QE2cp1jL8DTxwYNy/Fp6Tmx0Bjf8kifE2nunXIHmTLkwQM2
BR8YGrgndjTvtyINPo8/Eix+ZqnziVfhoRwYKb5KynB/ZHTgutt0yDLPOVgQ
fgB0SfwgV4T8gL+BpXI/Dczw0MSxjMQx4tOkDDjJuFgv0qwH7bNfuEOD/YCe
TBvnR5o5ZE7gk9lon/xPog59EmNOXfI4g8RPcD7RDaZFbD/P1JCb+Je25u1j
4h7qXYnvojZLHPeGPOHuwZbQD4nnJa73hozjtu5IHLvFXdtNeWM0xCkuSvse
/dy29pmBdxGP06vKcQX4r76vsg8L3PqPvPkmvrXC8K+hbxNnPU/Ps1W2tbCz
WPP6uG+MXZskPleD1U47pR9T+s+87wric8GXgk8Fnw7xDk2qbZ/i32ia2MeR
Sox1gnNiR8EDwO43iG9cVOc4CGLwwWtn6P9bEvvnmDdiTjfnjYVNTuwXxCfI
HYWyxPcUTmvnuDrisLjnDU7whNoqTRw3SczkHNFfofTLyq9MHN+GbwS+Vdtg
3oVcujSxbOI3GDv4/6hS20mMPZM49g65UgA2rjrTwZkTx68zp1WJY+yIr+N+
yYOJ17k4cQwluMtDiWMFiBNAjoDP4f/lrtK/Et9XulNtt1V6T+XXJb4jwV0E
+BLrg++7Y9QnBgdsFtyde0NPqe4T9c7H5qspNd4xrNLryxnnPj5p/BPERuwY
MVQ1gYHNK/I9M+6bgbF0qfCZ5XyDx8Hr4fPUIQ9/HHgcdcHNaKc28NjawGZp
s0+k0Stuq7ffETyJ9sD7kMudtCYdG+zPJ+9vkY9s6RTpRpyOvrb5/KPNGZrX
IXrey7if/SKfGOWu4Y8CSyGOCmxlns7Rhir3wRiZB/gSPhXkKvfPwF26R3nq
kWafcyd+QuJ78cQH7RfjZU12LzWfJMa5Q5yRw9KOmYaWpa38mzRjycb88D/5
+E16qv1eDV6/+sT3YdBFWbeGWDvOfB2yr9xt1EU7XaMvYvWhG9sMXZp7QcRA
cMcLn2yHWF/u8XBflLui3CvqEPuBe0XEpRGTBs7LHR7wH8qRBqvk/jb7hLFi
/9EXfsk+MefQQNk2Uff5xDoH+kYj3eydw2NdqIuNi2zkLj8x9T0Sx9VzD5QY
b+54outtCHsc24c0tgl6GHYL+NourX1/mztKxPqSjy2zKPgpsergEsSfTQ0d
8utoZ8j2jvcC04WnjIlvSWwnWhaLd/2S/l/f1KXtL8P2Xx9p+kJHnRV3MLmL
OSti3Rp/Y48MqXLsNXoXGDBYMHe1wA/AEfDB8kZe4KOlbfoAbwAPAtMD28P+
+irox+/1Q9iMz0Yae4GxzgwaiCNYvL1tJ/JmBD2Nuix6I3olOiv6JDosuiw6
L/4C7sCCrxK3tE0PLjB+io5ITCn1asP+JQYDm2FT2CL8xh4hhmJy5IPXgtuC
7SIrsJ1pm35qoi/+4zf7dkGV4+04j+CFR7e1LEO3vClsW3QM/BnoirwvDH0J
uU+a/1uHz4P85XX2bbDfiStYGrYbsqfxrjB6yuWhH+IHID025P+0sLW3xNoh
34lvBl+nPnoA9h6+EmThmSEbt/mQ09aRuHPKPWfuR3DXmTQxHNzF+Snv+zh8
J2BUlEeWg5sh21cilxLLU84KZ4Z2ifldX2uckvYGRZsDIw2PavxNLAH3Gndv
cNwR5wcegX1Nm0PTvmcxNM4jshIf7KTEftinwsYYX2r/B/g/fgZw2ZsT2/lv
Yosk1nlmJY65Id7mpVLfaX452h4c7RPvy7mA53yfd5wBevKPefv48e9zv6eq
yn5w9t49YQfhs/slzhTYEXeLwc+4K3l9Yr5I3k+BC81NHBcIlsC54Sxhcx8P
1p74Tt6SKA+uAD+kfebnhsRxSMQgkcd/0AyvHx28i7UbG+lpieOQiEEijuyH
vGPJuM8+JuYZPw5rDabM+9yQZWMjzR5grsZEm2Nj3UkPjr4oc0hr485gztQb
He0gg/Hx4NfJaM1bN9hO2yXxvWIwOHwYi0u9Zz+r8j1S7pDCB/GXgCv8X2JM
/I2QY8g5ZNkVGtOjWcsdvhX0bNZ3v/5e5zh44n+6hdxDXuAfahd+u9EhJ6GT
OWWtaAc/1htxpx3bERuScwem8mCDcRXuBhBDAGZCHAFpsEnkFDE04JnUI16D
8rvHb9Kvl7oPfMG8X4s0PmLSw+O9ImhA/qMHoG8MirPLmVqfto8PXx/35yY0
eIzYq9x1487Rbcp/XfkLQ2b2ifFeErGyAwrtr1kYfjFiF18s9TdZ+LYCaeIE
8FXy/Qd8zU+GTQL2hXxGTsMzKftS1OVuYusq30/E74OPBP8IPnPiIvG5Q0vf
mEPWlXhgdAi+D4TvDb8bvk3uRYBV0P4LQQ/3CC9qsF2P3xcfILwAm3Z8jIvv
EBGTSbsHR3/0RQxgeWK+y7rdGndydm7rmBJsYfCwRxpcHnsRu5E4siPDn3Z3
zPHImOcvRc8XWd9L4Dd2LTr1KYmxKnAq5o955J4pejw+JjABfMDkM7fYxCND
l+Y9KtKvZnwnn/v4lFketvM+4WuFpknodInxgXfV54RaY/vgFPSD3jhTfPLI
rLEs9M+u4ftDv0PnQ8d7WWX6Za0DgG2Bn6E78f4m0sQbZIPvPaZ+e2Y9h9hj
yGSwGdZvbfi4sR+uCHsCnoPdDt+YkPV3u/hm112Vtu2JCV3SyvLp8LD1yQcH
mBk2P2WIk5sdZ2ptle+0c/+Pe/jwuEHxP+W4p8QZ5DfxirQzK9p8pZX7I/4c
PyQxBOiT6AxzS60bTBOdLzT4N2u1NtaR7/oMqvK3fZpmLBsYP/FUB8f3nZBl
rwU93dTO6AbTw36oD96O3Yv8x99I/Dpnk7gI4stmhwziW0HFoXPCA9CL4QMv
a61fqvc5Y++Pi/3P/C2Ku5DMx9L4jgn/830uYnr4/tOjba0fXhL/kV+Q9lxS
9zD1f2ne/GZug8cA/egKnAl0ROxq7gaDZTOPS2LtaO+SoKcw7bVhHoiPAHMH
b2eOmB9kMfjZxO2Noe0rfn9dnW0laF8WPH+I+v89b90ZmXzn9pbL6NFjoy/0
aX5v+7ZIlb+twFzAD86L/E+q/A0Cvj+wQWflVPZ9pecemol3wucPjgaGBuZG
ukvKsRh7Rxr+91vwQHgjMgN5QX8Fwa/HaX3eyjrehP4KQ/4u2t6+cHxCrDE6
BboF+seE0FW5iw1d6FfgcPQLFsc9qnU5+2qQz6wxchnfKffIweS4Q4ZeiE7I
XedrctY3aGOfaOfnvOMMiDEgxhXMCDwS3bM+9E/uddbFXkUmI5v55luN6g7N
+lsIu4El1Pn+P7Yzd9Gxo1nbFbHu8In7cuYVfLPkjpx9ZNy9vi1nnByf5NWV
xgG4G/3PnHUq7qbwPRTup3BPGH4BH+BuxE2JcQ90ZmJo0J/v2N7fm1gdd1Cv
ivvvjOu8KMO3T27K2SeI7Ts9vpMAponOiy/3tSp/U4x1Xqx1XFTvmIvjRFtt
Yh35GKX/lTPdfGuBby7gX35B83N61vfP1unsfN7gb2zAX+flzGOJCUC3pQyx
7M/HnQr0YuJf4EU9gmbk5gN8F1F1n6r093WaJP7GzgJ8/nnHDjEHfJORMYJ3
10b8Nd8+uTJn2U0cD/4fzu3hYQ+gp3N39rHAEh9A58x5PKPjTHG++JbhMYm/
Z8h99Otz9pvwzcUFWcdD4VNBh0BeD62L78U0993Qt3PWh9G7GQdyBLm0JGfZ
xJ3UF3O2c/k2zNScfVuPaB3KWxuruY65z9rmxkbhWxrYRNwbfiNn+xRsYFTM
IZgv84osxyeGHw9/Hrzs8JALxPgR58LdNHQreF6SMc7LNx/w4eJnPbbc97+4
qwHGwD4H4wHrAbcCf+gdZfCFTAheiK5FDA3xKNwlIo3eRXvHRHnoHRk2UV1g
OPxH7FK3KM/9EvYE+4FYmEPDZwGWBg39wn6kDPuBN3XQzSjbNcaCTkaaNtCt
jow2eR8V5RtpJX4Gf/WTofvN1j4Znnh+sP/RCcGoD97e3x3b5hMrcVwUfJTv
E5wUfmowznMT45xdiHWptx1HjB76AroQ4yVmi3ihUYm/m8D5+CTymQd0lutD
b+H7Lt1a+17SmMT3qPcODBTcDPyMe1nPxTdMuAfwTHw7hTviZyXWp85P/M0F
dL3TK/w9Du5rXZD4mw58z4FvUo5MfL/i0xgjfl54X9f4ngz6D2Mh5vC7sC3o
i7h02iOOHFq5S0UethD/Q9MJFb4v9EvExhA/QXwMPnh+gwvxf/soA43Qyv5h
nPgR8OXh0zso/HrEqNMu5alLuvE+Em/itJPoizLwjCTS5JEmDhfsZGBgNcST
YN+hZ/LNzr8n/r7Lnom/hQRGjT8DevBpvqd1z+eMYdAnNDEm5uD0mGfoGhS0
cY9k18R3SXJRHnqGJf7+Jro/YxwWfhPqMxecyxFV/rYLehr3pfEboHfgP+yd
2Id4VpW/DcQ6YBdiH4KNj0j8jRJ0nDMSf0cSPIVvzRJ/D05OLB1rxT7inhn5
+HQYR984y+x17ss1rnO/yGdNsG2458g9/l7hj+sd9FMGe4czyLlk/obFmoLT
/yNoALMFcyeP/skHv/0lZPY2HhJp9HX+PzDKEEe3Ns4XmDYYOphxt+A1nHfw
NmIT0OuITcROx17nmweDEt+VPSHxt1zBq+crv2+9dRf8Buj73H1HJ8Y2QEfm
/IxIOfYO+YMcIh6BOCpinYh3OTJxTD/x/MROtkyM/1Xz/Zt63xn6XPLk2MRt
sjbgB9A3o87f/0UGfZd37CNrhc8SWrAViWVrnTi+5oCgB91rZ/Gu09o4BhZf
dP8YO3OYDfv3Wsm4hsTftzle/TyTd0z1x1X+Fhg6Lr5t5CT6KL4i4j7Qx/ZQ
2R2zjvcZGr4lvsGEL2hU2JPYWNzZAUM4LXAr9gL21/q4y1MSOg0xA9iR2JPE
TBIzTD56DrEQnE/OJnk1UR78lHHhZ0c3Gxo4WHWUQaeFp1VHGr8UtiM8lLiD
/oljD4Ym/uYvdvZCjWmN5uXjUsch9kkciwgPQf/gmwM7ZT1+xo79BH/kbHLX
H98AfgG+bzQk8TeO0NVpG0wMfv9x7NX/BxpK4OM=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmnmg1tPWx3/N55zGc55zTqXznOd5fvtRiihTuLxX5Bpzm0c0oSSJjEVR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         "],
         VertexColors->None], 
        PolygonBox[{{8219, 8218, 6139, 5268, 2777}, {8765, 7966, 5207, 5076, 
         4420}, {9374, 9320, 4874, 1032, 6888}, {8133, 8764, 4390, 6441, 
         5230}, {8178, 9322, 7018, 6367, 2667}},
         VertexColors->None]}]}, 
     {RGBColor[0.707001861334212, 0.7576174531365523, 0.9127628269785089], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHeclNX1xmd32WWX3dnZnYGlbJndeVdQ0VhCYkESFVBAioWAvSu9KYiK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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmneclcUVhj+EhV3aLvfuwgJ795a5UuyJqEGwBAFBmoCAgB0F6U0QFJEO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         "],
         VertexColors->None], 
        PolygonBox[{{7943, 9321, 6905, 6187, 2331}, {8743, 7957, 5195, 5067, 
         4258}, {7975, 8742, 4256, 6358, 5209}},
         VertexColors->None]}]}, 
     {RGBColor[0.7912997736073076, 0.8565582720915125, 0.9011874151149496], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHeYldW1xs8Mw/RyGM6ZeurQLBFUULoFUEAkKoJiS2IBAVGuLWrEa4uK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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwlmXucjeUWx1/Mno0ZZpi9Zzbt992zx7UL0imFmXKiGydTSEKdQxHjMgdJ
p0jphhwqSUUX0emqKPfQCF1Ona6nc45rhQgRfZRudL6/z++P9Zln7bWe9axn
Petdt8kOru41unYQBA/WCoIc/haWBcHKdBDEQAYVBsE9YRC8FAXBnLpBMLde
EORmoAFH65jnYtblwDBoY4FF8I8Af4L1U0AM/Hzw4axHABORfVk2CL6qHwQf
cOb8UniBaXlB0JzzG8D7ODwHOa8F/LdLPufXBl8K3pR1D3Ts1zgIPouhL/QC
4EZkHYDnd+ivsv8I+g2NB8E81kehV3FeK/avYz2S88o5bzD7S9BlJDrOLQiC
nflBcAP0nuyZA+8jwN/BZwCbWb8N9M74zrrrJGAC6/3I+y3PNnoO/B9ANpfz
wd9H/gfAUmTfwnlHmgRB6xR08Ira3ns5500JLGMBe58GQvYPYf+50DsAh3Os
Uxm078GT7N8MvR/3rUR+EfpnwUdD/wT6JmR1QcZOZF+MvbY0CoJd2KATtFzu
exx5N6BPd2hDQ9uyGTbtxP5a4N9BPwKMY/9wzjgX2XH2v5Hxb1rnAhNYX6Lz
0WcOb3AYfC/8R+G/Bn0PQDsIPAu9Ne8x+ZQgaFIcBEvwrf3ADvgjdPqyvn0i
h7Mnc8Zr7K0CqmXP0HcZjMy7Wa+HfzH3exh696bojbyNyD4MbMe+x0qCYAWy
umDfKZx9F9AN/tbYuCXydnHmfO72b+7cClkP43g9eZN99W3bSWn7pmw8mnU3
9vfMs49dyd1eh+dp8CrwHmn7jHxlI/ApeAPoryFrGTAW/G3wNfCPg38N+1eC
Pwv+MzoMZ11Valv+JWZfnc+eQ3Xts9+x3see78EHIP8b7rc3iR/wViH8jaFt
wSYdkfUh9+8BngBvAK0cuEPfamTby6ZTsddP2Gtpod9gMffOJILgI+iXgfdD
fm/k38t6HvAS64781gP7t8eHjqLrBcgfWeA3H8j+/7C/EvoodOwF/msROiLv
K3jeYu8I3mMiezPoU8n53ZH5T+hHgL34Q1/oPdk/BZ672b+tyG/XDPl92H8f
/EfQZTD0PZzflvc43BAbYcNd0Es4vx33fxJYyV2noN9D3HUB+sxGXg77/4Qu
pyJjPPsvhV7J3suBC9i7j/OHolsN/GvQZwz4VfCXokM++DjwmZy9AX3rcF4V
8tYi61cgi/zWkgHtODq1h/8k9n0fWi5QCu0k9zkZt42/Z+/4Et91N/7YkO/v
FPS5Dt5rgbPg/wr6cL0f+hQj70zkdcc+I8G3g/cp8V7ZtC/n75a+0Pai8x70
qwbv08h76kX2Sfmi9P8B292Kv1+a9H3H8PcE8t/l7HeAq5rY5rL19UAK/0kC
p2HPM4BT0a8xML2u77yfu/WGfwC8r7B/HfJi0PuDXwPM473z0WcftOeBOLyn
J/z229B3C/qfUWzaC8BKzloF1EbfWsBc6O/A/3i+3+Rx3q8ae03Pc87Q2aM5
c1OhdVgLfrTYvnu4vmnVwOZC87yCvKnI2wCtO/g0fffgbZAdga/POEcoN9RX
PMJ2g9D/EOsa5NdO2qfkSz3Y0yrjGKLYUYl9DnPfwSW2nb6JWfD+jPzO8DZn
TwH6zUZGt9r+Bi+EvzH8rcCPgt8C/33w1yAvDv4h71cMDEOft7B5f95uGtAK
vdZAvxX+pkl/a/ngD4Pngl8Ofhr4vQn7qHxTMnfiP5eV2Lf1RtXgO7DXiEL7
7Jfgl0DfFdiH2nO/I5x1LXcbCGTQZS/278u3toM37Aj/bPav4bwS9rfLOGYp
VvUHnuHsM4HToZ8NfZhiF/Ljjaz/5+hXCv1l7rceHfcg/7G0c/l+YDj8O6Cv
K/Q3p9i3uIlzlWLgJXw/pwFbGznHFXH+VvSrQL/WnN8CefvkL+D7465FlGOU
W1STXM/bdQQ/G1/6A1DN91EP/Kcc56xV3O9W9P2h0Db5CV2mJx17j/HbCeWX
5n4H2f+3hH1MvnU+dz4J/W7ok/mtEb+djbwFxfb9huAj0C8ZOf50rOtvuRky
tsf9Tc+Af1mJvy35zOCMc6By32ygLvpvxF6P6lsBsux9Bvnbkb817thzBWd/
UeAYdFSxF3oKeW/w22vQyoGerCv57RzoN4O/iqwY+GjOryn2WjEilvSb6i3l
Y38FLy9xbtA3Ni1hH5bv6htTrFgnny50zNgLvhD8nEJ/c9+ynoyMqph98Anw
zil/W+3Al7P+rcixXTmjAlt15v4d8lwTxpP2efm67nAMewyA/iDrCt7vBWjt
gbbgXeB5gPWJhN+mRaFru3vhX5DnGm8meB3wk+j+LviPyLtB9oa/a751Pw+o
KPAdQnzvWdUsrCcqfqLPm9APoutU8Kmsv+a8M+APwV8GP1c2B78U/DLWYcKx
uSX3+SlhG+juihny/ZqUZekbUK2kmk61nGqmvpx3EPpe2R5ozHst5b2OFdgH
6iT9xnpb5cA3Uv7m9K0pxx/XfYrty/Jx+WmUdC6Rv15FfBqqb4736Yl+fZLO
gcp9etPj6NMbHy+B/yLscyO0A7zX6bzXA/jELOUXZH7C/X6B/2t8pZzzz425
Zkuz7lrsu9fEneu/LXIsVM6/A/ww+8/KcQ5ZyvufmXEsms+ertz3NvZfmuMc
Id+9J+HaWj6sWuRkymerJlnC/rYZx6Z57O8B7fci1yaboT/IefWbON6eYM9c
8Kbgm+KOWRXs7Zxxbaye55uEc4hyh3ysLOE31tvqG/4l4Ryg2K83/zVhH5Tv
yYcaIL+rvoeYY+iehGsy1WLymSLsP6fEtZVqJNWWn/D+r9d3jVmMLgmgV45z
9O6EfU6+ppibQv514PsLHAP6c/9N+Osk5DUHvlA+KnFu05v9lvI3o2/lZ2Ah
/Nvh38PZ98BfkXSNptpMMeRU8CEp1wbyOfniAOCbAvtkKfT+Kcde/TYP/YuQ
lx9zDp+A79wM3MnZLyOzDbRY1ush8OeynghUFbiHUm+5EJ4n67nH3IF+f+O3
xay3ot87yI/4JicpviH/OegL4B8ObVpd13pvJ+2birmyxX7gkbhtMomzbgd6
KbfTQ2aQdQf0EzF/4zOQ9wx4Z+xxITCX2P5j1rn5PWy5nPOnQl/E2QsVU8Af
D63LauDptH1YvquaXrV+44xzlWr+yrR7XvW6j9Z1L6ycqFyonviptH1Yvqse
azlnTky51lGN0h59o9C9+x5gFuu1pe7F8tG3GfS3+W11rm1Wl3W3yL2Icl5j
6G1D9w7K+b9zt6vS7s1Vc6dD16yqVf8MfAQeh+d13uZf2CwNbVjo3ko1bRha
J+lyEzCSu1Wn3TvpDV8N/YZ6u7XsrwJfhrz70G9bzLn9jDLXCsrxD0N/i/vc
GHePLV/qHvlu8qka1htknxzPABQ7dqoeznEM6Q3/i8hvwXmL4P8v6xf57Ur2
D+J9DsG/KeXaWzlJvqQYr9gun+oD/3j45xc45nWJPCPQbCCXPSPBP+Z+n6Nf
Z/Am4OOz9uXKOu6lb0q7tlRPPRna+cgbFXNPpdjYMOncrBh5UP6ZtW3fBO8P
viVrW60HP0+9M79tr+OclY5ccyh2b4u7r+2YdK2hGnUZ/Cc5/9sc57xBqu/Z
XxRzz9SS/auhv8neA3F/+33T7p0VAzS7KE+61tMMQ7qv5LxHC3yHosg1kWqh
j+PuxTsk3QupJ1dvox5BvYF6nAHwXxM5FulN2iHvmcix5lRgF/hXwAbVv8BH
8p3ItdJn6jHBC8rsi3rzfL6HvCaO3coJqzRfiFyrrge6wvvHMudb9XTjoN0B
z5OiIXMF9lnGeZ/m+Rt+E3w6NmqU65mDcvvVSeda5fhD8H4LNOOsNjmeTenN
9daaUSn3zUw6lioHdiWe12viXkc1v3rXKUnPQtTDjk97xqTZkmLSsdAxTLFr
Efjd8H6Xcq+mnLwkax+Rb6jmUawchs6d8hwzH9M8LWPbtQH6wZsq87e4Oua7
3Z/x7EJ3vJG9Q4EZvPd5yBjB+r5SfxuamSk3dkk43ilH5rE3P+NZ1Gnc+a7Q
NapqU81IVNt+ELnXVLwthz6k1LKl4xXcd1bGtZbO7AOteWhd5YOvc5+K0LMq
1WDy3SEZzyLlw5eE7unVy2tGo97+pshvqR5f38YFGc8e9Y1MCx2jFZs1g+kU
ugdQ7X9OnmtL9aDqPVVjtoDWstS9nWZGy6GtyHiWOLaWZy8NM55VagZzEfqO
SZumnuJi5be0Z2PK2QPB30vbV1Sz7067hlLtpJzzSNozDs02sgWe7ammVS2r
GV8FeLniV8wxcgx3HRu5dpEPKjeNynj2qhx1ZdY1rGrXYvYvhLYo49liBP0l
6H1Cx0LFLM16WqY8a9DMZ0XWOVG5UDPSO1lfFHqWqZi/HHxE6FitnPICsl/M
ePZZpplQ6BmrZquKEYqdvbLWRTFUtc+eEtd+qoHeSrunUS+jmZ16t1aRY5F6
uM+hl2Tsu6p5AujvR56daUb6Evj/so4Nium3kLiOZ13/qA6aAH4Q/z8A3Mx6
HDADuB8YC9zW3DMP1TOqazLyp6xjh2yuWHkF510dc8xswPf8A/q/H3eOmcn+
5pHrHdU9OrtR5NmcdIirdih1rtAMdiv3GZz1W6sGqmb/8+j2HDCa9RLogebr
cc/cn+C3C8scu/ZQ+25A1uzQb6mcqFq1e8qzUNWsd0K7k/MLc13DfFxqn5ev
a0b8WOgaRbWJZpTvsX631LNKzWDU64eRc4l6/i/49tum3Fvqzi9DWxy5VtHM
WLPHayPHbs0g1YsnIucC9eQDwSdEnlUrpg/gfqsiz+o0A/+Us58LXVspJkv3
uyLPfnWHh6DVlHq2rxn5eeC3ZZ0L9SYboc0J7XuyWZX+95BxbFINqFnKqMi5
WfFLs4cOCfc2mkEo9v8QOtYqB/wfb5iXDw==
         "],
         VertexColors->None], 
        PolygonBox[{{7691, 8689, 5394, 6219, 1989}, {8028, 8778, 4643, 6573, 
         5220}},
         VertexColors->None]}]}, 
     {RGBColor[0.8699272893455128, 0.8827784534858542, 0.865962358524916], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHmc1WW9x3+zz5xZzhk7M4c528yQpYAKLizKoqhpLqiJmIlmykDXvAGS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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHeUlFUSxb+B6Qk9wMxoT/cwdpgekpEggqAMOERJEgxHBVGJa4IBBCRJ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         "],
         VertexColors->None], 
        PolygonBox[{{6456, 6093, 5546, 2683, 5244}, {8771, 8770, 6502, 6501, 
         4493}, {6102, 4410, 5494, 4306, 6137}, {8747, 8748, 4281, 5087, 
         5479}, {9312, 8759, 4375, 5535, 5107}, {8776, 9315, 5114, 6561, 
         4595}},
         VertexColors->None], 
        PolygonBox[{{8939, 9335, 6089, 4400, 5130, 6105}},
         VertexColors->None]}]}, 
     {RGBColor[0.9411759999999999, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmFuU1VUdx/fMGTjnzH2QM2fmzJnDHJxeCheRlZQCgQpWyFpWLi4hARVD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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlV1o1XUYxx+mtrNztp1tbjvnzP//v3N0Bb1dSFCzmjl1m6V1UQyziEpq
FaSWwUqsIG8K0wm9XCQMU8LUal5oXfTiICEtchEpaUVFdVddFbTZHH2+fLt4
4Pf8n/eX7/Ovbdxy5+a6iNgEzYdO1SIGsogJ3oeKEV+nEX/wrdAQsbY+4hpk
V0MLkD8Ef35RxIZSxO5cxKutESu6I5qx2YT+49D+jojLKxE/oVtB/i+2g1Bj
zj7neF+CCvhrgn8B+wn4vciPwU9XI97H30lyGWq07zrkx+sdowJ/OzoVHDyI
zgzx9pPPdcgeo6ApZKfw2XtZxKfofE4tjdjMInsH/Sfhn6i5tu3EfA/ZL+jf
nUcX/Tb4NzLLmqD11DJJjBL+RqnnivaIA/AJ79/wcRTd+5KID8M1LOd9gRy+
L7hnfyP/CxrnfRD5JP6fhb+H9xFyvpFcboJy8POIsQt5Av8ntR8h3wn8zWbu
VRH6DNmLqXUvYdNL7sugWd57iDFNL050ONcRal7CvHaU3JtHoJexvRIfZ5si
DuP/+sURN0DlVs/sGPHWkX+J/OfmMSf0l8O/jf+L2C9Dt3exa1+EzdKuiHNl
6muhz8Q/gf4o+RxucA/qkPWSTx75GXo8ST/38W0U+zI1fEttM+RzM/rfEGMN
/BDx2rBthp8Pfz6z7GkW91Zkn8Afgl+Izipirey2bEuDe7c79azVwz7086lz
1w69SS5Xlbybqnkr+k9Bzfjaho8W6hkvOTfNfA32g9q3Bc7pNewz5GPEn6Om
XYlzVq4/QHdofxODqwv9FfAtxM/zbii41ud6Iu5qd83Cynr6cS7n/j9K/GFk
fciGoH5sz1S9y/0FY/V07f/dIMxazQqdTmQdBWPnx8y5CEOr6c1At3vzFvXd
i+0c/M/UkxU9K+2kdlEzu4j8AvZnc8bUZt7bqOekdjvn3dmZ+lZoh55JrCNZ
ifkuyYxRYVM7IuytJMdCwRj8gn3cSf/+KfqGCMtdqXslTAtLt/CtvmBMKdfj
iXdROT9A/9sq7r12TrswlBmr2glhYQbamjcmNLvbqt4VzTDXZQwrt0F0VmXG
hLAgDN6P/NoOY2Wp7hOzmVzoW/l7wbfldLdr1Y3ZxyxHeoyFd7GdQn8M/1N5
7/x3up2Zd0s9/UC7UTWW5XRvj3uuXn9JXWPIh2u+feuoeU+7MS0sy6dmXc28
K5r5x7w/ynxbhNGNZWNOWHsem2lyPZj4Vqgnral3UruomexA92i7a9NMmlLf
dN1yzeBh8nulx7gRXsaZX1+n69UNLKfeQe2ebsYA79VV5y5MfZX5xuq2aoe2
w7+eePd0A38l1kuJd1M3uL/qndeuCzPF1P8I/Rv0Dxmhxxs6XZvwc4B8hjs9
K2HmP3IE5us=
         "],
         VertexColors->None], 
        PolygonBox[{{8873, 9328, 5991, 4499, 6106, 6103}, {9357, 9332, 6052, 
         2630, 6602, 5189}},
         VertexColors->None]}]}}, {{}, {}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{7244, 7743, 8245, 7992, 7993, 8185, 8184, 7334, 8646, 7559, 
         8427, 8506, 8507, 7746, 7747, 7563, 8489, 7562, 8647, 7749, 8648, 
         7564, 8476, 7565, 8649, 7436, 8258, 7441, 8256, 7440, 8257, 7489, 
         8397, 8398, 8135, 8136, 7288, 7790, 7289, 7887, 7597, 8162, 8163, 
         7304, 7823, 7303, 8004, 8005, 8001, 8003, 8002, 7684, 7896, 8687, 
         7895, 8697, 9341}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7634, 7635, 7724, 7723, 7230, 8409, 7614, 8054, 7615, 7804, 
         7803, 7317, 8539, 8190, 7348, 8189, 7347, 8268, 7448, 8267, 7447, 
         7712, 8758, 8759, 9312, 9309, 9317, 9362}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7675, 7686, 7231, 7933, 7934, 7932, 7342, 8192, 7350, 8191, 
         7349, 8270, 7450, 8269, 7449, 7715, 8760, 8761, 8776, 9315, 9318, 
         9375}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7745, 7260, 7249, 7923, 7924, 7867, 7868, 8254, 7435, 8252, 
         7434, 8253, 7681, 7682, 7438, 8000, 7437, 8255, 7261, 7855, 7854, 
         8065, 7439, 7750, 7931, 8684, 7633, 8452, 8560, 8561, 7833, 7442, 
         7751, 7869, 8265, 8266, 8262, 8264, 8263, 7752, 7308, 7902, 7605, 
         8440, 8533, 7310, 7827, 7309, 8260, 8261, 8259, 8563, 8562, 7685, 
         7898, 8688, 7897, 8698, 9370}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{8873, 9328}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{9357, 9332}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[{8939, 9335}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{9348, 8702, 7708, 8511, 7709, 7654, 7711, 7710, 7352, 8564, 
         7455, 8428, 8508, 8509, 7612, 8628, 7530, 8470, 7531, 8629, 8730, 
         8729, 7622, 8739, 8057, 7901, 7599, 8665, 7514, 8571, 7480, 8432, 
         8515, 7760, 7445, 8033, 7554, 7863, 7864, 7259, 7242, 8056, 7245, 
         8425, 8055, 7851, 7557, 8037, 7422, 8372, 7558, 8076, 8077, 7744, 
         7423, 8251, 7431, 8249, 7430, 8250, 7485, 8627, 7524, 8438, 8529, 
         8530, 7541, 8532, 8531, 8439, 7395, 8549, 8574, 8573, 8630, 7532, 
         8471, 7533, 8631, 7486, 8575, 7487, 8433, 8519, 7287, 7720, 7286, 
         8518, 8206, 7377, 8205, 7378, 7689, 8769, 8771, 8770, 9373}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{9353, 9306, 8747, 8748, 8746, 8775, 8774, 7390, 8222, 7389, 
         8223, 8521, 7292, 7971, 7293, 8434, 7970, 7889, 7948, 7947, 8041, 
         8042, 7818, 7585, 7847, 7668, 7669, 7604, 8374, 7560, 8373, 7561, 
         8375, 7866, 7748, 7432, 7832, 7433, 8559, 8451, 8683, 8682, 7922, 
         7921, 8064, 8063, 7428, 7998, 7429, 7999, 7648, 8248, 7427, 8078, 
         8079, 7248, 7680, 7742, 8294, 8295, 8293, 7484, 8296, 8572, 8454, 
         8652, 8651, 7656, 7845, 7493, 8577, 8455, 7631, 8681, 7659, 8624, 
         7515, 8436, 8527, 7768, 7461, 7799, 7516, 7844, 7649, 7650, 7517, 
         8090, 8089, 8088, 7460, 8276, 7353, 7718, 7719, 7655, 7717, 8514, 
         7716, 9358}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{9359, 8689, 7691, 7890, 7692, 7794, 7793, 7660, 7661, 7368, 
         8444, 7369, 8540, 7363, 8200, 7362, 8304, 8579, 8578, 7774, 7254, 
         7644, 7843, 7842, 7471, 7773, 7444, 7755, 8705, 8704, 7470, 8722, 
         7408, 7985, 7984, 7857, 7328, 7911, 7407, 7983, 7982, 7856, 7327, 
         7910, 7406, 8380, 7567, 8379, 7566, 7754, 7443, 8347, 7535, 8346, 
         8349, 8348, 8632, 7253, 8703, 8495, 8494, 8420, 7318, 8546, 7386, 
         8216, 7385, 8566, 8567, 8453, 7469, 8565, 7705, 8779, 7706, 7527, 
         8027, 7526, 8778, 8028, 9368}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{8872, 9327}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{9356, 9331}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{9336, 8695, 7697, 8504, 7698, 7641, 7950, 7949, 7322, 7908, 
         7321, 7909, 7952, 7951, 7278, 8516, 8310, 7495, 8309, 7496, 7796, 
         7795, 7296, 8402, 7591, 8137, 8138, 7820, 7586, 8045, 7588, 8043, 
         7587, 8044, 7279, 7761, 8371, 7555, 8034, 7556, 8382, 8383, 8074, 
         8075, 7243, 8036, 7246, 8426, 8035, 8247, 8246, 7424, 7883, 8122, 
         8297, 8298, 8124, 8123, 7283, 7785, 7284, 8126, 8125, 8300, 8299, 
         8327, 8663, 7594, 8480, 7595, 8664, 7375, 7786, 7787, 7701, 7884, 
         8693, 9338}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{9339, 7960, 7957, 8743, 7958, 7956, 7381, 7959, 8526, 8435, 
         7512, 8728, 7453, 8753, 7454, 8720, 7351, 7942, 7941, 7874, 7344, 
         7936, 7640, 8387, 7573, 8104, 8105, 8106, 7815, 8103, 8102, 8101, 
         7572, 8386, 7639, 8385, 7571, 8098, 8099, 8100, 7814, 8097, 8096, 
         8095, 7570, 8384, 7638, 7935, 7343, 7871, 7872, 7873, 7393, 8719, 
         7452, 8718, 7451, 8732, 7528, 8442, 8536, 7974, 7394, 8229, 8230, 
         7976, 8742, 7975, 8231, 9364}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{9347, 8701, 7699, 8505, 7700, 7642, 7955, 7954, 7324, 8177, 
         7323, 8446, 7953, 8118, 8117, 7281, 8517, 8292, 7481, 8291, 7482, 
         8400, 8401, 8046, 7590, 8047, 7810, 7811, 7809, 7553, 7849, 7552, 
         8735, 7589, 8733, 8734, 8391, 7578, 8389, 7577, 8390, 7282, 8392, 
         8393, 8121, 8120, 8119, 7483, 7741, 7740, 8062, 7247, 7853, 7852, 
         7425, 7994, 7426, 7995, 7997, 7996, 8006, 8019, 7285, 7657, 7620, 
         7770, 7769, 7771, 8618, 7507, 8466, 7508, 8619, 7376, 7788, 7789, 
         7702, 7886, 8694, 9367}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{8871, 9326}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{8938, 9334}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{9355, 9330}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[{9329, 9354}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{9333, 8937}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV01toznEcx/GfaSRsKyFhs0NTkzZKMglJY+2EzCFGK4dsjULIxrCU043j
GGOYcbOTC02hjJtHGbYoUUrbKLlQmrTi9b949/58D//f83/+/+dJLd+9umpE
CGEYxzJCWJ4WwvEZMupwAiXTQzjKtajGEdRg5bQQ2rgdrehEB4rt30sNoQVJ
aMZdVNq/xU1IxB3cRpH9Rr6JBNzAdayw/5bfIRl96EWh/WvcgPG4inpU2L/I
lzAOV3AZBfZf8EtMRTeeI89+Pw8gE98wiJj9dckhlCJNLkkJYRUKUIRCFGNS
unvkv7wR6XYPeH6L5GLXnpTfy5PRrX6orpa38lP+wbfQhCnqHmfFeQcV8gL7
ubwvOk9voZyr18vlepv4DJ9Fnnmxus98Ge/kn5yHWvN6bIvOcn6wu13eK2fx
E/ecr7dD3q+3TG7QG3bNKedkqivlL+az8Ey+bp4gx7zrCean5Q366/k8xzgO
05w3FO05Z0j/secd41LXNOqXedYj+Z9zUvRuyK/tPOKv9np4DKrkbPN4nq3+
GH2WulUeJS+RazhdfdBnJUXfUf1ZnYYuucw9Z8jnfFai+XG5SH8VH+bFekvl
N3Izb+YPvNb+WLNDcqYzevUvyJ3uPUP/vjwx+o3qt8gd8neeF70n3+VB9F7M
BngO9sgzXZdqLzvad2adXr+cEz0/9/9Z3S6P5kGei09yF/dzluvbou8m58j5
0X8g+o2p56v/8Cvc1Nti9pvXqOPNfnknu7gJ/wGJZJzW
         "]],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{9349, 8772, 8306, 8305, 8308, 8307, 7494, 8364, 8365, 8361, 
         8363, 8362, 7236, 8312, 8313, 8311, 8315, 8314, 7497, 8582, 8583, 
         8456, 8581, 8580, 7273, 8584, 8585, 8457, 8587, 8586, 7498, 8655, 
         8656, 8477, 8654, 8653, 7237, 8588, 8589, 8458, 8591, 8590, 7499, 
         8594, 8595, 8459, 8593, 8592, 7274, 8620, 8621, 8467, 8623, 8622, 
         7510, 8640, 8641, 8474, 8639, 8638, 7238, 8673, 8674, 8485, 8676, 
         8675, 7625, 7765, 7764, 7456, 8010, 8011, 8009, 8275, 8273, 8274, 
         9226, 9080, 8007, 8978, 7457, 8822, 9173, 8981, 7758, 8824, 9022, 
         8795, 8881, 9172, 8979, 8798, 9082, 8859, 8860, 9292, 9065, 8116, 
         8886, 9087, 8330, 9211, 9053, 7280, 9110, 8903, 8022, 9212, 8840, 
         9270, 8950, 8875, 8876, 9037, 8186, 9222, 9073, 7937, 9045, 8839, 
         8878, 9296, 9077, 8202, 8946, 8146, 9219, 9069, 8867, 8965, 8147, 
         9224, 8791, 9166, 8968, 8866, 9068, 8145, 9163, 8144, 9223, 9076, 
         7364, 8880, 9035, 8244, 9225, 9079, 7865, 8977, 8837, 9285, 9036, 
         8927, 9139, 8796, 9156, 8716, 9260, 9138, 7446, 8980, 8717, 9261, 
         8821, 9278, 9020, 7739, 9154, 8808, 9094, 8892, 7523, 9299, 9093, 
         8342, 9040, 8781, 9195, 9024, 8826, 9091, 8890, 9182, 8998, 8807, 
         9233, 8334, 8953, 7519, 8891, 9298, 9092, 8335, 8997, 8025, 8854, 
         9214, 9056, 8026, 9057, 8818, 9275, 9017, 8898, 9102, 8815, 9187, 
         8404, 9237, 9103, 7600, 8835, 9034, 7825, 8935, 9188, 9006, 8745, 
         9147, 8923, 9267, 8941, 8932, 9144, 8737, 9244, 8524, 9169, 8971, 
         8901, 9121, 8909, 9239, 9105, 8545, 9249, 7963, 9206, 8193, 9350}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV03tol2UYxvFHEM9aiHje3DzgJBMtSxMhHEuU1HKeSstz5AzPMAh1Nf/R
peYsz5ZGDv9YqShqEllKHjaYhxKPi3QFIaI7ZIWWSz/3H9fve93XfT/P+z7v
+/6yZy/KX9gkpfSWn9W9U3qUnVJDr5Re75lSlnqmulTdka+SfcGfwlZ4kV7V
76aXJTuq/g1rabDsOn4ry8H+0aM/+NLMlEbzq/j9GSmt5zuYv5SVUg2/QL4O
T8Y++JLerO4pzeDf6JHSdGykzfpT1Fn8OmuLcbzZY/I37fsvrpW3k73DZ+v/
Qt/wH+L7+DLeodf4fNxufjVOtKbAHsfla9Tz8cdY495fwRH6RbJB+Cz2ld3G
7/A5WQv+NF+AR7AG9+AUvWpnacMnz64Me8rm8p/wF8xt01/IN5Xfc76zfL68
EA9gczxHk/lMM+fNNFXvVo9Vt3SGZXEm/pxevfxvXCQbJytXl7nGYvU/8vtx
3pihk3wpPsAhehPx03ie+JBK7F2ER+Ld6c+Lb8CeO9Tbaal6EjbBStrHtzA3
md/I/+75beY7W5PjzKNwg7xG/hjrzdZSHXXR22r2lt42rNA/gQ34MXXV72uP
CfFtmdkkq4jnGvdg/SH1cn4G/oB1+Dntos7qKjMn4l7tMz+evbOtxSLPZpjs
Rb7WN3ANZ5mbFufHj2ik/jj1JdfNxXfxHo6kD/S30mx+iWs8xjm0mM/Bo/Yc
He+cXyrL5bfI/otvzT591O/xN/X70fexn37b+O+5x/b6JfFfiO8f1+MZ/B/H
05/8Tfv8FeucpRInWfOZ/G3Pq1HdaJ8M2c74lswcxF/lVdiMpvLP6LfGp9WP
zExTH+cHyobzy+IdqAe7Vlv1HPXP6qfocFzTPXfj17hWG/2V/Bj5UCzGPNmo
uH/rh/JLZEPi/VpXh3vldzEvnr/siv4mvtoZcsx/Ff8d/rK8nL/B38bnaab7
3Ys/6d3ATJrL97Kug7nu8V+05wrZdT6DCl3vmnpf/PewGnvQVf5wfIfYz/qv
+U78AH6svXaoz6hfUN/H8/RlvHO9+vhu411gc++6wMw82kVPAIis4Ow=
         "]],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{8870, 9325}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{9337, 8692, 7881, 7696, 7779, 7778, 7372, 8662, 7593, 8479, 
         7592, 8661, 7797, 7762, 7763, 7621, 7658, 7291, 7819, 7807, 7781, 
         7782, 8419, 8418, 8417, 8283, 7476, 8280, 8282, 8281, 7733, 7734, 
         7735, 7607, 8166, 8167, 8168, 7802, 7314, 8406, 7608, 8405, 7609, 
         8407, 7549, 7808, 7550, 8359, 7551, 8360, 8537, 7315, 7828, 7829, 
         7611, 8408, 7610, 8670, 7298, 8211, 8212, 8155, 8154, 8153, 7382, 
         8220, 8221, 8217, 8219, 8218, 9344}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{9342, 8085, 8084, 7569, 8381, 7568, 8061, 7632, 8058, 8060, 
         8059, 7384, 7848, 7666, 7667, 7962, 7961, 7302, 7671, 7672, 7836, 
         7835, 7307, 7651, 7271, 7834, 7619, 7653, 7652, 7757, 7756, 8109, 
         8108, 8107, 7477, 7850, 7234, 7258, 8241, 8242, 7987, 7419, 7988, 
         8087, 8271, 8272, 8092, 8091, 7269, 7777, 7270, 8094, 8093, 8149, 
         8148, 7295, 8616, 7505, 8465, 7506, 8617, 7365, 7775, 7776, 7695, 
         7879, 8691, 9366}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{9343, 9310, 7966, 8765, 7967, 7965, 7388, 7968, 8528, 8437, 
         7520, 8731, 7463, 8754, 7464, 8721, 7361, 7919, 7335, 7918, 7336, 
         7920, 8520, 8139, 7581, 8395, 8127, 8128, 7812, 8411, 7617, 8410, 
         7618, 8412, 7325, 8396, 7582, 8129, 8130, 8131, 7813, 8039, 7583, 
         8038, 7584, 8040, 8132, 7885, 7345, 7938, 7876, 7877, 7397, 8233, 
         7398, 8169, 8170, 8551, 7400, 8443, 8538, 7979, 7399, 8234, 8235, 
         8134, 8764, 8133, 9311, 9365}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{8869, 9324}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[{9323, 8868}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{9346, 8338, 8339, 8337, 8341, 8340, 7522, 8669, 7603, 8483, 
         7602, 8668, 8336, 7272, 8112, 8111, 7478, 8284, 8018, 7862, 7861, 
         8490, 8492, 7860, 7915, 8493, 7914, 7233, 7257, 8557, 8558, 8239, 
         7418, 8240, 7331, 8238, 7415, 8072, 8073, 7647, 7646, 8237, 7414, 
         8069, 8070, 8071, 7474, 7673, 7311, 7837, 7312, 7674, 7313, 7939, 
         7940, 7878, 7972, 8429, 7267, 7973, 8225, 8226, 8208, 7379, 8207, 
         7380, 7687, 8491, 8741, 8740, 9305, 9352}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{9360, 8690, 7693, 8150, 7694, 7704, 7703, 7663, 7664, 7366, 
         8713, 7367, 8714, 7326, 8080, 8081, 8082, 8326, 8325, 7250, 8414, 
         7627, 8413, 7628, 7839, 7838, 7491, 7792, 7490, 7791, 8707, 8706, 
         7492, 8726, 8020, 7926, 7337, 7925, 7338, 7927, 8083, 7929, 7339, 
         7928, 7340, 7930, 8029, 8755, 7539, 8750, 8751, 7805, 7538, 7806, 
         7540, 7840, 7841, 7630, 8415, 7629, 8416, 7251, 8376, 8377, 8195, 
         7355, 8194, 7356, 8224, 7392, 7969, 7391, 8302, 8303, 8301, 7488, 
         8576, 7721, 7722, 7402, 7980, 7401, 7981, 9369}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{9363, 8287, 8288, 8286, 8290, 8289, 8725, 8724, 8650, 7576, 
         8431, 8512, 8513, 8115, 7277, 8114, 8113, 7479, 8285, 7421, 7917, 
         7333, 8183, 7916, 7990, 7989, 8243, 7736, 8356, 8357, 8355, 7548, 
         8358, 7417, 8354, 7547, 8353, 7546, 7729, 7416, 7780, 7475, 7831, 
         8671, 7623, 8484, 7624, 8672, 8723, 8636, 7543, 8473, 7542, 8635, 
         7616, 8535, 8534, 8441, 7396, 8550, 8569, 8568, 8633, 7536, 8472, 
         7537, 8634, 7472, 8570, 7473, 8430, 8510, 7268, 7707, 8227, 8228, 
         8204, 7370, 8203, 7371, 7688, 8766, 8768, 8767, 9372}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{7235, 7730, 7232, 7256, 7859, 7858, 7330, 8556, 7413, 8450, 
         7412, 8555, 7727, 7728, 7545, 8424, 8502, 8503, 7726, 8497, 8496, 
         8421, 7544, 8637, 7409, 7772, 7467, 7830, 7636, 7637, 7468, 8031, 
         8032, 8030, 8352, 8351, 7725, 7290, 7888, 7596, 8160, 8161, 7301, 
         7822, 7300, 8214, 8215, 8158, 8159, 7299, 7677, 7900, 8685, 7899, 
         8699, 9340}],
        RowBox[{"-", "3"}]],
       Annotation[#, -3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7252, 7263, 8232, 7977, 7978, 8188, 8187, 7346, 8199, 7360, 
         8198, 7359, 8213, 7383, 8156, 8157, 7714, 8756, 8757, 9314, 9308, 
         9316, 9361}],
        RowBox[{"-", "3"}]],
       Annotation[#, -3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7676, 7690, 7946, 7262, 8086, 7945, 7870, 7341, 8197, 7358, 
         8196, 7357, 8279, 7466, 8278, 7465, 7713, 8762, 8763, 8777, 9313, 
         9319, 9376}],
        RowBox[{"-", "3"}]],
       Annotation[#, -3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7731, 7679, 7986, 7912, 7913, 8180, 8179, 7329, 8554, 7411, 
         8423, 8500, 8501, 7255, 7645, 7410, 8422, 8498, 8499, 7678, 8552, 
         7404, 8449, 7405, 8553, 7643, 8236, 7403, 8066, 8067, 8068, 7525, 
         8343, 8344, 8164, 8165, 7305, 8350, 7306, 7670, 7534, 8171, 8172, 
         7316, 7753, 8378, 8209, 8210, 8151, 8152, 7297, 7683, 7894, 8686, 
         7893, 8696, 9371}],
        RowBox[{"-", "3"}]],
       Annotation[#, -3, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  Method->{"TransparentPolygonMesh" -> True},
  PlotRange->{{-2, 2}, {-2, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->697452701]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->132779997],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 " to control adaptive sampling:"
}], "ExampleText",
 CellID->139804660],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"x", " ", "y"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "4"}], "}"}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "pp"}], ",", 
      RowBox[{"MaxRecursion", "\[Rule]", "mr"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"mr", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"pp", ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "15"}], "}"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1133661767],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJzNlgtMU2cUx0vp+0XxgYOhQcAxhoAMQRDxXhBw6tRZVEBRVJBFUVDBN1iV
CEymwgSdTCMTjBupIBNlvlB0KoKiyMBBFEYURoFKqS0WKnUueg7rnSSLYYtN
mn9+9/ae+z/fOd/XM3pZjGQ5nUaj6V59/9K3f5QE5QJpiBwKiylMjUNViAfM
obCYwlQf1DhU5VBYTP0d7e3vpT7HGUDFFIYP1Tf1vdTnxAOokkg/tsfCteoG
Yci1yArPtsAWyybK/RZkd75Lk3RXx6DFMcyLRk5Lt+lOGHmdwjXIihC3rkmy
Rsr9ZuTv1stiH0W0EdqzCwIDW9mYd3h8Xc/KYBZypU9w9s4yBrIn+0FAlocx
8vHb8xSFPxj9Y91nz70fW7hYjux1+ZEZk/2Ycr+OwrcIMVuXGZolwngu2uJh
3n5C5EB53P6RT/nIcfUuQ/QHeciZFU/TGny4yIO1TsCg1ZF5D3Zu0+P1pdX7
W0qEfcidRIKm97AOOUEWyZgwtheZb/7F0NgLWuRDuzytC6Y/R7ZTWbu012mQ
zy4WkHYr1Mh+FZpZ4VoVcvWExkVHk7uI99WX4fpxSPvvczdKh4IPDvmwrEi+
fbGGyF8h+bYgm47rbGFxbek4WyZycrmrQ+EJNmkYT0x6jqrdci+mC/sp9MAE
ruyuClkqOnQw2VmNfCypd0z4Pg3ydf3Cosmd3citGy75WszWIvM7R1Vp8nuQ
nb7cHlYl0iHPaWxSyKJfIMcFTYlPqewjbJa4H2m+13+u6ZMYk5nXuMh1J+83
2J7hIRf9mi31O8FH3qeLtoo4JEBeae1dmpgqRA6Yxl+WkyBCfi3KQd7XNPLf
1mWgugKD7luemOsnNUJeygvfJPUyRnYt8P38/HMGMmuutZXmNOudnzN8/6vz
aEZEeWUqG1m8ulgVf5WF3LyX96FDDxP5wqlFU+qc+znt/qmo5EgGcqTaOMPt
iHF/fLOgi4+r6f3xPfKepPP6uSWkT0D6GJFzaSFCS38T9Ne6IfHrGUYi5HjF
Sf7WSwJkk4jfdudt5iPn1NN59W48ZPc5jl9xVdT/S+Wgnavveq4Dv1Ya+X/t
i/f1XDBcD85/1gfvS58b5ismT/eFtr4s4yGnm4UUhh02GfA68pt5ylBrUWGe
AoV5ChTmKVD7db+UFOSocE6QPElJCJuqIWBO2Dp/5iST9ucEzAm5Zaa6kr29
BMwJdybWnov+tI+AOWFYpjpUFiTCfXI3pti/tFSA+2T39C1OtQ583Cf+Y7xH
tGdycZ+AD0NfNegLfIAv8AG+wAf4yrh5svWjaD1qeFlK8UXFC1TXW+FJktU6
VHr55HmtHT2oVeXmtttWaVGzK9SqoR3dqGtu3y39MUqDSt7JSyPan6GaVO4K
q1mpQm2oXOIU1aZEvdN74ChnNJvM0jgSpr564oNv4oKzRrHIcbbyU+O9X/m0
l5iOtWSSNyS51sEevUT+FefyS+YMcuGOsIytrlqiJ0iYOHuEMdlVYME66tRN
+HW2eTUNo5NJDTUbr9qrib1JZep1Q4xIS2G6vNlWRWgcduSsGc4h24LoU5s+
URItHg/cs6RcsmJt/urxL1VErb9j+TU5j5SlLshIrtYQNyWJixSBAnLPcdaF
+hNa4uewOqVZiZCMvvxTk2O8jgDfkAf4hjzAN+QBviEP8A15gG/IA3xDHsMr
1qac+5vG/h7bl2xOR63SrF8338oY1Zm/6Q9bOwbqHqstoc8cmagdbvFVpeNZ
qNNnbAtI82KjzpRH5aXMEr5RJnk+e/OczhzOG6Vhn0PfQ59D30OfG/b9Lex7
qAPUBeoAdYE6QF2gDlAXqAPUBXyCb/AJvpcUf/wydZUINS3GxbTojAD1it1E
m4d6Hqqy0deN8RkX9U/C07CT
       "], {{
         {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
          GraphicsGroupBox[
           PolygonBox[{{237, 135, 22}, {60, 82, 13}, {107, 70, 13}, {199, 60, 
            13}, {140, 237, 22}, {135, 151, 22}, {70, 199, 13}, {190, 46, 
            10}, {50, 190, 10}, {82, 228, 13}, {85, 50, 10}, {228, 107, 13}},
            VertexColors->None]]}, 
         {RGBColor[
          0.3738002814617082, 0.19717095648076804`, 0.6424018319228891], 
          EdgeForm[None], 
          GraphicsGroupBox[{
            PolygonBox[{{161, 178, 24}, {235, 120, 20}, {129, 235, 20}, {246, 
             161, 24}, {176, 129, 20}, {167, 246, 24}},
             VertexColors->None], 
            PolygonBox[{{86, 51, 50, 85}, {238, 136, 135, 237}, {200, 61, 60, 
             199}, {191, 47, 46, 190}, {229, 108, 107, 228}, {141, 238, 237, 
             140}, {51, 191, 190, 50}, {108, 71, 70, 107}, {83, 229, 228, 
             82}, {61, 83, 82, 60}, {71, 200, 199, 70}, {136, 152, 151, 135}},
             
             VertexColors->None]}]}, 
         {RGBColor[
          0.45240226419430846`, 0.33383857680812745`, 0.7528864273719756], 
          EdgeForm[None], 
          GraphicsGroupBox[
           PolygonBox[{{62, 84, 83, 61}, {247, 162, 161, 246}, {84, 230, 229, 
            83}, {142, 239, 238, 141}, {72, 201, 200, 71}, {130, 236, 235, 
            129}, {239, 137, 136, 238}, {192, 48, 47, 191}, {236, 121, 120, 
            235}, {109, 72, 71, 108}, {87, 52, 51, 86}, {168, 247, 246, 
            167}, {137, 153, 152, 136}, {52, 192, 191, 51}, {177, 130, 129, 
            176}, {162, 179, 178, 161}, {201, 62, 61, 200}, {230, 109, 108, 
            229}},
            VertexColors->None]]}, 
         {RGBColor[
          0.5310042469269087, 0.47050619713548697`, 0.8633710228210623], 
          EdgeForm[None], 
          GraphicsGroupBox[{
            PolygonBox[{{80, 95, 14}, {110, 221, 18}, {209, 80, 14}, {144, 
             110, 18}},
             VertexColors->None], 
            PolygonBox[{{240, 138, 137, 239}, {202, 63, 62, 201}, {138, 154, 
             153, 137}, {193, 49, 48, 192}, {88, 53, 52, 87}, {53, 193, 192, 
             52}, {143, 240, 239, 142}, {73, 202, 201, 72}},
             VertexColors->None], 
            PolygonBox[{{116, 163, 162, 247, 18}, {231, 116, 18, 109, 230}, {
             112, 231, 230, 84, 14}, {95, 122, 121, 236, 14}, {63, 209, 14, 
             84, 62}, {169, 144, 18, 247, 168}, {248, 131, 130, 177, 25}, {
             163, 248, 25, 179, 162}, {221, 73, 72, 109, 18}, {131, 112, 14, 
             236, 130}},
             VertexColors->None]}]}, 
         {RGBColor[
          0.5974837008200982, 0.5816522429426644, 0.9102661502393317], 
          EdgeForm[None], 
          GraphicsGroupBox[
           PolygonBox[{{117, 164, 163, 116}, {113, 232, 231, 112}, {164, 249, 
            248, 163}, {232, 117, 116, 231}, {170, 145, 144, 169}, {64, 210, 
            209, 63}, {96, 123, 122, 95}, {210, 81, 80, 209}, {49, 193, 4, 
            5}, {139, 155, 154, 138}, {111, 222, 221, 110}, {203, 64, 63, 
            202}, {16, 139, 138, 240}, {222, 74, 73, 221}, {240, 143, 21, 
            16}, {74, 203, 202, 73}, {132, 113, 112, 131}, {54, 4, 193, 53}, {
            249, 132, 131, 248}, {81, 96, 95, 80}, {89, 54, 53, 88}, {145, 
            111, 110, 144}},
            VertexColors->None]]}, 
         {RGBColor[
          0.6552743459898152, 0.6745057293123441, 0.9115835989515814], 
          EdgeForm[None], 
          GraphicsGroupBox[{
            PolygonBox[{{9, 3, 4}, {11, 17, 16}, {139, 16, 17}, {185, 26, 
             2}, {4, 54, 9}, {31, 194, 6}},
             VertexColors->None], 
            PolygonBox[{{223, 75, 74, 222}, {194, 55, 11, 6}, {55, 102, 17, 
             11}, {180, 31, 6, 1}, {114, 233, 232, 113}, {97, 124, 123, 96}, {
             204, 65, 64, 203}, {36, 185, 2, 3}, {171, 146, 145, 170}, {233, 
             118, 117, 232}, {26, 180, 1, 2}, {165, 250, 249, 164}, {75, 204, 
             203, 74}, {118, 165, 164, 117}, {250, 133, 132, 249}, {65, 211, 
             210, 64}, {41, 36, 3, 9}, {133, 114, 113, 132}},
             VertexColors->None], 
            PolygonBox[{{241, 156, 155, 139, 17}, {211, 41, 9, 81, 210}, {102,
              223, 222, 111, 17}, {90, 216, 9, 54, 89}, {216, 97, 96, 81, 
             9}, {146, 241, 17, 111, 145}},
             VertexColors->None]}]}, 
         {RGBColor[
          0.7130649911595323, 0.7673592156820238, 0.9129010476638311], 
          EdgeForm[None], 
          GraphicsGroupBox[
           PolygonBox[{{27, 181, 180, 26}, {115, 234, 233, 114}, {119, 166, 
            165, 118}, {217, 98, 97, 216}, {172, 147, 146, 171}, {224, 76, 75,
             223}, {98, 125, 124, 97}, {181, 32, 31, 180}, {56, 103, 102, 
            55}, {251, 134, 133, 250}, {166, 251, 250, 165}, {37, 186, 185, 
            36}, {91, 217, 216, 90}, {234, 119, 118, 233}, {42, 37, 36, 41}, {
            186, 27, 26, 185}, {66, 212, 211, 65}, {134, 115, 114, 133}, {147,
             242, 241, 146}, {32, 195, 194, 31}, {103, 224, 223, 102}, {205, 
            66, 65, 204}, {212, 42, 41, 211}, {76, 205, 204, 75}, {195, 56, 
            55, 194}, {242, 157, 156, 241}},
            VertexColors->None]]}, 
         {RGBColor[0.7700172816385126, 0.849461128112, 0.9107219524450344], 
          EdgeForm[None], 
          GraphicsGroupBox[{
            PolygonBox[{{166, 119, 19}, {134, 251, 19}, {115, 134, 19}, {251, 
             166, 19}, {119, 234, 19}, {234, 115, 19}},
             VertexColors->None], 
            PolygonBox[{{218, 99, 98, 217}, {57, 104, 103, 56}, {187, 28, 27, 
             186}, {28, 182, 181, 27}, {92, 218, 217, 91}, {225, 77, 76, 
             224}, {196, 57, 56, 195}, {43, 38, 37, 42}, {38, 187, 186, 37}, {
             182, 33, 32, 181}, {148, 243, 242, 147}, {173, 148, 147, 172}, {
             77, 206, 205, 76}, {243, 158, 157, 242}, {99, 126, 125, 98}, {33,
              196, 195, 32}, {213, 43, 42, 212}, {206, 67, 66, 205}, {67, 213,
              212, 66}, {104, 225, 224, 103}},
             VertexColors->None]}]}, 
         {RGBColor[
          0.8219172033136918, 0.8667683690682865, 0.8874708340437673], 
          EdgeForm[None], 
          GraphicsGroupBox[
           PolygonBox[{{244, 159, 158, 243}, {34, 197, 196, 33}, {44, 39, 38, 
            43}, {188, 29, 28, 187}, {197, 58, 57, 196}, {93, 219, 218, 92}, {
            149, 244, 243, 148}, {78, 207, 206, 77}, {214, 44, 43, 213}, {183,
             34, 33, 182}, {58, 105, 104, 57}, {219, 100, 99, 218}, {29, 183, 
            182, 28}, {174, 149, 148, 173}, {105, 226, 225, 104}, {39, 188, 
            187, 38}, {68, 214, 213, 67}, {100, 127, 126, 99}, {207, 68, 67, 
            206}, {226, 78, 77, 225}},
            VertexColors->None]]}, 
         {RGBColor[0.8738171249888712, 0.884075610024573, 0.8642197156425001],
           EdgeForm[None], 
          GraphicsGroupBox[
           PolygonBox[{{101, 128, 127, 100}, {40, 189, 188, 39}, {208, 69, 68,
             207}, {106, 227, 226, 105}, {69, 215, 214, 68}, {215, 45, 44, 
            214}, {79, 208, 207, 78}, {220, 101, 100, 219}, {30, 184, 183, 
            29}, {94, 220, 219, 93}, {59, 106, 105, 58}, {227, 79, 78, 226}, {
            45, 40, 39, 44}, {175, 150, 149, 174}, {245, 160, 159, 244}, {189,
             30, 29, 188}, {35, 198, 197, 34}, {184, 35, 34, 183}, {150, 245, 
            244, 149}, {198, 59, 58, 197}},
            VertexColors->None]]}, 
         {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
          GraphicsGroupBox[{
            PolygonBox[{{245, 150, 23}, {40, 45, 8}, {160, 245, 23}, {35, 184,
              7}, {220, 94, 15}, {128, 101, 15}, {106, 59, 12}, {150, 175, 
             23}, {45, 215, 8}, {79, 227, 12}, {101, 220, 15}, {215, 69, 8}, {
             227, 106, 12}, {189, 40, 8}, {184, 30, 7}, {59, 198, 12}},
             VertexColors->None], 
            PolygonBox[{{198, 35, 7, 12}, {69, 208, 7, 8}, {208, 79, 12, 7}, {
             30, 189, 8, 7}},
             VertexColors->None]}]}}, {{}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           TooltipBox[LineBox[{128, 101, 220, 94}],
            "0.75`"],
           Annotation[#, 0.75, "Tooltip"]& ], 
          TagBox[
           TooltipBox[LineBox[{160, 245, 150, 175}],
            "0.75`"],
           Annotation[#, 0.75, "Tooltip"]& ], 
          TagBox[
           
           TooltipBox[
            LineBox[{30, 184, 35, 198, 59, 106, 227, 79, 208, 69, 215, 45, 40,
              189, 30}],
            "0.75`"],
           Annotation[#, 0.75, "Tooltip"]& ]}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           TooltipBox[LineBox[{93, 219, 100, 127}],
            "0.6`"],
           Annotation[#, 0.6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[LineBox[{159, 244, 149, 174}],
            "0.6`"],
           Annotation[#, 0.6, "Tooltip"]& ], 
          TagBox[
           
           TooltipBox[
            LineBox[{29, 183, 34, 197, 58, 105, 226, 78, 207, 68, 214, 44, 39,
              188, 29}],
            "0.6`"],
           Annotation[#, 0.6, "Tooltip"]& ]}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           TooltipBox[LineBox[{92, 218, 99, 126}],
            "0.44999999999999996`"],
           Annotation[#, 0.44999999999999996`, "Tooltip"]& ], 
          TagBox[
           TooltipBox[LineBox[{158, 243, 148, 173}],
            "0.44999999999999996`"],
           Annotation[#, 0.44999999999999996`, "Tooltip"]& ], 
          TagBox[
           
           TooltipBox[
            LineBox[{28, 182, 33, 196, 57, 104, 225, 77, 206, 67, 213, 43, 38,
              187, 28}],
            "0.44999999999999996`"],
           Annotation[#, 0.44999999999999996`, "Tooltip"]& ]}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           TooltipBox[LineBox[{91, 217, 98, 125}],
            "0.3`"],
           Annotation[#, 0.3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[LineBox[{157, 242, 147, 172}],
            "0.3`"],
           Annotation[#, 0.3, "Tooltip"]& ], 
          TagBox[
           
           TooltipBox[
            LineBox[{27, 181, 32, 195, 56, 103, 224, 76, 205, 66, 212, 42, 37,
              186, 27}],
            "0.3`"],
           Annotation[#, 0.3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[LineBox[{115, 234, 119, 166, 251, 134, 115}],
            "0.3`"],
           Annotation[#, 0.3, "Tooltip"]& ]}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           TooltipBox[LineBox[{90, 216, 97, 124}],
            "0.15`"],
           Annotation[#, 0.15, "Tooltip"]& ], 
          TagBox[
           TooltipBox[LineBox[{156, 241, 146, 171}],
            "0.15`"],
           Annotation[#, 0.15, "Tooltip"]& ], 
          TagBox[
           
           TooltipBox[
            LineBox[{180, 26, 185, 36, 41, 211, 65, 204, 75, 223, 102, 55, 
             194, 31, 180}],
            "0.15`"],
           Annotation[#, 0.15, "Tooltip"]& ], 
          TagBox[
           TooltipBox[LineBox[{114, 233, 118, 165, 250, 133, 114}],
            "0.15`"],
           Annotation[#, 0.15, "Tooltip"]& ]}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           TooltipBox[LineBox[{4, 54, 89}],
            "0"],
           Annotation[#, 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[LineBox[{16, 139, 155}],
            "0"],
           Annotation[#, 0, "Tooltip"]& ], 
          TagBox[
           
           TooltipBox[
            LineBox[{123, 96, 81, 210, 64, 203, 74, 222, 111, 145, 170}],
            "0"],
           Annotation[#, 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[LineBox[{113, 232, 117, 164, 249, 132, 113}],
            "0"],
           Annotation[#, 0, "Tooltip"]& ]}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           TooltipBox[LineBox[{49, 193, 53, 88}],
            RowBox[{"-", "0.15`"}]],
           Annotation[#, -0.15, "Tooltip"]& ], 
          TagBox[
           
           TooltipBox[
            LineBox[{122, 95, 80, 209, 63, 202, 73, 221, 110, 144, 169}],
            RowBox[{"-", "0.15`"}]],
           Annotation[#, -0.15, "Tooltip"]& ], 
          TagBox[
           TooltipBox[LineBox[{143, 240, 138, 154}],
            RowBox[{"-", "0.15`"}]],
           Annotation[#, -0.15, "Tooltip"]& ], 
          TagBox[
           TooltipBox[LineBox[{112, 231, 116, 163, 248, 131, 112}],
            RowBox[{"-", "0.15`"}]],
           Annotation[#, -0.15, "Tooltip"]& ]}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           TooltipBox[LineBox[{179, 162, 247, 168}],
            RowBox[{"-", "0.3`"}]],
           Annotation[#, -0.3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[LineBox[{48, 192, 52, 87}],
            RowBox[{"-", "0.3`"}]],
           Annotation[#, -0.3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[LineBox[{121, 236, 130, 177}],
            RowBox[{"-", "0.3`"}]],
           Annotation[#, -0.3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[LineBox[{142, 239, 137, 153}],
            RowBox[{"-", "0.3`"}]],
           Annotation[#, -0.3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[LineBox[{201, 62, 84, 230, 109, 72, 201}],
            RowBox[{"-", "0.3`"}]],
           Annotation[#, -0.3, "Tooltip"]& ]}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           TooltipBox[LineBox[{167, 246, 161, 178}],
            RowBox[{"-", "0.44999999999999996`"}]],
           Annotation[#, -0.44999999999999996`, "Tooltip"]& ], 
          TagBox[
           TooltipBox[LineBox[{176, 129, 235, 120}],
            RowBox[{"-", "0.44999999999999996`"}]],
           Annotation[#, -0.44999999999999996`, "Tooltip"]& ], 
          TagBox[
           TooltipBox[LineBox[{47, 191, 51, 86}],
            RowBox[{"-", "0.44999999999999996`"}]],
           Annotation[#, -0.44999999999999996`, "Tooltip"]& ], 
          TagBox[
           TooltipBox[LineBox[{141, 238, 136, 152}],
            RowBox[{"-", "0.44999999999999996`"}]],
           Annotation[#, -0.44999999999999996`, "Tooltip"]& ], 
          TagBox[
           TooltipBox[LineBox[{200, 61, 83, 229, 108, 71, 200}],
            RowBox[{"-", "0.44999999999999996`"}]],
           Annotation[#, -0.44999999999999996`, "Tooltip"]& ]}, 
         {GrayLevel[0], Opacity[0.4], 
          TagBox[
           TooltipBox[LineBox[{85, 50, 190, 46}],
            RowBox[{"-", "0.6`"}]],
           Annotation[#, -0.6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[LineBox[{140, 237, 135, 151}],
            RowBox[{"-", "0.6`"}]],
           Annotation[#, -0.6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[LineBox[{199, 60, 82, 228, 107, 70, 199}],
            RowBox[{"-", "0.6`"}]],
           Annotation[#, -0.6, "Tooltip"]& ]}, {}, {}}}],
      AspectRatio->1,
      Frame->True,
      PlotRange->{{0, 4}, {0, 4}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], 
     GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJy1XAlUzevXPqczd4YyNkkDmaVEkeF9SUTmKVNIiiQkZJ5JmTUYiiIRGUJC
AxEKmRo0F41KaZ6n7/zv99/v7+t3butrWfda1nrX49zOaZ/fu/d+9vPsdbVW
bZxrI8dgMCy4DMZ/Tvqfc32nSv/Go/Y4h+D0UAfp31+01ysJ/uvl9FqC0/76
hyaCW9v++kPw2b9+Xg4D7vMfeI5N8OO/3o9L8JS/PlBAcOpf7y8k2P6vX1BM
8P/+UaRhKs6/P3MIhnjbv15JMMQLGOIFDPEChngBQ7yAIV7AEC9giBcwxNv+
uSnSMPUc/z5O6mwfbw4t3hxavDm0eHNo8ebQ4s2hxZtDizeHFm8OLd4cWrw5
tHhl7+nfP0cqTvoJ8QKGeAFDvIAhXsAQL2CIFzDECxjiBQzxAoZ42+edIg1T
efj39zRHJq72r1Nn++dbSXu+lbTnW0l7vpW051tJe76VtOdbSXu+lbTnW0l7
vrJ15u/zMEfmudHjAkw/IV7AEC9giBcwxAsY4gUM8QKGeAFDvO3rpiINU3X0
7+tMjsy9pD83elyA6SfECxjiBQzxAoZ4AUO8gCFewBBv+76giDvqE39fR3Nk
8o5+L+nPjR4XYPoJ8QKGeAFDvIAhXsAQL2CIt33fU8Qd9UGIl1436XWFnnf0
e0l/bvS4ANNPiBcwxAsY4gUM8QKGeNv3dUXcUZ+HeOl9gV436XWFnnf0e0l/
bvS4ANNPiBcwxAsY4gUM8bbnLYq4Ix4D8dL7Hr0v0Osmva7Q845+L+nPjR4X
YPoJ8QKGeAFDvO15mSLuiKdBvPS+Tu979L5Ar5v0ukLPO/q9pD83elyA6SfE
Cxjibc87FXFHPBTipfMWel+n9z16X6DXTXpdoecd/V7Snxs9LsD0E+Jtz6sV
cUc8G+Kl8zI6b6H3dXrfo/cFet2k1xV63tHvJf250eMCTD8h3o7mCIi3Pc7p
gJfReQu9r9P7Hr0v0Osmva7Q845+L+nPjR6XoswJv/+1b3l2J/p9QEP3MO/v
NMuT4ZWMgE9OCUdek/4qtNXqfdczioa/oNXZxXU9rlfL8Jb52KX3nOZwGv5A
+vDiiRUH8y2e0nAswdEVI7RLJsSjLi9dFmtVys5XvS5ZXfl1+zENvyHYy+Bd
qB7+QvpCv6dJoTH+j2g4muDRHvhc0NaPpK5mRPBVgro8pOFXBJurnQzYr/qB
9no84tad+/TssOx853PNpCY4KZiGowj+5ZS/0RW/o73+hdQB9FA0PiP0Pg2/
IDj4iKuuzrsY2uufSV7V5aFNOQPv0fBzgsN+DUu0831Le/0TuafLLuuU1pbf
oeEIgrmGGfrPQt7QXo8jfC6vizjk4YxEcsK/w3088a1y3bnQdDTTsLk+/F6e
zFxzxUywYt+7RILHb0rWs9P6jkzt5U4ifrnMXPCJMXcFGpJGcJlr/15Gohw0
QUnncYmL7HwbyNxySS4+ieD9t2Y8f1aXRe5jTH32IPVB6eR+ze67Yd46fgq5
P5fXK/gb90gi9xTyCvIM4oTPhTghbngdzvd6Y8/scM4nZ/ufr0TDz5w3OlxQ
gA4n3GVOnfSbvA73sdeiMY07lxYhReHYlOrnHJk+/M45KV3Dt4jgy/en3PTx
LECnx+r5plTxZPpYZcT7mzoORQRHbzuwf1b/QoI99UYt3vEjD7GVtF9mZQhk
+kKI/4VIt7Zigodmjt3Vd0ARwTd6/hj1fHYhwRqzj9Ra7Mgn+ILrwJCKq7no
XdIJl+g5VN9ZGv2VaXhVKFOXmzQ87KyOFBNsmnjXw6PsJ8GnjsW8iFlcSHDK
2B/FjdH5BGtVNPbQ1c0j2D6g+wSrCzkopqGF+YajQH3ef+skPBd4vnAvO7q3
gOF94DnCc4XX4b4Jjw7RuF1YQfCU/d1M3PLL0KJT+YMN65ikD2WmcV6OmMuQ
4dG7b6yLH9uzguCT8d2OhzqVEay9aK5jVVgJWqd8t5v3SpYML5WbtnbM5eMV
BAdEjbbr51xO8dANPXVXvPlNcMrSZ66OPiXo9bTg931aOBQPuoOP5D5ly/DA
e8E9smJzKwju03tLhkZFOcF6SgGPS5vLCFattHrorfSbYPbH3venDi9BJbFx
Oc7n+eT9xxfqf7hpypPhYeqm+26s2F5BcLe7PQwqTpVTeNCifRzzMoLbGg5f
GLC9lOCSdw8emAf8QjxLce85QnkZ3rNha2Or29IKgh/1VG0qsC4nuHyj0+8j
Kb8J3vnwYcG4ohK0cX+W98ubQhlecUopL0gQUkGwtqV1jbJbOXU/Td/smR31
m+IVX6IVN64vQcZKh1RDcyheBvUJ+nZHfR0w3Geomx3VVcBQPzcZZTqanq5B
PiIHr/rqBpk5PbDVQO6eEoW/98k/E7W0mmDlqV4aCb6VKH5NUuqu5lby8+EH
bXQq7jfL6DUsrTMCn5oagvNib0SvuFFN8JtNkXv6WFShQBOb+w5eTMLT9FaW
D4s8y5CZM+NXKJet/llDcEK43m21F9UUVppqE+9ZRXCik5Wm6/pKpDEvQKXo
AYu835nz3KzNvnIyc53e86HdfU0p/FxYXhrepYbg6YsfxqRkVlFz4I0tV2tu
VaLf5XEpKXrUnLhBketmEs+WmaN6f+2xe9QoCl/R4bgZP6wmWH1n9fmxQ6rQ
bQUd/0/qfJm5RH9a1dl9h2oIDmQEstQuVKItn1Z02RcokuG5J8+MufJweBXB
/Z493buKU0Pwix8jV3RNqUW1LqXI+pyE/Pz6RTEe1i0KBHfEG/+/Pk3Xv+De
wT2k62Bqx7R76L5pIHhcT8MG09y6Dv+drivpPLUMfnm+keBBLjedxdoNBA9b
WDF+8Z06tM3hZIUij9Kljjkcv2o6v4Xgiw6uc3ZebZLR4/o3xSu69m8kWMK+
3T0hrJ7gatEBZfWZdcgs8W32izVMMmeUhGQWhtkzZHSS62EzNqt9byR4l8Oe
BW/5DQTP0bw7ylG/Drk1/pBM7EHpLHJ63Ga1rXIyOkS/oJQGj0kN5D4l37w3
It23HqnwRm6ses+TmWtt7+S+GLW/juDFOWd1FhTUEzxdGR93nN6IQhNPxk7Z
T+kARb7Pt485Ky8zNyqtqnNvsK0jeNfpYYZPZ9QTnB2xJmXbiAaCJxX77hyp
1khwoFJKr2pmEzrq4rOYdYGaw9nb4tPEW0QEH1zNX6Y8W1bPVGx57fjWp47g
e/V33h5ZUU+webWHmqn0PgAuKtu9iZ1P4aO/Vr+JvtlIcN/C6aqH1jUhq9Jc
ZT19Cfk8h2z1lpCeCgTv+GrxY3QzhaGew5zU2bmKzmvpempHdbezdZuux3Y2
DzqbV3Rd19h26oaeARSu0eTKb/rZQnBw+quAd4ObO/3f0XXUg7pxWxe5txJc
J2dh8TCsCf2Kc1DWk+YfXZcr3O3Zp3FKM8FTMsxXmWm3EnxzjNxVr+Y2VG0w
ZXp/P0rHfC+/3fl1BIdg3x+B16xSZfXo8+hEkWospZNxF/pO1k5qJnjr+of+
A3NaCM47+IahX9ZK8LyLKZajpJ8/X3vzo6s+PPL+0ZN/cMau4BM83H72om9a
svr3EbubAYUXqPzu3WX7a88dzQQ/eWqWa7KkheDZK1XkKo1bCS7iFWv6qVHv
d/B+GJop/X3WKCx59CyP+rzBZl+Vr9yUJ7hsv9neg+tk9XfPne4JB2qo+jDS
1S3MrLqZ4KTzB64qVLUQvPXG9mPfKlrR1LNdE6a6iGR0mSo/fD5lXAvqrM5A
nwvp+n1HPL0jXk/X+zviLZ3lPXS/oKO+0dm+Q/cbIA86yhO6D/G8Kq5ybiST
nHTdPt/69OAmAYPgbMstuQnfKJxqsdj7jj8Ts3NeqBiyWOTnP+wTO9Zls2R0
8Sdh8lscjzAI/lbnsyZNyCS4ZsSwpSbnKNxt88uZd5TlcML5aUqVDyhfIUBu
wPHrCzkEOztw2hY2UXhaSs5mgZ+snzKpekhI5WEGwes1/da8l34+YI/p3dSu
naNwxPajn3aoyOG9vS/7bVzEI+93dIrtpko1PsEnNw3DW7P5MjpxsmXYjogc
BtH9VrB6Xf/GkSN46sqqpHBHJsEjIt/zrmYycLNJk2rXAAXyfvtfLLvWmCEh
mD3m+cDc7hTurK5G10nofg/MnZ2dU+n+UEe8+095PN1v6ogXdZZX0f2pju5t
Z+893dcyXPChZbENlT+RhdMmK9dTeNLO96e+ubEIfi+aluyh/uc/R/eZ9i85
u2BgCJVvI8MPPHFdyiK4WG2zSrEcGz87Hplu94z6+ZeuiltPbecQHOtiLXlk
xJXxOeyqH405HMPCz8eWHuN6ycv4Atf230pRM6Gw3v2mtcVfWQQ/z5zR8HQl
haeL/FxdyiifId24UmXhXjm8yHDArjEzKN/hQC+7c8ahIoJvy92+NVqDwok/
i6NGHRPK6PZ5tfNve+ym8K4B4luNPSncdcmbmyul9xXwreN7brw1p/CEyJEB
QwqofE35Xep/br8c9jGTfqUZCuTzDil4lRWPpPC6b78Grj0tIXj25Qmr839S
8QBfBJ36T3Vuup8JOiPojnR/syMd6E91Jbpf2tFc/KdzNn3OofuvneVtneWB
dD/3T/vOn/Y5un/c2TztbN7TfdlhtS23g20oXJLa+rTEn4OXdVnZq+oWn/z3
/DjnDzrfeTI+p39Eb9OoVArbh6Z1Y9tR2CDYK2dKPYfgpltzHxx3oXC0v2T/
554UPn75/cxuN9j4ifIplUh7ylfNWMe1rS+QJ1gucu9Dg1UU7q9Q17ohk/Kd
Z1htNL+9SCDjU25aWztjbQyFzbMuZreZULjf/HGO56M4BDPff5cbNo7CGeiw
x1vp81A2aR3qeInyQdX9I0vKs0UEa7H2BG3SEcn4hlNd+z7Uj+T+sQ9F9/PB
J+jIR6D7/R3psv+U7kvfJwBdq7M6GH3/AHQM0DXo+widnZv+qTmNvv/QWV74
p7yTvk/RUV52lMf0vYuPX3/fW1rOJ/hZycQmrjOFA3jnpzxs4VH7R9q/3C0P
U3jvOPSdL+T9Y+9D35N4+EBRY2AGn+AfLZ9zbPQo3GXa6RvXpO9zYsdPPlKj
9ixORu8+7WchT/ApcZeech4Cmb2EX0pPNbZP4WFhxTKexiyRjI9vv6Kn9Yrv
VL6uTvI5GT2PR7CleZ+n/WMovPDlrZzjxnyCZxrpicvvUnjK3VCj+dL7J1/7
rfhLDrUnsX7z9q6D7SQEf/qtYnykjML69uFW2VsVCHYvXOb6H70J8J/60PT9
GPAJO+sr0vdpwHf5p3yc/0/3pu/rdKRTdlbnpO/7dFb3+Ld0F/rcSN83At4N
PJy+f/RP9c1/q6/T96M6m8edrQv0PSufA8cDgpIE5KTvJb257VDQZEbVh8j8
OwGmTyn8WLNk9en+8gTfXTq4b6oXhQO81uVqc4V4dJFvmbIj9bnzGHonexRS
2EEpalBXSxHBLrqzYyUJFL5q+t1GOFV2H0w1YV+EkydVnwzkG4IuCOQJnj5h
s3fkHgrbbv/lllMhj8M5q8sDo6j3u1NUeKD/TAnBlz/ad7uRTuFTD8qu97VT
IPhP91To+2gd7Qn8U3sI9H038G3/1Pel78uBzwb1pbM+xT/li9D380An/VOd
lb7P96dz9j8159P3CTvLq/8pHk/fXwReADyBvs/4T+X5P1V36HuVcZPwVy1n
6t+nCV0KurRROPbrxyam9P4Annyhe5dKyZ//HOA/3UsDDPUB9nr+rb0hwFAv
YC/jT/c6AEO96MhX76wvDxjqSWd9yH/LBwUMPgyJ/7/zTWd16s7q3oCh3vyp
zvZv6X7k9//vHA8Y6sc/xfP/rTkEMNSjP+UJf8pLAMOpifqyJ0crEDxINy6h
3pLCI9S3+AfVSwgeL+rltNydwmZN0RO76FJ4brF919ex4n/tfQEbL3l1J6Zr
EdkrFQfrZXhOKSd7iPPmiA3TllJ7Xd33fk09vYHa6wr/ER073Lue7NlELbiT
VrekkezZtL33MRhZ1Uz2CHSyPxx/tL2V7BFMq2rM1W+l9gi+iKqWWdxlkH3s
qyoFz+4tYRKfdHO/1J5cPuWTzo1v+zyxgPKNuu0PFVsdYhHfKHGog/k+Tco3
kj+9ZM83bQ7RqSsStb9ZP+IQnTpF9ZduhQmlUz9f+chlbyKlU793OzJebRWP
6F7ZN4e9jf3JI7pX9evUGds28onuxc85lNSnlk90L8U3vcIc/P/P3FvXffBU
bXky914bJPbpe1WezL32lhwxQ5Oaex1CdW2WF1C8lhla9puzQkR4refj4O13
k0WE1w547Ci3YDbFa3842k/1HSQhfc6Cr6ljfUVC+tzHK4mM/l0VSJ8zGema
UXxEgfQ5kXjJxMTPqeSsaVvQLeNjDlqUvsrDfW4CmjZsX/d+/X4iOePHXv1Z
WShl50JrjRW/0Yk7qtdqBqegSSZmRhs2VaAaqykZT85/R13rftSEP6tE7hvu
aB4UJqIhBxX99J9Xo6ZLtu8WqWegyWI07earWvTAWvHZeaUc9MVHX/TVsh41
fL9a+GBuCnIwTU/9ZdKINhwy663+KxslaZq01vdrRvvjrqgP1U1C/ma33Ndw
W1GovZFTYVAG8sjeXiCpY2CkpfjWm5mGRIG8cdWVcngDHvfz6vlktFEl3664
mI1rbmRH6EqSSF5AnkCcEDfECXErz/PcnDErl5x+NePrq9k/yWmrcyhbZ3gp
Undf7uUuzkO3mp883Z9TjvhrzAds9PuJrjjfMu+aWIWC3gs4jBX5qN40+FLQ
Ai4uUHq57t7CInR42D3th4/5+PNgjwmGD4sQZ8lm94VNPJyQdJ0dG1uA2D7O
R8Nr5LGLuafLu5NF6IWtqYmrgzx23Ba3k+FQiHbod2NY5Avw0qusDUbT89GP
pEfX112WzhV+Vk+qeL/Qr5M7ep7RE+O0/dv3us4vQjWm6NjjaBFmWp021bha
iNpa2I1pC0W4/4Qbosel+Ygf+t6eUSzEM7UiE6YZ56H+SokW6e8V8M5uz437
XixGQ376qgg2KOAzFqUT0nWKkP4z+3TDLgo4wLvX1HMPC5Ghm9Hl1SESHJ5t
PnsqKkBjlrJWnLOQ4C99dlkw4vIQHvJZM6pRjAvW3F7+ZFEuqUtQp+BewT2D
ewX3DL5n+N7he4bvfc2q298/1ZWQ852VUlZ6bznM8s0f6F5dgdaYjsz1MGXi
8bZaIzgTy9Ett1vJfbuy8ZWbzvXpZtL3H5084/5+FnZhJ+SV65Sjc4Xs16Ol
80H2q2XXhNzfqMG+OPb5SS5W1VoT+vZuBUo/o53h0IuLs9YlZ/T9UI4iHy8p
6xXEwZPsTnO5X8uQb9o5ubjRHBzXvHHeK+FvdKDtfY9dsWy84Mxsv72TS9Do
n2NGXGzi461fnNcOr6tAZcH3nA5c5OMcK8tCOYMKFLBD65GdER/Pqppom7Ch
HC2d6FE5J4mHnQVz3k9ZUIa6CnnDjZ14ePaQXrE/40pRbMIOR+0uPDxgVuEb
10klaBBn8nV/VSE2eNnQp/VaBfoi4KpERcrjfe93iI2KytE2yduTGSvl8YeE
htqNw8pRr25H5RpY8lg3rCpqzq/f6JXSZOceNwX4bVyVe7RzKVrbi1uiP02A
l2dX2Y5klyAV68DGvUvEuMxgyB37MxVI7fD5BWMaRbhqq/yqvM/lSD3gaHDd
RWk9e/JTyVKhHGm83SoMGS3CtVUnvYMu/0ZahattN6UKcavzNN7lXqWoL3/+
yyE7hJjXzHU65f0LLQyZpGEbq4DHn4z/Up5agQZsa9OcvlgB5yqaJUY0laNG
ozDt4cUS7OoRmXxMvRzFNWzpq7xLWv/0bENv7f2NroQP69cqlOCbRnMiJ7wq
IX2vfR/8Qvog1C2oY1C3oI5B3YI6BnkNeb7LJbH4wupGZDF+4ttZ8TUo8XzX
WXUb29AJzm+OjXktalqVlDFnYCt69CXY/QW7BvXRvbDuTk4zSvd20lJ9XoV8
+xm7Vdcycbxj5A2xUS26OCjtfJd9TByzo+XllCk1yEN3Z4Auj4kjDozLPGBR
jU4NV31kfpqBH7juqQ9fU4VcDcOi1iox8I2zkd1qnStR7P6meYbj2JiZebeH
mX4tkuTez9FJYuETV3sa9LeqQfNNVzv2cGBhJdt9s7lnq9Glm8oMDoeFrw36
6ZAfVYWyBR9PVfvIYd2y2cdfl1ei0qATjv6BXNy/eNyQ1K21yNFGNRNjLta1
XMzqHlCDanoHmmUlc/DIL1vSZiZWo+0pI0N2beTgsSZnHriyqlHz2WgNFR4H
m4QGHXstnTv2mc85HnqFjacNjFnRZlWJVFyTByaV8/HSpRO2VznVorRJqWsM
tvJxZvyk6vu7a5A3Iz3gbAMPL59mtmn9kWq0LCIjt2wPD2e/NC8ZcKoKqW/P
0popx8NWo2etzfeqRGxmrp5hDyEWyb21Wj+oFl31uaKRO18eTx49Dr29VY3G
j1oiOeMhwPs2hfTSHFiFBEunaEW8FuLK9c3qw+oq0fF3Ir95iRL8mVFT2/1w
NSphxGhl/Gdu2mjXqJNM7SO3500fCG+CvgZ9Dvoa9Dm4J3BvPA+rXf66kjov
qoed9RzWQM7LoYuOLm6tI2fU7jN52nvakI9B64vU4kbUrW9M25kLragsbUT6
FG4jsv3Qotr2qAVNPGhf+1irAT3bPMLQ4XMz8hx4rUvfcfVIpGo/J724Cf38
kjLk3KI6ND45f7BuEROP6HVT8v5uI3I6fTbkxx4mvnyiVUM/uQEFThk3zrMr
E3NbFuhfYDSgjLafb8xuMvBGh7sT2wbWoy5PPWY2j2Hg1Ez2fNt5dajtTIRY
fz0bn5v86u5RrSbkLul336aUhcMmeJaX9WlE/U+cnn1pAwvnjF1rsLhfAwoX
NFR8ktZbwagx214NqEezXFa5sxzlsL6B5NngwXWIXxQ9xXUrF++/O76l9Goj
Us9LXax+gYOD/Ndp9SysRwbZZfYPwtj420Uv0/FD6tCQqCcN2zcJ8P53TOUx
TnVock6+TbKOPH4kXl5el1mPVrC7x49Ml8cFc8JiQ8waUdxut2d9vYXYp6G7
01TDOjRn364jmS1CfKO1Vj68qQ59O7B+jtdKEQ5mpV4b8rIeLT1sqT5L2k/D
+OHGV442oO9HZxbx+onxa/HleIXpjcjGFT2OOibGn7ruW3egSxPanJcyelq+
9PV9GrPMR9WhxyHNTl2GS7CZ5pro1K91qO6w5r2UvRIcF3XPaK19PTJeMOmn
7wcJnm1VG1TLbkC7ddZqr1FWwInM8ZpHrjSgFzXHl+naKODF1454dBvViJhv
73vVPFDAmRM/8q99bUSTvBK+RLQq4FW53ffo2TcR3t6ex8cSHg+8HXg88C7g
YcC7gIdBXYM6B3UN6hzUNahzcE/h3sI9hXsL9xTuLdxTuLdwT+HeOt1z9hMn
tJFzuqfQdFRdKzl1dvsWrVKjztZVBqdOohZyJk+NGf7UupmcwXpLk3Ncmsip
eKWnxvlWJm6qvKSSv64NpeFv0VfsmPj0KFXratyKrud6rr2RyMB99l68w1Jq
QRuOLhDfQwz8JFq5tmtpE0rmKdl47WBj2z2CA5c+taEjI3dNfLhXDkenfB0T
n9KEBgvVXzpnsXGx8aHu3bnNyNav/xRBBgdb2VzQNGK2omsjh3+8lMrFKafv
DlnS3Ia6vZidd1nEw16LFxkqfWlCyKLo+wFnHi51dR2WHdCM1pUdyLTJ4eFJ
YWEDbu5qQV4uqmlTZ/Cxd/EvrY1zWtFLjUffhj7l40pVdTWj/m2o9Il5Qpc+
AjzVfGb3Nun7mxxedmMWEuD4S5me+v5NqOBl6ur8UwKs1DOlq+XEZuTatrDP
riwBtjwbf/rYj2Y0ZFziD0VdeXxN9FEUsr8Ffdo5x++GdL4udIlxzdZoRY5P
Py0f+1EeD2W94gpftKJutebq8b2EePPeiEOGy9tQqMG79DXrhfhpQyhjVUsb
eqJoNmb0HiH2WqftHX6iCV0c/2V54UchXvx2eI6SbjPatX7RQc/eItxL22Tg
Ful9sLz0PcBkowh/3zNv05dNLQjFrn1X8UKE/VOtnwzp2oo0a8tLfBXFeM3I
La3HHrUiZt8dijOtxHjQ2cOm+fPbUHbaysrMajGOevwyL7yoCWWJBzAM7SQ4
Um02Y318M8rEZeJTmRIcdiBLrVd4C8pwClUrmKOAnxSuN4rzbyX7v+3n3Ddk
zoW5FuZcmFNgbgFeCjwVeCnwVOABwAuABwAvAB4AvAB4APAC4AHAC6CuQ52H
ug51Huo61Hmo61Dnoa5DnYe8gDyBvIA8gbyAPIG8gDzRf5ikceuqHPY9eeLk
4UUMPCPGzMh1LguHX2u7vlrAxHYZ4TPtWGyc/GRzxKQwJl6rb1kS7sXGk36+
j9nMZuBA619uvEo2Pqy62Pb5CgYu8twxcN4MDn4zvZAtH87Ag2J5sVcCOZi7
b6v/gp5MvK7R07aYxcWTH7AmXnVk4qAhfTmGK7jYJffs95I4Jv61/KH/gTAu
jumhuW/UADlsm9z17YFBPBxsZ6TQfRYDvxmtvn/ATh5WiJvwLuwKA/f16W/8
+R0Pb9CdfsjqNwMfatWv3qrCxx/PLBzHH8/EOSvH3utlx8dDqlbW3TvJxBOi
J6+Nlubf8QX2DxZkMrGfzhztdXwBLn6y1b55iBx+U3De8OEJAd4z36lUYy0D
n19l0zKjVoBnfcEh4V8ZeF3W8NdFK+Sx9nTJLosxTDx2CeP4kXfyuDomfULV
den3k1DdGtQgwqd6ufSpOc7EClx5l0UhCthv0DyVPS3S533Nn50lVsC6MSVe
chZMPAiNO2i9RnrfrY92PxbMILpLex0mmugwoLuADgNzNszdMEfBXAVzFMxV
MEfBXAW8FHgq8FLgqcBLgacCLwWeCrwUeCrwDOAdwDOAdwDPAN4BPAN4B/AM
4B1Qt6GOQ92GOg73Fu4x3Fu4x3Bv4R5/ejbm3SZ3OXJuun89wusXdXYNEAdH
mLDIGXJpm3+ON3UuPJPtxa+mzvojZm6609nkXCr/ePb4a2z8Lt/+ucpi6e//
scJ/Qg0bJwYGdlG/I/2cM7p1k8w4OMs+f7VmmxzeNc9+mpk3Bxfpaj/tI/19
j/QMvGz+m4OrKpYL+wew8JnUvPKZE7i4NcR7+aB6Fr7kozVprgcX87enPBhq
zsYz9asnvzHi4UE/rbR3B8jh4QJ3e/1YHpZEMab8HMnCPX/on7m8SNpvzvva
z3/Lwkc1OA8GJwrwlwcDGyPr5bD2maPJdlvFOK3F6lTybDY29PrulqYkxr9Z
ERPMqlh4qo/xePMwEWbK96x56snCltc8KsKXiXAPxU2BA0exsGPg7+tD2oR4
YM/3Sy+lyeHQLL/YSxUKOLW/QWnuITb2450cPuqeAo6erWFxALOxm94On6R1
CvjuDuHL3i0svGWxDdepvwI+f61uUMQzFl5+cM4mxTwJPvAh12PxNhY2CxqX
dtdPgu2rP7fWDmfh4YkDJ5lbSvAC9Yi1HtL7otbS495PFQnGkwPj9aXfL6ef
nPLRb9L+stFj7Oe1ckSXbK9TviI6JeiSoFOCLgk6JehWoGOBbgQ6EugQoEuA
DgG6BOgQoEuADgG6BOgQoEvAXAdzHsx1MOfBXAdzHsx1MOfBXAdzHsx1MOcB
bwceD7wdeDzwduDxwIuAJwEvAp4EvAh4EvQF6BPQF6BPQF+APgF9AfoE9AXo
E9AXoE9AX4A+AXkGeQd5BnkHeQZ5B3kGeQd5BnkHeQZ5B3kGeedx8mWgWwib
nLX9fc/lLOWQc9Gr3buNpb83nDzVzRVmHny8tWbAir7mXPybeUMn8QYPL8tc
5n7fUvr9HToa6SblXyHG1RcmpHHxiSP9v75UF+K1Yz3vbD/OxdglNq/+kzzu
Nd4w6v5YLq46Zlc/bL88/oySEwpKOfimm7xojb48PjRhe6G6LwcvORGkcSVH
gA1NVJrmz+ZgyanpBknu0v42KUxygsnBg1WLC/vdEeOtdyT6z75wccPobudz
bcTYJM7o+1Y36fe7eOxkPw0x7lKy8vTwSVzsucOmZlmqCGcL3caXtXCw9cVT
11XcRfju4EelQU84WP/Zk3nfpovwLvMMn7WOHNyW8l3OnSvCU+0503UGc/Cn
esHDWVFCrHxct+lHHhv7KBtYiXYKccFti9tXpPfxSs/5M40bFfC8w8M4gUlc
XF53OeiAkwIOsNmxqmwmF09MLeS/K5Hg+snRLwxjOdg9TN9W0VaCpw0Qq++d
wMH53ruiLbLF+LLAYucb6X0FH6G9rxBFfAXwEcBXAB8BfAXQgUEXBh0YdGHQ
CUE3BJ0QdEPQCUE3BJ0QdEPQCUE3BJ0QdEPQXUCHAd0FdBjQXUCHAd0FdBjQ
XUCHgTkF5haYU2BugTkF5haYU2BugTkF5haYU2BuAV4GPA14GfA04GXA04CX
AU8DXgY8DXgZ8DTgZcDToM9B34M+B30P+hz0Pcg7yEPIO8jDT6j35VqWgJys
U3vv6Ek/F85RGVnh69ZT54ZB6MN1Ter03+6blpXII2fq27YiZVfqVOixsmHu
OOr8tDSqp85MIR5r5HyYwRHgBJeIWxNZQjzB2kmpdxgfpzx6OnblU3k8+fTG
22Ok9zMzO+TzHgd5bB5uP25xXz7+IXywyltbHs8qXPNlWyoPFxjdrXmaLMDz
u6229jjFw8XWt459k/LXRWhl7QMTHi47HaBWPUE6L9ovc/1cz8X+ithYYbUY
74u52+PtVz5WfBYnYa4R4ZKNxsVPpL//tuuKzYqx0nnMcKSpfwkXP69tvsce
LcE8V616L0se5k4tsqq/JcGz0sVBbp94eKZ3UvcSVWn/HtpouRfxsVfpy5js
4wo4a1+B4uZgPs5C93YmNCtgnfj4aBstyqdr79u9IL4d+HTg25H/T9J/fTvw
YcCXAR8GfBnwYcCXAd0ddHjQ3UGHB90ddHjQ3UGHB90ddHjQ3UGHB10TdE7Q
NUHnBF0TdE7QwUAXAx0MdDHQwUAXAx0AdAHQAUAXAB0AdAHQAUAXAB0AdAHQ
AUAXAB0AdAHQAUAXgDkI5iKYg2AugjkI5iKYg2AuAp4JvBP6HPQ96HPQ96DP
Qd+DPgd9D/oc9D3oc9D3oM9B34M8g7yDPIO8gzyDvIM8g7yDPIO8gzyDvIM8
g7yDPIO8a44NPG5kLSSnfgvXQKNGQE6vQV1HnfAQYjb3XcAacwFWrPd+fKtc
iPcmzO1zRHrf3N7oGMRI+2u9X4bfNel9ZLvfD84LFOHNG2x7R0m/730rR+vK
ccS4dEy5d2a4PG4YGh2kYSXGawQ7VZqUhLji4RjdcR/E+KPdLUH1KAHmW6ji
YwIJzhMfU0POAqzRVD8nYYoENz2wHer2WMobfJOtex+V4K4LTVFSlQDPMAnd
avdaggc29pmjOVwery70cAmRU8D4ipy1/SZ5vOu408U2rIAXTvyxJfSePD43
bG7QtH0K2KHgxVFmqTy+laAX6RmpgA+5XbkwfTDls7f33Z8T3x18dvDdwWcH
3x18VfBZwVcFnxV8VfBZwVcFnxV8VfBZwTcDHw18M/DRwDcDHw18M/DRwDcD
Hw18M/DRwMcAXwN0bdC5QdcGnRt0bdC5QdcGnRt0bdC5QdcGnRt0O9DxQLcD
HQ90O9DxQLcDHQ90O9DxQLcDHQ90O9DxQOcA3QPmSJgrYY6EuRLmSJgrYY6E
uRLmSJgrgacCbwWeCrwVeCrwVuCpwFuBpwJvBZ4KvBV4KvBW4KnAW4GnAm+F
vgl9FPom9FHIY8hryGPIa8hjyGvIY8hryGPIa8hjyOsIt3MHj24UktNaeZlz
8D3qlL+hsz6tlDqDDcpWsoeKyGnx8ukC3fXU2TLz4LRFQdR5PcMcHSymzmnr
eoy4M1BMzoq6rAHf1lLn6ncOhxZFi3H89b4VBtLv50mBjY+3swT3fdVL3llX
hIXs5Y+zBitg5+zufcJyRHi51sJPWt8V8Ltm0dgWL2o/tP0eTQTZo4G9Gdij
gb0Z2KOBvQjYk4C9CNiTgL0I2JOAvQjYk4C9CNiTgL0I2JMA3xt8cPC9wQcH
3xt8cPC9wQcH3xt8cPAxwdcEHxN8TfClwKcCXwp8KvClwKcCXwp8KvClwKcC
Xwp8KvClwKcCXwp8KtDhQZcHHR50edDhQZcHHR50edA5QfcEnRN0T9A5QfcE
nQh0I9CJQDcCnQh0I9CJQDcCnQh0I9CJQDcCnQh0I9CJQDcCnQh0I5hDYS6F
ORTmUphDYS6FORTmUphDYS4FHg28Gng08Grg0cCrgUcDrwYeDbwaeDTwaujr
0Oehr0Ofh74OfR76OvR56OvQ56GvQ5+Hvg59Hvo69Hno69DnoQ5AXYA6AHUB
6gDUBagDUBdOL5m7824cdfKONs9RdKbOfQ9uDHTSos7ajNnMb9J7D+cGflPK
qG3UmW8QEOytSZ3/A9oOR+w=
       "], {{
         {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
          GraphicsGroupBox[{
            PolygonBox[{{786, 793, 192}, {793, 1534, 192}, {689, 1378, 171}, {
             926, 1594, 221}, {388, 390, 88}, {629, 1320, 157}, {420, 1127, 
             100}, {1563, 890, 215}, {688, 693, 171}, {854, 1523, 206}, {1228,
              524, 115}, {519, 523, 128}, {1103, 388, 88}, {692, 629, 157}, {
             1225, 522, 114}, {633, 1383, 157}, {522, 471, 114}, {1221, 519, 
             128}, {1262, 565, 142}, {860, 1599, 206}, {859, 789, 192}, {1361,
              673, 165}, {1138, 425, 88}, {726, 1408, 178}, {1135, 423, 87}, {
             1098, 384, 87}, {1383, 692, 157}, {1418, 729, 164}, {1127, 417, 
             100}, {353, 1067, 75}, {387, 1098, 87}, {670, 1352, 164}, {1132, 
             422, 101}, {422, 424, 101}, {1326, 630, 143}, {1378, 688, 171}, {
             1067, 349, 75}, {1523, 851, 206}, {475, 1228, 115}, {567, 1262, 
             142}, {729, 670, 164}, {756, 1437, 186}, {828, 756, 186}, {851, 
             860, 206}, {789, 1463, 192}, {391, 353, 75}, {760, 1504, 186}, {
             792, 726, 178}, {1473, 792, 178}, {471, 1171, 114}, {423, 387, 
             87}, {1180, 472, 101}, {730, 1473, 178}, {390, 1138, 88}, {1408, 
             723, 178}, {1504, 828, 186}, {693, 1440, 171}, {1463, 786, 
             192}, {723, 730, 178}, {890, 897, 215}, {523, 1269, 128}, {891, 
             1563, 215}, {424, 1180, 101}, {572, 1326, 143}, {520, 1221, 
             128}, {1171, 469, 114}, {1352, 665, 164}, {1534, 859, 192}},
             VertexColors->None], 
            PolygonBox[{{472, 1177, 100, 101}, {731, 1418, 164, 165}, {630, 
             1323, 142, 143}, {1599, 932, 221, 206}, {417, 1132, 101, 100}, {
             1177, 475, 115, 100}, {425, 1135, 87, 88}, {1320, 567, 142, 
             157}, {1175, 420, 100, 115}, {1323, 633, 157, 142}, {1269, 572, 
             143, 128}, {1267, 520, 128, 143}, {565, 1267, 143, 142}, {469, 
             1175, 115, 114}, {1594, 854, 206, 221}, {665, 1361, 165, 164}, {
             384, 1103, 88, 87}, {1437, 689, 171, 186}, {1440, 760, 186, 
             171}, {524, 1225, 114, 115}},
             VertexColors->None]}]}, 
         {RGBColor[
          0.35410800711502305`, 0.1629314095859956, 0.6147219580949284], 
          EdgeForm[None], 
          GraphicsGroupBox[{
            PolygonBox[{{428, 1186, 102}, {1443, 758, 172}, {799, 1540, 
             193}, {1272, 570, 129}, {527, 1272, 129}, {1479, 794, 179}, {
             1497, 823, 200}, {1061, 344, 74}, {1092, 378, 86}, {606, 1294, 
             150}, {866, 1605, 207}, {697, 1443, 172}, {737, 1479, 179}, {
             1605, 927, 207}, {824, 1497, 200}, {1144, 430, 89}, {1294, 600, 
             150}, {832, 1570, 201}, {382, 1092, 86}, {1186, 478, 102}, {1314,
              623, 156}, {394, 1144, 89}, {1585, 916, 220}, {1540, 861, 
             193}, {348, 1061, 74}, {1570, 895, 201}, {920, 1585, 220}, {466, 
             1165, 113}, {625, 1314, 156}, {1165, 463, 113}},
             VertexColors->None], 
            PolygonBox[{{1099, 385, 384, 1098}, {1524, 852, 851, 1523}, {761, 
             1505, 1504, 760}, {1128, 418, 417, 1127}, {523, 519, 113, 129}, {
             1441, 761, 760, 1440}, {1321, 568, 567, 1320}, {387, 423, 102, 
             86}, {1104, 389, 388, 1103}, {1107, 394, 89, 74}, {566, 1268, 
             1267, 565}, {855, 1524, 1523, 854}, {671, 1353, 1352, 670}, {
             1464, 787, 786, 1463}, {1327, 631, 630, 1326}, {473, 1178, 1177, 
             472}, {1176, 421, 420, 1175}, {568, 1263, 1262, 567}, {693, 688, 
             156, 172}, {521, 1222, 1221, 520}, {790, 1464, 1463, 789}, {1324,
              634, 633, 1323}, {476, 1229, 1228, 475}, {1438, 690, 689, 
             1437}, {385, 1104, 1103, 384}, {426, 1136, 1135, 425}, {471, 522,
              129, 113}, {525, 1226, 1225, 524}, {892, 1564, 1563, 891}, {
             1353, 666, 665, 1352}, {421, 1128, 1127, 420}, {666, 1362, 1361, 
             665}, {727, 1409, 1408, 726}, {1268, 521, 520, 1267}, {732, 1419,
              1418, 731}, {1106, 348, 74, 89}, {1229, 525, 524, 1228}, {424, 
             422, 86, 102}, {1263, 566, 565, 1262}, {823, 1503, 201, 200}, {
             1181, 473, 472, 1180}, {629, 692, 172, 156}, {634, 1384, 1383, 
             633}, {895, 1568, 200, 201}, {1409, 724, 723, 1408}, {1139, 426, 
             425, 1138}, {573, 1327, 1326, 572}, {757, 1438, 1437, 756}, {
             1270, 573, 572, 1269}, {1172, 470, 469, 1171}, {631, 1324, 1323, 
             630}, {1595, 855, 854, 1594}, {418, 1133, 1132, 417}, {1178, 476,
              475, 1177}, {1068, 350, 349, 1067}, {690, 1379, 1378, 689}, {
             470, 1176, 1175, 469}, {1600, 933, 932, 1599}},
             VertexColors->None], 
            PolygonBox[{{1136, 428, 102, 423, 1135}, {1384, 697, 172, 692, 
             1383}, {378, 1099, 1098, 387, 86}, {478, 1181, 1180, 424, 102}, {
             570, 1270, 1269, 523, 129}, {1416, 671, 670, 729, 179}, {852, 
             1532, 207, 860, 851}, {787, 1471, 193, 793, 786}, {724, 1416, 
             179, 730, 723}, {1535, 866, 207, 859, 1534}, {1362, 606, 150, 
             673, 1361}, {1474, 799, 193, 792, 1473}, {1505, 832, 201, 828, 
             1504}, {623, 1321, 1320, 629, 156}, {1564, 824, 200, 890, 
             1563}, {1226, 527, 129, 522, 1225}, {861, 1535, 1534, 793, 
             193}, {1471, 727, 726, 792, 193}, {794, 1474, 1473, 730, 179}, {
             392, 1107, 74, 353, 391}, {1532, 790, 789, 859, 207}, {1133, 382,
              86, 422, 1132}, {1503, 757, 756, 828, 201}, {389, 1106, 89, 390,
              388}, {758, 1441, 1440, 693, 172}, {463, 1172, 1171, 471, 
             113}, {1419, 737, 179, 729, 1418}, {1568, 898, 897, 890, 200}, {
             430, 1139, 1138, 390, 89}, {1379, 625, 156, 688, 1378}, {1222, 
             466, 113, 519, 1221}, {344, 1068, 1067, 353, 74}, {927, 1600, 
             1599, 860, 207}, {916, 1595, 1594, 926, 220}},
             VertexColors->None]}]}, 
         {RGBColor[
          0.43500625766084766`, 0.3035916194989803, 0.72843423574193], 
          EdgeForm[None], 
          GraphicsGroupBox[{
            PolygonBox[{{415, 1122, 99}, {348, 1106, 73}, {1216, 514, 127}, {
             1106, 389, 73}, {1176, 470, 99}, {1431, 750, 185}, {1268, 566, 
             127}, {757, 1503, 185}, {421, 1176, 99}, {521, 1268, 127}, {751, 
             1431, 185}, {1122, 412, 99}, {343, 1055, 73}, {516, 1216, 127}, {
             1503, 823, 185}, {1055, 338, 73}},
             VertexColors->None], PolygonBox[CompressedData["
1:eJwtlMlvj1EUhr/f7/u+7qiEkBiiKiSEGFatKSRIDAuKaBdI6IIFakhQQw0b
FCtNDKHUsDAmbNSGkKgQQwxBYwj/AAtzCM+T8y3e3Dd3OPfec973DFm+tm5N
OUmSRpCBtjRJJlUkyURwGN6eJ8l1NlwDJ+GVoAFeD3rCt3DoailJroDN8B/M
dzB/GnyHDyXOTuK0gGr4J+anwaeCj/DtjIOYHwi2wReBv8z/AQvT2GsMz3rm
KBgPHweOwE9yZzd3vwEn4De58yxnz4BO+DT2nWffOe+Ev2ZuN2u7wCv4AObv
wu+A/vDjxHhHrLfgGHwB88vYtxTU5fHWWvbVpPHm23nENNYteCNYD18HVuSR
y3r2Lk4jpw+J2Yu1SvAgi7+Yc3Ptn34wN4W1yeA7/Az4wFvegw74bGIeZ+0Y
mAV/zvwh5g+CZ/BveeTQ3H3NI9ZYxjF5xPxdjhqY+1/wX5ybyDgB/IRvZhzN
2iiwCT6SsZaxBoyAf2K8z9hljHK8xRyZG990Ko2cm+v2NP7um3yLOXjMHT3Z
1wM8gu9j/hS8HezNQytDOFtVEZqxVi9Ze1GOmq3Ko8bWdmVx1pyYC2O8Awfg
reAt/Ck5aeOew+AJfCkxE2L/Y31JobV+jH3T0NwKxpmszwDL0/j7F85+ziIH
nezpw3xvcCOPWJ5xrzHzirjD2Bl8lTW0dmAlfA1oge8Aq+EXGdcxNoELpfCO
NbI2ekhvbWRtQxYeu1wKTaiFS6XQkjW0dpXF362RtTEHTUUNrd1a+Az2beVc
M5gOnwt2w3eBOdaDcaG6B3tL4S09oRf0WAMYDR8F6gvtmWNzqwb1ij3C3qBn
WkvRI+wN+0uhZT2rV9W0XrVn2Cv0rLGXWadS3DE8izu9a1gWvUiP6S17krk1
p+bSHOtdNaa29LDaV9NqWQ+oXT2v19WwXu5mfJOHp62NOTI31sha63G9bc3N
1XzW5mWRM7Wi5tW6mjG35tRcNhe5NAf+3ZyqZTWv1tX00KJG1qY6D+9thTeX
w4P2pipiD06jR+mNPb4jDY+oHTWhFtTQxkJTaknNrC/uMLY9Se/Zg+w9elDt
q2m1rAe8W4/pLd9gb7An2YvsEV1Z9Bx7zb0s3qbm1bpv/A/Wlsx/
             "],
             VertexColors->None], 
            PolygonBox[{{514, 1223, 1222, 521, 127}, {1264, 516, 127, 566, 
             1263}, {1498, 751, 185, 823, 1497}, {412, 1129, 1128, 421, 99}, {
             1105, 343, 73, 389, 1104}, {750, 1439, 1438, 757, 185}, {1173, 
             415, 99, 470, 1172}, {338, 1062, 1061, 348, 73}},
             VertexColors->None]}]}, 
         {RGBColor[0.5159045082066722, 0.444251829411965, 0.8421465133889318],
           EdgeForm[None], 
          GraphicsGroupBox[{
            PolygonBox[{{1278, 575, 130}, {1401, 713, 177}, {766, 1510, 
             187}, {728, 1472, 177}, {429, 1137, 103}, {528, 1227, 130}, {
             1194, 486, 103}, {660, 1345, 163}, {1372, 681, 170}, {1417, 725, 
             163}, {1049, 331, 72}, {1235, 529, 116}, {1533, 853, 191}, {780, 
             1456, 191}, {1227, 526, 130}, {762, 1442, 187}, {1325, 632, 
             158}, {1179, 474, 116}, {635, 1325, 158}, {1510, 829, 187}, {574,
              1271, 144}, {899, 1569, 216}, {1257, 559, 141}, {718, 1401, 
             177}, {1137, 427, 103}, {672, 1417, 163}, {533, 1278, 130}, {
             1271, 571, 144}, {343, 1105, 72}, {683, 1372, 170}, {1322, 624, 
             141}, {1439, 750, 170}, {1389, 694, 158}, {561, 1257, 141}, {483,
              1235, 116}, {395, 1108, 90}, {1108, 393, 90}, {376, 1087, 85}, {
             1569, 896, 216}, {383, 1134, 85}, {1472, 788, 177}, {336, 1049, 
             72}, {1134, 419, 85}, {640, 1389, 158}, {477, 1179, 116}, {1087, 
             372, 85}, {569, 1322, 141}, {1333, 636, 144}, {791, 1533, 191}, {
             1456, 775, 191}, {435, 1194, 103}, {579, 1333, 144}, {1345, 654, 
             163}, {1105, 386, 72}, {1442, 759, 187}, {691, 1439, 170}},
             VertexColors->None], 
            PolygonBox[{{465, 1174, 1173, 464}, {1537, 868, 867, 1536}, {834, 
             1572, 1571, 833}, {868, 1