(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    499374,       8689]
NotebookOptionsPosition[    494962,       8545]
NotebookOutlinePosition[    496383,       8585]
CellTagsIndexPosition[    496296,       8580]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Density and Contour Plots" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DensityAndContourPlots"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Density and Contour Plots\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MeshStyle" :> Documentation`HelpLookup["paclet:ref/MeshStyle"],
           "PlotStyle" :> Documentation`HelpLookup["paclet:ref/PlotStyle"], 
          "ContourLabels" :> 
          Documentation`HelpLookup["paclet:ref/ContourLabels"], "Contours" :> 
          Documentation`HelpLookup["paclet:ref/Contours"], "ContourShading" :> 
          Documentation`HelpLookup["paclet:ref/ContourShading"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MeshStyle\"\>", 
       2->"\<\"PlotStyle\"\>", 3->"\<\"ContourLabels\"\>", 
       4->"\<\"Contours\"\>", 
       5->"\<\"ContourShading\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Plotting Options" :> 
          Documentation`HelpLookup["paclet:guide/PlottingOptions"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Plotting Options\"\>", 
       2->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ContourStyle", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ContourStyle",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ContourStyle"]], "InlineFormula"],
     "\[LineSeparator]is an option for contour plots that specifies the style \
in which contour lines or surfaces should be drawn. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18684]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ContourStyle", "->", 
   StyleBox["g", "TI"]}]], "InlineFormula"],
 " specifies that a graphics directive ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " should be used to draw all contour lines or surfaces."
}], "Notes",
 CellID->2425],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ContourStyle", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["g", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["g", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " specifies that successive directives ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["g", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " should be used to draw successive contours."
}], "Notes",
 CellID->29358],

Cell[TextData[{
 "If equations are given as input to ",
 Cell[BoxData[
  ButtonBox["ContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["ContourPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot3D"]], "InlineFormula"],
 ", the successive directives in ",
 Cell[BoxData[
  RowBox[{"ContourStyle", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["g", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["g", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " are used cyclically to draw contours for the successive equations."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->11478],

Cell["The directives that can be given include:", "Notes",
 CellID->31844],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Dashing",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dashing"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["w", "TI"], 
        StyleBox["1", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[
    "dashing specification ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["Directive",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Directive"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[
    "composite graphics directive", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["GrayLevel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GrayLevel"], "[", 
     StyleBox["i", "TI"], "]"}], Cell["intensity", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Hue",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hue"], "[", 
     StyleBox["h", "TI"], "]"}], Cell["hue ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["Opacity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Opacity"], "[", 
     StyleBox["a", "TI"], "]"}], Cell["opacity ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Red",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Red"], Cell[",", "TableText"], " ", 
     ButtonBox["Blue",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Blue"], Cell[", etc.", "TableText"]}], Cell[
    "named colors", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["RGBColor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RGBColor"], "[", 
     RowBox[{
      StyleBox["r", "TI"], ",", 
      StyleBox["g", "TI"], ",", 
      StyleBox["b", "TI"]}], "]"}], Cell["RGB color ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Thickness",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Thickness"], "[", 
     StyleBox["w", "TI"], "]"}], Cell["line thickness ", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->30921],

Cell[TextData[{
 "For individual ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["g", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", a list of directives is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Directive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Directive"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 ". For a single ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ", a list of directives must be given as ",
 Cell[BoxData[
  RowBox[{"{", 
   StyleBox["list", "TI"], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->26962],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ContourStyle", "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 " specifies that no explicit contour lines or surfaces should be drawn. \
Contour shading and meshes are not affected."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->19169]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->68702111],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(5)", "ExampleCount"]
}], "ExampleSection",
 CellID->354534105],

Cell["Contour lines are partially transparent by default:", "ExampleText",
 CellID->729432489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->985380230],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyUvQd4VcXzP3xzS24EaaGIUgVEQHovwh5BBJSOiBpEpKgoiAUQBKUoItKU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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgmUVdWVhm/dquJRQj2sevWoKqhXgr0aTEeM2tqmoaWj4hAnJimgjMyi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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllllslFUUx2/X6TZdvs5MO22/EXgQFNRETYygQNhFQEFRwASEiiayo2yF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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.3835503214670458, 0.21412364290547561`, 0.656106692642075], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgmUlMW1xz9kpmFmeobpmenpnunucTnHuEBeEp+JUZ+iJhFUhhglgppN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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwlmHl01NUVxx+QPZMEJjOZTGYmgJ6jKNgqxxWKWBd2basoi2vZPBZE1BYF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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4736855602511393, 0.37084448077756177`, 0.782802674684231], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHmQ1MUVx38I7M7MzgIZZnaO37hqUINXSlRAxChWEhAkWIokhogCyyVy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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHmUVNURxt8A0zM9NIvN6+nuecMY0SREIxERkUWEkxP2YNgSRZFl2Bw2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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5638207990352326, 0.5275653186496478, 0.909498656726387], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtl32QVWUdxx9edu9d7t3Cy733nHvPygzOVGADRBsKO2BvE2DmGGSQUsCu
4eBCQQgRpqz40jhhmYwuu4glI/YiUi0NlCwKNSIvolObsxJRviJa/ZFQWEFN
ny/f549nznN+5/f83p/v73fGdCyf89WhIYQZQ0IYxnNZPYSLqiH050K4qhjC
Z1gjG0N4pimESTy/3RDCZSNC+HM+hDG8z+f7F1kroP8gCaGrDD+8m5HTyzpU
8NmOos/PSEOYUArheWjfZDWznuJsdxbClej9N3rv55lH1gls6oF+BzJ/Dc+0
99qm1dDHwXc18nZi8wt502WnbC9F+zuRsRxdz+b8nJx6v4n9oVoIFeQs4Uxn
o3UdRM+UzD73YddsnjW+tSNnEWsQPa9CX9xom1/Gv/Homj8cI5A7mLM9T0Ab
MyqE6fBPYP9fZB7nW8todLP/IXLvgd5cIXbIasWuF8uO5yjOLMvbtg/Bcwod
Jzi7Fv3fYP2Vb+fy1vcTbOhH1mvYtIazbdDvYU3k7ES+z2+y/KE5698f7IPy
J12LkV/Enh3Qf9USwvnUsViPzltYfeTuenTe1+I4dGY+I/4LNkY7Z6Pnmkbn
4wzfVyr+0Idw9lvsj7Ifj393IHM3Muex74T+MPY/CK2b9WzBudHztgbHqTfG
6iz0wzw3IP/jnHsS+hloV2DvEc5ugP9d8vlQyb6fhv6P1HlSPKbHmHwOvfvg
39Tg+mvjezf7LeSln1zkRrpGD2LDOtkAb0/d74+jdztrGrKqPG+HPoW8P8Fz
B2sQnm3QH2NNgacXmX3IHIbM89C+QyxuyTsfCxodk2PY+IfUtTwW225Dzi8K
9rkt2nwkZ9m6dzlqakHVNTKa/Y+q5pMfLxUch+1NjvENDbajjf15LvZPkf2z
uvk+gs6ddfv4GDGbW/WdUm3NbHR8lHvZIh+3YvsjrIuQvRL+j6a2a5zua+a6
7+K5jvWAbCcX3fDn4K/Af0lqu/4O/zXsH0X+S/COrbhu34K2G75rqcsm4jYj
M67sbnDtqm53QbsU/qehDyDrxmbiDf1YwbbId9Xjp/n2CWQeQf9zid9nENtn
EsdwUDXAvg36WvQNICcMNZ6JptrbQ733t/jbXJ7zWEvYHx1hDFKsLkVOpWrc
O8D+0ZrxZwuyj482rgnzVDuqqefwcVXi/Ts8V1eMf8K770b80T37Teq7thnZ
WcX4dDmyB4jPfehvFzaOsq/Cp20F87/Dc7DJWDQHew4lru1LOJfHntXB90eY
odor14zXwuoe9JzKHGt9DxHHTsdY656+jfzf5lwbgxH75fsj8AyJmNiO/R2s
lcTqP9DfaDJutzYZoxWfvboT8DTDM7TJd0I234stS0Z5vxabZ6XWd67q+yO+
+7FxI2srsq9kPR9lPin7U2Pe48j+Y2o8KjZbj2Ko2CiHwi7lRpgqDBdmiVd4
tY47MTxzrNYTn6eR82FiflPVuHaBp2pcUwyFnVNLlinskL4X2L9P51LX0qSq
cfxEzLNqWrm+jLOTM/vxO+RtbzGO6s4oD+Jbxblz5djn8PEs/MObjSnDYv0r
xiujXtH0XfUvTJE8nX2Vc90V5/MN9idZ/2T/Os9NFedb+e+tWPdf2G+uOId/
Stwb1BeEwxsidqkHSYbOqi71rm/z1Cex+7q84yqcVtzUz3uq9r2V2N7K+93x
+90x/sIyYZ9q5kb87qq6HtWXLq7YBvXtnpL7jrB/Ztl3/82K+4pq9Tpk701d
cy9Dr8J/b849rSv2teXInpS4zvWcVvL+X8g4WDcOfi1zv5GNqjXVseptI/wr
yq7fnfAcY+0p2g/pv+BLwfgi7N2PLftYrbyfLhhndY+EZXuLxsBp2Dml5hrR
nRRduNSXWYfkD2DXorLvur4/FXnU//dEOTrbH/fjsXNyyXUi3aplYZd8O5s3
DgsnZpeNFa9jw0T4v6fawd5X6r436qvZaPejXmy8mXt6Ell3cvauxLLk06wR
lj2WmC0sW75w91PliL3QX4y1oflMPUF9Ki07Z8rXA7Hfq0eOgz4QMfZqdM5N
3I++khhPhaVb+X645DjIv6PRR82Dkqe9+opmIeFDKz5OqDlXn02db9m8Hv6u
om2WP+vjvhv5lye+X8WC6+g1DcrYc3vN+xvIz0LWmjij6C6obmfC01WzTeqd
qm/VtjBGuCyckc2SKzmaSZYW3c/VQx5KjFWKtWpJPh5PjRe629enzpNydFiz
dt04rd4gW3RHzuBfR2ZMkB+zSvZlM3a9W3F93omPrYn7rGrqZNS1Wn6ntufH
F4fwAWS98h7zfrJk/puQvTRz7JT/s3GGWFh1/an21B+E2eoR14Iln29x/xZO
/69snFB+jjQ778L9UwXXpPTpvipWBzQn1v1N/Uc9WxirOyPcFGZqzp0YZwbV
oGYO5VE0zV6iL0ZGrezau5XnF1L3As1EU8uei9R7N1XdO5bix7LE+jTrjIv9
UX13W5y1fkk8drXYh5sTz0maS36PzPay7/2bmWcmyXg787+B7BWuaQ4QNu6A
ti31zNrJ2aV161BdaHZTLubE/xPpV39YUY043+R+vDjOmLpHwmr9Z9xVtf/6
xzqQWZ/uQWu8C5rX3socR+VC58V/BbTpmXVeqKm8a+n72PilOItWNHvXXKO6
B+3xLuifZkHiXP2tYkzXvejDp5/XPbtpTn84sc37OLc/86z/9cRzgGpB/5ea
OYQDwgPNXtoLA0fGf59D8f9BuVvF941V18MH2X8ZWcc4vyjzv5/uhbB2asRb
1fiaxLHdVfFcrhwLp3ROmNMB7WMlx3g6+/eX/F97umJ90rWl5P8Q4eT/AZe+
Jls=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3uQlXMYx3/bYtucJWfP+75n3/cUmUExhJTK5i6hhkJSSbvJdCO3hC4r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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6300910720034462, 0.6340432153367682, 0.9110094978702362], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VmtsFFUUPqEVdllayMzs7DC7y+NHKSYqtgiaiNGArTVWMaBtQahQMLaI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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlslVUQho8W6K2lgL33fvf26y3KDygaEdn/YDSgSCIKQUILIkvdKJgC
2ihGFgMohghxgwIhQBOKW6XVGJVFQI0LiiJIjeIWDbibomCioMTn9f1+nOTM
ObOdmXdmTp+6eRMbzg8htLK6sH7PhrA2F0K3khA2FYdQSIfQVhnCzu4hDE+F
sDgOoX8mhHldQ6iFruX+ec46SkMYh4IZyGaiEPYj28H9CfQdZ/1cFMJ47ifB
/xT8b8M/BrqN/Q7WY9g+xFkJ97ci/3oXy7Sw38b6jPvPObsU20ega1LW/wKy
rbF17cLnp7nrjY5/kb2Ls1+wvRKfzsDbhE/vyHZsX9+C/xr0jcx7rzc8i/xF
ify38FSyH458G/JDWcPKQxgAvZ39k+hbAP1yVQidPfyGSdxl0TkriU89tmaz
BqKrGf1r2E9A51XQb0APIbbn0FEC71hifDf2T7Huge7NWoNvq/OOXTl0P3T3
g27D33bkq6GfqXK8lZNe6D6CDxNLLD8dXcWc/ZTEvwG6B/RvRY7xfeiajv2p
+L4KHa+hayfrO3Rv5iwF76zIssrHh/h/mHWS+23Y28P9qayx0oq997g7EFte
MT6Kf0OwsRt/pvK+0dgakjOvZGq4/z7rWHZyNhlbLfAMusAxUWz6wr8lZfoA
dHNkLC6EZwp3eXTU4UvPbs6VMKt75ayCu9tjx76F9YrenjUWnuN+LndzWHcG
87SzfzE2FoWpv5CfgP8d+L8E/yej/4a0c3uQNQJ6Hf4MYt/OGinfc9YtGyXs
T2Pvb2K3IuW7efBXpcwjLM2AzqSMqbHl1ildW5FvgG4lHyfA17JgrF5fIGdl
xuzDyJ4H/2L4+7Oq8G17ZOwLwwsiv1m2ZDMbuYZUO8JMhP5v8G9rF2NgH/r3
5x1rnWXgvS2J3xf4UID/k8jvb8f+XPYz0sZrJetB6Pq0/emrGoGeD72c/UDW
FvWHCufuXvI1DP2r0L+v1G8cBd2cxF811YR8Jf7VlTjGZeg6zVljyhienjPG
hK2jnM1Uf0D+/pTxuZn7JZzt7Wp7MfKbIte2cvIVvF+zjqG/jrP53J3NuH4U
rynEopZ415eZ5wrlOrI+8e9F9kb4j5ca86ux9w/3O7g/h/xDkWtEeK9mnVS8
4P+T/XzWYPT3TepZNaK3boRncMpvVq9YGLvW1TPG561DssJkP/JxZd69T/go
sK/OOzfqB8cU77RtT+NsFG+pRKYx2KZ6Rc+036o3X4vsgHLXvmxswPbGJD+y
/27smlAt/MjZhcJa7NpSj2vk7o+kH2iGaJZUpJ170e30u84K50IzZVFsn+Xr
S+j4VL0959pSD12aMWbEr5jX4P/kgnPbUWzsDM+4l8rHy/F9TNLP1Y+nIXtL
zvNCb96Td89Qr1CPUa4bI/dKvX818mvz7vWaOWW85ZHItaX4ZdOOqfY6uxr+
uryxsTsYu6PRebjUGC6PHCPFRj1qXMEzQ76phruhqyGdYKmre92XWfdi9bwU
9OOR46ca6sW+rtz9SvHRrH0gduxUz2egP4LuLHUNzEb3ozljUbSweTayr8Lo
2IJ7jLBzM/4cjZwD6ZYN9ZYlkWtZNS3bLVXuBbpfh621sbEhPI1L+w+g/qKY
jyAWgxJ8auZ/DG915NxphqhXrEziK/3rI79Zb1UNtMT+M6gXK6bqJRuS+hDP
q2BpaKVnp3L6Zuw/iWaPanI9dFPs9wkfF+NLn7x5lY9lwkfaWFdNqjb7J/6J
roV3EWdF3Z3jJyJjXFhWTsYgezCyLuV4Kfs7Mv5vKGaHYs9M4VU5mRN55nUm
/XJFZIwJT6rR3eRjV8F/Hc0w/XUuybi3KZ6K5XUF50oxXQfdxGouds/fh62b
Mq5N9SPN2uWRdasH9VEvSubDuSL7+msyD+WzcqOY6O2KwQ+xe57wqRgsJ/+X
Jf1NGNoKb3POs0rzZjK+1OSNNfFMKVhGvOqh+oul046N7H0A/X7OfwvNQP19
6iPHRjNlZtozRrR6/v+zJqlX3QsLC9KercLEf1rSf4Y=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6963613290729136, 0.7405210785522395, 0.9125202556162386], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmQmQ1MUVxv/ALjuzww7Dzs49y7JyeSC4nAlhY4lELSGoBFcNAkYNiAGM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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHuU1VUVx08ww8zcYWaY+7v3N/feucPAkocogshLMWqJ+CiEjMcgMRCi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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7626315263956404, 0.8469981755389198, 0.9140307641752249], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgmcFdWVxguk6eW9buAt9V5Vd7NDjMgqIuA4iqLGBUUIUSMa1BnRAQRB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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXeYlNUVxi9ld2dndynzzXw7ZXeRGhWpIoKJUbBEEBRQogmCgBE0gCgI
KKLSFbBhVwRUkCrWiIoUwcRCgppoYqzoo2DjQYwUFcT8Xt/54z5zz3fOPffc
c889bZoPHzvgsvohhCX1QmjIb+tUCCdkQ9hcHsI04AVxCAsZr5WEkIDwA+an
1IRwXlUIFyZCWMP8UUb/0hDOZc05rG/AaA/+sbIQ9mRCqFcIIVcZwv3AR0Uh
nJ8L4Wj4lbJhxF5l6RBurgjhYdZvgf8ttSG82iiEPvCvqQ6hlrEV+jeQ5yR4
72F91wrz+w17z4JHvWQIZ1dZtrnADZOWcWU+hFWMf0F/Gvv1Av8jcIQ8F4AP
7LcPmdrDfyX8fkbew4xyaNvxrTn7dYDfc8g2HvIB7H0O4ytgyMI++HVifUVD
8/iJj2s4z5Hgl8NvP/jDTUPoCC7Pmfqz32B47gNfwvluR5Y7GFuQ77fwOAZd
bYXmfHj3QMZ28B7CfsdI/+CnMz8Onr9D9tc54zjWnglNV3CPwuN2dHcHYyt7
Ffg2B1n2QBOXW4dtoR0Ej7bMy8CPh9eVjO2sXcierdj7r9DvBD4TfCfk2QSP
05HlNMZVrD0Xmguwl1fY/yBnacX9LEr4PK/A62XGPdjDaPZ8BdoGzULYgQ4W
Mg6hn9XwawNuGfopYe29jCTwemQagq4ngf+Z/T/i2xpwC1gzh3lzxg3gz+IM
b7F3A0Z78E2Bm7P3ckYP4L7ItBTe64BPAT4L+BHg9cCt4LWEMz3GWS5tHEJP
8D9mTP8C+ObsvRz9bUd/M9DxqeDPTlnWDeDX1UHH6MTai9HXf9HVGNYcRN4f
GLvhNRIZd8iWOc+bnL9zwbq7EHg9vCegn3eYf88enWttE9LdYOCtnOVJ4JOA
n2JMh9cZke86MBIpvxG9jd7wiJFvGDTb2e9pSDpDO5w76gSuivvLgr8U/E7w
m8E/Cf5LZLyrzPrqUu03qre0BvhdznYi8K3c36ImIYxF1nTKZ+2DPi4Dbpyy
fZ4OnIN3a86/hrMvY49nge9jj1Lg9sh7J7J8A7+9DUL4BPgS9jsW+snId1HC
ujoxZdmks3nQXoROF7P+K3T2ALpLSkbsbSXwdOD6wB8C3w08ErhtyrY7BXgQ
uJbwHw3/QfB/D14N+LYu+I4GpX0H0v1D0MzlvPMYnwK/BZxFnm3odyDzR5Dn
MGcpAV6DfrrzbTby3cGZPuYsO9lvAvgnivc1hzGAvZYxCqx9Dfgl9t8dW74d
7P8u8AjW/JG7+RH4i4xtWHehO2nLeTYgY89Kv//u4FpA/9uiPTzP+rPT5qU3
ex1n78J4m/3myCcjf9eUbUHvZx/8T03Zd8qH660eAi5N+M1OYd6R8Ra0b7H/
5cxbMjbo7QLX4+2GZr6rbrzf99n/g7xtXWcocLax8PwkYXq99fqMz5r6zY9G
nk7QXw791/CsB/33nOcq4FXQDwf+SG8afW7jTodCOyxvW5JPky13BZ5QYZue
xl4rFRPK/YYUa8ZBsyXpmKO9+0F/W4VlyGGvfwK/Fnxr8AfRxyr016rcPqE/
tFXAt0M/n3Eesj3It9eL/k++5BB86qrsI8YrdsSWTTb/A/zOTDkWtEKeMZzl
WHg8k/R5s+x/A/a2GftqBY8xrB0d+6z9eGMvMc+wZgm0J8HjMq1nj3Hw3sW3
+vDeCM0Z6Lcd6yfB76oa6182/Qa4Vqx5rNxvdAT2801s275G9sn6oxivgt+G
/GdB+wP4h0tsM+2gr0jb3mVzMzlIL/S1CPk/A66uto+RPSnGnwVuVOS3/BBj
FvRn5zzfAf3nGdugbO9ZeI5D1itq7EtnMhZytifRx5foY5reU8E+Su//PtZ3
gPewnGOvYvCDBecAst9HJR+4WuRdyfnfZM8+sl94jq34JZSHbuw9j1EC7kVk
OB98knEyez/D+W/MOWdQrqAY8vfYMVdvTTqImO+NvH/7SsfiZvBbWW6f14m1
18Kjb4l5nsH8Dc6crrLOvtDZas1P9NewdoBiPPIdzXnWw+8FBp/DUfCYyKRL
jX3pUvboBu0m8C3BT2LNAc56ccF3eS2jC/Cl1fZV8qGf6z3wrSVrxzB2I/u5
yLQsaZ2MhNclsW1Nd9gOWdcW7Ksm8+1vwB/g/1Y0sc9XrD+n2r5LMf8meM1j
TA6OtzHyZRiHsd8/wH8T+yXAjwXXGXgnZ/me9e/g7xPc8TL4LeOMR4BvC7+T
884RlRtOhf5DcFfFjt/yAX+u8Z3qLiejkw55f9NcOdco5pfk/DamVNl37YN4
YsI+7BL4jSjGX8W8fXnnKIqvTXTH4M5lrEZ37yDD0KxzDtmrYugezvMU/E6G
fjzyVbNf97xjaUv2O455/5R9l3ySfNnxfJtYYZ/2DfBA5FvOWa4A3sv6AzXO
/ZQjHkLXr8J/CPs/0NSyvFvwW5NMg1hfjv10hr4f9NXA7xX8thRD6zPfw5r3
S5xTP1Frny3fqzc1KmcdS7frkWEO8Nyc725UcG7TIu1cUTnOFHDXyJ7BHeD8
XSL7MPku+cwR4C5mcKW/6HwVk0cZRzA/gA20Adc6Z1tSjnkivJ+utTzTS2xb
L2Njvy6zjent9Iz8FvSGhgK3j/zWlePOzDrnUa6jnH61dAHPq0sco+X7XuTb
oUb2gXXQxlm/Hb3RdNY1hWoJ+dSWWecoiifykbey3wWRdbsInrcA/x64F/B8
xXxoV6T99mWz88FfpJqloe+nF/MZRfnekL1G9onyf8oJArL9pPuGvg0yDldt
wLfjG5nHOODG0E+A9lPGvczvYRxs4G9j874z3ZV83AnQH65x7iGec7LOgXWf
qnG6gruQ+78guCa4h7uZDdwo6Zx6LbyOrXVuuUD1FndxAzZ0P+cbyp19ji1+
oXwD2pHY/CeKtWn7buXgE8BPg/6uSudcpcTXkmbOre7GfidDeyv4xZXO35Xr
jCj6K+U8etvKOZXf6I3fV+01opUNa+8WsWOTZMgg3yzW31tpGaeDuxF4QVFe
yTYD+J5Ky3gL85sLjoUL+TaOeT14DBAt+80t+Mxa+0Clc9FH+PZE8T01B34I
eA3wGGjuUmws1geC64M/OravGIh8e1W7xM6V+siemC+CfnWlY1RT6KcW9SUZ
lxa8h3g9DjwF+pnF8ynmzYDfQuBVla4X5oBfALyi0jmvcpW/8K1HwjnL/cDb
0eGIcr9B5bY3FXx26aCZcvnievEcmbPPlK+U2T4C/vY612ZpzvApHz/LunaX
znpDe2rWsXMwa8pYX8K4LGkfL9vvHTn26g0MZF6GfXVs5De0nfnHtY5FUZlr
3aYp59KqeTew90FsbDZnPb2Ja6GJNc5dlc9pr43w7FThPZWL7oxtm8pJlct8
DTwm4ZxmKvJcn3Vt9U/GFtY2Kb6vbhXW1YK0a0fpLMv55xX1JZudWu0Yq9j6
v4Rr9+fU40i4hletuha4Z8I1667YNqC7lwz7Oc+/kX8bujuF95DM2UfKN16e
dG48IHKvRDnyCuDrq72Xctg2yFNa1K9s8nFwSxnH1XNM/ypvG5FtlIJvCf3i
or3JZvfHtlHZpmKgcsWZ6H9TI+eMi4HvztnXKGYPVi8hci9BPQDF5qbwO6bo
71LMl7Nfu0p/U2w7EDkXUYxTrthX+ViJ8yXVMgeK+aTqgZGqbxjtG9onF+D/
U51rf8W8UyPHQMU+0eit3Rnb1vXmZiH7DEaHEp9hPPJemXUvQzn+g7HPpLP8
h29Pgdufd2yXTOq1rAN/WsI9F9nmorxjkWz0O/Y/rdq9GcWbLnnHfMV65dzX
wa97jWtdxYyIeSrrXE01wNWKdTnXttvxH43SriFUOyjHawftwTr7RsWs5dWu
aVXLqiY8ocY2K1vtC7/50C7N+K1klFPA68q8e02r4Tc76xxauXP9pHOH/vB8
NWF99lPtVWde+paNXNOrlm/HOI/3UhG7V6AYfwSyr4jdy5uq9xW5xlRtqRp2
Ebw2IE/nMsfsXdzPsox9hWwiVi+m6I9HNkY25Budc66RaehavbbOvRXdqXLB
M8EvTjonbMzaJgXngsqxJ3LWSXmfVTWVeksDY8cq9ZhKwZUxOiQNKxfen3at
rxij3opqINU+6rEod3o271iuHEq++bbY/ldvpnPeOZpyM9WkS2L7DPmK4xOO
NdNixzqdUWetzjh2CP5V5J6RekXKEZ+O3XNSr0k++tnYPSP1iuRDnondg1Lv
ST5EsS2dca2jGKBY0STjXoZihmLDtbHjlfBf5ZwDKlbJJ6r3ka+z7iWjfH1d
xr0R+fz90M6udS9Tb+jx2D0l3a96CK8oN8jZNvSGvlctn7dtqWeyMe2en3Sp
HtdNWfdM1StVTaXasA/jwaTrnY3Ispz1tyr/aOLeWuuMY53e83zV4nn3ktXj
7JF2jab4ohr77Yx7Tuo1dS9zLbmjxrWDcqq+Ofdc1GvRnsuzztHkq5onHSvn
xvaPOn+/tHsk6o2oh7mU+ZK8e7/qaSsX+0feuZ9ysg3M1+dd62tNM/Y+osa1
djdoNoN7sYiXzK0j9zSUH6vGUq/rfb2JMve82kSu4ZUrqwY4D/mPjNzrPlI+
Ur3vyL1X9cA3yp/XuXbSm+udc00p3erNqDdeGbt2VY9csaI859iimNGQ+2yB
vB2rXDNu4nyj0u4tKUdWrGiRce0s+++RccxSrFKPdq16D6niW8MmngPuEbm3
Kx+nWmpW2rFHNZVia5R37acYezWyDYucaym/m8b+uyL3QuSDh6Tds1FsV4yY
D/62Wvc61KM+lHdOoFxAPfkVeduUbEk9++nQfhtZd+q/3KjcP/LdqCen3s2M
nHNx9XCSwNXFekA9IOXGV2dd2yhHVi/mh8i1nHoyS4GH5+1L3wM+JuUcSLmP
bFqxeEXWtqaY/HzWPU7pRj7pZtbelHfvXv8RdIT387Fji2qaBLwuTbt2UI9A
ufTE2Lmr3rt6nUtqvbd6nsrlGlY7P1aOclHOPST1jtRT+hZ4d86xT/+BfIeu
9ta5N6ecSrm//iNRP1c1wFx4z6m1b5aNqJbL17gXpppO/7X8XONaRf+5fKh+
XOzejGp+9aKb5RwrFB/UOxpZ7F/qPv8PKfyNjg==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8221467150771062, 0.8668449051258277, 0.8873680129794306], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmneUVUW2xg/Qt7vv7Xs73Ry6yZjGRBAQGJU0C5UgqAiOccw4qKjjPB1H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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXe0VFWWxu/j1Qv1Ur33ql7lKiSK2LaCgNAYSbMMgCJIi9qi7TQgKg6i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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8816619037585722, 0.8866916347127356, 0.8607052617836362], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFnHeYVdXVxi8wBWbu3DIzd2ZuFQULCIoKsSBgQQFNAiIaE+wN7A1Ro58m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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmnmA1vP2x79Ts9RsTz0zz8w8a6v2jZD2XSqUUqJkKy1okeReF5efipaL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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHecVdX19s+9d4Yyw9yZO4VhhrnXCiLYO4qCoDRRAUUFld5EpAUFaTH2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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHuU12Mex5/mUnPpNzN+l7n1+35zSemmOEJJ05q2pjamstiiiC6y1ClR
aaXtQrXIdlMphVhsylmLxrJnFRWHLi6DJeTotC4TsotU077e+94/Puf3PL/P
9fk8z+f2PeXaScMm5oQQ6luEkMfvkSiE19IhJFuG8HFJCJPjEG7I8B/7FgUh
jAJ/djKEx6FdCD6G9jH+28f6Jv47i3V3oC3C1iVC2JQNYTOwjfVW4AxwreC/
KD+Ey+H5jv1hoEdpCMXo+DwVws3sry4OoRSaC+FdiA2HwB8GPxJbRrO/qFUI
f2ffDdozgcnoW4P8JtaDq0O4F/6z4VkNfxv+G4Cukey/ZL0C2MO+G/suVSF0
BYrR9TUy1mPbpsoQ2heFUINPArqW8N9B9A2Afjr6P0TmMXR9xD6JrBTwJfQD
Id+DP/LhGQzuEmAp63HwvwT/MfYvgj8I/Q7052L/c6zv4sw/wn+Y/y7G9mnY
MzTfZ0iyTgGV7N/Hvufg/xyedsh6NDeEC1ifB6wDNw7+Pei7EXmj2c8sC+Ea
cKMj+34e/z2ErNvAN6Hva+BEmxBmc6b98j80Kzn7WmgOgksCHSu4f/hXIfsR
7n8fvBXYeCW2rea/DuA6Rr7Lxcg/zvp1bDynMIR+yOyLrJ346wCyVyBvEvZd
j74dnH06NKdDvwSZ98LbxH/nQXs+MAj64Zx5JPhnUn5rC/Re8OUbyJjM2Xbl
+m4uhGZCie9oKrhJyH8DWbch/3tkHc5adzk090F/FPpabDsA/VlJn1FnW4++
XPhPgM/AXwfNQfCv8d8E9I1B3z7Odj/yNmHfb8Af0VsATkV2FWeowjeVwErW
ucjLImse9v+A/jpo2lSbRriR+PBNZB9O+iw3o6MR/0fwDIJ2CzJOgvYzaPaC
i5Gxm/vaBfwb3DPYeKLKd6K7GFDst/kRcDzhN6pY/SMyC4ocs5cgaxjwmN4P
/H8oJ9bYN7DvjA+eZV3DGedh37norMGWO5DfH/k3AF3Z70ZmiqQxgv2n6NoP
5Ok9A7+EfwCwBnnrkb8f3knwrCxxjJWg70H2jewb8P9OaC/lvsrAjUNfBlw5
0Bf8ddg7D/xC8F8i7wvgM3QVc563c63zt+CmQDOj8P85Cn/tRecScAPxRxm0
d0AzG/xa4C18NzN27LZFZ0vWFUnnrov5bxe8x/FpBO4APr4JffXY3An8LPzZ
lf1l0Pdg34v9GPZjgS34bjs8X4H7tsJvbyY2NiNrd8p30x9YrlgC9mJfXb5z
QyUwLOEcMRpbx2PTNPi3cZ5t0L4ChFLH9FxwCzKOlY78N471jbFjaTv/5UDb
GZ3T8GVHdPRGd27ktXLyZ9i2H0hyf7Og75N1jlVulQ0xtAtTzhV6g8XQtq5w
7ulMPpyNrjno/LSlc7DeRgU8/Ur8Rlbj71VAmveWAarAVeoNBdP8DvpekXPV
RcAE5F2HvFda+szV4OYqf7V2zl7Lugf/XcP6Wt039GMzPmsDPj8/ckwrlseC
b6pwzCpWb0HeLeCnRK4lT4J/F1w9Mh7Fd8fheR/5b7Gfhb96gv8W2m8ivz3V
pMvRdQX4qchqQOcY6BORaYfnufa1TbtW/q8GQv+6cjDyTih+wZcBZxQ5p26B
9gD7DqV+Q39NOccpty0qse+m8d+/iuzDCeCuj1xbVoC/EvkjY5/tRewZCq4e
eBpdt4Efy/od+Afz1paW+Gx7gdvLfMZGcOMjy1JM3spbOZOYqMXfQ/DRooxj
TrH2FVDP23g+cm1aku9aMCSyLtWEJniXxa5t5fhzAeuTOeOeAtfszei7UjkQ
2vnA0+ynRr6LO4E3uY9O7K9g/QVnqMWeb9B5UolzQkf2nYBDhX6zUbVzpHKj
egTVLsW4Yls1TGe9OrIvdebdsWu8arti4j32H2NfAW95hXIq76Wtaga8q7C5
HesOyifs5+Df97ClEfiJ2DgCPAbucaAc3lrOOxx7ypA3It89UzryG9fbVg67
h/Ujlc7dzcCsjHO+cr1yzEvIfheaZdA2Jtw77E47F6mHGAp+SNa+34W+RdA+
yXmOIOtokXuHdcivKnIPcTL8cezY1pka4H0VHx/hvFPAt8fenez3oms8/nsA
fDp2b9QNnu/Yt0u5VqaAPuB+ASwH/wD4b8GXg/8+13f0MOddD1yFfR+w34ht
fwYagm18GPqNnPkE/C8kXDt0Zp1VNURvvQH6omK/+T7I6g1syHNNH4ruPsrf
pa5Zdaz78V+G+16HPb9mPSTjWtgM/YfKVVnf1UpsPAv82cDcUvugI++1Uxv3
XgOweTr6H0T/pfnuIRPljgG9/efx9zpwM6D5qsg93uXIuizjXKCc34C++ehb
jb5a5DeC35Z2L7uUO26XdE1VLVUOnJC1j+XbGQn3Mm9mnCvU07Tk7HnyAftu
0MxMuWdTr3YIeAfeHO5wEP76D/znw18L/yr0rS5wb/dQ5LtQj3cV+BEZ54oA
vjWyElV+C0ex9z7Wi3k/rYrcI/wMb3Pk3i0Nz7XwfsAZmls5Rx9F/4/sXy5y
z6Ne9HnOe3qpe9Kt7Gewb1HqmrUn5Rqo2lcH/Ax/z5R7pdnIux3/zapw75XN
ce5UDVXtVA4dx35M7Fr4cql7yVBtWeopd4D7HPrR0I+BfkjsHke9jXJ8H3Cj
4JmU8Ju8gvMMj+2LF6BJIKs1UIEvhhZ7VnmqyrGlmSWV9EyhWUI96dsp51jl
VvXAS6Adm3It2KgzIKu62r3dqGLHZlG1ZStG28eeETQbKMe8lXLPol5Fd1qD
fXXQrAU3v9Rvv4viudQxsBT69pFzpXrmaZrP0tb9Afhjke9Qd6ce95s2ztHK
zc3k+DOh7xp7tpHMJs57D2doxLYSzvS1ch1n3sA+wX4z9i/kv/UJ17Be8PYG
7tNshY4p2Hdr7F54N/v1yLoL+rUJx4xy59SMbVMOVW/dIvYspR77QNI9oHo/
3eE1rEfFnu3Ukw6M3VOql5RP6vBVXtqx+xfONB7ZE2PPppophmX8JvQWjuGf
01ifEvutTYW/JuWap1p3ep57izXqN0rcY2zAnkVZx9p4fDSZ8/+Ude+nGiRf
5UeOTflMs8HOjHVpRrg/co+n3k4zpmLj5ArHpmIksO+sGEh4BpwP/6AK61KP
OxFZ/8SGE608wzSRj66KXDv1RhcnPaNpNmtC3EmqPdXupVWDtiNrA/L/hvzN
0HeOPKNpNlON/aHCOVK5UT1xA/ynxvbNGcrx+OKcyLlvDTzL2HdhP7zEPbBm
074p+04z6gVVnjk1a2om+T32P8C+eyv3iFvTzonKhT8GzzKrk+4lNdO8AP+W
KutSDViJrsJy36165Gbebsh6NpXMkaynp53rFdPqLdRTqJdQj6HeUTOXZi31
kE+g77WMa7VmhH6se/LfxELnTN1Fl6x7ed2Jvk2oJ1AvoG8UmvVW6htGwjNf
b3BjY+eiZ6H5U+z/tFZPsJn9JuA7zd/YsCvjGUmzUVTm3ign9mypHkm926WR
adXDdY+dAxT7qlk98M05Vc6NytHKrZur3Esox+7Q94O0Zw/VxKfg3xg7FkOJ
7255yrOa7lC1+LRy9xKqyYrtBVl/q1GMf8/5P8maVzPWo8qHSb8lzbD1uvvY
vZFq1CNZ13jVdr05favoUO3eQt8sClgXVnsWOBz8beBQG+cifSM4D3k3VHkW
S2pmrnaNU21TD1uDrv4Z9x6L2X+Sdg+n3k0z6lzpTnsWWqUchewOQDrH33BG
KDdlnOvVw6vW11dblmp+Et567m9HgXuYX0E/EPqHWzoGWyf9zUjfitQjX6h8
lHHu0xu6IPZMoVlCOXFN1j2Veqka8Dkp51jl1l7Ysx3fv1ruWCiCZhW4rei/
v4Xf2D3s784aJ5vmsH4o6d5COblv7JlIs5B6snWRv5noW4lmavVOfSPP6uqh
NGsoxhXbmjlUu5XjldtVw+dl7UP5Tj2McvedWX9LUw5/UG8j67N0x6ZPsX1/
udfqoWuVyzPuxdQj9I/9TUHfEvQN4An0vV7ps+uM52qeLfdbUM7Vt6uekWc3
fcPah65nKvxtS98wXob2H+XOdfqmMghdg9FRWeg7GgfvuSm/HfXQir2nY8ea
YnAn+Ls5/xv55hmP/Ouznh31338Bx0XwqA==
         "],
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV03loz2EcwPGHmDSWmzlmjp22YWHuyTmF2aQQc4SyHJFtSpirlORmSzn+
oMRGTdjwj5ApY8pRbjlK/KWYI7y+f7z3/j7P87m+z/e3PkvWFK5uFkKI9+dO
hxDaxIfQFrGo7RnCbXvnuoZwiwcnhJCNQcjtHEIeT8UkTMFk7O4SwkJehCIs
ELeY53M5b+MtvJWPcR3/7WEAvf5xuXW7bmL4u77P8czZUzzBevtl8oo7hXDA
jMs6hhDXK4Sl3Jaf8SPnjVhofcl6AddwEWd7j/3q74uQv5eH8hA0Otuk32bM
U/+KGoPtpVkXy52JAuRjFgpxQUw1LqLBbG/M+BbvEKv2N/mvPb9ClZjzWCuu
hNdxKb/U66jzClTipn5n5d2TX48GMc3N/9XZHnO21DcGLaJZ7CdF30St/pyC
ZDxUsyU/4Bjuqt4yJFifkdebf3I9N/Fdntvd3fMcbs/zOM73PO78BHL0H46O
6ny1nuZ8OsrMNM4cJTyW13Mul3KWb/pG/zZyPss5gqM4jEpUoLUeeeq00HMK
p8lJxzXrj86v8ycOPED/DGRitpp57uqq/Q/Oa7mvXv3QBwPdyS9xI8zyk//g
N37I+8JNXGDGbZ5Pea5Va6fnHdiOOvW2q7NLnSzrGDFJ+hxQrz8f5GS+bz+d
ByAFaUhFq+i+1eytRiISkKXWO3tv0RD9tvRPx1rfuUmPlViFfHdySP2M6K44
kx+Iv+HssfVy62G8Qm4OF/Mjd7ZRjw16PBf3Ai9Ro9dl7/JezhVOjGbCcLET
xObwRB7B43lM9D/NI3k0RuGx3vk8EzNQiAKMFZcRvRcycULcabVPcrV3qkKq
uVLwAv8BFoGdgg==
         "]],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV00dsz2Ecx/GnREKrSveOhnCwxa6ui4OD1jhZwcFIhMRWEgdFWxpCBR26
SIzy51Dr1KURB3WqG61wpDjar9/h/f88z3c/v+f5F+zYv25fXAgh3s+r5BBm
ZIcwEylZISRjCvpSQpiYEUICkvkaxH3M57PuyAyhjj8m7nhqCL15IfSjD/V8
V9n38r8VX2j9JieEQZSnhbCerYJuoMfkbskNYSuK1V+oV2V6CPfldOIeatV5
QGNiHmK7HtvQqs9d9hr+fPs8DLHlme+z2jH1DrJ94j9AD+MQHtlvojG6mX7R
b6KcRCQgHi3qnON/wv8U5fpWYC2OqDtNTqcztNt34BYGzP6A77b1HXNVyc+V
e5pm0xw08KWarZE2oU9OC72JZgz7HiNqD+O99TuxH2gxStBlP12PJHll6mUi
Cxk4pU8JLcVKFKMIl8UHeXH4Zz+WjsFU9appDYqi749MsTtxha0eX9zZKL7i
tfg/8v/iJ37jFy6JX0aXYykKsQInzZNK05EWzSlukrlHrb/hK37gO3rU7sOQ
nr30pfMPoNv6vLkuoA7l0Vtka5XTjjZU6tPme5+g7dF7ie5Dr9Viz0Tnc09V
tJYmqrmRb5G8RvHPxL/Acxy1v+HeG9CICd7BePTLWSK+iX8xbaal6pWhGKvU
LaFrxJbjplrHxDSp8ch6rpx5OGuuc2iN/jP8LTSFPRmTzFRg3t3We7Aresti
9tMRuo8O0zlyZmNQv1l0THSf0X3zxdHHbPPpAlTrVYOYOZLsJ2NKdA4xzbjO
flHfcWbudsYeXFOniz2TLQs5yEYu/gMAtpaO
         "]],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5069, 6652, 5070, 6653, 7126, 5502, 7885, 4850, 6133, 4849, 
         7884, 5581, 5084, 5485, 7882, 4843, 6128, 5484, 7796, 5487, 7795, 
         5486, 4826, 7755, 5449, 7754, 5450, 7756, 5259, 7624, 5260, 7270, 
         7271, 7272, 5952, 7787, 5477, 7786, 5478, 7788, 5476, 7791, 5480, 
         7789, 5479, 7790, 4842, 7793, 5482, 7792, 5483, 7794, 5481, 7849, 
         5577, 7846, 7848, 7847, 5948, 7781, 7782, 7780, 5473, 7783, 5472, 
         7785, 5475, 7784, 5474, 4825, 7747, 5447, 7746, 5448, 7748, 5254, 
         7623, 5255, 7267, 7268, 7269, 5951, 7766, 5461, 7765, 5462, 7767, 
         5460, 7770, 5464, 7768, 5463, 7769, 4838, 7772, 5466, 7771, 5467, 
         7773, 5465, 6125, 4839, 7881, 5576, 5083, 5458, 7879, 4836, 6124, 
         4837, 7880, 5459, 7120, 6467, 7407, 7408, 4886, 7406, 7260}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5073, 6657, 5074, 6658, 7380, 6659, 5076, 7525, 5075, 7918, 
         6679, 5085, 6655, 5071, 6654, 5072, 6656, 7368, 6464, 7410, 7411, 
         4900, 7409, 7273}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4609, 6068, 6069, 5532, 6071, 6070, 5261, 6949, 6950, 6946, 
         6948, 6947, 4608, 7197, 7198, 6943, 6945, 6944, 5299, 6942, 5301, 
         6940, 5300, 6941, 7196, 7195, 7921, 5297, 7651, 5298, 6939, 5294, 
         6937, 5296, 6936, 5295, 5593, 5592, 6934, 5292, 6314, 6315, 6316, 
         6065, 7297, 7296, 6313, 6933, 6932, 5591, 7649, 7650, 7294, 7295, 
         4766, 6064, 4765, 6718, 6719, 6717, 5115, 5636, 5635, 6072, 4917, 
         5821, 5959, 5958, 4690, 5634, 5114, 6714, 6716, 6715, 7210, 4613, 
         7902, 7903, 7901, 6513, 6510, 6512, 6511, 7209, 7208, 7564, 7565, 
         7207, 7859, 7206, 6724, 6259, 4920, 6509, 6723, 6722, 4692, 7205, 
         7204, 7203, 5119, 7563, 4923, 6726, 5122, 6725, 5121, 5639, 5638, 
         5640, 7216, 7572, 5123, 7919, 7215, 4925, 7580, 5129, 7578, 5128, 
         7579, 4697, 4619, 7218, 6526, 4931, 6268, 6269, 6742, 6743, 6739, 
         5135, 7581, 6740, 6741, 6533, 6535, 6534, 6768, 6977, 4639, 6187, 
         6186, 5169, 5656, 4716, 4640, 6188, 5855, 4947, 6081, 5660, 5661, 
         6198, 7174, 7175, 6001, 6000, 4779, 6085, 4780, 7329, 7328, 7703, 
         7702, 4868, 7159, 7160, 6352, 6353, 6354, 6093, 7335, 7334, 6355, 
         5365, 7012, 4874, 5732, 5558, 7163, 5559, 7164, 5379, 7030, 5381, 
         7028, 5380, 7029, 5491, 7857, 5584, 7399, 7400, 7401, 6137, 7403, 
         7402, 6480, 5511, 7131, 7916, 4854, 7915, 6623, 7914, 6624, 6620, 
         6622, 6621, 7727, 7110, 7111, 7078, 7080, 7079, 5273, 7084, 7085, 
         7081, 7083, 7082, 7086}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4677, 4748, 5684, 5082, 6460, 6461, 4819, 5941, 4820, 6636, 
         6637, 6635, 5056, 7522, 5772, 5773, 5048, 6385, 6670, 6671, 5081, 
         6672, 4796, 6383, 5755, 4882, 6108, 5610, 6911, 6912, 6910, 5269, 
         7633, 6025, 6026, 5283, 6921, 6923, 6922, 4659, 4733, 7842, 7843, 
         7172, 5570, 6116, 6115, 7362, 7361, 7360, 7721, 7720, 6357, 6356, 
         5038, 6608, 4869, 6087, 4870, 5723, 5266, 6909, 6842, 6843, 6210, 
         6211, 4650, 5864, 6002, 6920, 5281, 6919, 5282, 7698, 7699, 7695, 
         7697, 7696, 4756, 6140, 5520, 6157, 5521, 6141, 7687, 7236, 7929, 
         5522, 7821, 7237, 7238, 4717, 7830, 5546, 7154, 5547, 7155, 5329, 
         6980, 5331, 6978, 5330, 6979, 4755, 6138, 5517, 6156, 5518, 6139, 
         7684, 7231, 7928, 5519, 7820, 7232, 7233, 4711, 7829, 5544, 7152, 
         5545, 7153, 5323, 6971, 5325, 6969, 5324, 6970, 4753, 7668, 7669, 
         7667, 7671, 7670, 5278, 6915, 5277, 7639, 4634, 5838, 6748, 6749, 
         6747, 6751, 6750, 6903, 5264, 5719, 4863, 5961, 5598, 6587, 5022, 
         6331, 7133, 7181, 7182, 7184, 7183, 5709, 5710, 5568, 7840, 5569, 
         7841, 5516, 7814, 7815, 7219, 4621, 4699, 7659, 6959, 6960, 7638, 
         7637, 5276, 5964, 7871, 5963, 6898, 5262, 6897, 6900, 6899, 4857, 
         6074, 4858, 5712, 6320, 4770, 6660, 5079, 6324, 6323, 6321, 5014, 
         5594, 7864, 4624, 6579, 5016, 6578, 6581, 6580, 4816, 5923, 6730, 
         6731, 6729, 5125, 5642, 4694, 5922}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4682, 5689, 5688, 6650, 5067, 6433, 6435, 6436, 5097, 6698, 
         6697, 6440, 5068, 6651, 5694, 6633, 5053, 6403, 6404, 4803, 7115, 
         6892, 6893, 6891, 6895, 6894, 5683, 6629, 6630, 6400, 6401, 4801, 
         6693, 4802, 7876, 6692, 6402, 6632, 6631, 5692, 6618, 6619, 6381, 
         6382, 4795, 7114, 6883, 6884, 6882, 6886, 6885, 5679, 6615, 6616, 
         6378, 6379, 4793, 6687, 4794, 7875, 6686, 6380, 5047, 6617, 5691, 
         6614, 5042, 6367, 6373, 6374, 5457, 6870, 5223, 6370, 5224, 6871, 
         6290, 6291, 5751}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5567, 6153, 6112, 7365, 7364, 7363, 5440, 7733, 4982, 7757, 
         5451, 7369, 7370, 7371, 6120, 6466, 6465}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4626, 5595, 5017, 6327, 6329, 6330, 6663, 6662, 4771, 6326, 
         5714, 4860, 5924, 4859, 6901, 6902, 6322, 5263, 5965, 5131, 6957, 
         5309, 6955, 7657, 7656, 7865, 4700, 4623, 7278, 7220, 6262, 6167, 
         5130, 6736, 7938, 7939, 5831, 7943, 7933, 6171, 6754, 7588, 7587, 
         6755, 5515, 6055, 6054, 5970, 7872, 5971, 5311, 6961, 5310, 7660, 
         7867, 7866, 4704, 4628, 7279, 7225, 6270, 6170, 6753, 6752, 4939, 
         6770, 5154, 7591, 5153, 7893, 7281, 7282, 6278, 6905, 6904, 5156, 
         6076, 5155, 5979, 5848, 7941, 7942, 7931, 6189, 6793, 5170, 7595, 
         7594, 7819, 7818, 5265, 5993, 5172, 6077, 5171, 5992, 5858, 7936, 
         7937, 7922, 7924, 7923, 6815, 5184, 6907, 7869, 6908, 6906, 7241, 
         6284, 6283, 6200, 5185, 6816, 4951, 6844, 6845, 6840, 7284, 7283, 
         4727, 4651, 7015, 5366, 7013, 5367, 6016, 6015, 6056, 6057, 6017, 
         5214, 6117, 5213, 5879, 4966, 6873, 5227, 7615, 7616, 7288, 7287, 
         4738, 4664, 7053, 7054, 7051, 5400, 7055, 5242, 6041, 5272, 6384, 
         6914, 6913, 5616, 5940, 4888, 5774, 6414, 4807, 6677, 6678, 6676, 
         6675, 6416, 5058, 5795, 5794}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4898, 5945, 4899, 5808, 4981, 7094, 5421, 6434, 6437, 6438, 
         6050, 6896, 5257, 6439, 5258, 5917, 5916, 7072, 5410, 7071, 5411, 
         7073, 5409, 7076, 5413, 7075, 5412, 7709, 5898, 7068, 5406, 7066, 
         5407, 7069, 5251, 6890, 5253, 6246, 6248, 6249, 5912, 7046, 5396, 
         7045, 5397, 7047, 5395, 7050, 5399, 7049, 5398, 7706, 5890, 7042, 
         5392, 7040, 5393, 7043, 5237, 6881, 5239, 6238, 6240, 6241, 5910, 
         5911, 5376, 6368, 7340, 7341, 6100, 6372, 6371, 6369, 5377, 7026, 
         4961, 5753, 4881, 5934, 5608}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5531, 6061, 5275, 6111, 5274, 6060, 6058, 6410, 6409, 6406, 
         5414, 7077, 5615, 6548, 4971, 6478, 4970, 6547, 5510, 6477, 6476, 
         6473, 5508, 7129, 6228, 6229, 4737, 7027, 5674, 5378, 5878, 7162, 
         5877, 4656, 4732, 5670, 5364, 5868, 5867, 4649, 4725, 5666, 5352, 
         5863, 5862, 4643, 4720, 7600, 7601, 6813, 5179, 5854, 5853, 6792, 
         6539, 6540, 6280, 6538, 6537, 6767, 5149, 6532, 4938, 6275, 4937, 
         6531, 5133, 6737, 5134, 6738, 6267, 6266, 4930, 6525, 7217, 4618, 
         4696, 5644, 5127, 6163, 6164, 6165, 5827, 7568, 7569, 7567, 7571, 
         7570, 6261, 6260, 6515, 6514, 4611, 4691, 6720, 6507, 6508, 6258, 
         6721, 7561, 7562, 7201, 7202, 4612, 5823, 6712, 5111, 6711, 5112, 
         5633, 4689, 6709, 6710, 6498, 4914, 6256, 6713, 7191, 7891, 5113, 
         7559, 7192, 6499, 7930, 4915, 6253, 4916, 6500, 7193, 7194, 6501, 
         6502, 6255, 6504, 7275, 6503, 4607, 5819, 5820, 5106, 6162, 7187, 
         4604, 4685, 5953, 5811, 5812, 5290, 5627, 4686, 5955, 5813, 5814, 
         5291, 5628, 4687, 5956, 5815, 6935, 5816, 5293, 5629, 6938, 4688, 
         5957, 5107, 5817, 4912, 6066, 5630, 5631, 5108, 6931, 5288, 6309, 
         6311, 6312, 6052, 6063, 5289, 6119, 7648, 7647, 7646, 5540, 7825, 
         5543}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4663, 5609, 5041, 5752, 6365, 6366, 5730, 4788, 5740, 5741, 
         5375, 5736, 5735, 4736, 4662, 6239, 5607, 5238, 5750, 7041, 5749, 
         4792, 5761, 7048, 5762, 5394, 5757, 7044, 5756, 4741, 4669, 6247, 
         5614, 5252, 5770, 7067, 5769, 4800, 5780, 7074, 5781, 5408, 5776, 
         7070, 5775, 4747, 4676, 5621, 5256, 5789, 5787, 4812, 5800, 6432, 
         6431, 5809, 5066, 5807, 5806}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4844, 7381, 7926, 5441, 7734, 7366, 7367, 6118, 7826, 5541, 
         7147, 5542, 7148, 5287, 6930, 6929, 6310, 5286, 6928, 6927, 6497, 
         4911, 6495, 4910, 6496, 7190, 6494, 4909, 6492, 4908, 6493, 7189, 
         6491, 4907, 6489, 4906, 6490, 7188, 6488, 4905, 6486, 4904, 6487, 
         7186, 7185, 5105, 7554, 5626, 5954, 4903, 5810, 5104, 6708, 6707, 
         6254, 4902, 6485, 5103, 6706, 6705, 6252, 4901, 6484, 5102, 6704, 
         4684, 7274, 6703, 6251, 6483, 6482, 6702, 4683, 5625, 5101, 7552, 
         5100, 7553, 5818, 4606, 7414, 7415, 7412, 4913, 7413, 4605, 7858, 
         5109, 5632, 7558, 5110, 7555, 7557, 7556, 5822, 4610, 7200, 7199, 
         5116, 7560, 5637, 5118, 7892, 5117, 7422, 4922, 7421, 7424, 7423, 
         7566, 5826, 4616, 7860, 5126, 5643, 4695, 4617, 6523, 6524, 6264, 
         6265, 4703, 7222, 7221, 6530, 4936, 6274, 6276, 6277, 7228, 6536, 
         4942, 6279, 6281, 6282, 7235, 5852, 4946, 5999, 5659, 7603, 5181, 
         7602, 5180, 6814, 7431, 4949, 7432, 4950, 6542, 5197, 6839, 7433, 
         4955, 7434, 4956, 6543, 5209, 6860, 7435, 4962, 7436, 4963, 6545, 
         5225, 7176, 5583, 6472, 6474, 6475, 6136, 7398, 7397, 6479, 5509, 
         7130, 4887, 6634, 5054, 6405, 6407, 6408, 5055, 7839, 5566, 7837, 
         5565, 7838, 5572, 5574, 7900, 5573, 6154, 5437, 7897, 5588, 5571}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4861, 6521, 6522, 6328, 4929, 6520, 5716, 5717, 5018, 6582, 
         7475, 7474, 5713, 4701, 4625, 6168, 5837, 5132, 5835, 6956, 5834, 
         6175, 6174, 6166, 6759, 6758, 5647, 5973, 4932, 7932, 5832, 5969, 
         7868, 5968, 7905, 4705, 7280, 7226, 6272, 6271, 6173, 5139, 5840, 
         6962, 5839, 6180, 6179, 6169, 5157, 6771, 5651, 6774, 6775, 6769, 
         6773, 6772, 5849, 4641, 6191, 6190, 6797, 6796, 5657, 6802, 6803, 
         6799, 6801, 6800, 5859, 4645, 6202, 6201, 6820, 6819, 5662, 6825, 
         6826, 6822, 6824, 7870, 6823, 5865, 4652, 7242, 6212, 6199, 6849, 
         6848, 5668, 6852, 5200, 6841, 5199, 6851, 5870, 7014, 5871, 5212, 
         7613, 5211, 7612, 7285, 7286, 4734, 4660, 6222, 5881, 4967, 6027, 
         5675, 6875, 6876, 6872, 5229, 6874, 5891, 7052, 5892, 5243, 5893, 
         6040, 6039, 4742, 4671, 6640, 6641, 6638, 5057, 5792, 5791, 6550, 
         4978, 6415, 6552, 6551, 5622}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4678, 4749, 6293, 5790, 4891, 5942, 4892, 7087, 7088, 6639, 
         5415, 6046, 5246, 5894, 4974, 6042, 4973, 6877, 6878, 6233, 7256, 
         7257, 4739, 5676, 5228, 5880, 6230, 6231, 5882, 6862, 6863, 6861, 
         6865, 6864, 5671, 6018, 4957, 5873, 6213, 4653, 4728, 7608, 7609, 
         6846, 5198, 6850, 4952, 6827, 5188, 6204, 7243, 7244, 4721, 7604, 
         5186, 6817, 5187, 6821, 4948, 6804, 5175, 6193, 7239, 7240, 4718, 
         7596, 5173, 6794, 5174, 6798, 4944, 6776, 5158, 6182, 7234, 4635, 
         4712, 5980, 5981, 5841, 4940, 5983, 5652, 6779, 6780, 6172, 6183, 
         7227, 4636, 5843, 5972, 5141, 5833, 5142, 5648, 4706, 7589, 5140, 
         6756, 6761, 6760, 4933, 5966, 4934, 5836, 6176, 6177, 5316, 6583, 
         6964, 6963, 4862, 5925, 5596, 5597, 6263, 4702, 5715}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4681, 6295, 6294, 5798, 4893, 5944, 4895, 5801, 6430, 5788, 
         4890, 6051, 5620, 5897, 4977, 5785, 4976, 5779, 4889, 6037, 5617, 
         5619, 5052, 5765, 4884, 6106, 4885, 5767, 4969, 5760, 4883, 6023, 
         5611, 5613, 5046, 5745, 4879, 6098, 4880, 5747, 4959, 5739, 4960, 
         5876, 4877, 6099, 4878, 5742, 6364, 5731, 4873, 5935, 5604, 5605, 
         6285, 6286, 5724}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4630, 5599, 5023, 6333, 6335, 6336, 5718, 4773, 6332, 5977, 
         5144, 6075, 5143, 5650, 5649, 6764, 5145, 6757, 6763, 6762, 6972, 
         4637, 5844, 5846, 5975, 5974, 4941, 6781, 5160, 6777, 5159, 7592, 
         4713, 6981, 5653, 5162, 5842, 5161, 5982, 5332, 6195, 6194, 6181, 
         6806, 6805, 5658, 6809, 6810, 6795, 6808, 6807, 6988, 4646, 6205, 
         6192, 6829, 6828, 5663, 6832, 6833, 6818, 6831, 6830, 6997, 4654, 
         6214, 6203, 6854, 6853, 5669, 6856, 6857, 6847, 5203, 6855, 5368, 
         6224, 6223, 5872, 5215, 5672, 7016, 4735, 7255, 7254, 6226, 5216, 
         6866, 4968, 6028, 6029, 5884, 5883, 6033, 7056, 4672, 6242, 6232, 
         5244, 6887, 5680, 5681, 6243, 7091, 5247, 6047, 6420, 4809, 5793, 
         7355, 7354, 6422, 5060, 5797, 5796}],
        RowBox[{"-", "0.2`"}]],
       Annotation[#, -0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4896, 5915, 4897, 5804, 4980, 5799, 4894, 6048, 6049, 5624, 
         6244, 4680, 5943, 5782, 7170, 5783, 5403, 5786, 5784, 5896, 5777, 
         5778, 5236, 5618, 4675, 5939, 5763, 5764, 5389, 5768, 5766, 5889, 
         5758, 5759, 5222, 5612, 4668, 5937, 5743, 5744, 5371, 5748, 5746, 
         5875, 5737, 5738, 5207, 5606, 6220, 4661, 5933, 5727, 7157, 5728, 
         6091, 6090, 4872, 5729, 4954, 5726, 4871, 5907, 5602}],
        RowBox[{"-", "0.2`"}]],
       Annotation[#, -0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4655, 5603, 4998, 5725, 6302, 4760, 6600, 4759, 7008, 7009, 
         7007, 7011, 7010, 5363, 7158, 5554, 7156, 5553, 7833, 4731, 7253, 
         7252, 6221, 5526, 7137, 5208, 6012, 6451, 6446, 5427, 7097, 5697, 
         7025, 5374, 6363, 7338, 7339, 6097, 6362, 6361, 6360, 5557, 7161, 
         5673, 7142, 5527, 7139, 7141, 7140, 6024, 4818, 6455, 6454, 7104, 
         7103, 5700, 7038, 7039, 6377, 7349, 4791, 6105, 4790, 6376, 6375, 
         5561, 7165, 5678, 7145, 5529, 7143, 5528, 7144, 6038, 6458, 6457, 
         6456, 5436, 7109, 5705, 7062, 5405, 6396, 7352, 6109, 5402, 7171, 
         5564, 7169, 5563, 7836, 4746, 7266, 7265, 6245, 5530, 7146, 5250, 
         7064, 7065, 7063, 7708, 7707, 4763, 6647, 4764, 6308, 5805, 5009, 
         5803, 5802}],
        RowBox[{"-", "0.4`"}]],
       Annotation[#, -0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4864, 6528, 6529, 6334, 4935, 6527, 5318, 6967, 5319, 6968, 
         5317, 6563, 6966, 6965, 5976, 4707, 4629, 6178, 5165, 6786, 5146, 
         5978, 7311, 6338, 6974, 6973, 6184, 5845, 5163, 5988, 5654, 6784, 
         6785, 6778, 6783, 6782, 6916, 4642, 7688, 7689, 6982, 5333, 5985, 
         5984, 4776, 5995, 5996, 5334, 6079, 5176, 5994, 4719, 6197, 6196, 
         6834, 5177, 5997, 6347, 6004, 5190, 6084, 5189, 6003, 4722, 6207, 
         6206, 6858, 5191, 6005, 6350, 6007, 5202, 6088, 5201, 6006, 4729, 
         6216, 6215, 6867, 5217, 6009, 6008, 4784, 6019, 6020, 5369, 7017, 
         7019, 7018, 5733, 6924, 4665, 6234, 6225, 6880, 6879, 5677, 6034, 
         5232, 5885, 5231, 7057, 7058, 6386, 6388, 6045, 5245, 6129, 5493, 
         6044, 7898, 6043, 4743, 4673, 7089, 7090, 7128, 7127, 5416, 7093, 
         5418, 7092, 5417, 6553, 4979, 6421, 6555, 6554, 5623}],
        RowBox[{"-", "0.4`"}]],
       Annotation[#, -0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4679, 4750, 5685, 5061, 6423, 6424, 6425, 5093, 6696, 4810, 
         5706, 5507, 7395, 7396, 4853, 6135, 4852, 6470, 6471, 7801, 7800, 
         7385, 7386, 6130, 6131, 5495, 7121, 5494, 7802, 5895, 7059, 7060, 
         6390, 6389, 6387, 5401, 6235, 4666, 4740, 6030, 7925, 6031, 6102, 
         6101, 5230, 6032, 6306, 6305, 6926, 6925, 4875, 6094, 4876, 5734, 
         4958, 7020, 7021, 6359, 7336, 7337, 6021, 7614, 5218, 6868, 5219, 
         6869, 5000, 5909, 5356, 7001, 5357, 7002, 5355, 7004, 5359, 7003, 
         5358, 7704, 5866, 6999, 5353, 6998, 5354, 7000, 5204, 6859, 5205, 
         6217, 6218, 6219, 5905, 6993, 5348, 6992, 5349, 6994, 5347, 6996, 
         5351, 6995, 5350, 7701, 5860, 6990, 5345, 6989, 5346, 6991, 5192, 
         6835, 5193, 6208, 6209, 5904, 4994, 6983, 5335, 6341, 7314, 7315, 
         6080, 6344, 6343, 6342, 6985, 6984, 4945, 5722, 4867, 6078, 5600, 
         6917, 6918, 6301, 7289, 5989, 5164, 6811, 6812, 6185, 4638, 4714, 
         5986, 5987, 5326, 6337, 6339, 6340, 6976, 6975, 5847, 7124, 5497, 
         7123, 5498, 5991, 5990, 7593, 5166, 6787, 6789, 6788, 4989, 6564, 
         4990, 6565, 7116, 7907, 4774, 7310, 7927, 5452, 6766, 7934, 5147, 
         6765, 5148, 6273, 7940, 4708, 5720}],
        RowBox[{"-", "0.6`"}]],
       Annotation[#, -0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5029, 5665, 5664, 6838, 5196, 6836, 5195, 6837, 5908, 4778, 
         6349, 6348, 6602, 6601, 5690, 6092, 4997, 5906, 6011, 6010, 7113, 
         4782, 7873, 7112, 6351, 6607, 6606, 4953, 7096, 5426, 6448, 6449, 
         6450, 6089, 7359, 7358, 6447, 5425, 7095, 5037, 5928, 6227, 7136, 
         5221, 6022, 5206, 7024, 5373, 7022, 5372, 7023, 5874, 7722, 5430, 
         7101, 5431, 7102, 5370, 7100, 5429, 7098, 5428, 7099, 5932, 6237, 
         6236, 7138, 5235, 6036, 5220, 7037, 5391, 7035, 5390, 7036, 5888, 
         7723, 5434, 7107, 5435, 7108, 5385, 7106, 5433, 7105, 5432, 5936, 
         5045, 6889, 5249, 6395, 5248, 6888, 6035, 7351, 7350, 6394, 5404, 
         7061, 4975, 6627, 6628, 6398, 6399, 4799, 6691, 4798, 6397, 5913, 
         5008, 6110, 5693, 6648, 6649, 6429, 7356, 4811, 5914, 6428, 6427, 
         6426, 5062, 6642, 5686, 5687, 6250}],
        RowBox[{"-", "0.6`"}]],
       Annotation[#, -0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4823, 7877, 5087, 5086, 7531, 7533, 7532, 5031, 7500, 5030, 
         7501, 5861, 7502, 5032, 6597, 6599, 7912, 6598, 7913, 4832, 7374, 
         7375, 7173, 7845, 7844, 5534, 7822, 5533, 7823, 5535, 4724, 4648, 
         7862, 5525, 5488, 6142, 5524, 7177, 5523, 7135, 4822, 7911, 7134, 
         6596, 5028, 7499, 5027, 7917, 7290, 7291, 7006, 5360, 7005, 5361, 
         5550, 7899, 5549, 5696, 5695, 6158, 5536, 6143, 5537, 7627, 5268, 
         7625, 5267, 7626, 5362, 7832, 5552, 7831, 5551, 6151, 7643, 7642, 
         7641, 5585, 6148, 6147, 6095, 6096, 5590, 5699, 4786, 6152, 4785, 
         5698, 5589, 6145, 6144, 7824, 7631, 7632, 7628, 7630, 7629, 7705, 
         4787, 7874, 5556, 5555, 7180, 5587, 7178, 5586, 7179, 6149, 6150, 
         6104, 5386, 6161, 5703, 5704, 5560, 5702, 5701, 6159, 5538, 6146, 
         5539, 7636, 5271, 7634, 5270, 7635, 5387, 7834, 5388, 7034, 5285, 
         7645, 5284, 7644, 7292, 7293, 6625, 5050, 7935, 5051, 6626, 7125, 
         4840, 7805, 5500, 7804, 5501, 7806, 5499, 7851, 5579, 7850, 5578, 
         4745, 4674, 7779, 5470, 7778, 5471, 6127, 6126, 4841, 6645, 6646, 
         6643, 5063, 6644, 5901, 7524, 5064, 7523, 5065, 7545, 7546, 7544, 
         5096, 5420, 7896, 5419}],
        RowBox[{"-", "0.8`"}]],
       Annotation[#, -0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4865, 5721, 5090, 7536, 5091, 7537, 4828, 6121, 4827, 7878, 
         5453, 5947, 5946, 5926, 5927, 5280, 7640, 5279, 6062, 4846, 6700, 
         6701, 6699, 5098, 7547, 4715, 5655, 5168, 6790, 5167, 6791, 7313, 
         7312, 4775, 7908, 7117, 6567, 4993, 6566, 4992, 7598, 7599, 7597, 
         5178, 5998, 7318, 7317, 7316, 5336, 5851, 5850, 7694, 5339, 6986, 
         5340, 6987, 5337, 7693, 5338, 7690, 7692, 7691, 7731, 4647, 5601, 
         5575, 7372, 7373, 4829, 6122, 4830, 6589, 6590, 6588, 7491, 7490, 
         4757, 7494, 7495, 7493, 7497, 7496, 4831, 6592, 6593, 6591, 5024, 
         7492, 4723, 7246, 7245, 7605, 5194, 7920, 7376, 7377, 6595, 5026, 
         6594, 5025, 7498, 4758, 6604, 5035, 6603, 5036, 6605, 4833, 7509, 
         5034, 7508, 5033, 4730, 7251, 7250, 7610, 7611, 6463, 6462, 4824, 
         7513, 7514, 7510, 7512, 7511, 4761, 6610, 6611, 6609, 6613, 6612, 
         4835, 6123, 4834, 7379, 7378, 5454, 5931, 5930, 7732, 4667, 7259, 
         7258, 5234, 7617, 5233, 7033, 5383, 7031, 5382, 7032, 5886, 5887, 
         5384, 7346, 7347, 7348, 6103, 4789, 7345, 7344, 7456, 7455, 5003, 
         7457, 5004, 6574, 6688, 7910, 4797, 6689, 6690, 6393, 6392, 6391, 
         5049, 5682, 4744, 7264, 7263, 7621, 7622, 6469, 6468, 4845, 7809, 
         7810, 7459, 5006, 7458, 5007, 7550, 7551, 7548, 5099, 7549, 5949, 
         5950, 5580, 7883, 4847, 6132, 4848, 7543, 5095, 7542, 5094, 5708, 
         5707}],
        RowBox[{"-", "0.8`"}]],
       Annotation[#, -0.8, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{0, 3}, {0, 3}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1386126735]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->256706282],

Cell["Use dashed contour lines:", "ExampleText",
 CellID->1869105407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"ContourStyle", "\[Rule]", "Dashed"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1735185547],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyUvQd4VcXzP3xzS24EaaGIUgVEQHovwh5BBJSOiBpEpKgoiAUQBKUoItKU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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgmUVdWVhm/dquJRQj2sevWoKqhXgr0aTEeM2tqmoaWj4hAnJimgjMyi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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllllslFUUx2/X6TZdvs5MO22/EXgQFNRETYygQNhFQEFRwASEiiayo2yF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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.3835503214670458, 0.21412364290547561`, 0.656106692642075], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgmUlMW1xz9kpmFmeobpmenpnunucTnHuEBeEp+JUZ+iJhFUhhglgppN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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwlmHl01NUVxx+QPZMEJjOZTGYmgJ6jKNgqxxWKWBd2basoi2vZPBZE1BYF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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4736855602511393, 0.37084448077756177`, 0.782802674684231], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHmQ1MUVx38I7M7MzgIZZnaO37hqUINXSlRAxChWEhAkWIokhogCyyVy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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHmUVNURxt8A0zM9NIvN6+nuecMY0SREIxERkUWEkxP2YNgSRZFl2Bw2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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5638207990352326, 0.5275653186496478, 0.909498656726387], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtl32QVWUdxx9edu9d7t3Cy733nHvPygzOVGADRBsKO2BvE2DmGGSQUsCu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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3uQlXMYx3/bYtucJWfP+75n3/cUmUExhJTK5i6hhkJSSbvJdCO3hC4r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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6300910720034462, 0.6340432153367682, 0.9110094978702362], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VmtsFFUUPqEVdllayMzs7DC7y+NHKSYqtgiaiNGArTVWMaBtQahQMLaI
INooRASj+IhaAiIUCQGqFjUiWx+JQuWhglolIgKJD9BAQHyRimKCGo3f53f9
cTNnzj33O+9z7/Cm+ZPm9TGzU1hFWNMzZgdCs/qE2ap+Zpvx3VFsdjpt9hNW
O3ifxmb7sXpTZg05sylYLSVmixLivXCe2RZgtPpmc3F2yQCzw0mzDcD/FRgT
PLP1wNmI/R2R2SbIVOBsE2T+gBFfJYXXDflzwKmDzFZi5s3GBGYnS81OAGcU
bP0R8vuh8wBWNXBKgXkQ/NNF8qPWly83AmNiJDu2w95wsNmXkL8koe8X0DUb
PrVgdQBrJs5OxdmJlMmajcaqgR+TgDEjkI/078VQPtKWpC97XgPGc7Hs+g12
nknL3ypgpCG/G3QFvrOAtRM4IfAG4X8m6D2g34JtA/uajQW9HDjvAmcTznTB
1mPQVY9zf4aK90Lsj4BcF2QK+B/r/GlEjCfTB/g1FzKDIdOZkr8FJzMP9q6D
3U3Fwif237D/Ddi5NJBtAWzpAdbC/mZH4cd90P2Es6XC2UOMO33h/AyZcZ7q
pAX652BlITcd+2dA3wW6DN+PYFNtsfJBHmvjLPgzINeK/xWw4SpPNcBzVZHk
mNsSX/n9GHTCxXwBvkn8L4NMZUJf1tIe8DtD+XsFMC7G2p6UP4zVvYjzEuwv
xSrDfzvtgu6HTD4djeXX8Ei5YV7qoacOax9rFvyGSDXLVTRA8ntj+Ukfe0Dv
wjqO+M+GbI2neC8G3qlYZ5aCV4+6PAz+EvD7ZhT/Q9AxFfutppoquLrqRV7K
07L/c/CafdXDN6CnOHtWZhRHxpC1xrwSczVkYth2ZbFisG2AcJqzsoM2tHiq
V9bqOsg/SR+gNwt+syd7DoD3GdYv4M/Bdxzkbwd/NHRVYnXDhi3gDw3Vmxey
jjzlugt7DdA9H/ZshczNOLvC1Esd0PkPctdbKl/J9+Hfgy5H/UD78O0HyLyJ
mTA+kGwSexsTmicjoH884lmAng7Inksr5sNwNpsR/rdpzSDK07+1zsfvU5pZ
tPM28O5wM6HXzUTWHvUfT8uGupzmAmcCc7Iho3h+B7o20hnqZ+5pQxr29rh+
Xw3ehlB9STvYW+zZDGQ88JsgMzJUbpgXziD6yTo8klZP8gxj3BUrzkNQGy+H
6k3O7iChHimHrstziv3vwJsRaq8N/JNpzTrm5+28fB+M2KyCzCjIXA/6gVg5
WwNen5z6n710S4n6hbXyeko5HQj5BZDLQ+Y6yNZiNZaollkXrJ+9KZ2nzfsg
OyySvytBP+30cgY3hrKN90Ol6+vDOPt+Uv31POId++I/DtlHsUYm1McjPNl2
ELybMq7mOIecbcddvunv+lCxY9w6QHfn1B/H3P1E/GbEoAq6RoF3A/Cq/6eR
r/ewdyLlZnFS/cVaG+6r3njncB5xFgX4PgId5cAdibOLYsWN9cd5z7Ocg5yd
rLfdiE1dqNyz31gLrLdq5jRSLFqxfzd9SAivPBAme/3ZWJgPg17m9DKH7aF8
Y13kPNUG71fawbjdj3OLY+X1GsjU5JRvxo2+Mv7s+7yn3mduCy6/9wB7kC97
1oFeGyp/j+Gb9l2OYPsYTz1CjEOhcL4uVc+R5r1FmnHmzGUO2TuXIbZ5X3cW
58dFnmZFOzCv9TRHCuB3ZTXjvITqiD071Nd5nt0MnWsizR7G8oNY8WSemWPq
7URPBIHsujVU/7B3poFeHgn7FZy7OlBtXsB3QaB3C3uddzxtfgp4bZw/blax
d9n3lOVbh/IR6O6MemEC7+1Y75sy6FkTK76sg4r+mgOskV5XJ7wDiE2cl/Ka
4+zLv0LdB7wLqsFr8/TmOQLMeaHmxBDOQhcT5uO/dx/oybDhw9j1Ce9zX/OK
8+OTjOLAe/XVWP28DXp3uvuO77td7o03K5Q+4j6D/UsDzYDz8W3M6K7jezNw
b07eM9MyqiXGgzORMekE/51I/jNPnCvM+9m0ZgH7lG8+4vHsv9UdjCg=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlslVUQho8W6K2lgL33fvf26y3KDygaEdn/YDSgSCIKQUILIkvdKJgC
2ihGFgMohghxgwIhQBOKW6XVGJVFQI0LiiJIjeIWDbibomCioMTn9f1+nOTM
ObOdmXdmTp+6eRMbzg8htLK6sH7PhrA2F0K3khA2FYdQSIfQVhnCzu4hDE+F
sDgOoX8mhHldQ6iFruX+ec46SkMYh4IZyGaiEPYj28H9CfQdZ/1cFMJ47ifB
/xT8b8M/BrqN/Q7WY9g+xFkJ97ci/3oXy7Sw38b6jPvPObsU20ega1LW/wKy
rbF17cLnp7nrjY5/kb2Ls1+wvRKfzsDbhE/vyHZsX9+C/xr0jcx7rzc8i/xF
ify38FSyH458G/JDWcPKQxgAvZ39k+hbAP1yVQidPfyGSdxl0TkriU89tmaz
BqKrGf1r2E9A51XQb0APIbbn0FEC71hifDf2T7Huge7NWoNvq/OOXTl0P3T3
g27D33bkq6GfqXK8lZNe6D6CDxNLLD8dXcWc/ZTEvwG6B/RvRY7xfeiajv2p
+L4KHa+hayfrO3Rv5iwF76zIssrHh/h/mHWS+23Y28P9qayx0oq997g7EFte
MT6Kf0OwsRt/pvK+0dgakjOvZGq4/z7rWHZyNhlbLfAMusAxUWz6wr8lZfoA
dHNkLC6EZwp3eXTU4UvPbs6VMKt75ayCu9tjx76F9YrenjUWnuN+LndzWHcG
87SzfzE2FoWpv5CfgP8d+L8E/yej/4a0c3uQNQJ6Hf4MYt/OGinfc9YtGyXs
T2Pvb2K3IuW7efBXpcwjLM2AzqSMqbHl1ildW5FvgG4lHyfA17JgrF5fIGdl
xuzDyJ4H/2L4+7Oq8G17ZOwLwwsiv1m2ZDMbuYZUO8JMhP5v8G9rF2NgH/r3
5x1rnWXgvS2J3xf4UID/k8jvb8f+XPYz0sZrJetB6Pq0/emrGoGeD72c/UDW
FvWHCufuXvI1DP2r0L+v1G8cBd2cxF811YR8Jf7VlTjGZeg6zVljyhienjPG
hK2jnM1Uf0D+/pTxuZn7JZzt7Wp7MfKbIte2cvIVvF+zjqG/jrP53J3NuH4U
rynEopZ415eZ5wrlOrI+8e9F9kb4j5ca86ux9w/3O7g/h/xDkWtEeK9mnVS8
4P+T/XzWYPT3TepZNaK3boRncMpvVq9YGLvW1TPG561DssJkP/JxZd69T/go
sK/OOzfqB8cU77RtT+NsFG+pRKYx2KZ6Rc+036o3X4vsgHLXvmxswPbGJD+y
/27smlAt/MjZhcJa7NpSj2vk7o+kH2iGaJZUpJ170e30u84K50IzZVFsn+Xr
S+j4VL0959pSD12aMWbEr5jX4P/kgnPbUWzsDM+4l8rHy/F9TNLP1Y+nIXtL
zvNCb96Td89Qr1CPUa4bI/dKvX818mvz7vWaOWW85ZHItaX4ZdOOqfY6uxr+
uryxsTsYu6PRebjUGC6PHCPFRj1qXMEzQ76phruhqyGdYKmre92XWfdi9bwU
9OOR46ca6sW+rtz9SvHRrH0gduxUz2egP4LuLHUNzEb3ozljUbSweTayr8Lo
2IJ7jLBzM/4cjZwD6ZYN9ZYlkWtZNS3bLVXuBbpfh621sbEhPI1L+w+g/qKY
jyAWgxJ8auZ/DG915NxphqhXrEziK/3rI79Zb1UNtMT+M6gXK6bqJRuS+hDP
q2BpaKVnp3L6Zuw/iWaPanI9dFPs9wkfF+NLn7x5lY9lwkfaWFdNqjb7J/6J
roV3EWdF3Z3jJyJjXFhWTsYgezCyLuV4Kfs7Mv5vKGaHYs9M4VU5mRN55nUm
/XJFZIwJT6rR3eRjV8F/Hc0w/XUuybi3KZ6K5XUF50oxXQfdxGouds/fh62b
Mq5N9SPN2uWRdasH9VEvSubDuSL7+msyD+WzcqOY6O2KwQ+xe57wqRgsJ/+X
Jf1NGNoKb3POs0rzZjK+1OSNNfFMKVhGvOqh+oul046N7H0A/X7OfwvNQP19
6iPHRjNlZtozRrR6/v+zJqlX3QsLC9KercLEf1rSf4Y=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6963613290729136, 0.7405210785522395, 0.9125202556162386], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmQmQ1MUVxv/ALjuzww7Dzs49y7JyeSC4nAlhY4lELSGoBFcNAkYNiAGM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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHuU1VUVx08ww8zcYWaY+7v3N/feucPAkocogshLMWqJ+CiEjMcgMRCi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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7626315263956404, 0.8469981755389198, 0.9140307641752249], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgmcFdWVxguk6eW9buAt9V5Vd7NDjMgqIuA4iqLGBUUIUSMa1BnRAQRB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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXeYlNUVxi9ld2dndynzzXw7ZXeRGhWpIoKJUbBEEBRQogmCgBE0gCgI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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8221467150771062, 0.8668449051258277, 0.8873680129794306], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmneUVUW2xg/Qt7vv7Xs73Ry6yZjGRBAQGJU0C5UgqAiOccw4qKjjPB1H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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXe0VFWWxu/j1Qv1Ur33ql7lKiSK2LaCgNAYSbMMgCJIi9qi7TQgKg6i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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8816619037585722, 0.8866916347127356, 0.8607052617836362], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFnHeYVdXVxi8wBWbu3DIzd2ZuFQULCIoKsSBgQQFNAiIaE+wN7A1Ro58m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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmnmA1vP2x79Ts9RsTz0zz8w8a6v2jZD2XSqUUqJkKy1okeReF5efipaL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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHecVdX19s+9d4Yyw9yZO4VhhrnXCiLYO4qCoDRRAUUFld5EpAUFaTH2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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHuU12Mex5/mUnPpNzN+l7n1+35zSemmOEJJ05q2pjamstiiiC6y1ClR
aaXtQrXIdlMphVhsylmLxrJnFRWHLi6DJeTotC4TsotU077e+94/Puf3PL/P
9fk8z+f2PeXaScMm5oQQ6luEkMfvkSiE19IhJFuG8HFJCJPjEG7I8B/7FgUh
jAJ/djKEx6FdCD6G9jH+28f6Jv47i3V3oC3C1iVC2JQNYTOwjfVW4AxwreC/
KD+Ey+H5jv1hoEdpCMXo+DwVws3sry4OoRSaC+FdiA2HwB8GPxJbRrO/qFUI
f2ffDdozgcnoW4P8JtaDq0O4F/6z4VkNfxv+G4Cukey/ZL0C2MO+G/suVSF0
BYrR9TUy1mPbpsoQ2heFUINPArqW8N9B9A2Afjr6P0TmMXR9xD6JrBTwJfQD
Id+DP/LhGQzuEmAp63HwvwT/MfYvgj8I/Q7052L/c6zv4sw/wn+Y/y7G9mnY
MzTfZ0iyTgGV7N/Hvufg/xyedsh6NDeEC1ifB6wDNw7+Pei7EXmj2c8sC+Ea
cKMj+34e/z2ErNvAN6Hva+BEmxBmc6b98j80Kzn7WmgOgksCHSu4f/hXIfsR
7n8fvBXYeCW2rea/DuA6Rr7Lxcg/zvp1bDynMIR+yOyLrJ346wCyVyBvEvZd
j74dnH06NKdDvwSZ98LbxH/nQXs+MAj64Zx5JPhnUn5rC/Re8OUbyJjM2Xbl
+m4uhGZCie9oKrhJyH8DWbch/3tkHc5adzk090F/FPpabDsA/VlJn1FnW4++
XPhPgM/AXwfNQfCv8d8E9I1B3z7Odj/yNmHfb8Af0VsATkV2FWeowjeVwErW
ucjLImse9v+A/jpo2lSbRriR+PBNZB9O+iw3o6MR/0fwDIJ2CzJOgvYzaPaC
i5Gxm/vaBfwb3DPYeKLKd6K7GFDst/kRcDzhN6pY/SMyC4ocs5cgaxjwmN4P
/H8oJ9bYN7DvjA+eZV3DGedh37norMGWO5DfH/k3AF3Z70ZmiqQxgv2n6NoP
5Ok9A7+EfwCwBnnrkb8f3knwrCxxjJWg70H2jewb8P9OaC/lvsrAjUNfBlw5
0Bf8ddg7D/xC8F8i7wvgM3QVc563c63zt+CmQDOj8P85Cn/tRecScAPxRxm0
d0AzG/xa4C18NzN27LZFZ0vWFUnnrov5bxe8x/FpBO4APr4JffXY3An8LPzZ
lf1l0Pdg34v9GPZjgS34bjs8X4H7tsJvbyY2NiNrd8p30x9YrlgC9mJfXb5z
QyUwLOEcMRpbx2PTNPi3cZ5t0L4ChFLH9FxwCzKOlY78N471jbFjaTv/5UDb
GZ3T8GVHdPRGd27ktXLyZ9i2H0hyf7Og75N1jlVulQ0xtAtTzhV6g8XQtq5w
7ulMPpyNrjno/LSlc7DeRgU8/Ur8Rlbj71VAmveWAarAVeoNBdP8DvpekXPV
RcAE5F2HvFda+szV4OYqf7V2zl7Lugf/XcP6Wt039GMzPmsDPj8/ckwrlseC
b6pwzCpWb0HeLeCnRK4lT4J/F1w9Mh7Fd8fheR/5b7Gfhb96gv8W2m8ivz3V
pMvRdQX4qchqQOcY6BORaYfnufa1TbtW/q8GQv+6cjDyTih+wZcBZxQ5p26B
9gD7DqV+Q39NOccpty0qse+m8d+/iuzDCeCuj1xbVoC/EvkjY5/tRewZCq4e
eBpdt4Efy/od+Afz1paW+Gx7gdvLfMZGcOMjy1JM3spbOZOYqMXfQ/DRooxj
TrH2FVDP23g+cm1aku9aMCSyLtWEJniXxa5t5fhzAeuTOeOeAtfszei7UjkQ
2vnA0+ynRr6LO4E3uY9O7K9g/QVnqMWeb9B5UolzQkf2nYBDhX6zUbVzpHKj
egTVLsW4Yls1TGe9OrIvdebdsWu8arti4j32H2NfAW95hXIq76Wtaga8q7C5
HesOyifs5+Df97ClEfiJ2DgCPAbucaAc3lrOOxx7ypA3It89UzryG9fbVg67
h/Ujlc7dzcCsjHO+cr1yzEvIfheaZdA2Jtw77E47F6mHGAp+SNa+34W+RdA+
yXmOIOtokXuHdcivKnIPcTL8cezY1pka4H0VHx/hvFPAt8fenez3oms8/nsA
fDp2b9QNnu/Yt0u5VqaAPuB+ASwH/wD4b8GXg/8+13f0MOddD1yFfR+w34ht
fwYagm18GPqNnPkE/C8kXDt0Zp1VNURvvQH6omK/+T7I6g1syHNNH4ruPsrf
pa5Zdaz78V+G+16HPb9mPSTjWtgM/YfKVVnf1UpsPAv82cDcUvugI++1Uxv3
XgOweTr6H0T/pfnuIRPljgG9/efx9zpwM6D5qsg93uXIuizjXKCc34C++ehb
jb5a5DeC35Z2L7uUO26XdE1VLVUOnJC1j+XbGQn3Mm9mnCvU07Tk7HnyAftu
0MxMuWdTr3YIeAfeHO5wEP76D/znw18L/yr0rS5wb/dQ5LtQj3cV+BEZ54oA
vjWyElV+C0ex9z7Wi3k/rYrcI/wMb3Pk3i0Nz7XwfsAZmls5Rx9F/4/sXy5y
z6Ne9HnOe3qpe9Kt7Gewb1HqmrUn5Rqo2lcH/Ax/z5R7pdnIux3/zapw75XN
ce5UDVXtVA4dx35M7Fr4cql7yVBtWeopd4D7HPrR0I+BfkjsHke9jXJ8H3Cj
4JmU8Ju8gvMMj+2LF6BJIKs1UIEvhhZ7VnmqyrGlmSWV9EyhWUI96dsp51jl
VvXAS6Adm3It2KgzIKu62r3dqGLHZlG1ZStG28eeETQbKMe8lXLPol5Fd1qD
fXXQrAU3v9Rvv4viudQxsBT69pFzpXrmaZrP0tb9Afhjke9Qd6ce95s2ztHK
zc3k+DOh7xp7tpHMJs57D2doxLYSzvS1ch1n3sA+wX4z9i/kv/UJ17Be8PYG
7tNshY4p2Hdr7F54N/v1yLoL+rUJx4xy59SMbVMOVW/dIvYspR77QNI9oHo/
3eE1rEfFnu3Ukw6M3VOql5RP6vBVXtqx+xfONB7ZE2PPppophmX8JvQWjuGf
01ifEvutTYW/JuWap1p3ep57izXqN0rcY2zAnkVZx9p4fDSZ8/+Ude+nGiRf
5UeOTflMs8HOjHVpRrg/co+n3k4zpmLj5ArHpmIksO+sGEh4BpwP/6AK61KP
OxFZ/8SGE608wzSRj66KXDv1RhcnPaNpNmtC3EmqPdXupVWDtiNrA/L/hvzN
0HeOPKNpNlON/aHCOVK5UT1xA/ynxvbNGcrx+OKcyLlvDTzL2HdhP7zEPbBm
074p+04z6gVVnjk1a2om+T32P8C+eyv3iFvTzonKhT8GzzKrk+4lNdO8AP+W
KutSDViJrsJy36165Gbebsh6NpXMkaynp53rFdPqLdRTqJdQj6HeUTOXZi31
kE+g77WMa7VmhH6se/LfxELnTN1Fl6x7ed2Jvk2oJ1AvoG8UmvVW6htGwjNf
b3BjY+eiZ6H5U+z/tFZPsJn9JuA7zd/YsCvjGUmzUVTm3ign9mypHkm926WR
adXDdY+dAxT7qlk98M05Vc6NytHKrZur3Esox+7Q94O0Zw/VxKfg3xg7FkOJ
7255yrOa7lC1+LRy9xKqyYrtBVl/q1GMf8/5P8maVzPWo8qHSb8lzbD1uvvY
vZFq1CNZ13jVdr05favoUO3eQt8sClgXVnsWOBz8beBQG+cifSM4D3k3VHkW
S2pmrnaNU21TD1uDrv4Z9x6L2X+Sdg+n3k0z6lzpTnsWWqUchewOQDrH33BG
KDdlnOvVw6vW11dblmp+Et567m9HgXuYX0E/EPqHWzoGWyf9zUjfitQjX6h8
lHHu0xu6IPZMoVlCOXFN1j2Veqka8Dkp51jl1l7Ysx3fv1ruWCiCZhW4rei/
v4Xf2D3s784aJ5vmsH4o6d5COblv7JlIs5B6snWRv5noW4lmavVOfSPP6uqh
NGsoxhXbmjlUu5XjldtVw+dl7UP5Tj2McvedWX9LUw5/UG8j67N0x6ZPsX1/
udfqoWuVyzPuxdQj9I/9TUHfEvQN4An0vV7ps+uM52qeLfdbUM7Vt6uekWc3
fcPah65nKvxtS98wXob2H+XOdfqmMghdg9FRWeg7GgfvuSm/HfXQir2nY8ea
YnAn+Ls5/xv55hmP/Ouznh31338Bx0XwqA==
         "],
         VertexColors->None]}]}}, {{}, 
     {Dashing[{Small, Small}], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV03loz2EcwPGHmDSWmzlmjp22YWHuyTmF2aQQc4SyHJFtSpirlORmSzn+
oMRGTdjwj5ApY8pRbjlK/KWYI7y+f7z3/j7P87m+z/e3PkvWFK5uFkKI9+dO
hxDaxIfQFrGo7RnCbXvnuoZwiwcnhJCNQcjtHEIeT8UkTMFk7O4SwkJehCIs
ELeY53M5b+MtvJWPcR3/7WEAvf5xuXW7bmL4u77P8czZUzzBevtl8oo7hXDA
jMs6hhDXK4Sl3Jaf8SPnjVhofcl6AddwEWd7j/3q74uQv5eH8hA0Otuk32bM
U/+KGoPtpVkXy52JAuRjFgpxQUw1LqLBbG/M+BbvEKv2N/mvPb9ClZjzWCuu
hNdxKb/U66jzClTipn5n5d2TX48GMc3N/9XZHnO21DcGLaJZ7CdF30St/pyC
ZDxUsyU/4Bjuqt4yJFifkdebf3I9N/Fdntvd3fMcbs/zOM73PO78BHL0H46O
6ny1nuZ8OsrMNM4cJTyW13Mul3KWb/pG/zZyPss5gqM4jEpUoLUeeeq00HMK
p8lJxzXrj86v8ycOPED/DGRitpp57uqq/Q/Oa7mvXv3QBwPdyS9xI8zyk//g
N37I+8JNXGDGbZ5Pea5Va6fnHdiOOvW2q7NLnSzrGDFJ+hxQrz8f5GS+bz+d
ByAFaUhFq+i+1eytRiISkKXWO3tv0RD9tvRPx1rfuUmPlViFfHdySP2M6K44
kx+Iv+HssfVy62G8Qm4OF/Mjd7ZRjw16PBf3Ai9Ro9dl7/JezhVOjGbCcLET
xObwRB7B43lM9D/NI3k0RuGx3vk8EzNQiAKMFZcRvRcycULcabVPcrV3qkKq
uVLwAv8BFoGdgg==
         "]],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV00dsz2Ecx/GnREKrSveOhnCwxa6ui4OD1jhZwcFIhMRWEgdFWxpCBR26
SIzy51Dr1KURB3WqG61wpDjar9/h/f88z3c/v+f5F+zYv25fXAgh3s+r5BBm
ZIcwEylZISRjCvpSQpiYEUICkvkaxH3M57PuyAyhjj8m7nhqCL15IfSjD/V8
V9n38r8VX2j9JieEQZSnhbCerYJuoMfkbskNYSuK1V+oV2V6CPfldOIeatV5
QGNiHmK7HtvQqs9d9hr+fPs8DLHlme+z2jH1DrJ94j9AD+MQHtlvojG6mX7R
b6KcRCQgHi3qnON/wv8U5fpWYC2OqDtNTqcztNt34BYGzP6A77b1HXNVyc+V
e5pm0xw08KWarZE2oU9OC72JZgz7HiNqD+O99TuxH2gxStBlP12PJHll6mUi
Cxk4pU8JLcVKFKMIl8UHeXH4Zz+WjsFU9appDYqi749MsTtxha0eX9zZKL7i
tfg/8v/iJ37jFy6JX0aXYykKsQInzZNK05EWzSlukrlHrb/hK37gO3rU7sOQ
nr30pfMPoNv6vLkuoA7l0Vtka5XTjjZU6tPme5+g7dF7ie5Dr9Viz0Tnc09V
tJYmqrmRb5G8RvHPxL/Acxy1v+HeG9CICd7BePTLWSK+iX8xbaal6pWhGKvU
LaFrxJbjplrHxDSp8ch6rpx5OGuuc2iN/jP8LTSFPRmTzFRg3t3We7Aresti
9tMRuo8O0zlyZmNQv1l0THSf0X3zxdHHbPPpAlTrVYOYOZLsJ2NKdA4xzbjO
flHfcWbudsYeXFOniz2TLQs5yEYu/gMAtpaO
         "]],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5069, 6652, 5070, 6653, 7126, 5502, 7885, 4850, 6133, 4849, 
         7884, 5581, 5084, 5485, 7882, 4843, 6128, 5484, 7796, 5487, 7795, 
         5486, 4826, 7755, 5449, 7754, 5450, 7756, 5259, 7624, 5260, 7270, 
         7271, 7272, 5952, 7787, 5477, 7786, 5478, 7788, 5476, 7791, 5480, 
         7789, 5479, 7790, 4842, 7793, 5482, 7792, 5483, 7794, 5481, 7849, 
         5577, 7846, 7848, 7847, 5948, 7781, 7782, 7780, 5473, 7783, 5472, 
         7785, 5475, 7784, 5474, 4825, 7747, 5447, 7746, 5448, 7748, 5254, 
         7623, 5255, 7267, 7268, 7269, 5951, 7766, 5461, 7765, 5462, 7767, 
         5460, 7770, 5464, 7768, 5463, 7769, 4838, 7772, 5466, 7771, 5467, 
         7773, 5465, 6125, 4839, 7881, 5576, 5083, 5458, 7879, 4836, 6124, 
         4837, 7880, 5459, 7120, 6467, 7407, 7408, 4886, 7406, 7260}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5073, 6657, 5074, 6658, 7380, 6659, 5076, 7525, 5075, 7918, 
         6679, 5085, 6655, 5071, 6654, 5072, 6656, 7368, 6464, 7410, 7411, 
         4900, 7409, 7273}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {Dashing[{Small, Small}], 
      TagBox[
       TooltipBox[
        LineBox[{4609, 6068, 6069, 5532, 6071, 6070, 5261, 6949, 6950, 6946, 
         6948, 6947, 4608, 7197, 7198, 6943, 6945, 6944, 5299, 6942, 5301, 
         6940, 5300, 6941, 7196, 7195, 7921, 5297, 7651, 5298, 6939, 5294, 
         6937, 5296, 6936, 5295, 5593, 5592, 6934, 5292, 6314, 6315, 6316, 
         6065, 7297, 7296, 6313, 6933, 6932, 5591, 7649, 7650, 7294, 7295, 
         4766, 6064, 4765, 6718, 6719, 6717, 5115, 5636, 5635, 6072, 4917, 
         5821, 5959, 5958, 4690, 5634, 5114, 6714, 6716, 6715, 7210, 4613, 
         7902, 7903, 7901, 6513, 6510, 6512, 6511, 7209, 7208, 7564, 7565, 
         7207, 7859, 7206, 6724, 6259, 4920, 6509, 6723, 6722, 4692, 7205, 
         7204, 7203, 5119, 7563, 4923, 6726, 5122, 6725, 5121, 5639, 5638, 
         5640, 7216, 7572, 5123, 7919, 7215, 4925, 7580, 5129, 7578, 5128, 
         7579, 4697, 4619, 7218, 6526, 4931, 6268, 6269, 6742, 6743, 6739, 
         5135, 7581, 6740, 6741, 6533, 6535, 6534, 6768, 6977, 4639, 6187, 
         6186, 5169, 5656, 4716, 4640, 6188, 5855, 4947, 6081, 5660, 5661, 
         6198, 7174, 7175, 6001, 6000, 4779, 6085, 4780, 7329, 7328, 7703, 
         7702, 4868, 7159, 7160, 6352, 6353, 6354, 6093, 7335, 7334, 6355, 
         5365, 7012, 4874, 5732, 5558, 7163, 5559, 7164, 5379, 7030, 5381, 
         7028, 5380, 7029, 5491, 7857, 5584, 7399, 7400, 7401, 6137, 7403, 
         7402, 6480, 5511, 7131, 7916, 4854, 7915, 6623, 7914, 6624, 6620, 
         6622, 6621, 7727, 7110, 7111, 7078, 7080, 7079, 5273, 7084, 7085, 
         7081, 7083, 7082, 7086}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4677, 4748, 5684, 5082, 6460, 6461, 4819, 5941, 4820, 6636, 
         6637, 6635, 5056, 7522, 5772, 5773, 5048, 6385, 6670, 6671, 5081, 
         6672, 4796, 6383, 5755, 4882, 6108, 5610, 6911, 6912, 6910, 5269, 
         7633, 6025, 6026, 5283, 6921, 6923, 6922, 4659, 4733, 7842, 7843, 
         7172, 5570, 6116, 6115, 7362, 7361, 7360, 7721, 7720, 6357, 6356, 
         5038, 6608, 4869, 6087, 4870, 5723, 5266, 6909, 6842, 6843, 6210, 
         6211, 4650, 5864, 6002, 6920, 5281, 6919, 5282, 7698, 7699, 7695, 
         7697, 7696, 4756, 6140, 5520, 6157, 5521, 6141, 7687, 7236, 7929, 
         5522, 7821, 7237, 7238, 4717, 7830, 5546, 7154, 5547, 7155, 5329, 
         6980, 5331, 6978, 5330, 6979, 4755, 6138, 5517, 6156, 5518, 6139, 
         7684, 7231, 7928, 5519, 7820, 7232, 7233, 4711, 7829, 5544, 7152, 
         5545, 7153, 5323, 6971, 5325, 6969, 5324, 6970, 4753, 7668, 7669, 
         7667, 7671, 7670, 5278, 6915, 5277, 7639, 4634, 5838, 6748, 6749, 
         6747, 6751, 6750, 6903, 5264, 5719, 4863, 5961, 5598, 6587, 5022, 
         6331, 7133, 7181, 7182, 7184, 7183, 5709, 5710, 5568, 7840, 5569, 
         7841, 5516, 7814, 7815, 7219, 4621, 4699, 7659, 6959, 6960, 7638, 
         7637, 5276, 5964, 7871, 5963, 6898, 5262, 6897, 6900, 6899, 4857, 
         6074, 4858, 5712, 6320, 4770, 6660, 5079, 6324, 6323, 6321, 5014, 
         5594, 7864, 4624, 6579, 5016, 6578, 6581, 6580, 4816, 5923, 6730, 
         6731, 6729, 5125, 5642, 4694, 5922}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4682, 5689, 5688, 6650, 5067, 6433, 6435, 6436, 5097, 6698, 
         6697, 6440, 5068, 6651, 5694, 6633, 5053, 6403, 6404, 4803, 7115, 
         6892, 6893, 6891, 6895, 6894, 5683, 6629, 6630, 6400, 6401, 4801, 
         6693, 4802, 7876, 6692, 6402, 6632, 6631, 5692, 6618, 6619, 6381, 
         6382, 4795, 7114, 6883, 6884, 6882, 6886, 6885, 5679, 6615, 6616, 
         6378, 6379, 4793, 6687, 4794, 7875, 6686, 6380, 5047, 6617, 5691, 
         6614, 5042, 6367, 6373, 6374, 5457, 6870, 5223, 6370, 5224, 6871, 
         6290, 6291, 5751}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5567, 6153, 6112, 7365, 7364, 7363, 5440, 7733, 4982, 7757, 
         5451, 7369, 7370, 7371, 6120, 6466, 6465}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, 
     {Dashing[{Small, Small}], 
      TagBox[
       TooltipBox[
        LineBox[{4626, 5595, 5017, 6327, 6329, 6330, 6663, 6662, 4771, 6326, 
         5714, 4860, 5924, 4859, 6901, 6902, 6322, 5263, 5965, 5131, 6957, 
         5309, 6955, 7657, 7656, 7865, 4700, 4623, 7278, 7220, 6262, 6167, 
         5130, 6736, 7938, 7939, 5831, 7943, 7933, 6171, 6754, 7588, 7587, 
         6755, 5515, 6055, 6054, 5970, 7872, 5971, 5311, 6961, 5310, 7660, 
         7867, 7866, 4704, 4628, 7279, 7225, 6270, 6170, 6753, 6752, 4939, 
         6770, 5154, 7591, 5153, 7893, 7281, 7282, 6278, 6905, 6904, 5156, 
         6076, 5155, 5979, 5848, 7941, 7942, 7931, 6189, 6793, 5170, 7595, 
         7594, 7819, 7818, 5265, 5993, 5172, 6077, 5171, 5992, 5858, 7936, 
         7937, 7922, 7924, 7923, 6815, 5184, 6907, 7869, 6908, 6906, 7241, 
         6284, 6283, 6200, 5185, 6816, 4951, 6844, 6845, 6840, 7284, 7283, 
         4727, 4651, 7015, 5366, 7013, 5367, 6016, 6015, 6056, 6057, 6017, 
         5214, 6117, 5213, 5879, 4966, 6873, 5227, 7615, 7616, 7288, 7287, 
         4738, 4664, 7053, 7054, 7051, 5400, 7055, 5242, 6041, 5272, 6384, 
         6914, 6913, 5616, 5940, 4888, 5774, 6414, 4807, 6677, 6678, 6676, 
         6675, 6416, 5058, 5795, 5794}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4898, 5945, 4899, 5808, 4981, 7094, 5421, 6434, 6437, 6438, 
         6050, 6896, 5257, 6439, 5258, 5917, 5916, 7072, 5410, 7071, 5411, 
         7073, 5409, 7076, 5413, 7075, 5412, 7709, 5898, 7068, 5406, 7066, 
         5407, 7069, 5251, 6890, 5253, 6246, 6248, 6249, 5912, 7046, 5396, 
         7045, 5397, 7047, 5395, 7050, 5399, 7049, 5398, 7706, 5890, 7042, 
         5392, 7040, 5393, 7043, 5237, 6881, 5239, 6238, 6240, 6241, 5910, 
         5911, 5376, 6368, 7340, 7341, 6100, 6372, 6371, 6369, 5377, 7026, 
         4961, 5753, 4881, 5934, 5608}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5531, 6061, 5275, 6111, 5274, 6060, 6058, 6410, 6409, 6406, 
         5414, 7077, 5615, 6548, 4971, 6478, 4970, 6547, 5510, 6477, 6476, 
         6473, 5508, 7129, 6228, 6229, 4737, 7027, 5674, 5378, 5878, 7162, 
         5877, 4656, 4732, 5670, 5364, 5868, 5867, 4649, 4725, 5666, 5352, 
         5863, 5862, 4643, 4720, 7600, 7601, 6813, 5179, 5854, 5853, 6792, 
         6539, 6540, 6280, 6538, 6537, 6767, 5149, 6532, 4938, 6275, 4937, 
         6531, 5133, 6737, 5134, 6738, 6267, 6266, 4930, 6525, 7217, 4618, 
         4696, 5644, 5127, 6163, 6164, 6165, 5827, 7568, 7569, 7567, 7571, 
         7570, 6261, 6260, 6515, 6514, 4611, 4691, 6720, 6507, 6508, 6258, 
         6721, 7561, 7562, 7201, 7202, 4612, 5823, 6712, 5111, 6711, 5112, 
         5633, 4689, 6709, 6710, 6498, 4914, 6256, 6713, 7191, 7891, 5113, 
         7559, 7192, 6499, 7930, 4915, 6253, 4916, 6500, 7193, 7194, 6501, 
         6502, 6255, 6504, 7275, 6503, 4607, 5819, 5820, 5106, 6162, 7187, 
         4604, 4685, 5953, 5811, 5812, 5290, 5627, 4686, 5955, 5813, 5814, 
         5291, 5628, 4687, 5956, 5815, 6935, 5816, 5293, 5629, 6938, 4688, 
         5957, 5107, 5817, 4912, 6066, 5630, 5631, 5108, 6931, 5288, 6309, 
         6311, 6312, 6052, 6063, 5289, 6119, 7648, 7647, 7646, 5540, 7825, 
         5543}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {Dashing[{Small, Small}], 
      TagBox[
       TooltipBox[
        LineBox[{4663, 5609, 5041, 5752, 6365, 6366, 5730, 4788, 5740, 5741, 
         5375, 5736, 5735, 4736, 4662, 6239, 5607, 5238, 5750, 7041, 5749, 
         4792, 5761, 7048, 5762, 5394, 5757, 7044, 5756, 4741, 4669, 6247, 
         5614, 5252, 5770, 7067, 5769, 4800, 5780, 7074, 5781, 5408, 5776, 
         7070, 5775, 4747, 4676, 5621, 5256, 5789, 5787, 4812, 5800, 6432, 
         6431, 5809, 5066, 5807, 5806}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4844, 7381, 7926, 5441, 7734, 7366, 7367, 6118, 7826, 5541, 
         7147, 5542, 7148, 5287, 6930, 6929, 6310, 5286, 6928, 6927, 6497, 
         4911, 6495, 4910, 6496, 7190, 6494, 4909, 6492, 4908, 6493, 7189, 
         6491, 4907, 6489, 4906, 6490, 7188, 6488, 4905, 6486, 4904, 6487, 
         7186, 7185, 5105, 7554, 5626, 5954, 4903, 5810, 5104, 6708, 6707, 
         6254, 4902, 6485, 5103, 6706, 6705, 6252, 4901, 6484, 5102, 6704, 
         4684, 7274, 6703, 6251, 6483, 6482, 6702, 4683, 5625, 5101, 7552, 
         5100, 7553, 5818, 4606, 7414, 7415, 7412, 4913, 7413, 4605, 7858, 
         5109, 5632, 7558, 5110, 7555, 7557, 7556, 5822, 4610, 7200, 7199, 
         5116, 7560, 5637, 5118, 7892, 5117, 7422, 4922, 7421, 7424, 7423, 
         7566, 5826, 4616, 7860, 5126, 5643, 4695, 4617, 6523, 6524, 6264, 
         6265, 4703, 7222, 7221, 6530, 4936, 6274, 6276, 6277, 7228, 6536, 
         4942, 6279, 6281, 6282, 7235, 5852, 4946, 5999, 5659, 7603, 5181, 
         7602, 5180, 6814, 7431, 4949, 7432, 4950, 6542, 5197, 6839, 7433, 
         4955, 7434, 4956, 6543, 5209, 6860, 7435, 4962, 7436, 4963, 6545, 
         5225, 7176, 5583, 6472, 6474, 6475, 6136, 7398, 7397, 6479, 5509, 
         7130, 4887, 6634, 5054, 6405, 6407, 6408, 5055, 7839, 5566, 7837, 
         5565, 7838, 5572, 5574, 7900, 5573, 6154, 5437, 7897, 5588, 5571}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4861, 6521, 6522, 6328, 4929, 6520, 5716, 5717, 5018, 6582, 
         7475, 7474, 5713, 4701, 4625, 6168, 5837, 5132, 5835, 6956, 5834, 
         6175, 6174, 6166, 6759, 6758, 5647, 5973, 4932, 7932, 5832, 5969, 
         7868, 5968, 7905, 4705, 7280, 7226, 6272, 6271, 6173, 5139, 5840, 
         6962, 5839, 6180, 6179, 6169, 5157, 6771, 5651, 6774, 6775, 6769, 
         6773, 6772, 5849, 4641, 6191, 6190, 6797, 6796, 5657, 6802, 6803, 
         6799, 6801, 6800, 5859, 4645, 6202, 6201, 6820, 6819, 5662, 6825, 
         6826, 6822, 6824, 7870, 6823, 5865, 4652, 7242, 6212, 6199, 6849, 
         6848, 5668, 6852, 5200, 6841, 5199, 6851, 5870, 7014, 5871, 5212, 
         7613, 5211, 7612, 7285, 7286, 4734, 4660, 6222, 5881, 4967, 6027, 
         5675, 6875, 6876, 6872, 5229, 6874, 5891, 7052, 5892, 5243, 5893, 
         6040, 6039, 4742, 4671, 6640, 6641, 6638, 5057, 5792, 5791, 6550, 
         4978, 6415, 6552, 6551, 5622}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {Dashing[{Small, Small}], 
      TagBox[
       TooltipBox[
        LineBox[{4678, 4749, 6293, 5790, 4891, 5942, 4892, 7087, 7088, 6639, 
         5415, 6046, 5246, 5894, 4974, 6042, 4973, 6877, 6878, 6233, 7256, 
         7257, 4739, 5676, 5228, 5880, 6230, 6231, 5882, 6862, 6863, 6861, 
         6865, 6864, 5671, 6018, 4957, 5873, 6213, 4653, 4728, 7608, 7609, 
         6846, 5198, 6850, 4952, 6827, 5188, 6204, 7243, 7244, 4721, 7604, 
         5186, 6817, 5187, 6821, 4948, 6804, 5175, 6193, 7239, 7240, 4718, 
         7596, 5173, 6794, 5174, 6798, 4944, 6776, 5158, 6182, 7234, 4635, 
         4712, 5980, 5981, 5841, 4940, 5983, 5652, 6779, 6780, 6172, 6183, 
         7227, 4636, 5843, 5972, 5141, 5833, 5142, 5648, 4706, 7589, 5140, 
         6756, 6761, 6760, 4933, 5966, 4934, 5836, 6176, 6177, 5316, 6583, 
         6964, 6963, 4862, 5925, 5596, 5597, 6263, 4702, 5715}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4681, 6295, 6294, 5798, 4893, 5944, 4895, 5801, 6430, 5788, 
         4890, 6051, 5620, 5897, 4977, 5785, 4976, 5779, 4889, 6037, 5617, 
         5619, 5052, 5765, 4884, 6106, 4885, 5767, 4969, 5760, 4883, 6023, 
         5611, 5613, 5046, 5745, 4879, 6098, 4880, 5747, 4959, 5739, 4960, 
         5876, 4877, 6099, 4878, 5742, 6364, 5731, 4873, 5935, 5604, 5605, 
         6285, 6286, 5724}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {Dashing[{Small, Small}], 
      TagBox[
       TooltipBox[
        LineBox[{4630, 5599, 5023, 6333, 6335, 6336, 5718, 4773, 6332, 5977, 
         5144, 6075, 5143, 5650, 5649, 6764, 5145, 6757, 6763, 6762, 6972, 
         4637, 5844, 5846, 5975, 5974, 4941, 6781, 5160, 6777, 5159, 7592, 
         4713, 6981, 5653, 5162, 5842, 5161, 5982, 5332, 6195, 6194, 6181, 
         6806, 6805, 5658, 6809, 6810, 6795, 6808, 6807, 6988, 4646, 6205, 
         6192, 6829, 6828, 5663, 6832, 6833, 6818, 6831, 6830, 6997, 4654, 
         6214, 6203, 6854, 6853, 5669, 6856, 6857, 6847, 5203, 6855, 5368, 
         6224, 6223, 5872, 5215, 5672, 7016, 4735, 7255, 7254, 6226, 5216, 
         6866, 4968, 6028, 6029, 5884, 5883, 6033, 7056, 4672, 6242, 6232, 
         5244, 6887, 5680, 5681, 6243, 7091, 5247, 6047, 6420, 4809, 5793, 
         7355, 7354, 6422, 5060, 5797, 5796}],
        RowBox[{"-", "0.2`"}]],
       Annotation[#, -0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4896, 5915, 4897, 5804, 4980, 5799, 4894, 6048, 6049, 5624, 
         6244, 4680, 5943, 5782, 7170, 5783, 5403, 5786, 5784, 5896, 5777, 
         5778, 5236, 5618, 4675, 5939, 5763, 5764, 5389, 5768, 5766, 5889, 
         5758, 5759, 5222, 5612, 4668, 5937, 5743, 5744, 5371, 5748, 5746, 
         5875, 5737, 5738, 5207, 5606, 6220, 4661, 5933, 5727, 7157, 5728, 
         6091, 6090, 4872, 5729, 4954, 5726, 4871, 5907, 5602}],
        RowBox[{"-", "0.2`"}]],
       Annotation[#, -0.2, "Tooltip"]& ]}, 
     {Dashing[{Small, Small}], 
      TagBox[
       TooltipBox[
        LineBox[{4655, 5603, 4998, 5725, 6302, 4760, 6600, 4759, 7008, 7009, 
         7007, 7011, 7010, 5363, 7158, 5554, 7156, 5553, 7833, 4731, 7253, 
         7252, 6221, 5526, 7137, 5208, 6012, 6451, 6446, 5427, 7097, 5697, 
         7025, 5374, 6363, 7338, 7339, 6097, 6362, 6361, 6360, 5557, 7161, 
         5673, 7142, 5527, 7139, 7141, 7140, 6024, 4818, 6455, 6454, 7104, 
         7103, 5700, 7038, 7039, 6377, 7349, 4791, 6105, 4790, 6376, 6375, 
         5561, 7165, 5678, 7145, 5529, 7143, 5528, 7144, 6038, 6458, 6457, 
         6456, 5436, 7109, 5705, 7062, 5405, 6396, 7352, 6109, 5402, 7171, 
         5564, 7169, 5563, 7836, 4746, 7266, 7265, 6245, 5530, 7146, 5250, 
         7064, 7065, 7063, 7708, 7707, 4763, 6647, 4764, 6308, 5805, 5009, 
         5803, 5802}],
        RowBox[{"-", "0.4`"}]],
       Annotation[#, -0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4864, 6528, 6529, 6334, 4935, 6527, 5318, 6967, 5319, 6968, 
         5317, 6563, 6966, 6965, 5976, 4707, 4629, 6178, 5165, 6786, 5146, 
         5978, 7311, 6338, 6974, 6973, 6184, 5845, 5163, 5988, 5654, 6784, 
         6785, 6778, 6783, 6782, 6916, 4642, 7688, 7689, 6982, 5333, 5985, 
         5984, 4776, 5995, 5996, 5334, 6079, 5176, 5994, 4719, 6197, 6196, 
         6834, 5177, 5997, 6347, 6004, 5190, 6084, 5189, 6003, 4722, 6207, 
         6206, 6858, 5191, 6005, 6350, 6007, 5202, 6088, 5201, 6006, 4729, 
         6216, 6215, 6867, 5217, 6009, 6008, 4784, 6019, 6020, 5369, 7017, 
         7019, 7018, 5733, 6924, 4665, 6234, 6225, 6880, 6879, 5677, 6034, 
         5232, 5885, 5231, 7057, 7058, 6386, 6388, 6045, 5245, 6129, 5493, 
         6044, 7898, 6043, 4743, 4673, 7089, 7090, 7128, 7127, 5416, 7093, 
         5418, 7092, 5417, 6553, 4979, 6421, 6555, 6554, 5623}],
        RowBox[{"-", "0.4`"}]],
       Annotation[#, -0.4, "Tooltip"]& ]}, 
     {Dashing[{Small, Small}], 
      TagBox[
       TooltipBox[
        LineBox[{4679, 4750, 5685, 5061, 6423, 6424, 6425, 5093, 6696, 4810, 
         5706, 5507, 7395, 7396, 4853, 6135, 4852, 6470, 6471, 7801, 7800, 
         7385, 7386, 6130, 6131, 5495, 7121, 5494, 7802, 5895, 7059, 7060, 
         6390, 6389, 6387, 5401, 6235, 4666, 4740, 6030, 7925, 6031, 6102, 
         6101, 5230, 6032, 6306, 6305, 6926, 6925, 4875, 6094, 4876, 5734, 
         4958, 7020, 7021, 6359, 7336, 7337, 6021, 7614, 5218, 6868, 5219, 
         6869, 5000, 5909, 5356, 7001, 5357, 7002, 5355, 7004, 5359, 7003, 
         5358, 7704, 5866, 6999, 5353, 6998, 5354, 7000, 5204, 6859, 5205, 
         6217, 6218, 6219, 5905, 6993, 5348, 6992, 5349, 6994, 5347, 6996, 
         5351, 6995, 5350, 7701, 5860, 6990, 5345, 6989, 5346, 6991, 5192, 
         6835, 5193, 6208, 6209, 5904, 4994, 6983, 5335, 6341, 7314, 7315, 
         6080, 6344, 6343, 6342, 6985, 6984, 4945, 5722, 4867, 6078, 5600, 
         6917, 6918, 6301, 7289, 5989, 5164, 6811, 6812, 6185, 4638, 4714, 
         5986, 5987, 5326, 6337, 6339, 6340, 6976, 6975, 5847, 7124, 5497, 
         7123, 5498, 5991, 5990, 7593, 5166, 6787, 6789, 6788, 4989, 6564, 
         4990, 6565, 7116, 7907, 4774, 7310, 7927, 5452, 6766, 7934, 5147, 
         6765, 5148, 6273, 7940, 4708, 5720}],
        RowBox[{"-", "0.6`"}]],
       Annotation[#, -0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5029, 5665, 5664, 6838, 5196, 6836, 5195, 6837, 5908, 4778, 
         6349, 6348, 6602, 6601, 5690, 6092, 4997, 5906, 6011, 6010, 7113, 
         4782, 7873, 7112, 6351, 6607, 6606, 4953, 7096, 5426, 6448, 6449, 
         6450, 6089, 7359, 7358, 6447, 5425, 7095, 5037, 5928, 6227, 7136, 
         5221, 6022, 5206, 7024, 5373, 7022, 5372, 7023, 5874, 7722, 5430, 
         7101, 5431, 7102, 5370, 7100, 5429, 7098, 5428, 7099, 5932, 6237, 
         6236, 7138, 5235, 6036, 5220, 7037, 5391, 7035, 5390, 7036, 5888, 
         7723, 5434, 7107, 5435, 7108, 5385, 7106, 5433, 7105, 5432, 5936, 
         5045, 6889, 5249, 6395, 5248, 6888, 6035, 7351, 7350, 6394, 5404, 
         7061, 4975, 6627, 6628, 6398, 6399, 4799, 6691, 4798, 6397, 5913, 
         5008, 6110, 5693, 6648, 6649, 6429, 7356, 4811, 5914, 6428, 6427, 
         6426, 5062, 6642, 5686, 5687, 6250}],
        RowBox[{"-", "0.6`"}]],
       Annotation[#, -0.6, "Tooltip"]& ]}, 
     {Dashing[{Small, Small}], 
      TagBox[
       TooltipBox[
        LineBox[{4823, 7877, 5087, 5086, 7531, 7533, 7532, 5031, 7500, 5030, 
         7501, 5861, 7502, 5032, 6597, 6599, 7912, 6598, 7913, 4832, 7374, 
         7375, 7173, 7845, 7844, 5534, 7822, 5533, 7823, 5535, 4724, 4648, 
         7862, 5525, 5488, 6142, 5524, 7177, 5523, 7135, 4822, 7911, 7134, 
         6596, 5028, 7499, 5027, 7917, 7290, 7291, 7006, 5360, 7005, 5361, 
         5550, 7899, 5549, 5696, 5695, 6158, 5536, 6143, 5537, 7627, 5268, 
         7625, 5267, 7626, 5362, 7832, 5552, 7831, 5551, 6151, 7643, 7642, 
         7641, 5585, 6148, 6147, 6095, 6096, 5590, 5699, 4786, 6152, 4785, 
         5698, 5589, 6145, 6144, 7824, 7631, 7632, 7628, 7630, 7629, 7705, 
         4787, 7874, 5556, 5555, 7180, 5587, 7178, 5586, 7179, 6149, 6150, 
         6104, 5386, 6161, 5703, 5704, 5560, 5702, 5701, 6159, 5538, 6146, 
         5539, 7636, 5271, 7634, 5270, 7635, 5387, 7834, 5388, 7034, 5285, 
         7645, 5284, 7644, 7292, 7293, 6625, 5050, 7935, 5051, 6626, 7125, 
         4840, 7805, 5500, 7804, 5501, 7806, 5499, 7851, 5579, 7850, 5578, 
         4745, 4674, 7779, 5470, 7778, 5471, 6127, 6126, 4841, 6645, 6646, 
         6643, 5063, 6644, 5901, 7524, 5064, 7523, 5065, 7545, 7546, 7544, 
         5096, 5420, 7896, 5419}],
        RowBox[{"-", "0.8`"}]],
       Annotation[#, -0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4865, 5721, 5090, 7536, 5091, 7537, 4828, 6121, 4827, 7878, 
         5453, 5947, 5946, 5926, 5927, 5280, 7640, 5279, 6062, 4846, 6700, 
         6701, 6699, 5098, 7547, 4715, 5655, 5168, 6790, 5167, 6791, 7313, 
         7312, 4775, 7908, 7117, 6567, 4993, 6566, 4992, 7598, 7599, 7597, 
         5178, 5998, 7318, 7317, 7316, 5336, 5851, 5850, 7694, 5339, 6986, 
         5340, 6987, 5337, 7693, 5338, 7690, 7692, 7691, 7731, 4647, 5601, 
         5575, 7372, 7373, 4829, 6122, 4830, 6589, 6590, 6588, 7491, 7490, 
         4757, 7494, 7495, 7493, 7497, 7496, 4831, 6592, 6593, 6591, 5024, 
         7492, 4723, 7246, 7245, 7605, 5194, 7920, 7376, 7377, 6595, 5026, 
         6594, 5025, 7498, 4758, 6604, 5035, 6603, 5036, 6605, 4833, 7509, 
         5034, 7508, 5033, 4730, 7251, 7250, 7610, 7611, 6463, 6462, 4824, 
         7513, 7514, 7510, 7512, 7511, 4761, 6610, 6611, 6609, 6613, 6612, 
         4835, 6123, 4834, 7379, 7378, 5454, 5931, 5930, 7732, 4667, 7259, 
         7258, 5234, 7617, 5233, 7033, 5383, 7031, 5382, 7032, 5886, 5887, 
         5384, 7346, 7347, 7348, 6103, 4789, 7345, 7344, 7456, 7455, 5003, 
         7457, 5004, 6574, 6688, 7910, 4797, 6689, 6690, 6393, 6392, 6391, 
         5049, 5682, 4744, 7264, 7263, 7621, 7622, 6469, 6468, 4845, 7809, 
         7810, 7459, 5006, 7458, 5007, 7550, 7551, 7548, 5099, 7549, 5949, 
         5950, 5580, 7883, 4847, 6132, 4848, 7543, 5095, 7542, 5094, 5708, 
         5707}],
        RowBox[{"-", "0.8`"}]],
       Annotation[#, -0.8, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{0, 3}, {0, 3}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->435562169]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1072415479],

Cell["\<\
Show only the regions between contours, but not the actual contours:\
\>", "ExampleText",
 CellID->585648240],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"ContourStyle", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->663787133],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->110083653]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1975897682],

Cell["\<\
Use partially transparent contour surfaces in three dimensions:\
\>", "ExampleText",
 CellID->225224166],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}], "-", 
    RowBox[{"z", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"ContourStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", "0.4", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1476371948],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->62168091]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1542494148],

Cell["Give an explicit list of styles for contours:", "ExampleText",
 CellID->276558852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}], "-", 
    RowBox[{"z", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"ContourStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Orange", ",", "Yellow"}], "}"}]}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->962607057],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36395250]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5427],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeshStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MeshStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ContourLabels",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContourLabels"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Contours",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Contours"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ContourShading",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContourShading"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23743]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13930],

Cell[TextData[ButtonBox["Density and Contour Plots",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DensityAndContourPlots"]], "Tutorials",
 CellID->30811]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Plotting Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingOptions"]], "MoreAbout",
 CellID->161739692],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->273482045]
}, Open  ]],

Cell["New in 2  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ContourStyle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 34, 47.8620948}", "context" -> "System`", 
    "keywords" -> {
     "contour thickness", "style of contour lines", 
      "style of contour surfaces", "style of iso lines", 
      "style of iso surfaces"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ContourStyle is an option for contour plots that specifies the style in \
which contour lines or surfaces should be drawn. ", 
    "synonyms" -> {"contour style"}, "title" -> "ContourStyle", "type" -> 
    "Symbol", "uri" -> "ref/ContourStyle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14231, 400, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->68702111]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 496153, 8573}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2416, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3039, 84, 4196, 83, 70, "ObjectNameGrid"],
Cell[7238, 169, 501, 14, 70, "Usage",
 CellID->18684]
}, Open  ]],
Cell[CellGroupData[{
Cell[7776, 188, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8254, 205, 293, 9, 70, "Notes",
 CellID->2425],
Cell[8550, 216, 541, 19, 70, "Notes",
 CellID->29358],
Cell[9094, 237, 890, 28, 70, "Notes",
 CellID->11478],
Cell[9987, 267, 74, 1, 70, "Notes",
 CellID->31844],
Cell[10064, 270, 2948, 84, 70, "2ColumnTableMod",
 CellID->30921],
Cell[13015, 356, 732, 25, 70, "Notes",
 CellID->26962],
Cell[13750, 383, 444, 12, 70, "Notes",
 CellID->19169]
}, Closed]],
Cell[CellGroupData[{
Cell[14231, 400, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->68702111],
Cell[CellGroupData[{
Cell[14615, 414, 148, 5, 70, "ExampleSection",
 CellID->354534105],
Cell[14766, 421, 94, 1, 70, "ExampleText",
 CellID->729432489],
Cell[CellGroupData[{
Cell[14885, 426, 314, 10, 28, "Input",
 CellID->985380230],
Cell[15202, 438, 203962, 3388, 200, "Output",
 CellID->1386126735]
}, Open  ]],
Cell[219179, 3829, 125, 3, 70, "ExampleDelimiter",
 CellID->256706282],
Cell[219307, 3834, 69, 1, 70, "ExampleText",
 CellID->1869105407],
Cell[CellGroupData[{
Cell[219401, 3839, 371, 11, 70, "Input",
 CellID->1735185547],
Cell[219775, 3852, 203934, 3388, 70, "Output",
 CellID->435562169]
}, Open  ]],
Cell[423724, 7243, 126, 3, 70, "ExampleDelimiter",
 CellID->1072415479],
Cell[423853, 7248, 119, 3, 70, "ExampleText",
 CellID->585648240],
Cell[CellGroupData[{
Cell[423997, 7255, 368, 11, 28, "Input",
 CellID->663787133],
Cell[424368, 7268, 3584, 63, 200, "Output",
 Evaluatable->False,
 CellID->110083653]
}, Open  ]],
Cell[427967, 7334, 126, 3, 70, "ExampleDelimiter",
 CellID->1975897682],
Cell[428096, 7339, 114, 3, 70, "ExampleText",
 CellID->225224166],
Cell[CellGroupData[{
Cell[428235, 7346, 637, 20, 47, "Input",
 CellID->1476371948],
Cell[428875, 7368, 43900, 724, 227, "Output",
 Evaluatable->False,
 CellID->62168091]
}, Open  ]],
Cell[472790, 8095, 126, 3, 70, "ExampleDelimiter",
 CellID->1542494148],
Cell[472919, 8100, 88, 1, 70, "ExampleText",
 CellID->276558852],
Cell[CellGroupData[{
Cell[473032, 8105, 732, 22, 47, "Input",
 CellID->962607057],
Cell[473767, 8129, 18320, 304, 227, "Output",
 Evaluatable->False,
 CellID->36395250]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[492148, 8440, 310, 9, 70, "SeeAlsoSection",
 CellID->5427],
Cell[492461, 8451, 1212, 44, 70, "SeeAlso",
 CellID->23743]
}, Open  ]],
Cell[CellGroupData[{
Cell[493710, 8500, 314, 9, 70, "TutorialsSection",
 CellID->13930],
Cell[494027, 8511, 158, 3, 70, "Tutorials",
 CellID->30811]
}, Open  ]],
Cell[CellGroupData[{
Cell[494222, 8519, 299, 8, 70, "MoreAboutSection"],
Cell[494524, 8529, 143, 3, 70, "MoreAbout",
 CellID->161739692],
Cell[494670, 8534, 197, 4, 70, "MoreAbout",
 CellID->273482045]
}, Open  ]],
Cell[494882, 8541, 50, 0, 70, "History"],
Cell[494935, 8543, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

