(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     54264,       1644]
NotebookOptionsPosition[     50065,       1506]
NotebookOutlinePosition[     51458,       1545]
CellTagsIndexPosition[     51372,       1540]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Alignment" :> Documentation`HelpLookup["paclet:ref/Alignment"],
           "Labeled" :> Documentation`HelpLookup["paclet:ref/Labeled"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Alignment\"\>", 
       2->"\<\"Labeled\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Interactive Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/InteractiveManipulation"], 
          "Options & Styling for Interactive Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/OptionsAndStylingForInteractiveManipulation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Interactive Manipulation\"\>", 
       2->"\<\"Options & Styling for Interactive Manipulation\"\>"}, \
"\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ControlPlacement", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ControlPlacement",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ControlPlacement"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Manipulate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["TabView",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
     " and other control objects that specifies where controls should be \
placed."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18509]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Possible settings include:", "Notes",
 CellID->29833],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["pos", "TI"], Cell[
    "place all controls in the specified position", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["pos", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["pos", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "place control ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " in position ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pos", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->17708],

Cell[TextData[{
 "Possible forms for ",
 Cell[BoxData[
  StyleBox["pos", "TI"]], "InlineFormula"],
 " include ",
 Cell[BoxData[
  ButtonBox["Bottom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Bottom"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Left",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Left"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Top",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Top"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Right",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Right"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19761]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->39562141],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->168674170],

Cell[TextData[{
 "Placements for ",
 Cell[BoxData[
  ButtonBox["MenuView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MenuView"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->11461725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"MenuView", "[", 
    RowBox[{
     RowBox[{"Range", "[", "2", "]"}], ",", 
     RowBox[{"ControlPlacement", "\[Rule]", "p"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{"Left", ",", "Right", ",", "Bottom", ",", "Top"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->357298876],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = 1}, 
     InterpretationBox[
      StyleBox[
       PanelBox[
        TagBox[GridBox[{
           {
            ItemBox[
             PopupMenuBox[Dynamic[BoxForm`var$$], {1->"1", 2->"2"},
              DefaultBaseStyle->"MenuViewLabel",
              Enabled->Automatic],
             Alignment->Top,
             StripOnInput->False], 
            ItemBox[
             StyleBox[Cell[BoxData[
               PaneSelectorBox[{1->"1", 2->"2"}, Dynamic[BoxForm`var$$],
                Alignment->{Left, Top},
                ImageSize->All]]],
              Deployed->False,
              StripOnInput->False],
             Background->GrayLevel[1],
             Frame->True,
             FrameStyle->GrayLevel[0.8235294117647058],
             StripOnInput->False]}
          },
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          RowsEqual->False],
         "Grid"],
        BaselinePosition->Automatic,
        DefaultBaseStyle->"MenuView",
        FrameMargins->6,
        ImageMargins->Automatic],
       Deployed->True,
       StripOnInput->False],
      MenuView[{1, 2}, ControlPlacement -> Left]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = 1}, 
     InterpretationBox[
      StyleBox[
       PanelBox[
        TagBox[GridBox[{
           {
            ItemBox[
             StyleBox[Cell[BoxData[
               PaneSelectorBox[{1->"1", 2->"2"}, Dynamic[BoxForm`var$$],
                Alignment->{Left, Top},
                ImageSize->All]]],
              Deployed->False,
              StripOnInput->False],
             Background->GrayLevel[1],
             Frame->True,
             FrameStyle->GrayLevel[0.8235294117647058],
             StripOnInput->False], 
            ItemBox[
             PopupMenuBox[Dynamic[BoxForm`var$$], {1->"1", 2->"2"},
              DefaultBaseStyle->"MenuViewLabel",
              Enabled->Automatic],
             Alignment->Top,
             StripOnInput->False]}
          },
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          RowsEqual->False],
         "Grid"],
        BaselinePosition->Automatic,
        DefaultBaseStyle->"MenuView",
        FrameMargins->6,
        ImageMargins->Automatic],
       Deployed->True,
       StripOnInput->False],
      MenuView[{1, 2}, ControlPlacement -> Right]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = 1}, 
     InterpretationBox[
      StyleBox[
       PanelBox[
        TagBox[GridBox[{
           {
            ItemBox[
             StyleBox[Cell[BoxData[
               PaneSelectorBox[{1->"1", 2->"2"}, Dynamic[BoxForm`var$$],
                Alignment->{Left, Top},
                ImageSize->All]]],
              Deployed->False,
              StripOnInput->False],
             Background->GrayLevel[1],
             Frame->True,
             FrameStyle->GrayLevel[0.8235294117647058],
             StripOnInput->False]},
           {
            ItemBox[
             PopupMenuBox[Dynamic[BoxForm`var$$], {1->"1", 2->"2"},
              DefaultBaseStyle->"MenuViewLabel",
              Enabled->Automatic],
             Alignment->Left,
             StripOnInput->False]}
          },
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          RowsEqual->False],
         "Grid"],
        BaselinePosition->Automatic,
        DefaultBaseStyle->"MenuView",
        FrameMargins->6,
        ImageMargins->Automatic],
       Deployed->True,
       StripOnInput->False],
      MenuView[{1, 2}, ControlPlacement -> Bottom]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = 1}, 
     InterpretationBox[
      StyleBox[
       PanelBox[
        TagBox[GridBox[{
           {
            ItemBox[
             PopupMenuBox[Dynamic[BoxForm`var$$], {1->"1", 2->"2"},
              DefaultBaseStyle->"MenuViewLabel",
              Enabled->Automatic],
             Alignment->Left,
             StripOnInput->False]},
           {
            ItemBox[
             StyleBox[Cell[BoxData[
               PaneSelectorBox[{1->"1", 2->"2"}, Dynamic[BoxForm`var$$],
                Alignment->{Left, Top},
                ImageSize->All]]],
              Deployed->False,
              StripOnInput->False],
             Background->GrayLevel[1],
             Frame->True,
             FrameStyle->GrayLevel[0.8235294117647058],
             StripOnInput->False]}
          },
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          RowsEqual->False],
         "Grid"],
        BaselinePosition->Automatic,
        DefaultBaseStyle->"MenuView",
        FrameMargins->6,
        ImageMargins->Automatic],
       Deployed->True,
       StripOnInput->False],
      MenuView[{1, 2}, ControlPlacement -> Top]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ]}], "}"}]], "Output",
 ImageSize->{338, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->849186427]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->202131702],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OpenerView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenerView"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->553527264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"OpenerView", "[", 
    RowBox[{
     RowBox[{"Range", "[", "2", "]"}], ",", 
     RowBox[{"ControlPlacement", "\[Rule]", "p"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{"Left", ",", "Right", ",", "Bottom", ",", "Top"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1815448],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = False}, 
     InterpretationBox[
      StyleBox[
       PaneBox[
        TagBox[GridBox[{
           {
            ItemBox[
             OpenerBox[Dynamic[Typeset`var$$],
              Enabled->Automatic],
             Alignment->Top,
             StripOnInput->False], 
            ItemBox[
             StyleBox[
              
              PaneSelectorBox[{False->"1", True->"2"}, Dynamic[Typeset`var$$],
               
               Alignment->Automatic,
               ImageMargins->Automatic,
               ImageSize->Automatic],
              Deployed->False,
              StripOnInput->False],
             Background->Automatic,
             StripOnInput->False]}
          },
          ColumnsEqual->False,
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}},
             "RowsIndexed" -> {}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0}}, "Rows" -> {{0}}},
          RowsEqual->False],
         "Grid"],
        BaselinePosition->Automatic,
        DefaultBaseStyle->"OpenerView",
        ImageMargins->0],
       Deployed->True,
       StripOnInput->False],
      OpenerView[{1, 2}, False, ControlPlacement -> Left]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = False}, 
     InterpretationBox[
      StyleBox[
       PaneBox[
        TagBox[GridBox[{
           {
            ItemBox[
             StyleBox[
              
              PaneSelectorBox[{False->"1", True->"2"}, Dynamic[Typeset`var$$],
               
               Alignment->Automatic,
               ImageMargins->Automatic,
               ImageSize->Automatic],
              Deployed->False,
              StripOnInput->False],
             Background->Automatic,
             StripOnInput->False], 
            ItemBox[
             OpenerBox[Dynamic[Typeset`var$$],
              Enabled->Automatic],
             Alignment->Top,
             StripOnInput->False]}
          },
          ColumnsEqual->False,
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}},
             "RowsIndexed" -> {}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0}}, "Rows" -> {{0}}},
          RowsEqual->False],
         "Grid"],
        BaselinePosition->Automatic,
        DefaultBaseStyle->"OpenerView",
        ImageMargins->0],
       Deployed->True,
       StripOnInput->False],
      OpenerView[{1, 2}, False, ControlPlacement -> Right]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = False}, 
     InterpretationBox[
      StyleBox[
       PaneBox[
        TagBox[GridBox[{
           {
            ItemBox[
             StyleBox[
              
              PaneSelectorBox[{False->"1", True->"2"}, Dynamic[Typeset`var$$],
               
               Alignment->Automatic,
               ImageMargins->Automatic,
               ImageSize->Automatic],
              Deployed->False,
              StripOnInput->False],
             Background->Automatic,
             StripOnInput->False]},
           {
            ItemBox[
             OpenerBox[Dynamic[Typeset`var$$],
              Enabled->Automatic],
             Alignment->Left,
             StripOnInput->False]}
          },
          ColumnsEqual->False,
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}},
             "RowsIndexed" -> {}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0}}, "Rows" -> {{0}}},
          RowsEqual->False],
         "Grid"],
        BaselinePosition->Automatic,
        DefaultBaseStyle->"OpenerView",
        ImageMargins->0],
       Deployed->True,
       StripOnInput->False],
      OpenerView[{1, 2}, False, ControlPlacement -> Bottom]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = False}, 
     InterpretationBox[
      StyleBox[
       PaneBox[
        TagBox[GridBox[{
           {
            ItemBox[
             OpenerBox[Dynamic[Typeset`var$$],
              Enabled->Automatic],
             Alignment->Left,
             StripOnInput->False]},
           {
            ItemBox[
             StyleBox[
              
              PaneSelectorBox[{False->"1", True->"2"}, Dynamic[Typeset`var$$],
               
               Alignment->Automatic,
               ImageMargins->Automatic,
               ImageSize->Automatic],
              Deployed->False,
              StripOnInput->False],
             Background->Automatic,
             StripOnInput->False]}
          },
          ColumnsEqual->False,
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}},
             "RowsIndexed" -> {}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{0}}, "Rows" -> {{0}}},
          RowsEqual->False],
         "Grid"],
        BaselinePosition->Automatic,
        DefaultBaseStyle->"OpenerView",
        ImageMargins->0],
       Deployed->True,
       StripOnInput->False],
      OpenerView[{1, 2}, False, ControlPlacement -> Top]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ]}], "}"}]], "Output",
 ImageSize->{134, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->352694096]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->326325391],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SlideView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SlideView"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->501735968],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"SlideView", "[", 
    RowBox[{
     RowBox[{"Range", "[", "2", "]"}], ",", 
     RowBox[{"ControlPlacement", "\[Rule]", "p"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{"Left", ",", "Right", ",", "Bottom", ",", "Top"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49655698],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = 1}, 
     InterpretationBox[
      StyleBox[
       PanelBox[
        TagBox[GridBox[{
           {
            ItemBox[
             TagBox[GridBox[{
                {
                 TagBox[GridBox[{
                    {
                    TagBox[
                    TooltipBox[
                    ButtonBox[
                    StyleBox["\<\"\[FirstPage]\"\>",
                    StripOnInput->False,
                    FontSize->18],
                    Appearance->"Palette",
                    ButtonFrame->"Palette",
                    
                    ButtonFunction:>If[
                    BoxForm`var$$ =!= 1, BoxForm`var$$ = 1],
                    Enabled->Automatic,
                    Evaluator->Automatic,
                    ImageSize->Small,
                    Method->"Preemptive"],
                    "\"First Slide\""],
                    Annotation[#, "First Slide", "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    ButtonBox[
                    StyleBox["\<\"\[LeftPointer]\"\>",
                    StripOnInput->False,
                    FontSize->18],
                    Appearance->"Palette",
                    ButtonFrame->"Palette",
                    ButtonFunction:>If[BoxForm`var$$ > 1, 
                    PreDecrement[BoxForm`var$$]],
                    Enabled->Automatic,
                    Evaluator->Automatic,
                    ImageSize->Small,
                    Method->"Preemptive"],
                    "\"Previous Slide\""],
                    Annotation[#, "Previous Slide", "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    ButtonBox[
                    StyleBox["\<\"\[RightPointer]\"\>",
                    StripOnInput->False,
                    FontSize->18],
                    Appearance->"Palette",
                    ButtonFrame->"Palette",
                    ButtonFunction:>If[BoxForm`var$$ < 2, 
                    PreIncrement[BoxForm`var$$]],
                    Enabled->Automatic,
                    Evaluator->Automatic,
                    ImageSize->Small,
                    Method->"Preemptive"],
                    "\"Next Slide\""],
                    Annotation[#, "Next Slide", "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    ButtonBox[
                    StyleBox["\<\"\[LastPage]\"\>",
                    StripOnInput->False,
                    FontSize->18],
                    Appearance->"Palette",
                    ButtonFrame->"Palette",
                    
                    ButtonFunction:>If[
                    BoxForm`var$$ =!= 2, BoxForm`var$$ = 2],
                    Enabled->Automatic,
                    Evaluator->Automatic,
                    ImageSize->Small,
                    Method->"Preemptive"],
                    "\"Last Slide\""],
                    Annotation[#, "Last Slide", "Tooltip"]& ]}
                   },
                   ColumnsEqual->False,
                   
                   GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}},
                   RowsEqual->False],
                  "Grid"]}
               },
               ColumnsEqual->False,
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               
               GridBoxItemSize->{
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
               RowsEqual->False],
              "Grid"],
             Alignment->Top,
             StripOnInput->False], 
            ItemBox[
             StyleBox[Cell[BoxData[
               PaneSelectorBox[{1->"1", 2->"2"}, Dynamic[BoxForm`var$$],
                Alignment->Automatic,
                ImageSize->All]]],
              Deployed->False,
              StripOnInput->False],
             Background->GrayLevel[1],
             Frame->True,
             FrameStyle->GrayLevel[0.8235294117647058],
             StripOnInput->False]}
          },
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          RowsEqual->False],
         "Grid"],
        BaselinePosition->Automatic,
        DefaultBaseStyle->"SlideView",
        FrameMargins->6,
        ImageMargins->Automatic],
       Deployed->True,
       StripOnInput->False],
      SlideView[{1, 2}, ControlPlacement -> Left]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = 1}, 
     InterpretationBox[
      StyleBox[
       PanelBox[
        TagBox[GridBox[{
           {
            ItemBox[
             StyleBox[Cell[BoxData[
               PaneSelectorBox[{1->"1", 2->"2"}, Dynamic[BoxForm`var$$],
                Alignment->Automatic,
                ImageSize->All]]],
              Deployed->False,
              StripOnInput->False],
             Background->GrayLevel[1],
             Frame->True,
             FrameStyle->GrayLevel[0.8235294117647058],
             StripOnInput->False], 
            ItemBox[
             TagBox[GridBox[{
                {
                 TagBox[GridBox[{
                    {
                    TagBox[
                    TooltipBox[
                    ButtonBox[
                    StyleBox["\<\"\[FirstPage]\"\>",
                    StripOnInput->False,
                    FontSize->18],
                    Appearance->"Palette",
                    ButtonFrame->"Palette",
                    
                    ButtonFunction:>If[
                    BoxForm`var$$ =!= 1, BoxForm`var$$ = 1],
                    Enabled->Automatic,
                    Evaluator->Automatic,
                    ImageSize->Small,
                    Method->"Preemptive"],
                    "\"First Slide\""],
                    Annotation[#, "First Slide", "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    ButtonBox[
                    StyleBox["\<\"\[LeftPointer]\"\>",
                    StripOnInput->False,
                    FontSize->18],
                    Appearance->"Palette",
                    ButtonFrame->"Palette",
                    ButtonFunction:>If[BoxForm`var$$ > 1, 
                    PreDecrement[BoxForm`var$$]],
                    Enabled->Automatic,
                    Evaluator->Automatic,
                    ImageSize->Small,
                    Method->"Preemptive"],
                    "\"Previous Slide\""],
                    Annotation[#, "Previous Slide", "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    ButtonBox[
                    StyleBox["\<\"\[RightPointer]\"\>",
                    StripOnInput->False,
                    FontSize->18],
                    Appearance->"Palette",
                    ButtonFrame->"Palette",
                    ButtonFunction:>If[BoxForm`var$$ < 2, 
                    PreIncrement[BoxForm`var$$]],
                    Enabled->Automatic,
                    Evaluator->Automatic,
                    ImageSize->Small,
                    Method->"Preemptive"],
                    "\"Next Slide\""],
                    Annotation[#, "Next Slide", "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    ButtonBox[
                    StyleBox["\<\"\[LastPage]\"\>",
                    StripOnInput->False,
                    FontSize->18],
                    Appearance->"Palette",
                    ButtonFrame->"Palette",
                    
                    ButtonFunction:>If[
                    BoxForm`var$$ =!= 2, BoxForm`var$$ = 2],
                    Enabled->Automatic,
                    Evaluator->Automatic,
                    ImageSize->Small,
                    Method->"Preemptive"],
                    "\"Last Slide\""],
                    Annotation[#, "Last Slide", "Tooltip"]& ]}
                   },
                   ColumnsEqual->False,
                   
                   GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}},
                   RowsEqual->False],
                  "Grid"]}
               },
               ColumnsEqual->False,
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               
               GridBoxItemSize->{
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
               RowsEqual->False],
              "Grid"],
             Alignment->Top,
             StripOnInput->False]}
          },
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          RowsEqual->False],
         "Grid"],
        BaselinePosition->Automatic,
        DefaultBaseStyle->"SlideView",
        FrameMargins->6,
        ImageMargins->Automatic],
       Deployed->True,
       StripOnInput->False],
      SlideView[{1, 2}, ControlPlacement -> Right]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = 1}, 
     InterpretationBox[
      StyleBox[
       PanelBox[
        TagBox[GridBox[{
           {
            ItemBox[
             StyleBox[Cell[BoxData[
               PaneSelectorBox[{1->"1", 2->"2"}, Dynamic[BoxForm`var$$],
                Alignment->Automatic,
                ImageSize->All]]],
              Deployed->False,
              StripOnInput->False],
             Background->GrayLevel[1],
             Frame->True,
             FrameStyle->GrayLevel[0.8235294117647058],
             StripOnInput->False]},
           {
            ItemBox[
             TagBox[GridBox[{
                {
                 TagBox[GridBox[{
                    {
                    TagBox[
                    TooltipBox[
                    ButtonBox[
                    StyleBox["\<\"\[FirstPage]\"\>",
                    StripOnInput->False,
                    FontSize->18],
                    Appearance->"Palette",
                    ButtonFrame->"Palette",
                    
                    ButtonFunction:>If[
                    BoxForm`var$$ =!= 1, BoxForm`var$$ = 1],
                    Enabled->Automatic,
                    Evaluator->Automatic,
                    ImageSize->Small,
                    Method->"Preemptive"],
                    "\"First Slide\""],
                    Annotation[#, "First Slide", "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    ButtonBox[
                    StyleBox["\<\"\[LeftPointer]\"\>",
                    StripOnInput->False,
                    FontSize->18],
                    Appearance->"Palette",
                    ButtonFrame->"Palette",
                    ButtonFunction:>If[BoxForm`var$$ > 1, 
                    PreDecrement[BoxForm`var$$]],
                    Enabled->Automatic,
                    Evaluator->Automatic,
                    ImageSize->Small,
                    Method->"Preemptive"],
                    "\"Previous Slide\""],
                    Annotation[#, "Previous Slide", "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    ButtonBox[
                    StyleBox["\<\"\[RightPointer]\"\>",
                    StripOnInput->False,
                    FontSize->18],
                    Appearance->"Palette",
                    ButtonFrame->"Palette",
                    ButtonFunction:>If[BoxForm`var$$ < 2, 
                    PreIncrement[BoxForm`var$$]],
                    Enabled->Automatic,
                    Evaluator->Automatic,
                    ImageSize->Small,
                    Method->"Preemptive"],
                    "\"Next Slide\""],
                    Annotation[#, "Next Slide", "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    ButtonBox[
                    StyleBox["\<\"\[LastPage]\"\>",
                    StripOnInput->False,
                    FontSize->18],
                    Appearance->"Palette",
                    ButtonFrame->"Palette",
                    
                    ButtonFunction:>If[
                    BoxForm`var$$ =!= 2, BoxForm`var$$ = 2],
                    Enabled->Automatic,
                    Evaluator->Automatic,
                    ImageSize->Small,
                    Method->"Preemptive"],
                    "\"Last Slide\""],
                    Annotation[#, "Last Slide", "Tooltip"]& ]}
                   },
                   ColumnsEqual->False,
                   
                   GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}},
                   RowsEqual->False],
                  "Grid"]}
               },
               ColumnsEqual->False,
               
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               
               GridBoxItemSize->{
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
               RowsEqual->False],
              "Grid"],
             Alignment->Left,
             StripOnInput->False]}
          },
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          RowsEqual->False],
         "Grid"],
        BaselinePosition->Automatic,
        DefaultBaseStyle->"SlideView",
        FrameMargins->6,
        ImageMargins->Automatic],
       Deployed->True,
       StripOnInput->False],
      SlideView[{1, 2}, ControlPlacement -> Bottom]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = 1}, 
     InterpretationBox[
      StyleBox[
       PanelBox[
        TagBox[GridBox[{
           {
            ItemBox[
             TagBox[GridBox[{
                {
                 TagBox[GridBox[{
                    {
                    TagBox[
                    TooltipBox[
                    ButtonBox[
                    StyleBox["\<\"\[FirstPage]\"\>",
                    StripOnInput->False,
                    FontSize->18],
                    Appearance->"Palette",
                    ButtonFrame->"Palette",
                    
                    ButtonFunction:>If[
                    BoxForm`var$$ =!= 1, BoxForm`var$$ = 1],
                    Enabled->Automatic,
                    Evaluator->Automatic,
                    ImageSize->Small,
                    Method->"Preemptive"],
                    "\"First Slide\""],
                    Annotation[#, "First Slide", "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    ButtonBox[
                    StyleBox["\<\"\[LeftPointer]\"\>",
                    StripOnInput->False,
                    FontSize->18],
                    Appearance->"Palette",
                    ButtonFrame->"Palette",
                    ButtonFunction:>If[BoxForm`var$$ > 1, 
                    PreDecrement[BoxForm`var$$]],
                    Enabled->Automatic,
                    Evaluator->Automatic,
                    ImageSize->Small,
                    Method->"Preemptive"],
                    "\"Previous Slide\""],
                    Annotation[#, "Previous Slide", "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    ButtonBox[
                    StyleBox["\<\"\[RightPointer]\"\>",
                    StripOnInput->False,
                    FontSize->18],
                    Appearance->"Palette",
                    ButtonFrame->"Palette",
                    ButtonFunction:>If[BoxForm`var$$ < 2, 
                    PreIncrement[BoxForm`var$$]],
                    Enabled->Automatic,
                    Evaluator->Automatic,
                    ImageSize->Small,
                    Method->"Preemptive"],
                    "\"Next Slide\""],
                    Annotation[#, "Next Slide", "Tooltip"]& ], 
                    TagBox[
                    TooltipBox[
                    ButtonBox[
                    StyleBox["\<\"\[LastPage]\"\>",
                    StripOnInput->False,
                    FontSize->18],
                    Appearance->"Palette",
                    ButtonFrame->"Palette",
                    
                    ButtonFunction:>If[
                    BoxForm`var$$ =!= 2, BoxForm`var$$ = 2],
                    Enabled->Automatic,
                    Evaluator->Automatic,
                    ImageSize->Small,
                    Method->"Preemptive"],
                    "\"Last Slide\""],
                    Annotation[#, "Last Slide", "Tooltip"]& ]}
                   },
                   ColumnsEqual->False,
                   
                   GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}},
                   RowsEqual->False],
                  "Grid"]}
               },
               ColumnsEqual->False,
               GridBoxAlignment->{
                "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Center}}, "RowsIndexed" -> {}},
               
               GridBoxItemSize->{
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
               RowsEqual->False],
              "Grid"],
             Alignment->Left,
             StripOnInput->False]},
           {
            ItemBox[
             StyleBox[Cell[BoxData[
               PaneSelectorBox[{1->"1", 2->"2"}, Dynamic[BoxForm`var$$],
                Alignment->Automatic,
                ImageSize->All]]],
              Deployed->False,
              StripOnInput->False],
             Background->GrayLevel[1],
             Frame->True,
             FrameStyle->GrayLevel[0.8235294117647058],
             StripOnInput->False]}
          },
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Left}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          RowsEqual->False],
         "Grid"],
        BaselinePosition->Automatic,
        DefaultBaseStyle->"SlideView",
        FrameMargins->6,
        ImageMargins->Automatic],
       Deployed->True,
       StripOnInput->False],
      SlideView[{1, 2}, ControlPlacement -> Top]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ]}], "}"}]], "Output",
 ImageSize->{354, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->98170975]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->139633500],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->14835337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"TabView", "[", 
    RowBox[{
     RowBox[{"Range", "[", "2", "]"}], ",", 
     RowBox[{"ControlPlacement", "\[Rule]", "p"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{"Left", ",", "Right", ",", "Bottom", ",", "Top"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67341513],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TabViewBox[{{1,"1"->"1"}, {2,"2"->"2"}}, 1,
    ControlPlacement->Left], ",", 
   TabViewBox[{{1,"1"->"1"}, {2,"2"->"2"}}, 1,
    ControlPlacement->Right], ",", 
   TabViewBox[{{1,"1"->"1"}, {2,"2"->"2"}}, 1,
    ControlPlacement->Bottom], ",", 
   TabViewBox[{{1,"1"->"1"}, {2,"2"->"2"}}, 1,
    ControlPlacement->Top]}], "}"}]], "Output",
 ImageSize->{230, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->117397017]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->113],

Cell["\<\
Specify different placements for each control if there is more than one:\
\>", "ExampleText",
 CellID->1299438449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1110187199],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0, $CellContext`y$$ = 0, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}, {
      Hold[$CellContext`y$$], 0, 1}}, Typeset`size$$ = {39.1875, {2., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$1579$$ = 0, $CellContext`y$1580$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`x$$ = 0, $CellContext`y$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$1579$$, 0], 
        Hold[$CellContext`y$$, $CellContext`y$1580$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> {$CellContext`x$$, $CellContext`y$$}, 
      "Specifications" :> {{$CellContext`x$$, 0, 1}, {$CellContext`y$$, 0, 
         1}}, "Options" :> {ControlPlacement -> Left}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{313., {40., 45.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{317, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->956970576]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"ControlPlacement", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Top", ",", "Bottom"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1181117800],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0, $CellContext`y$$ = 0, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}, {
      Hold[$CellContext`y$$], 0, 1}}, Typeset`size$$ = {39.1875, {2., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$30275$$ = 0, $CellContext`y$30276$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`x$$ = 0, $CellContext`y$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$30275$$, 0], 
        Hold[$CellContext`y$$, $CellContext`y$30276$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> {$CellContext`x$$, $CellContext`y$$}, 
      "Specifications" :> {{$CellContext`x$$, 0, 1}, {$CellContext`y$$, 0, 
         1}}, "Options" :> {ControlPlacement -> {Top, Bottom}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {63., 68.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->315331217]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17260],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Alignment",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Alignment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Labeled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Labeled"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22161]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with ControlPlacement",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
ControlPlacement"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InteractiveManipulation"]], "MoreAbout",
 CellID->318735832],

Cell[TextData[ButtonBox["Options & Styling for Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/OptionsAndStylingForInteractiveManipulation"]], "MoreAbout",
 CellID->166963205]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ControlPlacement - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 35, 0.8624276}", "context" -> "System`", 
    "keywords" -> {
     "control positioning", "control layout", "control location", 
      "slider positioning"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ControlPlacement is an option for Manipulate, TabView and other control \
objects that specifies where controls should be placed.", 
    "synonyms" -> {"control placement"}, "title" -> "ControlPlacement", 
    "type" -> "Symbol", "uri" -> "ref/ControlPlacement"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6675, 213, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->39562141]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 51230, 1533}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1502, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2125, 63, 1581, 37, 70, "ObjectNameGrid"],
Cell[3709, 102, 785, 24, 70, "Usage",
 CellID->18509]
}, Open  ]],
Cell[CellGroupData[{
Cell[4531, 131, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5009, 148, 59, 1, 70, "Notes",
 CellID->29833],
Cell[5071, 151, 948, 29, 70, "2ColumnTableMod",
 CellID->17708],
Cell[6022, 182, 616, 26, 70, "Notes",
 CellID->19761]
}, Closed]],
Cell[CellGroupData[{
Cell[6675, 213, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->39562141],
Cell[CellGroupData[{
Cell[7059, 227, 148, 5, 70, "ExampleSection",
 CellID->168674170],
Cell[7210, 234, 197, 8, 70, "ExampleText",
 CellID->11461725],
Cell[CellGroupData[{
Cell[7432, 246, 408, 13, 28, "Input",
 CellID->357298876],
Cell[7843, 261, 5651, 172, 82, "Output",
 CellID->849186427]
}, Open  ]],
Cell[13509, 436, 125, 3, 70, "ExampleDelimiter",
 CellID->202131702],
Cell[13637, 441, 183, 7, 70, "ExampleText",
 CellID->553527264],
Cell[CellGroupData[{
Cell[13845, 452, 408, 13, 70, "Input",
 CellID->1815448],
Cell[14256, 467, 5894, 185, 70, "Output",
 CellID->352694096]
}, Open  ]],
Cell[20165, 655, 125, 3, 70, "ExampleDelimiter",
 CellID->326325391],
Cell[20293, 660, 181, 7, 70, "ExampleText",
 CellID->501735968],
Cell[CellGroupData[{
Cell[20499, 671, 408, 13, 70, "Input",
 CellID->49655698],
Cell[20910, 686, 20665, 543, 70, "Output",
 CellID->98170975]
}, Open  ]],
Cell[41590, 1232, 125, 3, 70, "ExampleDelimiter",
 CellID->139633500],
Cell[41718, 1237, 176, 7, 70, "ExampleText",
 CellID->14835337],
Cell[CellGroupData[{
Cell[41919, 1248, 406, 13, 70, "Input",
 CellID->67341513],
Cell[42328, 1263, 514, 15, 70, "Output",
 CellID->117397017]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42891, 1284, 214, 7, 70, "ExampleSection",
 CellID->113],
Cell[43108, 1293, 124, 3, 70, "ExampleText",
 CellID->1299438449],
Cell[CellGroupData[{
Cell[43257, 1300, 365, 11, 70, "Input",
 CellID->1110187199],
Cell[43625, 1313, 1822, 40, 70, "Output",
 CellID->956970576]
}, Open  ]],
Cell[CellGroupData[{
Cell[45484, 1358, 420, 13, 70, "Input",
 CellID->1181117800],
Cell[45907, 1373, 1836, 40, 70, "Output",
 CellID->315331217]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[47804, 1420, 311, 9, 70, "SeeAlsoSection",
 CellID->17260],
Cell[48118, 1431, 451, 17, 70, "SeeAlso",
 CellID->22161]
}, Open  ]],
Cell[CellGroupData[{
Cell[48606, 1453, 305, 8, 70, "RelatedLinksSection"],
Cell[48914, 1463, 374, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49325, 1480, 299, 8, 70, "MoreAboutSection"],
Cell[49627, 1490, 159, 3, 70, "MoreAbout",
 CellID->318735832],
Cell[49789, 1495, 204, 4, 70, "MoreAbout",
 CellID->166963205]
}, Open  ]],
Cell[50008, 1502, 27, 0, 70, "History"],
Cell[50038, 1504, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

