(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     61284,       1432]
NotebookOptionsPosition[     58395,       1341]
NotebookOutlinePosition[     59861,       1382]
CellTagsIndexPosition[     59775,       1377]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ControllerState" :> 
          Documentation`HelpLookup["paclet:ref/ControllerState"], 
          "SystemInformation" :> 
          Documentation`HelpLookup["paclet:ref/SystemInformation"], 
          "CurrentValue" :> 
          Documentation`HelpLookup["paclet:ref/CurrentValue"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ControllerState\"\>", 
       2->"\<\"SystemInformation\"\>", 
       3->"\<\"CurrentValue\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Gamepad & Device Interface" :> 
          Documentation`HelpLookup["paclet:guide/GamepadAndDeviceInterface"], 
          "Interactive 3D Control" :> 
          Documentation`HelpLookup["paclet:guide/Interactive3DControl"], 
          "New in 6.0: System Interfaces & Deployment" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60SystemInterfacesAndDeployment"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Gamepad & Device Interface\"\>", 
       2->"\<\"Interactive 3D Control\"\>", 
       3->"\<\"New in 6.0: System Interfaces & Deployment\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ControllerInformation", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ControllerInformation",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ControllerInformation"], "[", "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]gives dynamically updated information on currently \
connected controller devices."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ControllerInformation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControllerInformation"]], "InlineFormula"],
 " works only in a notebook front end."
}], "Notes",
 CellID->423604398],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ControllerInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControllerInformation"], "[", "]"}]], 
  "InlineFormula"],
 " yields a graphical form."
}], "Notes",
 CellID->407352741],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ControllerInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControllerInformation"], "[", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " yields information in the form of rules."
}], "Notes",
 CellID->421775957]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->209754214],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->298479083],

Cell["\<\
View information on the external controller connected to this machine (if \
any):\
\>", "ExampleText",
 CellID->14021340],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ControllerInformation", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1704157831],

Cell[BoxData[
 InterpretationBox[
  PanelBox[
   StyleBox[
    TagBox[GridBox[{
       {
        DynamicModuleBox[{System`InfoDump`open$$ = False}, 
         PaneSelectorBox[{False->
          RowBox[{
           OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
           StyleBox[
            InterpretationBox[
             RowBox[{
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "SystemInformationDialog", "ControllerDeviceText"], 
                 StandardForm],
                ImageSizeCache->{97., {1., 9.}}],
               StripOnInput->False,
               DynamicUpdating->True], "\[InvisibleSpace]", "\<\" \"\>", 
              "\[InvisibleSpace]", "\<\"1\"\>", 
              "\[InvisibleSpace]", "\<\": \"\>", 
              "\[InvisibleSpace]", "\<\"Logitech Dual Action\"\>"}],
             Row[{
               Style[
                Dynamic[
                 FEPrivate`FrontEndResource[
                 "SystemInformationDialog", "ControllerDeviceText"]], 
                DynamicUpdating -> True], " ", "1", ": ", 
               "Logitech Dual Action"}]],
            StripOnInput->False,
            FontWeight->Bold]}], True->
          TagBox[GridBox[{
             {
              RowBox[{
               OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
               StyleBox[
                InterpretationBox[
                 RowBox[{
                  StyleBox[
                   DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControllerDeviceText"], 
                    StandardForm]],
                   StripOnInput->False,
                   DynamicUpdating->True], "\[InvisibleSpace]", "\<\" \"\>", 
                  "\[InvisibleSpace]", "\<\"1\"\>", 
                  "\[InvisibleSpace]", "\<\": \"\>", 
                  "\[InvisibleSpace]", "\<\"Logitech Dual Action\"\>"}],
                 Row[{
                   Style[
                    Dynamic[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControllerDeviceText"]], 
                    DynamicUpdating -> True], " ", "1", ": ", 
                   "Logitech Dual Action"}]],
                StripOnInput->False,
                FontWeight->Bold]}]},
             {
              TagBox[GridBox[{
                 {"\<\"Manufacturer\"\>", 
                  InterpretationBox[
                   
                   RowBox[{"\<\"Logitech\"\>", 
                    "\[InvisibleSpace]", "\<\" (\"\>", "\[InvisibleSpace]", 
                    "1133", "\[InvisibleSpace]", "\<\")\"\>"}],
                   Row[{"Logitech", " (", 1133, ")"}]]},
                 {"\<\"Raw Product Name\"\>", "\<\"\\\"Logitech Dual Action\\\
\"\"\>"},
                 {"\<\"Raw Product ID\"\>", "49686"},
                 {"\<\"Device Type\"\>", "\<\"Mac OS X Human Interface Device\
\"\>"},
                 {"\<\"Raw Controller Type\"\>", "\<\"Joystick\"\>"},
                 {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Mathematica\\\\\\\"\\\", \
\\\"IT\\\"]\\) Controls\"\>", 
                  DynamicModuleBox[{System`InfoDump`open$$ = False}, 
                   PaneSelectorBox[{False->
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"35", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}], True->
                    TagBox[GridBox[{
                    {
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"35", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}]},
                    {
                    DynamicModuleBox[{System`InfoDump`dynamic$$ = True}, 
                    TagBox[GridBox[{
                    {
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {"\<\"X\"\>", 
                    RowBox[{"-", "0.0039215686274509665`"}]},
                    {"\<\"Y\"\>", 
                    RowBox[{"-", "0.0039215686274509665`"}]},
                    {"\<\"Z\"\>", 
                    RowBox[{"-", "0.0039215686274509665`"}]},
                    {"\<\"X1\"\>", 
                    RowBox[{"-", "0.0039215686274509665`"}]},
                    {"\<\"Y1\"\>", 
                    RowBox[{"-", "0.0039215686274509665`"}]},
                    {"\<\"Z1\"\>", 
                    RowBox[{"-", "0.0039215686274509665`"}]},
                    {"\<\"X2\"\>", 
                    RowBox[{"-", "0.0039215686274509665`"}]},
                    {"\<\"Y2\"\>", "0.0039215686274509665`"},
                    {"\<\"X3\"\>", "0.`"},
                    {"\<\"Y3\"\>", "0.`"},
                    {"\<\"X4\"\>", "0"},
                    {"\<\"Y4\"\>", "0"},
                    {"\<\"X5\"\>", "0"},
                    {"\<\"Y5\"\>", "0"},
                    {"\<\"B1\"\>", "False"},
                    {"\<\"B2\"\>", "False"},
                    {"\<\"B3\"\>", "False"},
                    {"\<\"B4\"\>", "False"},
                    {"\<\"B5\"\>", "False"},
                    {"\<\"B6\"\>", "False"},
                    {"\<\"B7\"\>", "False"},
                    {"\<\"B8\"\>", "False"},
                    {"\<\"B9\"\>", "False"},
                    {"\<\"B10\"\>", "False"},
                    {"\<\"B11\"\>", "False"},
                    {"\<\"B12\"\>", "False"},
                    {"\<\"BLB\"\>", "False"},
                    {"\<\"BRB\"\>", "False"},
                    {"\<\"JB\"\>", "False"},
                    {"\<\"JB1\"\>", "False"},
                    {"\<\"JB2\"\>", "False"},
                    {"\<\"Select Button\"\>", "False"},
                    {"\<\"Start Button\"\>", "False"},
                    {"\<\"TLB\"\>", "False"},
                    {"\<\"TRB\"\>", "False"}
                    },
                    ColumnsEqual->False,
                    
                    GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Grid"], True->
                    DynamicBox[ToBoxes[
                    Grid[
                    
                    Transpose[{{"X", "Y", "Z", "X1", "Y1", "Z1", "X2", "Y2", 
                    "X3", "Y3", "X4", "Y4", "X5", "Y5", "B1", "B2", "B3", 
                    "B4", "B5", "B6", "B7", "B8", "B9", "B10", "B11", "B12", 
                    "BLB", "BRB", "JB", "JB1", "JB2", "Select Button", 
                    "Start Button", "TLB", "TRB"}, 
                    ControllerState[
                    1, {"X", "Y", "Z", "X1", "Y1", "Z1", "X2", "Y2", "X3", 
                    "Y3", "X4", "Y4", "X5", "Y5", "B1", "B2", "B3", "B4", 
                    "B5", "B6", "B7", "B8", "B9", "B10", "B11", "B12", "BLB", 
                    "BRB", "JB", "JB1", "JB2", "Select Button", 
                    "Start Button", "TLB", "TRB"}]}], 
                    ColumnAlignments -> {Right, Left}], StandardForm]]}, 
                    Dynamic[System`InfoDump`dynamic$$]]},
                    {
                    InterpretationBox[
                    RowBox[{
                    CheckboxBox[Dynamic[System`InfoDump`dynamic$$],
                    ImageSize->Small], 
                    "\[InvisibleSpace]", "\<\" Show Dynamic Values\"\>"}],
                    Row[{
                    Checkbox[
                    Dynamic[System`InfoDump`dynamic$$], ImageSize -> Small], 
                    " Show Dynamic Values"}]]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    DynamicModuleValues:>{}]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{1.}}, "RowsIndexed" -> {}},
                    RowsEqual->False],
                    "Column"]}, Dynamic[System`InfoDump`open$$],
                    BaselinePosition->Baseline,
                    FrameMargins->0,
                    ImageSize->Automatic],
                   DynamicModuleValues:>{}]},
                 {"\<\"Raw Controls\"\>", 
                  DynamicModuleBox[{System`InfoDump`open$$ = False}, 
                   PaneSelectorBox[{False->
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"18", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}], True->
                    TagBox[GridBox[{
                    {
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"18", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}]},
                    {
                    DynamicModuleBox[{System`InfoDump`dynamic$$ = True}, 
                    TagBox[GridBox[{
                    {
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {"\<\"X Axis\"\>", 
                    RowBox[{"-", "0.0039215686274509665`"}]},
                    {"\<\"Y Axis\"\>", "0.0039215686274509665`"},
                    {"\<\"Z Axis\"\>", 
                    RowBox[{"-", "0.0039215686274509665`"}]},
                    {"\<\"Z Rotation\"\>", 
                    RowBox[{"-", "0.0039215686274509665`"}]},
                    {"\<\"Hatswitch X Axis\"\>", "0.`"},
                    {"\<\"Hatswitch Y Axis\"\>", "0.`"},
                    {"\<\"Button 1\"\>", "False"},
                    {"\<\"Button 2\"\>", "False"},
                    {"\<\"Button 3\"\>", "False"},
                    {"\<\"Button 4\"\>", "False"},
                    {"\<\"Button 5\"\>", "False"},
                    {"\<\"Button 6\"\>", "False"},
                    {"\<\"Button 7\"\>", "False"},
                    {"\<\"Button 8\"\>", "False"},
                    {"\<\"Button 9\"\>", "False"},
                    {"\<\"Button 10\"\>", "False"},
                    {"\<\"Button 11\"\>", "False"},
                    {"\<\"Button 12\"\>", "False"}
                    },
                    ColumnsEqual->False,
                    
                    GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Grid"], True->
                    DynamicBox[ToBoxes[
                    Grid[
                    
                    Transpose[{{"X Axis", "Y Axis", "Z Axis", "Z Rotation", 
                    "Hatswitch X Axis", "Hatswitch Y Axis", "Button 1", 
                    "Button 2", "Button 3", "Button 4", "Button 5", 
                    "Button 6", "Button 7", "Button 8", "Button 9", 
                    "Button 10", "Button 11", "Button 12"}, 
                    ControllerState[
                    1, {"X Axis", "Y Axis", "Z Axis", "Z Rotation", 
                    "Hatswitch X Axis", "Hatswitch Y Axis", "Button 1", 
                    "Button 2", "Button 3", "Button 4", "Button 5", 
                    "Button 6", "Button 7", "Button 8", "Button 9", 
                    "Button 10", "Button 11", "Button 12"}]}], 
                    ColumnAlignments -> {Right, Left}], StandardForm]]}, 
                    Dynamic[System`InfoDump`dynamic$$]]},
                    {
                    InterpretationBox[
                    RowBox[{
                    CheckboxBox[Dynamic[System`InfoDump`dynamic$$],
                    ImageSize->Small], 
                    "\[InvisibleSpace]", "\<\" Show Dynamic Values\"\>"}],
                    Row[{
                    Checkbox[
                    Dynamic[System`InfoDump`dynamic$$], ImageSize -> Small], 
                    " Show Dynamic Values"}]]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    DynamicModuleValues:>{}]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{1.}}, "RowsIndexed" -> {}},
                    RowsEqual->False],
                    "Column"]}, Dynamic[System`InfoDump`open$$],
                    BaselinePosition->Baseline,
                    FrameMargins->0,
                    ImageSize->Automatic],
                   DynamicModuleValues:>{}]}
                },
                GridBoxAlignment->{"Columns" -> {Right, Left}},
                GridBoxDividers->{"Rows" -> {{False}, 
                    GrayLevel[0, 0.2]}},
                GridBoxItemSize->{"Columns" -> {17, 39.992700729927}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.28], {
                    Offset[0.84]}, 
                    Offset[0.28]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.48]}, 
                    Offset[0.2]}}],
               "Grid"]}
            },
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            RowsEqual->False],
           "Column"]}, Dynamic[System`InfoDump`open$$],
          ImageSize->Automatic],
         DynamicModuleValues:>{}]},
       {
        DynamicModuleBox[{System`InfoDump`open$$ = False}, 
         PaneSelectorBox[{False->
          RowBox[{
           OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
           StyleBox[
            InterpretationBox[
             RowBox[{
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "SystemInformationDialog", "ControllerDeviceText"], 
                 StandardForm],
                ImageSizeCache->{97., {1., 9.}}],
               StripOnInput->False,
               DynamicUpdating->True], "\[InvisibleSpace]", "\<\" \"\>", 
              "\[InvisibleSpace]", "\<\"2\"\>", 
              "\[InvisibleSpace]", "\<\": \"\>", 
              "\[InvisibleSpace]", "\<\"Apple IR\"\>"}],
             Row[{
               Style[
                Dynamic[
                 FEPrivate`FrontEndResource[
                 "SystemInformationDialog", "ControllerDeviceText"]], 
                DynamicUpdating -> True], " ", "2", ": ", "Apple IR"}]],
            StripOnInput->False,
            FontWeight->Bold]}], True->
          TagBox[GridBox[{
             {
              RowBox[{
               OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
               StyleBox[
                InterpretationBox[
                 RowBox[{
                  StyleBox[
                   DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControllerDeviceText"], 
                    StandardForm]],
                   StripOnInput->False,
                   DynamicUpdating->True], "\[InvisibleSpace]", "\<\" \"\>", 
                  "\[InvisibleSpace]", "\<\"2\"\>", 
                  "\[InvisibleSpace]", "\<\": \"\>", 
                  "\[InvisibleSpace]", "\<\"Apple IR\"\>"}],
                 Row[{
                   Style[
                    Dynamic[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControllerDeviceText"]], 
                    DynamicUpdating -> True], " ", "2", ": ", "Apple IR"}]],
                StripOnInput->False,
                FontWeight->Bold]}]},
             {
              TagBox[GridBox[{
                 {"\<\"Manufacturer\"\>", 
                  InterpretationBox[
                   
                   RowBox[{"\<\"Apple Computer, Inc.\"\>", 
                    "\[InvisibleSpace]", "\<\" (\"\>", "\[InvisibleSpace]", 
                    "1452", "\[InvisibleSpace]", "\<\")\"\>"}],
                   Row[{"Apple Computer, Inc.", " (", 1452, ")"}]]},
                 {"\<\"Raw Product Name\"\>", "\<\"\\\"Apple IR\\\"\"\>"},
                 {"\<\"Raw Product ID\"\>", "33344"},
                 {"\<\"Device Type\"\>", "\<\"Mac OS X Human Interface Device\
\"\>"},
                 {"\<\"Raw Controller Type\"\>", "\<\"External \
Controller\"\>"},
                 {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Mathematica\\\\\\\"\\\", \
\\\"IT\\\"]\\) Controls\"\>", 
                  DynamicModuleBox[{System`InfoDump`open$$ = False}, 
                   PaneSelectorBox[{False->
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"5", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}], True->
                    TagBox[GridBox[{
                    {
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"5", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}]},
                    {
                    DynamicModuleBox[{System`InfoDump`dynamic$$ = True}, 
                    TagBox[GridBox[{
                    {
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {"\<\"B\"\>", "False"},
                    {"\<\"B1\"\>", "False"},
                    {"\<\"B2\"\>", "False"},
                    {"\<\"Button 1\"\>", "False"},
                    {"\<\"Button 2\"\>", "False"}
                    },
                    ColumnsEqual->False,
                    
                    GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Grid"], True->
                    DynamicBox[ToBoxes[
                    Grid[
                    Transpose[{{"B", "B1", "B2", "Button 1", "Button 2"}, 
                    ControllerState[
                    2, {"B", "B1", "B2", "Button 1", "Button 2"}]}], 
                    ColumnAlignments -> {Right, Left}], StandardForm]]}, 
                    Dynamic[System`InfoDump`dynamic$$]]},
                    {
                    InterpretationBox[
                    RowBox[{
                    CheckboxBox[Dynamic[System`InfoDump`dynamic$$],
                    ImageSize->Small], 
                    "\[InvisibleSpace]", "\<\" Show Dynamic Values\"\>"}],
                    Row[{
                    Checkbox[
                    Dynamic[System`InfoDump`dynamic$$], ImageSize -> Small], 
                    " Show Dynamic Values"}]]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    DynamicModuleValues:>{}]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{1.}}, "RowsIndexed" -> {}},
                    RowsEqual->False],
                    "Column"]}, Dynamic[System`InfoDump`open$$],
                    BaselinePosition->Baseline,
                    FrameMargins->0,
                    ImageSize->Automatic],
                   DynamicModuleValues:>{}]},
                 {"\<\"Raw Controls\"\>", 
                  DynamicModuleBox[{System`InfoDump`open$$ = False}, 
                   PaneSelectorBox[{False->
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"17", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}], True->
                    TagBox[GridBox[{
                    {
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"17", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}]},
                    {
                    DynamicModuleBox[{System`InfoDump`dynamic$$ = True}, 
                    TagBox[GridBox[{
                    {
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {"\<\"Reserved Button\"\>", "False"},
                    {"\<\"Rewind Button\"\>", "False"},
                    {"\<\"FastForward Button\"\>", "False"},
                    {"\<\"Menu Button\"\>", "False"},
                    {"\<\"Reserved Button 2\"\>", "False"},
                    {"\<\"SystemAppMenu Button\"\>", "False"},
                    {"\<\"SystemMenu Button\"\>", "False"},
                    {"\<\"SystemMenuRight Button\"\>", "False"},
                    {"\<\"SystemMenuLeft Button\"\>", "False"},
                    {"\<\"Reserved Button 3\"\>", "False"},
                    {"\<\"SystemMenuUp Button\"\>", "False"},
                    {"\<\"SystemMenuDown Button\"\>", "False"},
                    {"\<\"Unknown:65281:65535 Button\"\>", "False"},
                    {"\<\"Unknown:65281:32 Button\"\>", "False"},
                    {"\<\"Unknown:65281:33 Button\"\>", "False"},
                    {"\<\"Unknown:65281:34 Button\"\>", "False"},
                    {"\<\"Unknown:65281:35 Button\"\>", "False"}
                    },
                    ColumnsEqual->False,
                    
                    GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Grid"], True->
                    DynamicBox[ToBoxes[
                    Grid[
                    
                    Transpose[{{"Reserved Button", "Rewind Button", 
                    "FastForward Button", "Menu Button", "Reserved Button 2", 
                    "SystemAppMenu Button", "SystemMenu Button", 
                    "SystemMenuRight Button", "SystemMenuLeft Button", 
                    "Reserved Button 3", "SystemMenuUp Button", 
                    "SystemMenuDown Button", "Unknown:65281:65535 Button", 
                    "Unknown:65281:32 Button", "Unknown:65281:33 Button", 
                    "Unknown:65281:34 Button", "Unknown:65281:35 Button"}, 
                    ControllerState[
                    2, {"Reserved Button", "Rewind Button", 
                    "FastForward Button", "Menu Button", "Reserved Button 2", 
                    "SystemAppMenu Button", "SystemMenu Button", 
                    "SystemMenuRight Button", "SystemMenuLeft Button", 
                    "Reserved Button 3", "SystemMenuUp Button", 
                    "SystemMenuDown Button", "Unknown:65281:65535 Button", 
                    "Unknown:65281:32 Button", "Unknown:65281:33 Button", 
                    "Unknown:65281:34 Button", "Unknown:65281:35 Button"}]}], 
                    ColumnAlignments -> {Right, Left}], StandardForm]]}, 
                    Dynamic[System`InfoDump`dynamic$$]]},
                    {
                    InterpretationBox[
                    RowBox[{
                    CheckboxBox[Dynamic[System`InfoDump`dynamic$$],
                    ImageSize->Small], 
                    "\[InvisibleSpace]", "\<\" Show Dynamic Values\"\>"}],
                    Row[{
                    Checkbox[
                    Dynamic[System`InfoDump`dynamic$$], ImageSize -> Small], 
                    " Show Dynamic Values"}]]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    DynamicModuleValues:>{}]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{1.}}, "RowsIndexed" -> {}},
                    RowsEqual->False],
                    "Column"]}, Dynamic[System`InfoDump`open$$],
                    BaselinePosition->Baseline,
                    FrameMargins->0,
                    ImageSize->Automatic],
                   DynamicModuleValues:>{}]}
                },
                GridBoxAlignment->{"Columns" -> {Right, Left}},
                GridBoxDividers->{"Rows" -> {{False}, 
                    GrayLevel[0, 0.2]}},
                GridBoxItemSize->{"Columns" -> {17, 39.992700729927}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.28], {
                    Offset[0.84]}, 
                    Offset[0.28]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.48]}, 
                    Offset[0.2]}}],
               "Grid"]}
            },
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            RowsEqual->False],
           "Column"]}, Dynamic[System`InfoDump`open$$],
          ImageSize->Automatic],
         DynamicModuleValues:>{}]},
       {
        DynamicModuleBox[{System`InfoDump`open$$ = False}, 
         PaneSelectorBox[{False->
          RowBox[{
           OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
           StyleBox[
            InterpretationBox[
             RowBox[{
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "SystemInformationDialog", "ControllerDeviceText"], 
                 StandardForm],
                ImageSizeCache->{97., {1., 9.}}],
               StripOnInput->False,
               DynamicUpdating->True], "\[InvisibleSpace]", "\<\" \"\>", 
              "\[InvisibleSpace]", "\<\"3\"\>", 
              "\[InvisibleSpace]", "\<\": \"\>", 
              "\[InvisibleSpace]", "\<\"Sudden Motion Sensor\"\>"}],
             Row[{
               Style[
                Dynamic[
                 FEPrivate`FrontEndResource[
                 "SystemInformationDialog", "ControllerDeviceText"]], 
                DynamicUpdating -> True], " ", "3", ": ", 
               "Sudden Motion Sensor"}]],
            StripOnInput->False,
            FontWeight->Bold]}], True->
          TagBox[GridBox[{
             {
              RowBox[{
               OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
               StyleBox[
                InterpretationBox[
                 RowBox[{
                  StyleBox[
                   DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControllerDeviceText"], 
                    StandardForm]],
                   StripOnInput->False,
                   DynamicUpdating->True], "\[InvisibleSpace]", "\<\" \"\>", 
                  "\[InvisibleSpace]", "\<\"3\"\>", 
                  "\[InvisibleSpace]", "\<\": \"\>", 
                  "\[InvisibleSpace]", "\<\"Sudden Motion Sensor\"\>"}],
                 Row[{
                   Style[
                    Dynamic[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControllerDeviceText"]], 
                    DynamicUpdating -> True], " ", "3", ": ", 
                   "Sudden Motion Sensor"}]],
                StripOnInput->False,
                FontWeight->Bold]}]},
             {
              TagBox[GridBox[{
                 {"\<\"Manufacturer\"\>", 
                  InterpretationBox[
                   
                   RowBox[{"\<\"Apple Computer, Inc.\"\>", 
                    "\[InvisibleSpace]", "\<\" (\"\>", "\[InvisibleSpace]", 
                    "1452", "\[InvisibleSpace]", "\<\")\"\>"}],
                   Row[{"Apple Computer, Inc.", " (", 1452, ")"}]]},
                 {"\<\"Raw Product Name\"\>", "\<\"\\\"Sudden Motion Sensor\\\
\"\"\>"},
                 {"\<\"Raw Product ID\"\>", "0"},
                 {"\<\"Device Type\"\>", "\<\"Mac OS X Motion Sensor Device\"\
\>"},
                 {"\<\"Raw Controller Type\"\>", "\<\"Internal \
Controller\"\>"},
                 {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Mathematica\\\\\\\"\\\", \
\\\"IT\\\"]\\) Controls\"\>", 
                  DynamicModuleBox[{System`InfoDump`open$$ = False}, 
                   PaneSelectorBox[{False->
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"7", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}], True->
                    TagBox[GridBox[{
                    {
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"7", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}]},
                    {
                    DynamicModuleBox[{System`InfoDump`dynamic$$ = True}, 
                    TagBox[GridBox[{
                    {
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {"\<\"X\"\>", "0.08235294117647052`"},
                    {"\<\"Y\"\>", 
                    RowBox[{"-", "0.0039215686274509665`"}]},
                    {"\<\"Z\"\>", 
                    RowBox[{"-", "0.11372549019607847`"}]},
                    {"\<\"X1\"\>", "0.08235294117647052`"},
                    {"\<\"Y1\"\>", 
                    RowBox[{"-", "0.0039215686274509665`"}]},
                    {"\<\"Z1\"\>", 
                    RowBox[{"-", "0.11372549019607847`"}]},
                    {"\<\"X2\"\>", 
                    RowBox[{"-", "0.11372549019607847`"}]}
                    },
                    ColumnsEqual->False,
                    
                    GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Grid"], True->
                    DynamicBox[ToBoxes[
                    Grid[
                    Transpose[{{"X", "Y", "Z", "X1", "Y1", "Z1", "X2"}, 
                    ControllerState[
                    3, {"X", "Y", "Z", "X1", "Y1", "Z1", "X2"}]}], 
                    ColumnAlignments -> {Right, Left}], StandardForm]]}, 
                    Dynamic[System`InfoDump`dynamic$$]]},
                    {
                    InterpretationBox[
                    RowBox[{
                    CheckboxBox[Dynamic[System`InfoDump`dynamic$$],
                    ImageSize->Small], 
                    "\[InvisibleSpace]", "\<\" Show Dynamic Values\"\>"}],
                    Row[{
                    Checkbox[
                    Dynamic[System`InfoDump`dynamic$$], ImageSize -> Small], 
                    " Show Dynamic Values"}]]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    DynamicModuleValues:>{}]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{1.}}, "RowsIndexed" -> {}},
                    RowsEqual->False],
                    "Column"]}, Dynamic[System`InfoDump`open$$],
                    BaselinePosition->Baseline,
                    FrameMargins->0,
                    ImageSize->Automatic],
                   DynamicModuleValues:>{}]},
                 {"\<\"Raw Controls\"\>", 
                  DynamicModuleBox[{System`InfoDump`open$$ = False}, 
                   PaneSelectorBox[{False->
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"3", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}], True->
                    TagBox[GridBox[{
                    {
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"3", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}]},
                    {
                    DynamicModuleBox[{System`InfoDump`dynamic$$ = True}, 
                    TagBox[GridBox[{
                    {
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {"\<\"X Axis\"\>", "0.08235294117647052`"},
                    {"\<\"Y Axis\"\>", "0.0039215686274509665`"},
                    {"\<\"Z Axis\"\>", 
                    RowBox[{"-", "0.11372549019607847`"}]}
                    },
                    ColumnsEqual->False,
                    
                    GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Grid"], True->
                    DynamicBox[ToBoxes[
                    Grid[
                    Transpose[{{"X Axis", "Y Axis", "Z Axis"}, 
                    ControllerState[3, {"X Axis", "Y Axis", "Z Axis"}]}], 
                    ColumnAlignments -> {Right, Left}], StandardForm]]}, 
                    Dynamic[System`InfoDump`dynamic$$]]},
                    {
                    InterpretationBox[
                    RowBox[{
                    CheckboxBox[Dynamic[System`InfoDump`dynamic$$],
                    ImageSize->Small], 
                    "\[InvisibleSpace]", "\<\" Show Dynamic Values\"\>"}],
                    Row[{
                    Checkbox[
                    Dynamic[System`InfoDump`dynamic$$], ImageSize -> Small], 
                    " Show Dynamic Values"}]]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    DynamicModuleValues:>{}]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{1.}}, "RowsIndexed" -> {}},
                    RowsEqual->False],
                    "Column"]}, Dynamic[System`InfoDump`open$$],
                    BaselinePosition->Baseline,
                    FrameMargins->0,
                    ImageSize->Automatic],
                   DynamicModuleValues:>{}]}
                },
                GridBoxAlignment->{"Columns" -> {Right, Left}},
                GridBoxDividers->{"Rows" -> {{False}, 
                    GrayLevel[0, 0.2]}},
                GridBoxItemSize->{"Columns" -> {17, 39.992700729927}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.28], {
                    Offset[0.84]}, 
                    Offset[0.28]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.48]}, 
                    Offset[0.2]}}],
               "Grid"]}
            },
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            RowsEqual->False],
           "Column"]}, Dynamic[System`InfoDump`open$$],
          ImageSize->Automatic],
         DynamicModuleValues:>{}]}
      },
      ColumnsEqual->False,
      GridBoxAlignment->{"Columns" -> {{Left}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
      RowsEqual->False],
     "Column"], "DialogStyle",
    Editable->False,
    Deletable->False,
    StripOnInput->False,
    ShowStringCharacters->False,
    TooltipBoxOptions->{ActionDelay->Automatic}],
   DefaultBaseStyle->"DialogStyle",
   FrameMargins->5],
  ControllerInformationData[{
   "Logitech Dual Action" -> {{
      "X Axis" -> -0.0039215686274509665`, "Y Axis" -> 0.0039215686274509665`,
        "Z Axis" -> -0.0039215686274509665`, 
       "Z Rotation" -> -0.0039215686274509665`, "Hatswitch X Axis" -> 0., 
       "Hatswitch Y Axis" -> 0.}, {
      "Button 1" -> False, "Button 2" -> False, "Button 3" -> False, 
       "Button 4" -> False, "Button 5" -> False, "Button 6" -> False, 
       "Button 7" -> False, "Button 8" -> False, "Button 9" -> False, 
       "Button 10" -> False, "Button 11" -> False, "Button 12" -> False}, {
      "Manufacturer Name" -> "Logitech", "Manufacturer ID" -> 1133, 
       "Product Name" -> "Logitech Dual Action", "Product ID" -> 49686, 
       "Controller Type" -> "Joystick", "Device Type" -> 
       "Mac OS X Human Interface Device", "HID Usage Page" -> 
       "GenericDesktop", "HID Usage" -> "Joystick"}, {
      "X2" -> "Z Axis", "Y2" -> -"Z Rotation", "JB" -> "Button 11", "JB1" -> 
       "Button 11", "JB2" -> "Button 12", "JB3" -> None, "TLB" -> "Button 5", 
       "TRB" -> "Button 6", "BLB" -> "Button 7", "BRB" -> "Button 8", 
       "Select Button" -> "Button 9", "Start Button" -> "Button 10", "X" -> 
       "X Axis", "Y" -> -"Y Axis", "Z" -> "Z Axis", "X1" -> "X Axis", 
       "Y1" -> -"Y Axis", "Z1" -> "Z Axis", "X2" -> "Z Rotation", 
       "Y2" -> -"Slider", "Z2" -> None, "X3" -> "Hatswitch X Axis", 
       "Y3" -> -"Hatswitch Y Axis", "Z3" -> None, "X4" -> 
       Switch[{"Button 1", "Button 3"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "Y4" -> 
       Switch[{"Button 2", "Button 4"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "X5" -> 
       Switch[{"Button 7", "Button 5"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "Y5" -> 
       Switch[{"Button 8", "Button 6"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "B1" -> 
       "Button 1", "B2" -> "Button 2", "B3" -> "Button 3", "B4" -> "Button 4",
        "B5" -> "Button 5", "B6" -> "Button 6", "B7" -> "Button 7", "B8" -> 
       "Button 8", "B9" -> "Button 9", "B10" -> "Button 10", "B11" -> 
       "Button 11", "B12" -> "Button 12", "DefaultAbsolute" -> False}}, 
    "Apple IR" -> {{}, {
      "Reserved Button" -> False, "Rewind Button" -> False, 
       "FastForward Button" -> False, "Menu Button" -> False, 
       "Reserved Button 2" -> False, "SystemAppMenu Button" -> False, 
       "SystemMenu Button" -> False, "SystemMenuRight Button" -> False, 
       "SystemMenuLeft Button" -> False, "Reserved Button 3" -> False, 
       "SystemMenuUp Button" -> False, "SystemMenuDown Button" -> False, 
       "Unknown:65281:65535 Button" -> False, "Unknown:65281:32 Button" -> 
       False, "Unknown:65281:33 Button" -> False, "Unknown:65281:34 Button" -> 
       False, "Unknown:65281:35 Button" -> False}, {
      "Manufacturer Name" -> "Apple Computer, Inc.", "Manufacturer ID" -> 
       1452, "Product Name" -> "Apple IR", "Product ID" -> 33344, 
       "Controller Type" -> "External Controller", "Device Type" -> 
       "Mac OS X Human Interface Device", "HID Usage Page" -> "Consumer", 
       "HID Usage" -> "ConsumerControl"}, {
      "B" -> "Rewind Button", "B1" -> "Rewind Button", "Button 1" -> 
       "Rewind Button", "B2" -> "FastForward Button", "Button 2" -> 
       "FastForward Button", "X" -> "X Axis", "Y" -> -"Y Axis", "Z" -> 
       "Z Axis", "X1" -> "X Axis", "Y1" -> -"Y Axis", "Z1" -> "Z Axis", "X2" -> 
       "Z Rotation", "Y2" -> -"Slider", "Z2" -> None, "X3" -> 
       "Hatswitch X Axis", "Y3" -> -"Hatswitch Y Axis", "Z3" -> None, "X4" -> 
       Switch[{"Button 1", "Button 3"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "Y4" -> 
       Switch[{"Button 2", "Button 4"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "X5" -> 
       Switch[{"Button 7", "Button 5"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "Y5" -> 
       Switch[{"Button 8", "Button 6"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "B1" -> 
       "Button 1", "B2" -> "Button 2", "B3" -> "Button 3", "B4" -> "Button 4",
        "B5" -> "Button 5", "B6" -> "Button 6", "B7" -> "Button 7", "B8" -> 
       "Button 8", "B9" -> "Button 9", "B10" -> "Button 10", "B11" -> 
       "Button 11", "B12" -> "Button 12", "DefaultAbsolute" -> False}}, 
    "Sudden Motion Sensor" -> {{
      "X Axis" -> 0.08235294117647052, "Y Axis" -> 0.0039215686274509665`, 
       "Z Axis" -> -0.11372549019607847`}, {}, {
      "Manufacturer Name" -> "Apple Computer, Inc.", "Manufacturer ID" -> 
       1452, "Product Name" -> "Sudden Motion Sensor", "Product ID" -> 0, 
       "Controller Type" -> "Internal Controller", "Device Type" -> 
       "Mac OS X Motion Sensor Device"}, {
      "X2" -> "Z Axis", "Y2" -> -"Z Rotation", "JB" -> "Button 11", "JB1" -> 
       "Button 11", "JB2" -> "Button 12", "JB3" -> None, "TLB" -> "Button 5", 
       "TRB" -> "Button 6", "BLB" -> "Button 7", "BRB" -> "Button 8", "X" -> 
       "X Axis", "Y" -> -"Y Axis", "Z" -> "Z Axis", "X1" -> "X Axis", 
       "Y1" -> -"Y Axis", "Z1" -> "Z Axis", "X2" -> "Z Rotation", 
       "Y2" -> -"Slider", "Z2" -> None, "X3" -> "Hatswitch X Axis", 
       "Y3" -> -"Hatswitch Y Axis", "Z3" -> None, "X4" -> 
       Switch[{"Button 1", "Button 3"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "Y4" -> 
       Switch[{"Button 2", "Button 4"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "X5" -> 
       Switch[{"Button 7", "Button 5"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "Y5" -> 
       Switch[{"Button 8", "Button 6"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "B1" -> 
       "Button 1", "B2" -> "Button 2", "B3" -> "Button 3", "B4" -> "Button 4",
        "B5" -> "Button 5", "B6" -> "Button 6", "B7" -> "Button 7", "B8" -> 
       "Button 8", "B9" -> "Button 9", "B10" -> "Button 10", "B11" -> 
       "Button 11", "B12" -> "Button 12", "DefaultAbsolute" -> 
       False}}}]]], "Output",
 ImageSize->{277, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->791265578]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ControllerState",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControllerState"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SystemInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SystemInformation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CurrentValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CurrentValue"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->866398033],

Cell[TextData[ButtonBox["Gamepad & Device Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GamepadAndDeviceInterface"]], "MoreAbout",
 CellID->275651748],

Cell[TextData[ButtonBox["Interactive 3D Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Interactive3DControl"]], "MoreAbout",
 CellID->67382848],

Cell[TextData[ButtonBox["New in 6.0: System Interfaces & Deployment",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60SystemInterfacesAndDeployment"]], "MoreAbout",
 CellID->362343849]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ControllerInformation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 34, 55.6591694}", "context" -> "System`", 
    "keywords" -> {
     "gamepad", "joystick", "external controller devices", 
      "multi-axis control", "space mouse", "controller device", "HID", 
      "human interface device"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ControllerInformation[] gives dynamically updated information on \
currently connected controller devices.", 
    "synonyms" -> {"controller information"}, "title" -> 
    "ControllerInformation", "type" -> "Symbol", "uri" -> 
    "ref/ControllerInformation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5993, 184, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->209754214]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 59632, 1370}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1839, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2462, 70, 1586, 37, 70, "ObjectNameGrid"],
Cell[4051, 109, 533, 16, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4621, 130, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5099, 147, 233, 7, 70, "Notes",
 CellID->423604398],
Cell[5335, 156, 251, 9, 70, "Notes",
 CellID->407352741],
Cell[5589, 167, 367, 12, 70, "Notes",
 CellID->421775957]
}, Closed]],
Cell[CellGroupData[{
Cell[5993, 184, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->209754214],
Cell[CellGroupData[{
Cell[6378, 198, 148, 5, 70, "ExampleSection",
 CellID->298479083],
Cell[6529, 205, 131, 4, 70, "ExampleText",
 CellID->14021340],
Cell[CellGroupData[{
Cell[6685, 213, 113, 3, 28, "Input",
 CellID->1704157831],
Cell[6801, 218, 49528, 1042, 86, "Output",
 CellID->791265578]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[56390, 1267, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[56709, 1278, 740, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[57486, 1309, 319, 9, 70, "MoreAboutSection",
 CellID->866398033],
Cell[57808, 1320, 163, 3, 70, "MoreAbout",
 CellID->275651748],
Cell[57974, 1325, 153, 3, 70, "MoreAbout",
 CellID->67382848],
Cell[58130, 1330, 193, 4, 70, "MoreAbout",
 CellID->362343849]
}, Open  ]],
Cell[58338, 1337, 27, 0, 70, "History"],
Cell[58368, 1339, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

