(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24676,        750]
NotebookOptionsPosition[     20667,        621]
NotebookOutlinePosition[     22176,        662]
CellTagsIndexPosition[     22091,        657]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ControllerInformation" :> 
          Documentation`HelpLookup["paclet:ref/ControllerInformation"], 
          "ControllerPath" :> 
          Documentation`HelpLookup["paclet:ref/ControllerPath"], "Manipulate" :> 
          Documentation`HelpLookup["paclet:ref/Manipulate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ControllerInformation\"\>", 
       2->"\<\"ControllerPath\"\>", 
       3->"\<\"Manipulate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Gamepad & Device Interface" :> 
          Documentation`HelpLookup["paclet:guide/GamepadAndDeviceInterface"], 
          "Options & Styling for Interactive Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/OptionsAndStylingForInteractiveManipulation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Gamepad & Device Interface\"\>", 
       2->"\<\"Options & Styling for Interactive Manipulation\"\>"}, \
"\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ControllerLinking", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ControllerLinking",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ControllerLinking"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Manipulate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Plot3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
     " and related functions which specifies whether to allow interactive \
control by external controllers."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24115]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be given:", "Notes",
 CellID->839],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "never respond to external controllers", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Full",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Full"], Cell[
    "respond only if the object is within the current selection", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "respond if the object is within the current selection", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "respond whenever the notebook has focus  ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "always respond to external controllers", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->25858],

Cell[TextData[{
 "A new cell that contains an object with ",
 Cell[BoxData[
  RowBox[{"ControllerLinking", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " will automatically be selected if an external controller is moved \
immediately after the cell is generated."
}], "Notes",
 CellID->210324727]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->869166657],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(5)", "ExampleCount"]
}], "ExampleSection",
 CellID->172947842],

Cell["\<\
By default, the output will respond to an external controller if the object \
is selected:\
\>", "ExampleText",
 CellID->1474632954],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"Manipulate", "[", 
   RowBox[{"u", ",", " ", 
    RowBox[{"{", 
     RowBox[{"u", ",", " ", "0", ",", " ", "1"}], "}"}]}], "]"}],
  ShowStringCharacters->True,
  NumberMarks->True]], "Input",
 CellLabel->"In[1]:=",
 CellID->544645933],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$6718$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$6718$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[1]=",
 CellID->95767698]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->846126513],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["Full",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Full"]], "InlineFormula"],
 " makes the output respond only if the object is within the current \
selection:"
}], "ExampleText",
 CellID->47287851],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"Manipulate", "[", 
   RowBox[{"u", ",", " ", 
    RowBox[{"{", 
     RowBox[{"u", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
    RowBox[{"ControllerLinking", " ", "->", " ", "Full"}]}], "]"}],
  ShowStringCharacters->True,
  NumberMarks->True]], "Input",
 CellLabel->"In[1]:=",
 CellID->197962367],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$4628$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$4628$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {ControllerLinking -> Full}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[1]=",
 CellID->1787139942]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->211593557],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 " makes the output always respond to external controllers:"
}], "ExampleText",
 CellID->701332966],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"Manipulate", "[", 
   RowBox[{"u", ",", " ", 
    RowBox[{"{", 
     RowBox[{"u", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
    RowBox[{"ControllerLinking", " ", "->", " ", "All"}]}], "]"}],
  ShowStringCharacters->True,
  NumberMarks->True]], "Input",
 CellLabel->"In[1]:=",
 CellID->1912904826],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$4657$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$4657$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {ControllerLinking -> All}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[1]=",
 CellID->1754718252]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19993067],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " makes the output respond whenever the notebook has focus:"
}], "ExampleText",
 CellID->213731345],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"Manipulate", "[", 
   RowBox[{"u", ",", " ", 
    RowBox[{"{", 
     RowBox[{"u", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
    RowBox[{"ControllerLinking", " ", "->", " ", "True"}]}], "]"}],
  ShowStringCharacters->True,
  NumberMarks->True]], "Input",
 CellLabel->"In[1]:=",
 CellID->1590057631],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0.00529436944622766, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {70., {0., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$4685$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$4685$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {ControllerLinking -> True}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[1]=",
 CellID->156737113]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1016028137],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " makes the output never respond to external controllers:"
}], "ExampleText",
 CellID->812100949],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{"Manipulate", "[", 
    RowBox[{"u", ",", " ", 
     RowBox[{"{", 
      RowBox[{"u", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
     RowBox[{"ControllerLinking", " ", "->", " ", "False"}]}], "]"}],
   ShowStringCharacters->True,
   NumberMarks->True],
  InputForm[
   Manipulate[$CellContext`u, {$CellContext`u, 0, 1}, ControllerLinking -> 
    False]],
  AutoDelete->True,
  Editable->True]], "Input",
 CellLabel->"In[1]:=",
 CellID->1722073158],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$4713$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$4713$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {ControllerLinking -> False}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[1]=",
 CellID->1465706969]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->675],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ControllerInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControllerInformation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ControllerPath",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControllerPath"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Manipulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21862]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->187802014],

Cell[TextData[ButtonBox["Gamepad & Device Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GamepadAndDeviceInterface"]], "MoreAbout",
 CellID->280642392],

Cell[TextData[ButtonBox["Options & Styling for Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/OptionsAndStylingForInteractiveManipulation"]], "MoreAbout",
 CellID->218685463]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ControllerLinking - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 34, 56.0341790}", "context" -> "System`", 
    "keywords" -> {
     "controller hookup", "controller linking", "controller attachment", 
      "attaching controllers", "controller device", "HID", 
      "human interface device"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ControllerLinking is an option for Manipulate, Graphics3D, Plot3D and \
related functions which specifies whether to allow interactive control by \
external controllers.", "synonyms" -> {"controller linking"}, "title" -> 
    "ControllerLinking", "type" -> "Symbol", "uri" -> 
    "ref/ControllerLinking"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7143, 210, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->869166657]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21948, 650}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1697, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2320, 67, 1582, 37, 70, "ObjectNameGrid"],
Cell[3905, 106, 961, 29, 70, "Usage",
 CellID->24115]
}, Open  ]],
Cell[CellGroupData[{
Cell[4903, 140, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5381, 157, 67, 1, 70, "Notes",
 CellID->839],
Cell[5451, 160, 1282, 33, 70, "2ColumnTableMod",
 CellID->25858],
Cell[6736, 195, 370, 10, 70, "Notes",
 CellID->210324727]
}, Closed]],
Cell[CellGroupData[{
Cell[7143, 210, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->869166657],
Cell[CellGroupData[{
Cell[7528, 224, 148, 5, 70, "ExampleSection",
 CellID->172947842],
Cell[7679, 231, 142, 4, 70, "ExampleText",
 CellID->1474632954],
Cell[CellGroupData[{
Cell[7846, 239, 270, 9, 28, "Input",
 CellID->544645933],
Cell[8119, 250, 1465, 32, 124, "Output",
 CellID->95767698]
}, Open  ]],
Cell[9599, 285, 125, 3, 70, "ExampleDelimiter",
 CellID->846126513],
Cell[9727, 290, 258, 9, 70, "ExampleText",
 CellID->47287851],
Cell[CellGroupData[{
Cell[10010, 303, 340, 10, 70, "Input",
 CellID->197962367],
Cell[10353, 315, 1492, 32, 70, "Output",
 CellID->1787139942]
}, Open  ]],
Cell[11860, 350, 125, 3, 70, "ExampleDelimiter",
 CellID->211593557],
Cell[11988, 355, 235, 8, 70, "ExampleText",
 CellID->701332966],
Cell[CellGroupData[{
Cell[12248, 367, 340, 10, 70, "Input",
 CellID->1912904826],
Cell[12591, 379, 1491, 32, 70, "Output",
 CellID->1754718252]
}, Open  ]],
Cell[14097, 414, 124, 3, 70, "ExampleDelimiter",
 CellID->19993067],
Cell[14224, 419, 238, 8, 70, "ExampleText",
 CellID->213731345],
Cell[CellGroupData[{
Cell[14487, 431, 341, 10, 70, "Input",
 CellID->1590057631],
Cell[14831, 443, 1510, 32, 70, "Output",
 CellID->156737113]
}, Open  ]],
Cell[16356, 478, 126, 3, 70, "ExampleDelimiter",
 CellID->1016028137],
Cell[16485, 483, 238, 8, 70, "ExampleText",
 CellID->812100949],
Cell[CellGroupData[{
Cell[16748, 495, 511, 16, 70, "Input",
 CellID->1722073158],
Cell[17262, 513, 1493, 32, 70, "Output",
 CellID->1465706969]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18816, 552, 309, 9, 70, "SeeAlsoSection",
 CellID->675],
Cell[19128, 563, 738, 26, 70, "SeeAlso",
 CellID->21862]
}, Open  ]],
Cell[CellGroupData[{
Cell[19903, 594, 319, 9, 70, "MoreAboutSection",
 CellID->187802014],
Cell[20225, 605, 163, 3, 70, "MoreAbout",
 CellID->280642392],
Cell[20391, 610, 204, 4, 70, "MoreAbout",
 CellID->218685463]
}, Open  ]],
Cell[20610, 617, 27, 0, 70, "History"],
Cell[20640, 619, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

