(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24151,        722]
NotebookOptionsPosition[     20267,        612]
NotebookOutlinePosition[     22433,        662]
CellTagsIndexPosition[     22348,        657]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Advanced Dynamic Functionality" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedDynamicFunctionality"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>", 
       2->"\<\"Advanced Dynamic Functionality\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulate" :> 
          Documentation`HelpLookup["paclet:ref/Manipulate"], 
          "ControllerInformation" :> 
          Documentation`HelpLookup["paclet:ref/ControllerInformation"], 
          "ControllerState" :> 
          Documentation`HelpLookup["paclet:ref/ControllerState"], 
          "LocalizeVariables" :> 
          Documentation`HelpLookup["paclet:ref/LocalizeVariables"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Manipulate\"\>", 
       2->"\<\"ControllerInformation\"\>", 3->"\<\"ControllerState\"\>", 
       4->"\<\"LocalizeVariables\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], 
          "Gamepad & Device Interface" :> 
          Documentation`HelpLookup["paclet:guide/GamepadAndDeviceInterface"], 
          "Interactive Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/InteractiveManipulation"], 
          "New in 6.0: System Interfaces & Deployment" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60SystemInterfacesAndDeployment"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Custom Interface Construction\"\>", 
       2->"\<\"Gamepad & Device Interface\"\>", 
       3->"\<\"Interactive Manipulation\"\>", 
       4->"\<\"New in 6.0: System Interfaces & Deployment\"\>", 
       5->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ControllerManipulate", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ControllerManipulate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ControllerManipulate"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["u", "TI"], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a version of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " set up to allow interactive manipulation of the value of ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " using an external controller device."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ControllerManipulate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ControllerManipulate"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["u", "TI"], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["du", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]allows the value of ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " to vary between ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " in steps ",
     Cell[BoxData[
      StyleBox["du", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ControllerManipulate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ControllerManipulate"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            StyleBox["u", "TI"], ",", 
            SubscriptBox[
             StyleBox["u", "TI"], 
             StyleBox["init", "TI"]]}], "}"}], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes the initial value of ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " to be ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["init", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ControllerManipulate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ControllerManipulate"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["u", "TI"], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["u", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["u", "TI"], 
             StyleBox["2", "TR"]], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]allows ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " to take on discrete values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ControllerManipulate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ControllerManipulate"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["u", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["v", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]allows each of the ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     ", \[Ellipsis] to be manipulated by the external controller device. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ControllerManipulate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ControllerManipulate"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"u\", \"TI\"]]\)\>\"", "->", 
         RowBox[{"{", 
          RowBox[{
           StyleBox["u", "TI"], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], ",", 
        RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"v\", \"TI\"]]\)\>\"", "->", 
         RowBox[{"{", 
          RowBox[{
           StyleBox["v", "TI"], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]links the parameters to the specified controllers on \
the external controller device."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->26633]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ControllerManipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControllerManipulate"]], "InlineFormula"],
 " has the same features and options as ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ", but by default does not explicitly display any controls or frame."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ControllerMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControllerMethod"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", successive parameters will be controlled by successive controls on the \
external controller device."
}], "Notes",
 CellID->270497548]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->9537525],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->318218893],

Cell["Use a controller to change the sinusoids:", "ExampleText",
 CellID->1703178356],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ControllerManipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"x", "+", "a"}], "]"}], "+", "b"}], ",", 
       RowBox[{
        RowBox[{"Sinc", "[", 
         RowBox[{"x", "+", "c"}], "]"}], "+", "d"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{
        RowBox[{"-", "2"}], "Pi"}], ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1200685644],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 0, $CellContext`b$$ = 
    0, $CellContext`c$$ = 0, $CellContext`d$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`a$$], 0, 10}, {
      Hold[$CellContext`b$$], 0, 1}, {
      Hold[$CellContext`c$$], 0, 10}, {
      Hold[$CellContext`d$$], 0, 1}}, Typeset`size$$ = {180., {60., 64.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`a$32913$$ = 0, $CellContext`b$32914$$ = 
    0, $CellContext`c$32915$$ = 0, $CellContext`d$32916$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 0, $CellContext`b$$ = 
        0, $CellContext`c$$ = 0, $CellContext`d$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$32913$$, 0], 
        Hold[$CellContext`b$$, $CellContext`b$32914$$, 0], 
        Hold[$CellContext`c$$, $CellContext`c$32915$$, 0], 
        Hold[$CellContext`d$$, $CellContext`d$32916$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[{Sin[$CellContext`x + $CellContext`a$$] + $CellContext`b$$, 
         Sinc[$CellContext`x + $CellContext`c$$] + $CellContext`d$$}, \
{$CellContext`x, (-2) Pi, 2 Pi}, PlotRange -> 2], 
      "Specifications" :> {{$CellContext`a$$, 0, 10}, {$CellContext`b$$, 0, 
         1}, {$CellContext`c$$, 0, 10}, {$CellContext`d$$, 0, 1}}, 
      "Options" :> {
       AppearanceElements -> {}, ControlType -> None, Paneled -> False, 
        SynchronousUpdating -> True}, "DefaultOptions" :> {}],
     ImageSizeCache->{200., {70., 75.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{204, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->446684965]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Manipulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ControllerInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControllerInformation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ControllerState",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControllerState"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LocalizeVariables",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LocalizeVariables"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Advanced Dynamic Functionality",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"]], "Tutorials",
 CellID->558945376]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->1019017406],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->79006704],

Cell[TextData[ButtonBox["Gamepad & Device Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GamepadAndDeviceInterface"]], "MoreAbout",
 CellID->643163554],

Cell[TextData[ButtonBox["Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InteractiveManipulation"]], "MoreAbout",
 CellID->40498093],

Cell[TextData[ButtonBox["New in 6.0: System Interfaces & Deployment",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60SystemInterfacesAndDeployment"]], "MoreAbout",
 CellID->432698498],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->69885193]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ControllerManipulate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 34, 57.4717158}", "context" -> "System`", 
    "keywords" -> {
     "external controller devices", "controller device", "HID", 
      "human interface control", "gamepad", "joystick", "space mouse"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ControllerManipulate[expr, {u, u_min, u_max}] generates a version of \
expr set up to allow interactive manipulation of the value of u using an \
external controller device. ControllerManipulate[expr, {u, u_min, u_max, du}] \
allows the value of u to vary between u_min and u_max in steps du. \
ControllerManipulate[expr, {{u, u_init}, u_min, u_max, ...}] takes the \
initial value of u to be u_init. ControllerManipulate[expr, {u, {u_1, u_2, \
...}}] allows u to take on discrete values u_1, u_2, .... \
ControllerManipulate[expr, {u, ...}, {v, ...}, \\ ...] allows each of the u, \
v, ... to be manipulated by the external controller device. \
ControllerManipulate[expr, \"SubscriptBox[ c, u]\" -> {u, ...}, \
\"SubscriptBox[ c, v]\" -> {v, ...}, ...] links the parameters to the \
specified controllers on the external controller device.", 
    "synonyms" -> {"controller manipulate"}, "title" -> 
    "ControllerManipulate", "type" -> "Symbol", "uri" -> 
    "ref/ControllerManipulate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12867, 381, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->9537525]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22206, 650}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3159, 71, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3782, 98, 1585, 37, 70, "ObjectNameGrid"],
Cell[5370, 137, 6081, 190, 70, "Usage",
 CellID->26633]
}, Open  ]],
Cell[CellGroupData[{
Cell[11488, 332, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[11966, 349, 429, 12, 70, "Notes",
 CellID->1067943069],
Cell[12398, 363, 432, 13, 70, "Notes",
 CellID->270497548]
}, Closed]],
Cell[CellGroupData[{
Cell[12867, 381, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->9537525],
Cell[CellGroupData[{
Cell[13250, 395, 148, 5, 70, "ExampleSection",
 CellID->318218893],
Cell[13401, 402, 85, 1, 70, "ExampleText",
 CellID->1703178356],
Cell[CellGroupData[{
Cell[13511, 407, 892, 28, 65, "Input",
 CellID->1200685644],
Cell[14406, 437, 2478, 51, 168, "Output",
 CellID->446684965]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16945, 495, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[17264, 506, 1007, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[18308, 546, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[18629, 557, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[18791, 562, 173, 3, 70, "Tutorials",
 CellID->558945376]
}, Open  ]],
Cell[CellGroupData[{
Cell[19001, 570, 320, 9, 70, "MoreAboutSection",
 CellID->1019017406],
Cell[19324, 581, 167, 3, 70, "MoreAbout",
 CellID->79006704],
Cell[19494, 586, 163, 3, 70, "MoreAbout",
 CellID->643163554],
Cell[19660, 591, 158, 3, 70, "MoreAbout",
 CellID->40498093],
Cell[19821, 596, 193, 4, 70, "MoreAbout",
 CellID->432698498],
Cell[20017, 602, 178, 3, 70, "MoreAbout",
 CellID->69885193]
}, Open  ]],
Cell[20210, 608, 27, 0, 70, "History"],
Cell[20240, 610, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

