(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25700,        900]
NotebookOptionsPosition[     20740,        737]
NotebookOutlinePosition[     22166,        777]
CellTagsIndexPosition[     22081,        772]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Appearance" :> 
          Documentation`HelpLookup["paclet:ref/Appearance"], "ControlType" :> 
          Documentation`HelpLookup["paclet:ref/ControlType"], "Slider" :> 
          Documentation`HelpLookup["paclet:ref/Slider"], "Manipulate" :> 
          Documentation`HelpLookup["paclet:ref/Manipulate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Appearance\"\>", 
       2->"\<\"ControlType\"\>", 3->"\<\"Slider\"\>", 
       4->"\<\"Manipulate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Controls Options" :> 
          Documentation`HelpLookup["paclet:guide/ControlsOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Controls Options\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ControlsRendering", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ControlsRendering",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ControlsRendering"]], "InlineFormula"],
     " \[LineSeparator]is a ",
     Cell[BoxData[
      ButtonBox["Style",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Style"]], "InlineFormula"],
     " option that specifies how controls should be rendered."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Possible settings include:", "Notes",
 CellID->1067943069],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "Automatic", Cell[
    "use native control appearances for the computer system", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Generic\>\"", Cell[
    "use generic control appearances", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->349983646]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->182863042],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(9)", "ExampleCount"]
}], "ExampleSection",
 CellID->64284219],

Cell[TextData[{
 "Compare the default and generic appearances of ",
 Cell[BoxData[
  ButtonBox["Slider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->972670439],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", "]"}], ",", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Slider", "[", "]"}], ",", 
     RowBox[{"ControlsRendering", "\[Rule]", "\"\<Generic\>\""}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1435729129],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[0.5], ",", 
   StyleBox[
    SliderBox[0.5],
    ControlsRendering->"Generic",
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{430, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->111587005]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->912564848],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Checkbox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Checkbox"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1026547309],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Checkbox", "[", "]"}], ",", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Checkbox", "[", "]"}], ",", 
     RowBox[{"ControlsRendering", "\[Rule]", "\"\<Generic\>\""}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1540587701],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   CheckboxBox[False], ",", 
   StyleBox[
    CheckboxBox[False],
    ControlsRendering->"Generic",
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{56, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->689569204]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->826669350],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RadioButton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RadioButton"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1771134871],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RadioButton", "[", 
    RowBox[{"1", ",", "1"}], "]"}], ",", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"RadioButton", "[", 
      RowBox[{"1", ",", "1"}], "]"}], ",", 
     RowBox[{"ControlsRendering", "\[Rule]", "\"\<Generic\>\""}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->112136915],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RadioButtonBox[1, {1}], ",", 
   StyleBox[
    RadioButtonBox[1, {1}],
    ControlsRendering->"Generic",
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{68, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1211594372]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->149193462],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PopupMenu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupMenu"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->297002365],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PopupMenu", "[", 
    RowBox[{"1", ",", 
     RowBox[{"Range", "[", "10", "]"}]}], "]"}], ",", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"PopupMenu", "[", 
      RowBox[{"1", ",", 
       RowBox[{"Range", "[", "10", "]"}]}], "]"}], ",", 
     RowBox[{"ControlsRendering", "\[Rule]", "\"\<Generic\>\""}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->220845980],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PopupMenuBox[1, {1->"1", 2->"2", 3->"3", 4->"4", 5->"5", 6->"6", 7->"7", 8->
    "8", 9->"9", 10->"10"}], ",", 
   StyleBox[
    PopupMenuBox[1, {1->"1", 2->"2", 3->"3", 4->"4", 5->"5", 6->"6", 7->"7", 
     8->"8", 9->"9", 10->"10"}],
    ControlsRendering->"Generic",
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{114, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->181740928]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1381099785],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InputField",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputField"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1908740239],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InputField", "[", "]"}], ",", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"InputField", "[", "]"}], ",", 
     RowBox[{"ControlsRendering", "\[Rule]", "\"\<Generic\>\""}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->355170887],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`i$$ = Null}, 
     InputFieldBox[Dynamic[Typeset`i$$]],
     DynamicModuleValues:>{}],
    InputField[
     Setting[#]]& ], ",", 
   StyleBox[
    TagBox[
     DynamicModuleBox[{Typeset`i$$ = Null}, 
      InputFieldBox[Dynamic[Typeset`i$$]],
      DynamicModuleValues:>{}],
     InputField[
      Setting[#]]& ],
    ControlsRendering->"Generic",
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{552, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1500042796]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2140829719],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Button",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Button"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->593177346],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Button", "[", "\"\<xxx\>\"", "]"}], ",", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Button", "[", "\"\<xxx\>\"", "]"}], ",", 
     RowBox[{"ControlsRendering", "\[Rule]", "\"\<Generic\>\""}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1086477987],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ButtonBox["\<\"xxx\"\>",
    Appearance->Automatic,
    ButtonData->"paclet:ref/xxx",
    ButtonFrame->"DialogBox",
    ButtonFunction:>{},
    Evaluator->None,
    Method->"Preemptive"], ",", 
   StyleBox[
    ButtonBox["\<\"xxx\"\>",
     Appearance->Automatic,
     ButtonData->"paclet:ref/xxx",
     ButtonFrame->"DialogBox",
     ButtonFunction:>{},
     Evaluator->None,
     Method->"Preemptive"],
    ControlsRendering->"Generic",
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{86, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->382077068]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1192945830],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Setter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Setter"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->61023149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Setter", "[", 
    RowBox[{"1", ",", "1"}], "]"}], ",", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Setter", "[", 
      RowBox[{"1", ",", "1"}], "]"}], ",", 
     RowBox[{"ControlsRendering", "\[Rule]", "\"\<Generic\>\""}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1266365624],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SetterBox[1, {1}, "1"], ",", 
   StyleBox[
    SetterBox[1, {1}, "1"],
    ControlsRendering->"Generic",
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{56, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1097194872]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->659339126],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Slider2D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider2D"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->933236418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider2D", "[", "]"}], ",", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Slider2D", "[", "]"}], ",", 
     RowBox[{"ControlsRendering", "\[Rule]", "\"\<Generic\>\""}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1831403285],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Slider2DBox[{0.5, 0.5}], ",", 
   StyleBox[
    Slider2DBox[{0.26, 0.41000000000000003`}],
    ControlsRendering->"Generic",
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{190, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->511898544]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1984065395],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->966752927],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Manipulate", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Manipulate", "[", 
      RowBox[{"x", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{"ControlsRendering", "\[Rule]", "\"\<Generic\>\""}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1353141343],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`x$$ = 0.12373001886358258`, 
      Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
      Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ =
       1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`x$$], 0, 1}}, Typeset`size$$ = {49., {0., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`x$27819$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`x$$, $CellContext`x$27819$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`x$$, 
        "Specifications" :> {{$CellContext`x$$, 0, 1}}, "Options" :> {}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{249., {48., 53.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   StyleBox[
    TagBox[
     StyleBox[
      DynamicModuleBox[{$CellContext`x$$ = 0.266462115348279, Typeset`show$$ =
        True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
       Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
       "\"untitled\"", Typeset`specs$$ = {{
         Hold[$CellContext`x$$], 0, 1}}, Typeset`size$$ = {56., {0., 8.}}, 
       Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
       True, $CellContext`x$27836$$ = 0}, 
       DynamicBox[Manipulate`ManipulateBoxes[
        1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
         "ControllerVariables" :> {
           Hold[$CellContext`x$$, $CellContext`x$27836$$, 0]}, 
         "OtherVariables" :> {
          Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
           Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
           Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
           Typeset`initDone$$, Typeset`skipInitDone$$}, 
         "Body" :> $CellContext`x$$, 
         "Specifications" :> {{$CellContext`x$$, 0, 1}}, "Options" :> {}, 
         "DefaultOptions" :> {}],
        ImageSizeCache->{249., {47., 52.}},
        SingleEvaluation->True],
       Deinitialization:>None,
       DynamicModuleValues:>{},
       SynchronousInitialization->True,
       UnsavedVariables:>{Typeset`initDone$$},
       UntrackedVariables:>{Typeset`size$$}], "Manipulate",
      Deployed->True,
      StripOnInput->False],
     Manipulate`InterpretManipulate[1]],
    ControlsRendering->"Generic",
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{528, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->651317714]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Appearance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Appearance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ControlType",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControlType"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Slider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Manipulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Controls Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlsOptions"]], "MoreAbout",
 CellID->335170181]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ControlsRendering - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 35, 1.3311896}", "context" -> "System`", 
    "keywords" -> {
     "generic controls appearance", "native controls appearance", 
      "controls rendering", "rendering GUI elements", "rendering controls", 
      "GUI appearance"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ControlsRendering is a Style option that specifies how controls should \
be rendered.", "synonyms" -> {"controls rendering"}, "title" -> 
    "ControlsRendering", "type" -> "Symbol", "uri" -> 
    "ref/ControlsRendering"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5401, 160, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->182863042]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21938, 765}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1461, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2084, 62, 1582, 37, 70, "ObjectNameGrid"],
Cell[3669, 101, 604, 18, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4310, 124, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4788, 141, 64, 1, 70, "Notes",
 CellID->1067943069],
Cell[4855, 144, 509, 11, 70, "2ColumnTableMod",
 CellID->349983646]
}, Closed]],
Cell[CellGroupData[{
Cell[5401, 160, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->182863042],
Cell[CellGroupData[{
Cell[5786, 174, 147, 5, 70, "ExampleSection",
 CellID->64284219],
Cell[5936, 181, 226, 8, 70, "ExampleText",
 CellID->972670439],
Cell[CellGroupData[{
Cell[6187, 193, 299, 10, 28, "Input",
 CellID->1435729129],
Cell[6489, 205, 308, 12, 46, "Output",
 CellID->111587005]
}, Open  ]],
Cell[6812, 220, 125, 3, 70, "ExampleDelimiter",
 CellID->912564848],
Cell[6940, 225, 179, 7, 70, "ExampleText",
 CellID->1026547309],
Cell[CellGroupData[{
Cell[7144, 236, 303, 10, 70, "Input",
 CellID->1540587701],
Cell[7450, 248, 315, 12, 70, "Output",
 CellID->689569204]
}, Open  ]],
Cell[7780, 263, 125, 3, 70, "ExampleDelimiter",
 CellID->826669350],
Cell[7908, 268, 185, 7, 70, "ExampleText",
 CellID->1771134871],
Cell[CellGroupData[{
Cell[8118, 279, 370, 12, 70, "Input",
 CellID->112136915],
Cell[8491, 293, 324, 12, 70, "Output",
 CellID->1211594372]
}, Open  ]],
Cell[8830, 308, 125, 3, 70, "ExampleDelimiter",
 CellID->149193462],
Cell[8958, 313, 180, 7, 70, "ExampleText",
 CellID->297002365],
Cell[CellGroupData[{
Cell[9163, 324, 440, 14, 70, "Input",
 CellID->220845980],
Cell[9606, 340, 489, 14, 70, "Output",
 CellID->181740928]
}, Open  ]],
Cell[10110, 357, 126, 3, 70, "ExampleDelimiter",
 CellID->1381099785],
Cell[10239, 362, 183, 7, 70, "ExampleText",
 CellID->1908740239],
Cell[CellGroupData[{
Cell[10447, 373, 306, 10, 70, "Input",
 CellID->355170887],
Cell[10756, 385, 606, 22, 70, "Output",
 CellID->1500042796]
}, Open  ]],
Cell[11377, 410, 126, 3, 70, "ExampleDelimiter",
 CellID->2140829719],
Cell[11506, 415, 174, 7, 70, "ExampleText",
 CellID->593177346],
Cell[CellGroupData[{
Cell[11705, 426, 329, 10, 70, "Input",
 CellID->1086477987],
Cell[12037, 438, 657, 24, 70, "Output",
 CellID->382077068]
}, Open  ]],
Cell[12709, 465, 126, 3, 70, "ExampleDelimiter",
 CellID->1192945830],
Cell[12838, 470, 173, 7, 70, "ExampleText",
 CellID->61023149],
Cell[CellGroupData[{
Cell[13036, 481, 361, 12, 70, "Input",
 CellID->1266365624],
Cell[13400, 495, 324, 12, 70, "Output",
 CellID->1097194872]
}, Open  ]],
Cell[13739, 510, 125, 3, 70, "ExampleDelimiter",
 CellID->659339126],
Cell[13867, 515, 178, 7, 70, "ExampleText",
 CellID->933236418],
Cell[CellGroupData[{
Cell[14070, 526, 303, 10, 70, "Input",
 CellID->1831403285],
Cell[14376, 538, 344, 12, 70, "Output",
 CellID->511898544]
}, Open  ]],
Cell[14735, 553, 126, 3, 70, "ExampleDelimiter",
 CellID->1984065395],
Cell[14864, 558, 182, 7, 70, "ExampleText",
 CellID->966752927],
Cell[CellGroupData[{
Cell[15071, 569, 499, 16, 70, "Input",
 CellID->1353141343],
Cell[15573, 587, 3278, 72, 70, "Output",
 CellID->651317714]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18912, 666, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[19231, 677, 955, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[20223, 717, 299, 8, 70, "MoreAboutSection"],
Cell[20525, 727, 143, 3, 70, "MoreAbout",
 CellID->335170181]
}, Open  ]],
Cell[20683, 733, 27, 0, 70, "History"],
Cell[20713, 735, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

