(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29815,       1084]
NotebookOptionsPosition[     23913,        880]
NotebookOutlinePosition[     25289,        918]
CellTagsIndexPosition[     25204,        913]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FromContinuedFraction" :> 
          Documentation`HelpLookup["paclet:ref/FromContinuedFraction"], 
          "Rationalize" :> Documentation`HelpLookup["paclet:ref/Rationalize"],
           "ContinuedFraction" :> 
          Documentation`HelpLookup["paclet:ref/ContinuedFraction"], "Divide" :> 
          Documentation`HelpLookup["paclet:ref/Divide"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FromContinuedFraction\"\>", 
       2->"\<\"Rationalize\"\>", 3->"\<\"ContinuedFraction\"\>", 
       4->"\<\"Divide\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Numbers" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicNumbers"], 
          "Continued Fractions & Rational Approximations" :> 
          Documentation`HelpLookup[
           "paclet:guide/ContinuedFractionsAndRationalApproximations"], 
          "Number Recognition" :> 
          Documentation`HelpLookup["paclet:guide/NumberRecognition"], 
          "New in 6.0: Number Theory & Integer Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Algebraic Numbers\"\>", 
       2->"\<\"Continued Fractions & Rational Approximations\"\>", 
       3->"\<\"Number Recognition\"\>", 
       4->"\<\"New in 6.0: Number Theory & Integer Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Convergents", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Convergents",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Convergents"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a list of the convergents corresponding to the \
continued fraction terms ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Convergents",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Convergents"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the first ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " convergents for a number ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Convergents",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Convergents"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives if possible all convergents leading to the number \
",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->9373]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The convergents of the continued fraction ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["a", "TI"], 
    StyleBox["1", "TR"]], "+", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["2", "TR"]], "+", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox[
          StyleBox["a", "TI"], 
          StyleBox["3", "TR"]], "+", 
         StyleBox["\[Ellipsis]", "TR"]}], ")"}]}]}], ")"}]}]}]], 
  "InlineFormula"],
 " are the rationals ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["a", "TI"], 
    StyleBox["1", "TR"]], ",", 
   RowBox[{
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["1", "TR"]], "+", 
    RowBox[{"1", "/", 
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["2", "TR"]]}]}], ",", 
   RowBox[{
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["1", "TR"]], "+", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["2", "TR"]], "+", 
       RowBox[{"1", "/", 
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["3", "TR"]]}]}], ")"}]}]}], ",", 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9346],

Cell[TextData[{
 "For exact numbers, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convergents",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Convergents"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " can be used if ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is rational or a quadratic irrational."
}], "Notes",
 CellID->2688],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is a quadratic irrational or a representation of a quadratic irrational as \
a continued fraction, the final list element returned by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convergents",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Convergents"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " is the quadratic irrational represented by ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->12244],

Cell[TextData[{
 "For inexact numbers, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convergents",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Convergents"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " generates a list of all convergents that can be obtained given the \
precision of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->31622],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convergents",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Convergents"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " will return ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " convergents if possible. If ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " represents a rational or an inexact number, fewer than ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " terms may be returned."
}], "Notes",
 CellID->10198]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->155461870],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->92196182],

Cell["Generate the first 10 convergents to the Golden Ratio:", "ExampleText",
 CellID->155905724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convergents", "[", 
  RowBox[{"GoldenRatio", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->495135882],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", 
   FractionBox["3", "2"], ",", 
   FractionBox["5", "3"], ",", 
   FractionBox["8", "5"], ",", 
   FractionBox["13", "8"], ",", 
   FractionBox["21", "13"], ",", 
   FractionBox["34", "21"], ",", 
   FractionBox["55", "34"], ",", 
   FractionBox["89", "55"]}], "}"}]], "Output",
 ImageSize->{257, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49009856]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->427937408],

Cell[TextData[{
 "Generate convergents from the continued fraction terms for ",
 Cell[BoxData[
  ButtonBox["GoldenRatio",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GoldenRatio"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->151564373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convergents", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->102794176],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", 
   FractionBox["3", "2"], ",", 
   FractionBox["5", "3"], ",", 
   FractionBox["8", "5"]}], "}"}]], "Output",
 ImageSize->{111, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->162179022]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->216311208],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convergents", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->126891196],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   FractionBox[
    RowBox[{"1", "+", 
     RowBox[{"a", " ", "b"}]}], "b"], ",", 
   FractionBox[
    RowBox[{"a", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"a", " ", "b"}]}], ")"}], " ", "c"}]}], 
    RowBox[{"1", "+", 
     RowBox[{"b", " ", "c"}]}]], ",", 
   FractionBox[
    RowBox[{"1", "+", 
     RowBox[{"a", " ", "b"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"a", " ", "b"}]}], ")"}], " ", "c"}]}], ")"}], " ", 
      "d"}]}], 
    RowBox[{"b", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"b", " ", "c"}]}], ")"}], " ", "d"}]}]]}], "}"}]], "Output",
 ImageSize->{342, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36331781]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21502],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{"Pi", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->167769903],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "7", ",", "15", ",", "1", ",", "292", ",", "1", ",", "1", ",", 
   "1", ",", "2", ",", "1"}], "}"}]], "Output",
 ImageSize->{210, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->152269411]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convergents", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11134025],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   FractionBox["22", "7"], ",", 
   FractionBox["333", "106"], ",", 
   FractionBox["355", "113"], ",", 
   FractionBox["103993", "33102"], ",", 
   FractionBox["104348", "33215"], ",", 
   FractionBox["208341", "66317"], ",", 
   FractionBox["312689", "99532"], ",", 
   FractionBox["833719", "265381"], ",", 
   FractionBox["1146408", "364913"]}], "}"}]], "Output",
 ImageSize->{493, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->522943271]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convergents", "[", 
  RowBox[{"Pi", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->365303145],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   FractionBox["22", "7"], ",", 
   FractionBox["333", "106"], ",", 
   FractionBox["355", "113"], ",", 
   FractionBox["103993", "33102"], ",", 
   FractionBox["104348", "33215"], ",", 
   FractionBox["208341", "66317"], ",", 
   FractionBox["312689", "99532"], ",", 
   FractionBox["833719", "265381"], ",", 
   FractionBox["1146408", "364913"]}], "}"}]], "Output",
 ImageSize->{493, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->222322187]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->630024835],

Cell["Quadratic irrationals have periodic continued fractions:", "ExampleText",
 CellID->303356017],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{"Sqrt", "[", "7", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->166883876],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->428259421]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convergents", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->212907639],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3", ",", 
   FractionBox["5", "2"], ",", 
   FractionBox["8", "3"], ",", 
   SqrtBox["7"]}], "}"}]], "Output",
 ImageSize->{123, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->123137355]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convergents", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "7", "]"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->202469662],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3", ",", 
   FractionBox["5", "2"], ",", 
   FractionBox["8", "3"], ",", 
   FractionBox["37", "14"], ",", 
   FractionBox["45", "17"], ",", 
   FractionBox["82", "31"], ",", 
   FractionBox["127", "48"], ",", 
   FractionBox["590", "223"], ",", 
   FractionBox["717", "271"]}], "}"}]], "Output",
 ImageSize->{285, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->57190375]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->34936731],

Cell["Give all convergents for a rational number:", "ExampleText",
 CellID->48713004],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convergents", "[", 
  RowBox[{"7", "/", "17"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->461324702],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox["1", "2"], ",", 
   FractionBox["2", "5"], ",", 
   FractionBox["7", "17"]}], "}"}]], "Output",
 ImageSize->{99, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->559735199]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->62693655],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Convergents",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Convergents"]], "InlineFormula"],
 " continues until the precision of the input is reached:"
}], "ExampleText",
 CellID->188128395],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convergents", "[", "5.67567", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->432205233],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "6", ",", 
   FractionBox["17", "3"], ",", 
   FractionBox["210", "37"], ",", 
   FractionBox["26897", "4739"], ",", 
   FractionBox["27107", "4776"], ",", 
   FractionBox["54004", "9515"], ",", 
   FractionBox["81111", "14291"], ",", 
   FractionBox["135115", "23806"], ",", 
   FractionBox["216226", "38097"]}], "}"}]], "Output",
 ImageSize->{438, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->132201342]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9831],

Cell["\<\
The convergents of a number converge to it while alternating sides:\
\>", "ExampleText",
 CellID->7826],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Convergents", "[", 
   RowBox[{"\[Pi]", ",", "10"}], "]"}], "-", 
  RowBox[{"N", "[", "\[Pi]", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19651],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.14159265358979312`"}], ",", "0.0012644892673496777`", ",", 
   
   RowBox[{"-", "0.0000832196275291075`"}], ",", "2.667641894049666`*^-7", 
   ",", 
   RowBox[{"-", "5.778906242426274`*^-10"}], ",", "3.3162805834763276`*^-10", 
   ",", 
   RowBox[{"-", "1.2235634727630895`*^-10"}], ",", "2.914335439641036`*^-11", 
   ",", 
   RowBox[{"-", "8.715250743307479`*^-12"}], ",", 
   "1.6107115641261771`*^-12"}], "}"}]], "Output",
 ImageSize->{527, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27978]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->693058674],

Cell[TextData[{
 "The results from ",
 Cell[BoxData[
  ButtonBox["Rationalize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rationalize"]], "InlineFormula"],
 " are not always among the list of convergents:"
}], "ExampleText",
 CellID->16337581],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rationalize", "[", 
  RowBox[{"Pi", ",", 
   RowBox[{"1", "/", "1000"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->199541071],

Cell[BoxData[
 FractionBox["201", "64"]], "Output",
 ImageSize->{30, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->192097174]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convergents", "[", 
  RowBox[{"Pi", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->322375566],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   FractionBox["22", "7"], ",", 
   FractionBox["333", "106"], ",", 
   FractionBox["355", "113"], ",", 
   FractionBox["103993", "33102"], ",", 
   FractionBox["104348", "33215"], ",", 
   FractionBox["208341", "66317"], ",", 
   FractionBox["312689", "99532"], ",", 
   FractionBox["833719", "265381"], ",", 
   FractionBox["1146408", "364913"]}], "}"}]], "Output",
 ImageSize->{493, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->120837039]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22946],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromContinuedFraction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FromContinuedFraction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rationalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rationalize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ContinuedFraction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContinuedFraction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Divide",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Divide"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12003]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->672363112],

Cell[TextData[ButtonBox["Algebraic Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumbers"]], "MoreAbout",
 CellID->413714256],

Cell[TextData[ButtonBox["Continued Fractions & Rational Approximations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ContinuedFractionsAndRationalApproximations"]], "MoreAbout",
 CellID->369487734],

Cell[TextData[ButtonBox["Number Recognition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberRecognition"]], "MoreAbout",
 CellID->3787929],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "MoreAbout",
 CellID->29271938]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Convergents - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 35, 2.9874820}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Convergents[list] gives a list of the convergents corresponding to the \
continued fraction terms list. Convergents[x, n] gives the first n \
convergents for a number x. Convergents[x] gives if possible all convergents \
leading to the number x.", "synonyms" -> {}, "title" -> "Convergents", "type" -> 
    "Symbol", "uri" -> "ref/Convergents"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9617, 313, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->155461870]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25061, 906}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2143, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2766, 74, 1576, 37, 70, "ObjectNameGrid"],
Cell[4345, 113, 1516, 49, 70, "Usage",
 CellID->9373]
}, Open  ]],
Cell[CellGroupData[{
Cell[5898, 167, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6376, 184, 1319, 52, 70, "Notes",
 CellID->9346],
Cell[7698, 238, 364, 13, 70, "Notes",
 CellID->2688],
Cell[8065, 253, 536, 17, 70, "Notes",
 CellID->12244],
Cell[8604, 272, 396, 14, 70, "Notes",
 CellID->31622],
Cell[9003, 288, 577, 20, 70, "Notes",
 CellID->10198]
}, Closed]],
Cell[CellGroupData[{
Cell[9617, 313, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->155461870],
Cell[CellGroupData[{
Cell[10002, 327, 147, 5, 70, "ExampleSection",
 CellID->92196182],
Cell[10152, 334, 97, 1, 70, "ExampleText",
 CellID->155905724],
Cell[CellGroupData[{
Cell[10274, 339, 141, 4, 28, "Input",
 CellID->495135882],
Cell[10418, 345, 468, 15, 51, "Output",
 CellID->49009856]
}, Open  ]],
Cell[10901, 363, 125, 3, 70, "ExampleDelimiter",
 CellID->427937408],
Cell[11029, 368, 248, 8, 70, "ExampleText",
 CellID->151564373],
Cell[CellGroupData[{
Cell[11302, 380, 187, 6, 70, "Input",
 CellID->102794176],
Cell[11492, 388, 300, 10, 51, "Output",
 CellID->162179022]
}, Open  ]],
Cell[11807, 401, 125, 3, 70, "ExampleDelimiter",
 CellID->216311208],
Cell[CellGroupData[{
Cell[11957, 408, 174, 5, 70, "Input",
 CellID->126891196],
Cell[12134, 415, 932, 34, 53, "Output",
 CellID->36331781]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13115, 455, 216, 7, 70, "ExampleSection",
 CellID->21502],
Cell[CellGroupData[{
Cell[13356, 466, 138, 4, 70, "Input",
 CellID->167769903],
Cell[13497, 472, 294, 9, 36, "Output",
 CellID->152269411]
}, Open  ]],
Cell[CellGroupData[{
Cell[13828, 486, 106, 3, 70, "Input",
 CellID->11134025],
Cell[13937, 491, 548, 16, 51, "Output",
 CellID->522943271]
}, Open  ]],
Cell[CellGroupData[{
Cell[14522, 512, 132, 4, 70, "Input",
 CellID->365303145],
Cell[14657, 518, 548, 16, 51, "Output",
 CellID->222322187]
}, Open  ]],
Cell[15220, 537, 125, 3, 70, "ExampleDelimiter",
 CellID->630024835],
Cell[15348, 542, 99, 1, 70, "ExampleText",
 CellID->303356017],
Cell[CellGroupData[{
Cell[15472, 547, 144, 4, 70, "Input",
 CellID->166883876],
Cell[15619, 553, 273, 9, 36, "Output",
 CellID->428259421]
}, Open  ]],
Cell[CellGroupData[{
Cell[15929, 567, 107, 3, 70, "Input",
 CellID->212907639],
Cell[16039, 572, 291, 10, 51, "Output",
 CellID->123137355]
}, Open  ]],
Cell[CellGroupData[{
Cell[16367, 587, 163, 5, 70, "Input",
 CellID->202469662],
Cell[16533, 594, 476, 15, 51, "Output",
 CellID->57190375]
}, Open  ]],
Cell[17024, 612, 124, 3, 70, "ExampleDelimiter",
 CellID->34936731],
Cell[17151, 617, 85, 1, 70, "ExampleText",
 CellID->48713004],
Cell[CellGroupData[{
Cell[17261, 622, 131, 4, 70, "Input",
 CellID->461324702],
Cell[17395, 628, 290, 10, 51, "Output",
 CellID->559735199]
}, Open  ]],
Cell[17700, 641, 124, 3, 70, "ExampleDelimiter",
 CellID->62693655],
Cell[17827, 646, 238, 7, 70, "ExampleText",
 CellID->188128395],
Cell[CellGroupData[{
Cell[18090, 657, 113, 3, 70, "Input",
 CellID->432205233],
Cell[18206, 662, 511, 15, 51, "Output",
 CellID->132201342]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18766, 683, 232, 7, 70, "ExampleSection",
 CellID->9831],
Cell[19001, 692, 113, 3, 70, "ExampleText",
 CellID->7826],
Cell[CellGroupData[{
Cell[19139, 699, 187, 6, 70, "Input",
 CellID->19651],
Cell[19329, 707, 612, 17, 58, "Output",
 CellID->27978]
}, Open  ]],
Cell[19956, 727, 125, 3, 70, "ExampleDelimiter",
 CellID->693058674],
Cell[20084, 732, 250, 8, 70, "ExampleText",
 CellID->16337581],
Cell[CellGroupData[{
Cell[20359, 744, 158, 5, 70, "Input",
 CellID->199541071],
Cell[20520, 751, 181, 6, 51, "Output",
 CellID->192097174]
}, Open  ]],
Cell[CellGroupData[{
Cell[20738, 762, 132, 4, 70, "Input",
 CellID->322375566],
Cell[20873, 768, 548, 16, 51, "Output",
 CellID->120837039]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21482, 791, 311, 9, 70, "SeeAlsoSection",
 CellID->22946],
Cell[21796, 802, 987, 35, 70, "SeeAlso",
 CellID->12003]
}, Open  ]],
Cell[CellGroupData[{
Cell[22820, 842, 319, 9, 70, "MoreAboutSection",
 CellID->672363112],
Cell[23142, 853, 145, 3, 70, "MoreAbout",
 CellID->413714256],
Cell[23290, 858, 203, 4, 70, "MoreAbout",
 CellID->369487734],
Cell[23496, 864, 145, 3, 70, "MoreAbout",
 CellID->3787929],
Cell[23644, 869, 197, 4, 70, "MoreAbout",
 CellID->29271938]
}, Open  ]],
Cell[23856, 876, 27, 0, 70, "History"],
Cell[23886, 878, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

