(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15127,        541]
NotebookOptionsPosition[     11588,        422]
NotebookOutlinePosition[     12927,        460]
CellTagsIndexPosition[     12842,        455]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Files and Directories" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingFilesAndDirectories"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Files and Directories\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RenameDirectory" :> 
          Documentation`HelpLookup["paclet:ref/RenameDirectory"], 
          "CreateDirectory" :> 
          Documentation`HelpLookup["paclet:ref/CreateDirectory"], 
          "DeleteDirectory" :> 
          Documentation`HelpLookup["paclet:ref/DeleteDirectory"], "CopyFile" :> 
          Documentation`HelpLookup["paclet:ref/CopyFile"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"RenameDirectory\"\>", 
       2->"\<\"CreateDirectory\"\>", 3->"\<\"DeleteDirectory\"\>", 
       4->"\<\"CopyFile\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Directories & Directory Operations" :> 
          Documentation`HelpLookup[
           "paclet:guide/DirectoriesAndDirectoryOperations"], 
          "File Operations" :> 
          Documentation`HelpLookup["paclet:guide/FileOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Directories & Directory Operations\"\>", 
       2->"\<\"File Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CopyDirectory", "ObjectName",
 CellID->28042],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CopyDirectory",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CopyDirectory"], "[", 
       RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"dir\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"dir\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]copies the directory ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["dir", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["dir", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6300]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  SubscriptBox[
   StyleBox["dir", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " must already exist; ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["dir", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 " must not. "
}], "Notes",
 CellID->15811],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CopyDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CopyDirectory"]], "InlineFormula"],
 " copies all the files in ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["dir", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["dir", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5225],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CopyDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CopyDirectory"]], "InlineFormula"],
 " sets the modification dates for ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["dir", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 " and for all the files in it to be the same as those for ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["dir", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21143],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CopyDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CopyDirectory"]], "InlineFormula"],
 " returns the full name of the directory it copies to, and ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 " if it cannot complete the copy. "
}], "Notes",
 CellID->21595]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->298294285],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->428609001],

Cell["Copy a directory:", "ExampleText",
 CellID->1717575100],

Cell[BoxData[
 RowBox[{
  RowBox[{"dir", "=", 
   RowBox[{
   "$InstallationDirectory", "<>", 
    "\"\</SystemFiles/Kernel/TextResources/English\>\""}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->270696185],

Cell[BoxData[
 RowBox[{
  RowBox[{"cdir", "=", 
   RowBox[{"$TemporaryPrefix", "<>", "\"\<test123\>\""}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->39535821],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CopyDirectory", "[", 
  RowBox[{"dir", ",", "cdir"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1628776246],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\test123\"\>"], "Output",
 ImageSize->{417, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->290035832]
}, Open  ]],

Cell["List of files in the directory:", "ExampleText",
 CellID->8710499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileNames", "[", 
  RowBox[{"\"\<*\>\"", ",", "cdir"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->809522726],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\test123\\\\FunctionInformation.m\"\>", 
   ",", "\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\test123\\\\Messages.m\"\>", 
   ",", "\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\test123\\\\Usage.m\"\>"}], "}"}]], "Output",
 ImageSize->{585, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->875657444]
}, Open  ]],

Cell["Delete the directory:", "ExampleText",
 CellID->866240174],

Cell[BoxData[
 RowBox[{"DeleteDirectory", "[", 
  RowBox[{"cdir", ",", 
   RowBox[{"DeleteContents", "\[Rule]", " ", "True"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1106961405],

Cell["The directory is no longer there: ", "ExampleText",
 CellID->328443058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileNames", "[", 
  RowBox[{"\"\<*\>\"", ",", "cdir"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->187463474],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->43350533]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28368],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RenameDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RenameDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreateDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeleteDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DeleteDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CopyFile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CopyFile"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31641]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21016],

Cell[TextData[ButtonBox["Manipulating Files and Directories",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingFilesAndDirectories"]], "Tutorials",\

 CellID->26615]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->616620],

Cell[TextData[ButtonBox["Directories & Directory Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DirectoriesAndDirectoryOperations"]], "MoreAbout",
 CellID->226919445],

Cell[TextData[ButtonBox["File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FileOperations"]], "MoreAbout",
 CellID->84076432]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CopyDirectory - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 35, 8.6282514}", "context" -> "System`", 
    "keywords" -> {
     "directories", "files", "file utilities", "file operations"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "CopyDirectory[\"SubscriptBox[ dir, 1]\", \"SubscriptBox[ dir, 2]\"] \
copies the directory dir_1 to dir_2. ", 
    "synonyms" -> {"copy directory", "cp -r"}, "title" -> "CopyDirectory", 
    "type" -> "Symbol", "uri" -> "ref/CopyDirectory"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6089, 208, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->298294285]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12699, 448}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2370, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2993, 85, 51, 1, 70, "ObjectName",
 CellID->28042],
Cell[3047, 88, 898, 29, 70, "Usage",
 CellID->6300]
}, Open  ]],
Cell[CellGroupData[{
Cell[3982, 122, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4460, 139, 289, 12, 70, "Notes",
 CellID->15811],
Cell[4752, 153, 421, 17, 70, "Notes",
 CellID->5225],
Cell[5176, 172, 483, 17, 70, "Notes",
 CellID->21143],
Cell[5662, 191, 390, 12, 70, "Notes",
 CellID->21595]
}, Closed]],
Cell[CellGroupData[{
Cell[6089, 208, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->298294285],
Cell[CellGroupData[{
Cell[6474, 222, 148, 5, 70, "ExampleSection",
 CellID->428609001],
Cell[6625, 229, 61, 1, 70, "ExampleText",
 CellID->1717575100],
Cell[6689, 232, 215, 7, 70, "Input",
 CellID->270696185],
Cell[6907, 241, 166, 5, 70, "Input",
 CellID->39535821],
Cell[CellGroupData[{
Cell[7098, 250, 138, 4, 28, "Input",
 CellID->1628776246],
Cell[7239, 256, 242, 6, 36, "Output",
 CellID->290035832]
}, Open  ]],
Cell[7496, 265, 72, 1, 70, "ExampleText",
 CellID->8710499],
Cell[CellGroupData[{
Cell[7593, 270, 139, 4, 70, "Input",
 CellID->809522726],
Cell[7735, 276, 521, 12, 71, "Output",
 CellID->875657444]
}, Open  ]],
Cell[8271, 291, 64, 1, 70, "ExampleText",
 CellID->866240174],
Cell[8338, 294, 189, 5, 70, "Input",
 CellID->1106961405],
Cell[8530, 301, 77, 1, 70, "ExampleText",
 CellID->328443058],
Cell[CellGroupData[{
Cell[8632, 306, 139, 4, 70, "Input",
 CellID->187463474],
Cell[8774, 312, 174, 6, 36, "Output",
 CellID->43350533]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9009, 325, 311, 9, 70, "SeeAlsoSection",
 CellID->28368],
Cell[9323, 336, 983, 35, 70, "SeeAlso",
 CellID->31641]
}, Open  ]],
Cell[CellGroupData[{
Cell[10343, 376, 314, 9, 70, "TutorialsSection",
 CellID->21016],
Cell[10660, 387, 178, 4, 70, "Tutorials",
 CellID->26615]
}, Open  ]],
Cell[CellGroupData[{
Cell[10875, 396, 316, 9, 70, "MoreAboutSection",
 CellID->616620],
Cell[11194, 407, 179, 3, 70, "MoreAbout",
 CellID->226919445],
Cell[11376, 412, 140, 3, 70, "MoreAbout",
 CellID->84076432]
}, Open  ]],
Cell[11531, 418, 27, 0, 70, "History"],
Cell[11561, 420, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

