(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16133,        476]
NotebookOptionsPosition[     12975,        373]
NotebookOutlinePosition[     14518,        417]
CellTagsIndexPosition[     14400,        411]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Cells" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForCells"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Options for Cells\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Selectable" :> 
          Documentation`HelpLookup["paclet:ref/Selectable"], "ReadProtected" :> 
          Documentation`HelpLookup["paclet:ref/ReadProtected"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Selectable\"\>", 
       2->"\<\"ReadProtected\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Copyable", "ObjectName",
 CellID->23901],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Copyable",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Copyable"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which specifies whether a cell can be copied interactively using the \
front end. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12306]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Even with the setting ",
 Cell[BoxData[
  RowBox[{"Copyable", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the expression corresponding to a cell can still be read into the kernel \
using ",
 Cell[BoxData[
  ButtonBox["NotebookRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookRead"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10635],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"Copyable", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " set at the notebook level, no cells in the notebook can be copied \
interactively in the front end. "
}], "Notes",
 CellID->17860]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->471089691],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->53893332],

Cell["\<\
Create a document with one cell that can be copied and one that cannot:\
\>", "ExampleText",
 CellID->84425591],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"TextCell", "[", 
       RowBox[{"\"\<copyable\>\"", ",", "\"\<Text\>\"", ",", 
        RowBox[{"Copyable", "\[Rule]", "True"}]}], "]"}], ",", 
      RowBox[{"TextCell", "[", 
       RowBox[{"\"\<not copyable\>\"", ",", "\"\<Text\>\"", ",", 
        RowBox[{"Copyable", "\[Rule]", "False"}]}], "]"}]}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->112953892],

Cell["Select both cells:", "ExampleText",
 CellID->194313482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "All", ",", "Notebook"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->714910518],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztne1TlNcZh7fT7538C/1X2n7sNDNNPrWdBpyKSTuZTvsH9EMmJm1oOhoV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   "], {{0, 0}, {458, 92}}, {0, 255}],
  ImageSize->{458 0.75, 92 0.75},
  PlotRange->{{0, 458}, {0, 92}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->139975539]
}, Open  ]],

Cell["\<\
If you copy this selection and paste to a new notebook, only the first cell \
is copied:\
\>", "ExampleText",
 CellID->236143503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FrontEndExecute", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FrontEnd`SelectionMove", "[", 
      RowBox[{"nb", ",", "All", ",", "Notebook"}], "]"}], ",", 
     RowBox[{"FrontEndToken", "[", 
      RowBox[{"nb", ",", "\"\<Copy\>\""}], "]"}], ",", 
     RowBox[{"FrontEndToken", "[", 
      RowBox[{"nb", ",", "\"\<New\>\""}], "]"}], ",", 
     RowBox[{"FrontEndToken", "[", "\"\<Paste\>\"", "]"}]}], "}"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->81915285],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVtPVFcYhml63/gX+ldae6tp05u2SRVTUdsY06Z3TXphqrZam3oCT6BS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   "], {{0, 0}, {458, 68}}, {0, 255}],
  ImageSize->{458 0.75, 68 0.75},
  PlotRange->{{0, 458}, {0, 68}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->508117927]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9768],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Selectable",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Selectable"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReadProtected",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReadProtected"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28233]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32471],

Cell[TextData[ButtonBox["Options for Cells",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForCells"]], "Tutorials",
 CellID->29527]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Copyable - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 35, 8.3938704}", "context" -> "System`", 
    "keywords" -> {"copyable", "copy protected", "copy protection"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Copyable is an option for Cell which specifies whether a cell can be \
copied interactively using the front end. ", "synonyms" -> {}, "title" -> 
    "Copyable", "type" -> "Symbol", "uri" -> "ref/Copyable"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3860, 135, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->471089691]},
 "Notebook Image"->{
  Cell[5271, 188, 3008, 52, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->139975539],
  Cell[8978, 267, 2589, 45, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->508117927]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14029, 397},
 {"Notebook Image", 14170, 401}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1269, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1892, 59, 46, 1, 70, "ObjectName",
 CellID->23901],
Cell[1941, 62, 619, 19, 70, "Usage",
 CellID->12306]
}, Open  ]],
Cell[CellGroupData[{
Cell[2597, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3075, 103, 439, 15, 70, "Notes",
 CellID->10635],
Cell[3517, 120, 306, 10, 70, "Notes",
 CellID->17860]
}, Closed]],
Cell[CellGroupData[{
Cell[3860, 135, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->471089691],
Cell[CellGroupData[{
Cell[4245, 149, 147, 5, 70, "ExampleSection",
 CellID->53893332],
Cell[4395, 156, 121, 3, 70, "ExampleText",
 CellID->84425591],
Cell[4519, 161, 508, 14, 70, "Input",
 CellID->112953892],
Cell[5030, 177, 61, 1, 70, "ExampleText",
 CellID->194313482],
Cell[CellGroupData[{
Cell[5116, 182, 152, 4, 70, "Input",
 CellID->714910518],
Cell[5271, 188, 3008, 52, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->139975539]
}, Open  ]],
Cell[8294, 243, 139, 4, 70, "ExampleText",
 CellID->236143503],
Cell[CellGroupData[{
Cell[8458, 251, 517, 14, 70, "Input",
 CellID->81915285],
Cell[8978, 267, 2589, 45, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->508117927]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11628, 319, 310, 9, 70, "SeeAlsoSection",
 CellID->9768],
Cell[11941, 330, 465, 17, 70, "SeeAlso",
 CellID->28233]
}, Open  ]],
Cell[CellGroupData[{
Cell[12443, 352, 314, 9, 70, "TutorialsSection",
 CellID->32471],
Cell[12760, 363, 143, 3, 70, "Tutorials",
 CellID->29527]
}, Open  ]],
Cell[12918, 369, 27, 0, 70, "History"],
Cell[12948, 371, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

