(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32305,       1174]
NotebookOptionsPosition[     27069,        993]
NotebookOutlinePosition[     28374,       1030]
CellTagsIndexPosition[     28288,       1025]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitioning Data into Clusters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PartitioningDataIntoClusters"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitioning Data into Clusters\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CosineDistance" :> 
          Documentation`HelpLookup["paclet:ref/CosineDistance"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"CosineDistance\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Distance and Dissimilarity Measures" :> 
          Documentation`HelpLookup[
           "paclet:guide/DistanceAndDissimilarityMeasures"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Distance and Dissimilarity Measures\"\>", 
       2->"\<\"New in 6.0: Mathematics & Algorithms\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["CorrelationDistance", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CorrelationDistance",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CorrelationDistance"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the correlation coefficient distance between \
vectors ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15457]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CorrelationDistance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CorrelationDistance"], "[", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"1", "-", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       StyleBox["u", "TI"], "-", 
       RowBox[{
        ButtonBox["Mean",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Mean"], "[", 
        StyleBox["u", "TI"], "]"}]}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["v", "TI"], "-", 
       RowBox[{
        ButtonBox["Mean",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Mean"], "[", 
        StyleBox["v", "TI"], "]"}]}], ")"}]}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       ButtonBox["Norm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Norm"], "[", 
       RowBox[{
        StyleBox["u", "TI"], "-", 
        RowBox[{
         ButtonBox["Mean",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Mean"], "[", 
         StyleBox["u", "TI"], "]"}]}], "]"}], 
      RowBox[{
       ButtonBox["Norm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Norm"], "[", 
       RowBox[{
        StyleBox["v", "TI"], "-", 
        RowBox[{
         ButtonBox["Mean",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Mean"], "[", 
         StyleBox["v", "TI"], "]"}]}], "]"}]}], ")"}]}]}]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->709349618,
  ButtonNote->"709349618"]
}], "Notes",
 CellID->24221]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->223404005],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->34816504],

Cell["The correlation distance between two vectors:", "ExampleText",
 CellID->235641551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CorrelationDistance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->196650888],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{
         FractionBox["1", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{
         FractionBox["1", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}]}]}], ")"}]}], "+", 
     
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{
         FractionBox["1", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"y", "+", 
        RowBox[{
         FractionBox["1", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}]}]}], ")"}]}], "+", 
     
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         FractionBox["1", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}], "+", "c"}], 
       ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         FractionBox["1", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}]}], "+", "z"}], 
       ")"}]}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"Abs", "[", 
         RowBox[{"a", "+", 
          RowBox[{
           FractionBox["1", "3"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}]}], "]"}], "2"],
        "+", 
       SuperscriptBox[
        RowBox[{"Abs", "[", 
         RowBox[{"b", "+", 
          RowBox[{
           FractionBox["1", "3"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}]}], "]"}], "2"],
        "+", 
       SuperscriptBox[
        RowBox[{"Abs", "[", 
         RowBox[{
          RowBox[{
           FractionBox["1", "3"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}], "+", "c"}], 
         "]"}], "2"]}]], " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"Abs", "[", 
         RowBox[{"x", "+", 
          RowBox[{
           FractionBox["1", "3"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}]}]}], "]"}], "2"],
        "+", 
       SuperscriptBox[
        RowBox[{"Abs", "[", 
         RowBox[{"y", "+", 
          RowBox[{
           FractionBox["1", "3"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}]}]}], "]"}], "2"],
        "+", 
       SuperscriptBox[
        RowBox[{"Abs", "[", 
         RowBox[{
          RowBox[{
           FractionBox["1", "3"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}]}], "+", "z"}], 
         "]"}], "2"]}]]}], ")"}]}]}]], "Output",
 ImageSize->{535, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->481006019]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->125461358],

Cell["Correlation distance between numeric vectors:", "ExampleText",
 CellID->319587507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CorrelationDistance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190454384],

Cell[BoxData[
 RowBox[{"1", "-", 
  FractionBox["7", 
   RowBox[{"2", " ", 
    SqrtBox["13"]}]]}]], "Output",
 ImageSize->{69, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->840913080]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20040],

Cell["Compute distance between any vectors of equal length:", "ExampleText",
 CellID->86273121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CorrelationDistance", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"5", ",", "100"}], "]"}], ",", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"5", ",", "100"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->488208944],

Cell[BoxData["1.0550658243454474`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11504388]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->204991544],

Cell["Compute distance between vectors of any precision:", "ExampleText",
 CellID->14044010],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CorrelationDistance", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "5", ",", "2", ",", "3", ",", "10"}], "}"}], ",", 
     "50"}], "]"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "15", ",", "20", ",", "5", ",", "5"}], "}"}], ",", 
     "50"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->323525768],

Cell[BoxData["1.\
21066351883988135330352743477616766501485878100283985106625890527`49.\
17787732211532"], "Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4728052]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2589],

Cell["Cluster data using correlation distance:", "ExampleText",
 CellID->245478961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"DistanceFunction", "\[Rule]", "CorrelationDistance"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108189764],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}]}], "}"}], "}"}]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->430526372]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25990],

Cell["Correlation distance includes a dot product scaled by norms:", \
"ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->709349618],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->553453199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"u", "-", 
      RowBox[{"Mean", "[", "u", "]"}]}], ")"}], ".", 
    RowBox[{"(", 
     RowBox[{"v", "-", 
      RowBox[{"Mean", "[", "v", "]"}]}], ")"}]}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Norm", "[", 
      RowBox[{"u", "-", 
       RowBox[{"Mean", "[", "u", "]"}]}], "]"}], 
     RowBox[{"Norm", "[", 
      RowBox[{"v", "-", 
       RowBox[{"Mean", "[", "v", "]"}]}], "]"}]}], ")"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6273653],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{
         FractionBox["1", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{
         FractionBox["1", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}]}]}], ")"}]}], "+", 
     
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{
         FractionBox["1", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"y", "+", 
        RowBox[{
         FractionBox["1", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}]}]}], ")"}]}], "+", 
     
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         FractionBox["1", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}], "+", "c"}], 
       ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         FractionBox["1", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}]}], "+", "z"}], 
       ")"}]}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"Abs", "[", 
         RowBox[{"a", "+", 
          RowBox[{
           FractionBox["1", "3"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}]}], "]"}], "2"],
        "+", 
       SuperscriptBox[
        RowBox[{"Abs", "[", 
         RowBox[{"b", "+", 
          RowBox[{
           FractionBox["1", "3"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}]}], "]"}], "2"],
        "+", 
       SuperscriptBox[
        RowBox[{"Abs", "[", 
         RowBox[{
          RowBox[{
           FractionBox["1", "3"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}], "+", "c"}], 
         "]"}], "2"]}]], " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"Abs", "[", 
         RowBox[{"x", "+", 
          RowBox[{
           FractionBox["1", "3"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}]}]}], "]"}], "2"],
        "+", 
       SuperscriptBox[
        RowBox[{"Abs", "[", 
         RowBox[{"y", "+", 
          RowBox[{
           FractionBox["1", "3"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}]}]}], "]"}], "2"],
        "+", 
       SuperscriptBox[
        RowBox[{"Abs", "[", 
         RowBox[{
          RowBox[{
           FractionBox["1", "3"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}]}], "+", "z"}], 
         "]"}], "2"]}]]}], ")"}]}]}]], "Output",
 ImageSize->{535, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->413565]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CorrelationDistance", "[", 
   RowBox[{"u", ",", "v"}], "]"}], "\[Equal]", "%"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->418619957],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->611160862]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23098092],

Cell["\<\
Correlation distance includes a dot product scaled by Euclidean distances \
from the mean:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->38175833],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->201109570],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"scale", "=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"EuclideanDistance", "[", 
     RowBox[{"u", ",", 
      RowBox[{"Mean", "[", "u", "]"}]}], "]"}], 
    RowBox[{"EuclideanDistance", "[", 
     RowBox[{"v", ",", 
      RowBox[{"Mean", "[", "v", "]"}]}], "]"}]}], ")"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3304662],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"Abs", "[", 
      RowBox[{"a", "+", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}]}], "]"}], "2"], 
    "+", 
    SuperscriptBox[
     RowBox[{"Abs", "[", 
      RowBox[{"b", "+", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}]}], "]"}], "2"], 
    "+", 
    SuperscriptBox[
     RowBox[{"Abs", "[", 
      RowBox[{
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}], "+", "c"}], 
      "]"}], "2"]}]], " ", 
  SqrtBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"Abs", "[", 
      RowBox[{"x", "+", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}]}]}], "]"}], "2"], 
    "+", 
    SuperscriptBox[
     RowBox[{"Abs", "[", 
      RowBox[{"y", "+", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}]}]}], "]"}], "2"], 
    "+", 
    SuperscriptBox[
     RowBox[{"Abs", "[", 
      RowBox[{
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "x"}], "-", "y", "-", "z"}], ")"}]}], "+", "z"}], 
      "]"}], "2"]}]]}]], "Output",
 ImageSize->{483, 78},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->261565900]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CorrelationDistance", "[", 
   RowBox[{"u", ",", "v"}], "]"}], "==", 
  RowBox[{"1", "-", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"u", "-", 
       RowBox[{"Mean", "[", "u", "]"}]}], ")"}], ".", 
     RowBox[{"(", 
      RowBox[{"v", "-", 
       RowBox[{"Mean", "[", "v", "]"}]}], ")"}]}], "/", 
    "scale"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->45975943],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->171868949]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->179646547],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CorrelationDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CorrelationDistance"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["CosineDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CosineDistance"]], "InlineFormula"],
 " of vectors shifted by their means:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->655878966],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->10753412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CorrelationDistance", "[", 
   RowBox[{"u", ",", "v"}], "]"}], "==", 
  RowBox[{"CosineDistance", "[", 
   RowBox[{
    RowBox[{"u", "-", 
     RowBox[{"Mean", "[", "u", "]"}]}], ",", 
    RowBox[{"v", "-", 
     RowBox[{"Mean", "[", "v", "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31468961],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->416498768]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1017],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["CosineDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CosineDistance"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->14932]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->875],

Cell[TextData[ButtonBox["Partitioning Data into Clusters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartitioningDataIntoClusters"]], "Tutorials",
 CellID->22256]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->636469],

Cell[TextData[ButtonBox["Distance and Dissimilarity Measures",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DistanceAndDissimilarityMeasures"]], "MoreAbout",
 CellID->98488719],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->856277]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CorrelationDistance - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 35, 9.3157690}", "context" -> "System`", 
    "keywords" -> {"correlation dissimilarity"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CorrelationDistance[u, v] gives the correlation coefficient distance \
between vectors u and v.", "synonyms" -> {"correlation distance"}, "title" -> 
    "CorrelationDistance", "type" -> "Symbol", "uri" -> 
    "ref/CorrelationDistance"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7242, 230, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->223404005]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28145, 1018}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2061, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2684, 80, 1584, 37, 70, "ObjectNameGrid"],
Cell[4271, 119, 733, 24, 70, "Usage",
 CellID->15457]
}, Open  ]],
Cell[CellGroupData[{
Cell[5041, 148, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5519, 165, 1686, 60, 70, "Notes",
 CellID->24221]
}, Closed]],
Cell[CellGroupData[{
Cell[7242, 230, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->223404005],
Cell[CellGroupData[{
Cell[7627, 244, 147, 5, 70, "ExampleSection",
 CellID->34816504],
Cell[7777, 251, 88, 1, 70, "ExampleText",
 CellID->235641551],
Cell[CellGroupData[{
Cell[7890, 256, 256, 8, 28, "Input",
 CellID->196650888],
Cell[8149, 266, 3395, 118, 168, "Output",
 CellID->481006019]
}, Open  ]],
Cell[11559, 387, 125, 3, 70, "ExampleDelimiter",
 CellID->125461358],
Cell[11687, 392, 88, 1, 70, "ExampleText",
 CellID->319587507],
Cell[CellGroupData[{
Cell[11800, 397, 257, 8, 70, "Input",
 CellID->190454384],
Cell[12060, 407, 240, 9, 55, "Output",
 CellID->840913080]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12349, 422, 216, 7, 70, "ExampleSection",
 CellID->20040],
Cell[12568, 431, 95, 1, 70, "ExampleText",
 CellID->86273121],
Cell[CellGroupData[{
Cell[12688, 436, 268, 8, 70, "Input",
 CellID->488208944],
Cell[12959, 446, 175, 5, 36, "Output",
 CellID->11504388]
}, Open  ]],
Cell[13149, 454, 125, 3, 70, "ExampleDelimiter",
 CellID->204991544],
Cell[13277, 459, 92, 1, 70, "ExampleText",
 CellID->14044010],
Cell[CellGroupData[{
Cell[13394, 464, 429, 14, 70, "Input",
 CellID->323525768],
Cell[13826, 480, 245, 7, 36, "Output",
 CellID->4728052]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14120, 493, 222, 7, 70, "ExampleSection",
 CellID->2589],
Cell[14345, 502, 83, 1, 70, "ExampleText",
 CellID->245478961],
Cell[CellGroupData[{
Cell[14453, 507, 479, 16, 70, "Input",
 CellID->108189764],
Cell[14935, 525, 453, 16, 36, "Output",
 CellID->430526372]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15437, 547, 233, 7, 70, "ExampleSection",
 CellID->25990],
Cell[15673, 556, 153, 3, 70, "ExampleText",
 CellID->709349618],
Cell[15829, 561, 281, 10, 70, "Input",
 CellID->553453199],
Cell[CellGroupData[{
Cell[16135, 575, 547, 19, 70, "Input",
 CellID->6273653],
Cell[16685, 596, 3392, 118, 168, "Output",
 CellID->413565]
}, Open  ]],
Cell[CellGroupData[{
Cell[20114, 719, 169, 5, 70, "Input",
 CellID->418619957],
Cell[20286, 726, 161, 5, 36, "Output",
 CellID->611160862]
}, Open  ]],
Cell[20462, 734, 124, 3, 70, "ExampleDelimiter",
 CellID->23098092],
Cell[20589, 739, 188, 5, 70, "ExampleText",
 CellID->38175833],
Cell[20780, 746, 281, 10, 70, "Input",
 CellID->201109570],
Cell[CellGroupData[{
Cell[21086, 760, 350, 11, 70, "Input",
 CellID->3304662],
Cell[21439, 773, 1723, 64, 99, "Output",
 CellID->261565900]
}, Open  ]],
Cell[CellGroupData[{
Cell[23199, 842, 421, 15, 70, "Input",
 CellID->45975943],
Cell[23623, 859, 161, 5, 36, "Output",
 CellID->171868949]
}, Open  ]],
Cell[23799, 867, 125, 3, 70, "ExampleDelimiter",
 CellID->179646547],
Cell[23927, 872, 436, 13, 70, "ExampleText",
 CellID->655878966],
Cell[24366, 887, 280, 10, 70, "Input",
 CellID->10753412],
Cell[CellGroupData[{
Cell[24671, 901, 345, 11, 70, "Input",
 CellID->31468961],
Cell[25019, 914, 161, 5, 36, "Output",
 CellID->416498768]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25241, 926, 310, 9, 70, "SeeAlsoSection",
 CellID->1017],
Cell[25554, 937, 208, 6, 70, "SeeAlso",
 CellID->14932]
}, Open  ]],
Cell[CellGroupData[{
Cell[25799, 948, 312, 9, 70, "TutorialsSection",
 CellID->875],
Cell[26114, 959, 170, 3, 70, "Tutorials",
 CellID->22256]
}, Open  ]],
Cell[CellGroupData[{
Cell[26321, 967, 316, 9, 70, "MoreAboutSection",
 CellID->636469],
Cell[26640, 978, 178, 3, 70, "MoreAbout",
 CellID->98488719],
Cell[26821, 983, 176, 3, 70, "MoreAbout",
 CellID->856277]
}, Open  ]],
Cell[27012, 989, 27, 0, 70, "History"],
Cell[27042, 991, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

