(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    279505,       6732]
NotebookOptionsPosition[    259095,       5989]
NotebookOutlinePosition[    260268,       6025]
CellTagsIndexPosition[    260181,       6020]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Some Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SomeMathematicalFunctions"], 
          "Elementary Transcendental Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ElementaryTranscendentalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Some Mathematical Functions\"\>", 
       2->"\<\"Elementary Transcendental Functions\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ArcCos" :> Documentation`HelpLookup["paclet:ref/ArcCos"], 
          "Sec" :> Documentation`HelpLookup["paclet:ref/Sec"], "Sin" :> 
          Documentation`HelpLookup["paclet:ref/Sin"], "Degree" :> 
          Documentation`HelpLookup["paclet:ref/Degree"], "TrigToExp" :> 
          Documentation`HelpLookup["paclet:ref/TrigToExp"], "TrigExpand" :> 
          Documentation`HelpLookup["paclet:ref/TrigExpand"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ArcCos\"\>", 2->"\<\"Sec\"\>", 
       3->"\<\"Sin\"\>", 4->"\<\"Degree\"\>", 5->"\<\"TrigToExp\"\>", 
       6->"\<\"TrigExpand\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elementary Functions" :> 
          Documentation`HelpLookup["paclet:guide/ElementaryFunctions"], 
          "Functions for Separable Coordinate Systems" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsForSeparableCoordinateSystems"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Precollege Education" :> 
          Documentation`HelpLookup["paclet:guide/PrecollegeEducation"], 
          "Trigonometric Functions" :> 
          Documentation`HelpLookup["paclet:guide/TrigonometricFunctions"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Elementary Functions\"\>", 
       2->"\<\"Functions for Separable Coordinate Systems\"\>", 
       3->"\<\"Mathematical Functions\"\>", 4->"\<\"Precollege Education\"\>",
        5->"\<\"Trigonometric Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Cos", "ObjectName",
 CellID->29182],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Cos",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Cos"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the cosine of ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19066]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "The argument of ",
 Cell[BoxData[
  ButtonBox["Cos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cos"]], "InlineFormula"],
 " is assumed to be in radians. (Multiply by ",
 Cell[BoxData[
  ButtonBox["Degree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Degree"]], "InlineFormula"],
 " to convert from degrees.) ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->4345,
  ButtonNote->"4345"]
}], "Notes",
 CellID->6388],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cos"]], "InlineFormula"],
 " is automatically evaluated when its argument is a simple rational multiple \
of ",
 Cell[BoxData["\[Pi]"], "InlineFormula"],
 "; for more complicated rational multiples, ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " can sometimes be used. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->31155,
  ButtonNote->"31155"]
}], "Notes",
 CellID->9425],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["Cos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cos"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->30114149],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cos"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cos"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->223867532],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->388993457],

Cell["The argument is given in radians:", "ExampleText",
 CellID->20280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cos", "[", 
  RowBox[{"Pi", "/", "6"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5638],

Cell[BoxData[
 FractionBox[
  SqrtBox["3"], "2"]], "Output",
 ImageSize->{32, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->367372996]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17420],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Degree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Degree"]], "InlineFormula"],
 " to specify an argument in degrees:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->4345],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cos", "[", 
  RowBox[{"30", "Degree"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16883],

Cell[BoxData[
 FractionBox[
  SqrtBox["3"], "2"]], "Output",
 ImageSize->{32, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->148277102]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30833],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->77920477]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22632],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20189],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "24"], "-", 
   FractionBox[
    SuperscriptBox["x", "6"], "720"], "+", 
   FractionBox[
    SuperscriptBox["x", "8"], "40320"], "-", 
   FractionBox[
    SuperscriptBox["x", "10"], "3628800"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 0, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 2], 0, 
    Rational[1, 24], 0, 
    Rational[-1, 720], 0, 
    Rational[1, 40320], 0, 
    Rational[-1, 3628800]}, 0, 11, 1],
  Editable->False]], "Output",
 ImageSize->{284, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->138841666]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13817],

Cell["Evaluate numerically:", "ExampleText",
 CellID->22129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cos", "[", "1.2", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6753],

Cell[BoxData["0.3623577544766736`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->370845305]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11211],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->25429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cos", "[", 
  RowBox[{"2.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2264],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.236229198856342`"}], "-", 
  RowBox[{"0.7033251781135349`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->163973528]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18613],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->10600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"12", "/", "10"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8252],

Cell[BoxData["0.\
3623577544766735776383733556230760203399477855766486264877497209361`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->549061300]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22403088],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->19861],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cos", "[", "1.20000000000000000000000", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2151],

Cell[BoxData["0.36235775447667357763837335562307602034`22.58970343438236"], \
"Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->176231896]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28963],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cos"]], "InlineFormula"],
 " threads element-wise over lists and matrices:"
}], "ExampleText",
 CellID->7813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cos", "[", 
  RowBox[{"{", 
   RowBox[{"1.2", ",", "1.5", ",", "1.8"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14907],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.3623577544766736`", ",", "0.0707372016677029`", ",", 
   RowBox[{"-", "0.2272020946930871`"}]}], "}"}]], "Output",
 ImageSize->{224, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->793328532]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cos", "[", 
  TagBox[
   RowBox[{"(", "\:f3a2", GridBox[{
      {"\[Pi]", "u"},
      {"v", 
       FractionBox["\[Pi]", "2"]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{
      "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
       "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}], "\:f3a2", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], " ", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31476],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"Cos", "[", "u", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "v", "]"}], ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->280036980]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19531],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->29942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cos", "[", 
  RowBox[{"Pi", "/", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10698],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    SqrtBox["5"]}], ")"}]}]], "Output",
 ImageSize->{76, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->223926616]
}, Open  ]],

Cell[TextData[{
 "More complicated cases require explicit use of ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->31155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cos", "[", 
  RowBox[{"Pi", "/", "24"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27587],

Cell[BoxData[
 RowBox[{"Cos", "[", 
  FractionBox["\[Pi]", "24"], "]"}]], "Output",
 ImageSize->{58, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->34238267]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->23158],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "4"], " ", 
   SqrtBox[
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{"2", "-", 
       SqrtBox["2"]}], ")"}]}]], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SqrtBox["2"]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox["2"]}], ")"}], " ", 
   SqrtBox[
    RowBox[{"2", "+", 
     SqrtBox["2"]}]]}]}]], "Output",
 ImageSize->{324, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->352233115]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13762],

Cell["\<\
Convert multiple\[Hyphen]angle expressions:\
\>", "ExampleText",
 CellID->8510],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{"Cos", "[", 
   RowBox[{"4", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30946],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"Cos", "[", "x", "]"}], "4"], "-", 
  RowBox[{"6", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "2"]}], "+", 
  SuperscriptBox[
   RowBox[{"Sin", "[", "x", "]"}], "4"]}]], "Output",
 ImageSize->{233, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4906821]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigReduce", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8380],

Cell[BoxData[
 RowBox[{"Cos", "[", 
  RowBox[{"4", " ", "x"}], "]"}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23365278]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5946],

Cell["Convert sums of trigonometric functions to products:", "ExampleText",
 CellID->13540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactor", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], "+", 
   RowBox[{"Cos", "[", "y", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27297],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"Cos", "[", 
   RowBox[{
    FractionBox["x", "2"], "-", 
    FractionBox["y", "2"]}], "]"}], " ", 
  RowBox[{"Cos", "[", 
   RowBox[{
    FractionBox["x", "2"], "+", 
    FractionBox["y", "2"]}], "]"}]}]], "Output",
 ImageSize->{157, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->912609644]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14464],

Cell["Expand assuming real variables:", "ExampleText",
 CellID->23194],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{"Cos", "[", 
   RowBox[{"x", "+", 
    RowBox[{"I", " ", "y"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12584],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   RowBox[{"Cosh", "[", "y", "]"}]}], "-", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"Sin", "[", "x", "]"}], " ", 
   RowBox[{"Sinh", "[", "y", "]"}]}]}]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->269958010]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32715],

Cell["Convert to complex exponentials:", "ExampleText",
 CellID->32200],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigToExp", "[", 
  RowBox[{"Cos", "[", "z", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1206],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", "z"}]], "2"], "+", 
  FractionBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[ImaginaryI]", " ", "z"}]], "2"]}]], "Output",
 ImageSize->{69, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95805962]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31302],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->92683338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", "x", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3899757],

Cell[BoxData[
 FormBox[
  RowBox[{"cos", "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{33, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->621586031]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8833],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cos"]], "InlineFormula"],
 " can deal with real\[Hyphen]valued intervals:"
}], "ExampleText",
 CellID->7611],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cos", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19067],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->749369744]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6645],

Cell["Infinite arguments give symbolic results:", "ExampleText",
 CellID->30175],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cos", "[", "Infinity", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6354],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->150125626]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cos", "[", "ComplexInfinity", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24919],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->658536667]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27988],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cos"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->26321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cos", "[", 
  RowBox[{
   FractionBox["\[Pi]", "2"], "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "3"], "+", 
   SuperscriptBox[
    RowBox[{"O", "[", "x", "]"}], "4"]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7592],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", "x"}], "-", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 1, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {-1, 
    Rational[-1, 2], 
    Rational[-1, 6]}, 1, 4, 1],
  Editable->False]], "Output",
 ImageSize->{124, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->109618877]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22197],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cos"]], "InlineFormula"],
 " threads element-wise over sparse arrays as well as lists: "
}], "ExampleText",
 CellID->13509],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "\[Pi]"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", 
     FractionBox["\[Pi]", "3"]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", 
     FractionBox["\[Pi]", "2"]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", " ", "2"}], "}"}], "->", "u"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8652],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->109032441]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cos", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->658],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}], ",", "1"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{185, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->818598134]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Normal", "[", "%", "]"}], " ", "//", " ", "MatrixForm"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->26859],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "1"}], "1", 
      FractionBox["1", "2"]},
     {"1", "1", "1"},
     {"1", "1", "0"},
     {"1", 
      RowBox[{"Cos", "[", "u", "]"}], "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{108, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->304271510]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1899],

Cell["Draw a circle:", "ExampleText",
 CellID->4120],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "t", "]"}], ",", 
     RowBox[{"Sin", "[", "t", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1320],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNmluIndUVx7/MOTNjEmOMGmcy9TKam4kmJpNbkzgZS6lBRKQPxQfpQxqE
5MELGl/0RV8USn1REANSH9oKXh4UwVJQkApFoVQoFYoKoiD6oAiVPgSE42+t
tfesddbZyYyIaNAz+9vf/q/7Xnvtvb9bj506ceddx06dPH5s9uh9x+49cfL4
/bM33XMfXb0VXdc9xf9PTHe0B7T0/6cGA/6O/t7Ab48BY/IkjYH+68ZoTqS+
o4qYT709+en7c9eNN3H7+ZVhvRZ+nOevvz7z7r8+pfHKy+91/Wf/+E8dxV9t
6s87b3/CkA/e/6L7hcuyehHLmIce/Nvx371Ezy03P3vP3a/SePwPbyk1IaZU
Vj5w6jVeMWxh/rQNO/30Oy++8G+he1jpHpLfVV9++f83Xv9Q8JUc8Lf+/pGM
G7VY1mtSflaaYH/587tPPvEPOP7ql8/Ancf3/vN5d0B56e/kZ5/9D7Vh8evb
/vTIw6+LCaolz2nb8xV95sw3mAYtTp54GQKPPfomYnZ7FaK/E4z462v/RYLb
f/McGiGTyF+93PL2hYrDBuCwKgaALGLvVqpz6jUsATHjKFZZn2hcrDSwATQQ
7bd3PI9iiLJTaexSGohi3uAVI7upRONSHfXxx18ZJ+yITN11SkHp9NEVOEQg
NVO02aAo6OFXVC6o7YpSbB95gaAZjcsSzxlFI+giWiS7RtFKow815IEtPK9I
aKXWNzQqo/tWRW7TcdYpDp5NuCsqZayJtZBrs+IU3ccCdJooVyWkUurjHAQi
CmC9UZFbdBzhRr9E3MaEuzq8h749d5uqHISqUduUcEYHhLmtU3lKL2LTSzgq
d/HF5moPLEZs07hSxxt3phh6iXe2Ji5b6nv8xPww+xivHnIZKfNKQBkVtDUT
dpcrymyNYVFWmtsSyqggBSiRXX1oHHtwwRK4sbs2obbV94SRvP+ZopRjDzeB
ElrXJdT2ikIcQWm0GcfCS1A7ivV2VMkZKs3pMNqGSnNH4mHPiMXkkKbOKpMv
0NrZRJk+IoOhVL4ekUfoSvP6hNpZUcXiOmNtBvaIDrwuzV0JdX2wuHhXc4dp
12NSoZp4d3dC7aoxBkreX6KoqUqLyJNImkuo3TWSiJlBzUsFBSGCRZpzxeJ7
tB+xEV6aF+lo0WqMBWBvoj1XtS9zyEavD1EozYzak/RYp6hLEq19CbW3yBBH
u182F/njSiSrSCu7700+02xvdglS2cyN689kopNXvX1J77WBrmXoQclX/cUF
LpBfkv7+5JsLFKc27xHqxO2gZo4l5ZbH/TVySPOisdFbV61D72JmGlmHW3bV
1VxyPG6R5ppAz3vb9CKd/HwgSWR0L0y924pUk+VvpvLzJMf5gYr3HmyinEtE
sZQRqC3UwUR1taLWJk8dKpJqxSU5kyVe/BBHMxkIyTo68jiUomGVotSHZR2S
5uEmyt9HlM+mjDqcZFmpqDXVNsgtNcINTZRnwYhyK7RR2BqqGeXZO6Ps2WfZ
eQFF+YZ4dZRYfD75x0arb3tWk0kzV/vGg3xNLGSU2y6j5lOsTAaUW7SNcu8a
anWNFFSS5pEmym0bUd7bRrnFI4pao1QNGXUk6TURUL42HykWX9B+liAWIh8t
nISkpiR06sreQhBTg7Nn9Jkky/Q5xk5HHugSeeh482PJSGaFsdBjpNaP9OSs
mmv3qSURWitMLj67g4qEsp1dIX+tr1deFb3i3tPWnFGpJU8tb6353tL7tGhK
H23MFGYi/yg2JlmxDV2WlBb5y5Gyroc5KkelqyM3DEvFP4JOlpclpbIMuFyp
ojQbCu/pJUdOj0hneaotXV1vNSCt6NZmnMN1zIYGp/h+eM57FvG5qutVyJsL
iaI9+zoxHlDEJ1F6dpTn8OWjpCKdCKOJLmJsuaMX5k8PSXC20RIBv+dlP2B9
bD8957rxu77/ocf/ZPhj30HyNr3MQ2nmk438POyh5UWYr6aRp+/C2qh2NHut
00b5WhtR3qvyA7oxUYujfUa0efjqH1FeV7VRPkciype/jLJKw+uTaHFfdtoo
EghpxFFWn3hF2K5qXIOIchu1Ue6niHIbDtdCnsPiaN+nt6s0X8BileZWaKO8
po3Vp0drq/qU2I4Vrtei7VrVrRN5uD7tatp3PZGX97ZRVkFIM9b5LsFwne8x
H0c7jfYOxPc1cQfikrVRrq+hLkgStHdWvtJFlMduexfnM8J2cWuTV9s7RhIQ
aSijvHd4V+o737gr9TODzONgsoKhbL/sM6G9X/YZEVHOq70397xhe/N1iVc9
F2jtDdpnBC5HpOhy6HnpOavOfD9yIElqJxhyciOz7LvT2598E0+C6CUty6ni
6ElLi66fBHnWM3oXJ6lHT5ZqPZvtuK9aDElkBtlJmJ3Z+bns6AlbppNXbqPr
synSRWMcJ9zq2XutKjMVO//zGLXzPzu19KzQPrWEPjqJze0cUvcXYf7uaaJc
54hyWhll56p+cmLnqrb7oVQg0Ukc1jPbudRvJ7zTyaft02RkwGoSLXaabBW6
5/r2ybWd1MuN5fqA8rPzNsqpGmqmSkABJCe+rbN1mR/x/B5Jy41I+/weBsV/
hrosoYZvFny03Sxcnkbn24trU4yo3qUyNJRsk/JNyfbqiYKyO48rKwrtxZLb
E+qaalP8x3/lVma22qzcyuS7nK3hPRzLDZDeG/Xt1gUv0GjfN9k9m0hj900b
q+RoJnG6JaF0BkuGKB5UnewOTeKR6JZoqGfzm4IUBApCqjYlD5jMvKLRvquz
Oz7R2u7qtlZvFD5XJ9RspWuXwwhoN4OWb+2ODzlwwWxCmm/IEFCWIyO7i7Tb
T7Sll7CEcN4TqLXL7SrJBRZqMYsIuVMFRsrGoDJP882rRngfcewiHzfYravG
qtznEgagEUiyXL3tnak8YchbxLObXp1N44iA9pQJuF0iejrxnKo6YQt4orLd
Lmu2kJtzpghULdp4zLfcmjXGoWxcyvy3O267fecZp9oVOnygcVGioTlxAhrY
xW7pURHBNYvY2jRpd/iQNybli4Ve1/56I68jayoN+1LAmGBNoaG512oL+WIB
Ee1zBUbYFhE/SOyPnrnkdUVrt/OgiaQWcoufPNCpelhFKj422sTJGBp14/a9
Bj0yaUUrmYTjZVuoHMTnUsh3qyBvX4YAQsqF+dOI+5he7wLQisz2AasWZRvo
yaZ9YgJQ8gk8hKnsPqFQKyIportxiBkHECLrgtPM++hzWuTo98LND4a/0rhN
e0e/4+lWfAtTN6Se\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->437768227]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16984],

Cell["Lissajous figure:", "ExampleText",
 CellID->4912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"2", "t"}], "]"}], ",", 
     RowBox[{"Cos", "[", 
      RowBox[{"5", "t"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1915],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->11254939]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19485],

Cell["Equiangular (logarithmic) spiral:", "ExampleText",
 CellID->20741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"t", "/", "10"}], "]"}], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", "t", "]"}], ",", 
      RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"10", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10199],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->72773718]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4208],

Cell["Circular motion:", "ExampleText",
 CellID->6844],

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Cos", "[", "t", "]"}], ",", 
          RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"PlotRange", "->", "1.2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"10", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30169],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29681],

Cell["Solve an equation for harmonic motion:", "ExampleText",
 CellID->4879],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
     RowBox[{
      SuperscriptBox["\[Omega]", "2"], 
      RowBox[{"x", "[", "t", "]"}]}]}], "==", "0"}], ",", 
   RowBox[{"x", "[", "t", "]"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21108],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "[", "t", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"t", " ", "\[Omega]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"t", " ", "\[Omega]"}], "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{255, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->637832160]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5259],

Cell["Rotation matrix:", "ExampleText",
 CellID->25706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RotationMatrix", "[", "\[Theta]", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->58604075],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
     RowBox[{"-", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "\[Theta]", "]"}], ",", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{256, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31826101]
}, Open  ]],

Cell["Apply to a horizontally aligned vector:", "ExampleText",
 CellID->23481099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", ".", 
  RowBox[{"{", 
   RowBox[{"1", ",", "0"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23849],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
   RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->72098358]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28026],

Cell["Plot a sphere:", "ExampleText",
 CellID->20124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "\[Phi]", "]"}], " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
      RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ",", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", 
     RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", "\[Pi]"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27607],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVfHV8HEeyv84UZrzL3SXv3e/37sG1KXYSJ3EYnRs5liHGmEZoC2yBSQbJ
FjMzWmAxMzMzr7RiZljtSrtTn99vumfXlkey43v3/nn7sUfTPdU99a2qrqru
nhnqtIGGqvZpA82zp9/7/uJpPQ3Ns/rvfad7ka1a/zslJSUT9r/720rs+f9j
z8h/EwBgL6w4KrPH9eyldbiET4D8lNaxp/9BKPbyrqzHhw0PykpK//6/gg4j
xag2yf9y6D6Vl9av6EUJy4P9/wk5/2RVf0/x7vjR/zDdK6SsqqoqL/+fR7Tb
KOf9FYUO2Sb/9zG0K+/x4hq42ebyeymk8pT873PyO3DknJDWreDyQcv/WqNf
kNvTO/Jenua1/Atp+Z+reN6wqubtFfz893p4Yw0kzxKq+/JmT/71ift7Td7f
S7i48X4fcr7+5Yn7eUWO7NV/sp8X18DHt6d1vPKfH9KcYny8IP+7sqfXn6in
d9awAcWY+oOcv9/zWq7nlf9E2vxhFT7+WHlDfq8/8tpv4JXJdUKNu+OGw4pu
V/X72hro33mie/w2zy/LuXiX134jr/zOI/pbOe7x37/w2m3ilf/wmH7W8gn8
WPDeE/X/PDw6kig45vuTv/J6eopXJlZCLPHxHv5teX//8UT9bZTLf8Nv9qvw
Fn/j9fM0r/z2E/KpsKotvPbP8MpvPWF/CgvY/hv8PWl/L8ol8/5v8PcmKDTO
9xjr1/D9W5+ot/fkrXfxrj7LK79BqP8sv+envKvP8crEY5GRiak/eyLq38s5
+YJ39Xle+TVCrbC9L3lXX+CViWcnaB41Su7bI9eIeOSn5Vr57Z6f+03t8mP9
v4HCx6kg+hii8emz+LDBnCuQH9+W+NyQ6EL6frIxtQ5WepkH/bwn70Hp5TOI
1kC0DqINCBs3EG2CaDNEWyLaFtEOiHZGtBuivRDtg2hfRG+Q2+Bvc/nbMlql
F14/f1LI7K1DiD6O6LOI1lTwegXRNwnHLKM2iLZfwSjLZSCi7yI6DNHhiL5H
yCI300rrIhD9IFY+uM9LvPLL/03++f3+XsH/xn2IPkTUfgrRaiw/G0kYtCKc
Oa3gO4CteYZYRdIWOmEr+beFvh8b5bbKzzFe+gf4VUSIVR4LU1KEoYOIJlnN
G7qINkT0NUTfIiZhTeyBveDJ8rqZDthMB2+hQ7fQ97bQ0VvouM104mY6ZTOd
tpnOQHQWS8lF/8xtdMZ2On0bnYxoPBJeXZP7Z+Fh/8b3a3yeX1dcZ3nGbBMZ
/ZmV8Gli0CzrRog2JtZsTizEEdGuhHs/RAdtpkM20+Fb6KitdOw2OmE7nbyd
TttOZ26nc7bTee/TBTswZcl2uvR9umwnXbqT08GG/B0YQuYWWh4PVo0CTpYr
+OaPlVfW4vuFA8Q47rNuSFg3RbSFgnXWQrxZ6k2Y+vmkbXQqy+z7dM4OOn8n
XbSTLvmALvuIrtiF+ar+hK75lF5Xu5slr/2UrvmESJ1FQzC9vCbXb8qlzo8W
RDfP37cMZUT/TE6OKpjVUTCLfafSpnCkGrVZLXaLWsJWtZRtqunbVYk1r2/4
mm78hm7+lsWLD+ubv8FMNX4lx78+fxu9kh++/+Wi1gqp8vkkVM9wTLLHvYTP
A6TI8qmusMU3LZCaLVJzQupuSN0bafgjjbtInb0QtVkjbotW4hatlG2a6e9r
Zn+gmfeRZuEnGiWfaZR/oVH1tUbtN+r136k1/qBK+nlWoEwLKFrwd4yi4ye6
Yw/d/iO+WdEH+Mj3J88/JGN+HCTlTRzjygreD3KeVuldA6R6BaneROpmSMMG
aToiLVek5YXO+aNzweg8YV0nbotu4nbd1B06GR/qZH+sk/epduHn2qVfald8
c776+/N1P55r+Olc89+1WpU1WXrBPrUuFVXhftWeA6qc9Df2HMA4evbT3Sq0
cB+nk0djWKkHPpZnVmDh4HCej9znb6pI9TxSu4DULiH160jzNtKyQucdkI4L
0vVEer7oQhDSD0MGLGnsdsPEnUapHxllfGyYvdsw73PDwq8MSr8xqPjeoHqP
ft3f9Rv3XmzZd6FNRU9wQJel7/7lXM8Rzb6jGgPHNAaPqQ8eV+MiO3scPEYP
HsVaEe5fSzfPrYmLn308tcJDcriIh/yPXxG+kRZS10MaRkjrGjpvgnQt0AU7
pO+MDD2QkQ+6FIguh2y5GrH9GkuZ8KFxyifXM3Zfz/7COO8r48JvjUt+uFax
51o1da1u79VGlastB660H7osOHxJeNSIpe87oT9w8sLQKd3h0+dHzmiNntEY
PaPOsjV2Vq67DWOnMaq+I/jIHzsctqfX8Ki4qSILWrdGS+JtX1uJlz3fj1QP
I7UTSP0M0mCLOkhbH+leQRduIn0zZGSNLjuiq27I2BtdV3oV3+BF4a83ek9d
xzo4e3WYvjyqZjSmbjCucWFCQ2dSU4u925Sm+rSm2rSmKucFxs7Sgydp4WF6
FT8kL32gBXmtvGbj/Ro5Mr6PI8hffuBzyck+pHoIqR1H6qeQlirSYSsvIINL
yOg6umyKrlmi62T8vRq00yzsQ/PIjy1iP7Vky2lfWWV9a5X7g3XBHqsSyqr8
Z6sqFcvag5YNv1i2HLVoP2HRedKi+7Q5ie/PTpy7Pql9bVr78rSO4bTORZah
Wd1z83oa83pq83pyzJOa9Igq3XlkNeZn4EEiyf3uZ3KrZfBQDYmwD9ZY5DpW
eu4+duJgVI8gzeNI5wy6yFbqoiuG6BrnJd9x2mzuvtXSZ7tVwAfWIbts7n1q
G/O5XcKX9uy1jO8dcvY4FlCOxXsdylQcKg861Pxi33DUvvm4fdtJe8EZOyFt
16tm269hM6RlzdKP61hM6Jpx/T49Z3CFZWre8KLIUHfR6LzYSENsqCoykOc3
Y5q03Dj5o++Zx2mfl9evxM6BJb0/xVmxCtI4iLSPoAsnkaEaukIaK229ju7c
RuaWyNJ+i7XLNluv9+39P3AI3uUY9qlT1BfOcV+7JH3nytJl/909b697kYp7
6QG3il/cao661R93azrp2nratYN2Faq59Gq69J9zHtJ2GtF1ZOkn9e2mDWxm
Da3mL1kuXDYXXbnNOaXFa1fF14wkxvpLxnpLxufYSsllWmSE0Y9o4SN/zvH0
I/ArZvr8XOl+hsUpXGkd/ruRQmp70XkVpHcIGZxAlznsfzVE5teQ5S1kbY5s
bbbYO253dN/h7POBa+Aut5BP3SM+94j52jPhO6/UPd4sde4+n8IDPiWHfMuP
+FQf96n71afxtE8L7d2u5t2l6d1zzqtfx2tIz3PkoseYgTtLP33ZZfaK8/xV
R5Gxvfi6rfiGleSmOXbL5N7PSE0vSU312TPpTY3l67TkGuZ26BzhmS+Dpx4j
A/4cAstEsVaIcbODXoNCOnuR/n50ifObSA3dPo/M2bPLyPY6sr+92dFyq7Pd
+64uO909P/T03+UdvNsn/AvfqG/84r73T/rJP105gCXOPxhUfDio7FhQ5a9B
taeCGs4GNasFtmkEdp4L7NYO6NMLGLzoP2zgN2bkO3HZh6WfNfaav+Epuuku
NnFdMnVevu2wfMeWBSUzs5CZ32EsTDhJbGLM9Jg752Smqks3MfrB8/Ta+BW+
XLG2w5+BEM0/iL8U0qKQHoWMCOZtJ5DpWWSmiax0kR1bvoqcb21xNdvmbrPD
0/EDb7ePfH0+9g/cHRDyZVDEt0ExPwQn/P1u6s8hmftDWeLCo2ElJ8IqToZX
nwmrVw1rUg9r1Qrr0A4T6ob1XgwdMAgdvhQyeuXuxLXgqetBLP28SYDI1E98
x2fJzHvZwlNq6Sa1dMHIre1kNtaMrQVjawZ2JvIoxlhfZCzPMxbqEhNakYfi
QcyN/Dd4KF9ReH2FQ8MouZ5eUkEmh5HZr8iSRrbnkMMF5MLWXt/qafq+t8VO
X7sP/Z13BXp8Guz3WUjwV6FKb+E2b4jMQsQWd5csg5atA2Q2flJbH6mdF+bV
wUXm6Mg42jNONuBkgRlwusEeGXt9xk5HZqUmNiW2ulHOLX+NkuT+ZKaisEgy
ErlIdIEcbyij2/uRxRFkcxLZqyLn88hNH3mxl25u9b/zfqD1B8EOu0K43PXe
nqho5ej4fTEpB2IzDsfmHItja0vOxFeoJlRrJNRpxTdpx7fqxXdcjO8yjO+5
FDdwNW74etzYzdgJk9jp2zFzZtEkKj3PON6VOQXJnP0xQlcvxtWDcXNl3J3A
HTt4cDcDt1tcXsg4aMtsVEV3FH4ZQ+OvUDzAuHpXRWGH5zjdsPn5TWV0RxlZ
70f2R5DTKeSmjjx1kI8h8udmxO+6fxbp81V04HcxoXviIpTjY1USEg8mph5O
yjyelHsymaUoVUup1EypOZ/aoJPSfCGlzSBFYJQivJLcdy158EbyiEny+O2k
KbPEGYvEeasEll5sF7fkECN1ipY5R3Jj7WWWd8YzgPHyZby9wccDfLBvBx8b
8DYHLxPwNMYadjontVPl3DU/x30M4hcIXHWKhFQK3aKQmTKy2YscDyLXY8jj
DPLWQv56KIiTx19vb4uw3BlptyvaeXeMx1dxvt8lBO1JDFNOjlJJiTuYmnQk
Le14Wtap9LyzGSx1uVZmlXZmnV5m48XMFsPM9kuZXVczeq5n9N/MGDLNGL2T
PmGRPm2VNmeTumCXimOKU9KSS6LULZ5xjwPPGPCKAu8I7Hu5XIAJCIQAPwjE
tgaBThBgB/4W4GcKPjhPlbloKa01V3nYoldomQ01OkqKSGuujGyVkdPPyP0X
5HUC+akqEP/X5S0R7J87O2OtdsXZ705w+TLR87tkvz0pwcpp4Srp0Ycy449k
JZ/IyjiVnUPnFKjnlpzLZemrL+TVG+Q1GeW1XskTXMsV3sjtvZU7cDt32Dxn
3DJnyiZnxi573iFL5JTJEi+5pS95pEk9UxjvZPBNBL948I/FCAIjIDhcjh5C
sDeHEA8IcYG79hBsBYGm4HcVQ3fTmrKgH4Ocv7ug9CznaTmVK+FZsp0yclZG
HirI5wgKIHfcor35nv62qCvvx9z6IJ4tW+9Odvwyxe3bNO8fMwKUM0NUsiMO
5cQczUs8kZd6Oj+TLsjVKCw8V1iqU8QS1xoWN1wqbr5a3H69qPNmUbdpUd+d
okGLwlHrwgnbwmmHwlmnggWXfLFbHku87JUj9cmW+mYy/hkQkAZByRCciHGE
xEJoNIRHwj25FJ6Be75wzxPuuUK4A4RaQvAtCLzM+OoqPVbzK/GT2dQzBLkG
ORpTJKhSyIVCnhTy4+60/fTmcI2tkTrbYwx2xl37MNHk4xS21vbLDKdvM91/
zPahcgJV8kIP5UceLYz7tSjpdHGaakmWRkneudIi3bKyi+Uscd3l8sZr5a03
yjtMyrtul/eYl/dblg/blI3ZlU06ls04l865log8SiRexTif8CuU+efLAvOY
4By4mwUhGRCWhrHcS4KIeIiMhehoiI7g7BWi/SDaC6LdINIB7llA6A0INiJ8
81fDORk8aoVKUYerXgbFyh+FLlPoNkUCLisSTh5vHEJhx7dEnNkerbkjTvfD
BMNdycafppl+hse53bc5zj/meVD5vvsKgw4Whx0tifq1LP50ebJqebpGRfb5
ynzdKqUXcC+vz7pXzntWLnpXLPliEckCS2XBJUxIERNWCOH5cC8XIrIhKhMD
iEmB2CSIS4D4WMxxQrgce7w3xLlBjB1EmkE4nqrNOtOPwL1xVe61ekeUn4+Q
8YEzTwoZsN6fQlYUcuZk8IoyCj6Awg6jqBNbYuntCVo7k/Q+Sr30Scb1z7Ju
f4mHvf2PhS5Usee+Er+DZcFHK8JPVHLrXy+UGNVXXG1gz+pvNTSbNrSZNQgs
G7qtG/rsGgYdG0ac6ydc66c96jjqN5iwCia8jIkoZaJKILoIYvIhNheDS8iE
xHRISoXkJMxxcjQk34PkEHye5A0JrhBnC9F31vSDG/85ibxOjOEqGx4o5Iit
AhfvqqDwAyjqCIo7uTlJdVvKuR3pFz/Muvxxzo3P8s2+wX7AkSpz21dBsoHf
x6jWJWjUp55vyNRrzNVvLDRqKr3aXHm9hb3WcLu12by13bKl06al276lz7Fl
yKV51K15wrN52rtpzq9JFNAoCWpYDsEilIXXcXHxVSa2gokvg4QSSCzCSFPy
IDUH0rBPhfRkSI+H9GhIj4B0nA5CqhckO0OC9T8vnfuRZAOF9ClkQiFbCrlx
fnovCt+Hog+i+GMo+dTmNLVtmdo7cvQ/yruyu/DW1yXmP5RzvL/nc6Qu4ER9
yOmGCLoxRqMp8Xxzqm5Lpn5rrlFb4dX20usdlSYdLF2juaDFqqPdtqPTvqPH
qaPfpX3IvX3Us33Sp33Gv20+sG0xuE0S2ioNx2JkopqY6EYmtp6Jr9ugyBwg
vRgyCiATe1rIzoDsFMhOgOwYyI6ALGI66Z6Qimd/sgij/zmrIX72JYXVWFLI
iZwHk2gTvQ/F/4KSj6P00yhbfXuezocFBp8Uc3PuD50O1rsfafQ53hR4qjmE
bonQaI0915ao2552sSPLSJB3RVB0vbPsVlfVbSGWj7WwxVbY4SDschL2uHb1
u3cNe3WN+XRN+nfOBHXO3+1cDBUs3RNg4UR3MLFtTFwLk9DMJDUyyQ1Mah2T
XstkVHPLbpBTArnYaCEvB/IyIC8V8hMhLxZy70EO5huyPPAxDjudVR7nn5TU
C0Q6pgqvG0ChMApFK+ElrJTDKOM4yjmzNV9jZxHnif527dsqkx9rLJTr7Q40
smWP462+p9oCz7aHqndEaAlidTqTLnalGQmzrgjzjLuLbvaU3e6tMu9lKZvs
+lod+jqc+7pce3s9ege8eod9e8cCeqaCemZDehbCehbvdS9FYckycV1MQieT
1MEktzGprUxaM5PRxGQ2MNn1GHVeNbHjp6GwAIpyoSgTilKhKBEKo6EgHPKD
5DtAyXeWo/QBVq9/b3woMj0qQhHZPEdEYkmOvqzXoVAkhXBKooIyDqGcY5sL
OKls1fus0ujrmmvf15lQDRYqzXa/tGLZnOzwPSMIVOsM1eqK1BbGXuhOMuxN
v9KXbdyXf7O/+PZAuflAldUglo3DUJvzkMBtUOgx2Os9OOA3OBIwMB48MBUy
MBs+sBDRL47uX4rtw7JJ7GWSe5hUIZPWyWQImMx2JruVyWlh8powwsJ6KKqF
4ip55lZaCGW5UJYFpalQkgDFUVAUCoWBZOhZy+KvPsKWXl3pafYQ9JxxBFIo
nEKxFMIpyT6UexAVsidnPyjX+rRK78tao+/qjX9qMvm5xeJAm90R7EQ8zgh9
VbuDNHtCtXsj9friDPqTLg+kGw9m3xzKNx0uNh8utxqpth1lKZudR9vcRgWe
o0Lv0T6/0cHA0ZHgkfHQkanwkbnIkYXoYXHc8HLCEBZBygCT1s9k9DGZPUx2
N5PTxeQJmIJ2prANAylpgjJsmVBeDRUV+KSyECrzoDILKlKgPA5KI3FlkS/u
KtXk0RLgRyJFjuJHoRAKRVEokUIZnE996/iOirMfV2t9Xqf3TaPRj83GVKuJ
SrvFLwK749igPeleX42+oPP9YXoDkfpDcZeGk6+NpN8czTYdyzcfK7YaL7ed
qHaYUHoK9/X2SOjExL2J6aiJuZhxUdy4OHFsOXkMM5s+wmQOM9lDTO4Ak9fH
FPQyhd1Q3AUlnZj98jaowK4YquqhugaqK+R5a00eVGdAVTJUkmymhCTzmRZr
eZINv4k9iEL3KBRHoVQKZctzk4PbK49/WHP203qtr5r0vm8x+qnN+OcOk4Od
Fke77X7tdTnbzxL5nRsK0h0O0x+JujQad3VcidsBa/aabfOZ7fSf7Q6a7bs7
Oxg2Q3bA/sDkjDF5o1AwAoVDUDwAJf1Q1gvl3ZjTqk6oxpYFtc1QWw911VBX
AXWluKY+F+rSoSaRKP8uFHtCru1jUd638TcpZEEhbwqFsq6PQkkUwpGc2lzC
Hg/trD3xcf3Zz5u0vmnV29NhpNxpvF9oerjH4nif3ekBFzVskn46YySCvJVs
Mp1uNpNjOVtgM1viMFfhPF/jNo+t23ehzV8kCFrovrvQF7YweG9hNGp+InZ+
On5+LmlOlDInSZ+VZs5iLedOc9HodSgbgfIhqByEqn7MfW0PASmAhjZoaIKG
OmiohsYKaMRcQmMONKQR9YdBmd9aGfmjtSvfvfCnUATr3iiURopFyltwpnzo
w4bju5vPftWq9X3HBarLaF+38aE+02MDlieH7OgReU4RbDgddmUmyng27tZs
8p25dIv5HJuFAntRiZOowm2x2lOMZRAgaQuSCEIk3WHivgjxYJR4JFY8Eb84
nbQ4l7IoShdJMkU4F8hbkBXMyYpmmeIZpnSaKZ/CpocD5YuY6yYhNHdCcxs0
N0FzHTRXQUs5tBARNGdBYzLURkJl4D+Gn1sNI6pPJtALqM2le7dVqeysZ4vH
P287+61Aa4/wwt7eSwf6jY8Mmv46zNn+ey7nJ7H6DWaDL8+FGc9H3VyIuy1K
Nl9Mtxbn2EkKnCTFrkvlnsvVPlIsgCBZW4hUECYVRkj7oqWDscsjCcsTScvT
qUtz6UuirCVxjoQlkxaKpUWLshKRrGwes6/0BtRiGXA/ecbQ2gdt3dDWCW1t
0NYEbbXQVgXtZdBeTCSRCg2xUBMiK3V/9Dhf+WQnQfM8GdnpRALFylsr9u2o
3f9RE5bAV4Kz3wu1qF49lQGi73ctVSfttKaddWY99bF5B19bDLspjjIVx5lL
kq2W0u2Wsx2X812Wiz2k5d7Saj8ZjnEhsrYwmSBCJoyS9cVKBxOkI0nS8VTp
dLp0Lku6kCMV52MhSYuXCatKr8qqREzNAlM3B/Wz0DgNzZPQMsFJADoGoaMP
BN0g6ARBKwgaQVALgkoQlHFrpNCcAPXhsnLPx6Lnr0lx6y6sYyciKKQ2l/28
vVrlw4aDn2DHevzb7jN7ejX3DrDnRkfHjE9OmJ6dstCYsT0/53xhwdNoEQvi
xlKY6XKk2XKc5XKSzXK6gzTbRZrvLi32kpb7yqoCiSDCmNYImSBKJoyV9cbL
BpNkI6nS8XTpVJZ0Nke6kC/j8P9BWr4srVyWVS/JaiWyOjHTIGKaFqBlDlpn
oX0acy4Yl1uDsB+E3SAUgLAVhI0grMWVXcQU2pKhKUpa6cXPrx8tBfKoFfHz
KRTKpVDJ3q2V+3bWquxq2r+7/cCXQmIBf9T9Zczw+ITx6WkTtVkLrXlbXZGz
gdjj8hJ7LejWcuid5UgLaay1NMlemuYkzXaT5XvKinxkZQGyqmAGC+Ee0xrF
CGIZYbysN0k2kCIbSZfhdWGlPy0WYwJphUxWJZXVSGW1y7L6JVmjhGmWMC1i
pk0EHQsgmCO4p6BbIYPefugVQm8H9LZAbwO5WgJdeO7BtMRKq3xWzbw4Caxf
I//DABU7vusVMeLfiFQiyTGfNQ3l7dV7P2j4+ePWnz/r3P91L1t/eu+wxoEx
nSOThr9OXzs7Z6KxYK69aHtB7GQkcb+65HtzmaUJNZdGWMlibWWJjrI0V1mW
hyzPR1bkz5QFMVUhTN09DL01humIZ4RJDLGDfxnPYabymdlCZr6EWSwjsqli
ZDUypk7KNEiZpmWmeYlplTDtEhCIoRO7Wuieh54Z6J2CPoV4Bvqgvwv626G/
mRCUyWXTFkeGPk823EbqI/ZPV+0hk+cN/7hCPkXU5krlbXXKO5v37ur4+bNu
tvLYT8PsUf2XSZ3jMwan566qiW5pLZrpim30JY6XltyMl31u4eEfYimLsJHF
ODCJzkyqO4MzIrKSTmxOUg3SWmDqGaZRxjRJmRYptC1DxzIIlqBrCbolxA5E
0DcP/TMwMInxDI7gyqFeGOokYmiA3groLsDQ2+P/aeRkje8tNiHknDO1uZra
1qi8o23vri62uP/7oWMUTm7Vj85qn5w3OCu6oiG+eV5sdkFibbjkcGXZ9cay
tymBbc1wUX9Dpi/kBkDhXSgNA6L/Z1sSoT0FutKgJxP6c2AoD0YLYbIEZspg
vhLIXsCb0MpAmww6ZNApBaEUurGtQd8y9IthQASDczA0DUNEICNYDzDSTcTS
BP1V0FMIwqx1/6gsVj2PrPQ6O3tUyKGW2tqsvAPPfqmvBg78MHx078TpQzNs
Ufv04kVVyWWtpRu6S3f0l60uSe2Npa63ZNz+4z1HiHaBeA9I8YYMf5BHgooo
qInDt2lOgfY06MyE7mzoy4OhAhgthokymK6AuWpMIK6HpUaQNQO0cjuar4OQ
gR4Z9MmI9qUwtARDYhhegOE5GJmG0QkMdwwncTDaCSMtMFgDvUXsDZRW76s+
Sh4r95bXKaziVTIS0thQik+24gkhtbuP+mbowI+jR/dNnTqMPdi5s5IL6suX
zkuvX5DeNpRZXpVx8cvTHPyscdfhzmS3TOntnBA8uy2JhPJYqE7Al5rSoC0D
BNkgzIO+AhgshpFSGK+AqWqYrcUEi00gaYblVpC1AwgAugC6Oam8AoMMDMlg
RAojEhhdhLF5GJuF8SmYIPKYwDEOxtpguB76S6AnR+kflMbqJ1UflIm34Pb1
2FkEXvagtrTj42cD1LcjB36aOKoyc+rIgupJ7Mn0NGVGOoyxPsPN6u1ugfMd
8LCUW8afIz0hzgeSAiAtGLLDID8CiqOhLB6qkjAnjRnQmg0dudBVgHU6UArD
FTBWBZNEPHNNIGoBcSsstYNUAAwRD/QC9AMMcnJ6CcZkML4M4xKYEMHkPEzO
wBTOxbAUJntgogNGG2GwjDXGR0tIYRWP2ocm1vI8EUYBhXDkoj7qob4YUv5+
7AA1dXT/3MkjIvrUkpYaN0bWm1wB8xvkOWn8XpXSNh97CHTBgCJ8INYfEoMg
NRSy7kEeO9uPg7JEqEzBVxuyoCUX2gugqwh6SqG/HIarYLQGJurx1dlmmG8F
UTtIBLDcBbIVkiDuAmAUYJycT8pgcgmmxDAtgmlsxMwMDjIwhdcnYLwZhiuV
1j1SGop8m3iMF+XRlEO9q4/6clj5h4n9yjOHD8yfOLZ45vSSujoOePoXOF+4
0/oOOFiCqy14O0GAGwHtBzGBkBACqeGQGQm5MVCYAKXsbDedgM6F5nxoL4JO
1oorsLNjh/dIHYw34qszrTDXDgsCWOyCpW6Q9gJDEMMwATqGEcMEwBQpTstg
ZhlmxTArIqAnmJlheXCdaIaRSpEwfdUTc+vuY16l8fUK7PXyJwupr0apH6d+
/nn24KGFo8cl5MEcpb9dugzXjeG2CViZgb01uNiDlwv4e8BdH8xUzF1ICIPU
SMiIgZw4KEiCklSoyMSX6vOhuQjaS6GTjXdV0FcDA3Uw3ABjzfjqdDvMCmC+
C0TdIO6FpX6QrcTNgp7EuGEaYAbk+x9zJKjMzzOzk8zMCDPTr3g65clQE41v
olAOhWo4dePjnmmi2VfY8zOajKYu6BliJoxvgOltsLAAOxtwdgQPV/D1hGA/
fCk6FBIiICWacyJKL00JYEYIcz0g6gPxACwNgXQYmFECZSWOWYA5zNs8twsH
CxJYWGDmppjZUWa2n5kR4uet+gtXPRHHoXlJbrdvPdBdFbWlg/NDL1MqIuow
zn2P0MwpLUZdD3SMMAPXTMDEDMytwMYOHJ3AzQ18vCEoQP4+QVo8ZCZCbioU
ZkBpDqavK4HGMmipgPYqENSAsA76WP/Sgi+Nd3KtnhcPwdIwLBOAsglgJoGZ
wlriALLwYIHT2NMgWgaRiJmfZuZYiAOsmDjX9WiEK/WFn/PkdEPtZP3RCLVn
htqPJzk/n5IdUmVOnGPoC3DuEly8jjm5ZQHmNmDtAA4u4OrB7fApvR0aiq/F
xkBCHCQn4K2R7DTIz4LiXFxfUwr15dBYCS3V0F4LXQ3Q0wz9bfjSqBAmemC6
D1i25wc55C9JJ0E2DbIZYDioCwAiouZFBhZxgGcWFxnRjGx+jJkblD8tzXt6
+zdR49kwGXncRh7JZnZ0U58PUz9Okx6fZeEfUGOOnWfOXATNy6B3Ay7dxpRm
dmDlxEn+jx5+4BcEwWHEXmMhLh4SkyA1BTIzIDcbivKhvJgIoALqq6CpBtrq
QdCEZ299Hbh+pBvGemGiD6YGYHYIFkZgcYzr+bXlaZDOgHQWZPPAEAHAIpGB
WAZiKYiXiRhmZQvj7Iloqp1DhgGtPUr5+F+Sa32TIq5TO4TU7iHqhynOpn4+
LTugLjuszZzUB7UroH0DDO6AsTXH3Xs27uDoBW5+4B0MgWEQGkWcVALEJ0Ny
GmRkQk4uFBRCSQmur6qE2mporIOWRuhohq52XNkvhMFuGO6FsX6YGITpYZgj
lr44BeJp7i4vShdAJgLZIjBifImRMIxEJpNIZRKMXraIg5J4FrsX/lsm/Az3
4bH9ghw7WTH4GGP/ZID6Dq/wUEfw4N6nAYd04LgBnL0CWjfhwh1i+I74aOUB
dj7g7A+ed8EvHIKjIZxkrLEpkJQBadmQlQd5hVBIgFdUQU0t1DfgNay2VhAQ
nfcIob8HBvtgZBDGh2GKoJ6bhPlpEM2CeA4kC7hGughSgloqgWUJsyyRLUuk
y0vLnLUvLoxOTODl0VXvgPKR/25N7T8jlwCJ3eTZuF391DfYlFj3pnyKu8t/
HjWEU1dB/SZmw8gajB3hNonFNr7gGAhuIeB9DwKiISSeaD8Nbx6n5EBGPuQU
Q0EZriyvwcvUdU3Q1AItbdAuwJXCHujtg4EBGBqC0RGYGCOBagpmZ2B+FkTz
sLgAEhGXQy1JYJ1kiVHaJFmSSZbwFEq0ODMx3d8z3MB/i4Q/7+eQv8hDvkk+
7slc/21qaz0bjjHsQxLlk9K96rK9upibX6/h4zkzuGgNlx3hphvc8cY19kHg
EgqeEeAbA0EJEEYyrvhseJ547M5e6O6HvkF2MgrDBNX4JExOw9QMzMzB3Dws
iOTPX4olIF6CxSUQLTGiJZnch03Oj/eMCbgg/DAW/toWh02+tCH/rfVGH3+1
Y71c7+TZ/qeoHXi9izqwSJ2QKqvK9mrDAUO5R39O3Qy0rcHAAa65gYkX0Xow
OIWBeyR4x0BAAtet0vNJBZBSBOklkF2BiUoaoKIJqlqgpg0vYbM1bT3c3PW1
oQkYmYKxGZiYhal5mCFmPieGeQnML+Fz9riwBPPLOBOckeBZQc9kPxfgnkQa
a755tubOOpGbquJH3h7eRH2E1w2oY0vKNKN8Dvbpc5SbaHPQsgY9B7jkBte9
wNSfq3/DLVou+aBUCCOJWHwhJBZDSilkVOJiUSPZomqByjaoIZJo7oO2ARAM
QdewXHrPsbP1kVkYm4MJIo2pRZJvS2CaCGR6Wa6NDZOS5VHRAndDPnr+vuc/
LI0VbRXvqbJZ6hlGWQuUL2DKo7fkfGw87wj6rnDFC276g9ldee077vHglQh+
qRCcCffycIu4Ykgsg1QiiLxGKGiC4lYoJ46/rgca+qCpH1rJlKNzDIQTeAWL
PR+cwxN2YstjbLB7dkyMZ2TjSzCxjGsnlmBUwgyKxL1zeAeF7+n4VvKkcuDv
CJNvCPyV2ofvQWkARRzCoRtw9A6cIXN1XTcw9IJr/vjc4h7YEUvwSAbvVPDP
hLsk5YkugbhySKqCjDpczG2GglYoIQGgqhtqeqF+AJ+3jkL7OAgmoWsaemYV
Uh4UwdAiWb5g/0nktrJhQAy9ImnXHJ6V8HMcvr94Uuwr35bFNyHYn6YOzt33
KirG8MttOG4FZx043/X768FgGg6WUWBP/L5HGvhkQmAuhBYR4OUQXwXJBHVW
M+SRLK+kC8p7oKoPaonOG0ehZRzaJhV4hXO4Fi/oLUKfWF67qV+Ca7sXoXMB
2uZwXObns/wI8KSoFes4f1ZQUkfmKTW5F964/xb8YgEn7EDVBc57KUbg9TC4
HQlWcWCfJB81vrkQVAihbKQnq5avlfTIPUL1MNSNQgOZRbdMQ+sMtBOAnSLo
Ijlctxi6xCAg563z3B34b05ijf6OLWJMv1thqNxP8TSD4tn3P91HckJEaco4
i9l42AZOOoGaB26lH6RAcicWrBLBIQ1cs7h8+6mIaoghCktugTSisFyhnPrp
0kGoGJbftm4S6qegYQaaZjlb2NAuglYRNC9A4zypeW0NDT2M4vWVst9AnVyg
tGXUVaBuyf3OKZJhaAeCQShciZDb/osOmQ/iXGA5WQ8gDMeTKVMaca85PZDX
L9dN2ShUjEPlhLz9xnqigIZ5qJ+H2jk5tvUlE1K56fO/K7JxFd+KL0asFWVX
auZPCg+6gboG1B3YZwOHXeTS0r8HV2LgZgLcSZF/I8WjWNGOaxPdLC+nCOVI
cgYeothUOgllU1A+TfLLWaiUa2J9jHBKztGbPCwbVmF5fq0R8mDNWy6T9Qq7
wuZNXQfKHPba4YsnfUAtCLTDuLi+3i5fweFzBEPOCOSMQu4Y5I1z9rWhYAqy
xuREf+Bxt34Vd5jfJ3uTf3UN+QIKWW26AxRJ2I/7wdlg0AqHCzFwiaynmmaC
RS7YFoJjCbxI7D9jFDIIf+wxaRhi+gmv/C+6rOZ0TTk+1r/et44XKBtcccQf
ToeARgToxIIBWcu8mQ138sCK+FKnSrn9rg9sfcgKnoruheg+8q8fYoiFxAxy
tsj/psu6/wbXCv/4LtzPBpxx/bG7cCYCNGM5cqVNZsR6bUmUd60H90Y5dUAH
BAogqBOCuiBYyFH/62P4ehKeFKuqf+JbN+HkZCSoxsH5ZLiYgYmNC+Sjwroa
bGvBvp6b5PwbsfP7bYGbLz8Y3yufE3tGgX3F93f43wzCcsKP1f0XYeR+/X1U
7/FQ8duv/BrIA07wt5Zwo7efiFrxRaq19jVX8v4Wr7fPcbv7nN7/2sFD8iZC
A4Vr4074nvKLh/SIoxju5hF7SSs1vEZfu4Gbmz2Wp0fsOGAO+V9R2CXvb+Mj
+lPYuULn/PY7YeUbV2u3X8mPwkb5eQr+/sxGxWz7vsYU1E/L9c3P6f4mvzv3
dRXEuxc/+/13OfWb923occ/j862DP4f4i5xj7stK761CvvqZU8VT/vzZybty
vt594p74UuXn9e/Ie/zLE/e4Mlta2dObcpR/feKeFPkWP/NUrCb+7Yl7eoaH
kr+O84Kct60P6VOBROGt+Otez8r52ElarfUtPIVvWMsKnpK3Jl9AWuNrb7z9
YHjwtSXM6e7HtVrLt9+fgX/1hC1/fASdYhz//THXV/bz00PSIaiV1s7sOM4+
eBSC+3f48n8F3U542Io4dKu/yan0u/8PdJU94g==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{129, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{129., Automatic}},
 CellLabel->"Out[1]=",
 CellID->123439539]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2884],

Cell["Plot a torus:", "ExampleText",
 CellID->20128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "\[Phi]", "]"}], "+", 
      RowBox[{
       RowBox[{"1", "/", "2"}], " ", 
       RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
       RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "\[Phi]", "]"}], "+", 
      RowBox[{
       RowBox[{"1", "/", "2"}], " ", 
       RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
       RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "\[Theta]", "]"}], "/", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", 
     RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", " ", "\[Pi]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24546],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytfQd4FEmWphboaTdtpulx2zuzMzt7u7d7lxKmHT09babNtCuEMI1paBoo
IQFCQkIGISEhCYG8d8h7771XyXvvSqbkvfemqv7vLiMyC+hCszN73/EVqcrM
iMiI/7148d6L97IEFwy1Na9fMLxy6cLv/mJw4Yb2lUs3f/e5ngF7afc/qKio
ZLH/bX+lwn7/P+w3+j8LAHvjiaMWe9zN3vqanmmTIzkF/afy1X/j6ut8Swd3
vPsae9jFnu6i1zU1NblbKvt3LP0K39YeRWlaSoUvrcW39Qr/V2U3d5scd65h
xLf3PC3C3eUK7KN/bvIt/ZScPfOoNt+GGv17g2/jyae9+ET5R03y5a/z5X/2
RI/I111KY/3ftPQ1vgc//xul/9cjvJT78vrfqPkiX+c3tMpl/nnP7ECnJxDi
67ykVOqfaBuf8G38li/1T0o92KNUi/RozyOqKrf2Z1rl8VUVlTd+xDOP7/zj
33jOC39n+7/i+/17pfaUMXn+72zv53x7//r/qb29/Pj/fYfxKrhZgf9O9V/l
y/2HUv1nlZ7/bz+ipmLu/a+/q5YGX1pVqfRzSqX/By2tzj9jv1JpZUQogirf
4Gku37fDc0iLXG++5Gu8rVRKmSP+QEv/ha97SKn0i0ql/4WW/pRvW5kblZ+1
c+3f87V/yz/zw79Ri/IkV1eJ8wmJP9phfKQY96w3+FK7lWr/ki/1qVLtnyqV
+92Oz/75E0g/z8+eJ1tRlhH/vGMrr+1AU8L/z5Brz59nhJqMkP2mxwgNGKER
IzRhhLcYoSl7cddt9rDbjBGaM8I75JwcdlswQjNagz7kFaU+vaz09N/u2KdX
8Xge0fXk+aOM8CQjPMsILzBCLUZ4nRHepP0gj3yBlNjjzQh9GKEvI/RjhLse
spd/4s8IH9KLnozQjRE6M0LyiBf+rh79Hj+ee/+k6Mkz6ozwBO3JJUaoTR5D
rv7MnrbPfvOkT2T7wD49kBEGM8JQRhjOCCMYYRQjjFEVxqkK49WEiWp8zWfi
GWEsrRlCq6mQpzy7Qx/JdY6C+/gzKqUImQSMUIMRnmKELLWowFH5rQmlgiUj
tGGEDxihIyN0pTj40kexvQrjuqT6oy4l7xOm7hOm7Rdm7BdmHRBmHxDmHhDm
HxTmc8e3hAUHhLsKVCmOKs+kMMI42oofR+89Sr1+VQlZTqoyPKJvPNH7oxTT
0/zoVf7A4qrLCA0pm7H8ZM0I7zNCB0bowgjdGU1v5rIfoxXIaIcyRGmJ3qcd
u18n4aBO0ls6KW/rpL17Lf3QtcxDV7MPXc09dCX/0JXCQ1eKDmmXHNIuPaRV
fkir8tDlykOaVYeEVe+xz6v6IwdZ1ZvCireEZW9yY/tJmqowYh/7MCHXfXZQ
r+04mv/cYfb8WlGSHZk6mRLk/j6WcS8zQh06jTjGtWYu32e0HZgrLsw1d0bH
m7nux+gGMrqhqjoR+3RjDtxgqyW+ZZTyjnH6IePMPxpn/8ko5wOjvI+MCj42
LPrEsOTTm6Wf3Sz/zKDyM4Oqz/RrPtOv+0y/4bMbjZ/pNX52venTa82fXm3+
VLvlUy22nZY/C5s/EjZ9KGz4k7DukLDmLSGnpyXvF4aqCon2t1dpfHvwhP6j
8j/5s988MTbSAG3lzdOU9YSM8CojvEGkhOZtRtuSuXaP0bVnbjgzBu7MTS/G
0I8xDlQ1DFEzithvEn3QNP4ts6R3zNn6GX+0zP7T3byP7hZ8fLfoE8viTy1F
n1uUfWFR8aVF1dd3ar65U3fYvEHdvFHDrFnDrFXjdrvG7Q6NWx0aJp0aRl0a
Bt0aemINHbadHnVt8WEt8Tea3V8Lu78Udv5F2PZnIVVtd+cdFHIqLtX+dim4
9UerM9XX6Lq4+6+N9CArhM4ppv51RsuAuWrCXDdn9KwYg/uMkSNj4sbc9mLM
/RjzQLU7IfstIw5aRb9lHffOvcT3bFPff5DxoT3bSt6nDgWfOxZ/4Sj6yrHs
a4cKgUPVYfuaI/Z1GnYNR+2ajj9oOfGg7eT9jlP3u87Yir+z7Tl7r++cdf+5
u5JzFpJzZgPnTAfPmbDtDH13c/CMweAp/cGTepwK/1zfYaH4K2HHZ8LWj/gB
s5M4WlWoPBd3/ZXR/4FHZzf/l/LyO49RUFE5RiUx++UH5rImc+Uqo6PH6Boy
+qaMoQVjbMOY2jHmzoyFJ2Plq3bP/8D94Lfswt6xj3zPMeZ9p4QPXZI/dkv7
1D3zc8+cL73YRooEPiXqPmVHfSuO+VQd96n51rvupHfDaa+mM14tZz3bznl0
nPfo+sFdfMG995Jbv9Bt4LLr4GWXIS2nES2HUS27Me3749r32HYmtCw5BF6a
uGg8ceHm2Pc3Rr7TGT6lPXRCU6Ih7P2GoNH+Cem36E06klcU8geKfyo76BJ0
1tP1d7dC/r7FQXGEER6nUJwiq4E2e0WL0dNhDPQZI2PGxIy5fZe5Y8tYOqha
u6je91S19z3gFPC2a8gh9/D3PaM+9I79s0/iZ34pf/FP/yogSxCUdyS48Ggo
20jpybCK0+FV34XXnA2r+z6s4Xxo04XQloshbcKQDs3grsvBYu2g3itB/dcC
B3QCh64HjOgFjOo9HLvhO3HDZ1Lfa1rfg8PhZ3P6dnM3bOdvWM/rWc5fvzN3
zXRG22hKU3/i4vXx81fHvtMaOUUw6VcnU4V9cPl+IYfJj7hiZzwU67ICF5X9
Ryka3xJAtM8x1y8xBuxVXebWTcbsFmNxh7lrrXrvvuoDB1UHVzUXzwPuvm97
BbznF/pBQMTHQdGfBsf/JTTpy/DUbyIy1KNyjsbkn4gtOhUv+i6BbaTyh8Sa
i0l1wqSGy0lNWokt2oltVxM6riV0XY8X68b33ojr148bMIgdMowdMYoZM4mZ
uBU9aRo1ZRrB4fD6glkg28qSme/Sba/l2+7Lpi4rtxxXbj1YMbZZMbRc0jdb
0DWZu3ZzRltvWlNn6qI2W2nsjHDohLDnGyojX/o7MXkDj20XKiv2H6EL2zGy
tmmfZHTOMfpCxpi9cYOxNFK1NlW1vaNqb63qdF/N1VHN03W/j+dbD30PBQZ+
EBr654jIz6Njv4xN+CY++XBCmkZS5vHknJOp+WfSis6li37ILL9EXAk12tn1
V3MadXKadXNa9XLab2R3GmR138zqMcrsM86U3MocNM0YNssYNU8ft0iftEyb
tkpT2UUw+dW8deKiTfySTdzyvRi2odV74as2IWs2gWvWD9etfNatPNfvuq5b
OKyb267ftlq9dWfFyHTJwGhBV5+tPad9dVZTa/oH4fBJig/Rp/bwqDxeL37F
X6Wa3f5Ha6EGo3mUuXKMuX6S0f+eMRYyZtdU77J3jVQdTNWcLdTcrdW8Hqj5
Ou4PcH0r2PNQmN+fogI/jg39LCHyy+RYQVqCRkby8cy0k1mZZ3JyzuXm/5BX
dKlAdLmw/EpxlU4J2079DVGjgajZUNRqJGo3EXXeEnXfLukxL+m7UyKxKBq0
LBq2Khq1Lhy/V8hxx2/m7fMWHHKXHLKXHTNXHTPWnNLYVjackjad4jedYjYd
o7Ycw7Ycgrfs/bceeG/Zum/ZOG1ZP9i8a7NpYbFudnv1ljHbzLL+jSVdnXlt
stAOnKDSRVn3/gVF5Rc8RtSa+jcOFfZzmNFUZ65oMNePMvqnGKPzzG1NVcur
qrZ6ao5smdtqPhb7HlrvC3ywL9TxzQjXd6M934/z+ygp4LOUkC/TIwRZMRo5
CSfyk08Xpp0tzjxfknOxNF+zrEi7XHStsly3qupGdc3NGradRpNaqnHu6bep
HbCtGbpfM2JXQ1H4l2nnylmXinm3ikW3siX30hUP0apH8bpn4aZXAVth2ytn
2ytT6pUu9UqReSbJPONlHtEytzCZS6DMyU/m6Cmzd5E+cJDa2krv3d22Mmeb
3DAzWjMi+sv8Fc2xcwSR3HeEyhYVh8mzT6w4iruK9VbZTqfc9JtHuAmYK4eZ
60cY/aOM0Wnm9nlVS6Gq7RU1Rz01d0M1X7aYxb4wm/2RD96MdXw3wfX9ZM+P
0nw/zfD/IjtYkBeuURB9ojj+dGnSufK0C1WZwmrOjni21aqtw6at615b9/22
ngetfXatVFFiB0VsLJXfbPjXbAZUbQdUsifSQJEsoFgWUCAPyJMHZMsDMuGf
ioeJ8I2FdwS8guHhDzdvuLrB2QmOD4hubGchszGRWuhv3NJZvqE1c1k4eIpy
jDI63Dz6yVPSh9oGzyqtW6AqKofPr5/A56qA0VdnjI4xt0+rWn6vantJzfGK
mrvuPp+b+wJN94Vb7I9lC99/J8Xh/XSXj7I8Ps3x+SLf/5uiIA1R2ImyqNOV
dIFUeTlfr7VQv63EsKPUpLPCtKvKvLvWQtxg1UMUS9ve9ge9nfa93Y69PU69
lJ9+OuwhHvUUj3uLJ326p/26Zx92zwV0LQR2LQV1rgR3rIW0r4e20ZZ/LQuv
loVXyMPL5OEl8vAihOUjNBsh6QhORlA8AqLwMAx+gfDxhZcnPFwIgi42cCRq
47aF7prxlUVdzfELFMHneQnM8ZVCI3+kuz3zCCr+xrN/VQMgUpKu9b9QYKkp
YHQEzE0BY3pM1fKUqu05NYeLam5aaj7X9wUa7As32RdrfiDJ6u10trzDR3ku
nxZ6fFniIyh7qFFJ7bFXEzVbU660p1/vzLrRnWsgzjfqKbrVK7rdV3anv9JS
Um09UGc72PBgiC3a6jTc7jLCrV19XsMS76FB36Fhv6FR/8HxgMHJwMHp4IHZ
kIH5sIHFcMlyhGQlsn8tqm8junczWrwd0y2L7WIbkce10ef+Qh5XhdhyxJQg
uhBRuYjMREQqwhMRFouQCAQFI8Af/t4EVi+imsocTbdsDNfNdFcMtWavClVU
nvLUvP5f8eWeJ9F8PKsf24TU6ntdgeplAXNdwBgKGHMN1Xvfqjp8p+r2g5qP
plrgVbVwvX2xRvuTzN5Mv3sox/YDIoecvyhzF1RSfeO10HPNET+0xgg74rW7
knTEaTd6M2/25xgP5JkOFpgNFVsMi+6OlNuMVt4fr7GbqHOcbHSeIrQlqL7R
5T0t9p3u9Zvq958aCJgaCpocCZ4cC52cCJuYCp+YjpyYjRqfjx5fjB1fjhtb
iRtdix/ZSBjeTBzaThok2Cb3y5N75SlieUqXPKVDntLKWXivI6kSSWVILEZ8
HuKyEJuGmGRExyMqChGhCPXnnew+tnAzl9obb1jdWL19dVF/J5T3/hWUn8ET
1ssT5ZVxpnr7a5ymKmC0BYyegDEWMJbqjN1xVbfTqj7fqwZeUgvXVovV3Z90
82C66ds5Fn8stPlYZPeXCg5h31MtAWfbgn/oDBd2R2n3xF3rS9STpNwcTDce
zro9mntnPN9yosh6quTedOmDmQr72SqnuVqXecq3v2vzW+rwX+oOWOoJWuoL
XpKELg6GLQ5FLI5ELoxFLUzELEzFzk/Hzc8mzM8nzi0mzS0nz66kzKylTm+k
TW2mTW6nTxBWzByVZw7LMwflmRJ5Vp88qwdZ3cjqQGYr10OkVyBVhJQCJOcg
KQOJKUhIQFw0D3OIO/zt4H1X5npry85g/a7Owo5Iv/ZfIP00wio/so+fRJz4
8lReVXD2FVbwCphbAsb6MON4lPH6VjXwrGr4BdXYy/uTdA6mG7ydc+vdQvMP
Suks/ZnnqQ6fs13+58VBl3pDtfojrw3E6A7FG4wkGY+nmk5m3JnOvjubZzNf
cH+h2G5R5LhU7rzM6S//1uC73uy/wbbRHrzZGbrZHb7VE7HZF7kpid4cjNkY
it0Yid8YS1ifSFyfSl6fTlmbTV2bT1tbzFhdzlxdyVpZy1reyF7azFnczl0g
kOfNyvKm5XmT8vxxef6IPH8I+QPI70O+GHmdyGtDbjPF/lVkiZBZhIw8pGch
NRXJ8QSJmEBEeCHEEf428L4tdTFcs7o2R1FX9idzqCvW/p10ACqclTCma+Ir
FGNNemQFspmAuSdgnDUYnxNMyGnV2PP7kjQPpl97K+fGu4XGfyzlZP9r975u
sjvS6nyikz3xPt/nd0kScHkw5OpwuO5otMF4nNFUoulMivlc+t2FTJulnPsr
+Q5rRU7rFOP/XeWzXftQWh8gbQyWNodK2RY6ImVd0bLuGFlPrLQ3XtqfIB1I
lA4lSUdSpGOp0vE06WSGdDpTOpslnc+RLuZKl/O2V/K31wq21gs3Nws3tovW
CdjFK7LiJXnxgrxkTl4yIy+ZQsk4SkZQMojifhT3oLgbxR0oakFREx3FK8gv
Q14xcvIIRBnJBJjEEMT6IsIVwffhf0fqZrhmfXWWQv6j/QFyzsmU15UwVvY1
0vsvUSbWoRjfETAPBIzbEebhcSb8lGr8uX1pl97MufJOod57PLo/u/NFk5Wg
9f7RDoeTYpez/Z4XiJz0vzIWdH0iTH860mg25tZ8vPlikuVyqs1qxv31bPtN
jn/3i7ylZX7SSn9pdZCsNkRWHyZripS1RMsJyHHoTJB3J8rFSfLeFHlfqlyS
Jh/IkA9lykeyZGPZsokc2VSebCZfNlcgWyiSLRbLlktkqyLpuki6USrdKiOU
kpZvyco3ZRXr8opVecWyvGIRFXOomEbFBMpHUT6E8gGU96FMjLJOlLWhtJkb
08soLiMg5eUQaDLjkRqORH/EeCDCHoEWUneDVesr0zvy9qs74vycEs50BvxU
ISwMKdQOAsZTnQk8xkSdUks8uz/jwsF8rbdFtD+vGn/aePvLVsvDHTbHxA9O
9TmdG3S7OOqlTSRl4I25EMOF8FtLUWYrsZZrCdYbyfe3KL7P5HlIC3xkxX4y
UYCsPEhOlUOVX61UyFcrZetVss1qGVGkaqTSGqmsZltWuyWv3ULtBmpXUbuE
2nnUzKBmEjXjqBlB9SCq+1Hdg6ouVLWjspn27KcQiVCUR0aWm4isKKQFIdEb
UfYIMt/20F+x0Z7UF/51jBQ25FOe4xcpJKyKYMCuW/S7z2Em+KhqzMl9yd8d
yPrhYCFHqVf0Pmq8+Vnrra86zNXFd4/32Z4etD8/4iyc8Lgy7aM7z5YINlkN
M1uPtNiMtt7i+G53mos0012W7S3jNNxfV0ahOha18ahPREMymlLIjGnNQHsm
OrPQlQNxLnry0JcPSQEGCjFUjOESjIowVoqJckxVYKYSc1VYqOZUSpVnthrk
2w0yaaNM1iiVN0pZvbJxmzULmzbRuIbGFTQuomEODdNomEDDKOqHUC9BfS/q
ulHbzmkUL6K0kIBSkIK8WGSFIdkb0XYINtv20Fu20VbZgfde2ZH3dtzzeEOx
VrEqmLmAcaSnYUfV4r7dl3rmQM73B4vZK1rv1et83KL/eYfR192mR/osvh20
/m7k/g8TjprTrtfmPW8s+RmtscVCLLbCrLY5/Wp3nKOMU7u5UfwhLxgFoSiO
gCgaZbGoiEdVImqSUZuK+nQ0ZhKoW3LQlov2fHQWoLsQ4iL0lqBPBEkpBsow
VI6RCoxWYrwKEzWYqsVMHebqsdCApUYsN5EW1ps55HehVabyT2iVonUbrVto
3UDrKlqX0DqPlhm0TKJlHM3DaB5AUy+BqKEFdfXkS2UxQagkDYXxyAlDiidi
7iPUdNtTd/me9g7y9Mc8/FMljKkH4HnF/DYRMHYsA7Pl1FUTjqmlf7svn+Pe
l4R/bLzycbveF903BX0mRwfNT43cPTdx7+K0vda8s86Su8Gaj8mmvznHtxRP
JskLKb5I80dmELJDkRuOgigUxaIkHqWJKE9GRSqq0lGdidos1OeQvjYVoLkQ
rcVoL0GHCF2l6C5DTzn6KtFfhYFqDNVguBajdRirx3gDJhsx3YTZZsy3YLGV
tLDShrV2bLRjswPbHZB1cFCwCn2nDJ1SdG6jcwudm+hcQ+cKOhfRMYeOKbSP
E8DaJGgRo7kNjY3sKQGpKh/lmShJQG4IUj0QZ4uwW1teujvx9Ms78rQy3vT8
5wJGiwoMa1aSCphwAZPI1jiqWsgez7xVc/695ssfd+h80aOvPmB8fOT2mQmL
89M2wvkHV5YcddfcDDceo3ww2g2xnkjwQdJDpAQiPQSZ4ciJIjOxIB6FSShO
RkkqROkoy0B5FipzUJ2HmgICVn0xGkVoLkVLGdrK0V6Jzip0V0Ncg95a9NdB
Uo+BBgw2YqgJI00YbcZ4CyZbMd2G2XbSwmInljux2oX1bmx2Y6sbUjFkYkDM
4/4r9MjQs42eLfRsomcDPasQL0I8RxDqGkXHINp70NaBlmY01RKYagtRmQFR
HPKDke6OeBuEG++gDxMdbLeC25/aFXpZCXVa+1lqH1+nqoKLgAkRMAkCJpPj
7xe+fbPu7KGWix93aX/Rp6s+dPPE+K2z0+YX5q0uL9leW6PS+H1fK15ihDiR
wUeyM88HcQ+REIjkELLypkciMwbZ8WSFyU9BATtHM1DE8k82RDkozUN5ASqK
UFWMahElQDkaKtBUheZqtNagvRYddeisR3cDxI3oaUJvE/qaIWnBQCuGWjHc
htF2jHeQutNdmO3GfDcWxVjuwWovNnqx2YftPkj7IO8D2E8/5+P9Ofpl6JdC
sgXJJiRErUPfAnpnIB5H9xC6+tDZhfZWtNUTzOoLUZWBUpaDApHhigRrlV1/
hQJPnv/kKUpwyuCPKUFnzasC5ho1O+wFjL+AiWPJIGCKyBQ40HDqUNv5j7o1
v5BcPTx848SE0dlZs0tLFP8PnW5tqyj++TsgyAWh7gj3Js+JCUBcMBLZtScS
qTFIj0NmIrKTkZOG3AzkZ6EgB4W5KMpHSSFERSgtQbkIFWWoqiDVa6pRV4P6
WjTWoakezQ1obURbE9qb0NGMzhZ0t0Lchp429LajvwOSDgx2YriL1B0XY7IH
0z2Y7cV8Hxb7sNyPNQk2JNgawPYAZAPAANnLGgRvgQ9JMbRFMBpcw8ASJHPo
m0TvCHok6Bajq503DRsLUZ2GshgUBiDThb2y4HRVEbujbPdx6CvsbmXaKGxx
8pfuLLJPoJres3Q5ZSWRjYDxEjBRAiZNwPAayzMnDrV/91HPxS8GtA6P6pyY
4nSST6z0Nm0Ntx1MyVzwuAfvB/BjLSlXBHkg1Afh/pQcYYiLQEI0kuOQmoj0
ZGSkISsD2VnIyUFuHvIKUFCEwmIUiVBSClE5SitQVoWKGlK9qh7V9ahpQE0j
6hpR34RGVjy0oLkVLW1oa0N7Ozo60NmJ7i6Iu9Dbjb5uSMSk7nAvRnsx3ofJ
fkxLMCvB/AAWB7AyiLVBbAxhaxjSYciHCQePEPfuKB5xFUa2MLKO4RUMzmNg
GpJR9A+gt4clPk8TdomqSUE5u5L5s6eyCIMdZobyzgtHm6d3cp++oky315Rm
D6X6T+nssRAwrgImVMAkCxhiaB1Wa9B4p5398v1fhoSHx6mOs8fw4qqp9oaF
3pa1kYzS9Beu9+BhB28n+LnB3xNBvggJQHgwIsPJ8+NiiW8iKRkpqUjLIEZz
Rg4y85BdgJwi5JYgrxRUN98r7kVPH6ki6cdgP4YlGB3A+AAmBzE9hNkhLAxj
aRgrI1gbwcYotsYgHYN8nKAzTkzkCR51TMgwvo2xDYyuYmQRwzMYGsfAIPrE
6GnlUW8pQG0yKiPJ90SLGUdtPoLyEVK8tHnuv4X0LhWVp6IfKQVeoLPCmFo6
AQImXsDk0Cv1R95qP/6nHjoP9lw7u3Tj4qqR9sZt3W2K7V67u3Cyhas9PJzh
7Q5fL/j7ITAQISEIj0BkDEU4CQmpSEpHchZScpCWh/QCXhd/ObcK+dUoqEVh
HYoaUNSI4kZSp7gZJeynBaIWlLairBW7yttYUVrRjqoOVHeitovo4w1iNPWg
pRdtfXyLeyWDGBzC8BBGhzE+jMkRTI9gdhQLo1gaw8oY1saxMY6tCcgmAfYz
RX3PU5zEYFXHyW1MbmJiDePLGJvD8DgGByDpRm+LgjI5qE8iX7LspZF6/z+o
8pQXVzk2lZNZVqyeSgVWBj2t4aTTr84KJtlz7e+Wr19c09feNNYlYurubdje
hb0tnB3g6gIPd3h5w/ch/AMRGIqQSITFIDIB0dScis9CQg7dFVR5LlWEtDLi
wMuoQmY1smqRU4fcBuzKZQmzO68Jec2cNz6f1T5fL2hDYRuK2smnuAMlHRB1
opT9dKG8GxViVPWghjWd+tDQj6Z+artJ0D6AzkHueS8NjWB0BOOjmBzF9Bhm
xzE/jsUJLE9gbRKbk5BRArHIzYC3/6e3MLWOyRWMz2J0DEMSDHQRwHrIZhpa
s8mx2FuWZKZYOZ6MAdr136KOslyjOxjPPRnzK2B0BYwza58JmBRKj2ePvtd5
4s8Dp76a+P4YsXGvXNjQ1ZLyFrH5bVhZ4r4tHBzh7Ao3T3j6wjsAfsHwD0dQ
NELjEJ6EqDTEZPL65MsJhUgoRqIISaVILkdyJVKqkVqDtDqkNyCjERlNyGQ/
zdiV2cLOEbZOZiuy2sgnux05HcjtIE7C/E529AXsAv5qYTeKxCgWQ9SD0h6U
96KyD1VUttVJ0CBB0wBaBtE2iM4hiIe5NfyFkTGMjWNyHNMTmJ3A/CQWJ7FK
qSNlaSOfxR7McV5AzG5jZgNTy5iYwdgoRliJ2UlQ66umJEpHVYg8+/5mhM5T
u2vP/z/Thvp5H8djs0ovF3kjYMoPq9VpvNt+/KO+k1+MntGYPX96RfOHDY4i
RjdhagoLS9jYws4Rjm5w8YK7H7wC4ROKh5EIjEVwAsJSEJnBy4hXYqktEVeC
eBESypBQgcRKJFUjuRbJdUhpQEojktlPE5JYC3hXEkuZJJ4yyW3gPintSG1H
WgfSO5HBUmZ3Zhd2ZRHq5HQht5s4dgt7yGNEfSjvR6UE1RLUDqBhEE2DaB1C
xzC6htEzynH4iyMTGJvExCSmpzA7hcVpUndjFluzkM5BPk/84vNcHzC3jdkN
zCxhahrj7Pzrw3AHgYqfKw2sxeqxnXTrqWhXbt4oNK6f4OmIJIr4i3Q2pHNC
6sjbLcc+EH/7+dDpw9Pffbt84fsNrcvbvIVtYgpzS9y1ha0j7N3g5A3Xh/AI
hnc4fKPgH4egJISk8aj/LLoA0UVkwyy2lMJfifgqJNQgoRYJ9UhsQGIjEpuQ
0Iz4ZsSxHxbyXbHsYU9MC2JayYdwTQy7juyObUdcO+JZs2IXe9iVwP5PZE/2
JnUguRMpnUjrQgbVdXPEyO9BYS9K+lDK0mEANYOoG0TjEFqG0TaCzlGIx/i5
+sLYFCYp8gszWJ7F+hw257E1D+kC5IvYhUViqC1QWbQgxdw6ZhcJwSaHMUZc
HvwK05aG6iBZts1PeWS5OaEc5/hzBd4k1Jn9K2DcBUwMRb1S/c3GY+93Hv9k
4NuvJk5pLJw7u35JSLyuugbk2aaWsLCFtSMeuMHBG87+cAuGZwR8YvAwgZvt
e8PzEFmIqGJEiRBdhphKUjG2BrF1iKtHXAPimijOLWAhZgGObkVUKyJZjPeS
+q9HtyOWGswJnQTS1C6kdyNLjNxeFPahRELcu1VDqB1CwzCaRtA6is4xiCfQ
P8lHFrOiY3oWc7NYmsPqPNYXsLGIrUVIl4jOwh5+SrBYlGJ+DXOLmJnC1DCH
ISQkBgCN0fISV+V4j2d3xJLmD7A1qbb5HwImkCqZosP764682370w75jn4+e
EMydPrV6/gIxyK7p48YtGFuS8Vk64p4b7Hzg6A+XELhHwCsGvonkVmAGgnMQ
mo/wIkSUILIMkRWIqkJUDaJqSYHoRkQ3Iab5MYBUxO0KZnn0uaA2BNKPP2Vc
n2Z4NcGrEbs8G9i+e9SD/Uu+7vJiD3u8G+DbBP9mBLZwK+vPWArEdYCFP6Ub
GWJk95L9oiIJSgdQOYSaYdSPoGkUrePopJqpZJqfac9PzmF2HosLWF7A6iLW
l7C5BOkysEL0kWUe+aVtLK5iYYGqTwMY61BwbxJqAlSejrT5ySPkFTYZ4V56
9Recn53jXcFbLervizU+GT721fS3x5bPfE/sxsu60DGGwR2Y2MDcnnT3vg/s
/eEUAtcIeMTyuoF/JgJzEVyA0GKElSK8HOGViKhGRA0i6hDRgAjqkmTZlGK0
lwU6sJUA7NcK31b4tMK7FZ4tcG+GK1VEHethXwc79lMLuxo8YD/VuF/N4nC/
ipWmdtVwqIFTLVzrSGmWHN6N8GuEfxMvEX4d14mkbqSKkdmL3D4USFAygLIh
VLH4UzOsfRLdU+ibweAsOZ2Yx8wC5hexuISVJawtY3MF0hVglWC/wnnfsbyF
pVW60I5gUoyRRoX9HL4Yq/NU5PwzO/L8SzwFqHT5A+fKpxSoE7zTefjDgSOf
Txw9vHDyDNnEvHANWga4bgoDK9yywx0XWFMnhEMInCPgGku+e6fCNxP+uQgs
RHAJQssQWoHQKoRWI7QWYfUIa0R4M4/L3pA2sAwe0IaHFHkWdq9WeLTArQWO
jbCrh20trKthUQkz6q8wKYWRCIYlLAqGxewqaViEm+ynEAYFMCyESRFMi+l0
LIN1OWwrYFcJhyq41sCzDn4NnFR7KZ5SI01BjaIBUqV6BPVjaJkgXlHxNPpn
+Xnw3PQi5pawuIyVZaytYHMV0lVgjZXjqxy/PYflZaIIsVb3uMJcbotbSjV+
CY/3TxV5bY+Rf5FHnq6vr7E2F4W9VMA0CQ71CP48pv7V3PEThLxntXFRD1rG
uH4HN+/hliMsPGHzEA9CuPH81CMVXpnwzYV/IYJECCmngNcgtA5hDQhrIoBz
+kF4B8I6EdxJBuzfAb8O+HTAqx3ubXBpgUMTbz/t1srZPJW4RL7SmLTd6j6L
R7zpOZ0xL2pnQCcL+rkwyod5Me6KYFsG+wq4VMGzlgDNx1zEdxG5w37L6yf7
phUjqB1D4wRaJ9E1jd5Z4m5g704tYXYZCytYWcHaKjbXICX4rivwXVnDErsI
DGOqC2MNHMRrBfdeUUJ0zyOcFeslwVeRraLyikC1XfC+RPDZ1GH1JY3TRKCc
08HFm9C+DV0r3LSDqSssfHAvGA8ieOq/6M5imwXfPPgXIbAUIZWEk8MeAdui
kJbhnQjvQlgXQroQ2AV/qjZ4dsCtjcdit3Hpum4BxVDRQ5WX1Z1XVRT/NFOg
kwnDPJgVwbIE90opoNXwqiOChJb/bUIXESLZrAQZQOkwqkZRP47mSXRMo2cW
Az8Gc3kVa2vYXId0Hdig6sY62bklEmVhHDN9mGjBSCWJByx1Uo5A370jzz7D
Y0q9nTRCcl+NYF+34INhwRdzgmNkr+mklvzcDVwygbYFdG1h6ITbnrgbgPvU
0eKcCLc0upDl42ExAssQXKkQDBycKiosk3JohosRJkaIGIFiPOyGdyfNenqU
v6Fuu3bcbZPD/yfCJOik42YObhfgbgkelHOI7Q2goj6mg8z49B7k9qNoEOUs
H46jaRLt0xDPQkJxm1zGzArmV7G0htU1nq4vyDfl2KCosVguz2B+CNOdGK9T
oTrGK09qDE+htZu/S+1FGlW1n9QTfDQu+HqR/aJxUXZKR/79TVy6jSvW0LOH
sTvM/WAdShedRLikwiML3vncWPYEVdEp3fhoPj/3CKfwHoT1IrgHgT14KObt
XY/2TYfGFco4dOklmFmtH3Mjysu5GFxO4tu9Wwy7crjVwKeBu/IGu16lsOKR
47MRsr/cNIX2GYjnIKGK68QKplcwt0q+r65jcwOyTbBYyTeJ3wGrC1hkzfge
jNdzQFFpt4fuP3J66o/nKwGN8NWveD2gUHCgUfCmhIClTgZwTFN2Wk9+3gSa
lrh2HwYuuOUNiyDydPt4OKfALROeefApxsMyBFbxs+sxO7EYdROMIvoQKUG4
BKHUCxEg3vLrWvdtm+XwytzPJ1FQHuOuKWK0+Myt35+LgnYSDDJhlg/rYtiX
w72aCjxWj2OZjIKWP0hBm0DjFNpm0D2H/kXqMV8hxzlWmK1jbQPbLGJbLGKU
u9ZZ4TeNeQkmGngL7Mfez0dakrJX6JHltVOE7qM4NE36j4vv2yNgCgQHmwVv
Dwo+40b+s+PastM38YMZtGxw3RE3PXCb+rPvx8IhGS4ZcM+FVyF8S+FfiaA6
hCo0mz0R3YjsQVQ/ogewK2aQU13DJdKQ3s2QnnVubs5YXR7WIjBWvEuOgQyN
TFdk61KI+UwegSLH7N8FN9YE1lvqngScH6JxNQmGWbiTj3slcK6AT91jwDP6
CeCiEVQ/AnxeAfgqptcwv47lDWxsQroFGQFcSll0DgsDmGzCUKHKowjdXTyX
Pr8j0k9n5Twdo0rD1snVfxQw+YI3WwTvDgv+QjxA6hekR3XkZ4xxwRLaD6Dn
CiMfmAWTVh4kwDENrtnwKIB3CfwqEFCDYMpTkR2I6kZ0D6ep7k4YodJsSMah
/8xECYkKXXS7tmCuOa7F57LtTtsvjFQj6YT0XJHHTugufATzbp67WYPxioJb
VPYKLi4Kbm0J7MgkPh0KYSxupMEsD/eK4VQO71oEU79fIot6H/JY1EcJ6g0K
m+FlyTIVDmuYWcfiBlY3sUUxl22RFuVrC/LFIUw1Y7hkF8/TL/13kFbaayCy
9Q1FScGbTYL3RwRfLtCR/et3prhojSsOuOEBkwDSgnUs7FLglAm3PHgWw6cM
D6sQVM+jHCNGbC/iJUgYQuIwkqhWnjyOlDFp2uhWxvBSkUTMXlkuc9pIIcld
qw5Xl25fntYWDp3icvWeLzsozNpHkkVDKMzOjPAezSM0Zk+pVvWT72g20gl6
PEOzT35MF0ILng6MEyeIBN/NCwy31W1kx9wIgpdioJeK2zmwKYJTGbxqEETX
t0R2caME4f3XjTNon0cPnQSjq5hkbeMNLG9ifQvb2+Cpsb4oXxqWz7Sp8JG3
T0jm/1eqKEddUnn+ezKOg/WEOl8T/eewpkxDn9S+ZIurztD3Id8tonAvEfbp
cMmFeyG8SuFXhUBW0lCGixUjvg+JA0gaQvIISxRyMWNCnjMpz5vcLhhf46Tz
c9JsK1mc8baf3rrdtRVT7QUdAmy/upDi/0I0Iwyi+b9uNF3VhqZGszf0GeE1
ViZdZoS0lZ9okJwPoYIq1wSMLoeqgCE5cQI1keBjEkF3WG9bw0J63IUSJgq6
ybidDetCOFLCBDZxs+61giGUjaF2Gs2z6FhAL50iY2uY3sDCJla2sLnNEoU0
Iltfki+PymfbpcNFyki++HdSROGXU45no37R35HuH6gRvEe6LzizJdCSHzXA
mTuk4lU36PtRSsTgXjIcsuBaAE8RfCsRUIcQSoaYbiT0IXkAKcNIHUUaJUPO
lLxgWiaakZVNb3L7p+MDJRz3yoqc5KlWvB21+UB3/fZV9tvMReHwt0Lx18KW
D0mm60vk7kuXaNI2++1bOjEOk0ARLsBRnx65EDN/fm0UHCRpH4KLm9QQVnk9
phPJPciWoHgElROonyHhRF1LdF90DZMbmN3E0hbWtlmw5dtbZAGQr4yxxw1J
rnIUq3I01n+F9H8VQUi1PuJpFeyvFByiusx3W4Ir8mM3cdoCl+z5ufr6rXBY
xMM2DU658GDlUjn8axFCp3V0F+J7Cd5pI0gfQxb10BTOyEWzsoo5Wc28lLbw
r2PjzYtDpWRMzRGo9EWuExKtEWbGXtm2098yv05A17wydlZLcpSk3TZ9QIAu
PijM3i9MVhPG0CT4hxR9RzotzGj+/jWaSUtJcuUoya/QY4nBPZFG8HAhaeF0
ShQLDjQL/kjZSlt62ESqcU923IOs3VrRuJmCO7m4XwzXSjykq1q8QlyJxlAz
jcZZtC9AzE2MDUxvYn6LTIyNbfnmFrd/u3trupmD+ikZszO9FFqRInZZeUWn
scp0v3NfueCdXp462jhuhDN3cdERV724NfdV53xeGgXRvkd1Iq4HSRKkDSNr
HLmTKJwh18vn5FXzsvpFrr8vjM4Nzk+1bo3SKNX2BNSHQeSHTBfEP0DIXSoZ
frl802D2it74+euDJ66KBZfZS7V/Epa9Lcx/k2T4J6iR5H32ohcjdCJk0TJj
rhgw164whJ6nGX0NkpphwnERu4bY0ugeHwETymXpC/aVES36nQE6to3D12Xq
5jINB0KUCyG4HodbGbDKh0MpPBXLCKtNZUlQOILyCdTOoHkenXQOjWxgYhMz
W1jcwuo2NrZII9srY6ujFVRg/g2K/AOlyK/whDX0EpGib4sfiaHjN/EdC7sT
rlCPkmk07ibDLpvXMp/jpgMnflIGkTmG/EkUz3AUeqVjRd6/QoJ7ZhaG1qfJ
eoYhEh2J5nhUh6PQH+meiHFC0H148tLotRXjW/M6xpMXDYfO6LHnbV/p1H2i
W/aRbv4HuhnvXU84SDAOYK56MNcdGH0r5qYpY6THGNPnvSBg7lPWd6dRPGEC
JpaeFgr2VwveaqXt/6Pg2zXBZflhA7m6lVzDlc6ESBgkwTwbtkVwqYAv1Tzi
WIO+DzmDKBlDFTsT5tBOF+3BdRIZMLWFuS0sb/O2yPqCZK4/B3g6KlyZuznE
ld/7Q612mgPxFgm0F5zaFGjKj7ELgAVhePaKQQhMY2CVArscuLKiqAKB9fTd
JSqv1y+heQVdq+hfk4+srk2vzK4sjRCMpxoxQrgAHRmoTyARIvkhSPFDtAeC
SOwOHO5zq2/PSeNWddM6wa2yv9zK/+hW+ntEjQrfb/yQMXFnzCiy/66pev+c
mv0xVecjjAfFNFjARNJ4NW4jqVxwoF7wThdRqj+dIVcuyQ/fkKuby4/YE4gv
BkMnBiZpsMqFQwk8WQ2C+m8Te5A5gMJRVEyhfhatixBTU2yY8jU/g1Y2iUdo
cYqsLMqyfGd839gJ331k0v2ZpDMJhPJjN8jqetGBghsK0zhYpcE+F64l8Knk
BQor5FmuThtCzhgKp1BGHcANy2hdQTeBGyPUa7O0Os/OOPlCH4lCHKvDYDkB
tyWThOWI4pAbgZQQciXQG54eckfXTWun1dv28wYP6Aq510X1wT1VBzNVolde
U/O4qOZzSvXhcSb4CBNJkU0mIYHkSxldsVoF7/YK3h8TfDHPzcDX1G/juC1O
u1FVIRJGybDMhl0R3Fn1gJPpYqRLkD+C0knUzqJ5AZ3LnAb0DMvGrEBf3NxY
WpmeHq54Sj4oo82hq/x2LOq5/g3p3ftk5RZclB3VwxlzXKQbAfosurG4mwY7
Dl1WXFPSx4mRIkHmMPInIJpBJXX1EE5eQ/86WME2uSlf3NjgeOCAfGmIRBdO
tGK4Hv2UrRtzSVxmcTKy48lpVBgCg+EVIHXy27DxXjIjGuGYjrtE07Xze9em
U65VGi7FXxG+T/rYLfJP7oHvenge9HJQ87Ha58devLEv+LJa+FnVqG9V44+p
JlPAuRCbCsG+WoEq1WreHRR8NMWpyoKL8iM6vPfyOxfS9SvhuJkIiyw8KIR7
OR5SQziuG6n9yBlGyQSqZtC0wPP0sxI6RJbHZ6nInlsYGOnNeUqXVJYmHP6/
4eW1wk5X+bXgguzodZwxww8PyFP1QmASC8tU3M+Fcwm8KxFIOSFBjFQJskdQ
OInSGVRRyNtW0bOGIdqZebYztMV/k6/Ny1cmSKTalBijbRhsQA8NDqgvQkUu
CglLIikJUfEIioV31LZT+JptGHtxyjhoWC+wRzug7WJA3XcB5cdJVFr614Fx
nweFfRTs936o6zvhDw4Q1jbcF39tX9LFfaln1DJPquVye84Cplr9QIP6O62C
d7oJzB+MCz6bo+vkNhGJevj2Fk5bcwqfyrN3MvCgAK5l8KP7dTFdSO7j7z3X
SrUWlpU4WTK1QXTLick2ZQtKeY3kMP5npauPfNV/YLURDR2cNMW5+7jkQZ5h
HIM7KbDNgVMxPBWzLoHOutwRFE2ibAY11DnXuUp4e3SDxMiwpxucvru+jNVZ
LI5jZhATPRjuQH8zuus5SryBMrpiZuQgMQuR6QhKlfskb7mQ+Oy5u3HjprED
BrFdOjHNmjHV35Pt5ZzjsSmH46K/jA/6NNH7o2SnP6ayF83eyjI4mHv1YMGF
g8Wc3PiZ+oFmjUMdRz/oOfzhgOBDEm0u+GaZHL+XHr6C4wY4bYaztjjvSnp6
LQyG8Vygk8oLWUMoHEfFDOrm0UJR7mMZiK6LE+ubj9798Dcx/t0OGKv8UnCQ
xAyyCt8xY5y5hwvu5AE3o2GeApscOBYpQ5w3ipJJVMyinkIsXsPAOj/LXlom
ZoVMvkX8qmSvbnkO8xOYGsJYPwa70dNOgmmbeL/eL5FXhvQSJBQhMl8elCv1
JQJg0S5ryipz2Cyj1yijTTejXptEdxWcy8w4lZVwNCv8cM7DL/PcPstnL1p9
WGL6pzJ+/vzwTv3pd4hifPRQ1/GP+o5/OnTk83HBX2YFgiWemy/J1HVwwgjf
WeK8HS5STtKLgEkCLDNwPx+upfClsafEhOpD9hCKxlE+Q3KLOE7qXcMglSLs
6cjcoHJcM8H8H9hTgjWHt/LbASneJBxAcJ4PYz5HJdmNSNxOhnU2HFiwK5TB
Fk2hapZk4fB8NE5kGFaIqcx7k7C+QfaLFudJpMvEKIYH0d+HLjFaiXKDqia+
JhIq5ZHlsmCysC25lczYF4/aFPffKe40KWrSL2IvirRKci6WpJwVxZwsDT5W
7qNeyef3GH/WrPtJq/afOy5+QjTVU58Onvxi9Nuvp44K5tU1lgUn+FXj14ev
Ei2KnatnrXHBEZpUhTWMghk7vCzYPyGoY6mgzh1G8QQBmZuuHSzI62BF9dCa
jLb4qhKCzzyF8b/shDH1oV6Ra5gp9q6uhcM4EVZsF4rgUfF4nU6jEkM0ycuw
n7OTioWX1TRXt7C1/aSPlLWaV8k29NQsiSsaGEXPEDqIKYvablR0orgdua3c
fN09YFsjtqxpvV3Dnf+n57dkNbun0Wmu3m0k6NH7pv+qYEh4mKzdZ9RnTh1b
PHFy9egZonMdvSQ7dpWsT6du4SzLpw8gdOXX9FuxsEhVFnrxCqFXPIXy2cco
spOSFRGSlXXxeKdyBPGepzD8A7++UeyoB/H7rcP68qPWIIENKr9jF9LGeXRQ
A4hHiIWD86Ft4fG+0PIW8TDPrGBiEcOz6J+CmCbVNA6iRoKyfhI2lC2Wp5GF
ZiuqczWkff5h+6Qn9waAX1aathcbduTodaRc64zR6g4Viv1+INao/RmJ1akh
s5Mjxt+O3Tg5de0kWZ4unF75/uz62R/IPDqtLT+lIz9tgLO3eHr/QtMZV7wo
74XDLB5W6bDLg6sI3tW8MsTqwekDyBtTAEdNjfZVotb3rJLB7P2bqP0PpRI0
yuCfqCiVq5vKj1NV92oEjJNgxcpRVi2oUvgoe5AxiMIxlLNK+BzaFtFDlfDx
DeoKYyfzBjY3yT4SNqDYW/+EeG6m1jC2iiEi0tA5g9YpkpRXPYbSEXnBkDyL
eB224gdWIvsXQvun/PuHvfv6XPs6HfrY69V3+0XmkjwTSYbhQKL+YJTucPBV
Yra4CCceXJyyvjBjfmHe5MKSwYXV6xfJ7uVlTcL4l67jgj5+MMIPprhkicu2
uELtI72HvHFqmQzbLDgWwINVChTiM6mXDDBvHCXTJIuVvdi0grYVeeeKnE4z
JeR2P4Xtv+2E7ceC0+vExrEijVwKhl4szDJgm0/0kSe1v7xhlE6QfNBmhedr
ZB2T68Txu7RBt5s2IFsngQtYBijlMb1NdJYREttBiMHyessCoU3ljLxkWp5P
jJiN1ImV+PH56LGpsLGRwLF+37Eu91H2eo3deKnNeIHlRLb5RMrtqTiT6QjD
Wfa6p+6Cy/UlO51Vm2vrFlc3TK9tGerwkX7PX9PHVSNcMYX2HWhb4eoD6DhB
zwMGfryUf/VeOhzy4CYi+junTLISM7lfWX9vXGY1AjldTJ/2/fwYU+V3wVKd
4bd0Ndo8bCQ/Qv0hWuEwTIJlDuyLidHIO0N6kD2AolFUckbjPLqXFK7bdSys
Y2Ud6+vYWoNslQRFYQmY5yye32JoG/2bEG+ifQPN66gj2c2yEqL4rGctLKfO
zyfOT8XMj0bMSYLnuv3I3K5zm69wmi+2W8i1XUy3Xkq0XIm+sxp6mzCll8mm
q/GWg9H2PUPO4/eyiTFVV8xgYIEb1tCzxQ0HGLjC0AvGlEfNo2AZj3tpfNRu
gMKRHt+D1AFkj1JLk/Jo7RIt87eR/J+8vKRc+c8EwYtbh01kR5wJgqzZfSsd
1vlwKoUP1ZJju5DaSz0bo6ie4n18vRTByTXMrmFhDctrNNxjhYSVyVn4FoBZ
YJrnhn9EL01cbN1GI8l9llYSubdesLmcvTGXvj6ZtD4Sty6JWheHEpAa/Nar
vDZK3TYLnDezHLZS7LbibLfDrUkV/7tS77ucX27vfQtYWcDyLu5Y07n8ALcc
YOICEw+Y+sI8kFy8Gw2bBNxPhUM23IrgXQb/Gs6Vq7K7ZlFet0DT4WgcwjNP
RoErdhC5904+lf1I90GE2+q3iYi5EExccKYZsCmAcxl863hvEOcXLR1DzRSa
ZtG5gH4OsxXMrtKojhWsLmNjiQZBzkNO3QUkhWEUGFTEVaGFpDZv15InrYqk
iwXS2RzpRIZ0OEXaHy8VR5PrTaGymkBZ+UNpkbc0x0OW5ipLcJZxGsHvvO3g
bgdnO9jb4YEDbJ1gQ3W2u56w9IGlP6xCyKltLOyS4JAO5xy40U2bh1WPvRrx
1FeXNYaCKZTQblbMy6vmyLPf2BE7js+U36NMsfsDwU5r+/AdAv3FEOjG43Ym
7hXCuRx+1JOW0E32JAuGUD6Guim0zKJrjiT7sbcmljGzjPllLC1hZRFr89iY
wzb12sonIR+DbJgkq0l7IevmwiRUnp0ulI/lyocyyIsNxEmExZtj+Ht/iPci
3i32W5A7HrrD2w1ubnBxh7MnHL3h4As7bvM8mA96cUiAUypcMuGaB/ciBUz1
vDeZ8/CnjyJ3AgU0bLh0VlY+S2DidpIfR7Pz81GFewe6MkZUx766ddiSYHQh
FHoJuJ2Fe0VwreD97ondyOwHvyE1ieZpdMyid47XH/aSSLdFGvE5R0xF9tLm
FDYmsDmOrRFsDWJLgs0ebHZhnQb1LjdgoQYzFbzFtrcuHlWxEEWiIAxZIeRF
A0mBiKObr6EPEfgQfn7w8oPnQ7gHwC2IBMo6h8FJEWu11zkJrulwo/vgXiV0
h7b6CXbicBpB5jhyacJB0bSsaGqLE7g748TsJP33Ci6uCmhK64Uw6CXBLBu2
xXCrhL9icyKtD7kD5F0fVeM0pICLElLg9B9T85hhTTzKQIuTWJrA8hhWRrEy
hFUJVvuwIsYSjbGba8ZMAyZrSHL8UCkkxegpQFcu2rKo6E1FZTJKE1AYh9wY
ZEYjNRKJEeRWRBhCQhEQSt6v5RsOnwh4RcEzRoGUaxIp5JEJz1x4F8JXRIIG
WCEV3Ph47rFgpXLbRpPkYsGULGd09UfW2eM5p/qkbKeRSkaU/1iTPAGmWbAp
JPv/XNQFt9dG9gmGUDGK+gm0TKFzGj0zkMxy682/Tk1jehLT45gZI2lXc8PE
xTPfTyKCZmhk3GQrxpsw2kDS2geq0FuObhE6itCST+5WZ6E8g6RvF6YgLxk5
ychIQkoCEuLJ3fBYhMQhOB6BCQhI5GOYfNLglQ7vLPjkKqKAyxFQRYJVHm0e
cFvIKSNk7zJ9nFzMGifDVFgCHBbKb0ync4vu413dEDwgbHM5FjfTYZEPOxE8
qhURgJwAyqeBeaxyyqqoLZMkmLRHsZ79fmQCo+MYGyPpFhPDJGVwoh/jvVSp
6MJIO4ZaMNCE/gb01aO7Bh2VaC1DYwkpUJmPslyU5KAwC3mZyM5ARgZS00lG
HaF4KiLTEJ6uiFoLykJgNonCfZhPAhcDRAgsR3AVnYmN/Juyo7tJxEPCAJKG
kTzK19ydOkITdAElVJTfQE9n0s8JKmZkiT0fCZ0kEphwr5hsbnAimYsiy2JB
kUA0hCoaYcteb59A1zhJweZWm18PDZNUvaEBDNGorAExJJ3oa0dPK7qb0dmI
jnq01pJ88XoaBVwhQmkxiotQUIDcfGTlkRcdpeYiKYdv8cXIAkQUkoD70GIS
hRxc9kTg5hPxx8/G9CJuAAmKeI+kEcr1//6E7qOicmAnrfw5wY11boJcjoNh
JiwLYV8GjxoO25f4kfeSSG9CvGHUjqJhhKQ4tIygbZjP2+HiQl4R96C7G12d
6GhHWyt5JUBzExobUF+PGmpclFdCVIHichSU8nVeii+iSlYxokWIKiVZBeHl
JNSaGycX+UvGyVE1ootEaUX3c7WJnbHn0fgO4gk7+DmBwQY3rqvJMMmBVTEc
yuFRy/ug46hU48KmC1miDqJ8ENU0gaN+kFi8zYNoGUDrAMnuo1tNKq9kVyKj
Aqnl9OVr5UgoRxylYkwlyYKIYIlS8zg0nI9r4oIaI3oRLUGMIqpld5B4nafB
v/Aj4OIu31KikOKt8Cp7yCByYVUCh0pur/C1+C4k00jQbJYt+1HUD5EE5RJU
0dSqGsqAtf2o7UNtD2q6UdWJig4u7/TnZa0obYGIKtJFTShoRF4DcuqRWYe0
WqTUIKkWibUkFSmuDjFUWEbWI7xBwXNcNJxSPGKEhN/d8+1c4/v/OzwRhfbU
7yUQOlEe2GNZjPtlcK4iwe10dM9zSQYZYuT0ILeH5izR9LES9rhLxB5+IepG
STeKu1DUiaIOFLajoA35NLckpwVZzSSDML0JqY00fY3mriU0kTSf2GZENyOq
mXvST7ghhIkR2oOQXgT3Pnq77qOoLpV3lHr+6LcMnr2eAZN8WBSTKGeHCrjX
wFcRM/4sl66STDktnSZgZbJLBsmK25XNfnkuqxOZ7KcDGe1IbyOlUlqR1IJd
CeQVM1zW16NsJP4t/sGdCO5CUDcfSUyfpECZe0/Mu0p9ff1RX6+mwzAXd4ph
Uwr7SpJL4F3PaTy72K7u5jPHVPbEtyOuDbG0R7vYR9MnPxdEE0v82+Dfjocd
eEiH5dP56H3VpAfcOxsP8fOQWmIvc0Hu3L8bOTAtwt1SktDgUE1Xfpr0w2X7
0PiZFwJbEUAfxWVSeLWQTAqvNni0kRB0wi+/4Z9GY7JU/rjDeH/8OzaUx35p
kEeyKsxFsKrAvUrYVuF+FeyqYV8Dh1o41sG5Di71cG2AG9U93Jrg2gSXJjg3
kRQOhwbYN3JS+Xc8b3Bv5n9f6fnKnieyJ0gUWsVM535b4U87cNST54f40tzv
lXygdFf5l4Xe4ktTHwH9hRGCv3KpA3y/uV8S+nin1eCJc1W+Tfr7LtxvzCiv
mk+c/ydfmq4x9Bdlnv6dkcfnCrlNJQL9VRLSX+VSCsTeo6U+V7qrvJP9z/zo
KFb0F17+q53ZN/i2KQoqXyjdVd5H/CVf+jNa+kulu8q7NXv50rQc/c0sMjrl
Uq/y/RXQUt8o3d2ldP4S3+YRWprWecrqVESmH6dlDkPZkniWv3+K3lfnn7+H
/3uWXiW/6kMaPk/PVP7h/wIzXD1P\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{181, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{181., Automatic}},
 CellLabel->"Out[1]=",
 CellID->298589536]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20481],

Cell["2D waves:", "ExampleText",
 CellID->11714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], 
    RowBox[{"Cos", "[", "y", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"10", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", 
     RowBox[{"10", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20149],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{173, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{173., Automatic}},
 CellLabel->"Out[1]=",
 CellID->153087238]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13338],

Cell["Triple\[Hyphen]periodic surface:", "ExampleText",
 CellID->20307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "+", 
    RowBox[{"Cos", "[", "y", "]"}], "+", 
    RowBox[{"Cos", "[", "z", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "Pi"}], ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "Pi"}], ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "Pi"}], ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Contours", "->", 
    RowBox[{"{", "0", "}"}]}], ",", 
   RowBox[{"Mesh", "->", "False"}], ",", 
   RowBox[{"BoundaryStyle", "->", "None"}], ",", "\[IndentingNewLine]", 
   RowBox[{"ContourStyle", "->", 
    RowBox[{"{", 
     RowBox[{"Opacity", "[", "0.8", "]"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26793],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{158, 185},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{158., Automatic}},
 CellLabel->"Out[1]=",
 CellID->359135258]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1105],

Cell["\<\
Approximate the almost nowhere differentiable Riemann\[Dash]Weierstrass \
function:\
\>", "ExampleText",
 CellID->1697],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"N", "[", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{
         RowBox[{"j", "^", "2"}], " ", "x"}], "]"}], "/", 
       RowBox[{"j", "^", "2"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "12"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->407741761],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->259563363]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16641],

Cell["\<\
Basic parity and periodicity properties of the cosine function get \
automatically applied:\
\>", "ExampleText",
 CellID->2343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cos", "[", 
  RowBox[{"x", "+", 
   RowBox[{"2", "Pi"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26133],

Cell[BoxData[
 RowBox[{"Cos", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->250636768]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"-", "x"}], "]"}], ",", 
   RowBox[{"Cos", "[", 
    RowBox[{"I", " ", "x"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->679],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"Cosh", "[", "x", "]"}]}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->74368135]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", 
  RowBox[{"Cos", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1954],

Cell[BoxData[
 RowBox[{"Sec", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->28005712]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10252],

Cell["\<\
Complicated expressions containing trigonometric functions do not simplify \
automatically:\
\>", "ExampleText",
 CellID->19904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"Cos", "[", 
    RowBox[{"3", "z"}], "]"}], "2"], "-", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Cos", "[", "z", "]"}], "3"], "-", 
     RowBox[{"3", " ", 
      RowBox[{"Cos", "[", "z", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "z", "]"}], "2"]}]}], ")"}], "2"]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20279],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"Cos", "[", 
    RowBox[{"3", " ", "z"}], "]"}], "2"], "-", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Cos", "[", "z", "]"}], "3"], "-", 
     RowBox[{"3", " ", 
      RowBox[{"Cos", "[", "z", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "z", "]"}], "2"]}]}], ")"}], "2"]}]], "Output",
 ImageSize->{257, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30896504]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24870],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->11773472]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cos", "[", 
    FractionBox[
     RowBox[{"x", "+", "y"}], "2"], "]"}], 
   RowBox[{"Cos", "[", 
    FractionBox[
     RowBox[{"x", "-", "y"}], "2"], "]"}]}], "+", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       FractionBox["x", "2"], "]"}], "2"]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", 
       FractionBox["y", "2"], "]"}], "2"]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       FractionBox["x", "2"], "]"}], "2"]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       FractionBox["y", "2"], "]"}], "2"]}]}], ")"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->26072],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", 
     FractionBox["x", "2"], "]"}], "2"]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", 
     FractionBox["y", "2"], "]"}], "2"]}], "+", 
  RowBox[{
   RowBox[{"Cos", "[", 
    FractionBox[
     RowBox[{"x", "-", "y"}], "2"], "]"}], " ", 
   RowBox[{"Cos", "[", 
    FractionBox[
     RowBox[{"x", "+", "y"}], "2"], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     FractionBox["x", "2"], "]"}], "2"]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     FractionBox["y", "2"], "]"}], "2"]}]}]], "Output",
 ImageSize->{452, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->129229844]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->26701],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", "x", "]"}], "+", 
  RowBox[{"Cos", "[", "y", "]"}]}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->13527235]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18086],

Cell["Compose with inverse functions:", "ExampleText",
 CellID->4231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"ArcCos", "[", "z", "]"}], "]"}], ",", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"2", 
     RowBox[{"ArcCos", "[", "z", "]"}]}], "]"}], ",", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"3", 
     RowBox[{"ArcCos", "[", "z", "]"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17480],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"Cos", "[", 
    RowBox[{"2", " ", 
     RowBox[{"ArcCos", "[", "z", "]"}]}], "]"}], ",", 
   RowBox[{"Cos", "[", 
    RowBox[{"3", " ", 
     RowBox[{"ArcCos", "[", "z", "]"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{264, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->48858067]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30260],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["z", "2"]}]}], ",", 
   RowBox[{
    SuperscriptBox["z", "3"], "-", 
    RowBox[{"3", " ", "z", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["z", "2"]}], ")"}]}]}]}], "}"}]], "Output",
 ImageSize->{189, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16798595]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8938],

Cell["Solve a trigonometric equation:", "ExampleText",
 CellID->16657],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Cos", "[", "z", "]"}], "2"], "+", 
     RowBox[{"3", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"z", "+", 
        RowBox[{"Pi", "/", "6"}]}], "]"}]}]}], "\[Equal]", "4"}], ",", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14990],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{579, 168},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->296643189]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28981],

Cell["Numerically find a root of a transcendental equation:", "ExampleText",
 CellID->15447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Cos", "[", "z", "]"}], "2"], "+", 
     RowBox[{"3", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"z", "+", 
        RowBox[{"Pi", "/", "6"}]}], "]"}]}], "+", "z"}], "\[Equal]", "4"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5242],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", "4.045601359490997`"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->426260367]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16070],

Cell["Reduce a trigonometric equation: ", "ExampleText",
 CellID->25631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{"\[Alpha]", " ", "x"}], "+", "\[Beta]"}], "]"}], "==", "0"}], 
   ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24061],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Alpha]", "\[Equal]", "0"}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[Beta]", "\[Equal]", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["\[Pi]", "2"]}], "+", 
          RowBox[{"2", " ", "\[Pi]", " ", 
           RowBox[{"C", "[", "1", "]"}]}]}]}], "||", 
        RowBox[{"\[Beta]", "\[Equal]", 
         RowBox[{
          FractionBox["\[Pi]", "2"], "+", 
          RowBox[{"2", " ", "\[Pi]", " ", 
           RowBox[{"C", "[", "1", "]"}]}]}]}]}], ")"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Alpha]", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "\[Equal]", 
         FractionBox[
          RowBox[{
           RowBox[{"-", 
            FractionBox["\[Pi]", "2"]}], "-", "\[Beta]", "+", 
           RowBox[{"2", " ", "\[Pi]", " ", 
            RowBox[{"C", "[", "1", "]"}]}]}], "\[Alpha]"]}], "||", 
        RowBox[{"x", "\[Equal]", 
         FractionBox[
          RowBox[{
           FractionBox["\[Pi]", "2"], "-", "\[Beta]", "+", 
           RowBox[{"2", " ", "\[Pi]", " ", 
            RowBox[{"C", "[", "1", "]"}]}]}], "\[Alpha]"]}]}], ")"}]}], 
     ")"}]}], ")"}]}]], "Output",
 ImageSize->{447, 82},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->98911571]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28781],

Cell["Integrals:", "ExampleText",
 CellID->20990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Cos", "[", "z", "]"}], "a"], 
   RowBox[{"\[DifferentialD]", "z"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12833],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cos", "[", "z", "]"}], 
     RowBox[{"1", "+", "a"}]], " ", 
    RowBox[{"Hypergeometric2F1", "[", 
     RowBox[{
      FractionBox[
       RowBox[{"1", "+", "a"}], "2"], ",", 
      FractionBox["1", "2"], ",", 
      FractionBox[
       RowBox[{"3", "+", "a"}], "2"], ",", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "z", "]"}], "2"]}], "]"}], " ", 
    RowBox[{"Sin", "[", "z", "]"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "a"}], ")"}], " ", 
    SqrtBox[
     SuperscriptBox[
      RowBox[{"Sin", "[", "z", "]"}], "2"]]}]]}]], "Output",
 ImageSize->{384, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->224519465]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1563],

Cell["Fourier transform:", "ExampleText",
 CellID->21302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->502],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox[
    FractionBox["\[Pi]", "2"]], " ", 
   RowBox[{"DiracDelta", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "s"}], "]"}]}], "+", 
  RowBox[{
   SqrtBox[
    FractionBox["\[Pi]", "2"]], " ", 
   RowBox[{"DiracDelta", "[", 
    RowBox[{"1", "+", "s"}], "]"}]}]}]], "Output",
 ImageSize->{316, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->217261319]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30721],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cos"]], "InlineFormula"],
 " appears in special cases of many mathematical functions: "
}], "ExampleText",
 CellID->24898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", "z"}], "]"}], ",", 
   RowBox[{"MathieuC", "[", 
    RowBox[{"1", ",", "0", ",", "z"}], "]"}], ",", 
   RowBox[{"JacobiCD", "[", 
    RowBox[{"z", ",", "0"}], "]"}], ",", " ", 
   RowBox[{"Hypergeometric0F1", "[", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     RowBox[{"-", "z"}]}], "]"}], ",", 
   RowBox[{"MeijerG", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "0", "}"}], ",", 
       RowBox[{"{", 
        FractionBox["1", "2"], "}"}]}], "}"}], ",", "z"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31447],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     SqrtBox[
      FractionBox["2", "\[Pi]"]], " ", 
     RowBox[{"Cos", "[", "z", "]"}]}], 
    SqrtBox["z"]], ",", 
   RowBox[{"Cos", "[", "z", "]"}], ",", 
   RowBox[{"Cos", "[", "z", "]"}], ",", 
   RowBox[{"Cos", "[", 
    RowBox[{"2", " ", 
     SqrtBox["z"]}], "]"}], ",", 
   FractionBox[
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", 
      SqrtBox["z"]}], "]"}], 
    SqrtBox["\[Pi]"]]}], "}"}]], "Output",
 ImageSize->{368, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->694390237]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28406],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cos"]], "InlineFormula"],
 " is a numeric function:"
}], "ExampleText",
 CellID->2222],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Cos", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8686],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Listable", ",", "NumericFunction", ",", "Protected"}], 
  "}"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->48427803]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", 
  RowBox[{"Cos", "[", 
   RowBox[{"2", "+", "E"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23577],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->873076770]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18683],

Cell["\<\
Machine-precision input is insufficient to give a correct answer:\
\>", "ExampleText",
 CellID->21547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cos", "[", 
  RowBox[{"10.", "^", "30"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13240],

Cell[BoxData["0.6542680511139177`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->564297870]
}, Open  ]],

Cell["With exact input, the answer is correct:", "ExampleText",
 CellID->16464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"10", "^", "30"}], "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31723],

Cell[BoxData[
 RowBox[{"-", "0.99593119440539570239424858799704864115`20."}]], "Output",
 ImageSize->{166, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->135181339]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16653],

Cell[TextData[{
 "A larger setting for ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " can be needed:"
}], "ExampleText",
 CellID->27168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"10", "^", "100"}], "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28130],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \
\\!\\(Cos[\
100000000000000000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000]\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->218553774],

Cell[BoxData["0``0"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39921122]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "200"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"10", "^", "100"}], "]"}], ",", "20"}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->29656],

Cell[BoxData[
 RowBox[{"-", "0.92808190507465534345619464377695592818`20."}]], "Output",
 ImageSize->{166, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->13239703]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13201],

Cell["\<\
Machine-number inputs can give high\[Hyphen]precision results:\
\>", "ExampleText",
 CellID->142],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cos", "[", 
  RowBox[{
   RowBox[{"10.", "^", "3"}], "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21276],

Cell[BoxData["9.8503555700852349694443967612`12.954589770191015*^433"], \
"Output",
 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1219570]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32702],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27033430]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26850],

Cell[TextData[{
 "Continuous functions involving ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Cos",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cos"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " can give discontinuous indefinite integrals:"
}], "ExampleText",
 CellID->19195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", "+", 
     RowBox[{"Cos", "[", "x", "]"}]}]], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5488],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"Tan", "[", 
      FractionBox["x", "2"], "]"}], 
     SqrtBox["3"]], "]"}]}], 
  SqrtBox["3"]]], "Output",
 ImageSize->{112, 58},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26134877]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26101],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WElrFEEUrsxM90wmq/uCS9z3ff8DLoiIB/EgHmIQkoNGNF70ohdF0Ite
9KIHF3A5KIIiKIiCKIiCKIgKEkH0oAiKh4DQfu+9qp6amuq246hhMlOvu+qr
r9776tXr3tDZ171jZ2dfT1dnx5o9nbu7e7r2dqzu3YNL+Qal1FH8rx2t0I7Q
4v9RURSpPLX4T/XSl6KrOVxcxnfPnnly6+Yraq6M79pjlrJ95PC9TRvPPX70
3uoVYxRw9/q1l/v6bj57+mEF3y/im0ByFpoiG/+hb4YAGODx/ftA764bb15/
Vst5RMnp647N2zxCwUAzhlkm8+b19JpBPgNqDcNijG5PIPcy8SQz9qb2ufjn
y5cfXduvEtoSL1pBr9LrOQtNeFe4LU5Es+2gSg8VtIKDtiiOLPU2v8FvOAUW
CulnoUeDld6h6X1g/23qvSBdk3pUke2BgZ+QIC6p+alzNBr7wvln1JybqFiO
UAa/l9k+feoxLoGFmuP1O0enULFVoueb2IYBn0EbanYmFfvxfaprZvvli09Q
HbasmjUIvml+aDFqBm/kFTWzTj+0RTpDaT9M/0s829nGyrdtvUR6mRYrwETb
/nVZDeH5oFFcguA+fvw2JZNKh/E4qBqzQnoQyqRUnQ7n/ugGYWEIBnZU8bTj
n5pbLcyRjAnKIA6nQgITeHRY48Oix8s0Q6vWFMW6YNk5r4Yr48vG5z3d17C5
+Va7xix59S1htCh5Odl2q2O3OB4aYq1SmDY7I9gOHtx/h50BlpT29Bo93sno
tbxBSGHaXsOsrP3Le6AgjGAiYi2Z2Zh95arCnb3N47ecJ6aNjj+HmhkRU3zu
3nnbNChuvlPI5eLazD2IbSHHastZimLmAZx16OAdFC5IIZQ/SjoaorffnWSu
l5pr1lCrJ5tHjVIDcAAT8EFnOt1ctYivTD5otTxifrPsNNOffR6gE/b6ls0X
kXLIB8bPlbnS8sUMxkC+QA4Cb2wJBFk8kZi3+LSiPQTfr1939vixB4iDaCdx
DJ/BIXIq6kgoSTIkpg0zseQqIezv/wqWWCkAAAMwSSgj8N3HWYVxSmhIPzSk
X1RJP1Xx/T9XsI5/P1dlx8hFvUO8V2k0jh1xTEPsOc7JFBCEE0GFHBBghLns
RMebXap2SYuvR4odeFXAXEMQhSQhzFhqcx11VD+xsKKqlCYamJU4yp6TM0cA
pcUOoH08I3XGJounbEWZcap3VClKPt3dDMV+pN0JNoA9eeIh2mqyF7dYows3
++QiK3cFIHjl8nOgwrW0fzvqQLVtOTMgGzgfFQgKggl1IJMpdRKAAAdQQI/L
iGhyoetXqZKwaqxdSuSxg0D0PbmNYQPlBDjiAwGNTo2+OZPcZ7WxZq3QLZIY
gjQyVXvj+S5yKfpT5h6R2psjUcApAV1DqWgMy7QrJrItlS2dxkMT15b0hGUi
wRWxrq1BAo12L1ajg1Gb9VzPya6ADyARKuva6sClDlzz5xFIOW101qufJ2cF
qvqxp/FBo7kOZPKpZCdwhPDgUF0v1M9UcOUpkvJOOTHq9tOUibTkW4zTbz4a
vaNdpckorAJep8xbShxFc/BzOL0X0G8Tipl1mZRxXcQwky/d+ttk2nkOWvDH
aLbtohb+GJXM+Q5aPhOa0Z7rvwUOmlvLJqP50PmNFJ2sUAN0GJn6YlWV8uxc
Sr/8ViyI32vpJ4hVXr1xX3pelrwdYxuFLTUqRjFA+dWPEvfStl/b8nZWNfwC
c6j40g==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{137, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{137., Automatic}},
 CellLabel->"Out[2]=",
 CellID->204122173]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27892],

Cell["\<\
In traditional form parentheses are needed around the argument:\
\>", "ExampleText",
 CellID->18848],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"cos", " ", "x"}], TraditionalForm]], "Input",
 CellLabel->"In[1]:=",
 CellID->6784],

Cell[BoxData[
 RowBox[{"cos", " ", "x"}]], "Output",
 ImageSize->{35, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->717851784]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"cos", "(", "x", ")"}], TraditionalForm]], "Input",
 CellLabel->"In[2]:=",
 CellID->12187],

Cell[BoxData[
 RowBox[{"Cos", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->44781871]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8871],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "+", 
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", "2", "]"}], "x"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"40", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8172],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{202, 126},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{202., Automatic}},
 CellLabel->"Out[1]=",
 CellID->16432956]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24441],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", 
   FractionBox["\[Pi]", 
    SuperscriptBox["2", "12"]], "]"}], "//", "FunctionExpand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17683],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SqrtBox[
   RowBox[{"2", "+", 
    SqrtBox[
     RowBox[{"2", "+", 
      SqrtBox[
       RowBox[{"2", "+", 
        SqrtBox[
         RowBox[{"2", "+", 
          SqrtBox[
           RowBox[{"2", "+", 
            SqrtBox[
             RowBox[{"2", "+", 
              SqrtBox[
               RowBox[{"2", "+", 
                SqrtBox[
                 RowBox[{"2", "+", 
                  SqrtBox[
                   RowBox[{"2", "+", 
                    SqrtBox[
                    RowBox[{"2", "+", 
                    SqrtBox["2"]}]]}]]}]]}]]}]]}]]}]]}]]}]]}]]}]], "Output",
 ImageSize->{421, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->84328358]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"x", "^", "n"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13976],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{
    SqrtBox[
     FractionBox["\[Pi]", "2"]], " ", 
    RowBox[{"FresnelC", "[", 
     RowBox[{
      SqrtBox[
       FractionBox["2", "\[Pi]"]], " ", "x"}], "]"}]}], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"\[ImaginaryI]", " ", 
            SuperscriptBox["x", "3"]}], ")"}], 
          RowBox[{"1", "/", "3"}]], " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{
           FractionBox["1", "3"], ",", 
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", 
            SuperscriptBox["x", "3"]}]}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", 
            SuperscriptBox["x", "3"]}], ")"}], 
          RowBox[{"1", "/", "3"}]], " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{
           FractionBox["1", "3"], ",", 
           RowBox[{"\[ImaginaryI]", " ", 
            SuperscriptBox["x", "3"]}]}], "]"}]}]}], ")"}]}], 
     RowBox[{"6", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox["x", "6"], ")"}], 
       RowBox[{"1", "/", "3"}]]}]]}]}], "}"}]], "Output",
 ImageSize->{382, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->338413482]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18298],

Cell["Chladni figure:", "ExampleText",
 CellID->39],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"4", "x"}], "]"}], 
     RowBox[{"Cos", "[", 
      RowBox[{"3", "y"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"1", "/", "2"}], 
     RowBox[{"Cos", "[", 
      RowBox[{"3", "x"}], "]"}], 
     RowBox[{"Cos", "[", 
      RowBox[{"4", "y"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31283],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->355296240]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19997],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  ButtonBox["Cos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cos"]], "InlineFormula"],
 " at integer points:"
}], "ExampleText",
 CellID->29146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"x", " ", "y"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "20"}], ",", "20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5769],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{135, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{135., Automatic}},
 CellLabel->"Out[1]=",
 CellID->464799536]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5193],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcCos",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcCos"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sec",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sec"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sin"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Degree",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Degree"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigToExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigToExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigExpand"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27038]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13101],

Cell[TextData[ButtonBox["Some Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeMathematicalFunctions"]], "Tutorials",
 CellID->5610],

Cell[TextData[ButtonBox["Elementary Transcendental Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ElementaryTranscendentalFunctions"]], "Tutorials",
 CellID->6450]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->19982],

Cell[TextData[{
 ButtonBox["Demonstrations with Cos",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Cos"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/Cosine.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ElementaryFunctions/Cos/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Cos"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->363471554],

Cell[TextData[ButtonBox["Elementary Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementaryFunctions"]], "MoreAbout",
 CellID->25266056],

Cell[TextData[ButtonBox["Functions for Separable Coordinate Systems",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FunctionsForSeparableCoordinateSystems"]], "MoreAbout",
 CellID->68749941],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->46201968],

Cell[TextData[ButtonBox["Precollege Education",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecollegeEducation"]], "MoreAbout",
 CellID->357845058],

Cell[TextData[ButtonBox["Trigonometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TrigonometricFunctions"]], "MoreAbout",
 CellID->74819347]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Cos - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 35, 20.9566920}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Cos[z] gives the cosine of z. ", 
    "synonyms" -> {"cosin", "cosine", "cosinus"}, "title" -> "Cos", "type" -> 
    "Symbol", "uri" -> "ref/Cos"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6696, 214, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->223867532]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 260038, 6013}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3114, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3737, 94, 41, 1, 70, "ObjectName",
 CellID->29182],
Cell[3781, 97, 528, 18, 70, "Usage",
 CellID->19066]
}, Open  ]],
Cell[CellGroupData[{
Cell[4346, 120, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4824, 137, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4947, 143, 471, 17, 70, "Notes",
 CellID->6388],
Cell[5421, 162, 593, 19, 70, "Notes",
 CellID->9425],
Cell[6017, 183, 237, 8, 70, "Notes",
 CellID->30114149],
Cell[6257, 193, 208, 7, 70, "Notes",
 CellID->31226],
Cell[6468, 202, 191, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6696, 214, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->223867532],
Cell[CellGroupData[{
Cell[7081, 228, 148, 5, 70, "ExampleSection",
 CellID->388993457],
Cell[7232, 235, 72, 1, 70, "ExampleText",
 CellID->20280],
Cell[CellGroupData[{
Cell[7329, 240, 118, 4, 28, "Input",
 CellID->5638],
Cell[7450, 246, 190, 7, 56, "Output",
 CellID->367372996]
}, Open  ]],
Cell[7655, 256, 121, 3, 70, "ExampleDelimiter",
 CellID->17420],
Cell[7779, 261, 260, 9, 70, "ExampleText",
 CellID->4345],
Cell[CellGroupData[{
Cell[8064, 274, 119, 4, 70, "Input",
 CellID->16883],
Cell[8186, 280, 190, 7, 56, "Output",
 CellID->148277102]
}, Open  ]],
Cell[8391, 290, 121, 3, 70, "ExampleDelimiter",
 CellID->24696],
Cell[CellGroupData[{
Cell[8537, 297, 231, 8, 28, "Input",
 CellID->30833],
Cell[8771, 307, 2263, 41, 110, "Output",
 Evaluatable->False,
 CellID->77920477]
}, Open  ]],
Cell[11049, 351, 121, 3, 70, "ExampleDelimiter",
 CellID->22632],
Cell[CellGroupData[{
Cell[11195, 358, 212, 7, 70, "Input",
 CellID->20189],
Cell[11410, 367, 861, 29, 54, "Output",
 CellID->138841666]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12320, 402, 217, 7, 70, "ExampleSection",
 CellID->13817],
Cell[12540, 411, 60, 1, 70, "ExampleText",
 CellID->22129],
Cell[CellGroupData[{
Cell[12625, 416, 96, 3, 70, "Input",
 CellID->6753],
Cell[12724, 421, 176, 5, 36, "Output",
 CellID->370845305]
}, Open  ]],
Cell[12915, 429, 121, 3, 70, "ExampleDelimiter",
 CellID->11211],
Cell[13039, 434, 70, 1, 70, "ExampleText",
 CellID->25429],
Cell[CellGroupData[{
Cell[13134, 439, 119, 4, 70, "Input",
 CellID->2264],
Cell[13256, 445, 269, 8, 36, "Output",
 CellID->163973528]
}, Open  ]],
Cell[13540, 456, 121, 3, 70, "ExampleDelimiter",
 CellID->18613],
Cell[13664, 461, 66, 1, 70, "ExampleText",
 CellID->10600],
Cell[CellGroupData[{
Cell[13755, 466, 174, 6, 70, "Input",
 CellID->8252],
Cell[13932, 474, 235, 7, 36, "Output",
 CellID->549061300]
}, Open  ]],
Cell[14182, 484, 124, 3, 70, "ExampleDelimiter",
 CellID->22403088],
Cell[14309, 489, 109, 3, 70, "ExampleText",
 CellID->19861],
Cell[CellGroupData[{
Cell[14443, 496, 118, 3, 70, "Input",
 CellID->2151],
Cell[14564, 501, 218, 6, 36, "Output",
 CellID->176231896]
}, Open  ]],
Cell[14797, 510, 121, 3, 70, "ExampleDelimiter",
 CellID->28963],
Cell[14921, 515, 208, 7, 70, "ExampleText",
 CellID->7813],
Cell[CellGroupData[{
Cell[15154, 526, 158, 5, 70, "Input",
 CellID->14907],
Cell[15315, 533, 287, 8, 36, "Output",
 CellID->793328532]
}, Open  ]],
Cell[CellGroupData[{
Cell[15639, 546, 571, 17, 70, "Input",
 CellID->31476],
Cell[16213, 565, 389, 14, 36, "Output",
 CellID->280036980]
}, Open  ]],
Cell[16617, 582, 121, 3, 70, "ExampleDelimiter",
 CellID->19531],
Cell[16741, 587, 87, 1, 70, "ExampleText",
 CellID->29942],
Cell[CellGroupData[{
Cell[16853, 592, 119, 4, 70, "Input",
 CellID->10698],
Cell[16975, 598, 262, 10, 51, "Output",
 CellID->223926616]
}, Open  ]],
Cell[17252, 611, 286, 9, 70, "ExampleText",
 CellID->31155],
Cell[CellGroupData[{
Cell[17563, 624, 120, 4, 70, "Input",
 CellID->27587],
Cell[17686, 630, 212, 7, 49, "Output",
 CellID->34238267]
}, Open  ]],
Cell[CellGroupData[{
Cell[17935, 642, 106, 3, 70, "Input",
 CellID->23158],
Cell[18044, 647, 601, 25, 60, "Output",
 CellID->352233115]
}, Open  ]],
Cell[18660, 675, 121, 3, 70, "ExampleDelimiter",
 CellID->13762],
Cell[18784, 680, 89, 3, 70, "ExampleText",
 CellID->8510],
Cell[CellGroupData[{
Cell[18898, 687, 151, 5, 70, "Input",
 CellID->30946],
Cell[19052, 694, 446, 15, 36, "Output",
 CellID->4906821]
}, Open  ]],
Cell[CellGroupData[{
Cell[19535, 714, 101, 3, 70, "Input",
 CellID->8380],
Cell[19639, 719, 209, 7, 36, "Output",
 CellID->23365278]
}, Open  ]],
Cell[19863, 729, 120, 3, 70, "ExampleDelimiter",
 CellID->5946],
Cell[19986, 734, 91, 1, 70, "ExampleText",
 CellID->13540],
Cell[CellGroupData[{
Cell[20102, 739, 187, 6, 70, "Input",
 CellID->27297],
Cell[20292, 747, 391, 14, 49, "Output",
 CellID->912609644]
}, Open  ]],
Cell[20698, 764, 121, 3, 70, "ExampleDelimiter",
 CellID->14464],
Cell[20822, 769, 70, 1, 70, "ExampleText",
 CellID->23194],
Cell[CellGroupData[{
Cell[20917, 774, 184, 6, 70, "Input",
 CellID->12584],
Cell[21104, 782, 375, 12, 36, "Output",
 CellID->269958010]
}, Open  ]],
Cell[21494, 797, 121, 3, 70, "ExampleDelimiter",
 CellID->32715],
Cell[21618, 802, 71, 1, 70, "ExampleText",
 CellID->32200],
Cell[CellGroupData[{
Cell[21714, 807, 130, 4, 70, "Input",
 CellID->1206],
Cell[21847, 813, 394, 13, 55, "Output",
 CellID->95805962]
}, Open  ]],
Cell[22256, 829, 121, 3, 70, "ExampleDelimiter",
 CellID->31302],
Cell[22380, 834, 202, 7, 70, "ExampleText",
 CellID->92683338],
Cell[CellGroupData[{
Cell[22607, 845, 135, 4, 70, "Input",
 CellID->3899757],
Cell[22745, 851, 233, 7, 50, "Output",
 CellID->621586031]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23027, 864, 238, 7, 70, "ExampleSection",
 CellID->8833],
Cell[23268, 873, 207, 7, 70, "ExampleText",
 CellID->7611],
Cell[CellGroupData[{
Cell[23500, 884, 202, 7, 70, "Input",
 CellID->19067],
Cell[23705, 893, 260, 9, 36, "Output",
 CellID->749369744]
}, Open  ]],
Cell[23980, 905, 120, 3, 70, "ExampleDelimiter",
 CellID->6645],
Cell[24103, 910, 80, 1, 70, "ExampleText",
 CellID->30175],
Cell[CellGroupData[{
Cell[24208, 915, 101, 3, 70, "Input",
 CellID->6354],
Cell[24312, 920, 260, 9, 36, "Output",
 CellID->150125626]
}, Open  ]],
Cell[CellGroupData[{
Cell[24609, 934, 109, 3, 70, "Input",
 CellID->24919],
Cell[24721, 939, 170, 5, 36, "Output",
 CellID->658536667]
}, Open  ]],
Cell[24906, 947, 121, 3, 70, "ExampleDelimiter",
 CellID->27988],
Cell[25030, 952, 195, 7, 70, "ExampleText",
 CellID->26321],
Cell[CellGroupData[{
Cell[25250, 963, 324, 11, 70, "Input",
 CellID->7592],
Cell[25577, 976, 598, 21, 54, "Output",
 CellID->109618877]
}, Open  ]],
Cell[26190, 1000, 121, 3, 70, "ExampleDelimiter",
 CellID->22197],
Cell[26314, 1005, 222, 7, 70, "ExampleText",
 CellID->13509],
Cell[CellGroupData[{
Cell[26561, 1016, 573, 20, 70, "Input",
 CellID->8652],
Cell[27137, 1038, 479, 17, 36, "Output",
 CellID->109032441]
}, Open  ]],
Cell[CellGroupData[{
Cell[27653, 1060, 93, 3, 70, "Input",
 CellID->658],
Cell[27749, 1065, 489, 17, 36, "Output",
 CellID->818598134]
}, Open  ]],
Cell[CellGroupData[{
Cell[28275, 1087, 143, 5, 70, "Input",
 CellID->26859],
Cell[28421, 1094, 861, 27, 102, "Output",
 CellID->304271510]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29331, 1127, 223, 7, 70, "ExampleSection",
 CellID->1899],
Cell[29557, 1136, 52, 1, 70, "ExampleText",
 CellID->4120],
Cell[CellGroupData[{
Cell[29634, 1141, 324, 11, 70, "Input",
 CellID->1320],
Cell[29961, 1154, 3575, 63, 70, "Output",
 Evaluatable->False,
 CellID->437768227]
}, Open  ]],
Cell[33551, 1220, 121, 3, 70, "ExampleDelimiter",
 CellID->16984],
Cell[33675, 1225, 55, 1, 70, "ExampleText",
 CellID->4912],
Cell[CellGroupData[{
Cell[33755, 1230, 368, 13, 70, "Input",
 CellID->1915],
Cell[34126, 1245, 5062, 87, 70, "Output",
 Evaluatable->False,
 CellID->11254939]
}, Open  ]],
Cell[39203, 1335, 121, 3, 70, "ExampleDelimiter",
 CellID->19485],
Cell[39327, 1340, 72, 1, 70, "ExampleText",
 CellID->20741],
Cell[CellGroupData[{
Cell[39424, 1345, 458, 15, 70, "Input",
 CellID->10199],
Cell[39885, 1362, 5261, 90, 70, "Output",
 Evaluatable->False,
 CellID->72773718]
}, Open  ]],
Cell[45161, 1455, 120, 3, 70, "ExampleDelimiter",
 CellID->4208],
Cell[45284, 1460, 54, 1, 70, "ExampleText",
 CellID->6844],
Cell[45341, 1463, 585, 19, 70, "Input",
 CellID->30169],
Cell[45929, 1484, 121, 3, 70, "ExampleDelimiter",
 CellID->29681],
Cell[46053, 1489, 76, 1, 70, "ExampleText",
 CellID->4879],
Cell[CellGroupData[{
Cell[46154, 1494, 352, 12, 70, "Input",
 CellID->21108],
Cell[46509, 1508, 543, 18, 36, "Output",
 CellID->637832160]
}, Open  ]],
Cell[47067, 1529, 120, 3, 70, "ExampleDelimiter",
 CellID->5259],
Cell[47190, 1534, 55, 1, 70, "ExampleText",
 CellID->25706],
Cell[CellGroupData[{
Cell[47270, 1539, 116, 3, 70, "Input",
 CellID->58604075],
Cell[47389, 1544, 483, 16, 36, "Output",
 CellID->31826101]
}, Open  ]],
Cell[47887, 1563, 81, 1, 70, "ExampleText",
 CellID->23481099],
Cell[CellGroupData[{
Cell[47993, 1568, 135, 5, 70, "Input",
 CellID->23849],
Cell[48131, 1575, 279, 9, 36, "Output",
 CellID->72098358]
}, Open  ]],
Cell[48425, 1587, 121, 3, 70, "ExampleDelimiter",
 CellID->28026],
Cell[48549, 1592, 53, 1, 70, "ExampleText",
 CellID->20124],
Cell[CellGroupData[{
Cell[48627, 1597, 615, 18, 70, "Input",
 CellID->27607],
Cell[49245, 1617, 15680, 261, 70, "Output",
 Evaluatable->False,
 CellID->123439539]
}, Open  ]],
Cell[64940, 1881, 120, 3, 70, "ExampleDelimiter",
 CellID->2884],
Cell[65063, 1886, 52, 1, 70, "ExampleText",
 CellID->20128],
Cell[CellGroupData[{
Cell[65140, 1891, 880, 26, 70, "Input",
 CellID->24546],
Cell[66023, 1919, 23964, 397, 70, "Output",
 Evaluatable->False,
 CellID->298589536]
}, Open  ]],
Cell[90002, 2319, 121, 3, 70, "ExampleDelimiter",
 CellID->20481],
Cell[90126, 2324, 48, 1, 70, "ExampleText",
 CellID->11714],
Cell[CellGroupData[{
Cell[90199, 2329, 378, 13, 70, "Input",
 CellID->20149],
Cell[90580, 2344, 27982, 463, 70, "Output",
 Evaluatable->False,
 CellID->153087238]
}, Open  ]],
Cell[118577, 2810, 121, 3, 70, "ExampleDelimiter",
 CellID->13338],
Cell[118701, 2815, 71, 1, 70, "ExampleText",
 CellID->20307],
Cell[CellGroupData[{
Cell[118797, 2820, 950, 30, 70, "Input",
 CellID->26793],
Cell[119750, 2852, 42325, 698, 70, "Output",
 Evaluatable->False,
 CellID->359135258]
}, Open  ]],
Cell[162090, 3553, 120, 3, 70, "ExampleDelimiter",
 CellID->1105],
Cell[162213, 3558, 129, 4, 70, "ExampleText",
 CellID->1697],
Cell[CellGroupData[{
Cell[162367, 3566, 494, 17, 70, "Input",
 CellID->407741761],
Cell[162864, 3585, 3498, 61, 70, "Output",
 Evaluatable->False,
 CellID->259563363]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[166411, 3652, 234, 7, 70, "ExampleSection",
 CellID->16641],
Cell[166648, 3661, 137, 4, 70, "ExampleText",
 CellID->2343],
Cell[CellGroupData[{
Cell[166810, 3669, 138, 5, 70, "Input",
 CellID->26133],
Cell[166951, 3676, 187, 6, 36, "Output",
 CellID->250636768]
}, Open  ]],
Cell[CellGroupData[{
Cell[167175, 3687, 216, 8, 70, "Input",
 CellID->679],
Cell[167394, 3697, 266, 9, 36, "Output",
 CellID->74368135]
}, Open  ]],
Cell[CellGroupData[{
Cell[167697, 3711, 117, 4, 70, "Input",
 CellID->1954],
Cell[167817, 3717, 186, 6, 36, "Output",
 CellID->28005712]
}, Open  ]],
Cell[168018, 3726, 121, 3, 70, "ExampleDelimiter",
 CellID->10252],
Cell[168142, 3731, 138, 4, 70, "ExampleText",
 CellID->19904],
Cell[CellGroupData[{
Cell[168305, 3739, 430, 15, 70, "Input",
 CellID->20279],
Cell[168738, 3756, 527, 18, 41, "Output",
 CellID->30896504]
}, Open  ]],
Cell[CellGroupData[{
Cell[169302, 3779, 100, 3, 70, "Input",
 CellID->24870],
Cell[169405, 3784, 157, 5, 36, "Output",
 CellID->11773472]
}, Open  ]],
Cell[CellGroupData[{
Cell[169599, 3794, 877, 32, 70, "Input",
 CellID->26072],
Cell[170479, 3828, 898, 33, 51, "Output",
 CellID->129229844]
}, Open  ]],
Cell[CellGroupData[{
Cell[171414, 3866, 100, 3, 70, "Input",
 CellID->26701],
Cell[171517, 3871, 240, 8, 36, "Output",
 CellID->13527235]
}, Open  ]],
Cell[171772, 3882, 121, 3, 70, "ExampleDelimiter",
 CellID->18086],
Cell[171896, 3887, 69, 1, 70, "ExampleText",
 CellID->4231],
Cell[CellGroupData[{
Cell[171990, 3892, 371, 12, 70, "Input",
 CellID->17480],
Cell[172364, 3906, 397, 13, 36, "Output",
 CellID->48858067]
}, Open  ]],
Cell[CellGroupData[{
Cell[172798, 3924, 106, 3, 70, "Input",
 CellID->30260],
Cell[172907, 3929, 476, 17, 39, "Output",
 CellID->16798595]
}, Open  ]],
Cell[173398, 3949, 120, 3, 70, "ExampleDelimiter",
 CellID->8938],
Cell[173521, 3954, 70, 1, 70, "ExampleText",
 CellID->16657],
Cell[CellGroupData[{
Cell[173616, 3959, 359, 13, 70, "Input",
 CellID->14990],
Cell[173978, 3974, 2888, 51, 70, "Output",
 Evaluatable->False,
 CellID->296643189]
}, Open  ]],
Cell[176881, 4028, 121, 3, 70, "ExampleDelimiter",
 CellID->28981],
Cell[177005, 4033, 92, 1, 70, "ExampleText",
 CellID->15447],
Cell[CellGroupData[{
Cell[177122, 4038, 425, 15, 70, "Input",
 CellID->5242],
Cell[177550, 4055, 226, 7, 36, "Output",
 CellID->426260367]
}, Open  ]],
Cell[177791, 4065, 121, 3, 70, "ExampleDelimiter",
 CellID->16070],
Cell[177915, 4070, 72, 1, 70, "ExampleText",
 CellID->25631],
Cell[CellGroupData[{
Cell[178012, 4075, 248, 9, 70, "Input",
 CellID->24061],
Cell[178263, 4086, 1505, 45, 103, "Output",
 CellID->98911571]
}, Open  ]],
Cell[179783, 4134, 121, 3, 70, "ExampleDelimiter",
 CellID->28781],
Cell[179907, 4139, 49, 1, 70, "ExampleText",
 CellID->20990],
Cell[CellGroupData[{
Cell[179981, 4144, 202, 7, 70, "Input",
 CellID->12833],
Cell[180186, 4153, 784, 27, 70, "Output",
 CellID->224519465]
}, Open  ]],
Cell[180985, 4183, 120, 3, 70, "ExampleDelimiter",
 CellID->1563],
Cell[181108, 4188, 57, 1, 70, "ExampleText",
 CellID->21302],
Cell[CellGroupData[{
Cell[181190, 4193, 170, 5, 70, "Input",
 CellID->502],
Cell[181363, 4200, 454, 17, 60, "Output",
 CellID->217261319]
}, Open  ]],
Cell[181832, 4220, 121, 3, 70, "ExampleDelimiter",
 CellID->30721],
Cell[181956, 4225, 221, 7, 70, "ExampleText",
 CellID->24898],
Cell[CellGroupData[{
Cell[182202, 4236, 807, 28, 70, "Input",
 CellID->31447],
Cell[183012, 4266, 619, 23, 80, "Output",
 CellID->694390237]
}, Open  ]],
Cell[183646, 4292, 121, 3, 70, "ExampleDelimiter",
 CellID->28406],
Cell[183770, 4297, 185, 7, 70, "ExampleText",
 CellID->2222],
Cell[CellGroupData[{
Cell[183980, 4308, 103, 3, 70, "Input",
 CellID->8686],
Cell[184086, 4313, 245, 8, 36, "Output",
 CellID->48427803]
}, Open  ]],
Cell[CellGroupData[{
Cell[184368, 4326, 154, 5, 70, "Input",
 CellID->23577],
Cell[184525, 4333, 161, 5, 36, "Output",
 CellID->873076770]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[184735, 4344, 226, 7, 70, "ExampleSection",
 CellID->18683],
Cell[184964, 4353, 112, 3, 70, "ExampleText",
 CellID->21547],
Cell[CellGroupData[{
Cell[185101, 4360, 121, 4, 70, "Input",
 CellID->13240],
Cell[185225, 4366, 176, 5, 36, "Output",
 CellID->564297870]
}, Open  ]],
Cell[185416, 4374, 79, 1, 70, "ExampleText",
 CellID->16464],
Cell[CellGroupData[{
Cell[185520, 4379, 175, 6, 70, "Input",
 CellID->31723],
Cell[185698, 4387, 219, 6, 36, "Output",
 CellID->135181339]
}, Open  ]],
Cell[185932, 4396, 121, 3, 70, "ExampleDelimiter",
 CellID->16653],
Cell[186056, 4401, 234, 8, 70, "ExampleText",
 CellID->27168],
Cell[CellGroupData[{
Cell[186315, 4413, 176, 6, 70, "Input",
 CellID->28130],
Cell[186494, 4421, 527, 11, 70, "Message",
 CellID->218553774],
Cell[187024, 4434, 160, 5, 36, "Output",
 CellID->39921122]
}, Open  ]],
Cell[CellGroupData[{
Cell[187221, 4444, 308, 11, 70, "Input",
 CellID->29656],
Cell[187532, 4457, 218, 6, 36, "Output",
 CellID->13239703]
}, Open  ]],
Cell[187765, 4466, 121, 3, 70, "ExampleDelimiter",
 CellID->13201],
Cell[187889, 4471, 107, 3, 70, "ExampleText",
 CellID->142],
Cell[CellGroupData[{
Cell[188021, 4478, 139, 5, 70, "Input",
 CellID->21276],
Cell[188163, 4485, 212, 6, 36, "Output",
 CellID->1219570]
}, Open  ]],
Cell[CellGroupData[{
Cell[188412, 4496, 106, 3, 70, "Input",
 CellID->32702],
Cell[188521, 4501, 161, 5, 36, "Output",
 CellID->27033430]
}, Open  ]],
Cell[188697, 4509, 121, 3, 70, "ExampleDelimiter",
 CellID->26850],
Cell[188821, 4514, 295, 10, 70, "ExampleText",
 CellID->19195],
Cell[CellGroupData[{
Cell[189141, 4528, 203, 7, 70, "Input",
 CellID->5488],
Cell[189347, 4537, 343, 13, 79, "Output",
 CellID->26134877]
}, Open  ]],
Cell[CellGroupData[{
Cell[189727, 4555, 200, 7, 70, "Input",
 CellID->26101],
Cell[189930, 4564, 2042, 38, 70, "Output",
 Evaluatable->False,
 CellID->204122173]
}, Open  ]],
Cell[191987, 4605, 121, 3, 70, "ExampleDelimiter",
 CellID->27892],
Cell[192111, 4610, 110, 3, 70, "ExampleText",
 CellID->18848],
Cell[CellGroupData[{
Cell[192246, 4617, 118, 4, 70, "Input",
 CellID->6784],
Cell[192367, 4623, 182, 6, 36, "Output",
 CellID->717851784]
}, Open  ]],
Cell[CellGroupData[{
Cell[192586, 4634, 124, 4, 70, "Input",
 CellID->12187],
Cell[192713, 4640, 186, 6, 36, "Output",
 CellID->44781871]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[192948, 4652, 223, 7, 70, "ExampleSection",
 CellID->8871],
Cell[CellGroupData[{
Cell[193196, 4663, 344, 12, 70, "Input",
 CellID->8172],
Cell[193543, 4677, 10228, 172, 70, "Output",
 Evaluatable->False,
 CellID->16432956]
}, Open  ]],
Cell[203786, 4852, 121, 3, 70, "ExampleDelimiter",
 CellID->24441],
Cell[CellGroupData[{
Cell[203932, 4859, 185, 6, 70, "Input",
 CellID->17683],
Cell[204120, 4867, 770, 28, 104, "Output",
 CellID->84328358]
}, Open  ]],
Cell[204905, 4898, 121, 3, 70, "ExampleDelimiter",
 CellID->22015],
Cell[CellGroupData[{
Cell[205051, 4905, 291, 10, 70, "Input",
 CellID->13976],
Cell[205345, 4917, 1495, 49, 108, "Output",
 CellID->338413482]
}, Open  ]],
Cell[206855, 4969, 121, 3, 70, "ExampleDelimiter",
 CellID->18298],
Cell[206979, 4974, 51, 1, 70, "ExampleText",
 CellID->39],
Cell[CellGroupData[{
Cell[207055, 4979, 613, 22, 70, "Input",
 CellID->31283],
Cell[207671, 5003, 42627, 703, 70, "Output",
 Evaluatable->False,
 CellID->355296240]
}, Open  ]],
Cell[250313, 5709, 121, 3, 70, "ExampleDelimiter",
 CellID->19997],
Cell[250437, 5714, 192, 8, 70, "ExampleText",
 CellID->29146],
Cell[CellGroupData[{
Cell[250654, 5726, 394, 13, 70, "Input",
 CellID->5769],
Cell[251051, 5741, 2844, 51, 70, "Output",
 Evaluatable->False,
 CellID->464799536]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[253956, 5799, 310, 9, 70, "SeeAlsoSection",
 CellID->5193],
Cell[254269, 5810, 1409, 53, 70, "SeeAlso",
 CellID->27038]
}, Open  ]],
Cell[CellGroupData[{
Cell[255715, 5868, 314, 9, 70, "TutorialsSection",
 CellID->13101],
Cell[256032, 5879, 162, 3, 70, "Tutorials",
 CellID->5610],
Cell[256197, 5884, 181, 4, 70, "Tutorials",
 CellID->6450]
}, Open  ]],
Cell[CellGroupData[{
Cell[256415, 5893, 321, 9, 70, "RelatedLinksSection",
 CellID->19982],
Cell[256739, 5904, 346, 11, 70, "RelatedLinks"],
Cell[257088, 5917, 177, 4, 70, "RelatedLinks"],
Cell[257268, 5923, 195, 4, 70, "RelatedLinks"],
Cell[257466, 5929, 381, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[257884, 5947, 319, 9, 70, "MoreAboutSection",
 CellID->363471554],
Cell[258206, 5958, 150, 3, 70, "MoreAbout",
 CellID->25266056],
Cell[258359, 5963, 194, 4, 70, "MoreAbout",
 CellID->68749941],
Cell[258556, 5969, 154, 3, 70, "MoreAbout",
 CellID->46201968],
Cell[258713, 5974, 151, 3, 70, "MoreAbout",
 CellID->357845058],
Cell[258867, 5979, 156, 3, 70, "MoreAbout",
 CellID->74819347]
}, Open  ]],
Cell[259038, 5985, 27, 0, 70, "History"],
Cell[259068, 5987, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

