(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    247102,       5079]
NotebookOptionsPosition[    237912,       4749]
NotebookOutlinePosition[    239164,       4785]
CellTagsIndexPosition[    239077,       4780]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SinhIntegral" :> 
          Documentation`HelpLookup["paclet:ref/SinhIntegral"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"SinhIntegral\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Error and Exponential Integral Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ErrorAndExponentialIntegralFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Error and Exponential Integral Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CoshIntegral", "ObjectName",
 CellID->27669],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CoshIntegral",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CoshIntegral"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the hyperbolic cosine integral ",
     Cell[BoxData[
      FormBox[
       RowBox[{"Chi", "(", "z", ")"}], TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->893]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Chi", "(", "z", ")"}], "=", 
    RowBox[{"\[Gamma]", "+", 
     RowBox[{"log", "(", "z", ")"}], "+", 
     RowBox[{
      SubsuperscriptBox["\[Integral]", "0", "z"], 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"cosh", "(", "t", ")"}], "-", "1"}], ")"}], "/", "t"}], 
       RowBox[{"\[DifferentialD]", "t"}]}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]], "InlineMath"],
 " is Euler\[CloseCurlyQuote]s constant. "
}], "Notes",
 CellID->1014],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CoshIntegral",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CoshIntegral"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " plane running from ",
 Cell[BoxData[
  RowBox[{"-", "\[Infinity]"}]], "InlineFormula"],
 " to ",
 Cell[BoxData["0"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19104],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["CoshIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoshIntegral"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->45234343],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CoshIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoshIntegral"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CoshIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoshIntegral"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->153222897],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->797764109],

Cell["Evaluate numerically:", "ExampleText",
 CellID->14890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoshIntegral", "[", "2.8", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8493],

Cell[BoxData["4.331221215681975`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32199678]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"CoshIntegral", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9314],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->438689084]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"CoshIntegral", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19911],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"EulerGamma", "+", 
     RowBox[{"Log", "[", "x", "]"}]}], ")"}], "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "4"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "96"], "+", 
   FractionBox[
    SuperscriptBox["x", "6"], "4320"], "+", 
   FractionBox[
    SuperscriptBox["x", "8"], "322560"], "+", 
   FractionBox[
    SuperscriptBox["x", "10"], "36288000"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 0, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {EulerGamma + Log[$CellContext`x], 0, 
    Rational[1, 4], 0, 
    Rational[1, 96], 0, 
    Rational[1, 4320], 0, 
    Rational[1, 322560], 0, 
    Rational[1, 36288000]}, 0, 11, 1],
  Editable->False]], "Output",
 ImageSize->{437, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->605260004]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6508],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->9647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CosIntegral", "[", 
  RowBox[{"3.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4982],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.13071648315103368`"}], "-", 
  RowBox[{"0.29526431390959607`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{148, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->321279465]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->111457831],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->25149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"CoshIntegral", "[", "2", "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23088],

Cell[BoxData["2.\
4526669226469145219061326474994928766017806887285094480480946148128`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2262220]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15565528],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->6231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoshIntegral", "[", "2.000000000000000000000000000000000000", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31920],

Cell[BoxData["2.452666922646914521906132647499492876567270899966`35.\
72515480599651"], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->149694353]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19271],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CoshIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoshIntegral"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->12368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoshIntegral", "[", 
  RowBox[{"{", 
   RowBox[{"1.2", ",", "1.5", ",", "1.8"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6421],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.1418419241705944`", ",", "1.6006329333615825`", ",", 
   "2.092577214062032`"}], "}"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->845852105]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24122],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->17723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoshIntegral", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->906],

Cell[BoxData[
 RowBox[{"-", "\[Infinity]"}]], "Output",
 ImageSize->{20, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->139206018]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoshIntegral", "[", 
  RowBox[{"I", " ", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10189],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "2"]], "Output",
 ImageSize->{28, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->969300938]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->846489652],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->204480725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CoshIntegral", "[", "x", "]"}], "//", "TraditionalForm"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->272298317],

Cell[BoxData[
 FormBox[
  RowBox[{"Chi", "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{34, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->411390102]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14651],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CoshIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoshIntegral"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->13406],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoshIntegral", "[", 
  RowBox[{"1", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "9"], "+", 
   SuperscriptBox[
    RowBox[{"O", "[", "x", "]"}], "4"]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4510],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"CoshIntegral", "[", "1", "]"}], "+", 
   RowBox[{
    RowBox[{"Cosh", "[", "1", "]"}], " ", "x"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", 
        RowBox[{"2", " ", "\[ExponentialE]"}]]}], "+", 
      FractionBox[
       RowBox[{"Cosh", "[", "1", "]"}], "2"]}], ")"}], " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", 
        RowBox[{"2", " ", "\[ExponentialE]"}]]}], "+", 
      FractionBox[
       RowBox[{"Cosh", "[", "1", "]"}], "9"], "+", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"3", " ", 
           RowBox[{"Cosh", "[", "1", "]"}]}], "2"], "-", 
         RowBox[{"Sinh", "[", "1", "]"}]}], ")"}]}]}], ")"}], " ", 
    SuperscriptBox["x", "3"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    CoshIntegral[1], 
    Cosh[1], Rational[-1, 2]/E + Rational[1, 2] Cosh[1], Rational[-1, 2]/E + 
    Rational[1, 9] Cosh[1] + 
    Rational[1, 3] (Rational[3, 2] Cosh[1] - Sinh[1])}, 0, 4, 1],
  Editable->False]], "Output",
 ImageSize->{347, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->689846630]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30345],

Cell["Find asymptotic series expansion at infinity:", "ExampleText",
 CellID->12351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"CoshIntegral", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6923],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cosh", "[", "x", "]"}], " ", 
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "x"], ")"}], "2"], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         FractionBox["1", "x"], "]"}], "4"],
       SeriesData[$CellContext`x, 
        DirectedInfinity[1], {}, 2, 4, 1],
       Editable->False]}],
     SeriesData[$CellContext`x, 
      DirectedInfinity[1], {1}, 2, 4, 1],
     Editable->False], ")"}]}], "+", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "2"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        FractionBox["1", "x"], "]"}], "4"],
      SeriesData[$CellContext`x, 
       DirectedInfinity[1], {}, 0, 4, 1],
      Editable->False]}],
    SeriesData[$CellContext`x, 
     DirectedInfinity[1], {Complex[0, 
        Rational[-1, 2]] Pi}, 0, 4, 1],
    Editable->False], ")"}], "+", 
  RowBox[{
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      FractionBox["1", "x"], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["1", "x"], ")"}], "3"]}], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         FractionBox["1", "x"], "]"}], "4"],
       SeriesData[$CellContext`x, 
        DirectedInfinity[1], {}, 1, 4, 1],
       Editable->False]}],
     SeriesData[$CellContext`x, 
      DirectedInfinity[1], {1, 0, 2}, 1, 4, 1],
     Editable->False], ")"}], " ", 
   RowBox[{"Sinh", "[", "x", "]"}]}]}]], "Output",
 ImageSize->{452, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->803589]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27844],

Cell["Plot the imaginary part in the complex plane:", "ExampleText",
 CellID->24743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"CoshIntegral", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7741],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->778087178]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19785],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify expressions containing the hyperbolic cosine integral:"
}], "ExampleText",
 CellID->9227],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"CoshIntegral", "[", "z", "]"}], "-", 
   RowBox[{
    FractionBox[
     SuperscriptBox["z", "2"], "4"], 
    RowBox[{"HypergeometricPFQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2", ",", 
        FractionBox["3", "2"]}], "}"}], ",", 
      FractionBox[
       SuperscriptBox["z", "2"], "4"]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8624],

Cell[BoxData[
 RowBox[{"EulerGamma", "+", 
  RowBox[{"Log", "[", "z", "]"}]}]], "Output",
 ImageSize->{129, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5948405]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to express ",
 Cell[BoxData[
  ButtonBox["CoshIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoshIntegral"]], "InlineFormula"],
 " through other functions:"
}], "ExampleText",
 CellID->363387086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{
   RowBox[{"CoshIntegral", "[", "z", "]"}], "-", 
   RowBox[{"CoshIntegral", "[", 
    RowBox[{"-", "z"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->152250703],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Log", "[", 
    RowBox[{"-", "z"}], "]"}]}], "+", 
  RowBox[{"Log", "[", "z", "]"}]}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->183947134]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6227],

Cell["Find a numerical root:", "ExampleText",
 CellID->555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"CoshIntegral", "[", "z", "]"}], "\[Equal]", "Pi"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10102],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", "2.3364597045939886`"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90926008]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19468],

Cell[TextData[{
 "Obtain ",
 Cell[BoxData[
  ButtonBox["CoshIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoshIntegral"]], "InlineFormula"],
 " from integrals, sums:"
}], "ExampleText",
 CellID->11698],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"Cosh", "[", "t", "]"}], "-", "1"}], "t"], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8979],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "EulerGamma"}], "+", 
  RowBox[{"CoshIntegral", "[", "z", "]"}], "-", 
  RowBox[{"Log", "[", "z", "]"}]}]], "Output",
 ImageSize->{254, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31784577]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"k", "=", "1"}], "\[Infinity]"], 
  FractionBox[
   RowBox[{" ", 
    SuperscriptBox["z", 
     RowBox[{"2", " ", "k"}]]}], 
   RowBox[{"k", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", " ", "k"}], ")"}], "!"}]}]]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12489],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", 
  RowBox[{"(", 
   RowBox[{"EulerGamma", "-", 
    RowBox[{"CoshIntegral", "[", "z", "]"}], "+", 
    RowBox[{"Log", "[", "z", "]"}]}], ")"}]}]], "Output",
 ImageSize->{278, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->462914808]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13490],

Cell["Integrals:", "ExampleText",
 CellID->30775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"CoshIntegral", "[", 
    SuperscriptBox["z", "a"], "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28410],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "z", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"CoshIntegral", "[", 
      SuperscriptBox["z", "a"], "]"}]}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", 
        SuperscriptBox["z", "a"]}], ")"}], 
      RowBox[{
       RowBox[{"-", "1"}], "/", "a"}]], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{
       FractionBox["1", "a"], ",", 
       RowBox[{"-", 
        SuperscriptBox["z", "a"]}]}], "]"}]}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox["z", "a"], ")"}], 
      RowBox[{
       RowBox[{"-", "1"}], "/", "a"}]], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{
       FractionBox["1", "a"], ",", 
       SuperscriptBox["z", "a"]}], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{471, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->640158681]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27089],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CoshIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoshIntegral"]], "InlineFormula"],
 " can take large values for moderate\[Hyphen]size arguments:"
}], "ExampleText",
 CellID->27296],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoshIntegral", "[", 
  RowBox[{"10.", "^", "6"}], " ", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11950],

Cell[BoxData["1.5166092150115172880848626851023322`15.954589770191005*^\
434288"], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->568169198]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20122],

Cell[TextData[{
 "A larger setting for ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " can be needed:"
}], "ExampleText",
 CellID->12529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"CoshIntegral", "[", 
     RowBox[{"I", " ", 
      RowBox[{"10", "^", "60"}]}], " ", "]"}], "-", 
    RowBox[{
     RowBox[{"Pi", "/", "2"}], " ", "I"}]}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7672],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(\\(\\(-\\(\\(\\(\[ImaginaryI]\\\\ \[Pi]\\)\\/2\
\\)\\)\\)\\) + \
\\(\\(CoshIntegral[\\(\\(\
1000000000000000000000000000000000000000000000000000000000000\\\\ \
\[ImaginaryI]\\)\\)]\\)\\)\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->242881962],

Cell[BoxData[
 RowBox[{"8.3038976521934266466406179`10.474314166381525*^-61", "+", 
  RowBox[{"0``9.170776042835692", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{201, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->536849233]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "150"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"CoshIntegral", "[", 
       RowBox[{"I", " ", 
        RowBox[{"10", "^", "60"}]}], " ", "]"}], "-", 
      RowBox[{
       RowBox[{"Pi", "/", "2"}], " ", "I"}]}], ",", "20"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5553],

Cell[BoxData[
 RowBox[{"8.30389765219342664664061785421328757`20.150514997831998*^-61", "+",
   
  RowBox[{"0``80.23123301009274", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{271, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->470323217]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1056],

Cell["Nested integrals:", "ExampleText",
 CellID->12826],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Integrate", "[", 
      RowBox[{"#", ",", "x"}], "]"}], "&"}], ",", 
    RowBox[{"CoshIntegral", "[", " ", "x", "]"}], ",", "4"}], "]"}], 
  " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12902],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"CoshIntegral", "[", "x", "]"}], ",", 
   RowBox[{
    RowBox[{"x", " ", 
     RowBox[{"CoshIntegral", "[", "x", "]"}]}], "-", 
    RowBox[{"Sinh", "[", "x", "]"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"Cosh", "[", "x", "]"}], "2"]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox["x", "2"], " ", 
     RowBox[{"CoshIntegral", "[", "x", "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", "x", " ", 
     RowBox[{"Sinh", "[", "x", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "6"]}], " ", "x", " ", 
     RowBox[{"Cosh", "[", "x", "]"}]}], "+", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     SuperscriptBox["x", "3"], " ", 
     RowBox[{"CoshIntegral", "[", "x", "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", 
       SuperscriptBox["x", "2"]}], ")"}], " ", 
     RowBox[{"Sinh", "[", "x", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"Cosh", "[", "x", "]"}], "6"]}], "-", 
    RowBox[{
     FractionBox["1", "24"], " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", 
       SuperscriptBox["x", "2"]}], ")"}], " ", 
     RowBox[{"Cosh", "[", "x", "]"}]}], "+", 
    RowBox[{
     FractionBox["1", "24"], " ", 
     SuperscriptBox["x", "4"], " ", 
     RowBox[{"CoshIntegral", "[", "x", "]"}]}], "+", 
    RowBox[{
     FractionBox["1", "6"], " ", "x", " ", 
     RowBox[{"Sinh", "[", "x", "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "24"], " ", "x", " ", 
     RowBox[{"(", 
      RowBox[{"6", "+", 
       SuperscriptBox["x", "2"]}], ")"}], " ", 
     RowBox[{"Sinh", "[", "x", "]"}]}]}]}], "}"}]], "Output",
 ImageSize->{527, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->47356080]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14578],

Cell["\<\
Plot the logarithm of the absolute value in the complex plane:\
\>", "ExampleText",
 CellID->4949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"Abs", "[", 
     RowBox[{"CoshIntegral", "[", 
      RowBox[{"x", "+", 
       RowBox[{"I", " ", "y"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", " ", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21705],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyEnQm4zsX7/8/COZyFs+/7QRJRStl6xpotRURUVJJEWVooa1pERUKyREVa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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlkts1FUUxu9AH0Nn2kznX2amakp0qy5MFERbSSPFjSHBGNT4SgBfWFsg
sLDFhZi09VldNdGFNmqEpFiVAi4ERY2tiRW0DyyCfaokanSpUYnfr9+duLi5
d87/vO53vnPuXLmt846OFSGEM1ortZ7Ih/B+EsJYRQjNq0K4TOtjnbsl/0jy
4aoQHilYD50zDSGc1nq7OoQW9LMhbK8MYYd0HirY/lrpzWpVKtBX2vco0IWU
ZfhDnm0M4Uv5GZSfYe375P+svq+X/EatttoQfsqFMJLYdinGOZ3y/laVzztl
N5T4d0OlY+N/j+wXakKY1u/PM86Vey3WWL55pXd+c5ffFOuQ/Pwun2fxp3VR
5/mog36X7H/VeYfOTdr/rfHdvlH+e/OOdVR2HXnfu6SYqSrntEHYtGj9lQ5h
l3S2aV0l/z8q7jXFEPLydV/ib8j5ncRY38p/W9H4kNcvOef2gvw9r7VBcdpr
vXdWOvaamNvP0j0WMWxX7BnJb5L8pORbJd8ieVfEDtzurAvhz7R/vyOdx+U/
lfI9qB93OZxzruTZusoYgc+TwnGuxvoHpXNP4vOEzn8Lk3/k81SFd2oB/nPR
lvyHss7tD/m8JHlP2rrNsXZv1poHnJ9OG5uJlO2w74z+0YEb+N5d6xxeK4Xw
qtZ34sKH4tdxraN1/g5XpmM+nLG7PGtOwbUyvuTWKx+Tus8X8vOe7reYcw7o
DlQ7LjjAa7g0odpNah2sNvfZwXl/vXsAPfIl7zI/5yMnyQNf4IMO9ycfuMwZ
fWpLn1Bf+EGO1HREeC8o113Sn1b8Ka1D1eYwuFG7OX2f17pCvi9JfzbnOl9X
dB+2RU7xHWyP6fs6yTdKPqy4S/Hu49qvbzQX4Bc25PGcuHMkb1twwgZ9ckKX
e8HxsZjTDfKxNvqflO4AM0f5PFzwfGG2bJbsAX3rqzB/T+R838cK5vSW6B/f
4J/XXW5rNKfgEz3RnDI34TfcKHMX/a5qn5HTQ02xj/ZJf29i27Xyua7obx+o
jqOrQziQ9gyjV6kD/UMf0S83K7fmgn+PS7dZtr1p87Y7bayYGY8W3LvMiVvi
rPg64zyQj8n2iOI9I/km+Rha7Z5+QzFfb3DuPSVzFH6iR5+AOXH2p43PeX2/
UPLsps/IBWxa5PMz+XwqbV8Ppo0FPXMu4/5nVl0d5xU1wz9cYv4NNriPkB2I
8vsTYwducGE6MR8+VZydBedE341kbQuuF3PGFtlC7IXRzP/zg1yG4zzqr7KM
vuuR76a859l2nTflzXfuMRjrOiB5a952dwmDu7X6M+Yd/IZ79BY9Rq/dK3lH
znOR2bA7zodbi5775My7cT6+HbxprUXHoz6HY434fi7qgBucpy5bS+Y0fOY9
IRfOcKg9coOaDNe7Lt2RN8z/TxTrVIPnzrv1xhQ84U0pvsMzGdcPrOiDE/Xu
hfaCeUOdidsX3+n1RfMM7jAfee/A8GS9uQtX4PuKomv8ivJ/uWSeolvmBb1y
POe6TynutNZUnWvDTn8wM14seBasyXqnd4fivOGO9H9/fOuX51f8//Cs7PoK
rhP/RzYWzRNmBO89s7Hc88s5JH7Xl31m3B/w5vvEs5K43B8c0F/SnRZLzisp
eo7gby7ntwRMmZUzEVtsicUcLteJWNSvO/YdMUdjXLh5e8nYYtcbbZmH4xnz
4yW4WfLvWe0/lPwugcdY9PMf+Md1Bw==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllEtI1HEQx2fFx+qW7O5/2/2vhVLX6NCh95osqacuSVQQFbj0MtG6mh0q
MO1lXRKiCKnAHmYPxbCMBLENeoHu5qNNLSOhoi5BUUmfYQ4Dv/nN/L4z33n8
FlfXV9VliUgVko1cdkUOB0W6ckXGfSL3HJG7yLBHJInDH2w3kVi+yN8ckaUR
kVG/iFMgEiyw81kwXvrsbhY9ic8/zsXIJPol7GPYPcSIY/vG3Xfw2/NEHmus
kEhHnuVwICxSizSge/AZWCByJyDS6CVPr2FN8X7UZ5gx8D6jZ/A9gT1Ori34
JLG1gncGrD7wp8klDod2zpVRkUPzRdLw+4DvDFIyT+Qg/LLA6wRvCXjHwCtH
D+Lfjf06OWWwrYwYt5ICs22IGJb6ZMCaQBJgFaH3k/tz7HP4/iD+T2zbebO5
UCSEzznXMBXrFTlPo58k53psi3h/0bUeaW+U8ylsU67ZysDrA/uT33rxFXmP
rYYaXIP7QnxG4PuIGudkWY2/4FvKmyNwm4XjR+2d32qjNajjvI4Yv7yWYzVv
E0hDttWkV3sfMS4x9H34nnct9xf4pPFNOYatHGbwX4P/ca/NVBu5tTnWm2Su
9aLDb73WnnRj63EMS3vaSf9vIWNwqwWjN2qclWsP+a0n/n4wXfL5jX03egIZ
JJ8i7mrUjmzy2Ayt4v1y3lcQqxzZSO4Po4alHNfiWxY2rGXo/eTWRQ3fZhtG
BW8rI5aL3l3BdpX8dnltZlPoTVovuN1AXw32iqjF0pjj2CYcmzXdgWbiD/tt
t56R84jf7vQ85DPup8PWa62BznaTazadcd21reitPtu5AeJfAP+11pr4xdQm
RfxUoeWUjtoM6uzpXSxsnJWr9lx35U3IZl13RmvZgpTmW011ltIh46YzpbP9
JGC7pzPeCvbesP0d+ic8wDYEh6NemwGtVWPAdl9rpr2bC9rfoD3sCtjO667r
jO4k3g7HZq0ZzGaw37m2W5qTch1xbJaU823OT0PGXXdgG75bXHurNdLdnHRt
N3RH9W/bE7ZZ0T9Oc70fsN3XnP8DTa/NWw==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.45152812593710356`, 0.3323186864529984, 0.7516577203043383], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgeU1EW2xntSjzM9PXRPz3QAZTGuiTXsqgQXUVcFd1UwvsOgIhjIrAiI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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwlmHeclcUVhj/Y5haW27j3fmABLIkKJqCANDui2MAYLHRQQBCUqlgi0YiC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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5378728785044736, 0.4824488924718707, 0.873025715422364], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnXecVEXWhm/P0BO6Z3qmu2emu1l3zaKua8Q1IAZAQcSEKCgKAmtA14iu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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmneAFVWyxhsmwL0zzNwwc/s2T9ccMcuaeK5ZMaGAigkBURGQjKIEQQFR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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6082264618179364, 0.5989128706611486, 0.9105110521019263], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3e8VcW1x/et3HtPu+ecexrGhr0bFCSaqIkaNUZjL8SKoIIFEEEpggqo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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXecleXRhl84u8vunmVP2z1lY6KigNJEihg1YBIsqFEDNlARCMonQfjo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         "],
         VertexColors->None], 
        PolygonBox[{{6680, 6682, 3889, 6684, 6679}, {4183, 6691, 3911, 4153, 
         3939}, {6691, 4188, 4187, 6693, 3911}, {4229, 4183, 3939, 4152, 
         1843}},
         VertexColors->None]}]}, 
     {RGBColor[0.6717098344303467, 0.7009129860129772, 0.9119582774660293], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmnm41mWZx3+cjfes73be7YCigAkEEbGqQJlAlxiIrImaiiNUFyozo4gL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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmAlw1dUVxv+EvJcXEpK8Ne8FiqwCEaRA2AOIAh20gLIYjCAFy1InAm0R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         "],
         VertexColors->None], 
        PolygonBox[{{5895, 6706, 4122, 4036, 3903}, {6705, 6708, 3962, 1649, 
         2564}, {5603, 6698, 3922, 4154, 3970}},
         VertexColors->None]}]}, 
     {RGBColor[0.7351932070427569, 0.8029131013648058, 0.9134055028301322], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXuQ1WUZx3/u5Vx298g5nPM7u8v9jtxEBCXHG2aoCAU5hWBBM83oOKlo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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3uQ1WUZx192lz17WOScs7/f75yzCywQLLILCKsCGQpryC22WBlviNJM
adMMCuYlZIzEYkYgu8hFWWTKMArCBLYyQfEPrZkyCqdxShFMxdVwl2VthF0u
K32+ffnjmfM+57m/z+39jfjasgVLS0IIJ4AyIF8TwlDgikwIY4EZ+RByxRCu
rwzhs4oQxsQhXAoMS4UwHPhPFMJGeGanOZcjz7m8KoS+0hAi+Acn6MmF8DuM
HOW/o9DeAX7LeSP/LagO4VZ4VmP7wCUhnOI8BJ2N4HuRXwjejPwb8A7EwVJs
lwEpbG/lv1nQbgRvAo/hfydnn+TLM+ApbM1LTHsDGArtE/BndYZnWTaEVvBb
wLcQwx7wvxJvemAIXf1D+AfytZF5jwFLoP8Q/q/Avwn+IucCMB9/2/HhGPb/
jcxhZH8FzwloJwoh1HN/Oyps+yT+/illH9Zz3gDcBd5DPNugPw20DQhhMfTz
nPsS627CxmT0fwH+seBngQ5onei/FP3b4W/g/scCTZw3wF8DvRqYE5yzafhf
JJ4aYjkOvAzvzei7Ftoq4jkJbxf6GtC3Cx0r4J8HLIKWgacfsV0NTwrawQr7
el3etSGfl8M7F7gh7Rxdhe5J+HwmZZ83qZ6wT/r/XzNjOD/Pf/dzrsOfKzkX
sTGCXDeAfx9fGpE/hewa9I/kXILNQyjYwX3NRv81/FeO/cnw3AA+M+faU00M
j5xD5a4W+Cnn94Ej5Ocg+I/Q9SgyJ0uc0174h0A/xfkc9JXQHgYWo+sjeHo4
dye+m4fwp4HzBey9VmEfX0X2Y6Ad/W+pZuDfSkzzie8B+C9H/2rgQWjjgTnQ
pyNfcdH/dcS7CJ0jwFsHuLZnQ08uxqPcTwE/d/E+K7G1GP466IeBqfRuDz31
30HUf8axrQHuTDnGTs5diWtxBfovS5xT5VI6j0PvTFxLy6F/HXw+9kaBz4M+
FdoLxLM87Tv/VPWcc6/uAT4HbSRweYV7+kzkO9VdngfupjYmg0/g3Ad8Gdm1
Bcf6FjIt4HfEtqWYXse3KyLf1XtAC7Gl6M889rcwL65J3OPqbd2hZsvxyLWt
GXMv9qaDTwHfisws8BrwweBdQDm2+wOPUu/t0EdCWwksgTYC2Ikvi9D5C+iP
4NPrxHYI2A7vL4HunO9AsbcBX4T2BPhNnPuArZw3A78hvoXgtyfuOfWa7rQ9
do2oNg6kXHvHgQ/6uwbPxK451drfoH8e2Qzxz8ef09CbE9eAcq8aycCbjd2r
z5DvddB+D/9Y7AV0Tsu55lRr6uEtiWeQZo9mYCOxn42cq22IdMSuCdXCK8h0
x64h1Y5mWBJ55mrWFpBpAh+DzbK077wJf7PYb8Hfs/BMidwj6g3VwEzodeD9
5B9wPbrq+O89eEcD9+DfQv57F/9yzITx4Huh3532TCnlvLrg2fApeJR13av+
6/htxd7urHO3AXsr4H8Me734Mx4dm6FPzXn2rFe/w3sQnp+lPTPnxp4xuq8p
wIfIbtHOUz1ynwewMRSZfgO8L9uBtUAp+Db8HQOtNmuaduo3Od9a7dp5SjMZ
vAS4gL/joG/OumZVq9oJsjUD/0aX26Z2yQexa0U7RbM/jnz32gH98S/J21ft
4C9VuWfUK6vwp8B5SN69ph4qRb4MeJ/zROL5Afxvo3838uP47xb4bwb2l3qG
fQvavUCxzDlRb9QWHL96ZDm6vwG9OeWauxHflyTe3Ufhvw3+7irv1u3wP47s
EfDHoe1Bx2jkR+Wda9VAe5VzpNy8i8xr1FJrlX3VzFVvXZt3banHOiLvYO3e
DmTWQG+E3gm+E/oD3O11QEvaO/ok/N2Re/1tYtwE/1V599Yu+GuZp9NrnEfl
b0PWM0yzSz26ifM9wGflnvn3YfvHxPQcsruBUvSNynlXvYn+Cs2rxLv8X9zR
AM5Dua9noR8G/zXx7QI+rPQOVC4ezLtWlZNh4MNjv6Uko139ceze1M6eGnvn
ajeMA+Zh+0XkV6b9htLumRB5t2oHleTdQ+odvWHUGz8p2Hf1SHXknaldqTdD
V+w3mN5ef0Tmptg7V7tJb4hvZz1jNVu1Y58nlheA0+gqBe+LPaM0mw6l/Nba
m/Xs1ZurHn/jxHe1F57vcF7Mf+2ca7mPVnirkFmAvr8H987Pycv+Qe6hl4jl
oyr35nelk3M5/DMrfQcTwR+LPAub0XeXZnXOtZkHn4G+zsi1Q8uE4QXXrGpV
Pf1c1jNFs0Q9cwn2JiK/D/m/UDP10CZRL0cy7lm9ndKJc6s31J2xd6r2m3pE
u/Tq2LnSTh0ceadol2hH6S11PvZd6U1VQyzVRdeqZpRq+UTsXKime+nV3dXu
Fc3AdYl7QLXfjM4nE9e4als7Sruskfhuq/ROWwZtaeK3o3b4QOh9Ocf2Z2BS
5J2sXXwZ8Ai8qxLvCr059xedc+W6B50JtIacc3kMn89FnjGaLeqZ70H/as5v
K82Uemhz8377TivzLh4W+e2mnay3gXbE6Ivvkds5P5Q4d6qRYQV/w2jeaiZp
V9TH/lbRztCu2Ve0b9o5bRnvDO2KcmCOvmWAN1Vb0J/mv3TWtH2DvNtm5U3T
jvsE+6cT72a9Sddn/Y2gbwO9GQdhK6ly7WoG/RM9dwAPl7k+ejO2Id2q4Zai
Z7Zmtd4kPejuTTwr9E2kXfNyxrtC8ektsDZxbvUmGFXlnapdqh5R7asn1Avq
Ae3iKyPnTjtZs+r+nGevZtaQontEvaGaaMv7m0PfGkvTfqurJlQLerOP427H
Ax2l/sZTbPdlvPsU4wRk6xPnXj2yE/07it59mnH6tnwq8dtI35gX8CcUbUs6
I3zN5fyt2Ab+h6LfWHpbaaboraxvSH076s28MetvOn3L6c37P/my918=
         "],
         VertexColors->None], PolygonBox[{{6705, 5921, 2563, 3976, 4070}},
         VertexColors->None]}]}, 
     {RGBColor[0.7950023769823064, 0.8577929916577138, 0.8995286521209739], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuMVdUVxo8zA/feGWDm3DnnzowyCJbHUB9ALW/GgeFdwCpoI1agaaRt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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlsVkUUhidt5X6l0Ha+3vu1ILssRVBAlB0qO4gKAhpBFjVgDCCbMSyi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         "],
         VertexColors->None], 
        PolygonBox[{{6650, 6676, 3881, 4120, 4012}, {4905, 4419, 715, 4050, 
         3958}, {6648, 6647, 4089, 4087, 3755}},
         VertexColors->None]}]}, 
     {RGBColor[0.8520147542725122, 0.8768051003354077, 0.8739871581856131], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuMVdUVxg/MDPde5w4zZ+ace+8goNCqNNqCgjKMVhlsEY06iDOggEJ9
wIgBH6RiTaoChZr6Lo2AZrRNH6ZaH206hdYEaJuKYkyAaWKIbWEa02rVGp/U
gtDvx7dM/9h377v22muvvfda31rrjLvmpjkrhidJ8tqwJKlTf3w1SXa0JMnh
UpJsyZLkN2r3F5JkoEnjYpL8VePfjkiSnWqFhiTZ3eD/jAfE+2u1+8SzXUKP
qO+TzLGinZQmyTOi/aktSV5s85qu+iS5W/109VuQr3ZeOUnaRFsd9HMk93GN
N2n8psb9MZ6i/ttqr0p+u/o+tZEa/1N7VbTXdu39itrERjXRLxTtHp1tt3Q4
oZIki/Mk+ZLOc7no94q+T/QJoq8UfVrRfDX1d2ntp6J9td3nf02X9LzmzhV9
p/pG0W5OrPff6nzGonQoqJW0/zop9R+1iRrvFc9j0p37btdel+beY7Zo66R/
t/r3WpPkKd3/uzrrxervaPFez4qvtRBn0XiRxj9M/A7wcv/MDwZPd9wR97O4
YP7nEus+qmCZe9S3qJ2mcVX6tqs9qfmr9Pap6GeLfrtod6i9Ifpl0uUutUtE
nyzZ60Nn7o67fCDx23SIvkvjVbrbrjb/P1z0mm2ivy5d79d4uXhPlezTxDcw
3O1t7XuleG4V7Zw2n+Fm8czX/yHNZ+qrbX7zqbrPXL1Ix+Z4t36NW0RobfMc
e7R/bhsjbFvc//mSmY1KkkOaaNFbnJf7Lbu09rtVv+0c/d9c8r2tEP8fxZdL
Xrf23Sj6L0S/QDyPaDwz+k1q72s8S+2hkt9oiWQv0r2t0XiR5GyXnEbsQG1Q
+6wU/eviOUv6HGhOkp9pvi23rd2u/jqtfVg8v5IN/lLtWem8WjquUbvzOPlr
k/dl/7PE3yv+heKfLx0eE+2FxPpuCp2xtU813lBvPf4y3Lpt17r2qudOlp5P
S4+/S4fN0mlTs215lfzp55K7Quu+mNsmsIcejee3+CyztfZ3FZ/vTI0HNH5P
ck5vtG0NaP1l4i/W7F/Xcvc1288Y8ZblA8V6N/wQHvTYOtx7ZeLN1Xolb6hs
vHlUvCNKpoErr2p8i8Z9Gr9TZ9vCrg7WGZvApaN1fmf8t6R9J+XGrKPqx+a2
RfT+w3DfJ/7PfYOBg2XjIv68V/0ZjfYXfGJK+EVZMg7pPi9KjB+npJYxWfS6
mnWYoXF9zTpUpUOx1XoVND6cWveR3GWrdR8n/mE1n+WpkX4T9PtM531MOmyu
N17S44u92vcfeoNt0vE2rW2q2Ud26n9RbUxinCoGDixVv6Rgm+kteQ76Ksm4
Te0K/f9X0RiEba/HPlP/J2awN5h9tOgeHLhP6+7NLPta8a7L7R9rRVuTGZ/A
r1Mb7K8nNNmW8a0+8T+MnQXmzYp9J+pOMt3J2+F3+Bw+uFw8C4ve992Qiew7
2Uey3tRdnS7+slqtwTIvKtrH+wr2ecaPa8+bxL8AfFf/RG65YMpPisacG/Xz
A9F7in5/3hYbuEb07+TWf7T6j1PHhnfQt9VxbHfoBS6dpbN8I3TbKD0fUVsR
78C5Xwj8f65ofF4i3gclt7vo+MYcmI9P4pu86Vi98xi1qxqNV5eWzU8cHwg9
PyL+xXmHFazXvsRx5NnY62PpMlr77RLtQ2JV0RiCXR/Jbds3aP77ue+uLP5G
Gn6k/oTUceZQ0XfJWR4S79LUsi4rOR6g8wbRl6XWiXec/zm/5DyodoNoI3SO
vSW/a0/Zd09MyTTfljlu7VB7SvQTRX9J42eKtuEPiHGpbf8B6X+/2pPy5+vB
/Nx20F7vWIKPnK0YckvquEWeApZMD7zsLhgzz5DMKZmxCZx+ILCa++Z8vOGN
ml+eeR3YvDbwGWxeGr6G/70UvlbTnu+L/0XsUTwNBZ+Ft90ZPjtKPB9mXnOJ
+ovVOjWerv68zPkGvjov8gQwAhr7zi35fbAZ4tviyA3SyAewDeaPC55dMUYH
znlSwThMfLsi5JMfsBdnX6j9r84c275A7pc57+hSPyOzLsx9reB4QWz8XsRH
7uHFOOMC4n5mPvZ/OXTAPvpC5/p4b+jYAzbCXK/G1ZL/Tys7H4S3IXr4q/hc
5vUV9Xlm2+8sew2Yia+zFn8nnoD52EGeGlvhAXeJQWBuf8m+C/4sCDvmfaEt
D/qJCMsdN7DNPfHu3P3euP/jxfNR5jNjy7tC57GiHxF9d9zJK/FGy/CPzHY5
Xv24zHne6eonZX6zcVo7LHeOyF67Y98xon+SWdYKjftz+15r5HbE5Wmir686
dh7DkrJxgDvmrrfF/ffGG5BbzC07Dp6cugYgN8aX5n7OX/Qa3gv9tkacZX5e
8BCP+8uOd+wFHdns0xM8xOrxEa+/nDqnHIg89/nIGXizPWX7L7hGbkUOTM5y
T+QtxOTmiuMycQg8xQ7fKjrmYefE5DG54zJ54vTUOQSxhxgEhj9edqxGDjnX
xohP88Im0RlfeStk3iJ5La2+b2qUWanzHvKCWsW5AXgH7qETOSxnIY+l3xtj
eJhHd2SzB36ZR67M2TvKHmOCxOi07DhNPXRd1ETYfmfwkFN1hi9ML7vO4R3J
laZEvkRcwSaWRL0DzuDj4NGuyG/Jr8+PHJsaa1XUWQtS5/dgLnqhX1fkch2h
Az75ZNRcC5psD9jhVRo/UfZdofePys4Vr27yeF/UZ7wHb0G8J+5Tb1F3sfbm
yI27Iz7iP+A0OLY9sAMdtsUY7Jgd58X+8fsjJeefC5u8F/YwGO+C3RUiryHW
Q9sT9BbFl+bU73mgbBnE3/1lx2LyN3QkH0RP7Gdu2D/59RW5c2xokyPn/ET2
83HVuTZxnnwbPGnOXU9yh9TiP674HUdlrjfwh8vV91T+f0fIo34ckm0eaHWc
pga6I3cdxNuy/8rw5cMRi1vFe2vuWMqdzw4518uer1N7tNF56GkVx1lynEMR
69fmXs/alyP+gXvE5o8iV8HHmGctueKHkZPwbujF2xFDyC3wX+qJS3LXE2BY
R2r7IS9rzJ2bgYnERbAUu8P+sEPy7om5/bkz6NgDeSc+hn/tiW8W+NcMnaur
5jqJOu3u+M5BvKPWIsZR65xSMa6+HraBntgsOmLD2DgYc2XEXOoQsJHacVlu
WXy3mJPazqmlxla8dmr4EPqQ/1Hv8QZgIXUUeEhtNyH3f/Lao5EzExPI+4kL
vFM16kTwaVFujLqUOJP5/c8JO2Utdd603LpSx5yb23bxbdZxXmqXYsXnwuax
deImeM07kE/yLQisoc76N3lO7tyXefAHHr4VwQfPjNQ6oQ/zzMHToXp6klqh
xfK2xPclcqWZufGJOwcvuHfqaOwJW6KuPBC6zQxc7w9/Hwo6dgc/eT68Q+HD
YP6OkMP8jqhn+ObRHt8kvpI6d9wa8QKcAjeOxerc8XBC6vzp+fguwh1xLnL4
g5HHd6bOq8BbbAY8xran6dwXSs7qZtclrAEHjq2Le+NODsaYnHFqbuzeH2cH
i8an/jYE/oJdg/ENC3zaHzzYOPV2X3z7IQfCHn6qe/+g4rkz1U+tOA4Ol7xh
mXMxajRyemLX0+L/pOI4x7eZ/7b7+ww519GS912m8+xp9lv/Xvyjq6598fs3
ArepQaHxRoOytz/XHOfI9S+IOpG7IpbgY8ShochzelLn62DJN9V/K3ccxYc2
BCYil7Nj9+Snvblz1ItS5774Orhdi++I2BjxaV+8NXECPCFfW5o75nyms37a
7m+FrCW24TsLU3+D42wHwy94d+pFalrssqtsOnjO99GO+EaKToPxbYd8sCV3
TsR9DkYM4jtrHtjF98g58U0SeV2x1/8AJTnBdw==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnuQ1mMUx59qey+V9n12n9/7vrsqii5moqFcoqGNcWmmqVYRlUxSyYgY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         "],
         VertexColors->None], 
        PolygonBox[{{5446, 5445, 4064, 4062, 1850}, {6704, 6653, 3832, 4009, 
         4103}, {5449, 4418, 714, 4049, 3969}},
         VertexColors->None]}]}, 
     {RGBColor[0.9090271315627179, 0.8958172090131016, 0.8484456642502525], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuQ1WUZx99z2Dh7zt7O2T2/vcDKgm5gwG4ihInkoBRojqVIGtNMJppg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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlslVUQhs9tC9zbAvdeuOcrbYFSZEdrAWWVTUBRFlnKaqLspUYBw6aY
CBRwAdk0MZoYMDGYiAmoUfijAX6IGo0GJZq4EBVjFDUgGrVAwefNy48335lv
5szMmTPLqVm0csaKohDCy6AE/FUIoTIfwj5+flwcwq5cCEvAjkwI09qE0AR/
C+iF8DlkhsYQbgW7SkMoToewG94eMBD+Rfjl7D2YDaG5fQh9+N6CbB14BvmA
/DjWo8Fe6HbQzRUhtIASZOuw1y0JIdMphLvKQvgO/npkV4NXkB8BXYGvF7F3
rNg+n0b2CzAM+5fxOQWvCByH/yL8MtZtwSfQ+6H34F8j2I3sbOz1RvcN4An0
X4CeyHo8eA46h71z+LUJZFk/y78Z8KaC51lX8u8Kvs+rcCxaOHN3eF3BVvh/
oK8af68VHNsD2O/L+ZbDr0X+JxBYd8ubdxqZ4/hWVe6z3J8K4W/2VuXtu860
Dnq9/nHes/x7E9tvgXri1YK6scTidnAq4xh1xV4aeiL8b7G3UneNzQHsb2Z/
Z2ydyNnWDsUD+TLkJyF/FvkG5Pcg3xP5P5GvR3YA9DVkV2FjCesF4CXO2x/5
yN4COFRsnzZ2DOFx9pxpFcJDrUO4G98ngWHs/xB9V7CfZ/8P0EOQb4C3HEyF
/hr+YWJfwv4U36vEdzrrHsifh9+A/ZGcvTk6dnPahXAj/rfD/hR0/YI/jeh6
oOBc/gZ9K9CTylnXa2Arexdxxl+LfMbJyE4BI5D/iH9b8L8W9MX39WBkJXdT
4bs+hK5ibA2Kzu0x2ExB10Tf/UjoDqzbg02lPuOTWeeUcukz9uTxdzg6f8ua
3obs4rxrTXdchL5e0bk5Cn3z8e1eMAH6c2Qmc5Ys/O+h7yMeg9E1ITpfz16P
nfyUv4rhaPaOKbjWTrB/Lut5YBz0qSLHbl10rSmG09hfDf07/GWKN7KjQC30
ceTriM2DyFwiNv3BU6zng8cyjuE/nO916HTKOana0x7Jqgbr4c8Em+CXQV9k
fSDnXF7Txr3oEezflnZP2pDzmXXWjvDfxpd3Cs7dBeioQfcU+BfQX936+t0l
rjXd4dPaCzZnfObtyn3QlHFMj6DraMG2F6JvY845p1yr4t+/5bYh3YOIz2J4
a/BvOPq3I5NNnBPKhU/5dxn5tvDPsHcw/+awngle4P67wE8nzhnlyknoreib
rTNnHOPSxDmgu/8AflPONaja6wF/J/p3lTvXlcNb4M0CD8PvpXxjPQ9syLjm
WrKuAeW+enQrdN8Z3evGl7n2F0fXsnqAevHsaF/Vk2uJzc0F2z6iQZK4hlW7
76lHItuY9yzQzFitWBbca3/k3374q/LuPerZl6JjqlgeTdv3wfwrSvsMd0TX
pGpROV3HekDBZzvKvxz8GujDRa6Bq9ExV6zfRX5ttA+yrTs6yd29Dxq42370
pAgvKTiXXkVmL/LL8+516pFLOP9S8F/GM66O+hoK3sh6ZjUivxTsK3VPr8D2
Mc4wN+U9s+gVMe9Z1Jl4T4uuOdVaBfKVie9Asf8q7V6pmlOtqWeqlurZ0znt
mnqU9dqCe79qQnd7T7Qu3bFi0b3gXFVMlEtj4LdNO6d6590z1SsPwR8b3ZPV
iyWj2XUtOnaaYT2jY65Yq+eq11cnniXq+aqlhfzrl3ZNaTZWwP8y7RmpXK9K
fDbl/MDoHqLeoRmi2NUknvWK4c8Fx0yx0gwp0TyLfiuMK3Pc9cbocz3+mm3T
o2exZpxqeRn0TWnXdKfEOrRXPqVkL++71ptgSHRPVC9Uzh1k//kOzg31rFnR
PVe9Vnegt0sucW3rDaO3Qypx7usNobdOJnEt682jt1JZ4trVm6kLvnTt5F6n
HGmInlGaTfJZs+JydC1oZujt0yfxLNYbaFH0jNRsVMy7RdekalE9uon821zu
u1XP0VumQ+LZojfNzpx7lnqVZuz/9BU2ug==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{5650, 5444, 2062}, {4222, 4991, 75}, {4912, 4201, 158}, {
         5195, 5194, 1848}, {5209, 5208, 1858}, {5459, 5463, 2075}, {5444, 
         5448, 2062}, {5455, 4185, 113}, {5627, 5390, 2015}, {5224, 5223, 
         1869}, {5390, 5394, 2015}, {5473, 4190, 128}, {5411, 5415, 2030}, {
         6135, 5626, 61}, {5477, 5481, 2092}, {5167, 5166, 1827}, {4897, 6135,
          61}, {4176, 4222, 75}, {4201, 4240, 158}, {5393, 6140, 76}, {6489, 
         6652, 3666}, {6146, 5642, 91}, {5440, 4182, 105}, {5182, 5181, 
         1837}, {5492, 4195, 143}, {4204, 4912, 158}, {5208, 5456, 1858}, {
         5181, 5426, 1837}, {5194, 5441, 1848}, {5223, 5474, 1869}, {5480, 
         5673, 144}, {5414, 6146, 91}, {4190, 4233, 128}, {6714, 5649, 
         3974}, {4195, 4237, 143}, {5235, 5493, 1877}, {5166, 5408, 1827}, {
         5633, 5411, 2030}, {4185, 4231, 113}, {4182, 4228, 105}, {4173, 4897,
          61}, {5447, 6149, 114}, {4910, 4995, 144}, {6651, 6717, 4096}, {
         6140, 5632, 76}, {5643, 5429, 2049}, {5673, 4910, 144}, {5462, 6153, 
         129}, {5429, 5432, 2049}, {5236, 5235, 1877}, {6153, 5664, 129}, {
         5665, 5477, 2092}, {5425, 4180, 90}, {5407, 4176, 75}, {5659, 5459, 
         2075}, {6149, 5658, 114}, {4180, 4226, 90}},
         VertexColors->None], 
        PolygonBox[{{4240, 5236, 1877, 158}, {5626, 5627, 2015, 61}, {5664, 
         5665, 2092, 129}, {5394, 5393, 76, 2015}, {4226, 5167, 1827, 90}, {
         5448, 5447, 114, 2062}, {5426, 5425, 90, 1837}, {4231, 5195, 1848, 
         113}, {5632, 5633, 2030, 76}, {4237, 5224, 1869, 143}, {4228, 5182, 
         1837, 105}, {5642, 5643, 2049, 91}, {5493, 5492, 143, 1877}, {5432, 
         6489, 3666, 2049}, {4233, 5209, 1858, 128}, {5474, 5473, 128, 
         1869}, {5456, 5455, 113, 1858}, {5658, 5659, 2075, 114}, {5481, 5480,
          144, 2092}, {5441, 5440, 105, 1848}, {5463, 5462, 129, 2075}, {5415,
          5414, 91, 2030}, {5408, 5407, 75, 1827}},
         VertexColors->None], 
        PolygonBox[{{6652, 6651, 4096, 4079, 3666}, {5649, 5650, 2062, 3967, 
         3974}},
         VertexColors->None]}]}}, {{}, {}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4173, 4897, 6135, 5626, 5627, 5390, 5394, 5393, 6140, 5632, 
         5633, 5411, 5415, 5414, 6146, 5642, 5643, 5429, 5432, 6489, 6652, 
         6651, 6717}],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4204, 4912, 4201, 4240, 5236, 5235, 5493, 5492, 4195, 4237, 
         5224, 5223, 5474, 5473, 4190, 4233, 5209, 5208, 5456, 5455, 4185, 
         4231, 5195, 5194, 5441, 5440, 4182, 4228, 5182, 5181, 5426, 5425, 
         4180, 4226, 5167, 5166, 5408, 5407, 4176, 4222, 4991}],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4995, 4910, 5673, 5480, 5481, 5477, 5665, 5664, 6153, 5462, 
         5463, 5459, 5659, 5658, 6149, 5447, 5448, 5444, 5650, 5649, 6714}],
        "7"],
       Annotation[#, 7, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4290, 5300, 5301, 5299, 5916, 4289, 5031, 4288, 5915, 5914, 
         6356, 6355, 4643, 5535, 4464, 5269, 4463, 5534, 4640, 5521, 4456, 
         5258, 4455, 5520, 4634, 5508, 4450, 6029, 6030, 5677, 5676, 6157, 
         5494, 5495, 5491, 5672, 5671, 6155, 5475, 5476, 5472, 5663, 5662, 
         6152, 5457, 5458, 5454, 5657, 5656, 6148, 5442, 5443, 5439, 5648, 
         5647, 6147, 5427, 5428, 5424, 5641, 5640, 6145, 5409, 5410, 5406, 
         5631, 5630, 6139, 5388, 6481, 5389, 6018, 6017, 4391, 6461, 5625, 
         4594, 5376, 4384, 5138, 4383, 5375, 4588, 5363, 4378, 5126, 4377, 
         5362, 4581, 6209, 6210, 5877, 5878, 4267, 6343, 4266, 4847, 4758, 
         5062, 5061, 4823}],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4291, 5302, 5303, 5274, 5874, 4261, 5000, 6577, 6578, 6163, 
         6165, 6164, 5706, 5350, 6485, 4373, 5119, 5121, 5122, 5790, 5364, 
         4379, 5129, 5131, 5132, 5793, 5377, 4385, 5141, 5142, 4218, 4172, 
         5391, 5392, 5153, 5154, 4223, 4177, 5412, 5413, 5168, 5169, 4227, 
         4181, 5430, 5431, 5183, 5184, 6649, 6653, 6704, 6712}],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5758, 5715, 5716, 5714, 6174, 6173, 5005, 4287, 5913, 5912, 
         6245, 6244, 5730, 5264, 5263, 5261, 4457, 5522, 5832, 5251, 5250, 
         5248, 4451, 5509, 5829, 5239, 5238, 5237, 5497, 5496, 4196, 4238, 
         5226, 5225, 5479, 5478, 4191, 4234, 5211, 5210, 5461, 5460, 4186, 
         4232, 5197, 5196, 5446, 5445, 6710}],
        "6"],
       Annotation[#, 6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4580, 4887, 4372, 5013, 4832, 4833, 5789, 5361, 4376, 5125, 
         5127, 5128, 5792, 5374, 4382, 5137, 5139, 5140, 5797, 6133, 6134, 
         5796, 6387, 5795, 4389, 5150, 4390, 5387, 4597, 5404, 4396, 5163, 
         4397, 5405, 4604, 5639, 6463, 4408, 6022, 4409, 5423, 4610, 5646, 
         6464, 4416, 6023, 4417, 5438, 4616, 5655, 6465, 4424, 6024, 4425, 
         5453, 4620, 5661, 6466, 4434, 6027, 4435, 5471, 4624, 5489, 4442, 
         5232, 4443, 5490, 4626, 5507, 4448, 5246, 4449, 5686, 5687, 5685, 
         5831, 5519, 4454, 5257, 5259, 5260, 5833, 5533, 4462, 5268, 5270, 
         5271, 5834, 4929, 4471, 5030, 4843, 4844, 5116}],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4646, 4924, 4466, 5006, 4465, 4923, 4641, 5524, 4459, 5262, 
         4458, 5523, 4635, 5511, 4453, 5249, 4452, 5510, 4627, 5678, 4628, 
         5679, 5242, 5240, 4444, 5498, 5827, 5230, 5229, 5227, 4436, 5482, 
         5823, 5215, 5214, 5212, 4426, 5464, 5818, 5200, 5199, 5198, 4418, 
         5449, 6713}],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5095, 4880, 4367, 5001, 4368, 4882, 4575, 5351, 4374, 5120, 
         4375, 5352, 4582, 5365, 4380, 5130, 4381, 5366, 4589, 5618, 4590, 
         5619, 4386, 5143, 5145, 5146, 5798, 5395, 4392, 5155, 5157, 5158, 
         5803, 5416, 4398, 5170, 5172, 5173, 5813, 5433, 4410, 5185, 5186, 
         6574, 5187, 6676, 6650, 6716}],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4165, 4886, 4163, 5100, 5099, 4579, 4831, 4213, 4164, 5357, 
         5358, 5123, 5124, 4215, 4169, 5372, 5373, 5135, 5136, 4217, 4171, 
         5385, 5386, 5149, 5151, 5152, 5802, 5403, 4395, 5162, 5164, 5165, 
         5812, 6143, 6144, 5811, 6388, 5810, 4406, 5178, 4407, 5422, 4609, 
         5436, 4414, 5192, 4415, 5437, 4615, 5451, 4422, 5205, 4423, 5452, 
         4619, 5470, 4432, 5220, 4433, 5669, 5670, 5668, 5826, 5488, 4441, 
         5231, 5233, 5234, 5828, 5506, 4447, 5245, 5247, 4242, 4203, 5517, 
         5518, 5255, 5256, 4244, 4207, 5529, 5530, 5266, 5267, 4248, 4210, 
         4927, 4928, 4648, 5702, 5704, 5703, 4930, 4999}],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4211, 4249, 6162, 4644, 5701, 4645, 6329, 6330, 6326, 6328, 
         6327, 5698, 5526, 5527, 5525, 5689, 5688, 6159, 5513, 5514, 5512, 
         5681, 5680, 6158, 4629, 5500, 4446, 5241, 4445, 5499, 4625, 5484, 
         4438, 5228, 4437, 5483, 4621, 5465, 4428, 5213, 4427, 5819, 6479, 
         4617, 6150, 5820, 4839, 4838, 5018, 4419, 4905, 6709}],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4984, 4881, 5781, 5780, 5096, 4574, 4885, 4884, 6124, 5611, 
         5612, 5353, 5355, 5354, 6126, 5615, 5616, 5367, 5369, 5368, 5622, 
         4593, 5378, 4387, 5144, 4388, 5379, 4595, 5396, 4393, 5156, 4394, 
         5397, 4598, 5417, 4399, 5171, 4400, 5645, 4605, 5644, 5814, 4904, 
         4411, 5016, 4837, 6575, 6648, 6647, 6715}],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4576, 4883, 4369, 5011, 4829, 4830, 5097, 4158, 4888, 4889, 
         4766, 4834, 4214, 4166, 4890, 4891, 4592, 5620, 4591, 5621, 4892, 
         6132, 5623, 5624, 5380, 5384, 5383, 6136, 5628, 5629, 5398, 5400, 
         5399, 6141, 5634, 5635, 6020, 6019, 4401, 5418, 4607, 6346, 4761, 
         5891, 5892, 4270, 5017, 4271, 5289, 4699, 5918, 5919, 6678, 6685, 
         6686, 6719}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4649, 5705, 5537, 5538, 5536, 5700, 5699, 6161, 5531, 5532, 
         5528, 5697, 5696, 6160, 4916, 4917, 4816, 4915, 4914, 4996, 4911, 
         5684, 4632, 5683, 4633, 6314, 6315, 6311, 6313, 6312, 4200, 6490, 
         5841, 5840, 5839, 4657, 6172, 4656, 5004, 6009, 6008, 4746, 6325, 
         5751, 5222, 5221, 5219, 4431, 5469, 5822, 5207, 5206, 5204, 4421, 
         5654, 4614, 5652, 4612, 5651, 4613, 5653, 5193, 5191, 4413, 5435, 
         5816, 5180, 5179, 5177, 4405, 5421, 5809, 5161, 5160, 5159, 5402, 
         5401, 4175, 4221, 5836, 5835, 6170, 6169, 4596, 5102, 5103, 5104, 
         4899, 4989, 4895, 4896, 4818, 4894, 4893, 5617, 5359, 5360, 5356, 
         5614, 5613, 6125, 5348, 5349, 5347, 5788, 5787, 6488, 6487}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4828, 6033, 4468, 6031, 4467, 6032, 4748, 5753, 5752, 5339, 
         4747, 5115, 4208, 4245, 4842, 4803, 4919, 4918, 4205, 4243, 4841, 
         4636, 5112, 5113, 5114, 4913, 5682, 5504, 5505, 5501, 5675, 5674, 
         6156, 5486, 5487, 5485, 5667, 5666, 6154, 5466, 6482, 5467, 6026, 
         6025, 4429, 6411, 5660, 6423, 4618, 6151, 6480, 4682, 6224, 5893, 
         5894, 4273, 6347, 4272, 4848, 4700, 5920, 5921, 6705, 6708}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4968, 4973, 6681, 6683, 4230, 4184, 6692, 4189, 4968}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4647, 4926, 4470, 5094, 4469, 4925, 4642, 4922, 4461, 5068, 
         4460, 4921, 4639, 6308, 6309, 5977, 5978, 4340, 6310, 4339, 4864, 
         4817, 4870, 4869, 4351, 6005, 6004, 6476, 4567, 6118, 5982, 5983, 
         4568, 6119, 4569, 6120, 6537, 4354, 5060, 6536, 6535, 6409, 4809, 
         5608, 5607, 5605, 5606, 5342, 4363, 5341, 4364, 6297, 4730, 6296, 
         4729, 5743, 5742, 5218, 5217, 6483, 4430, 5468, 5821, 5203, 5202, 
         5201, 4420, 5450, 5817, 5190, 5189, 5188, 4412, 5434, 5815, 5176, 
         5175, 5174, 4404, 5420, 5807, 5808, 5838, 5837, 4653, 6171, 4603, 
         5105, 5106, 5107, 4902, 4990, 5729, 4676, 5728, 4677, 6249, 4698, 
         6248, 4697, 5285, 5284, 5283, 4490, 5542, 4356, 6115, 6116, 5980, 
         5981, 4343, 6117, 4342, 4866, 4819, 4872, 4871, 4352, 6007, 6006, 
         6468, 4485, 6042, 5887, 5888, 4696, 5886, 5885, 5884, 4672, 6214, 
         4578, 5346, 4371, 6016, 4370, 6460, 5786, 6486}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4820, 5761, 4757, 5275, 5276, 5277, 5012, 5876, 5875, 5278, 
         5722, 5721, 4292, 5080, 5081, 4767, 5762, 5764, 5763, 4262, 6211, 
         5726, 5727, 5707, 6425, 4650, 6166, 5708, 5709, 5370, 6449, 5371, 
         5133, 5134, 4216, 4170, 5381, 5382, 5147, 5148, 4219, 4174, 4900, 
         4901, 4814, 4836, 4224, 4178, 4903, 5109, 5108, 5760, 4606, 6183, 
         6184, 6180, 6182, 6181, 6587, 4681, 6221, 6223, 6222, 4473, 5858, 
         5859, 6477, 5860, 6478, 4570, 5861, 6493, 6391, 6582, 6581, 4497, 
         5290, 5601, 6475, 5602, 5896, 6508, 5895, 6706, 6677, 6718}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5984, 5338, 6416, 4511, 6066, 5609, 5610, 4573, 6595, 4693, 
         6430, 4692, 6594, 5026, 5027, 4811, 6384, 4810, 6385, 4346, 5088, 
         5089, 4804, 6379, 6381, 6380, 4920, 6302, 4260, 5873, 5872, 4668, 
         6202, 5719, 5720, 6451, 6450, 5253, 5252, 5516, 5515, 4202, 4241, 
         5244, 5243, 5503, 5502, 4197, 4239, 4840, 4812, 4909, 4908, 4192, 
         4235, 4994, 4622, 5087, 4623, 6190, 6191, 6187, 6189, 6188, 6227, 
         4685, 6226, 6229, 6228, 4353, 5073, 6340, 6341, 6339, 4756, 6342, 
         6688, 6664, 4808, 6675, 6496, 6393, 6540, 6539, 4349, 5019, 6588, 
         6589, 6428, 4683, 5604, 6698, 5603, 6707, 6711}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4967, 4972, 6680, 6682, 4229, 4183, 6691, 4188, 4967}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1FlsjUEUwPERiQSx0yI82MXSeiDxhkiI5UUREiEhlgRR+7611XqwJYSi
W6zV9taaiFqLBLHW9oBqKx4oEUvsQfzm4X//c86cOd/c+ebeLjPS0xY0CCGM
8TGsZQh7k0IYwrm8B69ahbC6TQircFv+XNsQKvBX/A9L5YZihPFILrLmg/HH
5BDeWNuuQwhX1A8WH2kXQqbcYc7g3XIl1ixqH8L01iEs5Bm8mN+aX6NPPSfp
8Y7LOYcvm9+m7gJfwkWsVXsn7l/PfdiDLLW5fIDzeTPncSEKcFd9qXXr9V2H
Rjiq72usNVfiuxxDMX6r/4WVerwQV+MltooPyn+z5jse4Cd+oLHeNXqWGffm
BNfyTr5mz7u4Ro9/MYcdeh3TqzSeC+7bw1EuxqF4fjiMOrXPrH+OTGxCFmbq
t4JXYhlmiZfzaX0+G+/Uv8y7SKAcZeJK7+KM+S/mK5Cm/3h8kntg/1V4q8cF
c2/iWXOBXD7uiveLz6pP6NWNuyM37kF+lPFopHQMIRX90VB+o7VNjFPiGcU5
7sm90A99sUVNJ07GPOPZmGJPPcRdMVN8zjMzuIJn8VjPGoMb4qc8AKk4L77G
Yz1nnL0Vqi3CZXF9vEP8jh/LPcJnz5mofkJca65p3C8eiq/r1ZSboDF2ifua
64MNesxRv54zsBGz413idViFNViN7HjnPeeq91+JQXoNRLVcOR9HWTxL/RPx
7unzG8XYrL6Es+P95Bxu5vl/jP/iHj6gSK8T1ubpUeo9D3dvJhlvlZsc77Ga
OWrGWZuGZHF7NUl8kls555aoULNfnIfmyLd2H5fE3xUXcAsujGPcUl+j303+
Gvfnrj2J99u4G2+Pezffmec7h2k8l6fyvHjXrKu134f61vAjruNJ9v2Sq8TV
XCeujb/1+B+Cpc5hGZZgU7z7nMWn9MzhE/Hc43eL9zP+p1j7Qq/6eO78nrPj
fwwq7e8qMtUn1B9HORbIpeM/KNPYmw==
         "]],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4366, 4879, 4690, 6429, 4691, 6593, 6667, 6255, 4704, 6253, 
         4703, 6254, 4773, 6439, 6621, 6620, 4510, 5909, 5910, 5911, 6065, 
         6064, 4284, 6358, 4770, 6357, 4771, 5070, 5069, 5755, 4752, 5754, 
         5757, 5756, 5759, 5054, 4341, 5979, 5337, 5746, 5745, 4865, 6324, 
         4745, 5995, 5996, 5997, 5059, 5994, 5993, 5992, 4744, 6323, 5830, 
         6014, 6015, 5991, 5990, 4348, 5058, 4347, 5989, 5988, 4805, 4983, 
         4982, 5869, 5868, 5592, 4553, 5591, 4554, 5593, 5965, 5590, 4552, 
         5589, 4551, 6102, 4977, 6304, 4734, 6303, 4735, 6305, 4733, 6307, 
         4737, 6306, 4736, 6609, 4280, 4851, 4769, 6404, 6522, 6523, 5085, 
         4294, 6551, 6552, 6401, 6513, 6514, 4566, 6512, 6511, 6400, 4500, 
         6550, 6656, 6657, 6543, 6544, 6396, 6500, 4254, 6549, 4253, 6499, 
         6395, 6542, 6541, 4360, 6547, 6548, 6399, 6510, 4277, 6597, 4276, 
         6509, 6398, 6591, 6590, 4608, 5419, 4403, 6021, 4402, 6462, 5637, 
         4601, 5636, 4602, 5638, 5711, 5710, 6585, 4679, 6427, 4680, 6586, 
         4599, 6142, 4600, 5804, 5805, 5806, 4937, 5554, 4514, 5553, 4515, 
         5555, 5969, 5557, 4517, 5556, 4516, 6067, 4898, 4951, 4952, 4753, 
         6335, 6337, 6336, 5007, 4311, 5929, 5930, 6013, 6012, 5794, 6168, 
         4652, 6167, 4651, 6579, 5002, 5987, 5986, 5985, 4743, 6322, 4867, 
         6610, 6611, 6408, 6532, 4345, 5055, 4344, 6130, 6131, 6128, 4587, 
         6129, 4707, 6359, 6360, 6260, 6259, 4671, 6212, 4670, 6213, 6501, 
         6502, 5882, 5883, 5881, 6469, 5880, 5879, 4484, 6559, 6560, 6417, 
         4519, 6035, 4479, 6034, 4480, 6036, 6655, 6545, 4478, 6413, 4477, 
         4822, 4821}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5903, 4506, 6194, 6195, 5865, 5866, 5867, 4955, 5864, 5863, 
         5862, 6193, 6192, 4504, 5294, 5579, 5580, 4540, 6085, 6087, 6086, 
         4502, 5043, 4501, 4943, 5216, 4236, 4194, 4969, 4198, 4826, 5048, 
         5047, 4361, 4878, 5308, 5009, 4664, 5053, 4732, 5092, 5093, 4846, 
         4256, 5744, 4257, 5273, 5272, 5718, 5717, 4665, 5010, 5967, 5336, 
         4362, 5340, 5110, 5111, 5595, 5594, 4944, 4932, 4933, 4505, 5900, 
         5901, 5902, 4525, 5905, 5904, 5903}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5008, 4662, 6580, 4663, 6390, 6492, 4252, 6606, 6598, 6599, 
         6431, 6601, 6600, 4712, 5035, 5922, 5545, 4494, 5543, 4493, 5544, 
         5578, 5577, 4941, 6079, 4534, 6078, 6564, 6563, 4359, 6410, 4358, 
         6538, 4533, 6528, 6527, 6407, 4520, 6561, 6562, 6068, 4522, 6069, 
         4954, 5857, 5856, 5855, 6186, 6185, 4496, 5286, 5287, 5288, 4532, 
         6075, 6077, 6076, 4357, 5042, 4824, 4825, 4961, 4960, 4179, 4225, 
         4938, 4939, 5038, 5037, 4491, 4940, 5307, 5008}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6001, 4807, 6383, 4863, 5091, 4350, 4868, 4948, 4947, 5778, 
         4801, 5777, 4802, 5779, 4799, 6674, 4800, 6659, 6660, 6570, 4565, 
         6420, 6572, 6571, 4564, 6113, 4563, 6114, 4979, 4259, 4978, 4258, 
         5870, 6197, 6196, 4666, 5974, 6531, 6110, 4559, 6108, 4558, 6109, 
         6515, 4282, 4970, 6517, 6516, 6402, 4688, 6592, 4687, 6293, 4721, 
         6290, 6292, 6291, 4304, 6100, 4305, 5926, 5925, 6072, 6071, 6349, 
         5024, 5025, 4720, 6433, 4719, 6607, 4318, 6635, 6636, 6445, 6638, 
         6637, 4763, 6350, 6351, 5908, 6518, 6519, 6234, 6235, 6233, 6237, 
         6236, 4667, 6198, 6199, 6201, 6200, 5871, 6382, 4806, 5998, 5999, 
         6000, 5090, 6003, 6002, 6001}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5050, 4727, 6434, 4726, 6608, 4310, 6602, 6603, 6432, 6605, 
         6604, 4675, 6344, 6345, 5889, 6506, 6507, 6216, 6217, 6215, 6219, 
         6218, 4661, 6178, 6179, 6438, 6437, 6436, 6048, 4488, 6047, 4489, 
         6484, 6049, 6419, 6473, 4549, 6474, 5976, 6663, 4338, 6661, 6662, 
         6658, 6668, 6696, 4306, 6687, 6697, 4715, 6689, 6669, 6671, 6670, 
         4659, 5847, 5848, 5849, 4935, 4250, 4936, 4251, 5850, 6177, 6176, 
         4660, 5968, 6530, 6105, 4556, 6103, 4555, 6104, 6503, 4268, 4959, 
         6505, 6504, 6397, 4760, 6615, 4674, 6285, 4716, 6282, 6284, 6283, 
         4931, 6106, 4309, 5928, 5927, 5960, 5959, 4335, 5049, 5050}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5296, 4329, 5559, 5560, 5558, 5583, 5582, 6090, 4949, 4247, 
         5842, 5265, 5713, 5712, 4365, 5343, 5345, 5344, 5588, 4297, 6524, 
         6405, 6619, 6618, 4772, 5775, 5776, 5774, 6644, 6643, 6373, 6374, 
         6238, 6240, 6239, 4512, 6242, 6243, 6241, 4689, 6294, 4722, 5317, 
         5318, 5319, 5029, 6353, 4764, 6352, 4765, 6354, 4528, 6073, 4529, 
         5572, 5966, 5335, 6426, 4658, 6175, 5845, 5846, 5843, 5844, 5550, 
         5552, 5551, 4330, 5315, 5316, 5314, 4332, 5298, 5297, 5296}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5587, 4546, 5586, 4545, 6247, 4695, 6246, 4694, 6596, 5032, 
         5952, 5951, 5320, 4723, 5741, 4669, 6203, 5723, 5725, 5724, 4518, 
         6207, 6208, 6204, 6206, 6205, 6639, 6640, 6446, 6642, 6641, 4768, 
         6616, 6617, 6403, 6521, 4293, 5917, 5566, 5567, 6011, 6010, 4355, 
         6095, 6096, 6092, 6094, 6093, 4168, 5573, 5562, 5563, 5561, 5565, 
         5564, 4322, 5282, 5322, 6458, 5323, 6459, 4334, 5954, 5324, 5326, 
         5325, 4321, 5309, 5310, 5098, 5584, 6386, 4162, 5785, 6472, 4543, 
         6091, 4544, 5585, 5950, 5587}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5064, 4790, 6447, 4789, 6645, 4303, 6626, 6627, 6442, 6629, 
         6628, 4781, 6625, 4783, 6441, 4782, 6495, 6494, 6392, 4474, 6568, 
         6569, 6107, 4557, 6567, 4313, 4942, 5934, 5933, 6081, 4535, 6080, 
         5946, 6529, 5947, 6084, 4539, 6083, 5938, 5939, 4876, 4314, 6099, 
         4548, 6098, 6566, 6565, 4475, 6394, 6497, 6498, 4785, 6443, 4786, 
         6630, 4784, 6633, 6634, 6444, 6632, 6631, 4315, 6646, 4791, 6448, 
         4792, 5066, 5065, 5067, 5063, 5064}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5078, 4787, 5770, 6369, 6368, 5771, 5772, 5547, 5549, 5548, 
         5958, 5957, 5330, 4725, 5295, 4285, 4950, 4286, 5737, 5738, 5570, 
         4526, 5569, 4527, 5571, 5949, 4331, 5028, 5079, 5077, 5078}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5576, 4531, 5574, 4530, 5575, 5890, 4269, 4956, 4976, 4962, 
         4963, 4678, 6220, 6584, 6583, 6074, 4325, 5932, 5931, 4312, 6286, 
         6287, 5735, 4717, 5041, 5040, 4323, 5039, 4324, 5945, 5576}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5943, 4328, 6088, 6231, 6232, 6230, 4686, 4958, 4957, 4981, 
         4980, 4279, 5907, 5906, 6471, 4541, 6089, 4542, 5581, 5948, 4327, 
         5046, 4326, 5044, 5045, 4718, 5736, 6289, 6288, 4317, 5942, 5943}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4998, 4638, 6613, 6614, 6389, 6491, 4206, 5691, 5692, 5690, 
         5695, 5693, 5694, 4713, 4862, 4319, 6300, 4320, 6299, 6298, 6301, 
         4731, 5052, 5331, 5332, 5051, 5334, 5333, 4998}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5015, 4673, 6281, 6278, 6279, 4308, 6280, 4307, 4859, 4778, 
         5734, 5732, 5733, 5731, 5769, 5768, 6364, 6365, 6363, 6367, 6366, 
         4714, 5036, 5312, 5313, 5014, 5076, 4759, 5015}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{6455, 5937, 6457, 6456, 6453, 6454, 4278, 6455}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5280, 5279, 5539, 4476, 6412, 5321, 5953, 4333, 5033, 5084, 
         5082, 5083, 4788, 6370, 6372, 6371, 4301, 6452, 5773, 5306, 5328, 
         5327, 5956, 6418, 5955, 5329, 4724, 5281, 6470, 4264, 4953, 4263, 
         5739, 5740, 5280}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-10, 10}, {-10, 10}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->434410143]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1293],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["SinhIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SinhIntegral"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->28892]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->484],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->2943]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->11495],

Cell[TextData[{
 ButtonBox["Demonstrations with CoshIntegral",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=CoshIntegral"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/Chi.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/GammaBetaErf/CoshIntegral/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->622554087],

Cell[TextData[ButtonBox["Error and Exponential Integral Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ErrorAndExponentialIntegralFunctions"]], "MoreAbout",
 CellID->245232039]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CoshIntegral - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 35, 10.2845438}", "context" -> "System`", 
    "keywords" -> {"chi", "hyperbolic cosine integral"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CoshIntegral[z] gives the hyperbolic cosine integral Chi(z).", 
    "synonyms" -> {"cosh integral"}, "title" -> "CoshIntegral", "type" -> 
    "Symbol", "uri" -> "ref/CoshIntegral"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5560, 198, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->153222897]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 238934, 4773}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1809, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2432, 75, 50, 1, 70, "ObjectName",
 CellID->27669],
Cell[2485, 78, 602, 19, 70, "Usage",
 CellID->893]
}, Open  ]],
Cell[CellGroupData[{
Cell[3124, 102, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3602, 119, 120, 4, 70, "Notes",
 CellID->20640],
Cell[3725, 125, 621, 21, 70, "Notes",
 CellID->1014],
Cell[4349, 148, 475, 17, 70, "Notes",
 CellID->19104],
Cell[4827, 167, 255, 8, 70, "Notes",
 CellID->45234343],
Cell[5085, 177, 226, 7, 70, "Notes",
 CellID->31226],
Cell[5314, 186, 209, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[5560, 198, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->153222897],
Cell[CellGroupData[{
Cell[5945, 212, 148, 5, 70, "ExampleSection",
 CellID->797764109],
Cell[6096, 219, 60, 1, 70, "ExampleText",
 CellID->14890],
Cell[CellGroupData[{
Cell[6181, 224, 105, 3, 28, "Input",
 CellID->8493],
Cell[6289, 229, 174, 5, 36, "Output",
 CellID->32199678]
}, Open  ]],
Cell[6478, 237, 120, 3, 70, "ExampleDelimiter",
 CellID->1549],
Cell[CellGroupData[{
Cell[6623, 244, 217, 7, 28, "Input",
 CellID->9314],
Cell[6843, 253, 2440, 44, 155, "Output",
 Evaluatable->False,
 CellID->438689084]
}, Open  ]],
Cell[9298, 300, 121, 3, 70, "ExampleDelimiter",
 CellID->15238],
Cell[CellGroupData[{
Cell[9444, 307, 221, 7, 70, "Input",
 CellID->19911],
Cell[9668, 316, 986, 32, 54, "Output",
 CellID->605260004]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10703, 354, 215, 7, 70, "ExampleSection",
 CellID->6508],
Cell[10921, 363, 69, 1, 70, "ExampleText",
 CellID->9647],
Cell[CellGroupData[{
Cell[11015, 368, 127, 4, 70, "Input",
 CellID->4982],
Cell[11145, 374, 272, 8, 36, "Output",
 CellID->321279465]
}, Open  ]],
Cell[11432, 385, 125, 3, 70, "ExampleDelimiter",
 CellID->111457831],
Cell[11560, 390, 66, 1, 70, "ExampleText",
 CellID->25149],
Cell[CellGroupData[{
Cell[11651, 395, 157, 5, 70, "Input",
 CellID->23088],
Cell[11811, 402, 233, 7, 36, "Output",
 CellID->2262220]
}, Open  ]],
Cell[12059, 412, 124, 3, 70, "ExampleDelimiter",
 CellID->15565528],
Cell[12186, 417, 108, 3, 70, "ExampleText",
 CellID->6231],
Cell[CellGroupData[{
Cell[12319, 424, 144, 4, 70, "Input",
 CellID->31920],
Cell[12466, 430, 228, 6, 36, "Output",
 CellID->149694353]
}, Open  ]],
Cell[12709, 439, 121, 3, 70, "ExampleDelimiter",
 CellID->19271],
Cell[12833, 444, 214, 7, 70, "ExampleText",
 CellID->12368],
Cell[CellGroupData[{
Cell[13072, 455, 166, 5, 70, "Input",
 CellID->6421],
Cell[13241, 462, 274, 9, 36, "Output",
 CellID->845852105]
}, Open  ]],
Cell[13530, 474, 121, 3, 70, "ExampleDelimiter",
 CellID->24122],
Cell[13654, 479, 87, 1, 70, "ExampleText",
 CellID->17723],
Cell[CellGroupData[{
Cell[13766, 484, 102, 3, 70, "Input",
 CellID->906],
Cell[13871, 489, 185, 6, 36, "Output",
 CellID->139206018]
}, Open  ]],
Cell[CellGroupData[{
Cell[14093, 500, 134, 4, 70, "Input",
 CellID->10189],
Cell[14230, 506, 217, 7, 51, "Output",
 CellID->969300938]
}, Open  ]],
Cell[14462, 516, 125, 3, 70, "ExampleDelimiter",
 CellID->846489652],
Cell[14590, 521, 203, 7, 70, "ExampleText",
 CellID->204480725],
Cell[CellGroupData[{
Cell[14818, 532, 148, 5, 70, "Input",
 CellID->272298317],
Cell[14969, 539, 233, 7, 50, "Output",
 CellID->411390102]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15251, 552, 239, 7, 70, "ExampleSection",
 CellID->14651],
Cell[15493, 561, 213, 7, 70, "ExampleText",
 CellID->13406],
Cell[CellGroupData[{
Cell[15731, 572, 307, 10, 70, "Input",
 CellID->4510],
Cell[16041, 584, 1491, 47, 83, "Output",
 CellID->689846630]
}, Open  ]],
Cell[17547, 634, 121, 3, 70, "ExampleDelimiter",
 CellID->30345],
Cell[17671, 639, 84, 1, 70, "ExampleText",
 CellID->12351],
Cell[CellGroupData[{
Cell[17780, 644, 226, 7, 70, "Input",
 CellID->6923],
Cell[18009, 653, 1820, 61, 52, "Output",
 CellID->803589]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19878, 720, 223, 7, 70, "ExampleSection",
 CellID->27844],
Cell[20104, 729, 84, 1, 70, "ExampleText",
 CellID->24743],
Cell[CellGroupData[{
Cell[20213, 734, 416, 14, 70, "Input",
 CellID->7741],
Cell[20632, 750, 24051, 398, 70, "Output",
 Evaluatable->False,
 CellID->778087178]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[44732, 1154, 233, 7, 70, "ExampleSection",
 CellID->19785],
Cell[44968, 1163, 256, 8, 70, "ExampleText",
 CellID->9227],
Cell[CellGroupData[{
Cell[45249, 1175, 518, 17, 70, "Input",
 CellID->8624],
Cell[45770, 1194, 218, 7, 36, "Output",
 CellID->5948405]
}, Open  ]],
Cell[46003, 1204, 367, 13, 70, "ExampleText",
 CellID->363387086],
Cell[CellGroupData[{
Cell[46395, 1221, 233, 7, 70, "Input",
 CellID->152250703],
Cell[46631, 1230, 280, 10, 36, "Output",
 CellID->183947134]
}, Open  ]],
Cell[46926, 1243, 120, 3, 70, "ExampleDelimiter",
 CellID->6227],
Cell[47049, 1248, 59, 1, 70, "ExampleText",
 CellID->555],
Cell[CellGroupData[{
Cell[47133, 1253, 250, 8, 70, "Input",
 CellID->10102],
Cell[47386, 1263, 226, 7, 36, "Output",
 CellID->90926008]
}, Open  ]],
Cell[47627, 1273, 121, 3, 70, "ExampleDelimiter",
 CellID->19468],
Cell[47751, 1278, 215, 8, 70, "ExampleText",
 CellID->11698],
Cell[CellGroupData[{
Cell[47991, 1290, 263, 9, 70, "Input",
 CellID->8979],
Cell[48257, 1301, 286, 9, 36, "Output",
 CellID->31784577]
}, Open  ]],
Cell[CellGroupData[{
Cell[48580, 1315, 344, 13, 70, "Input",
 CellID->12489],
Cell[48927, 1330, 338, 11, 36, "Output",
 CellID->462914808]
}, Open  ]],
Cell[49280, 1344, 121, 3, 70, "ExampleDelimiter",
 CellID->13490],
Cell[49404, 1349, 49, 1, 70, "ExampleText",
 CellID->30775],
Cell[CellGroupData[{
Cell[49478, 1354, 190, 6, 70, "Input",
 CellID->28410],
Cell[49671, 1362, 962, 34, 51, "Output",
 CellID->640158681]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[50682, 1402, 226, 7, 70, "ExampleSection",
 CellID->27089],
Cell[50911, 1411, 240, 7, 70, "ExampleText",
 CellID->27296],
Cell[CellGroupData[{
Cell[51176, 1422, 134, 4, 70, "Input",
 CellID->11950],
Cell[51313, 1428, 223, 6, 36, "Output",
 CellID->568169198]
}, Open  ]],
Cell[51551, 1437, 121, 3, 70, "ExampleDelimiter",
 CellID->20122],
Cell[51675, 1442, 234, 8, 70, "ExampleText",
 CellID->12529],
Cell[CellGroupData[{
Cell[51934, 1454, 293, 10, 70, "Input",
 CellID->7672],
Cell[52230, 1466, 601, 12, 70, "Message",
 CellID->242881962],
Cell[52834, 1480, 285, 7, 36, "Output",
 CellID->536849233]
}, Open  ]],
Cell[CellGroupData[{
Cell[53156, 1492, 434, 15, 70, "Input",
 CellID->5553],
Cell[53593, 1509, 298, 8, 36, "Output",
 CellID->470323217]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[53940, 1523, 223, 7, 70, "ExampleSection",
 CellID->1056],
Cell[54166, 1532, 56, 1, 70, "ExampleText",
 CellID->12826],
Cell[CellGroupData[{
Cell[54247, 1537, 287, 10, 70, "Input",
 CellID->12902],
Cell[54537, 1549, 1901, 61, 133, "Output",
 CellID->47356080]
}, Open  ]],
Cell[56453, 1613, 121, 3, 70, "ExampleDelimiter",
 CellID->14578],
Cell[56577, 1618, 108, 3, 70, "ExampleText",
 CellID->4949],
Cell[CellGroupData[{
Cell[56710, 1625, 465, 15, 70, "Input",
 CellID->21705],
Cell[57178, 1642, 177932, 2997, 70, "Output",
 CellID->434410143]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[235171, 4646, 310, 9, 70, "SeeAlsoSection",
 CellID->1293],
Cell[235484, 4657, 204, 6, 70, "SeeAlso",
 CellID->28892]
}, Open  ]],
Cell[CellGroupData[{
Cell[235725, 4668, 312, 9, 70, "TutorialsSection",
 CellID->484],
Cell[236040, 4679, 143, 3, 70, "Tutorials",
 CellID->2943]
}, Open  ]],
Cell[CellGroupData[{
Cell[236220, 4687, 321, 9, 70, "RelatedLinksSection",
 CellID->11495],
Cell[236544, 4698, 369, 12, 70, "RelatedLinks"],
Cell[236916, 4712, 174, 4, 70, "RelatedLinks"],
Cell[237093, 4718, 197, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[237327, 4727, 319, 9, 70, "MoreAboutSection",
 CellID->622554087],
Cell[237649, 4738, 191, 4, 70, "MoreAbout",
 CellID->245232039]
}, Open  ]],
Cell[237855, 4745, 27, 0, 70, "History"],
Cell[237885, 4747, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

