(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25730,        924]
NotebookOptionsPosition[     20649,        751]
NotebookOutlinePosition[     22019,        789]
CellTagsIndexPosition[     21934,        784]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Testing and Searching List Elements" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TestingAndSearchingListElements"], 
          "Finding Expressions That Match a Pattern" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FindingExpressionsThatMatchAPattern"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Testing and Searching List Elements\"\>", 
       2->"\<\"Finding Expressions That Match a Pattern\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BinCounts" :> Documentation`HelpLookup["paclet:ref/BinCounts"],
           "Cases" :> Documentation`HelpLookup["paclet:ref/Cases"], "FreeQ" :> 
          Documentation`HelpLookup["paclet:ref/FreeQ"], "MemberQ" :> 
          Documentation`HelpLookup["paclet:ref/MemberQ"], "Select" :> 
          Documentation`HelpLookup["paclet:ref/Select"], "Position" :> 
          Documentation`HelpLookup["paclet:ref/Position"], "StringCount" :> 
          Documentation`HelpLookup["paclet:ref/StringCount"], "Tally" :> 
          Documentation`HelpLookup["paclet:ref/Tally"], "Total" :> 
          Documentation`HelpLookup["paclet:ref/Total"], "LeafCount" :> 
          Documentation`HelpLookup["paclet:ref/LeafCount"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"BinCounts\"\>", 2->"\<\"Cases\"\>", 
       3->"\<\"FreeQ\"\>", 4->"\<\"MemberQ\"\>", 5->"\<\"Select\"\>", 
       6->"\<\"Position\"\>", 7->"\<\"StringCount\"\>", 8->"\<\"Tally\"\>", 
       9->"\<\"Total\"\>", 10->"\<\"LeafCount\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Discrete & Integer Data" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteAndIntegerData"], 
          "Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Math & Counting Operations on Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicalAndCountingOperationsOnLists"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "Pattern Matching Functions" :> 
          Documentation`HelpLookup["paclet:guide/PatternMatchingFunctions"], 
          "Rules & Patterns" :> 
          Documentation`HelpLookup["paclet:guide/RulesAndPatterns"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Discrete & Integer Data\"\>", 
       2->"\<\"Elements of Lists\"\>", 3->"\<\"Handling Arrays of Data\"\>", 
       4->"\<\"List Manipulation\"\>", 
       5->"\<\"Math & Counting Operations on Lists\"\>", 
       6->"\<\"Numerical Data\"\>", 7->"\<\"Pattern Matching Functions\"\>", 
       8->"\<\"Rules & Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Count", "ObjectName",
 CellID->5874],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Count",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Count"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["pattern", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the number of elements in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " that match ",
     Cell[BoxData[
      StyleBox["pattern", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Count",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Count"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["pattern", "TI"], ",", 
        StyleBox["levelspec", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the total number of subexpressions matching ",
     Cell[BoxData[
      StyleBox["pattern", "TI"]], "InlineFormula"],
     " that appear at the levels in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " specified by ",
     Cell[BoxData[
      StyleBox["levelspec", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->25774]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Count",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Count"]], "InlineFormula"],
 " uses standard level specifications:"
}], "Notes",
 CellID->7043],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["n", "TI"], Cell[TextData[{
     "levels ",
     Cell[BoxData["1"], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[TextData[{
     "levels ",
     Cell[BoxData["1"], "InlineFormula"],
     " through ",
     Cell[BoxData[
      ButtonBox["Infinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Infinity"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     StyleBox["n", "TI"], "}"}], Cell[TextData[{
     "level ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " only"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]}], "}"}], Cell[TextData[{
     "levels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->9429],

Cell[TextData[{
 "The default value for ",
 Cell[BoxData[
  StyleBox["levelspec", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["Count",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Count"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"{", "1", "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5536],

Cell[TextData[{
 "A positive level ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " consists of all parts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " specified by ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " indices."
}], "Notes",
 CellID->6763],

Cell[TextData[{
 "A negative level ",
 Cell[BoxData[
  RowBox[{"-", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " consists of all parts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with depth ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->20016],

Cell[TextData[{
 "Level ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 " consists of numbers, symbols and other objects that do not have subparts."
}], "Notes",
 CellID->21858],

Cell[TextData[{
 "Level ",
 Cell[BoxData["0"], "InlineFormula"],
 " corresponds to the whole expression."
}], "Notes",
 CellID->23934],

Cell[TextData[{
 "With the option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Heads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Heads"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Count",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Count"]], "InlineFormula"],
 " looks at heads of expressions and their parts."
}], "Notes",
 CellID->7301]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->109699646],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->68031792],

Cell[TextData[{
 "Count how many times ",
 Cell[BoxData["b"], "InlineFormula"],
 " occurs:"
}], "ExampleText",
 CellID->4676806],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Count", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "a", ",", "a", ",", "b", ",", "c", ",", "b"}],
     "}"}], ",", "b"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108286541],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->287948886]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15376],

Cell["Count works with patterns:", "ExampleText",
 CellID->912739045],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Count", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "a", ",", "2", ",", "a", ",", "a", ",", "1", ",", "c", ",", "b", ",", "3",
      ",", "3"}], "}"}], ",", "_Integer"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->397086737],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1196444]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26945843],

Cell[TextData[{
 "Count the number of elements not matching ",
 Cell[BoxData["b"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->64668646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Count", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "a", ",", "a", ",", "b", ",", "c", ",", "b", ",", "a",
      ",", "a"}], "}"}], ",", 
   RowBox[{"Except", "[", "b", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->170561005],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->125200406]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->278859213],

Cell[TextData[{
 "Count occurrences of ",
 Cell[BoxData["b"], "InlineFormula"],
 " down to level 2:"
}], "ExampleText",
 CellID->805133508],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Count", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "a", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "a"}], "}"}]}], "}"}], ",", "b", ",", "2"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->278016456],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->218777954]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11300],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Count",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Count"]], "InlineFormula"],
 " works with any head, not just ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->426787265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Count", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", "b", ",", "a"}], "]"}], ",", "b"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->343641540],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11733389]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20537],

Cell["Count the total number of symbols in an expression:", "ExampleText",
 CellID->785215061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Count", "[", 
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{
     RowBox[{"b", "^", "2"}], "/", 
     RowBox[{"(", 
      RowBox[{"a", "+", "b"}], ")"}]}]}], ",", "_Symbol", ",", "Infinity"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->66389610],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->93820240]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10139],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinCounts",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinCounts"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FreeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FreeQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MemberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MemberQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Select",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Select"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Position",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Position"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringCount"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tally",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tally"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Total",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Total"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LeafCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LeafCount"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12082]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2061],

Cell[TextData[ButtonBox["Testing and Searching List Elements",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TestingAndSearchingListElements"]], "Tutorials",\

 CellID->32655],

Cell[TextData[ButtonBox["Finding Expressions That Match a Pattern",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FindingExpressionsThatMatchAPattern"]], "Tutorials",
 CellID->3815]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->581441322],

Cell[TextData[ButtonBox["Discrete & Integer Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteAndIntegerData"]], "MoreAbout",
 CellID->404727390],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->1186074],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->1063471],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->273950103],

Cell[TextData[ButtonBox["Math & Counting Operations on Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalAndCountingOperationsOnLists"]], "MoreAbout",
 CellID->9790901],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout",
 CellID->137309056],

Cell[TextData[ButtonBox["Pattern Matching Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PatternMatchingFunctions"]], "MoreAbout",
 CellID->1655443],

Cell[TextData[ButtonBox["Rules & Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RulesAndPatterns"]], "MoreAbout",
 CellID->614009091]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Count - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 35, 32.0507260}", "context" -> "System`", 
    "keywords" -> {"number of occurrences"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Count[list, pattern] gives the number of elements in list that match \
pattern. Count[expr, pattern, levelspec] gives the total number of \
subexpressions matching pattern that appear at the levels in expr specified \
by levelspec. ", "synonyms" -> {}, "title" -> "Count", "type" -> "Symbol", 
    "uri" -> "ref/Count"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10182, 325, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->109699646]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21790, 777}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3958, 81, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4581, 108, 42, 1, 70, "ObjectName",
 CellID->5874],
Cell[4626, 111, 1395, 44, 70, "Usage",
 CellID->25774]
}, Open  ]],
Cell[CellGroupData[{
Cell[6058, 160, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6536, 177, 196, 7, 70, "Notes",
 CellID->7043],
Cell[6735, 186, 1663, 55, 70, "2ColumnTableMod",
 CellID->9429],
Cell[8401, 243, 333, 14, 70, "Notes",
 CellID->5536],
Cell[8737, 259, 302, 12, 70, "Notes",
 CellID->6763],
Cell[9042, 273, 312, 13, 70, "Notes",
 CellID->20016],
Cell[9357, 288, 189, 6, 70, "Notes",
 CellID->21858],
Cell[9549, 296, 134, 5, 70, "Notes",
 CellID->23934],
Cell[9686, 303, 459, 17, 70, "Notes",
 CellID->7301]
}, Closed]],
Cell[CellGroupData[{
Cell[10182, 325, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->109699646],
Cell[CellGroupData[{
Cell[10567, 339, 147, 5, 70, "ExampleSection",
 CellID->68031792],
Cell[10717, 346, 128, 5, 70, "ExampleText",
 CellID->4676806],
Cell[CellGroupData[{
Cell[10870, 355, 228, 7, 28, "Input",
 CellID->108286541],
Cell[11101, 364, 158, 5, 36, "Output",
 CellID->287948886]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11308, 375, 216, 7, 70, "ExampleSection",
 CellID->15376],
Cell[11527, 384, 69, 1, 70, "ExampleText",
 CellID->912739045],
Cell[CellGroupData[{
Cell[11621, 389, 261, 8, 70, "Input",
 CellID->397086737],
Cell[11885, 399, 156, 5, 36, "Output",
 CellID->1196444]
}, Open  ]],
Cell[12056, 407, 124, 3, 70, "ExampleDelimiter",
 CellID->26945843],
Cell[12183, 412, 143, 5, 70, "ExampleText",
 CellID->64668646],
Cell[CellGroupData[{
Cell[12351, 421, 288, 9, 70, "Input",
 CellID->170561005],
Cell[12642, 432, 158, 5, 36, "Output",
 CellID->125200406]
}, Open  ]],
Cell[12815, 440, 125, 3, 70, "ExampleDelimiter",
 CellID->278859213],
Cell[12943, 445, 139, 5, 70, "ExampleText",
 CellID->805133508],
Cell[CellGroupData[{
Cell[13107, 454, 385, 13, 70, "Input",
 CellID->278016456],
Cell[13495, 469, 158, 5, 36, "Output",
 CellID->218777954]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13702, 480, 239, 7, 70, "ExampleSection",
 CellID->11300],
Cell[13944, 489, 319, 12, 70, "ExampleText",
 CellID->426787265],
Cell[CellGroupData[{
Cell[14288, 505, 201, 7, 70, "Input",
 CellID->343641540],
Cell[14492, 514, 157, 5, 36, "Output",
 CellID->11733389]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14698, 525, 223, 7, 70, "ExampleSection",
 CellID->20537],
Cell[14924, 534, 94, 1, 70, "ExampleText",
 CellID->785215061],
Cell[CellGroupData[{
Cell[15043, 539, 277, 10, 70, "Input",
 CellID->66389610],
Cell[15323, 551, 157, 5, 36, "Output",
 CellID->93820240]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15541, 563, 311, 9, 70, "SeeAlsoSection",
 CellID->10139],
Cell[15855, 574, 2391, 89, 70, "SeeAlso",
 CellID->12082]
}, Open  ]],
Cell[CellGroupData[{
Cell[18283, 668, 313, 9, 70, "TutorialsSection",
 CellID->2061],
Cell[18599, 679, 179, 4, 70, "Tutorials",
 CellID->32655],
Cell[18781, 685, 188, 4, 70, "Tutorials",
 CellID->3815]
}, Open  ]],
Cell[CellGroupData[{
Cell[19006, 694, 319, 9, 70, "MoreAboutSection",
 CellID->581441322],
Cell[19328, 705, 157, 3, 70, "MoreAbout",
 CellID->404727390],
Cell[19488, 710, 142, 3, 70, "MoreAbout",
 CellID->1186074],
Cell[19633, 715, 153, 3, 70, "MoreAbout",
 CellID->1063471],
Cell[19789, 720, 145, 3, 70, "MoreAbout",
 CellID->273950103],
Cell[19937, 725, 188, 4, 70, "MoreAbout",
 CellID->9790901],
Cell[20128, 731, 139, 3, 70, "MoreAbout",
 CellID->137309056],
Cell[20270, 736, 160, 3, 70, "MoreAbout",
 CellID->1655443],
Cell[20433, 741, 144, 3, 70, "MoreAbout",
 CellID->614009091]
}, Open  ]],
Cell[20592, 747, 27, 0, 70, "History"],
Cell[20622, 749, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

