(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7317,        241]
NotebookOptionsPosition[      5470,        183]
NotebookOutlinePosition[      6557,        213]
CellTagsIndexPosition[      6514,        210]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Automatic Numbering" :> 
         Documentation`HelpLookup["paclet:ref/menuitem/AutomaticNumbering"], 
         "CounterAssignments" :> 
         Documentation`HelpLookup["paclet:ref/CounterAssignments"], 
         "CounterStyleMenuListing" :> 
         Documentation`HelpLookup["paclet:ref/CounterStyleMenuListing"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"Automatic Numbering\"\>", 
      2->"\<\"CounterAssignments\"\>", 
      3->"\<\"CounterStyleMenuListing\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CounterFunction", "ObjectName",
 CellID->2334],

Cell[TextData[{
 "This function has not been fully integrated into the long-term ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system, and is subject to change.  "
}], "AwaitingReviewNote",
 CellID->630456918],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["CounterFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/CounterFunction"]], "InlineFormula"],
     " \[LineSeparator]is an option for counters that specifies the symbols \
used to display the value of the counter."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30049]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Counters can be inserted using the ",
 StyleBox[ButtonBox["Insert",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InsertMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Automatic Numbering",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/AutomaticNumbering"], "MenuName"],
 " menu item."
}], "Notes",
 CellID->19094],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"CounterFunction", "->", 
   ButtonBox["Identity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Identity"]}]], "InlineFormula"],
 ", the value of the counter is displayed as an ordinary decimal number."
}], "Notes",
 CellID->28592],

Cell["\<\
You can also set the counter display to use symbols such as Roman numerals or \
Greek letters. Other possible formats include capital Roman numerals, capital \
Greek letters, lowercase letters, uppercase letters, days of the week, \
months, and circled numbers. To use any of these formats, choose the \
corresponding item from the popup menu next to the option.\
\>", "Notes",
 CellID->31270],

Cell[TextData[{
 "In the cell expression, these formats are implemented using the ",
 Cell[BoxData[
  ButtonBox["CharacterRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CharacterRange"]], "InlineFormula"],
 " function. This allows you to specify any arbitrary set of symbols or \
strings to use in the counter display. For example,"
}], "Notes",
 CellID->30119]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->153],

Cell[TextData[{
 StyleBox[ButtonBox["Automatic Numbering",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/AutomaticNumbering"], "MenuName",
  FontFamily->"Verdana"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CounterAssignments",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CounterAssignments"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CounterStyleMenuListing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CounterStyleMenuListing"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->173457838]
}, Open  ]],

Cell["New in 4.0", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CounterFunction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 35, 31.5038370}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CounterFunction is an option for counters that specifies the symbols \
used to display the value of the counter.", 
    "synonyms" -> {"counter function"}, "title" -> "CounterFunction", "type" -> 
    "Symbol", "uri" -> "ref/CounterFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 901, 20, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1524, 47, 52, 1, 70, "ObjectName",
 CellID->2334],
Cell[1579, 50, 218, 6, 70, "AwaitingReviewNote",
 CellID->630456918],
Cell[1800, 58, 494, 14, 70, "Usage",
 CellID->30049]
}, Open  ]],
Cell[CellGroupData[{
Cell[2331, 77, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2809, 94, 399, 11, 70, "Notes",
 CellID->19094],
Cell[3211, 107, 308, 9, 70, "Notes",
 CellID->28592],
Cell[3522, 118, 403, 7, 70, "Notes",
 CellID->31270],
Cell[3928, 127, 371, 9, 70, "Notes",
 CellID->30119]
}, Closed]],
Cell[CellGroupData[{
Cell[4336, 141, 309, 9, 70, "SeeAlsoSection",
 CellID->153],
Cell[4648, 152, 748, 24, 70, "SeeAlso",
 CellID->173457838]
}, Open  ]],
Cell[5411, 179, 29, 0, 70, "History"],
Cell[5443, 181, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

