(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   1240862,      25862]
NotebookOptionsPosition[   1193201,      24220]
NotebookOutlinePosition[   1194675,      24259]
CellTagsIndexPosition[   1194586,      24254]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Internet Connectivity" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/InternetConnectivity"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Mathematica Internet Connectivity\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CityData" :> Documentation`HelpLookup["paclet:ref/CityData"], 
          "FinancialData" :> 
          Documentation`HelpLookup["paclet:ref/FinancialData"], 
          "DateListPlot" :> 
          Documentation`HelpLookup["paclet:ref/DateListPlot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CityData\"\>", 
       2->"\<\"FinancialData\"\>", 
       3->"\<\"DateListPlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integrated Data Sources" :> 
          Documentation`HelpLookup["paclet:guide/DataCollections"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Integrated Data Sources\"\>", 
       2->"\<\"New in 6.0: Data Handling & Data Sources\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["CountryData", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CountryData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CountryData"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"tag\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the value of the specified property for the \
country, country-like entity, or group of countries specified by ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"tag\", \"TI\"]\)\>\""], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CountryData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CountryData"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"tag\", \"TI\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["property", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          StyleBox["dates", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives time series for certain economic and other \
properties."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CountryData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CountryData"], "[", "\"\<\!\(\*
StyleBox[\"tag\", \"TI\"]\)\>\"", "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " gives the standardized name for the country or country-like entity \
specified by ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"tag\", \"TI\"]\)\>\""], "InlineFormula"],
 ", or a list of standardized names if ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"tag\", \"TI\"]\)\>\""], "InlineFormula"],
 " corresponds to a group of countries."
}], "Notes",
 CellID->213623289],

Cell["\<\
Possible tags for individual countries include English and local names, short \
names, two-letter internet codes, Olympic codes, ISO codes, etc.\
\>", "Notes",
 CellID->535276832],

Cell["\<\
Tags can also specify political or economic groups of countries, as well as \
continents and oceans.\
\>", "Notes",
 CellID->292503973],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CountryData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CountryData"], "[", "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CountryData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CountryData"], "[", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"], "]"}]], "InlineFormula"],
 " gives the list of all ordinary countries and dependencies."
}], "Notes",
 CellID->187942252],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CountryData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CountryData"], "[", 
   StyleBox["patt", "TI"], "]"}]], "InlineFormula"],
 " gives a list of all country names that match the string pattern ",
 Cell[BoxData[
  StyleBox["patt", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->628766205],

Cell[TextData[{
 "With the following special tags ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CountryData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CountryData"], "[", "\"\<\!\(\*
StyleBox[\"tag\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " yields lists of tags:"
}], "Notes",
 CellID->74712364],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Countries\>\"", Cell[
    "ordinary countries and dependencies", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Continents\>\"", Cell[
    "continents", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Groups\>\"", Cell[TextData[{
     "groups of countries (e.g. ",
     Cell[BoxData["\"\<UN\>\""], "InlineFormula"],
     ", ",
     Cell[BoxData["\"\<G8\>\""], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Oceans\>\"", Cell[
    "oceans", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->24912190],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CountryData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CountryData"], "[", "\"\<Properties\>\"", "]"}]], 
  "InlineFormula"],
 " gives a list of all properties available for countries."
}], "Notes",
 CellID->54231339],

Cell[TextData[{
 "Properties that do not apply or are not known in a particular case are \
indicated by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Missing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Missing"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->48425469],

Cell["\<\
Numerical values that are known only to a certain precision are typically \
tagged with their precision, and given in arbitrary-precision form.\
\>", "Notes",
 CellID->286491208],

Cell["Basic properties for countries include:", "Notes",
 CellID->505403785],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Area\>\"", Cell[
    "land area in square kilometers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CapitalCity\>\"", Cell[
    "capital city specification", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Flag\>\"", Cell[
    "a graphic of the flag for the country", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GDP\>\"", Cell[
    "estimated gross domestic product in U.S. dollars", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Name\>\"", Cell[
    "English short country name", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Population\>\"", Cell[
    "estimated population", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Shape\>\"", Cell[
    "a graphic of the basic shape of the country", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->50744794],

Cell["Country name and identifier properties include:", "Notes",
 CellID->90192706],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AlternateNames\>\"", Cell[
    "alternate names and tags for the country", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CallingCode\>\"", Cell[
    "international telephone prefix code", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CountryCode\>\"", Cell[
    "two-letter ISO code", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FlagDescription\>\"", Cell[
    "textual description of the flag for the country", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Flag\>\"", Cell[
    "a graphic of the flag for the country", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FullName\>\"", Cell[
    "formal full English country name", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FullNativeName\>\"", Cell[
    "full name in native language", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<InternetCode\>\"", Cell[
    "two-letter internet top-level domain code", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ISOName\>\"", Cell[
    "full ISO country name", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Name\>\"", Cell[
    "standard English country name ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NationalityName\>\"", Cell[
    TextData[{
     "name of the country nationality (e.g. ",
     Cell[BoxData["\"\<American\>\""], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NativeName\>\"", Cell[
    "standard name in native language", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Regions\>\"", Cell[
    "administrative divisions of the country", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RegionNames\>\"", Cell[
    "English names for administrative divisions", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UNCode\>\"", Cell[
    "three-letter United Nations country code ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UNNumber\>\"", Cell[
    "United Nations country number", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True}}}},
 CellID->757848343],

Cell["Cartographic display properties include:", "Notes",
 CellID->73738441],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<FullPolygon\>\"", Cell[
    "polygon for all boundaries", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Polygon\>\"", Cell[
    "polygon for main boundaries", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SchematicPolygon\>\"", Cell[
    "polygon for schematic boundaries", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Shape\>\"", Cell[
    "a graphic of the basic shape of the country", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"spec\", \"TI\"]\)\>\"", ",", 
      StyleBox["proj", "TI"]}], "}"}], Cell[
    "use the specified cartographic projection", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->36641477],

Cell["\<\
Main boundaries exclude entities such as outlying islands and dependencies.\
\>", "Notes",
 CellID->996014769],

Cell["\<\
By default, coordinates are given as longitude-latitude pairs, corresponding \
to an equirectangular projection.\
\>", "Notes",
 CellID->49215383],

Cell["Available cartographic projections include:", "Notes",
 CellID->475627759],

Cell[BoxData[GridBox[{
   {Cell[" ", "TableRowIcon"], "\"\<Albers\>\"", Cell[
    "Albers equal-area conic projection", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<Albers\>\"", ",", 
      SubscriptBox[
       StyleBox["\[Phi]", "TR"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["\[Phi]", "TR"], 
       StyleBox["2", "TR"]]}], "}"}], Cell[TextData[{
     "Albers projection with standard parallels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["\[Phi]", "TR"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["\[Phi]", "TR"], 
       StyleBox["2", "TR"]]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Bonne\>\"", Cell[
    "Bonne projection", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<Bonne\>\"", ",", 
      SubscriptBox[
       StyleBox["\[Phi]", "TR"], 
       StyleBox["1", "TR"]]}], "}"}], Cell[TextData[{
     "Bonne projection with standard parallel ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["\[Phi]", "TR"], 
       StyleBox["1", "TR"]]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<CylindricalEqualArea\>\"", ",", 
      SubscriptBox[
       StyleBox["\[Phi]", "TR"], 
       StyleBox["s", "TI"]]}], "}"}], Cell[TextData[{
     "cylindrical equal-area projection with standard latitude ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["\[Phi]", "TR"], 
       StyleBox["s", "TI"]]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<CylindricalEquidistant\>\"", ",", 
      SubscriptBox[
       StyleBox["\[Phi]", "TR"], 
       StyleBox["s", "TI"]]}], "}"}], Cell[TextData[{
     "cylindrical equidistant projection with standard latitude ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["\[Phi]", "TR"], 
       StyleBox["s", "TI"]]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EckertIV\>\"", Cell[
    "Eckert IV projection", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EckertVI\>\"", Cell[
    "Eckert VI projection", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Equirectangular\>\"", Cell[
    "explicit longitude, latitude", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LambertAzimuthal\>\"", Cell[
    "Lambert azimuthal equal-area projection", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LambertConic\>\"", Cell[
    "Lambert conformal conic projection", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<LambertConic\>\"", ",", 
      SubscriptBox[
       StyleBox["\[Phi]", "TR"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["\[Phi]", "TR"], 
       StyleBox["2", "TR"]]}], "}"}], Cell[TextData[{
     "Lambert conic projection ",
     "with standard parallels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["\[Phi]", "TR"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["\[Phi]", "TR"], 
       StyleBox["2", "TR"]]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LambertCylindrical\>\"", Cell[
    "Lambert cylindrical equal-area projection", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Mercator\>\"", Cell[
    "Mercator cylindrical projection", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MillerCylindrical\>\"", Cell[
    "Miller cylindrical projection", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Mollweide\>\"", Cell[
    "homolographic Mollweide projection", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Orthographic\>\"", Cell[
    "orthographic projection", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Polyconic\>\"", Cell[
    "conic projection with two poles", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Robinson\>\"", Cell[
    "Robinson projection", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Sinusoidal\>\"", Cell[
    "equal-area pseudo-cylindrical projection", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VanDerGrinten\>\"", Cell[
    "van der Grinten projection", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<WinkelTripel\>\"", Cell[
    "Winkel Tripel projection", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->139305700],

Cell["\<\
The centering of cartographic projections is specified as follows:\
\>", "Notes",
 CellID->334325888],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"proj\", \"TI\"]\)\>\"", Cell[
    "use {0,0} as the center", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"proj\", \"TI\"]\)\>\"", ",", 
      ButtonBox["Center",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Center"]}], "}"}], Cell[
    "use the center of specified country as the center", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"proj\", \"TI\"]\)\>\"", ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["lat", "TI"], ",", 
        StyleBox["long", "TI"]}], "}"}]}], "}"}], Cell[
    "use the specified latitude and longitude (in degrees)", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->211222108],

Cell["Raw cartographic properties include:", "Notes",
 CellID->6643475],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Coordinates\>\"", Cell[
    "latitude, longitude lists for main boundaries", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FullCoordinates\>\"", Cell[
    "latitude, longitude lists for all boundaries", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SchematicCoordinates\>\"", Cell[
    "latitude, longitude lists for schematic boundaries", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->327168531],

Cell["Geographical properties include:", "Notes",
 CellID->344892175],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Area\>\"", Cell[
    "total country area in square kilometers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<BorderingCountries\>\"", Cell[
    "countries bordering by land", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<BordersLengths\>\"", Cell[
    "list of lengths of borders with other countries ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<BoundaryLength\>\"", Cell[
    "total large-scale boundary length in kilometers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CenterCoordinates\>\"", Cell[
    "latitude and longitude of geographical center", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CenterLocationLink\>\"", Cell[
    "URI for a map centered on the country", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CoastlineLength\>\"", Cell[
    "large-scale length of coastline in kilometers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Continent\>\"", Cell[
    "primary continent (by area) in which the country lies", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HighestElevation\>\"", Cell[
    "highest elevation in meters", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HighestPoint\>\"", Cell[
    "name and elevation of highest point", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LandArea\>\"", Cell[
    "country land area in square kilometers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LargestCities\>\"", Cell[
    "a list of largest cities", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LowestElevation\>\"", Cell[
    "lowest elevation in meters", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LowestPoint\>\"", Cell[
    "name and elevation of lowest point", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MaritimeClaims\>\"", Cell[
    "claim types and distances from land in nautical miles", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<TimeZones\>\"", Cell[
    "current time zones relative to UTC", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<WaterArea\>\"", Cell[
    "approximate enclosed water area in square kilometers", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True}}}},
 CellID->237093512],

Cell["\<\
Properties related to natural resources and features include:\
\>", "Notes",
 CellID->666703082],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ArableLandArea\>\"", Cell[
    "arable land area in square kilometers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ArableLandFraction\>\"", Cell[
    "fraction of land area that is arable", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<ClimateTypes\>\"", Cell[
    "list of primary climate types", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CropsLandArea\>\"", Cell[
    "land area planted with crops in square kilometers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CropsLandFraction\>\"", Cell[
    "fraction of land area permanently planted with crops", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EnvironmentalIssues\>\"", Cell[
    "list of primary environmental issues", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<IrrigatedLandArea\>\"", Cell[
    "irrigated land area in square kilometers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<IrrigatedLandFraction\>\"", Cell[
    "fraction of land area that is irrigated", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NaturalHazards\>\"", Cell[
    "list of primary natural hazards", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NaturalResources\>\"", Cell[
    "list of primary natural resources", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<TerrainTypes\>\"", Cell[
    "list of primary terrain types", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, 
      True}}}},
 CellID->483492826],

Cell["Culture-related properties include:", "Notes",
 CellID->184994300],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<EthnicGroups\>\"", Cell[
    "common ethnic groups", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EthnicGroupsFractions\>\"", Cell[
    "ethnic groups and fractions of population", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FemaleLiteracyFraction\>\"", Cell[
    "fraction of adult female population able to read and write", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Languages\>\"", Cell[
    "primary languages commonly spoken", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LanguagesFractions\>\"", Cell[
    "primary languages and fractions of population", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LiteracyFraction\>\"", Cell[
    "fraction of adult population able to read and write ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MaleLiteracyFraction\>\"", Cell[
    "fraction of adult male population able to read and write ", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Religions\>\"", Cell[
    "religions commonly practiced", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ReligionsFractions\>\"", Cell[
    "religions and fractions of population", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True, True}}}},
 CellID->11666219],

Cell["Demographic properties include:", "Notes",
 CellID->9164254],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AdultPopulation\>\"", Cell[
    "estimated population aged 15 to 64", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AnnualBirths\>\"", Cell[
    "estimated total number of births per year", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AnnualDeaths\>\"", Cell[
    "estimated total number of deaths per year", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<BirthRateFraction\>\"", Cell[
    "average number of births per person per year", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ChildPopulation\>\"", Cell[
    "estimated population aged below 15", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DeathRateFraction\>\"", Cell[
    "average number of deaths per person per year", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ElderlyPopulation\>\"", Cell[
    "estimated population aged above 65", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FemaleAdultPopulation\>\"", Cell[
    "estimated female population aged 15 to 64", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FemaleChildPopulation\>\"", Cell[
    "estimated female population aged below 15", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FemaleElderlyPopulation\>\"", Cell[
    "estimated female population aged above 65", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FemaleLifeExpectancy\>\"", Cell[
    "female life expectancy in years", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FemaleMedianAge\>\"", Cell[
    "median age of female population in years", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FemalePopulation\>\"", Cell[
    "estimated female population", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LifeExpectancy\>\"", Cell[
    "average life expectancy in years", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MaleAdultPopulation\>\"", Cell[
    "estimated male population aged 15 to 64", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MaleChildPopulation\>\"", Cell[
    "estimated male population aged below 15", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MaleElderlyPopulation\>\"", Cell[
    "estimated male population aged above 65", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MaleLifeExpectancy\>\"", Cell[
    "male life expectancy in years", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MaleMedianAge\>\"", Cell[
    "median age of male population in years", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MalePopulation\>\"", Cell[
    "estimated male population", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MedianAge\>\"", Cell[
    "median age of population in years", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MigrationRateFraction\>\"", Cell[
    "average net migration per person per year", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Population\>\"", Cell[
    "estimated population", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PopulationGrowth\>\"", Cell[
    "annual fractional growth in estimated population", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<TotalFertilityRate\>\"", Cell[
    "lifetime total average number of births per woman ", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, None, None, None, None, None, None, None, None, {
     None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True}}}},
 CellID->318218454],

Cell["Public health properties include:", "Notes",
 CellID->11612530],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AnnualHIVAIDSDeaths\>\"", Cell[
    "recent number of deaths per year from AIDS", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FemaleInfantMortalityFraction\>\"", 
    Cell["fraction of female births with infant mortality", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HIVAIDSDeathRateFraction\>\"", Cell[
    "average number of AIDS deaths per year", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HIVAIDSFraction\>\"", Cell[
    "fraction of population infected with HIV", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HIVAIDSPopulation\>\"", Cell[
    "total population infected with HIV", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<InfantMortalityFraction\>\"", Cell[
    "fraction of births with infant mortality", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<InfectiousDiseases\>\"", Cell[
    "list of major infectious diseases", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MaleInfantMortalityFraction\>\"", 
    Cell["fraction of male births with infant mortality", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->48675566],

Cell["Military-related properties include:", "Notes",
 CellID->238021233],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<MilitaryAgeFemales\>\"", Cell[
    "total number of females of military age", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MilitaryAgeMales\>\"", Cell[
    "total number of males of military age", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MilitaryAgePopulation\>\"", Cell[
    "total population of military age", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MilitaryAgeRate\>\"", Cell[
    "total population reaching military age each year", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MilitaryExpenditureFraction\>\"", 
    Cell["military expenditure as a fraction of GDP", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MilitaryExpenditures\>\"", Cell[
    "total military expenditures in U.S. dollars", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MilitaryFitFemales\>\"", Cell[
    "total females considered fit for military service", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MilitaryFitMales\>\"", Cell[
    "total males considered fit for military service", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MilitaryFitPopulation\>\"", Cell[
    "total population considered fit for military service", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True, True}}}},
 CellID->18882649],

Cell["Economic-related properties include:", "Notes",
 CellID->630533524],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AgriculturalProducts\>\"", Cell[
    "major agricultural products", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GDP\>\"", Cell[
    "GDP in U.S. dollars at official exchange rate", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GDPAtParity\>\"", Cell[
    "GDP in U.S. dollars at purchasing power parity", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GDPPerCapita\>\"", Cell[
    "GDP normalized by population", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GDPRealGrowth\>\"", Cell[
    "annual growth in real GDP", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GiniIndex\>\"", Cell[
    "Gini index of income inequality", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GovernmentDebt\>\"", Cell[
    "outstanding government debt in U.S. dollars", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GovernmentExpenditures\>\"", Cell[
    "annual government expenditures in U.S. dollars", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GovernmentReceipts\>\"", Cell[
    "annual government receipts in U.S. dollars", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GovernmentSurplus\>\"", Cell[
    "annual government surplus in U.S. dollars", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<IndustrialProductionGrowth\>\"", 
    Cell["annual change in industrial output", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<InflationRate\>\"", Cell[
    "annual fractional change in consumer prices", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LaborForce\>\"", Cell[
    "size of adult labor force, whether employed or not", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MajorIndustries\>\"", Cell[
    "list of major industries", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NationalIncome\>\"", Cell[
    "national income in U.S. dollars at official exchange rate", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PovertyFraction\>\"", Cell[
    "fraction of population below official poverty line", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PriceIndex\>\"", Cell[
    "general price index relative to the current year", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SectorLaborFractions\>\"", Cell[
    "fractions of labor force in different sectors", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnemploymentFraction\>\"", Cell[
    "fraction of labor force unemployed", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True}}}},
 CellID->353261256],

Cell["\<\
Properties related to components of GDP include (by default all values are in \
U.S. dollars):\
\>", "Notes",
 CellID->292247816],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AgriculturalValueAdded\>\"", Cell[
    "value added by agricultural activities", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ConstructionValueAdded\>\"", Cell[
    "value added by construction and real estate activities", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ExpenditureFractions\>\"", Cell[
    "fractions of components of expenditure", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FixedInvestment\>\"", Cell[
    "investment in fixed capital", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GDPSectorFractions\>\"", Cell[
    "major sector portions of production", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GovernmentConsumption\>\"", Cell[
    "annual government consumption", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GrossInvestment\>\"", Cell[
    "gross investment", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HouseholdConsumption\>\"", Cell[
    "annual household consumption", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<IndustrialValueAdded\>\"", Cell[
    "value added by all industrial activities", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<InventoryChange\>\"", Cell[
    "annual change in the value of inventories", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ManufacturingValueAdded\>\"", Cell[
    "value added by manufacturing industries", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MiscellaneousValueAdded\>\"", Cell[
    "value added by miscellaneous service and other activities", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<TotalConsumption\>\"", Cell[
    "total consumption expenditure", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<TradeValueAdded\>\"", Cell[
    "value added by wholesale and retail trade", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<TransportationValueAdded\>\"", Cell[
    "value added by transportation and communications", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True}}}},
 CellID->200034761],

Cell["Trade-related properties include:", "Notes",
 CellID->239883574],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ExportCommodities\>\"", Cell[
    "major commodities exported", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ExportPartners\>\"", Cell[
    "major countries exported to", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ExportPartnersFractions\>\"", Cell[
    "major export partners and fractions", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ExportValue\>\"", Cell[
    "total estimated value of annual exports in U.S. dollars", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ImportCommodities\>\"", Cell[
    "major commodities imported", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ImportPartners\>\"", Cell[
    "major countries imported from", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ImportPartnersFractions\>\"", Cell[
    "major import partners and fractions", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ImportValue\>\"", Cell[
    "total estimated value of annual imports in U.S. dollars", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CurrentAccountBalance\>\"", Cell[
    "current account trade balance in U.S. dollars", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ForeignExchangeReserves\>\"", Cell[
    "government reserves of currency and gold in U.S. dollars", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ExternalDebt\>\"", Cell[
    "total government foreign currency debt, in U.S. dollars ", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EconomicAid\>\"", Cell[
    "net inflow of economic aid, in U.S. dollars", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, {None}},
    "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True}}}},
 CellID->680416868],

Cell["\<\
Properties whose values are given in terms of currency allow the following \
alternative forms:\
\>", "Notes",
 CellID->650627073],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"prop\", \"TI\"]\)\>\"", ",", "\"\<USDollars\>\""}], "}"}], Cell[
    "nominal value in U.S. dollars (default)", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"prop\", \"TI\"]\)\>\"", ",", "\"\<Local\>\""}], "}"}], Cell[
    "nominal value in local currency", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"prop\", \"TI\"]\)\>\"", ",", "\"\<Adjusted\>\""}], "}"}], Cell[
    "adjusted to give a real value in current U.S. dollars ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"prop\", \"TI\"]\)\>\"", ",", "\"\<LocalAdjusted\>\""}], "}"}], 
    Cell["adjusted to give a real value in current local currency", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"prop\", \"TI\"]\)\>\"", ",", 
      StyleBox["curr", "TI"], ",", 
      StyleBox["y", "TI"]}], "}"}], Cell[TextData[{
     "value in year ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " currency"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->296415807],

Cell["Currency-related properties include:", "Notes",
 CellID->3185618],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<CurrencyCode\>\"", Cell[
    "standard currency code (e.g. \"USD\", \"GBP\")", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CurrencyName\>\"", Cell[
    "English currency name (e.g. \"U.S. dollars\")", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CurrencyShortName\>\"", Cell[
    "short currency name (e.g. \"Dollars\", \"Pesos\")", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CurrencyUnit\>\"", Cell[
    "currency unit (e.g. \"USDollars\") ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ExchangeRate\>\"", Cell[
    "currency units per U.S. dollar", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->652332835],

Cell["Energy-related properties include:", "Notes",
 CellID->378430503],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ElectricityConsumption\>\"", Cell[
    "annual electricity consumption in kilowatt hours", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ElectricityExports\>\"", Cell[
    "annual electricity exports in kilowatt hours", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ElectricityImports\>\"", Cell[
    "annual electricity imports in kilowatt hours", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ElectricityProduction\>\"", Cell[
    "annual electricity output in kilowatt hours", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NaturalGasConsumption\>\"", Cell[
    "annual natural gas consumption in cubic meters", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NaturalGasExports\>\"", Cell[
    "annual natural gas exports in cubic meters", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NaturalGasImports\>\"", Cell[
    "annual natural gas imports in cubic meters", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NaturalGasProduction\>\"", Cell[
    "annual natural gas production in cubic meters", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NaturalGasReserves\>\"", Cell[
    "natural gas reserves in cubic meters", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<OilConsumption\>\"", Cell[
    "oil consumption in barrels per day", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<OilExports\>\"", Cell[
    "oil exports in barrels per day", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<OilImports\>\"", Cell[
    "oil imports in barrels per day", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<OilProduction\>\"", Cell[
    "oil production in barrels per day", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<OilReserves\>\"", Cell[
    "estimated oil reserves in barrels", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True}}}},
 CellID->636640732],

Cell["Electrical grid properties include:", "Notes",
 CellID->91467005],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ElectricalGridFrequency\>\"", Cell[
    "electrical grid frequency in hertz", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ElectricalGridPlugImages\>\"", Cell[
    "images of standard electrical plugs used", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ElectricalGridPlugs\>\"", Cell[
    "standard electrical plug types used", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ElectricalGridSocketImages\>\"", 
    Cell["images of standard electrical sockets used", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ElectricalGridSockets\>\"", Cell[
    "standard electrical socket types used", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ElectricalGridVoltages\>\"", Cell[
    "list of standard electrical grid voltages", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->111001963],

Cell["Governmental-related properties include:", "Notes",
 CellID->623051097],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<CapitalCity\>\"", Cell[
    "capital city specification", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Dependencies\>\"", Cell[
    "entities identifying themselves as dependencies", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DependencyParent\>\"", Cell[
    "country (if any) of which this is a dependency", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FiscalYearDate\>\"", Cell[
    "date of beginning of fiscal year", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<IndependenceYear\>\"", Cell[
    "claimed year of independence", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Regions\>\"", Cell[
    "administrative divisions of the country", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SuffrageType\>\"", Cell[
    "voting eligibility", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->176589035],

Cell["International relations properties include:", "Notes",
 CellID->97909574],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<EnvironmentalAgreements\>\"", Cell[
    "environmental agreements in force for the country", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<InternationalOrganizations\>\"", 
    Cell["organizations in which the country is a member", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SignedEnvironmentalAgreements\>\"", 
    Cell["agreements signed by the country, ratified or not", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->559222342],

Cell["Communications-related properties include:", "Notes",
 CellID->92844320],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<PhoneLines\>\"", Cell[
    "number of telephone land lines in use", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CellularPhones\>\"", Cell[
    "number of cellular phones in use", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CallingCode\>\"", Cell[
    "international telephone prefix code", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RadioStations\>\"", Cell[
    "total number of public radio stations", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AMRadioStations\>\"", Cell[
    "number of AM broadcast radio stations", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FMRadioStations\>\"", Cell[
    "number of FM broadcast radio stations", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ShortWaveRadioStations\>\"", Cell[
    "number of shortwave broadcast radio stations", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<TelevisionStations\>\"", Cell[
    "number of broadcast television stations", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<InternetCode\>\"", Cell[
    "two-letter internet top-level domain code", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<InternetHosts\>\"", Cell[
    "estimated number of internet hosts", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<InternetUsers\>\"", Cell[
    "estimated number of internet users", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, 
      True}}}},
 CellID->833439306],

Cell["Transportation-related properties include:", "Notes",
 CellID->57438332],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Airports\>\"", Cell[
    "total number of airports", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PavedAirports\>\"", Cell[
    "total number of paved airports", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnpavedAirports\>\"", Cell[
    "total number of unpaved airports", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PavedAirportLengths\>\"", Cell[
    "numbers of paved airports in length bins", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnpavedAirportLengths\>\"", Cell[
    "numbers of unpaved airports in length bins", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RoadLength\>\"", Cell[
    "total length of all roads in kilometers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PavedRoadLength\>\"", Cell[
    "total length of paved roads in kilometers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnpavedRoadLength\>\"", Cell[
    "total length of unpaved roads in kilometers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<WaterwayLength\>\"", Cell[
    "total length of navigable waterways in kilometers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MajorPorts\>\"", Cell[
    "names of major ports", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RailwayLength\>\"", Cell[
    "total length of railways in kilometers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RailwayGaugeLengths\>\"", Cell[
    "lengths of railways by gauge in kilometers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RailwayGaugeRules\>\"", Cell[
    "rules for railways gauges in meters", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MerchantShips\>\"", Cell[
    "total merchant ships above 1000 gross tons ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MerchantShipTypes\>\"", Cell[
    "type and number of merchant ships above 1000 tons", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MerchantShipsGross\>\"", Cell[
    "total gross tonnage for merchant ships above 1000 tons", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MerchantShipsDeadWeight\>\"", Cell[
    "total dead weight for merchant ships above 1000 tons", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ForeignRegisteredShips\>\"", Cell[
    "merchant ships owned in country but registered elsewhere", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ForeignOwnedShips\>\"", Cell[
    "merchant ships registered in country but owned elsewhere", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Pipelines\>\"", Cell[
    "type and total kilometer length of pipelines", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True}}}},
 CellID->647909340],

Cell[TextData[{
 "For properties available for multiple years, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CountryData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CountryData"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"tag\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["property", "TI"], ",", 
      StyleBox["y", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 " gives the value of the property for year ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->25055888],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CountryData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CountryData"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"tag\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["property", "TI"], ",", 
      ButtonBox["All",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/All"]}], "}"}]}], "]"}]], "InlineFormula"],
 " gives the dates and values for all available years. "
}], "Notes",
 CellID->44610353],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CountryData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CountryData"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"tag\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["property", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["2", "TR"]]}], "}"}]}], "}"}]}], "]"}]], "InlineFormula"],
 " gives the dates and values for years from ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["y", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " through ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["y", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 "."
}], "Notes",
 CellID->45622568],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CountryData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CountryData"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"property\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"ann\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " gives various annotations associated with a property. Typical annotations \
include:"
}], "Notes",
 CellID->276644756],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Date\>\"", Cell[
    "date to which the data refers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DateValue\>\"", Cell[TextData[{
     "lists of the form ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["date", "TI"], ",", 
        StyleBox["value", "TI"]}], "}"}]], "InlineFormula"],
     " for each year"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Description\>\"", Cell[
    "a textual description of the property", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Note\>\"", Cell[
    "special note about the property given", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Units\>\"", Cell[
    "units in which the value is given", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnitsName\>\"", Cell[
    "English name for the units used", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnitsNotation\>\"", Cell[
    "notation for the units used", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnitsStandardName\>\"", Cell[
    TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " standard name for the units used"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->469751789],

Cell[TextData[{
 "Use of ",
 Cell[BoxData[
  ButtonBox["CountryData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CountryData"]], "InlineFormula"],
 " may require internet connectivity."
}], "Notes",
 CellID->94188222]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->618285734],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(8)", "ExampleCount"]
}], "ExampleSection",
 CellID->86959528],

Cell["Find the population of France:", "ExampleText",
 CellID->12285923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<France\>\"", ",", "\"\<Population\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->44403061],

Cell[BoxData["6.2312148`*^7"], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2095777485]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->485260917],

Cell["Find the members of the G8:", "ExampleText",
 CellID->463296105],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", "\"\<G8\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->326795755],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Canada\"\>", ",", "\<\"France\"\>", ",", "\<\"Germany\"\>", 
   ",", "\<\"Italy\"\>", ",", "\<\"Japan\"\>", ",", "\<\"Russia\"\>", 
   ",", "\<\"UnitedKingdom\"\>", ",", "\<\"UnitedStates\"\>"}], 
  "}"}]], "Output",
 ImageSize->{517, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->705412301]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->120851259],

Cell["Find the GDPs of members of the G8:", "ExampleText",
 CellID->542627797],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CountryData", "[", 
    RowBox[{"#", ",", "\"\<GDP\>\""}], "]"}], "&"}], "/@", 
  RowBox[{"CountryData", "[", "\"\<G8\>\"", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->163575984],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.1317597770741843`*^12", ",", "2.1265776254725664`*^12", ",", 
   "2.794856489081232`*^12", ",", "1.7624749651606726`*^12", ",", 
   "4.558949854127995`*^12", ",", "7.659680383768098`*^11", ",", 
   "2.1987957539265283`*^12", ",", "1.24558`*^13"}], "}"}]], "Output",
 ImageSize->{391, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1754811467]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->41250271],

Cell["Logarithmic rank plot of populations of all countries:", "ExampleText",
 CellID->543725067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"Reverse", "[", 
   RowBox[{"Sort", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"CountryData", "[", 
       RowBox[{"#", ",", "\"\<Population\>\""}], "]"}], "&"}], "/@", 
     RowBox[{"CountryData", "[", "]"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->120293051],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWOtLFUEUX+/uffiozFeSVBZRVERWUETlvXZTybJMkIieZoIipZkGFUVB
9LAkIntdraQs6LNiX4W+1Ke+9rl/ZJuZMzs7e/bser23QIqce2fm/H7nzHnM
2butnUM93Zc6h3q7OmubBzsHenq7rtY29Q+yJbPAMIwZ9ne12mDfbfZN/M3Y
Nvv0j9vYaDIBk31G2OcKOY/IubNeKdcNS8DkP2e3gn1aBKpaCO/gIwdLaESb
86+c27DcuVeCQpSjuTmPfBkfomqfkAq0axFYX75gDYvF8oqQ/WC762zInojP
vhW5WewiApmrcrbUyStF9bf87OM1fTxCLqavZMcP1m/XvOHUvl69eu1HZOnr
8pUB8lD1+i2D8+YdufpGzD9N/UzufzP65BtYbZSycUrcNljeQnMzz/3/je+v
6E/oWfjj++/+y9NfZ3+xxQKbiuHqPOcrSVY6X9xVvjifzGJbfW17s90MkTrR
8ZlJNaYnQqXc6NBSr5BGK0TK1Rgm9fDBHJMauDwdIPWSDxZoBDpa7gUfokou
lczwU4TIWkdaJrlsPReMknJjXt3phkyMlHtO6g6RtcA3IBgPltO8k1BS/H4c
Qx6GXe+TlXPHFpPMbqQB6+9n+MZPoPkzr3dYOhTmxQSngQPlxwReO9wyyY4X
yuTrjzxmnO6pN6LSy0UL5tJtA06ZdSpLgFOWm+H0aKdHcjVRxDPKh5huW0rk
sIgz8Gl9G1sxSlpRIqSLpWaMeSw0Dg/NIo1LQlEjfjuFsqUCVYKkcSd5hNGZ
9raPDL3MpqrlgU8X1PVyUvq+7d5i7L8R4YPJylvul5Koe2KuvCBRqf2ZM6e/
cB+Wkag7SFcUUMI6vlVOom4jlCWHTGvLJKirJHE3SRyz8WB6AvxXHYJTFeg7
Ww2JusGHOHjkYMM406HMM1aRiGuEfWtJyWEkacJQnxl5OMe3aknUIIXynH8d
iRug/GbCUfjWehLVT+YR09bU+JaZaWwkUX2kLtfXmxSKV1Ufyjps2WYhnd3N
38uHhF4lzC2Hmt6BuVvt3O7ci+R53EjV5cjbRVYOHDsf3gt8KPTcSyI/lCOM
nVkyO7ceXzpH5kJSRXV3FpwGoQM/UZ+lMly7u0BPUD/x6sad5RTKNdN36+wR
wKJ5mU6SOeFm7V7FYxKd4wSyI+LYoUJUL/A4v7EV7ciKGLp7U4KlRPoHo1uR
FQmfNw7YVH03I1yRSF5IMHUNGY0kNoUsLpZmZwCrzt9CovchdCEf4jra1X+M
ZNhFMiish6GDZKijTmDptp8mcVsQTngtxioz3TCeTo0r9HkSvQH5HOxWde3p
TN0kwzqkX0Q75of3keg1CB0NiNsVEl1D5amna10jcVVkhurWXidx5QgX98Xo
FokrpaqaOOVdEr0EaVXPNCy8cMr7CsfrsYSSN938E0+IWXa+BLJc3WzK5id2
bt3EoiJvqsdVeOrPkte9hdwnMROd+tkC+EynEcTBvkPN7z19bixLLvV07/mN
wyIjrWtIOt3nZRaMgV3ORTBzLdTXgHnhfY1Ruf1D1YV42+H95SLfgepvBcbt
kG4nfdF29ENSvBowJuaThiC0H5/icZzwW8BR6if9W1vVEF9XP9e19X/5hikJ
73f8qyzWxCo/P1qVbxfCtBkFfwBZbg9b\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->195630913]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->45215624],

Cell["\<\
A log-log scatter plot of GDP against population for all countries, with \
tooltips for country name:\
\>", "ExampleText",
 CellID->279352469],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogLogPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Tooltip", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"CountryData", "[", 
         RowBox[{"#", ",", "\"\<Population\>\""}], "]"}], ",", 
        RowBox[{"CountryData", "[", 
         RowBox[{"#", ",", "\"\<GDP\>\""}], "]"}]}], "}"}], ",", 
      RowBox[{"CountryData", "[", 
       RowBox[{"#", ",", "\"\<Name\>\""}], "]"}]}], "]"}], "&"}], "/@", 
   RowBox[{"CountryData", "[", "\"\<Countries\>\"", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->634141703],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJwVl3k8Fd8fxrNlL4UkbdbL5d47d5u74NvTIkVR0oIkS9L2JaHFUiiFQkWS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      "]]}, {}}, {
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{17.212130981314573`, 22.5956575541734}}]},
      "\"Afghanistan\""],
     Annotation[#, "Afghanistan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.956440681824938`, 22.867737446294747`}}]},
      "\"Albania\""],
     Annotation[#, "Albania", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{17.307577912650185`, 25.350753025761147`}}]},
      "\"Algeria\""],
     Annotation[#, "Algeria", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.964640243043856`, 19.62605256919201}}]},
      "\"American Samoa\""],
     Annotation[#, "American Samoa", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.111477278219999`, 21.851729301496437`}}]},
      "\"Andorra\""],
     Annotation[#, "Andorra", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.55570837571923, 24.08546587234704}}]},
      "\"Angola\""],
     Annotation[#, "Angola", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9.40960098282706, 18.86989482989382}}]},
      "\"Anguilla\""],
     Annotation[#, "Anguilla", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.296236040895817`, 20.355218142344146`}}]},
      "\"Antigua and Barbuda\""],
     Annotation[#, "Antigua and Barbuda", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{17.472567711055017`, 25.934442185357234`}}]},
      "\"Argentina\""],
     Annotation[#, "Argentina", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.919545451035441`, 22.305952366172924`}}]},
      "\"Armenia\""],
     Annotation[#, "Armenia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.507591263379526`, 21.537542403190084`}}]},
      "\"Aruba\""],
     Annotation[#, "Aruba", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.818969354909843`, 27.287749555008592`}}]},
      "\"Australia\""],
     Annotation[#, "Australia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.918356565856893`, 26.447064148089062`}}]},
      "\"Austria\""],
     Annotation[#, "Austria", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.945027271171163`, 23.253868239293602`}}]},
      "\"Azerbaijan\""],
     Annotation[#, "Azerbaijan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.685602629625338`, 22.49303528828285}}]},
      "\"the Bahamas\""],
     Annotation[#, "the Bahamas", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.496154795137436`, 23.314606549338702`}}]},
      "\"Bahrain\""],
     Annotation[#, "Bahrain", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{18.77008525422355, 24.88304853752111}}]},
      "\"Bangladesh\""],
     Annotation[#, "Bangladesh", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.50453143995317, 21.82063742292782}}]},
      "\"Barbados\""],
     Annotation[#, "Barbados", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.09330139820276, 24.109876094681198`}}]},
      "\"Belarus\""],
     Annotation[#, "Belarus", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.159146323329804`, 26.63896921782365}}]},
      "\"Belgium\""],
     Annotation[#, "Belgium", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.505198981866213`, 20.823156419761208`}}]},
      "\"Belize\""],
     Annotation[#, "Belize", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.9483569568629, 22.199787018789372`}}]},
      "\"Benin\""],
     Annotation[#, "Benin", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.069353423226037`, 22.131785483697605`}}]},
      "\"Bermuda\""],
     Annotation[#, "Bermuda", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.586796789238234`, 20.636886391604058`}}]},
      "\"Bhutan\""],
     Annotation[#, "Bhutan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.032757237420988`, 22.99826896331148}}]},
      "\"Bolivia\""],
     Annotation[#, "Bolivia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.178299314221292`, 22.9350050859867}}]},
      "\"Bosnia and Herzegovina\""],
     Annotation[#, "Bosnia and Herzegovina", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.383619321124991`, 22.90370497192196}}]},
      "\"Botswana\""],
     Annotation[#, "Botswana", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{19.043431817164556`, 27.407144066280157`}}]},
      "\"Brazil\""],
     Annotation[#, "Brazil", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9.99952474073307, 20.694866362424712`}}]},
      "\"British Virgin Islands\""],
     Annotation[#, "British Virgin Islands", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.831527002032326`, 22.560641472198046`}}]},
      "\"Brunei\""],
     Annotation[#, "Brunei", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.860097292040194`, 23.997347648655456`}}]},
      "\"Bulgaria\""],
     Annotation[#, "Bulgaria", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.39783387946505, 22.409175663186375`}}]},
      "\"Burkina Faso\""],
     Annotation[#, "Burkina Faso", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.836728927974207`, 20.55442538597983}}]},
      "\"Burundi\""],
     Annotation[#, "Burundi", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.45962749472406, 22.40916495405134}}]},
      "\"Cambodia\""],
     Annotation[#, "Cambodia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.60801605539688, 23.54601202713092}}]},
      "\"Cameroon\""],
     Annotation[#, "Cameroon", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{17.289594115691198`, 27.754794862124378`}}]},
      "\"Canada\""],
     Annotation[#, "Canada", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.13588553948843, 20.760322744261487`}}]},
      "\"Cape Verde\""],
     Annotation[#, "Cape Verde", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.714795475190176`, 21.188716196101584`}}]},
      "\"Cayman Islands\""],
     Annotation[#, "Cayman Islands", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.211197421112434`, 21.004654212226423`}}]},
      "\"Central African Republic\""],
     Annotation[#, "Central African Republic", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.09266819593737, 22.321056060598508`}}]},
      "\"Chad\""],
     Annotation[#, "Chad", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.60637512982304, 25.435846275557644`}}]},
      "\"Chile\""],
     Annotation[#, "Chile", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{20.98021975647255, 28.314949886693018`}}]},
      "\"China\""],
     Annotation[#, "China", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{17.635423625347492`, 25.526282152437044`}}]},
      "\"Colombia\""],
     Annotation[#, "Colombia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.589741061873003`, 19.7566545007276}}]},
      "\"Comoros\""],
     Annotation[#, "Comoros", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9.795568210316635, 19.025846480092312`}}]},
      "\"Cook Islands\""],
     Annotation[#, "Cook Islands", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.280437710215406`, 23.709837026149}}]},
      "\"Costa Rica\""],
     Annotation[#, "Costa Rica", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.330931813632287`, 24.332748986743187`}}]},
      "\"Croatia\""],
     Annotation[#, "Croatia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.23760164591195, 24.57196305947128}}]},
      "\"Cuba\""],
     Annotation[#, "Cuba", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.521787609439334`, 23.54004427095025}}]},
      "\"Cyprus\""],
     Annotation[#, "Cyprus", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.139818296584156`, 25.530111052330433`}}]},
      "\"Czech Republic\""],
     Annotation[#, "Czech Republic", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{17.868142868393573`, 22.698988599100414`}}]},
      "\"Democratic Republic of the Congo\""],
     Annotation[#, "Democratic Republic of the Congo", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.507558341624467`, 26.27900542961951}}]},
      "\"Denmark\""],
     Annotation[#, "Denmark", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.58367685643563, 20.37421417044102}}]},
      "\"Djibouti\""],
     Annotation[#, "Djibouti", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.276443349216837`, 19.459516816238448`}}]},
      "\"Dominica\""],
     Annotation[#, "Dominica", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.000989423715442`, 24.094031933197154`}}]},
      "\"Dominican Republic\""],
     Annotation[#, "Dominican Republic", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.761121951722046`, 19.685939211793816`}}]},
      "\"East Timor\""],
     Annotation[#, "East Timor", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.39787833019577, 24.221655595664757`}}]},
      "\"Ecuador\""],
     Annotation[#, "Ecuador", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{18.12001993083999, 25.34240187939279}}]},
      "\"Egypt\""],
     Annotation[#, "Egypt", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.744267427101276`, 23.55529118702891}}]},
      "\"El Salvador\""],
     Annotation[#, "El Salvador", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.129376726277831`, 22.45502161716981}}]},
      "\"Equatorial Guinea\""],
     Annotation[#, "Equatorial Guinea", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.29742346043109, 20.797014016475305`}}]},
      "\"Eritrea\""],
     Annotation[#, "Eritrea", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.100461654694248`, 23.269756619909703`}}]},
      "\"Estonia\""],
     Annotation[#, "Estonia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{18.1648939265752, 22.952906823327968`}}]},
      "\"Ethiopia\""],
     Annotation[#, "Ethiopia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{7.995306620290822, 18.132998671500584`}}]},
      "\"Falkland Islands\""],
     Annotation[#, "Falkland Islands", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.763123273253704`, 20.72326583694641}}]},
      "\"Faroe Islands\""],
     Annotation[#, "Faroe Islands", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.650289156547148`, 21.821154391275602`}}]},
      "\"Fiji\""],
     Annotation[#, "Fiji", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.47355957091782, 25.986760109018935`}}]},
      "\"Finland\""],
     Annotation[#, "Finland", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{17.947666956723534`, 28.385535054840563`}}]},
      "\"France\""],
     Annotation[#, "France", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.203614627076458`, 21.162165721140813`}}]},
      "\"French Guiana\""],
     Annotation[#, "French Guiana", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.455285422443731`, 22.407450238651577`}}]},
      "\"French Polynesia\""],
     Annotation[#, "French Polynesia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.140373524166971`, 22.79254987097813}}]},
      "\"Gabon\""],
     Annotation[#, "Gabon", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.232297333441448`, 19.98881514242064}}]},
      "\"The Gambia\""],
     Annotation[#, "The Gambia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.172315393466732`, 20.459300291111948`}}]},
      "\"Gaza Strip\""],
     Annotation[#, "Gaza Strip", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.313883716463726`, 22.59348391619762}}]},
      "\"Georgia\""],
     Annotation[#, "Georgia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{18.230599679897722`, 28.65880187562927}}]},
      "\"Germany\""],
     Annotation[#, "Germany", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.911667410458502`, 23.064406035371736`}}]},
      "\"Ghana\""],
     Annotation[#, "Ghana", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.237385048784873`, 20.46060152746992}}]},
      "\"Gibraltar\""],
     Annotation[#, "Gibraltar", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.224246044580397`, 26.140257781452004`}}]},
      "\"Greece\""],
     Annotation[#, "Greece", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.939532708935408`, 20.818576016750736`}}]},
      "\"Greenland\""],
     Annotation[#, "Greenland", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.541746130778423`, 19.9345862296649}}]},
      "\"Grenada\""],
     Annotation[#, "Grenada", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.023152800932804`, 21.9797362102301}}]},
      "\"Guadeloupe\""],
     Annotation[#, "Guadeloupe", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.049529940423525`, 21.74319560358005}}]},
      "\"Guam\""],
     Annotation[#, "Guam", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.349132686593144`, 24.186595874322954`}}]},
      "\"Guatemala\""],
     Annotation[#, "Guatemala", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.088415142656158`, 21.674923712657858`}}]},
      "\"Guernsey\""],
     Annotation[#, "Guernsey", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.05644341382608, 21.841153745767695`}}]},
      "\"Guinea\""],
     Annotation[#, "Guinea", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.276942555514234`, 19.51182717968794}}]},
      "\"Guinea-Bissau\""],
     Annotation[#, "Guinea-Bissau", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.529451168250455`, 20.48259623944167}}]},
      "\"Guyana\""],
     Annotation[#, "Guyana", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.958839275890146`, 22.08012395142246}}]},
      "\"Haiti\""],
     Annotation[#, "Haiti", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.790247341152769`, 22.84841321038365}}]},
      "\"Honduras\""],
     Annotation[#, "Honduras", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.767244430460629`, 25.874524863038292`}}]},
      "\"Hong Kong\""],
     Annotation[#, "Hong Kong", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.127821303107773`, 25.416807111258876`}}]},
      "\"Hungary\""],
     Annotation[#, "Hungary", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.593241391355221`, 23.48416009304652}}]},
      "\"Iceland\""],
     Annotation[#, "Iceland", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{20.821635696607277`, 27.408855828010072`}}]},
      "\"India\""],
     Annotation[#, "India", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{19.22170197010543, 26.36260123528056}}]},
      "\"Indonesia\""],
     Annotation[#, "Indonesia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{18.057056077970586`, 26.101840255046863`}}]},
      "\"Iran\""],
     Annotation[#, "Iran", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{17.176135566725883`, 24.231207048719778`}}]},
      "\"Iraq\""],
     Annotation[#, "Iraq", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.238112981122917`, 26.030358338872933`}}]},
      "\"Ireland\""],
     Annotation[#, "Ireland", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.231106172786824`, 21.538630650230605`}}]},
      "\"Isle of Man\""],
     Annotation[#, "Isle of Man", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.721277648636692`, 25.588091793645127`}}]},
      "\"Israel\""],
     Annotation[#, "Israel", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{17.877551325899045`, 28.197740167367797`}}]},
      "\"Italy\""],
     Annotation[#, "Italy", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.714394153832774`, 23.543767571687166`}}]},
      "\"Ivory Coast\""],
     Annotation[#, "Ivory Coast", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.79033921837694, 23.032166901070966`}}]},
      "\"Jamaica\""],
     Annotation[#, "Jamaica", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{18.668201947042483`, 29.148113417785474`}}]},
      "\"Japan\""],
     Annotation[#, "Japan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.419537436648556`, 22.004199682408476`}}]},
      "\"Jersey\""],
     Annotation[#, "Jersey", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.556463631794085`, 23.25182977535526}}]},
      "\"Jordan\""],
     Annotation[#, "Jordan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.51183258545367, 24.750191286523066`}}]},
      "\"Kazakhstan\""],
     Annotation[#, "Kazakhstan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{17.34936417441202, 23.677327017437005`}}]},
      "\"Kenya\""],
     Annotation[#, "Kenya", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.506404247979964`, 18.087206670991467`}}]},
      "\"Kiribati\""],
     Annotation[#, "Kiribati", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.803888621873252`, 25.03021623311351}}]},
      "\"Kuwait\""],
     Annotation[#, "Kuwait", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.476362617482943`, 21.615730026259953`}}]},
      "\"Kyrgyzstan\""],
     Annotation[#, "Kyrgyzstan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.594546930775206`, 21.778217670388745`}}]},
      "\"Laos\""],
     Annotation[#, "Laos", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.651453335581895`, 23.447435456230256`}}]},
      "\"Latvia\""],
     Annotation[#, "Latvia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.089984136320469`, 23.776515112743954`}}]},
      "\"Lebanon\""],
     Annotation[#, "Lebanon", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.400386880815345`, 21.012031875684254`}}]},
      "\"Lesotho\""],
     Annotation[#, "Lesotho", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.004349521230392`, 20.144562656998062`}}]},
      "\"Liberia\""],
     Annotation[#, "Liberia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.582542130646154`, 24.338842896394276`}}]},
      "\"Libya\""],
     Annotation[#, "Libya", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.449323113491568`, 21.970811046202968`}}]},
      "\"Liechtenstein\""],
     Annotation[#, "Liechtenstein", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.04837193998145, 23.936667127975596`}}]},
      "\"Lithuania\""],
     Annotation[#, "Lithuania", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.049586211642522`, 24.319695188238022`}}]},
      "\"Luxembourg\""],
     Annotation[#, "Luxembourg", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.039333880379644`, 23.12044120223087}}]},
      "\"Macau\""],
     Annotation[#, "Macau", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.525544353680644`, 22.45508123042844}}]},
      "\"Macedonia\""],
     Annotation[#, "Macedonia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.738990421359457`, 22.322616365281313`}}]},
      "\"Madagascar\""],
     Annotation[#, "Madagascar", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.371491744403425`, 21.48417639826679}}]},
      "\"Malawi\""],
     Annotation[#, "Malawi", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{17.048185456181148`, 25.596707957031448`}}]},
      "\"Malaysia\""],
     Annotation[#, "Malaysia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.704414672432453`, 20.46127645884868}}]},
      "\"Maldives\""],
     Annotation[#, "Maldives", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.419563461952038`, 22.36835572560994}}]},
      "\"Mali\""],
     Annotation[#, "Mali", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.90328654576488, 22.44124220514707}}]},
      "\"Malta\""],
     Annotation[#, "Malta", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.034292711693084`, 18.524560896413092`}}]},
      "\"Marshall Islands\""],
     Annotation[#, "Marshall Islands", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.985697935918088`, 22.534337617206837`}}]},
      "\"Martinique\""],
     Annotation[#, "Martinique", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.936778263596926`, 21.23722257590157}}]},
      "\"Mauritania\""],
     Annotation[#, "Mauritania", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.034375368508838`, 22.56191681181693}}]},
      "\"Mauritius\""],
     Annotation[#, "Mauritius", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.21222368901468, 19.961411458376674`}}]},
      "\"Mayotte\""],
     Annotation[#, "Mayotte", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{18.4886137473108, 27.367625057701783`}}]},
      "\"Mexico\""],
     Annotation[#, "Mexico", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.612653145960163`, 19.294034229070128`}}]},
      "\"Micronesia\""],
     Annotation[#, "Micronesia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.251962481271992`, 21.793883286011056`}}]},
      "\"Moldova\""],
     Annotation[#, "Moldova", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.47030591100205, 20.908174009333976`}}]},
      "\"Monaco\""],
     Annotation[#, "Monaco", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.788743658119994`, 21.347803648947583`}}]},
      "\"Mongolia\""],
     Annotation[#, "Mongolia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.332608095300753`, 21.437187615185707`}}]},
      "\"Montenegro\""],
     Annotation[#, "Montenegro", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{8.409162447202533, 17.562833607948285`}}]},
      "\"Montserrat\""],
     Annotation[#, "Montserrat", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{17.275601841080626`, 24.664085267244648`}}]},
      "\"Morocco\""],
     Annotation[#, "Morocco", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.800803278515453`, 22.622731381753102`}}]},
      "\"Mozambique\""],
     Annotation[#, "Mozambique", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{17.737869799972415`, 23.115480659834986`}}]},
      "\"Myanmar\""],
     Annotation[#, "Myanmar", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.524162909675084`, 22.53653379222606}}]},
      "\"Namibia\""],
     Annotation[#, "Namibia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9.52039529527969, 17.83132089423914}}]},
      "\"Nauru\""],
     Annotation[#, "Nauru", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{17.11624758373678, 22.72641735622023}}]},
      "\"Nepal\""],
     Annotation[#, "Nepal", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.60662492829355, 27.15971534094523}}]},
      "\"the Netherlands\""],
     Annotation[#, "the Netherlands", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.115359881396454`, 21.887585655931954`}}]},
      "\"Netherlands Antilles\""],
     Annotation[#, "Netherlands Antilles", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.375131642090551`, 22.191328325371646`}}]},
      "\"New Caledonia\""],
     Annotation[#, "New Caledonia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.208875860948021`, 25.420167638448785`}}]},
      "\"New Zealand\""],
     Annotation[#, "New Zealand", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.517834805973285`, 22.314553799817247`}}]},
      "\"Nicaragua\""],
     Annotation[#, "Nicaragua", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.451490084570818`, 21.90028003682197}}]},
      "\"Niger\""],
     Annotation[#, "Niger", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{18.694743003905643`, 25.454720793284707`}}]},
      "\"Nigeria\""],
     Annotation[#, "Nigeria", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{7.680637427560936, 16.119095151291404`}}]},
      "\"Niue\""],
     Annotation[#, "Niue", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.320056479095435`, 20.266612692068815`}}]},
      "\"The Northern Mariana Islands\""],
     Annotation[#, "The Northern Mariana Islands", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.98189595110925, 23.229607215561575`}}]},
      "\"North Korea\""],
     Annotation[#, "North Korea", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.345964785095974`, 26.411977876862956`}}]},
      "\"Norway\""],
     Annotation[#, "Norway", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.758241058189734`, 24.133394629031326`}}]},
      "\"Oman\""],
     Annotation[#, "Oman", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{18.8776945888199, 25.42389859866289}}]},
      "\"Pakistan\""],
     Annotation[#, "Pakistan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9.90093429574841, 18.625150011151735`}}]},
      "\"Palau\""],
     Annotation[#, "Palau", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.988457602592524`, 23.447261996117376`}}]},
      "\"Panama\""],
     Annotation[#, "Panama", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.588280529216881`, 22.396577697023293`}}]},
      "\"Papua New Guinea\""],
     Annotation[#, "Papua New Guinea", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.633304665692224`, 22.762417376301155`}}]},
      "\"Paraguay\""],
     Annotation[#, "Paraguay", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{17.146580281655638`, 25.061949399971326`}}]},
      "\"Peru\""],
     Annotation[#, "Peru", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{18.23500731189569, 25.30468388872745}}]},
      "\"the Philippines\""],
     Annotation[#, "the Philippines", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{17.46693634877235, 26.39316670191335}}]},
      "\"Poland\""],
     Annotation[#, "Poland", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.166362058943804`, 25.934391375825367`}}]},
      "\"Portuguese Republic\""],
     Annotation[#, "Portuguese Republic", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.190385970339475`, 25.18781259336779}}]},
      "\"Puerto Rico\""],
     Annotation[#, "Puerto Rico", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.608292027699685`, 24.463613707475776`}}]},
      "\"Qatar\""],
     Annotation[#, "Qatar", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.172104959380375`, 22.201199025914235`}}]},
      "\"The Congo\""],
     Annotation[#, "The Congo", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.576725310660107`, 22.289796248369235`}}]},
      "\"R\[EAcute]union\""],
     Annotation[#, "R\[EAcute]union", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.89335134241179, 25.313989119347458`}}]},
      "\"Romania\""],
     Annotation[#, "Romania", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{18.779763790084196`, 27.364406280459832`}}]},
      "\"Russia\""],
     Annotation[#, "Russia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.016914168741305`, 21.47359006771471}}]},
      "\"Rwanda\""],
     Annotation[#, "Rwanda", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{8.922924930641832, 16.70588231586044}}]},
      "\"Saint Helena\""],
     Annotation[#, "Saint Helena", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.66186051801378, 19.931566189006862`}}]},
      "\"Saint Kitts and Nevis\""],
     Annotation[#, "Saint Kitts and Nevis", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.987698950343717`, 20.561705062650383`}}]},
      "\"Saint Lucia\""],
     Annotation[#, "Saint Lucia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{8.857372832825773, 17.692942118622803`}}]},
      "\"Saint-Pierre and Miquelon\""],
     Annotation[#, "Saint-Pierre and Miquelon", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.687307251711735`, 19.874979834186313`}}]},
      "\"Saint Vincent and the Grenadines\""],
     Annotation[#, "Saint Vincent and the Grenadines", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.128024613833803`, 19.82238315327755}}]},
      "\"Samoa\""],
     Annotation[#, "Samoa", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.244129654600282`, 20.997368258132827`}}]},
      "\"San Marino\""],
     Annotation[#, "San Marino", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.960958243020299`, 18.101661632492664`}}]},
      "\"S\[ATilde]o Tom\[EAcute] and Pr\[IAcute]ncipe\""],
     Annotation[#, "S\[ATilde]o Tom\[EAcute] and Pr\[IAcute]ncipe", 
      "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{17.01716290666475, 26.472725062098974`}}]},
      "\"Saudi Arabia\""],
     Annotation[#, "Saudi Arabia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.271517951295916`, 22.836390455001776`}}]},
      "\"Senegal\""],
     Annotation[#, "Senegal", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.82527117900562, 23.909924071440564`}}]},
      "\"Serbia\""],
     Annotation[#, "Serbia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.297923679347642`, 20.365294305268502`}}]},
      "\"Seychelles\""],
     Annotation[#, "Seychelles", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.524880317462916`, 20.873106173128974`}}]},
      "\"Sierra Leone\""],
     Annotation[#, "Sierra Leone", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.280047314860614`, 25.483513721382526`}}]},
      "\"Singapore\""],
     Annotation[#, "Singapore", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.502077645547336`, 24.560921756737585`}}]},
      "\"Slovak Republic\""],
     Annotation[#, "Slovak Republic", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.491925532656069`, 24.25049779193417}}]},
      "\"Slovenia\""],
     Annotation[#, "Slovenia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.076826116802716`, 19.516428391878136`}}]},
      "\"Solomon Islands\""],
     Annotation[#, "Solomon Islands", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.923032382229481`, 21.503499313382154`}}]},
      "\"Somalia\""],
     Annotation[#, "Somalia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{17.67480405920177, 26.19899770823158}}]},
      "\"South Africa\""],
     Annotation[#, "South Africa", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{17.682890444332283`, 27.392290417602116`}}]},
      "\"South Korea\""],
     Annotation[#, "South Korea", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{17.578202328029946`, 27.74845920161584}}]},
      "\"Spain\""],
     Annotation[#, "Spain", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.84771481845953, 23.89827391636934}}]},
      "\"Sri Lanka\""],
     Annotation[#, "Sri Lanka", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{17.405479345794596`, 23.92874417338531}}]},
      "\"the Sudan\""],
     Annotation[#, "the Sudan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.015308093103746`, 21.13091037556911}}]},
      "\"Suriname\""],
     Annotation[#, "Suriname", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.847433553588196`, 21.674326816744564`}}]},
      "\"Swaziland\""],
     Annotation[#, "Swaziland", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.01730932439485, 26.602913459652818`}}]},
      "\"Sweden\""],
     Annotation[#, "Sweden", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.796833492396644`, 26.62559047819907}}]},
      "\"Switzerland\""],
     Annotation[#, "Switzerland", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.762230197604275`, 23.97411351953845}}]},
      "\"Syria\""],
     Annotation[#, "Syria", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.95257254429891, 26.502155784089418`}}]},
      "\"Taiwan\""],
     Annotation[#, "Taiwan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.688386004859366`, 21.57440821654452}}]},
      "\"Tajikistan\""],
     Annotation[#, "Tajikistan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{17.43431526092759, 23.255873896509375`}}]},
      "\"Tanzania\""],
     Annotation[#, "Tanzania", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{17.978023887748506`, 25.897165374335852`}}]},
      "\"Thailand\""],
     Annotation[#, "Thailand", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.63114995191778, 21.505844639326295`}}]},
      "\"Togo\""],
     Annotation[#, "Togo", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{7.238496840894365, 14.22097566607244}}]},
      "\"Tokelau\""],
     Annotation[#, "Tokelau", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.535772473040838`, 19.180199866587444`}}]},
      "\"Tonga\""],
     Annotation[#, "Tonga", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.0818944253007, 23.415385804979813`}}]},
      "\"Trinidad and Tobago\""],
     Annotation[#, "Trinidad and Tobago", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.128290209411244`, 24.092253015519493`}}]},
      "\"Tunisia\""],
     Annotation[#, "Tunisia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{18.10860813261469, 26.616605395281656`}}]},
      "\"Turkey\""],
     Annotation[#, "Turkey", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.391032987591172`, 22.48554665659967}}]},
      "\"Turkmenistan\""],
     Annotation[#, "Turkmenistan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.17686784027705, 20.161664328772886`}}]},
      "\"Turks and Caicos Islands\""],
     Annotation[#, "Turks and Caicos Islands", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9.25349564229011, 17.083810319653296`}}]},
      "\"Tuvalu\""],
     Annotation[#, "Tuvalu", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{17.1764492933402, 22.9331914018188}}]},
      "\"Uganda\""],
     Annotation[#, "Uganda", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{17.654547795178406`, 25.1259343739991}}]},
      "\"Ukraine\""],
     Annotation[#, "Ukraine", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.318659301453309`, 25.619287471365055`}}]},
      "\"United Arab Emirates\""],
     Annotation[#, "United Arab Emirates", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{17.904303806785826`, 28.418930941844337`}}]},
      "\"United Kingdom\""],
     Annotation[#, "United Kingdom", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{19.513318202150042`, 30.153207493812392`}}]},
      "\"United States\""],
     Annotation[#, "United States", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.595472725937794`, 21.178790144927312`}}]},
      "\"United States Virgin Islands\""],
     Annotation[#, "United States Virgin Islands", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.057702708858667`, 23.54416196953639}}]},
      "\"Uruguay\""],
     Annotation[#, "Uruguay", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{17.09616320649171, 23.239442555094215`}}]},
      "\"Uzbekistan\""],
     Annotation[#, "Uzbekistan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.261351238057092`, 19.611004273145888`}}]},
      "\"Vanuatu\""],
     Annotation[#, "Vanuatu", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{17.102011909262433`, 25.60889271062955}}]},
      "\"Venezuela\""],
     Annotation[#, "Venezuela", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{18.249159426044336`, 24.69644905035165}}]},
      "\"Vietnam\""],
     Annotation[#, "Vietnam", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9.68190528178887, 17.909855120186375`}}]},
      "\"Wallis and Futuna Islands\""],
     Annotation[#, "Wallis and Futuna Islands", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.124441036818443`, 22.15325346988182}}]},
      "\"West Bank\""],
     Annotation[#, "West Bank", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.85882536202971, 23.46463456719071}}]},
      "\"Yemen\""],
     Annotation[#, "Yemen", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.272399776155094`, 22.713133859406515`}}]},
      "\"Zambia\""],
     Annotation[#, "Zambia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.38119303124611, 21.51067242019585}}]},
      "\"Zimbabwe\""],
     Annotation[#, "Zimbabwe", "Tooltip"]& ]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{7.238496840894365, 14.22097566607244},
  FrameTicks->{{{{13.815510557964274`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["6", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {18.420680743952367`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["8", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {23.025850929940457`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["10", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {27.631021115928547`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["12", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {16.300417207752275`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {16.951004773893423`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.341871082580436`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.622173047734595`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.840862248699423`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.02020317735524, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.172219384653864`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.304146927696415`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.905587393740365`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {21.556174959881517`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {21.947041268568526`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {22.227343233722685`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {22.446032434687513`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {22.625373363343332`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {22.777389570641958`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {22.909317113684505`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {25.51075757972846, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {26.161345145869607`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {26.55221145455662, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {26.832513419710775`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {27.051202620675607`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {27.230543549331422`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {27.382559756630048`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {27.514487299672595`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{13.815510557964274`, 
       FormBox["\" \"", TraditionalForm]}, {18.420680743952367`, 
       FormBox["\" \"", TraditionalForm]}, {23.025850929940457`, 
       FormBox["\" \"", TraditionalForm]}, {27.631021115928547`, 
       FormBox["\" \"", TraditionalForm]}, {16.300417207752275`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {16.951004773893423`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.341871082580436`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.622173047734595`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.840862248699423`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.02020317735524, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.172219384653864`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.304146927696415`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.905587393740365`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {21.556174959881517`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {21.947041268568526`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {22.227343233722685`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {22.446032434687513`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {22.625373363343332`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {22.777389570641958`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {22.909317113684505`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {25.51075757972846, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {26.161345145869607`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {26.55221145455662, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {26.832513419710775`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {27.051202620675607`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {27.230543549331422`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {27.382559756630048`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {27.514487299672595`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}, {{{6.907755278982137, 
       FormBox["1000", TraditionalForm]}, {9.210340371976184, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["4", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {11.512925464970229`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["5", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {13.815510557964274`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["6", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {16.11809565095832, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["7", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {18.420680743952367`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["8", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {20.72326583694641, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["9", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {7.600902459542082, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.006367567650246, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.294049640102028, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.517193191416238, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.699514748210191, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.85366542803745, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.987196820661973, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.104979856318357, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.903487552536127, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.308952660644293`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.596634733096073`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.819778284410283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.002099841204238`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.156250521031495`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.289781913656018`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.407564949312402`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.206072645530174`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.611537753638338`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.89921982609012, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.122363377404328`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.304684934198283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.458835614025542`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.592367006650065`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.710150042306449`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {14.508657738524219`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {14.914122846632385`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.201804919084164`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.424948470398375`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.60727002719233, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.761420707019587`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.89495209964411, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {16.012735135300492`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {16.811242831518264`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.216707939626428`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.50439001207821, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.72753356339242, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.909855120186375`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.064005800013632`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.197537192638155`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.31532022829454, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {19.11382792451231, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {19.519293032620475`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {19.806975105072254`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.030118656386467`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.21244021318042, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.36659089300768, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.5001222856322, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.617905321288585`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{6.907755278982137, 
       FormBox["\" \"", TraditionalForm]}, {9.210340371976184, 
       FormBox["\" \"", TraditionalForm]}, {11.512925464970229`, 
       FormBox["\" \"", TraditionalForm]}, {13.815510557964274`, 
       FormBox["\" \"", TraditionalForm]}, {16.11809565095832, 
       FormBox["\" \"", TraditionalForm]}, {18.420680743952367`, 
       FormBox["\" \"", TraditionalForm]}, {20.72326583694641, 
       FormBox["\" \"", TraditionalForm]}, {7.600902459542082, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.006367567650246, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.294049640102028, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.517193191416238, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.699514748210191, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.85366542803745, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.987196820661973, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.104979856318357, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.903487552536127, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.308952660644293`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.596634733096073`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.819778284410283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.002099841204238`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.156250521031495`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.289781913656018`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.407564949312402`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.206072645530174`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.611537753638338`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.89921982609012, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.122363377404328`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.304684934198283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.458835614025542`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.592367006650065`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.710150042306449`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {14.508657738524219`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {14.914122846632385`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.201804919084164`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.424948470398375`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.60727002719233, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.761420707019587`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.89495209964411, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {16.012735135300492`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {16.811242831518264`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.216707939626428`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.50439001207821, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.72753356339242, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.909855120186375`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.064005800013632`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.197537192638155`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.31532022829454, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {19.11382792451231, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {19.519293032620475`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {19.806975105072254`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.030118656386467`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.21244021318042, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.36659089300768, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.5001222856322, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.617905321288585`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  Method->{},
  PlotRange->{{7.238496840894365, 20.98021975647255}, {14.22097566607244, 
   30.153207493812392`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->FrontEndValueCache[{{{6.907755278982137, 
       FormBox["1000", TraditionalForm]}, {9.210340371976184, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["4", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {11.512925464970229`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["5", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {13.815510557964274`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["6", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {16.11809565095832, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["7", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {18.420680743952367`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["8", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {20.72326583694641, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["9", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {7.600902459542082, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.006367567650246, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.294049640102028, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.517193191416238, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.699514748210191, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.85366542803745, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.987196820661973, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.104979856318357, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.903487552536127, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.308952660644293`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.596634733096073`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.819778284410283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.002099841204238`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.156250521031495`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.289781913656018`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.407564949312402`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.206072645530174`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.611537753638338`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.89921982609012, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.122363377404328`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.304684934198283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.458835614025542`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.592367006650065`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.710150042306449`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {14.508657738524219`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {14.914122846632385`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.201804919084164`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.424948470398375`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.60727002719233, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.761420707019587`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.89495209964411, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {16.012735135300492`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {16.811242831518264`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.216707939626428`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.50439001207821, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.72753356339242, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.909855120186375`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.064005800013632`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.197537192638155`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.31532022829454, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {19.11382792451231, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {19.519293032620475`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {19.806975105072254`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.030118656386467`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.21244021318042, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.36659089300768, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.5001222856322, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.617905321288585`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{13.815510557964274`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["6", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {18.420680743952367`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["8", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {23.025850929940457`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["10", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {27.631021115928547`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["12", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {16.300417207752275`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {16.951004773893423`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.341871082580436`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.622173047734595`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.840862248699423`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.02020317735524, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.172219384653864`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.304146927696415`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.905587393740365`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {21.556174959881517`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {21.947041268568526`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {22.227343233722685`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {22.446032434687513`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {22.625373363343332`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {22.777389570641958`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {22.909317113684505`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {25.51075757972846, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {26.161345145869607`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {26.55221145455662, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {26.832513419710775`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {27.051202620675607`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {27.230543549331422`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {27.382559756630048`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {27.514487299672595`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}, {{{6.907755278982137, 
       FormBox["1000", TraditionalForm]}, {9.210340371976184, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["4", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {11.512925464970229`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["5", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {13.815510557964274`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["6", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {16.11809565095832, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["7", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {18.420680743952367`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["8", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {20.72326583694641, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["9", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {7.600902459542082, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.006367567650246, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.294049640102028, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.517193191416238, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.699514748210191, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.85366542803745, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.987196820661973, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.104979856318357, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.903487552536127, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.308952660644293`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.596634733096073`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.819778284410283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.002099841204238`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.156250521031495`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.289781913656018`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.407564949312402`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.206072645530174`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.611537753638338`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.89921982609012, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.122363377404328`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.304684934198283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.458835614025542`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.592367006650065`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.710150042306449`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {14.508657738524219`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {14.914122846632385`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.201804919084164`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.424948470398375`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.60727002719233, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.761420707019587`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.89495209964411, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {16.012735135300492`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {16.811242831518264`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.216707939626428`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.50439001207821, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.72753356339242, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.909855120186375`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.064005800013632`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.197537192638155`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.31532022829454, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {19.11382792451231, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {19.519293032620475`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {19.806975105072254`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.030118656386467`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.21244021318042, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.36659089300768, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.5001222856322, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.617905321288585`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{13.815510557964274`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["6", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {18.420680743952367`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["8", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {23.025850929940457`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["10", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {27.631021115928547`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["12", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {16.300417207752275`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {16.951004773893423`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.341871082580436`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.622173047734595`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.840862248699423`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.02020317735524, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.172219384653864`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.304146927696415`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.905587393740365`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {21.556174959881517`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {21.947041268568526`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {22.227343233722685`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {22.446032434687513`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {22.625373363343332`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {22.777389570641958`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {22.909317113684505`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {25.51075757972846, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {26.161345145869607`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {26.55221145455662, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {26.832513419710775`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {27.051202620675607`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {27.230543549331422`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {27.382559756630048`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {27.514487299672595`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}]]], "Output",
 ImageSize->{184, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2099046637]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->815272160],

Cell["Find the GDP of France in 1970:", "ExampleText",
 CellID->656717797],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<France\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "\"\<GDP\>\"", "}"}], ",", "1970"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->93666131],

Cell[BoxData["1.4860490316148856`*^11"], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1962958790]
}, Open  ]],

Cell["Plot the GDP of France from 1970 to 2005:", "ExampleText",
 CellID->151285263],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{"CountryData", "[", 
   RowBox[{"\"\<France\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "\"\<GDP\>\"", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1970", ",", "2005"}], "}"}]}], "}"}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->871671729],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs1u1DAQTpPsT7c/292WP/HTdpGAE2+AOCDgxBFxXiqk9gCF0mfgAjwA
EkfoC1DBA3ABqRJXzrxISMbx2Bn/JI693R5aqbvxxp755vN4ZuzkyfRw98XL
6eHeznTr8cH09e7eztutR/sH+U/JQhRFx/n/m8tRfp3lV/B/nGX5t/x5O/9M
8ltRAk34S4vL4scM/qI4/4jz5oahb1z+VHyva/rwe6nUJ82/YzKWf6/C0Dsa
FFEH26V4UJOKXgylMq7SI5Z6RKRdXI50EhpLRAkd1KDRU9cuLpcED6lsd6K1
m44ea8dFPYRkxIYWKKNjLqVDpDDWG7Pc2FreT5l3dQ7sCGDetOPWvZGvO/Q/
fcubIBh5S5gpBw5yxt4S/LlYKz666iJrx0kRoWmU5GuRR2VdFJUjsu1+3XgW
jdXMcVxB9x5atxTuipj/rjDOcK/6S5cwQDMRbXfOWP/Q+oo5WLCwlzbgbNnz
vh7jyclJw/6u8hezMsfUe0wO4iZBMyHtbdIe1zAaSjpfF53yG6aSdVSk1Ekd
cRnRXZgAhvDrlz/37336+OGnszyBEuT1mbxnT49yeQ8ffEbBm35yl5nc37/+
PZ8e/fj+FxXI4K966QBWBshsrmr/1bdclWyOqwbCdsUfwPd7shoxC5f82Kro
KdZA1FVnZCO4DrQFlfnpoL4OOSxBLZGrdNtsQJ7tITmV2VgOyBTTI7svXnvq
oWwNi4+B7F94jaYttmaw8F793gF+ITscucZYUzhh3i54cEUleOgT3XI+iHh+
s9b1KwZ0wuvCoaMZutMCHYtIwldpRj1t7th+Xci/QuaW4lsi+OmapnjXuA7A
E3Ncys6mnkt5D0p6I69i1ilu2PoO5HihRthRY+5p3TXUo1es1NY/1qoDVueq
FncmRQj8sbkNvUzU+HLNrzsBsmO+QXwCRqygTryhRV7qE+3mFkwaIKVR9npW
9W8Ys4jS8YbAc60Gj4ixTfDomBO6YEQXZeONzaCcVDFMyOxRDzTr2iaew1e4
zPc24btOui3nTzhbrKZ0QKrKomPHhIWV4LIFB26y63YQY85K6UN10m0Mt9/z
nFVZhU/yzOFe99RxfzGreg2tNczc94h2ubZonr3tLDF05jrNnhtkXTTftal8
9OjMdVpzdLPgDuogw/4ibo0Uom/L2kd+qsJPF2j1RpEwK/S7lzorROVGrVjV
49U/n5HmRa3a9Kxr90AOrPM8NMx8K5v2cYfmYRptOKYwZ0NNtAW1zO6tAbXp
aoyQeaZuDmB0F9e+8XzMJasymbgS8YLKdMmITCbWRrhsWGw0n1T5ZF0WF0RE
sct29XYmXax/yBeGiMz3MG2sSAhDKWnD0y1DDB16sJcQ9lLSZnpxRjM5Flb1
ujKbEGbpDqxPGKCZWfg6G8r/lGdaPAdo98H2M6Y69i5o2TPnaOGLNFpBROkR
hCXOEJWEFvlAe46M5lD01EeX7dZYclyIyo1aBFm7q26d9VZUz09nNSd1lZHW
Bsv5EV0zA67DeOqg9/z2tV6orKeteugzu5lUdxQj1JGa3Ep3sAK7zAs/v1rK
Zl3lMZxqvjbjnEX1x1CgB+IFRXFeFc6+KvR5cjXPcxFWU4k80g9qNa0H+QoN
h7xao5ztk6ciHvI3HcOfPDX3QLkiMLYDVwTzPVma7/PHcGhCVxCuNZH5REjF
0PQJmH/VQFHRJ5JpNv9zIIapujs5vXMh0N5V3x5oVRVE52/mQf/ynU75HKBl
5XPOaIVReSdsru7Ye6SmN1H9P6OF/6Ha5xs=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->411809373]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->208642707],

Cell["Basic iconic shape of France:", "ExampleText",
 CellID->554165425],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<France\>\"", ",", "\"\<Shape\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->166993791],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{159, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->189108577]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->897220132],

Cell["Generate a world map using a Mollweide projection:", "ExampleText",
 CellID->131543054],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<World\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<Shape\>\"", ",", "\"\<Mollweide\>\""}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->427845621],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{500, 228},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->5685001]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(44)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Countries, Groups and Names",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(14)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->856352312],

Cell["Find the list of all ordinary countries and dependencies:", \
"ExampleText",
 CellID->27085270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CountryData", "[", "]"}], "//", "Short"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->378591739],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"\<\"Afghanistan\"\>", ",", "\<\"Albania\"\>", 
    ",", "\<\"Algeria\"\>", ",", 
    RowBox[{"\[LeftSkeleton]", "231", "\[RightSkeleton]"}], 
    ",", "\<\"Yemen\"\>", ",", "\<\"Zambia\"\>", ",", "\<\"Zimbabwe\"\>"}], 
   "}"}],
  Short]], "Output",
 ImageSize->{443, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->1508036943]
}, Open  ]],

Cell["\<\
Find all countries and dependencies whose names begin with U:\
\>", "ExampleText",
 CellID->167077364],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", "\"\<U*\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->103455631],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Uganda\"\>", ",", "\<\"Ukraine\"\>", 
   ",", "\<\"UnitedArabEmirates\"\>", ",", "\<\"UnitedKingdom\"\>", 
   ",", "\<\"UnitedStates\"\>", ",", "\<\"UnitedStatesMinorIslands\"\>", 
   ",", "\<\"UnitedStatesVirginIslands\"\>", ",", "\<\"Uruguay\"\>", 
   ",", "\<\"Uzbekistan\"\>"}], "}"}]], "Output",
 ImageSize->{514, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1976548386]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->213595484],

Cell["Find the countries in South America:", "ExampleText",
 CellID->212214928],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", "\"\<SouthAmerica\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->627635238],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Argentina\"\>", ",", "\<\"Bolivia\"\>", ",", "\<\"Brazil\"\>", 
   ",", "\<\"Chile\"\>", ",", "\<\"Colombia\"\>", ",", "\<\"Ecuador\"\>", 
   ",", "\<\"FrenchGuiana\"\>", ",", "\<\"Guyana\"\>", 
   ",", "\<\"Paraguay\"\>", ",", "\<\"Peru\"\>", ",", "\<\"Suriname\"\>", 
   ",", "\<\"Uruguay\"\>", ",", "\<\"Venezuela\"\>"}], "}"}]], "Output",
 ImageSize->{464, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1874519313]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->964731051],

Cell["Find all supported country groups:", "ExampleText",
 CellID->183279257],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CountryData", "[", "\"\<Groups\>\"", "]"}], "//", 
  "Short"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37642333],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"\<\"Africa\"\>", ",", "\<\"AfricanCaribbeanAndPacificGroup\"\>", 
    ",", 
    RowBox[{"\[LeftSkeleton]", "252", "\[RightSkeleton]"}], 
    ",", "\<\"ZanggerCommittee\"\>"}], "}"}],
  Short]], "Output",
 ImageSize->{472, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->1460992101]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19828031],

Cell["Find members of the East African Community:", "ExampleText",
 CellID->4825368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", "\"\<EastAfricanCommunity\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->417755616],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Kenya\"\>", ",", "\<\"Tanzania\"\>", ",", "\<\"Uganda\"\>"}], 
  "}"}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->566221709]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28678809],

Cell["Find the number of members in the United Nations:", "ExampleText",
 CellID->601310876],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"CountryData", "[", "\"\<UnitedNations\>\"", "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->836395986],

Cell[BoxData["193"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->988223306]
}, Open  ]],

Cell["Use the abbreviation UN:", "ExampleText",
 CellID->4424655],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"CountryData", "[", "\"\<UN\>\"", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->47635596],

Cell[BoxData["193"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->473953699]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29205665],

Cell["\<\
Find countries that are in the United Nations but not the Universal Postal \
Union:\
\>", "ExampleText",
 CellID->65150137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Complement", "[", 
  RowBox[{
   RowBox[{"CountryData", "[", "\"\<UnitedNations\>\"", "]"}], ",", 
   RowBox[{"CountryData", "[", "\"\<UniversalPostalUnion\>\"", "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->210104223],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Andorra\"\>", ",", "\<\"MarshallIslands\"\>", 
   ",", "\<\"Micronesia\"\>", ",", "\<\"Palau\"\>"}], "}"}]], "Output",
 ImageSize->{311, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->722972370]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->136730368],

Cell["Find the populations of all countries in the G8:", "ExampleText",
 CellID->903975250],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<G8\>\"", ",", "\"\<Population\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14439257],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3.2268243`*^7", ",", "6.2312148`*^7", ",", "8.268921`*^7", ",", 
   "5.8092744`*^7", ",", "1.28084652`*^8", ",", "1.43201572`*^8", ",", 
   "5.9667844`*^7", ",", "2.98212895`*^8"}], "}"}]], "Output",
 ImageSize->{371, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->534147864]
}, Open  ]],

Cell["Find the total population:", "ExampleText",
 CellID->597197136],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"CountryData", "[", 
   RowBox[{"\"\<G8\>\"", ",", "\"\<Population\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->378083246],

Cell[BoxData["8.64529308`*^8"], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->941505788]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->65275881],

Cell["The English name for the United States:", "ExampleText",
 CellID->75304857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<UnitedStates\>\"", ",", "\"\<Name\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->780938539],

Cell[BoxData["\<\"United States\"\>"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1228267820]
}, Open  ]],

Cell["The full English name:", "ExampleText",
 CellID->706137583],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<UnitedStates\>\"", ",", "\"\<FullName\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->197207243],

Cell[BoxData["\<\"United States of America\"\>"], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1884435776]
}, Open  ]],

Cell["Alternate names:", "ExampleText",
 CellID->248850075],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<UnitedStates\>\"", ",", "\"\<AlternateNames\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->13578880],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"United States of America\"\>", ",", "\<\"America\"\>", 
   ",", "\<\"US\"\>", ",", "\<\"USA\"\>", ",", "\<\"U.S.\"\>", 
   ",", "\<\"U.S.A.\"\>"}], "}"}]], "Output",
 ImageSize->{396, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->623261276]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->463225030],

Cell["The name for Germany in German: ", "ExampleText",
 CellID->3873019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<Germany\>\"", ",", "\"\<NativeName\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->109504657],

Cell[BoxData["\<\"Deutschland\"\>"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->124918826]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->350723361],

Cell["Codes for Germany:", "ExampleText",
 CellID->317432914],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<Germany\>\"", ",", "\"\<InternetCode\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->539008282],

Cell[BoxData["\<\".de\"\>"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46663399]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<Germany\>\"", ",", "\"\<CountryCode\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->403302189],

Cell[BoxData["\<\"DE\"\>"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->64397513]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<Germany\>\"", ",", "\"\<UNCode\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->80881659],

Cell[BoxData["\<\"DEU\"\>"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->20545889]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<Germany\>\"", ",", "\"\<UNNumber\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->21786870],

Cell[BoxData["276"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->120472802]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->482426513],

Cell["Find the standard name of a country from a tag:", "ExampleText",
 CellID->102804819],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", "\"\<.de\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67577911],

Cell[BoxData["\<\"Germany\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37379205]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", "276", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->33946397],

Cell[BoxData["\<\"Germany\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->47418110]
}, Open  ]],

Cell[TextData[{
 "Alternate names that follow standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " conventions can also be used:"
}], "ExampleText",
 CellID->69656086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", "\"\<USA\>\"", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->616772103],

Cell[BoxData["\<\"UnitedStates\"\>"], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->502245932]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<USA\>\"", ",", "\"\<CapitalCity\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->31671],

Cell[BoxData["\<\"Washington, DC\"\>"], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->300743743]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->70883770],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<UnitedKingdom\>\"", ",", "\"\<Flag\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->268930383],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztml1oFUcUx3fv3t17c29MYoypSKN5CwjWhwqlIBiEtr4EkfSlBatXUTT4
hUqp0NKo+BCRhrQvKhSDSFqhtH7Q+vVw0ScFEZ9ERFDBjwcRa0AKpXA65+zM
5uTuzt29M/vQggs73OzOzPn/dr7OmclQbd/WzTtq+7ZtqvV/sqe2e+u2TXv7
P961RzzyXMdxdor7g34Hf4P4qRIPju3aD6c734dTzoATUOrB2fV7oV6v4+0U
KPVg7LtJWPLhCPQt3ej0YerJF5hZFKOiZUp9OLNsSFVA90dr9zuLqKgHw+sO
wLkLF6l0BVMXq3BhYnBYSKJa4Z9X0/Di2+NOCe45y8WzB4uH4M+T50FcQhCm
Hrye/gt++PEaLF99xHkXBlYc8uQLURCLUdEypT48XrkF+LVu+6mwkMgvfsPN
24+odEXWgcbQKJZ24ZfBz4Q0n6Sp6++HT+HZ+tFIIlp4U7+llbjQROLCjBIL
mCqdHtcZaZF6KXuQQTMaXmCieUFGzUW95mKLmp88ewVfHT5HhntNNPdm1OyH
mkUVLlwaPx4THjDhaKdROD7XCe8xEd7TivCGr+fSEESE2sgYTJ65QU/LsjTm
akTAtmiG0G2C0C0R1mw4EUNAEQ+Xfc4QfI5AlygjUL4+eEygFGH4iwNYH6z6
9Hv49fc7bRY0XSY0XZJG2o/RKBEhTSlGc/f+c2pMrMVFGkEVRFTqzkiH06iO
rsOErqMluoC6H6eTAjysRtF5nM7xEiyoLjn9Wz3Woe93DpJ6gep4CZjtJpjt
BphyeeKYvh7Tb4KZNG6TMHlXqZhgVvLBLOkxSzlg4pygMMsmmOV8MNv0mG0G
mMqdScIMTDCDfDCresxqgoWStCA9NkSLpiDutSVhFk0wi/lgztFjzskZs2CC
WcgHs1OP2WmAqVyHJEw9YSmJEJ1idDRFr2qZaq6eam4GKp07GRL4yguJLoxE
KrJUI8nV6/fQZW7WNGpSU5f0sOfpIeYxCOUSKYg0n9jXNoPHxTf57CU+DXPF
FMf0zJY9Nj5Jr7Al51Pq8e8Xky1MhV9RPHs5PhXl0/ee2bIrLB8+x5p8WSuX
rGQLt7YXZbmoNOavv5fRKuWb8Zf/G1WIyCnKPjI7mHr7Shda/q9b/PRPZ2lw
Ycgzn1KfOjm/xEATVYlR3Z7RBo08KiGHqXpB0cU7aMZFy5pZKuCxp1KAQ11t
jPAwq9qKJic9bFNOFl+HetIWh5YUhyFWszUhvn6LNcGKoDtt0TYgsFur5Wpq
RdWV5nFpqZQFHh1UEizk5mgVLDA70vzngJsywczNbbbBbE+LhowweeSeWxBk
g1lJi22tMXMLaW0wy2k7FdaYuW1QmGDi1mLUpZrtO1ljWm83YTxhgomasXw0
QaRuHiYdDKgNCoy70DvXYVptHvK9ahvMAseM7fym4amIPQnPauc3L7yZBtz5
5USzPplGY7Urb0zjomQXtVPrKO+3Re25HYpk1V4KtSuP+8rJqUy9B73wwxOX
yXBuJ1BZNfuzNfNIyEvRrKL63E76mmmO7bUozQHXTLfUW02Qan2QivvmXCo/
VgilFhuPZZTQYiRUZkgSaHUYjR0fBwAXyLeQgzC0pRNIYX+m1ad2fwN/jB6l
v6vyaP78hYt0tocTSR+m6sweMyIJRshlSn1+6E83jtxFVDQMPBv/IQDzqzqo
AV34eXRMaHH/BX/EIQ0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{110, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->112645522]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->304076276],

Cell["Show small flags for all countries in South America:", "ExampleText",
 CellID->855462101],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"CountryData", "[", 
      RowBox[{"#", ",", "\"\<Flag\>\""}], "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "50"}]}], "]"}], "&"}], "/@", 
  RowBox[{"CountryData", "[", "\"\<SouthAmerica\>\"", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180023355],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{432, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->220605820]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->627780382],

Cell["International organizations of which Bermuda is a member:", \
"ExampleText",
 CellID->167227615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<Bermuda\>\"", ",", "\"\<InternationalOrganizations\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13870238],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"CaribbeanCommunityAndCommonMarket\"\>", 
   ",", "\<\"ConfederationsOfFreeTradeUnions\"\>", ",", "\<\"Interpol\"\>", 
   ",", "\<\"InternationalOlympicCommittee\"\>", 
   ",", "\<\"UniversalPostalUnion\"\>", 
   ",", "\<\"WorldCustomsOrganization\"\>"}], "}"}]], "Output",
 ImageSize->{552, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->697141049]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Maps & Images",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->32840558],

Cell["The basic shape of Australia:", "ExampleText",
 CellID->988249],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<Australia\>\"", ",", "\"\<Shape\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->253923123],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyVm3lw3dV1x3/oPb33ZNmSMLYkHCQZZC3BkgWWLVkSSNgTJMtgyfEiGTKW
7KRemOAF24NZBrPMgO1/cP6J+YMtq2lJayaT1NBl6tJO62QmE2baoUy30JnU
hSaUJf/wp/s559zz7vUbptNozOPp9zv33HPP8j3n3Hu1ec/xA3sP7jn+wDf2
LJ84uufIgQe+cWz5+OGjPMpdl2XXVWdZ9rvmjO9X+ab/yU+B/+zr/+fbZfnM
nT9/fnZm5pNPPslG9OnfymeR39va2kqlYn19fWtra3//7S+88EKW0xG8++CD
D+Tr2jhi4YULFxDj7POnf/Lj1zesH3vnl3/Hr6+88govDx86xPfZ2ZmBSJ8f
GxvjYWtLy6/+7R+rrvz6X7JiT8+tPDly5Agz86Wrq1Oksjn+RsdcunSJF2v6
V7/37i9yMiY3PLyupeUmHmY5/Th8+LBq4mrWH8fJ07ld9/3s8qUsrzMx/OWX
zmX6A7empsbLly+Hmd7WESdPnmTlb196KyvIiALkPT0rR4aH/vytH4+MDCFI
Sj06OvrHr39fCBeoVKjr1KlT8mqNUv21Ul28eBGFimJqhSr/g++/xPyweu21
1/oTOpQGg9PPPW101SiIKdetWwf1+++/n62OtPk33njDloHijSsC8isTYaOE
Mif2y7KmxsZskcp47OihtrZWeZVSvffee1B1dKwIVLCdn5urpIJ1a2sLWgxU
LB4VRKpLSvX5558PDKwVeeqVirmD39yeUL355psbNtwlBHVKxWp7Vt763HPP
XcPr7Nmze/fuEYKSUv3wBy9jd2iznI/CkLjYNaP4/fSpZ9SAfFSxmCyHx7F0
VZWOfOrJx6anpyqlevLJJ48dPVimqmGtSDk2NjoxMY6Cdu26D/vgUOIh6r05
KFA6a76GT/QMk5Mha9b0P/vss1mVvK/Bfjjn/v378DbMwRobGxs7Otr379t3
zUoiH5vt3LfPrurtkXjQWK7GL5gaLcFQuPfHsUX8CdmRd8OGMeJlemoKM2Rj
kUJGa4DOvvrqq+fOncvWJ7aGYYioDb8Xuvzf336uvJnunXfeka9D+vRn6tOi
wyxra23lS/qc1dbX1xWLRb4MRQQr4qBoT4a0tYFmCCzrG1SKv3CvBkrka0k5
Ma+FzOOPPWy40dnZwcIjpv2Z6gUBcMTOjg5eI2hWLU8LPMU98C1iYN/er+N6
6iN5PGB+7msDAwOQWty/pfIhzfj43QcfPAAl0d/b2yNoo/Yv8A2vsRBuamp6
7NHj6t/56al7eIIXMJn5wZuOZKAVrmD+VGDOkZFh0IpJsB9jqtBRlgN+4Ivz
W7zkWSuKA1LRTt5nBnceeeQRXGtqaopfu3Sen+rKYYdTzMzMECsSZdUKbnzj
d+IYfbNIWUaW9fWtuuOOYQSpEZr6b509Y9bo6uqCL9wRZM2a1Vu2bCYtIAdQ
isjPP/+8eF2HzvmGmgZ2Y/IzCiSwcqZBwS98+6yuoERagS+8sD7S8RYtMKui
XsECB9b84zmCqsR5tI4oDMT+K3SuC25Dwm1ycqK3ZyXCoSjjw8BHHznGw/Hx
cfR5/NjhRR7dvCrjT544ZiYLeOP7I/cYtEocjo7eiejZYh0N0gMz8vVGR6sV
K9oPHz6U2djXdSy+i6yTk+MshtVmfU4bcN9o/8ixlUXJu9VOhTCSL1MqjM0S
haBfqY4+dDCgebtS/aHnm4aGBgHHNY5R+Ltgi1G9pjFDDOG5WBFVrFU6fBkZ
JFpviXQ5ignASQgGlQoBSD3y6uaEyhJhpCJL4Ncif0o1ODgYeK1TKqYLGWS5
Up1XKnSDowjBkFLNzm4nPiOV8WIsk0Re4lilkkR1SsVAlBSpGAJkgs/XUBE1
eEmcEe3jfWKjtoQK78dHhGBYqfAzgEfW2JpIHy054vlb0q8WQi0JHQED2AjJ
HUpHnHWsaIcOjdykdGqtBXgVEwPyGALwQigcEoBgZSz2EZ+Tok4qkdEkd8kr
46RrrSOPrFq1ihlADs0ed6EKlAspM/NQEGr/fuZ/WLmyMomamW2ZpvPcztnt
Vv9lX1KuqptqZOIFq2RSyZ5WkfENcdAClhQAAxOobI5ojgQOCChUx1rwylWr
elfowqX+GAtVypnm5ibxRJtJP6tZrq0eSEZ1oZqyaQB+OIgtDqUZcGYb6xP4
qtKsQEIBCsQ2Y151iOPiMzbPMh0rGVN/CA6JW6t2gI6uzk5qPpuhhiDArsQW
b3EeszElr1jB9EWRh2OJJMsid/GiLdP3MnPAEjSF7aROU75FUMqwhX9IyneR
d71nJFTFelDbjcrzRs+HzC8kS1QnCM66AESwHJNlX/e6AR8i4/AJA5QlK9e8
lQNGAAwZPB6iXMoiQbR0HujRnxAs9UoWBbAcaCUH71H90R5Q8SE4sY4OJIPV
Z3krDCzSFMLyaGpu1/1IiSTNcZa8zcJ4nKrR7USqE3+43ysK3ICYYCrNfgvQ
6syOrYQ6KmIIvo2X8QZHQ7yNOp95GQUfw5vifJIbkRC9gB+C8TYnoD0/r9h6
n845Nzdn8UlM6Jy14DtAQlizSIYwgNl4gzXgJDnd1ok1QBOKNaoGm1ejMkcw
kkjK2sxZvUGCzaoIbkX7gI7bVE4QAyYoHO7SgmmAFzG0pXGMxQOSLriU3aMc
mZZaWPS2NJkXz6X3kWhr0loYSZEd3QHtJApUSbWBOcUnyx0iwkh0bdTMjm4t
QgANJkfbg4MDJ06c0FqwSHgSNhjPbLZv374zp58JEjFR8BWTSBFRSraAv8vk
Y7H1cw9+cz/QoQAidQLlFL4yMryus7MT/eAArJVYtQKNMNMqt4YZcQyGUHtZ
CJ2TzKCVvNqtZAiNiLzGAYE8CcB3f6ES5k1Cqha4L0m0ZjWKxGKr0DVY8Wd1
BF8sF8EUqREZGyDv0NCg9MStLbjKekdq8qLo3voHNIN+1MG0jinHIYUOaAV6
bdZIkz6jfzXMcA9xjsWJZGZyIfuy1jwgiolSTuh3uRVtoaFTYhBD9ZX6F9hm
0W2js2mdGe1Zn8lYwfDrk5kxOR4gHHvd3wLHMX0PxyBZuetiBuAH4yEWNHyC
/9JTbtXZaJQtdeBT0GUNyWy4E54vOcZmI4eF6mfU9UBpL9IUNQchOc0hZauF
JQEs9fMOHUv+CN1yfTIDaZW1Sh/f69UCQSqv7tT3mIr1yL6D1sYiC8TIjEOz
kqmpzVaVbHVkLxWLYq2GmMUEQ/EMkcTqwTJUZXd4XWMYZvlNdiqISF5BRdgy
+TYdh4NQv0l2SVeAewRMWaVUhBWQG7mTwsw9snJ9TP+KTMAfTTC/bnfu1hNk
dYnsxABdqmS4PkdwRuMFiLHOsRui3bt3081r/1+NOgAVPAfg/eqWqaB/bIct
BWEWJfxxC8BSCG7TsSiCKCZ+EFvymPZy1dbtoVrKl52zOyw/S52FRcmemHaH
V3Hr12uDn86BQUPdqDV0HnVQv6Bi1rDa12DJn+kX+55C8IuZK2GvhXwr9f3C
JLPH6nxAOWM5RMdF0chtSnHhwoUQLze4h8BXvH+2wt9qE75R4nWhOjoNX9lR
6fN6GSdn6sAVaS0pZDs9KlGspskklzMeI5erWaFXzGklzVAd4G1kgSwnbUPO
gvpq6DOqxAAS+2G86YjVhnrW1gKCIIVU2raW5gr8u9NxjVEkUMIA5NSiKcsb
ejIDE2svQuXWWl9XJ1XfoXJP09EhPpFyjzW1VjEF/BP/gRvDsQOKUh8oYDmi
gvUhDr6K/Y+4x4QOyDTV5BGLl4s+N7nMZgIzbaZZohbroytT09zcLlxd1qNt
M8gtox+qiPeaZI5oY3X/vE1w4sTDgLYibgH+8OntXYnk8/PzrLPKvQGgE40e
9S6OGBW5jH9jkr2EYNorNzTDYq0WtAiRShiDoS/YsUpKAvH8R5Uv8RC8qJTw
jRrf6tkCCxKuABGFUlZFYOUFAgu278TSWSpJAAA46bX+nKG48V3qfjIxMSGz
7/BIoUyRCKzC0fJIluXxeOyKPtHc0xW6LSa8WFWojufddyzJZU97vNg28zWj
rIoRgl/7qJAxjGpJReX9n0pFAYfnVlKhYasRAxVLAbsF/VIqTC37UqDrFbes
Fau2JxioYq/3X64/8o4CY0I1J3XEGSH4QKmsACrXGdkNShX3aj+8EjptYjtS
LXakQC7Bqv/+QqrrHf1IhJIbf3Ml9ONBrpQq9tC/cdRAX1JZGpVmyhzVLcAu
BL+tsKtR1Xs2thov+8j7LYvAQFVXscaPPMYNEIO+6jxvhv1Yo2Ipg4ODgvAp
VdwL+cizK/ESdW9ULIg6PVKBA+H0wKgWOWoT4WLH/1EqYiLUTikVRf3TTz0u
BEZFBTA9PR2pNP/Ijk/Q18deZVvNE6hqrbp54olA9UmFHY1qQUVEf+oWsvoj
UJXcVymWRoaHst+5R+NiUo0kVNUMBLUBQSwgCPWp9zmNjUujBayPQTqeauLd
QqAxrZyYfOLcgarIXeOhBkmtC2loaNi5cyeZlcCgZ5uf/1oYFzErn4wDCwFl
PVQp2WaibY3iTKY/6bOZnD6DmMlHGUuMpN1jTHNzM77As76+PrT1sVcFvAI3
0nWVdBfl7uGhQURkHisuCCYfcxAWsquQ6oLEMj11D+5hbbqhXFjTOYmrxB5F
z2jgqpHjkshk1JMbx+3YLmBIjWcDQBjHChYBV+nYpdtPqVAlWij7i1R76Bjv
Zg2FxBdwWzBQ7PuZ1xssVMWKEgpusVIiJlDFWqeYUBkvyZafeRyG7FCMFhTv
Q/2y51PmNTCwVpDScki1z8hTYDBQAedr1/QL6tYkVBHBP/VMwypJCKEGMCoC
ZXJSi4rPvjCLm1yxdv/Ya0vbAmOSBQkdBrUkZAgh2RjuejpbJ/Vq7RfyNFpi
Ae+FIZ4tuJnSRnQ15Nn7B7spouTVooSKnpk0FalYfji1WZRYIvL60GtxnBUf
x3Nk3rqENuZKpc1vnPiKVT44dn1Cx8OQeTUrya47/bw1Gg0JXdTPhwlmy65D
Q7IOFBB2oyyXCJzaOuoTy0Fl+3Qhl9CYhK4xpYr7X7/1KKN8qaAq4AWApi3B
TiU0n4etb/tnVZ+EeTKyWO7RIbVTeOmw/0NHMzGcNk1OWJ5CVNlMtB1L7HxV
f1ILFiQGdcsBVqQDgOt91ydPgFH4V+lmLIlbyvgsgyzRXcHyChOiHsuQyqEG
VpgNkGvUarHs5rKe6+N4QXrqbwpSIId3GEy6mF9p1Y2nAMT4CGKCwKDRkgTb
5DQzy+wIgcoi7Mf+u49EcpvOWuolEWcKjDT78mPy66gcX2zvy2ppy4l5JIQX
jo6i/1XpMECoD5pits7bDhLLhe6fPWuEvGh0VpNQ31BgiKzveT1IJzM9PWW9
R6hvwGH0Iru7/+TIGk57jGqx8wr7Iu96JkZWqTZSKjRIrAmHdx2/wh0Ko7rB
1wmO4nUo7x/cC2CY7qsu8RyBmwOBgLBtWv1S6WnjWD7gTFqw3V6t7aU75+GW
6XvxKeKBMhm2eNXPdZScWGvGYZTtb6u2aiRftbZSPKEdlk63MrB2rYmXXdZ1
8BSflK7Ddt1VxpIdBmBymh7MLBA/O0sdddnratnMnJpKzx5kPz+cw/29UsUb
CcsiVTXr0NO/7dAKDryteAa48Yh6CkVJt2R89aREThNJouQA3nWsaGepf+U4
jZ3GxsYQRLJNck4je9JkKiY6fuzwX6qGsBd5GLEpZ+2EqFO5U2sS4JaZcQM0
+qfKXbpbLUfgI1mqLY6p4ffn9eeqbvHSYBE4aFWiTtvG/JnTzxC5CEyY2Jlb
j86GLtE2pmJOQ5o/8dxkJRCC23mf7ibIuSBeApaSOH+kcjGHbfF3d3XF00G9
FZFHc0gLdsH3vKIZJQNlIaoGhuzij2wX2Mmj3mKQXZBNmzZKJP1Qo54RZFza
PZyGSgVHsDNPPXNP6tHvuQ2YDhENIDI75V5bkYe+6/V56Oy+nFDFXazvei4P
VaJRDVTM+x2v1MIpZEqFy4Yc9B2vllG1yJVSwd7SeKDCFNSbFVRy94fkZAc+
ryjdt86eCT3nrUqndyDyBAirGhkZZgkvO79QjRid3qaQWop1ioe85DFkDhSo
hpVK8KO3V7zhRUeskPlSKqoSViBY9KJjbuh8UiqEDfo3KgS0THANVawCXvTs
bgf610gfz5qKziuMekC9Bk1jOCCZKMCDUO4t3l3wnG4iW5lwI9+Emkfvf+UO
HnyA5CVfdQurxiowIAuvwqZEDMvjV9lVu9n1gnsJs5QvhMyvjmn19uQEmCkn
MPvdW4FXGIX7EXlHdvoz4d3m/Q2W3717t8Vs4I3XEEMarCq4dtRTxCfashXv
1dG46f79+0V/Vo/HPV49RM/rxYaSFSWJ7IJY5JMt05shsBt7sJRKXm/X2DUW
IDLb6yuzLZwwCwVFuHd1k/dMvUSV/vREaxetZypXscyl+0JXQ9XV3d0lfdde
r+Cs4AlzgAa4uVRKX3LbrlnTL9dUtHGwG44F6+daW1rsLBKmxl33GpuA40zD
OI8tCAZ6Y6qFWo8QOgQ5qVt2JfTNYbfc+Oue+QJcYsP6MdZPEJgKkAtXR24K
7N2OYfgByuM568PUCz26qAckbuymyMaNd+MfcQY9VygBGVjaeFtXyzpYTc6l
Ch3ATq+S7BoMLor/sQirUHCpsNPR7BVKiL5kLqncxsZGad6vaplFt63n43L8
Lx5m1wDoPo8+dBDF23439QwuLDvOlbtezY5TdkExzKQ3y4oYpa6uzlyPFhhR
5bZilezw0tXUhQp/m1uWGQQRGyuQXM8oZZcL7Ue96QxyDkkypa6xupBfS0Xp
oargvcOjNuzHGd+4z9rkOgoIa3wnPDLo1ru7uwFj3dcsWLlt9wWwrxziKL/Y
nTU5/gf0TPhVg9jEN97NP6lAdI+3xDcwiX9oBCERDS0x9Y0eG6EjMc52nlrJ
GT1BJX3UyFCZs1R0FKZgHlDWUoFTugksvTydl2FCwq/IGAIJXzct8Vne9xYE
DrpscxTDZvK+0XG8t3clXmiVhJ0VF+BoZb7tN+M3DapRLGOX7azlgXm/+xJV
n1QOWsUkO2A2i7GJXj2perDbsHZRVnalGjxSWCULsuty8Cn56gl6u2/WmXRO
LA/XvtmrBKwlq1vqHSHsBXtsdZt0daAgTwleEIK+AUSsdwvAjx+5iqGZAEjG
M6EcGhoUxGlXCZ956nF8TLazsww1YY32Cgy/wbWCp0sXdlucXe6HhcMwDbKe
nlvLd3hln4AS047OpQbIu0Ys7nikoDbeodTaeUmsgg2i246KTG1nPEgr93So
Te1O7L0aLSbCzI6tTKl6z6M4VMkn0GX3Gkm2WB4CPAZQQoYVrifMYxe3Ol3v
4aSifGMZ9YjGqhyLII/3plWGArDN6mGLwVgLBtbRdfzKjAADQiIAOrWTFbyq
VX5awD8kB2u0eqg2z7C7p9KhdDmKhxtpCzVycVzii3KQ7MESWQSJgCzXHyUq
2q0SfvpX30aXgXbFg3T8QrsTDXwb2JdPpxhobdCJEyes/7cwlEFaKeQlH+vN
UsKs2yvQcJvDZCPSDA3lUPfQIZwKYIGryWYbh3YGDT7Pz8/JXkOtYxwoMjs7
Y+NxA9tnQXssQ9Cl3T2L0dY5ia90uo6sTzQ5JJeHXUA9Gc5s0xpwZBQTwFHu
2tQ4ciCG6Nv2jfkGIY+Qh4yZrfCOhf8TU363NUHzBaFGP8Q4ySJDcc7QWV7V
7QbUDriB0pCGSvDBAzyPNcfszMzcrvvlVbe+Hx5eh6JiTMS6VLWW3KKwObeq
9WmKynhEW3P61DPxzgczhhyhe4fSQ+nd1XGBeEcjgpN6w2+jJh5os8a9e5v1
q/K50O6+WH9NusS3+c4C6A2pDLAYad92R1gP5aVdB7E5CQFUa77S7viOleKc
sTOwOfVWUk35PrmRY7R9+/bhMnJXpM7rsHAjUjWa93NR2cpod5whpCTwzI4A
V1/fqjjTrFcdQdO212KH3DKg0zEMmCEwSLfl2655qTYlYhpRqnlbU/mWinH/
ptLNqN2BGtl/85rErieb5fNyYkFWm/iKvHCKkIuGI6eCXdwHHZgUO01P39vu
tQYalr34Dve0kOFNrp2zO3gvu5zG7ZDHd7gj0O4IDmICNtSRTI4X2An51NRm
co1oueRVP36r2xWjxu+gW4MyQ85IdJVFy2uNcgdcTmoOHDgg2FreBwHnhocG
saptGlV7JY2mkQGCCt4BKdQiBaTmFxASieFNoXazx7dFB7EocWGRiPqDf1Xw
RFFSNHY7QuvfVrSFPRitRfKw5hFVs2R6r5fsenH4OyjVZsGuuNu1MmpKFq/d
XYkVze26j1l081QuGpBOcOE2r6w7VrTLuore65DcScgIYNwPe5QSeVJCG3q/
ohvo5U5sARFk2cWilEKFx0gyODiAYK2OBsgNThGQBZ8NbZMqyrPpPdpq+7uK
5uYmPsk/psU8E9glZ0ysWXsRvQlNnv0BFyiDeAQI7snEUEJPhuru6gqaJA7M
E9Ck1gzVZFz9qzExoSQsk+EhRRzQ8OLFi7giXFERREQQ60K3x44eNAcsZ7Jw
wqo6XIpIOJ25NprVso7yiIiZlWsJs9vhuHz5cpCxoaHe6hu7LIIvke2DtOiA
VE6gsTz7qw3bskYu4EL7t+yYfNYjOVmLRhnnYzxhOCU/m+FAAGM2lELVFaol
lXGJdlAtVuDZ1pzVaDDETHC0+9QnHpYdS/vTLRZx8uQTzHGLR2+4O2LYH8+o
tRvLnnSqcD9Aa5xaLE5ViN1YLkGN2yAWJS75nEkpDsIuPE5j8MsiSOUNDQ3i
35YxKv/CKGaMZGb5Kz9i+/HHHr6iVw6tFrNtu27dTWRMvfu24bzharKjYvzj
Kbfxf8yruXDvQHvyBXa3ur//dmn4GhvLV1wxFl8GKyrAL5ZcOVeTP0hfds2E
+AkRh9OT2fFh6921J9XjVusySCziwXpfMHtUPmtxFnSPqszGRWkg682WeITE
mHGy9EZjbG6KmoTIOOkRWy1zdXd3WcbVu9d9xs+OayVLjKnPEjCkdvMnvZmZ
6ZZDCY3KTf9p2eKBN0ub1ltpG1z/FIkyp40RU/x+f6OVXfe/uJ2Ojg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{261, 242},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->118882566]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->549062115],

Cell["Generate a polygon boundary for Australia:", "ExampleText",
 CellID->143278442],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Gray", ",", 
    RowBox[{"CountryData", "[", 
     RowBox[{"\"\<Australia\>\"", ",", "\"\<Polygon\>\""}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3861288],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytVklPVEEQfsw+LDMww8AwA4Issg4gmwjEuCRiFNSEg3qcEOJggijgkujh
uVxcABP04EERBfQH8P+eVd316nX3LPHgJFP9vvqqq7urq7p7Mb9VWFnLb60u
5zvmN/KPCqvLmx1X1zdA5a+yLOsE/ntpC74d+BL/E8eBtljuggzatt0h0A7I
MCAfIj98OOJnZQS7DTIKSssPH5K0sszUgKZVoI8gaxm5nNqrhe3qQCN9fAAZ
Y/QeZFxDMfaIKATIT61ng1OOGnPPlll5sfxk9DxdQfsGZACUIYpfp9C+UuLn
U9aMn16UX9DakIxA2y60z0EmjD5eTJ+B7AOUEugpyAFAjQI9ATn4z2gIULIE
2gKZY7QJcgRQQqCHJdbjsesUeZXNMVsgNgDtJLT1QpugSN2mOPo0Nk6ZMW/E
PkjzwIEm2DoGsgHQFfLlWuk+a0Emy1hNQRtnq5SxlpAYmmchCWucdh79nNf6
9wAapVpB7zPQxnim3YCGqSZcto5X3WWws9DWMot9Byh71BlOaz56AfVCuwBt
jdDWU/b0lOg759aMmF2Oxg1QXd1iNk5xwvxY0rTu6HehjbCny8Y49zR2H1BY
IOz5owI6oCqTsf35X9Av2jfLwvgcMqoGeUy5aiJc729GEULBMuiYx9NRmJBc
X4j6eegPWwpfAZl1Uh4xFzLqwmOiml2whF2Y53HEOxKmKETZ+5GGkKtmj4ec
V8XogHM9RDvpoX2uEhzvG1dmJYT9vmvoKyZTkPOKqtHrq673i63fO4mSVp/h
s4n3SmX2mMFV7AJq5qzfYYRjbzPCMd4BkndcyvD4Fj7TgkH+Ndu1gXxpu3dZ
F8hNQKcEwqp9zAgre81YVxszD0DTJVAfyFVG/SALGroPqFugQZArFdANOhPS
mvYa5VITa/FkChpVf4msUnT6yL6Y1mh0kTKwEdozgh1yvBP+Ap19SWZzSk3I
3xzlVAOdeZY1ZkR8ushi0pEnWYOmnQA5bssbVteOURboHtwxbLqn1VW30y7X
c48pR95oqlUbiIxmdc6RLyfz/YBkmrIDz+8+tq6jWm8hX/hK6hfsjCNfFxj9
LOVZVPE9IKxmHXkPm1bDzIboJMjSmtDniGCvg8xQH0+7QLNpIc9Su0ja5iLb
Vop5RLPNuJWnRBk3flRY3ATZbBe/U5M0prRy3xZqzGNKBBppdWeF9R1aecDw
WX4W2EN996Cyk3RjbOGj7PW0S8oOeFqbtB5SZyHnWO7lalX9BceR72g=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->109136820]
}, Open  ]],

Cell["The \"schematic boundary\" is lower resolution:", "ExampleText",
 CellID->14458036],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Gray", ",", 
    RowBox[{"CountryData", "[", 
     RowBox[{"\"\<Australia\>\"", ",", "\"\<SchematicPolygon\>\""}], "]"}]}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->530938651],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyVlttPE0EUxhfabaFAiwUpF1Gq3C9yEYOARNEEjYokvvDcEBVMCAp4iTGB
xMREUSQxMT4oCoqgz/x/le9M8/V0urvEh/Idfufr7NmZMzOdzqzO31/MrC7M
ZVpuLGcezy/MrbRMLS0foVCJ4ziHR5+tFgdx9ijM/Tl0stkskh6yCYll19fX
T/mAD5AKG1QCNBnwHlL1X2ADEg8C7yBlAGcDyg+Sj5AwRkgb8BoSAohy8DMm
tQYpBwix1NzrvoKcBmg04AWkFaDegOeQDoA6BToBThrwDNJlg26AWh/wFNJj
g16AGgNWIX1BYAXSD5A0YBkyoMATyBDACQOkPhdgRoBMl0T4uLY9yW65iaiU
MyiR2IcRVRt7HJIAmOJahAu/eFHZqyBJgOssS0zjiBLKVAswiSiCqNTTlAKY
4NLnTXFlagQYZTsUmUSaAYa5MfKmKmVKAwxwszhSOSL5b9S2twH0ILqFqFKl
pJU6OHdeI+XsCXaN7JppRBUqNcg+nrFTI1zWe3ZqgntmFlFMlfbVBt8AytWE
btvgO0CZAVL2Dxvs8HmOI3Xs2uAnQMQHSDl7bEAPIOXss/s8gJRzYIN9NUaU
Dj8g5fw5Fhyo0l06/ICU81cBKey3DfbUjBWBKL+iwZ5ahghBuQ9wCWIK/FKt
43JdKtUYuzbYURshwnaIq8K21Ub2Bl/U0VoE5JU+q+O5CMgbfAJIqT7dUkAe
tqmAbJQNdQnIkftWARn7jQJysa2pi0TunpfqzmuFrAA0G9AOWVL3lIBFdafJ
qfAI4JwBnZAFG8wDtBrQBXkYBLohDxSQY8n1OHuu8firR9R2jP0qez+l7L2Q
EEeaZC8HmK6wFeuUqU8kXHBnZXPnl/Sc3BPtxjwIuczuK0qN8SaqUSk59eWS
khVPqtQIRE7YWjt1CRLzmJE0e6qah7y2y8tGCme5wbbnryvr7k2xuRK2vYw7
NW+Se6rbmMYgUe7vBvatPKfP09TI6mT088Y0zlcIMN2GNHG3yJj9JnWH3/JO
NXEKdWqaqTo+f8Ck7nLAotRMYcq1UykWL002aFKzXK7TdsrrV1SYL59mUw8p
eymvHZe9LeyCqt/67dTp8ZzcmGv+qaCfz07JPwUerT0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->744389902]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6492268],

Cell["Combine the polygons for all countries in South America:", "ExampleText",
 CellID->641243771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"EdgeForm", "[", "Black", "]"}], ",", "LightGray", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"CountryData", "[", 
       RowBox[{"#", ",", "\"\<Polygon\>\""}], "]"}], "&"}], "/@", 
     RowBox[{"CountryData", "[", "\"\<SouthAmerica\>\"", "]"}]}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->434270926],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->100472974]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->494366061],

Cell["\<\
Show countries in South America colored by their arable land fractions:\
\>", "ExampleText",
 CellID->259672429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{"CountryData", "[", 
        RowBox[{"#", ",", "\"\<ArableLandFraction\>\""}], "]"}], "]"}], ",", 
      RowBox[{"CountryData", "[", 
       RowBox[{"#", ",", "\"\<Polygon\>\""}], "]"}]}], "}"}], "&"}], "/@", 
   RowBox[{"CountryData", "[", "\"\<SouthAmerica\>\"", "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->117354655],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->851970879]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->65805113],

Cell["\<\
By default, country shapes are generated separately for each country:\
\>", "ExampleText",
 CellID->540426067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<UnitedStates\>\"", ",", "\"\<Shape\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29912348],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{219, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89802349]
}, Open  ]],

Cell["Use a fixed Mercator projection:", "ExampleText",
 CellID->452801239],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<UnitedStates\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<Shape\>\"", ",", "\"\<Mercator\>\""}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->669085720],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{234, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->389034220]
}, Open  ]],

Cell["Use a Mollweide projection instead:", "ExampleText",
 CellID->167571537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<UnitedStates\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<Shape\>\"", ",", "\"\<Mollweide\>\""}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->55211471],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{239, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->465226114]
}, Open  ]],

Cell["\<\
The Mollweide projection, with the central longitude as the projection \
center:\
\>", "ExampleText",
 CellID->5446574],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<UnitedStates\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<Shape\>\"", ",", 
     RowBox[{"s", 
      RowBox[{"{", 
       RowBox[{"\"\<Mollweide\>\"", ",", "Center"}], "}"}]}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->152097895],

Cell[GraphicsData["CompressedBitmap", "\<\
eJx1ml1wVdUVx7f33OTeEEwilCRWk6Dkw0I+kI/wEU2Aagi2SfCLYDskUCQJ
VUgKjKCOoEyBOLakDxW0YpiOiB1ry1BtsH1o2pl26EOnPHQ6zHQ69aHj+OAD
jz7S31pr77sPV3snHu89Z+21117rv/5r7X3o33VofM++XYf27t61ePOBXZPj
e3cfXNw7cYBbyW3Ouc/5b6rW8f0m3/S/z2/e5P9fvv5OrsnFixdnZ2fla4fe
1a/JF1980dv7MKNdJp/Pu2Rubu6mflxblCq9ceNGTU31f/79jw8vv19ZWTk0
tC2lo/TSpUutrcs+/e+/+GtrXYYKe/pbnYGxzc3NF9455zI8d0nrsqVHjhyR
R+0qNSHXLFIjw8PoRtlGHceXnp7uoaEnXKLj/jT3cUtzcxz3rFxzjJuZmenu
7q6vr586dbyxccmaNZ1ug2r47LPPUDh9+lWXVQ1/vTrX0FAfNXxfriVoOHPm
THt72/ahJz54/x2Xufb3v7ikrW1ZR4cuo0d1nT17dmT4u6LGdOGLfD4Xde3V
VWAzMyLIVGb1lr7eqqqqgYEBrwebGhoaXj72givV5zXV1dyK/lY9CevBlDjb
li2bidCxY8e8lrGxUX6/fe6M11JfX/fJJ59ELeNhrubmpuv//JtpyfINQcx5
7733uoO9NTU1B36w790Lb5smwVE6/qZpYv/+F54/VLAny/JYJ4Ah1qopEfA4
98rLL3qLin1tetrb23//8eWoB4uqq6sZiCEPqkUsAxsZzSPTNLrne6dPn46a
xlTT9evXm5oaRaBENQFApx+cpJqS4eFhQi8PTQ9hzedyV65c8fg3PfzetGlD
waISpMBQTj+DRO2BIIVqwWJOdRE/FkzueF2jKnXt2jX8zQJtRlnd1MlXWODg
4GCXrq6QbTjKNK1fv5ZpYlaaJoAO3Au2Z7GqsrKCKXt7e03T+fPnbb1btvTa
+n4y/SoxwS9uuWrao5pOnDixb99eEShTTXv27GIQBmHKOtUEsltbl86cO8Mk
JQHbrP7kyZPuftX0tGqyyIjAPPUUMXr2mTEEt2/fLp5YWyRlVglGncMzt+iK
sZmvVhFKFG3e3Atk1wReIr+iHoKEHrR7PbuDx9uUedztcslBT0gZFsH5xMR+
sWy1ygJ0VngLhk0WAkjrjJmuOvMEgiTe9+w4yon7pk093d0PYmeNSpMAZJPM
cmeKcwq4TMwiAOxW6BzblHNYB7dIkM7OTvFNXscSXGhShi3UsWden0YE89wd
8jxvKX716lVu8UUCJKDcZjNDn6Aqzoyqjg5NGZv5SeVL8ABGySmWhW2wpugv
DStftWqFDF6kGg4dnBgY6BefV8jzeZjM2gjv2rVrmXliYgLbN28WaoLgagKP
syZL4WJuMjseD3KQGHYQE2NK6BcmV0OCBDQIvEmjmhQGIGs3XyTKwTq0zSpI
uVUrV+x5eic/QQ1CZJnExGI0PT29dWt/xBLQA4DyaKVa9FjITQJL6IG/sS4U
jAXyMBMkenp6Vq68P1g0X0pFwBs5C/eQl0ACFHAlQIzPSJZmsaGlpYVv5LHh
T/K1omLx4gbUVqI/AwdqtfT8mwSEkxzC4cYX8uP69SLbU/mksc+xBPICtgVS
amAO+nZ3KrSweXjHd4gKYAYEgwPfQgK1VKKurnXgnGULV+ZzZAxuJTH5Lqxm
dpP0FnBMvV3rv3jaOXgOR3CflWcCR6f5ULgOPgTSlpHe9qFt2wC6mq1SyPss
MBph7dZa8AX4YbWusYS4YynpiHWUr1sqE+YQKUOt1Uq0Ij19eoqFj42NESkz
zfgVf2E+4SBkadsQoziKyLJQ1cyWyG6ep7NBz9bBfqYDBlnFDHFHieWs3QEb
IyMjyBCSJNhMaTl4YB9uVx9kMRWcgHcKj9nzaOilgLgwV7dyEz5oa2ulncKJ
QI0rqcnIjPggjwu4CQQgVm40NS2hSqK6QufAF9XVi2jrMCg9BzCk3RCRHrlU
4PbnjxwkRIwkxTCcGmKkWF9Xx31oAtoglReoT0i1AatopnVrrI3NwoYPpXgR
xYbKBA04KY4a1FGjo6MYLgjqDaNwsXyttVErV+ChOEqnTQjiyIgy+K5Qz7AU
dnOdKtWvUpDNI7bO3SpFCKwsel2dofKbb125XBJrRZTEg5ZHtw4wg3s6WOj7
HtOiWSo9JtPzgJDiMVcujabn96gLmiQJRc2ewFOQSrTo/lA7gDTEbW2mVamk
kLGuRPgmwW0QTNSFJKGmVHld2m2UkKrEipQgL4VjqpDN4O79fv4pdEp9WqVj
WnUMcMHBGAZbSHX/ocrW1d3lu3rjpaUqS0jxHouCVoCMO6mZC9n09fWBMwhC
VmfVt0G5BE8d0w+OxzoWmw0dKBAR300FVgCA7CVAu1VB06LuzKGVusRTsheX
YylrdMLEGY0i3vO9wGuhv0I1FIC1y6M14kUvJ5yT0ahFDvixjsUHUCSphmPa
U2Njv/FGiADzgxffx6qlCdXMY/XNEEe0YYaXqgt5sH3oSRF4K3Dk6tWrpDJb
l35X6EVAmVTJGbUMKUoAvpDqgmO/kZLFOgQl5ud1eYAFfOAclkwaOJOt1Sge
PXq0Wz9IyIif6wi+4Q8SC4xIFO/TEVpxSzCD6PCYP1n3hcCWXevXSS9tsgs0
VhZxIA2kcJC1Du4XwWcPPtAlCGyJI7K0NYOD3wayQOqD0ItS72g8JicnRbox
SienTp2iZInYJfXKjh1PVVRUNNTXY/SSlNzhw4dBqYj8WnVap8yHDaWsz2Tv
CDxM5h5nt6M6S/C0FFjnmF/6qSLZqqrKV4JsKaNIAOnc+3qhRFBzr0pXhb4X
KEmNVek8Xoa0sQVHHzywn+aDkQT6ntQYspo2ScR/E7whxOoc9Ej9cSZbGTgG
5Ejf8qHK2vbLWhPBZloWaiBkUS+jKOGWcBjpzO6KUOv9fuyjsPehnCKIcWk5
flKyoxzMiU7QyMLTctiJUTCQ2SkVEb4jnUmNJSm5ixcvEgnhhcLasYNGhF02
bvKR0D5FuBuulsqjsqVnX5+2bhFyAfb0s2lp0GTlxl0OPRX7JNqPrvVroRuG
QXi36Me0urq7KYRmc6lVccCNLYiTFPfeqp+bIq3W5JDGGkoyCULlhgXoj72P
td+VvbH1NixXx+RxXV/fw6tWrYRMmYTZWTkJYFEsD5GRHR9tXqKVAQh5/vqV
bgvxGDixNpZc8ecKzrGfcCk9WSKHfbiE7iAjgUlsKy9KfhliSRGF7YmAziX7
Om5CcC0tzWmb8BTpK4Mup/ZiGzfKqYf2yyV9mx9iKh7aQYK3ZF7oJfyuT/2c
kFEsSjBtYyEZI2mCJQ2wjS0LY8G/zPdRYDGWK8QuHewiO6PK2t7J2oHFqdG0
daxQRGbVd9bFyAZXmR7PsBn2+730uNhT6bh5AAlvQ3XQLrZo3KtZg23gG75y
5BUdad03ziPWtt3DwcM7nuro6IBo6lMj4w5aR5aAFUHutsdBlvpKfSdnQnV1
QN+lx8ZdvNpbSqShIAs23i6cblGSR2wnVZcazaZxxnhjLnRWt0jli3z5x1Ad
fN+Ylood+Fyo1DhpfHyc1RZpA2zSKc6Fzlg3W5WW2IVt2Z0pO0E7yBfxPwT8
WoOLRyxXCBK9TmEn+SXPquVlL77wHMJEHkJgobYdJB2lPlencBtPdWwcKLMt
rRWZ2toa2znIfItS42IF+3MYR/4Bbjr65cuXszyoxY+7IzUunm2dCx7Gl2DH
3aeMI+dZzpFpXAEFnhLcVqU0sHGguxfhn+kI0ELmESar2L6DaFaPWw3Eh1RR
XMBqcBJRqkzpw5m+xqq+hB/ckkeZYDHbMsnGlpCdMChs6KtT2rZ4WlLQhVX6
SPsKgk3LAkJBrqW4cPk9qhfmBy0nTpwgvaRfSHvNeD/qZRT7BGStS8/R01JU
8YE1S7Zm1xD2PtySOCxMaZyY2O9PZiwOcD7qVJkyK/KHDz/HRg4X1qsEMMnZ
WeXCW6Phd/nnwl4DY+VRWWD6zs7V4r26kHe+J09rIcYYELXEk+x5oQ/ypyV3
63NwBsKiFmNwONk41nek8bw3nSOCjrqi52ktxJTuRvxntsSzokJWw4ry3PxC
KEkGebQg1kWJmEfCWyEKFKuoBVtoYaXUl2pWM4vvzBcFP/pztrRWoGHlK+LA
x3ZBkR9VSwkpCeaNnKTzqErV+rgXsC4/niwtCBbSCkpVWhR2NyyC+K1ft8Y4
oTKljczz1fPN4BUQWfCtePWbmzaI5bpLzm7a2LNz586RkWFS4vaUnsgPpofU
Jhnk0df0+ezs7COP9IkePe0qlaKv5zx0ZjgM2fKUtsiKbwQM+/c11cFfnu91
i1vGGskdqgmYtqoGvomTeDif6vCkJuoRkDtbhEc73Tt69CX2d7K7/HroPFkw
6vBJWs/Y2BhDox7m9FjSXY7snrAXH7hy9Lnk3Qtv++5mvmXTtsfpCYqtgw38
memZUE9px4RT7gr9xpx+nLwrcVmmxEu0wE2NS8o/9Ts+AImvLXN8741//Rug
nwbuhhlFSvdOWeYloKwS8Op5fMLuAO8VMtD0lFldtIUwE7NKWayokPr4I/WX
7Mq61sFnoGOZeWp0dOrUcSX80HvjFjtSnZfSDX5otUw3MjAWXwiEIEb31XIG
TecnC28LGLGttz/rY+H2wtH4wPSWwmPWffCHBvTaThv8Ub/YhKKmvQgbxWfN
aX3coiBhqtU5yrWtnL50UEsZQeoo0mdn6LaDlkfzoz45gZFudYN0q4I7W+uM
+lG6ej3nlvN4DI66ADvUGnXZ3u2+lhYYUHjytdAJszXFKdDRiqIOyPQwifdZ
Wg900ti4pKAngSBosuXRyqJczwacmiMte70WMpDeR+KXCbnmUainPHKiQDdK
5cU6e6sS3+hZR0iho9zJo5TefEGKv/COJgd7Hg9rhu2QgXL17U/eul4MRoxt
H6na39+PsRVRZ1mhTvNnnYz077o5csdCr8gcECvVYL0iAQyTWCiiYSIT/cn7
V2mUffeypaZR9mgvhX6EH0AYMhPfdQVU+3e4C1IZDEqam5rEl0kYS9sfTzgO
BJZkmVKz7SQalBTUPxa1lVu3jDYCayda/KQ3mpycrK2txUfuGRlfjgR7f1uG
5Qv+aG9rI/4sHoyaNZLT8BZtB5F8IjWP5R69CEXGjuCgUfxn77Wkv9b2bSGr
YVK4A7ajycB1UERPTzdoBXeWhCyBrQD3sZYrEIW17A2Yx9vIyIh/m2GnfGii
vIjP9Ey2jPlYAX/2UoC58AzwE37NBP61Ay5/hmp8K8+36zxWI/TfL9QI8nYF
XrL3Iy4jL9UTSAqtwlPjqVFyWkoZoerpeW22AA6hbD0LtMNosbdDJYgrqu2l
3v6UJqJkh/F2ipy1vT8frKrXE0k7iJBre5CAt60ia7Fz2sj5MwA+fLH7z3PN
AI9J/fX//g2Iu+1/eJpphQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{235, 136},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->792469357]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->965972949],

Cell["\<\
In the default projection for polygons, the coordinates are literal \
longitude, latitude values:\
\>", "ExampleText",
 CellID->16223613],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Gray", ",", 
     RowBox[{"CountryData", "[", 
      RowBox[{"\"\<UnitedStates\>\"", ",", "\"\<Polygon\>\""}], "]"}]}], 
    "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->317218020],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWEtrFEEQnuzO7CPP3byzrBpJokkEjxqCF9E8UIwgCIIgLEFIJMGQBCRC
NHgzuehP8JSDHvP/2qqe6pnumurd2XjQ4MJWTfd89ezq6t591jrcervbOtze
bE2v7bf2trY3D6ZX3+/DVLEnCIIL+L6ZDOBZwZP+XigF3KZTQIvwKijqof4U
8AtD5DV6X7A4ny+QOPI68ZD4KHs/hmZQUOlPIl/W5htIq8nb2CWbarwtPyjo
C8J07JHwIiQbtY46NaJkI2TcMJKIxZdBhXp+BGhoFqarCMuXliyRZNh1jiqW
TV1PUZIHkhggBC01T1VGY18uX9J8NdisHf3fqhwtkaMuzK7J+jD2H0Sfd/eM
dJOL7j29Ytmo58TFOcE+b/dhw2tdzg+zsdTf7XMh3uzZc8em2BnOMWU6oeQw
fSIWTUVaKU/dS/hux2IP/QP8VXuP4554KWhdYhp20LPAxh8SPXk8wuEP4p5z
rM34CEjh5ORkPrGZ0SBUFkoVQeq2FXGnXoN6npLcIvAI+C2aD5w7lUHzvK0D
CUHqDkmn1gcYcg1ICRALxF0k6l5niNQTrmuVEMbn+YwuRJTpTYDhAQcahGRZ
1rsCpEqIiDyRo3kMpBcVFmPFODebkSpanSUijpJDgKpZninqmyaWQmbVpcrj
42VaC1yjOvA+qiPbxzpZWRRrK4+VJco9yo2j9nKsPf6klkKKsexYc+7pGmbX
KHqOptDGIkXQTzkpemTy+HuXZWGIKvZyGbgP5KGrQVjne8AfUexytc1RteGt
dcXJkqniGeCvnJrgOm4Aed22UptAWrSbXO3jwLfgzZxXO56G7wAx69WOd5pd
QMw4uTA90OQCUXuAmlZSbUs55uMhIIekwdMTO4z7gXwEDdfEWuTd1ESAUkcg
1fRVoLXq/PZ/ZFUdPjZd350qLpEelPsE4EaaqcDffatAjp2Y+Prg+f6Z/HdX
v5dkm97VL5OsvXMabS0dU1+w+9pkxrLRy5ETXk8iyortCfaXKa83mKkvLP+p
7/41NFzLRols/GB52H0fQke+gpKJxIswKTxLTdIDEX8K+NGk8jI9KtM7uf0z
kB9X+Xsvlz9lOR/tQpep1zNhpQd9eVTybkL5b3SeyOuNiO/6gFfWadSXqT3E
7dMZeZ1FV/XWH3p5ACis3AbwAa8fiMQ+hbrwdBwUPTCICeD9ba0a5CQhZV2Y
lzqLpuLm2M6VJ8MYId4PRshm/vuupGmYMhApu96lKjPVfkDVPgbczLtVL3Vp
bhtX96aKT9ZQSfVqn9Rceo/OsorjOZeW7tEhSeNZWSbbcv4LSu7mqHmXTvuS
Y1+q9h3rpuwiTWXs0B0lJIS/yrYBseRac/ZkRCuC94jljK04vnR3o+2XrPdq
+/DwwOsH7q3nTOqJanfDQokNgG0o6Vbhy7w9fsE831DS7SKPJv/vxTyacPiv
/zPQacz/g+qEF+Nzqs7sf9XhpDl3cIluB/dTM7PzDP+lZ7P/6AQ9vwHksjQT
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21250279]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->677826035],

Cell["Show all countries in schematic form:", "ExampleText",
 CellID->148889908],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Gray", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"CountryData", "[", 
       RowBox[{"#", ",", "\"\<SchematicPolygon\>\""}], "]"}], "&"}], "/@", 
     RowBox[{"CountryData", "[", "]"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19062617],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyFWNtuHEUQnczM3u/rrLO78WW9vqzXrInXC+ISEARwiBXlIYB548GKkJIH
BAoRvCCYH4BHBPxdvmSo6j7dU1szBkuecvVUna6qPtXd4yfXr55/+931qxfP
riefv7z+4fmLZz9OHn7/koaiW0EQvKbfb4YB/Z3SX+b3dZqSvOn5kJ5hkiR/
G+0zekak/WO0T+kZ36CxZYm0v7zG734HWt2MXqjRmh9lz19Z48lS8xM0lV7x
yBUa/HNN+wOIZT9aJ+0nkmWSHYVU8lY1GvwZVnd8NOy7QObvQNYEBj0DnnXT
ezRJOwHO25AlIK1bzUlWSa5I3iE58G/bpM0Q0/mNbxnxjOQw9/aIZIPkcs2X
17ND2gHmLyGfGaw2vVWPtKmyOiY58LVhqz5pE5ItVDtETrf/12qBSEY+avbZ
IdklGWPGBXIMYlto+zPyK8bR7AofRj4FCyJgWOtPkOEucosVCxZqRSMgSJs8
Uldwotj6AT1HIrNLZdXyVmMa3IbVqojtQg99fT+m513hOUc0HfBuaKw+oucW
aVuwOlZ4vdR2XajGb/s5XA49cIsjqEJWMNfYW/O67JHcANdC1CcumKOkKh8i
TovUM4thX/HgHtCnoupFqHp9dz1iHzENwMoIbHD5h8jQrkoP1ptY8RjWMXrc
8oGZfAhebJvp/czgfLRm34BdBXOOge6qurbWSt/3Kyqr1kDVDkn2lcewEOFD
RMX4NcQzA3N4vK68Vt5Ljrr6cyUPcp3aQU6N9ZrckOmhmeGDNNtH9kluIJ6G
ypjh7hmP97B6x/BwfHFs6giEivd6F6NvkJyiDozSguT8y2C3jNJyg6tRhfce
vKuYw3lVCnK03kvMEaXZ2Reiig6tjvEKGOS4ktu1PJrbAUuQ+0CT9agDTZ9e
MVhw5hFjERdHPVFIDSAxd0+N16nC5Zj47NpRnlXV02XY2P7QO3ElWT9vXRW3
FWoZWRyBO0HAa9NIsn2K+bGlvFxV53hvveT8tYK6a91xlcdPPNKJQuqDLz0V
w/01j01YtbCSeq98q2B8YrwZYwRvXucuyfMCBu8aaz7z+eR4E4xl65XgpOts
uxcfoXZzwYxcRdY6vIV6zAQjy8pr7LG3UQPXgdKqDaRjxZuwILcMkRk1Q25x
LrpQrUEXGZ+ibwKzG3H3sKyIHEJgVtPs5DlLsptNFoHuPUbSbEqwk5XTbEdw
q5C/TTDqESLcKOBlWSDs+CwOkMXXCU4ngzNNspsdM+JKRTv2/lz3vYKafeWz
3U/zndVy3FG3Ko75S9GVPYMwTfMd7U5JV3X37XCZ2H02AmuDQN/pO+B2GRWf
qveldT6AIRckm1hVg2juRTJ+fjtEFFWsgzvJItTzQkTX8dG5E2UE6dZaRjWD
lz6/WH0kGOg61KK3Bat2BLquyVaanSFPC1hYcl1t7qQL0toKwTF+RyBdiY6Q
vRn7zOdJdp939ywXY1OsYiXJ7+dS/yJxX3TstRQM0nV0Z1nuJoWZ2kB6UuAb
+ZpOCjJLxDnjTvkmWNoBalvZv+8iMXV1XyruC8XtII7jjpXW2X3DRKJuXXQd
Z8hfdfeFnf0q7sJ6AKv87ldH7TtJfg8ZizUpuunJ3CZK59xtPx+iMuXc3EW3
dc6L97N7afZF4fppJPpp5LHdrYRPyweour3XncOWv4+4V8/VXJxXI8luhXeN
16PU7mADYK8gl+btJd72UdmlwrRWj1P7BSD74Bfz5iq15+FvRvvv/7kEt/4F
eRtMsw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->9767172]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->444124004],

Cell["Use a Lambert azimuthal projection:", "ExampleText",
 CellID->31958558],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Gray", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"CountryData", "[", 
       RowBox[{"#", ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<SchematicPolygon\>\"", ",", "\"\<LambertAzimuthal\>\""}], 
         "}"}]}], "]"}], "&"}], "/@", 
     RowBox[{"CountryData", "[", "]"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->471608793],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 169},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->560162209]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->175986872],

Cell[TextData[{
 "Use a Robinson projection, with the longitude of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"90", " ", "\[Degree]"}], TraditionalForm]], "InlineMath"],
 " west as the projection center:"
}], "ExampleText",
 CellID->82973810],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Gray", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"CountryData", "[", 
       RowBox[{"#", ",", 
        RowBox[{"{", 
         RowBox[{"\"\<SchematicPolygon\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"\"\<Robinson\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"-", "90"}]}], "}"}]}], "}"}]}], "}"}]}], "]"}], "&"}], 
     "/@", 
     RowBox[{"CountryData", "[", "]"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->301022969],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->6324177]
}, Open  ]],

Cell["\<\
Use the Lambert azimuthal projection, centered at New York City:\
\>", "ExampleText",
 CellID->103797875],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Gray", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"CountryData", "[", 
       RowBox[{"#", ",", 
        RowBox[{"{", 
         RowBox[{"\"\<SchematicPolygon\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"\"\<LambertAzimuthal\>\"", ",", 
            RowBox[{"CityData", "[", 
             RowBox[{"\"\<NewYork\>\"", ",", "\"\<Coordinates\>\""}], "]"}]}],
            "}"}]}], "}"}]}], "]"}], "&"}], "/@", 
     RowBox[{"CountryData", "[", "]"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->488128011],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->128300393]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->912191634],

Cell["\<\
World maps using the Bonne projection, with two different standard parallels:\
\
\>", "ExampleText",
 CellID->644329003],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Gray", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"CountryData", "[", 
         RowBox[{"#", ",", 
          RowBox[{"{", 
           RowBox[{"\"\<SchematicPolygon\>\"", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"\"\<Bonne\>\"", ",", "\[Phi]"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], "}"}]}], "]"}], 
        "&"}], "/@", 
       RowBox[{"CountryData", "[", "]"}]}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", 
     RowBox[{"{", 
      RowBox[{"40", ",", "85"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->576032394],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->155189434]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Geography, etc.",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->799256],

Cell["Find the area of U.S. in square kilometers:", "ExampleText",
 CellID->100608788],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<UnitedStates\>\"", ",", "\"\<Area\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42559342],

Cell[BoxData["9.63142`*^6"], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21752163]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<UnitedStates\>\"", ",", "\"\<Area\>\"", ",", "\"\<Units\>\""}],
   "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->302046586],

Cell[BoxData["\<\"SquareKilometers\"\>"], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->394509920]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->61794499],

Cell["Find the list of countries that border Germany:", "ExampleText",
 CellID->258659040],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<Germany\>\"", ",", "\"\<BorderingCountries\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->807581890],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Austria\"\>", ",", "\<\"Belgium\"\>", 
   ",", "\<\"CzechRepublic\"\>", ",", "\<\"Denmark\"\>", 
   ",", "\<\"France\"\>", ",", "\<\"Luxembourg\"\>", 
   ",", "\<\"Netherlands\"\>", ",", "\<\"Poland\"\>", 
   ",", "\<\"Switzerland\"\>"}], "}"}]], "Output",
 ImageSize->{371, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->207739066]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->245912364],

Cell["Lengths of borders in kilometers:", "ExampleText",
 CellID->880853690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<Germany\>\"", ",", "\"\<BordersLengths\>\""}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->477404237],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"Austria\"\>", "\[Rule]", "784.`"}], ",", 
   RowBox[{"\<\"Belgium\"\>", "\[Rule]", "167.`"}], ",", 
   RowBox[{"\<\"CzechRepublic\"\>", "\[Rule]", "646.`"}], ",", 
   RowBox[{"\<\"Denmark\"\>", "\[Rule]", "68.`"}], ",", 
   RowBox[{"\<\"France\"\>", "\[Rule]", "451.`"}], ",", 
   RowBox[{"\<\"Luxembourg\"\>", "\[Rule]", "138.`"}], ",", 
   RowBox[{"\<\"Netherlands\"\>", "\[Rule]", "577.`"}], ",", 
   RowBox[{"\<\"Poland\"\>", "\[Rule]", "456.`"}], ",", 
   RowBox[{"\<\"Switzerland\"\>", "\[Rule]", "334.`"}]}], "}"}]], "Output",
 ImageSize->{556, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1383605288]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->407008451],

Cell["Find the standard time zones for Russia:", "ExampleText",
 CellID->11048139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<Russia\>\"", ",", "\"\<TimeZones\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->431490145],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", ",", "9", ",", "10", 
   ",", "11", ",", "12", ",", "13"}], "}"}]], "Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1301145700]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->536068321],

Cell["Find a link to web satellite image of the country:", "ExampleText",
 CellID->152988530],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<France\>\"", ",", "\"\<CenterLocationLink\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->290079659],

Cell[BoxData[
 TagBox[
  ButtonBox[
   PaneSelectorBox[{
    False->"\<\"http://maps.google.com/maps?q=+46+2&z=6&t=h\"\>", True->
    StyleBox["\<\"http://maps.google.com/maps?q=+46+2&z=6&t=h\"\>", 
     "HyperlinkActive"]}, Dynamic[
     CurrentValue["MouseOver"]],
    BaselinePosition->Baseline,
    FrameMargins->0,
    ImageSize->Automatic],
   BaseStyle->"Hyperlink",
   ButtonData->{
     URL["http://maps.google.com/maps?q=+46+2&z=6&t=h"], None},
   ButtonNote->"http://maps.google.com/maps?q=+46+2&z=6&t=h"],
  Annotation[#, "http://maps.google.com/maps?q=+46+2&z=6&t=h", 
   "Hyperlink"]& ]], "Output",
 ImageSize->{305, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->529802499]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24974541],

Cell["Lowest and highest points in the U.S.:", "ExampleText",
 CellID->916960960],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<UnitedStates\>\"", ",", "\"\<LowestPoint\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->246049511],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"DeathValley\"\>", ",", 
   RowBox[{"-", "86.`"}]}], "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->923400231]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<UnitedStates\>\"", ",", "\"\<HighestPoint\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->168022788],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"MountMcKinley\"\>", ",", "6194.`"}], "}"}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1870849195]
}, Open  ]],

Cell["Show only the highest elevation, in meters:", "ExampleText",
 CellID->279596409],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<UnitedStates\>\"", ",", "\"\<HighestElevation\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->322808772],

Cell[BoxData["6194.`"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2054344638]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->439203504],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<France\>\"", ",", "\"\<NaturalResources\>\""}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->48646302],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Antimony\"\>", ",", "\<\"Arsenic\"\>", ",", "\<\"Bauxite\"\>", 
   ",", "\<\"Coal\"\>", ",", "\<\"Feldspar\"\>", ",", "\<\"Fish\"\>", 
   ",", "\<\"Fluorspar\"\>", ",", "\<\"Gypsum\"\>", ",", "\<\"Iron\"\>", 
   ",", "\<\"Potash\"\>", ",", "\<\"Timber\"\>", ",", "\<\"Uranium\"\>", 
   ",", "\<\"Zinc\"\>"}], "}"}]], "Output",
 ImageSize->{380, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->128254400]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->627684696],

Cell["Find countries with antimony as a natural resource:", "ExampleText",
 CellID->45981319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"CountryData", "[", "]"}], ",", 
   RowBox[{
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"CountryData", "[", 
       RowBox[{"#", ",", "\"\<NaturalResources\>\""}], "]"}], ",", 
      "\"\<Antimony\>\""}], "]"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->644510609],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Austria\"\>", ",", "\<\"Bolivia\"\>", ",", "\<\"China\"\>", 
   ",", "\<\"France\"\>", ",", "\<\"Honduras\"\>", ",", "\<\"Myanmar\"\>", 
   ",", "\<\"Serbia\"\>", ",", "\<\"SouthAfrica\"\>", 
   ",", "\<\"Tajikistan\"\>", ",", "\<\"Turkey\"\>"}], "}"}]], "Output",
 ImageSize->{343, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1645602859]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->136193397],

Cell["Find a list of natural hazard types for Peru:", "ExampleText",
 CellID->150290545],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<Peru\>\"", ",", "\"\<NaturalHazards\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->761518707],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Earthquake\"\>", ",", "\<\"Flood\"\>", 
   ",", "\<\"Landslide\"\>", ",", "\<\"Tsunami\"\>", ",", "\<\"Volcano\"\>"}],
   "}"}]], "Output",
 ImageSize->{329, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->905964032]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->232465780],

Cell["Find the regions (provinces) of Canada:", "ExampleText",
 CellID->276358656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<Canada\>\"", ",", "\"\<Regions\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->392538410],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Alberta\"\>", ",", "\<\"BritishColumbia\"\>", 
   ",", "\<\"Manitoba\"\>", ",", "\<\"NewBrunswick\"\>", 
   ",", "\<\"NewfoundlandAndLabrador\"\>", 
   ",", "\<\"NorthwestTerritories\"\>", ",", "\<\"NovaScotia\"\>", 
   ",", "\<\"Nunavut\"\>", ",", "\<\"Ontario\"\>", 
   ",", "\<\"PrinceEdwardIsland\"\>", ",", "\<\"Quebec\"\>", 
   ",", "\<\"Saskatchewan\"\>", ",", "\<\"Yukon\"\>"}], "}"}]], "Output",
 ImageSize->{459, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55483360]
}, Open  ]],

Cell["Give their traditional English names:", "ExampleText",
 CellID->99600417],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<Canada\>\"", ",", "\"\<RegionNames\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->142808476],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Alberta\"\>", ",", "\<\"British Columbia\"\>", 
   ",", "\<\"Manitoba\"\>", ",", "\<\"New Brunswick\"\>", 
   ",", "\<\"Newfoundland and Labrador\"\>", 
   ",", "\<\"Northwest Territories\"\>", ",", "\<\"Nova Scotia\"\>", 
   ",", "\<\"Nunavut\"\>", ",", "\<\"Ontario\"\>", 
   ",", "\<\"Prince Edward Island\"\>", ",", "\<\"Quebec\"\>", 
   ",", "\<\"Saskatchewan\"\>", ",", "\<\"Yukon\"\>"}], "}"}]], "Output",
 ImageSize->{473, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10191436]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->227041248],

Cell["Find the largest cities in Fiji:", "ExampleText",
 CellID->165610869],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<Fiji\>\"", ",", "\"\<LargestCities\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->550120254],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Suva\"\>", ",", "\<\"Central\"\>", ",", "\<\"Fiji\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Nadi\"\>", ",", "\<\"Western\"\>", ",", "\<\"Fiji\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Lautoka\"\>", ",", "\<\"Western\"\>", ",", "\<\"Fiji\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Labasa\"\>", ",", "\<\"Northern\"\>", ",", "\<\"Fiji\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Nausori\"\>", ",", "\<\"Central\"\>", ",", "\<\"Fiji\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Lami\"\>", ",", "\<\"Central\"\>", ",", "\<\"Fiji\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Ba\"\>", ",", "\<\"Western\"\>", ",", "\<\"Fiji\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Sigatoka\"\>", ",", "\<\"Western\"\>", ",", "\<\"Fiji\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Vatukoula\"\>", ",", "\<\"Western\"\>", 
     ",", "\<\"Fiji\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Savusavu\"\>", ",", "\<\"Northern\"\>", 
     ",", "\<\"Fiji\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{528, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->199373871]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Culture & Demography",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->631611536],

Cell["Primary languages used in Spain:", "ExampleText",
 CellID->160457467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<Spain\>\"", ",", "\"\<Languages\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->630062603],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Spanish\"\>", ",", "\<\"Catalan\"\>", ",", "\<\"Galician\"\>", 
   ",", "\<\"Basque\"\>"}], "}"}]], "Output",
 ImageSize->{248, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->459198787]
}, Open  ]],

Cell["Approximate fractions:", "ExampleText",
 CellID->346134646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<Spain\>\"", ",", "\"\<LanguagesFractions\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->347048501],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"Spanish\"\>", "\[Rule]", "0.74`"}], ",", 
   RowBox[{"\<\"Catalan\"\>", "\[Rule]", "0.17`"}], ",", 
   RowBox[{"\<\"Galician\"\>", "\[Rule]", "0.07`"}], ",", 
   RowBox[{"\<\"Basque\"\>", "\[Rule]", "0.02`"}]}], "}"}]], "Output",
 ImageSize->{424, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->271830515]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->43890008],

Cell["Life expectancy and median age for the U.S.:", "ExampleText",
 CellID->387422644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<UnitedStates\>\"", ",", "\"\<LifeExpectancy\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->245216402],

Cell[BoxData["77.85`"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->449759898]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<UnitedStates\>\"", ",", "\"\<MedianAge\>\""}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->240145441],

Cell[BoxData["36.5`"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->402969018]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->749780323],

Cell["Components of population estimates for the U.S.:", "ExampleText",
 CellID->21402103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<UnitedStates\>\"", ",", "\"\<AdultPopulation\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->786720628],

Cell[BoxData["2.00436329`*^8"], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->205361500]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<UnitedStates\>\"", ",", "\"\<ChildPopulation\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->260657042],

Cell[BoxData["6.0811719`*^7"], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->504509771]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<UnitedStates\>\"", ",", "\"\<MalePopulation\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->129788674],

Cell[BoxData["1.4666098`*^8"], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1030282841]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18452934],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<UnitedStates\>\"", ",", "\"\<PhoneLines\>\""}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1881664],

Cell[BoxData["2.68`*^8"], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->803062926]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<UnitedStates\>\"", ",", "\"\<CellularPhones\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->199080200],

Cell[BoxData["2.194`*^8"], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->143875887]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<UnitedStates\>\"", ",", "\"\<InternetUsers\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->645439392],

Cell[BoxData["2.0532668`*^8"], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->55446287]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<UnitedStates\>\"", ",", "\"\<InternetHosts\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->78215352],

Cell[BoxData["1.95138696`*^8"], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->2025326458]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Economics & Trade",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->429909782],

Cell["Export partners for South Africa:", "ExampleText",
 CellID->868471503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<SouthAfrica\>\"", ",", "\"\<ExportPartners\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->375447023],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"UnitedKingdom\"\>", ",", "\<\"UnitedStates\"\>", 
   ",", "\<\"Japan\"\>", ",", "\<\"Germany\"\>", ",", "\<\"China\"\>", 
   ",", "\<\"Italy\"\>"}], "}"}]], "Output",
 ImageSize->{403, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->675704531]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->252327679],

Cell["Major industries in South Africa:", "ExampleText",
 CellID->709174725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<SouthAfrica\>\"", ",", "\"\<MajorIndustries\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14696541],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Automobiles\"\>", ",", "\<\"Chemicals\"\>", 
   ",", "\<\"Fertilizer\"\>", ",", "\<\"Food\"\>", ",", "\<\"Iron\"\>", 
   ",", "\<\"Machinery\"\>", ",", "\<\"Metals\"\>", ",", "\<\"Mining\"\>", 
   ",", "\<\"ShipRepair\"\>", ",", "\<\"Textiles\"\>"}], "}"}]], "Output",
 ImageSize->{375, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2045974656]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->188866693],

Cell["Export commodities:", "ExampleText",
 CellID->43423047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<SouthAfrica\>\"", ",", "\"\<ExportCommodities\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68372410],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Diamonds\"\>", ",", "\<\"Gold\"\>", ",", "\<\"Machinery\"\>", 
   ",", "\<\"Metals\"\>", ",", "\<\"Minerals\"\>", ",", "\<\"Platinum\"\>"}], 
  "}"}]], "Output",
 ImageSize->{375, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1187887628]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12111827],

Cell["GDP in nominal U.S. dollars:", "ExampleText",
 CellID->246394796],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<SouthAfrica\>\"", ",", "\"\<GDP\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180115003],

Cell[BoxData["2.388251922850344`*^11"], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1819381284]
}, Open  ]],

Cell["Adjusted GDP in 1970 U.S. dollars:", "ExampleText",
 CellID->73429218],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<SouthAfrica\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<GDP\>\"", ",", "\"\<Adjusted\>\"", ",", "1970"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->176310130],

Cell[BoxData["8.065814581300273`*^11"], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->47502502]
}, Open  ]],

Cell["GDP in local currency:", "ExampleText",
 CellID->73163393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<SouthAfrica\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<GDP\>\"", ",", "\"\<Local\>\""}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->71844993],

Cell[BoxData["1.374476`*^12"], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->299959330]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->392846233],

Cell["Oil exports in barrels per day:", "ExampleText",
 CellID->219618284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<UnitedArabEmirates\>\"", ",", "\"\<OilExports\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->65514803],

Cell[BoxData["2.5`*^6"], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->140825937]
}, Open  ]],

Cell["Oil reserves:", "ExampleText",
 CellID->659419430],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<UnitedArabEmirates\>\"", ",", "\"\<OilReserves\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->79172094],

Cell[BoxData["9.78`*^10"], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->264874159]
}, Open  ]],

Cell["\<\
Estimated number of years of oil remaining at current production rates:\
\>", "ExampleText",
 CellID->360470755],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CountryData", "[", 
   RowBox[{"\"\<UnitedArabEmirates\>\"", ",", "\"\<OilReserves\>\""}], "]"}], 
  "/", 
  RowBox[{"(", 
   RowBox[{"365", " ", 
    RowBox[{"CountryData", "[", 
     RowBox[{"\"\<UnitedArabEmirates\>\"", ",", "\"\<OilProduction\>\""}], 
     "]"}]}], ")"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->476297354],

Cell[BoxData["111.83021931529719`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->263392043]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Time Series",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->273981319],

Cell["U.S. population estimate for 1990:", "ExampleText",
 CellID->158190665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<UnitedStates\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<Population\>\"", ",", "1990"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->274845636],

Cell[BoxData["2.55538974`*^8"], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104621415]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->172539389],

Cell["Population of the U.S. from 1990 to 1995:", "ExampleText",
 CellID->677574356],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<UnitedStates\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<Population\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"1990", ",", "1995"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->303186326],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1990", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0"}], 
      "}"}], ",", "2.55538974`*^8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1991", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0"}], 
      "}"}], ",", "2.58233346`*^8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1992", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0"}], 
      "}"}], ",", "2.61005155`*^8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1993", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0"}], 
      "}"}], ",", "2.63838877`*^8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1994", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0"}], 
      "}"}], ",", "2.66711107`*^8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1995", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0"}], 
      "}"}], ",", "2.69602775`*^8"}], "}"}]}], "}"}]], "Output",
 ImageSize->{505, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32772875]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->185941572],

Cell["\<\
Find a fit to the U.S. population over the period 1990 to 2005:\
\>", "ExampleText",
 CellID->77013507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fit", "[", 
  RowBox[{
   RowBox[{"Last", "/@", 
    RowBox[{"CountryData", "[", 
     RowBox[{"\"\<UnitedStates\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"\"\<Population\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"1990", ",", "2005"}], "}"}]}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "y", ",", 
     RowBox[{"y", "^", "2"}]}], "}"}], ",", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->267396922],

Cell[BoxData[
 RowBox[{"2.5245540981964302`*^8", "+", 
  RowBox[{"2.8794477419817667`*^6", " ", "y"}], "-", 
  RowBox[{"783.3349089619189`", " ", 
   SuperscriptBox["y", "2"]}]}]], "Output",
 ImageSize->{264, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->321590555]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->170860299],

Cell["Time series for the GDP of Germany:", "ExampleText",
 CellID->826676460],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{"CountryData", "[", 
   RowBox[{"\"\<Germany\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<GDP\>\"", ",", "All"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->233814350],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->300922034]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->186754535],

Cell["GDP time series in current U.S. dollars for each year:", "ExampleText",
 CellID->575224789],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{"CountryData", "[", 
   RowBox[{"\"\<SouthAfrica\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<GDP\>\"", ",", "All"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12176277],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWzuPI0UQ7rXH9q7X3r0770mn1QnMgriMf4AIEI+EzIgUc0K6C+DguIDQ
0QU84hMSIcwf4AQhAdIIpJVIyZDwjyA008+pnvm63TPTsw/kldaPck/VV6/u
qu6Z95ZPHnz8yfLJw/vL+TuPl589eHj/i/nbjx7npP4eY+x5/v/5nPHPm/yj
ennONpsN/5G+3RNv+yxbMfm3SNk6p6zTBf3eE8P6+WvG0nQtvmmavnSR008E
7dY2dmLUZrNmmszYimWKTvjNBGEaxK5MQ/Akv4OCnxaeVUTD6xFtTA3ZV1pJ
bfqatk7ZyrJabvCUWILzW2UKwoKl683MyW5qsaOXcgtwRIBd7pJ68FwyLHiz
QqSOCyA6lHZADXlgIZXhkrHCbfISgzZLJVtlBe1PLsaE0SyIpaAJZPw3SQMs
lUFr8CzREE+dPes8NjQ/NC6QtsWghe8KLsagJM+lq4IMiliaCCrlWahBEU9E
Qzy1QQunYtmBtC0GRVxkjo1MuiPXuayJ+MlQkmOylXyvE56h2iOet8W3myZh
W4Smnewgi0jwaHjrLCMzZuqcR5zZDnjyaW5RDgzn9BnI00HDPE9IthczTot5
VFn2VfE2YcUqS+cosvKqq4UlWD4B8L+BpYC9es7CWVIaWakpT2mEo2Y8V5l7
kU+sWTenh67nnjUeVlBWIWVf9hV1xQA6UMwPT0WBZsahfJHzSCIrOWkf/nko
pVIyF1ShJbtxweP2bG84Z/Vk54BI45Jm8X9+fv6KYpl/NCxfBrQzQDvmryVn
O1O0O9Fo4hBW6Ynf+1qeU0Co0KOCKXutW50k+4Fm/+WPP/y5eeP17559+81v
rVSoyphoGX9/8H7KZfz71pvfW/JK8u/GFC+tOX73j9//2Xy0TD/85ee/KI4y
rjayq96blL3H3zmUXx99+hOHUv4eVfVq8MjCo28Z/86FiLRsHlUkysF9eaFl
6TZCA/JyKr6MqWl9MT7t1uqS/RG1ui/qy+gOunbQROKjDvKlRRlvG3zUlwOF
eF1schXLGmnjxHdefS+qO0J9FXHlDTBOJQvGMXbUHRCpsayvssA0oQKAftVd
lXyXZLCjAxbbI6zJXTC3DCJrsk5XZhNJ8ZYQlc1daqByxa+GlR2x1BhpyKKR
k/AGWhltaRJmfYc6qN4V6sjCzQZwCiKsjULTQpDik+jOlKnWUJKHVutuUmiV
SbVuBXmJZpEjswbYkbEKpaHOIrIbLGMH7zVU+n/xW2mctachxyVYjRdBWvVc
kEvjbjZWl7pUwJuY2cPaBHB352FJ6FfaSkKP0ta4Jkq/5IRczDd6u91Z+L8A
Es0D2hoXCpouXm7QwXZGOTIDgYSqlaY2rRH7HniWy5vAm/sDWlcE3HgDl8fR
dDID3g3Fd+HtXxD7BAQEot2+EBiW4xGtMQzk4TOg5wB4OAG0UCABXpceHvlK
duiSCaCN47lJwaK9NadsddEE0CLCktEzpJdRxyBfTQCtMaLQqeIUeGcYKJQG
zVBRqnVSUAfTroFBqXoaEK5oZQwtxeiSYtUrURsaj2a+3jSaZqZbiNvgILVC
S5fmDuqwwUGgmjQzCHxQJ4MPxOt2MraLO29nKOQjY4v67UzPabWoKqDVbZ+o
ZTpRu5ybYrLvUDFIudApHtUPaBxaJUeFIFVMB4ILs/wZEOmBZs0N1PLdQbPq
CgnNWtSpVSfdIpLSB5pm+XNeRUaNSpHJoXq+M+FIkqqg1YqzEj7LqQAfdeYh
CbPaTYeRaIXHfMscdHV6G8Re3Q/k272HhwmN60APCO+m/Q0xZuwDSj8ft3E0
Qne4bcse9CJjn0b08414Dj2UNNCCjH0a0OmngqaNbw+L6c3IPgHjaI2vDgV8
JT4vOnpqbHGI4Sz7Wx5chBpf3dW6dTuJZo9ac8hcPTJY6YS5uaCq36PX1n2o
EL3sgw2zVHVf9yPFjquzii+v0WGVX2dTgZJTEKnzFWgS0I4yKs6Q2rSZqKpt
nbyxUil6nToMtH+NisT6kaGP9OhRy6Ex7ZXtTSpKWYVc9YyM3AMavzPpTrVa
ZXWXd0Z1Vt9vh6EOoqsbr123HsHQqjNX096jE3jVWSNWVXV9DlSi3kmzM8//
wfr6RiT81NtF3IgUd38xKT92Zq2Cl1Kwh96cQ5/sMqXq5ZTiwfcTkWenOr+f
KNZ2e3F3WlG89bXVr00xvM1F2h3oCaKpscm1KG2LLXbroZ3L3mIPVUXtutiH
kO2rNrZ7wKTtOJnWiahcc7LeGYxQUu+cE8s5YjM0J+stoCbOeVq/EflaUL1P
9cV5Y3v/Aceb3lo=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2574298]
}, Open  ]],

Cell["GDP time series in 1970 U.S. dollars:", "ExampleText",
 CellID->619627052],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{"CountryData", "[", 
   RowBox[{"\"\<SouthAfrica\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<GDP\>\"", ",", "\"\<Adjusted\>\"", ",", "1970"}], "}"}], 
      ",", "All"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->143632279],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->73088645]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1020263627],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CountryData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CountryData"]], "InlineFormula"],
 " includes applicable data on oceans:"
}], "ExampleText",
 CellID->391654322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<PacificOcean\>\"", ",", "\"\<Area\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->391577957],

Cell[BoxData["1.55557`*^8"], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->328692367]
}, Open  ]],

Cell["Find the list of oceans:", "ExampleText",
 CellID->283523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", "\"\<Oceans\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->153383683],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ArcticOcean\"\>", ",", "\<\"AtlanticOcean\"\>", 
   ",", "\<\"IndianOcean\"\>", ",", "\<\"PacificOcean\"\>", 
   ",", "\<\"SouthernOcean\"\>"}], "}"}]], "Output",
 ImageSize->{483, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->158812827]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->103304442],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CountryData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CountryData"]], "InlineFormula"],
 " includes applicable data on the world as a whole: "
}], "ExampleText",
 CellID->205162027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<World\>\"", ",", "\"\<Population\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->373708276],

Cell[BoxData["6.525170264`*^9"], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->238823414]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->218749633],

Cell[TextData[{
 "For groups, ",
 Cell[BoxData[
  ButtonBox["CountryData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CountryData"]], "InlineFormula"],
 " gives lists of values:"
}], "ExampleText",
 CellID->384037465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<SouthAmerica\>\"", ",", "\"\<Population\>\""}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->62311879],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3.8747148`*^7", ",", "9.182015`*^6", ",", "1.86404913`*^8", ",", 
   "1.6295102`*^7", ",", "4.5600244`*^7", ",", "1.3228423`*^7", ",", 
   "199509.`", ",", "751218.`", ",", "6.158259`*^6", ",", "2.7968244`*^7", 
   ",", "449238.`", ",", "3.463197`*^6", ",", "2.6749114`*^7"}], 
  "}"}]], "Output",
 ImageSize->{553, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->741952112]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->733366652],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CountryData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CountryData"]], "InlineFormula"],
 " can give information in appropriate date ranges for some former \
countries:"
}], "ExampleText",
 CellID->2305049],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<FormerSovietUnion\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<Population\>\"", ",", "1970"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->53048723],

Cell[BoxData["2.42781513`*^8"], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63549130]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<FormerYugoslavia\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<Population\>\"", ",", "1990"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->191887962],

Cell[BoxData["2.2816912`*^7"], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->63897456]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->95609238],

Cell["Plot the GDP of both Russia and the former Soviet Union:", "ExampleText",
 CellID->349158017],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"CountryData", "[", 
     RowBox[{"#", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "\"\<GDP\>\"", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1970", ",", "2005"}], "}"}]}], "}"}]}], "]"}], "&"}], "/@", 
   
   RowBox[{"{", 
    RowBox[{"\"\<Russia\>\"", ",", "\"\<FormerSovietUnion\>\""}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->52114598],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{207, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90055703]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellLabel->"In[2]:=",
 CellID->43737718]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["\<\
Plot population against area for all countries, with a tooltip for the \
country name:\
\>", "ExampleText",
 CellID->202933873],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogLogPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Tooltip", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"CountryData", "[", 
         RowBox[{"#", ",", "\"\<Area\>\""}], "]"}], ",", 
        RowBox[{"CountryData", "[", 
         RowBox[{"#", ",", "\"\<Population\>\""}], "]"}]}], "}"}], ",", 
      RowBox[{"CountryData", "[", 
       RowBox[{"#", ",", "\"\<Name\>\""}], "]"}]}], "]"}], "&"}], "/@", 
   RowBox[{"CountryData", "[", "\"\<Countries\>\"", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->213010404],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJw9lnk41Xkbxi1TIiKRpaznOOd39t85FOqU29LbMval7BU1bVrHkkGbXZjQ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      "]]}, {}}, {
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.790102552776862`, 16.222302501400268`}}]},
      "\"Greece\""],
     Annotation[#, "Greece", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{5.840641657373398, 11.535215192944289`}}]},
      "\"Grenada\""],
     Annotation[#, "Grenada", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.598093477340107`, 16.3246864787137}}]},
      "\"Guatemala\""],
     Annotation[#, "Guatemala", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{8.675904882571059, 15.092818114157588`}}]},
      "\"West Bank\""],
     Annotation[#, "West Bank", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.38087407255583, 17.168017360498244`}}]},
      "\"Afghanistan\""],
     Annotation[#, "Afghanistan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.266323478588333`, 14.95068618593943}}]},
      "\"Albania\""],
     Annotation[#, "Albania", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.683341870966741`, 17.29235858553259}}]},
      "\"Algeria\""],
     Annotation[#, "Algeria", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6.148468295917647, 11.111477278219999`}}]},
      "\"Andorra\""],
     Annotation[#, "Andorra", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.036010618333066`, 16.55570837571923}}]},
      "\"Angola\""],
     Annotation[#, "Angola", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4.624972813284271, 9.393827915410107}}]},
      "\"Anguilla\""],
     Annotation[#, "Anguilla", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6.092666427616949, 11.296236040895817`}}]},
      "\"Antigua and Barbuda\""],
     Annotation[#, "Antigua and Barbuda", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.833234503732365`, 17.46282625814745}}]},
      "\"Argentina\""],
     Annotation[#, "Argentina", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.302263672493496`, 14.922781584662626`}}]},
      "\"Armenia\""],
     Annotation[#, "Armenia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{5.262690188904886, 11.494812409543302`}}]},
      "\"Aruba\""],
     Annotation[#, "Aruba", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.85502163467659, 16.808359177782435`}}]},
      "\"Australia\""],
     Annotation[#, "Australia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.337023259978457`, 15.91611189380786}}]},
      "\"Austria\""],
     Annotation[#, "Austria", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.369055094550527`, 15.938323681203348`}}]},
      "\"Azerbaijan\""],
     Annotation[#, "Azerbaijan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9.542517684314515, 12.672200021804963`}}]},
      "\"the Bahamas\""],
     Annotation[#, "the Bahamas", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6.499787040655854, 13.481184017689303`}}]},
      "\"Bahrain\""],
     Annotation[#, "Bahrain", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.877568578558138`, 18.751526696967378`}}]},
      "\"Bangladesh\""],
     Annotation[#, "Bangladesh", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6.066108090103747, 12.502024181523282`}}]},
      "\"Barbados\""],
     Annotation[#, "Barbados", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.24336843027387, 16.098969914519824`}}]},
      "\"Belarus\""],
     Annotation[#, "Belarus", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.326399574248013`, 16.15728924835936}}]},
      "\"Belgium\""],
     Annotation[#, "Belgium", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.041770140336135`, 12.484919552600571`}}]},
      "\"Belize\""],
     Annotation[#, "Belize", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.63177459880861, 15.916861330022503`}}]},
      "\"Benin\""],
     Annotation[#, "Benin", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3.975936331171799, 11.065762979305855`}}]},
      "\"Bermuda\""],
     Annotation[#, "Bermuda", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.757902880692196`, 14.56494733060338}}]},
      "\"Bhutan\""],
     Annotation[#, "Bhutan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.909528994736778`, 16.013739630626098`}}]},
      "\"Bolivia\""],
     Annotation[#, "Bolivia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.842107129893346`, 15.178914675001392`}}]},
      "\"Bosnia and Herzegovina\""],
     Annotation[#, "Bosnia and Herzegovina", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.305301410804192`, 14.385953237298734`}}]},
      "\"Botswana\""],
     Annotation[#, "Botswana", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.956983378713003`, 19.029970865608313`}}]},
      "\"Brazil\""],
     Annotation[#, "Brazil", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{5.030437921392435, 9.987139125031739}}]},
      "\"British Virgin Islands\""],
     Annotation[#, "British Virgin Islands", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{8.660427359502146, 12.809533055242014`}}]},
      "\"Brunei\""],
     Annotation[#, "Brunei", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.616474340598787`, 15.867092474233623`}}]},
      "\"Bulgaria\""],
     Annotation[#, "Bulgaria", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.521613046110351`, 16.366648514070217`}}]},
      "\"Burkina Faso\""],
     Annotation[#, "Burkina Faso", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.427639758257062`, 17.72761328021495}}]},
      "\"Burma\""],
     Annotation[#, "Burma", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.233869854519936`, 15.80089372350654}}]},
      "\"Burundi\""],
     Annotation[#, "Burundi", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.10647328030742, 16.44004312638387}}]},
      "\"Cambodia\""],
     Annotation[#, "Cambodia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.071995970040541`, 16.59045562683749}}]},
      "\"Cameroon\""],
     Annotation[#, "Cameroon", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.116561474711542`, 17.27992940632845}}]},
      "\"Canada\""],
     Annotation[#, "Canada", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{8.302265794873367, 13.112658436440599`}}]},
      "\"Cape Verde\""],
     Annotation[#, "Cape Verde", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{5.568344503761097, 10.694283086332076`}}]},
      "\"Cayman Islands\""],
     Annotation[#, "Cayman Islands", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.342276115256812`, 15.198291504264287`}}]},
      "\"Central African Republic\""],
     Annotation[#, "Central African Republic", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.065490763232043`, 16.061307709661413`}}]},
      "\"Chad\""],
     Annotation[#, "Chad", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.537052480040025`, 16.595807929573613`}}]},
      "\"Chile\""],
     Annotation[#, "Chile", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.076956939621923`, 20.974201370789217`}}]},
      "\"China\""],
     Annotation[#, "China", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.945582222626037`, 17.620282773402348`}}]},
      "\"Colombia\""],
     Annotation[#, "Colombia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{7.682482446534506, 13.563532766849745`}}]},
      "\"Comoros\""],
     Annotation[#, "Comoros", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{5.466793516519938, 9.8022297204619}}]},
      "\"Cooks Island\""],
     Annotation[#, "Cooks Island", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.841539776191796`, 15.263143873939287`}}]},
      "\"Costa Rica\""],
     Annotation[#, "Costa Rica", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.94273900380909, 15.328378537438137`}}]},
      "\"Croatia\""],
     Annotation[#, "Croatia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.616023422973795`, 16.235432809448476`}}]},
      "\"Cuba\""],
     Annotation[#, "Cuba", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9.132378830506472, 13.624245930859885`}}]},
      "\"Cyprus\""],
     Annotation[#, "Cyprus", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.27550548873721, 16.140741976208137`}}]},
      "\"Czech Republic\""],
     Annotation[#, "Czech Republic", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.667970784665059`, 17.838231827888258`}}]},
      "\"Democratic Republic of the Congo\""],
     Annotation[#, "Democratic Republic of the Congo", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.67113905526418, 15.504536797933813`}}]},
      "\"Denmark\""],
     Annotation[#, "Denmark", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.043249494911286`, 13.565897253380216`}}]},
      "\"Djibouti\""],
     Annotation[#, "Djibouti", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6.625392368007956, 11.271286931019775`}}]},
      "\"Dominica\""],
     Annotation[#, "Dominica", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.794050135837551`, 15.986604461417683`}}]},
      "\"Dominican Republic\""],
     Annotation[#, "Dominican Republic", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9.616272037895989, 13.695414223694673`}}]},
      "\"East Timor\""],
     Annotation[#, "East Timor", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.555179019968953`, 16.38353088746816}}]},
      "\"Ecuador\""],
     Annotation[#, "Ecuador", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.81695950772938, 18.101056894762618`}}]},
      "\"Egypt\""],
     Annotation[#, "Egypt", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9.954180666851647, 15.726894181763473`}}]},
      "\"El Salvador\""],
     Annotation[#, "El Salvador", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.24177956093926, 13.10670746060791}}]},
      "\"Equatorial Guinea\""],
     Annotation[#, "Equatorial Guinea", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.706186961802517`, 15.25807607831902}}]},
      "\"Eritrea\""],
     Annotation[#, "Eritrea", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.719427421682939`, 14.10450027507599}}]},
      "\"Estonia\""],
     Annotation[#, "Estonia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.935182475226718`, 18.14096453955981}}]},
      "\"Ethiopia\""],
     Annotation[#, "Ethiopia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9.813015649372053, 13.642125749215008`}}]},
      "\"Fiji\""],
     Annotation[#, "Fiji", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.731230076556344`, 15.470923819547586`}}]},
      "\"Finland\""],
     Annotation[#, "Finland", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.212258924507156`, 17.943486878804514`}}]},
      "\"France\""],
     Annotation[#, "France", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{8.334951631422454, 12.439926634782557`}}]},
      "\"French Polynesia\""],
     Annotation[#, "French Polynesia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.497498949590026`, 14.124707761129102`}}]},
      "\"Gabon\""],
     Annotation[#, "Gabon", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9.332558004700433, 14.205974373897238`}}]},
      "\"The Gambia\""],
     Annotation[#, "The Gambia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.151955596748616`, 15.323575770600623`}}]},
      "\"Georgia\""],
     Annotation[#, "Georgia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.785549882561153`, 18.230068405411547`}}]},
      "\"Germany\""],
     Annotation[#, "Germany", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.386141667270834`, 16.8911828108385}}]},
      "\"Ghana\""],
     Annotation[#, "Ghana", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.790102552776862`, 16.222302501400268`}}]},
      "\"Greece\""],
     Annotation[#, "Greece", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{5.840641657373398, 11.535215192944289`}}]},
      "\"Grenada\""],
     Annotation[#, "Grenada", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.598093477340107`, 16.3246864787137}}]},
      "\"Guatemala\""],
     Annotation[#, "Guatemala", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.41250534508067, 16.034905219395885`}}]},
      "\"Guinea\""],
     Annotation[#, "Guinea", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.494602007530922`, 14.24710594391369}}]},
      "\"Guinea-Bissau\""],
     Annotation[#, "Guinea-Bissau", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.27825376249018, 13.528137771012135`}}]},
      "\"Guyana\""],
     Annotation[#, "Guyana", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.23099111917458, 15.944568232131585`}}]},
      "\"Haiti\""],
     Annotation[#, "Haiti", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.627057399015142`, 15.768300841662635`}}]},
      "\"Honduras\""],
     Annotation[#, "Honduras", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6.9957661563048505`, 15.756099431254038`}}]},
      "\"Hong Kong\""],
     Annotation[#, "Hong Kong", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.440677300762605`, 16.13043332785163}}]},
      "\"Hungary\""],
     Annotation[#, "Hungary", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.542484267211773`, 12.584368660432974`}}]},
      "\"Iceland\""],
     Annotation[#, "Iceland", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15.005665331519285`, 20.806801319926244`}}]},
      "\"India\""],
     Annotation[#, "India", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.467544034794303`, 19.209488597432202`}}]},
      "\"Indonesia\""],
     Annotation[#, "Indonesia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.315072989451554`, 18.04675287774095}}]},
      "\"Iran\""],
     Annotation[#, "Iran", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.987853220231734`, 17.149749105225617`}}]},
      "\"Iraq\""],
     Annotation[#, "Iraq", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.160242542301033`, 15.22152053279085}}]},
      "\"Ireland\""],
     Annotation[#, "Ireland", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9.941264916870159, 15.702657476738544`}}]},
      "\"Israel\""],
     Annotation[#, "Israel", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.615629371541592`, 17.876517564607404`}}]},
      "\"Italy\""],
     Annotation[#, "Italy", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.68373437651773, 16.698739925161952`}}]},
      "\"Ivory Coast\""],
     Annotation[#, "Ivory Coast", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9.3048320350689, 14.785995492519909`}}]},
      "\"Jamaica\""],
     Annotation[#, "Jamaica", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.842212871367895`, 18.666942893160137`}}]},
      "\"Japan\""],
     Annotation[#, "Japan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.432799420490943`, 15.531247145846653`}}]},
      "\"Jordan\""],
     Annotation[#, "Jordan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.815149298212988`, 16.512743732074032`}}]},
      "\"Kazakhstan\""],
     Annotation[#, "Kazakhstan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.27534194200141, 17.326080267194612`}}]},
      "\"Kenya\""],
     Annotation[#, "Kenya", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6.698268054115413, 11.486673887825848`}}]},
      "\"Kiribati\""],
     Annotation[#, "Kiribati", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9.788076701024801, 14.773490875892284`}}]},
      "\"Kuwait\""],
     Annotation[#, "Kuwait", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.198544379109382`, 15.464860098660987`}}]},
      "\"Kyrgyzstan\""],
     Annotation[#, "Kyrgyzstan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.374971181991988`, 15.571935552821385`}}]},
      "\"Laos\""],
     Annotation[#, "Laos", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.075799396633869`, 14.65641761201044}}]},
      "\"Latvia\""],
     Annotation[#, "Latvia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9.249561085129464, 15.079719202658579`}}]},
      "\"Lebanon\""],
     Annotation[#, "Lebanon", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.320716527564535`, 14.402169921033712`}}]},
      "\"Lesotho\""],
     Annotation[#, "Lesotho", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.620613270387146`, 14.991262266919733`}}]},
      "\"Liberia\""],
     Annotation[#, "Liberia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.380562969216543`, 15.562995551935474`}}]},
      "\"Libya\""],
     Annotation[#, "Libya", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{5.075173815233827, 10.440127111195098`}}]},
      "\"Liechtenstein\""],
     Annotation[#, "Liechtenstein", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.085214747914744`, 15.051952778949918`}}]},
      "\"Lithuania\""],
     Annotation[#, "Lithuania", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{7.857867559331803, 13.036822918084695`}}]},
      "\"Luxembourg\""],
     Annotation[#, "Luxembourg", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3.339321977944068, 13.032902457277514`}}]},
      "\"Macau\""],
     Annotation[#, "Macau", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.139863172619055`, 14.523788193692855`}}]},
      "\"Macedonia\""],
     Annotation[#, "Macedonia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.282848239589109`, 16.712125287894168`}}]},
      "\"Madagascar\""],
     Annotation[#, "Madagascar", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.68249944894168, 16.349863585138138`}}]},
      "\"Malawi\""],
     Annotation[#, "Malawi", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.706090070579561`, 17.030157011637673`}}]},
      "\"Malaysia\""],
     Annotation[#, "Malaysia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{5.703782474656201, 12.679806807677076`}}]},
      "\"Maldives\""],
     Annotation[#, "Maldives", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.03062193758122, 16.3899543160067}}]},
      "\"Mali\""],
     Annotation[#, "Mali", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{5.755742213586912, 12.898757219104006`}}]},
      "\"Malta\""],
     Annotation[#, "Malta", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9.380445949940484, 10.997438996322042`}}]},
      "\"Marshall Islands\""],
     Annotation[#, "Marshall Islands", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.845748741024885`, 14.907553649964019`}}]},
      "\"Mauritania\""],
     Annotation[#, "Mauritania", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{7.620705086838262, 14.02510351324134}}]},
      "\"Mauritius\""],
     Annotation[#, "Mauritius", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.494837679923357`, 18.476106690158762`}}]},
      "\"Mexico\""],
     Annotation[#, "Mexico", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6.553933404025811, 11.605422600965156`}}]},
      "\"Micronesia\""],
     Annotation[#, "Micronesia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.42948746227303, 15.254850539750832`}}]},
      "\"Moldova\""],
     Annotation[#, "Moldova", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.6678293725756554, 10.4482217279533}}]},
      "\"Monaco\""],
     Annotation[#, "Monaco", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.262831366134979`, 14.776514583424436`}}]},
      "\"Mongolia\""],
     Annotation[#, "Mongolia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4.624972813284271, 8.342363500380579}}]},
      "\"Montserrat\""],
     Annotation[#, "Montserrat", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.009306655112033`, 17.260737424644848`}}]},
      "\"Morocco\""],
     Annotation[#, "Morocco", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.594352534185024`, 16.782015854216734`}}]},
      "\"Mozambique\""],
     Annotation[#, "Mozambique", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.623645203671268`, 14.513272573772987`}}]},
      "\"Namibia\""],
     Annotation[#, "Namibia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3.044522437723423, 9.501964663660587}}]},
      "\"Nauru\""],
     Annotation[#, "Nauru", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.899418400858922`, 17.096089989394276`}}]},
      "\"Nepal\""],
     Annotation[#, "Nepal", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.634075016069918`, 16.602138578930983`}}]},
      "\"the Netherlands\""],
     Annotation[#, "the Netherlands", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6.866933284461882, 12.10553382015156}}]},
      "\"Netherlands Antilles\""],
     Annotation[#, "Netherlands Antilles", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9.855347177208193, 12.357148603240356`}}]},
      "\"New Caledonia\""],
     Annotation[#, "New Caledonia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.501276359380801`, 15.19912107078313}}]},
      "\"New Zealand\""],
     Annotation[#, "New Zealand", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.771389827002036`, 15.497481202512711`}}]},
      "\"Nicaragua\""],
     Annotation[#, "Nicaragua", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.052162459303275`, 16.418111498730223`}}]},
      "\"Niger\""],
     Annotation[#, "Niger", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.736216236846314`, 18.673064095175974`}}]},
      "\"Nigeria\""],
     Annotation[#, "Nigeria", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.699736927037035`, 16.923846968689364`}}]},
      "\"North Korea\""],
     Annotation[#, "North Korea", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.68788749685885, 15.34111654268974}}]},
      "\"Norway\""],
     Annotation[#, "Norway", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.266509014334005`, 14.745247680564146`}}]},
      "\"Oman\""],
     Annotation[#, "Oman", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.597279918510708`, 18.857605435668813`}}]},
      "\"Pakistan\""],
     Annotation[#, "Pakistan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6.126869184114185, 9.896110408197078}}]},
      "\"Palau\""],
     Annotation[#, "Palau", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.267024926533402`, 14.970929680156697`}}]},
      "\"Panama\""],
     Annotation[#, "Panama", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.045136700990273`, 15.56852001657456}}]},
      "\"Papua New Guinea\""],
     Annotation[#, "Papua New Guinea", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.915954025081284`, 15.610131928044567`}}]},
      "\"Paraguay\""],
     Annotation[#, "Paraguay", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.066440467883025`, 17.131962756514994`}}]},
      "\"Peru\""],
     Annotation[#, "Peru", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.611537753638338`, 18.217548425625637`}}]},
      "\"the Philippines\""],
     Annotation[#, "the Philippines", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.65295157299572, 17.467709845003064`}}]},
      "\"Poland\""],
     Annotation[#, "Poland", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.433784850288433`, 16.161292966169405`}}]},
      "\"Portuguese Republic\""],
     Annotation[#, "Portuguese Republic", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9.531698970787348, 15.184646043993368`}}]},
      "\"Puerto Rico\""],
     Annotation[#, "Puerto Rico", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9.344608992781216, 13.56311325787498}}]},
      "\"Qatar\""],
     Annotation[#, "Qatar", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.742566016044742`, 15.172104959380375`}}]},
      "\"The Congo\""],
     Annotation[#, "The Congo", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.377922902456833`, 16.89695445586193}}]},
      "\"Romania\""],
     Annotation[#, "Romania", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.653137676383277`, 18.78462378615859}}]},
      "\"Russian Federation\""],
     Annotation[#, "Russian Federation", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.178768042270166`, 15.999578408337955`}}]},
      "\"Rwanda\""],
     Annotation[#, "Rwanda", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{5.564520407322694, 10.649914802538357`}}]},
      "\"Saint Kitts and Nevis\""],
     Annotation[#, "Saint Kitts and Nevis", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6.423246963533519, 11.979586012339704`}}]},
      "\"Saint Lucia\""],
     Annotation[#, "Saint Lucia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{5.963579343618446, 11.682060459960008`}}]},
      "\"Saint Vincent and the Grenadines\""],
     Annotation[#, "Saint Vincent and the Grenadines", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{7.987524479848767, 12.121309648130659`}}]},
      "\"Samoa\""],
     Annotation[#, "Samoa", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4.11414718951828, 10.23598762483351}}]},
      "\"San Marino\""],
     Annotation[#, "San Marino", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6.90875477931522, 11.937957878570922`}}]},
      "\"S\[ATilde]o Tom\[EAcute] and Pr\[IAcute]ncipe\""],
     Annotation[#, "S\[ATilde]o Tom\[EAcute] and Pr\[IAcute]ncipe", 
      "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.488751925904618`, 16.991480259690814`}}]},
      "\"Saudi Arabia\""],
     Annotation[#, "Saudi Arabia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.186838856414875`, 16.247887447501387`}}]},
      "\"Senegal\""],
     Annotation[#, "Senegal", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.389185974808175`, 16.16782204339593}}]},
      "\"Serbia\""],
     Annotation[#, "Serbia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6.12029741895095, 11.288656280368508`}}]},
      "\"Seychelles\""],
     Annotation[#, "Seychelles", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.180803751086273`, 15.490071008464856`}}]},
      "\"Sierra Leone\""],
     Annotation[#, "Sierra Leone", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6.54059700502856, 15.2677265457901}}]},
      "\"Singapore\""],
     Annotation[#, "Singapore", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.796407298087043`, 15.50218354805714}}]},
      "\"Slovak Republic\""],
     Annotation[#, "Slovak Republic", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9.917045230468194, 14.492139053183319`}}]},
      "\"Slovenia\""],
     Annotation[#, "Slovenia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.255903439554476`, 13.051496608410483`}}]},
      "\"Solomon Islands\""],
     Annotation[#, "Solomon Islands", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.365555800203934`, 15.890493926742781`}}]},
      "\"Somalia\""],
     Annotation[#, "Somalia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.014289282960322`, 17.670066577243052`}}]},
      "\"South Africa\""],
     Annotation[#, "South Africa", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.497608760858336`, 17.67927878487851}}]},
      "\"South Korea\""],
     Annotation[#, "South Korea", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.131881931887177`, 17.568453303124347`}}]},
      "\"Spain\""],
     Annotation[#, "Spain", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.091483402338923`, 16.839354859531174`}}]},
      "\"Sri Lanka\""],
     Annotation[#, "Sri Lanka", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14.734122593527106`, 17.38569059417184}}]},
      "\"the Sudan\""],
     Annotation[#, "the Sudan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.00316055112021, 13.009105089619363`}}]},
      "\"Suriname\""],
     Annotation[#, "Suriname", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9.762096784344138, 13.849217057285149`}}]},
      "\"Swaziland\""],
     Annotation[#, "Swaziland", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.016922858546332`, 16.013603757938597`}}]},
      "\"Sweden\""],
     Annotation[#, "Sweden", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.628375618880137`, 15.795092951453992`}}]},
      "\"Switzerland\""],
     Annotation[#, "Switzerland", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.129083604002037`, 16.73771210810904}}]},
      "\"Syria\""],
     Annotation[#, "Syria", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.871298965544542`, 15.67652630842833}}]},
      "\"Tajikistan\""],
     Annotation[#, "Tajikistan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.75903226573036, 17.443230229901513`}}]},
      "\"Tanzania\""],
     Annotation[#, "Tanzania", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.149978544437301`, 17.969595602246812`}}]},
      "\"Thailand\""],
     Annotation[#, "Thailand", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10.947027485325746`, 15.605331482761981`}}]},
      "\"Togo\""],
     Annotation[#, "Togo", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6.617402977974478, 11.532551606105406`}}]},
      "\"Tonga\""],
     Annotation[#, "Tonga", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{8.542470998600505, 14.07887970198653}}]},
      "\"Trinidad and Tobago\""],
     Annotation[#, "Trinidad and Tobago", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.005240825977122`, 16.117610633356296`}}]},
      "\"Tunisia\""],
     Annotation[#, "Tunisia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.567792512083484`, 18.09522472141406}}]},
      "\"Turkey\""],
     Annotation[#, "Turkey", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.098275581875239`, 15.377019825015038`}}]},
      "\"Turkmenistan\""],
     Annotation[#, "Turkmenistan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6.063785208687608, 10.133646438744243`}}]},
      "\"Turks and Caicos Islands\""],
     Annotation[#, "Turks and Caicos Islands", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3.258096538021482, 9.249176395761381}}]},
      "\"Tuvalu\""],
     Annotation[#, "Tuvalu", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.371756561171106`, 17.14128569393707}}]},
      "\"Uganda\""],
     Annotation[#, "Uganda", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.310832664784517`, 17.665431282875907`}}]},
      "\"Ukraine\""],
     Annotation[#, "Ukraine", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11.32514905749331, 15.270498779205006`}}]},
      "\"United Arab Emirates\""],
     Annotation[#, "United Arab Emirates", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.408278525629504`, 17.901139381577142`}}]},
      "\"United Kingdom\""],
     Annotation[#, "United Kingdom", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16.080541228770844`, 19.50387355447582}}]},
      "\"United States\""],
     Annotation[#, "United States", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.07948849342072, 15.0508288199392}}]},
      "\"Uruguay\""],
     Annotation[#, "Uruguay", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.011208328038165`, 17.08161551970873}}]},
      "\"Uzbekistan\""],
     Annotation[#, "Uzbekistan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9.409191230721348, 12.242071828970587`}}]},
      "\"Vanuatu\""],
     Annotation[#, "Vanuatu", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.72345009211506, 17.084401929247658`}}]},
      "\"Venezuela\""],
     Annotation[#, "Venezuela", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.705513710429527`, 18.235837013149936`}}]},
      "\"Vietnam\""],
     Annotation[#, "Vietnam", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{8.675904882571059, 15.092818114157588`}}]},
      "\"West Bank\""],
     Annotation[#, "West Bank", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.176794742892366`, 16.827576409398738`}}]},
      "\"Yemen\""],
     Annotation[#, "Yemen", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13.531307759147568`, 16.256019905819645`}}]},
      "\"Zambia\""],
     Annotation[#, "Zambia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12.875388092836774`, 16.375547484555437`}}]},
      "\"Zimbabwe\""],
     Annotation[#, "Zimbabwe", "Tooltip"]& ]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0., 8.342363500380579},
  FrameTicks->{{{{9.210340371976184, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["4", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {11.512925464970229`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["5", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {13.815510557964274`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["6", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {16.11809565095832, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["7", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {18.420680743952367`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["8", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {20.72326583694641, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["9", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {9.903487552536127, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.308952660644293`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.596634733096073`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.819778284410283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.002099841204238`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.156250521031495`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.289781913656018`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.407564949312402`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.206072645530174`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.611537753638338`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.89921982609012, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.122363377404328`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.304684934198283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.458835614025542`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.592367006650065`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.710150042306449`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {14.508657738524219`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {14.914122846632385`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.201804919084164`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.424948470398375`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.60727002719233, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.761420707019587`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.89495209964411, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {16.012735135300492`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {16.811242831518264`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.216707939626428`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.50439001207821, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.72753356339242, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.909855120186375`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.064005800013632`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.197537192638155`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.31532022829454, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {19.11382792451231, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {19.519293032620475`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {19.806975105072254`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.030118656386467`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.21244021318042, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.36659089300768, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.5001222856322, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.617905321288585`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{9.210340371976184, 
       FormBox["\" \"", TraditionalForm]}, {11.512925464970229`, 
       FormBox["\" \"", TraditionalForm]}, {13.815510557964274`, 
       FormBox["\" \"", TraditionalForm]}, {16.11809565095832, 
       FormBox["\" \"", TraditionalForm]}, {18.420680743952367`, 
       FormBox["\" \"", TraditionalForm]}, {20.72326583694641, 
       FormBox["\" \"", TraditionalForm]}, {9.903487552536127, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.308952660644293`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.596634733096073`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.819778284410283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.002099841204238`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.156250521031495`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.289781913656018`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.407564949312402`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.206072645530174`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.611537753638338`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.89921982609012, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.122363377404328`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.304684934198283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.458835614025542`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.592367006650065`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.710150042306449`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {14.508657738524219`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {14.914122846632385`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.201804919084164`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.424948470398375`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.60727002719233, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.761420707019587`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.89495209964411, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {16.012735135300492`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {16.811242831518264`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.216707939626428`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.50439001207821, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.72753356339242, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.909855120186375`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.064005800013632`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.197537192638155`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.31532022829454, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {19.11382792451231, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {19.519293032620475`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {19.806975105072254`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.030118656386467`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.21244021318042, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.36659089300768, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.5001222856322, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.617905321288585`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}, {{{0, 
       FormBox["1", TraditionalForm]}, {4.605170185988092, 
       FormBox["100", TraditionalForm]}, {9.210340371976184, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["4", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {13.815510557964274`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["6", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {2.4849066497880004`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.1354942159291497`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.5263605246161616`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.8066624897703196`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.02535169073515, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.204692619390966, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.356708826689592, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.48863636973214, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.090076835776092, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.7406644019172415`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.131530710604252, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.411832675758411, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.630521876723241, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.809862805379057, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.961879012677683, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.093806555720231, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.695247021764184`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.345834587905333`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.736700896592344`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.017002861746503`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.235692062711331`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.415032991367148`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.567049198665774`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.698976741708323`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{0, 
       FormBox["\" \"", TraditionalForm]}, {4.605170185988092, 
       FormBox["\" \"", TraditionalForm]}, {9.210340371976184, 
       FormBox["\" \"", TraditionalForm]}, {13.815510557964274`, 
       FormBox["\" \"", TraditionalForm]}, {2.4849066497880004`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.1354942159291497`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.5263605246161616`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.8066624897703196`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.02535169073515, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.204692619390966, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.356708826689592, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.48863636973214, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.090076835776092, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.7406644019172415`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.131530710604252, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.411832675758411, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.630521876723241, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.809862805379057, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.961879012677683, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.093806555720231, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.695247021764184`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.345834587905333`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.736700896592344`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.017002861746503`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.235692062711331`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.415032991367148`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.567049198665774`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.698976741708323`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  Method->{},
  PlotRange->{{0., 16.653137676383277`}, {8.342363500380579, 
   20.974201370789217`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->FrontEndValueCache[{{{0., 
       FormBox["1", TraditionalForm]}, {4.605170185988092, 
       FormBox["100", TraditionalForm]}, {9.210340371976184, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["4", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {13.815510557964274`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["6", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {2.4849066497880004`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.1354942159291497`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.5263605246161616`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.8066624897703196`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.02535169073515, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.204692619390966, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.356708826689592, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.48863636973214, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.090076835776092, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.7406644019172415`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.131530710604252, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.411832675758411, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.630521876723241, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.809862805379057, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.961879012677683, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.093806555720231, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.695247021764184`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.345834587905333`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.736700896592344`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.017002861746503`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.235692062711331`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.415032991367148`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.567049198665774`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.698976741708323`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{9.210340371976184, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["4", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {11.512925464970229`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["5", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {13.815510557964274`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["6", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {16.11809565095832, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["7", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {18.420680743952367`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["8", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {20.72326583694641, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["9", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {9.903487552536127, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.308952660644293`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.596634733096073`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.819778284410283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.002099841204238`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.156250521031495`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.289781913656018`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.407564949312402`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.206072645530174`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.611537753638338`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.89921982609012, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.122363377404328`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.304684934198283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.458835614025542`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.592367006650065`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.710150042306449`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {14.508657738524219`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {14.914122846632385`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.201804919084164`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.424948470398375`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.60727002719233, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.761420707019587`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.89495209964411, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {16.012735135300492`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {16.811242831518264`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.216707939626428`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.50439001207821, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.72753356339242, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.909855120186375`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.064005800013632`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.197537192638155`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.31532022829454, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {19.11382792451231, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {19.519293032620475`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {19.806975105072254`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.030118656386467`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.21244021318042, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.36659089300768, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.5001222856322, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.617905321288585`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}, {{{0., 
       FormBox["1", TraditionalForm]}, {4.605170185988092, 
       FormBox["100", TraditionalForm]}, {9.210340371976184, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["4", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {13.815510557964274`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["6", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {2.4849066497880004`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.1354942159291497`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.5263605246161616`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.8066624897703196`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.02535169073515, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.204692619390966, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.356708826689592, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.48863636973214, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.090076835776092, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.7406644019172415`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.131530710604252, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.411832675758411, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.630521876723241, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.809862805379057, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.961879012677683, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.093806555720231, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.695247021764184`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.345834587905333`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.736700896592344`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.017002861746503`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.235692062711331`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.415032991367148`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.567049198665774`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.698976741708323`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{9.210340371976184, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["4", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {11.512925464970229`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["5", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {13.815510557964274`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["6", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {16.11809565095832, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["7", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {18.420680743952367`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["8", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {20.72326583694641, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["9", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {9.903487552536127, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.308952660644293`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.596634733096073`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.819778284410283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.002099841204238`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.156250521031495`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.289781913656018`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.407564949312402`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.206072645530174`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.611537753638338`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.89921982609012, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.122363377404328`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.304684934198283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.458835614025542`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.592367006650065`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.710150042306449`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {14.508657738524219`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {14.914122846632385`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.201804919084164`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.424948470398375`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.60727002719233, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.761420707019587`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {15.89495209964411, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {16.012735135300492`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {16.811242831518264`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.216707939626428`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.50439001207821, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.72753356339242, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {17.909855120186375`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.064005800013632`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.197537192638155`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {18.31532022829454, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {19.11382792451231, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {19.519293032620475`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {19.806975105072254`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.030118656386467`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.21244021318042, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.36659089300768, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.5001222856322, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {20.617905321288585`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}]]], "Output",
 ImageSize->{184, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->443989194]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->169568010],

Cell["Find the 20 largest countries ranked by area:", "ExampleText",
 CellID->252537179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Last", "/@", 
  RowBox[{"Take", "[", 
   RowBox[{
    RowBox[{"Reverse", "[", 
     RowBox[{"Sort", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"CountryData", "[", 
           RowBox[{"#", ",", "\"\<Area\>\""}], "]"}], ",", "#"}], "}"}], 
        "&"}], "/@", 
       RowBox[{"CountryData", "[", "]"}]}], "]"}], "]"}], ",", "20"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->131355932],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Russia\"\>", ",", "\<\"Canada\"\>", 
   ",", "\<\"UnitedStates\"\>", ",", "\<\"China\"\>", ",", "\<\"Brazil\"\>", 
   ",", "\<\"Australia\"\>", ",", "\<\"India\"\>", ",", "\<\"Argentina\"\>", 
   ",", "\<\"Kazakhstan\"\>", ",", "\<\"Sudan\"\>", ",", "\<\"Algeria\"\>", 
   ",", "\<\"DemocraticRepublicCongo\"\>", ",", "\<\"Greenland\"\>", 
   ",", "\<\"Mexico\"\>", ",", "\<\"SaudiArabia\"\>", 
   ",", "\<\"Indonesia\"\>", ",", "\<\"Libya\"\>", ",", "\<\"Iran\"\>", 
   ",", "\<\"Mongolia\"\>", ",", "\<\"Peru\"\>"}], "}"}]], "Output",
 ImageSize->{489, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1778957389]
}, Open  ]],

Cell["Make a table of data for the top 5 countries:", "ExampleText",
 CellID->227693917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Text", "[", 
  RowBox[{"Grid", "[", 
   RowBox[{
    RowBox[{"Prepend", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"CountryData", "[", 
           RowBox[{"#", ",", "\"\<Name\>\""}], "]"}], ",", 
          RowBox[{"CountryData", "[", 
           RowBox[{"#", ",", "\"\<Area\>\""}], "]"}], ",", 
          RowBox[{"CountryData", "[", 
           RowBox[{"#", ",", "\"\<Population\>\""}], "]"}]}], "}"}], "&"}], "/@",
        
       RowBox[{"Take", "[", 
        RowBox[{"%", ",", "5"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<\>\"", ",", "\"\<area\>\"", ",", "\"\<population\>\""}], 
       "}"}]}], "]"}], ",", 
    RowBox[{"Frame", "\[Rule]", "All"}], ",", 
    RowBox[{"Background", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"None", ",", 
       RowBox[{"{", 
        RowBox[{"LightBlue", ",", 
         RowBox[{"{", "LightYellow", "}"}]}], "}"}]}], "}"}]}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->40164904],

Cell[BoxData[
 InterpretationBox[Cell[BoxData[
   TagBox[GridBox[{
      {"\<\"\"\>", "\<\"area\"\>", "\<\"population\"\>"},
      {"\<\"Russia\"\>", "1.70752`*^7", "1.43201572`*^8"},
      {"\<\"Canada\"\>", "9.98467`*^6", "3.2268243`*^7"},
      {"\<\"United States\"\>", "9.63142`*^6", "2.98212895`*^8"},
      {"\<\"China\"\>", "9.59696`*^6", "1.292985544`*^9"},
      {"\<\"Brazil\"\>", "8.511965`*^6", "1.86404913`*^8"}
     },
     ColumnsEqual->False,
     GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {
         RGBColor[0.87, 0.94, 1], {
          RGBColor[1, 1, 0.85]}}},
     GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
     RowsEqual->False],
    "Grid"]], "Text", "TR"],
  Text[
   Grid[{{"", "area", "population"}, {"Russia", 1.70752*^7, 1.43201572*^8}, {
     "Canada", 9.98467*^6, 3.2268243*^7}, {
     "United States", 9.63142*^6, 2.98212895*^8}, {
     "China", 9.59696*^6, 1.292985544*^9}, {
     "Brazil", 8.511965*^6, 1.86404913*^8}}, Frame -> All, 
    Background -> {None, {
       RGBColor[0.87, 0.94, 1], {
        RGBColor[1, 1, 0.85]}}}]]]], "Output",
 ImageSize->{235, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1669503389]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->258597729],

Cell["Literacy fractions in Africa:", "ExampleText",
 CellID->853244656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", "Gray", "]"}], ",", 
      RowBox[{"Catch", "[", 
       RowBox[{
        RowBox[{"ColorData", "[", "\"\<Warm\>\"", "]"}], "[", 
        RowBox[{
         RowBox[{"CountryData", "[", 
          RowBox[{"#", ",", "\"\<LiteracyFraction\>\""}], "]"}], "/.", 
         RowBox[{"_Missing", "\[RuleDelayed]", 
          RowBox[{"Throw", "[", "White", "]"}]}]}], "]"}], "]"}], ",", 
      RowBox[{"CountryData", "[", 
       RowBox[{"#", ",", "\"\<SchematicPolygon\>\""}], "]"}]}], "}"}], "&"}], 
   "/@", 
   RowBox[{"CountryData", "[", "\"\<Africa\>\"", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->91605617],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 156},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->577352694]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->255337795],

Cell["\<\
Find the number of years that estimated oil reserves will last at current \
production rates:\
\>", "ExampleText",
 CellID->209413136],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"Reverse", "[", 
    RowBox[{"Sort", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"CountryData", "[", 
             RowBox[{"#", ",", "\"\<OilReserves\>\""}], "]"}], "/.", 
            RowBox[{"_Missing", "\[Rule]", "0"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"365.", " ", 
            RowBox[{"CountryData", "[", 
             RowBox[{"#", ",", "\"\<OilProduction\>\""}], "]"}]}], ")"}]}], 
         ",", "#"}], "}"}], "&"}], "/@", 
      RowBox[{"Select", "[", 
       RowBox[{
        RowBox[{"CountryData", "[", "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"CountryData", "[", 
           RowBox[{"#", ",", "\"\<OilProduction\>\""}], "]"}], ">", "0"}], 
         "&"}]}], "]"}]}], "]"}], "]"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->340883122],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"913.2420091324201`", ",", "\<\"Morocco\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"204.22374429223743`", ",", "\<\"Canada\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"191.53175591531758`", ",", "\<\"DemocraticRepublicCongo\"\>"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"148.0932987782303`", ",", "\<\"Myanmar\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"147.26191021604959`", ",", "\<\"Iraq\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"141.17199391171994`", ",", "\<\"Albania\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"111.83021931529719`", ",", "\<\"UnitedArabEmirates\"\>"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"109.33976908347213`", ",", "\<\"Kuwait\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"102.73972602739727`", ",", "\<\"Chile\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"91.78323183012185`", ",", "\<\"Iran\"\>"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{559, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->128688233]
}, Open  ]],

Cell["Find the result for OPEC as a group:", "ExampleText",
 CellID->50665096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Total", "[", 
   RowBox[{"CountryData", "[", 
    RowBox[{"\"\<OPEC\>\"", ",", "\"\<OilReserves\>\""}], "]"}], "]"}], "/", 
  RowBox[{"(", 
   RowBox[{"365", " ", 
    RowBox[{"Total", "[", 
     RowBox[{"CountryData", "[", 
      RowBox[{"\"\<OPEC\>\"", ",", "\"\<OilProduction\>\""}], "]"}], "]"}]}], 
   ")"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->234842055],

Cell[BoxData["79.04194870088908`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23129786]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->364615456],

Cell["Find the Antarctic nations:", "ExampleText",
 CellID->974497617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", "\"\<AntarcticNations\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->45414499],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Argentina\"\>", ",", "\<\"Australia\"\>", 
   ",", "\<\"Belgium\"\>", ",", "\<\"Brazil\"\>", ",", "\<\"Bulgaria\"\>", 
   ",", "\<\"Chile\"\>", ",", "\<\"China\"\>", ",", "\<\"Ecuador\"\>", 
   ",", "\<\"Finland\"\>", ",", "\<\"France\"\>", ",", "\<\"Germany\"\>", 
   ",", "\<\"India\"\>", ",", "\<\"Italy\"\>", ",", "\<\"Japan\"\>", 
   ",", "\<\"Netherlands\"\>", ",", "\<\"NewZealand\"\>", 
   ",", "\<\"Norway\"\>", ",", "\<\"Peru\"\>", ",", "\<\"Poland\"\>", 
   ",", "\<\"Russia\"\>", ",", "\<\"SouthAfrica\"\>", 
   ",", "\<\"SouthKorea\"\>", ",", "\<\"Spain\"\>", ",", "\<\"Sweden\"\>", 
   ",", "\<\"Ukraine\"\>", ",", "\<\"UnitedKingdom\"\>", 
   ",", "\<\"UnitedStates\"\>", ",", "\<\"Uruguay\"\>"}], "}"}]], "Output",
 ImageSize->{468, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->139078506]
}, Open  ]],

Cell["Highlight the Antarctic nations:", "ExampleText",
 CellID->150870359],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"CountryData", "[", 
         RowBox[{"#", ",", "\"\<AntarcticNations\>\""}], "]"}], ",", "Orange",
         ",", "LightBrown"}], "]"}], ",", 
      RowBox[{"CountryData", "[", 
       RowBox[{"#", ",", "\"\<SchematicPolygon\>\""}], "]"}]}], "}"}], "&"}], 
   "/@", 
   RowBox[{"CountryData", "[", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->38310679],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylWUlvW1UUfn2Dn+chc2wncZy4STOQphFiFi2lgQp1AVKXLKIKqV0gUKlg
g4A/AEsE/LvsWPIPzDvfff7u4OMUiYXzjs899zvzufc5T65ePf/q66tXL55d
jT55efXt8xfPvhtdfvOyYCW3oii6Lj5fjiKhpwVZ/rmOptOpLC5+XMojnk5/
if40jI/lkQjjL8N4KI/0Jga2ZML4w2FA4lfC183SI2Wp5iwB5icwYAQo+TQV
Xu6oy2Xl95DxG5VUnKW6ML4XqiJUR4HOHPGarPxA8XXHXCCdMGRvkar5mHjC
ojVnd1MYRwR+k1RG7DnxO0JVhboQal2oVUeoLYwDmn3vNULx9J+/rwF3V75u
hJJYghCSdtvkqPiKRBUOFiSDdhYqu6RHEAS1b2CLrzGxMxO3gjogxJoDkVhl
QkFpQsvHxlvDLJfxzcIeCrXqZO/S5ofiqfxtCGskqy2YzCAh8Cv/CwKF0pHV
TSfEodHyF6neltUuYk9HTlgZUTorrNln06lZU/OyoyXUjg8Fa07ZJQljXEJ8
xFbMfIgeIYLUnyj1nhA7aK45LbCn6xtqe+kGiAcsMED0/LA9VgxtORv7Ir5F
8QtFPFd4UFUWwX15DHycO8xWx5hXUBtG/EN5DEV8SPFDRUWPfRYrqyuO7k26
jNzctk1NKqcVfWdjyqihIneFtyxf97kxMXILrMh8Hp7YNnS0JGz+hqkJVofI
7Jq2LFbHjNnNSrXa23H0Bc2UsJn2qWpEVakf5ZgBLOujximV2elCtTB5TRZ2
aHJK6sipcW02wYCJmXYFtWW8c/3i7EhCvAZ35DS+T0Ns9sO6VXh7Tl0GuWww
lxOhlpTdG4sRP6DlMUMAkw/YGLFyhGh2XziIwZItFmR13wzhmQuzj9XWmA/z
jSGbGNXvUwi9vSfUMsu7oQQPKs7M7ndYZofcXTbCrBpimmkRcwfibUbzWKgx
42rms6Fmt6wKmz7wpqxtxLNKsF2CgdcwEAVYTiu00JRg57QiYZBqpEa+gjpX
c97JbAkH/XUSKrBHV0ZqjwqCiNbZPtotLGVN3nW0pL7x8HCkYDeI3eQxay8z
GKynBvZUKQ34gnvZtoJd9XnYX7Eos7M+qgdXIvkWc9qV0+JEUZ/TySDecHdL
ManC4FftIE9dzfS9xStqFB0zxohNlU2ILhgqimwpIMI5z44VbithA59gIbzR
Cknj2T7GaouJA/Cao+9oUXfjEg1reoovO5ieIU5Mb46pNjhH8QFvgxCZ4sHI
wAJ9k4go+65QOFYG7ONgd3lm4roNoTc4ObrUPeDtKyaV8vISmYoZ2pTP1YRW
ZrEVJW8WCpuLPt123t58oL5jxJYNdNgSxd+WEuG2r2+g3E7s5ekGzdt8lQo0
J5wzUertnvLk8wqmyxkKg7bZU+WBOmGiwcWEnnCU2lDBp4QNYa+BdrXHNs7Z
tBUCuN7hfRC5yhSTJ6bDnbabaxLAZqweaMbowmDovOZ6b20ox+L8FWqPNtRK
rQ4OTatQ0RKd6dD3bSfCaH0Uhw1ui/FaZyCXOGu3HFvHbGgYt0PjMrq7oXjS
4TyxJYhvfceyQxHaDctnJjngSRRg1xnymI1Vwu4tGsRweBjklEVdTuiZV0u4
eAh14M/5ntEyNg264BjdsvXJjXUOGihY9g/ZoM/GvDDBuK5Rqv2m4/BowwaL
FOUzVrZl8wOLrQ377svXJm02akrv/btHU7EA7yTwuMp6tgdm4jR3sfrQd7bj
OGvvf4GCNSqw17RgGB4QMagqO/ex4ZE/auzRUBrS9gcCloa++o6ifshOw7bP
lYMcz8yeKWamo2Vwi2orsFWTEhmmvoKn/lwIxn7qBNU0OO8/wVuj9arJ1S5V
BaGsKLwv7NlmagMTAkPEzm0tYfb+qr7o0ZA2FTxZNGoTJ3WYhstsxorStPYy
aF8zmmzkDvVp0+xdlrWbv5iIOd217/92NNgWnBljCzPxc4KztM9ixK+R7zml
PJ1disy4yChUoy3zN5Q6E92xNvmB7wdjSIl0qsRlpPDazgSdMMgV3bSFP5cg
GkjoGRsy9+fKpj9SNh2V9i0IM+QBU1a+ld5j/PFrGGbpPcVxBKPBOYHFgYH4
VB4YEavUeEFTz43QYwotMc/nip5S/DN5rPu1i5UfzfpTU+oF92fD+A//J4lu
/QtgkIqO\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[2]=",
 CellID->71135675]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->221456520],

Cell["Show the adjacency graph for countries in South America:", "ExampleText",
 CellID->160220497],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Thread", "[", 
       RowBox[{"#", "->", 
        RowBox[{"CountryData", "[", 
         RowBox[{"#", ",", "\"\<BorderingCountries\>\""}], "]"}]}], "]"}], 
      "&"}], "/@", 
     RowBox[{"CountryData", "[", "\"\<SouthAmerica\>\"", "]"}]}], "]"}], ",", 
   
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->114100416],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{283, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->641511084]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19570639],

Cell["\<\
Find a traveling-salesman tour of the centers of the countries in Europe:\
\>", "ExampleText",
 CellID->22061579],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Gray", ",", 
    RowBox[{
     RowBox[{
      RowBox[{"CountryData", "[", 
       RowBox[{"#", ",", "\"\<SchematicPolygon\>\""}], "]"}], "&"}], "/@", 
     RowBox[{"CountryData", "[", "\"\<Europe\>\"", "]"}]}], ",", "Thick", ",",
     "Red", ",", 
    RowBox[{"Line", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"#", "[", 
        RowBox[{"[", 
         RowBox[{"Last", "[", 
          RowBox[{"FindShortestTour", "[", "#", "]"}], "]"}], "]"}], "]"}], 
       "&"}], "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Reverse", "[", 
         RowBox[{"CountryData", "[", 
          RowBox[{"#", ",", "\"\<CenterCoordinates\>\""}], "]"}], "]"}], 
        "&"}], "/@", 
       RowBox[{"CountryData", "[", "\"\<Europe\>\"", "]"}]}], "]"}], "]"}]}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->934699026],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{248, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->392226094]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->930143957],

Cell["Find countries recorded as having Hindu populations:", "ExampleText",
 CellID->90260279],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"CountryData", "[", "]"}], ",", 
   RowBox[{
    RowBox[{"!", 
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"CountryData", "[", 
        RowBox[{"#", ",", "\"\<Religions\>\""}], "]"}], ",", 
       "\"\<Hindu\>\""}], "]"}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->311540449],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Aruba\"\>", ",", "\<\"Bangladesh\"\>", 
   ",", "\<\"EastTimor\"\>", ",", "\<\"Fiji\"\>", ",", "\<\"Gibraltar\"\>", 
   ",", "\<\"Guyana\"\>", ",", "\<\"India\"\>", ",", "\<\"Indonesia\"\>", 
   ",", "\<\"Kuwait\"\>", ",", "\<\"Malaysia\"\>", ",", "\<\"Martinique\"\>", 
   ",", "\<\"Mauritius\"\>", ",", "\<\"Nepal\"\>", ",", "\<\"Oman\"\>", 
   ",", "\<\"Pakistan\"\>", ",", "\<\"Reunion\"\>", 
   ",", "\<\"SaintVincentGrenadines\"\>", ",", "\<\"Seychelles\"\>", 
   ",", "\<\"Singapore\"\>", ",", "\<\"SriLanka\"\>", ",", "\<\"Suriname\"\>",
    ",", "\<\"TrinidadTobago\"\>", ",", "\<\"UnitedArabEmirates\"\>", 
   ",", "\<\"UnitedKingdom\"\>", ",", "\<\"Yemen\"\>"}], "}"}]], "Output",
 ImageSize->{510, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->382930783]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->76889920],

Cell["\<\
Show the numbers of current countries that became independent by year:\
\>", "ExampleText",
 CellID->56979519],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"MapIndexed", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{"First", "[", "#2", "]"}]}], "}"}], "&"}], ",", 
    RowBox[{"Sort", "[", 
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"CountryData", "[", 
          RowBox[{"#", ",", "\"\<IndependenceYear\>\""}], "]"}], "&"}], "/@", 
        
        RowBox[{"CountryData", "[", "]"}]}], ",", "_Missing"}], "]"}], 
     "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->111583821],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdzi1MVWEcBvB3zkAwEAgEwtExx9ydu35/obx+XxUVEfWqqEcEvZtuOkcw
OPcGuqhM8fsEA4FgIBAM75yBQCAYCDecYDAYCAQCQeX/POF9znb33N959ux/
Ng497B9Z55z7/u/3P9ee4r63P0s9a7HwGHaW+TO4xbIYg1st/XO4zbJGt1tO
jcMdls0XcGbZ+hLeZFl/BXdartCbLSsTcBf8Gt5i2fcGrljO01stpyfhquXc
W3gbvu8dvN2yeA/vsIz0TsvqB3iXZY3eLd4j3mvZS+8T77fM6QOWo3S3+KD4
kLhH7FMH+An7w6kDPMb+SOoAT7A/ajnJHv7G/pjlAnu4yf64ZdtH9HAFdics
u9nDA+xPWtbZw1Psa5Yz7OFZ9qfwvezhH+xPW86zhxfZn7Es2cPL7HstV9iL
3VnLVfbw+k/oz6UOcAv785Yb2MOd7Pssq7AXB7gOR3iQ+wuWw9yLgziKXb9l
g3txgB9wL3YXLR9xLw7iCI9yP5Daw0+5h8e4h8e5v5TaiwM8wb3YXbac5B4u
uBdHsbuS2ouDOIpdXfbiII5id1X24iCOYndN9uIgjvAX7q+n9vAU9+IodoOp
vTiIo9jdsJzmHv7KvTiK3c3UHp7hXhzF7pblLPfiII5il+M9nIm9OBcHeA4u
xBGeh0uxu506E3v4J++LA7zI++IIN3lf7IZSZ2IvzsVBXIgjXPI+/Iv371j+
5n2xF+fwH94XF+IoLuEl3h9OncHLvC/O4VXeh91n3Idb4Cgu4XbYjaTOxB7u
gHNxEBfiKC7F7m7qTOzFuTiIC3EUl2J3T+6LvTiHM96HO3lfHMUl3MX7Dcs6
74t9w/8FkCO82g==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{1600., 0},
  ImageSize->{220., Automatic},
  PlotRange->{{1582.625, 2006.}, {0., 194.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{224, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8104481]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->240413419],

Cell["\<\
Sort current countries by their claimed independence years, showing the \
oldest 20:\
\>", "ExampleText",
 CellID->353024005],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"SortBy", "[", 
    RowBox[{
     RowBox[{"CountryData", "[", "]"}], ",", 
     RowBox[{
      RowBox[{"CountryData", "[", 
       RowBox[{"#", ",", "\"\<IndependenceYear\>\""}], "]"}], "&"}]}], "]"}], 
   ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->123713198],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"China\"\>", ",", "\<\"SanMarino\"\>", ",", "\<\"France\"\>", 
   ",", "\<\"Japan\"\>", ",", "\<\"Denmark\"\>", ",", "\<\"Hungary\"\>", 
   ",", "\<\"UnitedKingdom\"\>", ",", "\<\"Portugal\"\>", 
   ",", "\<\"Austria\"\>", ",", "\<\"Thailand\"\>", ",", "\<\"Andorra\"\>", 
   ",", "\<\"Switzerland\"\>", ",", "\<\"Monaco\"\>", ",", "\<\"Spain\"\>", 
   ",", "\<\"Sweden\"\>", ",", "\<\"Netherlands\"\>", ",", "\<\"Oman\"\>", 
   ",", "\<\"Liechtenstein\"\>", ",", "\<\"Nepal\"\>", 
   ",", "\<\"UnitedStates\"\>"}], "}"}]], "Output",
 ImageSize->{450, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->122301858]
}, Open  ]],

Cell["\<\
Plot countries color coded by the length of their claimed independence:\
\>", "ExampleText",
 CellID->660246461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{
        RowBox[{"2", "/", "3"}], " ", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"1", "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"CountryData", "[", 
              RowBox[{"#", ",", "\"\<IndependenceYear\>\""}], "]"}], "/.", 
             " ", 
             RowBox[{"_Missing", "\[Rule]", "2007"}]}], ")"}], "/", 
           "2007"}]}], "]"}]}], "]"}], ",", 
      RowBox[{"CountryData", "[", 
       RowBox[{"#", ",", "\"\<SchematicPolygon\>\""}], "]"}]}], "}"}], "&"}], 
   "/@", 
   RowBox[{"CountryData", "[", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5499387],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{403, 167},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->387627680]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell["\<\
Generate a world map with tooltips for the name of each country:\
\>", "ExampleText",
 CellID->141046855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"LightGreen", ",", 
    RowBox[{"EdgeForm", "[", "Gray", "]"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"Tooltip", "[", 
       RowBox[{
        RowBox[{"CountryData", "[", 
         RowBox[{"#", ",", "\"\<SchematicPolygon\>\""}], "]"}], ",", "#"}], 
       "]"}], "&"}], "/@", 
     RowBox[{"CountryData", "[", "]"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->412667841],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[0.88, 1, 0.88], EdgeForm[GrayLevel[0.5]], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{61.28333333333333, 35.6}, {64.06666666666666, 36.}, {
      65.78333333333333, 37.56666666666666}, {67.76666666666667, 
      37.21666666666667}, {70.95, 38.46666666666667}, {71.68333333333334, 
      36.68333333333333}, {74.91666666666667, 37.233333333333334`}, {
      74.56666666666666, 37.03333333333333}, {71.63333333333333, 
      36.46666666666667}, {69.9, 34.016666666666666`}, {69.33333333333333, 
      31.933333333333334`}, {66.71666666666667, 31.216666666666665`}, {66.25, 
      29.849999999999998`}, {60.86666666666667, 29.866666666666667`}, {61.85, 
      31.016666666666666`}, {60.583333333333336`, 33.06666666666666}, {
      61.28333333333333, 35.6}}}],
     "\"Afghanistan\""],
    Annotation[#, "Afghanistan", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{20.016666666666666`, 39.68333333333333}, {
      19.366666666666667`, 41.85}, {20.166666666666668`, 
      42.516666666666666`}, {20.983333333333334`, 40.85}, {
      20.016666666666666`, 39.68333333333333}}}],
     "\"Albania\""],
    Annotation[#, "Albania", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{8.616666666666667, 36.93333333333333}, {0., 
      35.833333333333336`}, {-2.216666666666667, 
      35.083333333333336`}, {-1.1833333333333333`, 
      32.1}, {-3.8166666666666664`, 31.7}, {-3.6333333333333333`, 
      30.966666666666665`}, {-8.666666666666666, 
      28.716666666666665`}, {-8.666666666666666, 
      27.666666666666668`}, {-8.666666666666666, 27.28333333333333}, {-4.8, 
      25.}, {0., 21.833333333333332`}, {4.25, 19.15}, {12., 
      23.516666666666666`}, {9.4, 26.15}, {9.533333333333333, 
      30.233333333333334`}, {7.5, 33.88333333333333}, {8.616666666666667, 
      36.93333333333333}}}],
     "\"Algeria\""],
    Annotation[#, "Algeria", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-170.769, -14.2769}, {-170.736, -14.2645}, {-170.7, \
-14.2521}, {-170.671, -14.2521}, {-170.636, -14.2579}, {-170.595, -14.2587}, \
{-170.559, -14.248}, {-170.537, -14.2455}, {-170.527, -14.2505}, {-170.529, \
-14.2653}, {-170.546, -14.2744}, {-170.58, -14.2901}, {-170.613, -14.2991}, \
{-170.65, -14.3098}, {-170.647, -14.3214}, {-170.655, -14.3324}, {-170.679, \
-14.3395}, {-170.704, -14.3502}, {-170.712, -14.3585}, {-170.724, -14.3684}, \
{-170.747, -14.3742}, {-170.766, -14.3733}, {-170.782, -14.3643}, {-170.803, \
-14.3544}, {-170.827, -14.3445}, {-170.854, -14.3445}, {-170.881, -14.3445}, \
{-170.896, -14.3387}, {-170.902, -14.3255}, {-170.9, -14.314}, {-170.887, \
-14.3057}, {-170.869, -14.2983}, {-170.829, -14.2958}, {-170.796, -14.2917}, \
{-170.785, -14.2851}, {-170.769, -14.2769}}}],
     "\"AmericanSamoa\""],
    Annotation[#, "AmericanSamoa", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{1.75, 42.5}, {1.5, 42.6}, {1.4833333333333334`, 42.6}, {
      1.75, 42.5}}}],
     "\"Andorra\""],
    Annotation[#, "Andorra", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{13.183333333333334`, -5.866666666666666}, {12.25, -6.1}, {
       13.799999999999999`, -11.8}, {11.766666666666666`, -17.25}, {
       13.85, -17.333333333333332`}, {
       23.483333333333334`, -17.633333333333333`}, {
       22., -16.166666666666668`}, {22., -13.}, {24.016666666666666`, -13.}, {
       23.983333333333334`, -10.866666666666667`}, {
       22.166666666666668`, -10.866666666666667`}, {
       21.78333333333333, -7.283333333333333}, {18., -8.1}, {
       16.983333333333334`, -7.25}, {
       16.516666666666666`, -5.883333333333333}, {
       13.183333333333334`, -5.85}}, {{
       12.033333333333333`, -5.016666666666667}, {12.2, -5.783333333333333}, {
       13.083333333333334`, -4.633333333333333}, {
       12.033333333333333`, -5.016666666666667}}}],
     "\"Angola\""],
    Annotation[#, "Angola", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-63.0071, 18.2457}, {-62.9908, 18.2486}, {-62.9774, 
      18.2467}, {-62.9582, 18.2388}, {-62.9537, 18.2269}, {-62.9626, 
      18.2141}, {-62.9789, 18.2101}, {-63.0115, 18.2081}, {-63.0708, 
      18.1726}, {-63.0827, 18.1489}, {-63.1034, 18.137}, {-63.1686, 
      18.137}, {-63.1864, 18.1439}, {-63.1879, 18.1568}, {-63.1672, 
      18.1726}, {-63.0071, 18.2457}}}],
     "\"Anguilla\""],
    Annotation[#, "Anguilla", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-61.6546, 17.0476}, {-61.6433, 17.0365}, {-61.6433, 
       17.0227}, {-61.6526, 17.0116}, {-61.6713, 17.0046}, {-61.7046, 
       17.0019}, {-61.7202, 16.9894}, {-61.7202, 16.9617}, {-61.7275, 
       16.9499}, {-61.7421, 16.9478}, {-61.7556, 16.9533}, {-61.7816, 
       16.963}, {-61.8638, 16.9672}, {-61.8815, 16.9769}, {-61.8835, 
       16.9922}, {-61.8648, 17.0247}, {-61.8607, 17.0747}, {-61.8263, 
       17.0989}, {-61.7982, 17.1065}, {-61.7587, 17.101}, {-61.6546, 
       17.0476}}, {{-61.8163, 17.5651}, {-61.838, 17.5645}, {-61.8641, 
       17.5703}, {-61.8876, 17.5842}, {-61.8937, 17.6103}, {-61.8824, 
       17.6671}, {-61.8754, 17.6741}, {-61.8624, 17.67}, {-61.8363, 
       17.63}, {-61.8215, 17.63}, {-61.8145, 17.6376}, {-61.8145, 
       17.6637}, {-61.8467, 17.7222}, {-61.8432, 17.7321}, {-61.831, 
       17.7355}, {-61.8102, 17.7332}, {-61.7536, 17.6811}, {-61.718, 
       17.6173}, {-61.7145, 17.5593}, {-61.7241, 17.5413}, {-61.7389, 
       17.535}, {-61.758, 17.5355}, {-61.8163, 17.5651}}}],
     "\"AntiguaBarbuda\""],
    Annotation[#, "AntiguaBarbuda", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-58.199999999999996`, -32.45}, {-58.516666666666666`, \
-34.45}, {-56.666666666666664`, -36.9}, {-58.31666666666666, \
-38.483333333333334`}, {-62.38333333333333, -38.8}, {-62.3, \
-40.81666666666666}, {-65.13333333333333, -40.85}, {-63.583333333333336`, \
-42.61666666666667}, {-64.96666666666667, -42.666666666666664`}, {-65.6, \
-45.016666666666666`}, {-67.58333333333333, -46.}, {-65.73333333333333, \
-47.38333333333333}, {-69.01666666666667, -50.016666666666666`}, \
{-68.43333333333334, -52.38333333333333}, {-71.93333333333334, \
-51.983333333333334`}, {-73.58333333333333, -49.53333333333333}, {-71.1, \
-44.53333333333333}, {-72.13333333333333, -42.28333333333333}, \
{-69.81666666666666, -34.233333333333334`}, {-70.56666666666666, \
-31.316666666666666`}, {-68.31666666666666, -27.05}, {-67.18333333333334, \
-22.816666666666666`}, {-66.23333333333333, -21.78333333333333}, \
{-64.31666666666666, -22.866666666666667`}, {-63.93333333333333, -22.}, \
{-62.63333333333333, -22.233333333333334`}, {-57.75, -25.183333333333334`}, \
{-58.6, -27.316666666666666`}, {-55.583333333333336`, -27.28333333333333}, \
{-54.6, -25.566666666666666`}, {-53.8, -27.133333333333333`}, \
{-57.63333333333333, -30.25}, {-58.199999999999996`, -32.45}}, \
{{-68.61666666666666, -52.65}, {-65.13333333333333, -54.65}, \
{-68.63333333333333, -54.78333333333333}, {-68.63333333333333, \
-54.88333333333333}, {-68.61666666666666, -52.65}}}],
     "\"Argentina\""],
    Annotation[#, "Argentina", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{43.166666666666664`, 40.583333333333336`}, {
      45.016666666666666`, 41.2}, {46.35, 40.31666666666666}, {
      47.483333333333334`, 39.35}, {46.766666666666666`, 39.06666666666666}, {
      46.166666666666664`, 39.56666666666666}, {44.81666666666666, 
      39.63333333333333}, {43.166666666666664`, 40.583333333333336`}}}],
     "\"Armenia\""],
    Annotation[#, "Armenia", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-70.0875, 12.5494}, {-70.0824, 12.6139}, {-70.079, 
      12.6407}, {-70.064, 12.6474}, {-70.0423, 12.6395}, {-70.0088, 
      12.6016}, {-69.9017, 12.538}, {-69.8397, 12.4912}, {-69.838, 
      12.4566}, {-69.8565, 12.4332}, {-69.8799, 12.4276}, {-70.0875, 
      12.5494}}}],
     "\"Aruba\""],
    Annotation[#, "Aruba", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{144.63333333333333`, -38.333333333333336`}, {
       143.55, -38.86666666666667}, {140.36666666666667`, -37.95}, {
       139.48333333333332`, -35.916666666666664`}, {
       138.08333333333334`, -34.15}, {136.83333333333334`, -35.3}, {
       137.76666666666665`, -32.516666666666666`}, {
       135.95, -34.983333333333334`}, {
       133.78333333333333`, -32.21666666666667}, {
       131.2, -31.483333333333334`}, {
       125.98333333333333`, -32.31666666666666}, {
       120.01666666666667`, -33.93333333333333}, {117.95, -35.15}, {
       115.11666666666666`, -34.38333333333333}, {
       115.73333333333333`, -31.9}, {113.14999999999999`, -26.15}, {
       114.23333333333333`, -26.133333333333333`}, {
       113.39999999999999`, -24.166666666666668`}, {
       114.03333333333333`, -21.816666666666666`}, {
       116.81666666666666`, -20.5}, {
       121.03333333333333`, -19.53333333333333}, {
       122.93333333333334`, -16.366666666666667`}, {
       123.76666666666667`, -17.883333333333333`}, {
       123.61666666666666`, -16.133333333333333`}, {
       125.25, -15.583333333333334`}, {126.01666666666667`, -13.9}, {
       127.41666666666667`, -13.95}, {127.83333333333333`, -15.6}, {
       128.48333333333332`, -14.766666666666666`}, {
       130.2, -15.383333333333333`}, {129.7, -13.883333333333333`}, {
       131., -12.166666666666666`}, {
       132.68333333333334`, -12.183333333333334`}, {
       131.98333333333332`, -11.2}, {135.71666666666667`, -12.3}, {
       136.98333333333332`, -12.4}, {135.45, -14.983333333333333`}, {
       140.1, -17.716666666666665`}, {
       141.71666666666667`, -15.233333333333333`}, {
       142.13333333333333`, -11.033333333333333`}, {143.1, -12.2}, {
       143.78333333333333`, -14.383333333333333`}, {
       145.36666666666667`, -14.966666666666667`}, {
       146.28333333333333`, -18.883333333333333`}, {
       148.78333333333333`, -20.25}, {149.63333333333333`, -22.55}, {
       150.8, -22.53333333333333}, {152.91666666666666`, -25.3}, {
       153.61666666666667`, -28.78333333333333}, {
       150.21666666666667`, -35.733333333333334`}, {
       149.61666666666667`, -37.71666666666667}, {
       146.36666666666667`, -39.15}, {
       144.63333333333333`, -38.333333333333336`}}, {{
       153.03333333333333`, -25.766666666666666`}, {
       153.26666666666665`, -24.7}, {
       153.03333333333333`, -25.766666666666666`}}, {{
       145.76666666666665`, -43.166666666666664`}, {
       144.7, -40.68333333333333}, {148.35, -40.96666666666667}, {
       147.98333333333332`, -43.18333333333333}, {
       145.76666666666665`, -43.15}}, {{
       130.93333333333334`, -11.933333333333334`}, {
       130.38333333333333`, -11.2}, {131.43333333333334`, -11.3}, {
       130.93333333333334`, -11.933333333333334`}}}],
     "\"Australia\""],
    Annotation[#, "Australia", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{9.733333333333333, 47.53333333333333}, {
      13.049999999999999`, 47.5}, {13.833333333333334`, 
      48.766666666666666`}, {17.166666666666668`, 48.016666666666666`}, {
      16.116666666666667`, 46.86666666666667}, {13.716666666666667`, 
      46.53333333333333}, {10.466666666666667`, 46.86666666666667}, {9.6, 
      47.06666666666666}, {9.533333333333333, 47.266666666666666`}, {
      9.733333333333333, 47.53333333333333}}}],
     "\"Austria\""],
    Annotation[#, "Austria", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{44.81666666666666, 39.63333333333333}, {
       46.166666666666664`, 39.56666666666666}, {46.766666666666666`, 
       39.06666666666666}, {46.166666666666664`, 38.833333333333336`}, {
       44.81666666666666, 39.63333333333333}}, {{47.483333333333334`, 
       39.35}, {46.35, 40.31666666666666}, {45.016666666666666`, 41.2}, {
       47.05, 40.75}, {46.3, 41.81666666666666}, {47.85, 41.21666666666667}, {
       48.583333333333336`, 41.833333333333336`}, {50.4, 
       40.233333333333334`}, {48.88333333333333, 38.45}, {48.13333333333333, 
       39.6}, {47.483333333333334`, 39.35}}}],
     "\"Azerbaijan\""],
    Annotation[#, "Azerbaijan", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-77.8622, 24.5191}, {-77.8837, 24.5231}, {-77.9142, 
       24.5201}, {-78.0482, 24.4703}, {-78.0681, 24.4551}, {-78.0803, 
       24.3698}, {-78.0529, 24.3149}, {-78.0635, 24.3048}, {-78.0773, 
       24.3038}, {-78.155, 24.3657}, {-78.1764, 24.4043}, {-78.251, 
       24.4825}, {-78.3607, 24.5445}, {-78.443, 24.5678}, {-78.4613, 
       24.5861}, {-78.4567, 24.5953}, {-78.4125, 24.6115}, {-78.3971, 
       24.6302}, {-78.3851, 24.6643}, {-78.3728, 24.6846}, {-78.3534, 
       24.6917}, {-78.3087, 24.6807}, {-78.2952, 24.6836}, {-78.2952, 
       24.6988}, {-78.3135, 24.7415}, {-78.3119, 24.7527}, {-78.2677, 
       24.7923}, {-78.1671, 24.8908}, {-78.1534, 24.9325}, {-78.1809, 
       25.0269}, {-78.2251, 25.1518}, {-78.2281, 25.1671}, {-78.2174, 
       25.1742}, {-78.1809, 25.1691}, {-78.1229, 25.1163}, {-78.0985, 
       25.1112}, {-78.0803, 25.1142}, {-78.0147, 25.1488}, {-77.9888, 
       25.1518}, {-77.9644, 25.1427}, {-77.9324, 25.0624}, {-77.9218, 
       25.0208}, {-77.8974, 24.968}, {-77.8699, 24.9527}, {-77.8607, 
       24.8583}, {-77.7465, 24.7222}, {-77.7007, 24.646}, {-77.7236, 
       24.5181}, {-77.6809, 24.447}, {-77.6794, 24.4165}, {-77.6916, 
       24.3891}, {-77.786, 24.3556}, {-77.8821, 24.2956}, {-77.9339, 
       24.2916}, {-77.975, 24.2987}, {-78.0344, 24.3444}, {-78.0482, 
       24.3708}, {-78.0375, 24.4246}, {-78.0009, 24.4551}, {-77.9201, 
       24.4866}, {-77.8699, 24.5008}, {-77.8622, 24.5191}}, CompressedData["
1:eJxdlAtQVGUUxzckMAvSkEZa8JFYKWDjpuJ3ZOXA7sLKQ4QPKI0NDVaBQZGC
NIbwtcwSiARKECoOiqEFWDEw0vT4zBBcRXeUSQLUSUHISVkFQyGpc3cmdsY7
c++d3/3Od8/j/793zvtpUXo7mUympVO6P2zuyn+i4UI3rhq9e57h/+w1o7Tj
uTaGnwas6zMHcWFwiji5v4WhTDq0Nv5iAQWu5MLcsOZhs4lh5WDN2dBQLqbX
B/+R1cEwkLa/GsEFXbsfX2fosTZx+Q3i6i3KKVdvMUy8oAttIzZUtn91qY+h
Wd1pGV7FRcgLdl7G2wwVW33mzArjImrloR2v3WRYvvml3SKEi5Twob28l6HP
d4cGa4gT7q0NXDHAMKt1PpRQ/ky7isnyewx9XxHvzg7nYjQn5YeMIYbWuNVc
nDZVaZqIHePLw1yjuaCiCsso/tdvF24+GsPF3sx0uZOF4ZkrXnq3WC6MNW+b
FMMM+8dO3L9M683/GIe7Rxj+7HzwrSO0P37++amtowyltJVRXBTnjMGWcYZN
hmxzQyQXybK0nfbPAg6nxn5ST/05XnSL7Hoe0OVBwKUNVF/qtqxj3i6Ary+a
XOtO/XhKCeQ2/myRNAhAilK5U3+uHuf6/D0BndJrC7ppPg47S1UF3jDRryRf
kgIw5vTx6lW03jT0pGMbs/HJeb27K5WAS/1+jPqc4qXHqAK0ykMcNI8mqAWM
Pfx1XSfl8z/b02gIAwz+4PGLfwbbuC75eno++YO6//5UOKDSu6PiNvlnxIEG
GwM4FrepZZzW6zvjP4p4D7DhzoeNrrT/sB8FbgCcLr1IzUVS8d1s/0zA9gt0
EDtaXtauzgYk1fbNIL894reOHTAAms4E1iXT/Kw+yYcJ/3wzqX/PG4WAWH3j
J2fSt4hneJYVAQbsutlaTutpZBtTMaCF7OlL/ZE6F/NKYMI/Vb8tHlxWCvhX
5KmZuSouFpxwMavzAJ8JJ6f7c2HNYwSUylyygovQNkflgVxAa59KLpiGJrMd
cKM6Oc1C3JNEgmcAyt+85ulAbFJIzqL6o2nSwEX5tX3G3BTAliISlnEhlVel
B8zxWLZRTRxN5f+7DvDLKaQExQ+keP1dpgNM2P678mM/Lqw+1Nnyl+rzEnRx
gHtC7tgvJh48R4NaAziNZCmk/eP6kd71kTYuiaMPnvRK1PUETfKz6d3o++iX
ROqvS569XqEBrNh68MjcAOLa0bhNxO8cX9K+PJAL6fPLUAO62cc6+5C+6oLU
/jHy11Uao4b0pSqmLXUHnFkzoF1IfHQuGdoe8On/zX9KwhQy
       "], {{-76.0924, 24.6304}, {-76.0983, 24.6194}, {-76.1055, 
       24.613}, {-76.1233, 24.6115}, {-76.1743, 24.6336}, {-76.2609, 
       24.7222}, {-76.3606, 24.7783}, {-76.3689, 24.7949}, {-76.3581, 
       24.8044}, {-76.3345, 24.8044}, {-76.2597, 24.7696}, {-76.2229, 
       24.7704}, {-76.1494, 24.802}, {-76.1423, 24.8218}, {-76.1636, 
       24.8945}, {-76.1719, 24.8953}, {-76.1802, 24.8906}, {-76.1897, 
       24.8597}, {-76.2028, 24.851}, {-76.2229, 24.8518}, {-76.2324, 
       24.8692}, {-76.2335, 24.9356}, {-76.1885, 25.0203}, {-76.1778, 
       25.1017}, {-76.2063, 25.1578}, {-76.3427, 25.282}, {-76.5172, 
       25.3539}, {-76.5409, 25.3808}, {-76.5433, 25.399}, {-76.5278, 
       25.4085}, {-76.4887, 25.4006}, {-76.4448, 25.3634}, {-76.3617, 
       25.3373}, {-76.325, 25.3365}, {-76.1517, 25.2148}, {-76.1114, 
       25.1871}, {-76.1114, 25.157}, {-76.1422, 25.0788}, {-76.1339, 
       25.0187}, {-76.0699, 24.9135}, {-76.0722, 24.8684}, {-76.1209, 
       24.7743}, {-76.1291, 24.7237}, {-76.0924, 24.6304}}, {{-78.9249, 
       26.6349}, {-78.941, 26.648}, {-78.9428, 26.66}, {-78.9231, 
       26.6659}, {-78.8515, 26.6635}, {-78.7565, 26.6468}, {-78.7171, 
       26.6325}, {-78.71, 26.6194}, {-78.7117, 26.5812}, {-78.6992, 
       26.5716}, {-78.6885, 26.5716}, {-78.6688, 26.5847}, {-78.6616, 
       26.6134}, {-78.6365, 26.6277}, {-78.5774, 26.6397}, {-78.4842, 
       26.6528}, {-78.3445, 26.7185}, {-78.1116, 26.7877}, {-77.9683, 
       26.8032}, {-77.9163, 26.802}, {-77.8841, 26.7805}, {-77.8805, 
       26.728}, {-77.8519, 26.7137}, {-77.8232, 26.7173}, {-77.8035, 
       26.7686}, {-77.7695, 26.7781}, {-77.7552, 26.7758}, {-77.7534, 
       26.7614}, {-77.7767, 26.7364}, {-77.7784, 26.7053}, {-77.7767, 
       26.6767}, {-77.8017, 26.6504}, {-77.8447, 26.6397}, {-78.0328, 
       26.6528}, {-78.1743, 26.6444}, {-78.4251, 26.6003}, {-78.6347, 
       26.5275}, {-78.6992, 26.5191}, {-78.7386, 26.5239}, {-78.9249, 
       26.6349}}, {{-72.9993, 21.234}, {-73.0148, 21.2012}, {-73.1465, 
       21.0521}, {-73.2037, 20.9477}, {-73.2177, 20.9086}, {-73.2414, 
       20.8944}, {-73.2865, 20.8868}, {-73.3357, 20.888}, {-73.4179, 
       20.8829}, {-73.4707, 20.8679}, {-73.5332, 20.8687}, {-73.5771, 
       20.8805}, {-73.6115, 20.8805}, {-73.6471, 20.86}, {-73.6756, 
       20.8592}, {-73.7041, 20.871}, {-73.7147, 20.8837}, {-73.7201, 
       20.9533}, {-73.7746, 21.0086}, {-73.7711, 21.0205}, {-73.7545, 
       21.0276}, {-73.7082, 21.0221}, {-73.694, 21.0268}, {-73.6928, 
       21.0347}, {-73.7213, 21.0703}, {-73.7177, 21.0814}, {-73.697, 
       21.0893}, {-73.6388, 21.0853}, {-73.615, 21.0869}, {-73.5901, 
       21.1043}, {-73.5901, 21.151}, {-73.5736, 21.1628}, {-73.4917, 
       21.1763}, {-73.4603, 21.2047}, {-73.4484, 21.2285}, {-73.4271, 
       21.2356}, {-73.4057, 21.2332}, {-73.3618, 21.2087}, {-73.3037, 
       21.1881}, {-73.2254, 21.1747}, {-73.1738, 21.1794}, {-73.1417, 
       21.1913}, {-73.1109, 21.2174}, {-73.0918, 21.2822}, {-73.0777, 
       21.2965}, {-73.0646, 21.2988}, {-73.0385, 21.2901}, {-73.0041, 
       21.2641}, {-72.9975, 21.249}, {-72.9993, 21.234}}, {{-74.8262, 
       22.8695}, {-74.8321, 22.865}, {-74.8448, 22.8616}, {-74.8575, 
       22.865}, {-74.893, 22.9039}, {-74.9623, 22.9901}, {-75.0503, 
       23.0385}, {-75.1119, 23.0498}, {-75.1719, 23.0723}, {-75.2895, 
       23.1416}, {-75.3022, 23.1529}, {-75.2996, 23.1613}, {-75.2793, 
       23.163}, {-75.2252, 23.1422}, {-75.1661, 23.0949}, {-75.1475, 
       23.0921}, {-75.1323, 23.1011}, {-75.1314, 23.1242}, {-75.1568, 
       23.1726}, {-75.1982, 23.203}, {-75.2134, 23.2171}, {-75.2151, 
       23.2289}, {-75.188, 23.252}, {-75.1686, 23.2847}, {-75.1737, 
       23.3253}, {-75.1838, 23.3625}, {-75.2421, 23.4104}, {-75.254, 
       23.4323}, {-75.2523, 23.4763}, {-75.2692, 23.5382}, {-75.2751, 
       23.5501}, {-75.3258, 23.5579}, {-75.3503, 23.5636}, {-75.3816, 
       23.5777}, {-75.3943, 23.5963}, {-75.396, 23.6154}, {-75.3994, 
       23.6531}, {-75.3748, 23.6644}, {-75.3326, 23.6515}, {-75.2379, 
       23.5782}, {-75.1974, 23.5326}, {-75.1948, 23.4706}, {-75.1568, 
       23.4036}, {-75.1103, 23.3467}, {-75.1154, 23.2306}, {-75.079, 
       23.1157}, {-74.9928, 23.0621}, {-74.9209, 23.0396}, {-74.8533, 
       22.9866}, {-74.8262, 22.8695}}, {{-74.2515, 22.1487}, {-74.2699, 
       22.1441}, {-74.2822, 22.146}, {-74.293, 22.1595}, {-74.2889, 
       22.1758}, {-74.2679, 22.2084}, {-74.1674, 22.2654}, {-74.147, 
       22.2916}, {-74.1131, 22.3088}, {-74.1049, 22.3297}, {-74.1022, 
       22.3559}, {-74.0913, 22.3677}, {-74.0425, 22.3839}, {-74.0289, 
       22.3993}, {-74.0289, 22.422}, {-74.0186, 22.4364}, {-73.9385, 
       22.4898}, {-73.9331, 22.5486}, {-73.9413, 22.5722}, {-73.9562, 
       22.5821}, {-73.9983, 22.5848}, {-74.0906, 22.641}, {-74.1042, 
       22.6581}, {-74.1042, 22.6771}, {-74.0818, 22.6925}, {-74.0614, 
       22.6962}, {-74.0289, 22.6916}, {-74.0044, 22.6916}, {-73.9827, 
       22.7052}, {-73.9474, 22.7188}, {-73.8849, 22.7314}, {-73.8605, 
       22.7278}, {-73.8503, 22.698}, {-73.8897, 22.6247}, {-73.8747, 
       22.5839}, {-73.8231, 22.5287}, {-73.8136, 22.5079}, {-73.8163, 
       22.4916}, {-73.9175, 22.4473}, {-73.9813, 22.3731}, {-73.9922, 
       22.3333}, {-74.0098, 22.3134}, {-74.2515, 22.1487}}, {{-75.5632, 
       23.3873}, {-75.546, 23.386}, {-75.5412, 23.3815}, {-75.5441, 
       23.3726}, {-75.5729, 23.3617}, {-75.6093, 23.3585}, {-75.6688, 
       23.3707}, {-75.7302, 23.4103}, {-75.8002, 23.4135}, {-75.8434, 
       23.4205}, {-75.8731, 23.4359}, {-75.9834, 23.5247}, {-76.0016, 
       23.5311}, {-76.0179, 23.5311}, {-76.0582, 23.5043}, {-76.0736, 
       23.5017}, {-76.086, 23.5094}, {-76.0888, 23.5247}, {-76.0783, 
       23.5516}, {-76.0649, 23.6149}, {-76.0764, 23.6647}, {-76.0707, 
       23.6711}, {-76.0563, 23.6762}, {-76.0026, 23.6596}, {-75.9219, 
       23.5855}, {-75.8644, 23.4832}, {-75.8251, 23.4634}, {-75.7599, 
       23.4551}, {-75.7234, 23.4468}, {-75.6793, 23.4167}, {-75.6102, 
       23.3879}, {-75.5632, 23.3873}}, {{-77.5655, 24.1137}, {-77.4856, 
       23.9787}, {-77.4342, 23.8968}, {-77.4389, 23.8664}, {-77.4579, 
       23.8512}, {-77.4903, 23.8442}, {-77.5055, 23.8353}, {-77.5112, 
       23.8182}, {-77.4884, 23.7282}, {-77.4951, 23.685}, {-77.5217, 
       23.6711}, {-77.5645, 23.6692}, {-77.6093, 23.68}, {-77.6597, 
       23.7168}, {-77.7025, 23.7846}, {-77.7367, 23.9235}, {-77.7567, 
       23.9806}, {-77.7519, 24.0009}, {-77.7072, 24.0281}, {-77.5931, 
       24.1068}, {-77.5798, 24.1169}, {-77.5731, 24.1188}, {-77.5655, 
       24.1137}}, {{-75.3694, 24.2904}, {-75.3107, 24.2248}, {-75.3089, 
       24.177}, {-75.3236, 24.1621}, {-75.3789, 24.1609}, {-75.4238, 
       24.1511}, {-75.46, 24.1316}, {-75.4851, 24.1327}, {-75.543, 
       24.1632}, {-75.5499, 24.1759}, {-75.5387, 24.1885}, {-75.4212, 
       24.2496}, {-75.4168, 24.2622}, {-75.4419, 24.3129}, {-75.5274, 
       24.4234}, {-75.5667, 24.478}, {-75.603, 24.4959}, {-75.6565, 
       24.512}, {-75.6678, 24.5258}, {-75.6686, 24.5471}, {-75.6617, 
       24.5868}, {-75.6708, 24.6029}, {-75.7373, 24.6381}, {-75.7572, 
       24.6622}, {-75.7554, 24.6709}, {-75.7459, 24.6789}, {-75.7174, 
       24.6806}, {-75.6423, 24.6622}, {-75.5688, 24.6283}, {-75.4972, 
       24.5206}, {-75.4415, 24.4619}, {-75.3871, 24.3388}, {-75.3694, 
       24.2904}}}],
     "\"Bahamas\""],
    Annotation[#, "Bahamas", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{50.402, 25.9856}, {50.4191, 26.1301}, {50.4996, 26.316}, {
      50.529, 26.3294}, {50.5879, 26.3397}, {50.6529, 26.3181}, {50.6607, 
      26.2757}, {50.622, 26.1694}, {50.5863, 25.8968}, {50.5554, 25.8647}, {
      50.5166, 25.8627}, {50.433, 25.9319}, {50.402, 25.9856}}}],
     "\"Bahrain\""],
    Annotation[#, "Bahrain", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{92.2, 21.15}, {91.48333333333333, 22.916666666666668`}, {
      89.25, 23.95}, {90.61666666666666, 22.366666666666667`}, {
      89.03333333333333, 21.916666666666668`}, {89.01666666666667, 
      25.28333333333333}, {88.41666666666667, 26.633333333333333`}, {89.85, 
      25.28333333333333}, {92.4, 25.03333333333333}, {91.16666666666667, 
      23.633333333333333`}, {91.61666666666666, 22.95}, {92.28333333333333, 
      23.633333333333333`}, {92.6, 21.983333333333334`}, {92.2, 21.15}}}],
     "\"Bangladesh\""],
    Annotation[#, "Bangladesh", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-59.4225, 13.0362}, {-59.483, 13.0184}, {-59.5168, 
      13.0196}, {-59.5577, 13.0315}, {-59.6484, 13.0955}, {-59.6715, 
      13.2555}, {-59.6555, 13.2804}, {-59.6288, 13.2851}, {-59.5879, 
      13.278}, {-59.5684, 13.2555}, {-59.5257, 13.1832}, {-59.4865, 
      13.1559}, {-59.4172, 13.131}, {-59.4047, 13.105}, {-59.3994, 
      13.0706}, {-59.4225, 13.0362}}}],
     "\"Barbados\""],
    Annotation[#, "Barbados", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{23.5, 53.949999999999996`}, {25.316666666666666`, 54.15}, {
      26.333333333333332`, 55.53333333333333}, {28.099999999999998`, 
      56.016666666666666`}, {29.983333333333334`, 55.833333333333336`}, {
      31.716666666666665`, 53.699999999999996`}, {31.633333333333333`, 
      52.06666666666666}, {27.333333333333332`, 51.583333333333336`}, {23.6, 
      51.53333333333333}, {23.5, 53.949999999999996`}}}],
     "\"Belarus\""],
    Annotation[#, "Belarus", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{2.55, 51.083333333333336`}, {3.3833333333333333`, 
      51.38333333333333}, {6.016666666666667, 50.766666666666666`}, {
      6.133333333333333, 50.13333333333333}, {5.816666666666666, 
      49.53333333333333}, {2.55, 51.083333333333336`}}}],
     "\"Belgium\""],
    Annotation[#, "Belgium", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-88.28333333333333, 
      18.483333333333334`}, {-88.91666666666667, 15.9}, {-89.13333333333333, 
      17.816666666666666`}, {-88.28333333333333, 18.483333333333334`}}}],
     "\"Belize\""],
    Annotation[#, "Belize", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{1.6333333333333333`, 6.216666666666667}, {
      2.7333333333333334`, 6.366666666666666}, {3.5666666666666664`, 11.75}, {
      2.4, 11.883333333333333`}, {0.9666666666666667, 11.}, {
      1.6333333333333333`, 6.216666666666667}}}],
     "\"Benin\""],
    Annotation[#, "Benin", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-64.9425, 32.19}, {-64.9635, 32.1956}, {-64.9788, 
       32.2002}, {-64.9873, 32.2086}, {-64.9719, 32.2217}, {-64.9313, 
       32.231}, {-64.9006, 32.23}, {-64.8866, 32.2189}, {-64.8894, 
       32.2002}, {-64.9076, 32.1918}, {-64.9425, 32.19}}, {{-64.7663, 
       32.3316}, {-64.7649, 32.3437}, {-64.7509, 32.3475}, {-64.73, 
       32.3465}, {-64.709, 32.3316}, {-64.6964, 32.3046}, {-64.7006, 
       32.2878}, {-64.7188, 32.2869}, {-64.7356, 32.2934}, {-64.7663, 
       32.3316}}, {{-64.6782, 32.3447}, {-64.6838, 32.3521}, {-64.6782, 
       32.3549}, {-64.653, 32.3558}, {-64.6195, 32.3409}, {-64.6069, 
       32.3242}, {-64.6139, 32.3139}, {-64.6335, 32.3139}, {-64.6629, 
       32.3232}, {-64.6782, 32.3447}}, {{-64.7258, 32.3968}, {-64.7188, 
       32.4052}, {-64.7062, 32.4062}, {-64.688, 32.4024}, {-64.6698, 
       32.3857}, {-64.6726, 32.3717}, {-64.6908, 32.3698}, {-64.7062, 
       32.3726}, {-64.7258, 32.3968}}, {{-64.9677, 32.2664}, {-64.9635, 
       32.2785}, {-64.9523, 32.2813}, {-64.9313, 32.2748}, {-64.9243, 
       32.2599}, {-64.9285, 32.2468}, {-64.9425, 32.244}, {-64.9621, 
       32.2505}, {-64.9677, 32.2664}}}],
     "\"Bermuda\""],
    Annotation[#, "Bermuda", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{88.91666666666667, 27.316666666666666`}, {90., 
      28.316666666666666`}, {91.65, 27.766666666666666`}, {88.91666666666667, 
      27.316666666666666`}}}],
     "\"Bhutan\""],
    Annotation[#, "Bhutan", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-69.56666666666666, -10.95}, {-68.66666666666667, -12.5}, \
{-69.5, -17.5}, {-67.18333333333334, -22.816666666666666`}, \
{-66.23333333333333, -21.78333333333333}, {-64.31666666666666, \
-22.866666666666667`}, {-63.93333333333333, -22.}, {-62.63333333333333, \
-22.233333333333334`}, {-61.75, -19.65}, {-58.166666666666664`, \
-20.166666666666668`}, {-57.449999999999996`, -18.2}, {-58.333333333333336`, \
-16.28333333333333}, {-60.166666666666664`, -16.266666666666666`}, \
{-60.46666666666667, -13.799999999999999`}, {-64.4, -12.466666666666667`}, \
{-65.31666666666666, -10.916666666666666`}, {-65.43333333333334, \
-9.683333333333334}, {-69.56666666666666, -10.95}}}],
     "\"Bolivia\""],
    Annotation[#, "Bolivia", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{18.633333333333333`, 42.5}, {16.366666666666667`, 
      44.18333333333333}, {16.1, 44.56666666666666}, {15.95, 
      45.166666666666664`}, {18.466666666666665`, 45.05}, {18.8, 
      44.88333333333333}, {18.633333333333333`, 42.5}}}],
     "\"BosniaHerzegovina\""],
    Annotation[#, "BosniaHerzegovina", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{25.266666666666666`, -17.8}, {21., -18.316666666666666`}, {
      20., -22.}, {20., -24.766666666666666`}, {
      20.65, -26.833333333333332`}, {22.8, -25.65}, {
      25.516666666666666`, -25.666666666666668`}, {
      29.383333333333333`, -22.2}, {25.266666666666666`, -17.8}}}],
     "\"Botswana\""],
    Annotation[#, "Botswana", "Tooltip"]& ], 
   TagBox[
    TooltipBox[PolygonBox[{CompressedData["
1:eJxdU01IVFEUfomJhAsfjYs2oiNGPxvLHB0mfFcc9P3MPN8bdCEihKi4ECUi
XZiLaOPW5bhScCEGbkRCDObSuhYtpFUREa7KyKAQjZp7vm9G8IOZyzn3O+c7
P/e1TswXpmosy3LKP3P+OC5jx9efPhoonTXY9HDW9uoVA9fTnQZPaNf7esSg
SWnL4JEL/8rDqr1WLGM0rV8flLGUxXnWpW2D1X4N3XvQXaY9dxd5n/brRcFt
6F6/sHH2wb/bAv5eH+tPQN/K6ndvDerQx+SAnhZcgz83QN55ScqeGYT+8VEJ
+Sv9nMP+4FL3KvUu7qWvMa9qS/5ZD7yR77z3MY/iaUn6/+nql9sGJw7yezop
aFTSx7jP+xoldYVB1ZZ8mRz67/znSBvrecb/dkT2MM96bOYLOY+EEtqbEHuw
bSX/j4fIb1DIGzGfDXt3iHpXlNT7KuI8fjky1oWY9hn6GYyp99WRsBcx6//i
iP9ZzH01Yi7pAvUTqOt5gfrN3FeB+ZK436jEJxG3FfNd3uS+Y+z7qB3vbiwC
f7wN98MR9nPYDv0bEfd/C/xMqGVdRb7HphBx2Q70cYfzdTvA26/s4z75efIe
QPdvjv4U+vgWMD7Fdxxgfn+68S5bAvAaeth/wO8mzb58zicD//sc4lQvzs8+
eHVKX/6+/wNCFebe
       "], {{-48.4, -0.26666666666666666`}, {-50.38333333333333, \
-1.8333333333333333`}, {-50.583333333333336`, -0.2}, {-48.4, \
-0.26666666666666666`}}}],
     "\"Brazil\""],
    Annotation[#, "Brazil", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-64.2772, 18.6801}, {-64.32, 18.7077}, {-64.3575, 
       18.7175}, {-64.4016, 18.7193}, {-64.415, 18.7265}, {-64.415, 
       18.7363}, {-64.399, 18.7461}, {-64.3494, 18.7514}, {-64.2839, 
       18.7327}, {-64.2597, 18.7086}, {-64.2517, 18.6899}, {-64.2544, 
       18.6801}, {-64.2638, 18.6765}, {-64.2678, 18.6765}, {-64.2772, 
       18.6801}}, {{-64.3869, 18.3973}, {-64.3949, 18.4205}, {-64.3922, 
       18.4366}, {-64.3387, 18.4696}, {-64.316, 18.4767}, {-64.2397, 
       18.4651}, {-64.2303, 18.4553}, {-64.241, 18.4464}, {-64.3053, 
       18.4313}, {-64.3561, 18.4009}, {-64.3682, 18.3965}, {-64.3869, 
       18.3973}}, {{-64.5569, 18.4259}, {-64.5314, 18.4179}, {-64.5288, 
       18.4045}, {-64.5328, 18.3947}, {-64.5649, 18.3875}, {-64.6439, 
       18.3875}, {-64.6854, 18.3688}, {-64.6933, 18.3688}, {-64.7027, 
       18.3759}, {-64.6947, 18.3929}, {-64.6653, 18.4161}, {-64.6238, 
       18.4268}, {-64.5569, 18.4259}}, {{-64.863, 18.3909}, {-64.8782, 
       18.3924}, {-64.8782, 18.4011}, {-64.8542, 18.4142}, {-64.8085, 
       18.4185}, {-64.7845, 18.4171}, {-64.778, 18.4069}, {-64.7889, 
       18.3996}, {-64.863, 18.3909}}}],
     "\"BritishVirginIslands\""],
    Annotation[#, "BritishVirginIslands", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{114.08333333333333`, 4.583333333333333}, {
       115.01666666666667`, 4.866666666666666}, {115.01666666666667`, 
       4.883333333333333}, {114.08333333333333`, 4.583333333333333}}, {{
       115.14999999999999`, 4.9}, {115.03333333333333`, 4.816666666666666}, {
       115.14999999999999`, 4.9}}}],
     "\"Brunei\""],
    Annotation[#, "Brunei", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{28.583333333333332`, 43.75}, {28.016666666666666`, 
      41.983333333333334`}, {26.349999999999998`, 41.71666666666667}, {
      22.933333333333334`, 41.35}, {22.683333333333334`, 
      44.233333333333334`}, {28.583333333333332`, 43.75}}}],
     "\"Bulgaria\""],
    Annotation[#, "Bulgaria", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-2.683333333333333, 
      9.483333333333333}, {-5.516666666666667, 
      10.433333333333334`}, {-3.966666666666667, 13.5}, {0., 15.}, {
      0.23333333333333334`, 15.}, {2.4, 11.9}, {0.9666666666666667, 
      11.}, {-0.16666666666666666`, 
      11.133333333333333`}, {-2.8333333333333335`, 11.}, {-2.683333333333333, 
      9.483333333333333}}}],
     "\"BurkinaFaso\""],
    Annotation[#, "BurkinaFaso", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{29.016666666666666`, -2.75}, {
      29.416666666666668`, -4.45}, {30.566666666666666`, -2.4}, {
      29.016666666666666`, -2.75}}}],
     "\"Burundi\""],
    Annotation[#, "Burundi", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{104.45, 10.416666666666666`}, {102.91666666666667`, 
      11.633333333333333`}, {102.33333333333333`, 13.549999999999999`}, {
      105.21666666666667`, 14.35}, {107.55, 14.7}, {107.55, 12.35}, {105.85, 
      11.666666666666666`}, {104.45, 10.416666666666666`}}}],
     "\"Cambodia\""],
    Annotation[#, "Cambodia", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{9.816666666666666, 2.35}, {9.75, 4.133333333333333}, {8.6, 
      4.816666666666666}, {9.8, 6.8}, {11.883333333333333`, 
      7.083333333333333}, {14.65, 11.566666666666666`}, {14.066666666666666`, 
      13.083333333333334`}, {15.683333333333334`, 9.983333333333333}, {13.95, 
      9.633333333333333}, {15.5, 7.533333333333333}, {14.416666666666666`, 
      6.05}, {16.2, 2.216666666666667}, {13.299999999999999`, 
      2.1666666666666665`}, {11.333333333333334`, 2.1666666666666665`}, {
      9.816666666666666, 2.35}}}],
     "\"Cameroon\""],
    Annotation[#, "Cameroon", "Tooltip"]& ], 
   TagBox[
    TooltipBox[PolygonBox[{CompressedData["
1:eJxVVGtIFFEUXqRAtAR/REQZpBQ9QIKSJAumcJ+zM3vvzs6u7qo7RQYWFRRm
UEFEhdGDQioUggqLHiJB0A+LGHr4yyIQiX5shNCDCsNM6Fe0c79vRzqwDGfv
ud/5znfOuSt2Hkh2lgUCgZ7iz/v+nCracIcb8OxERKv1bHv7/37ZnK++gazv
vx4rWrzF923POtPwAxGt17Ny221WFtYe3C/aQMpVuCeD2kB/0e6l3N2ehYLA
G0q5PZ69a0b8iOUq3O6gpmBeWq6KOz/nK7xbQW2DZzNJ90OhaFtDmsJNJ5kv
BP4fpe8r3FcS+e+ENKWHKd2nTzwLg8+YAJ9rIU3h7hPMR7z1wlU8K8Kautck
wG+IeMMJF98Qzs8J1NNAvHbBfEGcHzV9fBU3a7rVnk2X+CeQ7xvx1gnUWwij
3sfC11/9v5C+xn61lfhHoNe4xLkTBt/9EnyrItRXov5NEeTbK8Gnmvg1wlV9
Xh3V8L/pqr4uiQLvjY76lsYwT5M69YwBf54B/jU66m0o1R/D/fq5c+gaR/0x
XVM4GZPzp2v9Km8C+XJx4gnUU28i36kSX4PzLIlnEI/zMRlHvgWcj5AB/s8l
7pebfrzS8ZCJfPM5fwUT/ThjAX9tAvkHLfAxDcSvtBB/PY59iVjAG9eh5zR9
i/pMWKwvivgj3JfFMfSzL4X4Ph37k7WBf7ykbxp89jBfY4b847yf4f4Y8B9l
OD8m4u+mUX9vAnoczIBPpUC//tq+D71s1is4v2nsxzGB/X/P9yEloPePlMs9
wXwZNviO8L6TAh9XoB6b8bqEvrts6NEjwf+Fjfi3xN+SJh8JvEv0qyT02pyh
PsQbZP2BJOqpbWH9kv3PcJ4k+BbofxW4/zuDfb8tsD+VLcg3JTAfh1ugf530
31OF+4V6XmxFfd+px4Us/CbGL8tRb4n578r6fFB3FvN7lXqdzrEeifyjbcg/
w3zP2rjvEvGL8rifpp51eez3WYl6cnn2j/kCDuuV6G+r49/HO+iAXyPxGxy8
J5cZf9PB/LXz/JODfGsk5u/GDvhdzFf0Ff4qE/hTzPfZQLxGPrM68Lcx3zTf
l+WMH42h/xUO3wueD+d9X+H9yQNvIop5+EX/ShT93ki/Owp+Dzu4fxHtH1QD
YUA=
       "], {{-131.66666666666666`, 54.11666666666667}, {-132.7, 
       53.25}, {-133.06666666666666`, 
       54.166666666666664`}, {-131.66666666666666`, 
       54.11666666666667}}, {{-127.46666666666667`, 50.7}, {-123.55, 
       48.3}, {-127.48333333333333`, 50.7}}, {{-119.73333333333333`, 
       74.03333333333333}, {-115.31666666666666`, 73.48333333333333}, {-122.8,
        71.08333333333333}, {-126., 71.96666666666667}, {-124.78333333333333`,
        74.33333333333333}, {-119.75, 74.03333333333333}}, {{-114.6, 
       72.6}, {-108.6, 72.51666666666667}, {-107.85, 
       71.6}, {-108.08333333333333`, 73.35}, {-105.2, 
       72.38333333333333}, {-100.96666666666667`, 
       70.15}, {-102.89999999999999`, 68.8}, {-106.58333333333333`, 
       69.5}, {-113.31666666666666`, 
       68.46666666666667}, {-117.43333333333334`, 70.}, {-111.48333333333333`,
        70.33333333333333}, {-117.56666666666666`, 
       70.6}, {-115.06666666666666`, 71.53333333333333}, {-119.1, 
       71.68333333333334}, {-117.35, 72.91666666666667}, {-114.6, 
       72.6}}, {{-83.01666666666667, 64.91666666666667}, {-80.96666666666667, 
       63.449999999999996`}, {-85.23333333333333, 
       63.11666666666667}, {-87.18333333333334, 
       63.583333333333336`}, {-85.61666666666666, 
       65.91666666666667}, {-83.01666666666667, 
       64.91666666666667}}, {{-104.48333333333333`, 
       73.53333333333333}, {-105.28333333333333`, 
       72.85}, {-107.03333333333333`, 
       73.48333333333333}, {-104.48333333333333`, 
       73.53333333333333}}, {{-97.86666666666666, 
       69.88333333333333}, {-95.53333333333333, 
       68.66666666666667}, {-99.43333333333334, 
       68.88333333333333}, {-97.86666666666666, 
       69.88333333333333}}, {{-55.61666666666667, 51.61666666666667}, {-56.85,
        49.55}, {-55.38333333333333, 
       49.03333333333333}, {-53.483333333333334`, 
       49.28333333333333}, {-53.666666666666664`, 
       47.516666666666666`}, {-52.833333333333336`, 
       48.1}, {-53.083333333333336`, 46.65}, {-54.25, 
       47.9}, {-55.38333333333333, 46.86666666666667}, {-55.766666666666666`, 
       47.95}, {-59.3, 47.61666666666667}, {-59.4, 
       47.916666666666664`}, {-57.833333333333336`, 
       49.833333333333336`}, {-55.61666666666667, 
       51.6}}, {{-60.31666666666666, 46.85}, {-61.15, 45.7}, {-59.8, 
       45.93333333333333}, {-61.516666666666666`, 
       45.93333333333333}, {-60.31666666666666, 46.85}}, {{-67.23333333333333,
        68.28333333333333}, {-61.266666666666666`, 
       66.63333333333333}, {-63.55, 64.88333333333333}, {-64.35, 
       66.35}, {-68.53333333333333, 66.3}, {-67.38333333333333, 
       65.53333333333333}, {-64.63333333333333, 62.9}, {-69., 
       63.75}, {-66.06666666666666, 61.86666666666667}, {-71.4, 
       63.05}, {-75.2, 64.45}, {-78., 64.41666666666667}, {-77.43333333333334,
        65.46666666666667}, {-75.38333333333333, 
       64.71666666666667}, {-73.48333333333333, 65.45}, {-71.25, 
       65.95}, {-69.21666666666667, 66.56666666666666}, {-72.98333333333333, 
       66.75}, {-76.65, 68.7}, {-79.01666666666667, 
       70.68333333333334}, {-80.95, 69.71666666666667}, {-87.91666666666667, 
       70.23333333333333}, {-89.56666666666666, 
       71.08333333333333}, {-90.01666666666667, 71.88333333333333}, {-86.15, 
       73.86666666666666}, {-86.8, 70.98333333333333}, {-85.68333333333334, 
       72.9}, {-81.96666666666667, 73.73333333333333}, {-80.96666666666667, 
       71.88333333333333}, {-77.06666666666666, 72.75}, {-75.08333333333333, 
       71.18333333333334}, {-73.38333333333333, 
       70.98333333333333}, {-71.91666666666667, 
       71.56666666666666}, {-72.61666666666666, 
       70.63333333333333}, {-71.53333333333333, 
       70.01666666666667}, {-69.86666666666666, 70.88333333333333}, {-69., 
       70.}, {-70.03333333333333, 69.53333333333333}, {-66.76666666666667, 
       69.33333333333333}, {-69.4, 68.86666666666666}, {-67.23333333333333, 
       68.28333333333333}}, {{-95.08333333333333, 74.01666666666667}, {-90.2, 
       73.9}, {-94.06666666666666, 71.98333333333333}, {-95.08333333333333, 
       74.01666666666667}}, {{-118.64999999999999`, 
       77.36666666666666}, {-115.89999999999999`, 
       76.68333333333334}, {-120.33333333333333`, 
       75.8}, {-123.03333333333333`, 
       76.08333333333333}, {-118.64999999999999`, 
       77.36666666666666}}, {{-103.7, 79.35}, {-99.18333333333334, 
       77.83333333333333}, {-104.81666666666666`, 78.35}, {-103.7, 
       79.35}}, {{-100.38333333333333`, 
       76.63333333333333}, {-97.61666666666666, 
       75.11666666666666}, {-102.78333333333333`, 
       75.55}, {-101.86666666666666`, 76.45}, {-100.38333333333333`, 
       76.63333333333333}}}],
     "\"Canada\""],
    Annotation[#, "Canada", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-23.3104, 14.884}, {-23.3063, 14.8635}, {-23.3289, 
       14.8374}, {-23.3906, 14.8059}, {-23.4831, 14.7949}, {-23.5469, 
       14.8018}, {-23.6333, 14.8593}, {-23.6847, 14.958}, {-23.6888, 
       15.0978}, {-23.7238, 15.1869}, {-23.7238, 15.2485}, {-23.6991, 
       15.2691}, {-23.6559, 15.2718}, {-23.6168, 15.2677}, {-23.5695, 
       15.217}, {-23.5243, 15.0841}, {-23.4379, 14.9731}, {-23.3104, 
       14.884}}, {{-22.6501, 15.8626}, {-22.6751, 15.8574}, {-22.7078, 
       15.8574}, {-22.7904, 15.8647}, {-22.8542, 15.8595}, {-22.8854, 
       15.8688}, {-22.9477, 15.9218}, {-22.9477, 15.9342}, {-22.9212, 
       15.9508}, {-22.9212, 15.9799}, {-22.954, 16.0142}, {-22.9618, 
       16.0266}, {-22.9524, 16.037}, {-22.9181, 16.0495}, {-22.8916, 
       16.0765}, {-22.8792, 16.1367}, {-22.8527, 16.1429}, {-22.8278, 
       16.1429}, {-22.7888, 16.1294}, {-22.767, 16.1294}, {-22.6657, 
       16.1346}, {-22.6283, 16.1336}, {-22.6003, 16.1253}, {-22.5878, 
       16.0962}, {-22.58, 16.0463}, {-22.5582, 16.0339}, {-22.5551, 
       16.0225}, {-22.6439, 15.9249}, {-22.6501, 15.8626}}, {{-25.0189, 
       16.9946}, {-25.0568, 16.9741}, {-25.1508, 16.9296}, {-25.2376, 
       16.8465}, {-25.2954, 16.8393}, {-25.3442, 16.8393}, {-25.3695, 
       16.8525}, {-25.3533, 16.938}, {-25.3623, 16.9513}, {-25.4473, 
       16.9729}, {-25.4563, 16.9826}, {-25.4527, 16.9898}, {-25.3948, 
       17.0271}, {-25.3605, 17.0633}, {-25.2864, 17.1042}, {-25.2539, 
       17.1379}, {-25.2177, 17.1488}, {-25.2087, 17.15}, {-25.1761, 
       17.1428}, {-25.1364, 17.1367}, {-25.1075, 17.1391}, {-25.084, 
       17.1331}, {-25.0225, 17.0452}, {-25.0189, 16.9946}}, {{-24.082, 
       16.5612}, {-24.0508, 16.5404}, {-24.0477, 16.5145}, {-24.0477, 
       16.502}, {-24.0695, 16.4885}, {-24.1397, 16.4896}, {-24.2472, 
       16.5041}, {-24.3002, 16.4999}, {-24.3204, 16.4885}, {-24.3282, 
       16.3909}, {-24.3298, 16.3868}, {-24.3547, 16.3868}, {-24.3936, 
       16.4065}, {-24.5105, 16.5186}, {-24.5339, 16.5529}, {-24.5308, 
       16.5716}, {-24.4575, 16.6121}, {-24.4264, 16.6183}, {-24.3952, 
       16.6173}, {-24.3391, 16.5913}, {-24.1584, 16.5809}, {-24.082, 
       16.5612}}, {{-24.4255, 14.7199}, {-24.4839, 14.7413}, {-24.5148, 
       14.7421}, {-24.5411, 14.7405}, {-24.5768, 14.7413}, {-24.665, 
       14.8175}, {-24.6757, 14.8675}, {-24.6304, 14.9612}, {-24.5935, 
       14.9755}, {-24.5339, 14.9723}, {-24.4982, 14.9739}, {-24.4529, 
       14.9842}, {-24.4326, 14.9842}, {-24.4112, 14.9771}, {-24.3719, 
       14.9215}, {-24.3409, 14.8508}, {-24.3421, 14.7865}, {-24.3624, 
       14.7365}, {-24.3838, 14.7238}, {-24.3969, 14.723}, {-24.4255, 
       14.7199}}, {{-22.8234, 16.6614}, {-22.7989, 16.592}, {-22.8041, 
       16.5825}, {-22.8221, 16.58}, {-22.853, 16.58}, {-22.871, 
       16.5791}, {-22.9057, 16.5671}, {-22.9122, 16.5671}, {-22.9224, 
       16.574}, {-22.9315, 16.6083}, {-22.9315, 16.7034}, {-22.9379, 
       16.724}, {-22.9765, 16.76}, {-22.9765, 16.7755}, {-22.9559, 
       16.8286}, {-22.9508, 16.8972}, {-22.934, 16.9126}, {-22.8826, 
       16.9221}, {-22.8105, 16.9204}, {-22.7873, 16.9032}, {-22.7899, 
       16.8003}, {-22.8118, 16.7943}, {-22.8427, 16.7772}, {-22.8504, 
       16.766}, {-22.8491, 16.736}, {-22.8311, 16.7223}, {-22.8028, 
       16.7137}, {-22.7989, 16.7034}, {-22.8105, 16.6837}, {-22.8234, 
       16.6614}}, {{-23.1232, 15.2252}, {-23.0985, 15.2033}, {-23.0985, 
       15.1841}, {-23.1273, 15.1225}, {-23.1088, 15.0581}, {-23.1397, 
       15.0128}, {-23.1685, 14.9991}, {-23.2075, 15.0142}, {-23.2117, 
       15.0375}, {-23.2651, 15.0731}, {-23.2692, 15.0868}, {-23.2487, 
       15.1266}, {-23.2878, 15.2157}, {-23.2878, 15.239}, {-23.2754, 
       15.2499}, {-23.226, 15.2513}, {-23.1232, 15.2252}}, {{-24.9245, 
       16.8574}, {-24.9153, 16.8507}, {-24.9098, 16.8434}, {-24.9098, 
       16.8276}, {-24.8768, 16.7977}, {-24.8768, 16.7916}, {-24.8796, 
       16.7867}, {-24.9052, 16.7781}, {-24.9107, 16.7726}, {-24.9107, 
       16.7488}, {-24.919, 16.7293}, {-24.9419, 16.7189}, {-25.0581, 
       16.7189}, {-25.0746, 16.7226}, {-25.081, 16.7354}, {-25.1662, 
       16.7818}, {-25.1689, 16.8123}, {-25.1497, 16.8459}, {-25.1287, 
       16.8526}, {-25.0005, 16.8574}, {-24.9245, 16.8574}}, {{-24.8053, 
       14.7958}, {-24.8028, 14.7875}, {-24.8011, 14.778}, {-24.7885, 
       14.7724}, {-24.76, 14.769}, {-24.7391, 14.7595}, {-24.7299, 
       14.7389}, {-24.7475, 14.7193}, {-24.8112, 14.7037}, {-24.8514, 
       14.7025}, {-24.8875, 14.712}, {-24.9135, 14.7366}, {-24.9101, 
       14.7556}, {-24.8464, 14.8104}, {-24.8279, 14.8126}, {-24.8129, 
       14.8109}, {-24.8053, 14.7958}}, {{-24.7944, 16.5895}, {-24.7865, 
       16.5721}, {-24.7931, 16.5598}, {-24.8206, 16.5537}, {-24.8559, 
       16.5572}, {-24.8847, 16.5799}, {-24.8873, 16.5982}, {-24.8755, 
       16.6139}, {-24.8559, 16.6174}, {-24.8258, 16.6148}, {-24.7944, 
       16.5895}}, {{-24.7041, 16.5415}, {-24.6308, 16.5415}, {-24.6046, 
       16.5345}, {-24.602, 16.525}, {-24.6164, 16.5162}, {-24.6596, 
       16.5005}, {-24.691, 16.5014}, {-24.7067, 16.5084}, {-24.7185, 
       16.5258}, {-24.7159, 16.5363}, {-24.7041, 16.5415}}, {{-24.8363, 
       14.9115}, {-24.8573, 14.9266}, {-24.8531, 14.9372}, {-24.8179, 
       14.9528}, {-24.7802, 14.9545}, {-24.7559, 14.95}, {-24.7559, 
       14.9299}, {-24.7944, 14.9104}, {-24.8363, 14.9115}}, {{-24.8959, 
       14.9132}, {-24.8883, 14.9048}, {-24.895, 14.8947}, {-24.9151, 
       14.8841}, {-24.942, 14.883}, {-24.9629, 14.8886}, {-24.9671, 
       14.9009}, {-24.9503, 14.9137}, {-24.9327, 14.9165}, {-24.8959, 
       14.9132}}}],
     "\"CapeVerde\""],
    Annotation[#, "CapeVerde", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-81.4212, 19.355}, {-81.4223, 19.3621}, {-81.42, 
       19.3691}, {-81.4106, 19.3738}, {-81.3976, 19.3715}, {-81.3812, 
       19.3589}, {-81.3659, 19.3033}, {-81.3435, 19.2876}, {-81.3224, 
       19.2813}, {-81.3, 19.2852}, {-81.2811, 19.3001}, {-81.2717, 
       19.3331}, {-81.2565, 19.3495}, {-81.1012, 19.3495}, {-81.0541, 
       19.3284}, {-81.0447, 19.3135}, {-81.0577, 19.2915}, {-81.113, 
       19.279}, {-81.1706, 19.2735}, {-81.22, 19.2414}, {-81.2377, 
       19.2398}, {-81.2741, 19.2468}, {-81.3141, 19.2476}, {-81.3706, 
       19.2398}, {-81.3953, 19.2453}, {-81.4082, 19.257}, {-81.4212, 
       19.355}}, {{-79.8588, 19.6607}, {-79.8782, 19.6607}, {-79.8943, 
       19.6652}, {-79.8983, 19.6723}, {-79.8903, 19.6866}, {-79.8181, 
       19.7267}, {-79.7873, 19.7329}, {-79.7619, 19.7311}, {-79.7519, 
       19.7178}, {-79.7639, 19.6999}, {-79.7946, 19.6803}, {-79.8588, 
       19.6607}}, {{-80.0902, 19.659}, {-80.022, 19.6848}, {-79.9966, 
       19.6866}, {-79.9818, 19.6794}, {-79.9845, 19.667}, {-80.0394, 
       19.6411}, {-80.0915, 19.6269}, {-80.1048, 19.6304}, {-80.1089, 
       19.6393}, {-80.1076, 19.6465}, {-80.0902, 19.659}}}],
     "\"CaymanIslands\""],
    Annotation[#, "CaymanIslands", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{15.5, 7.533333333333333}, {18.583333333333332`, 
      8.033333333333333}, {22.766666666666666`, 10.95}, {22.883333333333333`, 
      10.916666666666666`}, {23.516666666666666`, 8.716666666666667}, {27.45, 
      5.016666666666667}, {22.333333333333332`, 4.133333333333333}, {19.2, 
      4.966666666666667}, {18.633333333333333`, 3.4833333333333334`}, {
      16.583333333333332`, 3.4833333333333334`}, {16.2, 2.216666666666667}, {
      14.416666666666666`, 6.05}, {15.5, 7.533333333333333}}}],
     "\"CentralAfricanRepublic\""],
    Annotation[#, "CentralAfricanRepublic", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{24., 19.5}, {16., 23.5}, {15., 23.}, {16., 20.35}, {
      15.483333333333333`, 16.9}, {13.633333333333333`, 
      13.716666666666667`}, {14.066666666666666`, 13.083333333333334`}, {
      15.683333333333334`, 9.983333333333333}, {13.95, 9.633333333333333}, {
      15.5, 7.533333333333333}, {18.583333333333332`, 8.033333333333333}, {
      22.766666666666666`, 10.95}, {21.833333333333332`, 12.8}, {
      22.933333333333334`, 15.549999999999999`}, {24., 15.7}, {24., 19.5}}}],
     "\"Chad\""],
    Annotation[#, "Chad", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-70.4, -18.35}, {-71.45, -32.65}, {-73.68333333333334, \
-37.333333333333336`}, {-72.3, -41.38333333333333}, {-72.6, -44.5}, \
{-73.73333333333333, -46.53333333333333}, {-74.16666666666667, -45.8}, \
{-75.7, -46.63333333333333}, {-74.51666666666667, -46.8}, \
{-73.21666666666667, -48.}, {-74.65, -48.016666666666666`}, {-74.7, -50.2}, \
{-73.55, -52.05}, {-72.46666666666667, -51.78333333333333}, {-73.45, -53.}, \
{-71.46666666666667, -52.63333333333333}, {-73.21666666666667, \
-53.233333333333334`}, {-71.11666666666666, -52.85}, {-72.13333333333333, \
-53.38333333333333}, {-68.43333333333334, -52.38333333333333}, \
{-71.93333333333334, -51.983333333333334`}, {-73.58333333333333, \
-49.53333333333333}, {-71.1, -44.53333333333333}, {-72.13333333333333, \
-42.28333333333333}, {-69.81666666666666, -34.233333333333334`}, \
{-70.56666666666666, -31.316666666666666`}, {-68.31666666666666, -27.05}, \
{-67.18333333333334, -22.816666666666666`}, {-69.5, -17.5}, {-70.4, -18.35}}, \
{{-67.05, -55.1}, {-68.36666666666666, -54.949999999999996`}, {-67.05, \
-55.1}}, {{-68.4, -54.96666666666667}, {-68.08333333333333, \
-55.71666666666667}, {-70.03333333333333, -55.166666666666664`}, \
{-68.38333333333333, -54.96666666666667}}, {{-68.63333333333333, \
-54.88333333333333}, {-72.01666666666667, -54.516666666666666`}, {-69., \
-54.46666666666667}, {-70.41666666666667, -52.766666666666666`}, \
{-68.61666666666666, -52.65}, {-68.63333333333333, -54.88333333333333}}, \
{{-73.9, -43.38333333333333}, {-73.5, -41.85}, {-73.9, -43.38333333333333}}}],
     
     "\"Chile\""],
    Annotation[#, "Chile", "Tooltip"]& ], 
   TagBox[
    TooltipBox[PolygonBox[{CompressedData["
1:eJxNVEtoE1EUDQWVgpuuVFxZxJW6aSejTVpfkvm1gtDMx0lm3mRMsUIFBSvG
+gERkQoiKCjU4koX4mclIhIXIuJKXQgiLipS8LuouBCRojgv5xg8EC533r3n
nnvve9nQPFjd25PL5cazn7IthTUN8eJ5htWGeNTOsDOBjSpiVuFoInIdGKIT
30rEu4UMJ+n/lPB/V0S/wiEpDIWNFfC0JfjvlGkTMaBwr4z4VxJ1ZktiTmGG
9ds7wP+J+ZtFVw/qjiC+l3wDI+RJwLs4DJ71jNcLYlLhmYTdNMR+qf+ajrxL
MfQbefDXYnFV2XU66kzE4ttShq151PscIf6MBt4rEc4PaOL2rQzHItQpDOL8
SAQ9DwbR1wmeH9eQ96eO7+c1xK2KUHdaE30Ke+qsr7PfGngn89A5WkPcRQ3+
w5D6t6G/Zoj8JR193w1hF7Yj7lyIuP4ieIOQ8ysKX2EF/dYw4r8E6P9pAffk
VID640X0P/TPLyC+N2C9Ar6XvO7+OudzLucvwPfexbkr2I+LeS0L3luP8yoh
77CLvMf0b1S5nzLzq9x3mXqr6HOlAT19Hn2T94z1py3yeZyvhTk98aBn3obd
77MPG/N67VOfA/+HD3vZoZ4Adsbm+wiw15sWvr/dzX1Y+L6W+5Jm1+/0kZrY
664652vwfvD+uCbfaURek+86pj4L9/2XhD6f/cxLxlH/hxj9f7fBt0Viz18d
1H8pobdnlJbvsTkGezoBz/0xzHdfA/M+y/NF+h9Zz0/5nhzEN1Lqt+G/STkf
B3qvM/6CBZ4khb4pi3NIwatxv//9//0FBz4vIw==
       "], {{109.56666666666666`, 19.983333333333334`}, {110.95, 
       19.966666666666665`}, {110.53333333333333`, 18.78333333333333}, {
       108.68333333333334`, 18.5}, {109.58333333333333`, 
       19.983333333333334`}}}],
     "\"China\""],
    Annotation[#, "China", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{105.682, -10.3815}, {105.659, -10.3823}, {
      105.638, -10.3773}, {105.62, -10.3699}, {105.619, -10.3637}, {
      105.633, -10.355}, {105.667, -10.3517}, {105.681, -10.3563}, {
      105.689, -10.3662}, {105.691, -10.3769}, {105.682, -10.3815}}}],
     "\"ChristmasIsland\""],
    Annotation[#, "ChristmasIsland", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{95.312, -12.2373}, {95.3064, -12.2485}, {
      95.2891, -12.2493}, {95.2729, -12.2419}, {95.2723, -12.2311}, {
      95.2872, -12.2225}, {95.2959, -12.2221}, {95.3094, -12.2291}, {
      95.312, -12.2373}}, {{96.8046, -11.7525}, {96.8062, -11.7608}, {
      96.7955, -11.7672}, {96.7821, -11.7633}, {96.7729, -11.7536}, {
      96.7767, -11.7447}, {96.7891, -11.7422}, {96.8003, -11.745}, {
      96.8046, -11.7525}}}],
     "\"CocosKeelingIslands\""],
    Annotation[#, "CocosKeelingIslands", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-71.31666666666666, 11.85}, {-74.86666666666666, 
      11.133333333333333`}, {-76.75, 7.916666666666667}, {-77.36666666666666, 
      8.666666666666666}, {-77.88333333333333, 
      7.233333333333333}, {-77.03333333333333, 
      3.9166666666666665`}, {-78.81666666666666, 
      1.4333333333333333`}, {-75.28333333333333, -0.1}, {-72.93333333333334, \
-2.433333333333333}, {-70.1, -2.6333333333333333`}, {-70.71666666666667, \
-3.783333333333333}, {-69.95, -4.216666666666667}, {-70.05, 
      0.5833333333333334}, {-69.11666666666666, 0.65}, {-69.85, 
      1.7166666666666666`}, {-66.86666666666666, 
      1.2166666666666666`}, {-67.85, 2.783333333333333}, {-67.45, 6.2}, {-72.,
       7.016666666666667}, {-73.38333333333333, 
      9.183333333333334}, {-71.31666666666666, 11.85}}}],
     "\"Colombia\""],
    Annotation[#, "Colombia", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{43.1657, -11.492}, {43.1641, -11.4544}, {
       43.15, -11.4126}, {43.1312, -11.3666}, {43.1328, -11.3457}, {
       43.1532, -11.3237}, {43.1767, -11.3164}, {43.2033, -11.3175}, {
       43.2519, -11.3279}, {43.2849, -11.3237}, {43.299, -11.3279}, {
       43.3209, -11.3436}, {43.3257, -11.3708}, {43.3257, -11.3885}, {
       43.3476, -11.4147}, {43.3492, -11.4377}, {43.346, -11.4764}, {
       43.3539, -11.4983}, {43.3711, -11.5297}, {43.3664, -11.6123}, {
       43.3507, -11.6499}, {43.3476, -11.7001}, {43.3625, -11.7362}, {
       43.3782, -11.7592}, {43.4362, -11.8261}, {43.4566, -11.8648}, {
       43.4566, -11.8846}, {43.4441, -11.8961}, {43.397, -11.8993}, {
       43.3484, -11.9014}, {43.3296, -11.8972}, {43.3155, -11.8815}, {
       43.2903, -11.8522}, {43.2715, -11.848}, {43.2339, -11.8501}, {
       43.2135, -11.8533}, {43.1979, -11.8491}, {43.1273, -11.7843}, {
       43.121, -11.754}, {43.1367, -11.7027}, {43.1696, -11.639}, {
       43.1728, -11.5971}, {43.1602, -11.5229}, {43.1657, -11.492}}, {{
       44.2542, -12.2694}, {44.1961, -12.2422}, {44.1899, -12.2296}, {
       44.1961, -12.2181}, {44.2149, -12.2181}, {44.2589, -12.2223}, {
       44.3043, -12.2056}, {44.331, -12.1784}, {44.3326, -12.1314}, {
       44.3514, -12.1219}, {44.378, -12.1219}, {44.4078, -12.1314}, {
       44.4502, -12.1774}, {44.4815, -12.2296}, {44.527, -12.2714}, {
       44.527, -12.2903}, {44.5098, -12.3321}, {44.4894, -12.3519}, {
       44.4643, -12.3582}, {44.4251, -12.354}, {44.3937, -12.3363}, {
       44.3765, -12.3154}, {44.2867, -12.2759}, {44.2542, -12.2694}}, {{
       43.7139, -12.3614}, {43.6637, -12.3174}, {43.6355, -12.2871}, {
       43.6386, -12.2652}, {43.6606, -12.2495}, {43.6794, -12.2453}, {
       43.7154, -12.2516}, {43.844, -12.307}, {43.8895, -12.3446}, {
       43.9115, -12.3854}, {43.9115, -12.4021}, {43.8911, -12.4053}, {
       43.8331, -12.3938}, {43.728, -12.3676}, {43.7139, -12.3614}}}],
     "\"Comoros\""],
    Annotation[#, "Comoros", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-165.643, -10.8159}, {-165.627, -10.8167}, {-165.617, \
-10.8237}, {-165.614, -10.8344}, {-165.62, -10.8555}, {-165.639, -10.8749}, \
{-165.66, -10.8797}, {-165.676, -10.8727}, {-165.679, -10.8603}, {-165.678, \
-10.8468}, {-165.664, -10.8264}, {-165.643, -10.8159}}, {{-165.628, \
-10.9215}, {-165.614, -10.9272}, {-165.612, -10.9331}, {-165.622, -10.9492}, \
{-165.643, -10.9676}, {-165.66, -10.9703}, {-165.677, -10.9692}, {-165.688, \
-10.9638}, {-165.693, -10.9573}, {-165.69, -10.9525}, {-165.678, -10.9471}, \
{-165.669, -10.9352}, {-165.651, -10.9228}, {-165.628, -10.9215}}, \
{{-165.731, -10.944}, {-165.734, -10.9448}, {-165.737, -10.9454}, {-165.74, \
-10.9457}, {-165.744, -10.9458}, {-165.747, -10.9457}, {-165.75, -10.9454}, \
{-165.753, -10.9448}, {-165.756, -10.944}, {-165.759, -10.9431}, {-165.762, \
-10.9419}, {-165.765, -10.9405}, {-165.767, -10.9389}, {-165.769, -10.9373}, \
{-165.771, -10.9354}, {-165.772, -10.9335}, {-165.773, -10.9314}, {-165.774, \
-10.9293}, {-165.775, -10.9272}, {-165.775, -10.925}, {-165.775, -10.9228}, \
{-165.774, -10.9207}, {-165.773, -10.9186}, {-165.772, -10.9165}, {-165.771, \
-10.9146}, {-165.769, -10.9127}, {-165.767, -10.9111}, {-165.765, -10.9095}, \
{-165.762, -10.9081}, {-165.759, -10.9069}, {-165.756, -10.906}, {-165.753, \
-10.9052}, {-165.75, -10.9046}, {-165.747, -10.9043}, {-165.744, -10.9042}, \
{-165.74, -10.9043}, {-165.737, -10.9046}, {-165.734, -10.9052}, {-165.731, \
-10.906}, {-165.728, -10.9069}, {-165.725, -10.9081}, {-165.723, -10.9095}, \
{-165.72, -10.9111}, {-165.718, -10.9127}, {-165.717, -10.9146}, {-165.715, \
-10.9165}, {-165.714, -10.9186}, {-165.713, -10.9207}, {-165.713, -10.9228}, \
{-165.712, -10.925}, {-165.713, -10.9272}, {-165.713, -10.9293}, {-165.714, \
-10.9314}, {-165.715, -10.9335}, {-165.717, -10.9354}, {-165.718, -10.9373}, \
{-165.72, -10.9389}, {-165.723, -10.9405}, {-165.725, -10.9419}, {-165.728, \
-10.9431}, {-165.731, -10.944}}, {{-165.387, -11.6488}, {-165.39, -11.6495}, \
{-165.393, -11.65}, {-165.395, -11.6503}, {-165.398, -11.6504}, {-165.401, \
-11.6503}, {-165.404, -11.65}, {-165.407, -11.6495}, {-165.41, -11.6488}, \
{-165.413, -11.6479}, {-165.415, -11.6468}, {-165.417, -11.6456}, {-165.419, \
-11.6442}, {-165.421, -11.6426}, {-165.423, -11.641}, {-165.424, -11.6392}, \
{-165.425, -11.6374}, {-165.426, -11.6355}, {-165.426, -11.6336}, {-165.427, \
-11.6316}, {-165.426, -11.6296}, {-165.426, -11.6277}, {-165.425, -11.6258}, \
{-165.424, -11.624}, {-165.423, -11.6222}, {-165.421, -11.6206}, {-165.419, \
-11.619}, {-165.417, -11.6176}, {-165.415, -11.6164}, {-165.413, -11.6153}, \
{-165.41, -11.6144}, {-165.407, -11.6137}, {-165.404, -11.6132}, {-165.401, \
-11.6129}, {-165.398, -11.6128}, {-165.395, -11.6129}, {-165.393, -11.6132}, \
{-165.39, -11.6137}, {-165.387, -11.6144}, {-165.384, -11.6153}, {-165.382, \
-11.6164}, {-165.38, -11.6176}, {-165.377, -11.619}, {-165.376, -11.6206}, \
{-165.374, -11.6222}, {-165.373, -11.624}, {-165.372, -11.6258}, {-165.371, \
-11.6277}, {-165.37, -11.6296}, {-165.37, -11.6316}, {-165.37, -11.6336}, \
{-165.371, -11.6355}, {-165.372, -11.6374}, {-165.373, -11.6392}, {-165.374, \
-11.641}, {-165.376, -11.6426}, {-165.377, -11.6442}, {-165.38, -11.6456}, \
{-165.382, -11.6468}, {-165.384, -11.6479}, {-165.387, -11.6488}}}],
     "\"CookIslands\""],
    Annotation[#, "CookIslands", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-83.65, 10.916666666666666`}, {-82.56666666666666, 
      9.566666666666666}, {-82.9, 8.033333333333333}, {-85.66666666666667, 
      9.9}, {-85.68333333333334, 11.066666666666666`}, {-83.65, 
      10.916666666666666`}}}],
     "\"CostaRica\""],
    Annotation[#, "CostaRica", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{18.65, 42.36666666666667}, {14.566666666666666`, 45.3}, {
      13.983333333333333`, 45.5}, {15.716666666666667`, 45.8}, {
      16.53333333333333, 46.6}, {17.866666666666667`, 45.766666666666666`}, {
      18.85, 45.916666666666664`}, {18.8, 44.88333333333333}, {
      18.466666666666665`, 45.05}, {15.95, 45.166666666666664`}, {16.1, 
      44.56666666666666}, {16.366666666666667`, 44.18333333333333}, {
      18.633333333333333`, 42.5}, {18.65, 42.36666666666667}}}],
     "\"Croatia\""],
    Annotation[#, "Croatia", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-84.91666666666667, 
      21.916666666666668`}, {-81.13333333333333, 23.216666666666665`}, {-77.3,
       21.75}, {-74.13333333333333, 20.183333333333334`}, {-77.46666666666667,
       20.15}, {-81.88333333333333, 22.683333333333334`}, {-84.91666666666667,
       21.916666666666668`}}}],
     "\"Cuba\""],
    Annotation[#, "Cuba", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{34.583333333333336`, 35.666666666666664`}, {
      33.03333333333333, 34.56666666666666}, {32.266666666666666`, 
      35.06666666666666}, {34.583333333333336`, 35.666666666666664`}}}],
     "\"Cyprus\""],
    Annotation[#, "Cyprus", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{16.516666666666666`, 48.166666666666664`}, {
      17.766666666666666`, 49.416666666666664`}, {19.116666666666667`, 
      49.88333333333333}, {14.833333333333334`, 50.86666666666667}, {12.1, 
      50.31666666666666}, {13.833333333333334`, 48.766666666666666`}, {
      16.516666666666666`, 48.166666666666664`}}}],
     "\"CzechRepublic\""],
    Annotation[#, "CzechRepublic", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{13.183333333333334`, -5.866666666666666}, {
      12.2, -5.783333333333333}, {13.1, -4.633333333333333}, {
      15.9, -3.9166666666666665`}, {18.633333333333333`, 
      3.4833333333333334`}, {19.2, 4.966666666666667}, {22.333333333333332`, 
      4.133333333333333}, {27.45, 5.016666666666667}, {30.866666666666667`, 
      3.4833333333333334`}, {31.3, 2.1166666666666667`}, {
      29.599999999999998`, -1.3833333333333333`}, {
      29.03333333333333, -2.7333333333333334`}, {
      29.416666666666668`, -4.45}, {
      30.766666666666666`, -8.183333333333334}, {
      28.366666666666667`, -9.266666666666666}, {
      28.366666666666667`, -11.55}, {29.8, -12.15}, {29.8, -13.45}, {
      27.2, -11.566666666666666`}, {
      23.983333333333334`, -10.866666666666667`}, {
      22.166666666666668`, -10.866666666666667`}, {
      21.78333333333333, -7.283333333333333}, {18., -8.1}, {
      16.983333333333334`, -7.25}, {
      16.516666666666666`, -5.883333333333333}, {
      13.183333333333334`, -5.866666666666666}}}],
     "\"DemocraticRepublicCongo\""],
    Annotation[#, "DemocraticRepublicCongo", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{8.666666666666666, 54.9}, {8.133333333333333, 
      56.583333333333336`}, {9.95, 57.05}, {8.25, 56.81666666666666}, {10.55, 
      57.733333333333334`}, {9.45, 54.81666666666666}, {8.666666666666666, 
      54.916666666666664`}}}],
     "\"Denmark\""],
    Annotation[#, "Denmark", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{43.28333333333333, 11.516666666666666`}, {
      42.516666666666666`, 11.533333333333333`}, {43.11666666666667, 
      12.716666666666667`}, {41.766666666666666`, 11.516666666666666`}, {
      42.95, 11.}, {43.28333333333333, 11.516666666666666`}}}],
     "\"Djibouti\""],
    Annotation[#, "Djibouti", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-61.3308, 15.249}, {-61.3582, 15.2384}, {-61.3834, 
      15.2374}, {-61.3999, 15.2432}, {-61.415, 15.2643}, {-61.4107, 
      15.3166}, {-61.4323, 15.4078}, {-61.5079, 15.5047}, {-61.5093, 
      15.5219}, {-61.5014, 15.5373}, {-61.4661, 15.5517}, {-61.4532, 
      15.568}, {-61.4438, 15.6184}, {-61.433, 15.627}, {-61.4129, 
      15.628}, {-61.3733, 15.6059}, {-61.2473, 15.5575}, {-61.2142, 
      15.5239}, {-61.2099, 15.4653}, {-61.2344, 15.4178}, {-61.2452, 
      15.3449}, {-61.2581, 15.3099}, {-61.3308, 15.249}}}],
     "\"Dominica\""],
    Annotation[#, "Dominica", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-71.76666666666667, 19.7}, {-68.31666666666666, 
      18.6}, {-71.78333333333333, 18.05}, {-71.76666666666667, 19.7}}}],
     "\"DominicanRepublic\""],
    Annotation[#, "DominicanRepublic", "Tooltip"]& ], 
   TagBox[
    TooltipBox[PolygonBox[{CompressedData["
1:eJxdVAlMVVcQxV814ILQUsGK+u6DWHBroOICLgPUqlAVJaJVw5RF+oMoFpTa
IuJOkVpEgliWIlFRiLEfkEUoMCAKQtTIIiDF1mqrKMSCIgJCO+//X016k5eX
mzv3zpkz54zwDV6zWWVgYODFn/J38C5aPsYRobPZsPJplqDuuhW+JoBQ5T43
2nmvoJPb3j1ALggWX0xJLfIVJDQh6rglCH29E8yNZwvaGW8x3OtThFdZCUZl
1oLq+fr65Qh5q6r8Rn4gyG2ManrUSoTYh91T6sYJajq9feGoYASfIFHt3CdR
eU36kvxwhAUBp+yHOiVqn2pneGE3wp+jnoWYPpNIed44AqHXyWxE/wuJZuak
Pju3ByE3r3SZekCirC4GvBch3Ozi0vv9Ep1wjQl6dIDPw7s1Hk8lClDWYYRu
51sBjY8kMrxgucE/5u2+ltM/P8r4PR+cTX4o0VDDrvapcQi+bta3a5slep3J
CY4jNE8r/2P7HYlu9XJgPEJ66eaViY0SGSjrJEJ8cP5lO8b/sbKS39anzf8T
goPtiDZvlaCrEhOYjtB2w3NSyDuCOlYXTj50GmFDz+W7RwYl+vvcNfe5mQhd
L9w+P/xf/iyErZbZ49PqJIrr3L3Y4SJCbavpytE3JVLoHZ+NcGXaveoFFRKZ
t9zs9cxF2HdrnNXBAom4u6rpBQgZyZWSJkePrxjhzJyvQspyJVLCH5Qg2Iwb
nZdxWaL854MNu8oR0HtvxI4iSdffa5z/0UBmV46+/lqEtLBXW3LyJWqzHrkv
oR7hoP+w9wqvSmTV2rcnsAHBcGHy2rRafTyfD4wo9mll/LEVPTabqhAiHu/v
P2Ek6AzLoekKQmINFzRRkJKmjvEkD3UsPTJP0EubTbEVeaxH0y1dth5CVy/z
Y5HQYKT21esrA+H2umMBMwIFhaqZoTSE31YdTdx2XJD2n6TnL0eQtg7uZ9cs
867UakHr51+qDvsBIcfPyuTnVkFruB1PoxH8IlsWftMsyJbT93yHkGB855/5
vwpKYRpDeH9J5epV8ESQIienKNbDl7lPQnvEG30qz6y2kEmrK9azVmeTZIoM
/GVH/C6EU9Ga++3vy8TuqknfiTD4cufvKaayDl8I61PxId/X+m0r68tx2IqD
M2VqZHnaqRGaPitt+WuOTMy+a4w/gsuixy0XHGWdvny4Xq+Ii/kuMpkoBXoh
aOal9DUGyW/8uGjx9yaTU/Xx7Nex0eEzIgplesHtb2c/r9uYXdZRKhO76lsz
3ntkRThOzpVJgW/xCevDttakKkkmZXyoXBFKHDRr9x+SdXwuQtDyEqnPz/t7
KqMjU0JlSvqRlzNC1NYY+4n+sk7P/L5zUrbacaNMEz9iRTGeefaxr8s9ZN38
cUP4kMeCJden9a87QnGnS2jqSJk4W2kan5890BNpXK+fX8sQln5t4uTJ/VXo
62S8s2dZGl6vE6SdEzzPhh+7W3l9rL4fPO9W3DkfpbaWidXIE4rjTecsKJFl
XTzPx/ry/sVRE2QKVho2X++XPkHn2a7RvA8b3N+muSHo//P0X6t2h5M=
       "], {{124.385, -9.12053}, {124.43, -9.17586}, {124.443, -9.23217}, {
       124.42, -9.30899}, {124.384, -9.35613}, {124.368, -9.36639}, {
       124.317, -9.37349}, {124.28, -9.3703}, {124.224, -9.35665}, {
       124.176, -9.32972}, {124.127, -9.28356}, {124.081, -9.23204}, {
       124.173, -9.18393}, {124.257, -9.1399}, {124.385, -9.12053}}}],
     "\"EastTimor\""],
    Annotation[#, "EastTimor", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-80.33333333333333, -3.3666666666666667`}, \
{-79.76666666666667, -2.0166666666666666`}, {-80.91666666666667, \
-2.3166666666666664`}, {-80.91666666666667, -1.0333333333333332`}, \
{-78.81666666666666, 
      1.4333333333333333`}, {-75.28333333333333, -0.1}, {-79.03333333333333, \
-5.}, {-80.48333333333333, -4.433333333333334}, {-80.33333333333333, \
-3.3666666666666667`}}}],
     "\"Ecuador\""],
    Annotation[#, "Ecuador", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{35.61666666666667, 23.133333333333333`}, {
      32.333333333333336`, 29.599999999999998`}, {34.25, 
      27.733333333333334`}, {34.96666666666667, 29.55}, {34.9, 
      29.483333333333334`}, {34.266666666666666`, 31.216666666666665`}, {
      34.21666666666667, 31.333333333333332`}, {25.15, 31.65}, {25., 22.}, {
      33.93333333333333, 21.75}, {35.61666666666667, 23.133333333333333`}}}],
     "\"Egypt\""],
    Annotation[#, "Egypt", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-87.83333333333333, 13.433333333333334`}, {-90.1, 
      13.75}, {-89.35, 14.433333333333334`}, {-87.83333333333333, 
      13.433333333333334`}}}],
     "\"ElSalvador\""],
    Annotation[#, "ElSalvador", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{9.8, 1.}, {9.816666666666666, 2.35}, {11.333333333333334`, 
      2.1666666666666665`}, {11.35, 1.}, {9.8, 1.}}}],
     "\"EquatorialGuinea\""],
    Annotation[#, "EquatorialGuinea", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{36.46666666666667, 14.366666666666667`}, {37., 
      17.066666666666666`}, {38.61666666666667, 18.03333333333333}, {
      39.71666666666667, 15.083333333333334`}, {43.11666666666667, 
      12.716666666666667`}, {42.666666666666664`, 12.316666666666666`}, {
      38.833333333333336`, 14.633333333333333`}, {36.46666666666667, 
      14.366666666666667`}}}],
     "\"Eritrea\""],
    Annotation[#, "Eritrea", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{28.03333333333333, 59.483333333333334`}, {
      27.599999999999998`, 57.81666666666666}, {24.1, 57.86666666666667}, {
      23.466666666666665`, 59.21666666666667}, {28.03333333333333, 
      59.483333333333334`}}}],
     "\"Estonia\""],
    Annotation[#, "Estonia", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{36.46666666666667, 14.366666666666667`}, {
      38.833333333333336`, 14.633333333333333`}, {42.666666666666664`, 
      12.316666666666666`}, {41.766666666666666`, 11.516666666666666`}, {
      42.95, 11.}, {44.016666666666666`, 9.}, {47.983333333333334`, 8.}, {
      44.95, 4.9}, {41.9, 3.9833333333333334`}, {39.516666666666666`, 
      3.433333333333333}, {35.93333333333333, 4.616666666666666}, {
      32.983333333333334`, 7.933333333333334}, {34.28333333333333, 10.55}, {
      36.15, 12.7}, {36.46666666666667, 14.366666666666667`}}}],
     "\"Ethiopia\""],
    Annotation[#, "Ethiopia", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-61.03333333333333, -52.016666666666666`}, \
{-59.21666666666667, -51.4}, {-61.03333333333333, -52.016666666666666`}}, \
{{-59.71666666666667, -52.11666666666667}, {-57.733333333333334`, \
-51.699999999999996`}, {-59.71666666666667, -52.11666666666667}}}],
     "\"FalklandIslands\""],
    Annotation[#, "FalklandIslands", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-7.23855, 62.3179}, {-7.20545, 62.3359}, {-7.17975, 
       62.3343}, {-7.1105, 62.293}, {-7.03695, 62.2456}, {-6.98545, 
       62.235}, {-6.95355, 62.208}, {-6.95235, 62.177}, {-6.9401, 
       62.1647}, {-6.88125, 62.1484}, {-6.86225, 62.1251}, {-6.861, 
       62.0932}, {-6.8365, 62.076}, {-6.7985, 62.0589}, {-6.7519, 
       62.009}, {-6.747, 61.9542}, {-6.77215, 61.9448}, {-6.83345, 
       61.9456}, {-6.86775, 61.9612}, {-6.9033, 62.0102}, {-6.9609, 
       62.0601}, {-7.0541, 62.1295}, {-7.1908, 62.188}, {-7.25575, 
       62.2264}, {-7.26555, 62.2485}, {-7.257, 62.3}, {-7.23855, 
       62.3179}}, {{-6.95935, 61.7034}, {-6.9182, 61.7034}, {-6.90445, 
       61.6963}, {-6.9075, 61.6759}, {-6.9159, 61.6632}, {-6.9113, 
       61.65}, {-6.8366, 61.6449}, {-6.78475, 61.6307}, {-6.771, 
       61.6205}, {-6.77405, 61.6022}, {-6.80915, 61.5799}, {-6.80915, 
       61.5666}, {-6.77405, 61.5483}, {-6.77255, 61.5372}, {-6.80915, 
       61.5138}, {-6.81675, 61.5036}, {-6.80455, 61.4945}, {-6.7893, 
       61.4955}, {-6.7588, 61.5036}, {-6.7405, 61.5046}, {-6.73285, 
       61.4985}, {-6.7344, 61.4619}, {-6.7298, 61.4324}, {-6.697, 
       61.4156}, {-6.69245, 61.3994}, {-6.70615, 61.3923}, {-6.75345, 
       61.3943}, {-6.7824, 61.4156}, {-6.8297, 61.4339}, {-6.8617, 
       61.4421}, {-6.8861, 61.4634}, {-6.89375, 61.4929}, {-6.94255, 
       61.5377}, {-6.9456, 61.5631}, {-6.95935, 61.5783}, {-7.02035, 
       61.5987}, {-7.03405, 61.6119}, {-7.0356, 61.6373}, {-6.9967, 
       61.6805}, {-6.95935, 61.7034}}, {{-7.0577, 62.3922}, {-7.0135, 
       62.3973}, {-6.97385, 62.3861}, {-6.8442, 62.3129}, {-6.8274, 
       62.3007}, {-6.8259, 62.2875}, {-6.8335, 62.2682}, {-6.81825, 
       62.258}, {-6.77405, 62.259}, {-6.75115, 62.2509}, {-6.73285, 
       62.2366}, {-6.742, 62.2255}, {-6.7603, 62.2133}, {-6.76185, 
       62.2051}, {-6.73135, 62.1858}, {-6.7039, 62.1655}, {-6.7039, 
       62.1472}, {-6.71915, 62.0973}, {-6.7481, 62.0984}, {-6.7786, 
       62.1258}, {-6.7969, 62.1685}, {-6.8152, 62.1807}, {-6.8335, 
       62.1797}, {-6.8564, 62.1634}, {-6.8747, 62.1634}, {-6.8869, 
       62.1777}, {-6.893, 62.2061}, {-6.91895, 62.2316}, {-6.9723, 
       62.26}, {-7.04245, 62.2875}, {-7.076, 62.3129}, {-7.09735, 
       62.3403}, {-7.0882, 62.3658}, {-7.0577, 62.3922}}, {{-7.4611, 
       62.2007}, {-7.39305, 62.1995}, {-7.28765, 62.1888}, {-7.2006, 
       62.1504}, {-7.12825, 62.1096}, {-7.12395, 62.0887}, {-7.12765, 
       62.0642}, {-7.1742, 62.0487}, {-7.3017, 62.0536}, {-7.3348, 
       62.0683}, {-7.3569, 62.092}, {-7.3471, 62.1034}, {-7.33235, 
       62.1181}, {-7.3348, 62.132}, {-7.38755, 62.1484}, {-7.4574, 
       62.1672}, {-7.47885, 62.1823}, {-7.47885, 62.1953}, {-7.4611, 
       62.2007}}, {{-6.97955, 61.9505}, {-6.89775, 61.948}, {-6.75885, 
       61.9125}, {-6.70935, 61.8833}, {-6.70175, 61.8643}, {-6.70175, 
       61.8275}, {-6.7246, 61.8123}, {-6.75695, 61.8097}, {-6.7874, 
       61.8237}, {-6.8159, 61.8516}, {-6.83115, 61.8567}, {-6.8597, 
       61.8567}, {-6.8825, 61.8503}, {-6.92625, 61.8313}, {-6.9548, 
       61.8313}, {-6.97575, 61.8402}, {-6.98335, 61.8579}, {-6.98525, 
       61.896}, {-6.99665, 61.9188}, {-6.99665, 61.9391}, {-6.97955, 
       61.9505}}, {{-6.62915, 62.3576}, {-6.61085, 62.3576}, {-6.59105, 
       62.3383}, {-6.5712, 62.3088}, {-6.54985, 62.2946}, {-6.5331, 
       62.2885}, {-6.5148, 62.2539}, {-6.51175, 62.2326}, {-6.5163, 
       62.2214}, {-6.5346, 62.2183}, {-6.5529, 62.2336}, {-6.5651, 
       62.2468}, {-6.5773, 62.2499}, {-6.59105, 62.2448}, {-6.59865, 
       62.2244}, {-6.6139, 62.2143}, {-6.6322, 62.2163}, {-6.65205, 
       62.2488}, {-6.6368, 62.2895}, {-6.6261, 62.3149}, {-6.6307, 
       62.3526}, {-6.62915, 62.3576}}, {{-6.60095, 62.4192}, {-6.5781, 
       62.4161}, {-6.55215, 62.3876}, {-6.53385, 62.3744}, {-6.50945, 
       62.3622}, {-6.4835, 62.3602}, {-6.47435, 62.351}, {-6.482, 
       62.3338}, {-6.5018, 62.3277}, {-6.5415, 62.3297}, {-6.5781, 
       62.349}, {-6.6147, 62.3785}, {-6.6162, 62.3978}, {-6.60705, 
       62.412}, {-6.60095, 62.4192}}, {{-6.73215, 62.0532}, {-6.68025, 
       62.0562}, {-6.6513, 62.044}, {-6.6406, 62.0023}, {-6.6467, 
       61.9749}, {-6.6711, 61.9606}, {-6.7001, 61.9677}, {-6.73215, 
       61.9952}, {-6.7367, 62.041}, {-6.73215, 62.0532}}}],
     "\"FaroeIslands\""],
    Annotation[#, "FaroeIslands", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{177.83333333333334`, -17.366666666666667`}, {
      178.7, -18.}, {178., -18.266666666666666`}}}],
     "\"Fiji\""],
    Annotation[#, "Fiji", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{24.166666666666668`, 65.81666666666666}, {25.45, 64.95}, {
      21.1, 62.766666666666666`}, {21.416666666666668`, 
      60.583333333333336`}, {22.883333333333333`, 59.8}, {27.866666666666667`,
       60.56666666666666}, {31.583333333333332`, 62.916666666666664`}, {
      29.016666666666666`, 69.03333333333333}, {28.966666666666665`, 69.05}, {
      27.9, 70.08333333333333}, {25.75, 68.98333333333333}, {20.6, 69.05}, {
      24.166666666666668`, 65.81666666666666}}}],
     "\"Finland\""],
    Annotation[#, "Finland", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{7.533333333333333, 43.78333333333333}, {7.433333333333334, 
      43.75}, {7.3999999999999995`, 43.733333333333334`}, {
      3.8833333333333333`, 43.55}, {3.216666666666667, 42.43333333333333}, {
      1.75, 42.5}, {1.5, 42.6}, {-1.7666666666666666`, 
      43.4}, {-1.1166666666666667`, 46.31666666666666}, {-4.783333333333333, 
      48.516666666666666`}, {-1.35, 48.63333333333333}, {-1.9333333333333333`,
       49.733333333333334`}, {0., 49.333333333333336`}, {2.55, 
      51.083333333333336`}, {5.816666666666666, 49.53333333333333}, {
      6.366666666666666, 49.46666666666667}, {8.233333333333333, 
      48.96666666666667}, {7.583333333333333, 47.583333333333336`}, {
      5.966666666666667, 46.21666666666667}, {7.033333333333333, 
      45.93333333333333}, {7.533333333333333, 43.78333333333333}}}],
     "\"France\""],
    Annotation[#, "France", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-54.166666666666664`, 5.35}, {-52.93333333333333, 
      5.45}, {-51.68333333333333, 4.033333333333333}, {-52.733333333333334`, 
      2.3333333333333335`}, {-54.61666666666667, 
      2.3333333333333335`}, {-54.166666666666664`, 5.35}}}],
     "\"FrenchGuiana\""],
    Annotation[#, "FrenchGuiana", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-149.301, -17.6312}, {-149.283, -17.6553}, {-149.249, \
-17.7303}, {-149.23, -17.7551}, {-149.2, -17.7704}, {-149.166, -17.7777}, \
{-149.134, -17.7806}, {-149.107, -17.7864}, {-149.095, -17.7973}, {-149.086, \
-17.8214}, {-149.103, -17.8447}, {-149.148, -17.8571}, {-149.185, -17.8607}, \
{-149.209, -17.8556}, {-149.233, -17.8388}, {-149.263, -17.7915}, {-149.281, \
-17.7755}, {-149.312, -17.7726}, {-149.331, -17.7799}, {-149.36, -17.8039}, \
{-149.428, -17.8236}, {-149.484, -17.825}, {-149.537, -17.8097}, {-149.601, \
-17.785}, {-149.625, -17.7514}, {-149.626, -17.6903}, {-149.61, -17.6145}, \
{-149.588, -17.5927}, {-149.496, -17.573}, {-149.415, -17.5708}, {-149.337, \
-17.5992}, {-149.301, -17.6312}}, {{-149.739, -17.4215}, {-149.717, \
-17.4258}, {-149.705, -17.4316}, {-149.7, -17.4412}, {-149.705, -17.4501}, \
{-149.719, -17.4551}, {-149.733, -17.4621}, {-149.742, -17.4694}, {-149.743, \
-17.4848}, {-149.751, -17.4956}, {-149.767, -17.5002}, {-149.781, -17.5103}, \
{-149.795, -17.5253}, {-149.817, -17.5292}, {-149.843, -17.518}, {-149.883, \
-17.4898}, {-149.908, -17.4613}, {-149.901, -17.4432}, {-149.864, -17.4331}, \
{-149.828, -17.4274}, {-149.739, -17.4215}}, {{-148.124, -17.9257}, \
{-148.107, -17.9286}, {-148.097, -17.9351}, {-148.098, -17.946}, {-148.109, \
-17.9596}, {-148.121, -17.9754}, {-148.127, -17.995}, {-148.137, -18.0048}, \
{-148.149, -18.0025}, {-148.175, -17.9863}, {-148.214, -17.9543}, {-148.214, \
-17.9464}, {-148.206, -17.9385}, {-148.186, -17.9294}, {-148.158, -17.9253}, \
{-148.124, -17.9257}}, {{-150.752, -17.7129}, {-150.758, -17.7115}, \
{-150.763, -17.7097}, {-150.768, -17.7077}, {-150.773, -17.7055}, {-150.778, \
-17.7031}, {-150.783, -17.7005}, {-150.787, -17.6978}, {-150.791, -17.6949}, \
{-150.795, -17.692}, {-150.798, -17.689}, {-150.801, -17.6859}, {-150.803, \
-17.6829}, {-150.805, -17.6799}, {-150.806, -17.677}, {-150.806, -17.6743}, \
{-150.806, -17.6716}, {-150.805, -17.6691}, {-150.804, -17.6669}, {-150.803, \
-17.6648}, {-150.8, -17.663}, {-150.797, -17.6614}, {-150.794, -17.6601}, \
{-150.791, -17.6592}, {-150.786, -17.6585}, {-150.782, -17.6581}, {-150.777, \
-17.6581}, {-150.772, -17.6583}, {-150.767, -17.6589}, {-150.762, -17.6598}, \
{-150.756, -17.661}, {-150.751, -17.6625}, {-150.746, -17.6642}, {-150.74, \
-17.6662}, {-150.735, -17.6684}, {-150.73, -17.6708}, {-150.725, -17.6734}, \
{-150.721, -17.6762}, {-150.717, -17.679}, {-150.713, -17.682}, {-150.71, \
-17.685}, {-150.708, -17.688}, {-150.706, -17.691}, {-150.704, -17.694}, \
{-150.703, -17.6969}, {-150.702, -17.6997}, {-150.702, -17.7023}, {-150.703, \
-17.7048}, {-150.704, -17.7071}, {-150.706, -17.7091}, {-150.708, -17.711}, \
{-150.711, -17.7125}, {-150.714, -17.7138}, {-150.718, -17.7148}, {-150.722, \
-17.7154}, {-150.726, -17.7158}, {-150.731, -17.7159}, {-150.736, -17.7156}, \
{-150.741, -17.715}, {-150.747, -17.7141}, {-150.752, -17.7129}}, {{-149.535, \
-17.0938}, {-149.54, -17.0914}, {-149.545, -17.0887}, {-149.55, -17.0859}, \
{-149.555, -17.0828}, {-149.559, -17.0797}, {-149.563, -17.0764}, {-149.567, \
-17.073}, {-149.571, -17.0696}, {-149.574, -17.0661}, {-149.577, -17.0627}, \
{-149.579, -17.0594}, {-149.581, -17.0562}, {-149.582, -17.0532}, {-149.582, \
-17.0503}, {-149.583, -17.0476}, {-149.582, -17.0451}, {-149.581, -17.043}, \
{-149.58, -17.0411}, {-149.578, -17.0395}, {-149.576, -17.0382}, {-149.573, \
-17.0373}, {-149.569, -17.0368}, {-149.566, -17.0366}, {-149.562, -17.0367}, \
{-149.557, -17.0372}, {-149.553, -17.0381}, {-149.548, -17.0393}, {-149.543, \
-17.0408}, {-149.538, -17.0427}, {-149.533, -17.0448}, {-149.528, -17.0472}, \
{-149.523, -17.0499}, {-149.518, -17.0527}, {-149.513, -17.0558}, {-149.509, \
-17.0589}, {-149.505, -17.0622}, {-149.501, -17.0656}, {-149.497, -17.069}, \
{-149.494, -17.0725}, {-149.492, -17.0759}, {-149.489, -17.0792}, {-149.488, \
-17.0824}, {-149.486, -17.0854}, {-149.486, -17.0883}, {-149.486, -17.091}, \
{-149.486, -17.0935}, {-149.487, -17.0956}, {-149.488, -17.0975}, {-149.49, \
-17.0991}, {-149.493, -17.1004}, {-149.495, -17.1013}, {-149.499, -17.1018}, \
{-149.502, -17.102}, {-149.506, -17.1019}, {-149.511, -17.1014}, {-149.515, \
-17.1005}, {-149.52, -17.0993}, {-149.525, -17.0978}, {-149.53, -17.0959}, \
{-149.535, -17.0938}}}],
     "\"FrenchPolynesia\""],
    Annotation[#, "FrenchPolynesia", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{9.8, 1.}, {8.716666666666667, -0.6333333333333333}, {
      11.166666666666666`, -3.9499999999999997`}, {
      11.583333333333334`, -2.3333333333333335`}, {14.45, -1.9}, {14.5, 
      0.9333333333333333}, {13.166666666666666`, 1.2333333333333334`}, {
      13.299999999999999`, 2.1666666666666665`}, {11.333333333333334`, 
      2.1666666666666665`}, {11.35, 1.}, {9.8, 1.}}}],
     "\"Gabon\""],
    Annotation[#, "Gabon", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-16.566666666666666`, 
      13.583333333333334`}, {-15.299999999999999`, 13.45}, {-16.75, 
      13.033333333333333`}, {-16.75, 
      13.066666666666666`}, {-13.799999999999999`, 
      13.383333333333333`}, {-16.566666666666666`, 13.583333333333334`}}}],
     "\"Gambia\""],
    Annotation[#, "Gambia", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{34.0734, 31.2784}, {34.112, 31.2908}, {34.2306, 31.3699}, {
      34.4738, 31.5893}, {34.5387, 31.6578}, {34.6148, 31.5928}, {34.5863, 
      31.4347}, {34.515, 31.3677}, {34.3724, 31.2034}, {34.1772, 31.0677}, {
      34.1552, 31.1011}, {34.0734, 31.2784}}}],
     "\"GazaStrip\""],
    Annotation[#, "GazaStrip", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{40., 43.38333333333333}, {43.95, 42.71666666666667}, {46.3,
       41.81666666666666}, {47.05, 40.75}, {45.016666666666666`, 41.2}, {
      43.166666666666664`, 40.583333333333336`}, {41.53333333333333, 
      41.516666666666666`}, {40., 43.38333333333333}}}],
     "\"Georgia\""],
    Annotation[#, "Georgia", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{7.2, 53.233333333333334`}, {9.833333333333334, 
      53.53333333333333}, {8.666666666666666, 54.916666666666664`}, {9.45, 
      54.81666666666666}, {9.45, 54.833333333333336`}, {10.9, 
      53.949999999999996`}, {14.266666666666666`, 53.733333333333334`}, {
      14.233333333333333`, 53.93333333333333}, {14.833333333333334`, 
      50.86666666666667}, {12.1, 50.31666666666666}, {13.833333333333334`, 
      48.766666666666666`}, {13.049999999999999`, 47.5}, {9.733333333333333, 
      47.53333333333333}, {9.566666666666666, 47.53333333333333}, {
      7.583333333333333, 47.583333333333336`}, {8.233333333333333, 
      48.96666666666667}, {6.366666666666666, 49.46666666666667}, {
      6.133333333333333, 50.13333333333333}, {6.016666666666667, 50.75}, {7.2,
       53.233333333333334`}}}],
     "\"Germany\""],
    Annotation[#, "Germany", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-3.1, 5.083333333333333}, {0., 5.616666666666666}, {1.2, 
      6.1}, {0., 10.6}, {-0.08333333333333333, 10.7}, {0., 11.1}, {-0.15, 
      11.133333333333333`}, {-2.8333333333333335`, 11.}, {-2.683333333333333, 
      9.483333333333333}, {-3.1, 5.083333333333333}}}],
     "\"Ghana\""],
    Annotation[#, "Ghana", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-5.34003, 36.1598}, {-5.34164, 36.1448}, {-5.33969, 
      36.1382}, {-5.34307, 36.1234}, {-5.33965, 36.1153}, {-5.34378, 
      36.1124}, {-5.34903, 36.1169}, {-5.35107, 36.1258}, {-5.35553, 
      36.1314}, {-5.35664, 36.1382}, {-5.35537, 36.1419}, {-5.35726, 
      36.147}, {-5.35249, 36.1551}, {-5.35322, 36.1598}, {-5.34003, 
      36.1598}}}],
     "\"Gibraltar\""],
    Annotation[#, "Gibraltar", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{26.03333333333333, 40.733333333333334`}, {23.7, 
      40.71666666666667}, {22.583333333333332`, 40.46666666666667}, {
      22.516666666666666`, 38.85}, {24.066666666666666`, 38.2}, {
      22.716666666666665`, 37.56666666666666}, {23.2, 36.43333333333333}, {
      21.1, 37.85}, {22.216666666666665`, 38.18333333333333}, {
      23.233333333333334`, 38.15}, {20.383333333333333`, 39.28333333333333}, {
      20.016666666666666`, 39.68333333333333}, {20.983333333333334`, 40.85}, {
      22.933333333333334`, 41.35}, {26.366666666666667`, 41.71666666666667}, {
      26.03333333333333, 40.733333333333334`}}}],
     "\"Greece\""],
    Annotation[#, "Greece", "Tooltip"]& ], 
   TagBox[
    TooltipBox[PolygonBox[{CompressedData["
1:eJxNVDtoFFEUHQVBxCaIgogQRTCVSOKuDpOFG5Kd3ZnEybyZt9hYiOAHgx9I
kSIgKhpSiCBWURQtFFwbt46RJ1gEUUEbsVgRGwUhFlayjTP3nI0eWB5v3r3n
nnvefbvn5MXs1EbP8xrFr1wXS/wYc7oupvKlW6Ambq7EfiO6Hg7cXoWRd28L
TFWdV+KKkRFFzd1dKmHkWbvAOd8NlPhgRD8vjYJ/cyb6/XbFaZ375LvpI39n
Br7ZwOn345mgzqH1vebtrrpWiceZvFgu0Bt2v9YKPMhE1wtVpzreZKJxrRHw
f87QzxzzKzn5hsE/mgt0Vp3yzvTPD6LfQQs9UnETJfZZ+jHkTiss+Y/QL7vu
l9a7YaE38OmfRb+5sJ6FP6YCvicW9VfGEP/cwt+2D/6PVnS9xvv6zvrHGvD/
Ffl/j8OPNvV/DXHe6dcLwX/Jwr+1JvjOsF58FHoWLO7Tn0I/LeYPJNA/z3qz
Ke57lX4OZeB/mIv6dj3F/kQOvZ+M07zxHPoGDfg35ai/JYHeDTn7mUS9nwb8
qzH07eB81CLEPzLsbxL3/9TA/108v8rzTox62znP2yLw9/geujH8/pYifz4C
35+UfsWYv/fcH4g4f4zvxZiX1+Rbod6FFP16EfJfMn6ZfJdT0bgwwns5n6Lf
JvlsPz/G/G79x4d3S76A/XamOc9N3M/ZBOf3Qod3mkD/rZDvNeH7rJOf8UEd
eroJ/LpT531OM38C9RvU+9//y1/eXwRC
       "], {{-54.3, 70.31666666666666}, {-51.833333333333336`, 
       69.63333333333333}, {-53.56666666666666, 69.23333333333333}, {-54.3, 
       70.31666666666666}}}],
     "\"Greenland\""],
    Annotation[#, "Greenland", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-61.7245, 12.}, {-61.7391, 11.9881}, {-61.7535, 
      11.9725}, {-61.7828, 11.9567}, {-61.8286, 11.9641}, {-61.8393, 
      11.9772}, {-61.8361, 11.9913}, {-61.8294, 12.}, {-61.7847, 
      12.0363}, {-61.7807, 12.1007}, {-61.7542, 12.1333}, {-61.7066, 
      12.1624}, {-61.6524, 12.1791}, {-61.6259, 12.1756}, {-61.6034, 
      12.1606}, {-61.5995, 12.1359}, {-61.6206, 12.0557}, {-61.6206, 
      12.0302}, {-61.6392, 12.0196}, {-61.6987, 12.0125}, {-61.7245, 12.}}}],
     "\"Grenada\""],
    Annotation[#, "Grenada", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-61.6069, 16.0991}, {-61.5872, 15.9472}, {-61.618, 
       15.8651}, {-61.6538, 15.8404}, {-61.6919, 15.8405}, {-61.724, 
       15.8552}, {-61.7696, 15.916}, {-61.8102, 16.049}, {-61.8188, 
       16.2181}, {-61.7955, 16.2789}, {-61.7634, 16.3002}, {-61.7326, 
       16.3035}, {-61.7141, 16.3018}, {-61.6464, 16.2649}, {-61.6119, 
       16.2567}, {-61.5811, 16.26}, {-61.5367, 16.2895}, {-61.5293, 
       16.3109}, {-61.5601, 16.3626}, {-61.5613, 16.3881}, {-61.5281, 
       16.4135}, {-61.4665, 16.4324}, {-61.4258, 16.4267}, {-61.4061, 
       16.4045}, {-61.4073, 16.3544}, {-61.395, 16.3355}, {-61.3297, 
       16.2945}, {-61.3002, 16.2682}, {-61.2238, 16.2419}, {-61.2016, 
       16.2288}, {-61.2102, 16.2082}, {-61.2472, 16.1959}, {-61.4382, 
       16.1877}, {-61.5404, 16.2}, {-61.591, 16.2017}, {-61.623, 
       16.1918}, {-61.6328, 16.1746}, {-61.6328, 16.1541}, {-61.6193, 
       16.1245}, {-61.6069, 16.0991}}, {{-61.1798, 15.9371}, {-61.1777, 
       15.9202}, {-61.1856, 15.9064}, {-61.2062, 15.8915}, {-61.2322, 
       15.8851}, {-61.2727, 15.8822}, {-61.3096, 15.8847}, {-61.3453, 
       15.8988}, {-61.3646, 15.9149}, {-61.3658, 15.9294}, {-61.3507, 
       15.942}, {-61.3211, 15.9537}, {-61.2654, 15.9557}, {-61.211, 
       15.9504}, {-61.1798, 15.9371}}}],
     "\"Guadeloupe\""],
    Annotation[#, "Guadeloupe", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{144.634, 13.4367}, {144.624, 13.4568}, {144.628, 
      13.4758}, {144.648, 13.4885}, {144.738, 13.5215}, {144.79, 13.5649}, {
      144.843, 13.6436}, {144.852, 13.6521}, {144.886, 13.6423}, {144.957, 
      13.6155}, {144.988, 13.5915}, {144.982, 13.5683}, {144.952, 13.5415}, {
      144.849, 13.4782}, {144.831, 13.4465}, {144.795, 13.3803}, {144.779, 
      13.3212}, {144.742, 13.288}, {144.705, 13.2773}, {144.669, 13.2865}, {
      144.655, 13.3027}, {144.663, 13.3381}, {144.634, 13.4367}}}],
     "\"Guam\""],
    Annotation[#, "Guam", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-88.91666666666667, 15.9}, {-88.21666666666667, 
      15.716666666666667`}, {-89.35, 14.433333333333334`}, {-90.1, 
      13.75}, {-92.25, 14.549999999999999`}, {-91.73333333333333, 
      16.066666666666666`}, {-90.43333333333334, 16.1}, {-90.98333333333333, 
      17.816666666666666`}, {-89.13333333333333, 
      17.816666666666666`}, {-88.91666666666667, 15.9}}}],
     "\"Guatemala\""],
    Annotation[#, "Guatemala", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-2.74065, 49.4329}, {-2.70755, 49.4445}, {-2.6658, 
       49.4735}, {-2.6449, 49.4817}, {-2.6188, 49.4828}, {-2.6101, 
       49.4689}, {-2.6136, 49.4109}, {-2.631, 49.397}, {-2.6571, 
       49.383}, {-2.7215, 49.3819}, {-2.7511, 49.3854}, {-2.77195, 
       49.3923}, {-2.77195, 49.4074}, {-2.7528, 49.4283}, {-2.74065, 
       49.4329}}, {{-2.4448, 49.4329}, {-2.4204, 49.4329}, {-2.4065, 
       49.4306}, {-2.3856, 49.4144}, {-2.3856, 49.3993}, {-2.403, 
       49.3877}, {-2.42565, 49.3877}, {-2.4465, 49.3912}, {-2.4535, 
       49.4109}, {-2.4587, 49.4248}, {-2.4448, 49.4329}}}],
     "\"Guernsey\""],
    Annotation[#, "Guernsey", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-13.299999999999999`, 
      9.033333333333333}, {-15.016666666666666`, 
      10.95}, {-13.716666666666667`, 12.683333333333334`}, {-11.35, 
      12.466666666666667`}, {-11.366666666666667`, 12.4}, {-8.983333333333333,
       12.4}, {-7.983333333333333, 10.15}, {-7.966666666666667, 
      10.166666666666666`}, {-8.466666666666667, 
      7.566666666666666}, {-10.266666666666666`, 
      8.483333333333333}, {-11.216666666666667`, 10.}, {-13.299999999999999`, 
      9.033333333333333}}}],
     "\"Guinea\""],
    Annotation[#, "Guinea", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-16.716666666666665`, 12.316666666666666`}, {-15., 
      11.966666666666667`}, {-15.5, 
      11.333333333333334`}, {-15.016666666666666`, 
      10.95}, {-13.716666666666667`, 
      12.683333333333334`}, {-16.716666666666665`, 12.316666666666666`}}}],
     "\"GuineaBissau\""],
    Annotation[#, "GuineaBissau", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-57.25, 5.483333333333333}, {-58.68333333333333, 
      6.383333333333333}, {-58.483333333333334`, 
      7.366666666666666}, {-59.983333333333334`, 
      8.533333333333333}, {-61.38333333333333, 5.95}, {-60.733333333333334`, 
      5.2}, {-59.666666666666664`, 4.383333333333333}, {-59.25, 
      1.3833333333333333`}, {-56.46666666666667, 1.95}, {-58.05, 4.}, {-57.25,
       5.483333333333333}}}],
     "\"Guyana\""],
    Annotation[#, "Guyana", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-71.76666666666667, 
      18.03333333333333}, {-74.48333333333333, 18.433333333333334`}, {-72.35, 
      18.53333333333333}, {-73.45, 19.75}, {-71.75, 
      19.7}, {-71.76666666666667, 18.03333333333333}}}],
     "\"Haiti\""],
    Annotation[#, "Haiti", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-88.21666666666667, 
      15.716666666666667`}, {-83.13333333333333, 15.}, {-87.3, 
      12.983333333333333`}, {-87.83333333333333, 
      13.433333333333334`}, {-89.35, 
      14.433333333333334`}, {-88.21666666666667, 15.716666666666667`}}}],
     "\"Honduras\""],
    Annotation[#, "Honduras", "Tooltip"]& ], 
   TagBox[
    TooltipBox[PolygonBox[{CompressedData["
1:eJxlmXVYVkkbh8UEuxsVO1GMI7quHkAUCQVxUeQlRBAMUMoAaRQEJVSMFTtw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       "], {{114.2986, 22.52828}, {114.293, 22.5311}, {114.2857, 22.52904}, {
       114.2837, 22.53012}, {114.2879, 22.53508}, {114.2845, 22.54186}, {
       114.2873, 22.54539}, {114.2874, 22.54953}, {114.2908, 22.55033}, {
       114.2942, 22.54744}, {114.3135, 22.54643}, {114.315, 22.5451}, {
       114.3121, 22.54248}, {114.2991, 22.53956}, {114.2959, 22.54129}, {
       114.2942, 22.53895}, {114.3007, 22.52973}, {114.2986, 22.52828}}, {{
       114.4301, 22.541}, {114.4347, 22.53563}, {114.4329, 22.53304}, {
       114.4233, 22.53758}, {114.4222, 22.54123}, {114.4235, 22.54586}, {
       114.4255, 22.54661}, {114.4301, 22.541}}, {{114.3152, 22.51892}, {
       114.3092, 22.52149}, {114.3051, 22.52596}, {114.3057, 22.5285}, {
       114.3079, 22.52903}, {114.3129, 22.52689}, {114.3147, 22.53222}, {
       114.3167, 22.53297}, {114.3177, 22.53117}, {114.3167, 22.51988}, {
       114.3152, 22.51892}}, {{114.3066, 22.51796}, {114.3184, 22.51327}, {
       114.3177, 22.51072}, {114.3078, 22.50422}, {114.2978, 22.50115}, {
       114.2943, 22.50242}, {114.2906, 22.50943}, {114.2995, 22.50879}, {
       114.3058, 22.51174}, {114.3066, 22.51796}}, {{114.357, 22.4623}, {
       114.3566, 22.46665}, {114.3535, 22.46978}, {114.3534, 22.47414}, {
       114.35, 22.47794}, {114.3573, 22.48115}, {114.3603, 22.48101}, {
       114.3631, 22.47834}, {114.3622, 22.47555}, {114.3654, 22.46945}, {
       114.3628, 22.46455}, {114.357, 22.4623}}, {{114.3428, 22.45728}, {
       114.3368, 22.46054}, {114.3354, 22.46509}, {114.3381, 22.47298}, {
       114.3404, 22.46915}, {114.3407, 22.46249}, {114.3442, 22.46007}, {
       114.3443, 22.45801}, {114.3428, 22.45728}}, {{114.2425, 22.44523}, {
       114.2421, 22.44866}, {114.2502, 22.45581}, {114.2518, 22.44758}, {
       114.2488, 22.44841}, {114.2425, 22.44523}}, {{114.3223, 22.33856}, {
       114.3178, 22.34049}, {114.3167, 22.34038}, {114.3085, 22.33952}, {
       114.3034, 22.34281}, {114.2997, 22.34913}, {114.3022, 22.35564}, {
       114.296, 22.37038}, {114.2976, 22.37411}, {114.3018, 22.37492}, {
       114.3041, 22.37224}, {114.3134, 22.37344}, {114.323, 22.36937}, {
       114.3286, 22.36449}, {114.3267, 22.36259}, {114.3183, 22.36739}, {
       114.3159, 22.3664}, {114.3187, 22.36281}, {114.3202, 22.35642}, {
       114.3267, 22.34789}, {114.3223, 22.33856}}, {{114.2923, 22.35097}, {
       114.2847, 22.36291}, {114.2853, 22.36637}, {114.2889, 22.36924}, {
       114.2925, 22.36591}, {114.2955, 22.35681}, {114.2945, 22.35126}, {
       114.2923, 22.35097}}, {{114.351, 22.33094}, {114.3494, 22.3325}, {
       114.3501, 22.33619}, {114.3465, 22.33861}, {114.3488, 22.34328}, {
       114.3475, 22.34557}, {114.3451, 22.3496}, {114.3426, 22.34538}, {
       114.3362, 22.34335}, {114.3337, 22.34603}, {114.3346, 22.35341}, {
       114.3286, 22.35759}, {114.3289, 22.36105}, {114.3321, 22.36161}, {
       114.335, 22.36491}, {114.3394, 22.36459}, {114.344, 22.36749}, {
       114.3485, 22.36716}, {114.3549, 22.36046}, {114.3707, 22.35405}, {
       114.375, 22.35097}, {114.3657, 22.3477}, {114.3617, 22.34298}, {
       114.3559, 22.34533}, {114.3547, 22.34369}, {114.3569, 22.33847}, {
       114.3536, 22.3324}, {114.351, 22.33094}}, {{114.0892, 22.32002}, {
       114.0869, 22.32316}, {114.0896, 22.32945}, {114.086, 22.33163}, {
       114.0879, 22.33583}, {114.0814, 22.33792}, {114.0798, 22.3466}, {
       114.0747, 22.3508}, {114.0813, 22.35285}, {114.0882, 22.35238}, {
       114.096, 22.35631}, {114.1027, 22.35468}, {114.1045, 22.35267}, {
       114.1022, 22.34846}, {114.1069, 22.34149}, {114.1009, 22.32246}, {
       114.0948, 22.32295}, {114.0892, 22.32002}}, {{114.0557, 22.33641}, {
       114.0534, 22.33932}, {114.0497, 22.34081}, {114.0525, 22.34457}, {
       114.0526, 22.34894}, {114.0562, 22.34975}, {114.0582, 22.3489}, {
       114.0574, 22.34496}, {114.0593, 22.33997}, {114.0557, 
       22.33641}}, CompressedData["
1:eJxd1gk01VkcB3CVjKeiUqlpsrRLhuRdO7eXjDUPSfQiZausiSS7FNqeyk6F
mhRGJUoikpZpUSliskw1CQktSDHz/et13jnjHMf5nLvf/+/+fhQ2+Vi7jhUR
EdmPX+ZvTJfVFdlIHvXimxg9tCY0l/1AZzUcNz94Vg2s4p0z5ho8Xbvwgtka
QlPMpx8wjeLRpvwhnpctoeoRl2kU/GF3+sg7O0KjXt5OKYPzRPdXp8JrQ/8o
2RTNo/1USdUF/f/5IPfEB74umbE8G/NNDiZ5+nBzp1ZHqA2hp1dTaWd4dF6s
X5V7ajWFa968auJaEep6buMaa/hc3xOLTVxCk/lSwQR2ub/B7I4lob9LGC0I
wPr1WmIuhXBqWRJfCq5raZtwFOPvZa0q+Yjz9Nyt5hTAgX6zJ7XBGsONh6fB
jU6BlrLob1dr0jMb4w33e7Z/RXs7OzCu00J4H58zPlX0wYvDDpRug8vCqryf
ryY0bWdG9jz4rt+ZHefh3hnG3G8RPOp+ZcwJOXiLT2/MXfht/5FbHhZCz3N3
ttQxJ3Rri1/8IbjFvqybY0aon55EQw4c52h04YUpoapLzko/gp3AJ/DEsUr7
ZmC9Lu/jnXz090joDjGAh5z39HrAI64Dr53h3W4mEWno/3PlevkVcF3VkME+
E0LXc/TfNmI+P/n5E1KMCQ3/qu37EBZhfmDVskVSE9BfmcW1uWdE6AHTTlF1
+IGsx/i9hoR2GP/6rwKcJJp71nUloZuy6tV7MJ77baZ/A4fQwRsu5zbCj5wr
romgfXReeAO3Ve0MrHXpTmBFOI8musZu3oD55mi6G26BxR0iFfLQ3qDeo7kK
5iiMlczCfLGf/mqIhB/b8d2WcoTzPQ0VsU6nmK++xksdLvXFgWDmugzhOQ4u
Oq0GhF6RRcTDJtnJVkthJpwWwY2pnHa2vnC+I+PN2+r1yPdxWM8N15iF9m3M
B4bN7vykl64n7O9t5RZtrk0o7/CNz4thiez34/iw0bF+MSf45jHj7GQt3M/k
dVqXYGKfI5sNi02dZnAL9mUOCEtWqKYugU8cuj1xDRHOPy6xr2c5rGaLCMD6
kbVS8/ZoEFq0+8N5Loxo8c9EO2v2cUdF2HTF5WR1+I3BqdaKMB7lxyomGKJ/
Ap5LHuxbUrpMD+vFy21+7wC3Dvc5FmO/Kc1H98XASSsR+DqERluZZEbAgwcL
9Yp0CZ1CdMut4dG4wPnfOyCAQnl0WV1/YT7aK6pkFtrAtUsRMBg/qU2ZfzKE
R0/FTswLgrv8i6d/3c2jN6ZKLU7Heleb4oddYZsEic0TsB/+ycFlb4J5tPd6
4rvnmoQWIM3UwPlaVPU37L8F23NA//yC506BMJM+7GD7vZr1NWxCObVuz9rR
f31JvQyLLTgvrCLTl5kCS3jM9QxivOVAvRVbcB54AM9xDlxdp+Q6C26aHeKs
BouulVS+uAvx8XDA5hUcE/KoyB7+6OeVOxPrSztjBKw4t3pJC/abc0R7jEUQ
jzY06z5TQHuE8fXQOXD5zD/jAjE+c8rp8qqdWE/MKcUc9mceLLxrHTLvcpxv
LCteDq5kxYhrqpPvcRfIoyuYxIp2uU+ea0NhdrFngYqaYL/wSn70VDe4rQKJ
FS6aTy2U0d/9WftWJfhLdGR7C4xsHN4YwKPZGR52CmzB94M/DZZbhCNehvsD
2jLgWdjudHyfz6X4QLD4TvfuEny/mYlPWR6Yj8UEzo94gWubvGTS0J4QhgQC
D3QE3ad6wvZ7gwOzZPB+djAPAueL0gr+1gLHPUFihiNZL66m4z0qr/yl6yX6
G4UsciunwvP+8Oi6MJOmYvH+h7q7KrUw3qqcfd6WI6gfcAtz/cgffZtRGHD/
MQtkuWQVoa9QnpLgnZN1bN4i3xjcelG8By6TUDQ4i/xWZ4EXiu95Lk2+Ux/5
j6AcPoZTVFQq9U0F94n42K+hdvibiaDewBJmuic9TYXxWo20twZm0nMjvFE3
eu8I+jPhoIl4zfDyNrfE/Ey64MHbRxZOm2ssiAe4x1ZJOgz9v0h1XC6ErZ09
Fe7AtkxBxHvqjW8LV4I1mISO9xZrhBMh3xsyFwKrMQnDTLC/MGE90Wm1PJgM
j+ZRmHnGxTCyXbMu6lHZlYNivbCeyVW3D7Ajk+iQT+7tcepsh5MUDgX4MfkQ
5cQB9ezwaxR0eFJe0LyPXGG+CvOpOzEMZ9yUP78dXhSd8/oZ6itTLlmoF9PG
DxkeR/0ffWfwhb87Ei/CYUwBYOrJu+fiN/H/wP//P/kPhcicaw==
       "], {{114.3269, 22.32124}, {114.3187, 22.32237}, {114.3167, 
       22.32392}, {114.3178, 22.32694}, {114.3144, 22.33303}, {114.3168, 
       22.33495}, {114.3245, 22.33403}, {114.3287, 22.32589}, {114.3269, 
       22.32124}}, {{113.929, 22.2905}, {113.935, 22.3164}, {113.926, 
       22.3166}, {113.907, 22.3053}, {113.908, 22.2957}, {113.929, 
       22.2905}}, {{114.3419, 22.30883}, {114.341, 22.31179}, {114.3447, 
       22.31972}, {114.3513, 22.32107}, {114.3538, 22.32}, {114.3468, 
       22.31036}, {114.3419, 22.30883}}, {{114.3636, 22.30122}, {114.3568, 
       22.31365}, {114.3588, 22.31808}, {114.3608, 22.31745}, {114.3686, 
       22.30827}, {114.3636, 22.30122}}, {{114.138, 22.30962}, {114.1351, 
       22.31229}, {114.1289, 22.3137}, {114.1269, 22.31616}, {114.1295, 
       22.31739}, {114.1429, 22.31506}, {114.138, 22.30962}}, CompressedData["

1:eJxd1Ass3VccB/Bb9a5aN6PmUYqUqlZ7zbm4Hodbj+o8pqrYP8pF3FC1lWmr
VpPrUe+LovFeSzzXWTFBY2YYlSlqY7PSjrZarWDFUsq+V7ZIJrmRT875/87v
d37nnP38CI9gCRaL5YOf+L/1Ze9q0xSG3o3KVZW0JjRuzeLTwWsM5RKJxTb4
Z67rcDa8099SmATnjcoJdOBqj0YZX1tC9VrXk18nM/QLHbec23BW17IBA18q
vqnbepzQPhmrotOwIF+yusae0EhB9qtY+N5bRft4B0KLTW42cRAvSNpwesqR
0NDJz1Iz4VqnxG8TnQjlqHV+oo38ejbuXFmCE3a7fXMd5icsCKZh93XVyLFU
hpYqZOaccfw3fhpDSwLpSgycNbOkNQL/9OXL5XmYlX11zSKdod99xS/+/gSh
f3rvbRmG5QU65y45E1pT4UqVMhg6xa4a4MO5FjtcEmBDi5yBOKzXrLw2MA8H
DkdFs+GQX56FHspk6FOdDqVG1NPM+bsrCLY8NtfjDnOn3DIKYFEYr8cM61ca
8TTm4D493ZAAWE691O9gFkODp5R/2MT8fSqhLn9hvDyl4fFz7NeeGFJnjfFo
tpmzHxzlcH1FGs4rtBqSx/5ykd5ueLLO68C6HfpRsCm6CoeLTjgMwp0vSy2N
RAx9PNz7bhj6U+vv6aEPb+WFftKKqQ5FeKsOWAXl9eP7bPnAXbawLNpXBs+u
5PQKrAjN56WdewaLszxlSejM+5r9T2A5swRDUy6hyVVn7rERr0mC59ViQagr
f4+3Ofxo4nWIDexVVvf1OOZ3z72RajffXo8fIl8yZkbo4Acf/66O+UajhU81
Odv5zoYeWikwJVQR7Q+GjzpmTU18SGhrhvSCCsxc+OOgJlyv4RvERbwX1qwa
F3hf1azTEbjccy3KkhA69t6S7X3x/tvKmYRztvtzMtdj6BXqs8RxZ+D6SIU+
PxtCoQ0e3GZ0gGjB5WrGD/VgdNtPAfNjlxrcw2BVf62SNtQnLu8sXGWzlq0D
i5ffxHmp0lHuVYEFjS8im+G4Sc+KLtSLaNLx8OKRvYslcLQbTgCcya0ULiO/
6t6TnBRYokzLQRb+bXD11DQcUqT+QAn1bJ0TWCCVVH8e+1ON7e+GXe0N0w+j
fu2RiLMyyKepL7qjjE2ovvgDjBss6T0vPEboRvDqTABcbYqbDhdexMWF9V3n
LxpgfsRCYr8nLHvBvesjE0LF19EWTtq536cT8QtlcYDF+egLb82Ybo8fvi9s
b0R+E6lvg1dxv/obUjls5I/HZWQSNka5N/7rJ6x0/KGMNqwRG8A+DSfGDjX6
wNLxebw0eLzdZrIO8aYri7q14VF/taQs7FeS2a894XDLMGtSwnz7ezu0dxP7
ret8RWgMm6gH5WTjfLIi4iV78B7cGUNAuO9Ge74INn4jP5KOfpqI/2DBbNkj
Ppxi6/9kCO/Lj+N2IiHiRYkvGIzTHeMKf45n0ws+2q7/zi7Mx+tjYwr7jj9Q
jIO9xRsL326/XMvDfTp/a8ddKVg8vRn+//v7DwHzVOc=
       "], {{114.0345, 22.27576}, {114.0316, 22.28233}, {114.0339, 
       22.28562}, {114.0369, 22.28548}, {114.0404, 22.28353}, {114.0393, 
       22.27959}, {114.0409, 22.27757}, {114.0345, 22.27576}}, {{114.0392, 
       22.23639}, {114.0362, 22.23675}, {114.029, 22.24685}, {114.0232, 
       22.25011}, {114.024, 22.2529}, {114.0262, 22.25343}, {114.0382, 
       22.24991}, {114.04, 22.2479}, {114.0392, 22.23639}}, {{114.2853, 
       22.23449}, {114.2774, 22.24229}, {114.2788, 22.24969}, {114.2871, 
       22.25224}, {114.2916, 22.25169}, {114.298, 22.24545}, {114.2929, 
       22.24254}, {114.2937, 22.23958}, {114.2916, 22.23721}, {114.2886, 
       22.23781}, {114.2853, 22.23449}}, {{114.1439, 22.24225}, {114.1546, 
       22.23869}, {114.1572, 22.23532}, {114.1585, 22.2264}, {114.1486, 
       22.2339}, {114.1439, 22.24225}}, {{114.1231, 22.17634}, {114.1203, 
       22.17786}, {114.1129, 22.17854}, {114.1088, 22.1814}, {114.1129, 
       22.1853}, {114.1148, 22.1871}, {114.1169, 22.19774}, {114.1151, 
       22.21239}, {114.1125, 22.21598}, {114.1093, 22.21657}, {114.1005, 
       22.21399}, {114.1011, 22.217}, {114.1059, 22.22106}, {114.1034, 
       22.22304}, {114.1047, 22.22585}, {114.1027, 22.22831}, {114.1041, 
       22.23088}, {114.1102, 22.23085}, {114.1183, 22.23294}, {114.1192, 
       22.22286}, {114.1239, 22.21497}, {114.1276, 22.21462}, {114.1296, 
       22.21974}, {114.1316, 22.22026}, {114.1327, 22.21571}, {114.1313, 
       22.20922}, {114.1249, 22.20696}, {114.1227, 22.20114}, {114.1249, 
       22.19983}, {114.1293, 22.20319}, {114.1352, 22.20314}, {114.1441, 
       22.20802}, {114.15, 22.20821}, {114.1571, 22.20407}, {114.1542, 
       22.20122}, {114.1461, 22.20096}, {114.1425, 22.19832}, {114.1369, 
       22.19677}, {114.1358, 22.19374}, {114.1458, 22.18142}, {114.145, 
       22.17864}, {114.1432, 22.17881}, {114.1317, 22.18994}, {114.1306, 
       22.186}, {114.1333, 22.18034}, {114.1324, 22.17801}, {114.1274, 
       22.18061}, {114.1231, 22.17634}}, {{114.0151, 22.19379}, {114.013, 
       22.19694}, {114.0156, 22.20138}, {114.0205, 22.202}, {114.0217, 
       22.20388}, {114.019, 22.21}, {114.0207, 22.21626}, {114.0283, 
       22.21834}, {114.0298, 22.21678}, {114.0261, 22.20977}, {114.0267, 
       22.20703}, {114.0337, 22.19898}, {114.0323, 22.19779}, {114.0238, 
       22.19843}, {114.0206, 22.19419}, {114.0151, 22.19379}}, {{113.9904, 
       22.18764}, {113.9869, 22.18818}, {113.9814, 22.19374}, {113.9809, 
       22.19831}, {113.9846, 22.20211}, {113.9883, 22.20095}, {113.9914, 
       22.19526}, {113.9926, 22.19109}, {113.9904, 22.18764}}, {{113.9052, 
       22.1866}, {113.9093, 22.18315}, {113.9165, 22.18105}, {113.9156, 
       22.17901}, {113.9045, 22.17897}, {113.9052, 22.1866}}, {{114.2427, 
       22.17642}, {114.2393, 22.17654}, {114.2401, 22.18599}, {114.2512, 
       22.18656}, {114.2545, 22.18506}, {114.2517, 22.17991}, {114.2427, 
       22.17642}}, {{114.2512, 22.15324}, {114.2478, 22.15865}, {114.2494, 
       22.16169}, {114.2461, 22.16457}, {114.2465, 22.16734}, {114.2535, 
       22.17055}, {114.2616, 22.17861}, {114.2703, 22.16992}, {114.2687, 
       22.16574}, {114.2714, 22.15939}, {114.2648, 22.15895}, {114.2595, 
       22.16086}, {114.2544, 22.1538}, {114.2512, 22.15324}}, {{113.9023, 
       22.15651}, {113.8995, 22.15991}, {113.9016, 22.16191}, {113.9092, 
       22.16331}, {113.908, 22.16727}, {113.9108, 22.17049}, {113.9139, 
       22.171}, {113.9169, 22.16822}, {113.9149, 22.16146}, {113.9067, 
       22.15719}, {113.9023, 22.15651}}}],
     "\"HongKong\""],
    Annotation[#, "HongKong", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{22.9, 47.95}, {22.15, 48.416666666666664`}, {
      17.166666666666668`, 48.016666666666666`}, {16.116666666666667`, 
      46.86666666666667}, {17.866666666666667`, 45.766666666666666`}, {
      20.266666666666666`, 46.11666666666667}, {22.9, 47.95}}}],
     "\"Hungary\""],
    Annotation[#, "Hungary", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-21.366666666666667`, 63.85}, {-24.05, 
      64.86666666666666}, {-21.7, 65.45}, {-24.53333333333333, 
      65.5}, {-23.116666666666667`, 66.43333333333334}, {-21.083333333333332`,
       65.16666666666667}, {-16.166666666666668`, 
      66.53333333333333}, {-13.633333333333333`, 
      65.46666666666667}, {-18.166666666666668`, 
      63.46666666666667}, {-21.366666666666667`, 63.85}}}],
     "\"Iceland\""],
    Annotation[#, "Iceland", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{89.03333333333333, 21.916666666666668`}, {87.9, 
      22.416666666666668`}, {86.41666666666667, 19.983333333333334`}, {
      80.28333333333333, 15.7}, {79.85, 11.166666666666666`}, {79.45, 9.15}, {
      76.96666666666667, 8.4}, {73.3, 16.516666666666666`}, {
      72.91666666666667, 22.266666666666666`}, {72.11666666666666, 21.2}, {
      70.73333333333333, 20.716666666666665`}, {68.95, 22.3}, {70.5, 23.1}, {
      68.2, 23.766666666666666`}, {71.1, 24.416666666666668`}, {
      69.51666666666667, 27.}, {71.9, 27.966666666666665`}, {
      74.68333333333334, 31.066666666666666`}, {75.38333333333333, 
      32.28333333333333}, {73.95, 34.65}, {77.81666666666666, 35.5}, {80.2, 
      35.1}, {78.9, 33.96666666666667}, {79.5, 32.65}, {78.4, 
      32.53333333333333}, {81.03333333333333, 30.2}, {80.06666666666666, 
      28.833333333333332`}, {82.76666666666667, 27.5}, {87.33333333333333, 
      26.349999999999998`}, {88.15, 27.866666666666667`}, {88.91666666666667, 
      27.316666666666666`}, {91.65, 27.766666666666666`}, {96.08333333333333, 
      29.466666666666665`}, {97.35, 28.216666666666665`}, {97.13333333333333, 
      27.083333333333332`}, {95.13333333333333, 26.616666666666667`}, {92.6, 
      21.983333333333334`}, {92.28333333333333, 23.633333333333333`}, {
      91.61666666666666, 22.95}, {91.16666666666667, 23.633333333333333`}, {
      92.4, 25.03333333333333}, {89.85, 25.28333333333333}, {
      88.41666666666667, 26.633333333333333`}, {89.01666666666667, 
      25.28333333333333}, {89.03333333333333, 21.916666666666668`}}}],
     "\"India\""],
    Annotation[#, "India", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{95.23333333333333, 5.566666666666666}, {97.51666666666667, 
       5.25}, {102.93333333333334`, 0.7}, {102.43333333333334`, 0.25}, {
       103.73333333333333`, 0.2833333333333333}, {
       104.38333333333333`, -1.0333333333333332`}, {
       104.53333333333333`, -2.7666666666666666`}, {
       106.08333333333333`, -3.2333333333333334`}, {
       105.78333333333333`, -5.833333333333333}, {
       104.66666666666667`, -5.933333333333334}, {
       101.6, -3.216666666666667}, {95.23333333333333, 5.566666666666666}}, {{
       99.2, -1.7666666666666666`}, {
       98.88333333333333, -0.9166666666666666}, {
       99.2, -1.7666666666666666`}}, {{
       105.88333333333333`, -1.4833333333333334`}, {
       106.51666666666667`, -3.1}, {
       105.13333333333333`, -2.0666666666666664`}, {
       105.89999999999999`, -1.5}}, {{109.64999999999999`, 
       2.0666666666666664`}, {109.11666666666666`, -0.5}, {
       110.23333333333333`, -2.9833333333333334`}, {
       111.86666666666666`, -3.5666666666666664`}, {
       114.63333333333333`, -4.183333333333334}, {116., -3.55}, {
       116.21666666666667`, -1.7833333333333332`}, {117.89999999999999`, 
       1.1166666666666667`}, {119.01666666666667`, 0.9833333333333333}, {
       117.03333333333333`, 3.6}, {117.58333333333333`, 4.166666666666667}, {
       115.86666666666666`, 4.366666666666666}, {114.88333333333333`, 
       2.0666666666666664`}, {110.56666666666666`, 0.85}, {
       109.64999999999999`, 2.0666666666666664`}}, {{
       109.89999999999999`, -7.833333333333333}, {
       114.56666666666666`, -8.783333333333333}, {
       114.43333333333334`, -7.8}, {
       111.01666666666667`, -6.433333333333334}, {
       107.03333333333333`, -5.916666666666667}, {
       105.21666666666667`, -6.766666666666667}, {
       109.89999999999999`, -7.833333333333333}}, {{
       112.93333333333334`, -6.8999999999999995`}, {
       114.13333333333333`, -6.95}, {112.95, -6.8999999999999995`}}, {{
       114.48333333333333`, -8.1}, {115.71666666666667`, -8.4}, {
       114.48333333333333`, -8.083333333333334}}, {{
       116.33333333333333`, -8.216666666666667}, {
       116.01666666666667`, -8.916666666666666}, {
       116.35, -8.216666666666667}}, {{
       117.21666666666667`, -8.383333333333333}, {119., -8.383333333333333}, {
       117.05, -9.116666666666667}, {
       117.21666666666667`, -8.383333333333333}}, {{
       119.03333333333333`, -9.433333333333334}, {
       120.81666666666666`, -9.983333333333333}, {
       119.03333333333333`, -9.433333333333334}}, {{
       120.26666666666667`, -8.266666666666666}, {123., -8.25}, {
       121.01666666666667`, -8.95}, {
       119.89999999999999`, -8.866666666666667}, {
       120.28333333333333`, -8.266666666666666}}, {{
       124.46666666666667`, -8.133333333333333}, {
       125.13333333333333`, -8.333333333333334}, {
       124.46666666666667`, -8.133333333333333}}, {{
       125.1, -9.466666666666667}, {127.3, -8.4}, {
       125.14999999999999`, -8.633333333333333}, {
       123.46666666666667`, -10.366666666666667`}, {
       125.1, -9.466666666666667}}, {{131.65, -7.116666666666666}, {
       131.13333333333333`, -8.016666666666666}, {
       131.65, -7.116666666666666}}, {{
       119.58333333333333`, -5.616666666666666}, {
       118.76666666666667`, -3.1}, {120.03333333333333`, 
       0.7166666666666667}, {125.25, 1.5}, {124.25, 0.36666666666666664`}, {
       120.25, 0.35}, {120.66666666666667`, -1.4}, {
       123.45, -0.7666666666666666}, {121.3, -1.8}, {
       122.89999999999999`, -4.4}, {121.53333333333333`, -4.4}, {
       120.76666666666667`, -2.6166666666666667`}, {
       120.35, -4.383333333333333}, {
       120.06666666666666`, -5.583333333333333}}, {{123.55, -1.3}, {
       122.8, -1.45}, {123.55, -1.3166666666666667`}}, {{
       124.41666666666667`, -1.65}, {
       125.31666666666666`, -1.8833333333333333`}, {
       124.41666666666667`, -1.65}}, {{
       125.41666666666667`, -1.7833333333333332`}, {
       126.35, -1.8166666666666667`}, {
       125.41666666666667`, -1.7833333333333332`}}, {{
       122.71666666666667`, -4.616666666666666}, {
       122.28333333333333`, -5.383333333333333}, {
       122.71666666666667`, -4.616666666666666}}, {{
       123.08333333333333`, -4.4}, {
       122.81666666666666`, -5.683333333333334}, {
       123.06666666666666`, -4.4}}, {{
       126.13333333333333`, -3.1166666666666667`}, {
       127.25, -3.3666666666666667`}, {
       126.13333333333333`, -3.1166666666666667`}}, {{
       128.18333333333334`, -2.8666666666666667`}, {
       130.58333333333334`, -3.1333333333333333`}, {
       130.83333333333334`, -3.8666666666666667`}, {
       127.91666666666667`, -3.5666666666666664`}, {
       128.18333333333334`, -2.8666666666666667`}}, {{
       134.51666666666665`, -5.433333333333334}, {
       134.33333333333334`, -6.233333333333333}, {
       134.51666666666665`, -5.433333333333334}}, {{128.9, 0.2}, {
       127.91666666666667`, 0.2}, {
       128.43333333333334`, -0.9166666666666666}, {127.56666666666666`, 
       0.4166666666666667}, {128.05, 2.2}, {127.63333333333333`, 
       0.9166666666666666}, {128.9, 0.2}}, {{138.55, -7.383333333333333}, {
       138.9, -8.083333333333334}, {137.65, -8.433333333333334}, {
       138.56666666666666`, -7.383333333333333}}, {{
       141., -9.133333333333333}, {140.15, -7.883333333333333}, {
       138.91666666666666`, -8.3}, {138.06666666666666`, -5.4}, {
       133.96666666666667`, -3.85}, {
       133.86666666666667`, -2.933333333333333}, {
       132.9, -4.083333333333333}, {131.95, -2.783333333333333}, {
       133.93333333333334`, -2.1}, {130.95, -1.4333333333333333`}, {
       132.43333333333334`, -0.35}, {
       134.23333333333332`, -1.4333333333333333`}, {
       135.11666666666667`, -3.3666666666666667`}, {
       137.85, -1.4666666666666666`}, {141., -2.6}, {141., -2.6}, {
       141., -9.133333333333333}}}],
     "\"Indonesia\""],
    Annotation[#, "Indonesia", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{61.61666666666667, 25.2}, {57.78333333333333, 
      25.633333333333333`}, {53.71666666666667, 26.7}, {50.13333333333333, 
      29.95}, {48.53333333333333, 29.966666666666665`}, {45.4, 
      33.96666666666667}, {46.35, 35.8}, {44.8, 37.166666666666664`}, {44.8, 
      39.65}, {46.166666666666664`, 38.833333333333336`}, {48.13333333333333, 
      39.6}, {48.88333333333333, 38.45}, {51.1, 36.733333333333334`}, {53.9, 
      37.35}, {57.199999999999996`, 38.28333333333333}, {59.56666666666666, 
      37.21666666666667}, {61.28333333333333, 35.6}, {60.583333333333336`, 
      33.06666666666666}, {61.85, 31.016666666666666`}, {60.86666666666667, 
      29.866666666666667`}, {63.333333333333336`, 27.133333333333333`}, {
      61.61666666666667, 25.2}}}],
     "\"Iran\""],
    Annotation[#, "Iran", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{47.95, 30.016666666666666`}, {48.53333333333333, 
      29.966666666666665`}, {45.4, 33.96666666666667}, {46.35, 35.8}, {44.8, 
      37.166666666666664`}, {42.35, 37.1}, {41., 34.416666666666664`}, {38.8, 
      33.36666666666667}, {39.3, 32.233333333333334`}, {44.71666666666667, 
      29.2}, {46.55, 29.099999999999998`}, {47.95, 30.016666666666666`}}}],
     "\"Iraq\""],
    Annotation[#, "Iraq", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-6.266666666666667, 
      54.083333333333336`}, {-6.366666666666666, 
      52.18333333333333}, {-9.766666666666666, 
      51.449999999999996`}, {-10.466666666666667`, 
      52.18333333333333}, {-8.733333333333333, 
      52.666666666666664`}, {-10.116666666666667`, 54.1}, {-7.25, 
      55.05}, {-8.15, 54.43333333333333}, {-6.266666666666667, 
      54.083333333333336`}}}],
     "\"Ireland\""],
    Annotation[#, "Ireland", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-4.52805, 54.4171}, {-4.49465, 54.4241}, {-4.4578, 
      54.4217}, {-4.44025, 54.403}, {-4.442, 54.3679}, {-4.4543, 
      54.3527}, {-4.4543, 54.3374}, {-4.44025, 54.3257}, {-4.39635, 
      54.3117}, {-4.38405, 54.3012}, {-4.38755, 54.259}, {-4.40685, 
      54.2438}, {-4.4525, 54.1958}, {-4.4701, 54.1642}, {-4.5105, 
      54.1337}, {-4.5526, 54.1232}, {-4.6053, 54.1185}, {-4.63515, 
      54.1033}, {-4.6738, 54.0717}, {-4.70715, 54.0518}, {-4.7212, 
      54.0471}, {-4.75105, 54.0518}, {-4.7809, 54.0588}, {-4.802, 
      54.0576}, {-4.8248, 54.0506}, {-4.85115, 54.0506}, {-4.8652, 
      54.0576}, {-4.874, 54.074}, {-4.8687, 54.0928}, {-4.82655, 
      54.1185}, {-4.7809, 54.1443}, {-4.7581, 54.1724}, {-4.7493, 
      54.2496}, {-4.737, 54.2684}, {-4.7019, 54.2953}, {-4.68255, 
      54.3035}, {-4.64045, 54.3093}, {-4.6176, 54.3211}, {-4.5895, 
      54.3597}, {-4.5526, 54.4042}, {-4.52805, 54.4171}}}],
     "\"IsleOfMan\""],
    Annotation[#, "IsleOfMan", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{34.21666666666667, 31.333333333333332`}, {35.1, 33.1}, {
      35.53333333333333, 33.233333333333334`}, {35.61666666666667, 33.25}, {
      35.666666666666664`, 33.25}, {35.65, 32.68333333333333}, {
      35.483333333333334`, 31.5}, {34.96666666666667, 29.55}, {34.9, 
      29.483333333333334`}, {34.266666666666666`, 31.216666666666665`}, {
      34.21666666666667, 31.333333333333332`}}}],
     "\"Israel\""],
    Annotation[#, "Israel", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{13.716666666666667`, 45.6}, {12.266666666666666`, 45.45}, {
       12.383333333333333`, 44.21666666666667}, {18.516666666666666`, 
       40.13333333333333}, {16.616666666666667`, 40.1}, {16.066666666666666`, 
       37.916666666666664`}, {15.666666666666666`, 40.03333333333333}, {11.1, 
       42.4}, {10.1, 44.016666666666666`}, {7.533333333333333, 
       43.78333333333333}, {7.033333333333333, 45.93333333333333}, {
       10.466666666666667`, 46.88333333333333}, {13.716666666666667`, 
       46.53333333333333}, {13.716666666666667`, 45.6}}, {{
       15.616666666666667`, 38.25}, {15.083333333333334`, 36.65}, {
       12.416666666666666`, 37.8}, {15.616666666666667`, 38.25}}, {{9.25, 
       41.25}, {8.85, 38.88333333333333}, {8.133333333333333, 
       40.733333333333334`}, {9.25, 41.25}}}],
     "\"Italy\""],
    Annotation[#, "Italy", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-7.533333333333333, 4.35}, {-3.1, 
      5.083333333333333}, {-3.1, 5.083333333333333}, {-2.683333333333333, 
      9.483333333333333}, {-2.683333333333333, 
      9.483333333333333}, {-5.516666666666667, 10.45}, {-5.516666666666667, 
      10.433333333333334`}, {-7.966666666666667, 
      10.166666666666666`}, {-7.966666666666667, 
      10.166666666666666`}, {-8.466666666666667, 
      7.566666666666666}, {-8.466666666666667, 
      7.566666666666666}, {-7.516666666666667, 4.35}}}],
     "\"IvoryCoast\""],
    Annotation[#, "IvoryCoast", "Tooltip"]& ], 
   TagBox[
    TooltipBox[PolygonBox[CompressedData["
1:eJxdVGtQVlUUBXkUKT4BNYeXGRgEeM4ooVJsRO3jEyTdhICFIqIIFKG8kQx5
KWhIDEJICKOFj1SUSGMItyiQbwxREENEDCwfaBg6k9q+n98MM96Z82Pdc+6+
e6291rFeEbU4VE9HR0eX12Jew3jVZ1YsOTMSqSFXxDvcFLC0pfaWiSmSlfvD
kHN/CPhKdTzF3Arp8PG7pa7XBey/2Op39y2k2Td8thZ2Cmh4fiT50VQk/d4t
U+/dE7BLt9Zg7HSkPTPOz174UMBjdUCmizPSGXnqsON9AUZPy1ZXMX7twsRF
1/4WsCiiOL6E8em4up1v3hAwr61/QD0TqfRBReOCqwJ0O4cZZbsh+S62Ldvc
LGDHn+YVfYAUlarfkHtJwER9v5EOc5A6sp+FDl4W8Mj94qpWD6Quh21lT5iP
W+P16vS5SNPs9o5r7tGenz+EN2UEttR++Mp51VC94JMt9qGeSLebJ3c8vSBg
tq53uvECpKWKIOcE5I1Kct6vRhrpcOS7B00CqkZE/5jD9aaPcXb9tV7AiT27
FwJjRR7jOgHmp2+77Wa8/lHlRxE1AvrC7f8t5PrG/FnHMQGTjLkTLyTDsSZu
jbUCXJ7Ur9zni+T0OSvbKiCoxnPEsCVIGp6sj++t73ec8kfa0P5+on+bgJk/
/RZXt2yo/5XKoCKQqn9IbHrnGvORH0+zi0bat5wV7RKQ6M+TWoeUsb65KuC2
gMHYrpIxsUjuG7ubing+Z8vn/fwP4/y9Gxd5PmN+ydx4vFYvXQnbPXIie5OR
Bp5dTrhjKGG5IlQK0tw1Uf0ZRtr9DUiavkZJCKv6a111KpJ5IHdmKUHjgzQk
hZa9rYSr0x+4zMtFak24YyOmSii/wi/ykGx60krP20mY8st/WQP5SGGTIxOS
ZkioOzHeBguQRvvzH5wlGKYWeOQUIdlnmbVfeE/CxG7/8Ue/1fKfJSG99Py+
i4wPti2L8/lA+z1jxV6V7hIsKvpUjoVI7bxtMV/CKuXZjlTkZbpFrZagTk5z
8mJc/Pqk0qAACR4H1nRGf4O0pSNMJypYwjjFMFuRsi1D7geulTDBBg12ZSNl
ulxp+CxGgq0SuEwkZQx710kwUIKXqtU7QoJii+INWj+tltDLdld9iaS6mWRy
kLGeEVdOQvrasN9M9YWEHB5zD89HzfJlxUlQZN4ZjqTRLVaCj4VZuHfI0HkH
a8uByEBtPqPlSz/7IOkoD+9fyvvkuQf7ueSUVeXaMAlnTs45sIbzpdjxeqh8
mXdXJI2vQyTwlE/7cl5jphS+2BYk4ezopppjAumOyvGFtbeEeI61kwOSj6KM
h4SWzq7h+W+z/x7+7r0CJKSw7R5bs3/Da2PyXSSsUBqfgFQQuink03cl5M/i
Bvk+8lMEsdT6YxySZq7sP1MlUKORFBaHBsRLPIL/f/SQXu9dAczWL+UNpBAl
IH1DeLAnuPwK519Tb7g2r90CXr0P/wd7S15p
      "]],
     "\"Jamaica\""],
    Annotation[#, "Jamaica", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{131.65, 32.45}, {131.01666666666665`, 33.95}, {
       129.58333333333334`, 33.35}, {130.66666666666666`, 31.}, {131.65, 
       32.45}}, {{134.6, 34.083333333333336`}, {133.01666666666665`, 32.7}, {
       132.01666666666665`, 33.333333333333336`}, {134.6, 
       34.06666666666666}}, {{141.13333333333333`, 41.43333333333333}, {
       142.06666666666666`, 39.55}, {140.33333333333334`, 
       35.13333333333333}, {138.85, 34.6}, {136.85, 35.083333333333336`}, {
       135.76666666666665`, 33.43333333333333}, {135.33333333333334`, 
       34.71666666666667}, {130.88333333333333`, 33.93333333333333}, {
       133.08333333333334`, 35.583333333333336`}, {136.76666666666665`, 
       37.35}, {138.55, 37.36666666666667}, {141.13333333333333`, 
       41.43333333333333}}, {{141.95, 45.516666666666666`}, {
       143.76666666666665`, 44.1}, {145.81666666666666`, 43.36666666666667}, {
       143.23333333333332`, 41.916666666666664`}, {140.46666666666667`, 
       42.56666666666666}, {141.2, 41.8}, {140.03333333333333`, 41.45}, {
       141.4, 43.28333333333333}, {141.96666666666667`, 45.5}}, {{
       128.28333333333333`, 26.866666666666667`}, {127.64999999999999`, 
       26.083333333333332`}, {128.28333333333333`, 26.849999999999998`}}}],
     "\"Japan\""],
    Annotation[#, "Japan", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-2.3543, 49.2833}, {-2.3021, 49.2844}, {-2.25685, 
      49.2682}, {-2.2168, 49.2566}, {-2.1646, 49.2287}, {-2.15155, 
      49.2131}, {-2.16375, 49.1934}, {-2.1794, 49.1818}, {-2.202, 
      49.1829}, {-2.2455, 49.191}, {-2.2751, 49.1922}, {-2.3517, 
      49.1899}, {-2.3743, 49.1922}, {-2.40215, 49.2003}, {-2.40735, 
      49.2131}, {-2.40215, 49.2398}, {-2.38825, 49.2676}, {-2.3543, 
      49.2833}}}],
     "\"Jersey\""],
    Annotation[#, "Jersey", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{34.96666666666667, 29.366666666666667`}, {
      34.983333333333334`, 29.55}, {35.483333333333334`, 31.5}, {35.65, 
      32.68333333333333}, {38.8, 33.38333333333333}, {39.3, 
      32.233333333333334`}, {37., 31.5}, {37.5, 30.}, {34.96666666666667, 
      29.366666666666667`}}}],
     "\"Jordan\""],
    Annotation[#, "Jordan", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{49.21666666666667, 46.36666666666667}, {51.2, 
      47.11666666666667}, {53.166666666666664`, 46.28333333333333}, {53.25, 
      45.333333333333336`}, {51.56666666666666, 44.516666666666666`}, {
      50.21666666666667, 44.56666666666666}, {52.833333333333336`, 41.7}, {
      56., 41.5}, {56., 45.}, {58.666666666666664`, 45.5}, {
      62.166666666666664`, 43.5}, {67.91666666666667, 41.28333333333333}, {
      69.5, 41.333333333333336`}, {71.01666666666667, 42.3}, {74.35, 43.2}, {
      78.25, 42.8}, {80.26666666666667, 42.05}, {79.86666666666666, 44.9}, {
      82.56666666666666, 45.13333333333333}, {83.03333333333333, 
      47.21666666666667}, {85.68333333333334, 47.2}, {87.33333333333333, 
      49.1}, {87.81666666666666, 49.13333333333333}, {83.53333333333333, 
      50.45}, {79.46666666666667, 51.43333333333333}, {77.3, 
      54.36666666666667}, {74.51666666666667, 53.78333333333333}, {
      70.63333333333333, 55.13333333333333}, {61.583333333333336`, 54.1}, {
      60.88333333333333, 50.78333333333333}, {54.11666666666667, 
      51.11666666666667}, {51.06666666666666, 51.61666666666667}, {46.85, 
      49.416666666666664`}, {49.21666666666667, 46.36666666666667}}}],
     "\"Kazakhstan\""],
    Annotation[#, "Kazakhstan", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{41.56666666666666, -1.6666666666666667`}, {
      39.2, -4.666666666666667}, {33.916666666666664`, -1.}, {
      35.03333333333333, 1.9166666666666667`}, {34., 4.216666666666667}, {
      35.93333333333333, 4.616666666666666}, {39.516666666666666`, 
      3.433333333333333}, {41.916666666666664`, 3.9833333333333334`}, {
      40.983333333333334`, 2.8333333333333335`}, {
      41.56666666666666, -1.6666666666666667`}}}],
     "\"Kenya\""],
    Annotation[#, "Kenya", "Tooltip"]& ], 
   TagBox[
    TooltipBox[PolygonBox[CompressedData["
1:eJxdk3tMjWEcx08dlKI1XSRqJJRGq5BY+zmWdZeuqObS0+UUKdYxooQdasKS
1kVbJZXuF5WWs+PVYi2EFFqitFics5lcqvc97+v3duyczbs9f3ye531+l+/v
+6yKSgqKEQoEAh1cO3Dp4pJ+C+ywriZUXa/c4cI5BkZsF5zPqyKUMM0m4MZG
BpbNCzPaUEkoj0uhspwZGq53/bKLLMdzRXnwXjkNrlmiQxOlhDIZjBBGVNDg
1tpzUl5CKEFOOr0tmYbZ9ARZCnJHo/BLth0NHdaYEf83nryPO7NgFR69/SPG
S+7L7P8wOgux/If5tsZ5xCd9n4VcCywA63Mx949bJ6SBHTg1ubZeGy+SL6iJ
UP7OJ8x/b6Jh4qXN8EwLob6be+1hLGj40e8fZdxKqAyvh2lWW2mQl1g6jiDn
ZhdL3RNpGEs1bfBsI9Smh0XCeVMM2PMB8fxMqZlFyzYVOOnXrQhHnqsrVgV3
kt0N3t4jVP/4ny2q/SpQoHxSZFPl+juMrUqTP6L9zdKFShokfAPIBceWXKR6
acDb5cnNWj49udZJH+sPSVp8NG+UhiBeIOwPNh/o9F7EQPuUauBUvXYed5/4
umYhBzTejMkkDAz1/QkeR7Ysl4RsfsRAgyffEaEujjQlBn5WwdOyXe1TeD5c
Ne4kNGM18eZ0dGLhOF9QHaFqFQ9spg+ysHp4Jj0BucznubVYquW+mheDYQoW
ljuiQ/D+jwNtzmNLOUjjC+Xzj4gUfqs48OLTNxJqjUS3SH85B3P+wn6JocjI
x4JT50fmZXA34OC3HQqOzNDZhnpdrLpt1EsUgztXWLX/kN3yP9W0JLEaPV8n
eL0n8Sy8QrnTkTNiKrztxSzoOlw2H0I+LbmmM3SE1cyHb0OWwsLVfBQe5+nh
l2WbWsjCIv4Czr+Jt5OShccrm06Iked8YsuBOEd5FpB9e/Tcb4Vy6v6RxzPb
pk0zODiHUXMx3qjcqNjlNqf2I3L29O5nqc0c8PaJxvw/j4alNbRzmnn3W3X3
mXZyEGW8z60V9bU7XKk8OMTBzkPooFpCfW0peHf2Pafuv4ZQmLyktv6ffvge
ouQyAS3m1P5Fjk/Ra3aZz0FRIX7IzuGeoSbdKnU/1Vp////e/wKwaxe4
      "]],
     "\"Kiribati\""],
    Annotation[#, "Kiribati", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{48.416666666666664`, 28.55}, {47.95, 
      30.016666666666666`}, {46.55, 29.099999999999998`}, {
      48.416666666666664`, 28.55}}}],
     "\"Kuwait\""],
    Annotation[#, "Kuwait", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{74.16666666666667, 39.53333333333333}, {71.51666666666667, 
      39.233333333333334`}, {69.56666666666666, 39.93333333333333}, {73., 
      40.93333333333333}, {71.23333333333333, 41.11666666666667}, {
      71.01666666666667, 42.3}, {74.35, 43.2}, {78.25, 42.8}, {
      80.26666666666667, 42.05}, {74., 40.05}, {74.16666666666667, 
      39.53333333333333}}}],
     "\"Kyrgyzstan\""],
    Annotation[#, "Kyrgyzstan", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{100.08333333333333`, 20.35}, {101.15, 
      21.566666666666666`}, {102.13333333333333`, 22.4}, {103.16666666666667`,
       20.85}, {104.64999999999999`, 20.666666666666668`}, {
      103.88333333333333`, 19.3}, {107.46666666666667`, 
      16.083333333333332`}, {107.55, 14.7}, {105.21666666666667`, 14.35}, {
      104.71666666666667`, 17.5}, {103.39999999999999`, 
      18.433333333333334`}, {100.91666666666667`, 17.566666666666666`}, {
      101.28333333333333`, 19.566666666666666`}, {100.08333333333333`, 
      20.35}}}],
     "\"Laos\""],
    Annotation[#, "Laos", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{24.1, 57.86666666666667}, {27.599999999999998`, 
      57.81666666666666}, {28.099999999999998`, 56.016666666666666`}, {
      26.333333333333332`, 55.53333333333333}, {24.65, 56.38333333333333}, {
      21.333333333333332`, 56.05}, {21.416666666666668`, 
      57.199999999999996`}, {24.4, 57.233333333333334`}, {24.1, 
      57.86666666666667}}}],
     "\"Latvia\""],
    Annotation[#, "Latvia", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{35.96666666666667, 34.65}, {35.1, 33.1}, {
      35.53333333333333, 33.233333333333334`}, {35.61666666666667, 33.25}, {
      35.96666666666667, 34.65}}}],
     "\"Lebanon\""],
    Annotation[#, "Lebanon", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{28.7, -28.616666666666667`}, {
      27.016666666666666`, -29.633333333333333`}, {
      28.099999999999998`, -30.666666666666668`}, {
      29.45, -29.349999999999998`}, {28.7, -28.616666666666667`}}}],
     "\"Lesotho\""],
    Annotation[#, "Lesotho", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-11.5, 6.933333333333334}, {-7.533333333333333, 
      4.35}, {-8.466666666666667, 7.566666666666666}, {-10.266666666666666`, 
      8.483333333333333}, {-11.5, 6.933333333333334}}}],
     "\"Liberia\""],
    Annotation[#, "Liberia", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{11.533333333333333`, 33.166666666666664`}, {
      15.916666666666666`, 31.316666666666666`}, {19.333333333333332`, 
      30.28333333333333}, {21.716666666666665`, 32.95}, {25.15, 31.65}, {25., 
      22.}, {25., 22.}, {25., 20.}, {24., 19.5}, {16., 23.5}, {
      14.966666666666667`, 22.983333333333334`}, {12., 23.516666666666666`}, {
      9.4, 26.15}, {9.533333333333333, 30.233333333333334`}, {
      11.533333333333333`, 33.166666666666664`}}}],
     "\"Libya\""],
    Annotation[#, "Libya", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{9.6, 47.06666666666666}, {9.533333333333333, 
      47.28333333333333}, {9.533333333333333, 47.266666666666666`}, {9.6, 
      47.06666666666666}}}],
     "\"Liechtenstein\""],
    Annotation[#, "Liechtenstein", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{21.333333333333332`, 56.05}, {24.65, 56.38333333333333}, {
      26.333333333333332`, 55.53333333333333}, {25.316666666666666`, 54.15}, {
      23.5, 53.949999999999996`}, {22.816666666666666`, 54.03333333333333}, {
      22.883333333333333`, 54.766666666666666`}, {21.28333333333333, 
      55.333333333333336`}, {21.333333333333332`, 56.05}}}],
     "\"Lithuania\""],
    Annotation[#, "Lithuania", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{6.133333333333333, 50.13333333333333}, {6.366666666666666, 
      49.46666666666667}, {5.816666666666666, 49.55}, {6.133333333333333, 
      50.13333333333333}}}],
     "\"Luxembourg\""],
    Annotation[#, "Luxembourg", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{113.414, 22.2666}, {113.361, 22.3087}, {113.353, 
      22.3379}, {113.357, 22.3731}, {113.381, 22.4151}, {113.429, 22.4473}, {
      113.48, 22.4686}, {113.556, 22.4874}, {113.633, 22.4214}, {113.644, 
      22.3795}, {113.644, 22.3492}, {113.615, 22.326}, {113.563, 22.291}, {
      113.494, 22.2666}, {113.414, 22.2666}}}],
     "\"Macau\""],
    Annotation[#, "Macau", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{20.53333333333333, 41.766666666666666`}, {
      21.233333333333334`, 42.21666666666667}, {22.85, 42.233333333333334`}, {
      22.933333333333334`, 41.333333333333336`}, {20.983333333333334`, 
      40.85}, {20.53333333333333, 41.766666666666666`}}}],
     "\"Macedonia\""],
    Annotation[#, "Macedonia", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{43.31666666666666, -21.866666666666667`}, {
      44.516666666666666`, -19.95}, {
      44.46666666666667, -16.183333333333334`}, {48., -14.766666666666666`}, {
      49.28333333333333, -11.95}, {50.5, -15.316666666666666`}, {
      49.63333333333333, -15.549999999999999`}, {
      47.13333333333333, -24.983333333333334`}, {44.06666666666666, -24.95}, {
      43.31666666666666, -21.866666666666667`}}}],
     "\"Madagascar\""],
    Annotation[#, "Madagascar", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{32.983333333333334`, -9.483333333333333}, {
      34.333333333333336`, -9.733333333333333}, {
      34.95, -11.566666666666666`}, {34.56666666666666, -13.35}, {
      35.916666666666664`, -14.883333333333333`}, {
      35.28333333333333, -17.133333333333333`}, {
      34.53333333333333, -14.583333333333334`}, {
      33.21666666666667, -14.016666666666666`}, {
      32.983333333333334`, -9.483333333333333}}}],
     "\"Malawi\""],
    Annotation[#, "Malawi", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{109.64999999999999`, 2.0666666666666664`}, {
       110.56666666666666`, 0.85}, {114.88333333333333`, 
       2.0666666666666664`}, {115.86666666666666`, 4.366666666666666}, {117.6,
        4.166666666666667}, {119.28333333333333`, 5.35}, {117.46666666666667`,
        5.866666666666666}, {117.14999999999999`, 7.}, {115.14999999999999`, 
       4.9}, {115.03333333333333`, 4.816666666666666}, {115.01666666666667`, 
       4.866666666666666}, {114.08333333333333`, 4.583333333333333}, {111.45, 
       2.683333333333333}, {111.38333333333333`, 1.35}, {109.64999999999999`, 
       2.0666666666666664`}}, {{100.13333333333333`, 6.416666666666667}, {
       101.28333333333333`, 2.8333333333333335`}, {103.51666666666667`, 
       1.2666666666666666`}, {104.3, 1.45}, {103.45, 4.8}, {102.1, 
       6.233333333333333}, {101.15, 5.633333333333333}, {100.13333333333333`, 
       6.416666666666667}}}],
     "\"Malaysia\""],
    Annotation[#, "Malaysia", "Tooltip"]& ], 
   TagBox[
    TooltipBox[PolygonBox[CompressedData["
1:eJxl1nk8lfkeB3CFZIpMt/Erv0xFSqEVheirjSzh2EUIEZMKRZiMNlJpHco6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      "]],
     "\"Maldives\""],
    Annotation[#, "Maldives", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{4.25, 19.15}, {0., 21.833333333333332`}, {-4.8, 
      25.}, {-6.583333333333333, 25.}, {-5.5, 15.5}, {-11.5, 15.65}, {-12.05, 
      14.733333333333333`}, {-12.25, 14.766666666666666`}, {-11.35, 
      12.466666666666667`}, {-11.366666666666667`, 12.4}, {-8.983333333333333,
       12.4}, {-7.966666666666667, 10.166666666666666`}, {-5.516666666666667, 
      10.433333333333334`}, {-3.966666666666667, 13.5}, {0., 15.}, {
      0.23333333333333334`, 15.}, {3.8833333333333333`, 
      15.716666666666667`}, {4.25, 19.15}}}],
     "\"Mali\""],
    Annotation[#, "Mali", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{14.3298, 36.0474}, {14.3495, 36.0606}, {14.3745, 
       36.0536}, {14.4152, 36.0089}, {14.4651, 36.0001}, {14.6438, 35.9064}, {
       14.649, 35.8845}, {14.6254, 35.867}, {14.5886, 35.8661}, {14.5623, 
       35.8819}, {14.5347, 35.8863}, {14.5203, 35.8767}, {14.5137, 35.8443}, {
       14.498, 35.8372}, {14.4743, 35.8469}, {14.3206, 35.98}, {14.3298, 
       36.0474}}, {{14.2261, 36.1245}, {14.2523, 36.1394}, {14.2825, 
       36.1367}, {14.3009, 36.1184}, {14.3009, 36.093}, {14.2747, 36.0798}, {
       14.2523, 36.0807}, {14.2326, 36.0938}, {14.2261, 36.1245}}}],
     "\"Malta\""],
    Annotation[#, "Malta", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{169.716, 5.91057}, {169.729, 5.912}, {169.743, 5.90337}, {
       169.731, 5.81903}, {169.708, 5.7859}, {169.676, 5.75277}, {169.609, 
       5.7117}, {169.576, 5.7052}, {169.57, 5.716}, {169.588, 5.7369}, {
       169.612, 5.765}, {169.638, 5.79093}, {169.677, 5.8414}, {169.677, 
       5.86373}, {169.695, 5.89543}, {169.716, 5.91057}}, {{168.818, 
       4.63913}, {168.844, 4.6333}, {168.844, 4.6216}, {168.805, 4.6041}, {
       168.749, 4.58853}, {168.702, 4.59533}, {168.669, 4.60313}, {168.676, 
       4.61967}, {168.721, 4.61967}, {168.818, 4.63913}}, {{167.468, 
       11.3351}, {167.468, 11.3382}, {167.468, 11.3414}, {167.469, 11.3446}, {
       167.47, 11.3478}, {167.472, 11.3509}, {167.474, 11.3539}, {167.476, 
       11.3568}, {167.478, 11.3595}, {167.481, 11.362}, {167.484, 11.3643}, {
       167.487, 11.3664}, {167.49, 11.3682}, {167.493, 11.3697}, {167.497, 
       11.3709}, {167.5, 11.3718}, {167.504, 11.3724}, {167.507, 11.3726}, {
       167.511, 11.3725}, {167.514, 11.3721}, {167.517, 11.3713}, {167.52, 
       11.3702}, {167.523, 11.3688}, {167.525, 11.3671}, {167.528, 11.3652}, {
       167.53, 11.363}, {167.532, 11.3605}, {167.533, 11.3579}, {167.534, 
       11.3551}, {167.535, 11.3521}, {167.535, 11.349}, {167.535, 11.3459}, {
       167.535, 11.3427}, {167.534, 11.3395}, {167.533, 11.3364}, {167.531, 
       11.3332}, {167.529, 11.3302}, {167.527, 11.3274}, {167.525, 11.3246}, {
       167.522, 11.3221}, {167.519, 11.3198}, {167.516, 11.3177}, {167.513, 
       11.3159}, {167.51, 11.3144}, {167.506, 11.3132}, {167.503, 11.3123}, {
       167.499, 11.3118}, {167.496, 11.3115}, {167.492, 11.3116}, {167.489, 
       11.3121}, {167.486, 11.3128}, {167.483, 11.3139}, {167.48, 11.3153}, {
       167.478, 11.317}, {167.475, 11.3189}, {167.473, 11.3212}, {167.471, 
       11.3236}, {167.47, 11.3262}, {167.469, 11.3291}, {167.468, 11.332}, {
       167.468, 11.3351}}, {{170.09, 12.3846}, {170.094, 12.393}, {170.105, 
       12.3939}, {170.148, 12.3883}, {170.172, 12.3688}, {170.174, 12.3503}, {
       170.153, 12.3428}, {170.123, 12.3493}, {170.101, 12.367}, {170.09, 
       12.3846}}, {{168.966, 7.7431}, {168.964, 7.7459}, {168.963, 7.7488}, {
       168.963, 7.75177}, {168.963, 7.75477}, {168.963, 7.7578}, {168.963, 
       7.76077}, {168.964, 7.7637}, {168.965, 7.76653}, {168.966, 7.76927}, {
       168.968, 7.77183}, {168.97, 7.7742}, {168.972, 7.77637}, {168.974, 
       7.77833}, {168.977, 7.78}, {168.98, 7.78143}, {168.983, 7.78257}, {
       168.986, 7.7834}, {168.989, 7.78393}, {168.992, 7.78417}, {168.996, 
       7.78407}, {168.999, 7.78367}, {169.002, 7.78293}, {169.005, 7.7819}, {
       169.008, 7.7806}, {169.011, 7.779}, {169.014, 7.77717}, {169.016, 
       7.77507}, {169.018, 7.77277}, {169.02, 7.77027}, {169.022, 7.76763}, {
       169.023, 7.76483}, {169.024, 7.76193}, {169.024, 7.75897}, {169.025, 
       7.75597}, {169.025, 7.75293}, {169.024, 7.74997}, {169.024, 7.74703}, {
       169.023, 7.7442}, {169.021, 7.74147}, {169.02, 7.7389}, {169.018, 
       7.73653}, {169.015, 7.73437}, {169.013, 7.7324}, {169.01, 7.73073}, {
       169.007, 7.7293}, {169.004, 7.72817}, {169.001, 7.72733}, {168.998, 
       7.7268}, {168.995, 7.72657}, {168.992, 7.72667}, {168.988, 7.72707}, {
       168.985, 7.7278}, {168.982, 7.72883}, {168.979, 7.73013}, {168.976, 
       7.73173}, {168.974, 7.73357}, {168.971, 7.73567}, {168.969, 7.73797}, {
       168.967, 7.74047}, {168.966, 7.7431}}, {{168.277, 5.6745}, {168.277, 
       5.6782}, {168.278, 5.68197}, {168.278, 5.68583}, {168.279, 5.68967}, {
       168.28, 5.6935}, {168.282, 5.69727}, {168.283, 5.7009}, {168.285, 
       5.7044}, {168.287, 5.7077}, {168.289, 5.7108}, {168.291, 5.71363}, {
       168.293, 5.71617}, {168.296, 5.71837}, {168.298, 5.72027}, {168.301, 
       5.72177}, {168.303, 5.7229}, {168.306, 5.72363}, {168.308, 5.724}, {
       168.311, 5.72393}, {168.313, 5.72347}, {168.315, 5.7226}, {168.317, 
       5.72137}, {168.319, 5.71973}, {168.321, 5.71777}, {168.322, 5.71547}, {
       168.323, 5.71283}, {168.324, 5.70993}, {168.325, 5.70677}, {168.326, 
       5.7034}, {168.326, 5.69987}, {168.326, 5.69617}, {168.325, 5.6924}, {
       168.325, 5.68853}, {168.324, 5.6847}, {168.323, 5.68087}, {168.322, 
       5.6771}, {168.32, 5.67347}, {168.318, 5.66997}, {168.316, 5.66667}, {
       168.314, 5.66357}, {168.312, 5.66073}, {168.31, 5.6582}, {168.307, 
       5.656}, {168.305, 5.6541}, {168.302, 5.6526}, {168.3, 5.65147}, {
       168.297, 5.65073}, {168.295, 5.65037}, {168.292, 5.65043}, {168.29, 
       5.6509}, {168.288, 5.65177}, {168.286, 5.653}, {168.284, 5.65463}, {
       168.282, 5.6566}, {168.281, 5.6589}, {168.28, 5.66153}, {168.279, 
       5.66443}, {168.278, 5.6676}, {168.278, 5.67097}, {168.277, 5.6745}}, {{
       170.181, 8.94083}, {170.179, 8.94293}, {170.177, 8.9452}, {170.176, 
       8.94757}, {170.175, 8.95}, {170.174, 8.9525}, {170.174, 8.955}, {
       170.174, 8.95753}, {170.175, 8.96003}, {170.176, 8.96247}, {170.177, 
       8.96483}, {170.178, 8.96707}, {170.18, 8.9692}, {170.182, 8.97117}, {
       170.185, 8.97293}, {170.188, 8.97453}, {170.191, 8.9759}, {170.194, 
       8.97703}, {170.197, 8.97793}, {170.201, 8.9786}, {170.204, 8.979}, {
       170.208, 8.97913}, {170.212, 8.979}, {170.215, 8.9786}, {170.219, 
       8.97793}, {170.222, 8.97703}, {170.225, 8.9759}, {170.228, 8.9745}, {
       170.231, 8.97293}, {170.234, 8.97113}, {170.236, 8.96917}, {170.238, 
       8.96707}, {170.24, 8.9648}, {170.241, 8.96243}, {170.242, 8.96}, {
       170.243, 8.9575}, {170.243, 8.955}, {170.243, 8.95247}, {170.243, 
       8.94997}, {170.242, 8.94753}, {170.241, 8.94517}, {170.239, 8.94293}, {
       170.237, 8.9408}, {170.235, 8.93883}, {170.232, 8.93707}, {170.23, 
       8.93547}, {170.227, 8.9341}, {170.223, 8.93297}, {170.22, 8.93207}, {
       170.217, 8.9314}, {170.213, 8.931}, {170.209, 8.93087}, {170.206, 
       8.931}, {170.202, 8.9314}, {170.199, 8.93207}, {170.195, 8.93297}, {
       170.192, 8.9341}, {170.189, 8.9355}, {170.186, 8.93707}, {170.183, 
       8.93887}, {170.181, 8.94083}}, {{168.565, 7.36423}, {168.564, 
       7.36837}, {168.562, 7.37267}, {168.56, 7.3771}, {168.559, 7.3816}, {
       168.557, 7.38613}, {168.556, 7.39063}, {168.555, 7.39507}, {168.555, 
       7.39937}, {168.555, 7.4035}, {168.554, 7.40743}, {168.555, 7.41113}, {
       168.555, 7.4145}, {168.556, 7.41753}, {168.556, 7.42023}, {168.558, 
       7.4225}, {168.559, 7.42437}, {168.56, 7.42577}, {168.562, 7.42673}, {
       168.564, 7.42723}, {168.566, 7.42727}, {168.568, 7.4268}, {168.57, 
       7.42587}, {168.572, 7.4245}, {168.575, 7.42267}, {168.577, 7.42043}, {
       168.579, 7.4178}, {168.582, 7.41477}, {168.584, 7.41143}, {168.586, 
       7.40777}, {168.588, 7.40387}, {168.59, 7.39973}, {168.592, 7.39543}, {
       168.594, 7.391}, {168.595, 7.3865}, {168.596, 7.38197}, {168.597, 
       7.37747}, {168.598, 7.37303}, {168.599, 7.36873}, {168.599, 7.3646}, {
       168.599, 7.36067}, {168.599, 7.35697}, {168.599, 7.3536}, {168.598, 
       7.35057}, {168.597, 7.34787}, {168.596, 7.3456}, {168.595, 7.34373}, {
       168.593, 7.34233}, {168.592, 7.34137}, {168.59, 7.34087}, {168.588, 
       7.34083}, {168.586, 7.3413}, {168.584, 7.34223}, {168.581, 7.3436}, {
       168.579, 7.34543}, {168.577, 7.34767}, {168.574, 7.3503}, {168.572, 
       7.35333}, {168.57, 7.35667}, {168.568, 7.36033}, {168.565, 
       7.36423}}, {{170.073, 8.94427}, {170.073, 8.9469}, {170.073, 
       8.94957}, {170.073, 8.95223}, {170.074, 8.9549}, {170.075, 8.9575}, {
       170.076, 8.96003}, {170.078, 8.96247}, {170.08, 8.96473}, {170.082, 
       8.96687}, {170.085, 8.96883}, {170.087, 8.97057}, {170.09, 8.9721}, {
       170.093, 8.97337}, {170.096, 8.9744}, {170.1, 8.97517}, {170.103, 
       8.97567}, {170.106, 8.97587}, {170.109, 8.9758}, {170.113, 8.97547}, {
       170.116, 8.97483}, {170.119, 8.97397}, {170.122, 8.9728}, {170.124, 
       8.9714}, {170.127, 8.9698}, {170.129, 8.96793}, {170.131, 8.9659}, {
       170.132, 8.9637}, {170.134, 8.96133}, {170.135, 8.95887}, {170.135, 
       8.9563}, {170.135, 8.95367}, {170.135, 8.951}, {170.135, 8.94833}, {
       170.134, 8.94567}, {170.133, 8.94307}, {170.132, 8.94053}, {170.13, 
       8.9381}, {170.128, 8.93583}, {170.126, 8.9337}, {170.123, 8.93173}, {
       170.121, 8.93}, {170.118, 8.92847}, {170.115, 8.9272}, {170.112, 
       8.92617}, {170.108, 8.9254}, {170.105, 8.9249}, {170.102, 8.9247}, {
       170.099, 8.92477}, {170.095, 8.9251}, {170.092, 8.92573}, {170.089, 
       8.9266}, {170.086, 8.92777}, {170.084, 8.92917}, {170.081, 8.93077}, {
       170.079, 8.93263}, {170.077, 8.93467}, {170.076, 8.93687}, {170.074, 
       8.9392}, {170.074, 8.9417}, {170.073, 8.94427}}, {{169.871, 9.46653}, {
       169.869, 9.4677}, {169.868, 9.46913}, {169.867, 9.4708}, {169.867, 
       9.47273}, {169.866, 9.4749}, {169.867, 9.47723}, {169.868, 9.47977}, {
       169.869, 9.4824}, {169.87, 9.48517}, {169.872, 9.48803}, {169.874, 
       9.49093}, {169.877, 9.49387}, {169.88, 9.49677}, {169.883, 9.49963}, {
       169.886, 9.50243}, {169.89, 9.5051}, {169.893, 9.50767}, {169.897, 
       9.51003}, {169.901, 9.51223}, {169.905, 9.5142}, {169.909, 9.51597}, {
       169.912, 9.51747}, {169.916, 9.51867}, {169.92, 9.5196}, {169.923, 
       9.52023}, {169.926, 9.5206}, {169.929, 9.52063}, {169.932, 9.52033}, {
       169.934, 9.51977}, {169.936, 9.5189}, {169.938, 9.51773}, {169.939, 
       9.5163}, {169.94, 9.51463}, {169.94, 9.5127}, {169.941, 9.51053}, {
       169.94, 9.5082}, {169.939, 9.50567}, {169.938, 9.50303}, {169.937, 
       9.50027}, {169.935, 9.4974}, {169.933, 9.4945}, {169.93, 9.49157}, {
       169.927, 9.48867}, {169.924, 9.4858}, {169.921, 9.483}, {169.917, 
       9.48033}, {169.914, 9.47777}, {169.91, 9.4754}, {169.906, 9.4732}, {
       169.902, 9.47123}, {169.898, 9.46947}, {169.895, 9.46797}, {169.891, 
       9.46677}, {169.887, 9.46583}, {169.884, 9.4652}, {169.881, 9.46483}, {
       169.878, 9.4648}, {169.875, 9.4651}, {169.873, 9.46567}, {169.871, 
       9.46653}}, {{170.048, 12.2862}, {170.062, 12.301}, {170.09, 12.302}, {
       170.108, 12.2908}, {170.112, 12.2704}, {170.096, 12.2555}, {170.069, 
       12.2546}, {170.051, 12.2648}, {170.048, 12.2862}}, {{165.54, 
       11.6585}, {165.536, 11.6601}, {165.533, 11.662}, {165.53, 11.664}, {
       165.528, 11.6661}, {165.525, 11.6684}, {165.523, 11.6708}, {165.521, 
       11.6732}, {165.52, 11.6757}, {165.519, 11.6783}, {165.518, 11.6808}, {
       165.517, 11.6833}, {165.517, 11.6857}, {165.517, 11.688}, {165.518, 
       11.6902}, {165.519, 11.6923}, {165.52, 11.6942}, {165.522, 11.696}, {
       165.524, 11.6975}, {165.526, 11.6988}, {165.528, 11.6999}, {165.531, 
       11.7007}, {165.534, 11.7013}, {165.537, 11.7016}, {165.54, 11.7017}, {
       165.544, 11.7015}, {165.547, 11.701}, {165.551, 11.7003}, {165.554, 
       11.6993}, {165.557, 11.6981}, {165.561, 11.6967}, {165.564, 11.6951}, {
       165.567, 11.6932}, {165.57, 11.6912}, {165.573, 11.6891}, {165.575, 
       11.6868}, {165.577, 11.6844}, {165.579, 11.682}, {165.581, 11.6795}, {
       165.582, 11.6769}, {165.583, 11.6744}, {165.583, 11.6719}, {165.583, 
       11.6695}, {165.583, 11.6672}, {165.582, 11.665}, {165.582, 11.6629}, {
       165.58, 11.661}, {165.579, 11.6592}, {165.577, 11.6577}, {165.575, 
       11.6564}, {165.572, 11.6553}, {165.569, 11.6545}, {165.566, 11.6539}, {
       165.563, 11.6536}, {165.56, 11.6535}, {165.557, 11.6537}, {165.553, 
       11.6542}, {165.55, 11.6549}, {165.546, 11.6559}, {165.543, 11.6571}, {
       165.54, 11.6585}}, {{169.99, 9.4561}, {169.987, 9.45727}, {169.984, 
       9.45863}, {169.981, 9.4602}, {169.978, 9.46197}, {169.975, 9.46383}, {
       169.973, 9.46587}, {169.971, 9.46803}, {169.969, 9.47023}, {169.968, 
       9.47253}, {169.966, 9.47487}, {169.966, 9.4772}, {169.965, 9.47953}, {
       169.965, 9.48183}, {169.966, 9.48407}, {169.967, 9.48623}, {169.968, 
       9.48823}, {169.969, 9.49013}, {169.971, 9.4919}, {169.973, 9.49347}, {
       169.975, 9.49483}, {169.978, 9.49603}, {169.981, 9.49697}, {169.984, 
       9.4977}, {169.987, 9.4982}, {169.99, 9.49847}, {169.994, 9.49847}, {
       169.997, 9.4982}, {170.001, 9.49773}, {170.004, 9.497}, {170.008, 
       9.49607}, {170.011, 9.4949}, {170.014, 9.49353}, {170.017, 9.49197}, {
       170.02, 9.4902}, {170.023, 9.48833}, {170.025, 9.4863}, {170.027, 
       9.48413}, {170.029, 9.48193}, {170.03, 9.47963}, {170.031, 9.4773}, {
       170.032, 9.47497}, {170.033, 9.47263}, {170.033, 9.47033}, {170.032, 
       9.4681}, {170.031, 9.46593}, {170.03, 9.46393}, {170.029, 9.46203}, {
       170.027, 9.46027}, {170.025, 9.4587}, {170.023, 9.45733}, {170.02, 
       9.45613}, {170.017, 9.4552}, {170.014, 9.45447}, {170.011, 9.45397}, {
       170.008, 9.4537}, {170.004, 9.4537}, {170.001, 9.45397}, {169.997, 
       9.45443}, {169.994, 9.45517}, {169.99, 9.4561}}, {{166.791, 9.25793}, {
       166.787, 9.25887}, {166.783, 9.26}, {166.779, 9.26133}, {166.776, 
       9.2628}, {166.772, 9.26447}, {166.768, 9.26627}, {166.765, 9.26817}, {
       166.762, 9.27017}, {166.759, 9.27223}, {166.757, 9.27437}, {166.755, 
       9.27653}, {166.753, 9.27873}, {166.752, 9.28087}, {166.751, 9.283}, {
       166.751, 9.28503}, {166.75, 9.287}, {166.751, 9.28887}, {166.752, 
       9.2906}, {166.753, 9.29217}, {166.754, 9.29357}, {166.756, 9.29483}, {
       166.759, 9.29587}, {166.761, 9.2967}, {166.764, 9.29733}, {166.768, 
       9.29773}, {166.771, 9.2979}, {166.775, 9.29787}, {166.779, 9.29757}, {
       166.783, 9.29707}, {166.787, 9.29637}, {166.791, 9.29543}, {166.795, 
       9.2943}, {166.799, 9.29297}, {166.802, 9.2915}, {166.806, 9.28983}, {
       166.81, 9.28803}, {166.813, 9.28613}, {166.816, 9.28413}, {166.819, 
       9.28207}, {166.821, 9.27993}, {166.823, 9.27777}, {166.825, 9.27557}, {
       166.826, 9.27343}, {166.827, 9.2713}, {166.827, 9.26927}, {166.827, 
       9.2673}, {166.827, 9.26543}, {166.826, 9.2637}, {166.825, 9.26213}, {
       166.823, 9.26073}, {166.821, 9.25947}, {166.819, 9.25843}, {166.816, 
       9.2576}, {166.813, 9.25697}, {166.81, 9.25657}, {166.807, 9.2564}, {
       166.803, 9.25643}, {166.799, 9.25673}, {166.795, 9.25723}, {166.791, 
       9.25793}}, {{166.767, 11.295}, {166.766, 11.298}, {166.766, 11.3011}, {
       166.766, 11.3042}, {166.766, 11.3074}, {166.767, 11.3105}, {166.767, 
       11.3136}, {166.768, 11.3166}, {166.77, 11.3195}, {166.771, 11.3223}, {
       166.773, 11.3249}, {166.775, 11.3272}, {166.777, 11.3294}, {166.779, 
       11.3312}, {166.781, 11.3329}, {166.783, 11.3342}, {166.786, 11.3352}, {
       166.788, 11.3359}, {166.791, 11.3362}, {166.793, 11.3363}, {166.796, 
       11.336}, {166.798, 11.3353}, {166.801, 11.3344}, {166.803, 11.3332}, {
       166.805, 11.3316}, {166.807, 11.3298}, {166.808, 11.3277}, {166.81, 
       11.3254}, {166.811, 11.3228}, {166.812, 11.3201}, {166.813, 11.3173}, {
       166.813, 11.3143}, {166.814, 11.3112}, {166.814, 11.3081}, {166.814, 
       11.3049}, {166.813, 11.3018}, {166.812, 11.2987}, {166.811, 11.2957}, {
       166.81, 11.2928}, {166.809, 11.29}, {166.807, 11.2874}, {166.805, 
       11.2851}, {166.803, 11.2829}, {166.801, 11.2811}, {166.799, 11.2794}, {
       166.796, 11.2781}, {166.794, 11.2771}, {166.791, 11.2764}, {166.789, 
       11.2761}, {166.786, 11.276}, {166.784, 11.2763}, {166.781, 11.277}, {
       166.779, 11.2779}, {166.777, 11.2791}, {166.775, 11.2807}, {166.773, 
       11.2825}, {166.771, 11.2846}, {166.77, 11.2869}, {166.769, 11.2895}, {
       166.768, 11.2922}, {166.767, 11.295}}, {{166.68, 11.2273}, {166.693, 
       11.2263}, {166.69, 11.2033}, {166.646, 11.1756}, {166.618, 11.1766}, {
       166.613, 11.1861}, {166.65, 11.2014}, {166.68, 11.2273}}, {{169.654, 
       9.42957}, {169.651, 9.42973}, {169.647, 9.4301}, {169.643, 9.43067}, {
       169.639, 9.43143}, {169.636, 9.4324}, {169.632, 9.43357}, {169.629, 
       9.43487}, {169.626, 9.43633}, {169.623, 9.43793}, {169.621, 9.43967}, {
       169.618, 9.4415}, {169.617, 9.4434}, {169.615, 9.44537}, {169.614, 
       9.44737}, {169.613, 9.4494}, {169.613, 9.45143}, {169.613, 9.45343}, {
       169.613, 9.45537}, {169.614, 9.45723}, {169.615, 9.459}, {169.617, 
       9.4607}, {169.618, 9.46223}, {169.621, 9.46363}, {169.623, 9.46487}, {
       169.626, 9.4659}, {169.629, 9.4668}, {169.632, 9.46747}, {169.636, 
       9.46793}, {169.639, 9.4682}, {169.643, 9.46827}, {169.647, 9.4681}, {
       169.651, 9.46773}, {169.654, 9.46717}, {169.658, 9.4664}, {169.662, 
       9.46543}, {169.665, 9.46427}, {169.668, 9.46297}, {169.671, 9.4615}, {
       169.674, 9.4599}, {169.677, 9.45817}, {169.679, 9.45633}, {169.681, 
       9.45443}, {169.682, 9.45247}, {169.684, 9.45047}, {169.684, 9.44843}, {
       169.685, 9.4464}, {169.685, 9.4444}, {169.684, 9.44247}, {169.684, 
       9.4406}, {169.682, 9.43883}, {169.681, 9.43713}, {169.679, 9.4356}, {
       169.677, 9.4342}, {169.674, 9.43297}, {169.671, 9.43193}, {169.668, 
       9.43103}, {169.665, 9.43037}, {169.662, 9.4299}, {169.658, 9.42963}, {
       169.654, 9.42957}}, {{169.812, 9.273}, {169.808, 9.27433}, {169.805, 
       9.27583}, {169.803, 9.27753}, {169.8, 9.2794}, {169.798, 9.28137}, {
       169.796, 9.28347}, {169.794, 9.28567}, {169.792, 9.28793}, {169.791, 
       9.2902}, {169.79, 9.29253}, {169.79, 9.29483}, {169.79, 9.2971}, {
       169.79, 9.2993}, {169.79, 9.30143}, {169.791, 9.30343}, {169.792, 
       9.30533}, {169.794, 9.30707}, {169.796, 9.30863}, {169.798, 9.31003}, {
       169.8, 9.31123}, {169.803, 9.3122}, {169.806, 9.31293}, {169.809, 
       9.31343}, {169.812, 9.31373}, {169.815, 9.31377}, {169.818, 9.31353}, {
       169.822, 9.3131}, {169.825, 9.3124}, {169.828, 9.3115}, {169.832, 
       9.31037}, {169.835, 9.30903}, {169.838, 9.30753}, {169.84, 9.30583}, {
       169.843, 9.30397}, {169.845, 9.302}, {169.848, 9.2999}, {169.849, 
       9.2977}, {169.851, 9.29543}, {169.852, 9.29317}, {169.853, 9.29083}, {
       169.853, 9.28853}, {169.853, 9.28627}, {169.853, 9.28407}, {169.853, 
       9.28193}, {169.852, 9.27993}, {169.851, 9.27803}, {169.849, 9.2763}, {
       169.847, 9.27473}, {169.845, 9.27333}, {169.843, 9.27213}, {169.84, 
       9.27117}, {169.837, 9.27043}, {169.834, 9.26993}, {169.831, 9.26963}, {
       169.828, 9.2696}, {169.825, 9.26983}, {169.821, 9.27027}, {169.818, 
       9.27097}, {169.815, 9.27187}, {169.812, 9.273}}, {{170.213, 9.54953}, {
       170.213, 9.55223}, {170.214, 9.55497}, {170.215, 9.5577}, {170.217, 
       9.5604}, {170.218, 9.56303}, {170.22, 9.56557}, {170.222, 9.56797}, {
       170.224, 9.57023}, {170.227, 9.57233}, {170.229, 9.57427}, {170.232, 
       9.57593}, {170.235, 9.5774}, {170.238, 9.5786}, {170.24, 9.57957}, {
       170.243, 9.58023}, {170.246, 9.58063}, {170.249, 9.58073}, {170.252, 
       9.58057}, {170.254, 9.5801}, {170.257, 9.57937}, {170.259, 9.57833}, {
       170.261, 9.57707}, {170.263, 9.57557}, {170.264, 9.57383}, {170.265, 
       9.57187}, {170.266, 9.56973}, {170.267, 9.5674}, {170.267, 9.56497}, {
       170.268, 9.5624}, {170.267, 9.55977}, {170.267, 9.55707}, {170.266, 
       9.55433}, {170.265, 9.5516}, {170.264, 9.5489}, {170.262, 9.54627}, {
       170.26, 9.54373}, {170.258, 9.54133}, {170.256, 9.53907}, {170.254, 
       9.53697}, {170.251, 9.53503}, {170.248, 9.53337}, {170.246, 9.5319}, {
       170.243, 9.5307}, {170.24, 9.52973}, {170.237, 9.52907}, {170.234, 
       9.52867}, {170.231, 9.52857}, {170.229, 9.52873}, {170.226, 9.5292}, {
       170.224, 9.52993}, {170.222, 9.53097}, {170.22, 9.53223}, {170.218, 
       9.53373}, {170.216, 9.53547}, {170.215, 9.53743}, {170.214, 9.53957}, {
       170.213, 9.5419}, {170.213, 9.54433}, {170.213, 9.5469}, {170.213, 
       9.54953}}, {{169.799, 9.11907}, {169.799, 9.1221}, {169.799, 
       9.12523}, {169.8, 9.1284}, {169.8, 9.1316}, {169.801, 9.13477}, {
       169.802, 9.13787}, {169.803, 9.1409}, {169.805, 9.1438}, {169.806, 
       9.14653}, {169.808, 9.1491}, {169.81, 9.15143}, {169.812, 9.15353}, {
       169.814, 9.1554}, {169.816, 9.15693}, {169.819, 9.1582}, {169.821, 
       9.15917}, {169.823, 9.15977}, {169.826, 9.16007}, {169.828, 9.16003}, {
       169.83, 9.15967}, {169.832, 9.15897}, {169.834, 9.15793}, {169.836, 
       9.1566}, {169.838, 9.15497}, {169.839, 9.15307}, {169.841, 9.1509}, {
       169.842, 9.1485}, {169.843, 9.1459}, {169.843, 9.1431}, {169.844, 
       9.14017}, {169.844, 9.13713}, {169.844, 9.134}, {169.844, 9.13083}, {
       169.843, 9.12763}, {169.842, 9.12447}, {169.841, 9.12137}, {169.84, 
       9.11833}, {169.839, 9.11543}, {169.837, 9.1127}, {169.835, 9.11013}, {
       169.833, 9.1078}, {169.831, 9.1057}, {169.829, 9.10383}, {169.827, 
       9.1023}, {169.825, 9.10103}, {169.822, 9.10007}, {169.82, 9.09947}, {
       169.818, 9.09917}, {169.815, 9.0992}, {169.813, 9.09957}, {169.811, 
       9.10027}, {169.809, 9.1013}, {169.807, 9.10263}, {169.805, 9.10427}, {
       169.804, 9.10617}, {169.803, 9.10833}, {169.801, 9.11073}, {169.8, 
       9.11333}, {169.8, 9.11613}, {169.799, 9.11907}}, {{168.832, 7.24067}, {
       168.828, 7.23967}, {168.824, 7.23883}, {168.82, 7.23817}, {168.815, 
       7.23767}, {168.811, 7.2373}, {168.807, 7.23713}, {168.802, 7.23713}, {
       168.798, 7.23733}, {168.794, 7.2377}, {168.79, 7.2382}, {168.786, 
       7.2389}, {168.783, 7.23973}, {168.78, 7.24073}, {168.777, 7.24183}, {
       168.775, 7.2431}, {168.773, 7.24447}, {168.772, 7.2459}, {168.771, 
       7.24743}, {168.77, 7.24903}, {168.77, 7.25067}, {168.77, 7.25233}, {
       168.771, 7.254}, {168.772, 7.25567}, {168.774, 7.2573}, {168.776, 
       7.2589}, {168.778, 7.26043}, {168.781, 7.26187}, {168.785, 7.26323}, {
       168.788, 7.26447}, {168.792, 7.26557}, {168.796, 7.26657}, {168.8, 
       7.2674}, {168.804, 7.26807}, {168.809, 7.26857}, {168.813, 7.26893}, {
       168.817, 7.2691}, {168.822, 7.2691}, {168.826, 7.2689}, {168.83, 
       7.26853}, {168.834, 7.26803}, {168.838, 7.26733}, {168.841, 7.2665}, {
       168.844, 7.2655}, {168.847, 7.2644}, {168.849, 7.26313}, {168.851, 
       7.26177}, {168.852, 7.26033}, {168.853, 7.2588}, {168.854, 7.2572}, {
       168.854, 7.25557}, {168.854, 7.2539}, {168.853, 7.25223}, {168.852, 
       7.25057}, {168.85, 7.24893}, {168.848, 7.24733}, {168.845, 7.2458}, {
       168.843, 7.24437}, {168.839, 7.243}, {168.836, 7.24177}, {168.832, 
       7.24067}}, {{169.436, 5.8806}, {169.432, 5.88223}, {169.429, 5.884}, {
       169.426, 5.88597}, {169.423, 5.88803}, {169.421, 5.89023}, {169.418, 
       5.89253}, {169.416, 5.8949}, {169.414, 5.8973}, {169.413, 5.89973}, {
       169.411, 5.90213}, {169.41, 5.9045}, {169.41, 5.90683}, {169.41, 
       5.90903}, {169.41, 5.91113}, {169.41, 5.9131}, {169.411, 5.9149}, {
       169.412, 5.91653}, {169.414, 5.91797}, {169.415, 5.9192}, {169.417, 
       5.9202}, {169.42, 5.92097}, {169.422, 5.92147}, {169.425, 5.92173}, {
       169.428, 5.92177}, {169.431, 5.92153}, {169.435, 5.92103}, {169.438, 
       5.9203}, {169.441, 5.91933}, {169.445, 5.91813}, {169.448, 5.91673}, {
       169.451, 5.9151}, {169.454, 5.91333}, {169.458, 5.91137}, {169.46, 
       5.9093}, {169.463, 5.9071}, {169.465, 5.9048}, {169.468, 5.90243}, {
       169.47, 5.90003}, {169.471, 5.8976}, {169.472, 5.8952}, {169.473, 
       5.89283}, {169.474, 5.8905}, {169.474, 5.8883}, {169.474, 5.8862}, {
       169.474, 5.88423}, {169.473, 5.88243}, {169.472, 5.8808}, {169.47, 
       5.87937}, {169.468, 5.87813}, {169.466, 5.87713}, {169.464, 5.87637}, {
       169.461, 5.87587}, {169.458, 5.8756}, {169.456, 5.87557}, {169.452, 
       5.8758}, {169.449, 5.8763}, {169.446, 5.87703}, {169.442, 5.878}, {
       169.439, 5.8792}, {169.436, 5.8806}}, {{169.114, 5.6533}, {169.113, 
       5.65673}, {169.113, 5.66023}, {169.113, 5.66383}, {169.114, 5.66747}, {
       169.115, 5.67107}, {169.115, 5.67463}, {169.116, 5.6781}, {169.118, 
       5.68143}, {169.119, 5.6846}, {169.12, 5.68757}, {169.122, 5.6903}, {
       169.124, 5.69277}, {169.126, 5.69497}, {169.128, 5.69683}, {169.13, 
       5.69837}, {169.132, 5.69953}, {169.134, 5.70037}, {169.136, 5.7008}, {
       169.138, 5.70087}, {169.14, 5.70057}, {169.141, 5.69987}, {169.143, 
       5.6988}, {169.145, 5.6974}, {169.146, 5.69563}, {169.148, 5.69357}, {
       169.149, 5.6912}, {169.15, 5.68853}, {169.151, 5.68567}, {169.152, 
       5.68257}, {169.152, 5.67927}, {169.152, 5.67583}, {169.152, 5.67233}, {
       169.152, 5.66873}, {169.152, 5.6651}, {169.151, 5.6615}, {169.15, 
       5.65793}, {169.149, 5.65447}, {169.148, 5.65113}, {169.147, 5.64797}, {
       169.145, 5.645}, {169.144, 5.64227}, {169.142, 5.6398}, {169.14, 
       5.6376}, {169.138, 5.63573}, {169.136, 5.6342}, {169.134, 5.63303}, {
       169.132, 5.6322}, {169.13, 5.63177}, {169.128, 5.6317}, {169.126, 
       5.632}, {169.124, 5.6327}, {169.122, 5.63377}, {169.121, 5.63517}, {
       169.119, 5.63693}, {169.118, 5.639}, {169.117, 5.64137}, {169.115, 
       5.64403}, {169.115, 5.6469}, {169.114, 5.65}, {169.114, 5.6533}}, {{
       169.473, 10.0418}, {169.471, 10.0438}, {169.47, 10.0459}, {169.469, 
       10.0481}, {169.468, 10.0503}, {169.468, 10.0526}, {169.468, 10.0549}, {
       169.468, 10.0572}, {169.468, 10.0595}, {169.469, 10.0617}, {169.47, 
       10.0638}, {169.472, 10.0658}, {169.473, 10.0676}, {169.475, 10.0693}, {
       169.477, 10.0709}, {169.48, 10.0722}, {169.482, 10.0734}, {169.485, 
       10.0743}, {169.488, 10.075}, {169.491, 10.0755}, {169.494, 10.0757}, {
       169.497, 10.0757}, {169.5, 10.0755}, {169.503, 10.075}, {169.506, 
       10.0743}, {169.509, 10.0734}, {169.512, 10.0722}, {169.514, 10.0709}, {
       169.517, 10.0693}, {169.519, 10.0676}, {169.521, 10.0657}, {169.523, 
       10.0637}, {169.524, 10.0616}, {169.525, 10.0594}, {169.526, 10.0572}, {
       169.526, 10.0549}, {169.526, 10.0526}, {169.526, 10.0503}, {169.526, 
       10.0481}, {169.525, 10.0459}, {169.524, 10.0438}, {169.522, 10.0418}, {
       169.521, 10.0399}, {169.519, 10.0382}, {169.516, 10.0367}, {169.514, 
       10.0353}, {169.511, 10.0342}, {169.509, 10.0332}, {169.506, 10.0325}, {
       169.503, 10.032}, {169.5, 10.0318}, {169.497, 10.0318}, {169.494, 
       10.032}, {169.49, 10.0325}, {169.488, 10.0332}, {169.485, 10.0342}, {
       169.482, 10.0353}, {169.479, 10.0367}, {169.477, 10.0382}, {169.475, 
       10.0399}, {169.473, 10.0418}}, {{170.895, 8.90043}, {170.894, 8.902}, {
       170.893, 8.9037}, {170.893, 8.90547}, {170.893, 8.90737}, {170.893, 
       8.9093}, {170.894, 8.91127}, {170.895, 8.91327}, {170.897, 8.91527}, {
       170.899, 8.91727}, {170.901, 8.9192}, {170.904, 8.92107}, {170.906, 
       8.92283}, {170.91, 8.9245}, {170.913, 8.92607}, {170.916, 8.92747}, {
       170.92, 8.92873}, {170.924, 8.9298}, {170.927, 8.9307}, {170.931, 
       8.9314}, {170.935, 8.93193}, {170.939, 8.93223}, {170.942, 8.9323}, {
       170.945, 8.9322}, {170.949, 8.93187}, {170.952, 8.93133}, {170.954, 
       8.9306}, {170.957, 8.9297}, {170.959, 8.9286}, {170.961, 8.92733}, {
       170.962, 8.9259}, {170.963, 8.92433}, {170.964, 8.92263}, {170.964, 
       8.92087}, {170.964, 8.91897}, {170.964, 8.91703}, {170.963, 8.91507}, {
       170.962, 8.91307}, {170.96, 8.91107}, {170.958, 8.90907}, {170.956, 
       8.90713}, {170.953, 8.90527}, {170.95, 8.9035}, {170.947, 8.90183}, {
       170.944, 8.90027}, {170.941, 8.89887}, {170.937, 8.8976}, {170.933, 
       8.89653}, {170.93, 8.89563}, {170.926, 8.89493}, {170.922, 8.8944}, {
       170.918, 8.8941}, {170.915, 8.89403}, {170.911, 8.89413}, {170.908, 
       8.89447}, {170.905, 8.895}, {170.903, 8.89573}, {170.9, 8.89663}, {
       170.898, 8.89773}, {170.896, 8.899}, {170.895, 8.90043}}, {{169.781, 
       9.4935}, {169.778, 9.492}, {169.774, 9.49063}, {169.771, 9.48943}, {
       169.767, 9.48837}, {169.763, 9.4875}, {169.76, 9.48677}, {169.756, 
       9.48627}, {169.752, 9.48593}, {169.748, 9.4858}, {169.744, 9.48583}, {
       169.741, 9.4861}, {169.738, 9.48653}, {169.735, 9.4872}, {169.732, 
       9.488}, {169.729, 9.489}, {169.727, 9.49013}, {169.725, 9.49143}, {
       169.724, 9.49287}, {169.722, 9.49443}, {169.722, 9.4961}, {169.721, 
       9.49783}, {169.721, 9.49963}, {169.722, 9.50147}, {169.723, 9.50337}, {
       169.724, 9.50523}, {169.726, 9.5071}, {169.728, 9.50893}, {169.73, 
       9.5107}, {169.732, 9.51237}, {169.735, 9.51397}, {169.739, 9.51547}, {
       169.742, 9.51683}, {169.745, 9.51803}, {169.749, 9.5191}, {169.753, 
       9.51997}, {169.757, 9.5207}, {169.761, 9.5212}, {169.764, 9.52153}, {
       169.768, 9.52167}, {169.772, 9.52163}, {169.775, 9.52137}, {169.779, 
       9.52093}, {169.782, 9.52027}, {169.784, 9.51947}, {169.787, 9.51847}, {
       169.789, 9.51733}, {169.791, 9.51603}, {169.793, 9.5146}, {169.794, 
       9.51303}, {169.794, 9.51137}, {169.795, 9.50963}, {169.795, 9.50783}, {
       169.794, 9.506}, {169.793, 9.5041}, {169.792, 9.50223}, {169.791, 
       9.50037}, {169.789, 9.49853}, {169.786, 9.49677}, {169.784, 9.4951}, {
       169.781, 9.4935}}, {{170.69, 10.1462}, {170.687, 10.1479}, {170.685, 
       10.1498}, {170.683, 10.1517}, {170.681, 10.1538}, {170.679, 10.156}, {
       170.678, 10.1583}, {170.677, 10.1606}, {170.676, 10.1629}, {170.675, 
       10.1652}, {170.675, 10.1675}, {170.675, 10.1698}, {170.676, 10.1719}, {
       170.677, 10.174}, {170.678, 10.1759}, {170.679, 10.1777}, {170.681, 
       10.1793}, {170.683, 10.1807}, {170.685, 10.1819}, {170.688, 10.183}, {
       170.69, 10.1838}, {170.693, 10.1843}, {170.696, 10.1846}, {170.699, 
       10.1847}, {170.702, 10.1846}, {170.705, 10.1841}, {170.708, 10.1835}, {
       170.711, 10.1826}, {170.714, 10.1815}, {170.716, 10.1802}, {170.719, 
       10.1787}, {170.722, 10.177}, {170.724, 10.1752}, {170.726, 10.1732}, {
       170.728, 10.1711}, {170.73, 10.169}, {170.731, 10.1667}, {170.732, 
       10.1644}, {170.733, 10.1621}, {170.733, 10.1597}, {170.733, 10.1574}, {
       170.733, 10.1552}, {170.733, 10.1531}, {170.732, 10.151}, {170.731, 
       10.1491}, {170.729, 10.1473}, {170.728, 10.1457}, {170.726, 10.1442}, {
       170.724, 10.143}, {170.721, 10.142}, {170.719, 10.1412}, {170.716, 
       10.1406}, {170.713, 10.1403}, {170.71, 10.1402}, {170.707, 10.1404}, {
       170.704, 10.1408}, {170.701, 10.1415}, {170.698, 10.1423}, {170.695, 
       10.1434}, {170.692, 10.1447}, {170.69, 10.1462}}, {{168.614, 7.2349}, {
       168.614, 7.23643}, {168.614, 7.23803}, {168.615, 7.23963}, {168.616, 
       7.24127}, {168.618, 7.2429}, {168.619, 7.24453}, {168.622, 7.2461}, {
       168.625, 7.24763}, {168.628, 7.2491}, {168.631, 7.25047}, {168.635, 
       7.25173}, {168.638, 7.25287}, {168.643, 7.2539}, {168.647, 7.25477}, {
       168.651, 7.2555}, {168.655, 7.25607}, {168.66, 7.2565}, {168.664, 
       7.25673}, {168.668, 7.2568}, {168.672, 7.2567}, {168.676, 7.25643}, {
       168.68, 7.256}, {168.684, 7.2554}, {168.687, 7.25463}, {168.689, 
       7.25373}, {168.692, 7.2527}, {168.694, 7.25153}, {168.696, 7.25023}, {
       168.697, 7.24887}, {168.697, 7.2474}, {168.698, 7.24587}, {168.698, 
       7.24427}, {168.697, 7.24267}, {168.696, 7.24103}, {168.694, 7.2394}, {
       168.692, 7.23777}, {168.69, 7.2362}, {168.687, 7.23467}, {168.684, 
       7.2332}, {168.681, 7.23183}, {168.677, 7.23057}, {168.673, 7.22943}, {
       168.669, 7.2284}, {168.665, 7.22753}, {168.661, 7.2268}, {168.656, 
       7.22623}, {168.652, 7.2258}, {168.648, 7.22557}, {168.643, 7.2255}, {
       168.639, 7.2256}, {168.635, 7.22587}, {168.632, 7.2263}, {168.628, 
       7.2269}, {168.625, 7.22767}, {168.622, 7.22857}, {168.62, 7.2296}, {
       168.618, 7.23077}, {168.616, 7.23207}, {168.615, 7.23343}, {168.614, 
       7.2349}}, {{170.732, 10.0833}, {170.729, 10.0829}, {170.725, 
       10.0826}, {170.722, 10.0825}, {170.718, 10.0826}, {170.714, 10.0829}, {
       170.711, 10.0834}, {170.707, 10.0841}, {170.704, 10.0849}, {170.701, 
       10.086}, {170.698, 10.0872}, {170.695, 10.0885}, {170.693, 10.09}, {
       170.691, 10.0915}, {170.689, 10.0932}, {170.688, 10.0949}, {170.687, 
       10.0968}, {170.686, 10.0986}, {170.686, 10.1005}, {170.686, 10.1023}, {
       170.686, 10.1042}, {170.687, 10.106}, {170.688, 10.1077}, {170.69, 
       10.1094}, {170.691, 10.1109}, {170.694, 10.1124}, {170.696, 10.1137}, {
       170.699, 10.1149}, {170.702, 10.1159}, {170.705, 10.1167}, {170.708, 
       10.1174}, {170.712, 10.1178}, {170.715, 10.1181}, {170.719, 10.1182}, {
       170.723, 10.1181}, {170.726, 10.1178}, {170.73, 10.1173}, {170.733, 
       10.1166}, {170.736, 10.1158}, {170.74, 10.1147}, {170.743, 10.1135}, {
       170.745, 10.1122}, {170.748, 10.1107}, {170.75, 10.1092}, {170.751, 
       10.1075}, {170.753, 10.1058}, {170.754, 10.1039}, {170.755, 10.1021}, {
       170.755, 10.1002}, {170.755, 10.0984}, {170.755, 10.0965}, {170.754, 
       10.0947}, {170.753, 10.093}, {170.751, 10.0913}, {170.749, 10.0898}, {
       170.747, 10.0883}, {170.745, 10.087}, {170.742, 10.0858}, {170.739, 
       10.0848}, {170.736, 10.084}, {170.732, 10.0833}}, {{167.213, 
       9.06707}, {167.211, 9.06837}, {167.211, 9.06983}, {167.21, 9.07147}, {
       167.21, 9.07323}, {167.21, 9.0751}, {167.211, 9.07703}, {167.212, 
       9.07907}, {167.213, 9.08113}, {167.215, 9.08323}, {167.217, 9.08537}, {
       167.219, 9.08743}, {167.222, 9.08947}, {167.225, 9.09147}, {167.228, 
       9.09333}, {167.231, 9.09513}, {167.235, 9.09677}, {167.238, 9.09827}, {
       167.242, 9.09963}, {167.246, 9.1008}, {167.249, 9.10177}, {167.253, 
       9.10253}, {167.256, 9.1031}, {167.26, 9.10347}, {167.263, 9.1036}, {
       167.266, 9.10353}, {167.269, 9.1032}, {167.271, 9.1027}, {167.273, 
       9.10197}, {167.275, 9.10103}, {167.277, 9.0999}, {167.278, 9.0986}, {
       167.279, 9.09713}, {167.28, 9.0955}, {167.28, 9.09373}, {167.279, 
       9.09187}, {167.279, 9.08993}, {167.278, 9.0879}, {167.276, 9.08583}, {
       167.275, 9.08373}, {167.272, 9.0816}, {167.27, 9.07953}, {167.267, 
       9.0775}, {167.265, 9.0755}, {167.261, 9.07363}, {167.258, 9.07183}, {
       167.255, 9.0702}, {167.251, 9.0687}, {167.248, 9.06733}, {167.244, 
       9.06617}, {167.24, 9.0652}, {167.237, 9.06443}, {167.233, 9.06387}, {
       167.23, 9.0635}, {167.227, 9.06337}, {167.224, 9.06343}, {167.221, 
       9.06377}, {167.218, 9.06427}, {167.216, 9.065}, {167.214, 9.06593}, {
       167.213, 9.06707}}, {{171.875, 5.99717}, {171.874, 5.9986}, {171.873, 
       6.0002}, {171.872, 6.00187}, {171.872, 6.00367}, {171.872, 6.00553}, {
       171.873, 6.00743}, {171.874, 6.0094}, {171.875, 6.01133}, {171.876, 
       6.0133}, {171.878, 6.0152}, {171.88, 6.01707}, {171.883, 6.01887}, {
       171.886, 6.02057}, {171.888, 6.02217}, {171.891, 6.02363}, {171.895, 
       6.02493}, {171.898, 6.0261}, {171.901, 6.0271}, {171.905, 6.0279}, {
       171.908, 6.0285}, {171.912, 6.02893}, {171.915, 6.02913}, {171.918, 
       6.02917}, {171.921, 6.02897}, {171.924, 6.02857}, {171.927, 6.02797}, {
       171.929, 6.02717}, {171.931, 6.0262}, {171.933, 6.02507}, {171.935, 
       6.02377}, {171.936, 6.02233}, {171.937, 6.02073}, {171.937, 6.01907}, {
       171.937, 6.01727}, {171.937, 6.0154}, {171.937, 6.0135}, {171.936, 
       6.01153}, {171.934, 6.0096}, {171.933, 6.00763}, {171.931, 6.00573}, {
       171.929, 6.00387}, {171.926, 6.00207}, {171.924, 6.00037}, {171.921, 
       5.99877}, {171.918, 5.9973}, {171.915, 5.996}, {171.911, 5.99483}, {
       171.908, 5.99383}, {171.904, 5.99303}, {171.901, 5.99243}, {171.898, 
       5.992}, {171.894, 5.9918}, {171.891, 5.99177}, {171.888, 5.99197}, {
       171.885, 5.99237}, {171.883, 5.99297}, {171.88, 5.99377}, {171.878, 
       5.99473}, {171.876, 5.99587}, {171.875, 5.99717}}, {{169.847, 
       10.3487}, {169.846, 10.3505}, {169.844, 10.3523}, {169.843, 10.3542}, {
       169.843, 10.3562}, {169.842, 10.3582}, {169.842, 10.3603}, {169.842, 
       10.3623}, {169.843, 10.3643}, {169.844, 10.3662}, {169.845, 10.3681}, {
       169.846, 10.3699}, {169.848, 10.3715}, {169.85, 10.3731}, {169.852, 
       10.3745}, {169.855, 10.3757}, {169.857, 10.3767}, {169.86, 10.3776}, {
       169.863, 10.3783}, {169.866, 10.3787}, {169.869, 10.379}, {169.872, 
       10.379}, {169.875, 10.3789}, {169.878, 10.3785}, {169.88, 10.3779}, {
       169.883, 10.3771}, {169.886, 10.3761}, {169.888, 10.375}, {169.891, 
       10.3736}, {169.893, 10.3721}, {169.895, 10.3705}, {169.896, 10.3688}, {
       169.897, 10.3669}, {169.898, 10.365}, {169.899, 10.3631}, {169.899, 
       10.361}, {169.9, 10.359}, {169.899, 10.357}, {169.899, 10.355}, {
       169.898, 10.353}, {169.897, 10.3512}, {169.895, 10.3494}, {169.894, 
       10.3477}, {169.892, 10.3462}, {169.889, 10.3448}, {169.887, 10.3436}, {
       169.884, 10.3425}, {169.882, 10.3417}, {169.879, 10.341}, {169.876, 
       10.3405}, {169.873, 10.3403}, {169.87, 10.3402}, {169.867, 10.3404}, {
       169.864, 10.3408}, {169.861, 10.3414}, {169.858, 10.3422}, {169.856, 
       10.3432}, {169.853, 10.3443}, {169.851, 10.3456}, {169.849, 10.3471}, {
       169.847, 10.3487}}, {{171.195, 8.2935}, {171.193, 8.2953}, {171.192, 
       8.29713}, {171.191, 8.2991}, {171.191, 8.30107}, {171.19, 8.3031}, {
       171.19, 8.30513}, {171.191, 8.30717}, {171.191, 8.30913}, {171.192, 
       8.31107}, {171.193, 8.3129}, {171.195, 8.31467}, {171.197, 8.31627}, {
       171.199, 8.31777}, {171.201, 8.31913}, {171.203, 8.3203}, {171.206, 
       8.3213}, {171.209, 8.3221}, {171.212, 8.3227}, {171.214, 8.3231}, {
       171.217, 8.3233}, {171.22, 8.32327}, {171.223, 8.32303}, {171.226, 
       8.3226}, {171.229, 8.32193}, {171.232, 8.3211}, {171.234, 8.32007}, {
       171.237, 8.31883}, {171.239, 8.31747}, {171.241, 8.31593}, {171.243, 
       8.3143}, {171.244, 8.3125}, {171.245, 8.31067}, {171.246, 8.3087}, {
       171.247, 8.30673}, {171.247, 8.3047}, {171.247, 8.30267}, {171.247, 
       8.30063}, {171.246, 8.29867}, {171.245, 8.29673}, {171.244, 8.2949}, {
       171.243, 8.29313}, {171.241, 8.29153}, {171.239, 8.29003}, {171.237, 
       8.28867}, {171.234, 8.2875}, {171.232, 8.2865}, {171.229, 8.2857}, {
       171.226, 8.2851}, {171.223, 8.2847}, {171.22, 8.2845}, {171.217, 
       8.28453}, {171.214, 8.28477}, {171.211, 8.2852}, {171.208, 8.28587}, {
       171.206, 8.2867}, {171.203, 8.28773}, {171.201, 8.28897}, {171.198, 
       8.29033}, {171.197, 8.29187}, {171.195, 8.2935}}, {{166.85, 9.22357}, {
       166.849, 9.22553}, {166.848, 9.22753}, {166.848, 9.22957}, {166.848, 
       9.2316}, {166.848, 9.23363}, {166.849, 9.23563}, {166.85, 9.2376}, {
       166.851, 9.23947}, {166.853, 9.24123}, {166.854, 9.2429}, {166.856, 
       9.2444}, {166.859, 9.24577}, {166.861, 9.24697}, {166.864, 9.248}, {
       166.866, 9.24883}, {166.869, 9.24947}, {166.872, 9.2499}, {166.875, 
       9.2501}, {166.878, 9.2501}, {166.881, 9.2499}, {166.884, 9.24947}, {
       166.887, 9.24883}, {166.889, 9.248}, {166.892, 9.24697}, {166.894, 
       9.24577}, {166.896, 9.2444}, {166.898, 9.24287}, {166.9, 9.2412}, {
       166.901, 9.23943}, {166.903, 9.23757}, {166.904, 9.2356}, {166.904, 
       9.2336}, {166.904, 9.23157}, {166.904, 9.22953}, {166.904, 9.2275}, {
       166.903, 9.2255}, {166.903, 9.22353}, {166.901, 9.22167}, {166.9, 
       9.2199}, {166.898, 9.21823}, {166.896, 9.21673}, {166.894, 9.21537}, {
       166.892, 9.21417}, {166.889, 9.21313}, {166.886, 9.2123}, {166.883, 
       9.21167}, {166.881, 9.21123}, {166.878, 9.21103}, {166.875, 9.21103}, {
       166.872, 9.21123}, {166.869, 9.21167}, {166.866, 9.2123}, {166.863, 
       9.21313}, {166.861, 9.21417}, {166.858, 9.21537}, {166.856, 9.21673}, {
       166.854, 9.21827}, {166.852, 9.21993}, {166.851, 9.2217}, {166.85, 
       9.22357}}, {{166.579, 11.4299}, {166.578, 11.4321}, {166.577, 
       11.4344}, {166.577, 11.4368}, {166.577, 11.4392}, {166.577, 11.4416}, {
       166.577, 11.444}, {166.578, 11.4463}, {166.578, 11.4486}, {166.579, 
       11.4507}, {166.581, 11.4528}, {166.582, 11.4547}, {166.584, 11.4564}, {
       166.586, 11.4579}, {166.588, 11.4593}, {166.59, 11.4604}, {166.592, 
       11.4613}, {166.595, 11.4619}, {166.597, 11.4623}, {166.6, 11.4625}, {
       166.602, 11.4624}, {166.605, 11.4621}, {166.607, 11.4615}, {166.61, 
       11.4607}, {166.612, 11.4596}, {166.614, 11.4583}, {166.616, 11.4568}, {
       166.618, 11.4552}, {166.619, 11.4533}, {166.621, 11.4513}, {166.622, 
       11.4492}, {166.623, 11.447}, {166.624, 11.4446}, {166.624, 11.4423}, {
       166.624, 11.4399}, {166.624, 11.4375}, {166.624, 11.4351}, {166.623, 
       11.4328}, {166.623, 11.4305}, {166.622, 11.4284}, {166.62, 11.4263}, {
       166.619, 11.4244}, {166.617, 11.4227}, {166.615, 11.4212}, {166.613, 
       11.4198}, {166.611, 11.4187}, {166.609, 11.4178}, {166.606, 11.4172}, {
       166.604, 11.4168}, {166.601, 11.4166}, {166.599, 11.4167}, {166.596, 
       11.417}, {166.594, 11.4176}, {166.591, 11.4184}, {166.589, 11.4195}, {
       166.587, 11.4208}, {166.585, 11.4223}, {166.583, 11.4239}, {166.582, 
       11.4258}, {166.58, 11.4278}, {166.579, 11.4299}}, {{169.42, 6.03927}, {
       169.419, 6.04073}, {169.417, 6.04237}, {169.416, 6.04407}, {169.415, 
       6.04583}, {169.414, 6.04767}, {169.414, 6.04953}, {169.414, 6.05143}, {
       169.415, 6.05333}, {169.415, 6.0552}, {169.416, 6.057}, {169.418, 
       6.05877}, {169.419, 6.06043}, {169.421, 6.062}, {169.423, 6.06343}, {
       169.426, 6.06473}, {169.428, 6.0659}, {169.431, 6.0669}, {169.434, 
       6.06773}, {169.437, 6.06837}, {169.44, 6.06883}, {169.443, 6.06907}, {
       169.446, 6.06913}, {169.449, 6.069}, {169.452, 6.06867}, {169.455, 
       6.06813}, {169.458, 6.06743}, {169.461, 6.06653}, {169.463, 6.06547}, {
       169.466, 6.06423}, {169.468, 6.06287}, {169.469, 6.0614}, {169.471, 
       6.05977}, {169.472, 6.05807}, {169.473, 6.0563}, {169.474, 6.05447}, {
       169.474, 6.0526}, {169.474, 6.0507}, {169.473, 6.0488}, {169.473, 
       6.04693}, {169.472, 6.04513}, {169.47, 6.04337}, {169.469, 6.0417}, {
       169.467, 6.04013}, {169.465, 6.0387}, {169.462, 6.0374}, {169.46, 
       6.03623}, {169.457, 6.03523}, {169.454, 6.0344}, {169.451, 6.03377}, {
       169.448, 6.0333}, {169.445, 6.03307}, {169.442, 6.033}, {169.439, 
       6.03313}, {169.436, 6.03347}, {169.433, 6.034}, {169.43, 6.0347}, {
       169.427, 6.0356}, {169.425, 6.03667}, {169.422, 6.0379}, {169.42, 
       6.03927}}, {{169.397, 9.81357}, {169.395, 9.8154}, {169.394, 
       9.81737}, {169.393, 9.8194}, {169.393, 9.82147}, {169.392, 9.82357}, {
       169.392, 9.82567}, {169.393, 9.82777}, {169.393, 9.8298}, {169.394, 
       9.8318}, {169.395, 9.8337}, {169.397, 9.8355}, {169.398, 9.83717}, {
       169.4, 9.8387}, {169.402, 9.84007}, {169.404, 9.84123}, {169.407, 
       9.84223}, {169.409, 9.84307}, {169.412, 9.84367}, {169.415, 9.84403}, {
       169.417, 9.8442}, {169.42, 9.84413}, {169.423, 9.84387}, {169.426, 
       9.84337}, {169.428, 9.84267}, {169.431, 9.84177}, {169.433, 9.84067}, {
       169.436, 9.83937}, {169.438, 9.8379}, {169.44, 9.8363}, {169.441, 
       9.83457}, {169.443, 9.83273}, {169.444, 9.83077}, {169.445, 9.82873}, {
       169.445, 9.82667}, {169.446, 9.82457}, {169.446, 9.82247}, {169.446, 
       9.82037}, {169.445, 9.81833}, {169.444, 9.81633}, {169.443, 9.81443}, {
       169.442, 9.81263}, {169.44, 9.81097}, {169.438, 9.80943}, {169.436, 
       9.80807}, {169.434, 9.8069}, {169.431, 9.8059}, {169.429, 9.80507}, {
       169.426, 9.80447}, {169.424, 9.8041}, {169.421, 9.80393}, {169.418, 
       9.804}, {169.415, 9.80427}, {169.412, 9.80477}, {169.41, 9.80547}, {
       169.407, 9.80637}, {169.405, 9.80747}, {169.402, 9.80877}, {169.4, 
       9.81023}, {169.398, 9.81183}, {169.397, 9.81357}}, {{165.489, 
       11.4958}, {165.488, 11.4968}, {165.487, 11.4981}, {165.487, 11.4995}, {
       165.486, 11.5011}, {165.487, 11.5029}, {165.487, 11.5048}, {165.488, 
       11.5069}, {165.489, 11.509}, {165.491, 11.5113}, {165.492, 11.5136}, {
       165.495, 11.5159}, {165.497, 11.5182}, {165.5, 11.5205}, {165.503, 
       11.5227}, {165.506, 11.5249}, {165.509, 11.527}, {165.512, 11.5289}, {
       165.515, 11.5307}, {165.519, 11.5324}, {165.522, 11.5339}, {165.526, 
       11.5351}, {165.529, 11.5362}, {165.532, 11.5371}, {165.535, 11.5377}, {
       165.538, 11.5381}, {165.541, 11.5382}, {165.543, 11.5381}, {165.545, 
       11.5378}, {165.547, 11.5372}, {165.549, 11.5364}, {165.55, 11.5354}, {
       165.551, 11.5341}, {165.552, 11.5327}, {165.552, 11.5311}, {165.552, 
       11.5293}, {165.551, 11.5274}, {165.55, 11.5253}, {165.549, 11.5232}, {
       165.547, 11.5209}, {165.546, 11.5186}, {165.543, 11.5163}, {165.541, 
       11.514}, {165.538, 11.5117}, {165.536, 11.5095}, {165.533, 11.5073}, {
       165.529, 11.5052}, {165.526, 11.5033}, {165.523, 11.5015}, {165.519, 
       11.4998}, {165.516, 11.4983}, {165.512, 11.4971}, {165.509, 11.496}, {
       165.506, 11.4951}, {165.503, 11.4945}, {165.5, 11.4941}, {165.497, 
       11.494}, {165.495, 11.4941}, {165.493, 11.4944}, {165.491, 11.495}, {
       165.489, 11.4958}}, {{169.53, 5.79953}, {169.531, 5.8018}, {169.531, 
       5.80403}, {169.532, 5.80627}, {169.534, 5.80843}, {169.535, 5.81057}, {
       169.537, 5.81257}, {169.539, 5.8145}, {169.541, 5.81627}, {169.543, 
       5.81787}, {169.546, 5.81933}, {169.548, 5.82057}, {169.551, 5.82163}, {
       169.554, 5.82247}, {169.556, 5.82307}, {169.559, 5.82347}, {169.562, 
       5.82363}, {169.564, 5.82353}, {169.567, 5.8232}, {169.569, 5.82267}, {
       169.571, 5.8219}, {169.573, 5.8209}, {169.575, 5.8197}, {169.577, 
       5.8183}, {169.578, 5.81673}, {169.579, 5.81503}, {169.58, 5.81317}, {
       169.58, 5.81117}, {169.581, 5.80907}, {169.581, 5.8069}, {169.581, 
       5.8047}, {169.58, 5.80243}, {169.579, 5.8002}, {169.578, 5.79797}, {
       169.577, 5.7958}, {169.575, 5.79367}, {169.574, 5.79167}, {169.572, 
       5.78973}, {169.57, 5.78797}, {169.567, 5.78637}, {169.565, 5.7849}, {
       169.562, 5.78367}, {169.56, 5.7826}, {169.557, 5.78177}, {169.554, 
       5.78117}, {169.552, 5.78077}, {169.549, 5.7806}, {169.547, 5.7807}, {
       169.544, 5.78103}, {169.542, 5.78157}, {169.54, 5.78233}, {169.538, 
       5.78333}, {169.536, 5.78453}, {169.534, 5.78593}, {169.533, 5.7875}, {
       169.532, 5.7892}, {169.531, 5.79107}, {169.53, 5.79307}, {169.53, 
       5.79517}, {169.53, 5.79733}, {169.53, 5.79953}}, {{168.336, 7.64893}, {
       168.334, 7.65023}, {168.331, 7.6517}, {168.329, 7.65333}, {168.327, 
       7.65507}, {168.325, 7.6569}, {168.323, 7.65883}, {168.322, 7.66083}, {
       168.321, 7.66287}, {168.32, 7.66493}, {168.319, 7.667}, {168.319, 
       7.66903}, {168.319, 7.67103}, {168.32, 7.67297}, {168.32, 7.6748}, {
       168.321, 7.67653}, {168.322, 7.67813}, {168.324, 7.6796}, {168.326, 
       7.6809}, {168.328, 7.68203}, {168.33, 7.68297}, {168.332, 7.6837}, {
       168.335, 7.68423}, {168.337, 7.68457}, {168.34, 7.68467}, {168.343, 
       7.68457}, {168.346, 7.68423}, {168.349, 7.6837}, {168.351, 7.68297}, {
       168.354, 7.682}, {168.357, 7.6809}, {168.36, 7.6796}, {168.362, 
       7.67813}, {168.364, 7.6765}, {168.367, 7.67477}, {168.368, 7.67293}, {
       168.37, 7.671}, {168.371, 7.669}, {168.373, 7.66697}, {168.373, 
       7.6649}, {168.374, 7.66283}, {168.374, 7.6608}, {168.374, 7.6588}, {
       168.374, 7.65687}, {168.373, 7.65503}, {168.372, 7.6533}, {168.371, 
       7.6517}, {168.37, 7.65023}, {168.368, 7.64893}, {168.366, 7.6478}, {
       168.364, 7.64687}, {168.361, 7.64613}, {168.359, 7.6456}, {168.356, 
       7.64527}, {168.353, 7.64517}, {168.351, 7.64527}, {168.348, 7.6456}, {
       168.345, 7.64613}, {168.342, 7.64687}, {168.339, 7.64783}, {168.336, 
       7.64893}}, {{170.379, 9.41823}, {170.377, 9.42063}, {170.376, 
       9.42313}, {170.376, 9.4257}, {170.375, 9.42833}, {170.375, 9.43097}, {
       170.374, 9.4336}, {170.375, 9.4362}, {170.375, 9.43873}, {170.375, 
       9.44117}, {170.376, 9.44347}, {170.377, 9.44563}, {170.378, 9.44763}, {
       170.38, 9.44943}, {170.381, 9.45103}, {170.383, 9.4524}, {170.385, 
       9.4535}, {170.387, 9.45437}, {170.389, 9.45493}, {170.391, 9.45527}, {
       170.393, 9.4553}, {170.395, 9.45507}, {170.397, 9.45457}, {170.399, 
       9.4538}, {170.402, 9.45277}, {170.404, 9.45147}, {170.406, 9.44993}, {
       170.408, 9.4482}, {170.409, 9.44627}, {170.411, 9.44417}, {170.412, 
       9.44187}, {170.414, 9.43947}, {170.415, 9.43697}, {170.415, 9.4344}, {
       170.416, 9.43177}, {170.416, 9.42913}, {170.417, 9.4265}, {170.416, 
       9.4239}, {170.416, 9.42137}, {170.416, 9.41893}, {170.415, 9.41663}, {
       170.414, 9.41447}, {170.413, 9.41247}, {170.411, 9.41067}, {170.41, 
       9.40907}, {170.408, 9.4077}, {170.406, 9.4066}, {170.404, 9.40573}, {
       170.402, 9.40517}, {170.4, 9.40483}, {170.398, 9.4048}, {170.396, 
       9.40503}, {170.394, 9.40553}, {170.392, 9.4063}, {170.389, 9.40733}, {
       170.387, 9.40863}, {170.385, 9.41017}, {170.383, 9.4119}, {170.382, 
       9.41383}, {170.38, 9.41593}, {170.379, 9.41823}}, {{167.097, 9.2003}, {
       167.096, 9.20227}, {167.095, 9.2043}, {167.095, 9.20637}, {167.095, 
       9.20843}, {167.095, 9.2105}, {167.096, 9.2125}, {167.097, 9.2145}, {
       167.098, 9.2164}, {167.099, 9.2182}, {167.101, 9.21987}, {167.103, 
       9.22143}, {167.105, 9.22283}, {167.107, 9.22403}, {167.11, 9.2251}, {
       167.112, 9.22597}, {167.115, 9.2266}, {167.118, 9.22707}, {167.12, 
       9.2273}, {167.123, 9.2273}, {167.126, 9.2271}, {167.129, 9.22667}, {
       167.131, 9.22607}, {167.134, 9.22523}, {167.136, 9.2242}, {167.138, 
       9.223}, {167.14, 9.22163}, {167.142, 9.2201}, {167.144, 9.21843}, {
       167.145, 9.21663}, {167.146, 9.21477}, {167.147, 9.2128}, {167.148, 
       9.21077}, {167.148, 9.2087}, {167.148, 9.20663}, {167.148, 9.20457}, {
       167.147, 9.20257}, {167.146, 9.20057}, {167.145, 9.19867}, {167.144, 
       9.19687}, {167.142, 9.1952}, {167.14, 9.19363}, {167.138, 9.19223}, {
       167.136, 9.19103}, {167.133, 9.18997}, {167.131, 9.1891}, {167.128, 
       9.18847}, {167.126, 9.188}, {167.123, 9.18777}, {167.12, 9.18777}, {
       167.117, 9.18797}, {167.115, 9.1884}, {167.112, 9.189}, {167.109, 
       9.18983}, {167.107, 9.19087}, {167.105, 9.19207}, {167.103, 9.19343}, {
       167.101, 9.19497}, {167.099, 9.19663}, {167.098, 9.19843}, {167.097, 
       9.2003}}, {{171.372, 8.0403}, {171.369, 8.0409}, {171.366, 8.04167}, {
       171.363, 8.04263}, {171.36, 8.04377}, {171.357, 8.04503}, {171.354, 
       8.0464}, {171.351, 8.04793}, {171.349, 8.04953}, {171.347, 8.05127}, {
       171.345, 8.05303}, {171.343, 8.05483}, {171.342, 8.05667}, {171.341, 
       8.05853}, {171.341, 8.06037}, {171.341, 8.06217}, {171.341, 8.0639}, {
       171.341, 8.06557}, {171.342, 8.06717}, {171.343, 8.06863}, {171.344, 
       8.06997}, {171.346, 8.0712}, {171.348, 8.07223}, {171.35, 8.07313}, {
       171.353, 8.07387}, {171.356, 8.0744}, {171.358, 8.07473}, {171.361, 
       8.0749}, {171.365, 8.07487}, {171.368, 8.07463}, {171.371, 8.0742}, {
       171.374, 8.0736}, {171.377, 8.07283}, {171.381, 8.07187}, {171.384, 
       8.07073}, {171.387, 8.06947}, {171.389, 8.0681}, {171.392, 8.06657}, {
       171.394, 8.06497}, {171.396, 8.06323}, {171.398, 8.06147}, {171.4, 
       8.05967}, {171.401, 8.05783}, {171.402, 8.05597}, {171.402, 8.05413}, {
       171.403, 8.05233}, {171.403, 8.0506}, {171.402, 8.04893}, {171.401, 
       8.04733}, {171.4, 8.04587}, {171.399, 8.04453}, {171.397, 8.0433}, {
       171.395, 8.04227}, {171.393, 8.04137}, {171.39, 8.04063}, {171.388, 
       8.0401}, {171.385, 8.03977}, {171.382, 8.0396}, {171.379, 8.03963}, {
       171.375, 8.03987}, {171.372, 8.0403}}, {{167.347, 8.2549}, {167.344, 
       8.25567}, {167.341, 8.2566}, {167.338, 8.2577}, {167.335, 8.25897}, {
       167.332, 8.26037}, {167.33, 8.2619}, {167.328, 8.26353}, {167.326, 
       8.26527}, {167.324, 8.26707}, {167.322, 8.26893}, {167.321, 8.27083}, {
       167.32, 8.27273}, {167.32, 8.27463}, {167.32, 8.2765}, {167.32, 
       8.27833}, {167.32, 8.28007}, {167.321, 8.28173}, {167.322, 8.2833}, {
       167.323, 8.28473}, {167.325, 8.28603}, {167.327, 8.28717}, {167.329, 
       8.28813}, {167.331, 8.28893}, {167.334, 8.28957}, {167.337, 8.28997}, {
       167.34, 8.2902}, {167.343, 8.29023}, {167.346, 8.29003}, {167.349, 
       8.28967}, {167.352, 8.2891}, {167.355, 8.28833}, {167.358, 8.2874}, {
       167.361, 8.2863}, {167.364, 8.28503}, {167.366, 8.28363}, {167.369, 
       8.2821}, {167.371, 8.28047}, {167.373, 8.27873}, {167.375, 8.27693}, {
       167.376, 8.27507}, {167.377, 8.27317}, {167.378, 8.27127}, {167.379, 
       8.26937}, {167.379, 8.2675}, {167.379, 8.26567}, {167.379, 8.26393}, {
       167.378, 8.26227}, {167.377, 8.2607}, {167.375, 8.25927}, {167.374, 
       8.25797}, {167.372, 8.25683}, {167.37, 8.25587}, {167.367, 8.25507}, {
       167.365, 8.25443}, {167.362, 8.25403}, {167.359, 8.2538}, {167.356, 
       8.25377}, {167.353, 8.25397}, {167.35, 8.25433}, {167.347, 8.2549}}, {{
       165.736, 9.1637}, {165.738, 9.16587}, {165.739, 9.16803}, {165.741, 
       9.1701}, {165.743, 9.17213}, {165.746, 9.17403}, {165.748, 9.17583}, {
       165.751, 9.1775}, {165.754, 9.179}, {165.756, 9.18033}, {165.759, 
       9.1815}, {165.762, 9.18243}, {165.765, 9.18317}, {165.768, 9.1837}, {
       165.771, 9.184}, {165.773, 9.18407}, {165.776, 9.1839}, {165.778, 
       9.18353}, {165.78, 9.18293}, {165.782, 9.1821}, {165.784, 9.18107}, {
       165.786, 9.17987}, {165.787, 9.17843}, {165.788, 9.17687}, {165.788, 
       9.17517}, {165.789, 9.1733}, {165.789, 9.17137}, {165.788, 9.1693}, {
       165.788, 9.1672}, {165.787, 9.16503}, {165.786, 9.16287}, {165.785, 
       9.1607}, {165.783, 9.15853}, {165.781, 9.15647}, {165.779, 9.15443}, {
       165.777, 9.15253}, {165.774, 9.15073}, {165.771, 9.14907}, {165.769, 
       9.14757}, {165.766, 9.14623}, {165.763, 9.14507}, {165.76, 9.14413}, {
       165.757, 9.1434}, {165.754, 9.14287}, {165.752, 9.14257}, {165.749, 
       9.1425}, {165.747, 9.14267}, {165.744, 9.14303}, {165.742, 9.14363}, {
       165.74, 9.14447}, {165.738, 9.1455}, {165.737, 9.1467}, {165.736, 
       9.14813}, {165.735, 9.1497}, {165.734, 9.1514}, {165.734, 9.15327}, {
       165.734, 9.1552}, {165.734, 9.15727}, {165.734, 9.15937}, {165.735, 
       9.16153}, {165.736, 9.1637}}, {{170.071, 9.11543}, {170.07, 9.1182}, {
       170.069, 9.12103}, {170.069, 9.12393}, {170.069, 9.1269}, {170.068, 
       9.12987}, {170.068, 9.1328}, {170.069, 9.1357}, {170.069, 9.13847}, {
       170.07, 9.14117}, {170.071, 9.14367}, {170.072, 9.14603}, {170.073, 
       9.14817}, {170.074, 9.1501}, {170.076, 9.15177}, {170.077, 9.15317}, {
       170.079, 9.1543}, {170.081, 9.15513}, {170.082, 9.15567}, {170.084, 
       9.1559}, {170.086, 9.1558}, {170.088, 9.15543}, {170.09, 9.15473}, {
       170.092, 9.15373}, {170.094, 9.15243}, {170.095, 9.1509}, {170.097, 
       9.14907}, {170.099, 9.14703}, {170.1, 9.14477}, {170.101, 9.14233}, {
       170.102, 9.13973}, {170.103, 9.13697}, {170.104, 9.13413}, {170.105, 
       9.1312}, {170.105, 9.12827}, {170.105, 9.1253}, {170.105, 9.12237}, {
       170.105, 9.11947}, {170.104, 9.1167}, {170.104, 9.114}, {170.103, 
       9.1115}, {170.102, 9.10913}, {170.101, 9.107}, {170.099, 9.10507}, {
       170.098, 9.1034}, {170.096, 9.102}, {170.095, 9.10087}, {170.093, 
       9.10003}, {170.091, 9.0995}, {170.089, 9.09927}, {170.087, 9.09937}, {
       170.085, 9.09973}, {170.083, 9.10043}, {170.081, 9.10143}, {170.08, 
       9.10273}, {170.078, 9.10427}, {170.076, 9.1061}, {170.075, 9.10813}, {
       170.073, 9.1104}, {170.072, 9.11283}, {170.071, 9.11543}}, {{171.12, 
       8.65603}, {171.118, 8.6582}, {171.117, 8.66047}, {171.116, 8.6628}, {
       171.114, 8.66523}, {171.113, 8.6677}, {171.113, 8.6702}, {171.112, 
       8.67267}, {171.112, 8.6751}, {171.112, 8.67747}, {171.112, 8.67973}, {
       171.113, 8.6819}, {171.114, 8.68393}, {171.115, 8.68577}, {171.116, 
       8.68743}, {171.117, 8.68893}, {171.119, 8.69017}, {171.121, 8.6912}, {
       171.123, 8.69197}, {171.125, 8.6925}, {171.127, 8.69277}, {171.129, 
       8.69277}, {171.132, 8.69253}, {171.134, 8.69203}, {171.136, 8.69127}, {
       171.139, 8.69027}, {171.141, 8.68903}, {171.143, 8.6876}, {171.145, 
       8.68593}, {171.147, 8.6841}, {171.149, 8.6821}, {171.151, 8.67993}, {
       171.153, 8.67767}, {171.154, 8.67533}, {171.155, 8.6729}, {171.156, 
       8.67043}, {171.157, 8.66793}, {171.157, 8.66547}, {171.157, 8.66303}, {
       171.157, 8.66067}, {171.157, 8.6584}, {171.157, 8.65623}, {171.156, 
       8.6542}, {171.155, 8.65237}, {171.154, 8.6507}, {171.152, 8.6492}, {
       171.15, 8.64797}, {171.149, 8.64693}, {171.147, 8.64617}, {171.145, 
       8.64563}, {171.142, 8.64537}, {171.14, 8.64537}, {171.138, 8.6456}, {
       171.136, 8.6461}, {171.133, 8.64687}, {171.131, 8.64787}, {171.129, 
       8.6491}, {171.126, 8.65053}, {171.124, 8.6522}, {171.122, 8.65403}, {
       171.12, 8.65603}}, {{165.113, 11.6934}, {165.113, 11.6961}, {165.113, 
       11.6988}, {165.113, 11.7016}, {165.114, 11.7044}, {165.114, 11.7072}, {
       165.115, 11.7099}, {165.116, 11.7125}, {165.117, 11.7151}, {165.119, 
       11.7175}, {165.12, 11.7197}, {165.122, 11.7218}, {165.123, 11.7237}, {
       165.125, 11.7253}, {165.127, 11.7267}, {165.129, 11.7278}, {165.131, 
       11.7287}, {165.133, 11.7292}, {165.135, 11.7295}, {165.137, 11.7295}, {
       165.139, 11.7292}, {165.141, 11.7286}, {165.143, 11.7277}, {165.145, 
       11.7266}, {165.146, 11.7252}, {165.148, 11.7235}, {165.149, 11.7217}, {
       165.15, 11.7196}, {165.151, 11.7173}, {165.152, 11.7149}, {165.152, 
       11.7123}, {165.152, 11.7097}, {165.152, 11.7069}, {165.152, 11.7042}, {
       165.152, 11.7014}, {165.151, 11.6986}, {165.15, 11.6959}, {165.149, 
       11.6932}, {165.148, 11.6907}, {165.147, 11.6883}, {165.145, 11.686}, {
       165.144, 11.684}, {165.142, 11.6821}, {165.14, 11.6805}, {165.138, 
       11.6791}, {165.136, 11.678}, {165.134, 11.6771}, {165.132, 11.6765}, {
       165.13, 11.6763}, {165.128, 11.6763}, {165.126, 11.6766}, {165.124, 
       11.6772}, {165.122, 11.678}, {165.121, 11.6792}, {165.119, 11.6806}, {
       165.118, 11.6822}, {165.116, 11.6841}, {165.115, 11.6862}, {165.114, 
       11.6885}, {165.114, 11.6909}, {165.113, 11.6934}}, {{167.577, 8.994}, {
       167.575, 8.99573}, {167.573, 8.9976}, {167.572, 8.99957}, {167.571, 
       9.0016}, {167.57, 9.0037}, {167.569, 9.00583}, {167.569, 9.00797}, {
       167.568, 9.0101}, {167.569, 9.01217}, {167.569, 9.0142}, {167.57, 
       9.01617}, {167.571, 9.01803}, {167.572, 9.01973}, {167.573, 9.02133}, {
       167.575, 9.02277}, {167.577, 9.024}, {167.579, 9.02507}, {167.581, 
       9.02593}, {167.584, 9.0266}, {167.586, 9.02703}, {167.589, 9.02727}, {
       167.591, 9.02727}, {167.594, 9.02703}, {167.597, 9.02657}, {167.599, 
       9.0259}, {167.602, 9.02503}, {167.604, 9.02397}, {167.607, 9.0227}, {
       167.609, 9.02127}, {167.611, 9.01967}, {167.613, 9.01793}, {167.614, 
       9.01607}, {167.616, 9.0141}, {167.617, 9.01207}, {167.618, 9.00997}, {
       167.618, 9.00783}, {167.619, 9.0057}, {167.619, 9.00357}, {167.619, 
       9.0015}, {167.618, 8.99947}, {167.618, 8.9975}, {167.617, 8.99563}, {
       167.615, 8.99393}, {167.614, 8.99233}, {167.612, 8.9909}, {167.61, 
       8.98967}, {167.608, 8.9886}, {167.606, 8.98773}, {167.604, 8.98707}, {
       167.601, 8.98663}, {167.599, 8.9864}, {167.596, 8.9864}, {167.593, 
       8.98663}, {167.591, 8.9871}, {167.588, 8.98777}, {167.586, 8.98863}, {
       167.583, 8.9897}, {167.581, 8.99097}, {167.579, 8.9924}, {167.577, 
       8.994}}, {{167.549, 11.3814}, {167.548, 11.3835}, {167.547, 11.3858}, {
       167.546, 11.3881}, {167.545, 11.3904}, {167.545, 11.3928}, {167.544, 
       11.3952}, {167.545, 11.3976}, {167.545, 11.3999}, {167.545, 11.4021}, {
       167.546, 11.4042}, {167.547, 11.4063}, {167.548, 11.4081}, {167.55, 
       11.4098}, {167.551, 11.4113}, {167.553, 11.4126}, {167.555, 11.4137}, {
       167.557, 11.4145}, {167.559, 11.4152}, {167.561, 11.4155}, {167.563, 
       11.4157}, {167.566, 11.4155}, {167.568, 11.4152}, {167.57, 11.4145}, {
       167.573, 11.4137}, {167.575, 11.4126}, {167.577, 11.4113}, {167.579, 
       11.4098}, {167.581, 11.4081}, {167.583, 11.4062}, {167.584, 11.4042}, {
       167.585, 11.4021}, {167.587, 11.3998}, {167.588, 11.3975}, {167.588, 
       11.3952}, {167.589, 11.3928}, {167.589, 11.3904}, {167.589, 11.388}, {
       167.589, 11.3857}, {167.588, 11.3835}, {167.587, 11.3814}, {167.586, 
       11.3793}, {167.585, 11.3775}, {167.584, 11.3758}, {167.582, 11.3743}, {
       167.581, 11.373}, {167.579, 11.3719}, {167.577, 11.3711}, {167.575, 
       11.3704}, {167.572, 11.3701}, {167.57, 11.3699}, {167.568, 11.3701}, {
       167.565, 11.3704}, {167.563, 11.3711}, {167.561, 11.3719}, {167.559, 
       11.373}, {167.556, 11.3743}, {167.554, 11.3758}, {167.553, 11.3775}, {
       167.551, 11.3794}, {167.549, 11.3814}}, {{167.061, 11.5147}, {167.06, 
       11.5168}, {167.06, 11.519}, {167.06, 11.5211}, {167.061, 11.5233}, {
       167.062, 11.5254}, {167.063, 11.5275}, {167.064, 11.5295}, {167.065, 
       11.5314}, {167.067, 11.5332}, {167.069, 11.5348}, {167.071, 11.5363}, {
       167.073, 11.5376}, {167.075, 11.5387}, {167.078, 11.5397}, {167.08, 
       11.5404}, {167.083, 11.5408}, {167.085, 11.5411}, {167.088, 11.5411}, {
       167.09, 11.5409}, {167.093, 11.5405}, {167.095, 11.5399}, {167.097, 
       11.539}, {167.1, 11.538}, {167.101, 11.5367}, {167.103, 11.5353}, {
       167.105, 11.5337}, {167.106, 11.5319}, {167.107, 11.5301}, {167.108, 
       11.5281}, {167.109, 11.526}, {167.109, 11.5239}, {167.109, 11.5218}, {
       167.109, 11.5196}, {167.108, 11.5174}, {167.108, 11.5153}, {167.107, 
       11.5132}, {167.105, 11.5112}, {167.104, 11.5093}, {167.102, 11.5075}, {
       167.1, 11.5059}, {167.098, 11.5044}, {167.096, 11.5031}, {167.094, 
       11.502}, {167.092, 11.5011}, {167.089, 11.5004}, {167.086, 11.4999}, {
       167.084, 11.4996}, {167.081, 11.4996}, {167.079, 11.4998}, {167.076, 
       11.5002}, {167.074, 11.5009}, {167.072, 11.5017}, {167.07, 11.5028}, {
       167.068, 11.504}, {167.066, 11.5055}, {167.064, 11.5071}, {167.063, 
       11.5088}, {167.062, 11.5107}, {167.061, 11.5126}, {167.061, 
       11.5147}}, {{168.222, 8.12717}, {168.221, 8.12843}, {168.22, 
       8.12987}, {168.219, 8.1314}, {168.219, 8.13307}, {168.219, 8.1348}, {
       168.219, 8.13663}, {168.22, 8.1385}, {168.221, 8.1404}, {168.222, 
       8.14233}, {168.224, 8.14423}, {168.226, 8.1461}, {168.228, 8.14793}, {
       168.23, 8.1497}, {168.232, 8.15137}, {168.235, 8.15293}, {168.238, 
       8.15437}, {168.241, 8.15567}, {168.244, 8.1568}, {168.247, 8.1578}, {
       168.25, 8.15857}, {168.253, 8.1592}, {168.257, 8.1596}, {168.26, 
       8.15983}, {168.262, 8.15983}, {168.265, 8.15967}, {168.268, 8.15927}, {
       168.27, 8.1587}, {168.272, 8.15793}, {168.274, 8.15697}, {168.276, 
       8.15587}, {168.277, 8.1546}, {168.278, 8.15317}, {168.279, 8.15163}, {
       168.279, 8.14997}, {168.279, 8.14823}, {168.279, 8.1464}, {168.278, 
       8.14453}, {168.277, 8.14263}, {168.276, 8.1407}, {168.274, 8.1388}, {
       168.272, 8.13693}, {168.27, 8.1351}, {168.268, 8.13333}, {168.266, 
       8.13167}, {168.263, 8.1301}, {168.26, 8.12867}, {168.257, 8.12737}, {
       168.254, 8.12623}, {168.251, 8.12523}, {168.248, 8.12447}, {168.245, 
       8.12383}, {168.241, 8.12343}, {168.238, 8.1232}, {168.236, 8.1232}, {
       168.233, 8.12337}, {168.23, 8.12377}, {168.228, 8.12433}, {168.226, 
       8.1251}, {168.224, 8.12607}, {168.222, 8.12717}}, {{167.714, 
       8.97953}, {167.713, 8.9814}, {167.713, 8.98337}, {167.712, 8.98533}, {
       167.712, 8.98733}, {167.713, 8.98933}, {167.713, 8.9913}, {167.714, 
       8.9932}, {167.715, 8.99507}, {167.716, 8.9968}, {167.718, 8.99847}, {
       167.72, 8.99997}, {167.722, 9.00133}, {167.724, 9.00253}, {167.726, 
       9.00357}, {167.729, 9.00443}, {167.731, 9.0051}, {167.734, 9.00553}, {
       167.737, 9.0058}, {167.74, 9.00583}, {167.742, 9.00567}, {167.745, 
       9.0053}, {167.748, 9.0047}, {167.75, 9.00393}, {167.752, 9.00297}, {
       167.755, 9.00183}, {167.757, 9.00053}, {167.759, 8.99907}, {167.76, 
       8.99747}, {167.762, 8.99577}, {167.763, 8.99393}, {167.764, 8.99207}, {
       167.764, 8.9901}, {167.765, 8.98813}, {167.765, 8.98613}, {167.764, 
       8.98413}, {167.764, 8.98217}, {167.763, 8.98027}, {167.762, 8.9784}, {
       167.761, 8.97667}, {167.759, 8.975}, {167.757, 8.9735}, {167.755, 
       8.97213}, {167.753, 8.97093}, {167.751, 8.9699}, {167.748, 8.96903}, {
       167.746, 8.96837}, {167.743, 8.96793}, {167.74, 8.96767}, {167.738, 
       8.96763}, {167.735, 8.9678}, {167.732, 8.96817}, {167.729, 8.96877}, {
       167.727, 8.96953}, {167.725, 8.9705}, {167.722, 8.97163}, {167.72, 
       8.97293}, {167.718, 8.9744}, {167.717, 8.976}, {167.715, 8.9777}, {
       167.714, 8.97953}}, {{167.491, 9.32833}, {167.488, 9.32977}, {167.486, 
       9.33133}, {167.484, 9.33303}, {167.481, 9.33487}, {167.479, 9.3368}, {
       167.478, 9.3388}, {167.476, 9.34083}, {167.475, 9.34293}, {167.474, 
       9.34503}, {167.473, 9.3471}, {167.473, 9.34913}, {167.473, 9.35113}, {
       167.473, 9.35303}, {167.473, 9.35483}, {167.474, 9.3565}, {167.475, 
       9.35807}, {167.476, 9.35943}, {167.478, 9.36063}, {167.48, 9.36167}, {
       167.482, 9.3625}, {167.484, 9.36313}, {167.486, 9.36353}, {167.489, 
       9.36373}, {167.491, 9.3637}, {167.494, 9.36343}, {167.497, 9.363}, {
       167.5, 9.36233}, {167.502, 9.36143}, {167.505, 9.36037}, {167.508, 
       9.35913}, {167.51, 9.3577}, {167.513, 9.35613}, {167.515, 9.35443}, {
       167.517, 9.3526}, {167.519, 9.35067}, {167.521, 9.34867}, {167.523, 
       9.34663}, {167.524, 9.34453}, {167.525, 9.34243}, {167.526, 9.34037}, {
       167.526, 9.33833}, {167.526, 9.33633}, {167.526, 9.33443}, {167.526, 
       9.33263}, {167.525, 9.33097}, {167.524, 9.3294}, {167.523, 9.32803}, {
       167.521, 9.32683}, {167.519, 9.3258}, {167.517, 9.32497}, {167.515, 
       9.32433}, {167.513, 9.32393}, {167.51, 9.32373}, {167.508, 9.32377}, {
       167.505, 9.32403}, {167.502, 9.32447}, {167.499, 9.32513}, {167.497, 
       9.32603}, {167.494, 9.3271}, {167.491, 9.32833}}, {{169.677, 
       11.1129}, {169.675, 11.1144}, {169.672, 11.116}, {169.67, 11.1177}, {
       169.667, 11.1195}, {169.665, 11.1215}, {169.663, 11.1235}, {169.662, 
       11.1256}, {169.66, 11.1277}, {169.659, 11.1298}, {169.659, 11.1319}, {
       169.658, 11.1339}, {169.658, 11.1359}, {169.658, 11.1378}, {169.658, 
       11.1396}, {169.659, 11.1413}, {169.66, 11.1429}, {169.661, 11.1442}, {
       169.662, 11.1454}, {169.664, 11.1465}, {169.666, 11.1473}, {169.668, 
       11.1479}, {169.67, 11.1483}, {169.673, 11.1485}, {169.676, 11.1484}, {
       169.678, 11.1482}, {169.681, 11.1477}, {169.684, 11.147}, {169.687, 
       11.1461}, {169.689, 11.145}, {169.692, 11.1437}, {169.695, 11.1423}, {
       169.697, 11.1407}, {169.7, 11.1389}, {169.702, 11.1371}, {169.704, 
       11.1352}, {169.706, 11.1331}, {169.708, 11.1311}, {169.709, 11.129}, {
       169.71, 11.1268}, {169.711, 11.1248}, {169.711, 11.1227}, {169.712, 
       11.1207}, {169.712, 11.1188}, {169.711, 11.117}, {169.711, 11.1153}, {
       169.71, 11.1138}, {169.709, 11.1124}, {169.707, 11.1112}, {169.705, 
       11.1102}, {169.703, 11.1093}, {169.701, 11.1087}, {169.699, 11.1083}, {
       169.697, 11.1082}, {169.694, 11.1082}, {169.691, 11.1085}, {169.688, 
       11.109}, {169.686, 11.1096}, {169.683, 11.1105}, {169.68, 11.1116}, {
       169.677, 11.1129}}, {{160.92, 9.75313}, {160.944, 9.75483}, {160.963, 
       9.73803}, {160.932, 9.72293}, {160.894, 9.72713}, {160.893, 9.7439}, {
       160.92, 9.75313}}, {{167.372, 9.224}, {167.372, 9.2262}, {167.372, 
       9.22843}, {167.373, 9.2307}, {167.373, 9.23293}, {167.374, 9.23513}, {
       167.375, 9.2373}, {167.376, 9.23937}, {167.378, 9.2413}, {167.38, 
       9.24313}, {167.381, 9.24483}, {167.383, 9.24637}, {167.386, 9.2477}, {
       167.388, 9.24887}, {167.39, 9.2498}, {167.393, 9.2505}, {167.395, 
       9.251}, {167.397, 9.25127}, {167.4, 9.25127}, {167.402, 9.25107}, {
       167.404, 9.25063}, {167.407, 9.24993}, {167.409, 9.24907}, {167.411, 
       9.24793}, {167.412, 9.24663}, {167.414, 9.24517}, {167.415, 9.2435}, {
       167.416, 9.2417}, {167.417, 9.23973}, {167.418, 9.2377}, {167.418, 
       9.23557}, {167.419, 9.23337}, {167.418, 9.23113}, {167.418, 9.22887}, {
       167.418, 9.22663}, {167.417, 9.22443}, {167.416, 9.22227}, {167.414, 
       9.2202}, {167.413, 9.21827}, {167.411, 9.21643}, {167.409, 9.21473}, {
       167.407, 9.2132}, {167.405, 9.21187}, {167.403, 9.2107}, {167.401, 
       9.20977}, {167.398, 9.20907}, {167.396, 9.20857}, {167.393, 9.2083}, {
       167.391, 9.2083}, {167.389, 9.2085}, {167.386, 9.20893}, {167.384, 
       9.20963}, {167.382, 9.2105}, {167.38, 9.21163}, {167.378, 9.21293}, {
       167.377, 9.2144}, {167.375, 9.21607}, {167.374, 9.21787}, {167.373, 
       9.21983}, {167.373, 9.22187}, {167.372, 9.224}}, {{165.179, 11.5497}, {
       165.18, 11.5519}, {165.181, 11.554}, {165.182, 11.5561}, {165.183, 
       11.5582}, {165.185, 11.5602}, {165.187, 11.5621}, {165.189, 11.5639}, {
       165.191, 11.5655}, {165.194, 11.567}, {165.196, 11.5683}, {165.199, 
       11.5694}, {165.201, 11.5703}, {165.204, 11.5711}, {165.206, 11.5716}, {
       165.209, 11.5718}, {165.212, 11.5719}, {165.214, 11.5717}, {165.216, 
       11.5713}, {165.219, 11.5707}, {165.221, 11.5699}, {165.222, 11.5688}, {
       165.224, 11.5676}, {165.226, 11.5662}, {165.227, 11.5646}, {165.228, 
       11.5629}, {165.228, 11.5611}, {165.229, 11.5591}, {165.229, 11.5571}, {
       165.229, 11.555}, {165.228, 11.5529}, {165.228, 11.5507}, {165.227, 
       11.5486}, {165.225, 11.5465}, {165.224, 11.5444}, {165.222, 11.5424}, {
       165.22, 11.5405}, {165.218, 11.5387}, {165.216, 11.5371}, {165.214, 
       11.5356}, {165.211, 11.5343}, {165.209, 11.5332}, {165.206, 11.5323}, {
       165.204, 11.5315}, {165.201, 11.531}, {165.198, 11.5308}, {165.196, 
       11.5307}, {165.193, 11.5309}, {165.191, 11.5313}, {165.189, 11.5319}, {
       165.187, 11.5327}, {165.185, 11.5338}, {165.183, 11.535}, {165.182, 
       11.5364}, {165.181, 11.538}, {165.18, 11.5397}, {165.179, 11.5415}, {
       165.179, 11.5435}, {165.179, 11.5455}, {165.179, 11.5476}, {165.179, 
       11.5497}}, {{165.304, 11.4696}, {165.303, 11.4709}, {165.302, 
       11.4723}, {165.301, 11.4738}, {165.301, 11.4754}, {165.301, 11.4771}, {
       165.301, 11.4789}, {165.302, 11.4808}, {165.303, 11.4827}, {165.304, 
       11.4846}, {165.306, 11.4865}, {165.308, 11.4884}, {165.31, 11.4902}, {
       165.312, 11.492}, {165.315, 11.4936}, {165.318, 11.4952}, {165.32, 
       11.4967}, {165.323, 11.498}, {165.327, 11.4991}, {165.33, 11.5001}, {
       165.333, 11.5009}, {165.336, 11.5016}, {165.339, 11.502}, {165.342, 
       11.5022}, {165.345, 11.5023}, {165.348, 11.5021}, {165.35, 11.5018}, {
       165.353, 11.5012}, {165.355, 11.5005}, {165.356, 11.4996}, {165.358, 
       11.4985}, {165.359, 11.4973}, {165.36, 11.4959}, {165.361, 11.4944}, {
       165.361, 11.4927}, {165.361, 11.491}, {165.361, 11.4892}, {165.36, 
       11.4873}, {165.359, 11.4854}, {165.358, 11.4835}, {165.356, 11.4816}, {
       165.354, 11.4798}, {165.352, 11.4779}, {165.35, 11.4762}, {165.347, 
       11.4745}, {165.344, 11.4729}, {165.341, 11.4715}, {165.338, 11.4702}, {
       165.335, 11.469}, {165.332, 11.468}, {165.329, 11.4672}, {165.326, 
       11.4666}, {165.323, 11.4661}, {165.32, 11.4659}, {165.317, 11.4658}, {
       165.314, 11.466}, {165.312, 11.4664}, {165.309, 11.4669}, {165.307, 
       11.4676}, {165.305, 11.4685}, {165.304, 11.4696}}, {{169.231, 
       9.88257}, {169.228, 9.88387}, {169.226, 9.88533}, {169.224, 9.88693}, {
       169.221, 9.88867}, {169.219, 9.8905}, {169.218, 9.8924}, {169.216, 
       9.89437}, {169.215, 9.8964}, {169.214, 9.89843}, {169.213, 9.90043}, {
       169.213, 9.90243}, {169.212, 9.9044}, {169.213, 9.90627}, {169.213, 
       9.90807}, {169.214, 9.90977}, {169.215, 9.9113}, {169.216, 9.9127}, {
       169.218, 9.91397}, {169.219, 9.91503}, {169.221, 9.91593}, {169.224, 
       9.9166}, {169.226, 9.9171}, {169.228, 9.91737}, {169.231, 9.91743}, {
       169.234, 9.9173}, {169.237, 9.91693}, {169.239, 9.91637}, {169.242, 
       9.9156}, {169.245, 9.91463}, {169.248, 9.9135}, {169.25, 9.9122}, {
       169.253, 9.91073}, {169.255, 9.90913}, {169.257, 9.9074}, {169.259, 
       9.90557}, {169.261, 9.90367}, {169.263, 9.9017}, {169.264, 9.89967}, {
       169.265, 9.89763}, {169.266, 9.89563}, {169.266, 9.89363}, {169.266, 
       9.89167}, {169.266, 9.8898}, {169.266, 9.888}, {169.265, 9.8863}, {
       169.264, 9.88477}, {169.263, 9.88337}, {169.261, 9.8821}, {169.259, 
       9.88103}, {169.257, 9.88013}, {169.255, 9.87947}, {169.253, 9.87897}, {
       169.25, 9.8787}, {169.248, 9.87863}, {169.245, 9.87877}, {169.242, 
       9.87913}, {169.239, 9.8797}, {169.237, 9.88047}, {169.234, 9.88143}, {
       169.231, 9.88257}}, {{171.295, 8.80183}, {171.293, 8.80377}, {171.292, 
       8.80583}, {171.291, 8.80793}, {171.291, 8.81013}, {171.29, 8.81233}, {
       171.29, 8.81453}, {171.29, 8.8167}, {171.29, 8.81887}, {171.291, 
       8.82093}, {171.292, 8.8229}, {171.293, 8.82477}, {171.294, 8.8265}, {
       171.296, 8.82807}, {171.298, 8.8295}, {171.299, 8.8307}, {171.302, 
       8.83173}, {171.304, 8.83257}, {171.306, 8.83317}, {171.308, 8.83353}, {
       171.311, 8.83367}, {171.313, 8.8336}, {171.316, 8.83327}, {171.318, 
       8.83273}, {171.32, 8.83197}, {171.323, 8.831}, {171.325, 8.8298}, {
       171.327, 8.82843}, {171.329, 8.8269}, {171.331, 8.8252}, {171.332, 
       8.82337}, {171.334, 8.82143}, {171.335, 8.81937}, {171.336, 8.81727}, {
       171.336, 8.81507}, {171.337, 8.81287}, {171.337, 8.81067}, {171.337, 
       8.8085}, {171.336, 8.80633}, {171.336, 8.80427}, {171.335, 8.8023}, {
       171.334, 8.80043}, {171.333, 8.7987}, {171.331, 8.79713}, {171.329, 
       8.7957}, {171.327, 8.7945}, {171.325, 8.79347}, {171.323, 8.79263}, {
       171.321, 8.79203}, {171.319, 8.79167}, {171.316, 8.79153}, {171.314, 
       8.7916}, {171.311, 8.79193}, {171.309, 8.79247}, {171.306, 8.79323}, {
       171.304, 8.7942}, {171.302, 8.7954}, {171.3, 8.79677}, {171.298, 
       8.7983}, {171.296, 8.8}, {171.295, 8.80183}}, {{166.008, 10.1046}, {
       166.005, 10.1039}, {166.002, 10.1034}, {165.999, 10.1031}, {165.997, 
       10.103}, {165.994, 10.1031}, {165.991, 10.1034}, {165.988, 10.1039}, {
       165.985, 10.1046}, {165.983, 10.1055}, {165.981, 10.1065}, {165.978, 
       10.1077}, {165.976, 10.109}, {165.975, 10.1105}, {165.973, 10.1121}, {
       165.972, 10.1138}, {165.971, 10.1155}, {165.97, 10.1174}, {165.97, 
       10.1192}, {165.969, 10.1211}, {165.97, 10.123}, {165.97, 10.1249}, {
       165.971, 10.1267}, {165.972, 10.1285}, {165.973, 10.1302}, {165.975, 
       10.1317}, {165.976, 10.1332}, {165.978, 10.1345}, {165.981, 10.1357}, {
       165.983, 10.1368}, {165.985, 10.1376}, {165.988, 10.1383}, {165.991, 
       10.1388}, {165.994, 10.1391}, {165.997, 10.1392}, {165.999, 10.1391}, {
       166.002, 10.1388}, {166.005, 10.1383}, {166.008, 10.1376}, {166.01, 
       10.1368}, {166.012, 10.1357}, {166.015, 10.1345}, {166.017, 10.1332}, {
       166.018, 10.1317}, {166.02, 10.1302}, {166.021, 10.1285}, {166.022, 
       10.1267}, {166.023, 10.1249}, {166.023, 10.123}, {166.024, 10.1211}, {
       166.023, 10.1192}, {166.023, 10.1174}, {166.022, 10.1155}, {166.021, 
       10.1138}, {166.02, 10.1121}, {166.018, 10.1105}, {166.017, 10.109}, {
       166.015, 10.1077}, {166.012, 10.1065}, {166.01, 10.1055}, {166.008, 
       10.1046}}, {{171.385, 8.59713}, {171.385, 8.5992}, {171.384, 
       8.60133}, {171.384, 8.6035}, {171.384, 8.60567}, {171.385, 8.60783}, {
       171.385, 8.60993}, {171.386, 8.612}, {171.387, 8.61397}, {171.389, 
       8.61587}, {171.39, 8.6176}, {171.392, 8.6192}, {171.394, 8.62067}, {
       171.396, 8.62193}, {171.398, 8.623}, {171.4, 8.62387}, {171.403, 
       8.62453}, {171.405, 8.62497}, {171.408, 8.62517}, {171.41, 8.62517}, {
       171.412, 8.62493}, {171.415, 8.62447}, {171.417, 8.6238}, {171.419, 
       8.6229}, {171.421, 8.6218}, {171.423, 8.6205}, {171.425, 8.61903}, {
       171.427, 8.61743}, {171.428, 8.61567}, {171.429, 8.61377}, {171.43, 
       8.6118}, {171.431, 8.60973}, {171.431, 8.6076}, {171.431, 8.60543}, {
       171.431, 8.60327}, {171.431, 8.6011}, {171.43, 8.599}, {171.429, 
       8.59693}, {171.428, 8.59497}, {171.427, 8.59307}, {171.425, 8.59133}, {
       171.423, 8.58973}, {171.421, 8.58827}, {171.419, 8.587}, {171.417, 
       8.58593}, {171.415, 8.58507}, {171.413, 8.5844}, {171.41, 8.58397}, {
       171.408, 8.58377}, {171.405, 8.58377}, {171.403, 8.584}, {171.4, 
       8.58447}, {171.398, 8.58513}, {171.396, 8.58603}, {171.394, 8.58713}, {
       171.392, 8.58843}, {171.39, 8.5899}, {171.389, 8.5915}, {171.387, 
       8.59327}, {171.386, 8.59517}, {171.385, 8.59713}}, {{171.588, 
       6.0375}, {171.585, 6.03997}, {171.582, 6.0426}, {171.58, 6.04533}, {
       171.577, 6.04817}, {171.575, 6.05103}, {171.573, 6.05393}, {171.571, 
       6.05683}, {171.569, 6.0597}, {171.568, 6.06247}, {171.567, 6.06517}, {
       171.566, 6.0677}, {171.565, 6.0701}, {171.565, 6.0723}, {171.564, 
       6.0743}, {171.565, 6.07603}, {171.565, 6.07757}, {171.566, 6.0788}, {
       171.567, 6.07977}, {171.568, 6.08043}, {171.57, 6.0808}, {171.571, 
       6.08087}, {171.573, 6.08063}, {171.576, 6.0801}, {171.578, 6.07927}, {
       171.58, 6.07817}, {171.583, 6.07677}, {171.586, 6.0751}, {171.588, 
       6.07323}, {171.591, 6.0711}, {171.594, 6.0688}, {171.597, 6.06633}, {
       171.599, 6.0637}, {171.602, 6.06097}, {171.604, 6.05813}, {171.607, 
       6.05527}, {171.609, 6.05237}, {171.611, 6.04947}, {171.612, 6.0466}, {
       171.614, 6.04383}, {171.615, 6.04113}, {171.616, 6.0386}, {171.617, 
       6.0362}, {171.617, 6.034}, {171.617, 6.032}, {171.617, 6.03027}, {
       171.616, 6.02873}, {171.616, 6.0275}, {171.615, 6.02653}, {171.613, 
       6.02587}, {171.612, 6.0255}, {171.61, 6.02543}, {171.608, 6.02567}, {
       171.606, 6.0262}, {171.604, 6.02703}, {171.601, 6.02813}, {171.598, 
       6.02953}, {171.596, 6.0312}, {171.593, 6.03307}, {171.59, 6.0352}, {
       171.588, 6.0375}}, {{167.766, 8.7829}, {167.763, 8.78443}, {167.761, 
       8.7861}, {167.759, 8.78787}, {167.757, 8.78973}, {167.756, 8.79173}, {
       167.754, 8.79373}, {167.753, 8.79583}, {167.752, 8.7979}, {167.751, 
       8.8}, {167.751, 8.80203}, {167.751, 8.80403}, {167.751, 8.80597}, {
       167.752, 8.8078}, {167.752, 8.80953}, {167.753, 8.8111}, {167.755, 
       8.81253}, {167.756, 8.8138}, {167.758, 8.8149}, {167.76, 8.8158}, {
       167.762, 8.8165}, {167.764, 8.81697}, {167.766, 8.81727}, {167.769, 
       8.8173}, {167.771, 8.81713}, {167.774, 8.81677}, {167.777, 8.81617}, {
       167.779, 8.81537}, {167.782, 8.81437}, {167.784, 8.81317}, {167.787, 
       8.81183}, {167.789, 8.8103}, {167.791, 8.80863}, {167.793, 8.80687}, {
       167.795, 8.805}, {167.797, 8.803}, {167.798, 8.801}, {167.799, 
       8.7989}, {167.8, 8.79683}, {167.801, 8.79473}, {167.801, 8.7927}, {
       167.801, 8.7907}, {167.801, 8.78877}, {167.801, 8.78693}, {167.8, 
       8.7852}, {167.799, 8.78363}, {167.798, 8.7822}, {167.796, 8.78093}, {
       167.795, 8.77983}, {167.793, 8.77893}, {167.791, 8.77823}, {167.789, 
       8.77777}, {167.786, 8.77747}, {167.784, 8.77743}, {167.781, 8.7776}, {
       167.778, 8.77797}, {167.776, 8.77857}, {167.773, 8.77937}, {167.771, 
       8.78037}, {167.768, 8.78157}, {167.766, 8.7829}}, {{170.164, 
       12.3085}, {170.161, 12.314}, {170.168, 12.3187}, {170.204, 12.3382}, {
       170.225, 12.3382}, {170.233, 12.3233}, {170.215, 12.3094}, {170.186, 
       12.3057}, {170.164, 12.3085}}, {{162.224, 11.6768}, {162.237, 
       11.6819}, {162.28, 11.6706}, {162.289, 11.6552}, {162.272, 11.6439}, {
       162.231, 11.6583}, {162.224, 11.6768}}, {{167.75, 8.8852}, {167.75, 
       8.88737}, {167.75, 8.88957}, {167.75, 8.89177}, {167.751, 8.894}, {
       167.752, 8.8962}, {167.752, 8.89833}, {167.754, 8.9004}, {167.755, 
       8.90237}, {167.756, 8.90423}, {167.758, 8.90593}, {167.76, 8.9075}, {
       167.762, 8.90887}, {167.764, 8.91007}, {167.766, 8.91103}, {167.769, 
       8.91183}, {167.771, 8.91237}, {167.773, 8.9127}, {167.775, 8.91277}, {
       167.778, 8.91263}, {167.78, 8.91227}, {167.782, 8.91167}, {167.784, 
       8.91083}, {167.786, 8.9098}, {167.788, 8.90857}, {167.789, 8.90713}, {
       167.791, 8.90553}, {167.792, 8.9038}, {167.793, 8.90193}, {167.793, 
       8.89993}, {167.794, 8.89783}, {167.794, 8.89567}, {167.794, 8.89347}, {
       167.794, 8.89127}, {167.794, 8.88903}, {167.793, 8.88683}, {167.792, 
       8.8847}, {167.791, 8.88263}, {167.789, 8.88067}, {167.788, 8.8788}, {
       167.786, 8.8771}, {167.784, 8.87553}, {167.782, 8.87417}, {167.78, 
       8.87297}, {167.778, 8.872}, {167.776, 8.8712}, {167.774, 8.87067}, {
       167.771, 8.87033}, {167.769, 8.87027}, {167.767, 8.8704}, {167.764, 
       8.87077}, {167.762, 8.87137}, {167.76, 8.8722}, {167.758, 8.87323}, {
       167.757, 8.87447}, {167.755, 8.8759}, {167.754, 8.8775}, {167.753, 
       8.87923}, {167.752, 8.8811}, {167.751, 8.8831}, {167.75, 8.8852}}, {{
       167.561, 11.4903}, {167.561, 11.4926}, {167.56, 11.4949}, {167.56, 
       11.4972}, {167.56, 11.4996}, {167.561, 11.5019}, {167.561, 11.5042}, {
       167.562, 11.5065}, {167.563, 11.5086}, {167.565, 11.5107}, {167.566, 
       11.5126}, {167.567, 11.5144}, {167.569, 11.5159}, {167.571, 11.5173}, {
       167.573, 11.5185}, {167.575, 11.5195}, {167.577, 11.5202}, {167.579, 
       11.5207}, {167.581, 11.521}, {167.584, 11.521}, {167.586, 11.5208}, {
       167.588, 11.5203}, {167.59, 11.5196}, {167.592, 11.5186}, {167.593, 
       11.5175}, {167.595, 11.5161}, {167.597, 11.5145}, {167.598, 11.5128}, {
       167.599, 11.5109}, {167.6, 11.5088}, {167.601, 11.5067}, {167.601, 
       11.5045}, {167.602, 11.5022}, {167.602, 11.4998}, {167.601, 11.4975}, {
       167.601, 11.4951}, {167.6, 11.4928}, {167.6, 11.4906}, {167.599, 
       11.4884}, {167.597, 11.4864}, {167.596, 11.4844}, {167.594, 11.4827}, {
       167.593, 11.4811}, {167.591, 11.4797}, {167.589, 11.4785}, {167.587, 
       11.4775}, {167.585, 11.4768}, {167.583, 11.4763}, {167.58, 11.476}, {
       167.578, 11.476}, {167.576, 11.4763}, {167.574, 11.4767}, {167.572, 
       11.4775}, {167.57, 11.4784}, {167.568, 11.4796}, {167.567, 11.481}, {
       167.565, 11.4825}, {167.564, 11.4843}, {167.563, 11.4862}, {167.562, 
       11.4882}, {167.561, 11.4903}}, {{171.773, 6.14213}, {171.772, 
       6.14383}, {171.771, 6.14563}, {171.77, 6.14753}, {171.769, 6.14943}, {
       171.769, 6.1514}, {171.769, 6.15337}, {171.769, 6.1553}, {171.769, 
       6.15723}, {171.77, 6.1591}, {171.771, 6.16087}, {171.772, 6.16257}, {
       171.774, 6.16413}, {171.775, 6.16557}, {171.777, 6.16687}, {171.779, 
       6.168}, {171.781, 6.16897}, {171.784, 6.16977}, {171.786, 6.17033}, {
       171.789, 6.17073}, {171.791, 6.17093}, {171.794, 6.1709}, {171.796, 
       6.17067}, {171.799, 6.17023}, {171.801, 6.16963}, {171.804, 6.1688}, {
       171.806, 6.1678}, {171.808, 6.16663}, {171.81, 6.1653}, {171.812, 
       6.16383}, {171.814, 6.16223}, {171.815, 6.16053}, {171.816, 6.15873}, {
       171.817, 6.15683}, {171.818, 6.15493}, {171.818, 6.15297}, {171.818, 
       6.151}, {171.818, 6.14907}, {171.817, 6.14713}, {171.817, 6.14527}, {
       171.816, 6.1435}, {171.815, 6.1418}, {171.813, 6.14023}, {171.811, 
       6.1388}, {171.81, 6.1375}, {171.808, 6.13637}, {171.805, 6.1354}, {
       171.803, 6.1346}, {171.801, 6.13403}, {171.798, 6.13363}, {171.796, 
       6.13343}, {171.793, 6.13347}, {171.79, 6.1337}, {171.788, 6.13413}, {
       171.785, 6.13473}, {171.783, 6.13557}, {171.781, 6.13657}, {171.779, 
       6.13773}, {171.777, 6.13907}, {171.775, 6.14053}, {171.773, 
       6.14213}}, {{170.788, 10.1108}, {170.788, 10.113}, {170.787, 
       10.1154}, {170.787, 10.1177}, {170.787, 10.1202}, {170.787, 10.1226}, {
       170.787, 10.125}, {170.788, 10.1273}, {170.788, 10.1296}, {170.789, 
       10.1317}, {170.79, 10.1338}, {170.792, 10.1356}, {170.793, 10.1374}, {
       170.795, 10.1389}, {170.797, 10.1402}, {170.798, 10.1413}, {170.8, 
       10.1422}, {170.802, 10.1428}, {170.804, 10.1432}, {170.807, 10.1433}, {
       170.809, 10.1432}, {170.811, 10.1428}, {170.813, 10.1422}, {170.815, 
       10.1413}, {170.816, 10.1402}, {170.818, 10.1389}, {170.82, 10.1374}, {
       170.821, 10.1356}, {170.823, 10.1338}, {170.824, 10.1317}, {170.825, 
       10.1296}, {170.825, 10.1273}, {170.826, 10.125}, {170.826, 10.1226}, {
       170.826, 10.1202}, {170.826, 10.1177}, {170.826, 10.1154}, {170.825, 
       10.113}, {170.825, 10.1108}, {170.824, 10.1086}, {170.823, 10.1066}, {
       170.821, 10.1047}, {170.82, 10.103}, {170.818, 10.1015}, {170.816, 
       10.1001}, {170.815, 10.099}, {170.813, 10.0982}, {170.811, 10.0975}, {
       170.809, 10.0972}, {170.807, 10.097}, {170.804, 10.0972}, {170.802, 
       10.0975}, {170.8, 10.0982}, {170.798, 10.099}, {170.797, 10.1001}, {
       170.795, 10.1015}, {170.793, 10.103}, {170.792, 10.1047}, {170.79, 
       10.1066}, {170.789, 10.1086}, {170.788, 10.1108}}, {{165.371, 
       11.7131}, {165.372, 11.7153}, {165.372, 11.7175}, {165.373, 11.7197}, {
       165.375, 11.7218}, {165.376, 11.7239}, {165.378, 11.7259}, {165.38, 
       11.7278}, {165.382, 11.7296}, {165.384, 11.7312}, {165.386, 11.7327}, {
       165.388, 11.734}, {165.391, 11.7351}, {165.393, 11.736}, {165.395, 
       11.7367}, {165.398, 11.7372}, {165.4, 11.7374}, {165.402, 11.7374}, {
       165.405, 11.7372}, {165.407, 11.7367}, {165.409, 11.736}, {165.41, 
       11.7351}, {165.412, 11.734}, {165.413, 11.7327}, {165.415, 11.7313}, {
       165.416, 11.7296}, {165.416, 11.7279}, {165.417, 11.726}, {165.417, 
       11.7239}, {165.417, 11.7219}, {165.417, 11.7197}, {165.416, 11.7175}, {
       165.415, 11.7153}, {165.414, 11.7131}, {165.413, 11.711}, {165.412, 
       11.7089}, {165.41, 11.7069}, {165.408, 11.705}, {165.406, 11.7032}, {
       165.404, 11.7016}, {165.402, 11.7001}, {165.4, 11.6988}, {165.397, 
       11.6977}, {165.395, 11.6968}, {165.392, 11.6961}, {165.39, 11.6956}, {
       165.388, 11.6954}, {165.385, 11.6954}, {165.383, 11.6956}, {165.381, 
       11.6961}, {165.379, 11.6968}, {165.377, 11.6977}, {165.376, 11.6988}, {
       165.374, 11.7001}, {165.373, 11.7015}, {165.372, 11.7032}, {165.371, 
       11.7049}, {165.371, 11.7068}, {165.371, 11.7089}, {165.371, 11.7109}, {
       165.371, 11.7131}}, {{169.608, 11.1682}, {169.606, 11.1694}, {169.604, 
       11.1708}, {169.602, 11.1723}, {169.6, 11.1739}, {169.598, 11.1756}, {
       169.596, 11.1774}, {169.595, 11.1792}, {169.594, 11.1811}, {169.593, 
       11.1831}, {169.593, 11.185}, {169.592, 11.1869}, {169.592, 11.1887}, {
       169.593, 11.1905}, {169.593, 11.1922}, {169.594, 11.1939}, {169.595, 
       11.1954}, {169.597, 11.1967}, {169.598, 11.1979}, {169.6, 11.199}, {
       169.602, 11.1999}, {169.605, 11.2006}, {169.607, 11.2011}, {169.609, 
       11.2014}, {169.612, 11.2015}, {169.615, 11.2014}, {169.617, 11.2011}, {
       169.62, 11.2006}, {169.623, 11.2}, {169.625, 11.1991}, {169.628, 
       11.1981}, {169.63, 11.1969}, {169.633, 11.1955}, {169.635, 11.194}, {
       169.637, 11.1924}, {169.638, 11.1907}, {169.64, 11.1889}, {169.641, 
       11.1871}, {169.642, 11.1852}, {169.643, 11.1832}, {169.644, 11.1813}, {
       169.644, 11.1794}, {169.644, 11.1776}, {169.643, 11.1758}, {169.643, 
       11.1741}, {169.642, 11.1724}, {169.641, 11.1709}, {169.639, 11.1696}, {
       169.638, 11.1684}, {169.636, 11.1673}, {169.634, 11.1664}, {169.632, 
       11.1657}, {169.629, 11.1652}, {169.627, 11.1649}, {169.624, 11.1648}, {
       169.622, 11.1649}, {169.619, 11.1652}, {169.616, 11.1657}, {169.614, 
       11.1663}, {169.611, 11.1672}, {169.608, 11.1682}}, {{169.521, 
       11.1362}, {169.52, 11.1382}, {169.519, 11.1403}, {169.519, 11.1424}, {
       169.519, 11.1445}, {169.519, 11.1466}, {169.519, 11.1488}, {169.52, 
       11.1508}, {169.521, 11.1528}, {169.522, 11.1547}, {169.523, 11.1565}, {
       169.525, 11.1581}, {169.526, 11.1596}, {169.528, 11.161}, {169.53, 
       11.1621}, {169.532, 11.1631}, {169.535, 11.1638}, {169.537, 11.1644}, {
       169.539, 11.1647}, {169.541, 11.1648}, {169.544, 11.1647}, {169.546, 
       11.1643}, {169.548, 11.1638}, {169.551, 11.163}, {169.553, 11.162}, {
       169.555, 11.1608}, {169.556, 11.1595}, {169.558, 11.1579}, {169.559, 
       11.1563}, {169.561, 11.1545}, {169.562, 11.1525}, {169.563, 11.1505}, {
       169.563, 11.1485}, {169.563, 11.1464}, {169.564, 11.1442}, {169.563, 
       11.1421}, {169.563, 11.14}, {169.562, 11.1379}, {169.561, 11.1359}, {
       169.56, 11.134}, {169.559, 11.1322}, {169.558, 11.1306}, {169.556, 
       11.1291}, {169.554, 11.1278}, {169.552, 11.1266}, {169.55, 11.1256}, {
       169.548, 11.1249}, {169.546, 11.1243}, {169.543, 11.124}, {169.541, 
       11.1239}, {169.539, 11.1241}, {169.536, 11.1244}, {169.534, 11.125}, {
       169.532, 11.1258}, {169.53, 11.1267}, {169.528, 11.1279}, {169.526, 
       11.1293}, {169.524, 11.1308}, {169.523, 11.1325}, {169.522, 11.1343}, {
       169.521, 11.1362}}, {{169.406, 6.1795}, {169.405, 6.1815}, {169.405, 
       6.1836}, {169.405, 6.1857}, {169.405, 6.18787}, {169.405, 6.19}, {
       169.405, 6.19213}, {169.406, 6.1942}, {169.407, 6.1962}, {169.408, 
       6.1981}, {169.409, 6.19987}, {169.411, 6.20153}, {169.412, 6.20303}, {
       169.414, 6.20437}, {169.416, 6.2055}, {169.418, 6.20647}, {169.42, 
       6.2072}, {169.423, 6.20773}, {169.425, 6.20803}, {169.427, 6.20813}, {
       169.43, 6.208}, {169.432, 6.20763}, {169.434, 6.20703}, {169.436, 
       6.20627}, {169.438, 6.20527}, {169.44, 6.20407}, {169.442, 6.20267}, {
       169.444, 6.20113}, {169.445, 6.19947}, {169.446, 6.19763}, {169.447, 
       6.1957}, {169.448, 6.1937}, {169.449, 6.1916}, {169.449, 6.1895}, {
       169.449, 6.18733}, {169.449, 6.1852}, {169.448, 6.18307}, {169.448, 
       6.181}, {169.447, 6.179}, {169.446, 6.1771}, {169.444, 6.17533}, {
       169.443, 6.17367}, {169.441, 6.17217}, {169.439, 6.17083}, {169.437, 
       6.1697}, {169.435, 6.16873}, {169.433, 6.168}, {169.431, 6.16747}, {
       169.428, 6.16717}, {169.426, 6.16707}, {169.424, 6.1672}, {169.422, 
       6.16757}, {169.419, 6.16817}, {169.417, 6.16893}, {169.415, 6.16993}, {
       169.413, 6.17113}, {169.411, 6.17253}, {169.41, 6.17407}, {169.408, 
       6.17573}, {169.407, 6.17757}, {169.406, 6.1795}}, {{167.479, 
       9.03863}, {167.477, 9.0401}, {167.474, 9.04173}, {167.472, 9.04347}, {
       167.47, 9.0453}, {167.468, 9.04723}, {167.466, 9.04923}, {167.464, 
       9.0513}, {167.463, 9.05337}, {167.461, 9.05543}, {167.461, 9.0575}, {
       167.46, 9.0595}, {167.46, 9.06143}, {167.46, 9.0633}, {167.46, 
       9.06503}, {167.46, 9.06663}, {167.461, 9.0681}, {167.462, 9.06943}, {
       167.463, 9.07057}, {167.465, 9.0715}, {167.467, 9.07223}, {167.469, 
       9.0728}, {167.471, 9.0731}, {167.473, 9.07323}, {167.476, 9.07313}, {
       167.478, 9.0728}, {167.481, 9.07227}, {167.484, 9.07153}, {167.486, 
       9.0706}, {167.489, 9.06947}, {167.492, 9.06817}, {167.494, 9.0667}, {
       167.497, 9.06507}, {167.499, 9.06333}, {167.502, 9.0615}, {167.504, 
       9.05957}, {167.506, 9.05757}, {167.507, 9.0555}, {167.509, 9.05343}, {
       167.51, 9.05137}, {167.511, 9.0493}, {167.511, 9.0473}, {167.512, 
       9.04537}, {167.512, 9.0435}, {167.511, 9.04177}, {167.511, 9.04017}, {
       167.51, 9.0387}, {167.509, 9.03737}, {167.508, 9.03623}, {167.506, 
       9.0353}, {167.504, 9.03457}, {167.502, 9.034}, {167.5, 9.0337}, {
       167.498, 9.03357}, {167.495, 9.03367}, {167.493, 9.034}, {167.49, 
       9.03453}, {167.488, 9.03527}, {167.485, 9.0362}, {167.482, 9.03733}, {
       167.479, 9.03863}}, {{169.102, 9.91563}, {169.1, 9.9172}, {169.097, 
       9.91893}, {169.095, 9.9208}, {169.092, 9.92273}, {169.09, 9.92477}, {
       169.088, 9.92687}, {169.087, 9.929}, {169.085, 9.93117}, {169.084, 
       9.9333}, {169.083, 9.9354}, {169.082, 9.93743}, {169.082, 9.9394}, {
       169.082, 9.94127}, {169.082, 9.94303}, {169.082, 9.94463}, {169.083, 
       9.94607}, {169.084, 9.94737}, {169.085, 9.94843}, {169.087, 9.94933}, {
       169.089, 9.95}, {169.091, 9.95047}, {169.093, 9.95073}, {169.095, 
       9.95073}, {169.098, 9.95053}, {169.1, 9.9501}, {169.103, 9.94947}, {
       169.105, 9.9486}, {169.108, 9.94753}, {169.111, 9.9463}, {169.113, 
       9.94487}, {169.116, 9.9433}, {169.119, 9.94157}, {169.121, 9.9397}, {
       169.123, 9.93777}, {169.125, 9.93573}, {169.127, 9.93363}, {169.129, 
       9.9315}, {169.13, 9.92933}, {169.132, 9.9272}, {169.133, 9.9251}, {
       169.133, 9.92307}, {169.134, 9.9211}, {169.134, 9.91923}, {169.134, 
       9.91747}, {169.133, 9.91587}, {169.132, 9.91443}, {169.131, 9.91313}, {
       169.13, 9.91207}, {169.129, 9.91117}, {169.127, 9.9105}, {169.125, 
       9.91003}, {169.123, 9.90977}, {169.121, 9.90977}, {169.118, 9.90997}, {
       169.116, 9.9104}, {169.113, 9.91103}, {169.11, 9.9119}, {169.108, 
       9.91297}, {169.105, 9.9142}, {169.102, 9.91563}}, {{168.597, 4.6565}, {
       168.598, 4.65883}, {168.599, 4.66117}, {168.6, 4.6635}, {168.602, 
       4.66577}, {168.604, 4.66803}, {168.606, 4.67017}, {168.608, 4.6722}, {
       168.61, 4.67413}, {168.612, 4.67587}, {168.614, 4.67747}, {168.617, 
       4.67887}, {168.619, 4.68007}, {168.622, 4.68107}, {168.624, 4.6818}, {
       168.626, 4.68233}, {168.629, 4.6826}, {168.631, 4.68263}, {168.633, 
       4.68243}, {168.635, 4.68197}, {168.636, 4.68127}, {168.638, 4.68037}, {
       168.639, 4.6792}, {168.64, 4.67787}, {168.641, 4.67633}, {168.641, 
       4.6746}, {168.642, 4.67273}, {168.642, 4.67073}, {168.641, 4.6686}, {
       168.641, 4.6664}, {168.64, 4.6641}, {168.639, 4.66177}, {168.638, 
       4.65943}, {168.637, 4.6571}, {168.635, 4.6548}, {168.633, 4.65257}, {
       168.631, 4.65043}, {168.629, 4.6484}, {168.627, 4.64647}, {168.625, 
       4.64473}, {168.623, 4.64313}, {168.62, 4.64173}, {168.618, 4.64053}, {
       168.615, 4.63953}, {168.613, 4.6388}, {168.611, 4.63827}, {168.608, 
       4.638}, {168.606, 4.63797}, {168.604, 4.63817}, {168.602, 4.63863}, {
       168.601, 4.63933}, {168.599, 4.64023}, {168.598, 4.6414}, {168.597, 
       4.64273}, {168.596, 4.64427}, {168.596, 4.646}, {168.595, 4.64787}, {
       168.595, 4.64987}, {168.596, 4.652}, {168.596, 4.6542}, {168.597, 
       4.6565}}, {{169.907, 10.1251}, {169.907, 10.127}, {169.907, 10.1289}, {
       169.908, 10.1307}, {169.908, 10.1325}, {169.909, 10.1343}, {169.911, 
       10.136}, {169.912, 10.1375}, {169.914, 10.139}, {169.916, 10.1404}, {
       169.918, 10.1416}, {169.92, 10.1426}, {169.922, 10.1435}, {169.925, 
       10.1442}, {169.927, 10.1447}, {169.93, 10.145}, {169.933, 10.1451}, {
       169.935, 10.1451}, {169.938, 10.1448}, {169.94, 10.1443}, {169.943, 
       10.1437}, {169.945, 10.1429}, {169.947, 10.1419}, {169.949, 10.1407}, {
       169.951, 10.1394}, {169.952, 10.138}, {169.954, 10.1364}, {169.955, 
       10.1348}, {169.955, 10.133}, {169.956, 10.1312}, {169.956, 10.1294}, {
       169.956, 10.1275}, {169.956, 10.1257}, {169.956, 10.1238}, {169.955, 
       10.122}, {169.954, 10.1202}, {169.953, 10.1186}, {169.951, 10.117}, {
       169.949, 10.1155}, {169.947, 10.1142}, {169.945, 10.113}, {169.943, 
       10.1119}, {169.941, 10.1111}, {169.938, 10.1104}, {169.936, 10.1099}, {
       169.933, 10.1095}, {169.93, 10.1094}, {169.928, 10.1095}, {169.925, 
       10.1097}, {169.923, 10.1102}, {169.92, 10.1108}, {169.918, 10.1117}, {
       169.916, 10.1127}, {169.914, 10.1138}, {169.912, 10.1151}, {169.911, 
       10.1166}, {169.91, 10.1181}, {169.908, 10.1198}, {169.908, 10.1215}, {
       169.907, 10.1233}, {169.907, 10.1251}}, {{168.402, 7.75617}, {168.401, 
       7.75807}, {168.4, 7.76007}, {168.399, 7.76213}, {168.399, 7.76427}, {
       168.398, 7.7664}, {168.398, 7.76853}, {168.398, 7.77067}, {168.398, 
       7.77273}, {168.399, 7.77473}, {168.4, 7.77667}, {168.401, 7.77847}, {
       168.402, 7.78013}, {168.403, 7.78167}, {168.405, 7.783}, {168.407, 
       7.7842}, {168.408, 7.78517}, {168.41, 7.78597}, {168.413, 7.78653}, {
       168.415, 7.78687}, {168.417, 7.787}, {168.419, 7.7869}, {168.421, 
       7.78657}, {168.424, 7.78603}, {168.426, 7.78527}, {168.428, 7.7843}, {
       168.43, 7.78313}, {168.432, 7.7818}, {168.434, 7.7803}, {168.435, 
       7.77863}, {168.437, 7.77683}, {168.438, 7.77493}, {168.439, 7.77293}, {
       168.44, 7.77087}, {168.441, 7.76873}, {168.441, 7.7666}, {168.441, 
       7.76447}, {168.441, 7.76233}, {168.441, 7.76027}, {168.44, 7.75827}, {
       168.44, 7.75633}, {168.439, 7.75453}, {168.437, 7.75287}, {168.436, 
       7.75133}, {168.434, 7.75}, {168.433, 7.7488}, {168.431, 7.74783}, {
       168.429, 7.74703}, {168.427, 7.74647}, {168.425, 7.74613}, {168.422, 
       7.746}, {168.42, 7.7461}, {168.418, 7.74643}, {168.416, 7.74697}, {
       168.413, 7.74773}, {168.411, 7.7487}, {168.409, 7.74987}, {168.407, 
       7.7512}, {168.405, 7.7527}, {168.404, 7.75437}, {168.402, 7.75617}}, {{
       167.527, 9.236}, {167.526, 9.23703}, {167.525, 9.23823}, {167.524, 
       9.2396}, {167.524, 9.2411}, {167.524, 9.2427}, {167.524, 9.24443}, {
       167.524, 9.24623}, {167.525, 9.2481}, {167.526, 9.25}, {167.528, 
       9.25193}, {167.529, 9.25387}, {167.531, 9.25577}, {167.533, 9.25763}, {
       167.535, 9.25947}, {167.538, 9.2612}, {167.54, 9.26283}, {167.543, 
       9.26433}, {167.546, 9.2657}, {167.549, 9.26693}, {167.552, 9.268}, {
       167.555, 9.2689}, {167.557, 9.2696}, {167.56, 9.27013}, {167.563, 
       9.27043}, {167.566, 9.27057}, {167.568, 9.27047}, {167.57, 9.2702}, {
       167.572, 9.2697}, {167.574, 9.26903}, {167.576, 9.26817}, {167.577, 
       9.26713}, {167.578, 9.26593}, {167.579, 9.26457}, {167.579, 9.26307}, {
       167.579, 9.26147}, {167.579, 9.25973}, {167.579, 9.25793}, {167.578, 
       9.25607}, {167.577, 9.25417}, {167.575, 9.25223}, {167.574, 9.2503}, {
       167.572, 9.2484}, {167.57, 9.24653}, {167.568, 9.2447}, {167.565, 
       9.24297}, {167.563, 9.24133}, {167.56, 9.23983}, {167.557, 9.23847}, {
       167.554, 9.23723}, {167.551, 9.23617}, {167.548, 9.23527}, {167.546, 
       9.23457}, {167.543, 9.23403}, {167.54, 9.23373}, {167.537, 9.2336}, {
       167.535, 9.2337}, {167.533, 9.23397}, {167.531, 9.23447}, {167.529, 
       9.23513}, {167.527, 9.236}}, {{167.251, 9.23223}, {167.25, 9.2343}, {
       167.249, 9.2364}, {167.249, 9.2386}, {167.249, 9.2408}, {167.249, 
       9.243}, {167.249, 9.2452}, {167.25, 9.24733}, {167.25, 9.2494}, {
       167.251, 9.2514}, {167.252, 9.25327}, {167.254, 9.255}, {167.255, 
       9.25657}, {167.257, 9.25797}, {167.259, 9.2592}, {167.261, 9.26023}, {
       167.263, 9.26103}, {167.265, 9.26163}, {167.267, 9.262}, {167.269, 
       9.26213}, {167.271, 9.26203}, {167.273, 9.26173}, {167.275, 9.26117}, {
       167.277, 9.2604}, {167.279, 9.2594}, {167.281, 9.25823}, {167.283, 
       9.25687}, {167.284, 9.2553}, {167.286, 9.2536}, {167.287, 9.25177}, {
       167.288, 9.2498}, {167.289, 9.24773}, {167.29, 9.24563}, {167.29, 
       9.24343}, {167.29, 9.24123}, {167.29, 9.23903}, {167.29, 9.23683}, {
       167.289, 9.2347}, {167.289, 9.23263}, {167.288, 9.23063}, {167.286, 
       9.22877}, {167.285, 9.22703}, {167.284, 9.22547}, {167.282, 9.22407}, {
       167.28, 9.22283}, {167.278, 9.2218}, {167.276, 9.221}, {167.274, 
       9.2204}, {167.272, 9.22003}, {167.27, 9.2199}, {167.268, 9.22}, {
       167.266, 9.2203}, {167.264, 9.22087}, {167.261, 9.22163}, {167.26, 
       9.22263}, {167.258, 9.2238}, {167.256, 9.22517}, {167.254, 9.22673}, {
       167.253, 9.22843}, {167.252, 9.23027}, {167.251, 9.23223}}, {{166.839, 
       11.0842}, {166.836, 11.0849}, {166.834, 11.0857}, {166.831, 11.0867}, {
       166.828, 11.0879}, {166.826, 11.0891}, {166.824, 11.0905}, {166.821, 
       11.092}, {166.819, 11.0935}, {166.818, 11.0952}, {166.816, 11.0968}, {
       166.815, 11.0986}, {166.814, 11.1003}, {166.814, 11.102}, {166.813, 
       11.1037}, {166.813, 11.1053}, {166.814, 11.1069}, {166.814, 11.1084}, {
       166.815, 11.1098}, {166.816, 11.1111}, {166.818, 11.1122}, {166.819, 
       11.1133}, {166.821, 11.1141}, {166.824, 11.1148}, {166.826, 11.1154}, {
       166.828, 11.1158}, {166.831, 11.116}, {166.834, 11.116}, {166.836, 
       11.1158}, {166.839, 11.1155}, {166.842, 11.115}, {166.845, 11.1143}, {
       166.848, 11.1134}, {166.851, 11.1124}, {166.853, 11.1113}, {166.856, 
       11.11}, {166.858, 11.1087}, {166.86, 11.1072}, {166.862, 11.1056}, {
       166.864, 11.104}, {166.865, 11.1023}, {166.866, 11.1006}, {166.867, 
       11.0989}, {166.868, 11.0972}, {166.868, 11.0955}, {166.868, 11.0939}, {
       166.868, 11.0923}, {166.867, 11.0908}, {166.866, 11.0894}, {166.865, 
       11.0881}, {166.864, 11.0869}, {166.862, 11.0859}, {166.86, 11.085}, {
       166.858, 11.0843}, {166.856, 11.0838}, {166.853, 11.0834}, {166.851, 
       11.0832}, {166.848, 11.0832}, {166.845, 11.0834}, {166.842, 11.0837}, {
       166.839, 11.0842}}, {{168.195, 8.0244}, {168.193, 8.02577}, {168.191, 
       8.0273}, {168.189, 8.0289}, {168.188, 8.03063}, {168.186, 8.03243}, {
       168.185, 8.0343}, {168.184, 8.0362}, {168.184, 8.0381}, {168.183, 
       8.04003}, {168.183, 8.04193}, {168.183, 8.04377}, {168.184, 8.04557}, {
       168.184, 8.04727}, {168.185, 8.04887}, {168.186, 8.05033}, {168.188, 
       8.05167}, {168.189, 8.05287}, {168.191, 8.05387}, {168.193, 8.05473}, {
       168.195, 8.0554}, {168.197, 8.05587}, {168.199, 8.05613}, {168.202, 
       8.05623}, {168.204, 8.0561}, {168.207, 8.05577}, {168.209, 8.05527}, {
       168.212, 8.05453}, {168.214, 8.05367}, {168.217, 8.0526}, {168.219, 
       8.05137}, {168.221, 8.05}, {168.223, 8.04847}, {168.225, 8.04687}, {
       168.226, 8.04513}, {168.228, 8.04333}, {168.229, 8.04147}, {168.23, 
       8.03957}, {168.23, 8.03767}, {168.231, 8.03573}, {168.231, 8.03383}, {
       168.231, 8.032}, {168.231, 8.0302}, {168.23, 8.0285}, {168.229, 
       8.0269}, {168.228, 8.02543}, {168.227, 8.0241}, {168.225, 8.0229}, {
       168.223, 8.0219}, {168.221, 8.02103}, {168.219, 8.02037}, {168.217, 
       8.0199}, {168.215, 8.01963}, {168.212, 8.01953}, {168.21, 8.01967}, {
       168.207, 8.02}, {168.205, 8.0205}, {168.202, 8.02123}, {168.2, 
       8.0221}, {168.197, 8.02317}, {168.195, 8.0244}}, {{169.808, 6.0807}, {
       169.807, 6.08257}, {169.807, 6.08447}, {169.807, 6.08643}, {169.807, 
       6.08837}, {169.807, 6.09033}, {169.807, 6.09227}, {169.808, 6.09413}, {
       169.809, 6.09597}, {169.81, 6.09767}, {169.812, 6.09927}, {169.813, 
       6.10077}, {169.815, 6.1021}, {169.817, 6.1033}, {169.819, 6.1043}, {
       169.821, 6.10517}, {169.823, 6.1058}, {169.826, 6.10623}, {169.828, 
       6.1065}, {169.83, 6.10653}, {169.833, 6.10637}, {169.835, 6.106}, {
       169.837, 6.10543}, {169.84, 6.10467}, {169.842, 6.10373}, {169.844, 
       6.1026}, {169.845, 6.10133}, {169.847, 6.0999}, {169.848, 6.09833}, {
       169.85, 6.09667}, {169.851, 6.0949}, {169.851, 6.09303}, {169.852, 
       6.09113}, {169.852, 6.08917}, {169.852, 6.08723}, {169.852, 6.08527}, {
       169.851, 6.08333}, {169.851, 6.08147}, {169.85, 6.07963}, {169.849, 
       6.07793}, {169.847, 6.07633}, {169.846, 6.07483}, {169.844, 6.0735}, {
       169.842, 6.0723}, {169.84, 6.0713}, {169.838, 6.07043}, {169.835, 
       6.0698}, {169.833, 6.06937}, {169.831, 6.0691}, {169.828, 6.06907}, {
       169.826, 6.06923}, {169.824, 6.0696}, {169.821, 6.07017}, {169.819, 
       6.07093}, {169.817, 6.07187}, {169.815, 6.073}, {169.813, 6.07427}, {
       169.812, 6.0757}, {169.81, 6.07727}, {169.809, 6.07893}, {169.808, 
       6.0807}}, {{171.025, 8.8578}, {171.024, 8.8595}, {171.023, 8.8613}, {
       171.023, 8.86317}, {171.022, 8.86503}, {171.022, 8.86697}, {171.022, 
       8.86887}, {171.022, 8.87077}, {171.023, 8.8726}, {171.024, 8.87437}, {
       171.025, 8.87607}, {171.026, 8.87767}, {171.027, 8.87913}, {171.029, 
       8.88047}, {171.031, 8.88167}, {171.033, 8.8827}, {171.035, 8.88353}, {
       171.037, 8.8842}, {171.04, 8.8847}, {171.042, 8.88497}, {171.045, 
       8.88503}, {171.047, 8.88493}, {171.049, 8.8846}, {171.052, 8.8841}, {
       171.054, 8.8834}, {171.056, 8.8825}, {171.058, 8.88143}, {171.06, 
       8.88023}, {171.062, 8.87887}, {171.064, 8.87737}, {171.065, 8.87573}, {
       171.066, 8.87403}, {171.067, 8.87223}, {171.068, 8.87037}, {171.068, 
       8.8685}, {171.068, 8.86657}, {171.068, 8.86467}, {171.068, 8.86277}, {
       171.067, 8.86093}, {171.067, 8.85917}, {171.066, 8.85747}, {171.064, 
       8.85587}, {171.063, 8.8544}, {171.061, 8.85307}, {171.059, 8.85187}, {
       171.057, 8.85083}, {171.055, 8.85}, {171.053, 8.84933}, {171.051, 
       8.84883}, {171.048, 8.84857}, {171.046, 8.8485}, {171.043, 8.8486}, {
       171.041, 8.84893}, {171.039, 8.84943}, {171.036, 8.85013}, {171.034, 
       8.85103}, {171.032, 8.8521}, {171.03, 8.8533}, {171.028, 8.85467}, {
       171.027, 8.85617}, {171.025, 8.8578}}, {{168.289, 7.8849}, {168.288, 
       7.8871}, {168.287, 7.88937}, {168.286, 7.8917}, {168.286, 7.89407}, {
       168.285, 7.89647}, {168.285, 7.89883}, {168.285, 7.9012}, {168.286, 
       7.90347}, {168.286, 7.90567}, {168.287, 7.90777}, {168.288, 7.9097}, {
       168.289, 7.9115}, {168.29, 7.91313}, {168.291, 7.91453}, {168.293, 
       7.91577}, {168.294, 7.91677}, {168.296, 7.91753}, {168.298, 7.91807}, {
       168.3, 7.91833}, {168.302, 7.91837}, {168.304, 7.91813}, {168.306, 
       7.91767}, {168.308, 7.91697}, {168.31, 7.916}, {168.311, 7.91483}, {
       168.313, 7.91343}, {168.315, 7.91187}, {168.316, 7.9101}, {168.318, 
       7.9082}, {168.319, 7.90613}, {168.32, 7.90393}, {168.321, 7.90167}, {
       168.322, 7.89933}, {168.322, 7.89697}, {168.323, 7.89457}, {168.323, 
       7.8922}, {168.323, 7.88983}, {168.322, 7.88757}, {168.322, 7.88537}, {
       168.321, 7.88327}, {168.32, 7.88133}, {168.319, 7.87953}, {168.318, 
       7.8779}, {168.317, 7.87647}, {168.315, 7.87527}, {168.313, 7.87427}, {
       168.312, 7.8735}, {168.31, 7.87297}, {168.308, 7.8727}, {168.306, 
       7.87267}, {168.304, 7.8729}, {168.302, 7.87337}, {168.3, 7.87407}, {
       168.298, 7.87503}, {168.296, 7.8762}, {168.295, 7.8776}, {168.293, 
       7.87917}, {168.291, 7.88093}, {168.29, 7.88283}, {168.289, 7.8849}}, {{
       168.85, 4.70443}, {168.848, 4.70587}, {168.846, 4.70737}, {168.845, 
       4.709}, {168.844, 4.7107}, {168.843, 4.71247}, {168.843, 4.71427}, {
       168.843, 4.71607}, {168.843, 4.7179}, {168.843, 4.7197}, {168.843, 
       4.72143}, {168.844, 4.72313}, {168.845, 4.72477}, {168.846, 4.7263}, {
       168.848, 4.7277}, {168.85, 4.72897}, {168.851, 4.7301}, {168.853, 
       4.7311}, {168.856, 4.73193}, {168.858, 4.73257}, {168.86, 4.73303}, {
       168.863, 4.7333}, {168.865, 4.7334}, {168.868, 4.7333}, {168.87, 
       4.733}, {168.873, 4.73253}, {168.875, 4.73187}, {168.878, 4.73103}, {
       168.88, 4.73003}, {168.882, 4.7289}, {168.884, 4.7276}, {168.885, 
       4.72617}, {168.887, 4.72467}, {168.888, 4.72303}, {168.889, 4.72133}, {
       168.89, 4.71957}, {168.891, 4.71777}, {168.891, 4.71597}, {168.891, 
       4.71413}, {168.891, 4.71233}, {168.89, 4.7106}, {168.889, 4.7089}, {
       168.888, 4.70727}, {168.887, 4.70573}, {168.886, 4.70433}, {168.884, 
       4.70307}, {168.882, 4.70193}, {168.88, 4.70093}, {168.878, 4.7001}, {
       168.875, 4.69947}, {168.873, 4.699}, {168.871, 4.69873}, {168.868, 
       4.69863}, {168.866, 4.69873}, {168.863, 4.69903}, {168.861, 4.6995}, {
       168.858, 4.70017}, {168.856, 4.701}, {168.854, 4.702}, {168.852, 
       4.70313}, {168.85, 4.70443}}, {{165.954, 10.0084}, {165.951, 
       10.0077}, {165.949, 10.0073}, {165.946, 10.007}, {165.944, 10.0069}, {
       165.941, 10.007}, {165.938, 10.0073}, {165.936, 10.0077}, {165.933, 
       10.0084}, {165.931, 10.0092}, {165.929, 10.0101}, {165.927, 10.0112}, {
       165.925, 10.0125}, {165.923, 10.0138}, {165.922, 10.0153}, {165.921, 
       10.0168}, {165.92, 10.0185}, {165.919, 10.0202}, {165.919, 10.0219}, {
       165.919, 10.0236}, {165.919, 10.0254}, {165.919, 10.0271}, {165.92, 
       10.0288}, {165.921, 10.0304}, {165.922, 10.032}, {165.923, 10.0335}, {
       165.925, 10.0348}, {165.927, 10.036}, {165.929, 10.0371}, {165.931, 
       10.0381}, {165.933, 10.0389}, {165.936, 10.0395}, {165.938, 10.04}, {
       165.941, 10.0402}, {165.944, 10.0403}, {165.946, 10.0402}, {165.949, 
       10.04}, {165.951, 10.0395}, {165.954, 10.0389}, {165.956, 10.0381}, {
       165.958, 10.0371}, {165.96, 10.036}, {165.962, 10.0348}, {165.964, 
       10.0335}, {165.965, 10.032}, {165.967, 10.0304}, {165.967, 10.0288}, {
       165.968, 10.0271}, {165.969, 10.0254}, {165.969, 10.0236}, {165.969, 
       10.0219}, {165.968, 10.0202}, {165.967, 10.0185}, {165.967, 10.0168}, {
       165.965, 10.0153}, {165.964, 10.0138}, {165.962, 10.0125}, {165.96, 
       10.0112}, {165.958, 10.0101}, {165.956, 10.0092}, {165.954, 
       10.0084}}, {{169.555, 6.2006}, {169.556, 6.20253}, {169.556, 6.2045}, {
       169.556, 6.2065}, {169.557, 6.20843}, {169.558, 6.21033}, {169.559, 
       6.21217}, {169.561, 6.2139}, {169.562, 6.21553}, {169.564, 6.21707}, {
       169.566, 6.21843}, {169.568, 6.21963}, {169.57, 6.2207}, {169.573, 
       6.22157}, {169.575, 6.22223}, {169.577, 6.2227}, {169.579, 6.22297}, {
       169.582, 6.22303}, {169.584, 6.2229}, {169.586, 6.22257}, {169.588, 
       6.22203}, {169.59, 6.22127}, {169.592, 6.22037}, {169.594, 6.21927}, {
       169.595, 6.21797}, {169.596, 6.21657}, {169.598, 6.215}, {169.598, 
       6.21333}, {169.599, 6.21157}, {169.599, 6.2097}, {169.6, 6.20777}, {
       169.6, 6.20583}, {169.599, 6.20387}, {169.599, 6.20187}, {169.598, 
       6.19993}, {169.597, 6.19803}, {169.596, 6.1962}, {169.594, 6.19447}, {
       169.593, 6.19283}, {169.591, 6.1913}, {169.589, 6.18993}, {169.587, 
       6.18873}, {169.585, 6.18767}, {169.582, 6.1868}, {169.58, 6.18613}, {
       169.578, 6.18567}, {169.576, 6.1854}, {169.573, 6.18533}, {169.571, 
       6.18547}, {169.569, 6.1858}, {169.567, 6.18633}, {169.565, 6.1871}, {
       169.563, 6.188}, {169.561, 6.1891}, {169.56, 6.1904}, {169.559, 
       6.1918}, {169.558, 6.19337}, {169.557, 6.19503}, {169.556, 6.1968}, {
       169.556, 6.19867}, {169.555, 6.2006}}, {{169.851, 11.2006}, {169.852, 
       11.2028}, {169.854, 11.205}, {169.855, 11.2072}, {169.857, 11.2094}, {
       169.859, 11.2114}, {169.861, 11.2134}, {169.864, 11.2153}, {169.866, 
       11.2171}, {169.868, 11.2187}, {169.871, 11.2201}, {169.873, 11.2214}, {
       169.876, 11.2224}, {169.878, 11.2233}, {169.881, 11.2239}, {169.883, 
       11.2243}, {169.885, 11.2245}, {169.887, 11.2244}, {169.889, 11.2241}, {
       169.89, 11.2236}, {169.892, 11.2229}, {169.893, 11.2219}, {169.894, 
       11.2208}, {169.895, 11.2194}, {169.895, 11.2179}, {169.896, 11.2162}, {
       169.896, 11.2144}, {169.895, 11.2125}, {169.895, 11.2104}, {169.894, 
       11.2083}, {169.893, 11.2061}, {169.892, 11.2039}, {169.89, 11.2017}, {
       169.889, 11.1995}, {169.887, 11.1974}, {169.885, 11.1953}, {169.883, 
       11.1933}, {169.88, 11.1914}, {169.878, 11.1897}, {169.876, 11.1881}, {
       169.873, 11.1866}, {169.871, 11.1854}, {169.868, 11.1843}, {169.866, 
       11.1835}, {169.863, 11.1828}, {169.861, 11.1824}, {169.859, 11.1823}, {
       169.857, 11.1823}, {169.855, 11.1826}, {169.854, 11.1831}, {169.852, 
       11.1839}, {169.851, 11.1848}, {169.85, 11.186}, {169.849, 11.1873}, {
       169.849, 11.1888}, {169.848, 11.1905}, {169.848, 11.1923}, {169.849, 
       11.1943}, {169.849, 11.1963}, {169.85, 11.1984}, {169.851, 
       11.2006}}, {{167.433, 11.5174}, {167.434, 11.5194}, {167.434, 
       11.5215}, {167.435, 11.5235}, {167.436, 11.5256}, {167.438, 11.5275}, {
       167.439, 11.5294}, {167.441, 11.5312}, {167.443, 11.5328}, {167.445, 
       11.5344}, {167.447, 11.5358}, {167.449, 11.537}, {167.451, 11.538}, {
       167.454, 11.5388}, {167.456, 11.5395}, {167.458, 11.5399}, {167.46, 
       11.5401}, {167.463, 11.5401}, {167.465, 11.5399}, {167.467, 11.5395}, {
       167.468, 11.5389}, {167.47, 11.538}, {167.472, 11.537}, {167.473, 
       11.5358}, {167.474, 11.5344}, {167.475, 11.5329}, {167.476, 11.5313}, {
       167.477, 11.5295}, {167.477, 11.5276}, {167.477, 11.5256}, {167.477, 
       11.5236}, {167.476, 11.5216}, {167.476, 11.5195}, {167.475, 11.5175}, {
       167.474, 11.5155}, {167.472, 11.5135}, {167.471, 11.5116}, {167.469, 
       11.5099}, {167.467, 11.5082}, {167.465, 11.5067}, {167.463, 11.5053}, {
       167.461, 11.5041}, {167.459, 11.503}, {167.456, 11.5022}, {167.454, 
       11.5016}, {167.452, 11.5011}, {167.45, 11.5009}, {167.447, 11.5009}, {
       167.445, 11.5011}, {167.443, 11.5015}, {167.442, 11.5022}, {167.44, 
       11.503}, {167.438, 11.504}, {167.437, 11.5052}, {167.436, 11.5066}, {
       167.435, 11.5081}, {167.434, 11.5098}, {167.433, 11.5116}, {167.433, 
       11.5134}, {167.433, 11.5154}, {167.433, 11.5174}}, {{167.043, 
       9.1201}, {167.043, 9.1217}, {167.044, 9.12323}, {167.044, 9.12473}, {
       167.045, 9.12613}, {167.046, 9.12747}, {167.048, 9.12867}, {167.049, 
       9.12977}, {167.051, 9.13073}, {167.054, 9.13153}, {167.056, 9.1322}, {
       167.058, 9.1327}, {167.061, 9.13307}, {167.063, 9.13323}, {167.066, 
       9.13323}, {167.069, 9.13307}, {167.072, 9.13273}, {167.075, 9.13223}, {
       167.077, 9.13157}, {167.08, 9.13077}, {167.082, 9.1298}, {167.085, 
       9.12873}, {167.087, 9.12753}, {167.089, 9.1262}, {167.091, 9.1248}, {
       167.092, 9.1233}, {167.094, 9.12177}, {167.095, 9.12017}, {167.096, 
       9.11857}, {167.096, 9.11693}, {167.096, 9.1153}, {167.096, 9.1137}, {
       167.096, 9.11217}, {167.095, 9.11067}, {167.094, 9.10927}, {167.093, 
       9.10793}, {167.092, 9.10673}, {167.09, 9.10563}, {167.088, 9.10467}, {
       167.086, 9.10387}, {167.084, 9.1032}, {167.081, 9.1027}, {167.079, 
       9.10233}, {167.076, 9.10217}, {167.073, 9.10217}, {167.071, 9.10233}, {
       167.068, 9.10267}, {167.065, 9.10317}, {167.062, 9.10383}, {167.06, 
       9.10463}, {167.057, 9.1056}, {167.055, 9.10667}, {167.053, 9.10787}, {
       167.051, 9.1092}, {167.049, 9.1106}, {167.047, 9.1121}, {167.046, 
       9.11363}, {167.045, 9.11523}, {167.044, 9.11683}, {167.043, 9.11847}, {
       167.043, 9.1201}}, {{169.791, 10.1987}, {169.791, 10.2003}, {169.791, 
       10.202}, {169.791, 10.2037}, {169.791, 10.2053}, {169.792, 10.2069}, {
       169.792, 10.2085}, {169.794, 10.21}, {169.795, 10.2114}, {169.797, 
       10.2127}, {169.798, 10.2139}, {169.8, 10.215}, {169.803, 10.2159}, {
       169.805, 10.2167}, {169.807, 10.2173}, {169.81, 10.2177}, {169.813, 
       10.218}, {169.815, 10.2181}, {169.818, 10.2181}, {169.82, 10.2178}, {
       169.823, 10.2174}, {169.826, 10.2168}, {169.828, 10.2161}, {169.83, 
       10.2152}, {169.832, 10.2142}, {169.834, 10.213}, {169.836, 10.2117}, {
       169.838, 10.2104}, {169.839, 10.2089}, {169.84, 10.2073}, {169.841, 
       10.2057}, {169.841, 10.2041}, {169.842, 10.2024}, {169.842, 10.2008}, {
       169.841, 10.1991}, {169.841, 10.1975}, {169.84, 10.1959}, {169.839, 
       10.1944}, {169.837, 10.193}, {169.836, 10.1917}, {169.834, 10.1905}, {
       169.832, 10.1895}, {169.83, 10.1885}, {169.827, 10.1878}, {169.825, 
       10.1871}, {169.822, 10.1867}, {169.82, 10.1864}, {169.817, 10.1863}, {
       169.814, 10.1864}, {169.812, 10.1866}, {169.809, 10.187}, {169.807, 
       10.1876}, {169.804, 10.1883}, {169.802, 10.1892}, {169.8, 10.1902}, {
       169.798, 10.1914}, {169.796, 10.1927}, {169.795, 10.1941}, {169.793, 
       10.1956}, {169.792, 10.1971}, {169.791, 10.1987}}, {{167.709, 
       8.69023}, {167.71, 8.69227}, {167.711, 8.6943}, {167.712, 8.69633}, {
       167.713, 8.69827}, {167.715, 8.70017}, {167.717, 8.70197}, {167.719, 
       8.70367}, {167.721, 8.70523}, {167.723, 8.70667}, {167.726, 8.70793}, {
       167.728, 8.70903}, {167.73, 8.70993}, {167.733, 8.71063}, {167.735, 
       8.71117}, {167.737, 8.71147}, {167.74, 8.71153}, {167.742, 8.7114}, {
       167.744, 8.71107}, {167.746, 8.71053}, {167.747, 8.7098}, {167.749, 
       8.70883}, {167.75, 8.70773}, {167.751, 8.70643}, {167.752, 8.70497}, {
       167.753, 8.70337}, {167.753, 8.70167}, {167.753, 8.69983}, {167.753, 
       8.69793}, {167.753, 8.69597}, {167.752, 8.69397}, {167.751, 8.69193}, {
       167.75, 8.6899}, {167.749, 8.68787}, {167.747, 8.68593}, {167.746, 
       8.68403}, {167.744, 8.68223}, {167.742, 8.68053}, {167.74, 8.67897}, {
       167.738, 8.67753}, {167.735, 8.67627}, {167.733, 8.67517}, {167.731, 
       8.67427}, {167.728, 8.67357}, {167.726, 8.67303}, {167.724, 8.67273}, {
       167.721, 8.67267}, {167.719, 8.6728}, {167.717, 8.67313}, {167.715, 
       8.67367}, {167.714, 8.6744}, {167.712, 8.67537}, {167.711, 8.67647}, {
       167.71, 8.67777}, {167.709, 8.67923}, {167.708, 8.68083}, {167.708, 
       8.68253}, {167.708, 8.68437}, {167.708, 8.68627}, {167.708, 8.68823}, {
       167.709, 8.69023}}, {{166.922, 11.362}, {166.921, 11.364}, {166.92, 
       11.366}, {166.92, 11.3681}, {166.92, 11.3703}, {166.919, 11.3724}, {
       166.92, 11.3746}, {166.92, 11.3767}, {166.92, 11.3787}, {166.921, 
       11.3807}, {166.922, 11.3825}, {166.923, 11.3843}, {166.924, 11.3858}, {
       166.926, 11.3873}, {166.927, 11.3885}, {166.929, 11.3896}, {166.931, 
       11.3904}, {166.933, 11.3911}, {166.935, 11.3915}, {166.937, 11.3917}, {
       166.939, 11.3917}, {166.941, 11.3915}, {166.943, 11.391}, {166.945, 
       11.3903}, {166.947, 11.3894}, {166.949, 11.3883}, {166.95, 11.3871}, {
       166.952, 11.3856}, {166.953, 11.384}, {166.955, 11.3822}, {166.956, 
       11.3804}, {166.957, 11.3784}, {166.958, 11.3763}, {166.958, 11.3742}, {
       166.958, 11.3721}, {166.959, 11.3699}, {166.958, 11.3678}, {166.958, 
       11.3657}, {166.958, 11.3636}, {166.957, 11.3617}, {166.956, 11.3598}, {
       166.955, 11.3581}, {166.954, 11.3565}, {166.952, 11.3551}, {166.951, 
       11.3538}, {166.949, 11.3527}, {166.947, 11.3519}, {166.945, 11.3512}, {
       166.943, 11.3508}, {166.941, 11.3506}, {166.939, 11.3506}, {166.937, 
       11.3509}, {166.935, 11.3513}, {166.933, 11.352}, {166.931, 11.3529}, {
       166.929, 11.354}, {166.928, 11.3553}, {166.926, 11.3567}, {166.925, 
       11.3583}, {166.923, 11.3601}, {166.922, 11.362}}, {{168.814, 
       7.51977}, {168.813, 7.52193}, {168.812, 7.52417}, {168.812, 7.52647}, {
       168.811, 7.52877}, {168.811, 7.5311}, {168.811, 7.53343}, {168.812, 
       7.5357}, {168.812, 7.5379}, {168.813, 7.54}, {168.814, 7.54197}, {
       168.815, 7.54383}, {168.816, 7.54553}, {168.818, 7.54703}, {168.819, 
       7.54837}, {168.821, 7.54947}, {168.822, 7.55037}, {168.824, 7.55103}, {
       168.826, 7.55147}, {168.828, 7.55163}, {168.83, 7.55157}, {168.832, 
       7.55127}, {168.833, 7.55073}, {168.835, 7.54993}, {168.837, 7.54893}, {
       168.839, 7.54773}, {168.84, 7.5463}, {168.842, 7.5447}, {168.843, 
       7.54293}, {168.844, 7.541}, {168.845, 7.53897}, {168.846, 7.5368}, {
       168.847, 7.53457}, {168.847, 7.53227}, {168.848, 7.52997}, {168.848, 
       7.52763}, {168.847, 7.5253}, {168.847, 7.52303}, {168.847, 7.52083}, {
       168.846, 7.51873}, {168.845, 7.51677}, {168.844, 7.5149}, {168.843, 
       7.5132}, {168.841, 7.5117}, {168.84, 7.51037}, {168.838, 7.50927}, {
       168.837, 7.50837}, {168.835, 7.5077}, {168.833, 7.50727}, {168.831, 
       7.5071}, {168.829, 7.50717}, {168.827, 7.50747}, {168.825, 7.508}, {
       168.824, 7.5088}, {168.822, 7.5098}, {168.82, 7.511}, {168.819, 
       7.51243}, {168.817, 7.51403}, {168.816, 7.5158}, {168.815, 7.51773}, {
       168.814, 7.51977}}, {{166.585, 11.2356}, {166.586, 11.2374}, {166.588, 
       11.2392}, {166.59, 11.2409}, {166.592, 11.2425}, {166.594, 11.244}, {
       166.596, 11.2453}, {166.599, 11.2466}, {166.602, 11.2477}, {166.604, 
       11.2487}, {166.607, 11.2495}, {166.609, 11.2501}, {166.612, 11.2505}, {
       166.615, 11.2508}, {166.617, 11.2508}, {166.619, 11.2507}, {166.622, 
       11.2504}, {166.624, 11.2498}, {166.625, 11.2492}, {166.627, 11.2483}, {
       166.628, 11.2473}, {166.63, 11.2461}, {166.63, 11.2448}, {166.631, 
       11.2434}, {166.631, 11.2418}, {166.632, 11.2402}, {166.631, 11.2385}, {
       166.631, 11.2367}, {166.63, 11.2349}, {166.629, 11.2331}, {166.628, 
       11.2313}, {166.626, 11.2295}, {166.625, 11.2278}, {166.623, 11.2261}, {
       166.621, 11.2245}, {166.618, 11.223}, {166.616, 11.2216}, {166.614, 
       11.2203}, {166.611, 11.2192}, {166.608, 11.2183}, {166.606, 11.2175}, {
       166.603, 11.2169}, {166.6, 11.2164}, {166.598, 11.2162}, {166.595, 
       11.2161}, {166.593, 11.2163}, {166.591, 11.2166}, {166.589, 11.2171}, {
       166.587, 11.2178}, {166.585, 11.2186}, {166.584, 11.2197}, {166.583, 
       11.2208}, {166.582, 11.2221}, {166.581, 11.2236}, {166.581, 11.2251}, {
       166.581, 11.2267}, {166.581, 11.2285}, {166.582, 11.2302}, {166.582, 
       11.232}, {166.583, 11.2338}, {166.585, 11.2356}}, {{169.41, 9.7342}, {
       169.409, 9.73577}, {169.408, 9.73733}, {169.408, 9.73897}, {169.408, 
       9.7406}, {169.408, 9.7422}, {169.409, 9.7438}, {169.409, 9.74537}, {
       169.41, 9.74683}, {169.412, 9.74827}, {169.413, 9.74957}, {169.415, 
       9.75077}, {169.417, 9.75187}, {169.419, 9.75283}, {169.422, 9.75363}, {
       169.424, 9.7543}, {169.427, 9.7548}, {169.429, 9.75513}, {169.432, 
       9.7553}, {169.435, 9.7553}, {169.437, 9.75513}, {169.44, 9.7548}, {
       169.443, 9.7543}, {169.445, 9.75363}, {169.447, 9.7528}, {169.45, 
       9.75183}, {169.452, 9.75077}, {169.453, 9.74953}, {169.455, 9.74823}, {
       169.456, 9.7468}, {169.457, 9.74533}, {169.458, 9.74377}, {169.459, 
       9.7422}, {169.459, 9.74057}, {169.459, 9.73893}, {169.459, 9.73733}, {
       169.458, 9.73573}, {169.458, 9.73417}, {169.457, 9.7327}, {169.455, 
       9.73127}, {169.454, 9.72997}, {169.452, 9.72877}, {169.45, 9.72767}, {
       169.448, 9.7267}, {169.445, 9.7259}, {169.443, 9.72523}, {169.44, 
       9.72473}, {169.438, 9.7244}, {169.435, 9.72423}, {169.432, 9.72423}, {
       169.43, 9.7244}, {169.427, 9.72473}, {169.424, 9.72523}, {169.422, 
       9.7259}, {169.42, 9.72673}, {169.417, 9.7277}, {169.415, 9.72877}, {
       169.414, 9.73}, {169.412, 9.7313}, {169.411, 9.73273}, {169.41, 
       9.7342}}, {{171.131, 8.8468}, {171.13, 8.84843}, {171.128, 8.85017}, {
       171.127, 8.85193}, {171.126, 8.8538}, {171.126, 8.8557}, {171.125, 
       8.85763}, {171.125, 8.85953}, {171.125, 8.86143}, {171.126, 8.86327}, {
       171.126, 8.86507}, {171.127, 8.86677}, {171.128, 8.86837}, {171.129, 
       8.86983}, {171.13, 8.87117}, {171.132, 8.87237}, {171.134, 8.8734}, {
       171.136, 8.87427}, {171.138, 8.87493}, {171.14, 8.8754}, {171.142, 
       8.87567}, {171.144, 8.87577}, {171.146, 8.87563}, {171.149, 8.87533}, {
       171.151, 8.8748}, {171.153, 8.8741}, {171.155, 8.8732}, {171.157, 
       8.87213}, {171.159, 8.87093}, {171.161, 8.86957}, {171.163, 8.86807}, {
       171.164, 8.86643}, {171.165, 8.8647}, {171.166, 8.86293}, {171.167, 
       8.86107}, {171.168, 8.85917}, {171.168, 8.85723}, {171.169, 8.85533}, {
       171.168, 8.85343}, {171.168, 8.8516}, {171.168, 8.8498}, {171.167, 
       8.8481}, {171.166, 8.8465}, {171.165, 8.84503}, {171.163, 8.8437}, {
       171.162, 8.8425}, {171.16, 8.84147}, {171.158, 8.8406}, {171.156, 
       8.83993}, {171.154, 8.83947}, {171.152, 8.8392}, {171.15, 8.8391}, {
       171.147, 8.83923}, {171.145, 8.83953}, {171.143, 8.84007}, {171.141, 
       8.84077}, {171.139, 8.84167}, {171.137, 8.84273}, {171.135, 8.84393}, {
       171.133, 8.8453}, {171.131, 8.8468}}, {{168.821, 7.3528}, {168.82, 
       7.35393}, {168.821, 7.35513}, {168.821, 7.35633}, {168.822, 7.35757}, {
       168.824, 7.3588}, {168.825, 7.36003}, {168.827, 7.3612}, {168.83, 
       7.36237}, {168.832, 7.36347}, {168.835, 7.3645}, {168.838, 7.36547}, {
       168.842, 7.36637}, {168.845, 7.36713}, {168.849, 7.36783}, {168.852, 
       7.3684}, {168.856, 7.36887}, {168.86, 7.36917}, {168.863, 7.3694}, {
       168.867, 7.36947}, {168.87, 7.3694}, {168.873, 7.36923}, {168.876, 
       7.36893}, {168.879, 7.3685}, {168.882, 7.36797}, {168.884, 7.3673}, {
       168.886, 7.36653}, {168.888, 7.36567}, {168.889, 7.36473}, {168.89, 
       7.3637}, {168.891, 7.3626}, {168.891, 7.36147}, {168.891, 7.36027}, {
       168.89, 7.35907}, {168.889, 7.35783}, {168.888, 7.3566}, {168.886, 
       7.35537}, {168.884, 7.3542}, {168.881, 7.35303}, {168.879, 7.35193}, {
       168.876, 7.3509}, {168.873, 7.34993}, {168.87, 7.34903}, {168.866, 
       7.34827}, {168.863, 7.34757}, {168.859, 7.347}, {168.855, 7.34653}, {
       168.852, 7.34623}, {168.848, 7.346}, {168.844, 7.34593}, {168.841, 
       7.346}, {168.838, 7.34617}, {168.835, 7.34647}, {168.832, 7.3469}, {
       168.829, 7.34743}, {168.827, 7.3481}, {168.825, 7.34887}, {168.823, 
       7.34973}, {168.822, 7.35067}, {168.821, 7.3517}, {168.821, 7.3528}}, {{
       169.181, 9.72507}, {169.18, 9.72693}, {169.179, 9.7289}, {169.178, 
       9.73093}, {169.177, 9.733}, {169.177, 9.7351}, {169.177, 9.7372}, {
       169.176, 9.73927}, {169.177, 9.74133}, {169.177, 9.7433}, {169.178, 
       9.74517}, {169.178, 9.74697}, {169.179, 9.7486}, {169.181, 9.75013}, {
       169.182, 9.75147}, {169.183, 9.75263}, {169.185, 9.7536}, {169.187, 
       9.75437}, {169.189, 9.75493}, {169.191, 9.7553}, {169.193, 9.75543}, {
       169.195, 9.75533}, {169.197, 9.75503}, {169.199, 9.75453}, {169.201, 
       9.7538}, {169.203, 9.75283}, {169.205, 9.75173}, {169.206, 9.7504}, {
       169.208, 9.74893}, {169.21, 9.74733}, {169.211, 9.74557}, {169.212, 
       9.7437}, {169.213, 9.74173}, {169.214, 9.7397}, {169.215, 9.73763}, {
       169.215, 9.73553}, {169.216, 9.73343}, {169.216, 9.73137}, {169.216, 
       9.7293}, {169.215, 9.72733}, {169.215, 9.72547}, {169.214, 9.72367}, {
       169.213, 9.72203}, {169.212, 9.7205}, {169.21, 9.71917}, {169.209, 
       9.718}, {169.207, 9.71703}, {169.205, 9.71627}, {169.204, 9.7157}, {
       169.202, 9.71533}, {169.2, 9.7152}, {169.198, 9.7153}, {169.196, 
       9.7156}, {169.193, 9.7161}, {169.191, 9.71683}, {169.19, 9.7178}, {
       169.188, 9.7189}, {169.186, 9.72023}, {169.184, 9.7217}, {169.183, 
       9.7233}, {169.181, 9.72507}}, {{171.589, 6.1209}, {171.587, 6.12203}, {
       171.586, 6.12333}, {171.584, 6.1247}, {171.583, 6.12617}, {171.582, 
       6.1277}, {171.582, 6.1293}, {171.582, 6.1309}, {171.582, 6.13257}, {
       171.582, 6.1342}, {171.582, 6.13583}, {171.583, 6.1374}, {171.584, 
       6.13897}, {171.586, 6.14043}, {171.587, 6.1418}, {171.589, 6.14307}, {
       171.591, 6.14423}, {171.593, 6.1453}, {171.595, 6.1462}, {171.598, 
       6.14693}, {171.6, 6.14753}, {171.603, 6.14797}, {171.605, 6.1482}, {
       171.608, 6.1483}, {171.61, 6.14823}, {171.613, 6.14797}, {171.615, 
       6.14753}, {171.618, 6.14697}, {171.62, 6.1462}, {171.622, 6.1453}, {
       171.624, 6.14427}, {171.626, 6.14313}, {171.627, 6.14183}, {171.629, 
       6.14047}, {171.63, 6.139}, {171.631, 6.13747}, {171.631, 6.13587}, {
       171.631, 6.13427}, {171.631, 6.1326}, {171.631, 6.13097}, {171.631, 
       6.12933}, {171.63, 6.12777}, {171.629, 6.1262}, {171.627, 6.12473}, {
       171.626, 6.12337}, {171.624, 6.1221}, {171.622, 6.12093}, {171.62, 
       6.11987}, {171.618, 6.11897}, {171.615, 6.11823}, {171.613, 6.11763}, {
       171.61, 6.1172}, {171.608, 6.11697}, {171.605, 6.11687}, {171.603, 
       6.11693}, {171.6, 6.1172}, {171.598, 6.11763}, {171.595, 6.1182}, {
       171.593, 6.11897}, {171.591, 6.11987}, {171.589, 6.1209}}, {{170.044, 
       9.3504}, {170.044, 9.3524}, {170.045, 9.35443}, {170.046, 9.35647}, {
       170.047, 9.35847}, {170.048, 9.3604}, {170.049, 9.3623}, {170.051, 
       9.36407}, {170.052, 9.36577}, {170.054, 9.36733}, {170.056, 9.36873}, {
       170.058, 9.36997}, {170.06, 9.37107}, {170.062, 9.37193}, {170.065, 
       9.37263}, {170.067, 9.37313}, {170.069, 9.37343}, {170.071, 9.3735}, {
       170.073, 9.37337}, {170.075, 9.373}, {170.077, 9.37243}, {170.078, 
       9.3717}, {170.08, 9.37073}, {170.081, 9.3696}, {170.083, 9.3683}, {
       170.084, 9.36683}, {170.084, 9.36523}, {170.085, 9.36353}, {170.085, 
       9.3617}, {170.085, 9.3598}, {170.085, 9.35783}, {170.085, 9.35583}, {
       170.084, 9.3538}, {170.084, 9.35177}, {170.083, 9.34977}, {170.082, 
       9.34783}, {170.08, 9.34593}, {170.079, 9.34417}, {170.077, 9.34247}, {
       170.075, 9.3409}, {170.073, 9.3395}, {170.071, 9.33827}, {170.069, 
       9.33717}, {170.067, 9.3363}, {170.065, 9.3356}, {170.063, 9.3351}, {
       170.061, 9.3348}, {170.058, 9.33473}, {170.056, 9.33487}, {170.054, 
       9.33523}, {170.053, 9.3358}, {170.051, 9.33653}, {170.049, 9.3375}, {
       170.048, 9.33863}, {170.047, 9.33993}, {170.046, 9.3414}, {170.045, 
       9.343}, {170.044, 9.3447}, {170.044, 9.34653}, {170.044, 9.34843}, {
       170.044, 9.3504}}, {{166.822, 11.1977}, {166.822, 11.1996}, {166.822, 
       11.2016}, {166.822, 11.2036}, {166.822, 11.2055}, {166.823, 11.2075}, {
       166.824, 11.2094}, {166.825, 11.2112}, {166.826, 11.2129}, {166.828, 
       11.2145}, {166.83, 11.216}, {166.831, 11.2173}, {166.833, 11.2185}, {
       166.835, 11.2195}, {166.837, 11.2203}, {166.839, 11.221}, {166.842, 
       11.2214}, {166.844, 11.2217}, {166.846, 11.2217}, {166.848, 11.2215}, {
       166.85, 11.2211}, {166.852, 11.2205}, {166.854, 11.2198}, {166.855, 
       11.2188}, {166.857, 11.2177}, {166.858, 11.2164}, {166.86, 11.2149}, {
       166.861, 11.2133}, {166.862, 11.2116}, {166.862, 11.2098}, {166.863, 
       11.208}, {166.863, 11.2061}, {166.863, 11.2041}, {166.862, 11.2021}, {
       166.862, 11.2002}, {166.861, 11.1982}, {166.86, 11.1963}, {166.859, 
       11.1945}, {166.858, 11.1928}, {166.856, 11.1912}, {166.855, 11.1897}, {
       166.853, 11.1884}, {166.851, 11.1872}, {166.849, 11.1862}, {166.847, 
       11.1854}, {166.845, 11.1847}, {166.843, 11.1843}, {166.841, 11.184}, {
       166.839, 11.184}, {166.836, 11.1842}, {166.834, 11.1846}, {166.832, 
       11.1852}, {166.831, 11.1859}, {166.829, 11.1869}, {166.827, 11.188}, {
       166.826, 11.1893}, {166.825, 11.1908}, {166.824, 11.1924}, {166.823, 
       11.1941}, {166.822, 11.1959}, {166.822, 11.1977}}, {{169.55, 
       6.27597}, {169.551, 6.2783}, {169.552, 6.2807}, {169.553, 6.2831}, {
       169.554, 6.2855}, {169.555, 6.28783}, {169.557, 6.29013}, {169.558, 
       6.29233}, {169.56, 6.2944}, {169.562, 6.29637}, {169.564, 6.29817}, {
       169.566, 6.29977}, {169.568, 6.3012}, {169.57, 6.3024}, {169.572, 
       6.3034}, {169.574, 6.30417}, {169.576, 6.30467}, {169.577, 6.30493}, {
       169.579, 6.30493}, {169.581, 6.3047}, {169.582, 6.3042}, {169.584, 
       6.30347}, {169.585, 6.3025}, {169.586, 6.30133}, {169.587, 6.2999}, {
       169.587, 6.2983}, {169.588, 6.29653}, {169.588, 6.2946}, {169.588, 
       6.29253}, {169.588, 6.29033}, {169.587, 6.28803}, {169.587, 6.2857}, {
       169.586, 6.2833}, {169.585, 6.2809}, {169.584, 6.2785}, {169.583, 
       6.27617}, {169.581, 6.27387}, {169.579, 6.27167}, {169.578, 6.2696}, {
       169.576, 6.26763}, {169.574, 6.26583}, {169.572, 6.26423}, {169.57, 
       6.2628}, {169.568, 6.2616}, {169.566, 6.2606}, {169.564, 6.25983}, {
       169.562, 6.25933}, {169.56, 6.25907}, {169.559, 6.25907}, {169.557, 
       6.2593}, {169.555, 6.2598}, {169.554, 6.26053}, {169.553, 6.2615}, {
       169.552, 6.26267}, {169.551, 6.26407}, {169.55, 6.26567}, {169.55, 
       6.26747}, {169.55, 6.2694}, {169.55, 6.27147}, {169.55, 6.27367}, {
       169.55, 6.27597}}, {{169.743, 9.30497}, {169.74, 9.3059}, {169.738, 
       9.30697}, {169.735, 9.30817}, {169.733, 9.30947}, {169.73, 9.3109}, {
       169.728, 9.3124}, {169.726, 9.31397}, {169.724, 9.31563}, {169.722, 
       9.3173}, {169.721, 9.31897}, {169.72, 9.32067}, {169.719, 9.32233}, {
       169.718, 9.32397}, {169.718, 9.32557}, {169.718, 9.32707}, {169.718, 
       9.3285}, {169.719, 9.3298}, {169.72, 9.331}, {169.721, 9.33207}, {
       169.722, 9.333}, {169.724, 9.33377}, {169.726, 9.33437}, {169.728, 
       9.3348}, {169.73, 9.33507}, {169.732, 9.33513}, {169.735, 9.33507}, {
       169.737, 9.3348}, {169.74, 9.33437}, {169.743, 9.33373}, {169.746, 
       9.33297}, {169.748, 9.33203}, {169.751, 9.33097}, {169.754, 9.32977}, {
       169.756, 9.32847}, {169.759, 9.32703}, {169.761, 9.32553}, {169.763, 
       9.32397}, {169.765, 9.3223}, {169.767, 9.32063}, {169.768, 9.31897}, {
       169.769, 9.31727}, {169.77, 9.3156}, {169.771, 9.31397}, {169.771, 
       9.31237}, {169.771, 9.31087}, {169.771, 9.30943}, {169.77, 9.30813}, {
       169.769, 9.30693}, {169.768, 9.30587}, {169.767, 9.30493}, {169.765, 
       9.30417}, {169.763, 9.30357}, {169.761, 9.30313}, {169.759, 9.30287}, {
       169.757, 9.3028}, {169.754, 9.30287}, {169.751, 9.30313}, {169.749, 
       9.30357}, {169.746, 9.3042}, {169.743, 9.30497}}, {{168.71, 7.33267}, {
       168.706, 7.332}, {168.702, 7.33143}, {168.699, 7.33093}, {168.695, 
       7.33057}, {168.691, 7.33033}, {168.687, 7.33017}, {168.683, 7.33013}, {
       168.68, 7.33023}, {168.676, 7.33043}, {168.673, 7.33073}, {168.67, 
       7.33117}, {168.667, 7.33167}, {168.664, 7.3323}, {168.662, 7.333}, {
       168.66, 7.3338}, {168.658, 7.33467}, {168.657, 7.3356}, {168.656, 
       7.33657}, {168.656, 7.3376}, {168.656, 7.33867}, {168.656, 7.33973}, {
       168.657, 7.34083}, {168.658, 7.34193}, {168.66, 7.343}, {168.662, 
       7.34403}, {168.664, 7.34507}, {168.667, 7.34603}, {168.67, 7.34693}, {
       168.673, 7.34777}, {168.676, 7.3485}, {168.68, 7.34917}, {168.684, 
       7.34973}, {168.687, 7.35023}, {168.691, 7.3506}, {168.695, 7.35083}, {
       168.699, 7.351}, {168.703, 7.35103}, {168.706, 7.35093}, {168.71, 
       7.35073}, {168.713, 7.35043}, {168.716, 7.35}, {168.719, 7.3495}, {
       168.722, 7.34887}, {168.724, 7.34817}, {168.726, 7.34737}, {168.728, 
       7.3465}, {168.729, 7.34557}, {168.73, 7.3446}, {168.73, 7.34357}, {
       168.73, 7.3425}, {168.73, 7.34143}, {168.729, 7.34033}, {168.728, 
       7.33923}, {168.726, 7.33817}, {168.724, 7.33713}, {168.722, 7.3361}, {
       168.719, 7.33513}, {168.716, 7.33423}, {168.713, 7.3334}, {168.71, 
       7.33267}}, {{171.374, 8.68883}, {171.372, 8.6903}, {171.37, 8.6919}, {
       171.368, 8.6936}, {171.367, 8.69537}, {171.365, 8.6972}, {171.364, 
       8.69907}, {171.364, 8.701}, {171.363, 8.7029}, {171.363, 8.70477}, {
       171.362, 8.70663}, {171.363, 8.7084}, {171.363, 8.71013}, {171.363, 
       8.71173}, {171.364, 8.71323}, {171.365, 8.7146}, {171.366, 8.7158}, {
       171.368, 8.71687}, {171.369, 8.71773}, {171.371, 8.71843}, {171.373, 
       8.71893}, {171.375, 8.71927}, {171.377, 8.71937}, {171.379, 8.7193}, {
       171.382, 8.719}, {171.384, 8.71853}, {171.386, 8.71787}, {171.388, 
       8.717}, {171.391, 8.716}, {171.393, 8.7148}, {171.395, 8.71347}, {
       171.397, 8.712}, {171.398, 8.7104}, {171.4, 8.7087}, {171.401, 
       8.70693}, {171.403, 8.7051}, {171.404, 8.70323}, {171.405, 8.7013}, {
       171.405, 8.6994}, {171.406, 8.69753}, {171.406, 8.69567}, {171.406, 
       8.6939}, {171.405, 8.69217}, {171.405, 8.69057}, {171.404, 8.68907}, {
       171.403, 8.6877}, {171.402, 8.6865}, {171.4, 8.68543}, {171.399, 
       8.68457}, {171.397, 8.68387}, {171.395, 8.68337}, {171.393, 8.68303}, {
       171.391, 8.68293}, {171.389, 8.683}, {171.387, 8.6833}, {171.384, 
       8.68377}, {171.382, 8.68443}, {171.38, 8.6853}, {171.378, 8.6863}, {
       171.376, 8.6875}, {171.374, 8.68883}}, {{166.749, 11.4701}, {166.748, 
       11.4717}, {166.747, 11.4735}, {166.746, 11.4752}, {166.746, 11.477}, {
       166.746, 11.4788}, {166.746, 11.4806}, {166.747, 11.4824}, {166.747, 
       11.4841}, {166.748, 11.4857}, {166.749, 11.4873}, {166.751, 11.4887}, {
       166.752, 11.4901}, {166.754, 11.4913}, {166.756, 11.4923}, {166.758, 
       11.4932}, {166.76, 11.4939}, {166.762, 11.4945}, {166.764, 11.4949}, {
       166.766, 11.495}, {166.768, 11.495}, {166.771, 11.4948}, {166.773, 
       11.4944}, {166.775, 11.4939}, {166.777, 11.4931}, {166.779, 11.4922}, {
       166.781, 11.4911}, {166.783, 11.4899}, {166.784, 11.4886}, {166.786, 
       11.4871}, {166.787, 11.4855}, {166.788, 11.4839}, {166.788, 11.4822}, {
       166.789, 11.4804}, {166.789, 11.4786}, {166.789, 11.4768}, {166.789, 
       11.475}, {166.789, 11.4733}, {166.788, 11.4715}, {166.787, 11.4699}, {
       166.786, 11.4683}, {166.785, 11.4669}, {166.783, 11.4656}, {166.781, 
       11.4644}, {166.78, 11.4633}, {166.778, 11.4624}, {166.776, 11.4617}, {
       166.773, 11.4611}, {166.771, 11.4608}, {166.769, 11.4606}, {166.767, 
       11.4606}, {166.765, 11.4608}, {166.762, 11.4612}, {166.76, 11.4618}, {
       166.758, 11.4625}, {166.756, 11.4634}, {166.754, 11.4645}, {166.753, 
       11.4657}, {166.751, 11.4671}, {166.75, 11.4685}, {166.749, 
       11.4701}}, {{170.162, 12.262}, {170.167, 12.2722}, {170.179, 
       12.2834}, {170.2, 12.2843}, {170.214, 12.275}, {170.208, 12.262}, {
       170.19, 12.2527}, {170.172, 12.2537}, {170.162, 12.262}}, {{166.043, 
       10.0263}, {166.043, 10.0281}, {166.044, 10.0298}, {166.045, 10.0315}, {
       166.047, 10.0331}, {166.048, 10.0346}, {166.05, 10.0361}, {166.052, 
       10.0374}, {166.054, 10.0386}, {166.056, 10.0397}, {166.058, 10.0406}, {
       166.061, 10.0414}, {166.063, 10.042}, {166.065, 10.0424}, {166.068, 
       10.0426}, {166.07, 10.0427}, {166.072, 10.0425}, {166.074, 10.0422}, {
       166.077, 10.0417}, {166.078, 10.0411}, {166.08, 10.0402}, {166.082, 
       10.0392}, {166.083, 10.0381}, {166.085, 10.0368}, {166.086, 10.0354}, {
       166.086, 10.0339}, {166.087, 10.0324}, {166.087, 10.0307}, {166.087, 
       10.029}, {166.087, 10.0272}, {166.087, 10.0255}, {166.086, 10.0237}, {
       166.085, 10.022}, {166.084, 10.0203}, {166.083, 10.0187}, {166.081, 
       10.0172}, {166.08, 10.0157}, {166.078, 10.0144}, {166.076, 10.0132}, {
       166.074, 10.0121}, {166.071, 10.0112}, {166.069, 10.0104}, {166.067, 
       10.0098}, {166.064, 10.0094}, {166.062, 10.0092}, {166.06, 10.0091}, {
       166.057, 10.0093}, {166.055, 10.0096}, {166.053, 10.0101}, {166.051, 
       10.0107}, {166.049, 10.0116}, {166.048, 10.0126}, {166.046, 10.0137}, {
       166.045, 10.015}, {166.044, 10.0164}, {166.043, 10.0179}, {166.043, 
       10.0194}, {166.042, 10.0211}, {166.042, 10.0228}, {166.042, 10.0246}, {
       166.043, 10.0263}}, {{169.916, 10.1823}, {169.915, 10.1836}, {169.915, 
       10.185}, {169.914, 10.1864}, {169.914, 10.1878}, {169.915, 10.1892}, {
       169.915, 10.1905}, {169.916, 10.1918}, {169.917, 10.1931}, {169.919, 
       10.1943}, {169.92, 10.1954}, {169.922, 10.1964}, {169.924, 10.1973}, {
       169.927, 10.1981}, {169.929, 10.1987}, {169.932, 10.1992}, {169.934, 
       10.1996}, {169.937, 10.1999}, {169.94, 10.2}, {169.943, 10.1999}, {
       169.946, 10.1997}, {169.949, 10.1994}, {169.951, 10.1989}, {169.954, 
       10.1983}, {169.956, 10.1975}, {169.959, 10.1967}, {169.961, 10.1957}, {
       169.963, 10.1946}, {169.964, 10.1935}, {169.966, 10.1922}, {169.967, 
       10.1909}, {169.968, 10.1896}, {169.969, 10.1882}, {169.969, 10.1868}, {
       169.969, 10.1854}, {169.969, 10.184}, {169.968, 10.1827}, {169.967, 
       10.1813}, {169.966, 10.1801}, {169.965, 10.1789}, {169.963, 10.1778}, {
       169.961, 10.1768}, {169.959, 10.1759}, {169.957, 10.1751}, {169.954, 
       10.1745}, {169.952, 10.1739}, {169.949, 10.1736}, {169.946, 10.1733}, {
       169.943, 10.1732}, {169.94, 10.1733}, {169.937, 10.1735}, {169.935, 
       10.1738}, {169.932, 10.1743}, {169.929, 10.1749}, {169.927, 10.1756}, {
       169.924, 10.1765}, {169.922, 10.1775}, {169.92, 10.1786}, {169.919, 
       10.1797}, {169.917, 10.181}, {169.916, 10.1823}}, {{171.382, 8.2686}, {
       171.381, 8.27057}, {171.381, 8.27257}, {171.381, 8.27457}, {171.382, 
       8.2766}, {171.382, 8.27857}, {171.383, 8.28053}, {171.384, 8.28243}, {
       171.385, 8.28423}, {171.387, 8.2859}, {171.388, 8.28747}, {171.39, 
       8.2889}, {171.391, 8.29017}, {171.393, 8.29127}, {171.395, 8.2922}, {
       171.397, 8.29293}, {171.399, 8.29343}, {171.401, 8.29377}, {171.403, 
       8.29387}, {171.405, 8.29377}, {171.407, 8.29347}, {171.409, 8.29293}, {
       171.411, 8.2922}, {171.412, 8.2913}, {171.414, 8.2902}, {171.415, 
       8.28893}, {171.416, 8.2875}, {171.417, 8.28593}, {171.418, 8.28423}, {
       171.419, 8.28243}, {171.419, 8.28057}, {171.42, 8.2786}, {171.42, 
       8.2766}, {171.419, 8.2746}, {171.419, 8.27257}, {171.419, 8.2706}, {
       171.418, 8.26863}, {171.417, 8.26673}, {171.416, 8.26493}, {171.414, 
       8.26327}, {171.413, 8.2617}, {171.411, 8.26027}, {171.409, 8.259}, {
       171.408, 8.2579}, {171.406, 8.25697}, {171.404, 8.25623}, {171.402, 
       8.25573}, {171.4, 8.2554}, {171.398, 8.2553}, {171.396, 8.2554}, {
       171.394, 8.2557}, {171.392, 8.25623}, {171.39, 8.25697}, {171.389, 
       8.25787}, {171.387, 8.25897}, {171.386, 8.26023}, {171.385, 8.26167}, {
       171.384, 8.26323}, {171.383, 8.26493}, {171.382, 8.26673}, {171.382, 
       8.2686}}, {{169.726, 5.97753}, {169.727, 5.97937}, {169.728, 
       5.98117}, {169.729, 5.98297}, {169.731, 5.9847}, {169.733, 5.98637}, {
       169.734, 5.9879}, {169.736, 5.98937}, {169.738, 5.9907}, {169.741, 
       5.9919}, {169.743, 5.99293}, {169.745, 5.9938}, {169.748, 5.9945}, {
       169.75, 5.995}, {169.752, 5.99533}, {169.754, 5.99547}, {169.757, 
       5.99543}, {169.759, 5.9952}, {169.761, 5.99477}, {169.762, 5.99413}, {
       169.764, 5.99333}, {169.765, 5.99237}, {169.767, 5.99127}, {169.768, 
       5.98997}, {169.768, 5.98857}, {169.769, 5.98707}, {169.769, 5.98543}, {
       169.769, 5.98373}, {169.769, 5.982}, {169.769, 5.98017}, {169.768, 
       5.97833}, {169.767, 5.9765}, {169.766, 5.9747}, {169.765, 5.9729}, {
       169.763, 5.97117}, {169.762, 5.9695}, {169.76, 5.96797}, {169.758, 
       5.9665}, {169.756, 5.96517}, {169.754, 5.96397}, {169.751, 5.96293}, {
       169.749, 5.96207}, {169.747, 5.96137}, {169.745, 5.96087}, {169.742, 
       5.96053}, {169.74, 5.9604}, {169.738, 5.96043}, {169.736, 5.96067}, {
       169.734, 5.9611}, {169.732, 5.96173}, {169.73, 5.96253}, {169.729, 
       5.9635}, {169.728, 5.9646}, {169.727, 5.9659}, {169.726, 5.9673}, {
       169.725, 5.9688}, {169.725, 5.97043}, {169.725, 5.97213}, {169.725, 
       5.97387}, {169.726, 5.9757}, {169.726, 5.97753}}, {{169.616, 6.0977}, {
       169.615, 6.09977}, {169.615, 6.10187}, {169.615, 6.104}, {169.616, 
       6.10617}, {169.616, 6.1083}, {169.617, 6.1104}, {169.618, 6.11243}, {
       169.619, 6.1144}, {169.62, 6.11623}, {169.621, 6.11797}, {169.623, 
       6.11953}, {169.624, 6.12097}, {169.626, 6.1222}, {169.628, 6.12323}, {
       169.63, 6.12407}, {169.631, 6.1247}, {169.633, 6.1251}, {169.635, 
       6.1253}, {169.637, 6.12527}, {169.639, 6.125}, {169.641, 6.12453}, {
       169.642, 6.12383}, {169.644, 6.1229}, {169.645, 6.1218}, {169.647, 
       6.1205}, {169.648, 6.11903}, {169.649, 6.1174}, {169.65, 6.11563}, {
       169.65, 6.11377}, {169.651, 6.11177}, {169.651, 6.1097}, {169.651, 
       6.1076}, {169.651, 6.10547}, {169.651, 6.1033}, {169.65, 6.10117}, {
       169.649, 6.09907}, {169.649, 6.09703}, {169.648, 6.09507}, {169.646, 
       6.09323}, {169.645, 6.0915}, {169.644, 6.08993}, {169.642, 6.0885}, {
       169.64, 6.08727}, {169.639, 6.08623}, {169.637, 6.0854}, {169.635, 
       6.08477}, {169.633, 6.08437}, {169.631, 6.08417}, {169.629, 6.0842}, {
       169.628, 6.08447}, {169.626, 6.08493}, {169.624, 6.08563}, {169.623, 
       6.08657}, {169.621, 6.08767}, {169.62, 6.08897}, {169.619, 6.09043}, {
       169.618, 6.09207}, {169.617, 6.09383}, {169.616, 6.0957}, {169.616, 
       6.0977}}, {{168.886, 7.54133}, {168.885, 7.5423}, {168.885, 7.5434}, {
       168.885, 7.5446}, {168.886, 7.54587}, {168.887, 7.5472}, {168.888, 
       7.5486}, {168.89, 7.55007}, {168.892, 7.55153}, {168.894, 7.553}, {
       168.896, 7.5545}, {168.899, 7.55593}, {168.902, 7.55737}, {168.905, 
       7.55873}, {168.909, 7.56003}, {168.912, 7.56123}, {168.916, 7.56233}, {
       168.919, 7.56337}, {168.923, 7.56423}, {168.926, 7.565}, {168.929, 
       7.56563}, {168.933, 7.5661}, {168.936, 7.56643}, {168.939, 7.5666}, {
       168.941, 7.56663}, {168.944, 7.5665}, {168.946, 7.5662}, {168.948, 
       7.56577}, {168.95, 7.56517}, {168.951, 7.56447}, {168.952, 7.5636}, {
       168.952, 7.56263}, {168.952, 7.56153}, {168.952, 7.56033}, {168.952, 
       7.55907}, {168.951, 7.55773}, {168.949, 7.55633}, {168.948, 7.55487}, {
       168.946, 7.5534}, {168.943, 7.55193}, {168.941, 7.55043}, {168.938, 
       7.549}, {168.935, 7.54757}, {168.932, 7.5462}, {168.929, 7.5449}, {
       168.925, 7.5437}, {168.922, 7.5426}, {168.918, 7.54157}, {168.915, 
       7.5407}, {168.911, 7.53993}, {168.908, 7.5393}, {168.905, 7.53883}, {
       168.902, 7.5385}, {168.899, 7.53833}, {168.896, 7.5383}, {168.893, 
       7.53843}, {168.891, 7.53873}, {168.889, 7.53917}, {168.888, 7.53977}, {
       168.887, 7.54047}, {168.886, 7.54133}}, {{165.509, 9.18317}, {165.51, 
       9.18527}, {165.512, 9.18737}, {165.513, 9.18947}, {165.515, 9.1915}, {
       165.517, 9.1935}, {165.519, 9.1954}, {165.521, 9.1972}, {165.523, 
       9.19887}, {165.526, 9.2004}, {165.528, 9.2018}, {165.53, 9.203}, {
       165.533, 9.20403}, {165.535, 9.20483}, {165.537, 9.20547}, {165.539, 
       9.20587}, {165.541, 9.20603}, {165.543, 9.206}, {165.545, 9.20573}, {
       165.546, 9.20527}, {165.548, 9.20457}, {165.549, 9.2037}, {165.55, 
       9.2026}, {165.55, 9.20133}, {165.551, 9.1999}, {165.551, 9.19833}, {
       165.551, 9.1966}, {165.55, 9.19477}, {165.55, 9.19283}, {165.549, 
       9.1908}, {165.548, 9.18877}, {165.547, 9.18667}, {165.545, 9.18457}, {
       165.544, 9.18247}, {165.542, 9.18043}, {165.54, 9.17843}, {165.538, 
       9.17653}, {165.535, 9.17473}, {165.533, 9.17307}, {165.531, 9.1715}, {
       165.529, 9.17013}, {165.526, 9.16893}, {165.524, 9.1679}, {165.522, 
       9.1671}, {165.519, 9.16647}, {165.517, 9.16607}, {165.515, 9.1659}, {
       165.513, 9.16593}, {165.512, 9.1662}, {165.51, 9.16667}, {165.509, 
       9.16737}, {165.508, 9.16823}, {165.507, 9.16933}, {165.506, 9.1706}, {
       165.506, 9.17203}, {165.506, 9.1736}, {165.506, 9.17533}, {165.506, 
       9.17717}, {165.507, 9.1791}, {165.508, 9.1811}, {165.509, 9.18317}}, {{
       162.184, 11.378}, {162.182, 11.3774}, {162.18, 11.377}, {162.177, 
       11.3768}, {162.175, 11.3767}, {162.172, 11.3768}, {162.17, 11.377}, {
       162.168, 11.3774}, {162.165, 11.378}, {162.163, 11.3787}, {162.161, 
       11.3796}, {162.159, 11.3806}, {162.158, 11.3818}, {162.156, 11.383}, {
       162.155, 11.3844}, {162.154, 11.3859}, {162.153, 11.3874}, {162.152, 
       11.3889}, {162.152, 11.3905}, {162.152, 11.3921}, {162.152, 11.3938}, {
       162.152, 11.3954}, {162.153, 11.3969}, {162.154, 11.3984}, {162.155, 
       11.3999}, {162.156, 11.4013}, {162.158, 11.4025}, {162.159, 11.4037}, {
       162.161, 11.4047}, {162.163, 11.4056}, {162.165, 11.4063}, {162.168, 
       11.4069}, {162.17, 11.4073}, {162.172, 11.4075}, {162.175, 11.4076}, {
       162.177, 11.4075}, {162.18, 11.4073}, {162.182, 11.4069}, {162.184, 
       11.4063}, {162.187, 11.4056}, {162.189, 11.4047}, {162.19, 11.4037}, {
       162.192, 11.4025}, {162.194, 11.4013}, {162.195, 11.3999}, {162.196, 
       11.3984}, {162.197, 11.3969}, {162.198, 11.3954}, {162.198, 11.3938}, {
       162.198, 11.3922}, {162.198, 11.3905}, {162.198, 11.3889}, {162.197, 
       11.3874}, {162.196, 11.3859}, {162.195, 11.3844}, {162.194, 11.383}, {
       162.192, 11.3818}, {162.19, 11.3806}, {162.189, 11.3796}, {162.187, 
       11.3787}, {162.184, 11.378}}, {{172.106, 5.9512}, {172.104, 5.95243}, {
       172.101, 5.95377}, {172.099, 5.95523}, {172.098, 5.9568}, {172.096, 
       5.95847}, {172.094, 5.96017}, {172.093, 5.96193}, {172.092, 5.9637}, {
       172.091, 5.9655}, {172.09, 5.96727}, {172.09, 5.96903}, {172.09, 
       5.9707}, {172.09, 5.97233}, {172.09, 5.97387}, {172.091, 5.9753}, {
       172.091, 5.9766}, {172.092, 5.97777}, {172.094, 5.9788}, {172.095, 
       5.97967}, {172.097, 5.98037}, {172.099, 5.9809}, {172.101, 5.98123}, {
       172.103, 5.98137}, {172.105, 5.98133}, {172.107, 5.98113}, {172.11, 
       5.98073}, {172.112, 5.98013}, {172.114, 5.97937}, {172.117, 5.97843}, {
       172.119, 5.97737}, {172.121, 5.97613}, {172.124, 5.9748}, {172.126, 
       5.97333}, {172.127, 5.97177}, {172.129, 5.9701}, {172.131, 5.9684}, {
       172.132, 5.96663}, {172.133, 5.96487}, {172.134, 5.96307}, {172.135, 
       5.9613}, {172.135, 5.95953}, {172.135, 5.95787}, {172.135, 5.95623}, {
       172.135, 5.9547}, {172.134, 5.95327}, {172.134, 5.95197}, {172.133, 
       5.9508}, {172.131, 5.94977}, {172.13, 5.9489}, {172.128, 5.9482}, {
       172.126, 5.94767}, {172.124, 5.94733}, {172.122, 5.9472}, {172.12, 
       5.94723}, {172.118, 5.94743}, {172.115, 5.94783}, {172.113, 5.94843}, {
       172.111, 5.9492}, {172.108, 5.95013}, {172.106, 5.9512}}, {{166.275, 
       8.85963}, {166.273, 8.86093}, {166.272, 8.86233}, {166.271, 8.8638}, {
       166.27, 8.86537}, {166.269, 8.86697}, {166.269, 8.8686}, {166.269, 
       8.87023}, {166.269, 8.87187}, {166.269, 8.87347}, {166.27, 8.87507}, {
       166.271, 8.87657}, {166.272, 8.87803}, {166.273, 8.87937}, {166.275, 
       8.88063}, {166.276, 8.88177}, {166.278, 8.88277}, {166.28, 8.88363}, {
       166.282, 8.88433}, {166.284, 8.8849}, {166.287, 8.8853}, {166.289, 
       8.8855}, {166.291, 8.88557}, {166.294, 8.88543}, {166.296, 8.88513}, {
       166.298, 8.88467}, {166.301, 8.88407}, {166.303, 8.88327}, {166.305, 
       8.88233}, {166.307, 8.8813}, {166.308, 8.8801}, {166.31, 8.8788}, {
       166.311, 8.8774}, {166.312, 8.87593}, {166.313, 8.87437}, {166.314, 
       8.87277}, {166.314, 8.87113}, {166.314, 8.8695}, {166.314, 8.86787}, {
       166.314, 8.86627}, {166.313, 8.86467}, {166.312, 8.86317}, {166.311, 
       8.8617}, {166.31, 8.86037}, {166.308, 8.8591}, {166.307, 8.85797}, {
       166.305, 8.85697}, {166.303, 8.8561}, {166.301, 8.8554}, {166.299, 
       8.85483}, {166.296, 8.85443}, {166.294, 8.85423}, {166.292, 8.85417}, {
       166.289, 8.8543}, {166.287, 8.8546}, {166.285, 8.85507}, {166.282, 
       8.85567}, {166.28, 8.85647}, {166.278, 8.8574}, {166.276, 8.85843}, {
       166.275, 8.85963}}, {{165.717, 8.90083}, {165.714, 8.90043}, {165.711, 
       8.90017}, {165.708, 8.90003}, {165.706, 8.90003}, {165.703, 8.90017}, {
       165.7, 8.90043}, {165.697, 8.90083}, {165.694, 8.9014}, {165.692, 
       8.90207}, {165.689, 8.90283}, {165.687, 8.90373}, {165.685, 8.90473}, {
       165.683, 8.9058}, {165.682, 8.90697}, {165.681, 8.9082}, {165.68, 
       8.90947}, {165.679, 8.91077}, {165.679, 8.9121}, {165.679, 8.91343}, {
       165.679, 8.91477}, {165.679, 8.91607}, {165.68, 8.91733}, {165.681, 
       8.91857}, {165.683, 8.91973}, {165.684, 8.9208}, {165.686, 8.9218}, {
       165.688, 8.9227}, {165.691, 8.92347}, {165.693, 8.92413}, {165.696, 
       8.9247}, {165.698, 8.9251}, {165.701, 8.92537}, {165.704, 8.9255}, {
       165.707, 8.9255}, {165.71, 8.92537}, {165.713, 8.9251}, {165.715, 
       8.9247}, {165.718, 8.92413}, {165.721, 8.92347}, {165.723, 8.9227}, {
       165.725, 8.9218}, {165.727, 8.9208}, {165.729, 8.91973}, {165.731, 
       8.91857}, {165.732, 8.91733}, {165.733, 8.91607}, {165.734, 8.91477}, {
       165.734, 8.91343}, {165.734, 8.9121}, {165.734, 8.91077}, {165.733, 
       8.90947}, {165.732, 8.9082}, {165.731, 8.90697}, {165.73, 8.9058}, {
       165.728, 8.90473}, {165.726, 8.90373}, {165.724, 8.90283}, {165.722, 
       8.90207}, {165.72, 8.9014}, {165.717, 8.90083}}, {{169.054, 9.7989}, {
       169.053, 9.80067}, {169.052, 9.8025}, {169.051, 9.80437}, {169.051, 
       9.8063}, {169.051, 9.80823}, {169.051, 9.81017}, {169.051, 9.8121}, {
       169.051, 9.81397}, {169.052, 9.81577}, {169.052, 9.81747}, {169.053, 
       9.81907}, {169.055, 9.82053}, {169.056, 9.8219}, {169.057, 9.82307}, {
       169.059, 9.8241}, {169.061, 9.82493}, {169.062, 9.8256}, {169.064, 
       9.82603}, {169.066, 9.8263}, {169.068, 9.82637}, {169.07, 9.8262}, {
       169.072, 9.82587}, {169.074, 9.8253}, {169.076, 9.82457}, {169.078, 
       9.82363}, {169.08, 9.82257}, {169.081, 9.8213}, {169.083, 9.8199}, {
       169.084, 9.81833}, {169.085, 9.8167}, {169.086, 9.81493}, {169.087, 
       9.8131}, {169.088, 9.81123}, {169.088, 9.8093}, {169.089, 9.80737}, {
       169.089, 9.80543}, {169.088, 9.8035}, {169.088, 9.80163}, {169.088, 
       9.79983}, {169.087, 9.79813}, {169.086, 9.79653}, {169.085, 9.79507}, {
       169.083, 9.7937}, {169.082, 9.79253}, {169.08, 9.7915}, {169.079, 
       9.79067}, {169.077, 9.79}, {169.075, 9.78957}, {169.073, 9.7893}, {
       169.071, 9.78923}, {169.069, 9.7894}, {169.067, 9.78973}, {169.065, 
       9.7903}, {169.063, 9.79103}, {169.061, 9.79197}, {169.06, 9.79303}, {
       169.058, 9.7943}, {169.056, 9.7957}, {169.055, 9.79727}, {169.054, 
       9.7989}}, {{166.715, 11.1108}, {166.715, 11.1126}, {166.715, 
       11.1145}, {166.714, 11.1164}, {166.714, 11.1184}, {166.715, 11.1203}, {
       166.715, 11.1223}, {166.716, 11.1241}, {166.717, 11.1259}, {166.718, 
       11.1276}, {166.719, 11.1292}, {166.72, 11.1307}, {166.722, 11.132}, {
       166.723, 11.1332}, {166.725, 11.1342}, {166.727, 11.1351}, {166.729, 
       11.1357}, {166.731, 11.1361}, {166.733, 11.1364}, {166.735, 11.1364}, {
       166.737, 11.1362}, {166.738, 11.1359}, {166.74, 11.1353}, {166.742, 
       11.1345}, {166.744, 11.1336}, {166.745, 11.1325}, {166.747, 11.1312}, {
       166.748, 11.1297}, {166.749, 11.1282}, {166.75, 11.1265}, {166.751, 
       11.1247}, {166.751, 11.1229}, {166.752, 11.121}, {166.752, 11.1191}, {
       166.752, 11.1171}, {166.752, 11.1152}, {166.751, 11.1132}, {166.751, 
       11.1114}, {166.75, 11.1096}, {166.749, 11.1079}, {166.747, 11.1063}, {
       166.746, 11.1048}, {166.745, 11.1035}, {166.743, 11.1023}, {166.741, 
       11.1013}, {166.739, 11.1004}, {166.738, 11.0998}, {166.736, 11.0994}, {
       166.734, 11.0991}, {166.732, 11.0991}, {166.73, 11.0993}, {166.728, 
       11.0996}, {166.726, 11.1002}, {166.724, 11.101}, {166.723, 11.1019}, {
       166.721, 11.103}, {166.72, 11.1043}, {166.718, 11.1058}, {166.717, 
       11.1073}, {166.716, 11.109}, {166.715, 11.1108}}, {{167.611, 8.7521}, {
       167.61, 8.7537}, {167.609, 8.7554}, {167.608, 8.75713}, {167.608, 
       8.7589}, {167.608, 8.7607}, {167.608, 8.7625}, {167.608, 8.76427}, {
       167.608, 8.766}, {167.609, 8.76767}, {167.61, 8.76927}, {167.611, 
       8.77073}, {167.612, 8.77213}, {167.614, 8.77337}, {167.615, 8.7745}, {
       167.617, 8.77547}, {167.619, 8.77623}, {167.621, 8.77687}, {167.623, 
       8.7773}, {167.625, 8.77757}, {167.627, 8.77763}, {167.629, 8.77753}, {
       167.631, 8.7772}, {167.633, 8.77673}, {167.635, 8.77607}, {167.637, 
       8.77523}, {167.639, 8.77423}, {167.641, 8.77307}, {167.642, 8.7718}, {
       167.644, 8.77037}, {167.645, 8.76887}, {167.646, 8.76727}, {167.647, 
       8.76557}, {167.647, 8.76383}, {167.648, 8.76207}, {167.648, 8.76027}, {
       167.648, 8.75847}, {167.648, 8.7567}, {167.647, 8.75497}, {167.647, 
       8.7533}, {167.646, 8.7517}, {167.645, 8.75023}, {167.643, 8.74883}, {
       167.642, 8.7476}, {167.64, 8.74647}, {167.639, 8.7455}, {167.637, 
       8.74473}, {167.635, 8.7441}, {167.633, 8.74367}, {167.631, 8.7434}, {
       167.629, 8.74333}, {167.627, 8.74343}, {167.625, 8.74377}, {167.623, 
       8.74423}, {167.621, 8.7449}, {167.619, 8.74573}, {167.617, 8.74673}, {
       167.615, 8.7479}, {167.614, 8.74917}, {167.612, 8.7506}, {167.611, 
       8.7521}}, {{167.351, 9.09357}, {167.351, 9.09503}, {167.35, 9.09653}, {
       167.35, 9.09803}, {167.351, 9.0995}, {167.351, 9.10097}, {167.352, 
       9.1024}, {167.353, 9.10373}, {167.354, 9.10503}, {167.355, 9.10623}, {
       167.357, 9.10733}, {167.359, 9.10833}, {167.361, 9.1092}, {167.363, 
       9.10997}, {167.365, 9.11057}, {167.368, 9.111}, {167.37, 9.11133}, {
       167.372, 9.11147}, {167.375, 9.11147}, {167.378, 9.1113}, {167.38, 
       9.111}, {167.382, 9.1105}, {167.385, 9.1099}, {167.387, 9.10917}, {
       167.389, 9.10827}, {167.391, 9.10727}, {167.393, 9.10617}, {167.394, 
       9.10493}, {167.396, 9.10363}, {167.397, 9.10227}, {167.398, 9.10087}, {
       167.398, 9.0994}, {167.399, 9.0979}, {167.399, 9.0964}, {167.398, 
       9.09493}, {167.398, 9.09347}, {167.397, 9.09203}, {167.396, 9.0907}, {
       167.395, 9.0894}, {167.394, 9.0882}, {167.392, 9.0871}, {167.39, 
       9.0861}, {167.388, 9.08523}, {167.386, 9.08447}, {167.384, 9.08387}, {
       167.381, 9.08343}, {167.379, 9.0831}, {167.377, 9.08297}, {167.374, 
       9.08297}, {167.371, 9.08313}, {167.369, 9.08343}, {167.367, 9.08393}, {
       167.364, 9.08453}, {167.362, 9.08527}, {167.36, 9.08617}, {167.358, 
       9.08717}, {167.356, 9.08827}, {167.355, 9.0895}, {167.353, 9.0908}, {
       167.352, 9.09217}, {167.351, 9.09357}}, {{162.325, 11.3577}, {162.323, 
       11.3572}, {162.321, 11.3567}, {162.319, 11.3565}, {162.316, 11.3564}, {
       162.314, 11.3565}, {162.311, 11.3567}, {162.309, 11.3572}, {162.307, 
       11.3577}, {162.305, 11.3584}, {162.303, 11.3593}, {162.301, 11.3603}, {
       162.299, 11.3614}, {162.298, 11.3627}, {162.297, 11.364}, {162.295, 
       11.3654}, {162.295, 11.3669}, {162.294, 11.3684}, {162.294, 11.37}, {
       162.293, 11.3716}, {162.294, 11.3732}, {162.294, 11.3747}, {162.295, 
       11.3762}, {162.295, 11.3777}, {162.297, 11.3791}, {162.298, 11.3805}, {
       162.299, 11.3817}, {162.301, 11.3828}, {162.303, 11.3838}, {162.305, 
       11.3847}, {162.307, 11.3854}, {162.309, 11.386}, {162.311, 11.3864}, {
       162.314, 11.3866}, {162.316, 11.3867}, {162.319, 11.3866}, {162.321, 
       11.3864}, {162.323, 11.386}, {162.325, 11.3854}, {162.328, 11.3847}, {
       162.33, 11.3838}, {162.331, 11.3828}, {162.333, 11.3817}, {162.335, 
       11.3805}, {162.336, 11.3791}, {162.337, 11.3777}, {162.338, 11.3762}, {
       162.338, 11.3747}, {162.339, 11.3732}, {162.339, 11.3716}, {162.339, 
       11.37}, {162.338, 11.3684}, {162.338, 11.3669}, {162.337, 11.3654}, {
       162.336, 11.364}, {162.335, 11.3627}, {162.333, 11.3614}, {162.331, 
       11.3603}, {162.33, 11.3593}, {162.328, 11.3584}, {162.325, 
       11.3577}}, {{168.709, 7.4083}, {168.707, 7.40927}, {168.704, 7.4104}, {
       168.702, 7.41163}, {168.7, 7.41297}, {168.698, 7.4144}, {168.697, 
       7.41593}, {168.695, 7.4175}, {168.694, 7.41913}, {168.693, 7.42077}, {
       168.692, 7.42243}, {168.691, 7.42407}, {168.691, 7.4257}, {168.691, 
       7.42727}, {168.691, 7.42877}, {168.691, 7.4302}, {168.692, 7.43153}, {
       168.693, 7.43277}, {168.694, 7.43387}, {168.695, 7.43483}, {168.697, 
       7.43567}, {168.698, 7.43633}, {168.7, 7.43683}, {168.702, 7.43717}, {
       168.704, 7.43733}, {168.707, 7.43733}, {168.709, 7.43713}, {168.711, 
       7.4368}, {168.714, 7.43627}, {168.716, 7.4356}, {168.719, 7.43477}, {
       168.721, 7.4338}, {168.723, 7.43267}, {168.725, 7.43143}, {168.727, 
       7.4301}, {168.729, 7.42867}, {168.731, 7.42713}, {168.733, 7.42557}, {
       168.734, 7.42393}, {168.735, 7.4223}, {168.736, 7.42063}, {168.736, 
       7.419}, {168.737, 7.41737}, {168.737, 7.4158}, {168.737, 7.4143}, {
       168.736, 7.41287}, {168.736, 7.41153}, {168.735, 7.4103}, {168.734, 
       7.4092}, {168.733, 7.40823}, {168.731, 7.4074}, {168.729, 7.40673}, {
       168.727, 7.40623}, {168.725, 7.4059}, {168.723, 7.40573}, {168.721, 
       7.40573}, {168.719, 7.40593}, {168.716, 7.40627}, {168.714, 7.4068}, {
       168.711, 7.40747}, {168.709, 7.4083}}, {{170.726, 8.75383}, {170.725, 
       8.75543}, {170.725, 8.7571}, {170.724, 8.75883}, {170.724, 8.76057}, {
       170.724, 8.76233}, {170.724, 8.7641}, {170.724, 8.76583}, {170.725, 
       8.76753}, {170.725, 8.76913}, {170.726, 8.77067}, {170.728, 8.77213}, {
       170.729, 8.77343}, {170.73, 8.77463}, {170.732, 8.7757}, {170.734, 
       8.7766}, {170.736, 8.77733}, {170.738, 8.7779}, {170.74, 8.7783}, {
       170.742, 8.7785}, {170.744, 8.77853}, {170.746, 8.77837}, {170.748, 
       8.778}, {170.75, 8.7775}, {170.752, 8.7768}, {170.754, 8.77593}, {
       170.756, 8.7749}, {170.757, 8.77373}, {170.759, 8.77243}, {170.76, 
       8.77103}, {170.761, 8.7695}, {170.762, 8.7679}, {170.763, 8.76623}, {
       170.764, 8.7645}, {170.764, 8.76277}, {170.764, 8.761}, {170.764, 
       8.75923}, {170.764, 8.7575}, {170.763, 8.7558}, {170.762, 8.7542}, {
       170.761, 8.75267}, {170.76, 8.7512}, {170.759, 8.7499}, {170.757, 
       8.7487}, {170.756, 8.74763}, {170.754, 8.74673}, {170.752, 8.746}, {
       170.75, 8.74543}, {170.748, 8.74503}, {170.746, 8.74483}, {170.744, 
       8.7448}, {170.742, 8.74497}, {170.74, 8.74533}, {170.738, 8.74583}, {
       170.736, 8.74653}, {170.734, 8.7474}, {170.732, 8.74843}, {170.73, 
       8.7496}, {170.729, 8.7509}, {170.727, 8.7523}, {170.726, 8.75383}}, {{
       169.913, 10.2382}, {169.912, 10.2393}, {169.91, 10.2406}, {169.909, 
       10.2419}, {169.908, 10.2433}, {169.907, 10.2447}, {169.907, 10.2462}, {
       169.907, 10.2477}, {169.907, 10.2493}, {169.907, 10.2508}, {169.908, 
       10.2523}, {169.908, 10.2538}, {169.909, 10.2552}, {169.911, 10.2565}, {
       169.912, 10.2578}, {169.914, 10.259}, {169.916, 10.26}, {169.918, 
       10.261}, {169.92, 10.2617}, {169.922, 10.2624}, {169.924, 10.2629}, {
       169.927, 10.2633}, {169.929, 10.2634}, {169.932, 10.2635}, {169.934, 
       10.2633}, {169.936, 10.2631}, {169.939, 10.2626}, {169.941, 10.262}, {
       169.943, 10.2613}, {169.945, 10.2604}, {169.947, 10.2594}, {169.948, 
       10.2583}, {169.949, 10.257}, {169.951, 10.2557}, {169.952, 10.2543}, {
       169.952, 10.2529}, {169.953, 10.2514}, {169.953, 10.2499}, {169.953, 
       10.2483}, {169.953, 10.2468}, {169.952, 10.2453}, {169.951, 10.2438}, {
       169.95, 10.2424}, {169.949, 10.2411}, {169.947, 10.2398}, {169.946, 
       10.2386}, {169.944, 10.2376}, {169.942, 10.2366}, {169.94, 10.2359}, {
       169.938, 10.2352}, {169.935, 10.2347}, {169.933, 10.2343}, {169.931, 
       10.2342}, {169.928, 10.2341}, {169.926, 10.2343}, {169.923, 10.2345}, {
       169.921, 10.235}, {169.919, 10.2356}, {169.917, 10.2363}, {169.915, 
       10.2372}, {169.913, 10.2382}}, {{165.644, 8.99397}, {165.642, 
       8.99343}, {165.639, 8.99303}, {165.637, 8.99277}, {165.635, 8.9927}, {
       165.632, 8.99277}, {165.63, 8.99303}, {165.628, 8.99343}, {165.626, 
       8.99397}, {165.624, 8.99467}, {165.622, 8.99553}, {165.62, 8.9965}, {
       165.618, 8.99757}, {165.617, 8.9988}, {165.616, 9.00007}, {165.614, 
       9.00147}, {165.614, 9.0029}, {165.613, 9.0044}, {165.613, 9.00593}, {
       165.613, 9.00747}, {165.613, 9.009}, {165.613, 9.01053}, {165.614, 
       9.01203}, {165.614, 9.01347}, {165.616, 9.01487}, {165.617, 9.01613}, {
       165.618, 9.01733}, {165.62, 9.01843}, {165.622, 9.0194}, {165.624, 
       9.02027}, {165.626, 9.02097}, {165.628, 9.0215}, {165.63, 9.0219}, {
       165.632, 9.02217}, {165.635, 9.02223}, {165.637, 9.02217}, {165.639, 
       9.0219}, {165.642, 9.0215}, {165.644, 9.02097}, {165.646, 9.02027}, {
       165.648, 9.0194}, {165.65, 9.01843}, {165.651, 9.01737}, {165.653, 
       9.01613}, {165.654, 9.01487}, {165.655, 9.01347}, {165.656, 9.01203}, {
       165.656, 9.01053}, {165.657, 9.009}, {165.657, 9.00747}, {165.657, 
       9.00593}, {165.656, 9.0044}, {165.656, 9.0029}, {165.655, 9.00147}, {
       165.654, 9.00007}, {165.653, 8.9988}, {165.651, 8.9976}, {165.65, 
       8.9965}, {165.648, 8.99553}, {165.646, 8.99467}, {165.644, 
       8.99397}}, {{162.105, 11.4611}, {162.118, 11.4611}, {162.124, 
       11.4467}, {162.109, 11.4354}, {162.075, 11.4333}, {162.07, 11.4467}, {
       162.105, 11.4611}}, {{169.372, 6.27413}, {169.371, 6.276}, {169.371, 
       6.2779}, {169.371, 6.27987}, {169.371, 6.28183}, {169.372, 6.28377}, {
       169.372, 6.2857}, {169.373, 6.28757}, {169.374, 6.28937}, {169.375, 
       6.29107}, {169.376, 6.29267}, {169.377, 6.29413}, {169.378, 6.29543}, {
       169.38, 6.2966}, {169.382, 6.2976}, {169.383, 6.2984}, {169.385, 
       6.29903}, {169.387, 6.29943}, {169.389, 6.29967}, {169.391, 6.29967}, {
       169.392, 6.29947}, {169.394, 6.29907}, {169.396, 6.29847}, {169.397, 
       6.2977}, {169.399, 6.2967}, {169.4, 6.29557}, {169.401, 6.29427}, {
       169.403, 6.2928}, {169.404, 6.29123}, {169.404, 6.28953}, {169.405, 
       6.28773}, {169.405, 6.28587}, {169.406, 6.28397}, {169.406, 6.282}, {
       169.405, 6.28003}, {169.405, 6.2781}, {169.405, 6.27617}, {169.404, 
       6.2743}, {169.403, 6.2725}, {169.402, 6.2708}, {169.401, 6.2692}, {
       169.4, 6.26773}, {169.398, 6.26643}, {169.397, 6.26527}, {169.395, 
       6.26427}, {169.393, 6.26347}, {169.392, 6.26283}, {169.39, 6.26243}, {
       169.388, 6.2622}, {169.386, 6.2622}, {169.384, 6.2624}, {169.383, 
       6.2628}, {169.381, 6.2634}, {169.379, 6.26417}, {169.378, 6.26517}, {
       169.377, 6.2663}, {169.375, 6.2676}, {169.374, 6.26907}, {169.373, 
       6.27063}, {169.372, 6.27233}, {169.372, 6.27413}}, {{170.759, 
       8.8974}, {170.759, 8.89897}, {170.758, 8.90057}, {170.758, 8.9022}, {
       170.758, 8.90383}, {170.759, 8.90543}, {170.759, 8.907}, {170.76, 
       8.90853}, {170.761, 8.90997}, {170.762, 8.91133}, {170.764, 8.9126}, {
       170.765, 8.91377}, {170.767, 8.9148}, {170.769, 8.91567}, {170.771, 
       8.91643}, {170.773, 8.917}, {170.775, 8.91743}, {170.777, 8.9177}, {
       170.779, 8.91777}, {170.781, 8.9177}, {170.783, 8.91743}, {170.786, 
       8.91703}, {170.787, 8.91647}, {170.789, 8.91573}, {170.791, 8.91483}, {
       170.793, 8.9138}, {170.794, 8.91267}, {170.796, 8.9114}, {170.797, 
       8.91003}, {170.798, 8.9086}, {170.798, 8.90707}, {170.799, 8.9055}, {
       170.799, 8.9039}, {170.799, 8.90227}, {170.799, 8.90063}, {170.798, 
       8.89903}, {170.798, 8.89747}, {170.797, 8.89593}, {170.796, 8.8945}, {
       170.795, 8.89313}, {170.793, 8.89187}, {170.792, 8.8907}, {170.79, 
       8.88967}, {170.788, 8.8888}, {170.786, 8.88803}, {170.784, 8.88747}, {
       170.782, 8.88703}, {170.78, 8.88677}, {170.778, 8.8867}, {170.776, 
       8.88677}, {170.774, 8.88703}, {170.772, 8.88743}, {170.77, 8.888}, {
       170.768, 8.88873}, {170.766, 8.88963}, {170.765, 8.89067}, {170.763, 
       8.8918}, {170.762, 8.89307}, {170.761, 8.89443}, {170.76, 8.89587}, {
       170.759, 8.8974}}, {{169.321, 9.6907}, {169.319, 9.69157}, {169.318, 
       9.69257}, {169.317, 9.69367}, {169.316, 9.69487}, {169.315, 9.69617}, {
       169.314, 9.6975}, {169.314, 9.6989}, {169.314, 9.7003}, {169.314, 
       9.70177}, {169.314, 9.7032}, {169.315, 9.70463}, {169.316, 9.70603}, {
       169.317, 9.7074}, {169.319, 9.7087}, {169.32, 9.70993}, {169.322, 
       9.71107}, {169.324, 9.71213}, {169.326, 9.71307}, {169.328, 9.71387}, {
       169.33, 9.71453}, {169.333, 9.7151}, {169.335, 9.7155}, {169.338, 
       9.71577}, {169.34, 9.71587}, {169.342, 9.7158}, {169.345, 9.7156}, {
       169.347, 9.71527}, {169.349, 9.71477}, {169.351, 9.71413}, {169.353, 
       9.71337}, {169.355, 9.7125}, {169.356, 9.7115}, {169.357, 9.7104}, {
       169.358, 9.7092}, {169.359, 9.7079}, {169.36, 9.70657}, {169.36, 
       9.70517}, {169.36, 9.70377}, {169.36, 9.7023}, {169.36, 9.70087}, {
       169.359, 9.69943}, {169.358, 9.69803}, {169.357, 9.69667}, {169.355, 
       9.69537}, {169.354, 9.69413}, {169.352, 9.693}, {169.35, 9.69193}, {
       169.348, 9.691}, {169.346, 9.6902}, {169.344, 9.68953}, {169.341, 
       9.68897}, {169.339, 9.68857}, {169.336, 9.6883}, {169.334, 9.6882}, {
       169.332, 9.68827}, {169.329, 9.68847}, {169.327, 9.6888}, {169.325, 
       9.6893}, {169.323, 9.68993}, {169.321, 9.6907}}, {{162.374, 11.4134}, {
       162.372, 11.4128}, {162.369, 11.4125}, {162.367, 11.4122}, {162.365, 
       11.4121}, {162.363, 11.4122}, {162.36, 11.4125}, {162.358, 11.4128}, {
       162.356, 11.4134}, {162.354, 11.4141}, {162.352, 11.4149}, {162.35, 
       11.4159}, {162.349, 11.4169}, {162.347, 11.4181}, {162.346, 11.4194}, {
       162.345, 11.4207}, {162.344, 11.4222}, {162.344, 11.4236}, {162.343, 
       11.4251}, {162.343, 11.4266}, {162.343, 11.4281}, {162.344, 11.4296}, {
       162.344, 11.4311}, {162.345, 11.4325}, {162.346, 11.4339}, {162.347, 
       11.4352}, {162.349, 11.4363}, {162.35, 11.4374}, {162.352, 11.4384}, {
       162.354, 11.4392}, {162.356, 11.4399}, {162.358, 11.4404}, {162.36, 
       11.4408}, {162.363, 11.4411}, {162.365, 11.4411}, {162.367, 11.4411}, {
       162.369, 11.4408}, {162.372, 11.4404}, {162.374, 11.4399}, {162.376, 
       11.4392}, {162.378, 11.4384}, {162.379, 11.4374}, {162.381, 11.4363}, {
       162.382, 11.4352}, {162.384, 11.4339}, {162.385, 11.4325}, {162.386, 
       11.4311}, {162.386, 11.4296}, {162.386, 11.4281}, {162.387, 11.4266}, {
       162.386, 11.4251}, {162.386, 11.4236}, {162.386, 11.4222}, {162.385, 
       11.4207}, {162.384, 11.4194}, {162.382, 11.4181}, {162.381, 11.4169}, {
       162.379, 11.4159}, {162.378, 11.4149}, {162.376, 11.4141}, {162.374, 
       11.4134}}, {{168.739, 7.4415}, {168.738, 7.4426}, {168.737, 7.4438}, {
       168.736, 7.44503}, {168.735, 7.44637}, {168.735, 7.4477}, {168.735, 
       7.4491}, {168.735, 7.4505}, {168.735, 7.4519}, {168.736, 7.45327}, {
       168.737, 7.45463}, {168.738, 7.45593}, {168.739, 7.45717}, {168.741, 
       7.45833}, {168.743, 7.4594}, {168.745, 7.46037}, {168.747, 7.46123}, {
       168.749, 7.462}, {168.751, 7.4626}, {168.754, 7.4631}, {168.756, 
       7.46343}, {168.759, 7.46363}, {168.761, 7.4637}, {168.764, 7.4636}, {
       168.766, 7.46337}, {168.768, 7.463}, {168.771, 7.46247}, {168.773, 
       7.46183}, {168.775, 7.46107}, {168.776, 7.46017}, {168.778, 7.45917}, {
       168.779, 7.45807}, {168.78, 7.45687}, {168.781, 7.45563}, {168.782, 
       7.4543}, {168.782, 7.45297}, {168.782, 7.45157}, {168.782, 7.45017}, {
       168.782, 7.44877}, {168.781, 7.4474}, {168.78, 7.44603}, {168.779, 
       7.44473}, {168.778, 7.4435}, {168.776, 7.44233}, {168.774, 7.44127}, {
       168.773, 7.4403}, {168.77, 7.43943}, {168.768, 7.43867}, {168.766, 
       7.43807}, {168.763, 7.43757}, {168.761, 7.43723}, {168.759, 7.43703}, {
       168.756, 7.43697}, {168.754, 7.43707}, {168.751, 7.4373}, {168.749, 
       7.43767}, {168.747, 7.4382}, {168.745, 7.43883}, {168.743, 7.4396}, {
       168.741, 7.4405}, {168.739, 7.4415}}, {{168.846, 7.45153}, {168.845, 
       7.45327}, {168.844, 7.45507}, {168.844, 7.4569}, {168.844, 7.4588}, {
       168.844, 7.46067}, {168.844, 7.46253}, {168.844, 7.46433}, {168.845, 
       7.4661}, {168.845, 7.4678}, {168.846, 7.4694}, {168.847, 7.4709}, {
       168.848, 7.47227}, {168.849, 7.4735}, {168.851, 7.47457}, {168.852, 
       7.47543}, {168.854, 7.47617}, {168.855, 7.4767}, {168.857, 7.47703}, {
       168.859, 7.4772}, {168.86, 7.47717}, {168.862, 7.4769}, {168.864, 
       7.47647}, {168.866, 7.47587}, {168.867, 7.47503}, {168.869, 7.47407}, {
       168.87, 7.47293}, {168.871, 7.47163}, {168.873, 7.47023}, {168.874, 
       7.46867}, {168.874, 7.46703}, {168.875, 7.4653}, {168.876, 7.4635}, {
       168.876, 7.46167}, {168.876, 7.45977}, {168.876, 7.4579}, {168.876, 
       7.45603}, {168.876, 7.45423}, {168.875, 7.45247}, {168.875, 7.45077}, {
       168.874, 7.44917}, {168.873, 7.44767}, {168.872, 7.4463}, {168.871, 
       7.44507}, {168.869, 7.444}, {168.868, 7.44313}, {168.866, 7.4424}, {
       168.865, 7.44187}, {168.863, 7.44153}, {168.861, 7.44137}, {168.86, 
       7.4414}, {168.858, 7.44167}, {168.856, 7.4421}, {168.854, 7.4427}, {
       168.853, 7.44353}, {168.851, 7.4445}, {168.85, 7.44563}, {168.849, 
       7.44693}, {168.847, 7.44833}, {168.846, 7.4499}, {168.846, 
       7.45153}}, {{165.819, 10.1274}, {165.817, 10.1268}, {165.815, 
       10.1265}, {165.813, 10.1262}, {165.81, 10.1262}, {165.808, 10.1262}, {
       165.806, 10.1265}, {165.804, 10.1268}, {165.802, 10.1274}, {165.8, 
       10.128}, {165.798, 10.1288}, {165.797, 10.1297}, {165.795, 10.1308}, {
       165.794, 10.1319}, {165.792, 10.1331}, {165.791, 10.1344}, {165.791, 
       10.1358}, {165.79, 10.1372}, {165.79, 10.1386}, {165.79, 10.1401}, {
       165.79, 10.1415}, {165.79, 10.143}, {165.791, 10.1444}, {165.791, 
       10.1457}, {165.792, 10.147}, {165.794, 10.1483}, {165.795, 10.1494}, {
       165.797, 10.1504}, {165.798, 10.1513}, {165.8, 10.1521}, {165.802, 
       10.1528}, {165.804, 10.1533}, {165.806, 10.1537}, {165.808, 10.1539}, {
       165.81, 10.154}, {165.813, 10.1539}, {165.815, 10.1537}, {165.817, 
       10.1533}, {165.819, 10.1528}, {165.821, 10.1521}, {165.823, 10.1513}, {
       165.824, 10.1504}, {165.826, 10.1494}, {165.827, 10.1483}, {165.829, 
       10.147}, {165.83, 10.1457}, {165.83, 10.1444}, {165.831, 10.143}, {
       165.831, 10.1415}, {165.831, 10.1401}, {165.831, 10.1386}, {165.831, 
       10.1372}, {165.83, 10.1358}, {165.83, 10.1344}, {165.829, 10.1331}, {
       165.827, 10.1319}, {165.826, 10.1308}, {165.824, 10.1297}, {165.823, 
       10.1288}, {165.821, 10.128}, {165.819, 10.1274}}, {{166.195, 8.9103}, {
       166.194, 8.91183}, {166.194, 8.91343}, {166.193, 8.91507}, {166.193, 
       8.9167}, {166.194, 8.91837}, {166.194, 8.92}, {166.194, 8.92157}, {
       166.195, 8.92313}, {166.196, 8.9246}, {166.197, 8.92597}, {166.198, 
       8.92723}, {166.2, 8.9284}, {166.201, 8.92943}, {166.203, 8.9303}, {
       166.204, 8.93107}, {166.206, 8.93163}, {166.208, 8.93203}, {166.21, 
       8.9323}, {166.212, 8.93237}, {166.214, 8.93227}, {166.216, 8.932}, {
       166.218, 8.93157}, {166.219, 8.93097}, {166.221, 8.9302}, {166.223, 
       8.9293}, {166.224, 8.92823}, {166.225, 8.92707}, {166.227, 8.92577}, {
       166.228, 8.92437}, {166.228, 8.9229}, {166.229, 8.92137}, {166.23, 
       8.91977}, {166.23, 8.91813}, {166.23, 8.9165}, {166.23, 8.91483}, {
       166.229, 8.9132}, {166.229, 8.91163}, {166.228, 8.91007}, {166.227, 
       8.9086}, {166.226, 8.90723}, {166.225, 8.90597}, {166.224, 8.9048}, {
       166.222, 8.90377}, {166.221, 8.9029}, {166.219, 8.90213}, {166.217, 
       8.90157}, {166.215, 8.90117}, {166.213, 8.9009}, {166.211, 8.90083}, {
       166.21, 8.90093}, {166.208, 8.9012}, {166.206, 8.90163}, {166.204, 
       8.90223}, {166.202, 8.903}, {166.201, 8.9039}, {166.199, 8.90497}, {
       166.198, 8.90613}, {166.197, 8.90743}, {166.196, 8.90883}, {166.195, 
       8.9103}}, {{172.056, 6.09537}, {172.057, 6.09703}, {172.058, 
       6.09873}, {172.059, 6.10037}, {172.061, 6.10197}, {172.062, 6.10353}, {
       172.064, 6.105}, {172.066, 6.10633}, {172.068, 6.1076}, {172.07, 
       6.10873}, {172.072, 6.10973}, {172.074, 6.11057}, {172.076, 6.11123}, {
       172.078, 6.11177}, {172.08, 6.11213}, {172.082, 6.1123}, {172.084, 
       6.1123}, {172.086, 6.1121}, {172.087, 6.11177}, {172.089, 6.11123}, {
       172.09, 6.11053}, {172.091, 6.1097}, {172.092, 6.1087}, {172.093, 
       6.10757}, {172.094, 6.10633}, {172.094, 6.10497}, {172.094, 6.1035}, {
       172.094, 6.10193}, {172.094, 6.10033}, {172.093, 6.0987}, {172.092, 
       6.097}, {172.091, 6.09533}, {172.09, 6.09363}, {172.089, 6.092}, {
       172.088, 6.0904}, {172.086, 6.08883}, {172.084, 6.08737}, {172.082, 
       6.08603}, {172.08, 6.08477}, {172.078, 6.08363}, {172.076, 6.08263}, {
       172.074, 6.0818}, {172.072, 6.08113}, {172.07, 6.0806}, {172.068, 
       6.08023}, {172.066, 6.08007}, {172.064, 6.08007}, {172.063, 6.08027}, {
       172.061, 6.0806}, {172.059, 6.08113}, {172.058, 6.08183}, {172.057, 
       6.08267}, {172.056, 6.08367}, {172.055, 6.0848}, {172.055, 6.08603}, {
       172.054, 6.0874}, {172.054, 6.08887}, {172.054, 6.09043}, {172.055, 
       6.09203}, {172.055, 6.09367}, {172.056, 6.09537}}, {{169.822, 
       11.2421}, {169.821, 11.2434}, {169.82, 11.2449}, {169.82, 11.2464}, {
       169.82, 11.2479}, {169.82, 11.2494}, {169.82, 11.251}, {169.82, 
       11.2525}, {169.821, 11.2539}, {169.821, 11.2553}, {169.822, 11.2567}, {
       169.823, 11.2579}, {169.825, 11.2591}, {169.826, 11.2602}, {169.828, 
       11.2611}, {169.83, 11.2619}, {169.831, 11.2625}, {169.833, 11.263}, {
       169.835, 11.2634}, {169.837, 11.2636}, {169.839, 11.2636}, {169.841, 
       11.2635}, {169.843, 11.2632}, {169.845, 11.2628}, {169.847, 11.2622}, {
       169.849, 11.2615}, {169.851, 11.2606}, {169.852, 11.2596}, {169.854, 
       11.2585}, {169.855, 11.2573}, {169.856, 11.256}, {169.857, 11.2546}, {
       169.858, 11.2531}, {169.858, 11.2517}, {169.859, 11.2501}, {169.859, 
       11.2486}, {169.859, 11.2471}, {169.858, 11.2456}, {169.858, 11.2441}, {
       169.857, 11.2427}, {169.856, 11.2413}, {169.855, 11.2401}, {169.854, 
       11.2389}, {169.852, 11.2379}, {169.851, 11.2369}, {169.849, 11.2361}, {
       169.847, 11.2355}, {169.845, 11.235}, {169.843, 11.2346}, {169.841, 
       11.2344}, {169.839, 11.2344}, {169.837, 11.2345}, {169.835, 11.2348}, {
       169.833, 11.2352}, {169.831, 11.2358}, {169.829, 11.2366}, {169.828, 
       11.2374}, {169.826, 11.2384}, {169.824, 11.2395}, {169.823, 11.2408}, {
       169.822, 11.2421}}, {{169.302, 9.83427}, {169.3, 9.8351}, {169.299, 
       9.83603}, {169.298, 9.83707}, {169.297, 9.8382}, {169.296, 9.8394}, {
       169.296, 9.84063}, {169.296, 9.84193}, {169.296, 9.84327}, {169.296, 
       9.84463}, {169.296, 9.84597}, {169.297, 9.8473}, {169.298, 9.8486}, {
       169.299, 9.84987}, {169.301, 9.8511}, {169.302, 9.85223}, {169.304, 
       9.8533}, {169.306, 9.85427}, {169.308, 9.85513}, {169.31, 9.85587}, {
       169.313, 9.8565}, {169.315, 9.857}, {169.317, 9.85737}, {169.32, 
       9.8576}, {169.322, 9.85767}, {169.324, 9.85763}, {169.326, 9.85743}, {
       169.329, 9.8571}, {169.331, 9.85663}, {169.333, 9.85603}, {169.334, 
       9.8553}, {169.336, 9.85447}, {169.337, 9.85353}, {169.338, 9.8525}, {
       169.339, 9.85137}, {169.34, 9.85017}, {169.34, 9.84893}, {169.341, 
       9.84763}, {169.341, 9.8463}, {169.34, 9.84493}, {169.34, 9.8436}, {
       169.339, 9.84227}, {169.338, 9.84097}, {169.337, 9.8397}, {169.335, 
       9.83847}, {169.334, 9.83733}, {169.332, 9.83627}, {169.33, 9.8353}, {
       169.328, 9.83443}, {169.326, 9.8337}, {169.324, 9.83307}, {169.321, 
       9.83257}, {169.319, 9.8322}, {169.317, 9.83197}, {169.314, 9.8319}, {
       169.312, 9.83193}, {169.31, 9.83213}, {169.308, 9.83247}, {169.306, 
       9.83293}, {169.304, 9.83353}, {169.302, 9.83427}}, {{171.667, 
       5.99143}, {171.666, 5.99273}, {171.666, 5.99407}, {171.665, 5.99543}, {
       171.665, 5.9968}, {171.665, 5.9982}, {171.665, 5.9996}, {171.666, 
       6.00093}, {171.667, 6.00227}, {171.668, 6.0035}, {171.669, 6.0047}, {
       171.67, 6.0058}, {171.671, 6.0068}, {171.673, 6.00773}, {171.675, 
       6.0085}, {171.677, 6.00917}, {171.679, 6.0097}, {171.681, 6.0101}, {
       171.683, 6.01037}, {171.685, 6.01047}, {171.687, 6.01043}, {171.689, 
       6.01023}, {171.691, 6.00993}, {171.693, 6.00947}, {171.695, 6.00887}, {
       171.697, 6.00813}, {171.698, 6.0073}, {171.7, 6.00633}, {171.701, 
       6.00527}, {171.702, 6.00413}, {171.703, 6.0029}, {171.704, 6.0016}, {
       171.705, 6.00027}, {171.705, 5.9989}, {171.705, 5.99753}, {171.705, 
       5.99613}, {171.705, 5.99473}, {171.705, 5.9934}, {171.704, 5.99207}, {
       171.703, 5.99083}, {171.702, 5.98963}, {171.701, 5.98853}, {171.699, 
       5.98753}, {171.698, 5.9866}, {171.696, 5.98583}, {171.694, 5.98517}, {
       171.692, 5.98463}, {171.69, 5.98423}, {171.688, 5.98397}, {171.686, 
       5.98387}, {171.684, 5.9839}, {171.682, 5.9841}, {171.68, 5.9844}, {
       171.678, 5.98487}, {171.676, 5.98547}, {171.674, 5.9862}, {171.672, 
       5.98703}, {171.671, 5.988}, {171.669, 5.98907}, {171.668, 5.9902}, {
       171.667, 5.99143}}, {{162.269, 11.5321}, {162.285, 11.5332}, {162.302, 
       11.5146}, {162.297, 11.5044}, {162.278, 11.5044}, {162.261, 11.5167}, {
       162.269, 11.5321}}, {{170.132, 12.224}, {170.137, 12.2314}, {170.155, 
       12.2379}, {170.175, 12.2342}, {170.175, 12.2267}, {170.162, 12.2156}, {
       170.14, 12.2119}, {170.132, 12.2156}, {170.132, 12.224}}, {{168.886, 
       7.4966}, {168.885, 7.49763}, {168.885, 7.4987}, {168.884, 7.49983}, {
       168.884, 7.50097}, {168.884, 7.5021}, {168.884, 7.50323}, {168.885, 
       7.50433}, {168.886, 7.50543}, {168.886, 7.50647}, {168.888, 7.50747}, {
       168.889, 7.5084}, {168.89, 7.50927}, {168.892, 7.51003}, {168.894, 
       7.51073}, {168.896, 7.5113}, {168.898, 7.51177}, {168.9, 7.51213}, {
       168.902, 7.5124}, {168.904, 7.51253}, {168.907, 7.51253}, {168.909, 
       7.51243}, {168.911, 7.51223}, {168.913, 7.5119}, {168.915, 7.51143}, {
       168.917, 7.51087}, {168.919, 7.51023}, {168.92, 7.50947}, {168.922, 
       7.50863}, {168.923, 7.50773}, {168.924, 7.50673}, {168.925, 7.5057}, {
       168.926, 7.50463}, {168.926, 7.5035}, {168.926, 7.50237}, {168.926, 
       7.50123}, {168.926, 7.5001}, {168.926, 7.499}, {168.925, 7.4979}, {
       168.924, 7.49687}, {168.923, 7.49587}, {168.922, 7.49493}, {168.92, 
       7.49407}, {168.918, 7.4933}, {168.917, 7.4926}, {168.915, 7.49203}, {
       168.913, 7.49157}, {168.91, 7.4912}, {168.908, 7.49093}, {168.906, 
       7.4908}, {168.904, 7.4908}, {168.902, 7.4909}, {168.899, 7.4911}, {
       168.897, 7.49143}, {168.895, 7.4919}, {168.893, 7.49247}, {168.892, 
       7.4931}, {168.89, 7.49387}, {168.889, 7.4947}, {168.887, 7.4956}, {
       168.886, 7.4966}}, {{171.107, 8.08273}, {171.106, 8.08393}, {171.106, 
       8.08517}, {171.105, 8.08643}, {171.105, 8.08773}, {171.105, 8.089}, {
       171.105, 8.0903}, {171.106, 8.09157}, {171.106, 8.0928}, {171.107, 
       8.094}, {171.108, 8.09513}, {171.109, 8.09617}, {171.11, 8.09713}, {
       171.112, 8.098}, {171.113, 8.09877}, {171.115, 8.09943}, {171.116, 
       8.09997}, {171.118, 8.10037}, {171.12, 8.10063}, {171.122, 8.10077}, {
       171.124, 8.10077}, {171.126, 8.10063}, {171.128, 8.10037}, {171.129, 
       8.09997}, {171.131, 8.09943}, {171.133, 8.0988}, {171.134, 8.09803}, {
       171.136, 8.09717}, {171.137, 8.0962}, {171.138, 8.09517}, {171.139, 
       8.09403}, {171.14, 8.09283}, {171.141, 8.0916}, {171.141, 8.09033}, {
       171.141, 8.08903}, {171.141, 8.08777}, {171.141, 8.08647}, {171.141, 
       8.0852}, {171.14, 8.08397}, {171.139, 8.08277}, {171.138, 8.08163}, {
       171.137, 8.0806}, {171.136, 8.07963}, {171.135, 8.07877}, {171.133, 
       8.078}, {171.131, 8.07733}, {171.13, 8.0768}, {171.128, 8.0764}, {
       171.126, 8.07613}, {171.124, 8.076}, {171.122, 8.076}, {171.12, 
       8.07613}, {171.118, 8.0764}, {171.117, 8.0768}, {171.115, 8.07733}, {
       171.113, 8.07797}, {171.112, 8.07873}, {171.11, 8.0796}, {171.109, 
       8.08057}, {171.108, 8.0816}, {171.107, 8.08273}}, {{169.772, 6.0035}, {
       169.771, 6.00407}, {169.77, 6.00477}, {169.77, 6.00567}, {169.77, 
       6.00667}, {169.769, 6.00783}, {169.769, 6.0091}, {169.77, 6.0105}, {
       169.77, 6.01197}, {169.771, 6.01353}, {169.772, 6.01513}, {169.773, 
       6.0168}, {169.774, 6.0185}, {169.775, 6.02017}, {169.777, 6.02187}, {
       169.779, 6.0235}, {169.78, 6.0251}, {169.782, 6.02663}, {169.784, 
       6.02807}, {169.786, 6.02943}, {169.788, 6.03063}, {169.79, 6.03177}, {
       169.792, 6.03273}, {169.794, 6.03353}, {169.796, 6.0342}, {169.797, 
       6.03467}, {169.799, 6.035}, {169.801, 6.03513}, {169.802, 6.0351}, {
       169.803, 6.0349}, {169.804, 6.0345}, {169.805, 6.03393}, {169.806, 
       6.03323}, {169.807, 6.03233}, {169.807, 6.03133}, {169.807, 6.03017}, {
       169.807, 6.0289}, {169.807, 6.0275}, {169.806, 6.02603}, {169.806, 
       6.02447}, {169.805, 6.02287}, {169.804, 6.0212}, {169.803, 6.0195}, {
       169.801, 6.01783}, {169.8, 6.01613}, {169.798, 6.0145}, {169.796, 
       6.0129}, {169.794, 6.01137}, {169.792, 6.00993}, {169.791, 6.00857}, {
       169.789, 6.00737}, {169.787, 6.00623}, {169.785, 6.00527}, {169.783, 
       6.00447}, {169.781, 6.0038}, {169.779, 6.00333}, {169.777, 6.003}, {
       169.776, 6.00287}, {169.774, 6.0029}, {169.773, 6.0031}, {169.772, 
       6.0035}}, {{172.2, 5.85703}, {172.2, 5.8583}, {172.199, 5.8596}, {
       172.199, 5.86093}, {172.199, 5.86223}, {172.2, 5.86357}, {172.2, 
       5.86483}, {172.2, 5.8661}, {172.201, 5.8673}, {172.202, 5.86843}, {
       172.203, 5.8695}, {172.204, 5.87047}, {172.205, 5.87133}, {172.207, 
       5.8721}, {172.208, 5.87273}, {172.21, 5.87327}, {172.211, 5.87363}, {
       172.213, 5.8739}, {172.214, 5.87403}, {172.216, 5.874}, {172.218, 
       5.87383}, {172.219, 5.87353}, {172.221, 5.87313}, {172.222, 5.87257}, {
       172.223, 5.8719}, {172.225, 5.8711}, {172.226, 5.8702}, {172.227, 
       5.8692}, {172.228, 5.86813}, {172.228, 5.86697}, {172.229, 5.86577}, {
       172.229, 5.8645}, {172.23, 5.8632}, {172.23, 5.86187}, {172.23, 
       5.86057}, {172.229, 5.85923}, {172.229, 5.85797}, {172.228, 5.8567}, {
       172.228, 5.8555}, {172.227, 5.85437}, {172.226, 5.8533}, {172.225, 
       5.85233}, {172.223, 5.85147}, {172.222, 5.8507}, {172.221, 5.85007}, {
       172.219, 5.84953}, {172.218, 5.84917}, {172.216, 5.8489}, {172.214, 
       5.84877}, {172.213, 5.8488}, {172.211, 5.84897}, {172.21, 5.84927}, {
       172.208, 5.84967}, {172.207, 5.85023}, {172.205, 5.8509}, {172.204, 
       5.8517}, {172.203, 5.8526}, {172.202, 5.8536}, {172.201, 5.85467}, {
       172.2, 5.85583}, {172.2, 5.85703}}, {{169.373, 9.80187}, {169.372, 
       9.8012}, {169.37, 9.80063}, {169.368, 9.80017}, {169.367, 9.7998}, {
       169.365, 9.79953}, {169.363, 9.7994}, {169.361, 9.79937}, {169.359, 
       9.79947}, {169.358, 9.7997}, {169.356, 9.8}, {169.354, 9.80043}, {
       169.353, 9.80097}, {169.351, 9.80163}, {169.35, 9.80233}, {169.349, 
       9.80317}, {169.348, 9.80407}, {169.347, 9.805}, {169.346, 9.806}, {
       169.346, 9.80707}, {169.346, 9.80817}, {169.345, 9.80927}, {169.345, 
       9.81037}, {169.346, 9.81147}, {169.346, 9.81257}, {169.347, 9.81363}, {
       169.347, 9.81467}, {169.348, 9.81563}, {169.349, 9.81657}, {169.351, 
       9.8174}, {169.352, 9.81817}, {169.353, 9.81883}, {169.355, 9.8194}, {
       169.357, 9.81987}, {169.358, 9.82023}, {169.36, 9.8205}, {169.362, 
       9.82063}, {169.364, 9.82067}, {169.366, 9.82057}, {169.367, 9.82033}, {
       169.369, 9.82003}, {169.371, 9.8196}, {169.372, 9.81907}, {169.374, 
       9.8184}, {169.375, 9.8177}, {169.376, 9.81687}, {169.377, 9.81597}, {
       169.378, 9.81503}, {169.379, 9.81403}, {169.379, 9.81297}, {169.379, 
       9.81187}, {169.38, 9.81077}, {169.38, 9.80967}, {169.379, 9.80857}, {
       169.379, 9.80747}, {169.378, 9.8064}, {169.378, 9.80537}, {169.377, 
       9.8044}, {169.376, 9.80347}, {169.374, 9.80263}, {169.373, 
       9.80187}}, {{168.931, 9.8814}, {168.93, 9.8823}, {168.929, 9.88327}, {
       168.929, 9.88423}, {168.929, 9.88523}, {168.929, 9.88623}, {168.929, 
       9.88727}, {168.929, 9.88823}, {168.93, 9.88923}, {168.931, 9.89017}, {
       168.932, 9.89107}, {168.933, 9.8919}, {168.934, 9.8927}, {168.936, 
       9.8934}, {168.937, 9.89403}, {168.939, 9.89457}, {168.941, 9.89503}, {
       168.943, 9.8954}, {168.944, 9.89563}, {168.946, 9.8958}, {168.948, 
       9.89583}, {168.95, 9.8958}, {168.952, 9.89563}, {168.954, 9.89537}, {
       168.956, 9.895}, {168.958, 9.89453}, {168.959, 9.89397}, {168.961, 
       9.89333}, {168.962, 9.89263}, {168.963, 9.89183}, {168.964, 9.891}, {
       168.965, 9.8901}, {168.966, 9.88913}, {168.966, 9.88817}, {168.967, 
       9.88717}, {168.967, 9.88617}, {168.966, 9.88513}, {168.966, 9.88417}, {
       168.965, 9.88317}, {168.965, 9.88223}, {168.964, 9.88133}, {168.962, 
       9.8805}, {168.961, 9.8797}, {168.96, 9.879}, {168.958, 9.87837}, {
       168.956, 9.87783}, {168.954, 9.87737}, {168.953, 9.877}, {168.951, 
       9.87677}, {168.949, 9.8766}, {168.947, 9.87657}, {168.945, 9.8766}, {
       168.943, 9.87677}, {168.941, 9.87703}, {168.939, 9.8774}, {168.937, 
       9.87787}, {168.936, 9.87843}, {168.934, 9.87907}, {168.933, 9.87977}, {
       168.932, 9.88057}, {168.931, 9.8814}}, {{168.598, 4.7185}, {168.597, 
       4.7196}, {168.596, 4.72077}, {168.596, 4.72197}, {168.595, 4.72323}, {
       168.594, 4.7245}, {168.594, 4.7258}, {168.594, 4.7271}, {168.594, 
       4.7284}, {168.594, 4.72967}, {168.594, 4.73087}, {168.594, 4.73203}, {
       168.595, 4.7331}, {168.595, 4.73413}, {168.596, 4.73503}, {168.597, 
       4.73583}, {168.598, 4.73657}, {168.599, 4.73713}, {168.6, 4.7376}, {
       168.601, 4.73793}, {168.602, 4.73813}, {168.604, 4.7382}, {168.605, 
       4.73813}, {168.606, 4.7379}, {168.608, 4.73757}, {168.609, 4.7371}, {
       168.61, 4.7365}, {168.612, 4.7358}, {168.613, 4.73497}, {168.614, 
       4.73403}, {168.615, 4.73303}, {168.616, 4.73193}, {168.617, 4.73077}, {
       168.618, 4.72957}, {168.619, 4.7283}, {168.619, 4.72703}, {168.62, 
       4.72573}, {168.62, 4.72443}, {168.62, 4.72313}, {168.62, 4.72187}, {
       168.62, 4.72067}, {168.62, 4.7195}, {168.619, 4.71843}, {168.619, 
       4.7174}, {168.618, 4.7165}, {168.617, 4.7157}, {168.616, 4.71497}, {
       168.615, 4.7144}, {168.614, 4.71393}, {168.613, 4.7136}, {168.611, 
       4.7134}, {168.61, 4.71333}, {168.609, 4.7134}, {168.607, 4.71363}, {
       168.606, 4.71397}, {168.605, 4.71443}, {168.603, 4.71503}, {168.602, 
       4.71573}, {168.601, 4.71657}, {168.599, 4.7175}, {168.598, 4.7185}}, {{
       171.048, 8.1245}, {171.047, 8.12497}, {171.045, 8.12553}, {171.044, 
       8.1262}, {171.042, 8.12693}, {171.041, 8.12773}, {171.04, 8.1286}, {
       171.039, 8.12953}, {171.038, 8.1305}, {171.037, 8.1315}, {171.036, 
       8.13253}, {171.036, 8.13357}, {171.035, 8.1346}, {171.035, 8.13563}, {
       171.035, 8.13663}, {171.035, 8.1376}, {171.036, 8.13853}, {171.036, 
       8.1394}, {171.037, 8.1402}, {171.038, 8.14093}, {171.039, 8.1416}, {
       171.04, 8.14217}, {171.041, 8.14263}, {171.042, 8.143}, {171.044, 
       8.14327}, {171.045, 8.14343}, {171.047, 8.1435}, {171.048, 8.14343}, {
       171.05, 8.14327}, {171.052, 8.143}, {171.053, 8.14263}, {171.055, 
       8.14217}, {171.056, 8.1416}, {171.058, 8.14093}, {171.059, 8.1402}, {
       171.06, 8.1394}, {171.062, 8.13853}, {171.063, 8.1376}, {171.064, 
       8.13663}, {171.065, 8.13563}, {171.065, 8.1346}, {171.066, 8.13357}, {
       171.066, 8.13253}, {171.066, 8.1315}, {171.066, 8.1305}, {171.066, 
       8.12953}, {171.066, 8.1286}, {171.065, 8.12773}, {171.065, 8.12693}, {
       171.064, 8.1262}, {171.063, 8.12553}, {171.062, 8.12497}, {171.061, 
       8.1245}, {171.059, 8.12413}, {171.058, 8.12387}, {171.056, 8.1237}, {
       171.055, 8.12363}, {171.053, 8.1237}, {171.052, 8.12387}, {171.05, 
       8.12413}, {171.048, 8.1245}}, {{167.812, 8.11823}, {167.81, 8.118}, {
       167.809, 8.11783}, {167.807, 8.11777}, {167.806, 8.11777}, {167.804, 
       8.11783}, {167.802, 8.11797}, {167.801, 8.1182}, {167.799, 8.1185}, {
       167.798, 8.11887}, {167.797, 8.1193}, {167.796, 8.1198}, {167.794, 
       8.12037}, {167.793, 8.12097}, {167.793, 8.1216}, {167.792, 8.1223}, {
       167.791, 8.123}, {167.791, 8.12373}, {167.791, 8.1245}, {167.791, 
       8.12523}, {167.791, 8.12597}, {167.791, 8.1267}, {167.792, 8.12743}, {
       167.792, 8.1281}, {167.793, 8.12877}, {167.794, 8.12937}, {167.795, 
       8.12993}, {167.796, 8.13043}, {167.797, 8.13087}, {167.799, 8.13127}, {
       167.8, 8.13157}, {167.802, 8.1318}, {167.803, 8.13197}, {167.805, 
       8.13203}, {167.806, 8.13203}, {167.808, 8.13197}, {167.809, 8.13183}, {
       167.811, 8.1316}, {167.812, 8.1313}, {167.814, 8.13093}, {167.815, 
       8.1305}, {167.816, 8.13}, {167.817, 8.12943}, {167.818, 8.12883}, {
       167.819, 8.1282}, {167.82, 8.1275}, {167.82, 8.1268}, {167.821, 
       8.12607}, {167.821, 8.1253}, {167.821, 8.12457}, {167.821, 8.12383}, {
       167.821, 8.1231}, {167.82, 8.12237}, {167.82, 8.1217}, {167.819, 
       8.12103}, {167.818, 8.12043}, {167.817, 8.11987}, {167.816, 8.11937}, {
       167.814, 8.11893}, {167.813, 8.11853}, {167.812, 8.11823}}, {{166.078, 
       11.1495}, {166.077, 11.1505}, {166.076, 11.1515}, {166.075, 11.1526}, {
       166.074, 11.1537}, {166.073, 11.1548}, {166.072, 11.1559}, {166.072, 
       11.1571}, {166.071, 11.1582}, {166.071, 11.1593}, {166.07, 11.1604}, {
       166.07, 11.1615}, {166.07, 11.1624}, {166.07, 11.1633}, {166.07, 
       11.1641}, {166.071, 11.1649}, {166.071, 11.1655}, {166.072, 11.1661}, {
       166.072, 11.1665}, {166.073, 11.1668}, {166.074, 11.167}, {166.075, 
       11.1671}, {166.076, 11.167}, {166.077, 11.1669}, {166.078, 11.1666}, {
       166.079, 11.1662}, {166.08, 11.1657}, {166.081, 11.1651}, {166.082, 
       11.1644}, {166.083, 11.1636}, {166.084, 11.1627}, {166.085, 11.1617}, {
       166.086, 11.1607}, {166.087, 11.1596}, {166.088, 11.1585}, {166.089, 
       11.1574}, {166.09, 11.1563}, {166.09, 11.1551}, {166.091, 11.154}, {
       166.091, 11.1529}, {166.092, 11.1518}, {166.092, 11.1507}, {166.092, 
       11.1498}, {166.092, 11.1489}, {166.092, 11.1481}, {166.091, 11.1473}, {
       166.091, 11.1467}, {166.091, 11.1461}, {166.09, 11.1457}, {166.089, 
       11.1454}, {166.088, 11.1452}, {166.088, 11.1451}, {166.087, 11.1452}, {
       166.086, 11.1453}, {166.085, 11.1456}, {166.083, 11.146}, {166.082, 
       11.1465}, {166.081, 11.1471}, {166.08, 11.1478}, {166.079, 11.1486}, {
       166.078, 11.1495}}, {{166.284, 11.1122}, {166.284, 11.1129}, {166.283, 
       11.1137}, {166.283, 11.1145}, {166.283, 11.1153}, {166.283, 11.1161}, {
       166.283, 11.117}, {166.283, 11.1178}, {166.283, 11.1186}, {166.283, 
       11.1193}, {166.284, 11.1201}, {166.284, 11.1208}, {166.285, 11.1214}, {
       166.285, 11.122}, {166.286, 11.1225}, {166.287, 11.1229}, {166.287, 
       11.1233}, {166.288, 11.1235}, {166.289, 11.1237}, {166.29, 11.1238}, {
       166.291, 11.1239}, {166.292, 11.1238}, {166.292, 11.1236}, {166.293, 
       11.1234}, {166.294, 11.1231}, {166.295, 11.1227}, {166.296, 11.1222}, {
       166.297, 11.1217}, {166.297, 11.1211}, {166.298, 11.1204}, {166.298, 
       11.1197}, {166.299, 11.119}, {166.299, 11.1182}, {166.299, 11.1174}, {
       166.3, 11.1166}, {166.3, 11.1158}, {166.3, 11.1149}, {166.3, 
       11.1141}, {166.299, 11.1133}, {166.299, 11.1126}, {166.299, 11.1118}, {
       166.298, 11.1111}, {166.298, 11.1105}, {166.297, 11.1099}, {166.297, 
       11.1094}, {166.296, 11.109}, {166.295, 11.1086}, {166.294, 11.1084}, {
       166.293, 11.1082}, {166.292, 11.1081}, {166.292, 11.108}, {166.291, 
       11.1081}, {166.29, 11.1083}, {166.289, 11.1085}, {166.288, 11.1088}, {
       166.287, 11.1092}, {166.287, 11.1097}, {166.286, 11.1102}, {166.285, 
       11.1108}, {166.285, 11.1115}, {166.284, 11.1122}}, {{166.104, 
       11.0979}, {166.103, 11.0986}, {166.103, 11.0994}, {166.103, 11.1001}, {
       166.103, 11.1009}, {166.103, 11.1017}, {166.103, 11.1025}, {166.103, 
       11.1033}, {166.103, 11.104}, {166.103, 11.1047}, {166.104, 11.1054}, {
       166.104, 11.1061}, {166.105, 11.1067}, {166.105, 11.1072}, {166.106, 
       11.1077}, {166.107, 11.1081}, {166.107, 11.1084}, {166.108, 11.1086}, {
       166.109, 11.1088}, {166.11, 11.1089}, {166.111, 11.1089}, {166.112, 
       11.1088}, {166.112, 11.1087}, {166.113, 11.1084}, {166.114, 11.1081}, {
       166.115, 11.1077}, {166.116, 11.1073}, {166.116, 11.1067}, {166.117, 
       11.1062}, {166.117, 11.1055}, {166.118, 11.1048}, {166.118, 11.1041}, {
       166.119, 11.1034}, {166.119, 11.1026}, {166.119, 11.1018}, {166.119, 
       11.101}, {166.119, 11.1002}, {166.119, 11.0995}, {166.119, 11.0987}, {
       166.118, 11.098}, {166.118, 11.0973}, {166.117, 11.0967}, {166.117, 
       11.0961}, {166.116, 11.0955}, {166.116, 11.0951}, {166.115, 11.0947}, {
       166.114, 11.0943}, {166.113, 11.0941}, {166.113, 11.0939}, {166.112, 
       11.0938}, {166.111, 11.0938}, {166.11, 11.0939}, {166.109, 11.0941}, {
       166.108, 11.0943}, {166.107, 11.0946}, {166.107, 11.095}, {166.106, 
       11.0955}, {166.105, 11.096}, {166.105, 11.0966}, {166.104, 11.0972}, {
       166.104, 11.0979}}, {{166.351, 11.1133}, {166.35, 11.1135}, {166.349, 
       11.1138}, {166.348, 11.1142}, {166.346, 11.1146}, {166.345, 11.115}, {
       166.344, 11.1155}, {166.343, 11.1161}, {166.342, 11.1166}, {166.341, 
       11.1172}, {166.34, 11.1178}, {166.339, 11.1183}, {166.339, 11.1189}, {
       166.338, 11.1195}, {166.338, 11.1201}, {166.338, 11.1207}, {166.337, 
       11.1212}, {166.337, 11.1217}, {166.338, 11.1222}, {166.338, 11.1226}, {
       166.338, 11.123}, {166.339, 11.1233}, {166.339, 11.1236}, {166.34, 
       11.1238}, {166.341, 11.124}, {166.342, 11.1241}, {166.343, 11.1241}, {
       166.344, 11.1241}, {166.345, 11.124}, {166.346, 11.1239}, {166.348, 
       11.1237}, {166.349, 11.1235}, {166.35, 11.1231}, {166.351, 11.1228}, {
       166.353, 11.1224}, {166.354, 11.1219}, {166.355, 11.1214}, {166.356, 
       11.1209}, {166.357, 11.1204}, {166.358, 11.1198}, {166.359, 11.1192}, {
       166.359, 11.1186}, {166.36, 11.118}, {166.361, 11.1174}, {166.361, 
       11.1169}, {166.361, 11.1163}, {166.361, 11.1158}, {166.361, 11.1153}, {
       166.361, 11.1148}, {166.361, 11.1144}, {166.361, 11.114}, {166.36, 
       11.1136}, {166.359, 11.1134}, {166.359, 11.1131}, {166.358, 11.113}, {
       166.357, 11.1129}, {166.356, 11.1128}, {166.355, 11.1128}, {166.354, 
       11.1129}, {166.352, 11.1131}, {166.351, 11.1133}}, {{166.202, 
       11.0742}, {166.201, 11.0747}, {166.201, 11.0751}, {166.2, 11.0757}, {
       166.199, 11.0762}, {166.199, 11.0768}, {166.198, 11.0775}, {166.197, 
       11.0781}, {166.197, 11.0787}, {166.197, 11.0794}, {166.197, 11.08}, {
       166.196, 11.0807}, {166.196, 11.0813}, {166.196, 11.0819}, {166.197, 
       11.0824}, {166.197, 11.083}, {166.197, 11.0834}, {166.198, 11.0839}, {
       166.198, 11.0842}, {166.199, 11.0846}, {166.199, 11.0848}, {166.2, 
       11.085}, {166.201, 11.0851}, {166.201, 11.0852}, {166.202, 11.0852}, {
       166.203, 11.0851}, {166.204, 11.085}, {166.205, 11.0848}, {166.206, 
       11.0845}, {166.207, 11.0842}, {166.207, 11.0838}, {166.208, 11.0833}, {
       166.209, 11.0829}, {166.21, 11.0823}, {166.21, 11.0818}, {166.211, 
       11.0812}, {166.212, 11.0805}, {166.212, 11.0799}, {166.212, 11.0793}, {
       166.213, 11.0786}, {166.213, 11.078}, {166.213, 11.0773}, {166.213, 
       11.0767}, {166.213, 11.0761}, {166.213, 11.0756}, {166.213, 11.075}, {
       166.212, 11.0746}, {166.212, 11.0741}, {166.211, 11.0738}, {166.211, 
       11.0734}, {166.21, 11.0732}, {166.21, 11.073}, {166.209, 11.0729}, {
       166.208, 11.0728}, {166.207, 11.0728}, {166.206, 11.0729}, {166.206, 
       11.073}, {166.205, 11.0732}, {166.204, 11.0735}, {166.203, 11.0738}, {
       166.202, 11.0742}}, {{166.222, 11.1083}, {166.221, 11.1081}, {166.22, 
       11.1079}, {166.219, 11.1078}, {166.218, 11.1078}, {166.218, 11.1078}, {
       166.217, 11.1079}, {166.216, 11.1081}, {166.215, 11.1083}, {166.214, 
       11.1085}, {166.214, 11.1088}, {166.213, 11.1092}, {166.212, 11.1096}, {
       166.212, 11.11}, {166.211, 11.1105}, {166.211, 11.111}, {166.211, 
       11.1116}, {166.211, 11.1121}, {166.21, 11.1127}, {166.21, 11.1132}, {
       166.21, 11.1138}, {166.211, 11.1144}, {166.211, 11.1149}, {166.211, 
       11.1154}, {166.211, 11.116}, {166.212, 11.1164}, {166.212, 11.1169}, {
       166.213, 11.1173}, {166.214, 11.1176}, {166.214, 11.1179}, {166.215, 
       11.1182}, {166.216, 11.1184}, {166.217, 11.1185}, {166.218, 11.1186}, {
       166.218, 11.1187}, {166.219, 11.1186}, {166.22, 11.1185}, {166.221, 
       11.1184}, {166.222, 11.1182}, {166.223, 11.1179}, {166.223, 11.1176}, {
       166.224, 11.1173}, {166.225, 11.1169}, {166.225, 11.1164}, {166.226, 
       11.116}, {166.226, 11.1154}, {166.226, 11.1149}, {166.226, 11.1144}, {
       166.227, 11.1138}, {166.227, 11.1132}, {166.227, 11.1127}, {166.226, 
       11.1121}, {166.226, 11.1116}, {166.226, 11.111}, {166.226, 11.1105}, {
       166.225, 11.11}, {166.225, 11.1096}, {166.224, 11.1092}, {166.223, 
       11.1088}, {166.223, 11.1085}, {166.222, 11.1083}}, {{166.365, 
       11.151}, {166.364, 11.1508}, {166.364, 11.1506}, {166.363, 11.1505}, {
       166.362, 11.1505}, {166.361, 11.1505}, {166.36, 11.1506}, {166.36, 
       11.1508}, {166.359, 11.151}, {166.358, 11.1512}, {166.357, 11.1515}, {
       166.357, 11.1519}, {166.356, 11.1522}, {166.356, 11.1527}, {166.355, 
       11.1531}, {166.355, 11.1536}, {166.355, 11.1541}, {166.354, 11.1547}, {
       166.354, 11.1552}, {166.354, 11.1557}, {166.354, 11.1563}, {166.354, 
       11.1568}, {166.355, 11.1574}, {166.355, 11.1579}, {166.355, 11.1584}, {
       166.356, 11.1588}, {166.356, 11.1593}, {166.357, 11.1596}, {166.357, 
       11.16}, {166.358, 11.1603}, {166.359, 11.1605}, {166.36, 11.1607}, {
       166.36, 11.1609}, {166.361, 11.161}, {166.362, 11.161}, {166.363, 
       11.161}, {166.364, 11.1609}, {166.364, 11.1607}, {166.365, 11.1605}, {
       166.366, 11.1603}, {166.367, 11.16}, {166.367, 11.1596}, {166.368, 
       11.1593}, {166.368, 11.1588}, {166.369, 11.1584}, {166.369, 11.1579}, {
       166.37, 11.1574}, {166.37, 11.1568}, {166.37, 11.1563}, {166.37, 
       11.1558}, {166.37, 11.1552}, {166.37, 11.1547}, {166.37, 11.1541}, {
       166.369, 11.1536}, {166.369, 11.1531}, {166.368, 11.1527}, {166.368, 
       11.1522}, {166.367, 11.1519}, {166.367, 11.1515}, {166.366, 11.1512}, {
       166.365, 11.151}}, {{166.305, 11.0827}, {166.303, 11.0829}, {166.302, 
       11.0831}, {166.301, 11.0833}, {166.299, 11.0836}, {166.298, 11.084}, {
       166.297, 11.0843}, {166.295, 11.0847}, {166.294, 11.0851}, {166.293, 
       11.0855}, {166.292, 11.0859}, {166.291, 11.0863}, {166.29, 11.0867}, {
       166.289, 11.0871}, {166.289, 11.0875}, {166.288, 11.0879}, {166.288, 
       11.0883}, {166.288, 11.0887}, {166.288, 11.089}, {166.288, 11.0893}, {
       166.288, 11.0896}, {166.288, 11.0899}, {166.289, 11.0901}, {166.289, 
       11.0902}, {166.29, 11.0903}, {166.291, 11.0904}, {166.292, 11.0905}, {
       166.293, 11.0905}, {166.294, 11.0904}, {166.295, 11.0903}, {166.297, 
       11.0902}, {166.298, 11.09}, {166.299, 11.0898}, {166.301, 11.0895}, {
       166.302, 11.0892}, {166.303, 11.0889}, {166.305, 11.0886}, {166.306, 
       11.0882}, {166.307, 11.0878}, {166.308, 11.0874}, {166.309, 11.087}, {
       166.31, 11.0866}, {166.311, 11.0862}, {166.312, 11.0857}, {166.313, 
       11.0853}, {166.313, 11.0849}, {166.314, 11.0845}, {166.314, 11.0842}, {
       166.314, 11.0838}, {166.314, 11.0835}, {166.314, 11.0833}, {166.313, 
       11.083}, {166.313, 11.0828}, {166.312, 11.0826}, {166.311, 11.0825}, {
       166.31, 11.0824}, {166.309, 11.0824}, {166.308, 11.0824}, {166.307, 
       11.0825}, {166.306, 11.0826}, {166.305, 11.0827}}, {{166.164, 
       11.0988}, {166.163, 11.0986}, {166.162, 11.0985}, {166.161, 11.0984}, {
       166.161, 11.0984}, {166.16, 11.0984}, {166.159, 11.0985}, {166.158, 
       11.0986}, {166.158, 11.0988}, {166.157, 11.0991}, {166.156, 11.0994}, {
       166.156, 11.0997}, {166.155, 11.1001}, {166.154, 11.1005}, {166.154, 
       11.1009}, {166.154, 11.1014}, {166.153, 11.1019}, {166.153, 11.1024}, {
       166.153, 11.1029}, {166.153, 11.1035}, {166.153, 11.104}, {166.153, 
       11.1045}, {166.153, 11.105}, {166.154, 11.1055}, {166.154, 11.106}, {
       166.154, 11.1064}, {166.155, 11.1069}, {166.156, 11.1072}, {166.156, 
       11.1076}, {166.157, 11.1079}, {166.158, 11.1081}, {166.158, 11.1083}, {
       166.159, 11.1084}, {166.16, 11.1085}, {166.161, 11.1085}, {166.161, 
       11.1085}, {166.162, 11.1084}, {166.163, 11.1083}, {166.164, 11.1081}, {
       166.164, 11.1079}, {166.165, 11.1076}, {166.166, 11.1072}, {166.166, 
       11.1069}, {166.167, 11.1064}, {166.167, 11.106}, {166.168, 11.1055}, {
       166.168, 11.105}, {166.168, 11.1045}, {166.168, 11.104}, {166.168, 
       11.1035}, {166.168, 11.1029}, {166.168, 11.1024}, {166.168, 11.1019}, {
       166.168, 11.1014}, {166.167, 11.1009}, {166.167, 11.1005}, {166.166, 
       11.1001}, {166.166, 11.0997}, {166.165, 11.0994}, {166.164, 11.0991}, {
       166.164, 11.0988}}, {{171.379, 8.1528}, {171.379, 8.15327}, {171.378, 
       8.15377}, {171.378, 8.1543}, {171.378, 8.15483}, {171.378, 8.15537}, {
       171.378, 8.15593}, {171.378, 8.15647}, {171.378, 8.157}, {171.378, 
       8.15753}, {171.378, 8.15803}, {171.378, 8.1585}, {171.378, 8.15893}, {
       171.378, 8.15933}, {171.379, 8.1597}, {171.379, 8.16003}, {171.379, 
       8.1603}, {171.38, 8.16053}, {171.38, 8.1607}, {171.381, 8.1608}, {
       171.381, 8.16087}, {171.382, 8.16083}, {171.383, 8.1608}, {171.383, 
       8.16067}, {171.384, 8.1605}, {171.384, 8.16027}, {171.385, 8.16}, {
       171.385, 8.15967}, {171.386, 8.1593}, {171.386, 8.1589}, {171.387, 
       8.15843}, {171.387, 8.15797}, {171.387, 8.15747}, {171.387, 8.15693}, {
       171.388, 8.1564}, {171.388, 8.15587}, {171.388, 8.1553}, {171.388, 
       8.15477}, {171.388, 8.15423}, {171.388, 8.1537}, {171.388, 8.1532}, {
       171.388, 8.15273}, {171.387, 8.1523}, {171.387, 8.1519}, {171.387, 
       8.15153}, {171.386, 8.1512}, {171.386, 8.15093}, {171.386, 8.1507}, {
       171.385, 8.15053}, {171.385, 8.15043}, {171.384, 8.15037}, {171.384, 
       8.1504}, {171.383, 8.15043}, {171.382, 8.15057}, {171.382, 8.15073}, {
       171.381, 8.15097}, {171.381, 8.15123}, {171.38, 8.15157}, {171.38, 
       8.15193}, {171.379, 8.15233}, {171.379, 8.1528}}}],
     "\"MarshallIslands\""],
    Annotation[#, "MarshallIslands", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-61.0325, 14.4419}, {-61.063, 14.4338}, {-61.0849, 
      14.4452}, {-61.1069, 14.4899}, {-61.1032, 14.5053}, {-61.0971, 
      14.5134}, {-61.0837, 14.5126}, {-61.0496, 14.4956}, {-61.0276, 
      14.5004}, {-61.0252, 14.5143}, {-61.0264, 14.5346}, {-61.0386, 
      14.546}, {-61.069, 14.5557}, {-61.2057, 14.6126}, {-61.241, 
      14.6817}, {-61.2386, 14.702}, {-61.1996, 14.7313}, {-61.1996, 
      14.7467}, {-61.241, 14.7914}, {-61.241, 14.8174}, {-61.224, 
      14.8377}, {-61.1959, 14.8491}, {-61.1569, 14.8491}, {-61.1178, 
      14.8393}, {-61.0337, 14.8109}, {-60.9825, 14.7702}, {-60.9581, 
      14.7597}, {-60.913, 14.7637}, {-60.8569, 14.7759}, {-60.8411, 
      14.7735}, {-60.8386, 14.7646}, {-60.8472, 14.7524}, {-60.9154, 
      14.7337}, {-60.924, 14.7215}, {-60.9203, 14.7093}, {-60.8935, 
      14.6817}, {-60.8898, 14.6695}, {-60.9008, 14.6524}, {-60.9008, 
      14.6435}, {-60.8776, 14.637}, {-60.852, 14.637}, {-60.8398, 
      14.6305}, {-60.8337, 14.6183}, {-60.7837, 14.4842}, {-60.8191, 
      14.42}, {-60.8764, 14.3916}, {-60.9008, 14.3916}, {-60.9069, 
      14.3981}, {-60.9069, 14.4086}, {-60.8935, 14.433}, {-60.8947, 
      14.4436}, {-60.9154, 14.4558}, {-60.9483, 14.4639}, {-61.0008, 
      14.4566}, {-61.0325, 14.4419}}}],
     "\"Martinique\""],
    Annotation[#, "Martinique", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-17.05, 20.766666666666666`}, {-16.2, 
      20.216666666666665`}, {-16.53333333333333, 
      16.05}, {-13.383333333333333`, 16.03333333333333}, {-12.05, 
      14.716666666666667`}, {-11.5, 15.65}, {-5.5, 15.5}, {-6.583333333333333,
       25.}, {-4.8, 25.}, {-8.666666666666666, 27.3}, {-8.666666666666666, 
      26.}, {-12., 26.}, {-13.1, 22.9}, {-13., 21.333333333333332`}, {-17.05, 
      20.766666666666666`}}}],
     "\"Mauritania\""],
    Annotation[#, "Mauritania", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{57.3255, -20.5155}, {57.313, -20.4945}, {
      57.2832, -20.4548}, {57.2784, -20.4203}, {57.2926, -20.369}, {
      57.3349, -20.2958}, {57.3726, -20.2665}, {57.4668, -20.2288}, {
      57.5076, -20.1901}, {57.5358, -20.1033}, {57.5821, -20.0086}, {
      57.6088, -19.9877}, {57.6323, -19.9856}, {57.659, -19.9908}, {
      57.681, -20.0075}, {57.6826, -20.0421}, {57.6763, -20.109}, {
      57.6841, -20.1394}, {57.7108, -20.1833}, {57.7124, -20.2502}, {
      57.7218, -20.2733}, {57.7689, -20.3036}, {57.7783, -20.3245}, {
      57.7783, -20.3789}, {57.7649, -20.4098}, {57.7383, -20.4286}, {
      57.6975, -20.438}, {57.6723, -20.4611}, {57.6629, -20.5573}, {
      57.6425, -20.5772}, {57.5751, -20.6023}, {57.4872, -20.6253}, {
      57.4393, -20.6258}, {57.3671, -20.6216}, {57.2824, -20.6331}, {
      57.2541, -20.63}, {57.2463, -20.6154}, {57.2636, -20.5756}, {
      57.2824, -20.5662}, {57.3153, -20.5589}, {57.3232, -20.5432}, {
      57.3255, -20.5155}}}],
     "\"Mauritius\""],
    Annotation[#, "Mauritius", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{45.072, -12.8282}, {45.0657, -12.7916}, {
       45.0893, -12.7466}, {45.1473, -12.6912}, {45.1645, -12.6891}, {
       45.1818, -12.6954}, {45.1943, -12.7351}, {45.2272, -12.7634}, {
       45.3041, -12.7916}, {45.3198, -12.8062}, {45.3214, -12.8219}, {
       45.3026, -12.8397}, {45.2806, -12.8627}, {45.2806, -12.8773}, {
       45.2979, -12.9118}, {45.2924, -12.9322}, {45.2782, -12.9542}, {
       45.2798, -12.9699}, {45.2908, -12.9939}, {45.2892, -13.0075}, {
       45.2704, -13.0201}, {45.2547, -13.0232}, {45.203, -13.0451}, {
       45.1794, -13.0451}, {45.1622, -13.0347}, {45.1559, -13.0201}, {
       45.1136, -12.9866}, {45.1089, -12.9678}, {45.1214, -12.9563}, {
       45.1434, -12.9531}, {45.1732, -12.9605}, {45.1857, -12.9552}, {
       45.1967, -12.9343}, {45.1936, -12.8956}, {45.1747, -12.8758}, {
       45.1747, -12.8507}, {45.1653, -12.8454}, {45.1387, -12.8433}, {
       45.0994, -12.8454}, {45.0806, -12.8402}, {45.072, -12.8282}}, {{
       45.0873, -12.6695}, {45.0685, -12.6664}, {45.0551, -12.6512}, {
       45.063, -12.6366}, {45.0857, -12.6251}, {45.1014, -12.6251}, {
       45.1155, -12.6319}, {45.1249, -12.6465}, {45.1257, -12.6554}, {
       45.1147, -12.6659}, {45.0873, -12.6695}}}],
     "\"Mayotte\""],
    Annotation[#, "Mayotte", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-97.13333333333333, 
      25.966666666666665`}, {-97.88333333333333, 22.6}, {-95.86666666666666, 
      18.716666666666665`}, {-91.18333333333334, 
      18.666666666666668`}, {-91.36666666666666, 
      18.866666666666667`}, {-90.33333333333333, 
      21.03333333333333}, {-87.11666666666666, 21.616666666666667`}, {-88.3, 
      18.483333333333334`}, {-89.13333333333333, 
      17.816666666666666`}, {-90.98333333333333, 
      17.816666666666666`}, {-90.43333333333334, 16.1}, {-91.73333333333333, 
      16.066666666666666`}, {-92.25, 
      14.549999999999999`}, {-92.78333333333333, 
      15.083333333333334`}, {-92.25, 
      14.549999999999999`}, {-94.86666666666666, 
      16.433333333333334`}, {-97.78333333333333, 
      15.966666666666667`}, {-103.48333333333333`, 
      18.333333333333332`}, {-105.45, 
      19.916666666666668`}, {-105.71666666666667`, 
      22.53333333333333}, {-109.39999999999999`, 
      25.633333333333333`}, {-112.16666666666667`, 
      28.966666666666665`}, {-113.08333333333333`, 
      31.233333333333334`}, {-115.03333333333333`, 
      31.95}, {-112.86666666666666`, 
      28.28333333333333}, {-109.51666666666667`, 
      23.133333333333333`}, {-112.1, 
      24.733333333333334`}, {-115.01666666666667`, 
      27.733333333333334`}, {-114.06666666666666`, 
      28.516666666666666`}, {-117.11666666666666`, 
      32.53333333333333}, {-114.71666666666667`, 32.71666666666667}, {-109.05,
       31.333333333333332`}, {-106.51666666666667`, 
      31.78333333333333}, {-104.05, 
      29.333333333333332`}, {-100.83333333333333`, 
      29.28333333333333}, {-99.08333333333333, 26.4}, {-97.13333333333333, 
      25.966666666666665`}}}],
     "\"Mexico\""],
    Annotation[#, "Mexico", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{162.981, 5.42553}, {163.008, 5.4229}, {163.005, 5.3936}, {
       163.018, 5.37483}, {163.054, 5.37667}, {163.072, 5.36203}, {163.022, 
       5.32083}, {162.969, 5.29097}, {162.928, 5.27533}, {162.913, 5.272}, {
       162.87, 5.274}, {162.852, 5.29567}, {162.88, 5.34373}, {162.908, 
       5.35607}, {162.922, 5.37117}, {162.981, 5.42553}}, {{159.727, 
       6.63423}, {159.726, 6.63623}, {159.725, 6.63837}, {159.723, 6.64057}, {
       159.723, 6.64283}, {159.722, 6.64513}, {159.722, 6.64743}, {159.722, 
       6.64973}, {159.722, 6.652}, {159.722, 6.65417}, {159.723, 6.6563}, {
       159.724, 6.65827}, {159.725, 6.66013}, {159.727, 6.66183}, {159.728, 
       6.6634}, {159.73, 6.66473}, {159.732, 6.66587}, {159.734, 6.6668}, {
       159.737, 6.6675}, {159.739, 6.66797}, {159.741, 6.6682}, {159.744, 
       6.66817}, {159.746, 6.66793}, {159.749, 6.66743}, {159.752, 6.6667}, {
       159.754, 6.66573}, {159.756, 6.66457}, {159.759, 6.6632}, {159.761, 
       6.66163}, {159.763, 6.65993}, {159.764, 6.65803}, {159.766, 6.65603}, {
       159.767, 6.6539}, {159.768, 6.6517}, {159.769, 6.64943}, {159.77, 
       6.64713}, {159.77, 6.64483}, {159.77, 6.64253}, {159.77, 6.64027}, {
       159.77, 6.6381}, {159.769, 6.63597}, {159.768, 6.634}, {159.767, 
       6.63213}, {159.765, 6.63043}, {159.764, 6.62887}, {159.762, 6.62753}, {
       159.76, 6.6264}, {159.758, 6.62547}, {159.755, 6.62477}, {159.753, 
       6.6243}, {159.75, 6.62407}, {159.748, 6.6241}, {159.745, 6.62433}, {
       159.743, 6.62483}, {159.74, 6.62557}, {159.738, 6.62653}, {159.735, 
       6.6277}, {159.733, 6.62907}, {159.731, 6.63063}, {159.729, 6.63233}, {
       159.727, 6.63423}}, {{159.786, 6.59173}, {159.785, 6.59297}, {159.785, 
       6.5943}, {159.784, 6.59573}, {159.784, 6.59723}, {159.784, 6.5988}, {
       159.784, 6.60037}, {159.785, 6.602}, {159.786, 6.60363}, {159.787, 
       6.60523}, {159.788, 6.6068}, {159.79, 6.60833}, {159.792, 6.6098}, {
       159.794, 6.6112}, {159.796, 6.6125}, {159.799, 6.61367}, {159.801, 
       6.61473}, {159.804, 6.61563}, {159.807, 6.61643}, {159.809, 6.61703}, {
       159.812, 6.6175}, {159.815, 6.6178}, {159.817, 6.61793}, {159.82, 
       6.6179}, {159.823, 6.6177}, {159.825, 6.61733}, {159.827, 6.61677}, {
       159.829, 6.61607}, {159.831, 6.61523}, {159.832, 6.61423}, {159.834, 
       6.61313}, {159.835, 6.6119}, {159.836, 6.61057}, {159.836, 6.60913}, {
       159.836, 6.60763}, {159.836, 6.60607}, {159.836, 6.6045}, {159.835, 
       6.60287}, {159.834, 6.60123}, {159.833, 6.59963}, {159.832, 6.59807}, {
       159.83, 6.59653}, {159.828, 6.59507}, {159.826, 6.59367}, {159.824, 
       6.59237}, {159.821, 6.5912}, {159.819, 6.59013}, {159.816, 6.58923}, {
       159.814, 6.58843}, {159.811, 6.58783}, {159.808, 6.58737}, {159.805, 
       6.58707}, {159.803, 6.58693}, {159.8, 6.58697}, {159.798, 6.58717}, {
       159.795, 6.58753}, {159.793, 6.5881}, {159.791, 6.5888}, {159.789, 
       6.58963}, {159.788, 6.59063}, {159.786, 6.59173}}, {{159.823, 
       6.67163}, {159.822, 6.6736}, {159.823, 6.6756}, {159.823, 6.67763}, {
       159.823, 6.67963}, {159.824, 6.6816}, {159.825, 6.68353}, {159.826, 
       6.6854}, {159.828, 6.68713}, {159.829, 6.6888}, {159.831, 6.6903}, {
       159.833, 6.69167}, {159.834, 6.69287}, {159.836, 6.6939}, {159.839, 
       6.69473}, {159.841, 6.69537}, {159.843, 6.6958}, {159.845, 6.69603}, {
       159.847, 6.69607}, {159.849, 6.69587}, {159.851, 6.69547}, {159.853, 
       6.69487}, {159.855, 6.69407}, {159.856, 6.69307}, {159.858, 6.6919}, {
       159.859, 6.69057}, {159.86, 6.68907}, {159.861, 6.68747}, {159.862, 
       6.6857}, {159.863, 6.68387}, {159.863, 6.68197}, {159.863, 6.68}, {
       159.863, 6.678}, {159.863, 6.67597}, {159.862, 6.67397}, {159.861, 
       6.672}, {159.86, 6.67007}, {159.859, 6.6682}, {159.858, 6.66647}, {
       159.856, 6.6648}, {159.855, 6.6633}, {159.853, 6.66193}, {159.851, 
       6.66073}, {159.849, 6.6597}, {159.847, 6.65887}, {159.845, 6.65823}, {
       159.843, 6.6578}, {159.841, 6.65757}, {159.839, 6.65753}, {159.837, 
       6.65773}, {159.835, 6.65813}, {159.833, 6.65873}, {159.831, 6.65953}, {
       159.829, 6.66053}, {159.828, 6.6617}, {159.826, 6.66303}, {159.825, 
       6.66453}, {159.824, 6.66613}, {159.823, 6.6679}, {159.823, 6.66973}, {
       159.823, 6.67163}}, {{160.756, 6.07783}, {160.757, 6.07973}, {160.758, 
       6.08163}, {160.759, 6.08353}, {160.761, 6.08537}, {160.762, 6.0872}, {
       160.764, 6.08893}, {160.766, 6.0906}, {160.767, 6.09213}, {160.769, 
       6.09353}, {160.771, 6.09483}, {160.773, 6.09597}, {160.775, 6.0969}, {
       160.777, 6.0977}, {160.779, 6.0983}, {160.781, 6.0987}, {160.783, 
       6.0989}, {160.785, 6.0989}, {160.786, 6.09873}, {160.788, 6.09833}, {
       160.789, 6.09777}, {160.79, 6.097}, {160.791, 6.09603}, {160.792, 
       6.09493}, {160.792, 6.09367}, {160.793, 6.09227}, {160.793, 6.09073}, {
       160.793, 6.0891}, {160.793, 6.08737}, {160.792, 6.08557}, {160.791, 
       6.0837}, {160.791, 6.0818}, {160.789, 6.0799}, {160.788, 6.078}, {
       160.787, 6.07617}, {160.785, 6.07433}, {160.784, 6.0726}, {160.782, 
       6.07093}, {160.78, 6.0694}, {160.778, 6.068}, {160.776, 6.0667}, {
       160.774, 6.06557}, {160.772, 6.06463}, {160.77, 6.06383}, {160.768, 
       6.06323}, {160.766, 6.06283}, {160.765, 6.06263}, {160.763, 6.06263}, {
       160.761, 6.0628}, {160.76, 6.0632}, {160.759, 6.06377}, {160.757, 
       6.06453}, {160.756, 6.0655}, {160.756, 6.0666}, {160.755, 6.06787}, {
       160.755, 6.06927}, {160.755, 6.0708}, {160.755, 6.07243}, {160.755, 
       6.07417}, {160.755, 6.07597}, {160.756, 6.07783}}}],
     "\"Micronesia\""],
    Annotation[#, "Micronesia", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{26.666666666666668`, 48.25}, {28.28333333333333, 48.15}, {
      29.633333333333333`, 46.85}, {28.166666666666668`, 45.46666666666667}, {
      26.666666666666668`, 48.25}}}],
     "\"Moldova\""],
    Annotation[#, "Moldova", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{7.45, 43.75}, {7.383333333333333, 43.71666666666667}, {
      7.383333333333333, 43.733333333333334`}, {7.433333333333334, 43.75}}}],
     "\"Monaco\""],
    Annotation[#, "Monaco", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{87.85, 49.166666666666664`}, {90.9, 46.95}, {90.7, 
      45.31666666666666}, {95.4, 44.266666666666666`}, {96.38333333333333, 
      42.733333333333334`}, {105.25, 41.733333333333334`}, {
      110.13333333333333`, 42.65}, {111.96666666666667`, 43.7}, {112., 
      45.1}, {119.89999999999999`, 46.666666666666664`}, {118.43333333333334`,
       48.}, {115.58333333333333`, 47.88333333333333}, {116.71666666666667`, 
      49.833333333333336`}, {108.55, 49.333333333333336`}, {
      103.31666666666666`, 50.2}, {98.93333333333334, 52.15}, {
      97.33333333333333, 49.733333333333334`}, {92.38333333333333, 
      50.86666666666667}, {87.85, 49.166666666666664`}}}],
     "\"Mongolia\""],
    Annotation[#, "Mongolia", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{18.4559, 42.6212}, {18.5546, 42.7568}, {18.6716, 42.912}, {
      18.7274, 42.9668}, {18.8596, 43.0566}, {18.9112, 43.1287}, {18.9541, 
      43.2303}, {18.9918, 43.2773}, {19.0498, 43.3066}, {19.0964, 43.3133}, {
      19.1405, 43.3167}, {19.1405, 43.3175}, {19.182, 43.331}, {19.2227, 
      43.353}, {19.2541, 43.4001}, {19.2658, 43.4498}, {19.3011, 43.4811}, {
      19.3835, 43.5352}, {19.4323, 43.5648}, {20.3741, 42.9175}, {20.1441, 
      42.5785}, {20.0403, 42.5785}, {19.8845, 42.5585}, {19.8162, 42.5804}, {
      19.7533, 42.6314}, {19.7205, 42.6824}, {19.6877, 42.7006}, {19.6221, 
      42.686}, {19.5757, 42.584}, {19.3488, 42.3617}, {19.3078, 42.2543}, {
      19.3652, 42.1413}, {19.3597, 42.0484}, {19.3231, 41.9486}, {19.3141, 
      41.9515}, {19.0867, 42.0882}, {19.0014, 42.2126}, {18.8383, 42.3098}, {
      18.6357, 42.4102}, {18.6122, 42.4407}, {18.6172, 42.4538}, {18.6616, 
      42.4621}, {18.7012, 42.4736}, {18.7086, 42.4934}, {18.6765, 42.5148}, {
      18.6419, 42.5247}, {18.5974, 42.5362}, {18.5455, 42.5362}, {18.5109, 
      42.5164}, {18.4764, 42.6027}, {18.4559, 42.6212}}}],
     "\"Montenegro\""],
    Annotation[#, "Montenegro", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-62.2202, 16.7304}, {-62.2059, 16.6966}, {-62.2116, 
      16.6642}, {-62.2269, 16.6591}, {-62.2555, 16.6648}, {-62.267, 
      16.6839}, {-62.267, 16.7157}, {-62.2546, 16.7361}, {-62.2431, 
      16.738}, {-62.2345, 16.7374}, {-62.2202, 16.7304}}}],
     "\"Montserrat\""],
    Annotation[#, "Montserrat", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-2.2, 35.1}, {-5.416666666666667, 
      35.916666666666664`}, {-6.233333333333333, 
      35.016666666666666`}, {-9.283333333333333, 
      32.55}, {-10.233333333333333`, 
      29.316666666666666`}, {-13.183333333333334`, 
      27.666666666666668`}, {-8.666666666666666, 
      27.666666666666668`}, {-8.666666666666666, 
      28.716666666666665`}, {-3.6333333333333333`, 
      30.966666666666665`}, {-3.8166666666666664`, 
      31.7}, {-1.1833333333333333`, 32.1}, {-2.2, 35.1}}}],
     "\"Morocco\""],
    Annotation[#, "Morocco", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{40.43333333333333, -10.483333333333333`}, {
      40.666666666666664`, -15.283333333333333`}, {
      34.56666666666666, -19.616666666666667`}, {35.5, -24.1}, {
      32.81666666666666, -25.6}, {32.9, -26.849999999999998`}, {
      32.13333333333333, -26.833333333333332`}, {
      31.966666666666665`, -25.95}, {31.3, -22.416666666666668`}, {
      33.03333333333333, -20.03333333333333}, {
      32.983333333333334`, -16.716666666666665`}, {
      30.416666666666668`, -15.633333333333333`}, {
      33.21666666666667, -14.016666666666666`}, {
      34.53333333333333, -14.583333333333334`}, {
      35.28333333333333, -17.133333333333333`}, {
      35.916666666666664`, -14.883333333333333`}, {
      34.56666666666666, -13.35}, {34.95, -11.566666666666666`}, {
      40.43333333333333, -10.483333333333333`}}}],
     "\"Mozambique\""],
    Annotation[#, "Mozambique", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{98.75, 10.35}, {97.73333333333333, 16.566666666666666`}, {
      96.88333333333333, 17.45}, {95.66666666666667, 15.95}, {94.25, 
      15.966666666666667`}, {94.08333333333333, 19.383333333333333`}, {92.2, 
      21.133333333333333`}, {92.6, 21.983333333333334`}, {95.13333333333333, 
      26.616666666666667`}, {97.13333333333333, 27.083333333333332`}, {97.35, 
      28.216666666666665`}, {98.15, 28.133333333333333`}, {98.71666666666667, 
      25.866666666666667`}, {97.53333333333333, 23.933333333333334`}, {98.9, 
      24.1}, {101.15, 21.566666666666666`}, {100.08333333333333`, 20.35}, {
      101.15, 21.566666666666666`}, {100.08333333333333`, 20.35}, {97.35, 
      18.55}, {98.93333333333334, 16.383333333333333`}, {98.18333333333334, 
      15.1}, {99.66666666666667, 11.833333333333334`}, {98.75, 10.35}}}],
     "\"Myanmar\""],
    Annotation[#, "Myanmar", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{11.766666666666666`, -17.25}, {
      14.533333333333333`, -22.683333333333334`}, {
      14.45, -23.133333333333333`}, {
      16.483333333333334`, -28.583333333333332`}, {
      20., -28.433333333333334`}, {20., -24.766666666666666`}, {20., -22.}, {
      21., -18.316666666666666`}, {25.266666666666666`, -17.8}, {
      23.483333333333334`, -17.633333333333333`}, {
      13.85, -17.333333333333332`}, {11.766666666666666`, -17.25}}}],
     "\"Namibia\""],
    Annotation[#, "Namibia", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{167.089, -0.5351}, {167.102, -0.537767}, {
      167.113, -0.549833}, {167.117, -0.563633}, {167.112, -0.578633}, {
      167.095, -0.588367}, {167.074, -0.589533}, {167.062, -0.581867}, {
      167.057, -0.567167}, {167.059, -0.547167}, {167.074, -0.539533}, {
      167.089, -0.5351}}}],
     "\"Nauru\""],
    Annotation[#, "Nauru", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{81.01666666666667, 30.2}, {88.15, 27.866666666666667`}, {
      87.33333333333333, 26.349999999999998`}, {82.76666666666667, 27.5}, {
      80.06666666666666, 28.833333333333332`}, {81.01666666666667, 30.2}}}],
     "\"Nepal\""],
    Annotation[#, "Nepal", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{3.3666666666666667`, 51.36666666666667}, {
      4.733333333333333, 52.96666666666667}, {7.216666666666667, 53.25}, {
      6.016666666666667, 50.75}, {3.3666666666666667`, 51.36666666666667}}}],
     "\"Netherlands\""],
    Annotation[#, "Netherlands", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-68.6607, 12.0372}, {-68.7562, 12.0454}, {-68.8299, 
       12.0627}, {-68.9091, 12.1163}, {-69.0483, 12.2073}, {-69.1042, 
       12.2237}, {-69.1574, 12.2682}, {-69.1616, 12.3637}, {-69.1479, 
       12.3874}, {-69.1302, 12.3974}, {-69.1083, 12.3928}, {-69.0565, 
       12.3482}, {-68.9882, 12.2491}, {-68.9446, 12.2246}, {-68.8845, 
       12.2146}, {-68.8204, 12.1955}, {-68.7808, 12.1555}, {-68.7303, 
       12.0927}, {-68.6894, 12.0763}, {-68.6539, 12.0581}, {-68.6389, 
       12.0436}, {-68.6471, 12.0372}, {-68.6607, 12.0372}}, {{-68.1751, 
       12.2157}, {-68.1626, 12.2081}, {-68.1543, 12.19}, {-68.1657, 
       12.1637}, {-68.1543, 12.1228}, {-68.1616, 12.1131}, {-68.172, 
       12.1103}, {-68.1928, 12.1138}, {-68.2084, 12.1082}, {-68.2105, 
       12.0978}, {-68.1928, 12.0562}, {-68.2, 12.0431}, {-68.2167, 
       12.0375}, {-68.2322, 12.041}, {-68.2833, 12.093}, {-68.2874, 
       12.1103}, {-68.2635, 12.1436}, {-68.2604, 12.1616}, {-68.2884, 
       12.1859}, {-68.3686, 12.2185}, {-68.3966, 12.2538}, {-68.3998, 
       12.2857}, {-68.381, 12.3044}, {-68.3571, 12.3065}, {-68.3269, 
       12.2968}, {-68.2666, 12.24}, {-68.2396, 12.2261}, {-68.1751, 
       12.2157}}, {{-66.6175, 11.7979}, {-66.6056, 11.7802}, {-66.6175, 
       11.7503}, {-66.6385, 11.7332}, {-66.7082, 11.7161}, {-66.7357, 
       11.7186}, {-66.7512, 11.732}, {-66.7457, 11.7467}, {-66.7256, 
       11.7589}, {-66.6926, 11.7589}, {-66.6669, 11.7644}, {-66.6404, 
       11.7766}, {-66.6221, 11.7992}, {-66.6175, 11.7979}}, {{-66.8057, 
       11.7619}, {-66.836, 11.7387}, {-66.9102, 11.7112}, {-66.9345, 
       11.7112}, {-66.9537, 11.7167}, {-66.9537, 11.7326}, {-66.9363, 
       11.7564}, {-66.9134, 11.7625}, {-66.8355, 11.7723}, {-66.8089, 
       11.7699}, {-66.8057, 11.7619}}, {{-66.1562, 11.8089}, {-66.1617, 
       11.7869}, {-66.1929, 11.7631}, {-66.235, 11.7527}, {-66.2992, 
       11.7552}, {-66.3001, 11.7619}, {-66.2927, 11.7778}, {-66.2213, 
       11.801}, {-66.1966, 11.8138}, {-66.1681, 11.8175}, {-66.1581, 
       11.8132}, {-66.1562, 11.8089}}}],
     "\"NetherlandsAntilles\""],
    Annotation[#, "NetherlandsAntilles", "Tooltip"]& ], 
   TagBox[
    TooltipBox[PolygonBox[{CompressedData["
1:eJxdWXd8T9cbtqpWUbtVtWpTtOdcap6YkVAktoiKE1TN2qtKEhmCSsSIIPao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       "], CompressedData["
1:eJxdlAlMFVcUhp8GjRVFpCBuUJbSmmKL6LkKMergAmq1TdEgol2EoSpRW1kU
caFiiIKKEpSStA1tCViLEqwiRl/wqAguKGJVJMQFeID4WHygEEWJ/x0mvsRJ
JpMv995zzn/Of8c9/KfgyIEGg2EhXvk1xmaMtmlSFfHd2QXDLhJnbXDYxeCy
9fRLMRN77x5Vc7NZVV61mdn/EvEsufGJqizuSlsSW0qcGIUI4D3JYf8bL1k5
OjXN1HneyvEJuRPnGImnpQT80Aj+IPWjiPazxN0TVh642KIqme5pcRvPEcvl
W09VpanAy7SrhPjBx4N3Hjariv+pK5tKEK8h97dSt1ZV6YvsMa26QPyv5fbi
cLDvkGPjw1CPTDcavMPFb/Xcq8Sh8iDiSVxbSQx11/5CvqSYwEPd94iHDYRC
8H9/dBwpq7XW11CedS7zMTG6E2KH9bvNUd7dzcQ+sqAWXU8rcfAZ12QzOCQ7
//j9Dque4E//TCm0EI+TB8COt+bef/aceKkUgPiRY+pDnXuIA093vbkDLg5P
rJnxkviyW2H0GuyfPfNJzbFXxFJ2NuoPSKovz+ol/ircPtS/1crJ5m/OuLap
imftyx1Rr4mbe49aboP3/4pBGgRLeTXtqoLkC5cPFhxi9zmk4rwlouJbW8GV
PUsacsHaPjvBs9F+D7Cma6TggqC6BEecn39+u4ufs2AbGQDxK39ER8aJ/nrB
G2cMrc5xExymTn/0Nfjk05giJ2/Bf8+DQNRrcnS52ugjuBPjsgeXnvhiQ46v
4DEyIPQ5F1cZHk4WvHcdFEB/3tBArzgwshcEgf3vXV5Pk/T44Kr0lX1zPhO8
uSR7rA9Y67uXeDe/Pc9rq3d6CtZ8ARYdfvOCPARPkQ/8rOVxF5wHOxXC77FF
Tr3XXfX4jaqC6Y43Owj+HcvRJlWpSEQHhgtGlhcTwBEY15YhenxwzgDjIAcb
wXfjWz7xNen+Qf813zaoSpw0Uh+xvTRkvap8n7XIaR/mq/WzTlVeoNyYbuJF
UgB495Fl1ybDL9Ie8eB10nBd1N+vev2+dhLHrElv24b4/5R9OS3FovsV9efP
XLbiBPwol2eB00ckTM1vJ9b2Ner3o0XPD65NfYMbRf3zRj/KsS3gse4/sOYT
3I+tGEddk34fqq3/iw87A2AJYmmDnxGvzjbjaFIV8Y0KPOjHFbTjIO6ftKkR
rPn0BnHfHTQM+0fYFuVtKSd+/3/0FognWEo=
       "], {{166.547, -20.3581}, {166.603, -20.3685}, {166.668, -20.3871}, {
       166.728, -20.4139}, {166.743, -20.4384}, {166.738, -20.4607}, {
       166.721, -20.4741}, {166.713, -20.4719}, {166.696, -20.46}, {
       166.68, -20.4555}, {166.676, -20.4637}, {166.676, -20.489}, {
       166.665, -20.5306}, {166.648, -20.5939}, {166.641, -20.6236}, {
       166.655, -20.6325}, {166.679, -20.6273}, {166.706, -20.6318}, {
       166.706, -20.6429}, {166.682, -20.6653}, {166.636, -20.7084}, {
       166.616, -20.7411}, {166.595, -20.7671}, {166.571, -20.7768}, {
       166.532, -20.7813}, {166.493, -20.7954}, {166.462, -20.8014}, {
       166.438, -20.7917}, {166.427, -20.7895}, {166.408, -20.7947}, {
       166.397, -20.7895}, {166.404, -20.7738}, {166.425, -20.7545}, {
       166.468, -20.7195}, {166.497, -20.6712}, {166.512, -20.6296}, {
       166.542, -20.5916}, {166.564, -20.5596}, {166.579, -20.5046}, {
       166.594, -20.4436}, {166.586, -20.4034}, {166.561, -20.3915}, {
       166.531, -20.3849}, {166.527, -20.3737}, {166.535, -20.3625}, {
       166.547, -20.3581}}, {{167.912, -21.4404}, {167.927, -21.4553}, {
       167.95, -21.4718}, {167.966, -21.4809}, {167.986, -21.4841}, {
       168.017, -21.4788}, {168.026, -21.4734}, {168.037, -21.4718}, {
       168.046, -21.4777}, {168.045, -21.4921}, {168.053, -21.4932}, {
       168.065, -21.4868}, {168.085, -21.4862}, {168.109, -21.4841}, {
       168.131, -21.4804}, {168.153, -21.4777}, {168.169, -21.4836}, {
       168.171, -21.4926}, {168.159, -21.5108}, {168.139, -21.5358}, {
       168.133, -21.5582}, {168.121, -21.5859}, {168.111, -21.6163}, {
       168.095, -21.6323}, {168.064, -21.6542}, {168.042, -21.6617}, {
       168.026, -21.6595}, {167.991, -21.651}, {167.947, -21.6307}, {
       167.92, -21.6211}, {167.902, -21.6147}, {167.886, -21.6169}, {
       167.867, -21.6227}, {167.841, -21.635}, {167.825, -21.6387}, {
       167.818, -21.6329}, {167.818, -21.6131}, {167.808, -21.5849}, {
       167.79, -21.5598}, {167.77, -21.5364}, {167.745, -21.5214}, {
       167.722, -21.5081}, {167.714, -21.4937}, {167.714, -21.4777}, {
       167.727, -21.4681}, {167.754, -21.467}, {167.79, -21.4686}, {
       167.814, -21.4766}, {167.83, -21.4788}, {167.842, -21.4782}, {
       167.858, -21.4729}, {167.864, -21.4628}, {167.879, -21.4484}, {
       167.898, -21.4377}, {167.912, -21.4404}}, {{167.506, -22.5131}, {
       167.541, -22.5332}, {167.585, -22.5508}, {167.626, -22.5653}, {
       167.662, -22.583}, {167.678, -22.6075}, {167.68, -22.6377}, {
       167.658, -22.6591}, {167.637, -22.6667}, {167.609, -22.6616}, {
       167.596, -22.6358}, {167.584, -22.6094}, {167.571, -22.6044}, {
       167.56, -22.6088}, {167.557, -22.6302}, {167.562, -22.6812}, {
       167.551, -22.6906}, {167.54, -22.6925}, {167.509, -22.6849}, {
       167.492, -22.6862}, {167.49, -22.6963}, {167.485, -22.7108}, {
       167.475, -22.7158}, {167.458, -22.7133}, {167.447, -22.7001}, {
       167.428, -22.6679}, {167.42, -22.6232}, {167.426, -22.6}, {
       167.444, -22.5767}, {167.443, -22.5483}, {167.435, -22.5225}, {
       167.442, -22.5131}, {167.464, -22.5087}, {167.486, -22.5099}, {
       167.506, -22.5131}}}],
     "\"NewCaledonia\""],
    Annotation[#, "NewCaledonia", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{174.01666666666665`, -41.68333333333333}, {
       172.71666666666667`, -40.5}, {171.46666666666667`, -41.75}, {
       166.73333333333332`, -46.21666666666667}, {
       170.78333333333333`, -45.88333333333333}, {
       170.48333333333332`, -44.75}, {172.2, -43.9}, {170.95, -43.3}, {
       172.75, -43.266666666666666`}, {
       174.01666666666665`, -41.68333333333333}}, {{
       176.93333333333334`, -39.68333333333333}, {
       175.23333333333332`, -41.61666666666667}, {175.35, -40.2}, {
       173.8, -39.416666666666664`}, {174.95, -37.06666666666666}, {
       172.7, -34.416666666666664`}, {176., -37.63333333333333}, {
       178.55, -37.7}, {176.93333333333334`, -39.68333333333333}}}],
     "\"NewZealand\""],
    Annotation[#, "NewZealand", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-83.13333333333333, 15.}, {-83.65, 
      10.916666666666666`}, {-85.68333333333334, 
      11.066666666666666`}, {-87.33333333333333, 
      12.966666666666667`}, {-83.13333333333333, 15.}}}],
     "\"Nicaragua\""],
    Annotation[#, "Nicaragua", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{14.966666666666667`, 22.983333333333334`}, {
      11.983333333333333`, 23.516666666666666`}, {4.25, 19.15}, {
      3.8833333333333333`, 15.716666666666667`}, {0.23333333333333334`, 
      15.}, {2.4, 11.9}, {3.5666666666666664`, 11.75}, {3.6, 11.7}, {
      4.883333333333333, 13.783333333333333`}, {9.633333333333333, 12.8}, {
      13.633333333333333`, 13.716666666666667`}, {15.483333333333333`, 
      16.9}, {16., 20.35}, {14.966666666666667`, 22.983333333333334`}}}],
     "\"Niger\""],
    Annotation[#, "Niger", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{8.583333333333334, 4.8}, {6.1, 4.266666666666667}, {
      5.283333333333333, 5.9}, {2.716666666666667, 6.366666666666666}, {
      3.5666666666666664`, 11.75}, {3.6, 11.7}, {4.883333333333333, 
      13.783333333333333`}, {9.633333333333333, 12.8}, {13.633333333333333`, 
      13.716666666666667`}, {14.083333333333334`, 13.066666666666666`}, {
      14.65, 11.566666666666666`}, {11.883333333333333`, 7.083333333333333}, {
      9.8, 6.8}, {8.583333333333334, 4.8}}}],
     "\"Nigeria\""],
    Annotation[#, "Nigeria", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-169.825, -18.9094}, {-169.744, -18.9068}, {-169.713, \
-18.912}, {-169.684, -18.9546}, {-169.682, -18.9908}, {-169.668, -19.036}, \
{-169.639, -19.0541}, {-169.647, -19.0696}, {-169.691, -19.0955}, {-169.759, \
-19.1291}, {-169.806, -19.1394}, {-169.835, -19.1239}, {-169.854, -19.0903}, \
{-169.868, -19.0709}, {-169.889, -19.0515}, {-169.924, -19.0347}, {-169.92, \
-19.0089}, {-169.911, -18.9637}, {-169.881, -18.9275}, {-169.825, \
-18.9094}}}],
     "\"Niue\""],
    Annotation[#, "Niue", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{167.793, -29.057}, {167.811, -29.0471}, {
       167.838, -29.0449}, {167.872, -29.0501}, {167.939, -29.0957}, {
       167.935, -29.1234}, {167.889, -29.1396}, {167.862, -29.1384}, {
       167.831, -29.1263}, {167.794, -29.0951}, {167.793, -29.057}}, {{
       167.907, -29.174}, {167.932, -29.1756}, {167.947, -29.1844}, {
       167.946, -29.1999}, {167.921, -29.2173}, {167.901, -29.2173}, {
       167.889, -29.2057}, {167.889, -29.1895}, {167.907, -29.174}}}],
     "\"NorfolkIsland\""],
    Annotation[#, "NorfolkIsland", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{145.885, 15.3413}, {145.905, 15.3471}, {145.918, 
       15.3413}, {145.916, 15.3281}, {145.906, 15.3105}, {145.892, 15.2939}, {
       145.869, 15.2729}, {145.864, 15.2236}, {145.853, 15.2153}, {145.833, 
       15.2162}, {145.809, 15.2226}, {145.793, 15.2162}, {145.793, 15.2016}, {
       145.8, 15.1889}, {145.787, 15.1718}, {145.757, 15.1694}, {145.735, 
       15.1772}, {145.721, 15.1938}, {145.724, 15.2123}, {145.743, 15.2377}, {
       145.76, 15.2714}, {145.773, 15.2963}, {145.793, 15.3046}, {145.822, 
       15.3071}, {145.846, 15.3159}, {145.885, 15.3413}}, {{145.717, 
       15.1281}, {145.73, 15.1354}, {145.747, 15.1276}, {145.752, 15.1076}, {
       145.753, 15.0846}, {145.76, 15.0763}, {145.785, 15.0614}, {145.79, 
       15.0341}, {145.753, 14.9833}, {145.736, 14.953}, {145.72, 14.9437}, {
       145.702, 14.9447}, {145.689, 14.952}, {145.685, 14.9716}, {145.695, 
       14.9899}, {145.692, 15.0182}, {145.671, 15.047}, {145.662, 15.068}, {
       145.681, 15.0885}, {145.703, 15.1037}, {145.717, 15.1281}}, {{145.398, 
       14.247}, {145.413, 14.2377}, {145.411, 14.2245}, {145.365, 14.2035}, {
       145.335, 14.185}, {145.318, 14.1581}, {145.257, 14.1408}, {145.216, 
       14.1388}, {145.204, 14.15}, {145.21, 14.1715}, {145.25, 14.196}, {
       145.29, 14.2126}, {145.317, 14.2438}, {145.344, 14.258}, {145.379, 
       14.2587}, {145.398, 14.247}}}],
     "\"NorthernMarianaIslands\""],
    Annotation[#, "NorthernMarianaIslands", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{128.36666666666667`, 38.61666666666667}, {127.5, 
      39.71666666666667}, {130.68333333333334`, 42.3}, {130.6, 
      42.416666666666664`}, {124.36666666666666`, 40.1}, {125.64999999999999`,
       38.63333333333333}, {124.66666666666667`, 38.11666666666667}, {126.7, 
      37.833333333333336`}, {128.36666666666667`, 38.61666666666667}}}],
     "\"NorthKorea\""],
    Annotation[#, "NorthKorea", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{30.78333333333333, 69.78333333333333}, {
       31.066666666666666`, 70.28333333333333}, {29.099999999999998`, 
       70.86666666666666}, {27.65, 71.11666666666666}, {25.366666666666667`, 
       70.96666666666667}, {18.1, 69.31666666666666}, {13.183333333333334`, 
       66.66666666666667}, {9.55, 63.766666666666666`}, {11.45, 
       63.78333333333333}, {6.883333333333333, 62.916666666666664`}, {
       5.083333333333333, 62.18333333333333}, {6.816666666666666, 
       61.86666666666667}, {5.2, 61.1}, {7.7, 61.233333333333334`}, {
       5.183333333333334, 60.65}, {7.1, 60.5}, {5.183333333333334, 59.5}, {
       6.6, 58.06666666666666}, {10.566666666666666`, 59.88333333333333}, {
       11.433333333333334`, 58.983333333333334`}, {12.133333333333333`, 
       63.583333333333336`}, {20.583333333333332`, 69.05}, {25.75, 
       68.98333333333333}, {27.9, 70.08333333333333}, {28.966666666666665`, 
       69.05}, {29.016666666666666`, 69.03333333333333}, {30.849999999999998`,
        69.8}}, {{24.85, 80.35}, {23.916666666666668`, 79.18333333333334}, {
       17.78333333333333, 80.13333333333333}, {24.85, 80.35}}, {{
       10.683333333333334`, 79.53333333333333}, {13., 78.2}, {17.3, 
       78.41666666666667}, {13.583333333333334`, 78.05}, {16.35, 
       76.56666666666666}, {21.55, 78.76666666666667}, {16.3, 
       80.06666666666666}, {16.45, 78.9}, {10.683333333333334`, 
       79.53333333333333}}}],
     "\"Norway\""],
    Annotation[#, "Norway", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{53.1, 16.633333333333333`}, {57.8, 18.966666666666665`}, {
      59.8, 22.216666666666665`}, {56.6, 24.5}, {55.833333333333336`, 
      23.166666666666668`}, {56.666666666666664`, 22.}, {51.983333333333334`, 
      19.}, {53.1, 16.633333333333333`}}}],
     "\"Oman\""],
    Annotation[#, "Oman", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{61.61666666666667, 25.2}, {66.7, 25.116666666666667`}, {
      68.2, 23.766666666666666`}, {71.1, 24.416666666666668`}, {
      69.51666666666667, 27.}, {71.9, 27.966666666666665`}, {
      74.68333333333334, 31.066666666666666`}, {75.38333333333333, 
      32.28333333333333}, {73.95, 34.65}, {77.81666666666666, 35.5}, {
      74.56666666666666, 37.03333333333333}, {71.63333333333333, 
      36.46666666666667}, {69.9, 34.016666666666666`}, {69.33333333333333, 
      31.933333333333334`}, {66.71666666666667, 31.216666666666665`}, {66.25, 
      29.849999999999998`}, {60.86666666666667, 29.866666666666667`}, {
      63.333333333333336`, 27.133333333333333`}, {61.61666666666667, 25.2}}}],
     
     "\"Pakistan\""],
    Annotation[#, "Pakistan", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{134.807, 7.69797}, {134.829, 7.6953}, {134.851, 7.68203}, {
       134.889, 7.61567}, {134.883, 7.54403}, {134.853, 7.50023}, {134.807, 
       7.41663}, {134.777, 7.35297}, {134.746, 7.33703}, {134.69, 7.32907}, {
       134.64, 7.345}, {134.604, 7.37683}, {134.586, 7.41533}, {134.602, 
       7.42327}, {134.628, 7.414}, {134.656, 7.4246}, {134.68, 7.4631}, {
       134.716, 7.53077}, {134.738, 7.552}, {134.803, 7.54137}, {134.817, 
       7.552}, {134.817, 7.5825}, {134.789, 7.63027}, {134.785, 7.68337}, {
       134.807, 7.69797}}, {{134.429, 7.28927}, {134.455, 7.26537}, {134.483, 
       7.24413}, {134.511, 7.24017}, {134.515, 7.20167}, {134.487, 7.19107}, {
       134.423, 7.20037}, {134.389, 7.22423}, {134.34, 7.25077}, {134.34, 
       7.276}, {134.365, 7.2919}, {134.379, 7.32377}, {134.407, 7.3251}, {
       134.429, 7.28927}}}],
     "\"Palau\""],
    Annotation[#, "Palau", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-82.56666666666666, 
      9.566666666666666}, {-80.03333333333333, 
      9.266666666666666}, {-79.83333333333333, 
      9.366666666666667}, {-77.36666666666666, 
      8.683333333333334}, {-77.88333333333333, 
      7.233333333333333}, {-78.11666666666666, 8.55}, {-79.53333333333333, 
      8.933333333333334}, {-79.6, 8.883333333333333}, {-80.43333333333334, 
      7.25}, {-82.9, 8.033333333333333}, {-82.56666666666666, 
      9.566666666666666}}}],
     "\"Panama\""],
    Annotation[#, "Panama", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{141., -2.6}, {147.48333333333332`, -5.983333333333333}, {
       147.18333333333334`, -7.466666666666667}, {
       150.88333333333333`, -10.233333333333333`}, {
       147.71666666666667`, -10.1}, {144.51666666666665`, -7.5}, {
       142.13333333333333`, -8.233333333333333}, {
       143.33333333333334`, -9.033333333333333}, {141., -9.133333333333333}, {
       141., -2.6}}, {{152.18333333333334`, -4.15}, {
       151.03333333333333`, -6.05}, {
       148.36666666666667`, -5.483333333333333}, {
       150.93333333333334`, -5.483333333333333}, {
       152.18333333333334`, -4.15}}}],
     "\"PapuaNewGuinea\""],
    Annotation[#, "PapuaNewGuinea", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-54.6, -25.566666666666666`}, {-55.583333333333336`, \
-27.28333333333333}, {-58.6, -27.316666666666666`}, {-57.75, \
-25.183333333333334`}, {-62.65, -22.233333333333334`}, {-61.75, -19.65}, \
{-58.166666666666664`, -20.166666666666668`}, {-57.983333333333334`, \
-22.083333333333332`}, {-55.85, -22.28333333333333}, {-55.4, \
-23.966666666666665`}, {-54.25, -24.05}, {-54.6, -25.566666666666666`}}}],
     "\"Paraguay\""],
    Annotation[#, "Paraguay", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-70.4, -18.35}, {-76.28333333333333, \
-14.166666666666666`}, {-78.76666666666667, -8.583333333333334}, \
{-81.18333333333334, -6.}, {-80.33333333333333, -3.3666666666666667`}, \
{-80.48333333333333, -4.433333333333334}, {-79.03333333333333, -5.}, \
{-75.28333333333333, -0.1}, {-72.93333333333334, -2.433333333333333}, {-70.1, \
-2.6333333333333333`}, {-70.71666666666667, -3.783333333333333}, {-69.95, \
-4.216666666666667}, {-72.9, -5.133333333333333}, {-74.01666666666667, \
-7.533333333333333}, {-73.2, -9.4}, {-70.51666666666667, -9.433333333333334}, \
{-70.63333333333333, -11.016666666666666`}, {-69.56666666666666, -10.95}, \
{-68.66666666666667, -12.5}, {-69.5, -17.5}, {-70.4, -18.35}}}],
     "\"Peru\""],
    Annotation[#, "Peru", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{122.28333333333333`, 18.4}, {121.38333333333333`, 
       15.283333333333333`}, {121.95, 13.983333333333333`}, {
       123.93333333333334`, 13.783333333333333`}, {124.08333333333333`, 
       12.55}, {122.53333333333333`, 13.966666666666667`}, {122.6, 
       13.166666666666666`}, {120.63333333333333`, 13.799999999999999`}, {
       119.78333333333333`, 16.316666666666666`}, {120.6, 
       18.53333333333333}, {122.3, 18.4}}, {{123.26666666666667`, 
       12.583333333333334`}, {124.06666666666666`, 11.733333333333333`}, {
       123.26666666666667`, 12.583333333333334`}}, {{120.36666666666666`, 
       13.516666666666666`}, {121.55, 13.116666666666667`}, {
       121.11666666666666`, 12.233333333333333`}, {120.38333333333333`, 
       13.516666666666666`}}, {{125.45, 9.8}, {126.61666666666666`, 
       7.266666666666667}, {126.2, 6.266666666666667}, {125.66666666666667`, 
       7.25}, {125.39999999999999`, 5.583333333333333}, {123.68333333333334`, 
       7.816666666666666}, {121.88333333333333`, 7.1}, {123.39999999999999`, 
       8.716666666666667}, {123.68333333333334`, 7.966666666666667}, {
       125.51666666666667`, 9.}, {125.45, 9.816666666666666}}, {{
       124.43333333333334`, 10.1}, {123.8, 9.75}, {124.45, 10.1}}, {{
       123.53333333333333`, 10.883333333333333`}, {123.21666666666667`, 
       9.1}, {122.39999999999999`, 9.833333333333334}, {123.53333333333333`, 
       10.883333333333333`}}, {{122.03333333333333`, 11.9}, {
       123.16666666666667`, 11.466666666666667`}, {121.93333333333334`, 
       10.433333333333334`}, {122.03333333333333`, 11.9}}, {{
       119.51666666666667`, 11.416666666666666`}, {119.71666666666667`, 
       10.5}, {117.18333333333334`, 8.333333333333334}, {119.51666666666667`, 
       11.4}}}],
     "\"Philippines\""],
    Annotation[#, "Philippines", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-128.299, -24.343}, {-128.298, -24.3515}, {-128.295, \
-24.3588}, {-128.289, -24.368}, {-128.287, -24.3822}, {-128.286, -24.395}, \
{-128.287, -24.4024}, {-128.289, -24.4054}, {-128.291, -24.4071}, {-128.295, \
-24.4065}, {-128.302, -24.4021}, {-128.31, -24.3993}, {-128.317, -24.3992}, \
{-128.324, -24.3982}, {-128.332, -24.3941}, {-128.335, -24.387}, {-128.345, \
-24.3689}, {-128.346, -24.3605}, {-128.346, -24.3508}, {-128.343, -24.3407}, \
{-128.336, -24.3311}, {-128.333, -24.3267}, {-128.331, -24.3255}, {-128.324, \
-24.326}, {-128.312, -24.3246}, {-128.303, -24.3209}, {-128.297, -24.3185}, \
{-128.294, -24.3159}, {-128.294, -24.3191}, {-128.297, -24.3235}, {-128.298, \
-24.3313}, {-128.298, -24.3389}, {-128.299, -24.343}}}],
     "\"PitcairnIslands\""],
    Annotation[#, "PitcairnIslands", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{14.233333333333333`, 53.93333333333333}, {
      19.616666666666667`, 54.46666666666667}, {23.5, 53.949999999999996`}, {
      23.6, 51.516666666666666`}, {22.55, 49.083333333333336`}, {
      14.833333333333334`, 50.86666666666667}, {14.233333333333333`, 
      53.93333333333333}}}],
     "\"Poland\""],
    Annotation[#, "Poland", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-7.416666666666667, 
      37.18333333333333}, {-8.916666666666666, 37.18333333333333}, {-9.5, 
      38.71666666666667}, {-8.75, 41.96666666666667}, {-6.183333333333334, 
      41.583333333333336`}, {-7.416666666666667, 37.18333333333333}}}],
     "\"Portugal\""],
    Annotation[#, "Portugal", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-67.2097, 18.0158}, {-67.19, 18.1095}, {-67.1477, 
       18.1659}, {-67.1477, 18.2143}, {-67.1779, 18.2657}, {-67.2762, 
       18.3403}, {-67.2807, 18.3584}, {-67.2671, 18.3796}, {-67.1976, 
       18.3957}, {-67.1839, 18.4078}, {-67.1794, 18.435}, {-67.1673, 
       18.4492}, {-67.1068, 18.4592}, {-67.0705, 18.4512}, {-66.9737, 
       18.4179}, {-66.6606, 18.4149}, {-66.3823, 18.3947}, {-66.0859, 
       18.4007}, {-65.9649, 18.3846}, {-65.8243, 18.3564}, {-65.7638, 
       18.3544}, {-65.6806, 18.3715}, {-65.6595, 18.3735}, {-65.6458, 
       18.3675}, {-65.6443, 18.3584}, {-65.6897, 18.2717}, {-65.6852, 
       18.2445}, {-65.67, 18.2254}, {-65.6201, 18.2012}, {-65.6126, 
       18.1871}, {-65.6247, 18.177}, {-65.6806, 18.1558}, {-65.7215, 
       18.1236}, {-65.7835, 18.0248}, {-65.8742, 17.9714}, {-66.1283, 
       17.924}, {-66.1918, 17.919}, {-66.216, 17.922}, {-66.2584, 
       17.9421}, {-66.2886, 17.9482}, {-66.4565, 17.9401}, {-66.6803, 
       17.9522}, {-66.8089, 17.9704}, {-66.8437, 17.9684}, {-66.8951, 
       17.9442}, {-66.9299, 17.9351}, {-66.9707, 17.9351}, {-67.0478, 
       17.9613}, {-67.0872, 17.9623}, {-67.1311, 17.9502}, {-67.1764, 
       17.92}, {-67.2067, 17.9139}, {-67.2369, 17.919}, {-67.2536, 
       17.9361}, {-67.2536, 17.9593}, {-67.2415, 17.9804}, {-67.2097, 
       18.0158}}, {{-65.4332, 18.0852}, {-65.4239, 18.0852}, {-65.4099, 
       18.0821}, {-65.3882, 18.0666}, {-65.3882, 18.0552}, {-65.4022, 
       18.0469}, {-65.4441, 18.0438}, {-65.4938, 18.02}, {-65.5358, 
       18.0169}, {-65.5777, 18.0241}, {-65.5932, 18.0355}, {-65.5917, 
       18.0458}, {-65.4332, 18.0852}}}],
     "\"PuertoRico\""],
    Annotation[#, "PuertoRico", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{51.21666666666667, 24.616666666666667`}, {51.25, 26.15}, {
      50.833333333333336`, 24.75}, {51.21666666666667, 
      24.616666666666667`}}}],
     "\"Qatar\""],
    Annotation[#, "Qatar", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{11.166666666666666`, -3.9499999999999997`}, {
      12.033333333333333`, -5.016666666666667}, {
      13.083333333333334`, -4.633333333333333}, {
      15.9, -3.9166666666666665`}, {18.633333333333333`, 
      3.4833333333333334`}, {16.583333333333332`, 3.4833333333333334`}, {16.2,
       2.216666666666667}, {13.299999999999999`, 2.1666666666666665`}, {
      13.166666666666666`, 1.2333333333333334`}, {14.5, 0.9333333333333333}, {
      14.45, -1.9}, {11.583333333333334`, -2.3333333333333335`}, {
      11.166666666666666`, -3.9499999999999997`}}}],
     "\"RepublicCongo\""],
    Annotation[#, "RepublicCongo", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{55.2646, -21.0922}, {55.2646, -21.0473}, {
      55.2772, -21.018}, {55.3227, -20.9792}, {55.3305, -20.9573}, {
      55.3211, -20.9405}, {55.2662, -20.9081}, {55.2662, -20.8945}, {
      55.2787, -20.8872}, {55.2991, -20.8903}, {55.3556, -20.9133}, {
      55.387, -20.9175}, {55.4216, -20.9123}, {55.4577, -20.8924}, {
      55.4859, -20.8903}, {55.5016, -20.8987}, {55.5361, -20.9123}, {
      55.5502, -20.9112}, {55.6256, -20.883}, {55.657, -20.884}, {
      55.6852, -20.8903}, {55.7088, -20.906}, {55.7276, -20.9301}, {
      55.7245, -20.9887}, {55.7276, -21.0263}, {55.7417, -21.0765}, {
      55.759, -21.1017}, {55.8508, -21.1514}, {55.8681, -21.1744}, {
      55.8696, -21.2068}, {55.8476, -21.2863}, {55.8241, -21.3397}, {
      55.8029, -21.4103}, {55.7825, -21.4312}, {55.7449, -21.448}, {
      55.7009, -21.4511}, {55.6162, -21.4459}, {55.5832, -21.4323}, {
      55.3839, -21.3151}, {55.3125, -21.2738}, {55.2936, -21.2455}, {
      55.2952, -21.1943}, {55.2826, -21.1388}, {55.2646, -21.0922}}}],
     "\"Reunion\""],
    Annotation[#, "Reunion", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{29.666666666666668`, 45.21666666666667}, {
      28.583333333333332`, 43.75}, {22.683333333333334`, 44.21666666666667}, {
      20.266666666666666`, 46.11666666666667}, {22.9, 47.95}, {
      26.666666666666668`, 48.25}, {28.166666666666668`, 45.46666666666667}, {
      29.666666666666668`, 45.21666666666667}}}],
     "\"Romania\""],
    Annotation[#, "Romania", "Tooltip"]& ], 
   TagBox[
    TooltipBox[PolygonBox[{CompressedData["
1:eJxNlm+IVFUYxofND0ERSVkKRq2FlZVE/yV39+78u/fO7J25f/bmrrO73p25
dxQzpSy0PgQFhkQtSUXsWh9Ko1A0alcMLJCMkFChrMQPRsi2LKFFHyqiPjR3
nt/u9sJwOed9z/M+5z3Pec901rf5SUcmk9nX+qXfZmqPRUY+tdsKxorUnouM
gwdSK2h+OjIyqR0vGD9eaNmuUWNivGVrLCNM7dCo4vaXFLdz1Nid2h1l4a3C
/2XJ2JHawwv+335t2Uyk+R1l5f12VHnecYzPjrVssi6ci45x+lTLljeM+1Pb
7iguaYjHm45wzIaxOLXfGX/UMNr7nKkI76oYvIp4LYqVt1QR3j2x1u+piOem
WOuLVeWfio3x9v6rmn+e/GGf/G+Q/0lb+XLkq5fF+3HWL+tTvq5Yea50xOfp
GF4V1Wdlom+lovpaifL9wf5ubsq/tSr8RpPzrAq/0KRursanE/G6y9X6bcQ/
gD9pqh4TjN9PlPdaV/h7E+FtcZX3oUT8dxN/hPFJ/GcSrXvdVd4rmvLv9KQj
D/92T/6AfPd6wnM4n83Ed1LPFZ7iZhviP+Wp7osb8n/iwasu//W+vsvrwvsF
/OEFf5tHra5zvcHnPOf07gv/BfR5Afwo0j4PM/5wWHixr/mRIfGMfNV745C+
t5PvbA39wy+/Xvzv85XniSHlP++L11c16hOgk/Wcf6D51wbFYyn+qQHN3xKg
/0Ht/2vyTw5QtwAeofIe8qljKPzuhXGbz7PUo7N/fr/C7Zc+d3Ee3/QL7zLj
dwOtX+ajq0DxP3uq99uB+H/K+f5EXaYZH/flf4R8L/Od8NARfovz2ES+NfhP
UJdp9HxrwP7Az1D3V9FzF+smXeHY+C+74v0gOrnbn8dp81nFeX9AnhPo904P
vYGbc1UXj/FZR7hLuA975/om+zlpanyU/M8UpYsfXPib4nfT3H0oit+/3Pcb
i5yzq/lLOXTJeiPP/cK/JSseZZc+nhWP2SrvRC98WR/1Ulf4LekVzisufbcH
ndAP/smiF/rF4bziT7nst1vrnvLUN893z/cL6b9L/qzHO9BDXarEP4oe6J9G
N3kd+u5a1etzR/HjxM/20afXCr+jj3Vd9I8y59BDnpLi3usBt8Q7ZCjunM1+
cor7wtL8Xzn0aFL3nOowZmr9xwtj9R3qFZrsi/WLTN6xrHDfKqKHPDgF6e/v
gvZRK0g3K8GZpe6XTHSXB89iv3nhroNntkicJX6rTfRiit8Ri/5r8w7wvYZ3
f8zmneQdjm10URHO1WX6KTreU6Z/zPWDknQQcH9Xl6kPfeyojd76uf+2eH0f
okdL+/8zRDfwXbqOfkp8OACupf0eG1De60ri8d0g/cxG9zXuhcX/iWHqR53O
DKMn+HWM8P8A/bw4Qv249xs3iOdL+C8ynuH/V8j7sxU9bYh4L+gT5yJ0Bf99
xI/RN0b4v7e5SD0j+hr6+N//w/8A/31ODQ==
       "], {{21.28333333333333, 55.333333333333336`}, {22.883333333333333`, 
       54.766666666666666`}, {22.816666666666666`, 54.03333333333333}, {
       19.633333333333333`, 54.46666666666667}, {21.25, 
       54.949999999999996`}, {21.28333333333333, 55.333333333333336`}}, {{
       141.83333333333334`, 53.15}, {142.08333333333334`, 
       45.88333333333333}, {143.61666666666667`, 46.36666666666667}, {143.25, 
       49.38333333333333}, {144.75, 48.63333333333333}, {143.01666666666665`, 
       54.13333333333333}, {141.83333333333334`, 53.15}}, {{
       155.23333333333332`, 50.05}, {156.06666666666666`, 
       50.78333333333333}, {155.23333333333332`, 50.05}}, {{141.15, 
       73.88333333333333}, {143.48333333333332`, 73.31666666666666}, {
       141.16666666666666`, 73.88333333333333}}, {{146.5, 
       75.58333333333333}, {150.95, 75.13333333333333}, {146.5, 
       75.58333333333333}}, {{139.83333333333334`, 74.8}, {143.7, 
       74.93333333333334}, {145.4, 75.51666666666667}, {138.73333333333332`, 
       76.21666666666667}, {136.91666666666666`, 75.26666666666667}, {
       140.06666666666666`, 74.81666666666666}}, {{99.46666666666667, 
       77.95}, {105.36666666666666`, 78.5}, {102.36666666666666`, 
       79.43333333333334}, {99.45, 77.95}}, {{99.46666666666667, 79.25}, {
       97.53333333333333, 80.16666666666667}, {92.85, 79.55}, {99.45, 
       79.25}}, {{51.4, 71.78333333333333}, {53.766666666666666`, 73.3}, {
       56.56666666666666, 73.16666666666667}, {57.63333333333333, 
       70.73333333333333}, {51.4, 71.8}}, {{56.983333333333334`, 
       74.68333333333334}, {54.05, 73.36666666666666}, {68.5, 76.95}, {
       56.96666666666667, 74.68333333333334}}}],
     "\"Russia\""],
    Annotation[#, "Russia", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{29.599999999999998`, -1.3833333333333333`}, {
      29.016666666666666`, -2.75}, {30.566666666666666`, -2.4}, {
      30.483333333333334`, -1.0666666666666667`}, {
      29.599999999999998`, -1.3833333333333333`}}}],
     "\"Rwanda\""],
    Annotation[#, "Rwanda", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-5.9486, -16.0126}, {-5.90615, -15.9726}, {-5.88865, \
-15.9352}, {-5.85365, -15.906}, {-5.80245, -15.8969}, {-5.78245, -15.9068}, \
{-5.7812, -15.9177}, {-5.79995, -15.9926}, {-5.79995, -16.0217}, {-5.8362, \
-16.0426}, {-5.90365, -16.0426}, {-5.94235, -16.0309}, {-5.94735, -16.0226}, \
{-5.9486, -16.0126}}}],
     "\"SaintHelena\""],
    Annotation[#, "SaintHelena", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-62.7283, 17.2415}, {-62.8144, 17.2979}, {-62.8824, 
       17.3231}, {-62.9293, 17.3593}, {-62.9172, 17.3754}, {-62.899, 
       17.3875}, {-62.8688, 17.3875}, {-62.8311, 17.3774}, {-62.7751, 
       17.3301}, {-62.7223, 17.3029}, {-62.6951, 17.2526}, {-62.7011, 
       17.2385}, {-62.7132, 17.2375}, {-62.7283, 17.2415}}, {{-62.6241, 
       17.1569}, {-62.609, 17.164}, {-62.5893, 17.161}, {-62.5757, 
       17.1469}, {-62.5697, 17.1076}, {-62.5803, 17.0986}, {-62.5984, 
       17.0955}, {-62.6211, 17.1006}, {-62.6362, 17.1106}, {-62.6241, 
       17.1569}}}],
     "\"SaintKittsNevis\""],
    Annotation[#, "SaintKittsNevis", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-60.9677, 13.6923}, {-61.1268, 13.7488}, {-61.1531, 
      13.7711}, {-61.1312, 13.8723}, {-61.0174, 13.9958}, {-60.9969, 
      14.0561}, {-60.9575, 14.0805}, {-60.9239, 14.0824}, {-60.8904, 
      14.0668}, {-60.8772, 14.024}, {-60.8714, 13.7955}, {-60.8904, 
      13.7711}, {-60.9385, 13.7225}, {-60.9385, 13.703}, {-60.9502, 
      13.6923}, {-60.9677, 13.6923}}}],
     "\"SaintLucia\""],
    Annotation[#, "SaintLucia", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-56.2107, 46.8928}, {-56.2069, 46.8798}, {-56.2147, 
       46.8684}, {-56.2382, 46.8545}, {-56.2865, 46.845}, {-56.3048, 
       46.8363}, {-56.3335, 46.8206}, {-56.3492, 46.8206}, {-56.3779, 
       46.8284}, {-56.3897, 46.8397}, {-56.3897, 46.8615}, {-56.4079, 
       46.8737}, {-56.4092, 46.8963}, {-56.4027, 46.9076}, {-56.374, 
       46.9102}, {-56.3387, 46.9172}, {-56.3244, 46.9337}, {-56.3257, 
       47.012}, {-56.3335, 47.0503}, {-56.3753, 47.0842}, {-56.4144, 
       47.1425}, {-56.4184, 47.1687}, {-56.4144, 47.1939}, {-56.3909, 
       47.2035}, {-56.34, 47.2008}, {-56.2356, 47.133}, {-56.2356, 
       47.1069}, {-56.2669, 47.079}, {-56.2826, 47.005}, {-56.2734, 
       46.9502}, {-56.2107, 46.8928}}, {{-56.1977, 46.8397}, {-56.199, 
       46.8475}, {-56.1899, 46.8571}, {-56.1781, 46.8632}, {-56.1559, 
       46.8632}, {-56.1206, 46.8449}, {-56.1141, 46.824}, {-56.1285, 
       46.8049}, {-56.1637, 46.7927}, {-56.199, 46.7953}, {-56.2199, 
       46.8066}, {-56.2199, 46.8223}, {-56.1977, 46.8397}}}],
     "\"SaintPierreMiquelon\""],
    Annotation[#, "SaintPierreMiquelon", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-61.2723, 13.3531}, {-61.2576, 13.36}, {-61.2238, 
       13.3623}, {-61.1901, 13.352}, {-61.1719, 13.3375}, {-61.1745, 
       13.3082}, {-61.2178, 13.1923}, {-61.2567, 13.1669}, {-61.3025, 
       13.1669}, {-61.3535, 13.194}, {-61.3605, 13.2102}, {-61.3596, 
       13.2315}, {-61.2991, 13.3007}, {-61.2723, 13.3531}}, {{-61.4897, 
       12.3986}, {-61.4989, 12.4154}, {-61.4989, 12.4321}, {-61.4619, 
       12.4568}, {-61.4275, 12.4929}, {-61.4037, 12.5026}, {-61.3904, 
       12.4965}, {-61.3812, 12.4691}, {-61.3852, 12.4277}, {-61.405, 
       12.4127}, {-61.4367, 12.4074}, {-61.4526, 12.396}, {-61.4751, 
       12.3942}, {-61.4897, 12.3986}}, {{-61.2846, 12.9514}, {-61.3044, 
       12.9461}, {-61.3441, 12.9443}, {-61.3599, 12.954}, {-61.356, 
       12.9822}, {-61.3137, 13.0183}, {-61.2542, 13.021}, {-61.241, 
       13.0166}, {-61.241, 13.006}, {-61.2846, 12.9514}}, {{-61.4434, 
       12.5652}, {-61.4566, 12.5652}, {-61.4658, 12.5688}, {-61.4671, 
       12.5802}, {-61.4472, 12.6093}, {-61.4275, 12.6181}, {-61.4037, 
       12.6155}, {-61.3785, 12.5899}, {-61.3785, 12.5793}, {-61.3878, 
       12.5714}, {-61.4434, 12.5652}}, {{-61.3679, 12.6931}, {-61.3746, 
       12.7468}, {-61.3653, 12.7556}, {-61.3388, 12.7601}, {-61.3243, 
       12.7556}, {-61.3203, 12.7371}, {-61.3468, 12.6886}, {-61.36, 
       12.6807}, {-61.3653, 12.6825}, {-61.3679, 12.6931}}, {{-61.2158, 
       12.8191}, {-61.2291, 12.8561}, {-61.2211, 12.8773}, {-61.2052, 
       12.8808}, {-61.1841, 12.8773}, {-61.1788, 12.865}, {-61.1814, 
       12.8403}, {-61.1933, 12.8235}, {-61.2013, 12.8191}, {-61.2158, 
       12.8191}}}],
     "\"SaintVincentGrenadines\""],
    Annotation[#, "SaintVincentGrenadines", "Tooltip"]& ], 
   TagBox[
    TooltipBox[PolygonBox[{CompressedData["
1:eJxdlAtQjWkYx4+KUcrKmlBtKSTnESJFadzGpRLSTENba5x6Z0wb5VoSoaHt
eujogkpHTqwxpEmx4/JMlnZFOGPRILmNySW6KLtt+L+dODO+mW+++c37ve9z
+/9fJ1XMUmGiUCj88cpv/xP2oZEHBTtnbVxrZ0U8ut+OnDlg3aKZP640Jd4y
5OT8JwcENy0Y/9mpW8nFthMejQK3R4dsPdmh5Mq27jvx+wWvvvKpfEurklWD
lk2ryBec4f/KzKNFyT+FRvo8zjNy0bujVwPAUYFtWcHtSl79suv3llzB5mmO
Ec3/KQ3xwOndovN5H+KKvzZdPAQecKZ0c405cXPijCm/gJuqTpm+tCTeCvwj
R7DP48WZeQOJZfrp+wQ72CACOExd/cF1j5E/3Ylvcsk08pugsw670gXLNPSo
//IH1zB1mrEf6dFYSRXc94raPQ68au/bxBng58lFN47/QGxpQik24GS+pp1r
Q1y2Dn/8JhhZ+Vk6Eze5uPc/AW5z1MesGEP8D8K7gz2sPadfmEQ8TRaYIrhW
O7eyzZd4vQwATuryjq1bQFxeiIaBZ7VEXA8PIF4kG4z9mmFmIQMDiZH96yBw
o9ue4o9BxFHnN2iGgQsmH67wWkY8tL6uMxj7a8Z6Z9euIEOfdmNeGF+litji
XkmsLxinnHUQxGOQrj1Yr2gwMY8iHo4wbuCSkef+T9lA7C8LBsvdSZuJJ8sH
5ye2li35NYH4SKyvxT2wS3DfkmxwTYBX6izk8/PpS2+KEomPt+gDVeChVbcV
DTuJ5fj8wPfft/sv302cOwcdx345tjA1MbpbXweWn06NkXv0WGisNzo+QTeu
hDgzb83gZHCPTkuJD6Ot3WDtXY93U3XEMYMxKcwLYu7YWEzsKAvHvDsQrTqn
V//Qg0x3egZxK9IdlCF44sJSi3m7yNB36McOx/fb0asPsP3rp56228kw9yzB
mO7SXKzfdn7w7zbwGa+P1ZFpxNJuPmrBIyKaQ2cXEaO75YXgxgJr3QUtsUI+
0Ouxq2ictldve6HPDNe3Vvi/R2fZguEma88CMvhJIwy+OEA8EuGioP/I8Ifz
TPOJnyTAUPBHqr6hcYDG6Jc4NyfHdtQn22cGP8lxeSNfKY81ucb5f/Vf3MVD
thPCiV/cQkFguT06hPhmZ/AzHfy8abF0FLEMfx7+t7OCImfSt/uix19uxKUH
/xxRBu6qbf77Mvwh5WeB+6ZKlVTvO5z4+/voC7pbSrY=
       "], {{-172.031, -13.8866}, {-171.998, -13.8813}, {-171.957, -13.877}, \
{-171.914, -13.8691}, {-171.883, -13.8616}, {-171.842, -13.8616}, {-171.807, \
-13.8669}, {-171.785, -13.8669}, {-171.765, -13.8638}, {-171.74, -13.8531}, \
{-171.725, -13.8394}, {-171.685, -13.8269}, {-171.649, -13.8301}, {-171.637, \
-13.8396}, {-171.624, -13.8587}, {-171.62, -13.889}, {-171.597, -13.906}, \
{-171.576, -13.9304}, {-171.57, -13.9479}, {-171.55, -13.9659}, {-171.518, \
-13.9871}, {-171.492, -13.9945}, {-171.466, -14.0057}, {-171.455, -14.0206}, \
{-171.457, -14.0444}, {-171.478, -14.0598}, {-171.507, -14.0704}, {-171.543, \
-14.0751}, {-171.583, -14.0788}, {-171.611, -14.0809}, {-171.63, -14.0788}, \
{-171.634, -14.0719}, {-171.638, -14.0528}, {-171.655, -14.0433}, {-171.675, \
-14.0374}, {-171.709, -14.0374}, {-171.738, -14.0433}, {-171.772, -14.0539}, \
{-171.797, -14.0655}, {-171.81, -14.0751}, {-171.823, -14.0809}, {-171.833, \
-14.0782}, {-171.85, -14.0607}, {-171.856, -14.0374}, {-171.878, -14.0066}, \
{-171.892, -13.9944}, {-171.914, -13.9875}, {-171.952, -13.9864}, {-171.993, \
-13.9875}, {-172.029, -13.9811}, {-172.056, -13.971}, {-172.074, -13.9545}, \
{-172.08, -13.9349}, {-172.079, -13.91}, {-172.062, -13.8962}, {-172.031, \
-13.8866}}}],
     "\"Samoa\""],
    Annotation[#, "Samoa", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{12.2459, 43.9489}, {12.2367, 43.9859}, {12.2759, 
      44.0274}, {12.3406, 44.0629}, {12.4283, 44.0705}, {12.4653, 44.0521}, {
      12.4907, 43.989}, {12.4976, 43.9459}, {12.4699, 43.9089}, {12.4006, 
      43.8828}, {12.336, 43.8828}, {12.2852, 43.9058}, {12.2459, 43.9489}}}],
     "\"SanMarino\""],
    Annotation[#, "SanMarino", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{6.51275, 0.075233}, {6.48505, 0.075233}, {6.47205, 
       0.087167}, {6.47205, 0.109967}, {6.4655, 0.1393}, {6.3873, 0.2164}, {
       6.3808, 0.241367}, {6.39385, 0.275033}, {6.4362, 0.313033}, {6.5095, 
       0.389067}, {6.55835, 0.419467}, {6.63655, 0.435767}, {6.6887, 
       0.436833}, {6.7506, 0.412967}, {6.7848, 0.359733}, {6.78645, 0.2859}, {
       6.7555, 0.2088}, {6.7164, 0.1697}, {6.705, 0.143633}, {6.661, 
       0.106733}, {6.604, 0.079567}, {6.51275, 0.075233}}, {{7.33525, 1.53}, {
       7.26515, 1.55293}, {7.2422, 1.57163}, {7.24605, 1.58267}, {7.27025, 
       1.59457}, {7.2983, 1.60983}, {7.3072, 1.62343}, {7.3072, 1.6608}, {
       7.3225, 1.68203}, {7.3505, 1.69223}, {7.41675, 1.70413}, {7.4461, 
       1.69987}, {7.44865, 1.68373}, {7.44225, 1.6744}, {7.3913, 1.63107}, {
       7.38875, 1.6107}, {7.41675, 1.58777}, {7.41675, 1.57247}, {7.4015, 
       1.55803}, {7.3607, 1.5283}, {7.3556, 1.52747}, {7.33525, 1.53}}, {{
       7.3075, 1.3492}, {7.31605, 1.3381}, {7.31975, 1.3296}, {7.3177, 
       1.31753}, {7.311, 1.30703}, {7.2996, 1.301}, {7.29025, 1.301}, {
       7.28155, 1.3057}, {7.2718, 1.3144}, {7.26815, 1.32357}, {7.2678, 
       1.3334}, {7.27215, 1.34347}, {7.28085, 1.34927}, {7.29425, 1.3506}, {
       7.3075, 1.3492}}, {{7.31575, 1.387}, {7.3174, 1.3799}, {7.31535, 
       1.37543}, {7.30835, 1.37163}, {7.29695, 1.36893}, {7.2842, 1.37073}, {
       7.27315, 1.3732}, {7.2648, 1.37853}, {7.26075, 1.38527}, {7.26075, 
       1.39173}, {7.2661, 1.3971}, {7.2782, 1.39977}, {7.29225, 1.39957}, {
       7.30265, 1.39553}, {7.31575, 1.387}}}],
     "\"SaoTomePrincipe\""],
    Annotation[#, "SaoTomePrincipe", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{34.96666666666667, 29.366666666666667`}, {
      34.56666666666666, 28.083333333333332`}, {39.18333333333333, 21.1}, {
      42.78333333333333, 16.383333333333333`}, {44.5, 17.4}, {
      45.583333333333336`, 15.1}, {51.983333333333334`, 19.}, {
      56.666666666666664`, 22.}, {55.833333333333336`, 23.166666666666668`}, {
      54.833333333333336`, 22.666666666666668`}, {51.166666666666664`, 
      23.833333333333332`}, {51.21666666666667, 24.616666666666667`}, {
      50.833333333333336`, 24.75}, {48.416666666666664`, 28.55}, {46.55, 
      29.099999999999998`}, {44.71666666666667, 29.2}, {39.3, 
      32.233333333333334`}, {37., 31.5}, {37.5, 30.}, {34.96666666666667, 
      29.366666666666667`}}}],
     "\"SaudiArabia\""],
    Annotation[#, "SaudiArabia", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-16.53333333333333, 
      16.066666666666666`}, {-17.53333333333333, 
      14.75}, {-16.566666666666666`, 
      13.583333333333334`}, {-13.799999999999999`, 
      13.383333333333333`}, {-16.75, 
      13.066666666666666`}, {-15.383333333333333`, 
      12.833333333333334`}, {-16.716666666666665`, 
      12.316666666666666`}, {-13.716666666666667`, 
      12.683333333333334`}, {-11.35, 12.466666666666667`}, {-12.25, 
      14.766666666666666`}, {-12.05, 
      14.716666666666667`}, {-13.383333333333333`, 
      16.03333333333333}, {-16.53333333333333, 16.05}}}],
     "\"Senegal\""],
    Annotation[#, "Senegal", "Tooltip"]& ], 
   TagBox[
    TooltipBox[PolygonBox[CompressedData["
1:eJxlVnlcjmkXjqghpskekzRII4nnft/Hrit57pdso8guJtlJpkiyNkKT7DQx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      "]],
     "\"Serbia\""],
    Annotation[#, "Serbia", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{55.3473, -4.7493}, {55.2847, -4.75033}, {
      55.2737, -4.7472}, {55.2612, -4.72737}, {55.2471, -4.71067}, {
      55.2, -4.6919}, {55.1844, -4.66683}, {55.1876, -4.6376}, {
      55.2126, -4.60837}, {55.2518, -4.5927}, {55.2878, -4.59063}, {
      55.3097, -4.6}, {55.3207, -4.59793}, {55.3301, -4.5875}, {
      55.3301, -4.56973}, {55.3395, -4.56767}, {55.3614, -4.5708}, {
      55.3864, -4.58853}, {55.3864, -4.60733}, {55.3724, -4.63657}, {
      55.3724, -4.6564}, {55.4005, -4.68563}, {55.4773, -4.7441}, {
      55.4898, -4.79317}, {55.4976, -4.8349}, {55.4976, -4.84533}, {
      55.482, -4.8537}, {55.4507, -4.85473}, {55.4256, -4.84847}, {
      55.377, -4.813}, {55.3661, -4.78583}, {55.3661, -4.7587}, {
      55.3583, -4.7514}, {55.3473, -4.7493}}}],
     "\"Seychelles\""],
    Annotation[#, "Seychelles", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-13.299999999999999`, 
      9.033333333333333}, {-11.483333333333333`, 6.933333333333334}, {-10.25, 
      8.483333333333333}, {-11.216666666666667`, 10.}, {-13.299999999999999`, 
      9.033333333333333}}}],
     "\"SierraLeone\""],
    Annotation[#, "SierraLeone", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{103.745, 1.4793}, {103.86, 1.44033}, {103.889, 1.42327}, {
      103.881, 1.41233}, {103.827, 1.40413}, {103.791, 1.37953}, {103.752, 
      1.3645}, {103.682, 1.36587}, {103.618, 1.39593}, {103.627, 1.43283}, {
      103.68, 1.4711}, {103.745, 1.4793}}}],
     "\"Singapore\""],
    Annotation[#, "Singapore", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{22.55, 49.083333333333336`}, {19.116666666666667`, 
      49.88333333333333}, {17.766666666666666`, 49.416666666666664`}, {
      16.516666666666666`, 48.166666666666664`}, {17.166666666666668`, 
      48.016666666666666`}, {22.15, 48.416666666666664`}, {22.55, 
      49.083333333333336`}}}],
     "\"Slovakia\""],
    Annotation[#, "Slovakia", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{13.983333333333333`, 45.5}, {13.716666666666667`, 45.6}, {
      13.716666666666667`, 46.53333333333333}, {16.116666666666667`, 
      46.86666666666667}, {16.53333333333333, 46.6}, {15.716666666666667`, 
      45.8}, {13.983333333333333`, 45.5}}}],
     "\"Slovenia\""],
    Annotation[#, "Slovenia", "Tooltip"]& ], 
   TagBox[
    TooltipBox[PolygonBox[{CompressedData["
1:eJxdlgs0Vukax0WlgwyOM02Gvd/vNEQyJ7eEjLdB6UKGoQbdvDVURGIGRZmW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       "], CompressedData["
1:eJxdlA9UjXcYx29/GBWlUlxq9T6Z2JmOLavYrV+nf8qpoRVjp+j9EUqs01L+
njSLo9bkT1JUdKlRUaJV09MQapuOZcIq7daomD/hlsKe9947zvGec889n/f9
ve/v9zzP9/u1j1gzf5m+TCYLo5/0/9zxq/RfnonM1CfJfVemgLPaP0/LfC4y
y2EvvA/tEXB2x3rLErXInFodhiftFXARpxUDIjP5srXHLUvA/THmyfhCZKuL
ncxvHRYwKMJsoduQyBojE23/Khbw0bH6OS4vRbYhaslxw2oB51fabusl/jtD
FdTdJKDRjSNrFa9EtviPGpVlq4BdTcLtAeJ9I2ubr/YKWLBWYXTjtcjWtJxx
LH8s4GGfM30vZZx1GO8u2kqctNdrZ7QBf/Ncw+9xJl9ZVGNDrFJmX7AbwVl0
ma/Cu09Alx2eS7qIkwwvpk9XC0inb8gfyZnvnufDw/sFDDDR/zDFiDOfUUeX
9hNfiT+XKzfmrGxazBG9IQE/kS7iVDPb1RP1AK1v/q4OJnaN9F65xgzQ7fTl
+HPELS2TfjxrBSiVO8+Es4MrFth3WQN2fzB9xAnirOp9P5jKAX2pnGbiV14v
HvTaAUqYMIqzE8Ut4fFOgOef0YBGc7bf2be3cCbg3LTMGHNTztzLHVigAvCq
OlilJK44mnhpCj2/NIcqNONsalyYmOkKuHucYejoMZyt//S4+4JZgJNp+4nm
nGnWMd33iaXjP/IBbb0WnFlkp0d5hQBqxk4c97AjQxUGeD2BKrDkjINZaW8k
4IpdDzZ6jOUspQMiAuIAqXtWN604m9vpf21GMmDZwYfH6q05a/ZyrkreDphz
we5k7DjOSid1Jh9KA/xCGhBx1NbCQdke0M6HWP5d+vYp+aDVz3jOrHP1l3xW
DqjRIXH8nZwxyp8B8+R0R85Z64bKzsrzgO9TuyuJm0zhW79GwKfUzm7ialO2
yuIGaPVN3DX5urtNO+CBLLroe/J5tyZs7AD8d6PHjDA6f3DJo2nWxBp9UH2t
vwXbxKoAbw9sXlVD9RtLBugGrGvI9zlD/WmXt0yte/K2f227U7Yt6gOtnqi/
njUl4Sd7ARtpeR/NQ/1rhmxGF+A6Wu5EHDp7wL+iXacXml9G45bZta2Ak6j9
XjTfBYtP1d5vA9xEx6sifSjVaaUKOo+NZEjS25abisSF93T1Gr3dT+MvYs17
dF6N/0jvIXWFBUF3AHdG3x0sIl45c9b4iddB6y/yh59BgrHDZUApHRyJow6s
yzlM/V1Nyx8PJ7/5uX6UUAc4QRrIMM5cvo6t9SKWSZchZ/+U0IDPAS6UDKHP
2X10g4BqQKkdVnqkz/lLo+0rAaU4SSN/j00N6DE8DSiNv4n8H7zP/vtvTgEq
pAIoL/Sbm8sqSnT6oXzZHNfTEFmk0+egyKZdDFnWrgSs8qcdiI9kzNQLLNDp
kfJJL2Wucnmurv+UX3kfv9pUvxdQslNyv8hWCNEJ67fBm/xTDQU6eq/Vrad8
tLxnkZjBAQtJjjuIl6s7l+aHAkrx6Ef8v3+mSA17KrJVBcon8c46PxJf6fIo
aLfV+aFPZA6Om1N/MgZtvhKL0gApbzTzJA7wPJvp/KeAT64FRpjR+0NtRz0G
6wTsJ7tnE580uJvqSPmq8Tft/zqhdFFWnoDv5vl/uyC8gQ==
       "], CompressedData["
1:eJxNlQtUTWkUx1vFpFaTSvRQ1/m+q/LIo2Uq1OiYPBuhmIymMS1zQkgUsRgl
STP0IhMSjSaPZkwRQ0NTu7xLMYSJMV4pKUoeITL/c8/VnbPWXXf91vnO9/33
3v+9PzY73D9EX09PLxo/+V/yuD0lqYckBhxbOXllOKPzUcVZtuAexuaLu4Uw
Oj7RRH8g2GnOn9blMxl9WL8kosTbbyojy7zxd1daSqJvcU3dmTGMsDqhV09J
tGu852YrMlqWZt0loJckjtxcETPBi9Hzd9UrGsCPLkbnfO/JaFfzvjOfW0ni
uhcxps9cdeyll+ub6czowSV+8zXWt6kGj3jSl9HBiHmbHuM8b1mwMSOcVlMF
PUcHlS9MfS0Q1G1dZCGJvaXNmw7fEci/UBXfaC6Jz3vm2Gy8JlCwvCG4cplt
aO4FgebID9bvvZpaeLZMoGHyg/0OTV2QsbxIIPlzP5z316agDu/jAp0WoADx
3V9w0dmIBNq2yCKOoC+/ykVYVSlQwU4EAP2tq3Z0NF0XyKXbAbtAa0l82l/v
zLC/Bco8hQ3AJaaZw7KrBVLffB09H6zJ81ndev2QaXktxQJNcv9hdLCNJDY8
xYbQ8yZ6ftHS3pKYma3+4+1Z7fd2kljnlXO7uEqgBkd5B0mcPNvsyxHYX/47
Ao7fkjW9vVagDqTf0V6rr02gLgGmgwrAkdctWkd3ZySXd6tKEnMWf2p8Xc0U
PYIkDn9VJv2CeiIbhSomic7VGXX24xkxuSDgB8bNEeZTGB19hgKDmw1Sb5yC
XzT68H1e7G8WzrO0/uojiS6HXhe6SYz27kBCcN7bcAcPtwhGJ1/0C0oBj7h2
OuyTNVr/gNcEJ6tKEhih+t95QW9deoD3vWTWGd/caFfDbumMssdCATj5gjpm
6E9MqTfWjwkNb4nPZeTlOuv4ROixkQMuZdQ/KKXsBdhsc9dJd84wuuKLHaEf
btti+j9W7Xs4YXAJo0C5AcAa3x/RxZtS29rncj6jmqq2affB+tXVBb/nMYK6
c1FcEt/XD/1m1kFGYfXtuU/B48//GmlSyAjZlTzUkphopgqzg55V8sZ4HwV7
FlVq/Q+2ytIP9rzCqGI3AnSA3vxGq6aXjLB7cZYj8ufvFT5Anyvx9ZPE0sjm
u5t7cMUP4Ielt2aesNe91/iwH1f8CHafnvjM3YUr8fWXxIsIY48HJ1nuZfCV
ovuW9hM5ZWzHA7ZPsdmfOIUr+cP3ZX6tj+ymcUr33riw3knHDh/F/ugNXrN6
6aPyGVzpf+gNde375JDESS7fObCqI+OAXwxX6g/+Ny0hPjCNkyzXxFEbbzqn
5bDPEAfdexlv9ZVEw6M+B4cncopBe6SBjbOfGKRu4Ir/wJq4krgyr8AF8YKh
QyZX/AM2MNrQ59s8TuPkgoKrbPxu9C7iFI72Lsd5b61hmMs6vdZN68M23uNK
/RDfe6PBAdUtnDR5Awsmnm2qDl2+NfkzUnfyjKYhJ5y6q2kCpmce1ifuzpw3
w1xNTWiveHB7UNjpDgt1536zzNEhA3XvQxZvKRrprlb8BD2ekzGhRqnJSW5Y
cMWrNhsrMKrRngv9cVaru4a6qZX+QHxz5YZw0HGsY9n6fVZqpd/B8vgZbKjV
B38e7iv6DmrknX7V5O0cJ7k8+uBCce29s4VcmR/w68mPX70dWsCVfkU/eMkG
P8A758kLs6Qnwl5On8kNinkwqCk0oQT1/dDv5e9Mx8Ymc5LTvxv9W+8f9MXL
JN7Z7zP94kKt8V4zn8GOtXG7KlFvud2KMR8xfc6/i+bkI19ItpKIKbezea52
P8xTQ7nAX3FagjH3M+bttkk9E318dKz/9Hh06SgdNxzLN6h35nQV7nUBV/ik
+V9CP0XKAWLeF8wb6WFjovUv7gPNdy3afsV9YZm+QqypZSTbsQj3ydr97Xo5
mC+afumhnWeYF1byAAGPefO4kbbr7uOv/xlnsGIjU+oPztnTGrUujlFpOQ4A
7xwXOCB8ue5+/nCf/wfFQ4ki
       "], CompressedData["
1:eJxdlA00lmcYx522NjU0ZuR5nnsr3pnWOrL5qKzjTr1I5IQj1MHcVJNUkhqx
TDgqXxPyke+PlN6E1CS7miQ5LNYmqTkmcxzRkZkaatfjfZadvee85z2/936e
674+/td/qe9eZ/95Kioq3vgVf3W72yddUhnlig66mhVwYNcXpq34D2tFw52C
NEb1BvdaLy3kQER5OqP24dHGDqUc5D4tu7Upg9Eb+HdtNQfNmyzi151m9Fmb
uUVpMwc2teMz95BNVCsEz8ccxAxvufpBJqOyjFfJkVMcLK0M3pWC7KIf72Wj
ycPB1MVvumUxarfn98eRH/PgprGi6kw2owkZQVrRlAeM7jOQw2is58/1/a48
tOK142cYVUzIrbcF8ZD044TR9jxGH6174lCQyoP4+lPksS6/hLCzPIjhNQoY
zbyWnryojgefgbv6Pch6B7q0nt3gwX11ze3QQkZn627iQTx+gXyzXXvNxQ4e
nmD6MUWMzm9KMjk0wgPx9LPsRa5c0uZuOsPDubFOR99iRr+ZWrOvXVWAtQu7
ivaVMHpBd/3qDg1BGb+UUcPewAOME+A0lgXIk83hv9yRCRCurbDtQ87njB/J
bARlf8sY3TQwolrmLyj7gVxfHdoTEyvA10OGJqpnGQ3fsfFoVp0As31G9r78
WV/GAwEa8jAQcufUra7cF1I+5Yz27NHNGtYmoIftWHGOUVgQo7pKRuDvyID6
kPOMTrWOtjRaE3DtL8m+WcGoUXZwzCEPopzXBUY/Mtj5pdM2ApgtCobRCXuP
2FVuBOYtj9PpRm6slWeqOxNQET+VjI4nuoTItkrxKqV6/QiI7XO6xGhEdVvC
0FdSfOTn5jPdSSFz592e3rKaGKLUE75vIArwJAEx3BLkP1KsFh9OJBCVtv5E
4EVG+VyvZa3JBP6cuXd4CPNpG6o6fT+HQK8TKgkZp6GwPkeUekZ+R2YUefJ7
AoNT5WOdWN/aq5a7r1wnIKYzgvVbTpt5FDUQmNU59kfu597E4/OjR6zMvLB/
7kL7dICCgJlX3UY15IzkRWHm5wlsOBGIIRl1LBjnrhVL/cLzrEzxM/f8v/XM
3o/Pj67dHvwwnoCDKHjkkSg3n9vHCbwlFojz3Dx6yGjhKQI/Tbr0l6Aeds2P
rQhKI5AyggmVzp0/x+PsYmm/UgjgdNonUa9ie96NI6/122V8X70nVKoPuVpt
f8UJnK8oJz9k8zbLzR1bCHwoLjDuw2q5bfALJ6k+3B9TTfMvruO8I7AddcjR
pqwjBPUgqsMWGVXfkOdJlPubz2jtsSN3qz0kPeTPxc/BaQbnS/5hS17v77Go
wd8a5QRm/Qr5hwiyaucGAi0YlkMO1vmrptGKQCOuf1Iuo7rLA1aqGxAoRHuY
Qb/It3i/fOWvgnJe6C8tA1bFvZGCMj/0Hw/dKx0qXgLgbWW30M+qji54WGcp
KPuBfphxYJnikx7Jb1IYPVvuvzviEg/iOjckMRp3fP9LwxDJLxIZDYLBOE1f
HqZxnI7ImnpuYzY2vLI/CYzmJTaruRrO8ad2n+s4vs2DM9rLcIK0D0Mc2Kvh
RuH7b0ToO33XzoE4Dku8770dD16mXeYgHeU+iPztqwt+zejHs/1Mxv3d6pZ1
Cv36//7+D8a83D4=
       "], CompressedData["
1:eJxdlQ1Uzlccx70z7xRq1RT3emsppqSk24tKlhRzaIR2bTEv5SVNshpbUpMY
EtGmJKdZJ5tso/2Ol8YmJTmhtcgs6cRECLHv/T9/nnM853Q6n+d/n3vv7/v7
/r5/m7BlwQvatWnTZin+1P9tZh1m9BwuxWD/mPX25xlVtaxbdHyYFBY9rttt
IUaRbl0r94NPyUPzphcYeVJG3JCTBxiF9Z457kdw8ZIxcYWZjL6bePRBK7jC
doF5bRojtTwC+wdds1g7fysjnGZXAHZtG7ChRwqj1Ma17o4jpJib9n6/5E2M
Bn7ZEHQMPMJl65+fb2SUFYEdbKVYH4QTv2L0oiK6foidFOldLPaGJjKqCfx6
59KRUjiVuE65mMpoRTh2tJfCy7Kh1imdUaf47V5JDlKcuGlqdS6bUfoufEZJ
kd++LnnY94ze0z5S+C5v6VVfyKj08bSb2eBzt9yzaooYDVaCjJFi0OZVkRYl
jHxQXgXYvHbmgMKLjM5Y5y8Pd5QCi3vuucToee798gAnKQKFyfxT4NBfJnVv
N1aKDXtLDpVeZuR3Y43pYfDEK/899L/KSF3XfZwUuVlThMkNRoke826VuUix
AHIH1zFqKg8I6z1eiqhIdKSRkQ2OS3WT4vhKdO6RrtcEPL++p092q76/uxTh
gxZHr+nI6QnK2S2k0L7vzKnvevrjWw8pjv0AAbpwg/6eUtgVZNzL6cTJv3s7
2wTwjNjDR8NeMtp7L6d4spcUieV/X+/2gJFtQv+rF8A7CrpH5jUwmqIM4K33
o17XBxxXKL6ordP7PVGKeVGB7/S/w8g7aXHdM3DqumcuEXcZwT1no3ykyLnt
N/JlW04Hdp+2zgfLOX/5tDfj9LAVDQc7f+K9cJkDN+gDVrLa+hqfa32azQlu
c+vqK0WPyLykqnBOqqxi8NTnZisql3OqHzKqS56fFFodqzmNVRuCj6CcpBhO
pod9b6wBv/B62tgQx0ldrwi/37/VBY7lhn6CK9L/tcrZqOvl88rPnE41D5ud
AjZp8ij9eDunc1FF+97Ges1XuzmpYx+DP7x0/KZpBic8ta/GeZ/NPOhYguda
fydJ0VU1MJ0Tqh1UBTYYjJN9NesUD/59Mm6eaaxH628OJ+178PDZKSebD3JS
9l/sa2RHVYDS79O3WjKxXptP9ANqR3fL4lRyHh/0z/nJSXkI+/dUxkC/8yxD
pOs+XX/44/ycyWc7Z+j3gZ9ilHC4r6e6MPwX5/dbrFUaN/TbTZ+Hbbof4edc
kzLvK1u4Yd5cjazNM/xvpRoOPVepgAIrO2cn6/thXpS8lxM4KbtFg+9/hBuh
H1r+OENPJQzWQx3LEPBTxNpKnG+FMmowf/2S/e90+Eb3D+Y1Ym7nC+ap+v6Y
51h3KJWo6wNuTXhYVRnPDfMKLnLYNcJsFTfk0av1C42s5UcoJ9XORuTFieAd
Nps/4K/zBOma+SSIk3ZPcPVPG9aWTeOG+UL+dBzTx2n8HP46n7Q5D9X9B74b
4jnh9ixOS+qe5d4fLYUqKzBA9yNY2cHXQ68HeafpOlqvB2zIbW7Ie+SjhWqk
ja4P8jOk+edrm6w4DYBdp4Fjy47MajbnpM0d2OHXob269dPvB360s3pbAvJm
Ko7pC+54JmXUauSVdj/kszZHNYzUsWfB8R2woNKY30iHRQHIS01H5PvLgpim
/DJmmMd3pYBrTluD05YiwfB+mB48NDMRfLAYhsf7JOWfpoHlpYzefJ/9D4Su
Hhs=
       "], CompressedData["
1:eJxNlAtQVGUUx3mFGxASo0QC+l3j1SgarzDAuIgYuBAsU4qAIFzAIAfIgiBh
iQAXVAJahRGLJJ4rII94y+OAC5RNIoqjYJCEPAQZEUcaedW5u7fZ7szOzm++
e8/5n/8556NCon3CVJSUlPzxx/7fjX9salnL0ItaW5bNeATGv9p09YM6hraW
1u2KUiUweWv7g5f1DK3zuLlGdQOB5Mj2L8QNDB3rGH7ZSptAtG4q3GhkaN2O
cyGtmwn4vtfwS1wTQy/lj4pFJgQG8XMhcrFy+yu6NgQq+vh2mfh+pWlG20Zv
Ageanq8NYbwISbvReKgivljyjcA9icDbAdk9L5CT8qa7RzMJJDnZBrbh95+d
7HIR5BDAbJ0/Yny7h8+v83IJ6LACkE0c3lV5doaAmSWvyhBZmpigvJSi4BS1
3mzLLwkc1FLZIWL1mmOiWAKFT8v7+M0MfeSN5kElIaenhaH5s2o2r+cR8GnZ
mj7XytCoyjyghsB1/MtuY+jeqYkR724Cbe4Y8BpD3xl7qCn+lUAC2strZ+jg
b7d2NQ8TkPmNbJgYbPXxAoE8l7MnpvF9dGeTkzoFbLnmeD73eePmFU0KPpoo
vSRFbu2/LdqlT4HB7lFj9Q6GXmuXuKVTFKinXHA5i+f3bJ7ucTWjoP4HLADj
HV13WZ7fQYEb21Dk1YmOyDArCrB6v1DkYZ50btmWkvuF+kVdpp8OWVNyf5B7
BIuzhsiXt2BCZBPa08LfgYJVybPbnsgFPIPCQHcKsBvuWshV1feD4rwoKLiI
D/oTFeXh5etDgV+ow59eyE8EaByfghA2Ifr53Xarqr/2cvUi/6bT39ZiQUH3
jSLXJvT/xMDOV73fouBeccxeDeS8J/d5UgMK2HErwv7fEpZkaCH/Nx/HhbYb
eHoUxIr11Q7hvE6voNB5rl84z5ZBgV8nPSJy/XheV260XvAHgX3HcMJ/Zujz
Y3adS8js6wKMN6JaDTmTBOwynY9NIiev2MfcnCFy/zH/wVOpuz2mCLDptJFN
V32cokcIsOPpzs6vvbJn2u9E7j/Gz4unh89fI+CdlR+li9xXrqQ/UEtgG6Zr
QT0PzqyF/V1CIHc+0ckWOYYd4CJuX1B/SeliXFoxty+4r0KjPcf3Swiw69ZZ
w9BmPafLD1/h4l1l6IHwu9ORlQRkPlQrzj3YgpDjNY3NhVUE7nhiR5Aj7B3e
NGwkUHvyk9z5KobOCd9ZcLOTQD+md0Z+x6NM40AvAbadWZUM/ZPmrP+UlKsH
OaHG7+IC1ofbpDd8haH9970/M4zxZf1AvjRlVD5TQeT9kzD0fhz7FQnnn0Sh
VzbvFQyN7pZplHF+47ljaeqL5EIC60O4QMg1Jo9SC7O4+wB53DXIuSBFkc84
/58c4SkC1uyD+mR9Rta2wA1BdvxwMDdAyOXD+jY2qLgcEnHx0Y8WX0FqRAYB
ijWkWnEu04+8oOfmvRpPANVb1CNrah0ZnY0g8n1A/8+lNX3PDybA2pWPbHLU
+mU4n7tPkcfEonQ/awUfZgdoGwGsNuUC9pO1k/8ad1/8737+F1mgsPs=
       "], {{161.239, -9.3479}, {161.24, -9.3372}, {161.259, -9.3317}, {
       161.281, -9.33867}, {161.325, -9.37837}, {161.354, -9.41267}, {
       161.37, -9.4231}, {161.398, -9.4408}, {161.415, -9.4735}, {
       161.43, -9.52607}, {161.446, -9.57003}, {161.447, -9.5936}, {
       161.465, -9.61023}, {161.495, -9.6212}, {161.499, -9.6346}, {
       161.498, -9.6598}, {161.48, -9.67}, {161.465, -9.68823}, {
       161.474, -9.7338}, {161.476, -9.77857}, {161.472, -9.82307}, {
       161.457, -9.83377}, {161.434, -9.83323}, {161.412, -9.8091}, {
       161.406, -9.79357}, {161.395, -9.76353}, {161.38, -9.7346}, {
       161.361, -9.71797}, {161.346, -9.71903}, {161.333, -9.7319}, {
       161.319, -9.7603}, {161.315, -9.78497}, {161.297, -9.78497}, {
       161.269, -9.7694}, {161.238, -9.72867}, {161.232, -9.704}, {
       161.233, -9.679}, {161.248, -9.6538}, {161.265, -9.62433}, {
       161.287, -9.58357}, {161.305, -9.5471}, {161.321, -9.5093}, {
       161.325, -9.48303}, {161.31, -9.47553}, {161.286, -9.46907}, {
       161.274, -9.45567}, {161.26, -9.41117}, {161.258, -9.3774}, {
       161.241, -9.35863}, {161.239, -9.3479}}}],
     "\"SolomonIslands\""],
    Annotation[#, "SolomonIslands", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{41.55, -1.6666666666666667`}, {47.95, 4.466666666666667}, {
      51.416666666666664`, 10.45}, {50.78333333333333, 12.}, {
      44.916666666666664`, 10.416666666666666`}, {43.28333333333333, 
      11.516666666666666`}, {43.25, 11.483333333333333`}, {42.95, 11.}, {
      44.016666666666666`, 9.}, {47.983333333333334`, 8.}, {44.95, 4.9}, {
      41.9, 3.9833333333333334`}, {40.983333333333334`, 
      2.8333333333333335`}, {41.55, -1.6666666666666667`}}}],
     "\"Somalia\""],
    Annotation[#, "Somalia", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{16.483333333333334`, -28.583333333333332`}, {
      18.316666666666666`, -34.166666666666664`}, {20., -34.81666666666666}, {
      27.9, -33.03333333333333}, {32.9, -26.849999999999998`}, {
      32.13333333333333, -26.833333333333332`}, {
      30.816666666666666`, -26.8}, {
      31.966666666666665`, -25.966666666666665`}, {
      31.3, -22.416666666666668`}, {
      29.366666666666667`, -22.183333333333334`}, {
      25.516666666666666`, -25.666666666666668`}, {22.8, -25.65}, {
      20.65, -26.833333333333332`}, {20., -24.766666666666666`}, {
      20., -28.433333333333334`}, {
      16.483333333333334`, -28.583333333333332`}}}],
     "\"SouthAfrica\""],
    Annotation[#, "SouthAfrica", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{126.7, 37.833333333333336`}, {126.51666666666667`, 
      34.28333333333333}, {129.43333333333334`, 35.483333333333334`}, {
      128.36666666666667`, 38.61666666666667}, {126.7, 
      37.833333333333336`}}}],
     "\"SouthKorea\""],
    Annotation[#, "SouthKorea", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{3.216666666666667, 42.43333333333333}, {0., 
      39.95}, {-0.11666666666666667`, 38.93333333333333}, {0., 
      38.61666666666667}, {-2.1333333333333333`, 
      36.733333333333334`}, {-5.366666666666666, 36.15}, {-7.416666666666667, 
      37.18333333333333}, {-6.183333333333334, 41.583333333333336`}, {-8.75, 
      41.96666666666667}, {-9.283333333333333, 
      43.06666666666666}, {-7.8999999999999995`, 
      43.78333333333333}, {-1.7666666666666666`, 43.4}, {1.4833333333333334`, 
      42.6}, {1.75, 42.5}, {3.216666666666667, 42.43333333333333}}}],
     "\"Spain\""],
    Annotation[#, "Spain", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{79.8, 7.6}, {80.46666666666667, 5.933333333333334}, {
      81.88333333333333, 7.283333333333333}, {79.91666666666667, 
      9.766666666666666}, {80.61666666666666, 9.45}, {79.8, 7.6}}}],
     "\"SriLanka\""],
    Annotation[#, "SriLanka", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{38.61666666666667, 18.03333333333333}, {36.9, 
      22.03333333333333}, {35.61666666666667, 23.133333333333333`}, {
      33.93333333333333, 21.75}, {25., 22.}, {25., 20.}, {24., 19.5}, {24., 
      15.7}, {22.933333333333334`, 15.549999999999999`}, {21.833333333333332`,
       12.8}, {22.766666666666666`, 10.95}, {22.883333333333333`, 
      10.916666666666666`}, {23.516666666666666`, 8.716666666666667}, {27.45, 
      5.016666666666667}, {30.866666666666667`, 3.4833333333333334`}, {34., 
      4.216666666666667}, {35.93333333333333, 4.616666666666666}, {
      32.983333333333334`, 7.933333333333334}, {34.28333333333333, 10.55}, {
      36.15, 12.7}, {37., 17.066666666666666`}, {38.61666666666667, 
      18.03333333333333}}}],
     "\"Sudan\""],
    Annotation[#, "Sudan", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-54.166666666666664`, 5.35}, {-57.25, 
      5.483333333333333}, {-58.05, 4.}, {-56.46666666666667, 1.95}, {-54.6, 
      2.3333333333333335`}, {-54.166666666666664`, 5.35}}}],
     "\"Suriname\""],
    Annotation[#, "Suriname", "Tooltip"]& ], 
   TagBox[
    TooltipBox[PolygonBox[{CompressedData["
1:eJxNXGegFMXSRVQUMCKKIhi5m2Z2ZnbvBREDDQgqioKDCAKSkYzkKFlyRskZ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       "], CompressedData["
1:eJxdW3d4VNXTDi0kBAIJvYSmFAGBvXV3Qxm6ghTZBQRRBAERQYpSRECKgCAi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       "], CompressedData["
1:eJxdVwlYjlkbToOxZBfGNipkmSK+c97XEk/CkL1jSbK0KRVJZQklSYlSyr4M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       "], CompressedData["
1:eJxdlA1QVFUUxxehEhNzcJnlwxVJkRgs07n3iZBxDERE1PAiGrV+AQmO60or
TbJoKR8qOeaCggKtfAgLiUirBBqlpEK2AgIaiiujoKyCBAipiGnnrcy+Gd/M
zs7vvXvO/Z9z/+e6rFMsixwlEomC8cf/G6Xa+wH7CAzN7Cx1PcpgasbL/duz
CIQsc8vZg3zVI9KhvYiATUzJ9zd5zuyUaisJtK+UVDQiK/qSLoU0EqjzXtKo
Rv4mO2/KaYPAJRPDIrx7Cche+D7ryWdQYyhPjBdRGHrnQcUJ5PLCrbXuYygE
nN0m9UR2+yNZu8KRgqZXW7MIudUpfu0sV2qO76g99Gv6hxR8Vnz+81nM3/CE
dRR4U5BffKFTFTJ4ipjlR+Fg5O5wWRHqiSuY7htEwYEXXMxgvV+0om85hTX3
rrx7EznZ8++L8ggKB3YlhTXjepeyr6LUcgobrYdy1msZqLcPe23eRGFTvkXV
G5jfECVS7NhCoWLdtzfmFjAgeadmP91Jwd81dlQm6mHpLvti1RTqHYJbnZCX
woS15/MpJIc1V3Ugm/LoKCRq6n5qwPjqOVMCVecpHDl2/PpqzF9ddHQJNFPQ
587/ZQC/i32wY3eF/e32BnZZDVLY2Y6NQHaacWvqmxYc1Lp7pepR76pFf741
920OovmDwXoKx6AyW+6VbuRzDzUfTRdzMODcpFiN6yNkBn9Le86sJ+zf060p
Ug4qJyV1B6Ne7831u5smcWAVOu59XS4D3h7Djhy0pWHDjjCQ3Kh/wiZwUGZp
3Pvejww+4xtqwwFGtd3OYsDLTxzLAZ62pfEQ9rMn3oeO4+DT5/bKlnQGf4Vg
xcg1cvJdxQEGHvYHr1qP5uBkl7LcLg3r06xy14s4+DrGyea2mkGOIxb8mJo5
4E6cuNRIwbbgt2pJKoOg2Xvmrbk20k9kW1MDqTkfumFidx6FZz3d5+Ygj4/j
jn28S/hueq+ksKXcbliP8Q+mzRxd8oWwnyQAlTMK9zd4PM5ADkG7XQBh/+fF
/U2LZwnxJl+7CcyPUdRkCjhtdxNSR/wkRn8qW2wfYT509UPNWGG/lzrVozKc
F1NeXI+uPNk1QMz5AlUJM4I6CciNw8X9yJPn9YdfvkUAp1PUhpy1nO8EAd/j
0W0xyBaLE22WNghs6lMNAT5MhvXXXcanigA/Bj14HoaWHUr/UwRaSK/n/AwG
lbzz8D74vVoyjR1moPsAnZlN4Irf9b7BzJF5/wHz8QbF83dxHtwYuo288m02
Ay+0e4JC4BPYBo2MgLt+fO0ZZNOcBhO48AkKRD9lHsZnIQHrFOfwfzQMVOLS
BXcCCeD0bV2Zw4A//gW43hHHLT53ZD4iCMSm2VuF5uH98OU14wYVgTOtKf9F
4v3Bt1+E+uykl+75oL9fv//+B6daUNQ=
       "]}],
     "\"Svalbard\""],
    Annotation[#, "Svalbard", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{32.13333333333333, -26.833333333333332`}, {
      31.966666666666665`, -25.95}, {30.816666666666666`, -26.8}, {
      32.13333333333333, -26.833333333333332`}}}],
     "\"Swaziland\""],
    Annotation[#, "Swaziland", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{11.433333333333334`, 58.983333333333334`}, {
      13.299999999999999`, 55.333333333333336`}, {15.85, 
      56.083333333333336`}, {16.183333333333334`, 58.63333333333333}, {
      18.416666666666668`, 59.13333333333333}, {16.016666666666666`, 59.5}, {
      19.083333333333332`, 59.733333333333334`}, {17.333333333333332`, 
      62.483333333333334`}, {24.166666666666668`, 65.81666666666666}, {20.6, 
      69.05}, {12.133333333333333`, 63.583333333333336`}, {
      11.433333333333334`, 58.983333333333334`}}}],
     "\"Sweden\""],
    Annotation[#, "Sweden", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{7.033333333333333, 45.93333333333333}, {
      10.466666666666667`, 46.88333333333333}, {9.6, 47.06666666666666}, {
      9.533333333333333, 47.28333333333333}, {9.566666666666666, 
      47.53333333333333}, {7.583333333333333, 47.583333333333336`}, {
      5.966666666666667, 46.21666666666667}, {7.033333333333333, 
      45.93333333333333}}}],
     "\"Switzerland\""],
    Annotation[#, "Switzerland", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{35.916666666666664`, 35.93333333333333}, {
      35.96666666666667, 34.65}, {35.666666666666664`, 33.25}, {35.65, 
      32.68333333333333}, {38.8, 33.38333333333333}, {41., 
      34.416666666666664`}, {42.35, 37.11666666666667}, {36.666666666666664`, 
      36.833333333333336`}, {35.916666666666664`, 35.93333333333333}}}],
     "\"Syria\""],
    Annotation[#, "Syria", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{121.28333333333333`, 25.116666666666667`}, {122., 25.}, {
      120.71666666666667`, 21.933333333333334`}, {120.11666666666666`, 
      23.616666666666667`}, {121.28333333333333`, 25.116666666666667`}}}],
     "\"Taiwan\""],
    Annotation[#, "Taiwan", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{67.76666666666667, 37.2}, {68.21666666666667, 
      38.03333333333333}, {67.58333333333333, 39.483333333333334`}, {
      69.58333333333333, 40.63333333333333}, {69.56666666666666, 
      39.93333333333333}, {71.51666666666667, 39.233333333333334`}, {
      74.16666666666667, 39.53333333333333}, {74.9, 37.233333333333334`}, {
      71.68333333333334, 36.68333333333333}, {70.95, 38.46666666666667}, {
      67.76666666666667, 37.2}}}],
     "\"Tajikistan\""],
    Annotation[#, "Tajikistan", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{40.43333333333333, -10.483333333333333`}, {
      38.78333333333333, -6.05}, {39.2, -4.666666666666667}, {
      33.916666666666664`, -1.}, {
      30.483333333333334`, -1.0666666666666667`}, {
      30.566666666666666`, -2.4}, {29.416666666666668`, -4.45}, {
      30.766666666666666`, -8.183333333333334}, {
      32.983333333333334`, -9.416666666666666}, {
      34.333333333333336`, -9.733333333333333}, {
      34.96666666666667, -11.566666666666666`}, {
      40.43333333333333, -10.483333333333333`}}}],
     "\"Tanzania\""],
    Annotation[#, "Tanzania", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{102.91666666666667`, 11.633333333333333`}, {
      100.86666666666666`, 12.65}, {100.26666666666667`, 
      13.516666666666666`}, {99.15, 10.366666666666667`}, {
      100.41666666666667`, 7.166666666666667}, {102.1, 6.233333333333333}, {
      101.15, 5.633333333333333}, {100.13333333333333`, 6.416666666666667}, {
      98.28333333333333, 8.216666666666667}, {98.75, 10.35}, {
      99.66666666666667, 11.833333333333334`}, {98.18333333333334, 15.1}, {
      98.93333333333334, 16.383333333333333`}, {97.35, 18.55}, {
      100.08333333333333`, 20.35}, {101.28333333333333`, 
      19.566666666666666`}, {100.91666666666667`, 17.566666666666666`}, {
      103.39999999999999`, 18.433333333333334`}, {104.71666666666667`, 
      17.5}, {105.21666666666667`, 14.35}, {102.33333333333333`, 
      13.549999999999999`}, {102.91666666666667`, 11.633333333333333`}}}],
     "\"Thailand\""],
    Annotation[#, "Thailand", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{1.2, 6.1}, {1.65, 6.216666666666667}, {0.9166666666666666, 
      11.}, {-0.16666666666666666`, 11.133333333333333`}, {0., 
      11.1}, {-0.08333333333333333, 10.7}, {0., 10.6}, {1.2, 6.1}}}],
     "\"Togo\""],
    Annotation[#, "Togo", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-171.858788, -9.120741}, {-171.780853, -9.113962}, \
{-171.781883, -9.155994}, {-171.763687, -9.218694}, {-171.783943, -9.233265}, \
{-171.823425, -9.236654}, {-171.858444, -9.186159}, {-171.853981, -9.158027}, \
{-171.858788, -9.120741}}}],
     "\"Tokelau\""],
    Annotation[#, "Tokelau", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-175.112, -21.1823}, {-175.074, -21.1827}, {-175.06, \
-21.1936}, {-175.061, -21.2147}, {-175.081, -21.235}, {-175.108, -21.2506}, \
{-175.118, -21.2685}, {-175.119, -21.2994}, {-175.134, -21.3146}, {-175.163, \
-21.322}, {-175.186, -21.3212}, {-175.219, -21.3196}, {-175.266, -21.3122}, \
{-175.304, -21.2931}, {-175.335, -21.272}, {-175.386, -21.2529}, {-175.421, \
-21.2455}, {-175.457, -21.2236}, {-175.482, -21.206}, {-175.489, -21.1795}, \
{-175.489, -21.1448}, {-175.481, -21.1261}, {-175.46, -21.1183}, {-175.437, \
-21.1206}, {-175.428, -21.1315}, {-175.438, -21.1549}, {-175.436, -21.1756}, \
{-175.423, -21.1904}, {-175.393, -21.201}, {-175.368, -21.2041}, {-175.35, \
-21.1963}, {-175.338, -21.1729}, {-175.318, -21.1592}, {-175.289, -21.1514}, \
{-175.253, -21.1537}, {-175.223, -21.1666}, {-175.214, -21.1869}, {-175.214, \
-21.2154}, {-175.206, -21.2333}, {-175.192, -21.2364}, {-175.172, -21.2314}, \
{-175.163, -21.2123}, {-175.148, -21.1912}, {-175.132, -21.1838}, {-175.112, \
-21.1823}}, {{-174.147, -18.5206}, {-174.088, -18.5231}, {-174.069, \
-18.5169}, {-174.051, -18.5048}, {-174.025, -18.4976}, {-174.005, -18.5011}, \
{-173.975, -18.511}, {-173.953, -18.5135}, {-173.935, -18.5238}, {-173.932, \
-18.5474}, {-173.933, -18.5772}, {-173.943, -18.5946}, {-173.973, -18.5984}, \
{-173.992, -18.5959}, {-174.031, -18.5838}, {-174.056, -18.5769}, {-174.091, \
-18.576}, {-174.12, -18.5803}, {-174.134, -18.5872}, {-174.158, -18.5949}, \
{-174.184, -18.6033}, {-174.202, -18.6049}, {-174.218, -18.5946}, {-174.222, \
-18.5763}, {-174.241, -18.5611}, {-174.242, -18.544}, {-174.232, -18.5297}, \
{-174.21, -18.5203}, {-174.179, -18.5194}, {-174.147, -18.5206}}, {{-174.902, \
-21.2895}, {-174.877, -21.3002}, {-174.871, -21.3219}, {-174.878, -21.352}, \
{-174.894, -21.3766}, {-174.909, -21.3859}, {-174.912, -21.4002}, {-174.91, \
-21.4706}, {-174.908, -21.4947}, {-174.917, -21.5021}, {-174.928, -21.4998}, \
{-174.94, -21.4841}, {-174.945, -21.4567}, {-174.956, -21.4303}, {-174.972, \
-21.4141}, {-174.982, -21.3947}, {-174.973, -21.3706}, {-174.96, -21.3405}, \
{-174.942, -21.3145}, {-174.924, -21.2965}, {-174.914, -21.2937}, {-174.902, \
-21.2895}}, {{-174.332, -18.7307}, {-174.351, -18.7278}, {-174.361, \
-18.7196}, {-174.36, -18.7015}, {-174.356, -18.6874}, {-174.333, -18.6746}, \
{-174.317, -18.6675}, {-174.293, -18.6652}, {-174.273, -18.6705}, {-174.242, \
-18.6874}, {-174.235, -18.6986}, {-174.244, -18.7038}, {-174.257, -18.7027}, \
{-174.27, -18.6933}, {-174.281, -18.6857}, {-174.295, -18.6845}, {-174.308, \
-18.6986}, {-174.317, -18.7138}, {-174.332, -18.7307}}, {{-175.762, \
-15.5704}, {-175.732, -15.5809}, {-175.724, -15.5937}, {-175.717, -15.6091}, \
{-175.723, -15.6263}, {-175.738, -15.6394}, {-175.758, -15.6452}, {-175.775, \
-15.6455}, {-175.795, -15.6414}, {-175.813, -15.6283}, {-175.824, -15.6094}, \
{-175.824, -15.5937}, {-175.816, -15.5771}, {-175.8, -15.5713}, {-175.777, \
-15.5681}, {-175.762, -15.5704}}, {{-175.137, -19.7645}, {-175.119, \
-19.7842}, {-175.112, -19.8135}, {-175.129, -19.831}, {-175.157, -19.8325}, \
{-175.185, -19.8267}, {-175.207, -19.804}, {-175.2, -19.7798}, {-175.185, \
-19.7623}, {-175.155, -19.7586}, {-175.137, -19.7645}}, {{-174.61, -18.7978}, \
{-174.609, -18.8126}, {-174.622, -18.825}, {-174.647, -18.8372}, {-174.668, \
-18.8419}, {-174.691, -18.838}, {-174.711, -18.8265}, {-174.716, -18.812}, \
{-174.708, -18.7978}, {-174.689, -18.7841}, {-174.665, -18.7797}, {-174.637, \
-18.7824}, {-174.626, -18.7859}, {-174.61, -18.7978}}, {{-173.79, -15.8543}, \
{-173.775, -15.8527}, {-173.758, -15.852}, {-173.747, -15.8533}, {-173.744, \
-15.8617}, {-173.747, -15.8799}, {-173.774, -15.9015}, {-173.797, -15.9114}, \
{-173.815, -15.9122}, {-173.828, -15.909}, {-173.833, -15.8985}, {-173.83, \
-15.8838}, {-173.816, -15.8709}, {-173.804, -15.8627}, {-173.79, -15.8543}}, \
{{-174.772, -19.8891}, {-174.754, -19.8995}, {-174.741, -19.9182}, {-174.742, \
-19.9419}, {-174.757, -19.9446}, {-174.781, -19.9391}, {-174.796, -19.9294}, \
{-174.805, -19.9092}, {-174.799, -19.8932}, {-174.783, -19.8877}, {-174.772, \
-19.8891}}, {{-174.424, -19.8873}, {-174.422, -19.8731}, {-174.409, \
-19.8706}, {-174.396, -19.8793}, {-174.381, -19.8903}, {-174.363, -19.9021}, \
{-174.352, -19.9033}, {-174.351, -19.9088}, {-174.361, -19.9131}, {-174.381, \
-19.9193}, {-174.403, -19.9218}, {-174.427, -19.9193}, {-174.432, -19.9088}, \
{-174.431, -19.9008}, {-174.424, -19.8873}}, {{-174.818, -20.6007}, {-174.83, \
-20.6268}, {-174.85, -20.6365}, {-174.865, -20.637}, {-174.881, -20.6283}, \
{-174.881, -20.6145}, {-174.872, -20.5981}, {-174.855, -20.5853}, {-174.832, \
-20.5848}, {-174.82, -20.592}, {-174.818, -20.6007}}, {{-175.029, -19.6862}, \
{-175.016, -19.7074}, {-175.035, -19.7308}, {-175.053, -19.7396}, {-175.074, \
-19.7374}, {-175.082, -19.7198}, {-175.073, -19.6986}, {-175.051, -19.6884}, \
{-175.029, -19.6862}}, {{-174.536, -20.3245}, {-174.555, -20.3404}, \
{-174.574, -20.3428}, {-174.592, -20.3343}, {-174.594, -20.3172}, {-174.59, \
-20.305}, {-174.577, -20.2965}, {-174.556, -20.2922}, {-174.539, -20.2941}, \
{-174.533, -20.3069}, {-174.536, -20.3245}}, {{-174.34, -19.7754}, {-174.328, \
-19.7861}, {-174.34, -19.802}, {-174.36, -19.8165}, {-174.378, -19.8303}, \
{-174.39, -19.8307}, {-174.402, -19.8194}, {-174.401, -19.8066}, {-174.386, \
-19.7921}, {-174.368, -19.7825}, {-174.356, -19.7776}, {-174.34, -19.7754}}, \
{{-176.275, -22.2753}, {-176.245, -22.2801}, {-176.226, -22.2927}, {-176.227, \
-22.3052}, {-176.242, -22.3196}, {-176.259, -22.3196}, {-176.28, -22.3106}, \
{-176.295, -22.301}, {-176.293, -22.2891}, {-176.285, -22.2783}, {-176.275, \
-22.2753}}, {{-174.368, -19.6678}, {-174.356, -19.6685}, {-174.344, \
-19.6833}, {-174.33, -19.706}, {-174.332, -19.7241}, {-174.34, -19.7351}, \
{-174.352, -19.7358}, {-174.362, -19.7312}, {-174.372, -19.7145}, {-174.373, \
-19.6908}, {-174.373, -19.6787}, {-174.368, -19.6678}}, {{-174.387, \
-18.6214}, {-174.368, -18.6126}, {-174.345, -18.6091}, {-174.332, -18.6126}, \
{-174.329, -18.6278}, {-174.348, -18.6378}, {-174.364, -18.6442}, {-174.38, \
-18.6536}, {-174.392, -18.6536}, {-174.406, -18.6471}, {-174.406, -18.6342}, \
{-174.396, -18.6243}, {-174.387, -18.6214}}, {{-174.388, -17.9513}, \
{-174.391, -17.9753}, {-174.412, -17.9918}, {-174.428, -17.9902}, {-174.443, \
-17.9769}, {-174.437, -17.9604}, {-174.413, -17.9406}, {-174.391, -17.9398}, \
{-174.388, -17.9513}}, {{-174.479, -19.9439}, {-174.454, -19.9513}, \
{-174.447, -19.9661}, {-174.45, -19.9803}, {-174.465, -19.984}, {-174.479, \
-19.9834}, {-174.498, -19.9766}, {-174.501, -19.9643}, {-174.495, -19.9513}, \
{-174.479, -19.9439}}}],
     "\"Tonga\""],
    Annotation[#, "Tonga", "Tooltip"]& ], 
   TagBox[
    TooltipBox[PolygonBox[{CompressedData["
1:eJxdVAtQVlUQ/qGRiJHJQdMSAolzTCBCfBKTsPALJsryEJKHRUIgIokg8hKJ
91NIFDRBSgQTRgzBGklN10cgOKMGgUOYWQHKICJIEkKPvb/MONOZuffO3rN7
vt1vvz2mQZFeIdoqlcqNH+Xb51D16/kmpGXH7dcHREmoze8OU11AOttYoPMo
VgIFzHMcPo6kfW6awaxPJcgd2qW6lUhZLd4XqzMkRLw0fnhTGZJBOrVWZEpY
rKx9SEtSTkNamoT1AfUXHhQiqZSVIiHOytRkNAMp1/Gj3pu8/+0rE9ceJiAF
ONnf79otYbJmuM0tGskvy7bzhwIJ28OKBpMikUYcb4R2ZEuw3bRyc+Q2pPjE
o2+pkyQcOmL23WQckunJ6LCiTySEuz0uXJeEVFOFMHOjBDPXnenWjPfxB7dd
XvCV0O4WNMM3F0nvVuW2Fa5T+Gx7FBzYaqCW8NmlPxdsyEaSOqklaksJDW9v
rdTieOX4QSMJnltK4w6lIalPbL4TpSdhvzo/4l76FJ6WhK7AWHfjLCSz7vHk
8EkBOcEMnM/+RgO/L3sqYOHar/RcCpBu30rd7jIqoK44JCeY7XTP1eUpfQLG
X+4/Xcf+7pz95XYBrUxzFZ83POrql9UoYPlc7kgqUqNx5oDn5wKOKmXuRHJQ
iN4tgIMsQ5hPrqrlcpqApUO2zqsSkdwy9N3rYgQcnmv9i0hGyjv5W3+JlwCT
0Yj3d7Ed9kZEfKKzgIT++Ta6zF933t8hY0LAM56RDPXvWu2ZJ+B7r/2mhbuQ
ovMKe0ZMBLgogkhB0uRtJuDR7Pc8JnOQzqyerm35poBjCc3mdqVIr7f0OlSx
/94N/6ifliOZcPqNxlyvTd/XsgqJ/w4O8Pkrmc6J+ufxp6ZH1eafRVLa/kgK
MPziQ/NrV6f0x/lVdC4Zsu1AGmq57HTCXIBS/ms/I2l0bC3AZ6FFzcy7SFoK
AWxXslyye5BKdZWTBPSOmLRFDiH5MM3I+IuUgMdIiswNOT+/Oad/VD1BinEp
fqLD+SvwM8aQbHRrjfwZ/12FEN53YnnesxAQyNvNI0h39mVn+i8WoNHNA6T5
66ZV7rUTEKQkfB/p0hz+oxbAapkd3ouk0Gy0RkDzGR48zree29OwVsAGHr/g
20gFCwb1z3uIZ/rtQnrnm6ux5wMF+LYuulLfyfqxZmGFCnBXBNWO1BHPjQyb
6u91pIq/mOgQAW2RgS9eb0GyaigfOsb+zH5POs+/7ooyny+3CDho8WrJTxeR
MpNunvLbIcD7j6NlVwipumnN8txUAZo5YjvPJPih/xEB/HayZ1szB90CNH05
x/we5DUuQMdglkMT25o6pkvwjhEH/mV/+wTf6qVWEkLHejZWML4iz2JnCZo+
3eD7oih5ws6D7xdFgFwPR+1JDnhua/CDJPz//voPGwIyRg==
       "], {{-60.6118, 11.2667}, {-60.5871, 11.2832}, {-60.5468, 
       11.2911}, {-60.5174, 11.2832}, {-60.5064, 11.2612}, {-60.5129, 
       11.216}, {-60.5321, 11.2038}, {-60.5605, 11.1989}, {-60.577, 
       11.1897}, {-60.599, 11.1604}, {-60.6265, 11.1488}, {-60.7099, 
       11.1452}, {-60.7282, 11.1415}, {-60.7969, 11.1128}, {-60.8528, 
       11.103}, {-60.867, 11.1061}, {-60.8816, 11.1189}, {-60.8844, 
       11.1403}, {-60.8761, 11.1531}, {-60.856, 11.1611}, {-60.7982, 
       11.1605}, {-60.7753, 11.1666}, {-60.7396, 11.191}, {-60.6938, 
       11.2185}, {-60.6351, 11.2435}, {-60.6118, 11.2667}}}],
     "\"TrinidadTobago\""],
    Annotation[#, "TrinidadTobago", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{8.616666666666667, 36.93333333333333}, {11.05, 
      37.083333333333336`}, {10., 34.166666666666664`}, {11.533333333333333`, 
      33.166666666666664`}, {9.533333333333333, 30.233333333333334`}, {7.5, 
      33.88333333333333}, {8.616666666666667, 36.93333333333333}}}],
     "\"Tunisia\""],
    Annotation[#, "Tunisia", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{35.916666666666664`, 35.93333333333333}, {
       36.016666666666666`, 36.93333333333333}, {32.8, 36.016666666666666`}, {
       29.683333333333334`, 36.11666666666667}, {27.366666666666667`, 
       36.68333333333333}, {28.333333333333332`, 37.03333333333333}, {
       26.233333333333334`, 38.266666666666666`}, {27.166666666666668`, 
       38.45}, {26.15, 39.95}, {29.616666666666667`, 41.18333333333333}, {
       34.95, 42.1}, {41.53333333333333, 41.516666666666666`}, {
       44.81666666666666, 39.63333333333333}, {44.8, 37.166666666666664`}, {
       42.35, 37.1}, {36.666666666666664`, 36.833333333333336`}, {
       35.916666666666664`, 35.93333333333333}}, {{26.03333333333333, 
       40.733333333333334`}, {26.183333333333334`, 40.05}, {
       28.983333333333334`, 41.}, {28.016666666666666`, 
       41.983333333333334`}, {26.349999999999998`, 41.71666666666667}, {
       26.03333333333333, 40.733333333333334`}}}],
     "\"Turkey\""],
    Annotation[#, "Turkey", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{52.833333333333336`, 41.7}, {54.766666666666666`, 
      41.03333333333333}, {52.71666666666667, 40.45}, {53.9, 37.35}, {
      57.199999999999996`, 38.28333333333333}, {59.56666666666666, 
      37.21666666666667}, {61.28333333333333, 35.6}, {64.06666666666666, 
      36.}, {65.78333333333333, 37.56666666666666}, {63.56666666666666, 
      39.1}, {60.36666666666667, 41.4}, {58.666666666666664`, 
      42.833333333333336`}, {56., 41.5}, {52.833333333333336`, 41.7}}}],
     "\"Turkmenistan\""],
    Annotation[#, "Turkmenistan", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-71.7221, 21.8213}, {-71.6583, 21.8283}, {-71.6345, 
       21.8213}, {-71.625, 21.8067}, {-71.6478, 21.768}, {-71.6469, 
       21.7528}, {-71.624, 21.7389}, {-71.5955, 21.7332}, {-71.5888, 
       21.7243}, {-71.6012, 21.704}, {-71.6421, 21.6888}, {-71.6573, 
       21.6907}, {-71.7087, 21.7116}, {-71.7524, 21.7167}, {-71.8191, 
       21.7363}, {-71.8486, 21.7579}, {-71.881, 21.7655}, {-71.8914, 
       21.7807}, {-71.8781, 21.8048}, {-71.8305, 21.8454}, {-71.801, 
       21.8467}, {-71.7753, 21.8359}, {-71.7544, 21.8182}, {-71.7429, 
       21.8169}, {-71.7221, 21.8213}}, {{-71.4422, 21.6767}, {-71.39, 
       21.676}, {-71.3692, 21.664}, {-71.3663, 21.6431}, {-71.3824, 
       21.6115}, {-71.4669, 21.5672}, {-71.5087, 21.5641}, {-71.5257, 
       21.5723}, {-71.5257, 21.5805}, {-71.503, 21.609}, {-71.5058, 
       21.6204}, {-71.5371, 21.6406}, {-71.5874, 21.6292}, {-71.614, 
       21.6305}, {-71.6358, 21.645}, {-71.6349, 21.6539}, {-71.5599, 
       21.7039}, {-71.5286, 21.7076}, {-71.4972, 21.7007}, {-71.4792, 
       21.6868}, {-71.4641, 21.683}, {-71.4422, 21.6767}}, {{-71.9106, 
       21.8906}, {-71.9555, 21.8927}, {-72.0345, 21.9319}, {-72.0763, 
       21.934}, {-72.1134, 21.9247}, {-72.1336, 21.9278}, {-72.1336, 
       21.9463}, {-72.0933, 21.9773}, {-72.0051, 21.9866}, {-71.9509, 
       21.9752}, {-71.8734, 21.9309}, {-71.8719, 21.9092}, {-71.8843, 
       21.8947}, {-71.9106, 21.8906}}, {{-72.1891, 21.7308}, {-72.2531, 
       21.7395}, {-72.3088, 21.7601}, {-72.3349, 21.7893}, {-72.3349, 
       21.8264}, {-72.323, 21.8462}, {-72.3029, 21.8469}, {-72.2827, 
       21.8398}, {-72.2721, 21.8225}, {-72.2733, 21.8003}, {-72.2721, 
       21.7893}, {-72.2626, 21.7861}, {-72.2389, 21.7948}, {-72.2164, 
       21.7964}, {-72.1974, 21.7861}, {-72.1583, 21.7577}, {-72.1595, 
       21.7419}, {-72.1642, 21.7356}, {-72.1891, 21.7308}}, {{-72.3799, 
       21.6992}, {-72.3681, 21.7103}, {-72.3515, 21.7071}, {-72.3349, 
       21.6921}, {-72.3325, 21.6795}, {-72.342, 21.6329}, {-72.3692, 
       21.6108}, {-72.3894, 21.5887}, {-72.4048, 21.5887}, {-72.4214, 
       21.5974}, {-72.4238, 21.6226}, {-72.3799, 21.6992}}}],
     "\"TurksCaicosIslands\""],
    Annotation[#, "TurksCaicosIslands", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{177.052, -12.5076}, {177.069, -12.5067}, {
      177.089, -12.511}, {177.118, -12.5128}, {177.14, -12.5106}, {
      177.154, -12.5037}, {177.171, -12.5028}, {177.194, -12.5058}, {
      177.214, -12.5171}, {177.216, -12.5335}, {177.211, -12.5474}, {
      177.199, -12.5547}, {177.187, -12.5586}, {177.172, -12.5586}, {
      177.161, -12.5573}, {177.148, -12.5517}, {177.131, -12.5465}, {
      177.107, -12.5465}, {177.092, -12.5474}, {177.076, -12.5508}, {
      177.054, -12.5526}, {177.041, -12.5526}, {177.033, -12.5456}, {
      177.028, -12.5335}, {177.028, -12.5192}, {177.037, -12.5115}, {
      177.052, -12.5076}}}],
     "\"Tuvalu\""],
    Annotation[#, "Tuvalu", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{30.866666666666667`, 3.4833333333333334`}, {31.3, 
      2.1166666666666667`}, {29.599999999999998`, -1.3833333333333333`}, {
      30.483333333333334`, -1.0666666666666667`}, {
      33.916666666666664`, -1.}, {35.03333333333333, 1.9166666666666667`}, {
      34., 4.216666666666667}, {30.866666666666667`, 3.4833333333333334`}}}],
     "\"Uganda\""],
    Annotation[#, "Uganda", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{23.6, 51.53333333333333}, {27.333333333333332`, 
      51.583333333333336`}, {31.633333333333333`, 52.06666666666666}, {
      33.88333333333333, 51.68333333333333}, {39.56666666666666, 
      49.516666666666666`}, {39.93333333333333, 47.78333333333333}, {
      38.266666666666666`, 47.11666666666667}, {37.03333333333333, 
      46.86666666666667}, {34.81666666666666, 46.18333333333333}, {
      36.36666666666667, 45.03333333333333}, {33.63333333333333, 
      44.43333333333333}, {32.483333333333334`, 45.4}, {33.766666666666666`, 
      45.93333333333333}, {31.8, 46.28333333333333}, {31.75, 47.25}, {
      29.666666666666668`, 45.21666666666667}, {28.166666666666668`, 
      45.46666666666667}, {29.633333333333333`, 46.85}, {28.28333333333333, 
      48.15}, {26.666666666666668`, 48.25}, {22.9, 47.95}, {22.15, 
      48.416666666666664`}, {22.55, 49.083333333333336`}, {23.6, 
      51.53333333333333}}}],
     "\"Ukraine\""],
    Annotation[#, "Ukraine", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{51.21666666666667, 24.616666666666667`}, {
      54.11666666666667, 24.133333333333333`}, {56.36666666666667, 
      26.383333333333333`}, {56.6, 24.5}, {55.833333333333336`, 
      23.166666666666668`}, {54.833333333333336`, 22.666666666666668`}, {
      51.166666666666664`, 23.833333333333332`}, {51.21666666666667, 
      24.616666666666667`}}}],
     "\"UnitedArabEmirates\""],
    Annotation[#, "UnitedArabEmirates", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-5., 58.63333333333333}, {-3.0166666666666666`, 
       58.63333333333333}, {-4.25, 57.5}, {-1.8166666666666667`, 
       57.6}, {-3.683333333333333, 56.016666666666666`}, {0., 
       53.766666666666666`}, {0.13333333333333333`, 53.583333333333336`}, {0.,
        53.53333333333333}, {1.7666666666666666`, 52.483333333333334`}, {
       0.3833333333333333, 51.449999999999996`}, {0.23333333333333334`, 
       50.733333333333334`}, {-4.916666666666667, 
       50.583333333333336`}, {-2.3833333333333333`, 51.75}, {-4.3, 
       51.666666666666664`}, {-4.716666666666667, 
       52.85}, {-2.7333333333333334`, 
       53.333333333333336`}, {-3.0166666666666666`, 
       54.983333333333334`}, {-5.133333333333333, 54.85}, {-4.933333333333334,
        56.266666666666666`}, {-5.816666666666666, 55.3}, {-5., 
       58.63333333333333}}, {{-7.25, 55.06666666666666}, {-6.25, 
       54.083333333333336`}, {-6.266666666666667, 54.1}, {-8.15, 
       54.43333333333333}, {-7.25, 55.06666666666666}}}],
     "\"UnitedKingdom\""],
    Annotation[#, "UnitedKingdom", "Tooltip"]& ], 
   TagBox[
    TooltipBox[PolygonBox[{CompressedData["
1:eJxlVEtoFEEQHVYRQREC7iGCB0XwZC4imMTZ9Px25yDi9Hyy2bi7GkggF0Uk
BA+CeAoioidJDoI5iK4fAn4CxkOzJBgkes1BIgoiqEEFUZF4cKbfc9dgwTAU
VV313qvq3jV0Sg7nDMMYSL/sP55ZqapcbULszkxWlZHZeSF0fG9NTWTmW+LL
59Su15TOa9riTiO1Cv2cI14spbZaU/rcuCOezqW2pY56hid0m4119NtTEq9X
UttXV/u1+UKnzdRUnFneR/58Tem+l0utuD53zgee+zXi9YHfrq73c20fOCot
X+M9XG75uu9wQry+0Lw3x9SnBL5TEfhe8MTUZGq3IzWSWdFDvbsR+C+7yH8S
gs8Y+c+HSuddavu63rQntAzfJPiZRaHrJpL9isD/Jmj5uu5CgP43i9DjSKC0
7nMl4Fk6CjzXeH4mwDwn2P9hAH1Pepj3M9ZvuuC/GEAP5f4X131/sN4tF3qM
Surpot8V4reZ/1gqnXfWwXyazDdc7MsrCT7v23Gd3+2g/7Jcv2+/perI7KqN
/h8k+K/Z0GMb9bUd6PVdKj2X5w74bw/Rb5MjdB2L/gjjboj9PONAD5/zzDO/
I0S9izbvT0g9bOpDPkUb+W8l9umdBb5rxDtIvF0h+P6yoN9Xifm8tLAfTojz
8xb45EPwP22h/zT3a1UA70Hua06g3nHu52yB9yMC3sUe7OuOCPMQ3ajvRdjH
nfQfReD7sRf5DfqNQ+Dz6W/c5H2LVUZnsrMAPaOY+SbPx9S7QH1ivjcFzLMz
Af4hxk8k0KOrgH3oT8B3a4H3mfdXmIjPJuxvAv9YP+b5wGS9Mvit9HK+Zejz
k3wXysTXA//AAPGZmMeGCvYhZr0bFerZx3kNMt6H9+7eMc6b7+s/7+8fHBdH
8Q==
       "], {{-130., 55.916666666666664`}, {-130.68333333333334`, 
       54.766666666666666`}, {-131.01666666666665`, 
       56.1}, {-132.26666666666665`, 55.75}, {-135.33333333333334`, 
       59.46666666666667}, {-135.15, 58.199999999999996`}, {-139.5, 
       60.05}, {-147.71666666666667`, 61.28333333333333}, {-149.65, 
       59.85}, {-151.98333333333332`, 59.28333333333333}, {-149.25, 
       61.5}, {-153.45, 58.71666666666667}, {-158.43333333333334`, 
       56.}, {-163.33333333333334`, 54.8}, {-157.4, 
       57.5}, {-156.78333333333333`, 59.15}, {-160.15, 
       58.88333333333333}, {-162.16666666666666`, 
       58.65}, {-161.88333333333333`, 
       60.699999999999996`}, {-163.66666666666666`, 59.8}, {-163.55, 
       60.9}, {-165.01666666666665`, 61.449999999999996`}, {-166.2, 
       61.583333333333336`}, {-164.41666666666666`, 
       63.21666666666667}, {-161.15, 
       63.516666666666666`}, {-160.98333333333332`, 
       64.93333333333334}, {-168.13333333333333`, 
       65.65}, {-164.28333333333333`, 66.6}, {-161.8, 
       65.98333333333333}, {-162.48333333333332`, 
       66.95}, {-160.23333333333332`, 66.4}, {-166.83333333333334`, 
       68.35}, {-161.73333333333332`, 70.2}, {-156.46666666666667`, 
       71.4}, {-141.01666666666665`, 69.65}, {-141., 
       60.3}, {-135.46666666666667`, 59.8}, {-130.01666666666665`, 
       55.916666666666664`}}, {{-155.81666666666666`, 
       20.266666666666666`}, {-154.8, 
       19.53333333333333}, {-155.66666666666666`, 
       18.916666666666668`}, {-155.81666666666666`, 
       20.266666666666666`}}, {{-153.26666666666665`, 
       58.}, {-152.33333333333334`, 57.43333333333333}, {-154.8, 
       57.35}, {-153.26666666666665`, 58.}}}],
     "\"UnitedStates\""],
    Annotation[#, "UnitedStates", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-64.6233, 17.6946}, {-64.8362, 17.657}, {-64.8913, 
       17.6519}, {-64.9041, 17.657}, {-64.9157, 17.6724}, {-64.8913, 
       17.7057}, {-64.867, 17.7194}, {-64.8285, 17.7211}, {-64.7964, 
       17.7331}, {-64.7759, 17.7314}, {-64.731, 17.7091}, {-64.6913, 
       17.7074}, {-64.6426, 17.7143}, {-64.6208, 17.7126}, {-64.608, 
       17.7023}, {-64.6118, 17.6963}, {-64.6233, 17.6946}}, {{-64.8651, 
       18.3082}, {-64.8739, 18.2966}, {-64.8869, 18.2908}, {-64.9218, 
       18.2893}, {-65.0046, 18.3111}, {-65.0546, 18.3212}, {-65.0721, 
       18.3314}, {-65.0656, 18.3416}, {-65.0307, 18.3488}, {-64.9675, 
       18.3793}, {-64.9349, 18.3837}, {-64.9022, 18.3706}, {-64.8651, 
       18.3082}}, {{-64.7911, 18.2922}, {-64.8041, 18.3111}, {-64.7954, 
       18.3285}, {-64.7627, 18.3387}, {-64.7039, 18.3329}, {-64.6625, 
       18.3082}, {-64.6625, 18.2922}, {-64.6865, 18.2762}, {-64.7301, 
       18.2762}, {-64.7911, 18.2922}}, {{-65.3726, 18.3141}, {-65.3742, 
       18.3275}, {-65.3555, 18.3317}, {-65.298, 18.3141}, {-65.2856, 
       18.2871}, {-65.2872, 18.2695}, {-65.3276, 18.2633}, {-65.3555, 
       18.2789}, {-65.3726, 18.3141}}}],
     "\"UnitedStatesVirginIslands\""],
    Annotation[#, "UnitedStatesVirginIslands", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-53.36666666666667, -33.75}, {-57.833333333333336`, \
-34.5}, {-58.199999999999996`, -32.45}, {-57.63333333333333, \
-30.233333333333334`}, {-53.75, -32.05}, {-53.36666666666667, -33.75}}}],
     "\"Uruguay\""],
    Annotation[#, "Uruguay", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{56., 41.5}, {56., 45.}, {58.666666666666664`, 45.5}, {
      62.166666666666664`, 43.5}, {67.91666666666667, 41.28333333333333}, {
      69.5, 41.333333333333336`}, {71.01666666666667, 42.3}, {
      71.23333333333333, 41.11666666666667}, {73., 40.93333333333333}, {
      69.56666666666666, 39.93333333333333}, {69.58333333333333, 
      40.63333333333333}, {67.58333333333333, 39.483333333333334`}, {
      68.21666666666667, 38.03333333333333}, {67.76666666666667, 37.2}, {
      65.78333333333333, 37.56666666666666}, {63.56666666666666, 39.1}, {
      60.36666666666667, 41.4}, {58.666666666666664`, 42.833333333333336`}, {
      56., 41.5}}}],
     "\"Uzbekistan\""],
    Annotation[#, "Uzbekistan", "Tooltip"]& ], 
   TagBox[
    TooltipBox[PolygonBox[{CompressedData["
1:eJxdlQtQVVUUhlHByreESgQIgWnq3jcNJCFlC2pgASIOMWpauMlCUxNUfKAC
GSapo2j4wCch5hiCD3zjKg1DEROlKwEiDwXCV6NCiGj/PufSnenMMHe+e9f5
99pr/WvhHD5nQkR7CwuLSPypz0u7x+Q8uipFkGPvyIBkRuO6tB+UWCRF0Zxp
LxUuYrTEJvP9SrDPlc+KayMZDT/y24Lca1Jkj5+5deEURmNzHrVevy4F87Vv
qApl9Mnt398oLZbimW2U0XoCox0PMvI+MErhtuKYiPdh5O0+9aT/DSnyvlTf
MFLH9S6RonnIncx+oxk9RLgHeNrmD3t9N45Rx7hNvkmIX51VWb8JeqHd2KHt
0Csb2yGms2TUTwWA01xOPEuMNp/3wrm1cf4KRoe24wvw3eDjjiuTGO3/uygg
HHravbYyen49pv5NnDdzUGNK+WFGC3N32hnA9ccOdqgtYFS5GIHgksKmkOrb
jCZJr4ogcMRrVWF9mhi9bih37Qj+Jn/iz/ssOZU2L4s8Df3q9G3nnXpwypr3
+fp74G65b28ZaMtp6xY8iP9h7ohORhdO6+8t9Xb/U4qC+/nnfBgnqMVtKpXC
Fdd57MVpohIqkyI0NjMn3JuTsxIsl2JdSLRrCjiBLu4ecxP1eutSjwuenLR7
VkhhlbbBsx30/gmBwC3Tfe24nm+lFO+cz+azO3CKVQ0Bz0B3BzUymp9saxla
JYVXu4Cvuz5glL8ABamWYuSisH3u9xhNWffLkwE1Uni6jFuSgN9TzztlzQPf
iIsauxHvR56OTrYFX0G50lsYnfRHh/F+0/xbqT2tOH07Cg6B/mSfkXUlXThp
7QcrW+1EfqjumhRwJ2Pa3BEDzazSjnPnpOzVDNb67MH1/kPfreew984MNd0f
rPlsMKfvfZNm1YJfad414zD0wnuEDT9SY66PVo/bUkQGPFob4sZpZQMEwM3d
4QBfTh4qYcSvelxqjAsxc3qgePXT6Vz3A+I1H33FSfeJFBfP+fz0xTJOo3F8
C/jhShhkFSdLZWBwQ9TRXi1JnC4X4Kkx85CXD9hPAjupAVzLdb+Ce6sEk836
2rzlcJqqClwrxan+3TsfzeN6/euksLbxzisr5lSMtIaAR8VXXdhcyslPGRrx
nhsuLferMNX/jhRRsOlSsLUyFPQ97GiyUyUnVLMhGOfrfTX5E/XUxvMvTtp7
4P4q8aec+mgJSpGY8dHFoZYGGr8mZbY1OECFgzW/o3+r+06/P6m9QZ93+E+F
JVgY9HmtMLPmx5tmVuX8Ef4/G+vw7gzoaXmVmea1i4Eet6IRmKdA1Wgbg15v
zFvM4vTBvvYGfZ4wj5k3pi0IcjSQhXrAMal7XE7gd80/RvP7bfsF2yE50cqg
1+sPKdS1vZ9w2mUHA4G7BR3cGFHH9X2FfVjvx184l3NSOOuaab4vc7qP60/F
PsX2ch2Qa/IH9m+ZEQN0hNMc1QBwvBqnvZza9vPk7LN3d6RyClMLGO+3eM4t
XLXBrL8/Pth/+wpODsqQYNW+UfAjsi1sUucv9zsb+zHX9y/y63x076IL/pxc
1MICnzq+puPDYSb/gS97BV5db8/1+oD3II1WG05Psd6ioXewX03Cjq5cn29w
XzU4zxlpn8hv2x2HjLo6pve7qM1/7L/7nam2ccj/lVHjAGwUsDYHBxj9///R
v7kkPKs=
       "], CompressedData["
1:eJxNlQlQV1UUxkmJFBkjFyynHAUXhOqdTKaA0GcioYiIrBEZMg9DcoFAQiDZ
xiEqQyAIZQwdSfkjEYHiGh40A/qPSwQumIGG7KssJqjTd59v5t+bYZgf9777
zv3O9x3mBG9bFzLOyMhIwY/4nZS9/KvNbYrcf+Q3t7c6JK76/eCKCrD74Dde
US0SRziZXj/UrsifVebPlG5L/Kd7sLl/hyLX24a8dPeGxE0eu7/b2qnIk1zm
bR/XKPHplWbjbLsUuSjIe92CZoltUy1uXgbrzatPn+yRePJrZfv7wDv8C+0u
jUncENMx/41uRV7UWjKvZTw9/V63Vs9E4ouzSz8N7VHkmtwzOXueJzb2xQng
gx+Xd0ZOJ56D5QzwlrYx3YAlcSFeSwPH3y9d+4kNcdC9q5a3wGWvbz30zKvE
KYwL9iry5S/q/m62Jfa3P1YTDQ6K9phlgf3m4g9gG93Uq87WxOvFhfoUOVgs
gNfiulPA5XH4AN4Xxz/EfvtrF7csJuI3xYN1CZ87a0fc7Xly1i7w1fL3h085
EBuJp1+RuyKPTx9zJLa69XBnGNjvg5/PdS8hhhoTisHS7bkmSSuIXSoGH9eD
A4ZPNX7pTvykHoINKHL1QodMvQexWI4BPwl50LLBk3jEOjD9PDjUcnNMrA8x
1Ax3uq/I13y7pTN+xGnLoAi4YSJ2+BOnnx+2DhzEOspPxHpBOBoA3rStf1et
N3HRQJ178BD640M2Oi9i1QZDmj+8tX4MG867gOPSRxQ5U5/geu5D4rhpJe/d
AdsJIYOJc7dOSWGw82hPF2/S9Af/FWq0LSmKOKMnfqkdeAPsc2AH8SMdCgAf
g3yNscR/QO6dgmuiK/NjNf3Bat+iiVU/P1DkH36pmjE/kp76D6xeJ4K4GvZY
9q8ir0NbusAJYWejssDqvaI0/cFXNja0hcVp/QH7VBUWrEkknlD8coCC88KF
gcC1KGMm+LApApBM3Ivy16OexBNy8t1UYj3iNAh9lrTfLB792qDXmL639kIm
cYDi2OQh9BM5yCVWfTak5SvX0I8UafVh0xxNL/RvBm7llaXthz+iXL4dMUkn
dr0TO60EfnPK88k/uptY3ddnWBflO4J1BWvkqRnEkUhPPLipeVKWLtPw/kbx
5Gj+6NPyuJdYxPcI/N7bxfZW+4hXQ84g5KvfwnXtI9Sryo18518qutKQo+kD
dqt5zikvW+sv5kVRsufK/XuIRXn/YJ4gDfreNGIR4zqwg9WquJQE4gNoy1zs
93r2UKZDhKYvuBLt9QohdhQDCCzi832ggR+nDt26jjyoPgFvRDwOuhCvwnhK
Fd8XvpYN9fghHguWGr6v1idr+QJbhMHxy4kXIl7DmIduncaLX8B5JsJw4FCM
o+PIq7B7bLum57vEwmaeYCc1iMQ5Yty2af5C/kd3woBgdU44anlpVWTLxyPb
m9/R8gvuzC4ziwDv24vnniLntb5ypP1tYpx+chb4cN6vs0sXEYvrWYA7Tvw0
vg3zTh2PLZiPvp+XVFhq/gbD9S8aW2h5BssFTZWTzYjVOu8Z5q8zyh0D5x/9
8cZHJlq+/vf/4j/Jzifn
       "]}],
     "\"Vanuatu\""],
    Annotation[#, "Vanuatu", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{12.5647, 41.7939}, {12.4695, 41.8306}, {12.4659, 
      41.8746}, {12.5026, 41.9136}, {12.5794, 41.9208}, {12.6966, 41.9109}, {
      12.7551, 41.8742}, {12.7515, 41.8302}, {12.6929, 41.8059}, {12.6453, 
      41.7938}, {12.5942, 41.7912}, {12.5647, 41.7939}}}],
     "\"VaticanCity\""],
    Annotation[#, "VaticanCity", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-59.983333333333334`, 
      8.533333333333333}, {-61.61666666666667, 8.566666666666666}, {-60.85, 
      9.433333333333334}, {-63.016666666666666`, 10.1}, {-61.85, 
      10.75}, {-65.08333333333333, 10.033333333333333`}, {-68.3, 
      10.683333333333334`}, {-70.01666666666667, 12.2}, {-69.8, 
      11.433333333333334`}, {-71.58333333333333, 10.8}, {-71.63333333333333, 
      9.05}, {-71.31666666666666, 11.85}, {-73.38333333333333, 
      9.183333333333334}, {-72., 7.016666666666667}, {-67.45, 6.2}, {-67.85, 
      2.783333333333333}, {-66.86666666666666, 1.2166666666666666`}, {-63.4, 
      2.15}, {-64.8, 4.283333333333333}, {-62.88333333333333, 
      3.5666666666666664`}, {-61.516666666666666`, 
      4.266666666666667}, {-60.733333333333334`, 5.2}, {-61.38333333333333, 
      5.95}, {-59.983333333333334`, 8.533333333333333}}}],
     "\"Venezuela\""],
    Annotation[#, "Venezuela", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{104.45, 10.366666666666667`}, {104.85, 
      8.566666666666666}, {105.81666666666666`, 10.}, {106.55, 
      9.583333333333334}, {109.25, 11.716666666666667`}, {108.95, 15.25}, {
      106.58333333333333`, 17.566666666666666`}, {105.78333333333333`, 
      19.6}, {107.98333333333333`, 21.55}, {108.11666666666666`, 21.45}, {
      105.51666666666667`, 23.183333333333334`}, {102.13333333333333`, 
      22.4}, {103.16666666666667`, 20.85}, {104.64999999999999`, 
      20.666666666666668`}, {103.88333333333333`, 19.3}, {107.46666666666667`,
       16.083333333333332`}, {107.55, 14.7}, {107.55, 12.35}, {105.85, 
      11.666666666666666`}, {104.45, 10.366666666666667`}}}],
     "\"Vietnam\""],
    Annotation[#, "Vietnam", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-178.185, -14.2655}, {-178.146, -14.28}, {-178.115, \
-14.2935}, {-178.095, -14.3068}, {-178.091, -14.317}, {-178.098, -14.3215}, \
{-178.12, -14.3241}, {-178.164, -14.323}, {-178.204, -14.321}, {-178.214, \
-14.317}, {-178.217, -14.3034}, {-178.217, -14.2791}, {-178.211, -14.2675}, \
{-178.199, -14.2644}, {-178.185, -14.2655}}, {{-178.032, -14.3493}, \
{-178.012, -14.3559}, {-178.009, -14.3684}, {-178.025, -14.3782}, {-178.058, \
-14.3833}, {-178.092, -14.38}, {-178.108, -14.374}, {-178.112, -14.366}, \
{-178.106, -14.3562}, {-178.087, -14.3511}, {-178.062, -14.349}, {-178.044, \
-14.3481}, {-178.032, -14.3493}}}],
     "\"WallisFutuna\""],
    Annotation[#, "WallisFutuna", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{35.2868, 31.3933}, {35.1951, 31.3682}, {34.9937, 31.358}, {
      34.9171, 31.3725}, {34.882, 31.409}, {34.893, 31.5448}, {34.932, 
      31.7951}, {35.0412, 31.7982}, {35.1566, 31.818}, {35.1374, 31.8688}, {
      35.0911, 31.9095}, {34.9855, 31.964}, {35.0298, 32.0818}, {35.0419, 
      32.2336}, {35.02, 32.2715}, {35.006, 32.3361}, {35.0319, 32.391}, {
      35.1059, 32.4882}, {35.2181, 32.5794}, {35.2794, 32.594}, {35.3867, 
      32.559}, {35.5268, 32.4437}, {35.5772, 32.4214}, {35.5915, 32.25}, {
      35.5986, 32.0492}, {35.5844, 31.9275}, {35.5655, 31.8949}, {35.5472, 
      31.8513}, {35.5289, 31.7859}, {35.485, 31.6426}, {35.4155, 31.4153}, {
      35.2868, 31.3933}}}],
     "\"WestBank\""],
    Annotation[#, "WestBank", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-13.183333333333334`, 27.666666666666668`}, {-17.05, 
      20.766666666666666`}, {-13., 21.333333333333332`}, {-13.1, 22.9}, {-12.,
       26.}, {-8.666666666666666, 26.}, {-8.666666666666666, 
      27.3}, {-8.666666666666666, 27.666666666666668`}, {-13.183333333333334`,
       27.666666666666668`}}}],
     "\"WesternSahara\""],
    Annotation[#, "WesternSahara", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{44.5, 17.4}, {42.78333333333333, 16.4}, {43.55, 12.7}, {
      48.7, 14.033333333333333`}, {53.083333333333336`, 
      16.633333333333333`}, {51.983333333333334`, 19.}, {45.583333333333336`, 
      15.1}, {44.5, 17.4}}}],
     "\"Yemen\""],
    Annotation[#, "Yemen", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{30.766666666666666`, -8.183333333333334}, {
      28.366666666666667`, -9.266666666666666}, {
      28.366666666666667`, -11.55}, {29.8, -12.15}, {29.8, -13.45}, {
      27.2, -11.566666666666666`}, {
      23.983333333333334`, -10.866666666666667`}, {
      24.016666666666666`, -13.}, {22., -13.}, {22., -16.166666666666668`}, {
      23.483333333333334`, -17.633333333333333`}, {
      25.266666666666666`, -17.8}, {27.15, -17.8}, {
      30.416666666666668`, -15.633333333333333`}, {
      33.21666666666667, -14.016666666666666`}, {
      32.983333333333334`, -9.483333333333333}, {
      32.983333333333334`, -9.416666666666666}, {
      30.766666666666666`, -8.2}}}],
     "\"Zambia\""],
    Annotation[#, "Zambia", "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{31.3, -22.416666666666668`}, {
      29.366666666666667`, -22.183333333333334`}, {
      25.266666666666666`, -17.8}, {27.15, -17.8}, {
      30.416666666666668`, -15.633333333333333`}, {
      32.983333333333334`, -16.716666666666665`}, {
      33.03333333333333, -20.03333333333333}, {31.3, -22.416666666666668`}}}],
     
     "\"Zimbabwe\""],
    Annotation[#, "Zimbabwe", "Tooltip"]& ]}]], "Output",
 ImageSize->{304, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[1]=",
 CellID->245756342]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29158814],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<Japan\>\"", ",", "\"\<CurrencyCode\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->641061775],

Cell[BoxData["\<\"JPY\"\>"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10191095]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FinancialData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FinancialData"]], "InlineFormula"],
 " gives the current exchange rate:"
}], "ExampleText",
 CellID->700771465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FinancialData", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<USD\>\"", ",", "\"\<JPY\>\""}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->599169367],

Cell[BoxData["118.73`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1347394167]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CountryData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CountryData"]], "InlineFormula"],
 " gives the most recent historical yearly exchange rate:"
}], "ExampleText",
 CellID->40708873],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountryData", "[", 
  RowBox[{"\"\<Japan\>\"", ",", "\"\<ExchangeRate\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->694772791],

Cell[BoxData["110.218211666667`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->324366435]
}, Open  ]],

Cell["Show yearly time series:", "ExampleText",
 CellID->241927134],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{"CountryData", "[", 
   RowBox[{"\"\<Japan\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<ExchangeRate\>\"", ",", "All"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->12341730],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW89v3EQUnuxu4t1kk02TVqVJVC1UbSUKfwLigPhxQQhpEVeWCqk9QKvS
A8cVt1ZwRkgcEBT/A0RwQhyQLJAiceWGhP8IjsaeGdsz3m/sNzN2uqGJlHj3
7fi9b7733szzm83b84d3Pvp4/vDu7fn0zQfz+3fu3v50+sa9B6mov8YYO05/
P5+y7HWSvpR/jlmSJNmH6mXML0MWLZj4mYUsTiVxOFPf9/iwfvo3YmEY83e5
LL91lsoPuWyvSR0flSQxy8WMLVgk5Yq+Iy7YJqmryhC8Ay4blfpy49GSaXg/
ku2oRPblrMRs+rksDtlCYy0lPFSYyPQtIglhxsI4OTCq29bUqbdmDGSIgDrp
GDo8kw0N3n5pMo8LYJoq21aJHGlIRbhErHSbuKVAG4VCrWQh92dmJoWXo6Wo
5DKOLPtMyIBKSaiFzorMrHMv/Sws9KFxRFkDoaXvSi0FoUqeC1eRCEUqiwiq
5BmVUKQTycw69xSnYttEWQOhSIvIsaBId+Q6E5tInwglMSZaiKtNeFJnj3SK
1fhCkbAeoaknO8giJXhyeHEUKStmaFxHjNkOdGbL3KwaGMblk6jTIKvqvMLf
XVSyvVxxPNZRyewWv4xZucuqa5Sy88q7ORMsXQCyn3VtAvruuU9XqcqUnXq5
YNhx07mIzJv8QFt1Uzl1P6/Z42EFpV+ytSb5LhG3jrTpmihABgdiDqJwE/dk
r4diqCpmG0RZ4HHv6ckCTZb+fvbD