(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     83925,       2110]
NotebookOptionsPosition[     75246,       1822]
NotebookOutlinePosition[     77990,       1898]
CellTagsIndexPosition[     77870,       1892]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MessageDialog" :> 
          Documentation`HelpLookup["paclet:ref/MessageDialog"], 
          "ChoiceDialog" :> 
          Documentation`HelpLookup["paclet:ref/ChoiceDialog"], "DialogInput" :> 
          Documentation`HelpLookup["paclet:ref/DialogInput"], "CreatePalette" :> 
          Documentation`HelpLookup["paclet:ref/CreatePalette"], "Button" :> 
          Documentation`HelpLookup["paclet:ref/Button"], "DefaultButton" :> 
          Documentation`HelpLookup["paclet:ref/DefaultButton"], 
          "CancelButton" :> 
          Documentation`HelpLookup["paclet:ref/CancelButton"], "DialogReturn" :> 
          Documentation`HelpLookup["paclet:ref/DialogReturn"], 
          "CreateDocument" :> 
          Documentation`HelpLookup["paclet:ref/CreateDocument"], 
          "CreateWindow" :> 
          Documentation`HelpLookup["paclet:ref/CreateWindow"], 
          "NotebookClose" :> 
          Documentation`HelpLookup["paclet:ref/NotebookClose"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MessageDialog\"\>", 
       2->"\<\"ChoiceDialog\"\>", 3->"\<\"DialogInput\"\>", 
       4->"\<\"CreatePalette\"\>", 5->"\<\"Button\"\>", 
       6->"\<\"DefaultButton\"\>", 7->"\<\"CancelButton\"\>", 
       8->"\<\"DialogReturn\"\>", 9->"\<\"CreateDocument\"\>", 
       10->"\<\"CreateWindow\"\>", 
       11->"\<\"NotebookClose\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], "Dialog Boxes" :> 
          Documentation`HelpLookup["paclet:guide/DialogBoxes"], 
          "Stand-Alone Interfaces" :> 
          Documentation`HelpLookup["paclet:guide/StandAloneInterfaces"], 
          "New in 6.0: Dynamic Interactivity" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DynamicInteractivity"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Custom Interface Construction\"\>", 
       2->"\<\"Dialog Boxes\"\>", 3->"\<\"Stand-Alone Interfaces\"\>", 
       4->"\<\"New in 6.0: Dynamic Interactivity\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["CreateDialog", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CreateDialog",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CreateDialog"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]creates a dialog notebook containing ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", and opens it in the front end."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CreateDialog",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CreateDialog"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["obj", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]replaces the notebook represented by the notebook \
object ",
     Cell[BoxData[
      StyleBox["obj", "TI"]], "InlineFormula"],
     " with the one obtained from ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->3925]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CreateDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateDialog"]], "InlineFormula"],
 " by default creates a notebook with options set so as to be suitable for \
the appearance and behavior of a typical dialog box. The option settings \
include ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Deployed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Deployed"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"ShowCellBracket", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WindowFloating",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowFloating"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WindowSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowSize"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->558],

Cell[TextData[{
 "Dialog notebooks created by ",
 Cell[BoxData[
  ButtonBox["CreateDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateDialog"]], "InlineFormula"],
 " are by default opened in the middle of the main display screen. Explicit \
settings for ",
 Cell[BoxData[
  ButtonBox["WindowMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowMargins"]], "InlineFormula"],
 " override this."
}], "Notes",
 CellID->6914],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CreateDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDialog"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " by default puts ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " into a single output cell."
}], "Notes",
 CellID->23130],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is a complete notebook expression, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CreateDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDialog"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " creates an open notebook corresponding to this expression."
}], "Notes",
 CellID->9479],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is a cell or list of cells, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CreateDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDialog"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " creates a notebook consisting of this cell or cells. "
}], "Notes",
 CellID->30803],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CreateDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateDialog"]], "InlineFormula"],
 " can take any notebook option."
}], "Notes",
 CellID->27000],

Cell[TextData[{
 "The additional option ",
 Cell[BoxData[
  ButtonBox["Modal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Modal"]], "InlineFormula"],
 " specifies whether the dialog created by ",
 Cell[BoxData[
  ButtonBox["CreateDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateDialog"]], "InlineFormula"],
 " should be modal."
}], "Notes",
 CellID->15651],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Modal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Modal"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", other windows can be used even when the dialog is open. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Modal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Modal"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", no other ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " windows can be used until the dialog has been closed. If there is no \
mechanism for closing the dialog, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will effectively freeze. "
}], "Notes",
 CellID->17554],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["DialogReturn",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DialogReturn"]], "InlineFormula"],
 " is executed, for example as a result of clicking a button, within the \
window created by ",
 Cell[BoxData[
  ButtonBox["CreateDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateDialog"]], "InlineFormula"],
 ", then the window will be closed."
}], "Notes",
 CellID->320309385],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CreateDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateDialog"]], "InlineFormula"],
 " returns a ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 " corresponding to the notebook it creates. "
}], "Notes",
 CellID->15399],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CreateDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDialog"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["obj", "TI"]}], "]"}]], "InlineFormula"],
 " overwrites whatever data was contained in the notebook represented by the \
notebook object ",
 Cell[BoxData[
  StyleBox["obj", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28785]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->162957361],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->136093556],

Cell["Make a dialog notebook:", "ExampleText",
 CellID->109343385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDialog", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"TextCell", "[", "\"\<Click OK to close\>\"", "]"}], ",", 
     RowBox[{"DefaultButton", "[", "]"}]}], "}"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->185067965],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnFtPG0cUgJH6H/rehyh/ok9tX2mkKspDKzUQFQiNoqhVH1pVyUMUkiY0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   "], {{0, 0}, {125, 86}}, {0, 255}],
  ImageSize->{125 0.75, 86 0.75},
  PlotRange->{{0, 125}, {0, 86}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->412509200]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15798136],

Cell["Make a dialog notebook that accepts input text:", "ExampleText",
 CellID->595373735],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDialog", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"TextCell", "[", "\"\<Enter a name: \>\"", "]"}], ",", 
     RowBox[{"InputField", "[", 
      RowBox[{
       RowBox[{"Dynamic", "[", "nm", "]"}], ",", "String"}], "]"}], ",", 
     RowBox[{"DefaultButton", "[", 
      RowBox[{"DialogReturn", "[", 
       RowBox[{"ret", "=", "nm"}], "]"}], "]"}]}], "}"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26253835],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnd1PG2cWh5H6P+x9L6r+E3vV9jattKp6sSu1ISqk2aqqdtWVWlXbiyik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   "], {{0, 0}, {194, 117}}, {0, 255}],
  ImageSize->{194 0.75, 117 0.75},
  PlotRange->{{0, 194}, {0, 117}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->540346907]
}, Open  ]],

Cell["Type something in the input field:", "ExampleText",
 CellID->487644555],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztne9PW9cZx5H2P+z9XlT9J/Zq29us0lT1xSatIRqkWVVVmzZp07S+iEK6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   "], {{0, 0}, {194, 117}}, {0, 255}],
  ImageSize->{194 0.75, 117 0.75},
  PlotRange->{{0, 194}, {0, 117}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->571871010],

Cell[TextData[{
 "Click ",
 StyleBox["OK", "DialogElementName"],
 " to assign the input to ",
 Cell[BoxData["ret"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->240822304],

Cell[CellGroupData[{

Cell[BoxData["ret"], "Input",
 CellLabel->"In[2]:=",
 CellID->410771003],

Cell[BoxData["\<\"Edison\"\>"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->257123932]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->305414307],

Cell[TextData[{
 "Put up a dialog window for setting a value for ",
 Cell[BoxData["u"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->317667033],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDialog", "[", 
   RowBox[{"Manipulate", "[", 
    RowBox[{
     RowBox[{"Button", "[", 
      RowBox[{"\"\<press me\>\"", ",", 
       RowBox[{"u", "=", "x"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25570],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnOtPW+cdxz3t5d7vxZq026T+F3u1VVVUqas0daq0SmsgDSTb2q7V1O1N
oqlLShOWqORCAgFCGCENuRBIcbJkXMLFMTaYiw3YhFswuXK1wVxNnv2OH/tw
4mOeUMLBT3y+X31y9Ps95zlHB/v5cGwj5xfpn/0u/ccWiyWb/v3kRxaLUmdk
7AcACFgOrwAA9KiCfHfxNgBAS5wgSb+RASAPCQUZHvIDADJi7zvWKYjfPwRA
6rFZgvh87g5XHQApgKezwdd71z/csYmC5JwpACA1yC0uLi4vVxzZVEEYgqRK
yBG6j2y6IOHwMwBedWgl03qm11oQBAA9EAQAARAEAAEQBAABRgvicDiT9NkD
gmw8tG4hCIKsFQiCIIJAEAQRBIIgiCAQBEEEgSAIIggEQRBBIAiCCAJBEEQQ
CIIggkAQBBEEgiCIIBAEQQSRU5Dl5aXFhZl/Flx784MDll/9TR5++u7+T49e
WFoKGfV8IJJFTkHmQzN7DpW+8/nxqppGW3OvPNTbmnd8+u1fjpQZ9XwgkkVO
QWaDU/S7uu6uI+lG6LHW1NC1GfV8IJJFTkFmApP0eoaKttYh2aCr4teGmCGS
C9LVOSobDIKYKZIL0tP7iGOxWNQ6uTAIYqZILoiv7xGHBFHr5MIgiJnyCgmi
JqEy+r2CVu9dwiLhIQyCmCmSCzI4NM6hhRpX60f09frbuEJwQgZBzBTJBfE/
mObQKo2r9SN6+C1grVZ7YFyx1gkJBkHMFMkFeTIW4tCKjavjRrRRR+ImqK3+
tHGF/oQqDIKYKZILMh0Ic2iVxtV86Qr2qiP6Vj8eV+hPqMIgiJkiuSCzoRWO
9ve5OqJutRP0h6w1IW5QfLgKgyBmiuSCzM2vyAaDIGaK5IIshFdkg0EQM0Vy
QVbkC4MgZgoE+aFhEMRMkVOQ4PQ4BEFkiJyC0B3kzQ8O1Ln6jfqxXyJ1rnt0
bcm+CmSLIq0g+/Ku/n5fSX37gFE/+YbSPfSYrmp/XkU4vJzsa0G2InIKEpoJ
BKcekyMSfid97+HS2eDY0uK8UU8JIlPkFIR+PyuOTI8HpsY2hbHHIy+Deh66
JLq70bXhDmKSyCkIgkgSCIIggkAQBBEEgiCIIBAEQQSBIAgiCARBEEEgCIII
AkEQRBAIgiCCQBAEEQSCIIggEARBBNlKQQB4FdkaQQB4pYEgAAiAIAAIgCAA
CIAgAAiAIAAIkFCQYOBRVn7ZvqN5f//mmJZ/HDr+xb+O0N6kP2jAPEgoyNmq
2l0VX75+adu2wp+9lh/jjLJ9N+tDciTpDxowDxIKUlFnf9vx1i9rf/5GxfY3
rsa4sn37udfIEbqPJP1BA+ZBQkGqm9o87vt0hkAgcP/+GNUez7DN1kXcsDbR
a62kP2jAPEAQAARAEAAEQBAABEAQAARAEAAEbLEgFoslrtDzQkEM+5YMkppZ
WJgNzU5q19j3iSKDIFwNgR3rEWR6YhiA9TM/F1hamk8oCK2x1BMkGHgCwPqZ
CT599uwZBAEgIQnvIIHnI4kgm/IepLAgD4D1s9Z7EKvVKuEd5IXgUyxgNDK/
xHohEAQYjf4jrOrq6oQzIQgAAiAIAAIgCAACIAgAAiQUxNrc9teezz52p7/j
3LHD+TaHf8fw9Uvb9h3NS/qDBsyDhILUOt1lXZXkSKYnI8Ozm7PLnU6O7Kr4
Miu/LOkPGjAPEgoSDDwiR+g+Qq+1tFTU2c9W1eJ/NQFbiYSCALCVjIz4W1vb
bkdCBbXavRAEmBmv16f/oyENqhMgCDAtdLNQpZiORG3V+wgEAaaFXlCtJQjt
4nMgCDAt9KZDVUMbGqRdfA4EAaYFggAgAC+xABCAN+kAiMHHvACIwR8KAdgw
EAQAARAEAAEQBAABxgmCIKkRIwQBIJUgOzZREABMBQQBQAAEAUAABAFAAAQB
QAAEAUAABAFAAAQBQIBWkD9/kj3QP1x53X44uxQAwFleWrbZez//IifjkyMk
COHzDQIAOFpBfF4/YysrK2EAAPFsJawVpKd7ZHk5HJpbIOYiROsQbRfVNhSK
TqBBdbJaa5lDi9bY9gcvy9MFFwvf/3XZe785/95bemic9tIcfuDCwmIotKgK
0tU5FAiGxicC4xPTkW0gVk/H15PaCep8dTD4/F60aI1oN7Isq97/bfj4CVZc
woqKElBcQntpDj9wYlI5RBWkvb3/4eOJkdGxEf+TEf9TBV6Pcp5G8Udqv4bo
rifK/FF1ZCxaoEVrSLuRZXkvM41Zq1lF+ZpYq2kOP9b/YMw/Oq4K4mzt6x96
6Lvnj6MvWoyuDvY93yr1iGbOSN9zZ0CL1ojWr1lyEdaxLPsy0lhVJbt0Ifqd
ECo4altVSXMih4z29Y/eG3ioCmJv8bq7hzrdA0SHJ7J1r261RSIG1Tna+WjR
GtR2atr1L8t4QSiXNXVMEH5Ul2fA03NfFYQKp8vraOttaet1tPa2tHrtTm+L
UlBLhZdvIyNU9zr4XqcyoaXNGy1aI8dGajtatAa23g0sy76MnayqgpWfV4hL
2Vl2vohdvUiCtPBztnldHf2qIM227iabu1Ghq7G5Syma3Q02XtCIsquBT2iO
bWM0RNuu2ARlfgNatMa1zRtZlr6PP1LUKDnDSvLZubxVO4pyWeEJduYYOeLb
/VHskC67w1t3p5ML0mTrrq1vV6m5EynuuCKtsq2pd2knRKfF9vJpNc+NoEVr
VLuxZakIUlrI8nLY6Zz4O8jxI+zYv1lhHgminqfJ5vneaueCNDZ7bt5q+e9t
RwRnrFC4qeCMDt5SaqW95Yzsolqd74zNdKBFa3S7gWXp272TFeWFv81WtVg8
ulrPHcpip0727d55ky/7W476ho7vymujgjR5rltt1TfsL8FdzTZuEC3azW3X
z+qyVN6DnDoZzPqaGzH7zdfBCLydOniQnTxBc9Rja+pcBUXXY4J0V1Terbxu
ByBVGdiTxnJzx7/6aurgAT00zk7lDmTu5JOvVdlv/a8953h5VJDGnsuXmq5e
sQGQqrj2/oHln2KniNwE5Oay/ILWP/2RT75y2XbD6jqcXcoFqa93l5yrKSut
AyBVOV1wsX33h4N70/sz0/QM7klzZabRHD75/H9qr1XYIQgACYEgAAiAIAAI
iBOkodFdWlJzoawOAECUna+tqlwVxD86OTD4dGDwCQCA8+DBtCoIACAhJMj/
Aac3hMU=
   "], {{0, 0}, {267, 139}}, {0, 255}],
  ImageSize->{267 0.75, 139 0.75},
  PlotRange->{{0, 267}, {0, 139}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->617831601]
}, Open  ]],

Cell[TextData[{
 "Moving the slider changes the value of the  ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " variable ",
 Cell[BoxData["x"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->52395030],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnO1TU1cex7OzL/t+X2y13d2Z/hf7arfTcTrT7cxOdzqznWlFC2h32247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   "], {{0, 0}, {267, 139}}, {0, 255}],
  ImageSize->{267 0.75, 139 0.75},
  PlotRange->{{0, 267}, {0, 139}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->285478700],

Cell[TextData[{
 "Click the button to set ",
 Cell[BoxData["u"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->226165258],

Cell[CellGroupData[{

Cell[BoxData["u"], "Input",
 CellLabel->"In[2]:=",
 CellID->181419638],

Cell[BoxData["0.632`"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->534227173]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->310675506],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->296060475],

Cell["Choose a background:", "ExampleText",
 CellID->29097309],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDialog", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"TextCell", "[", "\"\<Click OK to close\>\"", "]"}], ",", 
      RowBox[{"DefaultButton", "[", "]"}]}], "}"}], ",", 
    RowBox[{"Background", "\[Rule]", "LightBlue"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->96578406],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnFtPG0cUgJH6H/peKVL+RJ/avtJIVZRIrdRAFCA0iqpWfWhVJQ9RyI0Q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   "], {{0, 0}, {125, 86}}, {0, 255}],
  ImageSize->{125 0.75, 86 0.75},
  PlotRange->{{0, 125}, {0, 86}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->276609187]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Enabled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->89041805],

Cell["Create a dialog with user interactivity disabled:", "ExampleText",
 CellID->780561652],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDialog", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"TextCell", "[", "\"\<x\>\"", "]"}], ",", 
       RowBox[{"Slider", "[", 
        RowBox[{
         RowBox[{"Dynamic", "[", "x", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->424160803],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3ftPU2ccx3GT/SX7V7b9PJPF7Ict2cAM0C1m2f6A/WCmbjKX4aWIAlMG
KDeBMm7l0lLacnqhQC/QVgrYVh1XaaUIcnn2nJ72aamY0Q7KNyef5sXJ9znn
OSRN3jkUo/HD899/dv6DM2fOfM6/FviXPJeW/gRA2c7uHgBBos/HTQMApGT1
eeqPcQDh0D4X5sOHikVfSuZuo75DP9iWZbC/hV99340AeShNfeY8Yp9TTr1t
TGcY1g70t+n6WoX+3hZdbzNP9NTfEahJrn16XSanwyBZ+o2GLmFE3zU48IQn
yp+ip/6OQE1y7XPaY3mzuboZX4lvLAkbrxeXl56FQ370Cccrrz7XsvrkVpZD
6BOO3TH2GQmjTzhmeH4CZegTKEOfQNmx98nwwiuX19bWRnxjrWB9rq8uABzd
m83o27dvCtZnLLoIcHSvY0v7+/voE2gq8POzproK4OgK/PnztH7RA1VCn0AZ
+gTK0CdQhj6BMvz9JaAs1z5nPGNu15hr0ux0jDgdBkGy9BuGtUZ9x6m/I1CT
XPv0T9t8Xruc6JTFNSnwXA22MZ1k7j71dwRqkmufsehLnih/ivIf9Jm8LtOU
U49/vwnHK9c+AQoJfQJl6BMoQ59AGfoEytAnUIY+gTL0CZShT6AMfQJl6BMo
Q59AGfoEytAnUIY+gTL0CZShT6AMfQJlufYp/3eyh80AJyGP56eSJeKEAsjv
5zvihMJAn0AZfr4DZfj9CCjDny8BZegTKEOfQBn6BMrQJ1CGPoEy9AmUoU+g
DH0CZegTKEOfQBn6BMrQJ1CW2ed3l8qDswudXdL18noAInbe7likmR9+rCi9
dIP3yfn9cwBEZPbp94UZ29vb2wWgYH9vN7PPaW9oZ2c3vrnFbSYk5zg/botl
PJ7cwE+KzWLOtImlqpd5VHG3uqnm3EeNZz9uOPvJu/h5fpXvUW7c2tqOx7dF
n66p+WgsvrIaXVldTxyjqXk9e17L3CD2i5Oxg1exVOUynyq05z7dvXWbPahj
tbWHeFDHr/I9yo2ra/Itos+JidkX/6yGIsuh8GIovCRT5ohiKSmcmMMZkpcW
5f0RcWY5OWCpymU4nyqelhWznm7W3vxePd18j3Jv+PlyOLIi+rQ7ArPzL/xP
w1kCySGSPhk4uJTnUMaeUODAd8BSxcvcqgiUFjNtJ2t5xJQXHxRiqe3kexK3
RAKzkafBF6JPyepze+en3EFu0pM4utPHzOEwc2JP5n4sVbzMo4rsPvmrNWNO
9anc5fIEPdPPRJ98sDt9tvEZ6/iMzTFjdfgku88qD3zJB59yTJzh84xNuWqX
N1jHfcnBkbg3MUtYqndpS/WQUxWB0iKmbWfNDbKsV+OfrKGWPWnifVqV7znu
c07Oij7NFq/J4h6VuUbNLnkwu40WZeBn5EtGZYM5dUwxJpeu1AZ5vxFLVS/z
qML/zddymXX3Wd099rAqHWethtXcZvdv8kT9JV+nbnFJNp9+ZErp02TxDhsm
hKGRxDDiTCzl45DBmbkhuS11Vdk2dOAMlipf5lqF3Gd9DauqYHcrsp+ft26w
m7+xmirep/g+Jovn7x5J6XPU7OnTWfsHbAn21CDrk9mTJ3XyLC919sQlPov9
9tROG5bqXval5xyq8JcUsdqq3T/KRZXbv6fnzV+vsco7gZKiPqU6nc1gnHzc
PJzs0+Tp6rF090r/w1jGMesklmpd/qd0FfLnz8o7sWtXlSA3frkaS1CWr65c
YXdu8z3i3iG9s7q2K9Wnt71zrLNLAjghwQvFTKNZuXz51ZWf38XPs0pNsKxI
2dyhlXSDExW3mpN9jk63tpietFkATojz4hfsXiWr5DSH0GjYvWrHt18pm9ta
Lb09zuvl9UqfBoO77uFQY70e4ITcrW6aKPly7uL52bLid81dKHaWFfM9yuaG
v4Y72iX0CTShT6AMfQJlWX0aR931dUOPGvUAFDQ2DGs7032GI2vBuaXg3CIA
Ec+fr4s+AWjiff4LpV6sRw==
   "], {{0, 0}, {224, 86}}, {0, 255}],
  ImageSize->{224 0.75, 86 0.75},
  PlotRange->{{0, 224}, {0, 86}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->572061553]
}, Open  ]],

Cell["Enable user interactivity:", "ExampleText",
 CellID->190359599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"nb", ",", 
    RowBox[{"Enabled", "\[Rule]", "True"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->73474398],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3ftPU2ccx3GT/Rfztu1P2YwxSzaTxeyHmUxAKbrFuPmD2y/uBzdFZZoh
WiwCKoMqoNaWURmOglBqL1C0LdBWyq1Vx1XaWQS5PHtOT89pqZjRTug3J5/m
xcn3Oec5TZq80xaj8cO8I1/kvbdp06Yv+c8w/xFmleonAMoWFpcACJL7vFl7
H4CUlD6z/jYOIFu1z+Gh4Koi4eeFZdrj5zU/nL6Q7MczJUd/Psevvu1GgAyo
pO+ca+zzqsG0X3dsW/2WLRXvby6TXBGOnxXu5Ylm/RWBkqTbp67VutO+4yPT
B9t1W7ffkdzeuvX6Zp4ofxfN+isCJUm3z0Zzt8c9whgLh8MjIxN89niGLRYX
d89o5h/0WX9FoCToEyhDn0AZ+gTK0CdQhj6BsnfeJ8MDj3Qec3Mvoy+nN6zP
malhgLV7NRt+/frVhvUZCY8BrN0/kfHl5WX0CTRt8PtnRbkGYO02+Ptntn7R
A0VCn0AZ+gTK0CdQhj6BMvQJlKXbp7Gz+7u+IwfceZ86du1y7BSJf6N+W/2W
4+c1WX9FoCTp9mlyuLUuPU+0wKNSefJF+915PNH9umOFZdqsvyJQknT7jISf
80T5uyj/oE+ma7VeNZjw7zfh3Uq3T4CNhD6BMvQJlKFPoAx9AmXoEyhDn0AZ
+gTK0CdQhj6BMvQJlKFPoAx9AmXoEyhDn0AZ+gTK0CdQhj6BsnT7FP472dVm
gPWQwfunmCXihA2Q2ec74oSNgT6BMny+A2X4/Qgow58vAWXoEyhDn0AZ+gTK
0CdQhj6BMvQJlKFPoAx9AmXoEyhDn0AZ+gTK0CdQltznt4eLAgPD+gbr2aJq
ACIWXi9YrP3fHy1WHT7H++R8vkEAIpL79HmDjC0tLS0CULC8tJjcZ1/v6MLC
YnR2jpuNic9RfpyXl9FofAM/KW+W52SzWCp6mUEVl8trK/Z8rN39Sc3uHW/i
5/lVvke8cW5uPhqdl/t0PR4KR6KTU+HJqZnYMSzNM6nzdPIGeb98MrLyKpaK
XGZShWHP54slF9m1KlZZuYprVfwq3yPeODUt3CL32dMz8OzvqdHQxGhwbDQ4
LhDnkGg8Lhibg0nil8aE/SH5zER8wFKRy2AmVTwpyGXGRqareytjI98j3ht8
OhEMTcp9Orr8A0PPfE+CKfzxIZQ46V+5FObRpD2j/hXPgKWCl+lV4VflMoOe
1d9g4oMPInlp0PM9sVtC/oHQk8AzuU+rzevuHXrsDnCPPLGjO3FMHlYzKO9J
3o+lgpcZVJHaJ3/cSpqlPsW7XJ6Ap29E7pMPDqfX3t1v6+63d/XburxWh9cm
DHzJB694jJ3hc79dvOoQNti6vfGhK3ZvbLZiqdylXeohrSr8qhxm0LG6GkHK
Q3uV1VSyO7W8T5v4nN1e56MBuc9OS6/Z4u4QuDo6XcLQ6W63iAM/I1xqFzd0
SkdJe3zpkjYI+9uxVPQygyp8B/YJZVZdYVVl7LomEWelmlVcZFcu8ER9+fuk
W1xWu7f1wWOxT7Ol19TWI2t5EBseOGNL4djS5kzeEN8mXRW3taw4g6XCl+lW
IfRZXcE0xexycer7Z8k5duFXVqHhfcrPY7Z4/jBaxT47Oj1NzbY/79tjHNIg
aBI44iebhVlYNjtil/gs73dIO+1YKnvZlJjTqMKXn8MqNYu/FclVzp9PzLNn
ClnpJX9+TpNYXbO9rf3RzTpTvE+zp8Foabxn/R8eJh1TTmKp1OV/SlQhfP8s
vRQpPCUG+fL0qUiMuHxx8iS7dJHvke9taXWWVzZIffbq9A/1DVaAdRI4mMvU
6skTJ16c/OVN/DwrVQcKcsTNdw3W5r96ikvq4n129N2qN9+5bQFYJ85DX7Gy
UlbKqVehVrOy8q5vvhY3375luWd0ni2qFvtsa3NXXW/RVrcCrJPL5bU9+XsH
D+UNFOS+afBgrrMgl+8RN9f8brqrs6JPoAl9AmXoEyhL6bO9w11d1XJD2wpA
gbbGZNAn+gyGpgOD44HBMQAinj6dkfsEoIn3+S/FsEsc
   "], {{0, 0}, {224, 86}}, {0, 255}],
  ImageSize->{224 0.75, 86 0.75},
  PlotRange->{{0, 224}, {0, 86}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->44603463]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WindowMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->67592653],

Cell["Place a dialog window at the upper left of the screen:", "ExampleText",
 CellID->21638260],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDialog", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"TextCell", "[", "\"\<Click OK to close\>\"", "]"}], ",", 
      RowBox[{"DefaultButton", "[", "]"}]}], "}"}], ",", 
    RowBox[{"WindowMargins", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "Automatic"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "0"}], "}"}]}], "}"}]}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22710130],

Cell[BoxData[Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
  ImageSize->{555, 235},
  ImageMargins->0]], "NotebookImage",
 CellID->88145605]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WindowTitle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->34671842],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDialog", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"TextCell", "[", "\"\<Click OK to close\>\"", "]"}], ",", 
      RowBox[{"DefaultButton", "[", "]"}]}], "}"}], ",", 
    RowBox[{"WindowTitle", "\[Rule]", "\"\<Success\>\""}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->151456006],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnEtPW0cUgJG6r7Lqvosof6KrtltaqYqyaKUGogJJo6hq1UWrKllEIWlC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   "], {{0, 0}, {125, 86}}, {0, 255}],
  ImageSize->{125 0.75, 86 0.75},
  PlotRange->{{0, 125}, {0, 86}}]], "NotebookImage",
 CellID->89283674]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5775],

Cell["Create a dialog window for manipulating a graphics object:", \
"ExampleText",
 CellID->187291157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDialog", "[", 
   RowBox[{"DynamicModule", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "=", "\"\<\[EmptyCircle]\>\""}], ",", 
       RowBox[{"ctr", "=", 
        RowBox[{"{", 
         RowBox[{".5", ",", ".5"}], "}"}]}]}], "}"}], ",", 
     RowBox[{"Column", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"SetterBar", "[", 
         RowBox[{
          RowBox[{"Dynamic", "[", "a", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{
           "\"\<\[EmptyCircle]\>\"", ",", "\"\<\[FilledCircle]\>\"", ",", 
            "\"\<\[EmptySquare]\>\"", ",", "\"\<\[FilledSquare]\>\""}], 
           "}"}]}], "]"}], ",", 
        RowBox[{"Slider2D", "[", 
         RowBox[{"Dynamic", "[", "ctr", "]"}], "]"}], ",", 
        RowBox[{"Dynamic", "[", 
         RowBox[{"Graphics", "[", 
          RowBox[{
           RowBox[{"Text", "[", 
            RowBox[{"a", ",", "ctr"}], "]"}], ",", 
           RowBox[{"ImageSize", "\[Rule]", "140"}], ",", 
           RowBox[{"Background", "\[Rule]", "White"}], ",", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "1"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}], "]"}], ",",
         
        RowBox[{"DefaultButton", "[", "]"}]}], "}"}], "]"}]}], "]"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57069151],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt2v1vG/UdB/Cb9ifsUUhI2w8TP7BpGtI2aTANjU3ahjrGhNgACVq0lhWG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   "], {{0, 0}, {164, 309}}, {0, 255}],
  ImageSize->{164 0.75, 309 0.75},
  PlotRange->{{0, 164}, {0, 309}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->58907239]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7072],

Cell[TextData[{
 "Create a dialog that blocks kernel evaluations using ",
 Cell[BoxData[
  ButtonBox["DialogInput",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DialogInput"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1239382971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDialog", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"TextCell", "[", "\"\<Click OK to close\>\"", "]"}], ",", 
     RowBox[{"DefaultButton", "[", "]"}]}], "}"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1476997054],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnFtPG0cUgJH6H/rehyh/ok9tX2mkKspDKzUQFQiNoqhVH1pVyUMUkiY0
UUm4JkADwSQQCDG3UAh3cIwNBmyDL/gC+MIdbMM6UEynZ3fsYVnbxF5qm63H
+lidmTln1ufzeIWExCeXrn116aOMjIwL8HMdftg4N/cGJSXsBw4oyYRof9HQ
Q0kOAu0p/9KlAxG1z9sdEVmYd7pdy+trmx6Pz+fb2d6OzO77XQGhJWZnh2EY
/84243IuR7vL/x7yPI9Ru9Vidy7O/1rWdObCrYxPfxLBx5k3rhTKvN4Nn3c7
5e1LRbvZaMopqDmbWZB5fTD/5qY4oDz/3rOtLW/K25eKduPMLBzXu83OEwKb
rK1upLx96WifgQcFeEMITYzbRQCFUA6bLC+tprx9aWkv5LRrp50igMLCFhds
suReSXn70tL+oMUN9mYNSyKAwvtUuyjtRXLWnsm8JAIoLJK7qXYR2ovblwXa
M0Iv/kzEGApL2pepdhHay7tWwZ7Nvo4Bq+FxeICBwvKuFapdhPbKHla7w+UB
wCoOCHiGf+UDhZU9a1S7CO1P+9hDu7LGACAWBwQ8g585giUACmv61ql2Edpl
gxtgz+MNAOAWBwQ8g7ULlgAolA1tUu0itDeMboG9HeYAALc4IOAZ/pUPFEI5
1S5Ce7OSfUT73x9gwG14HB5goLDpnYdqF6FdrvaBvd3AAYH8AsmfiRhDoXzc
R7WL0N4+sQ32DkS9oLBDs021i9D+ZmrnJNq7phjYxE21x6zdoNeBsW4dcxLt
3To/bOJy0b8uxXHaz1y49VbvPyGwycKCM+XtS0j7z8UNZzMLNEtINFD+S3Gj
zTqf8valot00a7TPGcD8Sf6Wmnu7Zt5mssxZUt6+VLTDEQXz8ISf1R2HVqMW
QJagFr4ysAk97bFrp1Dt0oVqp9rTB6qdak8fqHaqPX2g2qn29IFqp9rTB6qd
ak8fqHaqPX2g2qn29EGc9gzeCw/Jlb/KnxTE4ZnhOdHyo9VG3DZafsRbR9vw
NGiPaCNcviA5WlW0tBjzj7lj+HsTl3AatEc7XcdrP97hBzdJnPaI38okkATt
H3Qo2CSagf9We7QnTHKeM6fwtCdNeyybS0X7PO/kCCZj1H7MXfgfyjEnM9ob
iHbCP7hhyrUfYyz2jyl8KfzTiesucb3b00AifoGMveuIJzBaLdUee2sp7zrl
byBx2ilUuySg2qn29IFqp9rTB6qdak8fqHaqPX3ga79ytdBqmZe3Ke8V1lES
zf7f+wql4Ycfi3Kv3gftgMlkoyQavnaT0cH9L4EAJaH8cxDga5+dWdzfDzD+
XcDPEYwZuO6RIcMEE2CSJJOYj1+CQ464my2vbKg6/1n9uc9l574IB+ZhFXJw
4e7uHsPsEe3aabvXx6xveNc3PNzVG4o9wniTn0DyyaTv6Kq0hmKabT3/ZeBR
MXpai6qrI/C0FlYhBxdubLIlRPvkpMW9vLHoXFt0rCw6Vllw7MSsBnFwsYNH
cGmFzXeSmbVgILGhmGbn8rJRZwdqaYxKZwfk4FqHa83hXCfa1eNmi91tmnMI
MAcD5+Gk+eiQjRd5OYvmIztIcRhfs+bcbNQqRy+fI/yCAEOGrXLI4UqcZotz
zuom2pVjRt2MfVpnBab03FV3eOUHkbCRHH6+5IbTvPnYmxVqZ/8VHS8OacdV
Wr1VP7tAtEOg1hhVE4axCYNq3DA2blSqjWNsAEMIjPjKzUBsUOFVNZswNmEM
BuNcLRcrJThUhdqMq1lzbhZqbUGNMhbBq/5PJKtGrxpA+xjec8KombIQ7aOK
mRGFbphFOzyqZYNR3ZACBzDDLg3hhNHQNcRQcKgNJbD5QxIc4i7ibdb03UVW
eO0TVPsY1VQcOq8uRVXF6MlDMG/KuRgq0SpVxv7Baax9RDHTNzBJ6B3kgkEN
N2SvvQMafkIwLbSK03qPzEhxKKZZVntdFaooQuVFwtP+6D56+DuqqgDtZJ8R
hb69U4m1D4/qu7rH/upRcahDAUsXizo42c3G7LBbzS1BTPLVoUyVRIddh8M4
mjXlZKHqisAfhUT23oPD2H/3DiorMedkdeFbdKsGhqZeNPYFtY/o2zoVHW+U
J+Ad7yqYlNYwvmbZZ3tZie/Obex557fbPg483CooQCXFkENqe/s1ldVtIe0z
LfJ38jYlJV6sl7NRaen6zZtbBbfCgXlUVmrNy8LJr1uV3W8nix41BrUPzza9
HHnVrKDEiyb/a/S4DJUBpREoLUWPK8e//xYnNzcp3nRq7hXWYe0DA7ramt76
un5KvJRXNkzmfGPLv2TJyw7Hdjlbk5cNOThZ9qzvdYuSak8yVDvVnj4ItA8N
6+pqe5/X91MSSr2sr1V+qN3h3LTaVq22FUqicbk8RDslyYD2fwE8Mmd8
   "], {{0, 0}, {125, 86}}, {0, 255}],
  ImageSize->{125 0.75, 86 0.75},
  PlotRange->{{0, 125}, {0, 86}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->1865701344]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DialogInput", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"TextCell", "[", "\"\<Click OK to close\>\"", "]"}], ",", 
    RowBox[{"DefaultButton", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1107242387],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnFtPG0cUgJH6H/rehyh/ok9tX2mkKspDKzUQFQiNoqhVH1pVyUMUkiY0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   "], {{0, 0}, {125, 86}}, {0, 255}],
  ImageSize->{125 0.75, 86 0.75},
  PlotRange->{{0, 125}, {0, 86}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->1433758761]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27829],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MessageDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MessageDialog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChoiceDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChoiceDialog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DialogInput",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DialogInput"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreatePalette",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreatePalette"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Button",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Button"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DefaultButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DefaultButton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CancelButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CancelButton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DialogReturn",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DialogReturn"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreateDocument",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDocument"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreateWindow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateWindow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookClose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookClose"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3243]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->312663076],

Cell[TextData[ButtonBox["Dialog Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DialogBoxes"]], "MoreAbout",
 CellID->102687903],

Cell[TextData[ButtonBox["Stand-Alone Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandAloneInterfaces"]], "MoreAbout",
 CellID->27726221],

Cell[TextData[ButtonBox["New in 6.0: Dynamic Interactivity",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DynamicInteractivity"]], "MoreAbout",
 CellID->325536602]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CreateDialog - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 35, 56.9419882}", "context" -> "System`", 
    "keywords" -> {
     "dialog box", "GUI dialog", "modal dialog ", "non-modal dialog ", 
      "interactive form", "input form", "input fields", "dialog form", 
      "user interaction"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CreateDialog[expr] creates a dialog notebook containing expr, and opens \
it in the front end. CreateDialog[expr, obj] replaces the notebook \
represented by the notebook object obj with the one obtained from expr.", 
    "synonyms" -> {"create dialog"}, "title" -> "CreateDialog", "type" -> 
    "Symbol", "uri" -> "ref/CreateDialog"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12230, 392, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->162957361]},
 "Notebook Image"->{
  Cell[13135, 428, 2666, 46, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->412509200],
  Cell[16536, 503, 2987, 52, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->540346907],
  Cell[19618, 561, 3109, 54, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->571871010],
  Cell[23984, 675, 3475, 60, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->617831601],
  Cell[27760, 750, 3572, 61, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->285478700],
  Cell[32692, 874, 2646, 46, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->276609187],
  Cell[36225, 957, 2268, 40, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->572061553],
  Cell[38793, 1013, 2287, 40, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->44603463],
  Cell[59170, 1431, 5454, 92, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->58907239],
  Cell[65455, 1560, 2667, 46, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->1865701344],
  Cell[68415, 1620, 2667, 46, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->1433758761]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 76556, 1851},
 {"Notebook Image", 76698, 1855}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2860, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3483, 87, 1577, 37, 70, "ObjectNameGrid"],
Cell[5063, 126, 1166, 36, 70, "Usage",
 CellID->3925]
}, Open  ]],
Cell[CellGroupData[{
Cell[6266, 167, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6744, 184, 1197, 42, 70, "Notes",
 CellID->558],
Cell[7944, 228, 445, 14, 70, "Notes",
 CellID->6914],
Cell[8392, 244, 338, 12, 70, "Notes",
 CellID->23130],
Cell[8733, 258, 396, 13, 70, "Notes",
 CellID->9479],
Cell[9132, 273, 385, 13, 70, "Notes",
 CellID->30803],
Cell[9520, 288, 205, 7, 70, "Notes",
 CellID->27000],
Cell[9728, 297, 378, 13, 70, "Notes",
 CellID->15651],
Cell[10109, 312, 831, 28, 70, "Notes",
 CellID->17554],
Cell[10943, 342, 443, 14, 70, "Notes",
 CellID->320309385],
Cell[11389, 358, 365, 12, 70, "Notes",
 CellID->15399],
Cell[11757, 372, 436, 15, 70, "Notes",
 CellID->28785]
}, Closed]],
Cell[CellGroupData[{
Cell[12230, 392, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->162957361],
Cell[CellGroupData[{
Cell[12615, 406, 148, 5, 70, "ExampleSection",
 CellID->136093556],
Cell[12766, 413, 66, 1, 70, "ExampleText",
 CellID->109343385],
Cell[CellGroupData[{
Cell[12857, 418, 275, 8, 70, "Input",
 CellID->185067965],
Cell[13135, 428, 2666, 46, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->412509200]
}, Open  ]],
Cell[15816, 477, 124, 3, 70, "ExampleDelimiter",
 CellID->15798136],
Cell[15943, 482, 90, 1, 70, "ExampleText",
 CellID->595373735],
Cell[CellGroupData[{
Cell[16058, 487, 475, 14, 70, "Input",
 CellID->26253835],
Cell[16536, 503, 2987, 52, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->540346907]
}, Open  ]],
Cell[19538, 558, 77, 1, 70, "ExampleText",
 CellID->487644555],
Cell[19618, 561, 3109, 54, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->571871010],
Cell[22730, 617, 177, 7, 70, "ExampleText",
 CellID->240822304],
Cell[CellGroupData[{
Cell[22932, 628, 72, 2, 70, "Input",
 CellID->410771003],
Cell[23007, 632, 171, 5, 36, "Output",
 CellID->257123932]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23227, 643, 220, 7, 70, "ExampleSection",
 CellID->305414307],
Cell[23450, 652, 149, 5, 70, "ExampleText",
 CellID->317667033],
Cell[CellGroupData[{
Cell[23624, 661, 357, 12, 70, "Input",
 CellID->25570],
Cell[23984, 675, 3475, 60, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->617831601]
}, Open  ]],
Cell[27474, 738, 283, 10, 70, "ExampleText",
 CellID->52395030],
Cell[27760, 750, 3572, 61, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->285478700],
Cell[31335, 813, 126, 5, 70, "ExampleText",
 CellID->226165258],
Cell[CellGroupData[{
Cell[31486, 822, 70, 2, 70, "Input",
 CellID->181419638],
Cell[31559, 826, 163, 5, 36, "Output",
 CellID->534227173]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31771, 837, 222, 7, 70, "ExampleSection",
 CellID->310675506],
Cell[CellGroupData[{
Cell[32018, 848, 231, 7, 70, "ExampleSubsection",
 CellID->296060475],
Cell[32252, 857, 62, 1, 70, "ExampleText",
 CellID->29097309],
Cell[CellGroupData[{
Cell[32339, 862, 350, 10, 70, "Input",
 CellID->96578406],
Cell[32692, 874, 2646, 46, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->276609187]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[35387, 926, 227, 7, 70, "ExampleSubsection",
 CellID->89041805],
Cell[35617, 935, 92, 1, 70, "ExampleText",
 CellID->780561652],
Cell[CellGroupData[{
Cell[35734, 940, 488, 15, 70, "Input",
 CellID->424160803],
Cell[36225, 957, 2268, 40, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->572061553]
}, Open  ]],
Cell[38508, 1000, 69, 1, 70, "ExampleText",
 CellID->190359599],
Cell[CellGroupData[{
Cell[38602, 1005, 188, 6, 70, "Input",
 CellID->73474398],
Cell[38793, 1013, 2287, 40, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->44603463]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[41129, 1059, 233, 7, 70, "ExampleSubsection",
 CellID->67592653],
Cell[41365, 1068, 96, 1, 70, "ExampleText",
 CellID->21638260],
Cell[CellGroupData[{
Cell[41486, 1073, 531, 17, 70, "Input",
 CellID->22710130],
Cell[42020, 1092, 11747, 195, 70, "NotebookImage",
 CellID->88145605]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[53816, 1293, 231, 7, 70, "ExampleSubsection",
 CellID->34671842],
Cell[CellGroupData[{
Cell[54072, 1304, 361, 11, 70, "Input",
 CellID->151456006],
Cell[54436, 1317, 2803, 48, 70, "NotebookImage",
 CellID->89283674]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[57300, 1372, 222, 7, 70, "ExampleSection",
 CellID->5775],
Cell[57525, 1381, 103, 2, 70, "ExampleText",
 CellID->187291157],
Cell[CellGroupData[{
Cell[57653, 1387, 1514, 42, 70, "Input",
 CellID->57069151],
Cell[59170, 1431, 5454, 92, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->58907239]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[64673, 1529, 232, 7, 70, "ExampleSection",
 CellID->7072],
Cell[64908, 1538, 243, 8, 70, "ExampleText",
 CellID->1239382971],
Cell[CellGroupData[{
Cell[65176, 1550, 276, 8, 70, "Input",
 CellID->1476997054],
Cell[65455, 1560, 2667, 46, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->1865701344]
}, Open  ]],
Cell[CellGroupData[{
Cell[68159, 1611, 253, 7, 70, "Input",
 CellID->1107242387],
Cell[68415, 1620, 2667, 46, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->1433758761]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[71143, 1673, 311, 9, 70, "SeeAlsoSection",
 CellID->27829],
Cell[71457, 1684, 2741, 98, 70, "SeeAlso",
 CellID->3243]
}, Open  ]],
Cell[CellGroupData[{
Cell[74235, 1787, 299, 8, 70, "MoreAboutSection"],
Cell[74537, 1797, 168, 3, 70, "MoreAbout",
 CellID->312663076],
Cell[74708, 1802, 135, 3, 70, "MoreAbout",
 CellID->102687903],
Cell[74846, 1807, 153, 3, 70, "MoreAbout",
 CellID->27726221],
Cell[75002, 1812, 172, 3, 70, "MoreAbout",
 CellID->325536602]
}, Open  ]],
Cell[75189, 1818, 27, 0, 70, "History"],
Cell[75219, 1820, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

