(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18480,        588]
NotebookOptionsPosition[     14823,        468]
NotebookOutlinePosition[     16267,        508]
CellTagsIndexPosition[     16182,        503]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Files and Directories" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingFilesAndDirectories"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Files and Directories\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DeleteDirectory" :> 
          Documentation`HelpLookup["paclet:ref/DeleteDirectory"], 
          "RenameDirectory" :> 
          Documentation`HelpLookup["paclet:ref/RenameDirectory"], 
          "CopyDirectory" :> 
          Documentation`HelpLookup["paclet:ref/CopyDirectory"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DeleteDirectory\"\>", 
       2->"\<\"RenameDirectory\"\>", 
       3->"\<\"CopyDirectory\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Directories & Directory Operations" :> 
          Documentation`HelpLookup[
           "paclet:guide/DirectoriesAndDirectoryOperations"], 
          "External Operations" :> 
          Documentation`HelpLookup["paclet:guide/ExternalOperations"], 
          "File Operations" :> 
          Documentation`HelpLookup["paclet:guide/FileOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Directories & Directory Operations\"\>", 
       2->"\<\"External Operations\"\>", 
       3->"\<\"File Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["CreateDirectory", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CreateDirectory",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CreateDirectory"], "[", "\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]creates a directory with name ",
     Cell[BoxData[
      StyleBox["dir", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CreateDirectory",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CreateDirectory"], "[", "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]creates a directory in the default area for temporary \
directories on your computer system."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->1527]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\""], "InlineFormula"],
 " is a single name, ",
 Cell[BoxData[
  ButtonBox["CreateDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateDirectory"]], "InlineFormula"],
 " creates a subdirectory of your current working directory. "
}], "Notes",
 CellID->20394],

Cell[TextData[{
 "The directory created by ",
 Cell[BoxData[
  ButtonBox["CreateDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateDirectory"]], "InlineFormula"],
 " is initially empty. "
}], "Notes",
 CellID->8490],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CreateDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateDirectory"]], "InlineFormula"],
 " returns the full name of the directory it creates, and ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 " if it cannot create the directory. "
}], "Notes",
 CellID->29648],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CreateDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateDirectory"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28054]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->620231105],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->138419935],

Cell["Create a directory:", "ExampleText",
 CellID->1696846846],

Cell[BoxData[
 RowBox[{
  RowBox[{"dir", "=", 
   RowBox[{"$TemporaryPrefix", "<>", " ", "\"\<test\>\""}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->194619255],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CreateDirectory", "[", "dir", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->322108562],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\test\"\>"], "Output",
 ImageSize->{396, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->51046597]
}, Open  ]],

Cell["Check the presense of the new directory: ", "ExampleText",
 CellID->108733167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileNames", "[", "dir", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->53533964],

Cell[BoxData[
 RowBox[{"{", "\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\test\"\>", "}"}]], "Output",
 ImageSize->{410, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->256360596]
}, Open  ]],

Cell["Delete the directory:", "ExampleText",
 CellID->1054463511],

Cell[BoxData[
 RowBox[{"DeleteDirectory", "[", "dir", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->755646583],

Cell["The directory is no longer there: ", "ExampleText",
 CellID->183508161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileNames", "[", "dir", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->655248885],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->340278192]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3148],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeleteDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DeleteDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RenameDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RenameDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CopyDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CopyDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24056]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5517],

Cell[TextData[ButtonBox["Manipulating Files and Directories",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingFilesAndDirectories"]], "Tutorials",\

 CellID->24192]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->10650918],

Cell[TextData[ButtonBox["Directories & Directory Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DirectoriesAndDirectoryOperations"]], "MoreAbout",
 CellID->722854261],

Cell[TextData[ButtonBox["External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "MoreAbout",
 CellID->296246156],

Cell[TextData[ButtonBox["File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FileOperations"]], "MoreAbout",
 CellID->206780748]
}, Open  ]],

Cell["New in 2  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CreateDirectory - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 35, 58.5201536}", "context" -> "System`", 
    "keywords" -> {
     "create folder", "new directory", "new folder", "file utilties", 
      "file operations"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CreateDirectory[\"dir\"] creates a directory with name dir. \
CreateDirectory[] creates a directory in the default area for temporary \
directories on your computer system.", 
    "synonyms" -> {"create directory", "mkdir"}, "title" -> "CreateDirectory",
     "type" -> "Symbol", "uri" -> "ref/CreateDirectory"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10025, 276, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->620231105]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16038, 496}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2417, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3040, 87, 4199, 83, 70, "ObjectNameGrid"],
Cell[7242, 172, 923, 28, 70, "Usage",
 CellID->1527]
}, Open  ]],
Cell[CellGroupData[{
Cell[8202, 205, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8680, 222, 351, 11, 70, "Notes",
 CellID->20394],
Cell[9034, 235, 231, 8, 70, "Notes",
 CellID->8490],
Cell[9268, 245, 395, 12, 70, "Notes",
 CellID->29648],
Cell[9666, 259, 322, 12, 70, "Notes",
 CellID->28054]
}, Closed]],
Cell[CellGroupData[{
Cell[10025, 276, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->620231105],
Cell[CellGroupData[{
Cell[10410, 290, 148, 5, 70, "ExampleSection",
 CellID->138419935],
Cell[10561, 297, 63, 1, 70, "ExampleText",
 CellID->1696846846],
Cell[10627, 300, 170, 6, 70, "Input",
 CellID->194619255],
Cell[CellGroupData[{
Cell[10822, 310, 113, 3, 28, "Input",
 CellID->322108562],
Cell[10938, 315, 238, 6, 36, "Output",
 CellID->51046597]
}, Open  ]],
Cell[11191, 324, 84, 1, 70, "ExampleText",
 CellID->108733167],
Cell[CellGroupData[{
Cell[11300, 329, 106, 3, 70, "Input",
 CellID->53533964],
Cell[11409, 334, 261, 7, 36, "Output",
 CellID->256360596]
}, Open  ]],
Cell[11685, 344, 65, 1, 70, "ExampleText",
 CellID->1054463511],
Cell[11753, 347, 113, 3, 70, "Input",
 CellID->755646583],
Cell[11869, 352, 77, 1, 70, "ExampleText",
 CellID->183508161],
Cell[CellGroupData[{
Cell[11971, 357, 107, 3, 70, "Input",
 CellID->655248885],
Cell[12081, 362, 175, 6, 36, "Output",
 CellID->340278192]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12317, 375, 310, 9, 70, "SeeAlsoSection",
 CellID->3148],
Cell[12630, 386, 734, 26, 70, "SeeAlso",
 CellID->24056]
}, Open  ]],
Cell[CellGroupData[{
Cell[13401, 417, 313, 9, 70, "TutorialsSection",
 CellID->5517],
Cell[13717, 428, 178, 4, 70, "Tutorials",
 CellID->24192]
}, Open  ]],
Cell[CellGroupData[{
Cell[13932, 437, 318, 9, 70, "MoreAboutSection",
 CellID->10650918],
Cell[14253, 448, 179, 3, 70, "MoreAbout",
 CellID->722854261],
Cell[14435, 453, 149, 3, 70, "MoreAbout",
 CellID->296246156],
Cell[14587, 458, 141, 3, 70, "MoreAbout",
 CellID->206780748]
}, Open  ]],
Cell[14743, 464, 50, 0, 70, "History"],
Cell[14796, 466, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

