(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42850,       1676]
NotebookOptionsPosition[     33844,       1357]
NotebookOutlinePosition[     35139,       1395]
CellTagsIndexPosition[     35053,       1390]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vectors and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/VectorsAndMatrices"], 
          "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Vectors and Matrices\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dot" :> Documentation`HelpLookup["paclet:ref/Dot"], 
          "Signature" :> Documentation`HelpLookup["paclet:ref/Signature"], 
          "Outer" :> Documentation`HelpLookup["paclet:ref/Outer"], 
          "KroneckerProduct" :> 
          Documentation`HelpLookup["paclet:ref/KroneckerProduct"], 
          "Orthogonalize" :> 
          Documentation`HelpLookup["paclet:ref/Orthogonalize"], "VectorAngle" :> 
          Documentation`HelpLookup["paclet:ref/VectorAngle"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Dot\"\>", 2->"\<\"Signature\"\>", 
       3->"\<\"Outer\"\>", 4->"\<\"KroneckerProduct\"\>", 
       5->"\<\"Orthogonalize\"\>", 
       6->"\<\"VectorAngle\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Operations on Vectors" :> 
          Documentation`HelpLookup["paclet:guide/OperationsOnVectors"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Matrices and Linear Algebra\"\>", 
       2->"\<\"Operations on Vectors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Cross ",
 StyleBox["(\[Cross])", "OperatorCharacter"]
}], "ObjectName",
 CellID->20170],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Cross",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Cross"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the vector cross product of ",
     Cell[BoxData[
      FormBox["a", TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox["b", TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18494]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 " are lists of length 3, corresponding to vectors in three dimensions, then \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Cross",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cross"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 " is also a list of length 3. "
}], "Notes",
 CellID->20216],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Cross",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cross"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 " can be entered in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "\[Cross]", "b"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]cross\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  RowBox[{
   StyleBox["a", "TI"], 
   StyleBox["\\[Cross]",
    ShowSpecialCharacters->False], 
   StyleBox["b", "TI"]}]], "InlineFormula"],
 ". Note the difference between ",
 Cell[TextData[ButtonBox["\\[Cross]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Cross"]], "InlineCharacterName"],
 " and ",
 Cell[TextData[ButtonBox["\\[Times]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Times"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->12729],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cross",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cross"]], "InlineFormula"],
 " is antisymmetric, so that ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Cross",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cross"], "[", 
   RowBox[{
    StyleBox["b", "TI"], ",", 
    StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"-", 
   RowBox[{"Cross", "[", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "]"}]}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->295148497]
}], "Notes",
 CellID->29726],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Cross",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cross"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 " gives the perpendicular vector ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", 
     StyleBox["y", "TI"]}], ",", 
    StyleBox["x", "TI"]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16038],

Cell[TextData[{
 "In general, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Cross",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cross"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    SubscriptBox[
     StyleBox["v", "TI"], 
     RowBox[{
      StyleBox["n", "TI"], "-", 
      StyleBox["1", "TR"]}]]}], "]"}]], "InlineFormula"],
 " is a totally antisymmetric product which takes vectors of length ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " and yields a vector of length ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " that is orthogonal to all of the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["v", "i"], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->29915],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Cross",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cross"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " gives the dual (Hodge star) of the wedge product of the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["v", "i"], TraditionalForm]], "InlineMath"],
 ", viewed as one\[Hyphen]forms in ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " dimensions. "
}], "Notes",
 CellID->28672]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->238083725],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->651090699],

Cell["The cross product of two vectors:", "ExampleText",
 CellID->403276501],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cross", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->229713371],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "c"}], " ", "y"}], "+", 
    RowBox[{"b", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"c", " ", "x"}], "-", 
    RowBox[{"a", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], " ", "x"}], "+", 
    RowBox[{"a", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->287049206]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->178984332],

Cell["The cross product of a single vector:", "ExampleText",
 CellID->231454196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cross", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2516002],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "y"}], ",", "x"}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56219563]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->66105971],

Cell[TextData[{
 "Enter using ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]cross\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ":"
}], "ExampleText",
 CellID->736734360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "\[Cross]", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->517110308],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "c"}], " ", "y"}], "+", 
    RowBox[{"b", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"c", " ", "x"}], "-", 
    RowBox[{"a", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], " ", "x"}], "+", 
    RowBox[{"a", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->121249925]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20497888],

Cell["Cross product computed with exact arithmetic:", "ExampleText",
 CellID->248405373],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"1", "/", "3"}]}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->50106498],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cross", "[", 
  RowBox[{"u", ",", "v"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->231036403],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["5", "6"]}], ",", 
   FractionBox["8", "3"], ",", 
   RowBox[{"-", 
    FractionBox["3", "2"]}]}], "}"}]], "Output",
 ImageSize->{90, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->45261496]
}, Open  ]],

Cell["Computed with machine arithmetic:", "ExampleText",
 CellID->160353027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cross", "[", 
  RowBox[{
   RowBox[{"N", "[", "u", "]"}], ",", 
   RowBox[{"N", "[", "v", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->444809258],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.8333333333333334`"}], ",", "2.6666666666666665`", ",", 
   RowBox[{"-", "1.5`"}]}], "}"}]], "Output",
 ImageSize->{182, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->174499478]
}, Open  ]],

Cell["Computed with arbitrary-precision arithmetic:", "ExampleText",
 CellID->95955959],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cross", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"u", ",", "20"}], "]"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{"v", ",", "20"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->297090210],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.83333333333333333333333333333`18.698970004336022"}], ",", 
   "2.66666666666666666666666666667`19.30102999566398", ",", 
   RowBox[{"-", "1.5`19.30102999566398"}]}], "}"}]], "Output",
 ImageSize->{483, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->599057769]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->495630124],

Cell["Cross of one vector in 2 dimensions:", "ExampleText",
 CellID->8946547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cross", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->537433712],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "y"}], ",", "x"}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->356402110]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], ".", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->237204636],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->65832610]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->265625596],

Cell["Cross product of three vectors in 4 dimensions:", "ExampleText",
 CellID->70714192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cross", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "9", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "8", ",", "27", ",", "81"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1148560],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "150"}], ",", "174", ",", 
   RowBox[{"-", "82"}], ",", "12"}], "}"}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->161923760]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->76672366],

Cell["Find the normal to the plane spanned by two vectors:", "ExampleText",
 CellID->376224441],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "9"}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->28222847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"w", "=", 
  RowBox[{"Cross", "[", 
   RowBox[{"u", ",", "v"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->146052857],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", 
   RowBox[{"-", "6"}], ",", "2"}], "}"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15291414]
}, Open  ]],

Cell["The equation for the plane:", "ExampleText",
 CellID->267900591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"w", ".", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "\[Equal]", "0"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->391529713],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"6", " ", "x"}], "-", 
   RowBox[{"6", " ", "y"}], "+", 
   RowBox[{"2", " ", "z"}]}], "\[Equal]", "0"}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->212720858]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->512940844],

Cell["Find a vector perpendicular to a vector in the plane:", "ExampleText",
 CellID->18655044],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", "2"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->308535604],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.2825325857495029`", ",", "0.4319135282868638`"}], 
  "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->417769100]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{"Cross", "[", "u", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->80396491],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.4319135282868638`"}], ",", "0.2825325857495029`"}], 
  "}"}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->138604140]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", ".", "v"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->54532497],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->8523061]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->731035118],

Cell[TextData[{
 "Find a vector orthogonal to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "-", " ", "1"}]], "InlineFormula"],
 " vectors in ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " dimensions:"
}], "ExampleText",
 CellID->88484351],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"uu", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"n", "-", "1"}], ",", "n"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"v", "=", 
  RowBox[{"Apply", "[", 
   RowBox[{"Cross", ",", "uu"}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->7466208],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.012890003949773904`"}], ",", 
   RowBox[{"-", "0.10490667739588803`"}], ",", "0.08209183216800416`", ",", 
   RowBox[{"-", "0.03842742497810124`"}], ",", "0.001672093718569824`"}], 
  "}"}]], "Output",
 ImageSize->{387, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10707579]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{"uu", ".", "v"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->687901068],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->49252403]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->36989431],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " are linearly independent u\[Cross]v is nonzero and orthogonal to ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->595193745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"u", ",", "v"}], "}"}], "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->573981064],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.7036362573218173`", ",", "0.3561468324342629`", ",", 
     "0.34063149504407586`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.2670110041190745`", ",", "0.8347997823581641`", ",", 
     "0.30417852805232815`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{424, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->215158658]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"w", "=", 
  RowBox[{"Cross", "[", 
   RowBox[{"u", ",", "v"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->796697076],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.17602687866677733`"}], ",", 
   RowBox[{"-", "0.12307868351009935`"}], ",", "0.49230027112946595`"}], 
  "}"}]], "Output",
 ImageSize->{210, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->318608673]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"u", ".", "w"}], ",", 
    RowBox[{"v", ".", "w"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->86965327],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->172755019]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->752084648],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " are linearly dependent u\[Cross]v is zero:"
}], "ExampleText",
 CellID->279885631],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", "3"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{
    RowBox[{"RandomReal", "[", "1", "]"}], " ", "u"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->651744852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{"Cross", "[", 
   RowBox[{"u", ",", "v"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->156093408],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->146787333]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->135293764],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cross",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cross"]], "InlineFormula"],
 " is antisymmetric:"
}], "ExampleText",
 CellID->295148497],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", ",", "v"}], "}"}], "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->212576386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Cross", "[", 
   RowBox[{"u", ",", "v"}], "]"}], "\[Equal]", 
  RowBox[{"-", 
   RowBox[{"Cross", "[", 
    RowBox[{"v", ",", "u"}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->259345476],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->180144791]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->741734496],

Cell[TextData[{
 "For vectors in 3 dimensions, ",
 Cell[BoxData[
  ButtonBox["Cross",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cross"]], "InlineFormula"],
 " is bilinear:"
}], "ExampleText",
 CellID->11980708],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["u", "1"], "=", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "1"], ",", 
     SubscriptBox["y", "1"], ",", 
     SubscriptBox["z", "1"]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["u", "2"], "=", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "2"], ",", 
     SubscriptBox["y", "2"], ",", 
     SubscriptBox["z", "2"]}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->301443844],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"Cross", "[", 
    RowBox[{
     RowBox[{"a", " ", 
      SubscriptBox["u", "1"]}], ",", 
     SubscriptBox["u", "2"]}], "]"}], "\[Equal]", 
   RowBox[{"a", " ", 
    RowBox[{"Cross", "[", 
     RowBox[{
      SubscriptBox["u", "1"], ",", 
      SubscriptBox["u", "2"]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13931761],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->12767487]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"Cross", "[", 
    RowBox[{
     SubscriptBox["u", "1"], ",", 
     RowBox[{"b", " ", 
      SubscriptBox["u", "2"]}]}], "]"}], "\[Equal]", 
   RowBox[{"b", " ", 
    RowBox[{"Cross", "[", 
     RowBox[{
      SubscriptBox["u", "1"], ",", 
      SubscriptBox["u", "2"]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->135630005],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->991504138]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->405766068],

Cell[TextData[{
 "The (antisymmetric) matrices for the linear operators ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"L", "(", "v", ")"}], "=", " ", 
    RowBox[{"u", "\[Cross]", "v"}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"L", "(", "u", ")"}], "\[LongEqual]", 
    RowBox[{"u", "\[Cross]", "v"}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->26864953],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Cross", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "#"}], "]"}], "&"}], 
    ",", 
    RowBox[{"IdentityMatrix", "[", "3", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->54596751],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "z", 
      RowBox[{"-", "y"}]},
     {
      RowBox[{"-", "z"}], "0", "x"},
     {"y", 
      RowBox[{"-", "x"}], "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{85, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->143552674]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Cross", "[", 
      RowBox[{"#", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], "&"}], ",", 
    RowBox[{"IdentityMatrix", "[", "3", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->782689668],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", 
      RowBox[{"-", "z"}], "y"},
     {"z", "0", 
      RowBox[{"-", "x"}]},
     {
      RowBox[{"-", "y"}], "x", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{85, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->30860676]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11128],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Signature",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Signature"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Outer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Outer"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["KroneckerProduct",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KroneckerProduct"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Orthogonalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Orthogonalize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VectorAngle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VectorAngle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21465]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18352],

Cell[TextData[ButtonBox["Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VectorsAndMatrices"]], "Tutorials",
 CellID->15862],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->400354195]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->82574273],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->53086985],

Cell[TextData[ButtonBox["Operations on Vectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OperationsOnVectors"]], "MoreAbout",
 CellID->470661672]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Cross (\[Cross]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 3.9109166}", "context" -> "System`", 
    "keywords" -> {
     "cross product", "Hodge star", "kross", "perp", "perpendicular vector", 
      "vector product", "wedge"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Cross[a, b] gives the vector cross product of a and b. ", 
    "synonyms" -> {}, "title" -> "Cross", "type" -> "Symbol", "uri" -> 
    "ref/Cross"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9162, 322, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->238083725]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 34910, 1383}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2563, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3186, 86, 105, 4, 70, "ObjectName",
 CellID->20170],
Cell[3294, 92, 693, 23, 70, "Usage",
 CellID->18494]
}, Open  ]],
Cell[CellGroupData[{
Cell[4024, 120, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4502, 137, 515, 19, 70, "Notes",
 CellID->20216],
Cell[5020, 158, 1380, 50, 70, "Notes",
 CellID->12729],
Cell[6403, 210, 659, 26, 70, "Notes",
 CellID->29726],
Cell[7065, 238, 472, 19, 70, "Notes",
 CellID->16038],
Cell[7540, 259, 901, 32, 70, "Notes",
 CellID->29915],
Cell[8444, 293, 681, 24, 70, "Notes",
 CellID->28672]
}, Closed]],
Cell[CellGroupData[{
Cell[9162, 322, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->238083725],
Cell[CellGroupData[{
Cell[9547, 336, 148, 5, 70, "ExampleSection",
 CellID->651090699],
Cell[9698, 343, 76, 1, 70, "ExampleText",
 CellID->403276501],
Cell[CellGroupData[{
Cell[9799, 348, 242, 8, 28, "Input",
 CellID->229713371],
Cell[10044, 358, 478, 18, 36, "Output",
 CellID->287049206]
}, Open  ]],
Cell[10537, 379, 125, 3, 70, "ExampleDelimiter",
 CellID->178984332],
Cell[10665, 384, 80, 1, 70, "ExampleText",
 CellID->231454196],
Cell[CellGroupData[{
Cell[10770, 389, 146, 5, 70, "Input",
 CellID->2516002],
Cell[10919, 396, 221, 8, 36, "Output",
 CellID->56219563]
}, Open  ]],
Cell[11155, 407, 124, 3, 70, "ExampleDelimiter",
 CellID->66105971],
Cell[11282, 412, 194, 7, 70, "ExampleText",
 CellID->736734360],
Cell[CellGroupData[{
Cell[11501, 423, 213, 7, 70, "Input",
 CellID->517110308],
Cell[11717, 432, 478, 18, 36, "Output",
 CellID->121249925]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12244, 456, 219, 7, 70, "ExampleSection",
 CellID->20497888],
Cell[12466, 465, 88, 1, 70, "ExampleText",
 CellID->248405373],
Cell[12557, 468, 332, 12, 70, "Input",
 CellID->50106498],
Cell[CellGroupData[{
Cell[12914, 484, 124, 4, 70, "Input",
 CellID->231036403],
Cell[13041, 490, 318, 12, 51, "Output",
 CellID->45261496]
}, Open  ]],
Cell[13374, 505, 76, 1, 70, "ExampleText",
 CellID->160353027],
Cell[CellGroupData[{
Cell[13475, 510, 182, 6, 70, "Input",
 CellID->444809258],
Cell[13660, 518, 291, 9, 36, "Output",
 CellID->174499478]
}, Open  ]],
Cell[13966, 530, 87, 1, 70, "ExampleText",
 CellID->95955959],
Cell[CellGroupData[{
Cell[14078, 535, 234, 8, 70, "Input",
 CellID->297090210],
Cell[14315, 545, 373, 10, 36, "Output",
 CellID->599057769]
}, Open  ]],
Cell[14703, 558, 125, 3, 70, "ExampleDelimiter",
 CellID->495630124],
Cell[14831, 563, 77, 1, 70, "ExampleText",
 CellID->8946547],
Cell[CellGroupData[{
Cell[14933, 568, 148, 5, 70, "Input",
 CellID->537433712],
Cell[15084, 575, 222, 8, 36, "Output",
 CellID->356402110]
}, Open  ]],
Cell[CellGroupData[{
Cell[15343, 588, 139, 5, 70, "Input",
 CellID->237204636],
Cell[15485, 595, 157, 5, 36, "Output",
 CellID->65832610]
}, Open  ]],
Cell[15657, 603, 125, 3, 70, "ExampleDelimiter",
 CellID->265625596],
Cell[15785, 608, 89, 1, 70, "ExampleText",
 CellID->70714192],
Cell[CellGroupData[{
Cell[15899, 613, 342, 10, 70, "Input",
 CellID->1148560],
Cell[16244, 625, 268, 9, 36, "Output",
 CellID->161923760]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16561, 640, 226, 7, 70, "ExampleSection",
 CellID->76672366],
Cell[16790, 649, 95, 1, 70, "ExampleText",
 CellID->376224441],
Cell[16888, 652, 280, 10, 70, "Input",
 CellID->28222847],
Cell[CellGroupData[{
Cell[17193, 666, 148, 5, 70, "Input",
 CellID->146052857],
Cell[17344, 673, 231, 8, 36, "Output",
 CellID->15291414]
}, Open  ]],
Cell[17590, 684, 70, 1, 70, "ExampleText",
 CellID->267900591],
Cell[CellGroupData[{
Cell[17685, 689, 181, 6, 70, "Input",
 CellID->391529713],
Cell[17869, 697, 293, 10, 36, "Output",
 CellID->212720858]
}, Open  ]],
Cell[18177, 710, 125, 3, 70, "ExampleDelimiter",
 CellID->512940844],
Cell[18305, 715, 95, 1, 70, "ExampleText",
 CellID->18655044],
Cell[CellGroupData[{
Cell[18425, 720, 153, 5, 70, "Input",
 CellID->308535604],
Cell[18581, 727, 243, 8, 36, "Output",
 CellID->417769100]
}, Open  ]],
Cell[CellGroupData[{
Cell[18861, 740, 123, 4, 70, "Input",
 CellID->80396491],
Cell[18987, 746, 262, 9, 36, "Output",
 CellID->138604140]
}, Open  ]],
Cell[CellGroupData[{
Cell[19286, 760, 91, 3, 70, "Input",
 CellID->54532497],
Cell[19380, 765, 158, 5, 36, "Output",
 CellID->8523061]
}, Open  ]],
Cell[19553, 773, 125, 3, 70, "ExampleDelimiter",
 CellID->731035118],
Cell[19681, 778, 267, 10, 70, "ExampleText",
 CellID->88484351],
Cell[CellGroupData[{
Cell[19973, 792, 400, 14, 70, "Input",
 CellID->7466208],
Cell[20376, 808, 390, 11, 36, "Output",
 CellID->10707579]
}, Open  ]],
Cell[CellGroupData[{
Cell[20803, 824, 124, 4, 70, "Input",
 CellID->687901068],
Cell[20930, 830, 222, 7, 36, "Output",
 CellID->49252403]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21201, 843, 236, 7, 70, "ExampleSection",
 CellID->36989431],
Cell[21440, 852, 386, 15, 70, "ExampleText",
 CellID->595193745],
Cell[CellGroupData[{
Cell[21851, 871, 251, 9, 70, "Input",
 CellID->573981064],
Cell[22105, 882, 454, 15, 36, "Output",
 CellID->215158658]
}, Open  ]],
Cell[CellGroupData[{
Cell[22596, 902, 148, 5, 70, "Input",
 CellID->796697076],
Cell[22747, 909, 312, 10, 36, "Output",
 CellID->318608673]
}, Open  ]],
Cell[CellGroupData[{
Cell[23096, 924, 196, 7, 70, "Input",
 CellID->86965327],
Cell[23295, 933, 203, 7, 36, "Output",
 CellID->172755019]
}, Open  ]],
Cell[23513, 943, 125, 3, 70, "ExampleDelimiter",
 CellID->752084648],
Cell[23641, 948, 233, 9, 70, "ExampleText",
 CellID->279885631],
Cell[23877, 959, 289, 10, 70, "Input",
 CellID->651744852],
Cell[CellGroupData[{
Cell[24191, 973, 156, 5, 70, "Input",
 CellID->156093408],
Cell[24350, 980, 213, 7, 36, "Output",
 CellID->146787333]
}, Open  ]],
Cell[24578, 990, 125, 3, 70, "ExampleDelimiter",
 CellID->135293764],
Cell[24706, 995, 189, 7, 70, "ExampleText",
 CellID->295148497],
Cell[24898, 1004, 275, 10, 70, "Input",
 CellID->212576386],
Cell[CellGroupData[{
Cell[25198, 1018, 231, 8, 70, "Input",
 CellID->259345476],
Cell[25432, 1028, 161, 5, 36, "Output",
 CellID->180144791]
}, Open  ]],
Cell[25608, 1036, 125, 3, 70, "ExampleDelimiter",
 CellID->741734496],
Cell[25736, 1041, 217, 8, 70, "ExampleText",
 CellID->11980708],
Cell[25956, 1051, 477, 18, 70, "Input",
 CellID->301443844],
Cell[CellGroupData[{
Cell[26458, 1073, 402, 14, 70, "Input",
 CellID->13931761],
Cell[26863, 1089, 160, 5, 36, "Output",
 CellID->12767487]
}, Open  ]],
Cell[CellGroupData[{
Cell[27060, 1099, 403, 14, 70, "Input",
 CellID->135630005],
Cell[27466, 1115, 161, 5, 36, "Output",
 CellID->991504138]
}, Open  ]],
Cell[27642, 1123, 125, 3, 70, "ExampleDelimiter",
 CellID->405766068],
Cell[27770, 1128, 443, 15, 70, "ExampleText",
 CellID->26864953],
Cell[CellGroupData[{
Cell[28238, 1147, 356, 12, 70, "Input",
 CellID->54596751],
Cell[28597, 1161, 823, 26, 78, "Output",
 CellID->143552674]
}, Open  ]],
Cell[CellGroupData[{
Cell[29457, 1192, 352, 11, 70, "Input",
 CellID->782689668],
Cell[29812, 1205, 822, 26, 78, "Output",
 CellID->30860676]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30695, 1238, 311, 9, 70, "SeeAlsoSection",
 CellID->11128],
Cell[31009, 1249, 1449, 53, 70, "SeeAlso",
 CellID->21465]
}, Open  ]],
Cell[CellGroupData[{
Cell[32495, 1307, 314, 9, 70, "TutorialsSection",
 CellID->18352],
Cell[32812, 1318, 149, 3, 70, "Tutorials",
 CellID->15862],
Cell[32964, 1323, 133, 3, 70, "Tutorials",
 CellID->400354195]
}, Open  ]],
Cell[CellGroupData[{
Cell[33134, 1331, 318, 9, 70, "MoreAboutSection",
 CellID->82574273],
Cell[33455, 1342, 162, 3, 70, "MoreAbout",
 CellID->53086985],
Cell[33620, 1347, 152, 3, 70, "MoreAbout",
 CellID->470661672]
}, Open  ]],
Cell[33787, 1353, 27, 0, 70, "History"],
Cell[33817, 1355, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

