(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25627,        960]
NotebookOptionsPosition[     21379,        816]
NotebookOutlinePosition[     22779,        855]
CellTagsIndexPosition[     22694,        850]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Quartics" :> Documentation`HelpLookup["paclet:ref/Quartics"], 
          "ToRadicals" :> Documentation`HelpLookup["paclet:ref/ToRadicals"], 
          "Reduce" :> Documentation`HelpLookup["paclet:ref/Reduce"], 
          "Resolve" :> Documentation`HelpLookup["paclet:ref/Resolve"], 
          "Eigenvalues" :> 
          Documentation`HelpLookup["paclet:ref/Eigenvalues"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Quartics\"\>", 
       2->"\<\"ToRadicals\"\>", 3->"\<\"Reduce\"\>", 4->"\<\"Resolve\"\>", 
       5->"\<\"Eigenvalues\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polynomial Equations" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialEquations"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Polynomial Equations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Cubics", "ObjectName",
 CellID->32647],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Cubics",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cubics"]], "InlineFormula"],
     " \[LineSeparator]is an option for functions that involve solving \
algebraic equations, that specifies whether explicit forms for solutions to \
cubic equations should be given."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11299]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"Cubics", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", roots of cubics are given explicitly in terms of radicals. With ",
 Cell[BoxData[
  RowBox[{"Cubics", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", roots of cubics that do not have very simple forms are given implicitly \
in terms of ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects."
}], "Notes",
 CellID->2489],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Cubics", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " may lead to fairly large outputs."
}], "Notes",
 CellID->448808338]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->354379452],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->95913594],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " does not use general formulas for solving cubics in radicals:"
}], "ExampleText",
 CellID->413536964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"3", " ", "x"}], "+", "4"}], "==", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->258275847],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "#1"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "#1"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"4", "+", 
       RowBox[{"3", " ", "#1"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "3"}], "]"}]}]}]], "Output",
 ImageSize->{456, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->188639596]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"Cubics", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " solves all cubics in terms of radicals:"
}], "ExampleText",
 CellID->248533402],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"3", " ", "x"}], "+", "4"}], "==", "0"}], ",", "x", ",", 
   RowBox[{"Cubics", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->583642825],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "-", 
      FractionBox[
       SuperscriptBox["5", 
        RowBox[{"2", "/", "3"}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "7"}], "+", 
          RowBox[{"3", " ", 
           SqrtBox["6"]}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"5", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "7"}], "+", 
           RowBox[{"3", " ", 
            SqrtBox["6"]}]}], ")"}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}], ")"}]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["2", "3"]}], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["5", 
       RowBox[{"2", "/", "3"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}]}], 
     RowBox[{"6", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "7"}], "+", 
         RowBox[{"3", " ", 
          SqrtBox["6"]}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}]], "-", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["3"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"5", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "7"}], "+", 
          RowBox[{"3", " ", 
           SqrtBox["6"]}]}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "3"}]]}]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["2", "3"]}], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["5", 
       RowBox[{"2", "/", "3"}]], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}]}], 
     RowBox[{"6", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "7"}], "+", 
         RowBox[{"3", " ", 
          SqrtBox["6"]}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}]], "-", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["3"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"5", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "7"}], "+", 
          RowBox[{"3", " ", 
           SqrtBox["6"]}]}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "3"}]]}]}]}]}]], "Output",
 ImageSize->{401, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->409561987]
}, Open  ]],

Cell["\<\
Solving this simple cubic in radicals does not require the general formulas:\
\>", "ExampleText",
 CellID->887792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "-", "5"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->256674784],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "5"}], ")"}], 
     RowBox[{"1", "/", "3"}]]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   SuperscriptBox["5", 
    RowBox[{"1", "/", "3"}]]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     RowBox[{"2", "/", "3"}]], " ", 
    SuperscriptBox["5", 
     RowBox[{"1", "/", "3"}]]}]}]}]], "Output",
 ImageSize->{260, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->38111357]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13361],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Eigenvalues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eigenvalues"]], "InlineFormula"],
 " does not use general formulas for solving cubics in radicals:"
}], "ExampleText",
 CellID->436488008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "1"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->178052272],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], "-", 
       RowBox[{"8", " ", "#1"}], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], ",", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], "-", 
       RowBox[{"8", " ", "#1"}], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "3"}], "]"}], ",", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "6"}], "-", 
       RowBox[{"8", " ", "#1"}], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{422, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->198581650]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"Cubics", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", all cubics are solved in terms of radicals:"
}], "ExampleText",
 CellID->5465385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"Cubics", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->427411283],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"216", "-", 
        RowBox[{"3", " ", 
         SqrtBox["1191"]}]}], ")"}], 
      RowBox[{"1", "/", "3"}]]}], "+", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"72", "+", 
        SqrtBox["1191"]}], ")"}], 
      RowBox[{"1", "/", "3"}]], 
     SuperscriptBox["3", 
      RowBox[{"2", "/", "3"}]]]}], ",", 
   RowBox[{"1", "-", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["3"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"216", "-", 
        RowBox[{"3", " ", 
         SqrtBox["1191"]}]}], ")"}], 
      RowBox[{"1", "/", "3"}]]}], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"72", "+", 
         SqrtBox["1191"]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}], 
     RowBox[{"2", " ", 
      SuperscriptBox["3", 
       RowBox[{"2", "/", "3"}]]}]]}], ",", 
   RowBox[{"1", "-", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["3"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"216", "-", 
        RowBox[{"3", " ", 
         SqrtBox["1191"]}]}], ")"}], 
      RowBox[{"1", "/", "3"}]]}], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"72", "+", 
         SqrtBox["1191"]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}], 
     RowBox[{"2", " ", 
      SuperscriptBox["3", 
       RowBox[{"2", "/", "3"}]]}]]}]}], "}"}]], "Output",
 ImageSize->{431, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->106283105]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16458946],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["ToRadicals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToRadicals"]], "InlineFormula"],
 " converts all cubic ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects to radicals:"
}], "ExampleText",
 CellID->758680193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nums", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"#", "^", "3"}], "-", 
        RowBox[{"2", "#"}], "+", "7"}], "&"}], ",", "1"}], "]"}], ",", 
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"#", "^", "3"}], "-", "5"}], "&"}], ",", "1"}], "]"}]}], 
   "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->331327142],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"7", "-", 
       RowBox[{"2", " ", "#1"}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], ",", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "5"}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{294, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->288030965]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToRadicals", "[", "nums", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->362176903],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["2", 
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{"63", "-", 
           SqrtBox["3873"]}], ")"}]}]], ")"}], 
      RowBox[{"1", "/", "3"}]]}], "-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"63", "-", 
          SqrtBox["3873"]}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "3"}]], 
     SuperscriptBox["3", 
      RowBox[{"2", "/", "3"}]]]}], ",", 
   SuperscriptBox["5", 
    RowBox[{"1", "/", "3"}]]}], "}"}]], "Output",
 ImageSize->{344, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->756351849]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"Cubics", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ToRadicals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToRadicals"]], "InlineFormula"],
 " does not use the general formulas for solving cubics:"
}], "ExampleText",
 CellID->416590211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToRadicals", "[", 
  RowBox[{"nums", ",", 
   RowBox[{"Cubics", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->241638772],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"7", "-", 
       RowBox[{"2", " ", "#1"}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], ",", 
   SuperscriptBox["5", 
    RowBox[{"1", "/", "3"}]]}], "}"}]], "Output",
 ImageSize->{199, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->148306913]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11957],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quartics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quartics"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToRadicals",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToRadicals"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Resolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Resolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eigenvalues",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eigenvalues"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15503]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->33817383],

Cell[TextData[ButtonBox["Polynomial Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialEquations"]], "MoreAbout",
 CellID->164578206]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Cubics - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 9.2704288}", "context" -> "System`", 
    "keywords" -> {
     "Cardano formulas", "radical solutions", 
      "radical solutions to polynomial equations", "polynomial roots"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Cubics is an option for functions that involve solving algebraic \
equations, that specifies whether explicit forms for solutions to cubic \
equations should be given.", "synonyms" -> {}, "title" -> "Cubics", "type" -> 
    "Symbol", "uri" -> "ref/Cubics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4185, 139, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->354379452]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22551, 843}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1562, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2185, 63, 44, 1, 70, "ObjectName",
 CellID->32647],
Cell[2232, 66, 540, 15, 70, "Usage",
 CellID->11299]
}, Open  ]],
Cell[CellGroupData[{
Cell[2809, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3287, 103, 629, 21, 70, "Notes",
 CellID->2489],
Cell[3919, 126, 229, 8, 70, "Notes",
 CellID->448808338]
}, Closed]],
Cell[CellGroupData[{
Cell[4185, 139, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->354379452],
Cell[CellGroupData[{
Cell[4570, 153, 147, 5, 70, "ExampleSection",
 CellID->95913594],
Cell[4720, 160, 252, 8, 70, "ExampleText",
 CellID->413536964],
Cell[CellGroupData[{
Cell[4997, 172, 303, 11, 28, "Input",
 CellID->258275847],
Cell[5303, 185, 1012, 33, 58, "Output",
 CellID->188639596]
}, Open  ]],
Cell[6330, 221, 373, 14, 70, "ExampleText",
 CellID->248533402],
Cell[CellGroupData[{
Cell[6728, 239, 348, 11, 28, "Input",
 CellID->583642825],
Cell[7079, 252, 2803, 101, 174, "Output",
 CellID->409561987]
}, Open  ]],
Cell[9897, 356, 124, 3, 70, "ExampleText",
 CellID->887792],
Cell[CellGroupData[{
Cell[10046, 363, 210, 8, 70, "Input",
 CellID->256674784],
Cell[10259, 373, 627, 23, 36, "Output",
 CellID->38111357]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10935, 402, 216, 7, 70, "ExampleSection",
 CellID->13361],
Cell[11154, 411, 262, 8, 70, "ExampleText",
 CellID->436488008],
Cell[CellGroupData[{
Cell[11441, 423, 347, 11, 70, "Input",
 CellID->178052272],
Cell[11791, 436, 1015, 35, 58, "Output",
 CellID->198581650]
}, Open  ]],
Cell[12821, 474, 254, 9, 70, "ExampleText",
 CellID->5465385],
Cell[CellGroupData[{
Cell[13100, 487, 416, 13, 70, "Input",
 CellID->427411283],
Cell[13519, 502, 2164, 78, 148, "Output",
 CellID->106283105]
}, Open  ]],
Cell[15698, 583, 124, 3, 70, "ExampleDelimiter",
 CellID->16458946],
Cell[15825, 588, 355, 13, 70, "ExampleText",
 CellID->758680193],
Cell[CellGroupData[{
Cell[16205, 605, 456, 17, 70, "Input",
 CellID->331327142],
Cell[16664, 624, 539, 20, 39, "Output",
 CellID->288030965]
}, Open  ]],
Cell[CellGroupData[{
Cell[17240, 649, 109, 3, 70, "Input",
 CellID->362176903],
Cell[17352, 654, 842, 31, 72, "Output",
 CellID->756351849]
}, Open  ]],
Cell[18209, 688, 397, 14, 70, "ExampleText",
 CellID->416590211],
Cell[CellGroupData[{
Cell[18631, 706, 171, 5, 70, "Input",
 CellID->241638772],
Cell[18805, 713, 428, 15, 39, "Output",
 CellID->148306913]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19294, 735, 311, 9, 70, "SeeAlsoSection",
 CellID->11957],
Cell[19608, 746, 1190, 44, 70, "SeeAlso",
 CellID->15503]
}, Open  ]],
Cell[CellGroupData[{
Cell[20835, 795, 318, 9, 70, "MoreAboutSection",
 CellID->33817383],
Cell[21156, 806, 151, 3, 70, "MoreAbout",
 CellID->164578206]
}, Open  ]],
Cell[21322, 812, 27, 0, 70, "History"],
Cell[21352, 814, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

