(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     44651,       1385]
NotebookOptionsPosition[     37396,       1159]
NotebookOutlinePosition[     39582,       1209]
CellTagsIndexPosition[     39496,       1204]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Advanced Dynamic Functionality" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedDynamicFunctionality"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>", 
       2->"\<\"Advanced Dynamic Functionality\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AbsoluteCurrentValue" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteCurrentValue"], 
          "MousePosition" :> 
          Documentation`HelpLookup["paclet:ref/MousePosition"], 
          "ControllerState" :> 
          Documentation`HelpLookup["paclet:ref/ControllerState"], 
          "MouseAnnotation" :> 
          Documentation`HelpLookup["paclet:ref/MouseAnnotation"], "Options" :> 
          Documentation`HelpLookup["paclet:ref/Options"], "AbsoluteOptions" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteOptions"], 
          "SystemOptions" :> 
          Documentation`HelpLookup["paclet:ref/SystemOptions"], 
          "ControlActive" :> 
          Documentation`HelpLookup["paclet:ref/ControlActive"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AbsoluteCurrentValue\"\>", 
       2->"\<\"MousePosition\"\>", 3->"\<\"ControllerState\"\>", 
       4->"\<\"MouseAnnotation\"\>", 5->"\<\"Options\"\>", 
       6->"\<\"AbsoluteOptions\"\>", 7->"\<\"SystemOptions\"\>", 
       8->"\<\"ControlActive\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Click-Interactive Panels" :> 
          Documentation`HelpLookup["paclet:guide/ClickInteractivePanels"], 
          "Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Creating Inspectors" :> 
          Documentation`HelpLookup["paclet:guide/CreatingInspectors"], 
          "Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], 
          "Dynamic Interactivity Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/DynamicInteractivityLanguage"], 
          "External Operations" :> 
          Documentation`HelpLookup["paclet:guide/ExternalOperations"], 
          "Global Computation Settings & Parameters" :> 
          Documentation`HelpLookup[
           "paclet:guide/GlobalComputationSettingsAndParameters"], 
          "Low-Level Interface Control" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelInterfaceControl"], 
          "Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"], 
          "Mathematica Session Information" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSessionInformation"], 
          "Notebook & Interface Customization" :> 
          Documentation`HelpLookup[
           "paclet:guide/NotebookAndInterfaceCustomization"], 
          "Notebook Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NotebookFormattingAndStyling"], 
          "Programmatic Notebook & Interface Customization" :> 
          Documentation`HelpLookup[
           "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"], 
          "Toolbars" :> Documentation`HelpLookup["paclet:guide/Toolbars"], 
          "New in 6.0: Dynamic Interactivity" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DynamicInteractivity"], 
          "New in 6.0: System Interfaces & Deployment" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60SystemInterfacesAndDeployment"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Click-Interactive Panels\"\>", 
       2->"\<\"Control Objects\"\>", 3->"\<\"Creating Inspectors\"\>", 
       4->"\<\"Custom Interface Construction\"\>", 
       5->"\<\"Dynamic Interactivity Language\"\>", 
       6->"\<\"External Operations\"\>", 
       7->"\<\"Global Computation Settings & Parameters\"\>", 
       8->"\<\"Low-Level Interface Control\"\>", 
       9->"\<\"Low-Level Notebook Programming\"\>", 
       10->"\<\"Mathematica Session Information\"\>", 
       11->"\<\"Notebook & Interface Customization\"\>", 
       12->"\<\"Notebook Formatting & Styling\"\>", 
       13->"\<\"Programmatic Notebook & Interface Customization\"\>", 
       14->"\<\"Toolbars\"\>", 
       15->"\<\"New in 6.0: Dynamic Interactivity\"\>", 
       16->"\<\"New in 6.0: System Interfaces & Deployment\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["CurrentValue", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CurrentValue",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CurrentValue"], "[", 
       StyleBox["item", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the current value of ",
     Cell[BoxData[
      StyleBox["item", "TI"]], "InlineFormula"],
     " at a location in the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " system and interface. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CurrentValue",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CurrentValue"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["item", "TI"], ",", 
         StyleBox["spec", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the current value for the feature of ",
     Cell[BoxData[
      StyleBox["item", "TI"]], "InlineFormula"],
     " specified by ",
     Cell[BoxData[
      StyleBox["spec", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CurrentValue",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CurrentValue"], "[", 
       RowBox[{
        StyleBox["obj", "TI"], ",", 
        StyleBox["item", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the current value of ",
     Cell[BoxData[
      StyleBox["item", "TI"]], "InlineFormula"],
     " associated with the object ",
     Cell[BoxData[
      StyleBox["obj", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->15062]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CurrentValue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CurrentValue"]], "InlineFormula"],
 " by default refers to the location at which it appears in a notebook \
structure."
}], "Notes",
 CellID->29229],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CurrentValue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CurrentValue"]], "InlineFormula"],
 " is most often used inside ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ", where it by default refers to the dynamic object being displayed."
}], "Notes",
 CellID->27560],

Cell[TextData[{
 "Values for appropriate items can be reset using ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"CurrentValue", "[", 
    StyleBox["item", "TI"], "]"}], "=", 
   StyleBox["val", "TI"]}]], "InlineFormula"],
 ", or implicitly through ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->7718],

Cell[TextData[{
 "For any option in the notebook front end, the current value at a particular \
location can be accessed using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CurrentValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CurrentValue"], "[", 
   StyleBox["opt", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->29073],

Cell[TextData[{
 "For options whose settings are lists of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"name\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CurrentValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CurrentValue"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["opt", "TI"], ",", 
     SubscriptBox[
      StyleBox["name", "TI"], 
      StyleBox["i", "TI"]]}], "}"}], "]"}]], "InlineFormula"],
 " picks out the current value of ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["val", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "Notes",
 CellID->8079],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CurrentValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CurrentValue"], "[", 
   RowBox[{"{", 
    RowBox[{
     ButtonBox["StyleDefinitions",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StyleDefinitions"], ",", "\"\<\!\(\*
StyleBox[\"style\", \"TI\"]\)\>\""}], "}"}], "]"}]], "InlineFormula"],
 " gives the explicit style definitions that would be used for the style with \
name ",
 Cell[BoxData[
  StyleBox["style", "TI"]], "InlineFormula"],
 " at the current location."
}], "Notes",
 CellID->8709],

Cell[TextData[{
 "Possible special items that can be used in ",
 Cell[BoxData[
  ButtonBox["CurrentValue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CurrentValue"]], "InlineFormula"],
 " include:"
}], "Notes",
 CellID->9662],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<MouseOver\>\"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the mouse is over the location "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SelectionData\>\"", Cell[
    "the contents of the selection in this notebook", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SelectionOver\>\"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the selection includes the current location"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->10224],

Cell["The following refer to the mouse:", "Notes",
 CellID->11574],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<MouseButtons\>\"", Cell[
    "a list of mouse buttons currently pressed", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MouseButtonTest\>\"", Cell[
    TextData[{
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the main mouse button is currently pressed"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<MouseButtonTest\>\"", ",", 
      StyleBox["i", "TI"]}], "}"}], Cell[TextData[{
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if mouse button ",
     StyleBox["i", "TI"],
     " is currently pressed"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MouseClickCount\>\"", Cell[
    "number of mouse clicks for the triggering event", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MouseOver\>\"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the mouse is over the current location "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MousePosition\>\"", Cell[
    "the current position of the mouse", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<MousePosition\>\"", ",", 
      StyleBox["coords", "TI"]}], "}"}], Cell[
    "the mouse position in the specified coordinate system", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->1838055263],

Cell[TextData[{
 "The primary mouse button is represented as ",
 Cell[BoxData["1"], "InlineFormula"],
 ". The secondary (\"right\") button is ",
 Cell[BoxData["2"], "InlineFormula"],
 ". The scroll wheel button is typically ",
 Cell[BoxData["3"], "InlineFormula"],
 ". Additional buttons are given higher numbers."
}], "Notes",
 CellID->7475],

Cell["The following refer to modifier keys:", "Notes",
 CellID->28815],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ModifierKeys\>\"", Cell[
    "a list of all modifier keys currently being pressed", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AltKey\>\"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the ",
     StyleBox["Alt", "KeyEvent"],
     " or ",
     StyleBox["Cmd", "KeyEvent"],
     " key is currently pressed"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CommandKey\>\"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the ",
     StyleBox["Alt", "KeyEvent"],
     " or ",
     StyleBox["Cmd", "KeyEvent"],
     " key is currently pressed"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ControlKey\>\"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the ",
     StyleBox["Ctrl", "KeyEvent"],
     " key is currently pressed"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<OptionKey\>\"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the ",
     StyleBox["Option", "KeyEvent"],
     " key on a Macintosh is currently pressed"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ShiftKey\>\"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the ",
     StyleBox["Shift", "KeyEvent"],
     " key is currently pressed "
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->29343],

Cell["The following refer to controller devices such as gamepads:", "Notes",
 CellID->431048264],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ControllerData\>\"", Cell["\<\
low\[Hyphen]level data on states of all controllers\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<ControllerData\>\"", ",", 
      StyleBox["ids", "TI"]}], "}"}], Cell[
    "data on controllers with the specified identifiers", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->228772180],

Cell["\<\
The following refer to the event or action currently being handled:\
\>", "Notes",
 CellID->27446],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<EventKey\>\"", Cell[
    "key that was pressed", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EventAbsoluteTime\>\"", Cell[
    "absolute time when the event occurred", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EventData\>\"", Cell[
    "data about the event", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->27532],

Cell["\<\
The following refer to the evaluation currently being performed:\
\>", "Notes",
 CellID->565132317],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<DynamicEvaluation\>\"", Cell[
    TextData[{
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the evaluation is associated with ",
     Cell[BoxData[
      ButtonBox["Dynamic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SynchronousEvaluation\>\"", Cell[
    TextData[{
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the evaluation is being performed synchronously"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->24758408],

Cell["\<\
The following special items refer to the complete current notebook:\
\>", "Notes",
 CellID->14568],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<NotebookDirectory\>\"", Cell[
    "directory name", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NotebookFileName\>\"", Cell[
    "name of file, without path", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NotebookFullFileName\>\"", Cell[
    "full file name, including path", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NotebookSelected\>\"", Cell[
    TextData[{
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the notebook is selected"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->32684],

Cell["\<\
The following refer to the font being used; all are given in printer's \
points:\
\>", "Notes",
 CellID->4361],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<FontAscenderHeight\>\"", Cell[
    "height of ascenders for lowercase letters", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FontAxisOffset\>\"", Cell[
    "offset of the font axis above the baseline ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FontCapHeight\>\"", Cell[
    "height of capital letters", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FontDescenderDepth\>\"", Cell[
    "depth of descenders for lowercase letters", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FontLineHeight\>\"", Cell[
    "total height of lines of text ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FontMWidth\>\"", Cell[
    "width of an \"m\"", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FontNWidth\>\"", Cell[
    "width of an \"n\"", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FontThickness\>\"", Cell[
    "default stroke thickness", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FontXHeight\>\"", Cell[
    "height of an \"x\"", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True, True}}}},
 CellID->5472],

Cell["The following refer to system font settings:", "Notes",
 CellID->25286],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ControlsFontFamily\>\"", Cell[
    "font family for system controls", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ControlsFontSize\>\"", Cell[
    "default font size for system controls", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PanelFontFamily\>\"", Cell[
    "font family for system panels", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PanelFontSize\>\"", Cell[
    "default font size for system panels", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->8266],

Cell[TextData[{
 "Typical objects that can be used in ",
 Cell[BoxData[
  ButtonBox["CurrentValue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CurrentValue"]], "InlineFormula"],
 " include:"
}], "Notes",
 CellID->6089],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["$FrontEnd",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$FrontEnd"], Cell[
    "the whole front end session", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["InputNotebook",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InputNotebook"], "[", "]"}], Cell[
    "the currently selected notebook", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["EvaluationNotebook",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EvaluationNotebook"], "[", "]"}], Cell[
    "the notebook in which the current evaluation is occurring", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["NotebookSelection",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookSelection"], "[", 
     StyleBox["nb", "TI"], "]"}], Cell[
    "the current selection within a notebook", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->32151],

Cell[TextData[{
 "When used in functions like ",
 Cell[BoxData[
  ButtonBox["EventHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EventHandler"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Button",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Button"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CurrentValue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CurrentValue"]], "InlineFormula"],
 " returns the current value at the moment when the triggering event \
occurred. "
}], "Notes",
 CellID->4604],

Cell[TextData[{
 "Cases such as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CurrentValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CurrentValue"], "[", "\"\<MousePosition\>\"", 
   "]"}]], "InlineFormula"],
 " are equivalent to explicit functions such as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MousePosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MousePosition"], "[", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->17233]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->608962052],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->305535705],

Cell["Get the current mouse position:", "ExampleText",
 CellID->769215536],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CurrentValue", "[", "\"\<MousePosition\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->161964968],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"805", ",", "516"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->677650558]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->56330427],

Cell["Dynamically update the current value:", "ExampleText",
 CellID->239727823],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"CurrentValue", "[", "\"\<MouseOver\>\"", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1051742779],

Cell[BoxData[
 DynamicBox[ToBoxes[
   CurrentValue["MouseOver"], StandardForm],
  ImageSizeCache->{35., {0., 8.}}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->117777198]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7148],

Cell[TextData[{
 "Mouseover is created by the ",
 Cell[BoxData[
  ButtonBox["CurrentValue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CurrentValue"]], "InlineFormula"],
 " item ",
 Cell[BoxData["\"\<MouseOver\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->135800110],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"CurrentValue", "[", "\"\<MouseOver\>\"", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->316291284],

Cell[BoxData[
 DynamicBox[ToBoxes[
   CurrentValue["MouseOver"], StandardForm],
  ImageSizeCache->{35., {0., 8.}}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->350125359]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mouseover", "[", 
  RowBox[{"False", ",", "True"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->320624211],

Cell[BoxData[
 PaneSelectorBox[{False->"False", True->"True"}, Dynamic[
   CurrentValue["MouseOver"]],
  FrameMargins->0,
  ImageSize->Automatic]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->147844746]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2510],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " may not be updated while mouse buttons are down, so this may show nothing: \
"
}], "ExampleText",
 CellID->10396],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"CurrentValue", "[", "\"\<MouseButtons\>\"", "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->15941],

Cell[BoxData[
 DynamicBox[ToBoxes[
   CurrentValue["MouseButtons"], StandardForm],
  ImageSizeCache->{14., {2., 8.}}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->75111079]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23533],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteCurrentValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteCurrentValue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MousePosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MousePosition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ControllerState",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControllerState"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MouseAnnotation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MouseAnnotation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Options",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Options"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteOptions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SystemOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SystemOptions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ControlActive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControlActive"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->468]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25594],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Advanced Dynamic Functionality",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"]], "Tutorials",
 CellID->558945376]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->14159125],

Cell[TextData[ButtonBox["Click-Interactive Panels",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ClickInteractivePanels"]], "MoreAbout",
 CellID->476374225],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->724146061],

Cell[TextData[ButtonBox["Creating Inspectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CreatingInspectors"]], "MoreAbout",
 CellID->75815984],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->305899386],

Cell[TextData[ButtonBox["Dynamic Interactivity Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicInteractivityLanguage"]], "MoreAbout",
 CellID->294888841],

Cell[TextData[ButtonBox["External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "MoreAbout",
 CellID->492100971],

Cell[TextData[ButtonBox["Global Computation Settings & Parameters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GlobalComputationSettingsAndParameters"]], "MoreAbout",
 CellID->34868524],

Cell[TextData[ButtonBox["Low-Level Interface Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelInterfaceControl"]], "MoreAbout",
 CellID->628228373],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->386999558],

Cell[TextData[ButtonBox["Mathematica Session Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessionInformation"]], "MoreAbout",
 CellID->361503167],

Cell[TextData[ButtonBox["Notebook & Interface Customization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotebookAndInterfaceCustomization"]], "MoreAbout",
 CellID->265826279],

Cell[TextData[ButtonBox["Notebook Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotebookFormattingAndStyling"]], "MoreAbout",
 CellID->194718628],

Cell[TextData[ButtonBox["Programmatic Notebook & Interface Customization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"]], "MoreAbout",\

 CellID->256868130],

Cell[TextData[ButtonBox["Toolbars",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Toolbars"]], "MoreAbout",
 CellID->392870886],

Cell[TextData[ButtonBox["New in 6.0: Dynamic Interactivity",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DynamicInteractivity"]], "MoreAbout",
 CellID->310930271],

Cell[TextData[ButtonBox["New in 6.0: System Interfaces & Deployment",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60SystemInterfacesAndDeployment"]], "MoreAbout",
 CellID->51592522]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CurrentValue - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 15.4112110}", "context" -> "System`", 
    "keywords" -> {
     "alt key", "command key", "control key", "controller data", 
      "controls font family", "controls font size", "dynamic evaluation", 
      "event absolute time", "event data", "event key", 
      "font ascender height", "font axis offset", "font cap height", 
      "font descender depth", "font height", "font line height", 
      "font thickness", "font width", "modifier keys", "mouse buttons", 
      "mouse button test", "mouse click count", "mouse over", 
      "mouse position", "notebook directory", "notebook file name", 
      "notebook full file name", "notebook selected", "option key", 
      "panel font family", "panel font size", "selection data", 
      "selection over", "shift key", "synchronous evaluation"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "CurrentValue[item] gives the current value of item at a location in the \
Mathematica system and interface. CurrentValue[{item, spec}] gives the \
current value for the feature of item specified by spec. CurrentValue[obj, \
item] gives the current value of item associated with the object obj. ", 
    "synonyms" -> {"current value"}, "title" -> "CurrentValue", "type" -> 
    "Symbol", "uri" -> "ref/CurrentValue"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[27084, 771, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->608962052]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 39352, 1197}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 5619, 117, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[6242, 144, 1577, 37, 70, "ObjectNameGrid"],
Cell[7822, 183, 1773, 56, 70, "Usage",
 CellID->15062]
}, Open  ]],
Cell[CellGroupData[{
Cell[9632, 244, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10110, 261, 256, 8, 70, "Notes",
 CellID->29229],
Cell[10369, 271, 391, 12, 70, "Notes",
 CellID->27560],
Cell[10763, 285, 394, 14, 70, "Notes",
 CellID->7718],
Cell[11160, 301, 343, 11, 70, "Notes",
 CellID->29073],
Cell[11506, 314, 850, 31, 70, "Notes",
 CellID->8079],
Cell[12359, 347, 577, 18, 70, "Notes",
 CellID->8709],
Cell[12939, 367, 231, 8, 70, "Notes",
 CellID->9662],
Cell[13173, 377, 954, 23, 70, "2ColumnTableMod",
 CellID->10224],
Cell[14130, 402, 66, 1, 70, "Notes",
 CellID->11574],
Cell[14199, 405, 1890, 47, 70, "2ColumnTableMod",
 CellID->1838055263],
Cell[16092, 454, 342, 9, 70, "Notes",
 CellID->7475],
Cell[16437, 465, 70, 1, 70, "Notes",
 CellID->28815],
Cell[16510, 468, 2095, 58, 70, "2ColumnTableMod",
 CellID->29343],
Cell[18608, 528, 96, 1, 70, "Notes",
 CellID->431048264],
Cell[18707, 531, 624, 15, 70, "2ColumnTableMod",
 CellID->228772180],
Cell[19334, 548, 108, 3, 70, "Notes",
 CellID->27446],
Cell[19445, 553, 612, 13, 70, "2ColumnTableMod",
 CellID->27532],
Cell[20060, 568, 109, 3, 70, "Notes",
 CellID->565132317],
Cell[20172, 573, 975, 27, 70, "2ColumnTableMod",
 CellID->24758408],
Cell[21150, 602, 108, 3, 70, "Notes",
 CellID->14568],
Cell[21261, 607, 907, 21, 70, "2ColumnTableMod",
 CellID->32684],
Cell[22171, 630, 120, 4, 70, "Notes",
 CellID->4361],
Cell[22294, 636, 1418, 27, 70, "2ColumnTableMod",
 CellID->5472],
Cell[23715, 665, 77, 1, 70, "Notes",
 CellID->25286],
Cell[23795, 668, 783, 15, 70, "2ColumnTableMod",
 CellID->8266],
Cell[24581, 685, 224, 8, 70, "Notes",
 CellID->6089],
Cell[24808, 695, 1232, 32, 70, "2ColumnTableMod",
 CellID->32151],
Cell[26043, 729, 545, 19, 70, "Notes",
 CellID->4604],
Cell[26591, 750, 456, 16, 70, "Notes",
 CellID->17233]
}, Closed]],
Cell[CellGroupData[{
Cell[27084, 771, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->608962052],
Cell[CellGroupData[{
Cell[27469, 785, 148, 5, 70, "ExampleSection",
 CellID->305535705],
Cell[27620, 792, 74, 1, 70, "ExampleText",
 CellID->769215536],
Cell[CellGroupData[{
Cell[27719, 797, 128, 3, 28, "Input",
 CellID->161964968],
Cell[27850, 802, 207, 7, 36, "Output",
 CellID->677650558]
}, Open  ]],
Cell[28072, 812, 124, 3, 70, "ExampleDelimiter",
 CellID->56330427],
Cell[28199, 817, 80, 1, 70, "ExampleText",
 CellID->239727823],
Cell[CellGroupData[{
Cell[28304, 822, 159, 4, 70, "Input",
 CellID->1051742779],
Cell[28466, 828, 256, 8, 70, "Output",
 CellID->117777198]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28771, 842, 232, 7, 70, "ExampleSection",
 CellID->7148],
Cell[29006, 851, 284, 10, 70, "ExampleText",
 CellID->135800110],
Cell[CellGroupData[{
Cell[29315, 865, 158, 4, 70, "Input",
 CellID->316291284],
Cell[29476, 871, 256, 8, 70, "Output",
 CellID->350125359]
}, Open  ]],
Cell[CellGroupData[{
Cell[29769, 884, 135, 4, 70, "Input",
 CellID->320624211],
Cell[29907, 890, 287, 9, 70, "Output",
 CellID->147844746]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30243, 905, 225, 7, 70, "ExampleSection",
 CellID->2510],
Cell[30471, 914, 249, 8, 70, "ExampleText",
 CellID->10396],
Cell[CellGroupData[{
Cell[30745, 926, 159, 5, 70, "Input",
 CellID->15941],
Cell[30907, 933, 258, 8, 70, "Output",
 CellID->75111079]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31226, 948, 311, 9, 70, "SeeAlsoSection",
 CellID->23533],
Cell[31540, 959, 2013, 71, 70, "SeeAlso",
 CellID->468]
}, Open  ]],
Cell[CellGroupData[{
Cell[33590, 1035, 314, 9, 70, "TutorialsSection",
 CellID->25594],
Cell[33907, 1046, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[34069, 1051, 173, 3, 70, "Tutorials",
 CellID->558945376]
}, Open  ]],
Cell[CellGroupData[{
Cell[34279, 1059, 318, 9, 70, "MoreAboutSection",
 CellID->14159125],
Cell[34600, 1070, 158, 3, 70, "MoreAbout",
 CellID->476374225],
Cell[34761, 1075, 141, 3, 70, "MoreAbout",
 CellID->724146061],
Cell[34905, 1080, 148, 3, 70, "MoreAbout",
 CellID->75815984],
Cell[35056, 1085, 168, 3, 70, "MoreAbout",
 CellID->305899386],
Cell[35227, 1090, 170, 3, 70, "MoreAbout",
 CellID->294888841],
Cell[35400, 1095, 149, 3, 70, "MoreAbout",
 CellID->492100971],
Cell[35552, 1100, 192, 4, 70, "MoreAbout",
 CellID->34868524],
Cell[35747, 1106, 163, 3, 70, "MoreAbout",
 CellID->628228373],
Cell[35913, 1111, 169, 3, 70, "MoreAbout",
 CellID->386999558],
Cell[36085, 1116, 172, 3, 70, "MoreAbout",
 CellID->361503167],
Cell[36260, 1121, 179, 3, 70, "MoreAbout",
 CellID->265826279],
Cell[36442, 1126, 169, 3, 70, "MoreAbout",
 CellID->194718628],
Cell[36614, 1131, 209, 5, 70, "MoreAbout",
 CellID->256868130],
Cell[36826, 1138, 128, 3, 70, "MoreAbout",
 CellID->392870886],
Cell[36957, 1143, 172, 3, 70, "MoreAbout",
 CellID->310930271],
Cell[37132, 1148, 192, 4, 70, "MoreAbout",
 CellID->51592522]
}, Open  ]],
Cell[37339, 1155, 27, 0, 70, "History"],
Cell[37369, 1157, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

