(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42239,       1596]
NotebookOptionsPosition[     34600,       1333]
NotebookOutlinePosition[     36394,       1377]
CellTagsIndexPosition[     36308,       1372]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Mathematics: Basic Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SymbolicMathematics-BasicOperations"], 
          "The Representation of Derivatives" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheRepresentationOfDerivatives"], 
          "Derivatives of Unknown Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DerivativesOfUnknownFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Symbolic Mathematics: Basic Operations\"\>", 
       2->"\<\"The Representation of Derivatives\"\>", 
       3->"\<\"Derivatives of Unknown Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dt" :> Documentation`HelpLookup["paclet:ref/Dt"], "Derivative" :> 
          Documentation`HelpLookup["paclet:ref/Derivative"], "Minimize" :> 
          Documentation`HelpLookup["paclet:ref/Minimize"], "Maximize" :> 
          Documentation`HelpLookup["paclet:ref/Maximize"], 
          "CoefficientArrays" :> 
          Documentation`HelpLookup["paclet:ref/CoefficientArrays"], "DSolve" :> 
          Documentation`HelpLookup["paclet:ref/DSolve"], "Integrate" :> 
          Documentation`HelpLookup["paclet:ref/Integrate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Dt\"\>", 2->"\<\"Derivative\"\>", 
       3->"\<\"Minimize\"\>", 4->"\<\"Maximize\"\>", 
       5->"\<\"CoefficientArrays\"\>", 6->"\<\"DSolve\"\>", 
       7->"\<\"Integrate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calculus" :> Documentation`HelpLookup["paclet:guide/Calculus"],
           "Operations on Vectors" :> 
          Documentation`HelpLookup["paclet:guide/OperationsOnVectors"], 
          "Precollege Education" :> 
          Documentation`HelpLookup["paclet:guide/PrecollegeEducation"], 
          "Series Expansions" :> 
          Documentation`HelpLookup["paclet:guide/SeriesExpansions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Calculus\"\>", 
       2->"\<\"Operations on Vectors\"\>", 3->"\<\"Precollege Education\"\>", 
       4->"\<\"Series Expansions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "D ",
 StyleBox["(\[PartialD])", "OperatorCharacter"]
}], "ObjectName",
 CellID->32395],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["D",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/D"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the partial derivative ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[PartialD]", "f", "/", "\[PartialD]", "x"}], 
       TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["D",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/D"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["n", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the multiple derivative ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["\[PartialD]", "n"], "f", "/", "\[PartialD]", 
        SuperscriptBox["x", "n"]}], TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["D",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/D"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]differentiates ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"],
     " successively with respect to ",
     Cell[BoxData[
      FormBox[
       RowBox[{"x", ",", "y", ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["D",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/D"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["2", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]for a scalar ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"],
     " gives the vector derivative ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"\[PartialD]", 
          RowBox[{"f", "/", 
           RowBox[{"\[PartialD]", 
            SubscriptBox["x", "1"]}]}]}], ",", 
         RowBox[{"\[PartialD]", 
          RowBox[{"f", "/", 
           RowBox[{"\[PartialD]", 
            SubscriptBox["x", "2"]}]}]}], ",", "\[Ellipsis]"}], ")"}], 
       TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->28218]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/D"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " can be input as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], "f"}], TraditionalForm]], 
  "InlineMath"],
 ". The character ",
 Cell[BoxData[
  FormBox["\[PartialD]", TraditionalForm]], "InlineMath"],
 " is entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]pd\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 ButtonBox["\[Backslash][PartialD]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/PartialD"],
 ". The variable ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is entered as a subscript. "
}], "Notes",
 CellID->6982],

Cell["\<\
All quantities that do not explicitly depend on the variables given are taken \
to have zero partial derivative. \
\>", "Notes",
 CellID->30729],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/D"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    SubscriptBox[
     StyleBox["var", "TI"], 
     StyleBox["1", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    RowBox[{
     ButtonBox["NonConstants",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NonConstants"], "->", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["u", "TI"], 
        StyleBox["1", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]}], "]"}]], "InlineFormula"],
 " specifies that every ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["u", "i"], TraditionalForm]], "InlineMath"],
 " implicitly depends on every ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["var", "TI"], 
   StyleBox["j", "TI"]]], "InlineFormula"],
 ", so that they do not have zero partial derivative. "
}], "Notes",
 CellID->28028],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/D"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    RowBox[{"{", 
     StyleBox["list", "TI"], "}"}]}], "]"}]], "InlineFormula"],
 " threads ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 " over each element of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->930],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/D"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      StyleBox["n", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/D"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    RowBox[{"{", 
     StyleBox["list", "TI"], "}"}], ",", 
    RowBox[{"{", 
     StyleBox["list", "TI"], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  RowBox[{"{", 
   StyleBox["list", "TI"], "}"}]], "InlineFormula"],
 " is repeated ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " times. If ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " is a scalar, a ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " has depth 1, then the result is a tensor of rank ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", as in the ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " term of the multivariate Taylor series of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/D"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    RowBox[{"{", 
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["1", "TR"]], "}"}], ",", 
    RowBox[{"{", 
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["2", "TR"]], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " is normally equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["First",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/First"], "[", 
   RowBox[{
    ButtonBox["Outer",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Outer"], "[", 
    RowBox[{"D", ",", 
     RowBox[{"{", 
      StyleBox["f", "TI"], "}"}], ",", 
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "]"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8839],

Cell[TextData[{
 "Numerical approximations to derivatives can be found using ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3234],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 " uses the chain rule to simplify derivatives of unknown functions. "
}], "Notes",
 CellID->20367],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/D"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " can be input as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[PartialD]", 
     RowBox[{"x", ",", "y"}]], "f"}], TraditionalForm]], "InlineMath"],
 ". The character ",
 ButtonBox["\[Backslash][InvisibleComma]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/InvisibleComma"],
 ", entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace],\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", can be used instead of an ordinary comma. It does not display, but is \
still interpreted just like a comma. "
}], "Notes",
 CellID->24829],

Cell[TextData[{
 "If any of the arguments to ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects, the result will be a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " object. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->507041017]
}], "Notes",
 CellID->17479]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->288920202],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(7)", "ExampleCount"]
}], "ExampleSection",
 CellID->639900687],

Cell[TextData[{
 "Derivative with respect to ",
 Cell[BoxData["x"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->18700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"x", "^", "n"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28685],

Cell[BoxData[
 RowBox[{"n", " ", 
  SuperscriptBox["x", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "n"}]]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->172]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23200],

Cell[TextData[{
 "4",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " derivative with respect to ",
 Cell[BoxData["x"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->4925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "^", "10"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6184],

Cell[BoxData[
 RowBox[{
  RowBox[{"5040", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "4"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "6"]}], "-", 
  RowBox[{"4680", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "8"]}], "+", 
  RowBox[{"280", " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "10"]}]}]], "Output",
 ImageSize->{364, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13975]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26470],

Cell[TextData[{
 "Derivative with respect to ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["y"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->13715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"x", " ", "y"}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], ")"}]}], ",", "x", ",", "y"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23150],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "2"], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"x", " ", "y"}], "]"}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], ")"}], "2"]]}], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["y", "2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"x", " ", "y"}], "]"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], ")"}], "2"]], "+", 
  FractionBox[
   RowBox[{"Cos", "[", 
    RowBox[{"x", " ", "y"}], "]"}], 
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}]], "+", 
  FractionBox[
   RowBox[{"8", " ", "x", " ", "y", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"x", " ", "y"}], "]"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], ")"}], "3"]], "-", 
  FractionBox[
   RowBox[{"x", " ", "y", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"x", " ", "y"}], "]"}]}], 
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}]]}]], "Output",
 ImageSize->{444, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27178]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31417],

Cell[TextData[{
 "Derivative involving a symbolic function ",
 Cell[BoxData["f"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->6580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"f", "[", "x", "]"}], 
    RowBox[{
     RowBox[{"f", "'"}], "[", "x", "]"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23296],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], " ", 
   RowBox[{
    SuperscriptBox["f", "\[Prime]",
     MultilineFunction->None], "[", "x", "]"}]}], "+", 
  RowBox[{"x", " ", 
   SuperscriptBox[
    RowBox[{
     SuperscriptBox["f", "\[Prime]",
      MultilineFunction->None], "[", "x", "]"}], "2"]}], "+", 
  RowBox[{"x", " ", 
   RowBox[{"f", "[", "x", "]"}], " ", 
   RowBox[{
    SuperscriptBox["f", "\[Prime]\[Prime]",
     MultilineFunction->None], "[", "x", "]"}]}]}]], "Output",
 ImageSize->{215, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19411]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27873],

Cell["Vector derivative (gradient vector):", "ExampleText",
 CellID->14870],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], 
    RowBox[{"Sin", "[", "y", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24716],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", "x", " ", 
    RowBox[{"Sin", "[", "y", "]"}]}], ",", 
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"Cos", "[", "y", "]"}]}]}], "}"}]], "Output",
 ImageSize->{149, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9562]
}, Open  ]],

Cell[TextData[{
 "2",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "nd"], TraditionalForm]]],
 "\[Hyphen]order derivative tensor:"
}], "ExampleText",
 CellID->18197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "y", "]"}], ",", " ", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], "+", 
      RowBox[{"Cos", "[", "y", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1893],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", 
        RowBox[{"Sin", "[", "y", "]"}]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"Sin", "[", "x", "]"}]}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", 
        RowBox[{"Cos", "[", "y", "]"}]}]}], "}"}]}], "}"}]}], "}"}]], "Output",\

 ImageSize->{365, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->552751517]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2661],

Cell["Evaluate derivatives numerically:", "ExampleText",
 CellID->16878],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Zeta", "'"}], "[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15654],

Cell[BoxData[
 RowBox[{"-", "0.9375482543158438`"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13112]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29249],

Cell[TextData[{
 "Enter ",
 Cell[BoxData[
  FormBox["\[PartialD]", TraditionalForm]], "InlineMath"],
 " using ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]pd\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", and subscripts using ",
 StyleBox["Control", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["_", "KeyEvent"],
 ":"
}], "ExampleText",
 CellID->2075],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", 
   RowBox[{"x", ",", "x"}]], 
  RowBox[{"ArcTan", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27035],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", "x"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], ")"}], "2"]]}]], "Output",
 ImageSize->{68, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18468]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4439],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Symbolic Manipulation of Derivatives",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->15497],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], 
    RowBox[{
     RowBox[{"f", "'"}], "[", "x", "]"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29981],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{
    SuperscriptBox["f", "\[Prime]",
     MultilineFunction->None], "[", "x", "]"}], "2"], "+", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], " ", 
   RowBox[{
    SuperscriptBox["f", "\[Prime]\[Prime]",
     MultilineFunction->None], "[", "x", "]"}]}]}]], "Output",
 ImageSize->{120, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10648]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"f", "->", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{"#", "^", "2"}], "]"}], "&"}], ")"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29552],

Cell[BoxData[
 RowBox[{
  RowBox[{"4", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "2"]}]], " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    SuperscriptBox["x", "2"]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       SuperscriptBox["x", "2"]]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["\[ExponentialE]", 
       SuperscriptBox["x", "2"]], " ", 
      SuperscriptBox["x", "2"]}]}], ")"}]}]}]], "Output",
 ImageSize->{187, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6717]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10823],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", "x", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30857],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["f", 
   TagBox[
    RowBox[{"(", 
     RowBox[{"1", ",", "1"}], ")"}],
    Derivative],
   MultilineFunction->None], "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12172]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", "y", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3674],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["f", 
   TagBox[
    RowBox[{"(", 
     RowBox[{"1", ",", "1"}], ")"}],
    Derivative],
   MultilineFunction->None], "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27358]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11687],

Cell["\<\
Results may not immediately be given in the simplest possible form:\
\>", "ExampleText",
 CellID->19736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "^", "10"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27287],

Cell[BoxData[
 RowBox[{
  RowBox[{"5040", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "4"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "6"]}], "-", 
  RowBox[{"4680", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "8"]}], "+", 
  RowBox[{"280", " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "10"]}]}]], "Output",
 ImageSize->{364, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13530]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27454],

Cell[BoxData[
 RowBox[{"10", " ", 
  RowBox[{"(", 
   RowBox[{"141", "+", 
    RowBox[{"238", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}]}], "+", 
    RowBox[{"125", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"4", " ", "x"}], "]"}]}]}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{"Sin", "[", "x", "]"}], "6"]}]], "Output",
 ImageSize->{284, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20535]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29134],

Cell["\<\
Functions given in different forms can yield the same derivatives:\
\>", "ExampleText",
 CellID->8378],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"ArcTan", "[", "x", "]"}], ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2386],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", 
   SuperscriptBox["x", "2"]}]]], "Output",
 ImageSize->{41, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7718]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"1", "/", "x"}], "]"}]}], ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10181],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", 
   SuperscriptBox["x", "2"]}]]], "Output",
 ImageSize->{41, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->22212]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28488],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Derivative",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Derivative"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Minimize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Minimize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Maximize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Maximize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CoefficientArrays",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CoefficientArrays"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DSolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Integrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integrate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1035]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8475],

Cell[TextData[ButtonBox["Symbolic Mathematics: Basic Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SymbolicMathematics-BasicOperations"]], "Tutorials",
 CellID->82228336],

Cell[TextData[ButtonBox["The Representation of Derivatives",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheRepresentationOfDerivatives"]], "Tutorials",
 CellID->8579],

Cell[TextData[ButtonBox["Derivatives of Unknown Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DerivativesOfUnknownFunctions"]], "Tutorials",
 CellID->75862164]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->19288],

Cell[TextData[ButtonBox["Implementation notes: Algebra and Calculus",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#4144"], None}]], "RelatedLinks",
 CellID->10377]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->60830005],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Calculus"]], "MoreAbout",
 CellID->428954177],

Cell[TextData[ButtonBox["Operations on Vectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OperationsOnVectors"]], "MoreAbout",
 CellID->37100382],

Cell[TextData[ButtonBox["Precollege Education",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecollegeEducation"]], "MoreAbout",
 CellID->50760426],

Cell[TextData[ButtonBox["Series Expansions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SeriesExpansions"]], "MoreAbout",
 CellID->431785826]
}, Open  ]],

Cell["New in 1  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"D (\[PartialD]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 46.0556924}", "context" -> "System`", 
    "keywords" -> {
     "calculus", "derivative tensor", "derivatives", "diff", "differentiable",
       "differentiation", "divergence", "extrema", "gradients", 
      "Leibniz's notation", "multivariate derivative", "partial derivatives", 
      "rate of change", "stationary points", "tensor derivative", 
      "vector derivative"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "D[f, x] gives the partial derivative \\[PartialD]f/\\[PartialD]x. D[f, \
{x, n}] gives the multiple derivative \\[PartialD]^n f/\\[PartialD]x^n. D[f, \
x, y, ...] differentiates f successively with respect to x, y, .... D[f, \
{{x_1, x_2, ...}}] for a scalar f gives the vector derivative (\\[PartialD]f/\
\\[PartialD]x_1, \\[PartialD]f/\\[PartialD]x_2, ...). ", "synonyms" -> {}, 
    "title" -> "D", "type" -> "Symbol", "uri" -> "ref/D"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14327, 490, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->288920202]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 36164, 1365}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3205, 69, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3828, 96, 104, 4, 70, "ObjectName",
 CellID->32395],
Cell[3935, 102, 3075, 101, 70, "Usage",
 CellID->28218]
}, Open  ]],
Cell[CellGroupData[{
Cell[7047, 208, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7525, 225, 848, 31, 70, "Notes",
 CellID->6982],
Cell[8376, 258, 154, 4, 70, "Notes",
 CellID->30729],
Cell[8533, 264, 940, 33, 70, "Notes",
 CellID->28028],
Cell[9476, 299, 485, 20, 70, "Notes",
 CellID->930],
Cell[9964, 321, 1419, 52, 70, "Notes",
 CellID->20640],
Cell[11386, 375, 1049, 39, 70, "Notes",
 CellID->8839],
Cell[12438, 416, 218, 8, 70, "Notes",
 CellID->3234],
Cell[12659, 426, 220, 7, 70, "Notes",
 CellID->20367],
Cell[12882, 435, 828, 27, 70, "Notes",
 CellID->24829],
Cell[13713, 464, 577, 21, 70, "Notes",
 CellID->17479]
}, Closed]],
Cell[CellGroupData[{
Cell[14327, 490, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->288920202],
Cell[CellGroupData[{
Cell[14712, 504, 148, 5, 70, "ExampleSection",
 CellID->639900687],
Cell[14863, 511, 125, 5, 70, "ExampleText",
 CellID->18700],
Cell[CellGroupData[{
Cell[15013, 520, 140, 5, 28, "Input",
 CellID->28685],
Cell[15156, 527, 242, 9, 36, "Output",
 CellID->172]
}, Open  ]],
Cell[15413, 539, 121, 3, 70, "ExampleDelimiter",
 CellID->23200],
Cell[15537, 544, 213, 9, 70, "ExampleText",
 CellID->4925],
Cell[CellGroupData[{
Cell[15775, 557, 221, 8, 70, "Input",
 CellID->6184],
Cell[15999, 567, 570, 19, 36, "Output",
 CellID->13975]
}, Open  ]],
Cell[16584, 589, 121, 3, 70, "ExampleDelimiter",
 CellID->26470],
Cell[16708, 594, 173, 7, 70, "ExampleText",
 CellID->13715],
Cell[CellGroupData[{
Cell[16906, 605, 316, 12, 70, "Input",
 CellID->23150],
Cell[17225, 619, 1374, 49, 61, "Output",
 CellID->27178]
}, Open  ]],
Cell[18614, 671, 121, 3, 70, "ExampleDelimiter",
 CellID->31417],
Cell[18738, 676, 138, 5, 70, "ExampleText",
 CellID->6580],
Cell[CellGroupData[{
Cell[18901, 685, 226, 8, 70, "Input",
 CellID->23296],
Cell[19130, 695, 636, 21, 36, "Output",
 CellID->19411]
}, Open  ]],
Cell[19781, 719, 121, 3, 70, "ExampleDelimiter",
 CellID->27873],
Cell[19905, 724, 75, 1, 70, "ExampleText",
 CellID->14870],
Cell[CellGroupData[{
Cell[20005, 729, 267, 10, 70, "Input",
 CellID->24716],
Cell[20275, 741, 347, 12, 39, "Output",
 CellID->9562]
}, Open  ]],
Cell[20637, 756, 175, 7, 70, "ExampleText",
 CellID->18197],
Cell[CellGroupData[{
Cell[20837, 767, 398, 14, 70, "Input",
 CellID->1893],
Cell[21238, 783, 693, 26, 36, "Output",
 CellID->552751517]
}, Open  ]],
Cell[21946, 812, 120, 3, 70, "ExampleDelimiter",
 CellID->2661],
Cell[22069, 817, 72, 1, 70, "ExampleText",
 CellID->16878],
Cell[CellGroupData[{
Cell[22166, 822, 143, 5, 70, "Input",
 CellID->15654],
Cell[22312, 829, 189, 6, 36, "Output",
 CellID->13112]
}, Open  ]],
Cell[22516, 838, 121, 3, 70, "ExampleDelimiter",
 CellID->29249],
Cell[22640, 843, 393, 14, 70, "ExampleText",
 CellID->2075],
Cell[CellGroupData[{
Cell[23058, 861, 172, 6, 70, "Input",
 CellID->27035],
Cell[23233, 869, 320, 12, 58, "Output",
 CellID->18468]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23602, 887, 215, 7, 70, "ExampleSection",
 CellID->4439],
Cell[CellGroupData[{
Cell[23842, 898, 253, 7, 70, "ExampleSubsection",
 CellID->15497],
Cell[CellGroupData[{
Cell[24120, 909, 216, 8, 70, "Input",
 CellID->29981],
Cell[24339, 919, 445, 15, 36, "Output",
 CellID->10648]
}, Open  ]],
Cell[CellGroupData[{
Cell[24821, 939, 217, 8, 70, "Input",
 CellID->29552],
Cell[25041, 949, 694, 23, 45, "Output",
 CellID->6717]
}, Open  ]],
Cell[25750, 975, 121, 3, 70, "ExampleDelimiter",
 CellID->10823],
Cell[CellGroupData[{
Cell[25896, 982, 180, 6, 70, "Input",
 CellID->30857],
Cell[26079, 990, 335, 13, 36, "Output",
 CellID->12172]
}, Open  ]],
Cell[CellGroupData[{
Cell[26451, 1008, 179, 6, 70, "Input",
 CellID->3674],
Cell[26633, 1016, 335, 13, 36, "Output",
 CellID->27358]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[27029, 1036, 226, 7, 70, "ExampleSection",
 CellID->11687],
Cell[27258, 1045, 114, 3, 70, "ExampleText",
 CellID->19736],
Cell[CellGroupData[{
Cell[27397, 1052, 222, 8, 70, "Input",
 CellID->27287],
Cell[27622, 1062, 570, 19, 36, "Output",
 CellID->13530]
}, Open  ]],
Cell[CellGroupData[{
Cell[28229, 1086, 104, 3, 70, "Input",
 CellID->27454],
Cell[28336, 1091, 476, 16, 36, "Output",
 CellID->20535]
}, Open  ]],
Cell[28827, 1110, 121, 3, 70, "ExampleDelimiter",
 CellID->29134],
Cell[28951, 1115, 112, 3, 70, "ExampleText",
 CellID->8378],
Cell[CellGroupData[{
Cell[29088, 1122, 186, 6, 70, "Input",
 CellID->2386],
Cell[29277, 1130, 221, 8, 52, "Output",
 CellID->7718]
}, Open  ]],
Cell[CellGroupData[{
Cell[29535, 1143, 235, 8, 70, "Input",
 CellID->10181],
Cell[29773, 1153, 222, 8, 52, "Output",
 CellID->22212]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30056, 1168, 311, 9, 70, "SeeAlsoSection",
 CellID->28488],
Cell[30370, 1179, 1683, 62, 70, "SeeAlso",
 CellID->1035]
}, Open  ]],
Cell[CellGroupData[{
Cell[32090, 1246, 313, 9, 70, "TutorialsSection",
 CellID->8475],
Cell[32406, 1257, 190, 4, 70, "Tutorials",
 CellID->82228336],
Cell[32599, 1263, 173, 3, 70, "Tutorials",
 CellID->8579],
Cell[32775, 1268, 175, 3, 70, "Tutorials",
 CellID->75862164]
}, Open  ]],
Cell[CellGroupData[{
Cell[32987, 1276, 321, 9, 70, "RelatedLinksSection",
 CellID->19288],
Cell[33311, 1287, 253, 5, 70, "RelatedLinks",
 CellID->10377]
}, Open  ]],
Cell[CellGroupData[{
Cell[33601, 1297, 318, 9, 70, "MoreAboutSection",
 CellID->60830005],
Cell[33922, 1308, 128, 3, 70, "MoreAbout",
 CellID->428954177],
Cell[34053, 1313, 151, 3, 70, "MoreAbout",
 CellID->37100382],
Cell[34207, 1318, 150, 3, 70, "MoreAbout",
 CellID->50760426],
Cell[34360, 1323, 145, 3, 70, "MoreAbout",
 CellID->431785826]
}, Open  ]],
Cell[34520, 1329, 50, 0, 70, "History"],
Cell[34573, 1331, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

