(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    366879,       6882]
NotebookOptionsPosition[    359080,       6613]
NotebookOutlinePosition[    360430,       6651]
CellTagsIndexPosition[    360343,       6646]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Lighter" :> Documentation`HelpLookup["paclet:ref/Lighter"], 
          "Blend" :> Documentation`HelpLookup["paclet:ref/Blend"], 
          "GrayLevel" :> Documentation`HelpLookup["paclet:ref/GrayLevel"], 
          "ColorSlider" :> 
          Documentation`HelpLookup["paclet:ref/ColorSlider"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Lighter\"\>", 2->"\<\"Blend\"\>", 
       3->"\<\"GrayLevel\"\>", 4->"\<\"ColorSlider\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "New in 6.0: Graphics Primitives & Directives" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Colors\"\>", 
       2->"\<\"Graphics Options & Styling\"\>", 
       3->"\<\"New in 6.0: Graphics Primitives & Directives\"\>", 
       4->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Darker", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Darker",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Darker"], "[", 
       StyleBox["color", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a darker version of the specified color. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Darker",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Darker"], "[", 
       RowBox[{
        StyleBox["color", "TI"], ",", 
        StyleBox["f", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a version of the specified color darkened by \
a fraction ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->25316]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"], "[", 
   RowBox[{
    StyleBox["color", "TI"], ",", "1"}], "]"}]], "InlineFormula"],
 " gives black. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->221677888]
}], "Notes",
 CellID->26425],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"], "[", 
   RowBox[{
    StyleBox["color", "TI"], ",", "0"}], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  StyleBox["color", "TI"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->142203686]
}], "Notes",
 CellID->9524],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"], "[", 
   StyleBox["color", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"], "[", 
   RowBox[{
    StyleBox["color", "TI"], ",", 
    RowBox[{"1", "/", "3"}]}], "]"}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->147092355]
}], "Notes",
 CellID->39054001],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"], "[", 
   RowBox[{
    StyleBox["color", "TI"], ",", 
    StyleBox["f", "TI"]}], "]"}]], "InlineFormula"],
 " for values of ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " outside the range ",
 Cell[BoxData["0"], "InlineFormula"],
 " to ",
 Cell[BoxData["1"], "InlineFormula"],
 " are clipped. "
}], "Notes",
 CellID->741047295],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["col", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["col", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " gives darker versions of each of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["col", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->530148910]
}], "Notes",
 CellID->142410365]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->34227263],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->132935285],

Cell["Darker version of colors:", "ExampleText",
 CellID->25812152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Darker", "[", "Red", "]"}], ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->142188391],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[
    NCache[
     Rational[2, 3], 0.6666666666666666], 0, 0], DiskBox[{0, 0}]}]], "Output",\

 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->211416760]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Darker", "[", "Green", "]"}], ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32734470],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[0, 
    NCache[
     Rational[2, 3], 0.6666666666666666], 0], 
   SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->4817333,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->575699757],

Cell["\<\
Specify how much the color should be darkened by using a fraction:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->116085846],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Darker", "[", 
       RowBox[{"Blue", ",", "#"}], "]"}], ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{".1", ",", ".5", ",", ".8"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->90164705],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[0., 0., 0.9], RectangleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[0., 0., 0.5], RectangleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[0., 0., 0.19999999999999996`], RectangleBox[{0, 0}]}]}], 
  "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->390719170]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->510489542],

Cell["With a darkening fraction of zero the color is unchanged:", \
"ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->142203686],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Darker", "[", 
   RowBox[{"Blue", ",", "0"}], "]"}], "\[Equal]", "Blue"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->114867121],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->513069107]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Darker", "[", 
       RowBox[{"Blue", ",", "0"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->141740984],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[0, 0, 1], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[0, 0, 1], DiskBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->308298973]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->40379589],

Cell["With a darkening fraction of one the color becomes black:", \
"ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->221677888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Darker", "[", 
   RowBox[{
    RowBox[{"RGBColor", "[", 
     RowBox[{"0", ",", "0", ",", "1"}], "]"}], ",", "1"}], "]"}], "\[Equal]", 
  
  RowBox[{"RGBColor", "[", 
   RowBox[{"0", ",", "0", ",", "0"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->432762779],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->313567944]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Darker", "[", 
       RowBox[{"Blue", ",", "1"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Black", ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->761992595],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[0, 0, 0], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {GrayLevel[0], DiskBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->322526879]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->434565670],

Cell[TextData[{
 "The default darkening fraction is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "3"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->147092355],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Darker", "[", "Red", "]"}], "\[Equal]", 
  RowBox[{"Darker", "[", 
   RowBox[{"Red", ",", 
    RowBox[{"1", "/", "3"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->402795023],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23652387]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Darker", "[", "Red", "]"}], ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Darker", "[", 
       RowBox[{"Red", ",", 
        RowBox[{"1", "/", "3"}]}], "]"}], ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->104240780],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[
      NCache[
       Rational[2, 3], 0.6666666666666666], 0, 0], RectangleBox[{0, 0}]}], 
   ",", 
   GraphicsBox[
    {RGBColor[
      NCache[
       Rational[2, 3], 0.6666666666666666], 0, 0], RectangleBox[{0, 0}]}]}], 
  "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->409621024]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23973780],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Darker",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Darker"]], "InlineFormula"],
 " automatically threads over colors:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->530148910],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Darker", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}], ",", 
   RowBox[{"1", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->691224926],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RGBColor", "[", 
    RowBox[{
     FractionBox["1", "2"], ",", "0", ",", "0"}], "]"}], ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"0", ",", 
     FractionBox["1", "2"], ",", "0"}], "]"}], ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox["1", "2"]}], "]"}]}], "}"}]], "Output",
 ImageSize->{393, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->113417553]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->142737640],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Darker",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Darker"]], "InlineFormula"],
 " to construct ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " for plots:"
}], "ExampleText",
 CellID->229319239],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"y", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"x", " ", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Darker", "[", 
       RowBox[{"Cyan", ",", "#3"}], "]"}], "&"}], ")"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "40"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->142543984],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->132864587]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"Sin", "[", "y", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Darker", "[", 
       RowBox[{"Cyan", ",", "#"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->37057173],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyF28+qZcUVx/GrdkxMVPoRktAJvsXtQYj4Z5RHCGTiv4Z+hAwdqHRCBhlm
6MCBSCty8DZOMzkkg0TaICTgpAeKiCgqkbt3f6rZ301x7mTxq1W79lqr1r+q
fe4vfn/jd394+Ozs7M1Hzs4u6fp39Q768e2X795++WcDv3cJ7z468J+vPXPr
2jMPD/zJMv/bC/gvC/+Lgf+64P8OvNLjAX515Z/Dr63PD/yvdf2B31jffx1+
Z5Vv4H+v8g98nxYPPUvpC9MXpi9MX5i+WzseDzB9YfrC9IXpC9MXpm/2rXin
F1xKX5i+MH1h+m795HiA6QvTF6YvTF+YvjB945fFu32rXnApfWH6wvTdxsHx
ANMXpi9MX5i+MH1h+ibuind+2X2rXnApfWH6buP8eIDpC9MXpi9MX5i+MH2T
V4p3cVe/7L5VL7iUvts8djzA9IXpC9MXpi9MX5i+yZvFu7zSuKtfdt+qF1xK
X5i+MH1h+sL0hekL0zd1oXiXN5tXGnf1y+5b9YJLt/XoeNjWo+NhW4+Oh209
Oh629eh42NajUfeKd3WhebN5pXFXv+y+VS+4lL4wfWH6wvSF6Zu6Xryre60L
zZvNK427+mX3rXrBpfSF6QvTF6Zv+pbiXV1v3WtdaN5sXmnc1S+7b9ULLqUv
TF+YvunLind9S+t6617rQvNm80rjrn7ZfatecCl9Yfqm7yze9WXtW1rXW/da
F5o3m1cad/XL7lv1gkvpm766eNd3ti9r39K63rrXutC82bzSuKtfdt+qF1xK
39k5on12+9D2ae1jWudbB1MXdnm0eaZxWD/tPlbP0lcup99+4g767K3LBR8b
+NeXy9+6MvD/lvXuXcB/W97/j4H/uOJz+J/r/IF/ua433vvb9X0Dv7TSqVyl
5IPJB5MPJh9MPph8MPlg8s3sVLlKyQeTDyYfTD6YfDD5YPLN9q12qlyl5IPJ
B5MHJg9MnpnfdJ9ql8pRSh6YvWDyweSDyTfz4/pN96l2qVyl5IPJB5MPJt8s
rurH9ZvapXKUkgcmD0yeWVw3juq39ZvuU+1SuUrJB5Nvlmca142j+nH9pvtU
O1WuUvLN8l7zTOO6cVU/rt9032qnylVKPnVRPWx+7v2TcfWyedz8+3eSuzxa
vnXfX9b7asQpjM8+2zp+PDTv9NzVuMdnP+u9vb5vF4fm45v/3f+XvzFffW7c
tK+q3+Lbl61+V3d+1HvO1qveA7auGmf/1rXeQ7Su9NzePN9zbvMsPvvh63dg
9mzeaV/auMdnr96Xtn6yg3mt9/j8EV//B+Obz36tw1u/Px5aF/H5Gz57wexV
vufZr3kan/2aJxu3jUP8Uv1xxz3PXh1H2QufvfDFY+0D45uvn+58fPbDZz98
9oL50yxv1Q+cH2Z+w171G3qbVzvhOz/UPvj0x6c/Pn1bd6pv7y+bB9p/9v6y
/WjvMxsX7QN779W+rPdE+OzRexV8/t++oOe42qf3t+0vxTX7tB/GZ5/2x/je
g2+89jHOPu1T8eWD9mX47NG+CH9bnx7c57Z/7X1n++3eZ7bf3tbl46H9d+85
24cb59/GxTuM733s0z619xTtE3vf2/65fUPzWPPWLM+Jw87HZ8/mAXwUXzzA
ncde+OyFz17t46Pv9Vmfxd9ndU5+aJ7HZ4/m9ea17rP58kXtYj771C747NNx
VLzgw+0b2wfN+iL5YtYHsFf7APvCXo0L+FTcsFft2fvY+knPTfhw77lqv94/
9/zX+9meV3tf2/Mrfuu+/NPzbO9re77t/W3Pu72n7bm395q1Hz779L6658/e
5/a8jM9fen7ufW7P073f7fm69709b+PP/KJ69zzee9+ey42zV++7J+dh/rg7
R7QPPNU3lW999uz5f/v+B3U3eXSaV5p3zGfPzsevX9Vu5vUewbj4Ykf5CBYP
zXvs7PmeZzvevrp9ZvuqfodrnWlegPnPTK+ee8jTvrbfOVv3W+eax2Hy9TtE
z1s9N7RvaN1sXeh3jdm5ln6tG7136ffe9jc9x7SPb51uHWqehe1zz4E9F/Vc
0L6ofUDrXL/bNC77PbX1uX1E6/nML3MOHe/x3l8tzz1+B31omfeTgd9e1vvw
An5xee5H47nXF/5Pp+uUWg/++yLP3XPY+rD1Z3J13VLrw9aHrT+Tq+uUeh6u
napX5Si13szOtUv1qFxdt/RPKx12vbHOH/jmuv7Q6/vFLX885Fr97vHd/lu3
lPyzce83DuPfW/W7wKc/jG8++fHZB8bvPuHTF67d8D3PHvhw/feUnnApfWHy
w+SHyQeTHyZf5akdZ3avXOahp8bJb9z+wPjm0wefPjC++fRrHqtf1A9mflO7
z+Sc6WUcPTVuP43TD6Z/+Z6nf/Wpn/Q9sPVg6zU/NU4aF7M4OuWns32d+cHM
DjO7Vc9S82bj7GEcbl08lRcah/Xb7mP34ZQccOm7i3mevIOu5npyjP/mctq1
b85vLu/5/gJ+fqUXxuHSF1b+mO/5UvMqR6m+sr9r6Pc8fV37PP1af7fT76z9
PXl/v9Df0fZ3E/3dmnHnp34H73eg/g6o33X7+9B+/+/vHPudv/1zf2/X7/W9
H+n3aXKSq9+j8bf30VdHXbHv23uVB78r7PdW5+y3FvrpyMv9LoLW3sY/WsYf
uX5led/nQ65+p6z9er9s3Hm497v9/WDl6P2PdegnXj3fODEuzp5a5n854tA5
Rrzhz+K6+Ofr/BGnjV982DmFnPYfJfcsjzjXVA/vgb1nlnc8T67aoXJH3iF3
82H/j8J7na9qx57vmte854N1v0ef4vzW35EZF4/lGxd/5sP4Xy/14rPz/6xx
MOSCyUGuUudU8QLLI+qT+TM5YO9Vt8kD45O7dCYHTI6nl315aNwP9l7euLgt
37j16Fk7Vg/5hj/JO6hxedF76OV5fHlPniiVN2DrN+/B3uO93oNfu6DGzUPr
p6jx59Z9GFQ+xSc3fuPYPM+Z5znx2XzWe5qu23zS+x3z7bd9gEvJVT+G8fll
/dQ+eO7mou+Hw5/lO/OLS7s/6hw56NPfoeB7v31nH+t6P39iN9h8epn/A1x1
x10=
   "], {{
     {GrayLevel[0.8], EdgeForm[None], 
      GraphicsGroupBox[PolygonBox[CompressedData["
1:eJxNnHf8l1Mbx+/7/pItZbSElmRWEhJSRHYhK6NskdRTxmOkjITsHZqa9pZR
yN57i8deUXhsz/Xuev9ePX+c17l+1/c6577OuM/5nM917l+LASf0GVQVRfF1
vaKoRb5DWRSfRI5ut5BDXaweaaeQ/1OkTa/48dPIl4p0YOi/jnzlSCvFj59F
vkykPqH/IvLlIu0S9l9GvnykfUK/QuRNI20Y9vvF3yuGvHPY7Bzy0iHvH/lX
1Mfzwubg+PubkO8Km0EhLwq5daTV9G166AeE/jt8Dvn7yFeNNDXkQ0P/bch7
Rv555MtGOjLkBZGvEen4kI+L1CzkW8P+6JB/CHlhpCaR1ovUThmf7wibY8Pm
x5Bfi/zVSMNCvif0g0P+KeQHQh4a8i8hzw55WMj/Dfkq2hLp15D7Rd4q8o6R
To7fTyqzTY+G/ciQ/wp5bshnh/x3yPXD/o/I20ZaJeQ/9W2vsDmjTB9HRH5m
pPVDPjXy3yJvE+nwMvuK5zWMsv9EvlGk00O/WeTbRxoecvvIt410TdicH+kg
8tCPLtPPCyI/JdKmIf8caS3r+VfoNol8m0jXRZkLIh0a6cDw7eL4bfPQXxb5
JZG2CPmKyM+KtGXIF0X+70idQn447E8L+feQR0XehbkW6dDQXx1/dw25cdQ7
OeR9Q9415BtDvjDS7j4f/8fG3z2Yg5H2tn07RLoy9DsVWXavIm34bXzoL43U
E3+izqUjTYy/r4t0baRuoa8XunEhj4l0VZl+7cdc1cedI7UPm5vit94hT4u8
1K8ZkVeR9mDOhU2tTN+ahFyvzHqWKtOnAcyxkCdE2oe5Gm2fEvIuzHdevpB3
i+w23pUy23dX5JMi9Q357siXKdOveyNfNtIBId8QZY+NtHr8fUukQ0I3KNL9
IS8XqV/IT8SzHgx5+UiPR1ol0lGhf4h3NtLBIZ9QZNlDGXfmVqQjIj3Cexyp
f8jPRT1zQ145Uv0ybYZGejr0j8bfK0U6J9JW9tu48Ou0SEdGOrfMcaSNx9TS
x9MjvRJln47fVo30WsjPMqcjNYx0DO9QpBdDPy/+bhDpDNuHv6N8Pv4+H7+t
EWlwyO+G/cshN47UpEybkZHeCv2L8Xcj6nY+8h69H/o34u+mkdYM39Ys87kD
Q/9+mX6+E3nzSKeG3Cls1mJ+h/xl5K1od8gfRf6BPq4T+YjIL47UOexb8G6g
D7llmf58Gvl/ymzHWqFfO+TTQv488tcjnR3y5qFvHfK5If8a+ReRLg/5+8g/
5B2hvZGfz/sd6doi5TGRvg59m0jnhfxx5C+wjoT8Q+TzI10U8o5Rf89Iv8Tf
n0Qay5yKdJO+XxLpp9Av4l1i/tdSf2OkD6N/3gp9s0hfRboidJMinRL633mf
Qv6zTL+mRvqrTP+mRfon5O94F5n6Yb8g5Ot5btT/r0i/xd9DalnfnYx3LZ95
S6Slw36pKn1cJvKfw3Z8yMuHzXLx93/j71rkP0Y+LvTfRn5Bkc9aIfSTebci
tQr7dvHbrJDrh37dMv1sEHLbMv1cNeT1Qp4e8hkhV5FmFFkH7b0y0kqh+yNs
prAOhLx+mX42DnmDkG8NuWnIG4Z8G36GfHvkj0bqwrsbf88MeQLvSaShzMHQ
bVRm29cKeeMyfW4T8gO8c8yTkFtEah+/fRl5q0gdmGeRd2Ouh82ZkXcM3f0h
P1Nk2QeL/O0RfWgbNpuGzWzmBj5H2iz+7lymzQuRvgtdu0idQtcj8u0ivRT6
jfEz0hzmCc+PtEXY/IptpC68Z5FvHmkr5mO0rWvkT4X9FlW2461IC0PeBLv4
rUvkW1bpb7cyn/9+pC1ZvyJ/lXkVv29DCl3bqHPbyJ8PfdfQbR3ysyHPivyG
SHuG/Hfod8Dv+HuG+AFcMalKDATu2THkHmXWv2OZeGmVIrEMGAF8M7FKLAVm
6iW2AZOAi8BCjYvEPGAs9mawE/gETDK5SrwCfgJPgXHAYYCvnvFb9zIxFVgK
XLJJ5HcX2eZZYiEw0M1V4jOwExhobf2cUiXGAreBwcBa4B+wE1ihZZEYBwwE
3sA/sAn44bYq8RMY6U7xElhogTb4emPUOTjSQv0Dm4BVwFpgN/AJGAFswL4M
PgITgT/uF0eBL8BK4KQORWIk8AzYo774p3ORuKmjvp3qWg2WAEeAl8A34LCN
bT+4DCwGXgFHgZ3AJ+AosBP4BNyzrf6Av8BL7FXnlYl1ti4SH4GLuhWJc8A2
4IedxUzgJLANGAucATYD04F5wHdgOvANmAr8071IzLS9PoOXwEg7FomXwENg
l6mRgwEOLHKfBF+wV7Kf9rJOsNLO+gy2ubxMLHFNmfvrrkXiGsrSTp4JjgB/
gHnAOGAVsBVYCjzTw9/BLd3oH/EQuHEb+xMMRT2MKRgGTMLeD24BC4Ex8BFs
AuYB1yDjK5gKXEYbwV5gNfAMOArsdFCReGeAfszwnQWTtBdTHVokvgJL9S/y
vQaPgVfYl9gH2KfATuCrw4rco9CzZ7znvg8emFclNgILgdPAVGChJ8VIK1gv
+AKc8bzYBswDXgJjHV8kJsIG356pEieBf8BpYLOjmdO1xGDHFombwExDiuw7
MAu45HXxD5jnpSrxGTjnZTEPOAhMBL4Db4BrwDRnFYn7wFJgBrDPGfoN3qJ+
8Bv4C7w3zPZgA555u0rMBBbCDzAImIRzzyj9A3uAH9jj3isT/4wu8nwEVgKf
fCR2AgN0FtswFuACcBS4BewEXgKXgEPARuCMTmIesApYC+wEngFHgVXAJ+Ai
MBj7N3iYMwLtAk8xxiOKPDuAt48M+Zsy8dDVReIosBl4CZwGjmLPBneBry4r
Eo+BwcA2+Ac+Aa+Ac8BB+Al+QI+fl4a+Ry3xFzgKzATGAIuBL/CzTy0x02eR
dhBbgdv6lrlHsHYuLW4BG/y7Spx0c5EYDyw1sUi8NFV/wEtgJHAIazB4CNwC
hpqm36WYB3wC/mGdBlfQZvAKWApchsyYgqFu8R1ZRtwEPgFDgb/AKFvWEhfd
UyQuA5PdwThWiZnASfdWeX7njLyqGAm80UV8Bd74T5XYCDz0SZUYC1wFplpd
TAMeAzuBQxqLlx4uEg+BU/Dnv2IMsAC454kifQM3gZfmML5V4icwE1gGHAM2
+KxKLMW++pXYCbz0fZUYCGzzjTgKzIRPYBAwCvgImbaAqcBhYBjw5J327Y9i
JLATeA+cB35aIXzrLBbaWIwDdvpZzANe2ki8Rjspgwzu6SRuer1IbAPeeadI
PAWOeqNIrPSWfnYR/7xdJNYCY71ZJD69y3kAbgIvvVskdgJjvRdyzzLxBFii
Ys8qEwP1EDd9yBpRpR36HcQsH7F+hNyrTFy0S5l4Clx0Xuj7Wy/HXH6viuSY
PlW3R5l4CCw0zXrAZj3FY/NDXp+5JJY6JfINxDd7lYmnwF17+37BTZ0TZQ8o
0+bAsF25ls+AzwIfwUEdVCaGQnd22Pcus37KUyec0rmh71dmmUO0hx+BWwL/
gAtHh81h+jykTIwDf3JB6E8oExsdVSaW4rw5s8o+Asvd4nPBXUeoA6fdXmXb
wGCsGwttI7j+fefG+VWeYyk7JuSB2m9US3uwGX0PTgIj0Qf4AJa723bxzl4Y
8onKu1dpz75/X5Vtpj0P2kYw1gG2CWz5UJV+/2obwXLgRc4gnBE+YHyrLAfu
ujp8OKSW9r2rtAfXTQ/dDNfcPlXiPfDStaHrX0vMt0+VWAsstHEt2wleHBB5
A+XpZWIScMUc2wUme6zKsQHzHRa2q9ZSBmOBu8BOh3MWk4th3HgWmBY8RZ3Y
Xl8mbkF3c5l7PVjn1jLxCTjm1KhjE7HLEZE3Up5pWbBN3yr9AsuBrcBA4J97
ysQk4Ifby9SDZ46OOpq6z/E8bMBaHcHR6m+IOlu7pt2nb3AoF7G+lolFHq+y
j8A/Y0OerYxvK9hvDyuDc+4sE7fgA9gFGbzwVJVtBvNcHPIc5Wer9Bu8dEnI
jynTB2CmQ4tsJ30F5jzddoFRnimTB4JjeaHKvgALXRbyk8q0q6H985QyXM2/
HTvaeGnYP1Fmna/aRvDV5SE/p/xGle0EVw2Mcs1qKT+gD2A2sBQ+wymRwFjo
3rS9YKcTq8QY7LGb1RKbgaPese1gTnwBL4HBPrAt4KXjwr55LXHSm9rAI10V
Nm9rM7/KdmJzZcivWCdjwLMYE/oNbHZKyMdWKYNlwC5gLXDSGbYRvHU8uTL1
gaVGFPnM1vpAGfRguUFh20JsR/+t5RjxDGRw0Zm1bH9L20KfgA/pF+oEb4yw
vWDK6/Czyj377zJxBFgHO36HOzqL/Uv8UU/sAF65OuRVqtRfE3lDccjZYTtK
DFGIL8BGI/FLLDI88tbKq2kDVjm6yvGFH7s25EZV1nNF5C851iuKKdjvm4lP
2KvPi/rOEX8sqx5c10SfwTDXh7y25b/QZ97TlcUj7M20CUwDnhkXckv/Xkcb
eIBHXOdZD7+usg1gFdoERgGfLKjy2eCQ9arUw4d8a7vAOb9UWS846iZ81n6r
WuIl9pfmYpU5IY/HF/9eZFvALTfST9Y5AV/Ub2rdcCknR53r1RJz/MG4iV02
ExOBbX5z7QLrtFT/hP3c2T48iblQy7J/6fO2thHMAz5bX4xEe8FJyOCcrbVB
t659Bn7rWss2g4Hai3PAZmAdZLDNP7arDuuQz2dPqGU7wShb1xIzwRuBheCU
GhaJl+CLGhSJfZDBP+AncBRYi3hWT21WjDp2sk76hf4A44GVqJPtCc5p1zJj
atPFSzwLHb+BrVbVDo5nkngDm22rbCsYYqJlee7uZXJW1EkZ5NXN+Q1sBn4C
qxEHBKdQJ88BO8FrNSoSNyGDncBSYBu4rzvEM4216aP8pTKYC5wB3gBfTda+
kTZgu7o4475lcnHk+6jHpq91LlTmnNXEMuA0sCi83zr0VZW8HvWAFeHN1iwS
L4JvwDbEJQ9QDw6Ec2teJAZEBjdS737aTxFTYX+z2Al7sCP1gzm3qWXssw57
Hmx777Es9qw367gWTdNnxog4Gnhv3SI5zMNsC3HJ/spgUXjCFkViPTAZeGym
eubAbMvW2cD7tXHcD3dMZ4nrsCG+idySOVNLm1ZFYnqeC7YExx7pWBNv7e3Y
gUvhHOEbwbRHq7/NtvDc89XTrt/0uY3jeKxjCt6GZwSP3ekaiH0zf2Mc2ilj
w/o40OeCVY93jMDknFU3KBIDD3K8wKLwdfCQnGdP1Ia47QnKc9VvWCR2BE+C
88HM8IdwkfCcQ7QBR8NLgqXBz0MdI/D2YG3uU2bc97UeeDfwMvwpmBku9GR9
4ze4Ofi91v7Wyn472bE+wLb04F2skrPsqA1cKngb3D7M8QWfD9fP/bXvXiQG
P9WxQIZ7BZOzB51m/4Nj4SjB5PCt8K5wrWD4030WfiDDR4LJR9qf7bTnnMKY
wdOiO7hKjhTOcO8q9fCr4PERju/e2mxhuRHa0N6T7CvsR+rbflXyn92K5Crx
GX4SDA4XDA7njHC243JIldwstvsob+kYwbXCFcMTwwlvV+T5AT1nhDHxjoyu
5e88d7Q2jO15zpNTLMu49Nc34hScKeBPie0yhhc5jsgX2K7L4S1rOVacY67W
/wFVxsx7298X2f/0ETz25s6NsY7vhZ6b4Ov7VZnDdXN2wQZ8Th9RP3HqpVi3
qqzrsCp5YfhnxuEyx2L3sNlNu+1YK6rkqbG5wjHtZ1n45FHq6VvOMfDF+/ks
6oQnP6JK3nhfx+Uq61m2lnPlSvuMvtvfcbjGMeL8AicM5wo3zvmNsxs5f++h
/jpl+vAmx2KMeuZMZVls6OMb7WdsxmnPON6gzVHKcMl9Ha9x1nVtueQ+w42O
xSmOLzL9BlcOT05fjndc6HPawnmR/htv//MMfD6U+VnLfpnomE1xnjMOk7Sn
Pydb//Vhe1Qt/6aPsIFf5Qy0+DxR5DnyZuckZx94Y85Dk2vJh8Mrc8eAcyXn
R87K05TpNzj9g5VnqsffWfbbDdrQbytoc7D6WfZhZZ11Z3Ge1c9+vkV7zpSc
SfsXeScBeUCR9xY4k3KG5Tx9mzJ9eYftZo9gnV9f/Z3a0B932SecueH3j1Z/
h/1ZX3vqmax9X/vtbuckdxjusSxn50f0k7M58YiB2nO34xjl+7SnT4g9cB5v
qB6bxy1LPxDXmG09nIE5xzJ2nPGJaxxnPQ/a/9y7eED7CfYJ8+o16znO9uIz
8RHO+MRBTizyzsnD5ZI4yCPOB2IoD1v2Fn1mXJ61LGNBPOUx6yFuMseycAXE
SOo4hrn2/1vanOjY3W4971oP9pz3iZsML/KMTIzkrCLjKU+q547HE8ofqj+p
SG5hnjJnbM7a8AnwBk/bP5yzX/ZZxGWe0p53BJtTlZ/xnSHexLl6hOM1z3GE
fyCWQxyH8yYxDuIxnKGfU88ZlPcL7DdIG87xza2fZ3EmfdH6ieO8pP0b1k//
E1d6Tvt3tKcPwZUvWRaei7gjexdn/VfsN/x5x7LwD2/ZXvgJYj/wGCRiRcSJ
jqkynjJKGf3Z2hMbOkf5TfUvOF7Mq8GWJUYDN/KGY9RKe8rCaRDTGe0zXyuX
xJ7e1gaOAZl4E7Ef7K+x32jL+crvOUZX2S7sj6syxkTs6fgq41DEnuCPnrC9
F7Mn1tKOMcPmdMsS+yHu0z1+H+rf/P6R9bygTLkhVcZsrnV8P9Gmd5TdM9K/
wGXq4UJPqDI+dZkyMSViVfQ1+pHmn2rzuvIon/txuYQH+th5ciU8WaST7PvP
7X+4rK+UT64yZjXRsSB+Bpdzcy1tJjF/bAsxKTgb7hvB28AtETMbY9nPHa/B
1nmZ4/ONY0qfYE/87JJa9iPxte3NGRd8JT41vsi++cF+o78XWPY0ZeJf9NNP
9hX9ij1xuj3sY+Jkw6uMH1MnZdARLztRvoj4GbwXNvBgjMtC62ltnzD3Fvks
6oHPIdbCvY3T9Zm41WX2eV0s8Bf7Ab6IOCBxt+HKxK2x+dX+P7XKuB33i75S
zxiNj/qG1TJWR79jc6Vjh25Ckfd24Hwesh58IwYEt4WeWBt8FX7gAzwafFxd
TPEv3yPG+R/HGpmxn2Z/Enfk7tYCbRiL9bSZrh4b+pi6/7L+v3zWVMeu0h4+
Dpn4G/1BrJQ+IRGzJF4JH4h8qzr+hhukv4lf0udwb/W0QU+Mc7zjTHyUsV6o
PM5nLWM//GyfUPY365zgmC6vDW0k3om/xAHhB+EG4QSxIZY32d94X7ivBcd3
b5G26OH94ARXVKb/iavSJ4wVd8uYS/B/KyvDf9a3nj/UU5ZxIo7M+gc3yrPg
EuFQ/7Sf6ddV7WdiuA2t50vl+2xXA8cXfrWBeuK2qynTt2vY53Bpq9kPjBnx
XHhIeNQ1nHsz1c+wLPHdh517je1neCn4qfds71q2i75sap8TR25inZRtZj3w
ycR85xZ5l6y5cmdtHrGf13SM4GqxmVPknbcm/+dPU+3hbPHhsSJjymtb50/K
6OFyW9iHxJfXUQ9vC48Jh8n5lPMq5yNiNMSXnywyBg3nOc9+a2Mfcneupfqv
tafPf9eesk9pT8wXPhROEx08LTHll4vkO+FG4ULhgNtWS3jgtr778KfwqM9r
gz08Krwusezn7MMN7J8F6ul/7uCtrw0c8gbW8716ngUHTJ/AXRMf31B74uzr
2pZF+kzfEgcnRg4HC9e8sWP0or+hn6P8qDbt1UOOwtO+UuR9v/b2A1x3B8eF
mHtH9RPUYz/OcaTPuWOwqXp4WGR4bPjgHj4LHntz/d+pljH+zRyPLRwLOOzO
zgH6dEt/JydOT4yeGOn2VcZJR1RZllj+VlXave04dnFc8IG4Ozw03DA+vKEN
9wPesa+IE8Phw38T74cDhzPfxv7vXqXNB/qzlc99SZ/q6sDufevp6pjyrK31
Dd+x/9ByPZRZk1m3ea/hz3ewz+G14JvgmuCQuZvY0n6G955fJL/eUxnem3uW
cJLw7T0dF7ht7lnCWcL9cm+yiX3OnYnXtaEsfPhu2sNvwwdjD28M74U/8Gy9
asm/cw8UjnM3nwuPB8cHbwO3BMcEbwOfs7ttOUU9/Ax8MPwy37/A28AtwsPA
ycCLwaER7+jkfIOX621ZeLY+2sON7VUt4biQ4cfOcj2BM+EczNmbGC7nZTiI
PfUNrgoOBI4FDgse7Fz18Ih8+wA/tZ1+wg11L5bwVt3o11refYRr2tUcG3iz
vtYJl4YMBzXWeuCs4JO4Q9lTn+Fq4HPgLvqph0s6SPlKbeB2uIc4wLbg/yHq
4aL4bmQXy1L/5sUSDgtO6Srt4e7G2CdwC3AO1NlbH+BTOPOC6cHxF+gD/Ajn
9wnacMaHwzpcGczMOQdMO0k99pMtC08F9uaMB96Gg+F7D/gTzsVwFnAaa2jD
ueAG9ZyX96nltyr0y6s+CzwPJgRDg/0+1OcL9X+g8gfKnE3A2Jyd6s4+yKO1
OV577v5zrgCLzlcPrgZjcz7h7MD5AptLbdcgbV7XH8qC80/UNzgJeA14CLAf
GB18CMYH64Mrv1MGK4ILuAc2w3YNVX9FLe/agdfBY+Dj8UXiN3RgNu4kg8s5
Ky3S5ib9H6YN+IQ7W6zJfTz3UA9388DK4DqwM98tTFEGK4Pd/lBGD4birh74
ar9afm9AXbQR/AqmqmwL+/lN1j+xSPwJdqy7/498u/an2fYH7Dc4B/Z2fF4c
my4zRsI9H+KExBQbuD5zz+YD115k1m3iSMSriCnsoP0nRcYPiU0ShySuRdyL
2Ecv9cSGiNsQzyNGs782xMT2VE9Mjz2KvYp7ZQf6LGJcXzkHOCceo8/ECIg7
EZfiftRhyi2KjB0Rk1unyBgXMjElYj7EjbjLRLyFeAmc/ED1xHTg6ojlEEcY
rA33lwapX+Q8nGd/wnuNdZ3E5i7bDhcCnzKiSD4JHgqeB74Kzos7LXAVcEzw
AXA5cEbcRYFfgdOBt3lCG7iLJ7WBM3lWG+6czLFOeJi5Pou7MS/qA3cM4Jng
sLjj8YryWUVieXA/OBPeAv6C+yFgczA65wbiHazz7AvgbvA35zwwL/gYzAue
BdeChRtaFmzZSHtwXXPt5xaJc7F/rEhMCk6a59yYYh+C9cCL4AqwKhiXuw2t
lZ90jk107rXTnjsDYEawI3cPwGVgMvb3DdWDJ8Fx4FrwQwdtuGOwiXow4Nv2
ybnO+Ym+Iy30GTzeT5+/dj5Pdp7vpUxcmpg28fK6ePsk3wvm+c2+U8zVac7n
Q9R/47s51TncS5sG2k9Vru84cj7jvZhu/b2Uv3PO3+t8Ju5KLLYu3j7z/95T
Yq5r+H7N1Ia14lbbRTyWOGsb/bxP/4+07A/Wc6vyMdr/4DuF/c/WP8t3lvpv
9908wPdokfo7fd8HKv/oWnS382QvyzbyPb3bNmJzjzLvPncFGmt/h/UM1qa5
Ze/13Z/te32cNve7VtCHc7TBn0f0jfXnQdecIdrTxqHq/6v8gDbYz66WxGOJ
m/7qmM7QZpg2LRyvh5SJkT7sc0fqz9+ue9T/izb49oc2j+ozcci5tuUE9X/Z
rrnWc4z1/6498ct/XPced607TD/r7qY+Zp3Ttenn2giGJC7wSZH3fiv7dp71
4B/3MDdzbXzedQyZWMuAIrl/YgDEGW5Vv5Lr3jPKrHvEY+D2H1EP/w+v/6z1
PKq8svUQL+mv/VPWc7v1YPOY/iATr4Bfhltm3SYGMFwZPev2k+qROQ/96doF
rw+/D2fPXkyMpI7jJx7AGj5PG9b2p7UZaF+9qsya/5pzEhu4+FPdI4hDNLVP
3rTtz2lD/fThG5ZlLyDOMcQ60XNH8XnLNrLt7zgW7CNvKWNDbOBM97i3tZ+j
TSPbQlzqaMtSD/vObP1fzb76wD5kP3pPmzdsy3DLoq/bQ9/9PxvKsk/Rt/Pt
N/avD5WxgceHR31buZnP/VAZHhhcOt/xfdGxYy2Fw7rXfQqOhn0NbgMOgrPq
murnFslDwNHALbH3fWFZ9la4OfaI9S3L3rSW9o+5j3yuPVwXXBg8GfssnBT7
ZhNl+K0W1s8+CM8B3wEObaXMnsj++JU27L/wMrOtZ4F1ov9Of9pq08l64OzY
uxsqd/C51DnPffY762lnneyznDt/1QZuA74Dnob9F36EvZX990ft2aPhyOB/
2HMX2p9N1GND/y9Szx79k/3W0DECnzS3LPv1JtpvYdmflN9ynhCLa6cPzzl2
v1hnB2V8bmlbOPd3sC2v2Le/2cZNbBf4Ab7kd/ufcflDuYFjSn92siz8Smvt
67gW7Ls6TxZ/g+oaArcCl8b9Ur5jYRy548VdL7AB/Ac8CNwG8t/6A58Bb/WK
Y1Eqc4+Q+4SfFDku2NTxItjAl+zlncMQF2Mk6tzOcfzH+vf2vln9Iu9TcK+C
czNnTGTO45z14QI4K+/r2RP9Lt5b2K7I+fCXY8EZfVltdjSuQbwFjpwz0YQi
vyWkLHcluIuAPWfr/bTH5iTtORvBncGhMY7E9/m2kLs0fPfBN7TcOYSXWdG2
HyBX83GRZ3/uscADHKg9uGjx9x61vMcIl8J3odw1WqAeG74j4LtTzhR8R7CK
9Vyrnm9Rd7dP4AD4xqCB+v3l/V4LmUHg/jnfb8JRcC+H/2vBNwW0hX2WvRk9
PAnfIDTUZjnLYsN9DL5n41s2vh3gu0f2Pr4f4A79oUXG3Bup584DNtzV4Z5J
Pcero/XARfDtAN86sidyF5dvfuDYuX/O/zvg/wNwtmmqDe8e97TB0uw33Bvn
jMO9cb7Hgyfh7jhxPmJ8Xa0TrN7GstR5sfZ8n/it9pRdfGe3lpzk2taPDTwD
3+ONLPIuN+8R37gRoyEeRwyhnfIsZe49E2vgjjpl4Sg2Vc87yFmV76A4+3M3
nXgesbxFythzrxgbzrOLufRacqqs81+7JnDu5fsj7rVyT6mjfQun1N5xgffj
u+tm2q7vvOV7JfTwgSuppz7m0kbOSeYacxEd9y4YL+5BLdSmrfnGyvBs3NOC
y2qsP3wDwlmdb6O4a8p3KO21gRProM98K7Gpc7Weep5F3L+TY1qz/sX/z6TM
u/1nFXlPoLN9WM85w1zl+4JOzpOW2jOOfBfQ2bKt7M/F99XL/L607ruAzZ1v
xIC4jw13TYwUfgp+qbN65hhzjTmHLXeq4ArhCVnnuF/LWgdfRdnPLNfVsqyX
3NVmzeT7Ar5v5LtLOKguziW+F+jifIMvpP7F9+pqyUeBQy5RhteC/+POFhwg
OAW8Uset7agP8EDwTXB4fEO6vfVQdzfrX0aZNvH/aqiTNYfYMWVZM5ezTvqG
uHZv64EP42/4LtYq1iz4Q/ha+Fv4adYqYhWsV+hY31krWEfhvllLuY8Gz9u9
yPLcP4ObJc7Md5hwVstYlrq5i7ir/nMfbTd9Jm5PHB8+j3uOO/ssOL097Ddi
wsjweT1sC+34wbbRLuLqcHbji6x7d+tnHNn/tndP28f24ltfn8U9hz72P3OD
vZD71ktrz/4F19hdf+pZdpw27IUTXZtZx/vZV+w9xCoYC/Yz9jHea/Ye9pzl
1TNek2p5Z5r/d8B3b/wPAmINrNms77xnK1uW/Wi0tsQXuCOIfbci13vsWfMZ
R/YeYkvUz/9TaFnk/2jijMbeRM7/Haj7P1DIcOPsb+xzrDNXW7aDexr6zd2j
2J/YmzjrHqLP19gG7Btqw562mv3DS0VMjnkyp8h7hXyLzt051mbWaNYG9pzF
e4/rHPsTawl3ibDnvk1T9exH8OpHWQ93cPjmHX57Si2/geceGt/f8G3yneon
azdQG/aXY/17ddd+/GH95/8ULfa1yL0L39i/2LsWfytV5reJfKPId9drq2cv
G6WOOHgz6+dZ2POdNrw0+xV3StizlnVeMfdO1Ab9YG3Y66bW8p4N7eFszpma
8yD3PfgGm++v+T8V1zgW7HXgTvY71mzWfdb8Vurbuaexz73p/sCexH7EPgwm
AA/ASXFXgHsCbbRnP2yrzbb6hg8Ti7wXwbrAmsD/rhmmbxtaP3sR/3+Ab/xW
8T1i7znQ8T3dPmffOMN+5vmsyzc7FuwN7AvsJ+wl7CPtbWPNPQSbNuII6mEP
6qx9S/ECa/pM+23x/ewy37Ux9iHv3GhlxvRsx6WLZenDVurhVBnzUdrAq57j
3ONbsHPthz9tD21hLM9RP1SbOc7b89Rvav+AB3nGKOdVna8dXQ9oQzffaf7f
Cu/1GPX4f6F61oFzrR8f0fEbeJm9hT2G9W1L+3xdcfSFll1aG9Zb3qWxzm3e
UcaV9/R0ZcaROBQ2vJvsV+xb7FP8Pk6b5dSzNrJvsH+wj7D+s6eyb2DD2v2Z
+wJ7xvW+v9w9Pd61ZXGdtVzzqYc9aA/t2UfgUrBf3XrYd+e7n1A/6zbr5LW2
t77yH655V9uf9Nt12mxvPd+7Jl1vu/prw5iwpvLNDGsyfCAy6+jB1onc2LKs
bTyLd5mxJYbCu8/7xRo2xfbyzvH+885RD+s+cxZccZN6xnqCc4n1hNjYDc5t
9qBW7uPYDHU8L3ZM11J+33d6vPUQB59oW47VH+YCsTXqX+jvk7TB96n6jx1t
GOT857dJRX5byv/XGGu7btKed4o1lvtd5NOUiZlOth+6O0+utyzPGqLtdNtL
21l/qe9/ieKpqg==
        "]]]}, {}, {}, {}}, {}},
   VertexColors->CompressedData["
1:eJy1nAtU1WW6xlFxtMK0Aq+kaF6IUdO8dVFfLacsPeao4SVHiVHDvJuZ1wat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    "]],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-4, 4}, {-4, 4}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19803942,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->412805249],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Darker",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Darker"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Lighter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Lighter"]], "InlineFormula"],
 " values of a particular hue as a color function: "
}], "ExampleText",
 CellID->367264277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"Sin", "[", "y", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"#", "<", "0"}], ",", 
        RowBox[{"Darker", "[", 
         RowBox[{"Blue", ",", 
          RowBox[{"Abs", "[", "#", "]"}]}], "]"}], ",", 
        RowBox[{"Lighter", "[", 
         RowBox[{"Red", ",", "#"}], "]"}]}], "]"}], "&"}], ")"}]}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->417549239],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJzEnXd8V8Xy9xOSEAIBEtKIigXFgmLvouegFOFiReVaUGx4LYCKqChe5IoK
YsN2QQVsWNBrQ1QgKhYsEBUUVCQoEQMGIyRAqCE8eZ6c9+4zn8O5/J6/nu8/
39ecmZ1ts7uzs7Oze102+Owrm6SkpLy2R0rK//7XX/jsrBP2mFEWWLjKwdXv
l1734321gq9z8Jddz7172rrU0NJnOLhtp67nbN0rK7Tpsx38zn0Txu21f46D
G/nlOrisPmdYt4/yhH+Bg9OHjO5/9XlFkl+xg7WeO/6vcjD1tfg6B1NfS5/h
YOpr02c7mPpafrkOpr6Wf4GDqa/NrzhM6scd19P/2/pWSX2rpL5VUt8qqW+V
1LdK6lsl9a2S+lZJfaukvlVS37ic7rgffT31n/oCU19Ll+Fg6mvTZzuY+lp+
uQ6mvpZ/gYOpr82vOEwahzuW06pYvSze/9v+rZP+rZP+rZP+rZP+rZP+rZP+
rZP+rZP+rZP+jc8zOx6HVbF+03oB6z/1Baa+Nn22g6mv5ZPrYOpr+Rc4mPra
/IrDpHl0x/NMVUwutd+0Xpbe/1t5zgitPGeEVp4zQivPGaGV54zQynNGaOU5
I7TyHF8ndjyPVsXGncql9pvWC1j/qS8w9bX8ch1MfS3/AgdTX5tPcZi0Du54
naiKzSs67lQutd+0Xja9/7fjNzu04zc7tOM3O7TjNzu04zc7tOM3vs7veB2s
is2bOq/ouFO51H7TegHrP/UFpr6Wf4GDqa/NrzhM0mN2vM5XxdYFnTd1XtFx
p3Kp/ab1svz8v52vcmW+ypX5Klfmq7ietmM9piq27um6oPOmzis67lQutd+0
XsD6T32Bqa/NrzhM0kN3rKdVxdZ1Xfd0XdB5U+cVHXcql9pvWi/L3//b+blA
5ue4nr1jPbQqprfouq7rnq4LOm/qvKLjTuVS+03rBaz/1DdpH7FjPbsqppep
3qLruq57ui7ovKnzio47lUvtN62Xza9Y8isN+G9MX+HgRv5pjq6RX6aDD1q5
vccDfzV38DkX3nLIW6NaOXjL41MHPHN9oYNbnTnggsM7t03MV//JH5j8gckf
mPyByR+Y/JPqqfnqP/kDkz8w+QOTPzD5J7Wr1lPz1X/yByZ/YPIHJv+kftR2
1XpqvvpP/sDkD0z+SXKj/ajtqvXUfPWf/IHJP0lOVW60H7VdtZ6ar/6Tf9K4
UDlVudF+1HbVemq++k/+O7aTlMq/2hdKI70sxfGx+mip7Et0PlE9X+cX1Yt1
vikLVixZfWOrKfmSX4HwK0qYj8pcO+943tf5ivJudvMT9Qe267nHN36vkX2b
n2fAU3/g7/Y6YsTwxW0cPfW182RBDG/5FcXkGjz1A9Z/6pv03eqr/rtNl+r4
0x7gqT/wh1fdMnZVy9xY/YHB2/R5MXrbTwUOT/uApz20X/97P9fG2sWOg7pY
O4DXf8YrdMBWbnJj7QPerv+bXf3BU18dp/993FbtRK5rY3Jtx3WdwzNeFdZ9
nLaH7nvAU3+7LudJ/cpieovaT3S9t3qZl0u7Lvt9ta6Lug/VdQs8/aPzutp7
dH22+7yaQMsFbPXnzNh3q0/7dRw87WvTF8XWHbXX6Hpu993xftd2U31D7Req
f6gdQ/UQviP/Nr8C4VcUW8dJb+f/7MRxqnKreNqV+qp+o+0OjLxAT32sXBXE
8JZfUUwvAU/9dN7VeTZpXma8K72dt1NDnbd0HABDp/VP+s741+923SxweNoH
PO2h6+x/X3drY+uS1UPqYuuQzsPaj0n9zPyn7QCe+mu9wes/4/O/601VO9Ez
amN6hh03dYGOu6RxyHyZJNfUX+Xa6ud5Ur+y2L5T7RWq79t9stcLdB5kHlD9
X+0Tuh8Ar3Jn9XpvX1H9XM81VW/TdUTnaZ3HdNxrOWz64ti+Qe0dqifpOmvt
RJmCz4uNM+0nYFuPKjm38/qp6mmqt1g7ZFpo+cTnQR33Og6ArVzVij3F68mq
J6reBGz3qX6e1XlGx53mp/Ow6nN2H5IbJvWbtb9lxspp9VuvB2k6tdPqvKfj
CJj+1/MCXZ9Ub1Y9UuupdnFdb3Qe1nkJ2O6vcp1c6z5F9XbVY7VddJ3TeV/n
Qc1P10Gdz7XcSeNO+6Hxv1nEZ1Hw6Enn/lj4RlsH8w+d/h/92dIu533fIvG7
8tX/xvKVBPxDn/S9ffP2p3+W2dzxHXPpLUtP+6rI8VG+lKexPZq6f77Dj+/A
4OGv7bSzdMD6T7skfSc/vlOPpHpqOUkHDB2wfrf2IM9Xv6vdWdt5x/YX/137
Xe3paqfVcwW146kdnnlJ2wU86zx4K58ZMTuvnjOoHVD3VZqPlot2QF5UPoFJ
D73KAeW246JC/EjK3He7/pTJuXSF6x+7Hvhy0V6UG3q7T/Plgt6O0wqxA5YF
aufV/aDd7zSN8QW261OKzL9pYqdIkfUjVdanFJl/00TPTZH1IjWC093/iFET
lo9aXuhg+Oj+wc7XqTE8+UKn+wA7DgpiePvdl0v/tZ+1HxvLVx7w3+ufE476
Y1JL953+V7mmnzSd/tv1rUL0q6rE79ZuV+3+7fpYIfpWVWD3+TXil1ATHDds
dKumT2HPqnb5JKVLysful6sdX77Dz9LlJH4Hho/lh72iPgDm/9q5S9esLSpw
eGClu/Sv7bUHHJ4fS8c/eP2udsNGfaaJy8/6A6Q5/tDpvnPoS7MqZ23z5bXn
4GkuX9KrHZHvlFfHOfmTj+5D+U56HYfkD53aLXUfq3Js50P1a6yIyZWdH9Xv
RM9bvR+Zyq2e69vxVBYkzZtqB9R5S89F6Ee1i9l1Pi82b6u9kPnDtqc/V7fr
YlXs/FH3F3Z/kxM7Z1Q/G+Wn/js6jtWPwc4HXi50XVE7p87reg5E+6odUP0n
9JzI2iE2O9iWs1T2o9BXuv9G/usczHgCvvjYcw+47ZrWDj7lvAHNvr0z18GM
H2B7flETywf+wNYOXePyA2/npXWxelt9bXNg9bXNgbWPbI7VU8tl98MpIeUB
T/2B7T7Mn6MpH2D6Axg50XNGrQcw/QsMP0tfGWtHrQew/lM/YNofWOVM5ULb
Scut+cAfWOVW203rTftb+25lTG6Atd21nlou+Os5pfa7lkPTWXwTt+9k3QFG
v0PPgp56oZcBo/dBDz/w7A+ByUf5AsOHcvCdf/RJYNoPGD2Q9JQnqR6kB9Z8
SA8MX/LRcihf2gd6+IGnfYC1XygvMO0DX/LXcmo+wJSD9HxP6jctp10nS928
RbnQs+Bj/d0qHd7q16lOr6U+wLS34nVckT96lpU3Xy/w8CM9sNXDql07K578
+dd9g87r9pysiYMZ76rX77h+NSIHfn2z+nF5rF2T2l31fPqb78gLeMoHXvcN
qvdTPrtfro7B2q9JckD5SG/3Vx4mPe0LDB5+yLHaz/S8XPF6Dm3tdW1j9HYd
SnXjkHakXowX7QdtZ62n1iupHZAn8qe/7Pzj5w3w8CM9MPIIzHhRPPnTv7ov
1vXbnt82cTB0um/V+kFP/qov2P1ceWweSJondN+r7US7ajsltaPugymftd9U
x2Cdh5LmLcpHeisn+Yn9lNSvKudW74yPc/pPz5GT6km+apdJmkftuUxcblSP
Tpon9Nw5qd1sO3s7T9I8TXmS5PKlTTnzXr6teThx1yMW/PpYlvvnu51vimU8
+Plbv1u/Ct8O1v8kTmfL7edz8HacpMTsFvZc3tshVY/T8aT5ajq1ZyaVg38d
X/odfnxXe2cSHXJq9ZuaGKx0SenULoic2X1ibgwmnZXrallHPD/NT+mS0pFv
UrnUTgqd3e/lxmClS0qnds5GOMX9799nwFt3/pKf+F3/mVesn0ttzG5g7W11
Ds/6qvsla/fKCS2/3Ni+1fol5jk88yz8ge05zCKn5/HdwqWBtWN5vVD3WexX
dN9l5+d0127sL2x+2Q625zhVsXVW9zHsK3Rfo/tL229l0k++H+05yTrxi6yV
8tbIPYdalx/prR9NrbRvXaB+D7b+deKfUuf6j3nO9qfXl60/Roab56ydJtXt
9+Bn+8frkcDWL8nbDdTf18pJamwdoVy0N3KE/Fs7Q0FsHic97W3TVzu5tHZm
387aDsDMF1auvR+lvQ+W6cqnfkgqF2ontOeLvt9pD7UXWLt3jvi/xu1U0FNe
8LQX/O34yHbyhB7KeLFwqZundJ+ndhTaUe0qVj9Kd/WiXDa/bAdb/++cmN6s
dgrmB7VbqH3FzrtlMTu09c9Jd3qulSPf7mrnBE9+pLfjx+encqb9CGzv9eS5
/kP/sH4zBTG7hh2H+TG5pj/gZ/0UCmL7PuYHtRuqP6idx1NjeqDlk+76kX6y
dseCmB5Getrbpq926wbjU+dZndeAmR/supMb6wett7Xjezum2u34h472tuce
3m+f83J7DlLs8NYvYZ2sE5vdOtIoV1ti9xZof4svcHjkArz6vdL+4PUeD/zt
Oaz38ya9tQdtduW0+r73e9D7EcBWL/d+CHpOqfcX7L1a3y/0n/qX6Xd7DuX5
0n/2XKrY4ek/8HY9bePq3zenfV3/3nmxelNPiy9weNoDvPoV0z7g9R4U/O05
uPeTJ721T2wO7LlkasxPRcsBDB/1G9FzZG1H6y/G/feKwO6PvV3f2vuz3Dmp
PQf285LuT+Fjz/WbunztOC6PlQPY3mfLcvy1HMD2/leWW/fAI4fWX7DQ0VNe
8Gq3gY58lK/WG3ryUb60n56z6Hc7f6c4vy/0D/x8kCdg67eRrDcr3q7DaQ6v
fkSsN5QHfYT8kVdg68eRvE4rnvLY8/hFcn7OPa+Nbr/GvKv7N+RQ5ZL5SPVo
a1dv4/Sk047o2mT8gDauPZgndL8Gf7vuVrj1Sddle/5R4/5tfatcfUlPfYGh
s/cmPZ09N98Y2PlnYzC8envvWxdiP9B7SlWu/vCl/vacIsfNe+gP5G/PdTcG
dj7b6PrVrpu+X6GzcuvvlVm9eYsrL/TIrd2XLQr++7iKn9upXFm4NqZnWH51
4reR5cY56yflYfxBD0x+Seck1g+sVWj3p7mxddT6V3g4yW6jdh07b8ftIGon
sX5O5bFxCaxymrRPVLyuX+gJSfsw3aeRXvd16heLfKkdRffnqveAZ3zYeShF
1p1kOQC/M7uG4vW+qPrF2/1rvisP8zl0jGdg8DvbRyle74/afcBmZz9AHnSc
J8m99hvtrHYPe+7ZxskV/Qt/xovuv+HPfA7MfK/7KHt+V+PmXTtv57j66jwK
bO1P8XmZ/lY5BSZf/i2fHEdHfvC155E+ndLRv/BhvgdmPrH7IL+uUn+rF2S7
/LRf4As98721oy0K/rveUhrzk9B13cK1sX2h5VcnfndZblwh5zsbV+THONFz
aZVDa2/Ije17rL+Vh5Ps6Gpnt3p03O6sdmnrD1ke04uAVS9IstspXvVt9kdJ
di+1i5Fe7Wg6rlWOme/V3qL7WPCMD/BWX6+IraO6jlg/xWrRryti/aLlsufQ
3v+Gdrf+3N7vALz1117n9DOth/rPMA7Uj8P6AdfLvFbn/IKsvhE/t6DctLf1
y4vbMa3/s29XW9/MWDlJp/s/Tad+DBo/QP3ErB7QVubXaqfHaj2hAw9/az8p
j8mJ+mswD6ifC+VWfwzrR75O5of4uZCWy/pBxu3E9l6Ql1ttJ2vf8PtV5i38
AxrzWRDY/XlT5z/QmH9Txw89AXzjePVwY7/5OEt6L9LaOxa4clh/UB9f1doJ
fLnsPTqfL3jmQ73HCP1bi1Z/dkP/Fo6e76rvwQc60ll/VB9XkHSlP63edXaT
tjH+pOM7dNRfz8H0/iHf4aP2J72PqPdL9ZxM7xfqfUy1z+h9Q20H9Abq19iP
c9x8mHTubO+LLJL/Cjc/Jp1L2XsRiwKrV3v7AuU884ul418Y6vuH8iSdS8NH
7bvkS3mSzq2gA2/3s95ORzkp1w/TSwvG/OFhyt04/pcF/M95aOr7aQe1dN/p
B7uP9nT6b/1H/L069SfVe3O6Xuo9PPWv03t26o+oeqHaBVQvs/fT02N+TOr/
rfe92Afi79G4XjRxcq9+ReoPrve/4IefCPxIp35Q6n+t98HYF1K+ww/t+mrP
z7zdW/2S1B9b74fBj/LBj3a2/e/tOvZcpFziDpQ7eyWwtcOXO78K1XvUj1j1
GGDWQ12X1a9S11nlp/fJ6F9rN6kTf21/vwx6q3f7+Pjqv2DXtcWy7qbKPibD
jfNZb5d+eHx3v+7QvtB3X7V90pKHimS9q5Px5+1e9B+w6jXwB6b/LL42pofq
+FW9Eph/1ZPUj1X1HuWn99WQf6v35sk5kr+/Br3Vw3w8aT1fBmb/queK9twr
w/2zn9RzLOBPtua037hbkaO3fkLNxC+gmctfzyntuVqG40v+ei4GDB3/5K/7
M2Drv1Auep2P66rnUhrPTs+hNN6qnjvRb/ix2nWvOlB7utrH2Z/Z/Uq98y+2
+yv8e7cHdhxsDKzeX+/Oe4CZT0mv5046r6qd0p4n+XGbNA/ruKZ9dD1X+5Pa
k9gfUQ67/0mR/U1K+MIVtxz59LXez4b00Nnx6GHah/R6DqbriNpNrbwVxOYt
XXd0HrNxAKokbkmVkyed5+z6Ux7br9t7r01j8waw1a/8PGjnx/LYfhPY7iP8
OsK6gT6q+6mkfRr6p/qLs+7oPoV/1h3ybeyfdPcdGHznlu2ntJla6PDAqtc2
zldpbvy8v/sR+x98TKGDwSM/4IHZZ8APeW1sx21ufAKD3/3m0e+9tynPyScw
9YBe/VQa58dUp99RL+jVL+L1LucefOVZBY4e/uSnfi7wRz+DP/TqVwF/6OHH
uIYf5SN/2hd+0MMPevKHHv6MT/hr+9n+8X708Ice/tCz3rGesJ7Z870tTi8H
r/dZmL+tn95GZz9j/gIPrPlQX2Dq2ziOtgbWDu39o4CpL/S6L2ceB2Y9ZxzZ
/XfT2LzGOg498wn6A7DuBxkvyCn09lwyy5UHeuYn6IGhZx2ydiQf18XawbNc
+aHXfqf9gWn/J++dcPz3d/t+V/8mYNoferWj0P7A1Jd5S+0itD8w5Yde5Ubr
oXKi5VY7g/UjXhSw3rMe4O9k/QC8vKvdAX7A8GP+h5/1E/DjQ/mQTvmof5Lu
y+3+2a8nui+2+nqaa2/odV9u7WheP2ae0X2ytYt5/Rh6e/+szq1HzI/2vlmd
W7/AW/tDnlvvmP/svJXn1jc736tda5HEV1js5AL5tudATUXP9nojcqzx3qBH
rqFXP0z169N5jfx0PgOveoX6gapfoc6DpNPxCp7v/DN/NMqnX2cYL9bvb3PA
ug098wkw/Ud66/e2OWBdhp788ydM/WB1G7+u6fpDfckfevIHJj/SWz+6Nk4v
gB67qbWLLw6wb9v7EBtd/Rvn701u3gIPf/Ckpzykf3jqrLD5M94vFDzpwds4
LFXOjxaY9mO80R7WHlMWqH3H3k/JjtlzwKMfWH9h/74d+gIw8wWwnrPwXc8n
gJFTq+cXC1zp/B/sfb0cJ8/MH7SHtW+UBWovsf742TH7CHirT/n1EdjqV349
tPF/1gV23triYNueiwK7HvrzAPhYf6Y4X7s+AW91coMewjyDXgDexsVpJnFU
vJ/9jvNp4doDmPro/K10Se2wYz5bndxrOakPeNabxv5Y6dYnYP6hYx4AXtxz
wGuPb2zlYP0OP2DNB35KB2zHRWnAPgM+7NfwCyL/xvltbcC+AXr2c9CTD/TQ
kQ905EP5wOMHBB4+lCPl19VfXdQj17UL9dD9s8aD4DvrrD3fbBvbf0NHuSgn
5aKcWi7aB3raB3raB3rah3S0D+ngAx4+4Gkf5av9re8RoS9Zv5Ntzo8BfQg8
sPVT9XHj9Jzf+ml6u5P1D64Uf91Ktw6o34XVu/08Z9eTGjlPSxG/Ux+HUO/N
6b106O37Aj4OjL1Hkxs7F7P3B1Nifg3WbzRfzjGrAl137L2ljJificaBUz8H
8OpHr/c+aR+916f36qGnfTTOjearftbMu+gl6j+BHc/at/36Y/2BmoYK6zoB
Xv289NzB+mvWu309sPXLqo+VI4lPEl/rN9PUrTvAyIvCem9A28n6ofl9KfZQ
8MgJsO47+Z6UTvtR/ZK1XvAFr35twEntQL2BoQdO6lftt53lq3zVXoFdB327
MZ9VAfoYePRt8PyTDjr48p1/1nPg5ft2ffHipa0djP2H9OQHnu/QKR/KC570
4Ckv3ykv6eAHnvIqH2DyIT3f+Ve9nPWWeZR1z8aF8XFMwFt/21o3b+i9fuwa
1r7j5Vrv+WKngJ7/RrrlTs+hney6utz1OzD7aWDKQ7tj3wGvcU/RC8iPdRp6
2hWYfTkw9SE/5AW9wtp91sfu+dOP0MMPer33a8+H6uR8CL+IBW7/gDwpbO3i
8XMQ4MbxvjrAr21Dau78Ry/NcX5ulMvGVa9zMPytvS5X7nn4eY38oUc+vr1u
9NuluV7PZRwgH+CRD2DqAUx5GFfkA96unzlObyQ/5AN65AMY+QCmPuSHfKBn
Up57vl7avctMf6+EdkI+oIcf9Hqv2/rj5Ym/HXbdBW4/hjwobM9B0mPnYsDI
B/6ByAewtevXyPmxv++teqHa5/R+NrD16/PvDapdTu2ASflY+2z8XrLa9ax9
1t/HTqq33qMG1vcv9Lver1a9Wcul96GB7f3fNjG7qNoxd9bu5I887CxfvkOv
cqD11HvPzLusc3pPDHkFr/d+GZf2/NnfO0C+wbNO4gfAfMO8xLzKuLLxtkvc
egI948z6M29266n6hSBXrAf2vvqi2L0b2hV6vUdKeRvrvUHsTJti95AoL/TW
jrMpsdzAeg/Mnr9tdv4n1t9tecyOrfYw6O18nRLqOoAdmfT0g+oJwKpXsD7o
ugGs64yNMxQvJ/IDX12XbRySZg4mPfJEep23d9bulJP1g/62cYb9vSzkCXr1
Y6L8zUtKP+3QqY2DsY+rXw/lhR7Y2tvjcr2zctp7fyUSL3557FxD7ZHazsC6
zuu5BvKkeiCw6o30m+oFwKpHoGfpOgsMf+QKPRY9CX7g0WPAM08gz+ih6Cn0
O3j0EPCqF6oeQPmQW8qHXkX5wFM+8JTPnm+udXoz5QNP+fScfmd+R/r+ltoz
1Q/J6lXLA9VTgdVPHnrVO9WP1q6H3h/G3hvc5vQc2g88sPrx2Pukft8J3t73
9Pto2pf0uu8ET3q+Y9/FboBdFRg8dgLwwMxr2NmAbbzWlJh/o/pLqn8fcKO8
pEZyty3Ivqe49WtHFjgY/B0ze4+vX5IXggdmvlP/GeDG/NKj9sgI9wwXNTkp
pcjBzG/q36L+K+qfAkz+6j8CTP5TDv5sRPshRS5/YPUTUr8VrZfmg9yonKjc
qZwAN57/pEXjoD44/+dBPVb2KXQw+NmHffbD9QX5IXhgyondinJZfyp/vmv9
29o4ex/9oPfumDd2HM/U2+P1/oDe09lxHNJyZ7+3frfx/HWfnWSX0X049m5r
b/V2PHv+3UTOu5sk2h2AmQ/svlXh+L7U+o9pvCEP075qn9VxYfX1uJ1V72Vp
fFc9P9D7BHpvSuO32nOQHPGLjuevdpAku5naSehPa6/1dlban/FFe1q4NmY3
AqY/rV1B4dyYXcHadwvEb6ZA/HS8Hdfep6oK1G5q71dVOb9A9FC9d2DjZm0O
7L2ALW682jgaq9w8Qf+Bpzx2/1Ds9Hpdp+39oAy5z5Qhdoos2YdnufKQr41b
nePKY+1JPj638qV9bDy0Yoen/OBpHxsPYZWbV8kHPOWw+nCx05/hr++maXw0
jcOn7azl1nyA9dwffcKew/u4O+pHoHEa1C9A+eq/Pb8sdfoHft/2/LLU6Svg
uR/MOTb3KIGxd+h9fr0/Qruh56seBB49GzzlsvEA5gTW/3qO40c7QY/fHfTA
6hdBPTmPB4YPfEkHHz3XoT7Q057Q67mK5kv7AtO+eh9f75/YuPnbA9UrwdO+
Nh53qdznnxPo/QDoqRf01At6YPUj0XoB2/gH2538AIOHP3jrP5Hi9LO5rZ6b
f9zWfAeDRz8DD2z9FCrEXhTXq6CzcafWue/2XL9C7Evxdd3eY64Ufy5fHtUL
rb5VEageojD0Nu7EupifH3DSPUFg8Og5Gn/RvqNXnqhnarvZcrVy+ozeF0/S
czQd7anlUb3a6jsVgeppCkMPX5uP94u0/gLxe5TWH8D7vdi4ctXOLkn72Hvq
m+Xd340Ob/WMEuffDr29l1ri6g3M+ga9jbNUEth1uiRQvzj1G7Pz9KpA/d7U
j8rOO6tcPWknbRfNF/7A9l3rzbF2Qj+hHdXvwr4ntMXpc+ApJ/VEHwHWOD2k
U/+RpHKQr/p3ANMfttwrY+2g/m+Uk+/80x/q/wY97WnjfZfIvSHfr8qX9Gov
pR7aLjurN+0Lnv7QcgNDr/4m2k/KV9MBJ9mFgO3+oiyw/hDLAmvnWCX3pzxs
4/g0cesser293+/PzYGht/uZssD6YywT+9EquZ/lYfJDv4G/fe+g2tlJKQ8w
9DZ+fGqsXYD1nqLVF7NdO2O/JT2w3mO0/VDt2plyajtbf59q1+62XTPkvmqq
s0OTHn0I2N6fzXB4vUfGvgr557vGMaVe2g6MA8qlsI0D5ctJuWz8gQxXL2Bb
bu8nj3xRHuSL/JEnhckP+YI/8gUeeaI8wNAjX3afukz2k8ti916tvpzt6qX1
ANZ7sXZcVbtxg3zpuLH+WdUS77vGjRsrLwWu3tpOwDaumG8X9f/Scuk40HyA
kR+16+u9X/UD0zgC7Gupl9r59Z6v+o3pvXv4UT49V9B7xuqXpnEK2F9TPj1n
0HvF6sem9/rhp3GX6W/mW713z3f6x9qxamJxPelv6PSePeMOftbu49+vsnap
GkdHPja+6KoA+QC29wJ83E++w4/v0PEdfsCka/ye4v7v/XfHR774OD/xu/7b
8blI4u7496k0TpPacW2cZ7/PsP4Fnq/tz+YiB2Wx/Z/qv1bvz47t/9Tvh/0g
6bG7Wn/EOreO2f15sp2d+xngmVdIvzO7Lvca9H09q9ekxPajNq6M3tOqjdll
gamn3mvSd2nUbmnvM+XF7hFpXE09d9H3jDSul9r19X0ia0coicmdprP4stj+
V/V3u8/Lju1/1R+MdrL7Mb8PsfHHMsSek3zuQjuCR55IvzM7P/Kk7x3qO1y6
H9d3eDQultrxgZEntcNbv8LcmJ3bvjOTF7NTW/5VMj/5+ceev1XJPedKOY+r
cnFKNY6SHTf+/RvrB1cb2HOIzc5uRLtw3qr37qyfo3/fhvNY6K1enRpavdq/
c6Tzjb5HSDrWXWDahXZiv8p+jXay9xVXOTx2JtKzvwVP/5Ce9cr6tfp+tPfU
/Ps3Nn53ZizOlZ2n4nGowNNf7LfpL+SQ/tJ7kNaf079nQ39Br+dM2u56zkJ/
6TuS+h3Y3lP2/o/Yqe29Xe/vaM870p3/IOUHxk9G/eKsn6XfZ6nfg8bR0X23
7pPwJ1I/OOvvXu/y1XWaddX6Z2wLdhxvwJcLevtee1ao8zbzLPS0J/w1Djn9
ZfmnO/862huY9lY/QuunmuXygS9yCWz9bLxdQfeBtLf6EQIzLvGLAmZesOff
y51/G+W2cUT9u5zg4YefFTDzBvzBqx5I/cjH6uXL5B5ndYxO9QDaBzr0aK0H
/Njf6n7AxgVYHaMDtnaveL62fNmu/0gPneWX7dIpnX2HY7u8y73dnXsg5+CB
kV/WO+QXGDzjEjwweOZf8MDWz9fPp8Csi9avfEssX/teyVaHZx7RuEj6rhn8
8SfVckHPPK/3MDTuT9I7sNifOfe094oyJR5CprMTg7f3TDLlfmahax/tBxvf
f2ug94o0DpS+2wZ/2kf7CXraR++laJyjpHduaR/OR2kfYH33kvYBT/sAs+7p
+qXn4+CZT/V8XedjPf8FT3rGD/R8x3+ucb7z/nXA4Ju8ckLB8tO9fx1wYz5p
zh+SdRf5e+qsFXef/0Chw7NOgCe9+kvSP6QHT3rwNg7llqCxvVn3Nzu4sV18
nCroz9j28Gm7Dypw9MDQwx85g9+QpYMmHbWhjYPfPWdF2UuH+LhX0MMPemBL
X5twnlgW6D7OngeWOf2Ied7GdyqL3YNVu709v1gm72VWOj1J7y+qHk5+Seuu
rsuU18abKovdg1U7sD3fWCbvc1Y6PUPvC1Ne275Vzr+d8lj/nCo3TsFrXB3a
Ez7Adj+W6/JnPoCf9fepCmwciNWuvuRHe5AfsNpVdN8LrOdWes5AOazc5MT8
PdXfkn7WeUv1cOTLvg/l79FY+coOL3hh1iMDL8xy/4wH9d+EXuc91UuRF/JH
Psjfyot/PxqY8ab6EzB49CQ7HrNdOyadg9EPwNbPNduth+BpT4XZr9Keer9U
98Hwpx1UnwMGT/3s+M2O3UPXcxjkGdj6mWa79Rg8/aUw9aO/9L499UM+gRk3
lN/6w+U4+dXzE+SM/mIc2/t9uY4OftDBz/rX5Th5BU/7wIf2g4+9H5gbs3uq
3UrPhfUcj/Fu592cWJwD9DTaA5j1r1Eu6hwfay/yMOsf9Mijrvt2HvX6cmP9
/b/G8br8vd5d3jyuyOGt32+W+LlmufqhJ1I/YOp3wimLzr//uTy5l+DXe2Dq
B70tt9db7LydId99PTQOGd/5V79ma18ojvn1WvtAsbw/U+n2Bfbdr6Zuvw29
jTOY6WDoOd+DT1I+8CUdfJLygS/0zAPQA0PPPh565ivobbzDTHfuB30SX/vu
WFOXTxJfG5+zaahxoZP8PDlHsu220fkZcs8W+4eVh0qJT8c96S2O3voXrpM4
7zWxuGKcQ8DfxheqCLinCX8rf5USD68iQE+28Tny3bxt7y3UxOJ4Qaf/0LN/
g57v0Nl3cH08DtrVvie2Ts5papwflX3X19Pbdxd9/A74J/Wrje+8PFB67Vdr
l1gu/RzvV2DKTT9bOd/o/D6BsYNRHmtv3+LogW3cjC2u/Wz+Hqa9bNy8jbG4
pthHKIe9Z+bjjuq7asinxg1n38z8jx1Q/aiZ760dcmNiu1E+2oF2SWo32gl6
G/c83m4a14/6wt/6pbdy9Yc/4xF6YOgZnzY+Sr7TT4Apj8bR03Fjx12uGxfQ
I5/6fqrGQ6EeVi/z/86vNkpn3732dHzX+Ckav1XnOStXywOl13nO2vWWy7wX
n+dsu/p5L6lfgeknypPUr8DQ2zgI8X4Fpr1snMqNsbjB2OeQf3vvs00szi/0
lFvthdZff5vzK7bnTRVOj0DvBbb7f78eoX/Dz55Pxd/9Rv9gH8G8Ys+N/H6c
dd7GdyqU9MtdXFdgrTdwUr01zhH8gElv4w/XOb9ja+doJfErNwRqd7fxz9cn
tgvnSmp3Jz37GtIDk17LTbmSyk1/s88BtvtBP9/R3/Cz9pf4u+pJ5bTnhH5/
Rv/b+E2Fkn55wP4BWOUUOElONe4U/IC13sBJ9bbxSTfEzllsfPr1iXKu54y0
C+lph6R20nc+kt410XdF7PxR4vQeG0dmnfNTZh2yfovrJU7IOud3Cr31I1zv
/Mf03of1x1gn8VPj+QJbe0KKW6fA017W39rfKyGdfU82mQ/1hZ76QQ8MPfXV
eyjWn2GdxEONtxuwjbuanC+wfde1MtB5X+cB9vvYsax9o0W0/jQJ1/cekPb7
BB9nEXpr32gRLvxzxNwm5QWOXvel6jdv43LE/dbVDxp5TvJDpv3s/qMmUDmy
+x7/LjLzmcajtvsn72dP++u79tqPpNd3fhnnGs8aeuYFrQ/tRn66/lk/QX+v
CbnQ+6WMix3fy2jl+k3v5dCvGqfa+k17fxK996D10HsG6sdO/yf5jdPuVr/1
/WTr7dcr0tPfGm/b6uf+vgF8gfW7vWfq53Hyo781Xjf09L/WR9tB1z/r5+nv
qdH/ev+V+WXH92BauX7Qe1b0v8Ydt37u3r/F3vevCKyf3Eonh0lyC17nC72H
D3/r17XS1TOpXcDr/GLjltTIvahqN48kzRs6r9h5JFf8Af296iQ5VDm1/FJd
v2nce9ovaRyD1/GocQzgr3Hjab8kOQGv49fGdakJ9D6KfT83Pk/qPGrnzVzx
38tx4zBp3Om41HeBaWf6gXYEtvpME5l3UmXeiadTvknvCFNO6Ow9jZRY3Cf7
vnKaaxe7X/Gw1e/8O8vwUTrlQzo736TKPBgvt9Yr6d1j6OBv9W4fP9761Xo+
SemUL3z0Hou9j1Hh1mfmF/uOwEqHt/f3/boOH3uvamUiX/iofgBe77XY+yAV
bp20+fh7seBtPl7fYR6gvIx78MDWft46pi9ZO6y/1wNfq4fE+Wq+9j6/z8eu
Ozmxemo7UG9df8HrPR/4Ul7S2fL5e8bWvtva4flu5/GcWDrlCx/VR6xdGb+N
BXKuu8D56Wk8cPxE8Quz971KXLwHe56eIufP3t/Yxu9Mj52jgyc/jW9t34mI
x6cGT3p7/6vE+RFZP+d88cP185Xe0wCmnLQHfn9JfoT4vSX50bGPVz9BYPKj
PvBP8kOEf5IfHvmp3yCwjR9V6fxYqK/1I/HnlvZdsfi7kxq3T+8Pa5w8+KIv
6D5X40FpufT9ST3v1vdqrZ9ha0dPu4Nn/Nl3e72/ub4zoO/kQEc+fE/KR9sh
6d1NjXuo8T3pZ8alvR+Y4uYD5B846d1RjcvIfl3jeNp3EhbJ/niB09+Bsbcl
2YXRR8if/rPnrWkx+zV4e4+u3MkveBu3v8LdLwSPPS/JbmnjppQ7PRW8vadb
EVg9c7nYzapcezCPcp5g9RIft432As88AmzvYfnvSemsXavK1R86ziuANU4a
7QOeecbeG8hx54CsB5QHWM/toae9bFzFeNxuYD2HpH6kT4rTbP1xFrl9KXKr
8cH++7gqd3KcJLcq11aO17n6/ne/S4/X+6ukxx6j70rrPR3yZ3wnzaP2fliK
Wy81HhqwxiGx8aLS5Jw2Tc7vPJ7yWf+EnfmpeTz5a5xI7Cz6LrZtH/+uWJKf
sPoR2/vAFQ5m/bLvxlTKvY1yuScZn7d0XtN3rGx8d/+ur40bl+76U98NUD9L
4CQ/S/XDtPG9WjmYdc/6J7SW846Wzq+I/rdxwD0MXt+Ngh/jQe+r2XclvP8u
cm3vQ8flWPVdG6cuXe51pSW2e9K73BrfVd/pVn8FvS9H/fQeG+s1+bNeUz7o
VV+nfugZ4FkPge192hZuvk46t6V9qK+Oe50XmAfAIyd2f9A0UW6QE/CsB0nn
ivacrqXT98DbuJetnL5oy7fRrYO0B+se65fd129x9EnrJDDzj/V/WJ24LjM+
4E/94cd6CAxf6OELHr72Xp9Px/ekdOpHZ/3Ekt/dAFY/H+vHkvzOgvVPXSTv
TC6Q+DulO9Fry51emKQHqp5o9cJ1rr5J9x70XoTGFyA98xv0Gjef+YX8mReS
9jWMY9qHca7xOZPmEcYN7ZM0bnRcUT4bnzLZT1z9yMnfxuvw7wJAr+8GWH/F
5Hs2eg/HxmuocDDrvX33rdLByLt9P6O5m3eT5lV9p0fvDQAn3RvQewU2fmQr
B7Nekx/81d8J2Ma7WBnTg1j/wNt4vnG9yMZ7qXF6j7Wf+njB1h+m2vmZWXuG
7yfbDyslnnC832z8mBr3Hgn523gyHq9xlqwf5erEfaDdJ/h7HqRnPk1aV+y8
4+NV6j0wYPK376lUB+qXpPdKgMnfxsnzMOWgXoxvPV+zcX+S+53yWbyPt4+9
FLy1C2c6O6zVE+oDe/7l9VjkEzzym6TX2nrkJpZDy0m5kF9rL/LjFPkEj/wm
jVsbDynXvVdD/sgvMHiN62X9M1cn2g20n+19O69nJOkhyK/G99R7hcDkb9/b
qQ7UD07vKQGTv43T6GHkV8ul55e2nZPnCcpn8f59Ae0H7SfKB96+z14W3Y9s
FvLP+g/MvcMfppcWjPnDw4125WbCL9vJK+MCeUXu7b40Td7fTQ/tPjgzMZ3y
1fcGSY98Q4/8A9t4K01dOvgonfIhnbXbN3dxZG37vBZYuMTdq0TP1HuUes/S
7gMXBzZuj4/PjZ6gcUOg07gieg8SWO896r1IyqPnMOSvcUWYlzTuCPkp3b/a
HnHbuLXcl/7FxUu2ceHi7WrfN/wlgI/+Y7fWOCEa10TjfmjcHKtH+zg5vC9E
PAHrL53u5j/k2K7n/j0G8Ohl5Gf9duoD3i8iP+tvnS7vR3mY/NCr7XtXGaIH
+/dVqB/xEOz49O9KMD6A9d178NSH/IDJj/qRnx3P/p0J+AHrO/LqX884wK5p
7bTx947Bs99SPQgYexB07D903VH/R+tPWyV6q9cDKL++66jvGVq7avx9Xn3P
0J63ro/pacDUj3pZv7v4Okn9oOOdL32HK+ldMH2ny9o3vd3f3ttLlXtCKW58
ADfuc/x7gGpXID3lB+b9BvgBw495GzlnPlE5U3u6xhGw8Qmy3bjRd9fpN30H
XM817D3C1Nj7FYwv4G57Tutz7uj8mF2M9iE97QNMe8APGH60D+OS9tFxpvYH
jXNg73Nnu3Gu787TPurnZ+8Jro7FxcDOon7Hes+edUHv2ZNe/VbJ395vWx2L
k4Edg/ztPJLj9Ezy03v3pCd/8Kr3Jel5wPY+UIaTM9YFYPtOtL/nTbtDD2zf
aW7i7BPw03jQ9l1p/z4S/KC3/gOF7j57o57h7+MDg980r9+uu1zt77MDY39F
D2HdBWbcopfY+KGL3DkRsI37uNjZOeHn3mGMfsg9/G180UXOLgVMO8Bf43La
+B4+no7Gb7N+F4udP5yNz1Hm4gZq/BvSoyda/5kil571h/Q2DuA6t1+x7zdn
OXsHeBs/sdilb5TvtpK+2KUHT3rs6zZeVF5sH2X9RhZL/Olst7+m/uApv42P
2UzeE85y+2HwNl5hsUtP+W36YpcevK4HzDPM59bu1FT8S328Uxt/P8XtS6Gn
PzU+qr3fk+r4kj8weOYx8Nau1dTZn0ln3w3zsH2XPd+VT+OB2vs4qY6O/IHR
d+27IU3cPsTCpU4fh97GjymReFClTj7ZtxHfxMaV8DB87f3BeDmsX1Sxq4e+
G2LjwHl69mfQ2zgUHqY81DupntaPqtjp6/C3cSvayrpSIe8aVgY2Dkya40s9
kupp378qdvWAnnKBpxxJ5WT+wC7F/GHtyRucvZNxaf0ptjp7I+mtPW+DszeR
XuNr6H1/2kXjSgKDh97aCf27aNCD13fR7Lu5aQ6m3e27uWkS39e/02Dtaamu
naEHb+cPP4+w3gDru5Xqh6PzoZ7b2Xhpq1372jhH6aH6HcFf5zM997LxmVa7
9ue7ngfhJ0CcBtYJYNYRG3c+mc7Ge6iQd6oq5V5npbv3yfiB3t63LpH716WO
L/kk8VX9QeNi6/xHOZLy1fVY42Tb+yvpjo+FS8UvZ4E7P4LewqWBvQe8ILDx
sMvdfA6M3Rb5Q19L0iuTymnjsbZw66Z9L9mvt/Q/8mnlqq3bR1FeYMqLPFO+
JD01qZ2AaYekdqJdyJf6kB8w+VHOpHpQbvjZeIKlTr+k/6w/7AJ5ry3TjS/r
v5zlYPD4cYMHJl/rh7sgsRzka/2EmyaWg3ySysF4AG/HW1bid2DalfLQrqQD
1vmJdEl0lk9bN05JBwydni8kpYNO+SOP0AFDZ88HChPTQaftQLwr6gfM/sL6
nS5z+zB9x8XCpc6uiZwk0dl3XBa4dPquh4VLnb2MdNw3oF7ANl58nI99F2aB
xFlq5vQt+LKPsXaL5HyBaU/Ld7EbT8C2HzIkrlmGywfY1i/b0bO+QG/vtXi/
DOjZV0APbOPO+3jZ9v6Kt9cjd+Dt/Fom+7plTi+i/OCxn1l8WWD3ecvcvp30
4EkP3s6nZYntDmzf/0hud2DLP7ndge18ndzuFvZxA1XuVC4Zx0njnPYDr3YP
+hO8tRd5v0/w9vzQ3wMBb+1BWW5/gT0J/oxD9hvgbdzpBU7/otzW/3uZiyuH
Hqt2Vu4pAasdlHxs/FR/Tkr+wHpuSf7ozWqnJX9gtaOiD2GnRR/SOMHYBRv3
X02cPRH7I/hxNzW7/+GXvL1R43xqXEwbr9rvFzQuMXZD8sdeSf7gyR88/JF/
+ANz7mDf2dH3f0okHl0zlw59Qu/t232Iv0dHvcDrvTfys/G1mrlyQaf2fbWb
JNk9yF/tGkl2Cev/Xxvovt76x9cGum+394K9/wr7eHuv1d8jBY+9mXa0cfV9
fC/wNm5+pTvHsHb79c4+hB0RPDB48qOfgDW+FHhgu79aH9hzAB9HzJ4TFsTi
TLFOqT1a9/foN5Rb9/fg9d43/WHHyUq5T7Pa7a/oH+jtfV1vx4Te3rtp6dpV
7QP2PNfbPymPHbcrxf93tdtPUR7ogaGHL/T4I6EX27ijPh4FeBv30Me/QO8F
1ngM4IHt+xneTkE+2I81rgJ8gDXuAOmx72pcBNIDa9wA9GK9vw+M3qr35W27
LY/dTwcmvd4HV3rmQbVz2P2ufx9I43+gX1k7/iKJj7I4sHb0ReKv6s+H7L2E
Ze7chHFl9Yxstx7adXur2wfovU/7/svyWNxB1hvsk/Zcoz52/w9+es+E+QV+
2DNJb+N/prp20nM89FF7HyBuh7Tj1cPWD26js++wbkAPrPfq9V0B8rP+9xmx
e0rMm9Db+SEjVL9Xe58iw61L0APrfMe4Rv4oJzByyzwFPfIIPTD0yKf6zdl7
KssCG++8XPTcbKcvwQc88qn3fu37O8tjcS7RT5BPe85WH7uvAj+9Z4R8wg/5
JD3yad81XBw7B2Y/g3zqfQXwyCN49ZNHPtEXkUfogTWug747oe+dgdd7Zsgn
9Mgj9OoHjXxSPuQRemD192TfAKz+/OCBNZ4J/azvqrC+gtd3GMiPfYn6rZMf
ePULJj/kQt9ZIT/w+i6D3ad6O7O1DxbF9qOUg3bVdUL3cWrHRL9mXrbzvfeP
ZFxYv9/CWDo7Hr3/of6THpj3B/A/450BYPD4n4EHpr42vtOyQP21wNt9qvcP
s/GRljm9FHrw1j5T4Polqd/Il34jX2D42vfZvL8O6eln0gOT3r5f5v1xrL9I
aWydtP4gpbF5ysY/X+f2XTbO5npnd7Bxqte5fRaw3c+sdXxsPPl1Lv4wdPbe
fK7TZ+x7PHXOvmHjNm90dPpOEuUnHeW399p9/G7KD729P+PvI+D3SfntvfZc
t97ZOOV5jq++s8k+G5h9uLULlDl7sNUXS8QPak5MP7L4CmcvYH0lf43rYd93
8fEsSc96Snq9J2zLn+3sxlafKBE/qzmx9VPv16mdl3mJcth7bx6GnnkKensv
zcPWTtrWjVvqYe2cfr5W+zj1tO+OzXH6O3hrl5vj0nG+jN0QOQHWfZ3aQeHL
PTWrH290MPeArP+hh0lv9ZeNDia99S/0MO1rzzEzY+d9Nn6N3iNp6vpN31Vh
voOedRN6PYekfegn0pEv6dQerucWel+HcpBe7fVWH9zo4s2h3+l8Cx79Cjzp
7T28DbH5DjzpwaN/Uk7mB2D0P2DGv6WfI/JYEui8hp5s0/n+137V9td+pH13
n7b4vlv+5s9Rdq1+cPCMo4tk3JUFC7/t87fd3/nF+Qe/svQ/y8ccWR6sv6zp
Fxsyq9x3xvsCQ58d/mv651f0f+0X5588NUr/529N7qrL9ff0mA++idJfnjHk
psGFS9y6yv9FEzvsunTparcOAs954LuTvxqV7dYx1ifwrCPA8IcP6YEPSR82
69gmVW4///r0vy/5aWG624+3OWbcx11z/btkl9/wTdE1WwsdTL2yq67sMHCv
Ju57ywi++rxXewzuneHmSdoHevZV0M/+eONpRx1TFNr1qDa4rnT6lZ0+ynDl
Bqb+wNTf0pcF9rywSs4ba2Pva1s/g1Q5X/LnQf+I6mf9brNi55P2/CkntPy9
36mNw+/97PX8Epj2svkUS/5lwZdpS/vfuzHb1f+uFw75ut3gluGGSL4pF/Wz
9NkOho70yLe9B13k6JE/6kl7Hzv3ntNmXJfj2hsY+YSef/C0DzD8+U56YOSb
dkS+gZFvYOTb3m+oCh7JXtT5nWcLnDwAI9/Um3YADx/gj6P+svpMbfBJXd1F
j13v37cHpv7A1Au43Z/PrJh/YG2w4ersvTNOXBIcfX6X9yf0rAuKR37XKWvr
z0Gfs+Yur1mSG4L/+brD217xfF4I/pEnDjtr5IVV7v/inqcuHLhbTvhoBJOO
fPrOnLLpqTHZ4e4RDB/yPeGO+mEXjcwOj4ng026cPOreyq3BGZ2+eGXl2NRw
z3U9x14yNi8E/vGSyz+cdV2G+7/18z5jLuxR5ODdJd9jJJ9zovqBp37gH5V6
6T/16yN84Ev9lC8w9TvyPxkjas4rcPUD1nrpf59hi+//qmNauKJuwvZBKd8H
R3//4PWX7Vvo4MOGD6pf+lJaOOnT8/oO/aMieOGc81+puqIwnBjBvR7odcX6
mqKwzbdT231RtjIgHXxJBx/9T/mleGrbp1uFh0Yw/MHD/5yI36GSDvrtSxth
6MuWvb5rp+LWsXpNlHocJvnCB3iK/MMfftRby6nl0HTAxwxft7Vy35Tw+hkX
lE+ZUhrc1f+4jI4HpIQ9u36YOv7lUrcu7jEpe+ANj82XdaI0eGnhri/f+EJ+
ODhK/83nH772yJT88NQoPeOf9L0uvPeSta9uCs4p6HPXnEm/ByvqU3qmj9/s
4NMPOvaC3f6zPdhn7Cf1+yxYEez30ZffPN8tJSxfsqH5G+/XBGfc92j+2wPT
wt86nXn6z0+sDRaeuv/CG/pmhgdMKJj0XE1NcMlfaSdvmdUmhF+38y4rqd/g
4Wf2enN21+H5Ifz3vPmecd9Oyw+XRfzfWXLtOz/0KHT8Nxx/9GPvdm4b7h/x
pxz8f3rV4HU9t6SFPaN6jfr61+sO2J7jyjto7uLn2z9YGJ4q9U5qB8pFO8CH
dhi4tu3013q2Cv8WpQeuiNKXf7v+0a4/tApJT3lITz/T7/Qz/U69aec3fjr/
7XOrmjs56Zfbf+GoBhj69PbvnvjO0bkh9LQD7UJ/AFv/2izXb/Sj+hXyb+Ov
er/hH4a/dNaABr2d9PZ+QpYrN/Wg3NQD+R6wa+m8jUe0iOXzciTfpEe+SY98
kz6pX4Bdv0b9RL/QT7Qj7Uq9qCftCT/kGxj5hj/yDX/kG/7IN/yRN+i1H++O
vvOPfF8s4y5pHCLflJNxRzmpR1I9qRfpKSfpmYeYl5iH6Dfkm3agX+ln+hV6
2gl6xrHWG5h5gna1fqa+ncG/ceiUWfPv9e+qzD2ppKy+dabTu967rMXimrX+
3Y2jLx9y4jtt2zo8dp2RByyv6lDi34H6ZwTfXLFm5OHHVrj9D3zI9+Z9Z6/P
vN6/V8b+9TVTrtpgUZPfr7r7e5+PjYubG4KvWnZBh8zZ/t0T+MCX+qEnvhvV
Dzz1s/dcPV/q92cEUz/0QupHu1E/8OTzrmnX2mBjUf7Fs2/z7Wbj6uaG4P+U
cjBeGdf88x254TtyC55/vkNHOv7B88/3bpdUPD6vRWp4aa8+XYfcWR8c/Hn+
0OWFBQ4Gv0/l0bfvclh+CB6Y9n076qc1/Qd1uLtdavjs/p0ryr9qEp74/QtH
Hd6Q/qwH+h/w2Q/+fYjpEX16j8WdZ+9R4OgPvHP9Z0808Ice/u9H7Q3/pR1n
P726tsDxP6rfdx9eUuffTZgR0cO/LKKHP/QdH7xxv+zr/b137gFee8H03zcO
XRoUzayfljLQ3/vmHt7VEf6yf47avcf89W5cdDj60xtaz8l1cpT9yp1v/Xhc
hdgnKiRdRphWWjBy1fdrg3kj/9O385AMZ4+6sO8L4Q3Xt3JyhvxdGaVnH5QS
pb/xx02Lnurl43lRD+o14Kefz5w5P9vdd4SOfBnHjMcFS9Lue2PINnk/JjeE
nnEB/Z0tn7+/8q8812/7mfb1+VIO5jfsq4WmvbPdvccrI3rqTTvQ3sC0t90v
a79khA+MuarXpm6+HtSL9ia95kN73x+lp71Jj1xouW08xhrXT7Q388PCqL3t
Oyo+H9ob+pFRe0P/eqtLjxvfsH5cX11c1rVh3frogVOmZW+oCUaf37P03BdL
g5q7O7Su/WxTkPGPz9v8Nf+rIFh42YTUEZsdfOwFt71/eUN+pK/bvPaHO1vl
hqRvduuffx3/SZsQ+qfn3ZbzYbWHGY+7jnjw1bKDKgPGGzB8KSd8Kee5707a
3jk9NWz+9CWXrnp1XfDKLSWbPmjg1/TXeyZN+nRdsEdpxnMjGtZX0r/1SbO3
+jfApH/vhpoDdssrCFtE6fuffeeLZQ35k55yJrXD+M+L7qoalRlWR/gJj17f
oflHzcMagaH/afN//hzSp224JsJTT9qBelAvykG97vz3iI2PN+hnxw54bsv6
Bj3z19L9Rhw+sLWb1x7cNuzkTbfnhn2i9Kd/8+lZFSNzQ9L3/q18ypcNegDp
KTf14Dv50H/gX+45ZL9bG/QW8LQr7Uy70s5J7QCM/JAe+SE9+UOP/ABTb9oB
+QFGfsgH+SEf2ol2o51oN8pFespF+ncj+SE98kN65CVpHNCuWs+keiM/4HXc
IMfINfJDueg3+lHbjXpQL+pBeuSH9Mgx5UJ+oKOc4EkHfu+ufd9t+/cm4dB5
f3WYMWJBMPH90zKaf1AQ3hTBl55Z8fH2rLbhT89Pu+W+/f4MoCMd+FaFh61d
+mdrlw4+pFM64H1e3GvsPUNTw8P+9to9p5y7LDjg9tTmf2/QY369pvV7tx1U
HUyO9Iwzxr/ar6pZdYCe8e60k058pFN10HuXCTdOzc4I5+963z7fv7U6mFT5
9prZfysID4/4nTf0udfyGvQe+KGH9In4oVdMj/i9/fyg5WcXFYXfRfwyo/4j
Pf98p3/43rWmou9uT+eE4KkX9YSOenaM/pH734M1R/U+pqVrF/hBT33cfFJ2
0aRH+vl37mgn2o12ot1oJ9rtwCuWbL1ks3/HbXLd/R8f+2hOSPphn95w3GUN
+ZO+6QXTWh17VU5IevQA9ALKTT0oN/WAL/nAl3zgSz70Z0XEj/rDDz3xmYgf
/Qk/+hN+9Avp6Q/6kX/w/PMduaJcpKdc9CfjlXJDDz/o+Ye+V9Sf6B/IKXKL
nFJP5JR60p+kp11oJ9qF9LQL6dXeov2bZJeBjn0Bej/9yzpBPcBTDvCkZx9A
euZH6gGe9OB7R+31R+6eJVf2rwyQ/92ieZrv0PEdOuRyVUR3W9Re0D1yWO9P
829r7fJh/nbzUfQdOr5DB1/ygS/58P3RKD3fSc936PgOHXaCPSP7q+4ryn+v
363lP9LDXW/ovdtvN/7o/Ho3dL1w4VPv/OTOxfaK0qPPXhelrxv97LHpcwrD
tlF6/Bpro/S7Rd9/2bNg6fsrfws2Rd/xg/20x74Lm77cJEz7z+jD7pvxW1A7
aWbO5COahksj+h9Tf/ti/JD0sM/jt6R8t7LSle/4cc//ekjnP4POs77+d9+c
7PDXiH7Q8Uflp1YUhE0ifk0HjDj866lF4ZIIf2tRXqu5cwvDsyJ+lPfYiB/7
xKbRfox2ot3OuP3atcffMtftB9nnZEX07Iug//r3a9IGf9Xc7f9Iz74BPPAe
pp9Sw+O+fmfS+CH+vbNzJjy378DWmc5uecAdwzd/1cvHv8F+Ar5TtH+z588p
bt9E/9PubaP9G/TMG9DT39BTr8uHtpty722Zrh7A7MOA2f9Y+qqgbHbFyDFH
tnDtRjsui8pHPzu7UESPPEJP+U6I6JG/M4eOGVu5pGWIvJ3/9xeX9Zvf0tXj
jAiPvA1sc9nCNU/5eAxX5XbqnVnT2pUDfgMjeYMf8gY/5O26iB/yNiDih7w9
GO1HGVfUC3mhHZE36Kk39MgT9KSn3cEDI2/YsZE3+h15A4+8uXc7InkDf2gk
b/Y8OMXtf5E32gl5gx6+0G+L+jMzokfeTlrw5vAup7d18gZMvYGpJ3B+dF62
MjqXWxTpozdHeurS6LwMfMtIP70lwvMdPqSDT7ODH5vwzagW4aUL200rW7lS
/Chqgnanbj17/nT8KTYHNxzXL6t+UYaDn5o5+fuKawsc3G3a/Nfrbi9yMP+H
XLx+Ub9pxLVpEwIrX/DA9l3PLCc3wJSbehz6XIuRa3dtHQJTf9qJdqGdNJ3m
Q/21XMDUH5j6A1O/57vt9vhr13g6YG035WP9Siok3lua24e0j/YzSXTANn5T
lsRrytopHfmxP2ov+yi+Ay/efMS1Fxzm3/3int/DmVWPnzj6G2fnm5bSaeH0
PxYG207cetD5VWnOn2xYXsmvU1/x74hwD4/0lOvtKP3Y6ZPDjvcWuvS07/ET
j+m76pKfg4fW7FHe6u74+3WVJ5ze7Nfvfg9of+hb9kvdOPj7IkePn9rVJXtP
HP3D747/iycEm4fO/Mv98x1+fE+t73l171NzQi0X8Ow9D5y8aWC2w1NP2g29
g3WB+aXg8ZJm5wxK9f4oc25rOeoa7wfFvDbur+c6jWju32FiHYAf8xH8nP9K
xA+9i3mR9QC/PfQw1iH6lX6mX+hn9CTWMefvdfKIhyYs8noT/J6/ZMGMfmet
cPzQu+z6XuH6mX51ccij9XCZKX+28zt87/Fvv3nw2Gy3jh7y9Vet2nzk36Hi
HlW7SYc+cspfaW7dpfzOXywqP+sw/FLvfv+Ts9/19+lYdyk/447y55X0LZx2
nn93iX6kX3+Mxhf7GfqVfiaf5675xxcrP/Tl1ndp4HdrNN7gx3iDH+Pt2Yjf
k1ceP2Tyvf5dFZVj6qHvR1Evxgf0jDfrl1oUHrHbA7dP7NvK8WccMa7gwz94
/nVca77AjDfqjV6Ons54K7r0ztf3O7XAjbeBw359M+ju/f5oV9oNfow39DDG
G/wYb45fNN7QE9Uvln0LehrzIP3EeGNeZB+Bnsd4G/9e+Q1zt/p9Bfyei8Yb
/NiXNDX6TYWbJ5kX6Tf0Wlv+7JDyM97Ij/FGfsgVcoZeSvkZb5QfPRV+jDd3
/hmNN8qPnFF+5Izyc++s+w3Duw5ruSKYfF3Fbbcc599N4V4Y+LLSx66a0cm/
S/FFToe0iZP8+zPVk945sHd//54M6chH/Yiv6Xn5lPOn+Pdi1A8TPuTD/RRg
ykG5iW8MDF/yUTrqB576gdd8qR8w9YOP+j3DF7z6jWq7aT7UT8sFbPWnRU4v
6ip+PX8JnnlK/XuS8DZeUpzexuH4/18OG98m7keUhP9/Tcc4Ur8SYMUnfU9K
x7qJPsJ6o++n7B6te3yHju/QMS/Aj3nB3kcqCusj/YV5BX5PRfMU/Cgf8x90
+j4K6ciHfMmHfNlXss+Ezt5/KgqZ7/kOHd+1fW1cyazweJHL7hEeuxh2CnsP
o8zZybCbsT6gBw6K1gfGAd+h4zt02C3Ij/l6epTuyGi+Jh16jvM/iuRwTaQH
2rg0cblSPHY69Eb4kg98yYdyUU7KRTmpD/ygg19+pBfBj+/O3yj6Dl1SublX
UJyAT6p3WdejOhw2ZWnAv8rFgshez7kQ/3zHHn9E9J1zFOz8/PMdOtLxz7kD
/3xnn4K+jV72UwR/FuHRD8ADzz31wovWnO3flRj22fuLr2rR1ME1M8/4+9CZ
Pt7NV7fWP/HWE0UOZr1z70ZG6xDwiXJ/Za3M53ofRedvvX+i86zeJ9Fx/FVU
P+IwVEf1Aab87l3HqPz6Hpj6tQFvHXrV6DZvpYTlh+W1e/SJ7cGYBeeuvqcy
P/wtgrmHhT2XdqPduYdi39du6crNPS13r0X6qc1Lr7cbsSnbtSPpwW+Jypex
fMANz92cH1I+YMqH/U/7nfKB13bkHpiN/+XlhPJpPFXw2f13P3jiN/69jAd/
qzhjwTX+/Qvw7AvA672j/79yVhybN4p3sm7o/Szu9SAX7I/b54x/5z/jUsOD
/hr6+s23+Ptm0NNP0E/cfdCohecXOHq99zYv4s9+YO+If/uGBXFGqb/vAz38
oZ8U8Yf+g8G1HfPOTQ2Dt9677foe24Jrv3k6uPeEAgeDL2sy/8vFv+WF4JdE
8OCm7fd+5IVUdx9+61XTt37/SGr4+TPBhb3f2Bp8VjxtVvfLfTy8++bWvXTV
BQUOvzV/VfaXNelhxtovmo77MSPM2uvfb5ZnFYXpEYw80t4ni5x8IXjaMUlu
FK/vbKscKZ52TJIrxdM+3LenfT6sr5k9f3heSPuAp33A0z4Ptr6n0+fDi8Lm
UfsA066aj/aL5gPMuvOprDOsOz/JuqTr0DH/ue2dG6enhp0v2lw7fNLm4LQX
3j1879dTw6Nf/OS56y7bEuw/8JL0964tCE+I8NP+cccprf9R4PCkf2rgMyuf
3tQmJP0us7/7bvwBeSHpn4zwpAdPPblnTL2AwXPPGDyw2hmJV5T5Q9ZlvU+o
i9lFXNy1CI+eiB/sbT/0/PKXjDK3/0Xehn367F81ZzRx8oVf5x9Xndbpveey
JR5MYXhbRI9fK3LM/rHn2uNvD57NcPfeq694YZ+p73u/TBtPMjeEnnvu0Ktd
lPq3uv+FT+ZPzovZcah/ywhP/fHzpf6sv9S/56a1z2x437/XhJ8q9Yee+kOP
Xy7jjPq/9dBHV028tMjVP73nTSVnD/R+pdBTf+jdPf+I/s1Px91wzvTNwbLu
d38+89qfg1vvvefzs+vbhMD8Q7d+Uf5/bhycHb4RwT0Knnhvz7e2BrM63fd1
ZcM8nPvgv5re0jcz/HjKo8ccckBK+MtTmT91uyMvBM936AZW/tnt8Sn5Dn5D
8qE8wFpOpTs1Ks/VnVY+vLZhntd8KA94zotS3h++X/r+aWFWyS7Tn5rWInxj
w2lV901Oc/j7b1z2wfZ9Ch3+99yee37aoGft+4/J7++6oj547LvdRrx22opg
yKbhRz78YFrYYu0fa37uty54orrn+FG98kPwnz/S/7Nufy90eL7D54NLW9w0
YHqrcL8Ihg6+rfrsNuCmf+SGwPtJOqUj/w8jPPmDJ3+lAyZ/TQf88hU1d35X
kubivSz78slVAwYXOhg88VTAAzPuddwAo7+ul3vS3JtmXOu4AL7osX89t20P
r0ewHz900bcVzz+QFj6bvcfiO8/073DN7H/57XXP+HvG7LehX/r0W4UnzfDv
OFJ+HcfAlF/vaQNTfh2nwJQfvYby75PafOK3fQtd+Yk7RPmhp/zQU34XTzSl
R/VFW/w94juf2HD0cw9ucuN+7g9HrHisdRt3D/egkl+PefEdPz+wzneRe/1f
yDnvGrnn/1WEP6j3acsemts8XPOvqyaWdfXloFzkQ7lqy8Yc/OQnGa7cnUcN
2XrXwoxQ8dyHBs/8xf3hzVF65o+RUfrMjKs+7nVjUbg1wk/9aclLwe1F4QjB
HxXxB/9WxP/nyb+9ccHMjDBv8MqPO7TdFmS0OuHLAcMyw5N/3LPFLtvrgmED
8pocOKgozI/w1INyUw/KTT3AUw/w5EO+5EO+86L+Iz39R/rF0T1q8Myj4M9a
+9QumT/mhfC/qPeqgz6bnxfC//+13+ln+v0roadf6Cf6hX7S+A3qP6D7qlM3
3r7gyN9yQ/JTeuSb/Ggf8rPnrf/zfMGTL+VAvskX+SZf+oF+ox8UT7+Bp9+o
B/ypB+mRX/gjv4qHP3j4IwfIBXKAXCDf4BlH8GUcwZdxBJ5xBJ5xAl/KDT3l
hp5yg6fc4CkX/O4YNfGQcwdmhEsi+9hNX2zcvkuLJuG4KG7B3J+qu7zco8jh
u29p13HsEwUOzz/poIMv3/nfJf3+JdN7tgjfvbS8bVmDfnvj7p8vuPqsBv1i
1XW1k4c2cXERhkT07yxadeuzP2SHwyN+5A8/vkNHOvhQfvCkB0/5+U75SUc+
4Iuj8g/44pF3/2zQTyn/d2N/euHreZ4v9OQLP77zr/bNi5c8f/Dpl6W4c3Hi
oz7Tf+JZzb/eHpyQftPH+3yS7/DEQ30hwl8Spee8lvTvDBpzUjgqP+wcpQdP
+ukR3vkTStwejaOicU+AP/g6f97wgpRww+jywd1OXxrU3jIjd8uSuuCeFgtm
79XN+/GgF1x7x2utS57KD2sj+jE3PXxw3Rd54d0R/ZatPV48/NaMcPqHF7fZ
1nZtcMyq1r+/PT8tPP63b56ou8rH5aHcY/K7bys8rcjRv9yi4259hxU6euKW
JMX10TgoC4Zd0/H8jvOD5974tM+WGanh3K4dD+m07ptg41mvXzP2sNTw7OHj
hnXfr0UI/soFR+93cG6LEDz30tGnfqpNbZL+zF/BL0s3HPzmbpnhvdf1ffGj
j9cEpaPPGvnl4Zlhj3Mv61jfNScE3y79r0lHjckJwVNujaOkcWs0Dg0w/XPM
xWGTz+Zlh/TPlsG3fnbKkFax+Z7+gZ7+gX5z1D/HfT5jdeei3JD+2fXbRd/W
rfJxkSgX/QM9/bNLRK9xZzSuksahoX/6rU5buGVggeufe4Nhl3x6QIHrH/D0
z+gIT/+gL9I/t9898eNz92jr+mftz3NXXdqxresf8PQP+F4tR99yb99M5+e3
onfKYYNdnIOa4LB2K678uLOPH8v9fvxAuMeu/obQsZ++YXTdmHHZTcPsAw4K
B85Kd/He8PuAnv30jRF9mwOP7fXO6sLQxuGsCZLKzToOHhh80ndg6gtMuSgn
9VX/Qr5T3zkX7Dm4+7+LwlZRfYlPp3yoL/R5UX1tXFHfD1rONeJv+JXYF9X/
UO2J6meo9kP1T1R7IfP6L3UfzzvxpdJg5e6XT53dsP6/MLXdyAnHLwmCF/YZ
euqZ9UHVZ9efPXzlEjcvMQ6YdxgHzPNlEb/uv8xc2Klh/X8+4vd0cO0XrTvk
h/BjnMCPcQQ/+oe4Ep/dsuc+LzfoQz1P6FB/1IG1we35G75qMSUjrJl++RGv
r1vn/JKgH3T24SVnNegdPSL6uXu2e+iuy4vCdRE9cZmWr/xj78EXbHB2lcqu
a6sXPbLB+d2uuORftWc8uymYX93713dfSw3X7zLhtct+3+jiIJEeO8cfUfoX
Ij/Viij9+ge/LD7/qgKXnnJST+JfANMv9FOvLRnTXnzO+wN3DtZsffSSLa5c
jA/oGR/Auz++/LyXNnv/4QtXtHvlt/3zQtK7fBL4IB8Df7tq1OljGtaDSD7e
7fbIL6smZbt1iXkQ+WAeRD7+FvEHhn+3SF7gj7zAH3mBP/Mq/LUdkZeLr3z1
gHlLckPkpVn61qMrH8h14xl65AV65CUroj89kpdRZ+42ZMJ+bcKZkbx8/tLF
+047yrfrPa//66WzZrRx7dqz36nnFt7XJjwikpe7o/TIy5woPfJCeuSF9MiL
lhuYcefaOZIX+CIv8E3qB2DkhfTIC+nRG1jH0BtYx1i3wLNugUdPQy9Aj0Nv
YN0Hj14AHj0LPQA9DD0OvQA8egB6BOVnnaX8rLOUHzzlB4/eiJ6CXokeQ/nB
U37wlB+9hPKjt6CngKf84PFX/ftVHw0vvLU+WLjvxpXHnJzq7IH4TYLf8Eq7
ScWHFzg86S+rPqtn2iH54aIoPfZC0oMnPXjSH7X7ky/XL2zi6IHBv9hhcP3w
rQUODzxr4mHzLxzYwtn3iMf/a0HQ/oNXm4QzIzz2M/C3P9vlhLIVBeH4FyaP
HNPcv8Px0x8115xc6N89AI+dEDzwk2NvH/PBFanhI0ePO+7kmrrg/LJfB110
SkH4aASDP/SKe449/eu8EDzwwCd6VbR+MS0cet+qzO5n1we3LHmwpllJWpg3
Z2LXS6dsCz699IunM64oDG+O8KeOqmzfZHBh2CbCk/6AGbsd9FDDPEf6+ff2
3HrulryQ9B0jPOnBz65vu/rVf9QG47peOfjO7hXBnLHf3Xpc8drgiA/ezDrm
jKVB5/NenrL/n7kh+DtmnNesd4P8HBnhw5O7te2+1/wg54I1t9721F/B5V9v
vHfcisogr6LZjJ7v/xaMeHHMkx1O/dP5Jblz9ihuR/9FvYv22bdFmBulv2HP
k9+d/FTrkPTvP7FiZvr61u5cFT3bxlnJcPfWsM/Sf5yrcM8Iey34Ua+vOGL5
lFT3ftQ3Awu6rnHnbU3Cx85r9u5us1LD+aNOGPddO3+PjntOP3TZN+P+QQUO
j14O/uOofTv/s931TzWMY9r3o663HfVbwzjeK7r3yvk9/3yn/UlP+5O+S9T+
36SGm69rmF+uiNq/34B7Pmk5v2U4Mmp/50cRtT9xT2h/0tP+pJ8Rtb99/9LH
TXHn1dH5GO3P+HDnzRGe9gd/T9T+vJ/1bdT+wLT/+p8+WrtiD39PEX8Y2h88
7Q+e+eOJpmMK7jqy0s1nwMRvYN0nXoPdz2Q5GPowioPRaKfKDNf9H7tdnYuj
AD1wl4i+vEnOPyee3tbRUw7K+Vt0v7cmut/8xvZj/91m6qoAv4wPB71YvNvg
1v6eQXSfF/r0gW22jCht7fw4npl6yD9nd27r9LDH+13eaUYD/El0rgeff+Rd
9c8ph2a4+RVY672zdkKPgN7ukzye9ORPvcgf+H/KR/Ml3gb9k9X7qnN/fi3P
xbGAHhh6+gd6lZvlUf9wf/zNqH/wg9F60D8ZET39Az39g75E/3D+SfuEz5x7
9ZkHFDm+wCpn9DN8tZ7uXn+E5xyVc1POUTk35RwVPOeo4JlH977hvsyn+85z
54HA5UFN1uzqNOffcMe7u7zRb4x/l4f0Wz4e/e9+Devsvh/u3yN7fL2Ln9O3
/QX93358e3DU6uYdn3szxc0b0Bd2r5qVckx+CH37yceefM3N+SH0lIN8Hrp+
17E3XjsvuObSsXMGvF4fdFxYkj/0x+auHnv9Xjv87Z+ah+D5Dh12YOzC2IGx
q1I+6LG7YofF7go97YN/B+0DTP5jblkx9KAGvaND1D7Eh/l71D4vPbDfR6dX
5rv8oS+I2gd62gd67TfaZ+XqURf+u7OvB3jaZ0WEP/jNO9u/NyzNvRf0/KDL
Tlh8WqGDwfOeD3jgKdH9FntvsjL4ZeRjVZXdljs9Ar0C/0HssegF6BnwgS98
4Ms5890XfTHno5wVAfdTSMe7j6RjHWRdxT+R/FkXWWexp7wY5f/waVd/O3Qd
9pRK944K+aNnoRegZ6GXQUe5WfehRy9Azzgu/d1uB77Yyp2nH73y539f3LDP
ubGg1ZD8W71etPHc7y6bNzEt3O++1htea9hHgKefwVMPayeqdPWif9AbiOOP
PZb+QY+jnWl32pl2p9zUo0lER/7QkT/9Q/70D/nTP+gx8IEvfOBL/xwf5Y+e
i95F/6CX0T+ko3+gp3+ghy/09E+3vV5Znnma10tHdxl74fJLCl3/gKd/wLt3
LM54+JMLGvbtnNceUzNu9qlj5jq7EHGrGs8fOaefG53T1jnYvWsR8eMcFH6s
J/B7amP9y7s35Vx0bsC6CUw8bf6Jp0pc1+biV0Oc7MkRPfFUO0T0+LM8HtFT
LuoNX/KBL/kQDxY8fjhZEV7bBf3hxKjd0D9qIj36npGvpbz3ZfPwBMEXiV4U
yDsJxRGe9LVRfugf5PfQxKDVW6e1dX4CfKdctD9wjZzfazkop+YLXCz0ek6u
ehj5k57+B1Z6+pV+ph/oF/qBfoGOf+QBeuQBPyjkAblFbkiH3JAOPuDhA17l
Wttd24l6K17bQd+tAK/tiDzAD3noF53fIw/QISfQkQ486cBjN8GOgt0EO4nz
U4rw2E3Ao5+2W/Ry5tQRv0b3glOie8FLg2Vvtzxl09yU8LBTs0a8Nf8Xt69h
n8M+hX0O+zveoWB/zrtV7Eu4d7j+ncO//9eW9HBYxryS6larIztlRmRHrQna
pF++T0WPjPD69de1b/p6tdPjKe/9BV/8svf0Br0kKm/dmpfnDduQHx4SlRc9
H70fvR29n/0m5cV+QHnR0ylv0xtm5QWtisKbo/JefNyb6/t0L3LlfXx8n87V
Rxa58t719R+vv37fr25/OG5Zt/TfJi4LZl6b2yGYlOramXannWn3r7rv1fGs
vJaun06ccu6iIT1bhrOi9A/kX5fXa3F2SPrdz+swKrcuOyQ95b7xz/IHf17Y
JPxxyJv/PLrL6gB/f/A3tTkjr+nhvt3pB+pBP3A/FH6ZHTYN2+f8HHd/ADz8
2h48eY9F23JC+L3c54PDR5TkhPDTe4sTdz1iwa+PeZh6l/Q47vHq3JauntSb
elJv5JN9G/LJvk3f+UE+eUcN+aQe6yL5PP6WWR8vOdvXg3pRD+qFfFJe5JPy
Ip+Ul30l5UU+Ka++24J8Ul7kk/Iin5QX+aS8yCflRT4p9yORfF5TOrVzu/4F
blxRD8YV9UA+SY98kp56k556kx7565b9aM01WwvCRZF8cl8E/OeTv5qW0tGP
M+qFfFIv2gF+TSP5hB94+NEu8KNd4Idc/yjlWiTjKFPyId8h0ThBjqFHLtnv
44eD3w1+NB0if2P8jKkX/MiPeznYB/DLwQ8Hfo9Hfsbwo3z0H+VDDikffkD4
/eDHQ/nwT6Z88KN83AOifPgF4QcEP/yg4Uf/j8feF/3znXn8p6g/6F/osOdA
z7iCnu/OXhWlg8/bEX/6l+/Ojhf98z0j4g/918ubhCd2T3H/Q0bv3Wu3d/IT
v+v/iAF7ftelvCYgfg/l7Xr65MqtY78JDjp06u6nZ+W6+D6UAzzf4cN3+HDv
/F8Rfttev7SZ1byFay/8wtnXoU+xD8HvGry9BxV/Z4xzuQ+j8zvs7tiJuW+/
JIrLcuSxUx8/4bhMJ+/u3CtKj92Y9NzL/SVK/+LhG296qpO3I7M/Uzs3cChx
pdfJPoJyUU74Uk6NK6x6521RfBjSM05ITz/QL/QD/dIp6m/w9Dd4+hu5oL+h
Ix18SAf+9qi/2d/S3+ih9Df4pH0G+jH9zXkn/Y3dn3agXWgH2oX+Jj39TXr6
+/YoPf1Nevpbzy2Au0hc8HWyj8POjl1X40Crno/dF3ricGrcQ+Cm98x7dOR1
mW78ECeR8fPQ4sybTurR1uGJawce+yP37tKn33zA4B/Twuojq3+eN7ouuDIz
6Ff4V1p40qYLcw7pudXZb6FvdcPSk6YPLwzXRPQnPfnxT6PvLQyDiB59CDlH
/0mJ9DD0H/Qw9BHoWVehZ12Fnu/w5Tt80RvAozdY/bEyWHFy+g8HD2oRPrf4
p8kfZ60Imkf27TGdxv41/NQ/A+y9hzTvd/vAt1YF2G+xG5H+zsuPL7n2hVYh
6W/b9OJDu6xv7ezFLwzeddp537R29l/ipGqcSmD6l/GicTLpX/Aa15D+5R4l
/fvl3r88c+i0vJD+fTr/uEE9L89z9mfo6V/o6V/o9dyIdqbdaWfaXc8x6F/o
6V/o6V/o6F/oSAeedOBZN4hr2Wbc7gNeqa8LXm//wh9f3z836NXjnPemn1sf
rEl5/rZTusxz/sHQz5/5StrLDfvl/0T0F++/sejaffND6GnPsMP4rzvOqnXj
Ze2lB43/YssGNz66RHjarybC4yeHXxR+bfjN4ccEHj8m/KZ0n6P3vJPwGscM
PPvo9bJvYR+D3xx+UfjN4ReF3xN4/KTAM5/quk6cUS3XuUJP/50y+JvDv5zb
PPxb1H/79Vs9tvUPzf/H9QRmPtd1h/JofDalRz4ozyWRfFAe5Nz6X/r0ikee
yvYY3e/L7blufDY7pNPDb5zRxo1H8MgTePwk8ZtEnvCDQ57wk0OewCeVS99V
/Z/WCzuH7iuB8avEbw6/SvzmkCfw+NGB/6TjpWtu/KxhHu3zc/teZ1S4eZt5
vP8nnffbtJ44fMuDSy7IavnpB8uCF198ud3z1/p3iO17NcuCsHb5Xb3HZrvz
i48WjN39ymOywyNz+p957JPlway3Sz88vnu2y3/Zx1vKvh7q533WAfLnHXf0
sVHRvvmWqH2w67A/xa7D/hS7DungAx3poCMdehnpaP/Ho/zYv74U8WH/Ch/2
5+THfvzgKD/24zdE+UFHuqFR/djXkw4+pIMP5aTclItyUi7KCR35Ub+TovxI
R36kIz/SwQc60kFHullHfDlt9fdpTn+65tCm6bW3FToYvIsfF+GBwbM+gwcG
7+KzRXhg9C7W9ZXRe4H4qR/4wjO/14/cEvR7ZvbU7FqvxzGvoMcxrxDHgrgN
+OnjJ47fPX776AXkzzt75P9E0OvyOw7LC8kfvYH80RvIn7gQ5I8fPPm7d96j
/NFj0Ys+vfTZN9tvqAlGjjx4wzN9M8M5m+p+e+jxdUHrmx85sOu1mWG7r64+
+bRutcFfq2YMPXhYZriyzZE14ep1Qda2CbutHOj1KvhtG9TrvHta5Ybw++Cc
8ucuvTk3hN/3o0u2nPlbbgi/7rsOXvHA/bkh/Ogf9Kg/ov7B3/+AqH9mDvjX
9rvGer2ZeR29mXk9XeKMcC8CP3z6h3sS9A/5d4/6h/zpH/Knf8if/iF/jeNB
/5A//cO9BfoHvZT+Oa3vcR2+adjPfBb1z2Nn/fnR5O5tw92i/knL3v77Y6e1
Df+I+ie3YPCxNf+XXgs/+gd+9A/86B/40T/wQ+9Dj0CPQw+09yLqnZ4BPev6
34Q+SW9Bb0RPID/0SNUryA968rtE6Heml2AH395m/HOrHk4LWx1xddmA8vpg
fEZJvw/GpoU/dHt17dVp24PsPQdtvfH8wrBlhP97ccr5ZecVhj9G+JS8xvRn
XN750r4988MJUfrUP0r3/ems/JD04EnfJMLP/9tD56+cnxbuf8L7dZeV1bl3
bHinhXMM9M2bSirPu2FYwziJ6Hn3BPqrI7sw9PA/r8OZVxd+mefej+E9Evij
b8AfevhDj90Z+mP3f3OPu99Kjd4n2eLisc/LGVS5bezm4OLzl3b4ZWpquGFZ
bsvBE7YEL3fcctzsqwscPfHJoT/h05wPrhtQENZG9PDPnzD1g9Vt8ly88w+f
vGOfbevahPCf++CAgecfkxfCH3r4fxTRwx96fUeCdyqIg8J4xU6n7wDwbgD0
jEfsPL2Lmx7/a36TcMbacW+nDy5351LoM+xDUl7Ly7v3sPLgmjcn73f85+nh
YWds+sf1R/o409gz0MvQ09DD0MsO37tDj4FPFbj86C/OHdBTye/j1TUf7LK+
0OVHnFryyyq+bNJ79euDJxf1uyft2DXBfl32bR502xZMiOC333vtxi19UkPo
iD9DuxJ/5oBR/+w+tdmG4JunZ457dX5uSPofXnz1utN+ywvHR/CVN966fMvx
BY4f8WrgR7yagyJ++k6GvmPAOaOeQwGfuWXoyP7VfwX4M/+w6MyZWWfkOP9m
8mW/k2Xkw9tlsdt1ET+GPrI/29m+884fUsfdtzY9pJ+Jh0M/Px3NW+oPzXfk
k/Ja+fR2RWtXzkucJ3e2rylNfX7tyc2LXHmJx9MlKu/A0r3/dtJpPwdv3nVP
0XVntQy7dKkfPqbXkmDOQ1PfTzuoZcj4+PyVP+4sucOfu6IPu/Zqm1Xcb1DL
cOy0X+/r81NG+EbEj7hH8GP83Lhnl/fGFvk459iLKCfloV1Jz/ihPIwfyuPa
IyrPWdXjBu93R5ErD3GI4Mf4ojyML8rTPJLzYMFfu9TfkhPuG40vYMbX/2rt
3sO9nLIHgDvKaUx1OqfOOcllXFNIRhQqvq9BJCU1ch2TGWNmVGPyIwwj0ZXE
z62Sy/RTkchlROg3LpnJJSJFRSlKMnW6C6HpmdZnn+e8np4xz+Ov7/N+197r
ttdea797r71e88b8Ms7m151Pv9iueaOG2axop//cmF+ezS/4zC/4zK+RgS//
nZn8d0DMr/y5qeeOMb/kq8+N+eX51D17D31pRFHU99tcOKz7kVN/Orwoq/jb
gLFNPttcOHz/M6vOO7MiwffPjimuPGOrfw+4uCeuiXv8rLgFLm6By8//fY9J
J158SnXdrVSHKvLzwY0vuPWs+WB96Zl8dw0Z3fadQY0y8jUcfF3DgTc2ysgH
Tj5w8onD5BPnyQdOPnZLvhde3NS59RHVdcJS3ayQ78WAkw+8eYsNJc2fL856
xndMmt3bZ/3ZtxRn42P/oFPjgbNnzC1OeTLay5tuHu0nR960/WT94NUPXnTg
1T7hjfbwomO/WXvfTdF+QOw7wC9/R3v53Np/HPnc8PsfXnjghQde7RPeaA+v
POp8XrFneeALn+x0wKqXlxZqP7V8+qYXNxVWtyqZ8OxflxbYH3iLeH8Ct05v
/26/K9sdsqZwQORHD1t18sSr260pyB//+58v+fkTH60pyKuGr37t3cdcNaBh
Bh/7Bh8Z70vg4gd68s/Rk1/9j6AnfmpfJ77vqf38I1qedPzkdYk/7fTTTj/t
9POevVPoTfw7OvDcFN8DHR54rht38LQR7cuyGYFnt5n9h868uzTF+aq3L53z
wX2lGXrfTjmm8NCrpRl63hvrBL00bjGO9GQc963VqvjTF6rHMY1rjCN5U557
8GkcyWscT9115L1tupek+wNznpnxzYouW5+D3pJH3jq9dbeS5LfA0SMveuRF
j7zoodP14ae7vbi2Ws/0zp7AS8KewNl/Pm/eM/xJrsCf+A45wMkBTg5ykYNc
5CAXfuFj//Cxf3D2D87+0WP/6LF/9NiV9uxKe3alPbtlx+yWHbNbdkzP9K4f
evqtDnr6oaedftrpp51+7B899k+v7Jte2T+9gtMr+0/3NkJeeuVH6NW4oGdc
0GP/6IGjR170jAN65EWPfT658s/dFw2rnvf0gA9wegF/+MjGdR477dtC4dvh
/z9/zbKCe8PT9+7U+f7blxUa9/h6ZvZVcXZjnLM+3+6ld4evK85axjnr00uX
T/p90/JMf/eG9R+6avHSl8fXyq7fu+/YDuvWFx6I+oXb9kc2FLredOvui39d
meDqGYJ3W9x60k8PXFZYG/twb95Z/sFt7ywtHB37cOiSA11yHDy+rP+Q3iXZ
uug/s1vHTot7lGTto/+DvR+Yfui9JUkPwzbe2Wy/ISXp/rRzQ/ujzg3tj+Kb
nPgmp3Mg/Z0D6b/qvGu63XxTWab/4DcWdjj22bJUBxJf+MQXPo3PVXGObXzu
j3Ns46O/8dEfXXygiw/jA258wI2PfUrjMyb2KY0PPowPPozPq9Hf+OiPb/3x
rb9zW/ujzm3tjxofchgfchgf/Y2P/uTWn9z6f65uQdQfSHUA4nlTwN3vvyHg
ntX/cE/EvTl+2T05fti9MXD3xOYF/PHJI8ec8PmrKS7O6dRr+SEzX033TPRD
B150+FlwfhUcv+6haKefdvrhF3xC8AuO3+Qvg99U78I6K/CQk9zwgsOLTr9p
Pebd9W5xWvdv2xcvzj48t/yVL+atKPBr5hG/Zh6ZV+DmFXjvwcuvfXzWjlnj
vm2nt7+obvbS/DsueveLivSMvvcC9Lse33HwUaMaZBfu1v/j5T2K0v7Z4VFX
wTldYdySMX3bVyS4ugrg8krZjzzQW778rMfKflvXrQ+8UXLz1veVj4/c68IR
p68tdHmkRbe+nWul9tviUK3swZeHjlpRtbbgfWf8sdc0eKTNmsLgpe1HnVhZ
K/aJ1qZ6cfrL6xwe9P7w2dBDT2hamS0Neof1ObL7U0dU34Oa+pPDmrfc+jwp
6HlPuT/ozRqa9dt798pE79SKBRWPL1temFB6+N6HX75DGscO9QbNHFdclHXa
Z481b7b8NMl96f1Zp7P7r031dOCRdzu9Q/n0zi1WF7w/937i2dG/3foeBb9x
gn/SZZ1KHz24Qcqv/X1hXfs5a0rTecLVa7accsWc0mxs4L/gvoG/GtKvNL2f
G1/7McbXeabxBTe+4MbXfMPHmjkfPD+1ZVn2cozv3/d76LjzPynNjK/2xvep
E48vnVqvLL3PbpxQVPXgvaWZ8SWH8dXf+K4OehfH+KJnfLU3vk8HPeOLnvFF
r3OM74c/mfbsyJnlaXwfvfuC0q7lFdlJMb74uCTG1/mK8ZUH/VqMr/2DXjG+
8Btf+B+K8YXf+MKPT3nMv4nxhZ/dsFN2ccCWX/yoebflhemvbRky+ED5pMuT
3ZLTeLJj/dkxuyVnvZW/adpn7x3T/rh9YvvI5KRXcjQLfqo2712VTShP/NAD
fuiB3tP3e82r0AN+bq03t/2TYysSP/bV7LuZ9+yYXyI3v8RPac+O+SV2zC+x
Y3zU9FNlad6YJ+ixW/NGe/TME/TYLXrsAT3jz48Yv48fPqfHoM9Lspdi/Od3
vPDhOzaVJL/CDvHFz+jPDvkVdI2//dv8uYHxZ/fG76Pgx/jjx/jjx/ibF/rj
xzzAj/HHT36f1XjyK+IEOuKEuKE9vyJO8CviBL9i/GvGjbLkx/gt9Iw/P6Y9
evwWesYfPXKjx24fCDtgR8aRHb0cdsCO2AE7YgfwwAsPvPDACw+88MBLr+yU
nPCSk52SE15ywsu+8Mc+Tg3+2Bf+2Ffan41xwB888MIDLzzwwgMvPPCSk9zk
JDc5yU1OcpOT3OwEf/DgDx78wYM/ePAHD7zwwAsPvPCk/dzAA697Lu7J8Kfi
kfkkHk2M+cT/T4j5xP+bT+KR/uIR/51fn6GLjn7ooIsOuujAh47+/kfXvRv3
dsxnfJjP+ODP8fF5zGd8mM8n1+Bj67ol+BA/8MHP81v8PH75VX6LXyUvPw8f
v6o/fm4OeY2ve03o4kM/fKCLD3TxgS4+9McHuvigV3qmV3qiV3qmV3qmV/jo
VX/80LPxdc8KXfLqR17+mrzokhfdmnovS/EMXe3QQRcd/dBBFx100YEPHf39
j+78qJuoPuqgqJv4etRHVZdwdsB3V7854Hf+ZcIeLe6qnc5B5cHKi5UHKy/2
vQs3Tm20qDK1XxD01dscGPRr1vOsncFbN/L84MVf9+iPP/3loekvD07/tk2P
7tZl0rxCzbq28wtNDz33d8OG1s/I51wXHu3h0Z582rsn5h5RqlcY94jcKwJP
9QsD7l6IeybuhbhnIg9RHp08RHmO8hDlOcpDlOcoT05/eXLy8OTJycOTJycP
T16nPFP77fJM5RXKc7TvK8+RfO7BkM89GPLJ6yOfvD7yyesjn7w+8ulPPv3J
pz/59CefPFbyyZMknzxK8oHXvH++IlfvY2Wu3seKXP2QZbk6HSvSPtGUqDNl
H+imqDO1vTrO/+m7cdurA40Ouuigq34VuPpV4D+U3DXrYFTLmc8nysPzcuXh
/GfNPM3S7cLz9bDzcOuk7eUP5eH5+tl5+A/Np3EybsbJuGn/334XcHt1wLv3
m/tY6407ZCufXrCs9/Fv5vLAvv93ELdXx/ypt4dfN6puRcJfiP145wLrYz/e
uYBzHHDnOOAfvlzy1z+2rJU91+K8e4qPWFoYcNysRxaMqJXqUnkf2NKq14iq
u5emfYB32h6+4tTCx4XWz3Va1Ka4VrpP8odDmj1zff/ibK+4f/L2yE4Dvu1S
nOD2//Gzc+z/48e5BrhzCfCvr5hYq03zymxa8Nt56s5Fvc6sTPxaxxcdto1f
9jU7+G224cQmTcorEz/27fdbeNLK5jtWFdQdb7pl/cQuZ1YV1C3v983yXTtk
VQV1x8f/+x7GqoK643ut/eCdsrmr0rk+fJ0vuW/gkBWbEz7fm4NPPWn41JOG
Dx544YEXHnjhgRceeO37w6vudrPAq+72FYFX3Wx41c2G17kqfHut73jjL29s
lOHT9+rwqf41fOpfw3doq0kzfnZaaTrn73tnz/51zi3NOoW87Sr79yneul49
OeTdVr+kNDsl5H3syXuW3tepNGsb8hrfWRsPbdJ3bHVdenXqja869erSqztu
fNUdpz/46E8dc/pTx5z+4KM/+MxjfsN988Yz5jwyb+s6akGH01qvuv6NtH9n
npq37N68NU/NW/PUvGX35q28W3mH8nblGc5b98pBi19fn+rtOM9TF7t55C/q
ry629s5Ptf+h49rIeWP3+Vlx3eR33cevCP0NPnZ0s7Zf/TjtM5w4dczmaYeU
ZPQnbtDfvC8XbWrTsSTtg7zR7n+7zFpbP9Fzb43+5FWSX14m/f2se/mUjdeX
pXWw80z6kA+tv7rg2jt3VUdc3ra8V+8Vad3+l7kDD3xzeWHF2JUPH1VeO61H
fv2TTWc161Y7u3HGkvfKLv408itqJz/Nb7MPftt9vq6jbnq9+Zu10v09/fPr
LXmv+PNegL/T7rhy46CKBhn+xGn8bb63/WvPH90g4XePEH/0jz/jzg7wiW94
8I3f//a7wdv7LsiUiMfoP/nRpw0aXlGZ6Levv8/4hg9VZr8M+sdEvHYOvyHi
tXN4eRPg8ibA2S07Zrf4Y7fsmN2yY3ZLj/RKz/QK/n7Ea/yI1/iRRwAuXoOL
1/gVr/ErXs8PfsVr/IrX+OHPxYll4c/FiU/Cn4sTS8OfixOfhz8XJ8QZ+MQZ
+MQZ+MQZ+MQZ+MRBcVEcFBfFQXFRHBQXxUFxUbzBn+9c4M93LvA3KOIN/k6O
eIM/fMG3Z/AF34fBF3x7Bl/wnR18wQcPvPDACw+88MALD7zG99Ky59o8dX71
d2B8F8Z3YHznw3rM9zTEa9/ToD/46M93Q+gPPvEaPvEaPvHaOly83uVP9Yo+
m1iezYt4bd/YOtU8EK/NA+tU88A61Tzgj80D8Vpev3sx8vjFa/sq4rXvTLjP
o794rb14rf0P/Z7HT/Kb4nXj0J94TX/8Bv3xG/THb9Afv4Eev0F/4jX53Xug
P/GaPsRr+hCv9RevtRevtRev3QsRr+2bLYl4fe1vR12765jKFK//Nn6PM8qe
rcwGRbwWR8QVcUZcAc+/v4rH6IvH6HeNeIx+2rcO+l9GPIZf3LbOsC47Z8I7
o6875ZPCmT0nPvb8V7XSPrW4Ti7x2Dpk9IBPBj15dJ1sWJ+FHW48a01B/aJv
Xl90ygmL1xYm7bL62mkd66R9a3zSGzs7O+hP/Ue/634xojLRJwf65KDXs86o
WPXeIbsk+vYlNwX9Jf83+rP3W++S6PPv/BT/zk/x794r+Hd+in/np/hP+PhP
cY3/FNf4T3GN/xTXRufu7clb6hHzvKzJ4Y/X77865Wvm7yHJg9F+8uiTen54
bWl1HmToybgZp5r1u6rHrarv/Kt6PlCaaT/81bO+Kdm5LNWpSucF0Z59WSey
r0crn/lqtyklGftyLsC+2C37so5EFx/o4gNdfLAv84J9oc++0Gdf6LMv84Z9
oc++bgj67Av9tG8Qcct7ufdM7+XeM9mXuMW+xC32BR/7EgfZlzjIvqwj2Jd1
xKjcPU72xQ82CPviB/P30tiX9uwr5cmGfdGbeVjzPKF6XtKr9vSqPb1qX3O9
X73/dtsxp79X+eiPvrMP6b7l7Tn4NvzVz/n+3iesr72XWF+zU/9r53/t+Hlw
9jU74P7Xzv/a4b/lv/mZlu5luqf5Sq2FPYdsqpf0IS/OvU3vOc6NnPs4N1Jn
RlyyXvG+hZ57mDXpVd/DdC8TPedO6Dl38p6CnviO3llf7fdZ2/fqZfUuKn70
64kLC+SmB/9rl/91T/vyXJ0WdVvUicnXVfHs/Ywf837Gj3k/48e8n10QfqxN
vJ+xA+se+Kx74LPugc+6Bz7rnvQ+HfwNCD93XfDHz+GPn0t5X+Hnjgj+2Bf+
+E38wYc/+FIeUeBrHvzB5x53v2WrB7Q6clnKt9u5Vb8F7ff8KNUjA5f/VCfg
C2L9yy9Z/zYMvySugYtr4qJ9F+to+zTwHBfrQ/2tD/Xn18D5NX7ROhF+60T4
5fW9dsy0D75tUCede3hO+tn/hQ11/liS8tHGPLPkhtcm1k/1aswj9VDMo6S/
6E9/d0V/9Uz0V89k3+hPv/w4vvlx+gWnX3D6tc6mX3qkX/39rz/9gtMvOP3C
T7/5+xPOTZwrODc5Y9Yt9Ua8sEP6XsvsJvfse/dORVmLTQdt6XzHt4UxPZu8
f/niHbLKA0e/cnuDLWmfxr6OfQ/7Okdec9Fjx68tT/guu3/Nc683qkj45v9j
8sijiiqyxoFPHQf35Nm9cRZfvm/dAffa4WMn8NGHcxn6sM/TI/Th+zT0cUb5
qgNOa1Oe0UfD80/64KOfl6d9IPtG9AHfEaEP+OgDvgWhD/jowz1985zd5uvU
/ae6BvQBH7tP8yDWN96zt71vVhXsi5vX5gG/Yh5Y77jn/3lR2Vu3nV+atYr+
7FZ/dqu/9bv3VPTtK6NvnvA77Bt9dQHQHx390dcfff23tw7aJbcOavI910Hs
zn4wu7MfbBzAjcPIgOvv/VV/76/6g+sPPmmPKzauuK8o+/qyffeZftDmwq+a
Lhq3rmdFegavu+GhS6rOaZSBex4Q9Tl6xXrpjah/Yf3UO37Pi/os6lV4Vi/i
3Hiuaa/V9Z29/+W/i3Jwrt5A3s7z9Qf85usJW/+3G9d10dWn75TOQx763clN
prVrnJ7BU15ywD1bD/SevEPJ3efPTvtUveL50H0uuG3J5sbpfVs7/VoF3LP2
3p965fBqn85xc3jy7bb3na3tfZcr/x0u5zZn//O3ZccP3DHtC3kGP6reu0/s
+U5Fgnt+4IvS1x/804+/Mx41/19R6BNyktuzX+18h8Sz74wsj/tUeTzae9a+
W9x/8r7RddXyedMazS14bzg1no+bPGXw8281zvaMdb1n6+7t/e+5Zvx5O9mt
e1ieh51/+cLOr9b53u08kyevX//PnFe12ws77vIduP/xmfQQv/73Sy9+8/Jt
iyd/T/OeH3CeRr9+/U9f3cBnLBw17rJqfv2vnf/fnTKzYtin1e1q9puf9Ge9
59l7k2fruZQnk/Nb6tp4Pjfnx8A919Tzf89HXi56rZn3U+033fPy7P3Rs3tC
Nf1gUXbvHc2zY3+3uGAei6vm730BN4/B/T5ep23tf9bZKcXTx+IZ/mu7dRlX
t3397KzArx384PCDw/+bXQst1pc3Tv9fEM8XTNxw+0231k37mZ7tP+3foOP6
2cMXpPyQb7o88sQd/1MvnWuJW+KYOHNY3fc39nxrp/Rerg6VOAEOvzgDv+c+
ubgI//53N2ja8srqOlHqRsEP/i8iMWbL
   "], {{{}, 
     {RGBColor[0., 0., 0.09999999999999998], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHtw1FcVx++mYbMLu78NC9kl2Veo2lL/kMyIj1oVtY4BCY90WgkFEgqF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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllllslWUQhj+gyznQnlbacmrP+f/TsutNm1g1xgUVY6u4Ek2wBFoqi21i
UVFA40YVpIJQtoCISmI06oXLha3FBfcrCyRiAgqJRi9QKJYKshTU5817Mck3
/8w3M9/MOzN/TevimR0jQwiboTxo2cUhLIc2JkNoGRFCZxzC09Db+SE0lISw
pSKE4SiE3akQ3uPbec7noBn5/rZ1XAhzoTLuP1gYQn0uhEb4HwpCKOTbPGzN
gbrRz2Evh3wK8k3Ib4avhm8vD+H2YvzAv58OoQN5jrubEyG04j8qI0Zsz8fG
WXyfgm7h/Bn+/8R2C/cbuP819zPYm8z9ddiP4a/IhnAlVIJ8G+97DVkzVJ60
zVXYeh46QTKmY68Of6VlfksJPp4kN09Bb6Hfx/1vx4awMrLuFHxk8Xcn/uux
fxp/F4hnGHoY2X74y5HPwt8R+BQ2kvCF0DPwvyLvwt96vUe5xN8g9k/A98FP
Q6cJ+YrYtXgCvg/Zp9BDyIvRn4S8JXZu25APIRuEGvNto5vzOuhknn0cRPdo
lWPvVb4z1BV6pyiEd6GfkDfynkt5z8fIt3F3O3Q3d89jI4W8FPoefpZqSm6r
oVHoTyM/O7DVxv3b4Ldi71HevgQqKDAmdB5TiX7S32q5Wwc9ju4c4Q/5Cqiw
wDnTuQj9vKS/6W0noV0pv1FY/Bf6ImVMLsH/Hfi/DP/3Fxkrp5WzlDGzGNkk
4v8FfvZoMEItanLGnjCZ43411AP2boBvx/++KteuHkxcQFaCjTHYHw3tRdY2
zrLEGPICvwi+Dn4Q+x+A56Fyn7dgc2zsHCp3/cRwL7LPiW8J56vQeYC7/VXu
HdkYQDfOOJZviPE4sr+q3BuX8O00slHYyCOWkdAubNVWGBuqWQ3358G35rtm
fyO/D/6jhHP4j7AP5q4vcI7Go1+HvUpsHYY/RG0OQ9vI5RvUZ0WlY1asG4ix
Gv0JsXXlowHdxqyx1DPC2NsI3ZoyBrsrXQPl/k3uX4iMcWFbNXwBfiL8JuK7
Cf4Uuq/wbSbnFr5tiIx5YV02p5Hf69LuTfXUtZyvSXuWqQc/Qb8UG0XF7hn1
+urIttXzK8nfPcivRr6cmPuJfQ80n/MMbATOE5CXIk9BL3L3O/I1VfMLG13w
ayKfh7CXR2wXxa7tIwm/ZS3yhpTfpF7rwF5TsXvuMLoDVa5lH/WtAotRzrNE
M6yXWZQgZ4Fc9WoGpZ0T5WInVIjsfOxZ81/Cs7Y59uzTzN0RuYfVu8rhubRt
ytbxhLFwJvIsFSZ+572/ZV3r7cR3I3g8y52BhHtWsSRynl2K6UDab9Zbv4T2
wocK90Iv/Bn4Hvz1JG3jR2zvzzq3CzUfMu5Z9apyrlwfi4115VxYLEB/XLEx
+WrGM0azRZgcX+4aqTaa8aq1elS9qZqPLHePqDc0o9Qrh2LnWj3TWWlMC8va
gdN573DaudHMWZUxRoQNzSjtxmdj7y7tyA2VxrSwrB2hXbQR/TVF3kmahUfQ
/6rEM/E5Yu3MujfSwhOy1bF3613oTOY8Mfau04x6HVs7M67Fy9AfyLIZ7wbZ
XMp5Wca5XAAtQr4g9i6Ziny3aht5l2nGKJe15fatnEbcPRp7d2oGHAOLP8ee
/cK43rIJWlvkN7Vxbodmc26C9pCrxeSsOumZqVoLk8Kiai6sd8V+mzCvXamY
Fat2pnpvYexY1YP6F9Cb9Vb9E2gXyad8aSdpth+Ivbs04+V7X9pYUwza7QfT
xqJ2fDvvbct6t2hmN3Oem/Wu0hv0r/Fh2rNZ/xz6l9mVdm/pn2Ypuo9l/e+g
HLwUuefV6+rp/wFqPkAz
         "],
         VertexColors->None]}]}, 
     {RGBColor[0., 0., 0.30000000000000004`], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgeUldW1xz9ncIa5M3eGO3eYdstgN2qsT33PZzRqVCDrCSpiRcVEDYQS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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHd01FUWxx8JEFIGQmacSTK/mQCKurALnuO69r5AcM+uylGxIG1dFUVQ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         "],
         VertexColors->None]}]}, 
     {RGBColor[0., 0., 0.5], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgeUldW1xz+YdqeXO9y5d+YyExvmoaJ5GgsIPgsaiATFLiBq1OQ9morB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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHucz2UWx7+YMdffhN/4ze86ttJNUqIUYSuXKCmU1mWRaLfMEF5CKLW6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         "],
         VertexColors->None]}]}, 
     {RGBColor[0., 0., 0.7], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFm3eYldW1xj+mcM7MwLTTz8w5Az5BxCAIIiAQUGzhUmJBUIkJiWLQiAXF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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHeQ1dUVx3/sLmx5sAu7r/3e7nuwJAioVGEBQRYQUERQehMlUZGodMWo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         "],
         VertexColors->None]}]}, 
     {RGBColor[0., 0., 0.9], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3mYlMW1xr8Zpmemp4ee7p7pnukeehDFCCog4IYsouCuWSDuRnAXZFPQ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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXucz2UWx7+Y+zAzZn7f7+8yvjPG0hqFKJL7pZXCVkJJIlK6ao3uiqh0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         "],
         VertexColors->None], 
        PolygonBox[{{6216, 6379, 2555, 5127, 6215}, {6381, 6216, 6215, 5128, 
         2556}, {6234, 6391, 2564, 5145, 6233}, {6388, 6234, 6233, 5144, 
         2563}},
         VertexColors->None]}]}, 
     {RGBColor[1., 0.1, 0.1], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFm3mUVNW1xm+39AzdVdVV1QNUN4ggMqOIgCgqDqgQfQaNiUqiIIhoAjjh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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHm4j2Uax1/5nd05znF+7287fufU2Pfsa2VJyRpFui7pSiJL1ExCqKxR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         "],
         VertexColors->None], 
        PolygonBox[{{6242, 5164, 2581, 6414, 6241}, {5149, 6237, 6236, 6396, 
         2566}, {6237, 5148, 2565, 6393, 6236}, {5163, 6242, 6241, 6412, 
         2580}},
         VertexColors->None]}]}, 
     {RGBColor[1., 0.30000000000000004`, 0.30000000000000004`], EdgeForm[
      None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFm3u41VWZx3+c6z7sc84+l30/Z++NgJlAilwF1FABDZXDJRQftRJU1OaJ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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmAeQldUVxz+2sG8by+6r39t9CwhiAZVehUgPCCxFihliQaWZRDFShcQo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         "],
         VertexColors->None]}]}, 
     {RGBColor[1., 0.5, 0.5], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgmUlcWVxz+6obtfN03TvO7X/d776FacgzrGEUlcJqMBFCUCChKDSk4w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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHu8jWUWx1+H49gOR9nbOXu/+6KYQVNNhxpdJqFcCuWSSH1S5JruKeVS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         "],
         VertexColors->None]}]}, 
     {RGBColor[1., 0.7, 0.7], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgmUVNW1hi/d0EVXd1HdXT1XdbVMDsnSmJiYAD4xxqdGIQqIGmdFFAVR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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHmYlMURxpsdZGB2lyXsMjuz881s5ApqkidCNB6ooJjHKCKHHCEmhEPA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         "],
         VertexColors->None]}]}, 
     {RGBColor[1., 0.9, 0.9], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmH2Q1WUVx3934d69u9yXYZe9y+5e7oZAluEfZhphODC8OAg4LcuKsiSw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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlllslGUUhr8WZjptZzqxU/7pMvMTKIgiXgGKJRAI6AUKkUWiFCgWQZO2
lCVuoK1QlbigCEWiUSFRAUEvXEqqiUsgoHgjAuqN3qJAFQQEjQo+b14vTuY7
/znf+539zLDWzjkrSkMIvdBg6Of6EL6LQ+jLhjAiGUKa88IhIazjfKQqhI6G
ENqhRekQFkPltSFkhoZwEv2S8hBmFkKYBX2I7NMScHIhJNG5kuKM/EB1CA8V
Q2gCqxHMRVEI+/MhvIa8Gvl9vNcK9SZ4H8wLnBt571Z0v4TfBP8c9D7yefBn
OQ9DPg35Ifg/OF/lzZIMv9iwEvwT4H8C/jDwe7FlK7Sb855y23YZjG+ytnEj
vj6BfVOqbEMtvtRBAbwJ+LMV2TZoJvK/CNhU8C+DP8DdUvA64N+D3wIfw2+L
7KN8aysLYRf27YZ2YtsOaDqyf9E/i34CnbuxZQFUjz0v8H4nuiuhJei2QK9w
fhXaxrkXaq8xprDmYWMb/G+xYzEX/i1kb0KvI38D2o5/Fci/qnIMu5DN5k4T
up3IU/g6Fr4evg46h+4y+BmcD4N5An4a/KiMa2Q151v4dh68lgryRX4D/IEq
52Q+eHcVHLs54C/B35/w9xD+DsHfBLoXuTNd+ePOJHQnQ9Xg7+BOKfJmbO5H
/yDyGzhnc45lAvvX14Wwoc65/AL94+ifrHdtfYR9fbx1ERtbUq6xUrBHwefA
vybj2n6aO7dnXeOqne/h92ddQ9uLzrlyPYv3H+T8KDSR8ym+XQDvPLSvxDnd
GdlH+bYWG9ehe7DavTSpyr1zB++PybiHNiBvxIYHkE9FfiX3fw2nXXOSNWNP
Q9Y698PHOWOvwP/+nHtQvdcPDUf+OJiTwdqMv2ewbaDg3MvGVdhWUetaTYCX
QD8C/1v016C/lruPFW3rafzrQT9T69pMob86MobuHoX+5O4lqCPpHnoy8h3p
nkk69i8XHTvlYDW5WgNtBu8e7Gni7oTYvqiGnsXWZwqeHarBWmbLTDBu5HwB
/Ai+bqjPm8BPcXcwNJv7h7lfwvkq792ZcA3ehO6CyLZkFR/4kdBV7vfyrZu3
ugquNfXUPu6+U3Rt3cv9H8D7hXoamXRNDCc3v8fuBdXspbxnnGabZkAlsnJo
bsI9thusNPaXY/9i+F3wo4n5oIRnyEZ0e6C9CdfgP3nnVLnUTBiLrbdFjnWS
b93c7ym6VgbIz7G8Z5xm28fojxjqmaBZIB8b4a+L7OuMrHtZM0SzQz39LvfP
8e3XCs+sKvTTUE/SM31cjWeCZkFDxrFOxu5VxVy9dD72bFZPnSJWp6GXUo7Z
RPCb8s61auTaGvegek893t3gGaTZszLt3A2K3evK4SNF17RqWT3Xji/H653L
CWWO7d/cL8s4xnPg9xadu/H49DbnPUXHXjEfD/Zy8No5H1V9xPZRvp2Fvx7b
Rhdsy3xs7qb2u6AXy12zh5EdgqaVeCbv5+0+6IO0d94qsJ6PvZuawWxFtrTB
s2922liyUbYJcxy6N8d+WzblVZ+Ra1s7YDnnr+ud+zFlfktvCFtvPlz0TNIs
0k5dim2tBdueQqer6J5WL2smHCcXpfhfWemdqNhV1lhXMTzCW8siv6Wa0K7U
jNds1848hrwtcuyF8WPeM0SzQzNds+1Y7NmrGaddoRjId+0MzfKy2L2qma7e
1o7TblOPTwVvSt6zXDWYRzenHZDwjBqB7sgG17r+EyyMvTO1KzUj1UtPxa51
9ZR2n3aidqF24Pqie0i9ox2v3bc09n8N7UD1bib2fx318L68d7p2uWpatgyJ
XTuy6TNi/XnB/4VUE/8Bu5c1Pg==
         "],
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{7020, 5196, 7890, 7891, 6886, 4802, 7542, 7543, 7541, 7545, 
         7544, 5410, 7549, 7550, 7546, 7548, 7547, 4803, 6887, 7893, 7892, 
         5187, 7010, 7011, 7012, 7254, 7253, 4931, 7192, 7193, 7158, 5118, 
         7157, 5119, 7894, 7895, 6888, 6889, 6890, 6058, 6059, 5741, 6061, 
         6060, 5360, 6857, 5733, 6856, 5734, 6858, 5701, 7987, 5702, 6956, 
         6957, 5746, 5745, 6154, 5697, 6135, 6134, 5045, 6150, 7927, 7928, 
         7926, 5649, 5947, 5946, 6544, 6514, 6515, 6272, 6271, 6270, 5202, 
         7594, 7595, 7593, 5419, 4879, 5781, 5725, 6070, 6069, 5364, 7574, 
         7575, 7571, 7573, 7572, 7590, 5418, 7589, 7592, 7591, 5132, 7163, 
         5131, 7164, 7267, 7266, 4947, 7209, 7210, 7040, 7039, 7038, 5201, 
         7779, 7780, 7778, 5511, 7552, 7553, 7551, 7555, 7554, 5411, 7771, 
         7772, 7768, 7770, 7769, 7959, 5669, 7958, 7961, 7960, 5197, 7023, 
         7024, 7025, 7366, 7365, 4940, 7358, 7359, 7022, 7021, 7020}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7075, 5227, 7918, 7919, 6945, 4851, 7680, 7681, 7679, 7683, 
         7682, 5467, 7687, 7688, 7684, 7686, 7685, 4852, 6946, 7921, 7920, 
         5221, 7065, 7066, 7067, 7295, 7294, 4983, 7229, 7230, 7171, 5158, 
         7170, 5159, 7922, 7923, 6947, 6948, 6949, 6097, 6098, 5744, 6100, 
         6099, 5378, 6866, 5739, 6865, 5740, 6867, 5721, 7990, 5722, 6972, 
         6973, 5764, 5763, 6157, 5700, 6141, 6140, 5048, 6153, 7949, 7950, 
         7948, 5660, 5953, 5952, 6547, 6529, 6530, 6293, 6292, 6291, 5234, 
         7737, 7738, 7736, 5479, 4894, 5792, 5728, 6109, 6108, 5381, 7702, 
         7703, 7699, 7701, 7700, 7733, 5478, 7732, 7735, 7734, 5172, 7176, 
         5171, 7177, 7306, 7305, 4997, 7245, 7246, 7095, 7094, 7093, 5233, 
         7820, 7821, 7819, 5527, 7690, 7691, 7689, 7693, 7692, 5468, 7814, 
         7815, 7811, 7813, 7812, 7971, 5672, 7970, 7973, 7972, 5228, 7078, 
         7079, 7080, 7411, 7410, 4988, 7403, 7404, 7077, 7076, 7075}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{6166, 5065, 6309, 6366, 6365, 7354, 7355, 7353, 7357, 7356, 
         5256, 6532, 5255, 7352, 5819, 4873, 4795, 6534, 5257, 6533, 5258, 
         7363, 7364, 7360, 7362, 7361, 6371, 6372, 6320, 5068, 6319, 5067, 
         7924, 7925, 7034, 7035, 4944, 6066, 4945, 7037, 7036, 7111, 7110, 
         5015, 6114, 5016, 7113, 7112, 5510, 5801, 4946, 5206, 7206, 7208, 
         7207, 5130, 6222, 6223, 6224, 6898, 4809, 5925, 4813, 6900, 6457, 
         5207, 6456, 5208, 7271, 7272, 7268, 7270, 7269, 4954, 5803, 5514, 
         7120, 7121, 5020, 6118, 5019, 7118, 7119, 7048, 7049, 4958, 6011, 
         6770, 6771, 6769, 6773, 6772, 5078, 7152, 5079, 6325, 6516, 8018, 
         5038, 7318, 7319, 7317, 7321, 7320, 5051, 6142, 5050, 8022, 5687, 
         6182, 4814, 5927, 5823, 6513, 5247, 6512, 5248, 7315, 7316, 7312, 
         7314, 7313, 5037, 6298, 6837, 6836, 5633, 6158, 6159, 5813, 5049, 
         6844, 6763, 6615, 6616, 6614, 7449, 7448, 6009, 4941, 7026, 6268, 
         6667, 6666, 6761, 5964, 5013, 7107, 7106, 5508, 5798, 4932, 7195, 
         7196, 7194, 7198, 7197, 5189, 7189, 5188, 8084, 6508, 7256, 7255, 
         5922, 6431, 6432, 6430, 6429, 6212, 5114, 7251, 7252, 7248, 7250, 
         7249, 4930, 5797, 5504, 7100, 7101, 5009, 5959, 7886, 7523, 7524, 
         7008, 7009, 4929, 6052, 4928, 7007, 7006, 7522, 7521, 6173, 6166}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6192, 5089, 6343, 6402, 6401, 7399, 7400, 7398, 7402, 7401, 
         5268, 6541, 5267, 7397, 5832, 4888, 4845, 6543, 5269, 6542, 5270, 
         7408, 7409, 7405, 7407, 7406, 6406, 6407, 6349, 5095, 6348, 5094, 
         7946, 7947, 7089, 7090, 4994, 6102, 4995, 7092, 7091, 7141, 7140, 
         5031, 6128, 5032, 7143, 7142, 5526, 5810, 4996, 5239, 7242, 7244, 
         7243, 5170, 6251, 6252, 6253, 6953, 4857, 5942, 4862, 6955, 6504, 
         5240, 6503, 5241, 7310, 7311, 7307, 7309, 7308, 5003, 5812, 5529, 
         7150, 7151, 5036, 6132, 5035, 7148, 7149, 7098, 7099, 5005, 6029, 
         6804, 6805, 6803, 6807, 6806, 5104, 7155, 5105, 6353, 6531, 8021, 
         5044, 7348, 7349, 7347, 7351, 7350, 5060, 6145, 5059, 8025, 5696, 
         6207, 4863, 5944, 5838, 6528, 5253, 6527, 5254, 7345, 7346, 7342, 
         7344, 7343, 5043, 6301, 6843, 6842, 5646, 6164, 6165, 5816, 5058, 
         6853, 6768, 6648, 6649, 6647, 7465, 7464, 6025, 4989, 7081, 6287, 
         6706, 6705, 6766, 5993, 5028, 7135, 7134, 5523, 5808, 4984, 7232, 
         7233, 7231, 7235, 7234, 5223, 7221, 5222, 8092, 6511, 7297, 7296, 
         5936, 6484, 6485, 6483, 6482, 6239, 5151, 7292, 7293, 7289, 7291, 
         7290, 4982, 5807, 5520, 7130, 7131, 5025, 5988, 7908, 7657, 7658, 
         7063, 7064, 4981, 6090, 4980, 7062, 7061, 7656, 7655, 6201, 6192}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{6303, 6171, 6172, 4794, 6734, 5617, 6733, 6736, 6735, 5272, 
         6167, 6869, 6870, 4869, 5954, 5841, 5842, 5404, 5777, 4870, 5955, 
         6043, 6044, 5817, 5061, 5958, 5062, 6427, 6428, 6426, 7188, 5186, 
         8083, 6875, 6876, 6874, 5629, 7887, 5281, 7528, 7529, 7525, 7527, 
         7526, 4899, 7753, 7754, 7752, 7756, 7755, 5283, 7416, 5284, 6877, 
         6878, 6434, 5190, 6433, 6436, 6435, 5070, 5963, 5069, 5821, 6054, 
         6053, 5965, 5852, 5853, 5361, 5855, 5854, 5969, 5862, 6179, 6178, 
         6561, 5299, 6621, 8004, 6622, 6620, 6960, 6961, 4810, 5751, 5729, 
         5825, 5824, 4904, 7867, 7868, 7866, 7870, 7869, 5625, 7980, 5686, 
         7979, 5685, 6846, 6845, 6230, 6627, 6626, 5304, 6324, 5303, 6569, 
         5869, 4820, 5867, 5868, 5366, 5866, 8100, 5865, 4819, 6681, 6682, 
         5756, 5755, 6119, 5077, 6459, 6460, 6458, 7211, 5209, 8087, 6679, 
         5431, 7616, 5432, 7617, 5430, 7619, 7620, 7618, 5433, 4903, 7585, 
         7586, 7584, 7588, 7587, 5417, 7935, 5652, 7934, 5651, 6449, 5200, 
         6448, 6451, 6450, 5075, 6115, 5749, 5750, 6671, 6670, 4807, 4877, 
         8097, 5779, 5414, 5851, 5850, 4801, 4875, 6556, 5290, 6318, 5291, 
         6738, 6739, 6737, 5618, 7862, 6305, 6306, 6304, 6308, 6307, 6364, 
         6302, 6303}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6337, 6199, 6200, 4844, 6755, 5623, 6754, 6757, 6756, 5317, 
         6193, 6914, 6915, 4885, 5982, 5889, 5890, 5462, 5787, 4886, 5983, 
         6083, 6084, 5830, 5086, 5987, 5087, 6480, 6481, 6479, 7220, 5220, 
         8091, 6934, 6935, 6933, 5644, 7909, 5325, 7662, 7663, 7659, 7661, 
         7660, 4909, 7799, 7800, 7798, 7802, 7801, 5327, 7433, 5328, 6938, 
         6939, 6487, 5224, 6486, 6489, 6488, 5097, 5992, 5096, 5834, 6092, 
         6091, 5994, 5904, 5905, 5379, 5907, 5906, 5996, 5910, 6205, 6204, 
         6596, 5340, 6654, 8007, 6655, 6653, 6976, 6977, 4858, 5770, 5732, 
         5840, 5839, 4915, 7882, 7883, 7881, 7885, 7884, 5628, 7986, 5695, 
         7985, 5694, 6855, 6854, 6257, 6659, 6658, 5346, 6352, 5345, 6601, 
         5920, 4868, 5918, 5919, 5383, 5917, 8108, 5916, 4867, 6720, 6721, 
         5775, 5774, 6133, 5103, 6506, 6507, 6505, 7247, 5242, 8094, 6717, 
         5498, 7747, 5499, 7748, 5497, 7750, 7751, 7749, 5500, 4914, 7728, 
         7729, 7727, 7731, 7730, 5477, 7957, 5664, 7956, 5663, 6495, 5232, 
         6494, 6497, 6496, 5099, 6129, 5768, 5769, 6710, 6709, 4854, 4892, 
         8104, 5789, 5470, 5903, 5902, 4850, 4890, 6589, 5332, 6347, 5333, 
         6759, 6760, 6758, 5624, 7865, 6339, 6340, 6338, 6342, 6341, 6400, 
         6336, 6337}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{6355, 5107, 6354, 5106, 6548, 6549, 7413, 7412, 5271, 5353, 
         8028, 5352, 5588, 8058, 5589, 5585, 5587, 8057, 5586, 5615, 4793, 
         7993, 5280, 5279, 5591, 8059, 5590, 5356, 8030, 5357, 6608, 6170, 
         6553, 6552, 5116, 7156, 5117, 6370, 5292, 6557, 7161, 5124, 7162, 
         5125, 6375, 5296, 6821, 6822, 6276, 6277, 4952, 6068, 4953, 7582, 
         7583, 7581, 5416, 5972, 5971, 5298, 5181, 8011, 4902, 5428, 5429, 
         5425, 5427, 8099, 5426, 5926, 5655, 8069, 5656, 5434, 7622, 5436, 
         7621, 5435, 6989, 6988, 6987, 7181, 7180, 7902, 5976, 5977, 5516, 
         7784, 7786, 7785, 4961, 6017, 6786, 6787, 6785, 6789, 6788, 5309, 
         6385, 5138, 6232, 6571, 6572, 5310, 5870, 5139, 6075, 5784, 6573, 
         6574, 6184, 6185, 7478, 7479, 6990, 6991, 6992, 5565, 7837, 5566, 
         7838, 5305, 6012, 6013, 5705, 5757, 4815, 4881, 6964, 6965, 6774, 
         6776, 6775, 5562, 7836, 5564, 7835, 5563, 6986, 6985, 6984, 7472, 
         7471, 5300, 6562, 6564, 6563, 5782, 6071, 5133, 5863, 6896, 6218, 
         6217, 6214, 5126, 6376, 6611, 7442, 7443, 6610, 7441, 7440, 6006, 
         4933, 7758, 7759, 7757, 5505, 6111, 6110, 5010, 7102, 7103, 7179, 
         7178, 6982, 6983, 5405, 7530, 5406, 7531, 5282, 5630, 7994, 4796, 
         5921, 4791, 7991, 5274, 5273, 5399, 8036, 5398, 4897, 8008, 5178, 
         4923, 6045, 6046, 5397, 7514, 5396, 4922, 6042, 4921, 7004, 6266, 
         6662, 6661, 6660, 6358, 5109, 6356, 5108, 6357, 6868, 6355}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5887, 5147, 6020, 5146, 6581, 6582, 7425, 7424, 5316, 6636, 
         6637, 6634, 5371, 6635, 5606, 7856, 5607, 7857, 5605, 7854, 7855, 
         7851, 7853, 7852, 7861, 4843, 6932, 6931, 7432, 7431, 5324, 6732, 
         5609, 6730, 5608, 6731, 8096, 5374, 8034, 8035, 7453, 7452, 6639, 
         6198, 6586, 6585, 5156, 6022, 5157, 5895, 5334, 6411, 5163, 6242, 
         5164, 6415, 5336, 6831, 6832, 6296, 6297, 5001, 6107, 5002, 7725, 
         7726, 7724, 5476, 6000, 5999, 6001, 5940, 5941, 6149, 6148, 5795, 
         5796, 5495, 7744, 5496, 7745, 5492, 5494, 8107, 5493, 5943, 5667, 
         8072, 5668, 5501, 5503, 8041, 5502, 4919, 5185, 5648, 6004, 6005, 
         5531, 7825, 7827, 7826, 5008, 6033, 6817, 6818, 6816, 6820, 6819, 
         5350, 6420, 5176, 6260, 6605, 6606, 5351, 6421, 5177, 6261, 6607, 
         7436, 7437, 6210, 6211, 5395, 8017, 4920, 5580, 8055, 5581, 5347, 
         6030, 6031, 5724, 5776, 4864, 4896, 6980, 6981, 6808, 6810, 6809, 
         5577, 5579, 8054, 5578, 4916, 8015, 5393, 5341, 6597, 6599, 6598, 
         6255, 6254, 5173, 6417, 6951, 6247, 6246, 6245, 5165, 6416, 6643, 
         7460, 7461, 6642, 7459, 7458, 6023, 4985, 7804, 7805, 7803, 5521, 
         6125, 6124, 5026, 5182, 8013, 4910, 5463, 8039, 5464, 5326, 7910, 
         7911, 6936, 6937, 4846, 5935, 4837, 6921, 6920, 7427, 7426, 5318, 
         7643, 5458, 7642, 5457, 6265, 6264, 6424, 7185, 6425, 6285, 6284, 
         4973, 6085, 6086, 5456, 7641, 5455, 4972, 6082, 4971, 7053, 6283, 
         6699, 6698, 6695, 6395, 5149, 6237, 5148, 6394, 6913, 5887}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{8, 7843, 5582, 5584, 8056, 5583, 4924, 5533, 8042, 5534, 
         5532, 5674, 8073, 5673, 7828, 7516, 7517, 7515, 7519, 7518, 5384, 
         7469, 7470, 7466, 7468, 7467, 5960, 5845, 5846, 5359, 5848, 7996, 
         5847, 6559, 6377, 7997, 6379, 6216, 6381, 6380, 6560, 7936, 7937, 
         6823, 6827, 6826, 5420, 6677, 6678, 6674, 6676, 6675, 7938, 7597, 
         7598, 7596, 7600, 7599, 5385, 7476, 7477, 7473, 7475, 7474, 7625, 
         5675, 8074, 5676, 5535, 5537, 8043, 5536, 4962, 5539, 8044, 5540, 
         5538, 7832, 7833, 7829, 7831, 7830, 6466, 6911, 6467, 6190, 5214, 
         5244, 8026, 5243, 4964, 5551, 8048, 5552, 5550, 5640, 8067, 5639, 
         4831, 5714, 8081, 5715, 5713, 6039, 6038, 5389, 7495, 7496, 7492, 
         7494, 7493, 4832, 5884, 5885, 5369, 5888, 5886, 4833, 6392, 6393, 
         6236, 6396, 6969, 8001, 8000, 4834, 6916, 6917, 6694, 6697, 6696, 
         5454, 6701, 6702, 6700, 6919, 6918, 4835, 7498, 7499, 7497, 7501, 
         7500, 5390, 6040, 6041, 5716, 5718, 8082, 5717, 4836, 5641, 8068, 
         5642, 5556, 5558, 8050, 5557, 4966, 5598, 8061, 5599, 5597, 5682, 
         8077, 5681, 4838}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{106, 7859, 5616, 5684, 8078, 5683, 4960, 5542, 8045, 5543, 
         5541, 5636, 8065, 5635, 4823, 5708, 8079, 5709, 5707, 6035, 6034, 
         5387, 7485, 7486, 7482, 7484, 7483, 4824, 5877, 5878, 5368, 5881, 
         5879, 4825, 6387, 6388, 6234, 6391, 6968, 7999, 7998, 4826, 6905, 
         6906, 6685, 6688, 6687, 5449, 6692, 6693, 6691, 6908, 6907, 4827, 
         7488, 7489, 7487, 7491, 7490, 5388, 6036, 6037, 5710, 5712, 8080, 
         5711, 4828, 5637, 8066, 5638, 5544, 5546, 8046, 5545, 4963, 5548, 
         8047, 5549, 5547, 7977, 7978, 7974, 7976, 7975, 4830, 6912, 6835, 
         6191, 5085, 5246, 8027, 5245, 4970, 5554, 8049, 5555, 5553, 5678, 
         8075, 5677, 7834, 7637, 7638, 7636, 7640, 7639, 5391, 7505, 7506, 
         7502, 7504, 7503, 5986, 5891, 5892, 5375, 5894, 8002, 5893, 6590, 
         6410, 8003, 6412, 6241, 6414, 6413, 6591, 7953, 7954, 6830, 6834, 
         6833, 5475, 6714, 6715, 6711, 6713, 6712, 7955, 7720, 7721, 7719, 
         7723, 7722, 5392, 7512, 7513, 7509, 7511, 7510, 7746, 5679, 8076, 
         5680, 5559, 5561, 8051, 5560, 5007, 5613, 8064, 5614, 5610, 5612, 
         8063, 5611, 5945}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{6360, 5111, 6359, 5110, 6550, 6551, 7415, 7414, 5275, 5355, 
         8029, 5354, 5593, 8060, 5594, 5592, 7847, 7848, 7844, 7846, 7845, 
         7858, 4797, 6880, 6879, 7418, 7417, 5285, 6724, 5596, 6722, 5595, 
         6723, 8095, 5358, 8031, 8032, 7439, 7438, 6609, 6174, 6555, 6554, 
         5120, 6007, 5121, 5849, 5295, 6378, 5127, 6215, 5128, 6382, 5297, 
         6824, 6825, 6278, 6279, 4955, 6072, 4956, 7602, 7603, 7601, 5421, 
         5974, 5973, 5975, 5928, 5929, 6147, 6146, 5793, 5794, 5440, 7623, 
         5441, 7624, 5437, 5439, 8101, 5438, 5931, 5657, 8070, 5658, 5446, 
         7632, 5448, 7631, 5447, 6995, 6994, 6993, 7183, 7182, 7903, 5978, 
         5979, 5517, 7787, 7789, 7788, 4965, 6019, 6791, 6792, 6790, 6794, 
         6793, 5311, 6386, 5140, 6235, 6575, 6576, 5312, 5876, 5141, 6081, 
         5785, 6577, 6578, 6186, 6187, 7480, 7481, 6996, 6997, 6998, 5570, 
         7839, 5571, 7840, 5308, 6015, 6016, 5706, 5760, 4818, 4882, 6966, 
         6967, 6782, 6784, 6783, 5567, 5569, 8052, 5568, 4907, 8012, 5386, 
         5302, 6566, 6568, 6567, 6229, 6228, 5137, 6384, 6897, 6221, 6220, 
         6219, 5129, 6383, 6613, 7446, 7447, 6612, 7445, 7444, 6008, 4939, 
         7766, 7767, 7765, 5507, 6113, 6112, 5012, 5180, 8010, 4901, 5408, 
         8038, 5409, 5287, 5632, 7995, 4800, 5923, 4792, 7992, 5278, 5277, 
         5403, 8037, 5402, 4898, 8009, 5179, 4927, 6050, 6051, 5401, 7520, 
         5400, 4926, 6047, 4925, 7005, 6267, 6665, 6664, 6663, 6363, 5113, 
         6361, 5112, 6362, 6871, 6360}],
        RowBox[{"-", "0.2`"}]],
       Annotation[#, -0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5880, 5143, 6018, 5142, 6579, 6580, 7421, 7420, 5313, 6632, 
         6633, 6630, 5370, 6631, 5601, 7849, 5602, 7850, 5600, 6728, 6729, 
         6725, 6727, 6726, 7860, 4839, 6923, 6922, 7429, 7428, 5319, 5604, 
         8062, 5603, 5372, 8033, 5373, 6638, 6194, 6584, 6583, 5152, 7167, 
         5153, 6403, 5331, 6588, 7172, 5160, 7173, 5161, 6408, 5335, 6828, 
         6829, 6294, 6295, 4998, 6103, 4999, 7705, 7706, 7704, 5471, 5998, 
         5997, 5337, 5183, 8014, 4911, 5483, 5484, 5480, 5482, 8105, 5481, 
         5938, 5665, 8071, 5666, 5489, 5491, 8040, 5490, 4917, 5184, 5647, 
         6002, 6003, 5530, 7822, 7824, 7823, 5006, 6032, 6812, 6813, 6811, 
         6815, 6814, 5348, 6418, 5174, 6258, 6602, 6603, 5349, 6419, 5175, 
         6259, 6604, 7434, 7435, 6208, 6209, 5394, 8016, 4918, 5575, 8053, 
         5576, 5344, 6027, 6028, 5723, 5773, 4861, 4895, 6978, 6979, 6800, 
         6802, 6801, 5572, 7842, 5574, 7841, 5573, 7003, 7002, 7001, 7508, 
         7507, 5339, 6593, 6595, 6594, 5791, 6106, 5169, 5909, 6950, 6244, 
         6243, 6240, 5162, 6409, 6641, 7456, 7457, 6640, 7455, 7454, 6021, 
         4979, 7796, 7797, 7795, 5519, 6123, 6122, 5024, 7128, 7129, 7187, 
         7186, 6999, 7000, 5460, 7653, 5461, 7654, 5321, 7906, 7907, 6927, 
         6928, 4842, 5933, 4829, 6910, 6909, 7423, 7422, 5315, 7635, 5453, 
         7634, 5452, 6263, 6262, 6422, 7184, 6423, 6282, 6281, 4969, 6079, 
         6080, 5451, 7633, 5450, 4968, 6076, 4967, 7052, 6280, 6690, 6689, 
         6686, 6390, 5145, 6233, 5144, 6389, 6902, 5880}],
        RowBox[{"-", "0.2`"}]],
       Annotation[#, -0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{6311, 6175, 6176, 4798, 6741, 5619, 6740, 6743, 6742, 5276, 
         6169, 6872, 6873, 4871, 5956, 5843, 5844, 5407, 5778, 4872, 5957, 
         6048, 6049, 5818, 5063, 5961, 5064, 6438, 6439, 6437, 7190, 5191, 
         8085, 6882, 6883, 6881, 5631, 7889, 5286, 7539, 7540, 7536, 7538, 
         7537, 4900, 7761, 7762, 7760, 7764, 7763, 5288, 7419, 5289, 6884, 
         6885, 6445, 5195, 6444, 6447, 6446, 5074, 5966, 5073, 5822, 6057, 
         6056, 5968, 5858, 5859, 5363, 5861, 5860, 5970, 5864, 6181, 6180, 
         6565, 5301, 6624, 8005, 6625, 6623, 6962, 6963, 4812, 5754, 5730, 
         5828, 5827, 4906, 7872, 7873, 7871, 7875, 7874, 5626, 7982, 5689, 
         7981, 5688, 6849, 6848, 6231, 6629, 6628, 5307, 6326, 5306, 6570, 
         5875, 4822, 5873, 5874, 5367, 5872, 8102, 5871, 4821, 6683, 6684, 
         5759, 5758, 6121, 5080, 6464, 6465, 6463, 7217, 5213, 8088, 6680, 
         5443, 7626, 5444, 7627, 5442, 7629, 7630, 7628, 5445, 4905, 7605, 
         7606, 7604, 7608, 7607, 5422, 7940, 5654, 7939, 5653, 6453, 5203, 
         6452, 6455, 6454, 5076, 6117, 5752, 5753, 6673, 6672, 4808, 4878, 
         8098, 5780, 5415, 5857, 5856, 4804, 4876, 6558, 5293, 6321, 5294, 
         6745, 6746, 6744, 5620, 7863, 6313, 6314, 6312, 6316, 6315, 6367, 
         6310, 6311}],
        RowBox[{"-", "0.4`"}]],
       Annotation[#, -0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6329, 6195, 6196, 4840, 6748, 5621, 6747, 6750, 6749, 5314, 
         6189, 6903, 6904, 4883, 5980, 5882, 5883, 5459, 5786, 4884, 5981, 
         6077, 6078, 5829, 5083, 5984, 5084, 6469, 6470, 6468, 7218, 5215, 
         8089, 6925, 6926, 6924, 5643, 7905, 5320, 7651, 7652, 7648, 7650, 
         7649, 4908, 7791, 7792, 7790, 7794, 7793, 5322, 7430, 5323, 6929, 
         6930, 6476, 5219, 6475, 6478, 6477, 5093, 5989, 5092, 5833, 6089, 
         6088, 5991, 5898, 5899, 5377, 5901, 5900, 5995, 5908, 6203, 6202, 
         6592, 5338, 6651, 8006, 6652, 6650, 6974, 6975, 4856, 5767, 5731, 
         5837, 5836, 4913, 7877, 7878, 7876, 7880, 7879, 5627, 7984, 5692, 
         7983, 5691, 6852, 6851, 6256, 6657, 6656, 5343, 6350, 5342, 6600, 
         5915, 4866, 5913, 5914, 5382, 5912, 8106, 5911, 4865, 6718, 6719, 
         5772, 5771, 6131, 5100, 6501, 6502, 6500, 7241, 5238, 8093, 6716, 
         5486, 7739, 5487, 7740, 5485, 7742, 7743, 7741, 5488, 4912, 7708, 
         7709, 7707, 7711, 7710, 5472, 7952, 5662, 7951, 5661, 6491, 5229, 
         6490, 6493, 6492, 5098, 6127, 5765, 5766, 6708, 6707, 4853, 4891, 
         8103, 5788, 5469, 5897, 5896, 4847, 4889, 6587, 5329, 6344, 5330, 
         6752, 6753, 6751, 5622, 7864, 6331, 6332, 6330, 6334, 6333, 6397, 
         6328, 6329}],
        RowBox[{"-", "0.4`"}]],
       Annotation[#, -0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{6168, 5066, 6317, 6369, 6368, 7369, 7370, 7368, 7372, 7371, 
         5260, 6535, 5259, 7367, 5820, 4874, 4799, 6537, 5261, 6536, 5262, 
         7378, 7379, 7375, 7377, 7376, 6373, 6374, 6323, 5072, 6322, 5071, 
         7929, 7930, 7041, 7042, 4948, 6067, 4949, 7044, 7043, 7115, 7114, 
         5017, 6116, 5018, 7117, 7116, 5512, 5802, 4950, 5210, 7212, 7214, 
         7213, 5134, 6225, 6226, 6227, 6899, 4811, 5930, 4816, 6901, 6462, 
         5211, 6461, 5212, 7278, 7279, 7275, 7277, 7276, 4957, 5804, 5515, 
         7124, 7125, 5022, 6120, 5021, 7122, 7123, 7050, 7051, 4959, 6014, 
         6778, 6779, 6777, 6781, 6780, 5081, 7153, 5082, 6327, 6521, 8019, 
         5040, 7328, 7329, 7327, 7331, 7330, 5054, 6143, 5053, 8023, 5690, 
         6183, 4817, 5932, 5826, 6518, 5249, 6517, 5250, 7325, 7326, 7322, 
         7324, 7323, 5039, 6299, 6839, 6838, 5634, 6160, 6161, 5814, 5052, 
         6847, 6764, 6618, 6619, 6617, 7451, 7450, 6010, 4943, 7033, 6269, 
         6669, 6668, 6762, 5967, 5014, 7109, 7108, 5509, 5800, 4938, 7202, 
         7203, 7201, 7205, 7204, 5194, 7191, 5193, 8086, 6509, 7265, 7264, 
         5924, 6442, 6443, 6441, 6440, 6213, 5115, 7260, 7261, 7257, 7259, 
         7258, 4936, 5799, 5506, 7104, 7105, 5011, 5962, 7888, 7534, 7535, 
         7015, 7016, 4935, 6055, 4934, 7014, 7013, 7533, 7532, 6177, 6168}],
        RowBox[{"-", "0.6`"}]],
       Annotation[#, -0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6188, 5088, 6335, 6399, 6398, 7384, 7385, 7383, 7387, 7386, 
         5264, 6538, 5263, 7382, 5831, 4887, 4841, 6540, 5265, 6539, 5266, 
         7393, 7394, 7390, 7392, 7391, 6404, 6405, 6346, 5091, 6345, 5090, 
         7941, 7942, 7082, 7083, 4990, 6101, 4991, 7085, 7084, 7137, 7136, 
         5029, 6126, 5030, 7139, 7138, 5524, 5809, 4992, 5235, 7236, 7238, 
         7237, 5166, 6248, 6249, 6250, 6952, 4855, 5937, 4859, 6954, 6499, 
         5236, 6498, 5237, 7303, 7304, 7300, 7302, 7301, 5000, 5811, 5528, 
         7146, 7147, 5034, 6130, 5033, 7144, 7145, 7096, 7097, 5004, 6026, 
         6796, 6797, 6795, 6799, 6798, 5101, 7154, 5102, 6351, 6526, 8020, 
         5042, 7338, 7339, 7337, 7341, 7340, 5057, 6144, 5056, 8024, 5693, 
         6206, 4860, 5939, 5835, 6523, 5251, 6522, 5252, 7335, 7336, 7332, 
         7334, 7333, 5041, 6300, 6841, 6840, 5645, 6162, 6163, 5815, 5055, 
         6850, 6767, 6645, 6646, 6644, 7463, 7462, 6024, 4987, 7074, 6286, 
         6704, 6703, 6765, 5990, 5027, 7133, 7132, 5522, 5806, 4978, 7225, 
         7226, 7224, 7228, 7227, 5218, 7219, 5217, 8090, 6510, 7288, 7287, 
         5934, 6473, 6474, 6472, 6471, 6238, 5150, 7283, 7284, 7280, 7282, 
         7281, 4976, 5805, 5518, 7126, 7127, 5023, 5985, 7904, 7646, 7647, 
         7056, 7057, 4975, 6087, 4974, 7055, 7054, 7645, 7644, 6197, 6188}],
        RowBox[{"-", "0.6`"}]],
       Annotation[#, -0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{7027, 5198, 7896, 7897, 6891, 4805, 7557, 7558, 7556, 7560, 
         7559, 5412, 7564, 7565, 7561, 7563, 7562, 4806, 6892, 7899, 7898, 
         5192, 7017, 7018, 7019, 7263, 7262, 4937, 7199, 7200, 7160, 5122, 
         7159, 5123, 7900, 7901, 6893, 6894, 6895, 6062, 6063, 5742, 6065, 
         6064, 5362, 6860, 5735, 6859, 5736, 6861, 5703, 7988, 5704, 6958, 
         6959, 5748, 5747, 6155, 5698, 6137, 6136, 5046, 6151, 7932, 7933, 
         7931, 5650, 5949, 5948, 6545, 6519, 6520, 6275, 6274, 6273, 5205, 
         7614, 7615, 7613, 5424, 4880, 5783, 5726, 6074, 6073, 5365, 7579, 
         7580, 7576, 7578, 7577, 7610, 5423, 7609, 7612, 7611, 5136, 7165, 
         5135, 7166, 7274, 7273, 4951, 7215, 7216, 7047, 7046, 7045, 5204, 
         7782, 7783, 7781, 5513, 7567, 7568, 7566, 7570, 7569, 5413, 7776, 
         7777, 7773, 7775, 7774, 7963, 5670, 7962, 7965, 7964, 5199, 7030, 
         7031, 7032, 7381, 7380, 4942, 7373, 7374, 7029, 7028, 7027}],
        RowBox[{"-", "0.8`"}]],
       Annotation[#, -0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7068, 5225, 7912, 7913, 6940, 4848, 7665, 7666, 7664, 7668, 
         7667, 5465, 7672, 7673, 7669, 7671, 7670, 4849, 6941, 7915, 7914, 
         5216, 7058, 7059, 7060, 7286, 7285, 4977, 7222, 7223, 7169, 5154, 
         7168, 5155, 7916, 7917, 6942, 6943, 6944, 6093, 6094, 5743, 6096, 
         6095, 5376, 6863, 5737, 6862, 5738, 6864, 5719, 7989, 5720, 6970, 
         6971, 5762, 5761, 6156, 5699, 6139, 6138, 5047, 6152, 7944, 7945, 
         7943, 5659, 5951, 5950, 6546, 6524, 6525, 6290, 6289, 6288, 5231, 
         7717, 7718, 7716, 5474, 4893, 5790, 5727, 6105, 6104, 5380, 7697, 
         7698, 7694, 7696, 7695, 7713, 5473, 7712, 7715, 7714, 5168, 7174, 
         5167, 7175, 7299, 7298, 4993, 7239, 7240, 7088, 7087, 7086, 5230, 
         7817, 7818, 7816, 5525, 7675, 7676, 7674, 7678, 7677, 5466, 7809, 
         7810, 7806, 7808, 7807, 7967, 5671, 7966, 7969, 7968, 5226, 7071, 
         7072, 7073, 7396, 7395, 4986, 7388, 7389, 7070, 7069, 7068}],
        RowBox[{"-", "0.8`"}]],
       Annotation[#, -0.8, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->
   NCache[{{0, 2 Pi}, {0, 2 Pi}}, {{0, 6.283185307179586}, {
     0, 6.283185307179586}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 187},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->502362731]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->329307150],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Darker",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Darker"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["Blend",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Blend"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->10318589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Darker", "[", 
    RowBox[{"Blue", ",", 
     RowBox[{"1", "/", "2"}]}], "]"}], ",", 
   RowBox[{"Blend", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Blue", ",", "Black"}], "}"}], ",", 
     RowBox[{"1", "/", "2"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->188011437],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RGBColor", "[", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox["1", "2"]}], "]"}], ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox["1", "2"]}], "]"}]}], "}"}]], "Output",
 ImageSize->{265, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22941607]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Darker", "[", 
       RowBox[{"Blue", ",", 
        RowBox[{"1", "/", "2"}]}], "]"}], ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Blend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Black"}], "}"}], ",", 
        RowBox[{"1", "/", "2"}]}], "]"}], ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->50450238],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[0, 0, 
      NCache[
       Rational[1, 2], 0.5]], RectangleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[0, 0, 
      NCache[
       Rational[1, 2], 0.5]], RectangleBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->111995126]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5872900],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Darker",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Darker"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Lighter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Lighter"]], "InlineFormula"],
 " are not commutative:"
}], "ExampleText",
 CellID->81595963],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Lighter", "[", 
  RowBox[{
   RowBox[{"Darker", "[", 
    RowBox[{"Red", ",", ".5"}], "]"}], ",", ".5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->794083643],

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{"0.75`", ",", "0.5`", ",", "0.5`"}], "]"}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->246914727]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Darker", "[", 
  RowBox[{
   RowBox[{"Lighter", "[", 
    RowBox[{"Red", ",", ".5"}], "]"}], ",", ".5"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->90728669],

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{"0.5`", ",", "0.25`", ",", "0.25`"}], "]"}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->46409775]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->463593624],

Cell["Values outside of the 0, 1 range will be clipped: ", "ExampleText",
 CellID->256712554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Darker", "[", 
       RowBox[{"Red", ",", "i"}], "]"}], ",", 
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Opacity", "[", ".1", "]"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"5", "i"}], ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"0", "-", 
       RowBox[{"1", "/", "4"}]}], ",", 
      RowBox[{"1", "+", 
       RowBox[{"1", "/", "4"}]}], ",", 
      RowBox[{"1", "/", "4"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->978530505],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1, 0, 0], EdgeForm[Opacity[0.1]], 
    DiskBox[NCache[{Rational[-5, 4], 0}, {-1.25, 0}]]}, 
   {RGBColor[1, 0, 0], EdgeForm[Opacity[0.1]], DiskBox[{0, 0}]}, 
   {RGBColor[
     NCache[
      Rational[3, 4], 0.75], 0, 0], EdgeForm[Opacity[0.1]], 
    DiskBox[NCache[{Rational[5, 4], 0}, {1.25, 0}]]}, 
   {RGBColor[
     NCache[
      Rational[1, 2], 0.5], 0, 0], EdgeForm[Opacity[0.1]], 
    DiskBox[NCache[{Rational[5, 2], 0}, {2.5, 0}]]}, 
   {RGBColor[
     NCache[
      Rational[1, 4], 0.25], 0, 0], EdgeForm[Opacity[0.1]], 
    DiskBox[NCache[{Rational[15, 4], 0}, {3.75, 0}]]}, 
   {RGBColor[0, 0, 0], EdgeForm[Opacity[0.1]], DiskBox[{5, 0}]}, 
   {RGBColor[0, 0, 0], EdgeForm[Opacity[0.1]], 
    DiskBox[NCache[{Rational[25, 4], 0}, {6.25, 0}]]}}]], "Output",
 ImageSize->{184, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->478442467]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->177509288],

Cell["Some colors may look greenish during the darkening:", "ExampleText",
 CellID->151396416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Darker", "[", 
       RowBox[{"Yellow", ",", "i"}], "]"}], ",", 
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Opacity", "[", ".1", "]"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"7", "i"}], ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "1", ",", 
      RowBox[{"1", "/", "6"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35481783],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1, 1, 0], EdgeForm[Opacity[0.1]], DiskBox[{0, 0}]}, 
   {RGBColor[
     NCache[
      Rational[5, 6], 0.8333333333333334], 
     NCache[
      Rational[5, 6], 0.8333333333333334], 0], EdgeForm[Opacity[0.1]], 
    DiskBox[NCache[{Rational[7, 6], 0}, {1.1666666666666667`, 0}]]}, 
   {RGBColor[
     NCache[
      Rational[2, 3], 0.6666666666666666], 
     NCache[
      Rational[2, 3], 0.6666666666666666], 0], EdgeForm[Opacity[0.1]], 
    DiskBox[NCache[{Rational[7, 3], 0}, {2.3333333333333335`, 0}]]}, 
   {RGBColor[
     NCache[
      Rational[1, 2], 0.5], 
     NCache[
      Rational[1, 2], 0.5], 0], EdgeForm[Opacity[0.1]], 
    DiskBox[NCache[{Rational[7, 2], 0}, {3.5, 0}]]}, 
   {RGBColor[
     NCache[
      Rational[1, 3], 0.3333333333333333], 
     NCache[
      Rational[1, 3], 0.3333333333333333], 0], EdgeForm[Opacity[0.1]], 
    DiskBox[NCache[{Rational[14, 3], 0}, {4.666666666666667, 0}]]}, 
   {RGBColor[
     NCache[
      Rational[1, 6], 0.16666666666666666`], 
     NCache[
      Rational[1, 6], 0.16666666666666666`], 0], EdgeForm[Opacity[0.1]], 
    DiskBox[NCache[{Rational[35, 6], 0}, {5.833333333333333, 0}]]}, 
   {RGBColor[0, 0, 0], EdgeForm[Opacity[0.1]], DiskBox[{7, 0}]}}]], "Output",
 ImageSize->{184, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->51506190]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5278388],

Cell["Tilted bumpy texture:", "ExampleText",
 CellID->661871211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{
          RowBox[{"RandomReal", "[", 
           RowBox[{"7", ",", "2"}], "]"}], ".", 
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", 
        RowBox[{"{", "10", "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10", ",", ".05"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "10", ",", ".05"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Darker", "[", 
       RowBox[{"Orange", ",", "#"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->439682672],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22146288]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->488],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Blend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GrayLevel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GrayLevel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorSlider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorSlider"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30682]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->336591028],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->50282284],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->51399424],

Cell[TextData[ButtonBox["New in 6.0: Graphics Primitives & Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]], "MoreAbout",
 CellID->384500459],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->184354127]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Darker - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 24.6145716}", "context" -> "System`", 
    "keywords" -> {
     "darkening colors", "blending colors", "dim colors", "dimming colors"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Darker[color] represents a darker version of the specified color. \
Darker[color, f] represents a version of the specified color darkened by a \
fraction f. ", "synonyms" -> {}, "title" -> "Darker", "type" -> "Symbol", 
    "uri" -> "ref/Darker"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8226, 271, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->34227263]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 360201, 6639}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2012, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2635, 72, 1571, 37, 70, "ObjectNameGrid"],
Cell[4209, 111, 951, 30, 70, "Usage",
 CellID->25316]
}, Open  ]],
Cell[CellGroupData[{
Cell[5197, 146, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5675, 163, 344, 13, 70, "Notes",
 CellID->26425],
Cell[6022, 178, 404, 16, 70, "Notes",
 CellID->9524],
Cell[6429, 196, 553, 21, 70, "Notes",
 CellID->39054001],
Cell[6985, 219, 468, 18, 70, "Notes",
 CellID->741047295],
Cell[7456, 239, 733, 27, 70, "Notes",
 CellID->142410365]
}, Closed]],
Cell[CellGroupData[{
Cell[8226, 271, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->34227263],
Cell[CellGroupData[{
Cell[8610, 285, 148, 5, 70, "ExampleSection",
 CellID->132935285],
Cell[8761, 292, 67, 1, 70, "ExampleText",
 CellID->25812152],
Cell[CellGroupData[{
Cell[8853, 297, 216, 7, 28, "Input",
 CellID->142188391],
Cell[9072, 306, 317, 11, 121, "Output",
 CellID->211416760]
}, Open  ]],
Cell[CellGroupData[{
Cell[9426, 322, 221, 7, 28, "Input",
 CellID->32734470],
Cell[9650, 331, 5204, 93, 129, 142, 5, "CachedBoxData", "BoxData", "Output",
 CellID->4817333]
}, Open  ]],
Cell[14869, 427, 125, 3, 70, "ExampleDelimiter",
 CellID->575699757],
Cell[14997, 432, 165, 4, 70, "ExampleText",
 CellID->116085846],
Cell[CellGroupData[{
Cell[15187, 440, 360, 12, 70, "Input",
 CellID->90164705],
Cell[15550, 454, 479, 15, 123, "Output",
 CellID->390719170]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16078, 475, 220, 7, 70, "ExampleSection",
 CellID->510489542],
Cell[16301, 484, 150, 3, 70, "ExampleText",
 CellID->142203686],
Cell[CellGroupData[{
Cell[16476, 491, 162, 5, 70, "Input",
 CellID->114867121],
Cell[16641, 498, 161, 5, 36, "Output",
 CellID->513069107]
}, Open  ]],
Cell[CellGroupData[{
Cell[16839, 508, 420, 14, 70, "Input",
 CellID->141740984],
Cell[17262, 524, 367, 12, 123, "Output",
 CellID->308298973]
}, Open  ]],
Cell[17644, 539, 124, 3, 70, "ExampleDelimiter",
 CellID->40379589],
Cell[17771, 544, 150, 3, 70, "ExampleText",
 CellID->221677888],
Cell[CellGroupData[{
Cell[17946, 551, 301, 10, 70, "Input",
 CellID->432762779],
Cell[18250, 563, 161, 5, 36, "Output",
 CellID->313567944]
}, Open  ]],
Cell[CellGroupData[{
Cell[18448, 573, 421, 14, 70, "Input",
 CellID->761992595],
Cell[18872, 589, 362, 12, 123, "Output",
 CellID->322526879]
}, Open  ]],
Cell[19249, 604, 125, 3, 70, "ExampleDelimiter",
 CellID->434565670],
Cell[19377, 609, 234, 8, 70, "ExampleText",
 CellID->147092355],
Cell[CellGroupData[{
Cell[19636, 621, 218, 7, 70, "Input",
 CellID->402795023],
Cell[19857, 630, 160, 5, 36, "Output",
 CellID->23652387]
}, Open  ]],
Cell[CellGroupData[{
Cell[20054, 640, 494, 16, 70, "Input",
 CellID->104240780],
Cell[20551, 658, 496, 18, 123, "Output",
 CellID->409621024]
}, Open  ]],
Cell[21062, 679, 124, 3, 70, "ExampleDelimiter",
 CellID->23973780],
Cell[21189, 684, 256, 8, 70, "ExampleText",
 CellID->530148910],
Cell[CellGroupData[{
Cell[21470, 696, 217, 7, 70, "Input",
 CellID->691224926],
Cell[21690, 705, 499, 16, 51, "Output",
 CellID->113417553]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22238, 727, 227, 7, 70, "ExampleSection",
 CellID->142737640],
Cell[22468, 736, 341, 13, 70, "ExampleText",
 CellID->229319239],
Cell[CellGroupData[{
Cell[22834, 753, 699, 22, 70, "Input",
 CellID->142543984],
Cell[23536, 777, 19118, 317, 70, "Output",
 Evaluatable->False,
 CellID->132864587]
}, Open  ]],
Cell[CellGroupData[{
Cell[42691, 1099, 548, 18, 70, "Input",
 CellID->37057173],
Cell[43242, 1119, 50112, 835, 204, 23168, 389, "CachedBoxData", "BoxData", \
"Output",
 CellID->19803942]
}, Open  ]],
Cell[93369, 1957, 125, 3, 70, "ExampleDelimiter",
 CellID->412805249],
Cell[93497, 1962, 358, 13, 70, "ExampleText",
 CellID->367264277],
Cell[CellGroupData[{
Cell[93880, 1979, 828, 25, 70, "Input",
 CellID->417549239],
Cell[94711, 2006, 191541, 3160, 70, "Output",
 CellID->502362731]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[286301, 5172, 237, 7, 70, "ExampleSection",
 CellID->329307150],
Cell[286541, 5181, 314, 12, 70, "ExampleText",
 CellID->10318589],
Cell[CellGroupData[{
Cell[286880, 5197, 347, 12, 70, "Input",
 CellID->188011437],
Cell[287230, 5211, 393, 13, 51, "Output",
 CellID->22941607]
}, Open  ]],
Cell[CellGroupData[{
Cell[287660, 5229, 614, 20, 70, "Input",
 CellID->50450238],
Cell[288277, 5251, 459, 16, 123, "Output",
 CellID->111995126]
}, Open  ]],
Cell[288751, 5270, 123, 3, 70, "ExampleDelimiter",
 CellID->5872900],
Cell[288877, 5275, 320, 12, 70, "ExampleText",
 CellID->81595963],
Cell[CellGroupData[{
Cell[289222, 5291, 189, 6, 70, "Input",
 CellID->794083643],
Cell[289414, 5299, 236, 7, 36, "Output",
 CellID->246914727]
}, Open  ]],
Cell[CellGroupData[{
Cell[289687, 5311, 188, 6, 70, "Input",
 CellID->90728669],
Cell[289878, 5319, 236, 7, 36, "Output",
 CellID->46409775]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[290163, 5332, 230, 7, 70, "ExampleSection",
 CellID->463593624],
Cell[290396, 5341, 93, 1, 70, "ExampleText",
 CellID->256712554],
Cell[CellGroupData[{
Cell[290514, 5346, 692, 22, 70, "Input",
 CellID->978530505],
Cell[291209, 5370, 940, 24, 65, "Output",
 CellID->478442467]
}, Open  ]],
Cell[292164, 5397, 125, 3, 70, "ExampleDelimiter",
 CellID->177509288],
Cell[292292, 5402, 94, 1, 70, "ExampleText",
 CellID->151396416],
Cell[CellGroupData[{
Cell[292411, 5407, 584, 18, 70, "Input",
 CellID->35481783],
Cell[292998, 5427, 1388, 38, 67, "Output",
 CellID->51506190]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[294435, 5471, 226, 7, 70, "ExampleSection",
 CellID->5278388],
Cell[294664, 5480, 64, 1, 70, "ExampleText",
 CellID->661871211],
Cell[CellGroupData[{
Cell[294753, 5485, 844, 26, 70, "Input",
 CellID->439682672],
Cell[295600, 5513, 61065, 1005, 70, "Output",
 Evaluatable->False,
 CellID->22146288]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[356726, 6525, 309, 9, 70, "SeeAlsoSection",
 CellID->488],
Cell[357038, 6536, 941, 35, 70, "SeeAlso",
 CellID->30682]
}, Open  ]],
Cell[CellGroupData[{
Cell[358016, 6576, 319, 9, 70, "MoreAboutSection",
 CellID->336591028],
Cell[358338, 6587, 123, 3, 70, "MoreAbout",
 CellID->50282284],
Cell[358464, 6592, 162, 3, 70, "MoreAbout",
 CellID->51399424],
Cell[358629, 6597, 197, 4, 70, "MoreAbout",
 CellID->384500459],
Cell[358829, 6603, 179, 3, 70, "MoreAbout",
 CellID->184354127]
}, Open  ]],
Cell[359023, 6609, 27, 0, 70, "History"],
Cell[359053, 6611, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

