(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27642,        909]
NotebookOptionsPosition[     22749,        746]
NotebookOutlinePosition[     24195,        786]
CellTagsIndexPosition[     24110,        781]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dotted" :> Documentation`HelpLookup["paclet:ref/Dotted"], 
          "DotDashed" :> Documentation`HelpLookup["paclet:ref/DotDashed"], 
          "Dashing" :> Documentation`HelpLookup["paclet:ref/Dashing"], 
          "AbsoluteDashing" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteDashing"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Dotted\"\>", 2->"\<\"DotDashed\"\>",
        3->"\<\"Dashing\"\>", 
       4->"\<\"AbsoluteDashing\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Directives" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsDirectives"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Graphics Directives\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Dashed", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Dashed",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Dashed"]], "InlineFormula"],
     " \[LineSeparator]is a graphics directive that specifies that lines \
which follow should be drawn dashed."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->33519971],

Cell["Dashed lines:", "ExampleText",
 CellID->568660478],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Dashed", ",", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->543815691],

Cell[BoxData[
 GraphicsBox[
  {Dashing[{Small, Small}], LineBox[{{0, 0}, {2, 1}}]}]], "Output",
 ImageSize->{104, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->5760678]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Dashed", ",", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->494817468],

Cell[BoxData[
 Graphics3DBox[
  {Dashing[{Small, Small}], Line3DBox[{{0, 0, 0}, {2, 1, 1}}]}]], "Output",
 ImageSize->{104, 81},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->7696343,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydV+9PE0EQ3fauFAoFCvLDxmolNiqKEBBRFEUiKDF88E9osAl8MBrk37/o
zezb3vJ27RVJyt3svH0zOzM7t3vWv74Y/OhfX573u5+v+r8uLs9/d09+XuVD
ScUY8z3/fVs1+fuf/E1/Z1mWVQeDwVL+NOYrJJPkL/lTBu+o5kv+P8lHEiDs
6DFGJ0RK7ASZvqjaI2inotpDMM2IlFqtBSyo/gCzZ0WqDfXgaClmH5jWCMxr
3+NkiDFVktWO2QXjSgm6qehtoNtjoTeB7pA2IVkjYjbgd3cs9Dq410ibkjyt
6MdA90hbI7mh6B48eTIWeg3c66SdIFmrwjwAeoO0dZInFd2BJ1tjodvg3o5p
ebZZAXo35ievQ3eFDL4p4bboBfj9roRbI2rmwP0+Fl/OreZfBj+OhW7Ak0+k
nSZZq0wjI4MnEb9FtP6mkE4jaxeRd0MynKWjxv7x7CQLe0vm9pblSIc9RbA5
B/vJ3Sc+31Kcwt7Mv/FBh6nB7kH+TF2vis8d0R3sPsppIO9lRa8NdnopO8tT
xP4CvvKe4QqIs3M/mUIEXP9hlvFYJQJSlTuZ1/NvzcIrknhVTdFj5mGF2SvK
xlnhummCre2xxaqbfY2z8+7sESv31vFYGdVCdppglc6SRvYEexNn5/rT77hX
WXXPSiyLbDVupUnyMuKupTdwf85G679ssGdy+pHKEDuzYF4iDHf2OPNcLAOe
v3dJzzUbZ52PxMjttiSITSdio5KLwh3n5yjKWl0/kyefQULG4MRIPcOPQR0Z
vUe4iZGsnA+fcQZx4HNYbSTjMrLuWPgMkpbO5r0n4ipWx/rbsdUR+Q7YgtXf
is1lgE8r1XKW4huZFec6iTXXpM8V8giNPbUV/YJ3OjMUGnfa2kM0tM/VfM/y
dxPOc7uP693xNG6uMGq7Ce+5I/snqLj1Rhbef+T1ABFMSxlcR+XOe0iRlPVV
o977ey/03jJ4toNsc2c4uWFJ4LzbjxCvJPCFa/hDVvSD0Xv9LTjtDcOtli3v
Zd4pLDip8Epewrq9bXJ2ubq3wG3vyXwm5eg+B1q7vWaxGsnB08y7DwZfLs55
L/N6cfDF5i//Q6AfKZq1PPs+PNEbnj03uWh7qDY4nymKv6H8JXO7flPRvHaO
4CI82FE0R5+z484xrxTdgr+xM5Og9hW1SFruCZOZd+uy37AbncF1ZL1naYUm
qHIZPdbRFUh6lzGm8hc0UjUa\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->255849672],

Cell["Dashed frame:", "ExampleText",
 CellID->273114951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", "Dashed"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->340435630],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWV0LgjAUPX6UESb01qP/JainfsSQQB+kNP//uptpSyUocSLcwXbvzu68
u/PgefAiqvSaiypLRHwuxT3Nkkd8upUEeQ6AgvrxAPIleboXUpKtR48Anzzf
knWhmnmCetyrUR1G6obdFHOYiPs6TWPXCvTb9UWsrsg6+kbNyrzPPeQEndtw
FxyxHqy54dams9+bGQ++njb60b6f1uEFOaFFRL8lzT6TjduJ57rm2b4X0cQZ
QznEFHtZbSlAY/u15i3K+sD68G8E6wP6vADrA+vDuKysD2B9MGpfagTrA/q8
AOsD68O4rKwPYH0wal9qBOsD+rwA6wPrw7isCpzrTwOcJ3ZUJkw=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{113, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->237801681]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["EdgeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeForm"]], "InlineFormula"],
 " to draw dashed edges:"
}], "ExampleText",
 CellID->386942407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Pink", ",", 
    RowBox[{"EdgeForm", "[", "Dashed", "]"}], ",", 
    RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->425061707],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], EdgeForm[Dashing[{Small, Small}]], 
   RectangleBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->439652843]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"EdgeForm", "[", "Dashed", "]"}], ",", 
     RowBox[{"Cuboid", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->913846666],

Cell[BoxData[
 Graphics3DBox[
  {EdgeForm[Dashing[{Small, Small}]], CuboidBox[{0, 0, 0}]},
  Boxed->False]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->446425458,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNmPtOE1EQxpdut0uv1C60RUqpXMQiKogIWEFjoiQiXh6hARNINJjK/z4L
PpLv0+jMnOl2+3E2WUESSTvtnvl+c9lLzzkcds9PPn/tnp8edVv7ve63k9Oj
7603Zz0acsccxzmm95e6Q99/0zd5H/f7fXJE7EuyLrnuyNEuWz48e/CDXk6K
DR/35c+ZE1WHbIoGPfLyZ0tGd3TUD5mL3pDZIpuPei566nmiXIG96aHXcZri
X9cKS6N+ehn/GtkK+7yoj747s+JfVT6A7Ck2kd5ui3pFq6mC2iXTEEWb7HSs
d0mzzZAiQ6MzMrqgUWeB88iYvPNkWxZvtMKaKJsaax7UnG1aFA1VLFoU0XhV
UUt+l6Vy2Z0loHwydVHWNG4bFONkTG2T2v39WEVAds3ijdYViLKs2dYTqYua
eQPUWVBXRF0guwXKHJlJ8ebI7oA3TyYIvdFn5OmVlQUypp4sKLG2AnQxEUuV
QVlKFL94JaoEVDGknoFygkx8zVEl158sO3aaF2ocqG2gbpEpJlZG4+cSURWg
sv+QwnuSqWHXz8EbkDE1+xAHr04A2f3/jpokk70BZbSSzDWp3dhKMhCzcy3l
5ew3Q02RGf9LpQdKvCenoBIvMTWsZC9x9o6uT+qk8K0Kfg750P35q19NVNvm
IDsRvMbI8Ceca3uux5orB0QQEmkg1pQoAYG/Fmkrvap0ADT+rtnpttJVCz2s
tq1nuEGqSmwfvFLhhVsTYvEveMZKzA3OslmWOAtA4sxj76GhPSxbaJPXBWJG
+1lJTNSUeAQEzqiulQ70zGwQjT3ZibLm24Z8+ZEKy9p5B1S52D7yGveFhTBP
QgoIX2t/lZgY7Bf2gciOEumQ0C4OSJ+Hs5MK9Sz/ABH9WPXg2WXgE1C4Pk6N
3lVKYa5MWL2XQJkO5wvM7oVengs+ktcfGYlGfg+sGyrzoDwEJe56xoQqAPUu
EcXrNKnk0s7L3LsTEPUAopqKyxYV92NiVMD7NhojvEa8bj+weqZGPNHqqxD5
NecNa6+Bd48M32lmppkGrzyN6eGsoGfU4d3fppLSp+zNouQqGX4mzO5oFrzL
ypp9XRO881qx2QfzLnxO9WY3z3vKuo7cDUdSOicwuSKjixCXZyi+pA/FuwRe
71KvG6Jb5tiabUtG7g1IPe87Mmr+7+CM/QG+bO/x\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->101466395],

Cell["A plot with dashed line:", "ExampleText",
 CellID->77058257],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Dashed"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->325230780],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->366814498]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dashed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashed"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dashing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dashing"], "[", 
   RowBox[{"{", 
    RowBox[{
     ButtonBox["Small",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Small"], ",", " ", 
     ButtonBox["Small",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Small"]}], "}"}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->588226320],

Cell[CellGroupData[{

Cell[BoxData["Dashed"], "Input",
 CellLabel->"In[1]:=",
 CellID->47575566],

Cell[BoxData[
 RowBox[{"Dashing", "[", 
  RowBox[{"{", 
   RowBox[{"Small", ",", "Small"}], "}"}], "]"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->227090635]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->221003472],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashing"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["AbsoluteDashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteDashing"]], "InlineFormula"],
 " provide richer specification of dashing: "
}], "ExampleText",
 CellID->3146420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Dashing", "[", 
       RowBox[{"{", 
        RowBox[{"r", ",", 
         RowBox[{"0.1", "-", "r"}]}], "}"}], "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.03", ",", "0.05", ",", "0.08"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->487066461],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Dashing[{0.01, 0.09000000000000001}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[{0.03, 0.07}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[{0.05, 0.05}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[{0.08, 0.020000000000000004`}], LineBox[{{0, 0}, {2, 1}}]}]}], 
  "}"}]], "Output",
 ImageSize->{452, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->154933809]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"AbsoluteDashing", "[", 
       RowBox[{"{", 
        RowBox[{"d", ",", 
         RowBox[{"15", "-", "d"}]}], "}"}], "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5", ",", "8", ",", "12"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->302616010],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {AbsoluteDashing[{2, 13}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {AbsoluteDashing[{5, 10}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {AbsoluteDashing[{8, 7}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {AbsoluteDashing[{12, 3}], LineBox[{{0, 0}, {2, 1}}]}]}], "}"}]], "Output",\

 ImageSize->{452, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->109723155]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->72811268],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dashed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashed"]], "InlineFormula"],
 " is absolute dashing, independent of the image size:"
}], "ExampleText",
 CellID->72097842],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Dashed", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "70", ",", "100"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->540741371],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Dashing[{Small, Small}], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->50], ",", 
   GraphicsBox[
    {Dashing[{Small, Small}], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->70], ",", 
   GraphicsBox[
    {Dashing[{Small, Small}], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->100]}], "}"}]], "Output",
 ImageSize->{261, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->47489957]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dotted",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dotted"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DotDashed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DotDashed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dashing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dashing"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteDashing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteDashing"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Dashed",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Dashed"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->29612531],

Cell[TextData[ButtonBox["Graphics Directives",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsDirectives"]], "MoreAbout",
 CellID->130895204]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Dashed - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 26.7708768}", "context" -> "System`", 
    "keywords" -> {
     "dashed", "dashed lines", "dashed edges", "dashed 3D lines", 
      "dashed 2D lines", "dashed grid lines", "dashed frame", "dashed mesh", 
      "dashed contour", "dashed curve", "dashed arrow", "dashed grid", 
      "dashed gridlines"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Dashed is a graphics directive that specifies that lines which follow \
should be drawn dashed.", "synonyms" -> {}, "title" -> "Dashed", "type" -> 
    "Symbol", "uri" -> "ref/Dashed"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4177, 120, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23975, 774}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1471, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2094, 62, 1571, 37, 70, "ObjectNameGrid"],
Cell[3668, 101, 472, 14, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4177, 120, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4554, 134, 147, 5, 70, "ExampleSection",
 CellID->33519971],
Cell[4704, 141, 56, 1, 70, "ExampleText",
 CellID->568660478],
Cell[CellGroupData[{
Cell[4785, 146, 359, 13, 28, "Input",
 CellID->543815691],
Cell[5147, 161, 276, 8, 73, "Output",
 CellID->5760678]
}, Open  ]],
Cell[CellGroupData[{
Cell[5460, 174, 381, 13, 28, "Input",
 CellID->494817468],
Cell[5844, 189, 1591, 31, 102, 105, 2, "CachedBoxData", "BoxData", "Output",
 CellID->7696343]
}, Open  ]],
Cell[7450, 223, 125, 3, 70, "ExampleDelimiter",
 CellID->255849672],
Cell[7578, 228, 56, 1, 70, "ExampleText",
 CellID->273114951],
Cell[CellGroupData[{
Cell[7659, 233, 333, 10, 28, "Input",
 CellID->340435630],
Cell[7995, 245, 569, 13, 88, "Output",
 Evaluatable->False,
 CellID->237801681]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8613, 264, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[8837, 273, 208, 8, 70, "ExampleText",
 CellID->386942407],
Cell[CellGroupData[{
Cell[9070, 285, 239, 7, 70, "Input",
 CellID->425061707],
Cell[9312, 294, 311, 9, 121, "Output",
 CellID->439652843]
}, Open  ]],
Cell[CellGroupData[{
Cell[9660, 308, 290, 9, 70, "Input",
 CellID->913846666],
Cell[9953, 319, 1562, 31, 129, 118, 3, "CachedBoxData", "BoxData", "Output",
 CellID->446425458]
}, Open  ]],
Cell[11530, 353, 125, 3, 70, "ExampleDelimiter",
 CellID->101466395],
Cell[11658, 358, 66, 1, 70, "ExampleText",
 CellID->77058257],
Cell[CellGroupData[{
Cell[11749, 363, 288, 9, 70, "Input",
 CellID->325230780],
Cell[12040, 374, 2282, 41, 70, "Output",
 Evaluatable->False,
 CellID->366814498]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14371, 421, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[14612, 430, 567, 21, 70, "ExampleText",
 CellID->588226320],
Cell[CellGroupData[{
Cell[15204, 455, 74, 2, 70, "Input",
 CellID->47575566],
Cell[15281, 459, 247, 8, 36, "Output",
 CellID->227090635]
}, Open  ]],
Cell[15543, 470, 125, 3, 70, "ExampleDelimiter",
 CellID->221003472],
Cell[15671, 475, 358, 12, 70, "ExampleText",
 CellID->3146420],
Cell[CellGroupData[{
Cell[16054, 491, 695, 24, 70, "Input",
 CellID->487066461],
Cell[16752, 517, 587, 17, 75, "Output",
 CellID->154933809]
}, Open  ]],
Cell[CellGroupData[{
Cell[17376, 539, 689, 24, 70, "Input",
 CellID->302616010],
Cell[18068, 565, 565, 17, 75, "Output",
 CellID->109723155]
}, Open  ]],
Cell[18648, 585, 124, 3, 70, "ExampleDelimiter",
 CellID->72811268],
Cell[18775, 590, 224, 7, 70, "ExampleText",
 CellID->72097842],
Cell[CellGroupData[{
Cell[19024, 601, 622, 21, 70, "Input",
 CellID->540741371],
Cell[19649, 624, 484, 16, 75, "Output",
 CellID->47489957]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20194, 647, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[20513, 658, 955, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[21505, 698, 305, 8, 70, "RelatedLinksSection"],
Cell[21813, 708, 357, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22207, 725, 318, 9, 70, "MoreAboutSection",
 CellID->29612531],
Cell[22528, 736, 149, 3, 70, "MoreAbout",
 CellID->130895204]
}, Open  ]],
Cell[22692, 742, 27, 0, 70, "History"],
Cell[22722, 744, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

