(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31082,        838]
NotebookOptionsPosition[     27410,        710]
NotebookOutlinePosition[     28692,        747]
CellTagsIndexPosition[     28607,        742]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reverse" :> Documentation`HelpLookup["paclet:ref/Reverse"], 
          "Transpose" :> Documentation`HelpLookup["paclet:ref/Transpose"], 
          "DataRange" :> Documentation`HelpLookup["paclet:ref/DataRange"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Reverse\"\>", 
       2->"\<\"Transpose\"\>", 3->"\<\"DataRange\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["DataReversed", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["DataReversed",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DataReversed"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["ArrayPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
     " and related functions which specifies whether data should be plotted \
in reverse order."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1244]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"DataReversed", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " specifies that the order of rows should be reversed, effectively turning \
the plot upside down."
}], "Notes",
 CellID->2549],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"DataReversed", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["row", "TI"], ",", 
     StyleBox["col", "TI"]}], "}"}]}]], "InlineFormula"],
 " specifies whether each row and each column should be reversed."
}], "Notes",
 CellID->292615158]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->60406266],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->143898385],

Cell["Reverse the order of rows, turning the image upside down:", \
"ExampleText",
 CellID->5532],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{"30", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "10"}], "]"}], ",", 
   RowBox[{"DataReversed", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25283],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAHiJAkGIPs/kAXG
ICEgYAaxwYBhA5BgpIFoEJDgBHJDR4isF5CQBHJ9R4isE5AQAHIFgTQHkHYd
VYVXlRVUFQeQVgTStqOq8KoygqoS+A/JdRLQ0DUdVU0T1VposQKiJYC07qjq
QaBaEUgIQuMSFIeKUBoWtyqjugaVLkmoLlCsKjBA6gZDIC0zqpomqkGyyHUw
qKwDtV00oXyRUV2DShfnf8zSDzmXgWIfVBryjOoeurpZ4Lr/o7ZEFKB6QGYq
YDGLZdSMkWAGxeMN0NEMRgCb2uYW\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->235690]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21880],

Cell["The frame ticks give the original row numbers:", "ExampleText",
 CellID->8835],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{"30", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "10"}], "]"}], ",", 
   RowBox[{"FrameTicks", "->", "Automatic"}], ",", 
   RowBox[{"DataReversed", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24987],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWVFr2zAQVqw4TgbtGCRru3RtWdlDoXQrg8EeNvYw1qf9iFAG7cNY6fpL
9tBf0v+n3Vkny7pIshyHNjAHovPJd59O0neSbP9Y3F39/LW4u75cHF3cLm6u
ri//HH3/fQtVciCEeID/za6AawVX5f9BKZCh8h2UGZjtg8xBZqTvefQhSEn6
q9L7DEusVuUPLl6jyKsaXVmiCGntdpOsXjJdLrW2V4pzZjdPj6GmD5m+w/Qs
0LoZwYOVWjXjmxbzTtVivbbFmPP+8PtO/2I9lsQZjH2oLCeMLsma3w8z8TmU
90JLKmvRHXbUnzF96wlb+Ztk9Q2KAtSL3npF689QzED96rUulF7ReN47Xpb9
ZD2ufOs+udKMN75fSJfMblJ6j1ltNIJIxupYJqyWtxlC43aF7ZmT89HoGled
UdVjXAHyFj1F+4l3Xj9CsQ3qttJs+OSd395r/V7vodgSmiVzkB+8XjhrPvY3
eUvy00zka2lGdznKOdWPmL1mHlrlqbE42Z5XkTTnhBetRW6YWpGKHVgVRLVC
4RxkHrQTQjPzPiV56pmLrELjPEhF8bOo917F+43SGYus2Sc+TEG+9XrjXelZ
caMoDv9ltf428z+KmpgH/lbQLIR+rGrrjONpd+l1jUHTnp06O/49fExtdUGV
wWydEwoyA/mG5/ZRjYcHzN7Pvx5l81GmhGL2CvQ+AcmfZbV36FSWiuKe0sL5
G8Kbqeb8ja870Ug7nk3XOQqbHTNnEXrxfWpG6zBy8gWz93OxR9k8FJ1q+ieF
fbvHeVQo98xZKPu0MKLMxX2oPKMvnZoNqm6sLBt5zfVWEfCnWm9r+Hp0gLJl
VOaJJCUas4/na49iM8fmMaMyrDJvEztx1rMWGlzN2qV8E3ZvnpPkLZn7/Fkz
kME94n+DeNhRf+q31/a9fPxrUv9NydX7b0q8f4/1TUkM/gHGQXri\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137544634]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25589],

Cell[TextData[{
 "Reverse in ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " but not ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->54112546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{"30", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "10"}], "]"}], ",", 
   RowBox[{"DataReversed", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->182265043],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAHiJAkGIPs/kAXG
ICEgYAaxwYBhA5BgpJYoC1wUCDiAHAEgLQikOYC0ApDmhIorAGlOqLwASOOo
GSPBDKRUA1ItAeRKYjFNEUqDdPOM6h4WugWhujSBtCSQloDyBaG6REZ1DSpd
oFg2hKpSgMYuKLZlRlXTRLXif0SpCYodxf+ouUxlVNeg0qX1H1Iaopd+uqOq
B4FqI2gcSvxHbYuYjqqmiWortFixHVWFV5XTf9Q62HVUFV5VXv8hbRffESIb
9B+S60JHiCx54w3Q0QxGAEIF5hY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->572716400]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32189],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"DataReversed", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 " gives the same orientation as ",
 Cell[BoxData[
  ButtonBox["ListDensityPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListDensityPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->13163],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListDensityPlot", "[", 
  RowBox[{"CellularAutomaton", "[", 
   RowBox[{"30", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "10"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30444],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxd1z2KHDEQBtDB0YYTTNBBB23RCCGE0G9sn8FHMDj2sZ36CF5jMOwbGD5e
WlSpqj9///ntx6fH4/Hr/f83//1+f/mYj68f/Yaf+IUPfOILB3zjiBPOuOCK
G+544IkX3tg6mm/4iV/4wCe+cMA3jjjhjAuuuOGOB5544Y3tQ+toPvELH/jE
Fw74xhEnnHHBFTfc8cATL7yxc2wfWkfzhQ984gsHfOOIE8644Iob7njgiRfe
2HfQObYPraN54BNfOOAbR5xwxgVX3HDHA0+88MbuEd9B59g+tI7miS8c8I0j
TjjjgituuOOBJ154Y/ewe8R30Dm2D62jeeGAbxxxwhkXXHHDHQ888cIbe8e4
h90jvoPOsX1oHc2AbxxxwhkXXHHDHQ888cIbewd6x7iH3SO+g86xfWgdzRtH
nHDGBVfccMcDT7zwxt7R3oHeMe5h94jvoHNsHwZsRpxwxgVX3HDHA0+88MZ+
h3hHewd6x7iH3SO+g85xwNbRTDjjgituuOOBJ154//cfjpTF3g==
   "], {{
     {GrayLevel[0.8], EdgeForm[None], 
      GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwBwQQ++yFib1JiAgAAAJABAAADAAAAGAIDHAYHGQMEFwECGwUGLRcYGgQF
HQcIHggJHwkKIAoLIQsMIgwNJA4PKBITIw0OJhARJxESKRMULBYXMBobKhQV
LxkaJQ8QLhgZMhwdNiAhMx0eMRscNR8gRzEyNB4fNyEiOCIjOSMkOiQlOyUm
PCYnPigpQy0uPScoQSssQiwtRC4vRjAxSjQ1RS8wSTM0PykqSDIzTDY3UDo7
TTc4SzU2Tzk6YUtMTjg5UTs8Ujw9Uz0+VD4/VkBBV0FCWUNEXUdIWEJDW0VG
XEZHXkhJYEpLZE5PX0lKY01OWkRFYkxNZlBRa1VWZ1FSZU9QaVNUe2VmaFJT
bFZXbVdYblhZb1lacFpbcVtcc11ed2FiclxddV9gdmBheGJjemRlfmhpeWNk
fWdodF5ffGZngWtshW9wgmxtgGprhG5vloCBg21uhnBxh3FyiHJziXN0inR1
i3V2jXd4kXt8jHZ3j3l6kHp7knx9lX+AmYOEk31+mIKDjnh5l4GCm4WGn4mK
nIaHmoSFnoiJsJqbnYeIoIqLoYuMooyNo42OpI6PpY+Qp5GSrJaXppCRqpSV
q5WWrZeYr5mas52erpiZspydqJKTsZuctZ+guaOktqChtJ6fuKKjyrS1t6Gi
uqSlu6WmvKanvaeov6mqwKqrwqytxrCxwausxK6vxa+wx7GyybO0zbe4yLKz
zLa3w62uy7W2z7m61L6/0Lq7zri50ry95M7P0bu81b/A1sDB18HC2MLD2cPE
2sTF3MbH4MrL28XG3sjJ38nK4cvM483O59HS4szN5tDR3cfI5c/QAhgXBhwb
AxkYARcWBRsaFy0sBBoZBx0cCB4dCR8eCiAfCyEgDCIhDiQjEignDSMiECYl
EScmEykoFiwrGjAvFCopGS8uDyUkGC4tHDIxIDY1HTMyGzEwHzU0MUdGHjQz
ITc2Ijg3Izk4JDo5JTs6Jjw7KD49LUNCJz08K0FALEJBLkRDMEZFNEpJL0VE
M0lIKT8+MkhHNkxLOlBPN01MNUtKOU9OS2FgOE5NO1FQPFJRPVNSPlRTQFZV
QVdWQ1lYR11cQlhXRVtaRlxbSF5dSmBfTmRjSV9eTWNiRFpZTGJhUGZlVWtq
UWdmT2VkU2loZXt6UmhnVmxrV21sWG5tWW9uWnBvW3FwXXNyYXd2XHJxX3V0
YHZ1Ynh3ZHp5aH59Y3l4Z318XnRzZnx7a4GAb4WEbIKBaoB/boSDgJaVbYOC
cIaFcYeGcoiHc4mIdIqJdYuKd42Me5GQdoyLeY+OepCPfJKRf5WUg5mYfZOS
gpiXeI6NgZeWhZuaiZ+ehpybhJqZiJ6dmrCvh52ciqCfi6GgjKKhjaOijqSj
j6WkkaemlqyrkKallKqplauql62sma+unbOymK6tnLKxkqinm7Gwn7W0o7m4
oLa1nrSzori3tMrJobe2pLq5pbu6pry7p728qb++qsC/rMLBsMbFq8HArsTD
r8XEscfGs8nIt83MssjHtszLrcPCtcvKuc/OvtTTutDPuM7NvNLRzuTju9HQ
v9XUwNbVwdfWwtjXw9nYxNrZxtzbyuDfxdvayN7dyd/ey+HgzePi0efmzOLh
0Oblx93cz+XkWGAiGw==
        "]]]}, {}, {}}, {}},
   VertexColors->CompressedData["
1:eJxTTMoPSmVkYGB4zkAr8MGeZkZTBcDch04PFkDIXQPtXlzuwxWu9HYvpeFH
a/dSGn60Dl9qpT9apV9qpT9C6skNX2qlP0rtJ9Z8QvYSUkep/dQ2H5c66vkP
AAivWPk=
    "]],
  AspectRatio->1,
  Frame->True,
  FrameTicks->True,
  PlotRange->{{1., 21.}, {1., 11.}},
  PlotRangeClipping->True]], "Output",
 ImageSize->{184, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18621,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy1XQu8VFXVX9yZObP3vXfuPedy4TIqAl4ERXnIyyeIKCiapSW9xIrU8oUQ
mFZQWvRQsIdWZliYlqZYCoWKJKVlKWFqaQmlWZFiDzXNih78vm+tteee2XP2
Xnvm/L6v8/t5EGbW3v//f61zzj57r7Xn5IUXnXP2ooUXnXvmwpHHL1245Jxz
z1w2cu7ipfhPhUEAsBH/u2sY4P//D/4f/7dxz549+IF1PgjPBfxo/9qfbfhn
G/7ZX/s7FPlrtWMU/qVofavMH06gM315Dx9sC8X638337W+Myvy9kPn7CDqV
zN/Ts9NK8b/U+8imLfy3erY/lxkfXFN/TGv91b9Rsxvdci/2v+7fWm8luzdq
fT/6M7LtQpqOtzDSn4U99Xhsq4VjWy0S7c9NJLrx7Z4reL4ZLQalf5tNMAuD
Bg0awgeU6NSD/zZs2LBDDz30jW9840UXXfTZz372W9/61mOPPfbSSy+hze9/
//sf/vCHN9988+WXX37uueeeeOKJBx98cKVSOdHf8siRI0ePHg1lOsVSm3/9
61+feOKJu+666wtf+ML73ve+t771rUceeeQ+++wjtzllyhQo88nbptFYSVjn
ie0effTRoI499liI3EZNmxLWJm2+/vWv97VZCOI8wW2zmLb5tre9Tb3zne+E
UpZ7YQDnz3/+c4Pz/e9/f4qzaZvvec973DaLFs6vf/3rBudJJ51kcB7vtlmy
2/zgBz8I6rLLLoOi3WhRxjl8+PCW2vzMZz7T2GYpiHOu22aUafNLX/qSuv76
66FQ514K4myxzdtvv91uMxrA+aMf/cjFOcdts+y2+Z3vfAfUd7/7XSikF1IN
66uvvmqwXnvttQbrUUcdhVjr7dL3irW7SrD9n/zkJ3b7Lu7zzjvP4O7q6jou
bT/K3GnTfpS3n1/+8pfq6aefhoLppjmTek/lzN200LynP//5z3ZPYU7Hpj2p
TE9tAz1pqad//vOfoP7973+rIJdwD0fwnaSjo6OTD4jopKTu4hdffBH03//+
d4kOzG6IgcbnWtHub28+IKKTlvr73e9+B93PPPMM6F27dkkErT6j2lOrZPc0
bty4gw46CMp0UlI33Y8++ii0P/nkkwFyxzRcN3b7RxxxBJTppKX2f/CDH0DX
fffdB+0PPfTQc889J5GR+zjhhBNAzZs3D5TUQdeGDRugY9OmTQEaePnDrHAf
b3nLW0BLfXzta1+Dyg033AAdt956a5iKr59i2s+73/1udc4554CSuqlcffXV
0LlmzZqU0LPPPusldHSzfi655BLQUj8f//jHoXPlypXQuWrVqgAp83zz9FWy
+6LW1Cc+8QlQUmedy5Ytg8ry5ctboQYzW+nvmmuuAS31h1+CjrPOOgsqF1xw
QSsUfX1GmT6xaXXTTTeBkrrsmD9/PnQtWLAgQNQei8xorc8777wTtNQnRW/7
nDlzoOvkk0/2kr377rszZD39lt1+6epVDzzwACip4/bp06dD98yZM1uhjHci
us0e1Xrfjz/+OGipbzQAPXbsWOieMGGCRN0dUvr6V97+sUu1c+dOUFL3uq+v
D+IRI0bkEuDIPP2/8soroKX+0QoUHhDj0YoIeI/D2zWK0IhhMkFoa2sDLeHg
Z+7u3btBYaPYNHaA3WBn2CV2jN2zfVIqlfCdBIf6CxcuxKEpjvm2bNny1FNP
4eM6M3ysx8MRDhbd09MDSgKinn/+eVAoMMp8zz33oOQoPMqPTkBXsG0sgfDq
gc9iFwMU8LVtFB8Q0UlLeDA+obxjxw4ei+AD28izevVqI8/EiRM12ScSJvv1
D2+hDdoc7sd1CB9QppOSQJV//OMf8wgsI9UZZ5yBUrWTbSwBknQS8OA746xZ
s6BMJy3hoZFvtHnzZlDYtFeqdm7Eiyn77olC4WM0FeowEdfrXvc6UHySQEW3
3XYbKLxUvVJ1kG3kAkrfW73Xl4yHXlnV29/+dtASHnyiQem6664Dhe16peog
ew+mQlCjQ4OY9IUXXghKAlS68sorQeHFiy0bmbZv325kWrFiRSfZlrIeS9+Y
7Tf7VCEPmmKKBt+WFb+Kinj4U2zSSISdGInWrVuHEnXSpw6eYlCd6U3w6E9+
8pOgvGCwt+KiRYtA4Z3NK1GFbIs2mKKlDT7cM9p4sJRsLJ/+9Kd5oBXAgwNZ
UPjE90pUIdsGPCVHG/s2NK0FPPob3/gGKC8YxFJ47WtfCwrb9ErURbaFuqdK
gjrmAe5BE2XQ3H777YpftEU8PH2EYwJs2EiEXaUSdZGthSeS1cEx3NTgW7OE
T/Pd2QsOsbVNmjQJFHZhJMNOjWT/+Mc/ULJusi2kN+smerWAr+zioykKGvYF
MOLrKyjswytjN9laGMMaTvHOoYSw6T/84Q+QeIEhriRJcIDt1Q9isiwYWM3V
a0Rmz76UBhAqL8I//elPNHCD2Atw0KBBNAzziReTlYUvo1zmDWKydxZgHMHS
WgewvfzyyzI2aaq6SlbibK2MRWODoLxAsFUKMUjyYkFbGEaWGr0qyQOHBKN/
HD8FEfoBfEBEJxGn/tnPfgZxXpDDyIpmciTZLIwVG9OhfPBkPE91u4CwD7rF
QZIXE11BfWTZjreTgHyT/MgQ99y5c6FMJxGZ3rhxI8R5YfWRVfvWrVsDgsmo
sFVQfPJCwr7okQlJXlQ00TyULDvwcSVJZm5lMFFEhwRAnX322TI6/fnPfx7i
vNCGklUHPtjDsjVBprF5UF5Y2CsNxSDJi4xGBkN4qgkHtE2lm+DiK6b4cDCj
PvrRj8oI9cUXXwxxXnhDyKoTB41N5WuGTmMXoLzQsH96/YAkLzpaNuolywoO
s1uREMa7KEs2ymuvvRbUjTfeKCPVb37zmyHOC7OXrCo4DA5ImT5UW0KpsSte
KnEhIhp67YUkL0p60xlMll34ateipAe7WKMM1rvvvlvdf//9Mlp9+OGHQ5wX
6mCy6sKhc4uytoZUY3egvDARF027QJIXKS0a95BlN3qkdWnhIBdx2UX8i1/8
AtRvfvMbGbXea6+9IM4LuYesuidOnNi6xDkQt9OSZNnFykMhmrpL8uKlRIKE
LGOzchQQOjO+HueiVl7Uf/vb32htDRQO9HDcgg9jfLbgLRKvbgxG1EuTbSzB
fuGFFx555JH169dfddVVS5cuPe2006ZNmzZ06NCErQYPHnzIIYeccsopixcv
xldifOvbtm0bjsYlsRtRj+LnVblc7uYDIjrJLGh4KM/ckm0SSMj49a9//b3v
fe+GG274yEc+cuaZZ86ZM2fMmDHYNyiSjq0lNnt86Ry1eD/Qz2hfPoD+HHij
ytB59tlny/gyBQo78LqmnWzFXBD0y6OPPmr8smzZMuOXvr4+xQjQrTUEEbci
0ZKejAIrVGzChAlQppPM6uGHH+YXzd27d3vWF7iBUDaK5KjyALMJfEDELXmZ
NclrOUBkN2PGDFB88lJ78MEHoy1btoDC13Xjtscff9y47ZJLLkG3dZCtmBMj
+Sxlhl6nBsrciksrnFkjszruuONAveY1rwmwouFwbQ0sddtNN91UWwMjWzEr
R/JXZLGiBsrcissqnNszNshKL1iwgGfFXEq33HJLae3ataCwI6+7OslWyAp6
8cUXvZ6yOdHwSHEb2ehzM4tsP3kYFVNGKKA6//zzA5wGpgq9zuokWyErCf10
3333GT+dddZZxk9KqVKWE7eR5eTNbEq9NKYJJ718+XJQXkJXXHFF8dJLLwVl
unNdRUvMvoyo1EdXX3218dH06dPRR8ynmPJBTytuwaYTzqnysCnZbFBAUKtW
rQowWrJkiZURsGPHDuOoBx54AB1VIVtPPpbkoaLLiFuwGYUzuvZvgZH+4he/
CMpLByOisHDhQlAXXnghdnrbbbcZN73yyivGTV1k6+SCSR5iPiWbDy38K26j
HnHhfDIPoyjD6Ctf+Yq69dZbA5xOPfVUXrrxOqqLbJ1cNMlHBT8nbqPOKQp6
aXRLnPSmTZtAeQnhHbZt9uzZvDzmdVU32Tp5cMZPGzZsyPiJOUUZTnfeeafi
VtJBRDYHLeOpOit7DpHZlV12+CgB9dBDDwUYTp48GdSsWbO8jusmWycT75ln
njFeW7lypfHa2LFj0WttEkNupc4wkPuGfutvnFF2csVCXPWTTz4JiZfo+PHj
+/v7J02aZLx55ZVX2t6EmCydTMCML+fPn298yUzLLlMcSoDilgxVjz8z6VAt
sVVetnjxULqBzLe3t3fUqFHo2zRta/Pmzca3EJNlNh8xljyLGLxkuX+Lazir
cb//E1dKMITYSxTfN3p6elzfPv/88wlacYZjIvlS4ob3Sk6jCOdRNnIq1K7H
KhGJogi0xGagUUgkRqFckypZxnhN480Yb/Qf+MAHTj/9dBzn0uuJTCcmq2Ce
5qiGu0u2XqDKY5skSWqZ+7RsB0qip5EYxHmpVckqycts165d0E2WwYzQOrvy
nnp9Q8pqfz4gopOWWOGZEzQgycuMFvyqZBnnpdZNVk2yUEc2PO1SThMnTpw6
dSqU6aQkQhpbhDgvmSpZJXm5bN26FbrIkjJeA86S+VChBCXBgJb48FMPgUGS
lxMtbFfJMs5LqousaPWjSZbtCJEXpwC84Q1vACWR0tgexHkJVckqyctn3bp1
UCHLWkZv6LpqwonqRbTECf+FB/6Q5OVFSRpVsozzEquQFeUQN3XXvi6zYsps
0aJFXLeiJGIaKUGcl1SVrJK8nFavXg2dZElrNQGXmbfmprw+/OEPg5Z40Yf0
Sg1JXm6UeFQlyzgvuU6yquVHN7/Khrv8SjY/UovreJREUGN7EOclVyWrJC83
So7qIEvKxW7FfS3x03xpecnhFUmTV5Dk5UdpU1WyjPMS7CArWlUKuNCeCt7H
ZRhlGGLb6o477pA5agwIiPMSrJJVkpcf3enaybKWZd6KG1vkSNVWWuJID0KF
92FI8vKkFK8qWcZ5ibaTFWW1t+hOytTd2+VadrnS6EA98sgjPDPgJavxCoc4
L9EqWSV5eSI44P5oDSzg1uwaWA6uVH+mJa5UvqroAZvk5UupZ1WyjPMS1mxl
cvZbd+9eLmPlZYx9ciWckghreg2J85KtklWSlysiBMX94dGii02edy6+//nP
f0BLfEulEq+Z8cJlLs6DBg0C7jnOS9qsUQZ87C7OoY+rDZxJbEUXtpZ48/sz
VQaSw9PF2iVLlpx66qlTpkzp7e3VZB97SWMP+PLuoidP8fgSdbNrE0UNTMb6
pk2bsnUQbIV3BLzR4z/icAtHyPg1M08m+d3VgOf67apFJYlB02ZcmInXPN7S
r7/++ssuu2zhwoWzZ8/u7+/XZCtqsXv37h07dmzevPm6665bsWKFKVFAFqkW
NQRlOnV7hcBWvMUXwD0nkhJ7Gqsv7JRwGOZX4yA+IKKTDmQPQJmqKylE3ACZ
PHlyOzfiymHW7ezoQC5pdHQPKILXVlrfKSriLf0A7jmW5JBiQ1ADu07rQJUk
RZlqQClAMDyeeuqpLVu22OHRTraSEpTd6Y0Nuj90WWowAG7JlYJbijwVJwzd
q4S/4mTevHkmOPpENTB+oEwnHUgrgWj9+vWgMEC84dFB9qWMHLWVwkxkmCjH
yLC14FETtSFq4al04e+7QnjXkdOokHV405veZKpqlSRCRBW1CkPDDoy1a9ea
wOggW78G2uTB+2OiktFBczvZmU9up5SJCOA+PRp4K2vSWBga1oDqfXUgvwhK
VPOrNmzY8Nhjj7nh0En2RVuEYjAOmH/RrsRjBIICdp0KLXxyb6XstWDX8rj1
Kh7+xZT/xRdfrPDLoCT6JV4gxVBwA+HSSy/tJFuXfS0C0hIkEwG1UUOno4Dm
Vmz63EqxoWqIvuMwD1cNDWnGnGqidSCxDIpUF60wAIz7X3rpJdv9FbIv1KO/
FHw2MO9SpgbT1GV7uDdUKPF3bOKZCiU0tz3u4V2yeVNCMpVngZKIF6k2m2aW
vI6vkG2Wd9DnHV7umtupx7yp4Ui9DtxPA2+3Esr2d28rvNEMdCCdGAqnnXYa
KHS87fY046+L7Avp0KiJz5l35NbdMgqHeepzML3U47wU9LeHd5ThvXHjRq5T
VxLtAtWoK3T7ypUrXad3kW2WddDj7QJzzS2lQ6AGn9NHFf68ztytTLI9Prg1
5mgLOpA/Dm3Tpk0DhY533f7www93k33BUK/73H6/sX3OzMveWmtgJA57oyN9
1MWfp4O9JtVPdfb2ajyrUHZVoEIXxUvEkgxtY8aMAYWBYMLgxhtvtMOgm2yz
KtRjIH3W198PdUAJza0ZGRri4Ak+oMKf15UwcbBz505vBm0PhNd2g5rQLgI9
gdKCvr4+DA9vcMRoq5xocN52lVR5z307KqCmO/mALv7cSNA8HlpSQXlVePnl
lzXdiGKvAmYZ2Q6M+++/3wRGTO+WTSNBBVXQtTZiHvjU2YZ9nnijn3rShUJB
5qmozDARy3AApKRlqJKl6GlFverAHgtwINtL3kuaeM9kA+MxmA+I6KQllpSh
RFAFjwZoVslKSd7U1KuSKB5IttrEr9dpPCXYEsv9+IAynZREUSFGSPIypKX6
YWSpxHlI6lVLLKnY4QCy1/jcl9xpMc3G5wC/dJcILfHbtm0bP7IhzktwGE/w
pkXJGUfy/hJKIncA2dZqDyVHdjc8eW1WxxxzDCg+SZQUDXGSvIwefPBB6CNL
Ja4MUK9aYkUlQGPJnuoXA45rwuyUU04BLTHjMnsausZ5qfWRlbLryG2XdVCv
SqI1lmzrtY/itdcVZKZp3wol0VK050WSl9Utt9wCQwd2y/CvzPFuGxIzKoUb
Q/a1+snQ9eZhV0zZveMd71CLFy8GLfHjDSRo4TLOS3AoL+dmNgFInddJvSqJ
3BheOLdrhCTnVZqw0x/60IdASdQUIoEkLzNa0B9CliqzfUB9XZx61RI72sBs
f7KvV3AGHOhhWLIZDiSWg5ZYstS0nB3npTlkYIcQrxt5hxAlUdyfbLMVoOI1
2NkCS/3lL38ZlERR4f0AkrwMqRCglyyVuxtELS+FetUSS5oQGE32/ipSz/Xo
YRplmK5du5ZKOkBLXPm2R4vbcV6yvdaeJq5TeU8TJREdTbaeGlTJqR0tMdW8
54lEkzaBhCQvSyrDGcy7paDuXsfybilaYkov/f1kL9axuo71sC27bPltl4Yv
WmLMQxBaAorzUh5MVrX9V9AV2f1XeNAk0e0n2yZ1sNlrtr1lxpr3ZJHo0ham
kORlO378eOgZ2M3F62bezUVLjOmlfj+yD9XSeq5fD2vlZU3vsfS6oSXe/MpA
y91xXuI9vEiObvA6m/eKURLp/bjHvLW4Ogdr3kFGSZRpM17OCsjFmItX+ZXZ
mLkO5x1otMSaaitHkX0cWBn31vM2Mufsa80HRLxXjVeCf/3rX4p3nUE+yGrT
pk0m1XPBggUmh4kbiCUJpDpmMzZFGg0IpIrghBGYubpvfvObn/rUp9APZhkX
/cDZ8GSf0HYBvn2H9shbvPPMRUaVKh8Q0UlW5be//S2r8txzzxkvr1q1ynh5
woQJmmwTSRXsSNxRsjygTA1FmVFIVeoxodCZRRsEi5AROE1YDOP2hgwZYrOK
JZmkWROPSrU9e8q8Z49XIozfMk/A4YXgDZ92so0lidyKXRM7qUJ46dcRiArx
/j/pVG8aPngZm/CpK2TvQlT2KtSkVrnsqoQ3nfouQqJKvN0qEn/11VfdcGrn
BvwzVgZPpgR43rx5JpgiSykGwCdpu4Nu3pEI4SAobzgVi8W+Aa2mTp2a8opc
ocLVz36djj/+eFB88oqEt8Lo29/+Nu8VaQLKZN6kAdVBtpErksHijaa9997b
1ogHWoxA1IgQtNtrB25A2RpRY2XG5WoUrqWOvBpRkoDZYUnUiPZJqlVRpuFk
NozFcOogW49GhWAclTIaaUYg7ZnRxTs1IRQTSr/61a/uvfdeN5RgqKUTFyZQ
q6XsFReuz5ZV0rzTk1eir371qyVeKsSrzA2m5cuXd5JtKXutFYJxZCqZG351
ghGIKvGuUZmFKM/dyVGJsWVVkiq+zZin1KhSMVUJv6Te+973BnT62Mc+ZlVO
ZwKqk2wdnYrBWCo6OmlGIG2/UiEEnWZFwg4ofJnNBNQQbjlVaunSpcytaAsV
qCXHaArppHn3K69I+EmR9rFSOM5D8d2QqpBt0RbJ4EhLsq+55hoTSyarx9Rc
O78MwghEnXgnLfPpT3/6Uzek0vGSRyfGZ+vkrVBPV2WLjTqVbJ14G/rPfe5z
Aa3e9a53WXsmmD1207CqkG2DVqWBeDIF+RhPJvsH4wmxFLxaaUYg7efTSQgq
6UKXFFb9/f10n+rlHmy9uLSDeijUr8BABTxGVjPFNEozMF+RkQuv9wInMp13
3nl2gKWpp11kW6hff6VgbJk6cc+vuTACUTFCUEnvZRhgf/nLX6QAkxRjnHXF
vPX1aYwVGhWLMophM4p3KBM145+VOP30091Aoz1mydbSLArGWJugmdkjTdoy
qoN3OkMoLQbaYO4lo9odd9zBPAvpEN1TwW+/5TXXTX//+9/n+RNXtLlz57Yd
dthhoE466SRvuHWTrZO/IMWaqWMXfoWHUYjaEYqu+fPnZ0Luj3/8ozfkRO0Y
b107728UpTHXlmrX+Et5A7+Qx2zLrqKU1KEQYEDVAw88kAtp7KFXGpDdZJvN
haDUA280EkifpJoRSLuXtROCboSCgBBWS3e+HvafqyqX0DBmI2soKk0GU13Z
NmdVOPvbcW0BlTW97yZeifGtDV9tcfBsYtdsdZ3GLvCbcjbTIjGRazKuMHLT
vFpJY57+4zd/UWd6v+6ePn16OHjTPPTe3t6wzoy7rjPHhhZ/ziGvzsqrM2W9
IGBZ6fb29uHDh9vxnO6WDzFZZrM86tGcyd6VZNbUipI24tMIAOKxY8emAY0A
pVcOUwKBAW3yY7w6v/DCC8TYZLpIOfh51TXPDVdbjRgh9gqrtVjxUiWrxLsB
47Bhw4K/10WWVAmBlu4OFaZeR6pwkYI2rCUFDkTuu23u+4CW4pNTbRAcJHl1
pCSkKlnGeYXk/mg+2mxkks7MYpcYipqKhxJJx0BYml0NyVq4B7ShojH37Y3M
/1dNNaKEOK+gVbJK8upJucVlsqQaLjs80d6EZ/uIESMgluprpNg0s8v77rvv
CD4g4pMrLOvK/duFaemCQX00UKiPBgZ+o5SfH7SEgpJ4ldy+fTuvjyV5taTE
yCpZxnnFLPPK2NNPP+0N0XZaGUskLU182pN+9fgsD+g5kQ+I+OTXEwr4P9v4
gArj8RY6No5SSceZM2dKOmq8bCDOK2KVrJK8GtIkaESWtJuwNyw7qIhLquyp
r1JkqhFTDWfMmEENlOlU8l3prOC9fECFkWQqJ80TtFFBWrQ9mQ+vgpxWhaAg
yasiVUtVyTLOK2NEVlRe7g3IDoQqqqgz0ZjWMVI9a2QpSY2U6SQruX79egJS
YTSm7jYzm+gqeQYfopKcvxHnlbFKVkleFWkytcT5ImbHcAxJMwTAkDRtdVLW
hr++SIxGW0PelpPaKHqvZdSPuufsEWX/zmMajI360Rj0goHDq9+aNWsU3rEh
yasglYtUyTLOK2GJrCjDB8PRrKNjOKaLq51UfOZXMBiJpayK1I6o4lVXXQUV
xpEWgDcwc1RcMXBIKnJOWJxXwipZJXkVpJ8RKHIOGpLzhiKlSHkqncQYNDPm
dmUwZ7EV/Ncwq8f927/yl4ahuw6wmg9os7L3MvItX76ccwaTvArSPaNKlnFe
CYtWtqAbihXC6iqo7QU5u6qbYrDoqkitZFUs2huDm5zF9JcK7SQRV8c1fEAb
nUQdNY4XIM4rYpWskrwa0g8yFMiStkfyBmMXYc1WX9XiMC3sNO+SGIdmtj1T
oc5hBip9oclsrd7J/Xu3NnAVXMcHFAYygF35sFvOO07yKkj1bFWyjPNKWBAy
jk0wdjHgjIL+OKztMlHwq0jtaElFKsQzmc/nn3++G46ukvfwAQUezkhKakp2
jvPKWCWrJK+KNMXbxmnj0u/wdDPgTEWYGItmdt7dLYEz6pUkYgcjSH8D1c6B
cjXcygcUuX7AKyD2rSh5L8mrIVXaVfmXLfOK2BasV+gmrFkNg9HYJulILWlJ
RyoSNJUTOKR0Q9LVcjsfUORaE0lLrjWJ8wpZJau98uo4btw4tJN+QSsmnNlq
NDEWzey9d+cOoLocfq5EroTtXNFjjDIB6Sq4iw/eCsCqSbLlQwCKJvhpwklS
ED/y1wjRz0RwP7WaqhKdquLULoD/h44BxJqvmLrPaprQJwCZjTZqsQkgaMq1
Vfix9DMewDrQN9JfG7Z3E4IGdesjIhj0v2H2RgY=\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{"30", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "10"}], "]"}], ",", 
   RowBox[{"DataReversed", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24705],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAHiJAkGIPs/kAXG
ICEgYAaxwYBhA5BgpIFoEJDgBHJDR4isF5CQBHJ9R4isE5AQAHIFgTQHkHYd
VYVXlRVUFQeQVgTStqOq8KoygqoS+A/JdRLQ0DUdVU0T1VposQKiJYC07qjq
QaBaEUgIQuMSFIeKUBoWtyqjugaVLkmoLlCsKjBA6gZDIC0zqpomqkGyyHUw
qKwDtV00oXyRUV2DShfnf8zSDzmXgWIfVBryjOoeurpZ4Lr/o7ZEFKB6QGYq
YDGLZdSMkWAGxeMN0NEMRgCb2uYW\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->551462507]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2429],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reverse",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reverse"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Transpose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Transpose"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DataRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DataRange"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7761]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->421924162],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->345513610]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DataReversed - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 31.1928650}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DataReversed is an option for ArrayPlot and related functions which \
specifies whether data should be plotted in reverse order.", 
    "synonyms" -> {"data reversed"}, "title" -> "DataReversed", "type" -> 
    "Symbol", "uri" -> "ref/DataReversed"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5405, 166, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->60406266]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28465, 735}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1427, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2050, 61, 1577, 37, 70, "ObjectNameGrid"],
Cell[3630, 100, 642, 19, 70, "Usage",
 CellID->1244]
}, Open  ]],
Cell[CellGroupData[{
Cell[4309, 124, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4787, 141, 293, 9, 70, "Notes",
 CellID->2549],
Cell[5083, 152, 285, 9, 70, "Notes",
 CellID->292615158]
}, Closed]],
Cell[CellGroupData[{
Cell[5405, 166, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->60406266],
Cell[CellGroupData[{
Cell[5789, 180, 148, 5, 70, "ExampleSection",
 CellID->143898385],
Cell[5940, 187, 97, 2, 70, "ExampleText",
 CellID->5532],
Cell[CellGroupData[{
Cell[6062, 193, 326, 10, 28, "Input",
 CellID->25283],
Cell[6391, 205, 542, 13, 119, "Output",
 Evaluatable->False,
 CellID->235690]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6982, 224, 216, 7, 70, "ExampleSection",
 CellID->21880],
Cell[7201, 233, 84, 1, 70, "ExampleText",
 CellID->8835],
Cell[CellGroupData[{
Cell[7310, 238, 378, 11, 70, "Input",
 CellID->24987],
Cell[7691, 251, 1180, 23, 70, "Output",
 Evaluatable->False,
 CellID->137544634]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8920, 280, 239, 7, 70, "ExampleSection",
 CellID->25589],
Cell[9162, 289, 216, 9, 70, "ExampleText",
 CellID->54112546],
Cell[CellGroupData[{
Cell[9403, 302, 390, 12, 70, "Input",
 CellID->182265043],
Cell[9796, 316, 545, 13, 70, "Output",
 Evaluatable->False,
 CellID->572716400]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10390, 335, 233, 7, 70, "ExampleSection",
 CellID->32189],
Cell[10626, 344, 511, 19, 70, "ExampleText",
 CellID->13163],
Cell[CellGroupData[{
Cell[11162, 367, 268, 9, 70, "Input",
 CellID->30444],
Cell[11433, 378, 13367, 231, 203, 2709, 52, "CachedBoxData", "BoxData", \
"Output",
 CellID->18621]
}, Open  ]],
Cell[CellGroupData[{
Cell[24837, 614, 326, 10, 70, "Input",
 CellID->24705],
Cell[25166, 626, 545, 13, 70, "Output",
 Evaluatable->False,
 CellID->551462507]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25772, 646, 310, 9, 70, "SeeAlsoSection",
 CellID->2429],
Cell[26085, 657, 697, 26, 70, "SeeAlso",
 CellID->7761]
}, Open  ]],
Cell[CellGroupData[{
Cell[26819, 688, 319, 9, 70, "MoreAboutSection",
 CellID->421924162],
Cell[27141, 699, 197, 4, 70, "MoreAbout",
 CellID->345513610]
}, Open  ]],
Cell[27353, 706, 27, 0, 70, "History"],
Cell[27383, 708, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

