(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34118,       1256]
NotebookOptionsPosition[     26581,       1001]
NotebookOutlinePosition[     28236,       1043]
CellTagsIndexPosition[     28150,       1038]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DatePlus" :> Documentation`HelpLookup["paclet:ref/DatePlus"], 
          "DateString" :> Documentation`HelpLookup["paclet:ref/DateString"], 
          "DateList" :> Documentation`HelpLookup["paclet:ref/DateList"], 
          "DateListPlot" :> 
          Documentation`HelpLookup["paclet:ref/DateListPlot"], "DatePattern" :> 
          Documentation`HelpLookup["paclet:ref/DatePattern"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DatePlus\"\>", 
       2->"\<\"DateString\"\>", 3->"\<\"DateList\"\>", 
       4->"\<\"DateListPlot\"\>", 
       5->"\<\"DatePattern\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Date & Time" :> 
          Documentation`HelpLookup["paclet:guide/DateAndTime"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Date & Time\"\>", 
       2->"\<\"New in 6.0: Data Handling & Data Sources\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["DateDifference", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DateDifference",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DateDifference"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["date", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["date", "TI"], 
         StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the number of days from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["date", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["date", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DateDifference",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DateDifference"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["date", "TI"], 
         StyleBox["1", "TR"]], ",", " ", 
        SubscriptBox[
         StyleBox["date", "TI"], 
         StyleBox["2", "TR"]], ",", "\"\<\!\(\*
StyleBox[\"unit\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the difference between ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["date", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["date", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " in the specified unit."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DateDifference",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DateDifference"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["date", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["date", "TI"], 
         StyleBox["2", "TR"]], ",", 
        RowBox[{"{", 
         RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"unit\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"unit\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the difference as a list with elements \
corresponding to the successive ",
     Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"unit\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Dates can be specified in the following forms:", "Notes",
 CellID->89433052],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["y", "TI"], ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["d", "TI"]}], "}"}], Cell["year, month, day", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["y", "TI"], ",", 
      StyleBox["m", "TI"]}], "}"}], Cell[
    "the first day of the specified month", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox[
     RowBox[{"{", "y", "}"}], "TI"], Cell[TextData[{
     "January 1 of the year ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", Cell[TextData[{
     "date as a string (",
     Cell[BoxData["\"\<Jan. 1, 2000\>\""], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["y", "TI"], ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["d", "TI"], ",", 
      StyleBox["h", "TI"], ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["s", "TI"]}], "}"}], Cell["precise time", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["time", "TI"], Cell["absolute time specification", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->166719552],

Cell[TextData[{
 "Possible units are ",
 Cell[BoxData["\"\<Year\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Quarter\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Month\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Week\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Day\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Hour\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Minute\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Second\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->8760711],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["y", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["d", "TI"]}], "}"}]], "InlineFormula"],
 " is taken to be equivalent to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["y", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["d", "TI"], ",", "0", ",", "0", ",", "0"}], "}"}]], 
  "InlineFormula"],
 ", etc."
}], "Notes",
 CellID->180144667],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DateDifference",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateDifference"], "[", 
   SubscriptBox[
    StyleBox["date", "TI"], 
    StyleBox["2", "TR"]], "]"}]], "InlineFormula", "TemplateInclusion"],
 " gives the fractional number of days from the current time until ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["date", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 "."
}], "Notes",
 CellID->133057871]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->6426167],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->61328803],

Cell["Give the number of days between January 1 and July 4:", "ExampleText",
 CellID->12319951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateDifference", "[", 
  RowBox[{"\"\<Jan. 1\>\"", ",", "\"\<July 4\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64096088],

Cell[BoxData["184"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->293496559]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->98341072],

Cell[TextData[{
 "Use dates specified in ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["y", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["d", "TI"]}], "}"}]], "InlineFormula"],
 " form:"
}], "ExampleText",
 CellID->240878611],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateDifference", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2006", ",", "8", ",", "29"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2007", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32993426],

Cell[BoxData["125"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->625344968]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->73368297],

Cell["Find a date difference in units of weeks:", "ExampleText",
 CellID->99626658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateDifference", "[", 
  RowBox[{
  "\"\<Jan. 1, 2000\>\"", ",", "\"\<July 4, 2004\>\"", ",", "\"\<Week\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->716655467],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"235.14285714285714`", ",", "\<\"Week\"\>"}], "}"}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->764031413]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->108710012],

Cell["\<\
If the second date is before the first, the date difference is negative:\
\>", "ExampleText",
 CellID->486036679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateDifference", "[", 
  RowBox[{"\"\<July 4\>\"", ",", "\"\<January 1\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74282549],

Cell[BoxData[
 RowBox[{"-", "184"}]], "Output",
 ImageSize->{33, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->283786883]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Date Formats",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->235852875],

Cell[TextData[{
 "Give dates in any format supported by ",
 Cell[BoxData[
  ButtonBox["DateString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateString"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->616257092],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateDifference", "[", 
  RowBox[{"\"\<May 9, 2001\>\"", ",", "\"\<Nov 4, 2001\>\""}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->696797801],

Cell[BoxData["179"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->465169065]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->795651197],

Cell["List and string date specifications can be mixed:", "ExampleText",
 CellID->347704918],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateDifference", "[", 
  RowBox[{"\"\<May 9, 2001\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"2001", ",", "11", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->659471992],

Cell[BoxData["179"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17377057]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->210556676],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DateDifference",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateDifference"]], "InlineFormula"],
 " can use times given in ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["y", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["d", "TI"], ",", 
    StyleBox["h", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["s", "TI"]}], "}"}]], "InlineFormula"],
 " format:"
}], "ExampleText",
 CellID->847852450],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateDifference", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2007", ",", "1", ",", "1", ",", "5", ",", "16", ",", "17"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2007", ",", "1", ",", "5", ",", "7", ",", "8", ",", "11"}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->171039218],

Cell[BoxData["4.077708333333333`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->359626403]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Units",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->161588335],

Cell["Find the number of hours between two dates:", "ExampleText",
 CellID->646458713],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateDifference", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2006", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2007", ",", "6", ",", "1"}], "}"}], ",", "\"\<Hour\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->242279172],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"12384", ",", "\<\"Hour\"\>"}], "}"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89006351]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->451904117],

Cell["Find the number of years between two dates:", "ExampleText",
 CellID->212531813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateDifference", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1936", ",", "8", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2000", ",", "12", ",", "1"}], "}"}], ",", "\"\<Year\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36828686],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"64.2986301369863`", ",", "\<\"Year\"\>"}], "}"}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36411434]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->243267015],

Cell["Find the difference between two dates in months and days:", \
"ExampleText",
 CellID->2658203],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateDifference", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2003", ",", "8", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2004", ",", "12", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\"\<Month\>\"", ",", "\"\<Day\>\""}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->220148636],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"15", ",", "\<\"Month\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"18", ",", "\<\"Day\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->78762887]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19169053],

Cell["\<\
Find the number of years, months and days since the beginning of the year \
2000:\
\>", "ExampleText",
 CellID->2672101],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateDifference", "[", 
  RowBox[{
   RowBox[{"{", "2000", "}"}], ",", 
   RowBox[{"DateList", "[", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\"\<Month\>\"", ",", "\"\<Day\>\"", ",", "\"\<Year\>\""}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->457815885],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"7", ",", "\<\"Year\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "\<\"Month\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10.012914722222222`", ",", "\<\"Day\"\>"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24450792]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DatePlus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DatePlus"]], "InlineFormula"],
 " adds time units to dates, while ",
 Cell[BoxData[
  ButtonBox["DateDifference",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateDifference"]], "InlineFormula"],
 " computes units between dates:"
}], "ExampleText",
 CellID->351901144],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateDifference", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2007", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2007", ",", "3"}], "}"}], ",", "\"\<Month\>\""}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->71026221],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "\<\"Month\"\>"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->378728241]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatePlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2007", ",", "1"}], "}"}], ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->419281970],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2007", ",", "3"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->14893623]
}, Open  ]],

Cell["The inverse relationship:", "ExampleText",
 CellID->176313335],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatePlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2007", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "\"\<Month\>\""}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->14311124],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2007", ",", "3"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->907693880]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateDifference", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2007", ",", "1"}], "}"}], ",", "%", ",", "\"\<Month\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->246455929],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "\<\"Month\"\>"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->193704873]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["Date strings can be ambiguous: ", "ExampleText",
 CellID->1009350085],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateDifference", "[", 
  RowBox[{"\"\<2/4/99\>\"", ",", "\"\<Feb. 23, 1999\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3690731],

Cell[BoxData["19"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->391747508]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 " to disambiguate between different interpretations: "
}], "ExampleText",
 CellID->168056412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateDifference", "[", 
  RowBox[{
   RowBox[{"DateList", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<2/4/99\>\"", ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Day\>\"", ",", "\"\<Month\>\"", ",", "\"\<YearShort\>\""}], 
       "}"}]}], "}"}], "]"}], ",", "\"\<Feb. 23, 1999\>\""}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->238357484],

Cell[BoxData[
 RowBox[{"-", "38"}]], "Output",
 ImageSize->{26, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32535683]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DatePlus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DatePlus"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateListPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateListPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DatePattern",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DatePattern"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Date & Time",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DateAndTime"]], "MoreAbout",
 CellID->319467769],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout",
 CellID->34582414]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DateDifference - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 32.0835128}", "context" -> "System`", 
    "keywords" -> {
     "subtracting dates", "time between", "time between dates", 
      "time difference", "dates"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DateDifference[date_1, date_2] gives the number of days from date_1 to \
date_2. DateDifference[date_1, date_2, \" unit\"] gives the difference \
between date_1 and date_2 in the specified unit. DateDifference[date_1, \
date_2, {\"SubscriptBox[ unit, 1]\", \"SubscriptBox[ unit, 2]\", ...}] gives \
the difference as a list with elements corresponding to the successive \
\"SubscriptBox[ unit, i]\".", "synonyms" -> {"date difference"}, "title" -> 
    "DateDifference", "type" -> "Symbol", "uri" -> "ref/DateDifference"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10322, 322, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->6426167]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28008, 1031}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1777, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2400, 68, 1579, 37, 70, "ObjectNameGrid"],
Cell[3982, 107, 2663, 84, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6682, 196, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7160, 213, 82, 1, 70, "Notes",
 CellID->89433052],
Cell[7245, 216, 1589, 43, 70, "2ColumnTableMod",
 CellID->166719552],
Cell[8837, 261, 523, 19, 70, "Notes",
 CellID->8760711],
Cell[9363, 282, 442, 17, 70, "Notes",
 CellID->180144667],
Cell[9808, 301, 477, 16, 70, "Notes",
 CellID->133057871]
}, Closed]],
Cell[CellGroupData[{
Cell[10322, 322, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->6426167],
Cell[CellGroupData[{
Cell[10705, 336, 147, 5, 70, "ExampleSection",
 CellID->61328803],
Cell[10855, 343, 95, 1, 70, "ExampleText",
 CellID->12319951],
Cell[CellGroupData[{
Cell[10975, 348, 158, 4, 28, "Input",
 CellID->64096088],
Cell[11136, 354, 160, 5, 36, "Output",
 CellID->293496559]
}, Open  ]],
Cell[11311, 362, 124, 3, 70, "ExampleDelimiter",
 CellID->98341072],
Cell[11438, 367, 250, 10, 70, "ExampleText",
 CellID->240878611],
Cell[CellGroupData[{
Cell[11713, 381, 257, 8, 70, "Input",
 CellID->32993426],
Cell[11973, 391, 160, 5, 36, "Output",
 CellID->625344968]
}, Open  ]],
Cell[12148, 399, 124, 3, 70, "ExampleDelimiter",
 CellID->73368297],
Cell[12275, 404, 83, 1, 70, "ExampleText",
 CellID->99626658],
Cell[CellGroupData[{
Cell[12383, 409, 198, 6, 70, "Input",
 CellID->716655467],
Cell[12584, 417, 233, 7, 36, "Output",
 CellID->764031413]
}, Open  ]],
Cell[12832, 427, 125, 3, 70, "ExampleDelimiter",
 CellID->108710012],
Cell[12960, 432, 123, 3, 70, "ExampleText",
 CellID->486036679],
Cell[CellGroupData[{
Cell[13108, 439, 161, 4, 70, "Input",
 CellID->74282549],
Cell[13272, 445, 177, 6, 36, "Output",
 CellID->283786883]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13498, 457, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[CellGroupData[{
Cell[13744, 468, 233, 7, 70, "ExampleSubsection",
 CellID->235852875],
Cell[13980, 477, 225, 8, 70, "ExampleText",
 CellID->616257092],
Cell[CellGroupData[{
Cell[14230, 489, 171, 5, 70, "Input",
 CellID->696797801],
Cell[14404, 496, 160, 5, 36, "Output",
 CellID->465169065]
}, Open  ]],
Cell[14579, 504, 125, 3, 70, "ExampleDelimiter",
 CellID->795651197],
Cell[14707, 509, 92, 1, 70, "ExampleText",
 CellID->347704918],
Cell[CellGroupData[{
Cell[14824, 514, 214, 6, 70, "Input",
 CellID->659471992],
Cell[15041, 522, 159, 5, 36, "Output",
 CellID->17377057]
}, Open  ]],
Cell[15215, 530, 125, 3, 70, "ExampleDelimiter",
 CellID->210556676],
Cell[15343, 535, 477, 17, 70, "ExampleText",
 CellID->847852450],
Cell[CellGroupData[{
Cell[15845, 556, 330, 10, 70, "Input",
 CellID->171039218],
Cell[16178, 568, 175, 5, 36, "Output",
 CellID->359626403]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16402, 579, 226, 7, 70, "ExampleSubsection",
 CellID->161588335],
Cell[16631, 588, 86, 1, 70, "ExampleText",
 CellID->646458713],
Cell[CellGroupData[{
Cell[16742, 593, 281, 9, 70, "Input",
 CellID->242279172],
Cell[17026, 604, 217, 7, 36, "Output",
 CellID->89006351]
}, Open  ]],
Cell[17258, 614, 125, 3, 70, "ExampleDelimiter",
 CellID->451904117],
Cell[17386, 619, 86, 1, 70, "ExampleText",
 CellID->212531813],
Cell[CellGroupData[{
Cell[17497, 624, 282, 9, 70, "Input",
 CellID->36828686],
Cell[17782, 635, 230, 7, 36, "Output",
 CellID->36411434]
}, Open  ]],
Cell[18027, 645, 125, 3, 70, "ExampleDelimiter",
 CellID->243267015],
Cell[18155, 650, 100, 2, 70, "ExampleText",
 CellID->2658203],
Cell[CellGroupData[{
Cell[18280, 656, 340, 10, 70, "Input",
 CellID->220148636],
Cell[18623, 668, 325, 11, 36, "Output",
 CellID->78762887]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[19009, 686, 226, 7, 70, "ExampleSection",
 CellID->19169053],
Cell[19238, 695, 130, 4, 70, "ExampleText",
 CellID->2672101],
Cell[CellGroupData[{
Cell[19393, 703, 298, 9, 70, "Input",
 CellID->457815885],
Cell[19694, 714, 414, 14, 36, "Output",
 CellID->24450792]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20157, 734, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[20398, 743, 376, 12, 70, "ExampleText",
 CellID->351901144],
Cell[CellGroupData[{
Cell[20799, 759, 260, 9, 70, "Input",
 CellID->71026221],
Cell[21062, 770, 215, 7, 36, "Output",
 CellID->378728241]
}, Open  ]],
Cell[CellGroupData[{
Cell[21314, 782, 179, 6, 70, "Input",
 CellID->419281970],
Cell[21496, 790, 205, 7, 36, "Output",
 CellID->14893623]
}, Open  ]],
Cell[21716, 800, 68, 1, 70, "ExampleText",
 CellID->176313335],
Cell[CellGroupData[{
Cell[21809, 805, 239, 8, 70, "Input",
 CellID->14311124],
Cell[22051, 815, 206, 7, 36, "Output",
 CellID->907693880]
}, Open  ]],
Cell[CellGroupData[{
Cell[22294, 827, 210, 7, 70, "Input",
 CellID->246455929],
Cell[22507, 836, 215, 7, 36, "Output",
 CellID->193704873]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22771, 849, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[23005, 858, 75, 1, 70, "ExampleText",
 CellID->1009350085],
Cell[CellGroupData[{
Cell[23105, 863, 164, 4, 70, "Input",
 CellID->3690731],
Cell[23272, 869, 159, 5, 36, "Output",
 CellID->391747508]
}, Open  ]],
Cell[23446, 877, 238, 8, 70, "ExampleText",
 CellID->168056412],
Cell[CellGroupData[{
Cell[23709, 889, 374, 12, 70, "Input",
 CellID->238357484],
Cell[24086, 903, 175, 6, 36, "Output",
 CellID->32535683]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24322, 916, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[24641, 927, 1208, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[25886, 976, 299, 8, 70, "MoreAboutSection"],
Cell[26188, 986, 134, 3, 70, "MoreAbout",
 CellID->319467769],
Cell[26325, 991, 184, 3, 70, "MoreAbout",
 CellID->34582414]
}, Open  ]],
Cell[26524, 997, 27, 0, 70, "History"],
Cell[26554, 999, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

