(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     59836,       2168]
NotebookOptionsPosition[     47998,       1763]
NotebookOutlinePosition[     49917,       1809]
CellTagsIndexPosition[     49831,       1804]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Date and Time Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DateAndTimeFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Date and Time Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DateString" :> 
          Documentation`HelpLookup["paclet:ref/DateString"], "DatePlus" :> 
          Documentation`HelpLookup["paclet:ref/DatePlus"], "DateDifference" :> 
          Documentation`HelpLookup["paclet:ref/DateDifference"], 
          "AbsoluteTime" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteTime"], "$TimeZone" :> 
          Documentation`HelpLookup["paclet:ref/$TimeZone"], "SessionTime" :> 
          Documentation`HelpLookup["paclet:ref/SessionTime"], "TimeUsed" :> 
          Documentation`HelpLookup["paclet:ref/TimeUsed"], "FileDate" :> 
          Documentation`HelpLookup["paclet:ref/FileDate"], "$CreationDate" :> 
          Documentation`HelpLookup["paclet:ref/$CreationDate"], "Clock" :> 
          Documentation`HelpLookup["paclet:ref/Clock"], "DateListPlot" :> 
          Documentation`HelpLookup["paclet:ref/DateListPlot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DateString\"\>", 
       2->"\<\"DatePlus\"\>", 3->"\<\"DateDifference\"\>", 
       4->"\<\"AbsoluteTime\"\>", 5->"\<\"$TimeZone\"\>", 
       6->"\<\"SessionTime\"\>", 7->"\<\"TimeUsed\"\>", 8->"\<\"FileDate\"\>",
        9->"\<\"$CreationDate\"\>", 10->"\<\"Clock\"\>", 
       11->"\<\"DateListPlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Converting between Expressions & Strings" :> 
          Documentation`HelpLookup[
           "paclet:guide/ConvertingBetweenExpressionsAndStrings"], 
          "Date & Time" :> 
          Documentation`HelpLookup["paclet:guide/DateAndTime"], 
          "External Operations" :> 
          Documentation`HelpLookup["paclet:guide/ExternalOperations"], 
          "Locale & Internationalization" :> 
          Documentation`HelpLookup[
           "paclet:guide/LocaleAndInternationalization"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Converting between Expressions & Strings\"\>", 
       2->"\<\"Date & Time\"\>", 3->"\<\"External Operations\"\>", 
       4->"\<\"Locale & Internationalization\"\>", 
       5->"\<\"New in 6.0: Data Handling & Data Sources\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["DateList", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DateList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DateList"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the current local date and time in the form ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["year", "TI"], ",", 
        StyleBox["month", "TI"], ",", 
        StyleBox["day", "TI"], ",", 
        StyleBox["hour", "TI"], ",", 
        StyleBox["minute", "TI"], ",", 
        StyleBox["second", "TI"]}], "}"}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DateList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DateList"], "[", 
       StyleBox["time", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a date list corresponding to an ",
     Cell[BoxData[
      ButtonBox["AbsoluteTime",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/AbsoluteTime"]], "InlineFormula"],
     " specification."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DateList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DateList"], "[", 
       RowBox[{
        StyleBox["{", "TI"], 
        RowBox[{
         StyleBox["y", "TI"], 
         StyleBox[",", "TI"], 
         StyleBox["m", "TI"], ",", 
         StyleBox["d", "TI"], ",", 
         StyleBox["h", "TI"], ",", 
         StyleBox["m", "TI"], ",", 
         StyleBox["s", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]converts a date list to standard normalized form. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DateList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DateList"], "[", 
       StyleBox[
        RowBox[{"\"\<\>", "string", "\"\<\>"}], "TI"], "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]converts a date string to a date list. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DateList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DateList"], "[", 
       RowBox[{"{", 
        RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}], "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]gives the date list obtained by extracting elements ",
     Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
     " from ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->25061]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DateList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateList"], "[", "]"}]], "InlineFormula"],
 " uses whatever date and time have been set on your computer system. It \
performs no corrections for time zones, daylight saving time, etc. "
}], "Notes",
 CellID->19952],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DateList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateList"], "[", 
   RowBox[{
    ButtonBox["TimeZone",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TimeZone"], " ", "->", " ", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " gives the date and time inferred for time zone ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " by assuming that your computer is set for the time zone specified by ",
 Cell[BoxData[
  ButtonBox["$TimeZone",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$TimeZone"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->208232548]
}], "Notes",
 CellID->10970],

Cell[TextData[{
 "All values returned by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DateList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateList"], "[", "]"}]], "InlineFormula"],
 " are integers, except the number of seconds. The number of seconds is never \
more accurate than ",
 Cell[BoxData[
  ButtonBox["$TimeUnit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$TimeUnit"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22823],

Cell[TextData[{
 "Shorter lists can be used in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DateList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateList"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["y", "TI"], ",", 
     StyleBox["m", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 ": ",
 Cell[BoxData[
  RowBox[{"{", 
   StyleBox["y", "TI"], "}"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["y", "TI"], ",", "1", ",", "1", ",", "0", ",", "0", ",", "0"}], 
   "}"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["y", "TI"], ",", 
    StyleBox["m", "TI"]}], "}"}]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["y", "TI"], ",", 
    StyleBox["m", "TI"], ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}]], 
  "InlineFormula"],
 ", etc."
}], "Notes",
 CellID->89151030],

Cell[TextData[{
 "Values of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " outside their normal ranges are appropriately reduced. Non-integer values \
of ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " can also be used. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->27928209]
}], "Notes",
 CellID->124355884],

Cell[TextData[{
 "You can compare two lists returned by ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 " using ",
 Cell[BoxData[
  ButtonBox["Order",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Order"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->212396129]
}], "Notes",
 CellID->18064],

Cell[TextData[{
 "In the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DateList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateList"], "[", 
   RowBox[{"{", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]}]], "InlineFormula"],
 " the ",
 Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
 " can be ",
 Cell[BoxData["\"\<Year\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<YearShort\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Quarter\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Month\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<MonthName\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Day\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<DayName\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Hour\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Hour12\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<AMPM\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Minute\>\""], "InlineFormula"],
 ", or ",
 Cell[BoxData["\"\<Second\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->69267552],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DateList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateList"], "[", 
   RowBox[{"{", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]}]], "InlineFormula"],
 " uses the ",
 Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
 " to fill in elements of ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["y", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["d", "TI"], ",", 
    StyleBox["h", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["s", "TI"]}], "}"}]], "InlineFormula"],
 ". Those not filled in are taken to have default values ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["y", "TI"], 
     StyleBox["c", "TI"]], ",", "1", ",", "1", ",", "0", ",", "0", ",", "0"}],
    "}"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["y", "TI"], 
   StyleBox["c", "TI"]]], "InlineFormula"],
 " is the current year. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->33092171]
}], "Notes",
 CellID->262340544],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DateList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateList"], "[", 
   RowBox[{"{", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]}]], "InlineFormula"],
 ", the ",
 Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
 " are extracted from ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
 " in the order given, and can be separated by any non-alphanumeric \
characters. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->171106044]
}], "Notes",
 CellID->32350066],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DateList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateList"], "[", 
   RowBox[{"{", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"sep\", \"TI\"], 
StyleBox[\"12\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"sep\", \"TI\"], 
StyleBox[\"23\", \"TR\"]]\)\>\"", ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]}]], "InlineFormula"],
 " extracts elements using the explicit separators specified. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->213309941]
}], "Notes",
 CellID->205302116]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->30486757],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(5)", "ExampleCount"]
}], "ExampleSection",
 CellID->341420388],

Cell["Find the current date:", "ExampleText",
 CellID->15183],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16933],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2006", ",", "11", ",", "7", ",", "11", ",", "48", ",", 
   "55.328125`9.495520791920056"}], "}"}]], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->204740087]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->77510635],

Cell["Convert an absolute time to a date list:", "ExampleText",
 CellID->30687951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", "3155673600", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->931154209],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2000", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0.`"}], 
  "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->159056820]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->433745713],

Cell["Expand an elided date list:", "ExampleText",
 CellID->52526329],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", 
  RowBox[{"{", 
   RowBox[{"2006", ",", "12"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->207768162],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2006", ",", "12", ",", "1", ",", "0", ",", "0", ",", "0.`"}], 
  "}"}]], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->47082808]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->318377344],

Cell["Convert a date string to a date list:", "ExampleText",
 CellID->846160392],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", "\"\<23 Nov, 1992\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->468746160],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1992", ",", "11", ",", "23", ",", "0", ",", "0", ",", "0.`"}], 
  "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->424227552]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->548007546],

Cell["Specify date elements for converting a string:", "ExampleText",
 CellID->186401120],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<05/06/07\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Day\>\"", ",", "\"\<Month\>\"", ",", "\"\<YearShort\>\""}], 
     "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->102498054],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2007", ",", "6", ",", "5", ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->280870416]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31037646],

Cell["Date lists are converted to standard normalized form:", "ExampleText",
 CellID->47250627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", 
  RowBox[{"{", 
   RowBox[{"2006", ",", "2", ",", "31"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67281060],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2006", ",", "3", ",", "3", ",", "0", ",", "0", ",", "0.`"}], 
  "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102056062]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->121074309],

Cell["Strings are automatically interpreted when possible:", "ExampleText",
 CellID->228124850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", "\"\<2006-12-15\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26535382],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2006", ",", "12", ",", "15", ",", "0", ",", "0", ",", "0.`"}], 
  "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->224435811]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", "\"\<10 March 2006\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->267969406],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2006", ",", "3", ",", "10", ",", "0", ",", "0", ",", "0.`"}], 
  "}"}]], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->345735825]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25392021],

Cell["Separators are assumed if not specified:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->171106044],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<2/23/2007\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Month\>\"", ",", "\"\<Day\>\"", ",", "\"\<Year\>\""}], 
     "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->168427058],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2007", ",", "2", ",", "23", ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->355868845]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->206227907],

Cell["Give explicit separators:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->213309941],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<2/23/2007\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
     "\"\<Month\>\"", ",", "\"\</\>\"", ",", "\"\<Day\>\"", ",", "\"\</\>\"", 
      ",", "\"\<Year\>\""}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->387067767],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2007", ",", "2", ",", "23", ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->52038373]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->112362973],

Cell["Day, hour, minute and second values can be non-integers:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->27928209],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", 
  RowBox[{"{", 
   RowBox[{"2007", ",", "3", ",", "15.5"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->751779630],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2007", ",", "3", ",", "15", ",", "12", ",", "0", ",", "0.`"}], 
  "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->225168739]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", 
  RowBox[{"{", 
   RowBox[{"2007", ",", "3", ",", "15", ",", "12.3"}], "}"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->632638308],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2007", ",", "3", ",", "15", ",", "12", ",", "18", ",", "0.`"}], 
  "}"}]], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->581606379]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4422378],

Cell["The current year is used if not specified in a string:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->33092171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<2/15\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Month\>\"", ",", "\"\<Day\>\""}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12776873],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2007", ",", "2", ",", "15", ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->550605044]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7468],

Cell["Give explicit date elements to interpret ambiguous strings:", \
"ExampleText",
 CellID->139144165],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", "\"\<05/10/1\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->187066901],

Cell[BoxData[
 RowBox[{
  RowBox[{"DateList", "::", "\<\"ambig\"\>"}], ":", 
  " ", "\<\"Warning: the interpretation of the string \
\\!\\(\\\"05/10/1\\\"\\) as a date is ambiguous. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/DateList\\\", ButtonNote -> \
\\\"DateList::ambig\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->17462720],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2001", ",", "5", ",", "10", ",", "0", ",", "0", ",", "0.`"}], 
  "}"}]], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16773697]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<05/10/1\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<YearShort\>\"", ",", "\"\<Day\>\"", ",", "\"\<Month\>\""}], 
     "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->543728066],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2005", ",", "1", ",", "10", ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->245673847]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->123483487],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TimeZone",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->287251432],

Cell["Find the current date in Greenwich, United Kingdom:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->208232548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", 
  RowBox[{"TimeZone", "\[Rule]", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->78442617],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2006", ",", "11", ",", "7", ",", "17", ",", "48", ",", 
   "58.34375`9.518569170592418"}], "}"}]], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->287728696]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12864],

Cell["Specify interpretation of a string in a standard format:", "ExampleText",
 CellID->141370219],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<1996-12-19T16:39:57Z\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
     "\"\<Year\>\"", ",", "\"\<-\>\"", ",", "\"\<Month\>\"", ",", "\"\<-\>\"",
       ",", "\"\<Day\>\"", ",", "\"\<T\>\"", ",", "\"\<Hour\>\"", ",", 
      "\"\<:\>\"", ",", "\"\<Minute\>\"", ",", "\"\<:\>\"", ",", 
      "\"\<Second\>\"", ",", "\"\<Z\>\""}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->412047447],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1996", ",", "12", ",", "19", ",", "16", ",", "39", ",", "57"}], 
  "}"}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->773950909]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30845],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbsoluteTime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteTime"]], "InlineFormula"],
 " represents dates as seconds since the beginning of 1900:"
}], "ExampleText",
 CellID->294473746],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTime", "[", 
  RowBox[{"{", 
   RowBox[{"2007", ",", "1", ",", "1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->244032669],

Cell[BoxData["3376598400"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55998844]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 " represents dates as lists of date elements:"
}], "ExampleText",
 CellID->512534639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->452464721],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2007", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0.`"}], 
  "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->206694218]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DateString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateString"]], "InlineFormula"],
 " represents dates as strings:"
}], "ExampleText",
 CellID->221426326],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->56881056],

Cell[BoxData["\<\"Mon 1 Jan 2007 00:00:00\"\>"], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->782973969]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->123040038],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["DateListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateListPlot"]], "InlineFormula"],
 " to plot data with date list ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " coordinates:"
}], "ExampleText",
 CellID->17347369],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2007", ",", "1"}], "}"}], ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2007", ",", "2"}], "}"}], ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2007", ",", "3"}], "}"}], ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2007", ",", "4"}], "}"}], ",", "8"}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->111258812],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs9rE0EUnuyPpFi8eyxSC02lQrXexEPRnkQ8SM9rEdpDW6n9GwRF/wDB
g2Bail6UBj156kUh0GvP/iPr/Hiz+/J2dpM1M5A1E8jsvNmZb7/3zczLy7CP
kqOd53vJ0e52srB5mLzY2d1+ufDw4JA3hS3GWJ9/X11jvJ7ymvz205RfP/My
5GZHWl9EKcxUflhbtka8DHhjyK8xgwpTny6M130CuC5Cu+6rgfFYYS9Dv0Bj
R/l91coUiw6ADJeqB2LcJba8H2d2yajrorhqfILhmSuIT4ZpQM7dbVNW4lac
DYS+N8nYQGtY6Lk4QpGAKN/V6nYIUpFlu4hK0VbQnGlty2eknrYmDTQn3BEx
juldypdihoShqN5I8zUeMMM8wlpnEWYckRUtRraMM37buA4j0ouyWCMs5uU1
Bv0FZhv1XoL2EK5rBP2KHN0vKYUvX9VzIqy0ME6zRjq7IfLruHfBK+/enrN1
0usWse+Uq1GYnSDT+cHGB6xmOBgMqvDhvp6XcnTN5PevP8+Skx/fL4E/xc9t
xT+zh/jrFYKkzFv4kLuTYKO1FqdoZ4KrY/FGdq7LnFWe0442O7p5T+t7GsLu
ssfPGHWcoqtcq9zbKjWGIyaNOfZ4G39LmqL5zEVg7+n/56nbvWxPR7eRIqrI
09687t+/917ktPXyNJbl7DpbL3r65PFHjs2zWsvRuPfp58H+mchjJ8ktm7I2
pnlX+NjkPfWZaz10e5mrW+7u4iU+u7IfibU+fn95T5vraRPO1JyeBNbEXpX2
ce8Cstn1WtijYrJC33p6Avks1ozE5LGipcIj57E+Who4Tjva7OjmPf2HCOls
77qNCvTfrL2c1e1Jh1t0t793YDLd5veb97S5nvr81QZ2djpbqYgAVnj5M81v
DHCb4w1H5Eqm4yKLNwzUmewIFU6NXnyT1bI3NyYpWesvdRtEZw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13752199]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->100265182],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["DatePlus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DatePlus"]], "InlineFormula"],
 " to add time units to a date list:"
}], "ExampleText",
 CellID->206399130],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatePlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2007", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "\"\<Day\>\""}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->484824814],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2007", ",", "1", ",", "4"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37865201]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["DateDifference",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateDifference"]], "InlineFormula"],
 " to find the number of time units between dates:"
}], "ExampleText",
 CellID->680283911],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateDifference", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2007", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2007", ",", "5", ",", "1"}], "}"}], ",", "\"\<Day\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30828526],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"89", ",", "\<\"Day\"\>"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->944979343]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->78355837],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Order",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Order"]], "InlineFormula"],
 " to determine the order of dates:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->212396129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Order", "[", 
  RowBox[{
   RowBox[{"DateList", "[", 
    RowBox[{"{", 
     RowBox[{"2007", ",", "1"}], "}"}], "]"}], ",", 
   RowBox[{"DateList", "[", 
    RowBox[{"{", 
     RowBox[{"2007", ",", "5"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->275570032],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->224574011]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Order", "[", 
  RowBox[{
   RowBox[{"DateList", "[", "\"\<2007 December 28\>\"", "]"}], ",", 
   RowBox[{"DateList", "[", 
    RowBox[{"{", 
     RowBox[{"2007", ",", "1"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->216784907],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6138521]
}, Open  ]],

Cell[TextData[{
 "The canonicalization performed by ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 " is significant: "
}], "ExampleText",
 CellID->192028282],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Order", "[", 
    RowBox[{
     RowBox[{"DateList", "[", 
      RowBox[{"{", 
       RowBox[{"2009", ",", "m"}], "}"}], "]"}], ",", 
     RowBox[{"DateList", "[", 
      RowBox[{"{", 
       RowBox[{"2010", ",", "7"}], "}"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "15", ",", "25"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->100799214],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "0", ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 ImageSize->{253, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->151828124]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Order", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2009", ",", "m"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2010", ",", "7"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "15", ",", "25"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->453732951],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{207, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->76563875]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1849],

Cell["\<\
Year and month must be integers because the lengths of years and months vary:\
\
\>", "ExampleText",
 CellID->431104821],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", 
  RowBox[{"{", 
   RowBox[{"2007", ",", "3.5"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->451847619],

Cell[BoxData[
 RowBox[{
  RowBox[{"DateList", "::", "\<\"arg\"\>"}], ":", 
  " ", "\<\"Argument \\!\\({2007, 3.5`}\\) cannot be interpreted as a date or \
time input. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/DateList/arg\\\", ButtonNote -> \
\\\"DateList::arg\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->20105854],

Cell[BoxData[
 RowBox[{"DateList", "[", 
  RowBox[{"{", 
   RowBox[{"2007", ",", "3.5`"}], "}"}], "]"}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->615958221]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", 
  RowBox[{"{", 
   RowBox[{"2007", ",", "3", ",", "15.5"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->49149522],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2007", ",", "3", ",", "15", ",", "12", ",", "0", ",", "0.`"}], 
  "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->100383140]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->802219224],

Cell[TextData[{
 "There is no ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["0", "th"], TraditionalForm]], "InlineMath"],
 " month or day:"
}], "ExampleText",
 CellID->644676629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", 
  RowBox[{"{", 
   RowBox[{"2007", ",", "0"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->157328957],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2006", ",", "12", ",", "1", ",", "0", ",", "0", ",", "0.`"}], 
  "}"}]], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->682867755]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", 
  RowBox[{"{", 
   RowBox[{"2007", ",", "1", ",", "0"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->194043702],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2006", ",", "12", ",", "31", ",", "0", ",", "0", ",", "0.`"}], 
  "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->399995670]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22443],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DatePlus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DatePlus"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateDifference",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateDifference"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteTime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteTime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$TimeZone",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$TimeZone"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SessionTime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SessionTime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TimeUsed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TimeUsed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileDate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileDate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$CreationDate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$CreationDate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Clock",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Clock"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateListPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateListPlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7161]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22050],

Cell[TextData[ButtonBox["Date and Time Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DateAndTimeFunctions"]], "Tutorials",
 CellID->31934]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->422282704],

Cell[TextData[ButtonBox["Converting between Expressions & Strings",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ConvertingBetweenExpressionsAndStrings"]], "MoreAbout",
 CellID->83468204],

Cell[TextData[ButtonBox["Date & Time",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DateAndTime"]], "MoreAbout",
 CellID->493497409],

Cell[TextData[ButtonBox["External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "MoreAbout",
 CellID->55090346],

Cell[TextData[ButtonBox["Locale & Internationalization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LocaleAndInternationalization"]], "MoreAbout",
 CellID->12220518],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout",
 CellID->198968419]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DateList - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 33.1460400}", "context" -> "System`", 
    "keywords" -> {
     "calendar", "clock", "date", "date structure", "day", "hour", "minute", 
      "month", "second", "time", "year", "date representation", 
      "dates and times", "date conversion", "date parsing", 
      "date canonicalization", "date normalization", "time zone"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "DateList[] gives the current local date and time in the form {year, \
month, day, hour, minute, second}. DateList[time] gives a date list \
corresponding to an AbsoluteTime specification. DateList[{y, m, d, h, m, s}] \
converts a date list to standard normalized form. DateList[\"string \"] \
converts a date string to a date list. DateList[{\" string\", \
{\"SubscriptBox[ e, 1]\", \"SubscriptBox[ e, 2]\", ...}}] gives the date list \
obtained by extracting elements \"SubscriptBox[ e, i]\" from \" string\".", 
    "synonyms" -> {"date list"}, "title" -> "DateList", "type" -> "Symbol", 
    "uri" -> "ref/DateList"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[17835, 566, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->30486757]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 49688, 1797}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3588, 77, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4211, 104, 1573, 37, 70, "ObjectNameGrid"],
Cell[5787, 143, 3082, 93, 70, "Usage",
 CellID->25061]
}, Open  ]],
Cell[CellGroupData[{
Cell[8906, 241, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9384, 258, 333, 9, 70, "Notes",
 CellID->19952],
Cell[9720, 269, 757, 24, 70, "Notes",
 CellID->10970],
Cell[10480, 295, 446, 15, 70, "Notes",
 CellID->22823],
Cell[10929, 312, 950, 37, 70, "Notes",
 CellID->89151030],
Cell[11882, 351, 819, 34, 70, "Notes",
 CellID->124355884],
Cell[12704, 387, 424, 16, 70, "Notes",
 CellID->18064],
Cell[13131, 405, 1393, 47, 70, "Notes",
 CellID->69267552],
Cell[14527, 454, 1435, 48, 70, "Notes",
 CellID->262340544],
Cell[15965, 504, 954, 30, 70, "Notes",
 CellID->32350066],
Cell[16922, 536, 876, 25, 70, "Notes",
 CellID->205302116]
}, Closed]],
Cell[CellGroupData[{
Cell[17835, 566, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->30486757],
Cell[CellGroupData[{
Cell[18219, 580, 148, 5, 70, "ExampleSection",
 CellID->341420388],
Cell[18370, 587, 61, 1, 70, "ExampleText",
 CellID->15183],
Cell[CellGroupData[{
Cell[18456, 592, 95, 3, 28, "Input",
 CellID->16933],
Cell[18554, 597, 283, 9, 36, "Output",
 CellID->204740087]
}, Open  ]],
Cell[18852, 609, 124, 3, 70, "ExampleDelimiter",
 CellID->77510635],
Cell[18979, 614, 82, 1, 70, "ExampleText",
 CellID->30687951],
Cell[CellGroupData[{
Cell[19086, 619, 113, 3, 70, "Input",
 CellID->931154209],
Cell[19202, 624, 252, 8, 36, "Output",
 CellID->159056820]
}, Open  ]],
Cell[19469, 635, 125, 3, 70, "ExampleDelimiter",
 CellID->433745713],
Cell[19597, 640, 69, 1, 70, "ExampleText",
 CellID->52526329],
Cell[CellGroupData[{
Cell[19691, 645, 155, 5, 70, "Input",
 CellID->207768162],
Cell[19849, 652, 252, 8, 36, "Output",
 CellID->47082808]
}, Open  ]],
Cell[20116, 663, 125, 3, 70, "ExampleDelimiter",
 CellID->318377344],
Cell[20244, 668, 80, 1, 70, "ExampleText",
 CellID->846160392],
Cell[CellGroupData[{
Cell[20349, 673, 123, 3, 70, "Input",
 CellID->468746160],
Cell[20475, 678, 254, 8, 36, "Output",
 CellID->424227552]
}, Open  ]],
Cell[20744, 689, 125, 3, 70, "ExampleDelimiter",
 CellID->548007546],
Cell[20872, 694, 89, 1, 70, "ExampleText",
 CellID->186401120],
Cell[CellGroupData[{
Cell[20986, 699, 271, 8, 70, "Input",
 CellID->102498054],
Cell[21260, 709, 250, 8, 36, "Output",
 CellID->280870416]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21559, 723, 219, 7, 70, "ExampleSection",
 CellID->31037646],
Cell[21781, 732, 95, 1, 70, "ExampleText",
 CellID->47250627],
Cell[CellGroupData[{
Cell[21901, 737, 164, 5, 70, "Input",
 CellID->67281060],
Cell[22068, 744, 252, 8, 36, "Output",
 CellID->102056062]
}, Open  ]],
Cell[22335, 755, 125, 3, 70, "ExampleDelimiter",
 CellID->121074309],
Cell[22463, 760, 95, 1, 70, "ExampleText",
 CellID->228124850],
Cell[CellGroupData[{
Cell[22583, 765, 120, 3, 70, "Input",
 CellID->26535382],
Cell[22706, 770, 254, 8, 36, "Output",
 CellID->224435811]
}, Open  ]],
Cell[CellGroupData[{
Cell[22997, 783, 124, 3, 70, "Input",
 CellID->267969406],
Cell[23124, 788, 253, 8, 36, "Output",
 CellID->345735825]
}, Open  ]],
Cell[23392, 799, 124, 3, 70, "ExampleDelimiter",
 CellID->25392021],
Cell[23519, 804, 131, 2, 70, "ExampleText",
 CellID->171106044],
Cell[CellGroupData[{
Cell[23675, 810, 267, 8, 70, "Input",
 CellID->168427058],
Cell[23945, 820, 251, 8, 36, "Output",
 CellID->355868845]
}, Open  ]],
Cell[24211, 831, 125, 3, 70, "ExampleDelimiter",
 CellID->206227907],
Cell[24339, 836, 116, 2, 70, "ExampleText",
 CellID->213309941],
Cell[CellGroupData[{
Cell[24480, 842, 310, 9, 70, "Input",
 CellID->387067767],
Cell[24793, 853, 250, 8, 36, "Output",
 CellID->52038373]
}, Open  ]],
Cell[25058, 864, 125, 3, 70, "ExampleDelimiter",
 CellID->112362973],
Cell[25186, 869, 146, 2, 70, "ExampleText",
 CellID->27928209],
Cell[CellGroupData[{
Cell[25357, 875, 167, 5, 70, "Input",
 CellID->751779630],
Cell[25527, 882, 254, 8, 36, "Output",
 CellID->225168739]
}, Open  ]],
Cell[CellGroupData[{
Cell[25818, 895, 180, 6, 70, "Input",
 CellID->632638308],
Cell[26001, 903, 255, 8, 36, "Output",
 CellID->581606379]
}, Open  ]],
Cell[26271, 914, 123, 3, 70, "ExampleDelimiter",
 CellID->4422378],
Cell[26397, 919, 144, 2, 70, "ExampleText",
 CellID->33092171],
Cell[CellGroupData[{
Cell[26566, 925, 237, 8, 70, "Input",
 CellID->12776873],
Cell[26806, 935, 251, 8, 36, "Output",
 CellID->550605044]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27106, 949, 238, 7, 70, "ExampleSection",
 CellID->7468],
Cell[27347, 958, 104, 2, 70, "ExampleText",
 CellID->139144165],
Cell[CellGroupData[{
Cell[27476, 964, 118, 3, 70, "Input",
 CellID->187066901],
Cell[27597, 969, 407, 8, 70, "Message",
 CellID->17462720],
Cell[28007, 979, 252, 8, 36, "Output",
 CellID->16773697]
}, Open  ]],
Cell[CellGroupData[{
Cell[28296, 992, 270, 8, 70, "Input",
 CellID->543728066],
Cell[28569, 1002, 251, 8, 36, "Output",
 CellID->245673847]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28869, 1016, 222, 7, 70, "ExampleSection",
 CellID->123483487],
Cell[CellGroupData[{
Cell[29116, 1027, 229, 7, 70, "ExampleSubsection",
 CellID->287251432],
Cell[29348, 1036, 142, 2, 70, "ExampleText",
 CellID->208232548],
Cell[CellGroupData[{
Cell[29515, 1042, 139, 4, 70, "Input",
 CellID->78442617],
Cell[29657, 1048, 282, 9, 36, "Output",
 CellID->287728696]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[30000, 1064, 223, 7, 70, "ExampleSection",
 CellID->12864],
Cell[30226, 1073, 99, 1, 70, "ExampleText",
 CellID->141370219],
Cell[CellGroupData[{
Cell[30350, 1078, 474, 11, 70, "Input",
 CellID->412047447],
Cell[30827, 1091, 255, 8, 36, "Output",
 CellID->773950909]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31131, 1105, 233, 7, 70, "ExampleSection",
 CellID->30845],
Cell[31367, 1114, 242, 7, 70, "ExampleText",
 CellID->294473746],
Cell[CellGroupData[{
Cell[31634, 1125, 168, 5, 70, "Input",
 CellID->244032669],
Cell[31805, 1132, 166, 5, 36, "Output",
 CellID->55998844]
}, Open  ]],
Cell[31986, 1140, 221, 7, 70, "ExampleText",
 CellID->512534639],
Cell[CellGroupData[{
Cell[32232, 1151, 104, 3, 70, "Input",
 CellID->452464721],
Cell[32339, 1156, 252, 8, 36, "Output",
 CellID->206694218]
}, Open  ]],
Cell[32606, 1167, 210, 7, 70, "ExampleText",
 CellID->221426326],
Cell[CellGroupData[{
Cell[32841, 1178, 105, 3, 70, "Input",
 CellID->56881056],
Cell[32949, 1183, 189, 5, 36, "Output",
 CellID->782973969]
}, Open  ]],
Cell[33153, 1191, 125, 3, 70, "ExampleDelimiter",
 CellID->123040038],
Cell[33281, 1196, 297, 11, 70, "ExampleText",
 CellID->17347369],
Cell[CellGroupData[{
Cell[33603, 1211, 614, 22, 70, "Input",
 CellID->111258812],
Cell[34220, 1235, 1179, 23, 70, "Output",
 Evaluatable->False,
 CellID->13752199]
}, Open  ]],
Cell[35414, 1261, 125, 3, 70, "ExampleDelimiter",
 CellID->100265182],
Cell[35542, 1266, 220, 8, 70, "ExampleText",
 CellID->206399130],
Cell[CellGroupData[{
Cell[35787, 1278, 248, 8, 70, "Input",
 CellID->484824814],
Cell[36038, 1288, 215, 7, 36, "Output",
 CellID->37865201]
}, Open  ]],
Cell[36268, 1298, 246, 8, 70, "ExampleText",
 CellID->680283911],
Cell[CellGroupData[{
Cell[36539, 1310, 279, 9, 70, "Input",
 CellID->30828526],
Cell[36821, 1321, 214, 7, 36, "Output",
 CellID->944979343]
}, Open  ]],
Cell[37050, 1331, 124, 3, 70, "ExampleDelimiter",
 CellID->78355837],
Cell[37177, 1336, 261, 9, 70, "ExampleText",
 CellID->212396129],
Cell[CellGroupData[{
Cell[37463, 1349, 304, 10, 70, "Input",
 CellID->275570032],
Cell[37770, 1361, 158, 5, 36, "Output",
 CellID->224574011]
}, Open  ]],
Cell[CellGroupData[{
Cell[37965, 1371, 273, 8, 70, "Input",
 CellID->216784907],
Cell[38241, 1381, 173, 6, 36, "Output",
 CellID->6138521]
}, Open  ]],
Cell[38429, 1390, 233, 8, 70, "ExampleText",
 CellID->192028282],
Cell[CellGroupData[{
Cell[38687, 1402, 435, 14, 70, "Input",
 CellID->100799214],
Cell[39125, 1418, 408, 13, 36, "Output",
 CellID->151828124]
}, Open  ]],
Cell[CellGroupData[{
Cell[39570, 1436, 355, 12, 70, "Input",
 CellID->453732951],
Cell[39928, 1450, 300, 9, 36, "Output",
 CellID->76563875]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40277, 1465, 225, 7, 70, "ExampleSection",
 CellID->1849],
Cell[40505, 1474, 130, 4, 70, "ExampleText",
 CellID->431104821],
Cell[CellGroupData[{
Cell[40660, 1482, 156, 5, 70, "Input",
 CellID->451847619],
Cell[40819, 1489, 402, 8, 70, "Message",
 CellID->20105854],
Cell[41224, 1499, 246, 8, 36, "Output",
 CellID->615958221]
}, Open  ]],
Cell[CellGroupData[{
Cell[41507, 1512, 166, 5, 70, "Input",
 CellID->49149522],
Cell[41676, 1519, 254, 8, 36, "Output",
 CellID->100383140]
}, Open  ]],
Cell[41945, 1530, 125, 3, 70, "ExampleDelimiter",
 CellID->802219224],
Cell[42073, 1535, 179, 7, 70, "ExampleText",
 CellID->644676629],
Cell[CellGroupData[{
Cell[42277, 1546, 154, 5, 70, "Input",
 CellID->157328957],
Cell[42434, 1553, 253, 8, 36, "Output",
 CellID->682867755]
}, Open  ]],
Cell[CellGroupData[{
Cell[42724, 1566, 164, 5, 70, "Input",
 CellID->194043702],
Cell[42891, 1573, 254, 8, 36, "Output",
 CellID->399995670]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43206, 1588, 311, 9, 70, "SeeAlsoSection",
 CellID->22443],
Cell[43520, 1599, 2699, 98, 70, "SeeAlso",
 CellID->7161]
}, Open  ]],
Cell[CellGroupData[{
Cell[46256, 1702, 314, 9, 70, "TutorialsSection",
 CellID->22050],
Cell[46573, 1713, 154, 3, 70, "Tutorials",
 CellID->31934]
}, Open  ]],
Cell[CellGroupData[{
Cell[46764, 1721, 319, 9, 70, "MoreAboutSection",
 CellID->422282704],
Cell[47086, 1732, 192, 4, 70, "MoreAbout",
 CellID->83468204],
Cell[47281, 1738, 134, 3, 70, "MoreAbout",
 CellID->493497409],
Cell[47418, 1743, 148, 3, 70, "MoreAbout",
 CellID->55090346],
Cell[47569, 1748, 169, 3, 70, "MoreAbout",
 CellID->12220518],
Cell[47741, 1753, 185, 3, 70, "MoreAbout",
 CellID->198968419]
}, Open  ]],
Cell[47941, 1759, 27, 0, 70, "History"],
Cell[47971, 1761, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

