(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25175,        729]
NotebookOptionsPosition[     21528,        608]
NotebookOutlinePosition[     22832,        645]
CellTagsIndexPosition[     22747,        640]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"DateString" :> 
         Documentation`HelpLookup["paclet:ref/DateString"], "DateFunction" :> 
         Documentation`HelpLookup["paclet:ref/DateFunction"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"DateString\"\>", 
      2->"\<\"DateFunction\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["DateTicksFormat", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["DateTicksFormat",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DateTicksFormat"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["DateListPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DateListPlot"]], "InlineFormula"],
     " which specifies how date tick labels should be formatted."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"DateTicksFormat", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " chooses tick labels based on the range of dates to be plotted."
}], "Notes",
 CellID->952775299],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"DateTicksFormat", "->", 
   RowBox[{"{", 
    RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"sep\", \"TI\"], 
StyleBox[\"12\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " concatenates date elements ",
 Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
 " with the specified separators. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->352817134]
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "Any of the date elements from ",
 Cell[BoxData[
  ButtonBox["DateString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateString"]], "InlineFormula"],
 " can be used."
}], "Notes",
 CellID->294295802],

Cell["Typical elements include:", "Notes",
 CellID->341980472],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Year\>\"", Cell[
    "full year (e.g. 2005)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<YearShort\>\"", Cell[
    "2Edigit year (e.g. 05)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<QuarterNameShort\>\"", Cell[
    "quarter of year in short form (e.g. \"Q1\")", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MonthNameShort\>\"", Cell[
    "month name in short form (e.g. \"Aug\")", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MonthNameInitial\>\"", Cell[
    "first letter of month name (e.g. \"A\")", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Month\>\"", Cell[
    "2-digit month number (e.g. 08)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MonthShort\>\"", Cell[
    "1- or 2-digit month number (e.g. 8)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DayNameShort\>\"", Cell[
    "short day of the week (e.g. \"Wed\")", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DayNameInitial\>\"", Cell[
    "first letter of day name (e.g. \"W\")", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Day\>\"", Cell[
    "2-digit day of the month (e.g. 09)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DayShort\>\"", Cell[
    "1- or 2-digit day of the month (e.g. 9 or 29)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Hour12\>\"", Cell[
    "hour on 12-hour clock", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Hour24\>\"", Cell[
    "hour on 24-hour clock", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AMPM\>\"", Cell[
    "AM or PM", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AMPMLowerCase\>\"", Cell[
    "am or pm", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Minute\>\"", Cell[
    "2-digit minute (e.g. 05)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Second\>\"", Cell[
    "2-digit seconds", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True}}}},
 CellID->28393]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->357781931],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->3116921],

Cell["Plot date-based data using default and specified ticks:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->352817134],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "10", ",", "1"}], "}"}], ",", "8"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "10", ",", "10"}], "}"}], ",", "10"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "10", ",", "20"}], "}"}], ",", "12"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "10", ",", "24"}], "}"}], ",", "14"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "11", ",", "5"}], "}"}], ",", "15"}], "}"}], ",",
      " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "11", ",", "15"}], "}"}], ",", "20"}], "}"}]}], 
    "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->351516546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"DateListPlot", "[", "data", "]"}], ",", 
   RowBox[{"DateListPlot", "[", 
    RowBox[{"data", ",", 
     RowBox[{"DateTicksFormat", "->", 
      RowBox[{"{", 
       RowBox[{"\"\<MonthShort\>\"", ",", "\"\</\>\"", ",", "\"\<Day\>\""}], 
       "}"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->371650594],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->249589195]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->52757542],

Cell["Specify both month and year information for ticks:", "ExampleText",
 CellID->53576798],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2000", ",", "7"}], "}"}], ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2001", ",", "7"}], "}"}], ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2002", ",", "7"}], "}"}], ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2003", ",", "7"}], "}"}], ",", "14"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2004", ",", "7"}], "}"}], ",", "15"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2005", ",", "7"}], "}"}], ",", "20"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->332377815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"DateListPlot", "[", "data", "]"}], ",", 
   RowBox[{"DateListPlot", "[", 
    RowBox[{"data", ",", 
     RowBox[{"DateTicksFormat", "->", 
      RowBox[{"{", 
       RowBox[{
       "\"\<MonthNameShort\>\"", ",", "\"\< \>\"", ",", "\"\<YearShort\>\""}],
        "}"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->800742312],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXc1u3DYQ1nq1/tv1Jk7Twoe49dlG+wZBDkGbU49Fz0ZQID60KdI8QXvp
oX2AAj226QO0aHLPJQYM9NqzX4QRKVGiRhQ5pChqpR0DXokUf775OBRnZqnV
l5cvn33z7eXLq6eXZ09eXH7/7OrpD2dfPH+RZc1nSTL7MUmSn0+S7JxlZ+Kf
//2U/eenmLPT7DPNqu5kx53sOFeO8+x41HJ9p8g3XTfVT3nvc4mZJStLOxdK
/iIpTpL8LwWY9xBlJX5sWd7uPqIslGvXof1jcelj/rnIWyg/RRnZbplelP0U
uXfwdXcrjPLCGl9bkRCml3HwGxCc84890IqpbqpyMQcl9ju1BrEfdGoNatfe
BkkKsQltSj6xMqLXhLv91jNoz8qpBZ6eS83t1O85vM4rLcpBKFpJcaM4YDta
HcW1s1CzZMMHgXDk+nhmGUu9Vh1jahnGdu1aX2oyEmmV2xWp0MJd0CrL1ym5
dokqDb61+uPVklaDvFqS1sShSwv7UAvlp1Mr49ZF/X3VUYOdkWann9Z7LwpD
hpF3L492tLo3IJ6aBneon9uW3NrXWX44HVi71DaM89KjHabR5EPfdlxlqTH6
mU4ap5UUIz9jzZWz2ZNtrW3WqOmTtaRaQtwBhHcC/UT1eMfzuvSB1i3XoaRH
hnL8eMEq/1O9foDMl3hgvo5xeL1cvUUhjBcua3Oz5lV2vFekd4u00CCNZapa
TX/+8V928usvb0UtFeOC0vZ0jdemFyGYriyDjOxHD3+rz9y2GV1ZDE7lsfli
DUgbpRH+vjFf4WceGLG2beM910mitEyyai5jautiN7ZZ9/VXrzJF+Pzx7zW7
im2KVgdMfwjSd0F6reep4rmkCvKs9pQUd0FXpHycl7pyrSNXZjbWa1T/1lZa
IiSWHHU9NNk+cKXPdVVdR+YC1PPv/n797//84pGocXNzU9Q47ZhesypqWe/z
+t1t3m0xJ6o6D7z6rKSU1oNxPWzoaDiZkTqvlDgOwkA7AuM9aguZUGdATPml
ZsJ+40h9nyleXkAppVQnxfFeYGnq8/l+5DH7aLCxIimnIyXNu/GMFUk5HSnH
P+/4p/R/h7BZDi39xxlL8f2eMfKojUT2yIs9FgrTY2FqJdJ58IpHCqF/Njxz
y54RujDJk3oGYdTHH5/0oo/QiPSMhUe078CUXefaYwKbonP9IaT7nBtT6j67
odZFU/9k45Bvsa1W93ZISfNuPGNFUk5HSpp34xgrGblQn2bQ7Y6JFcGw4Yjo
n++VuTmkApgrMyuR9veDtbY+EpuNrdDYFPYMvod8ugfHnL8/XPPIEXhwbHXH
o/jjAEUXHzJH5+/7avXMAR+OvXD49LrWlcUgnnhA1ihiMXzEok9bZtXSH9k2
ZG2TlJWUcjc23Js5CWmrfa6JfCAOrhtyN/1YfSrtOqiVcnKj29hfmpLsJHu0
mQ3tqA/YJsx0+R0ozIfpvjVB2kQYLENqic2PiMJbAyvG0x+KQYgFxkZSTbzE
lbWVSOPjJ+BpJKbY5BZkrsx5ITOM5CznVnlCVdhlmmdv5NMDflzioyu16I4B
hx9z7jh4f7PsyJnK2dJqYGP0u34nnuPFx1UsnngLKj8W/VHp9U97VwzOaMdY
RiAGQ64ecl8gvKvEXm3lfgwbjinbY+RpsQ0YYZI9jOw2O6NvLlD9R575Ngsi
9J0A298wdwabJRBHQyz9t2jItkUdtyOWTPtTxjNW9GQNo+9vgzPlE5+wpbs/
/9GVkdDPe2yVzqje6FAxBAuGiGw07CH4S1RR+LCiiLsnJAXHvveEwP7Inghj
+5GU05GS7PjxjBVJOR0pad6NY6zIf2bkCxFT/TPF6r+dGCm6AHoNLXn9jkm6
QbOoj/WJfiGCLCof7sjGJylp3m3TWJGU05Fy/POO/3K7+qbL2LbLgaX/eBac
+U2P/DS2vau+ZQmPalu8g5Vgp9w1V7CD++a6T770uPLZpr7nqG0sK8+7yj/t
mBaYit11ot+kvh/MhOUY5D/oAQuenfrYwvdODP1Wkk1P528cuX53m2UVL+JA
akJbuixP7xvq0jbE2/f7hpbN2uXu0qJcZR9gJOHpv5IE/TY5Wb767Wk1gvEG
pP8RpXhFt/eJxzhLZu8BuvNlbA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 136},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->119108511]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Specify formats on any time scale:", "ExampleText",
 CellID->380533905],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "13", ",", "14", ",", "17", ",", "24", ",", "26", ",", "28", ",", "29", 
     ",", "31", ",", "42", ",", "44"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\"\<1:00 PM\>\"", ",", "Automatic", ",", "\"\<Hour\>\""}], "}"}],
    ",", 
   RowBox[{"DateTicksFormat", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Hour12Short\>\"", ",", "\"\<AMPM\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->138755007],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW81u00AQ3jhOEZWbUA5tOUDzIogDAk4cEedQIbUHKCp9AK4geAAk4AR9
ASJ4gF5AitRrz7yI2V97Pd4/x961kzhS1zv22DPzze7Mjr19Ojs/fvlqdn5y
NJs+OZu9OT45ejt9fHqGTw0HCKE5/nt3gHA/xT36N09TfCy3e7iNMQOKKcl/
Q0wMRYfcjltC3xKdlP5oV8c7xp0IHyN+Xcc3ceRL+PnIkX9AyX1JY8TvKlhA
mhvZdblFu+Q4ynj52ZHhDmIzivOnV5M3qXW3RnbhjEl3yo0OivdIGJu0joE/
qunoIqH6XQ6+sDyBIXJH/Zxt+Uy5nUiyssFZfkoNX5ruJ/M08ifVYrsRNwl/
oWFk1VjmHMu+N3Jq5pP16U4YaOxgtu8tIdkdgQmU32Ek9iUKRglVRlHxiAwh
IjydmwY+nawEWKjjY5lDlzF3cPsVc21nlMgRP75f4c6nj5clD40BvWO53gh/
KXPdzDRmaD5/doEPjx5+6Ya+YBzl2gpL/v75d/r65+9f11zfxWLB+e8B+tBy
ndKjjC7hI+vCRij27YP7n4lv4bPryiK20pUG8QeWQfyxlAyJzvFjKV/8hGkj
pY0Y3xezC4JvkzYq1zAwekn0rkWWb12GmT9q6sBpEa06ikZhrRcpxoZ3DUpx
aotrcrtBL6TFWSFlkphLiwPaDWMMlMWu5zFn3LBsFbpMZh6DlpKpRNvN2jy6
N21tSK/6HbehrVkf5MQ6L3SEo8EMKeqjbsR8jTZ+c6Cc81DLeHRJF7Ql+0Xv
nXC5UVRKIWfMesWdPmKvA3J3KZ2vx6YekGMy8vWXkwxtriu+z7fNXyY7r//q
2CckS8TGVnu26q6tTJfy8VI1rsO6xPYexjxOTKsQUZXZ4gusWpw08lYTwkqm
Dj59NA+FHKP1b/iaQI7R+jd8zSHHaP27PJ9jLgFIKsd/w2MwAcja5pwUnRtc
4SYCddPMX4EaxEUXvzmz8JWHdAt5IuRbOrdauY42cF15WNMzy8wfuO6E1/3M
F7jiNFneZ8J+DdEjVwc5sW9K9e0vaM1hodvWJVxmg17YrO9+5T0u/r/5DVE3
v/WtViTpY3CPXGjk2o9X/iuBKtrEWQKRFKIxzXf+AtVHa5VZd2pEuybrPjea
jjXKvS+eY49t74u/KK7c+7IRUX318+GH93M2RpXIyf+P0pn9tXx8Ay8UYhbc
kd3a3mU2I0rYfsso3Q7t+i0a/AeE3iSo\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 128},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->443641049]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->680923742],

Cell["Give date formats for ticks at specific positions:", "ExampleText",
 CellID->351032184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"Range", "[", "10", "]"}], ",", 
   RowBox[{"{", "2000", "}"}], ",", 
   RowBox[{"DateTicksFormat", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Month\>\"", ",", "\"\</\>\"", ",", "\"\<Year\>\""}], 
     "}"}]}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2002", ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2006", ",", "9"}], "}"}]}], "}"}], ",", "Automatic", ",", 
      "Automatic", ",", "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->385800790],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmc1uEzEQx53sJi0HDnyooiqCSAVUCkECzlUPCBBIHBHnqEJqD1BU+gyc
4AEqcYT2wo0IHoBLkSJx5cyLGNuz3llP7LW9m7Ib1Ejxxl7Pb8azf0+y2Wej
/e2Xr0b7O1ujweO90Zvtna23g0e7e2Io6TDGxuL97hITn7n4pN5jzsUR2nuy
TeSoerGnpK/Os/ueWXfVrJui7YrBrjjKkwmZlWbnutk5PVeODwt9eUwDbPXx
qvK+pqdlFhnDGFER9WAkbxVX+8r7/aIdtLdLeflgjBdHX368XLYqu09jnpU/
ZTe02iXOtblyM9vVpCU0G53218uirOUtZm0uLcfy//HqSnYUjSTluGvrZLB0
RSQTwf6MyAe8WKHSwlHPY0zvI1uNuUP6Pa+l9nFFzRg72n6BdyiOHTXam4qf
amid9J9YzndUXCfPklOBMZlMDAb217J54fG4WfFrC2EVr0Q1wtmMcMtjoVUI
FtV9NWKZ1ZfPn35tbhx8eP8DqkRUfljy4vmhsH744KPXmuQq8/7z+M/u66/f
v/2O9D5fuW6/luReSWvvumLlpqRzqo9qWwomLxCSrMuyC0RUoI+IlWuREOm3
E5BRm+Gx+sinFbG9u7RoucpNtabRmbrGTXX6CO7MQSyoxrhYms5kOzVmqylN
k0JrMHhEbW6WEos1WfZtv/GAiFqlRKycoZUEiKhZd4z1a9PsrsB8aLeNlsvc
1OQwOlNAQA1SQnjmgITaK4+lbZlsh8bq78pm7w4hR6jHlUi2rUoCExVKmead
cRKQPSCiUt1R9gmpei4XuP2/rP9NwSdnucFNbZ2JXi8QUEmUEL5+IKGCymNp
WybnXSltqJJwh4lqvO5hh/zHB0zU5yqP/f1nJ6JOfVE2/51zes88a8uL3FTq
hehMAQF1eb5y5oCEejRjaXsmm9EYbCb90k9wqu+P6Wc7Qc/LGmLfUMRcvZGe
sOriOH06ozxk6lbkWivx+Elz7Ueu5Aguf8JzLejnZF/UkOv5WJ2Wdf4CpayV
DA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->175910648]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12164870]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DateTicksFormat - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 37.2867710}", "context" -> "System`", 
    "keywords" -> {"date ticks", "tick formatting"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DateTicksFormat is an option for DateListPlot which specifies how date \
tick labels should be formatted.", "synonyms" -> {"date ticks format"}, 
    "title" -> "DateTicksFormat", "type" -> "Symbol", "uri" -> 
    "ref/DateTicksFormat"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7783, 219, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->357781931]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22604, 633}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 679, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1302, 43, 1580, 37, 70, "ObjectNameGrid"],
Cell[2885, 82, 629, 18, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3551, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4029, 122, 277, 8, 70, "Notes",
 CellID->952775299],
Cell[4309, 132, 739, 21, 70, "Notes",
 CellID->1067943069],
Cell[5051, 155, 223, 8, 70, "Notes",
 CellID->294295802],
Cell[5277, 165, 62, 1, 70, "Notes",
 CellID->341980472],
Cell[5342, 168, 2404, 46, 70, "2ColumnTableMod",
 CellID->28393]
}, Closed]],
Cell[CellGroupData[{
Cell[7783, 219, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->357781931],
Cell[CellGroupData[{
Cell[8168, 233, 146, 5, 70, "ExampleSection",
 CellID->3116921],
Cell[8317, 240, 146, 2, 70, "ExampleText",
 CellID->352817134],
Cell[8466, 244, 995, 36, 70, "Input",
 CellID->351516546],
Cell[CellGroupData[{
Cell[9486, 284, 375, 11, 47, "Input",
 CellID->371650594],
Cell[9864, 297, 2270, 41, 156, "Output",
 Evaluatable->False,
 CellID->249589195]
}, Open  ]],
Cell[12149, 341, 124, 3, 70, "ExampleDelimiter",
 CellID->52757542],
Cell[12276, 346, 92, 1, 70, "ExampleText",
 CellID->53576798],
Cell[12371, 349, 893, 31, 70, "Input",
 CellID->332377815],
Cell[CellGroupData[{
Cell[13289, 384, 393, 12, 47, "Input",
 CellID->800742312],
Cell[13685, 398, 2376, 43, 157, "Output",
 Evaluatable->False,
 CellID->119108511]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16110, 447, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[16334, 456, 77, 1, 70, "ExampleText",
 CellID->380533905],
Cell[CellGroupData[{
Cell[16436, 461, 514, 15, 70, "Input",
 CellID->138755007],
Cell[16953, 478, 1465, 28, 70, "Output",
 Evaluatable->False,
 CellID->443641049]
}, Open  ]],
Cell[18433, 509, 125, 3, 70, "ExampleDelimiter",
 CellID->680923742],
Cell[18561, 514, 93, 1, 70, "ExampleText",
 CellID->351032184],
Cell[CellGroupData[{
Cell[18679, 519, 674, 20, 70, "Input",
 CellID->385800790],
Cell[19356, 541, 1254, 25, 70, "Output",
 Evaluatable->False,
 CellID->175910648]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20671, 573, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[20990, 584, 466, 17, 70, "SeeAlso",
 CellID->12164870]
}, Open  ]],
Cell[21471, 604, 27, 0, 70, "History"],
Cell[21501, 606, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

