(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16041,        559]
NotebookOptionsPosition[     12280,        434]
NotebookOutlinePosition[     13735,        472]
CellTagsIndexPosition[     13650,        467]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Automatic Loading of Packages" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AutomaticLoadingOfPackages"], 
          "Mathematica Packages" :> 
          Documentation`HelpLookup["paclet:tutorial/MathematicaPackages"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Automatic Loading of Packages\"\>", 
       2->"\<\"Mathematica Packages\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Needs" :> Documentation`HelpLookup["paclet:ref/Needs"], 
          "$NewSymbol" :> Documentation`HelpLookup["paclet:ref/$NewSymbol"], 
          "$Packages" :> Documentation`HelpLookup["paclet:ref/$Packages"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Needs\"\>", 
       2->"\<\"$NewSymbol\"\>", 3->"\<\"$Packages\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:guide/Attributes"], 
          "Package Development" :> 
          Documentation`HelpLookup["paclet:guide/PackageDevelopment"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Package Development\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DeclarePackage", "ObjectName",
 CellID->31720],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DeclarePackage",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DeclarePackage"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"context\", \"TI\"]`\)]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"name\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"name\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]declares that ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Needs",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Needs"], "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"context\", \"TI\"]`\)]\)\>\"", "]"}]], "InlineFormula"],
     " should automatically be executed if a symbol with any of the specified \
names is ever used. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16237]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["DeclarePackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DeclarePackage"]], "InlineFormula"],
 " to tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically to load a particular package when any of the symbols defined \
in it are used. "
}], "Notes",
 CellID->28264],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DeclarePackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DeclarePackage"]], "InlineFormula"],
 " creates symbols with the attribute ",
 Cell[BoxData[
  ButtonBox["Stub",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Stub"]], "InlineFormula"],
 " in the specified context. "
}], "Notes",
 CellID->709],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DeclarePackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DeclarePackage"]], "InlineFormula"],
 " prepends ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["context", "TI"], "`"}]]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30703]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3428856],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->251378900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclarePackage", "[", 
  RowBox[{"\"\<BarCharts`\>\"", ",", "\"\<BarChart\>\""}], "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->622561236],

Cell[BoxData["\<\"BarCharts`\"\>"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147953006]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "\"\<BarChart\>\"", "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[2]:=",
 CellID->923321450],

Cell[BoxData[
 RowBox[{"{", "Stub", "}"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3904557]
}, Open  ]],

Cell["\<\
Use of the symbol implies reading the corresponding package automatically:\
\>", "ExampleText",
 CellID->929089169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "2"}], "}"}], "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[3]:=",
 CellID->532787260],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW71OwzAQdmn4Z2BkLAxUAolCgRWYYGJiRAxVhdQOCFQKc1+ElQerxCMw
h7vEAeeSKE5o3Ut7VWvnbN/dZ+d6/eI0t51h7/GpM+x3O42bQeel1+++Nq6f
B9BUrymlvuHzsaPg2Iej4PPt+1CbZQvKOnS1ofZ0jfI59uKBH7xUIxh9TFrb
hqxStNpWVk6JfEbkY41tN1Wbjj6BYglE0ypi27PSpojb2lq6NvpS3p+cXIGT
mH5LS2cGxuzVNs+TqutpRIfGaLS0TNrG4fAYNi+B1nOs9RVOoKD99UBuHd09
3H/CW+1jgbLu3yD9zaB/NBrF9EEu1E/sVxW1ETcrfhh1NFZ4IN3W6Ki32aHh
uUaCquqoJMoFlcSToBJUEuWTQ5V1hYAyX9YX59CrBONSRTGjWBWs3NcX47Yq
8Usx8r8mXNWryxOp5H1BJfEkqARVUVR8GAjfNRJUkjUnxwPDKnxRXs2Xv1Kk
ATWswH2N+caNDWtQH4C5LUa4zBGXC43L5r6aGyRRdr5y5m02cxSvLjjjvM9x
kbxKVhCvkhXKM/esOyducFHms0Jk2s8HlbuIqcYaYYDxiSPKl2fPn7PuQbhB
sgg5btG8CvMRr5IVxGvc67xnBc9y59kNmohXGwKDfTuu+4mJZzpScWHDBdSH
YG7Twi+O2ypg3xzxlmP/SqslbEzCqsXuqp2l6Hv/bj26nA/+WqjEE5lLrXmL
hWmfVfqbkrUnYpstwios8/6NaGez6B6AnVWaL+l8o32OctZQ/s8qmhk27z+H
xTNu1vU4n6ishpbkGt7zmfZZrSu7Z3XL5ZBJMbipMUMjoyyn2sSGYWQLCDG8
VROL3Byfz9rHJec2/j1zWbwzHJF8kl7VfgByQqeO\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{245, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->353949291]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19570],

Cell["The named context is prepended to the search path:", "ExampleText",
 CellID->150170874],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeclarePackage", "[", 
  RowBox[{"\"\<Histograms`\>\"", ",", "\"\<Histogram\>\""}], "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->121535974],

Cell[BoxData["\<\"Histograms`\"\>"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33406901]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 CellContext->"Global`",
 CellLabel->"In[2]:=",
 CellID->43324775],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Histograms`\"\>", ",", "\<\"PacletManager`\"\>", 
   ",", "\<\"System`\"\>", ",", "\<\"Global`\"\>"}], "}"}]], "Output",
 ImageSize->{325, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->48050129]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12344],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Needs",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Needs"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$NewSymbol",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$NewSymbol"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Packages",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Packages"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17427]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32544],

Cell[TextData[ButtonBox["Automatic Loading of Packages",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AutomaticLoadingOfPackages"]], "Tutorials",
 CellID->32050],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaPackages"],
  FontSlant->"Italic"],
 ButtonBox[" Packages",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaPackages"]
}], "Tutorials",
 CellID->401900652]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "MoreAbout",
 CellID->158870601],

Cell[TextData[ButtonBox["Package Development",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageDevelopment"]], "MoreAbout",
 CellID->6417593]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DeclarePackage - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 42.9431658}", "context" -> "System`", 
    "keywords" -> {"autoload package", "stub", "load on-demand functions"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "DeclarePackage[\"StyleBox[ context`]\", {\"SubscriptBox[ name, 1]\", \
\"SubscriptBox[ name, 2]\", ...}] declares that Needs[\"StyleBox[ \
context`]\"] should automatically be executed if a symbol with any of the \
specified names is ever used. ", "synonyms" -> {"declare package"}, "title" -> 
    "DeclarePackage", "type" -> "Symbol", "uri" -> "ref/DeclarePackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5735, 188, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->3428856]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13509, 460}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2226, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2849, 80, 52, 1, 70, "ObjectName",
 CellID->31720],
Cell[2904, 83, 1135, 33, 70, "Usage",
 CellID->16237]
}, Open  ]],
Cell[CellGroupData[{
Cell[4076, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4554, 138, 353, 12, 70, "Notes",
 CellID->28264],
Cell[4910, 152, 356, 12, 70, "Notes",
 CellID->709],
Cell[5269, 166, 429, 17, 70, "Notes",
 CellID->30703]
}, Closed]],
Cell[CellGroupData[{
Cell[5735, 188, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3428856],
Cell[CellGroupData[{
Cell[6118, 202, 148, 5, 70, "ExampleSection",
 CellID->251378900],
Cell[CellGroupData[{
Cell[6291, 211, 190, 5, 28, "Input",
 CellID->622561236],
Cell[6484, 218, 175, 5, 36, "Output",
 CellID->147953006]
}, Open  ]],
Cell[CellGroupData[{
Cell[6696, 228, 146, 4, 28, "Input",
 CellID->923321450],
Cell[6845, 234, 181, 6, 36, "Output",
 CellID->3904557]
}, Open  ]],
Cell[7041, 243, 125, 3, 70, "ExampleText",
 CellID->929089169],
Cell[CellGroupData[{
Cell[7191, 250, 196, 6, 28, "Input",
 CellID->532787260],
Cell[7390, 258, 1107, 22, 178, "Output",
 Evaluatable->False,
 CellID->353949291]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8546, 286, 233, 7, 70, "ExampleSection",
 CellID->19570],
Cell[8782, 295, 93, 1, 70, "ExampleText",
 CellID->150170874],
Cell[CellGroupData[{
Cell[8900, 300, 192, 5, 70, "Input",
 CellID->121535974],
Cell[9095, 307, 175, 5, 36, "Output",
 CellID->33406901]
}, Open  ]],
Cell[CellGroupData[{
Cell[9307, 317, 105, 3, 70, "Input",
 CellID->43324775],
Cell[9415, 322, 294, 8, 36, "Output",
 CellID->48050129]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9770, 337, 311, 9, 70, "SeeAlsoSection",
 CellID->12344],
Cell[10084, 348, 696, 26, 70, "SeeAlso",
 CellID->17427]
}, Open  ]],
Cell[CellGroupData[{
Cell[10817, 379, 314, 9, 70, "TutorialsSection",
 CellID->32544],
Cell[11134, 390, 166, 3, 70, "Tutorials",
 CellID->32050],
Cell[11303, 395, 284, 9, 70, "Tutorials",
 CellID->401900652]
}, Open  ]],
Cell[CellGroupData[{
Cell[11624, 409, 299, 8, 70, "MoreAboutSection"],
Cell[11926, 419, 132, 3, 70, "MoreAbout",
 CellID->158870601],
Cell[12061, 424, 147, 3, 70, "MoreAbout",
 CellID->6417593]
}, Open  ]],
Cell[12223, 430, 27, 0, 70, "History"],
Cell[12253, 432, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

