(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38121,       1436]
NotebookOptionsPosition[     30830,       1176]
NotebookOutlinePosition[     32148,       1214]
CellTagsIndexPosition[     32062,       1209]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Operations on Polynomials" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicOperationsOnPolynomials"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Algebraic Operations on Polynomials\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FactorList" :> 
          Documentation`HelpLookup["paclet:ref/FactorList"], "Solve" :> 
          Documentation`HelpLookup["paclet:ref/Solve"], "Factor" :> 
          Documentation`HelpLookup["paclet:ref/Factor"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FactorList\"\>", 2->"\<\"Solve\"\>", 
       3->"\<\"Factor\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polynomial Algebra" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialAlgebra"], 
          "Polynomial Factoring & Decomposition" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialFactoring"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Polynomial Algebra\"\>", 
       2->"\<\"Polynomial Factoring & Decomposition\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Decompose", "ObjectName",
 CellID->205],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Decompose",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Decompose"], "[", 
       RowBox[{
        StyleBox["poly", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]decomposes a polynomial, if possible, into a \
composition of simpler polynomials. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20050]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Decompose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Decompose"]], "InlineFormula"],
 " gives a list of the polynomials ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["P", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " which can be composed as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["P", "1"], " ", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["P", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"\[Ellipsis]", " ", "x", " ", "\[Ellipsis]"}], ")"}]}], 
     ")"}]}], TraditionalForm]], "InlineMath"],
 " to give the original polynomial. "
}], "Notes",
 CellID->14642],

Cell[TextData[{
 "The set of polynomials ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["P", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is not necessarily unique. "
}], "Notes",
 CellID->19254],

Cell["\<\
Decomposition is an operation which is independent of polynomial \
factorization. \
\>", "Notes",
 CellID->30318]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->366065493],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->570290848],

Cell["Represent a polynomial as a composition of polynomials:", "ExampleText",
 CellID->128261774],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Decompose", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->263998301],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", "x"}], ",", 
   SuperscriptBox["x", "2"]}], "}"}]], "Output",
 ImageSize->{69, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->645332878]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2410],

Cell["A composition of more than two polynomials:", "ExampleText",
 CellID->1021958934],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Decompose", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", "1"}], ")"}], "^", "4"}], "+", "3"}], 
   ",", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->557775959],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"4", "+", 
    RowBox[{"2", " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], ",", 
   SuperscriptBox["x", "2"]}], "}"}]], "Output",
 ImageSize->{157, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->414416805]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->240657636],

Cell["No decomposition:", "ExampleText",
 CellID->104152810],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Decompose", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->306645293],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", "+", 
   RowBox[{"2", " ", "x"}]}], "}"}]], "Output",
 ImageSize->{55, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->409894521]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->258492896],

Cell["A polynomial with symbolic coefficients:", "ExampleText",
 CellID->14207263],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Decompose", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"x", "^", "3"}]}], "+", "1"}], ")"}], "^", "2"}], "+", "b"}], 
   ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->514521192],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", "b", "+", 
    RowBox[{"2", " ", "a", " ", "x"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["x", "2"]}]}], ",", 
   SuperscriptBox["x", "3"]}], "}"}]], "Output",
 ImageSize->{149, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27712198]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16552],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->15874],

Cell["Decompose a polynomial over integers modulo 2:", "ExampleText",
 CellID->16601269],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Decompose", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "3"}], "+", 
    RowBox[{"2", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"4", "x"}], "+", "7"}], ",", "x", ",", 
   RowBox[{"Modulus", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->476176640],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", "x"}], ",", 
   SuperscriptBox["x", "3"]}], "}"}]], "Output",
 ImageSize->{69, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65165075]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16977],

Cell["\<\
Solve some polynomial equations of degrees higher than 4 in terms of \
radicals: \
\>", "ExampleText",
 CellID->204000856],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"x", "^", "8"}], "+", 
    RowBox[{"4", 
     RowBox[{"x", "^", "7"}]}], "+", 
    RowBox[{"2", 
     RowBox[{"x", "^", "6"}]}], "-", 
    RowBox[{"8", 
     RowBox[{"x", "^", "5"}]}], "-", 
    RowBox[{"5", 
     RowBox[{"x", "^", "4"}]}], "+", 
    RowBox[{"8", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"2", 
     RowBox[{"x", "^", "2"}]}], "-", 
    RowBox[{"4", "x"}], "+", "8"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->66185092],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "=", 
  RowBox[{"Decompose", "[", 
   RowBox[{"f", ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->177190734],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"8", "+", 
    RowBox[{"2", " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{"x", "+", 
    SuperscriptBox["x", "2"]}]}], "}"}]], "Output",
 ImageSize->{185, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->294756400]
}, Open  ]],

Cell[TextData[{
 "Solve ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"a", "(", 
     RowBox[{"b", "(", 
      RowBox[{"c", "(", "x", ")"}], ")"}], ")"}], "\[LongEqual]", "0"}], 
   TraditionalForm]], "InlineMath"],
 " by solving ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"a", "(", "y", ")"}], "\[LongEqual]", "0"}], TraditionalForm]], 
  "InlineMath"],
 " and then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"b", "(", "z", ")"}], "\[LongEqual]", 
    SubscriptBox["y", "i"]}], TraditionalForm]], "InlineMath"],
 " etc:"
}], "ExampleText",
 CellID->99152632],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s1", "=", 
  RowBox[{"x", "/.", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"a", "\[Equal]", "0"}], ",", "x"}], "]"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->237439286],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "-", 
    RowBox[{"\[ImaginaryI]", " ", 
     SqrtBox["7"]}]}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"\[ImaginaryI]", " ", 
     SqrtBox["7"]}]}]}], "}"}]], "Output",
 ImageSize->{154, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->636294231]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s2", "=", 
  RowBox[{"Join", "@@", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "/.", 
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{"b", "\[Equal]", "#"}], ",", "x"}], "]"}]}], "&"}], "/@", 
     "s1"}], ")"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->336080310],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"3", "/", "4"}]], " ", 
     SuperscriptBox["7", 
      RowBox[{"1", "/", "4"}]]}]}], ",", 
   RowBox[{"1", "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"3", "/", "4"}]], " ", 
     SuperscriptBox["7", 
      RowBox[{"1", "/", "4"}]]}]}], ",", 
   RowBox[{"1", "-", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "7"}], ")"}], 
     RowBox[{"1", "/", "4"}]]}], ",", 
   RowBox[{"1", "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "7"}], ")"}], 
     RowBox[{"1", "/", "4"}]]}]}], "}"}]], "Output",
 ImageSize->{358, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->18222420]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s3", "=", 
  RowBox[{"Join", "@@", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "/.", 
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{"c", "\[Equal]", "#"}], ",", "x"}], "]"}]}], "&"}], "/@", 
     "s2"}], ")"}]}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->71934201],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      SqrtBox[
       RowBox[{"5", "-", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], 
          RowBox[{"3", "/", "4"}]], " ", 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]}]}]]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox[
       RowBox[{"5", "-", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], 
          RowBox[{"3", "/", "4"}]], " ", 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]}]}]]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      SqrtBox[
       RowBox[{"5", "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], 
          RowBox[{"3", "/", "4"}]], " ", 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]}]}]]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox[
       RowBox[{"5", "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], 
          RowBox[{"3", "/", "4"}]], " ", 
         SuperscriptBox["7", 
          RowBox[{"1", "/", "4"}]]}]}]]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      SqrtBox[
       RowBox[{"5", "-", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "7"}], ")"}], 
          RowBox[{"1", "/", "4"}]]}]}]]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox[
       RowBox[{"5", "-", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "7"}], ")"}], 
          RowBox[{"1", "/", "4"}]]}]}]]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      SqrtBox[
       RowBox[{"5", "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "7"}], ")"}], 
          RowBox[{"1", "/", "4"}]]}]}]]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox[
       RowBox[{"5", "+", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "7"}], ")"}], 
          RowBox[{"1", "/", "4"}]]}]}]]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{536, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->57590296]
}, Open  ]],

Cell[TextData[{
 "Check that these indeed are the roots of ",
 Cell[BoxData["f"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->301715197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "/.", 
     RowBox[{"x", "\[Rule]", "#"}]}], "&"}], "/@", "s3"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->259633829],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}],
   "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->353588732]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " solvers use ",
 Cell[BoxData[
  ButtonBox["Decompose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Decompose"]], "InlineFormula"],
 " automatically:"
}], "ExampleText",
 CellID->467328337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"f", "\[Equal]", "0"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->225713298],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{447, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->616553177]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13697],

Cell[TextData[{
 "Composition of polynomials given by ",
 Cell[BoxData[
  ButtonBox["Decompose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Decompose"]], "InlineFormula"],
 " gives the original polynomial:"
}], "ExampleText",
 CellID->54014377],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", "1"}], ")"}], "^", "4"}], "+", "3"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->260380564],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Decompose", "[", 
  RowBox[{"f", ",", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->220481216],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"4", "+", 
    RowBox[{"2", " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], ",", 
   SuperscriptBox["x", "2"]}], "}"}]], "Output",
 ImageSize->{157, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->608038100]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Fold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fold"]], "InlineFormula"],
 " to compose the polynomials:"
}], "ExampleText",
 CellID->63001716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fold", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#2", "/.", 
     RowBox[{"x", "\[Rule]", "#1"}]}], "&"}], ",", "x", ",", 
   RowBox[{"Reverse", "[", "%", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->381844410],

Cell[BoxData[
 RowBox[{"4", "+", 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     SuperscriptBox["x", "4"]}], ")"}]}], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     SuperscriptBox["x", "4"]}], ")"}], "2"]}]], "Output",
 ImageSize->{175, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->567885002]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " to show that the result is equal to ",
 Cell[BoxData["f"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->687287231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{"%", "\[Equal]", "f"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->168628878],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->699273259]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4479638],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " to represent a polynomial as a product of irreducible factors:"
}], "ExampleText",
 CellID->1722420],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"3", "x"}], "+", "2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{
    RowBox[{"x", "^", "4"}], "-", 
    RowBox[{"x", "^", "2"}], "+", "17"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->555354344],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{"{", 
   RowBox[{"f", ",", "g"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->86387809],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", "x"}], ")"}]}], ",", 
   RowBox[{"17", "-", 
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["x", "4"]}]}], "}"}]], "Output",
 ImageSize->{178, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->238537855]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["f"], "InlineFormula"],
 " can be factored but not decomposed; ",
 Cell[BoxData["g"], "InlineFormula"],
 " can be decomposed but not factored:"
}], "ExampleText",
 CellID->533463438],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Decompose", "[", 
  RowBox[{"f", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->252502950],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", "+", 
   RowBox[{"3", " ", "x"}], "+", 
   SuperscriptBox["x", "2"]}], "}"}]], "Output",
 ImageSize->{80, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->518283851]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Decompose", "[", 
  RowBox[{"g", ",", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->291012304],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"17", "-", "x", "+", 
    SuperscriptBox["x", "2"]}], ",", 
   SuperscriptBox["x", "2"]}], "}"}]], "Output",
 ImageSize->{101, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->203373838]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15370],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Decompose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Decompose"]], "InlineFormula"],
 " ignores possible decompositions with inner polynomials that are linear:"
}], "ExampleText",
 CellID->380691151],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Decompose", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "1"}], ")"}], "^", "3"}], "+", "1"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->200644367],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", "+", 
   RowBox[{"3", " ", "x"}], "+", 
   RowBox[{"3", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   SuperscriptBox["x", "3"]}], "}"}]], "Output",
 ImageSize->{115, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->94265309]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14754],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FactorList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Solve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Solve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Factor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Factor"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3171]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1390],

Cell[TextData[ButtonBox["Algebraic Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicOperationsOnPolynomials"]], "Tutorials",\

 CellID->18724]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->34596248],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "MoreAbout",
 CellID->258062253],

Cell[TextData[ButtonBox["Polynomial Factoring & Decomposition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialFactoring"]], "MoreAbout",
 CellID->45409766]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Decompose - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 43.2244230}", "context" -> "System`", 
    "keywords" -> {
     "decompose polynomial", "decomposition of polynomials", 
      "nested polynomials"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Decompose[poly, x] decomposes a polynomial, if possible, into a \
composition of simpler polynomials. ", "synonyms" -> {}, "title" -> 
    "Decompose", "type" -> "Symbol", "uri" -> "ref/Decompose"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4948, 167, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->366065493]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 31919, 1202}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2156, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2779, 80, 45, 1, 70, "ObjectName",
 CellID->205],
Cell[2827, 83, 584, 18, 70, "Usage",
 CellID->20050]
}, Open  ]],
Cell[CellGroupData[{
Cell[3448, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3926, 123, 652, 23, 70, "Notes",
 CellID->14642],
Cell[4581, 148, 204, 8, 70, "Notes",
 CellID->19254],
Cell[4788, 158, 123, 4, 70, "Notes",
 CellID->30318]
}, Closed]],
Cell[CellGroupData[{
Cell[4948, 167, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->366065493],
Cell[CellGroupData[{
Cell[5333, 181, 148, 5, 70, "ExampleSection",
 CellID->570290848],
Cell[5484, 188, 98, 1, 70, "ExampleText",
 CellID->128261774],
Cell[CellGroupData[{
Cell[5607, 193, 177, 6, 28, "Input",
 CellID->263998301],
Cell[5787, 201, 252, 9, 39, "Output",
 CellID->645332878]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6088, 216, 215, 7, 70, "ExampleSection",
 CellID->2410],
Cell[6306, 225, 87, 1, 70, "ExampleText",
 CellID->1021958934],
Cell[CellGroupData[{
Cell[6418, 230, 267, 10, 70, "Input",
 CellID->557775959],
Cell[6688, 242, 399, 14, 39, "Output",
 CellID->414416805]
}, Open  ]],
Cell[7102, 259, 125, 3, 70, "ExampleDelimiter",
 CellID->240657636],
Cell[7230, 264, 60, 1, 70, "ExampleText",
 CellID->104152810],
Cell[CellGroupData[{
Cell[7315, 269, 177, 6, 70, "Input",
 CellID->306645293],
Cell[7495, 277, 227, 8, 36, "Output",
 CellID->409894521]
}, Open  ]],
Cell[7737, 288, 125, 3, 70, "ExampleDelimiter",
 CellID->258492896],
Cell[7865, 293, 82, 1, 70, "ExampleText",
 CellID->14207263],
Cell[CellGroupData[{
Cell[7972, 298, 291, 11, 70, "Input",
 CellID->514521192],
Cell[8266, 311, 386, 13, 39, "Output",
 CellID->27712198]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8701, 330, 218, 7, 70, "ExampleSection",
 CellID->16552],
Cell[CellGroupData[{
Cell[8944, 341, 224, 7, 70, "ExampleSubsection",
 CellID->15874],
Cell[9171, 350, 88, 1, 70, "ExampleText",
 CellID->16601269],
Cell[CellGroupData[{
Cell[9284, 355, 309, 10, 70, "Input",
 CellID->476176640],
Cell[9596, 367, 251, 9, 39, "Output",
 CellID->65165075]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[9908, 383, 223, 7, 70, "ExampleSection",
 CellID->16977],
Cell[10134, 392, 132, 4, 70, "ExampleText",
 CellID->204000856],
Cell[10269, 398, 524, 19, 70, "Input",
 CellID->66185092],
Cell[CellGroupData[{
Cell[10818, 421, 209, 7, 70, "Input",
 CellID->177190734],
Cell[11030, 430, 445, 16, 39, "Output",
 CellID->294756400]
}, Open  ]],
Cell[11490, 449, 586, 23, 70, "ExampleText",
 CellID->99152632],
Cell[CellGroupData[{
Cell[12101, 476, 208, 7, 70, "Input",
 CellID->237439286],
Cell[12312, 485, 396, 15, 43, "Output",
 CellID->636294231]
}, Open  ]],
Cell[CellGroupData[{
Cell[12745, 505, 329, 12, 70, "Input",
 CellID->336080310],
Cell[13077, 519, 885, 33, 39, "Output",
 CellID->18222420]
}, Open  ]],
Cell[CellGroupData[{
Cell[13999, 557, 328, 12, 70, "Input",
 CellID->71934201],
Cell[14330, 571, 3055, 111, 116, "Output",
 CellID->57590296]
}, Open  ]],
Cell[17400, 685, 143, 5, 70, "ExampleText",
 CellID->301715197],
Cell[CellGroupData[{
Cell[17568, 694, 204, 7, 70, "Input",
 CellID->259633829],
Cell[17775, 703, 270, 9, 36, "Output",
 CellID->353588732]
}, Open  ]],
Cell[18060, 715, 261, 10, 70, "ExampleText",
 CellID->467328337],
Cell[CellGroupData[{
Cell[18346, 729, 155, 5, 70, "Input",
 CellID->225713298],
Cell[18504, 736, 3523, 62, 70, "Output",
 Evaluatable->False,
 CellID->616553177]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22076, 804, 233, 7, 70, "ExampleSection",
 CellID->13697],
Cell[22312, 813, 250, 8, 70, "ExampleText",
 CellID->54014377],
Cell[22565, 823, 243, 10, 70, "Input",
 CellID->260380564],
Cell[CellGroupData[{
Cell[22833, 837, 133, 4, 70, "Input",
 CellID->220481216],
Cell[22969, 843, 399, 14, 39, "Output",
 CellID->608038100]
}, Open  ]],
Cell[23383, 860, 205, 8, 70, "ExampleText",
 CellID->63001716],
Cell[CellGroupData[{
Cell[23613, 872, 247, 8, 70, "Input",
 CellID->381844410],
Cell[23863, 882, 498, 18, 41, "Output",
 CellID->567885002]
}, Open  ]],
Cell[24376, 903, 263, 10, 70, "ExampleText",
 CellID->687287231],
Cell[CellGroupData[{
Cell[24664, 917, 132, 4, 70, "Input",
 CellID->168628878],
Cell[24799, 923, 161, 5, 36, "Output",
 CellID->699273259]
}, Open  ]],
Cell[24975, 931, 123, 3, 70, "ExampleDelimiter",
 CellID->4479638],
Cell[25101, 936, 243, 8, 70, "ExampleText",
 CellID->1722420],
Cell[25347, 946, 327, 12, 70, "Input",
 CellID->555354344],
Cell[CellGroupData[{
Cell[25699, 962, 148, 5, 70, "Input",
 CellID->86387809],
Cell[25850, 969, 417, 15, 39, "Output",
 CellID->238537855]
}, Open  ]],
Cell[26282, 987, 212, 6, 70, "ExampleText",
 CellID->533463438],
Cell[CellGroupData[{
Cell[26519, 997, 128, 4, 70, "Input",
 CellID->252502950],
Cell[26650, 1003, 262, 9, 39, "Output",
 CellID->518283851]
}, Open  ]],
Cell[CellGroupData[{
Cell[26949, 1017, 133, 4, 70, "Input",
 CellID->291012304],
Cell[27085, 1023, 290, 10, 39, "Output",
 CellID->203373838]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27424, 1039, 226, 7, 70, "ExampleSection",
 CellID->15370],
Cell[27653, 1048, 251, 7, 70, "ExampleText",
 CellID->380691151],
Cell[CellGroupData[{
Cell[27929, 1059, 233, 9, 70, "Input",
 CellID->200644367],
Cell[28165, 1070, 322, 11, 39, "Output",
 CellID->94265309]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28548, 1088, 311, 9, 70, "SeeAlsoSection",
 CellID->14754],
Cell[28862, 1099, 689, 26, 70, "SeeAlso",
 CellID->3171]
}, Open  ]],
Cell[CellGroupData[{
Cell[29588, 1130, 313, 9, 70, "TutorialsSection",
 CellID->1390],
Cell[29904, 1141, 180, 4, 70, "Tutorials",
 CellID->18724]
}, Open  ]],
Cell[CellGroupData[{
Cell[30121, 1150, 318, 9, 70, "MoreAboutSection",
 CellID->34596248],
Cell[30442, 1161, 147, 3, 70, "MoreAbout",
 CellID->258062253],
Cell[30592, 1166, 166, 3, 70, "MoreAbout",
 CellID->45409766]
}, Open  ]],
Cell[30773, 1172, 27, 0, 70, "History"],
Cell[30803, 1174, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

