(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21427,        861]
NotebookOptionsPosition[     15557,        653]
NotebookOutlinePosition[     16829,        690]
CellTagsIndexPosition[     16744,        685]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Forms of Assignment" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialFormsOfAssignment"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Special Forms of Assignment\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PreDecrement" :> 
          Documentation`HelpLookup["paclet:ref/PreDecrement"], "SubtractFrom" :> 
          Documentation`HelpLookup["paclet:ref/SubtractFrom"], "Set" :> 
          Documentation`HelpLookup["paclet:ref/Set"], "Subtract" :> 
          Documentation`HelpLookup["paclet:ref/Subtract"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PreDecrement\"\>", 
       2->"\<\"SubtractFrom\"\>", 3->"\<\"Set\"\>", 
       4->"\<\"Subtract\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Decrement ",
 StyleBox["(--)", "OperatorCharacter"]
}], "ObjectName",
 CellID->17065],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "--"}]], "InlineFormula"],
     "\[LineSeparator]decreases the value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " by 1, returning the old value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31930]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Decrement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Decrement"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28264]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->71461546],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->974349604],

Cell[TextData[{
 "Decrement the value of ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " by one, but return the old value:"
}], "ExampleText",
 CellID->18144762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"k", "=", "1"}], ";", 
  RowBox[{"k", "--"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->462036873],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->50869477]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["k"], "Input",
 CellLabel->"In[2]:=",
 CellID->157577117],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->106596280]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3685035],

Cell["Decrement a numerical value:", "ExampleText",
 CellID->1113876286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "1.5"}], ";", " ", 
  RowBox[{"x", "--"}], ";", "x"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1774324750],

Cell[BoxData["0.5`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->314394674]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->305512978],

Cell["Decrement a symbolic value:", "ExampleText",
 CellID->838884225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "=", "a"}], ";", 
  RowBox[{"v", "--"}], ";", "v"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1698859122],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", "a"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54758914]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8865529],

Cell["Decrement all values in a list:", "ExampleText",
 CellID->822015323],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2332824],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->264597902]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "--"}], ";", "x"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1729906436],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "2"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->45031839]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->601614423],

Cell["Find the largest prime smaller than a given number:", "ExampleText",
 CellID->161028340],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"i", "=", 
   RowBox[{"10", "^", "6"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"!", 
     RowBox[{"PrimeQ", "[", "i", "]"}]}], ",", 
    RowBox[{"i", "--"}]}], "]"}], ";", "i"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->107312313],

Cell[BoxData["999983"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39113278]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->89293189],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Decrement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Decrement"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PreDecrement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PreDecrement"]], "InlineFormula"],
 " differ in the return value of the operation:"
}], "ExampleText",
 CellID->440092738],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->550656451],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "--"}], ",", 
   RowBox[{"--", "b"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->532828009],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->331409392]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b"}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->195309579],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->279508813]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->757407539],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Decrement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Decrement"]], "InlineFormula"],
 " is a short form of this assignment:"
}], "ExampleText",
 CellID->2065810971],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"k", "=", "1"}], ";"}], "\n", 
 RowBox[{"k", "=", 
  RowBox[{"k", "-", "1"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1887499219],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87318399]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3417850],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Decrement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Decrement"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["SubtractFrom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SubtractFrom"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1728269985],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"k", "=", "1"}], ";"}], "\n", 
 RowBox[{"k", "-=", "1"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->683214900],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->178627198]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->155058298],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Increment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Increment"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PreIncrement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PreIncrement"]], "InlineFormula"],
 " are closely related operations:"
}], "ExampleText",
 CellID->73150939],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->634282679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "++"}], ",", 
   RowBox[{"++", "b"}], ",", 
   RowBox[{"c", "--"}], ",", 
   RowBox[{"--", "d"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->463191000],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "1", ",", "0"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->132180517]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->95912239],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "2", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->389298997]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13076],

Cell["A variable to be decremented must have an initial value:", "ExampleText",
 CellID->992262862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "--"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1397421414],

Cell[BoxData[
 RowBox[{
  RowBox[{"Decrement", "::", "\<\"rvalue\"\>"}], ":", 
  " ", "\<\"\\!\\(x\\) is not a variable with a value, so its value cannot be \
changed.\"\>"}]], "Message", "MSG",
 CellID->258677002],

Cell[BoxData[
 RowBox[{"x", "--"}]], "Output",
 ImageSize->{27, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->361978373]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14638],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PreDecrement",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PreDecrement"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SubtractFrom",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SubtractFrom"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Set",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Set"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Subtract",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subtract"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8631]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5423],

Cell[TextData[ButtonBox["Special Forms of Assignment",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFormsOfAssignment"]], "Tutorials",
 CellID->23322]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Decrement (--) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 43.5525564}", "context" -> "System`", 
    "keywords" -> {
     "decrement", "post-decrement", "postdecrement", "subtract one"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "x-- decreases the value of x by 1, returning the old value of x. ", 
    "synonyms" -> {"--"}, "title" -> "Decrement", "type" -> "Symbol", "uri" -> 
    "ref/Decrement"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3636, 126, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->71461546]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16602, 678}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1499, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2122, 63, 103, 4, 70, "ObjectName",
 CellID->17065],
Cell[2228, 69, 544, 18, 70, "Usage",
 CellID->31930]
}, Open  ]],
Cell[CellGroupData[{
Cell[2809, 92, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3287, 109, 312, 12, 70, "Notes",
 CellID->28264]
}, Closed]],
Cell[CellGroupData[{
Cell[3636, 126, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->71461546],
Cell[CellGroupData[{
Cell[4020, 140, 148, 5, 70, "ExampleSection",
 CellID->974349604],
Cell[4171, 147, 176, 6, 70, "ExampleText",
 CellID->18144762],
Cell[CellGroupData[{
Cell[4372, 157, 134, 5, 28, "Input",
 CellID->462036873],
Cell[4509, 164, 157, 5, 36, "Output",
 CellID->50869477]
}, Open  ]],
Cell[CellGroupData[{
Cell[4703, 174, 70, 2, 28, "Input",
 CellID->157577117],
Cell[4776, 178, 158, 5, 36, "Output",
 CellID->106596280]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4983, 189, 218, 7, 70, "ExampleSection",
 CellID->3685035],
Cell[5204, 198, 72, 1, 70, "ExampleText",
 CellID->1113876286],
Cell[CellGroupData[{
Cell[5301, 203, 152, 5, 70, "Input",
 CellID->1774324750],
Cell[5456, 210, 161, 5, 36, "Output",
 CellID->314394674]
}, Open  ]],
Cell[5632, 218, 125, 3, 70, "ExampleDelimiter",
 CellID->305512978],
Cell[5760, 223, 70, 1, 70, "ExampleText",
 CellID->838884225],
Cell[CellGroupData[{
Cell[5855, 228, 145, 5, 70, "Input",
 CellID->1698859122],
Cell[6003, 235, 197, 7, 36, "Output",
 CellID->54758914]
}, Open  ]],
Cell[6215, 245, 123, 3, 70, "ExampleDelimiter",
 CellID->8865529],
Cell[6341, 250, 74, 1, 70, "ExampleText",
 CellID->822015323],
Cell[CellGroupData[{
Cell[6440, 255, 147, 5, 70, "Input",
 CellID->2332824],
Cell[6590, 262, 213, 7, 36, "Output",
 CellID->264597902]
}, Open  ]],
Cell[CellGroupData[{
Cell[6840, 274, 112, 4, 70, "Input",
 CellID->1729906436],
Cell[6955, 280, 212, 7, 36, "Output",
 CellID->45031839]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7216, 293, 227, 7, 70, "ExampleSection",
 CellID->601614423],
Cell[7446, 302, 94, 1, 70, "ExampleText",
 CellID->161028340],
Cell[CellGroupData[{
Cell[7565, 307, 303, 11, 70, "Input",
 CellID->107312313],
Cell[7871, 320, 162, 5, 36, "Output",
 CellID->39113278]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8082, 331, 236, 7, 70, "ExampleSection",
 CellID->89293189],
Cell[8321, 340, 361, 12, 70, "ExampleText",
 CellID->440092738],
Cell[8685, 354, 208, 8, 70, "Input",
 CellID->550656451],
Cell[CellGroupData[{
Cell[8918, 366, 155, 6, 70, "Input",
 CellID->532828009],
Cell[9076, 374, 203, 7, 36, "Output",
 CellID->331409392]
}, Open  ]],
Cell[CellGroupData[{
Cell[9316, 386, 115, 4, 70, "Input",
 CellID->195309579],
Cell[9434, 392, 203, 7, 36, "Output",
 CellID->279508813]
}, Open  ]],
Cell[9652, 402, 125, 3, 70, "ExampleDelimiter",
 CellID->757407539],
Cell[9780, 407, 216, 7, 70, "ExampleText",
 CellID->2065810971],
Cell[CellGroupData[{
Cell[10021, 418, 169, 6, 70, "Input",
 CellID->1887499219],
Cell[10193, 426, 157, 5, 36, "Output",
 CellID->87318399]
}, Open  ]],
Cell[10365, 434, 123, 3, 70, "ExampleDelimiter",
 CellID->3417850],
Cell[10491, 439, 335, 12, 70, "ExampleText",
 CellID->1728269985],
Cell[CellGroupData[{
Cell[10851, 455, 146, 5, 70, "Input",
 CellID->683214900],
Cell[11000, 462, 158, 5, 36, "Output",
 CellID->178627198]
}, Open  ]],
Cell[11173, 470, 125, 3, 70, "ExampleDelimiter",
 CellID->155058298],
Cell[11301, 475, 347, 12, 70, "ExampleText",
 CellID->73150939],
Cell[11651, 489, 248, 8, 70, "Input",
 CellID->634282679],
Cell[CellGroupData[{
Cell[11924, 501, 215, 8, 70, "Input",
 CellID->463191000],
Cell[12142, 511, 223, 7, 36, "Output",
 CellID->132180517]
}, Open  ]],
Cell[CellGroupData[{
Cell[12402, 523, 134, 4, 70, "Input",
 CellID->95912239],
Cell[12539, 529, 223, 7, 36, "Output",
 CellID->389298997]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12811, 542, 226, 7, 70, "ExampleSection",
 CellID->13076],
Cell[13040, 551, 99, 1, 70, "ExampleText",
 CellID->992262862],
Cell[CellGroupData[{
Cell[13164, 556, 89, 3, 70, "Input",
 CellID->1397421414],
Cell[13256, 561, 214, 5, 70, "Message",
 CellID->258677002],
Cell[13473, 568, 176, 6, 36, "Output",
 CellID->361978373]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13710, 581, 311, 9, 70, "SeeAlsoSection",
 CellID->14638],
Cell[14024, 592, 946, 35, 70, "SeeAlso",
 CellID->8631]
}, Open  ]],
Cell[CellGroupData[{
Cell[15007, 632, 313, 9, 70, "TutorialsSection",
 CellID->5423],
Cell[15323, 643, 162, 3, 70, "Tutorials",
 CellID->23322]
}, Open  ]],
Cell[15500, 649, 27, 0, 70, "History"],
Cell[15530, 651, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

