(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    276090,       5355]
NotebookOptionsPosition[    269410,       5126]
NotebookOutlinePosition[    270745,       5164]
CellTagsIndexPosition[    270658,       5159]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ModularLambda" :> 
          Documentation`HelpLookup["paclet:ref/ModularLambda"], 
          "KleinInvariantJ" :> 
          Documentation`HelpLookup["paclet:ref/KleinInvariantJ"], 
          "EllipticTheta" :> 
          Documentation`HelpLookup["paclet:ref/EllipticTheta"], "PartitionsP" :> 
          Documentation`HelpLookup["paclet:ref/PartitionsP"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ModularLambda\"\>", 
       2->"\<\"KleinInvariantJ\"\>", 3->"\<\"EllipticTheta\"\>", 
       4->"\<\"PartitionsP\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Number Theoretic Functions\"\>", 
       2->"\<\"Number Theory\"\>", 
       3->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DedekindEta", "ObjectName",
 CellID->16349],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DedekindEta",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DedekindEta"], "[", "\[Tau]", "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]gives the Dedekind eta modular elliptic function ",
     Cell[BoxData[
      RowBox[{"\[Eta]", 
       RowBox[{"(", "\[Tau]", ")"}]}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28947]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DedekindEta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DedekindEta"]], "InlineFormula"],
 " is defined only in the upper half of the complex ",
 Cell[BoxData["\[Tau]"], "InlineFormula"],
 " plane. It is not defined for real ",
 Cell[BoxData["\[Tau]"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29299],

Cell[TextData[{
 "The argument ",
 Cell[BoxData["\[Tau]"], "InlineFormula"],
 " is the ratio of Weierstrass half\[Hyphen]periods ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["\[Omega]", "\[Prime]"], "/", "\[Omega]"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->21448],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DedekindEta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DedekindEta"]], "InlineFormula"],
 " satisfies ",
 Cell[BoxData[
  RowBox[{"\[CapitalDelta]", "=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"2", "\[Pi]"}], ")"}], "12"], 
   SuperscriptBox["\[Eta]", "24"], 
   RowBox[{"(", "\[Tau]", ")"}]}]], "InlineFormula"],
 " where ",
 Cell[BoxData["\[CapitalDelta]"], "InlineFormula"],
 " is the discriminant, given in terms of Weierstrass invariants by ",
 Cell[BoxData[
  RowBox[{
   SubsuperscriptBox[
    StyleBox["g", "TI"], "2", "3"], "-", "27", 
   SubsuperscriptBox[
    StyleBox["g", "TI"], "3", "2"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->684],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["DedekindEta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DedekindEta"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->185371836],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DedekindEta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DedekindEta"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DedekindEta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DedekindEta"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->646483597],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->943846495],

Cell["Evaluate numerically:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->276493448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DedekindEta", "[", 
  RowBox[{"1", "+", 
   RowBox[{"2.", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->171814419],

Cell[BoxData[
 RowBox[{"0.5721978275379304`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.15331994579963126`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->68573264]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->487240653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"DedekindEta", "[", 
     RowBox[{"x", "+", 
      RowBox[{"0.2", "I"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "15"}], ",", "15"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->219862329],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->595965147]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5540],

Cell["Evaluate to high precision:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->16593189],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"DedekindEta", "[", 
    RowBox[{"1", "+", 
     RowBox[{"2", "I"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92267335],

Cell[BoxData[
 RowBox[{"0.\
5721978275379302702744247104868551319852990652682244926535318854275`50.\
13545877593468", "+", 
  RowBox[{
  "0.1533199457996312413182417119852489441437682748206549173437002578443`49.\
563511228401325", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{386, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->866861072]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6267416],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->47874911],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DedekindEta", "[", 
  RowBox[{"1.0000000000000000000000000000", "+", 
   RowBox[{"2", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->351838579],

Cell[BoxData[
 RowBox[{"0.57219782753793027027442471048685513199`28.43491142078607", "+", 
  RowBox[{
  "0.15331994579963124131824171198524894414`27.762300361633056", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{448, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16753032]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->75711896],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DedekindEta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DedekindEta"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->663211150],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DedekindEta", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"0.2", "+", "I"}], ",", 
    RowBox[{"0.3", "+", 
     RowBox[{"2", "I"}]}], ",", 
    RowBox[{"0.4", "+", 
     RowBox[{"3", "I"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57578442],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.7682408616721728`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.03889138242816559`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.5905595129745311`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.04647607084256271`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.4534404535679526`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.04765851035588215`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{455, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->559094449]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->275011245],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:  "
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->308166577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DedekindEta", "[", "\[Tau]", "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->52777769],

Cell[BoxData[
 FormBox[
  TagBox[
   RowBox[{"\[Eta]", "(", 
    TagBox["\[Tau]",
     Identity,
     Editable->True,
     Selectable->True], ")"}],
   InterpretTemplate[DedekindEta[#]& ],
   Editable->False,
   Selectable->False], TraditionalForm]], "Output",
 ImageSize->{24, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->228992310]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21082],

Cell[TextData[{
 "Plot the ",
 Cell[BoxData[
  ButtonBox["DedekindEta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DedekindEta"]], "InlineFormula"],
 " in the upper\[Hyphen]half complex plane:"
}], "ExampleText",
 CellID->177217333],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"DedekindEta", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0.01", ",", "2"}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->775141684],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxsnXd8V7X3/9mgKHv5AQVkO5A9VAhbUED2UECGCAgCgogMQWQP2RtkL2Va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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{6799, 5632, 398}, {4141, 3615, 787}, {3617, 4136, 789}, {
         3616, 3739, 789}, {4719, 6163, 789}, {6801, 5144, 2355}, {3877, 3583,
          1944}, {3557, 3963, 452}, {5632, 5407, 398}, {3913, 3635, 2169}, {
         6163, 7015, 789}, {3658, 3929, 2208}, {4559, 7470, 635}, {4135, 3577,
          540}, {3963, 3556, 452}, {7014, 6161, 787}, {3556, 3981, 452}, {
         3889, 3891, 2038}, {6358, 7203, 2038}, {4425, 5527, 452}, {4136, 
         3616, 789}, {4073, 3507, 635}, {3588, 4073, 635}, {3614, 4141, 
         787}, {7015, 6165, 789}, {5527, 7480, 452}, {6236, 6234, 1944}, {
         7499, 5148, 540}, {3539, 3700, 398}, {6983, 6358, 2038}, {3709, 3614,
          787}, {6161, 4716, 787}, {4382, 6983, 2038}, {3888, 3889, 2038}, {
         6609, 6611, 2208}, {6540, 6538, 2169}, {3848, 3539, 398}, {3896, 
         3877, 1944}, {3576, 4135, 540}, {6159, 7014, 787}, {3700, 3540, 
         398}, {7013, 6233, 1944}, {7480, 7353, 452}, {5407, 4341, 398}, {
         6234, 7013, 1944}, {3947, 3946, 2355}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnus13MYxz9iRvw+33Opc06nzu+UP2Jz0jqlG5pbqpXZIroIXYasshmp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         "],
         VertexColors->None], 
        PolygonBox[{{6365, 4719, 789, 3739, 3898}, {6235, 6236, 1944, 3583, 
         3878}, {6233, 7992, 3895, 3896, 1944}, {6165, 7692, 3584, 3617, 
         789}, {7203, 7202, 4009, 3888, 2038}, {7698, 6159, 787, 3615, 
         3606}, {7004, 4425, 452, 3981, 3983}, {7741, 6801, 2355, 3946, 
         3682}, {6531, 6540, 2169, 3635, 3908}, {7353, 7354, 4038, 3557, 
         452}, {4341, 6024, 3850, 3848, 398}, {7470, 7471, 4077, 3588, 635}, {
         4963, 6609, 2208, 3929, 3656}, {6538, 4875, 3633, 3913, 2169}, {4716,
          6362, 3897, 3709, 787}, {7988, 4382, 2038, 3891, 3890}, {5144, 8020,
          3944, 3947, 2355}, {6800, 6799, 398, 3540, 3945}, {6611, 6605, 3928,
          3658, 2208}, {7500, 7499, 540, 3577, 4081}},
         VertexColors->None]}]}, 
     {RGBColor[0.342839462818159, 0.143338454293188, 0.598882655895968], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVm1MlWUYfgTOB1/GOXDe8yHnPUEbtBGZCAhjSS6Wo2wmHVEI3GpLWxI0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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl1tsVVUQhheFckpLsbdza0/3pphQEikq98pdUW4FpZQipYBy0wi0hgiC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         "],
         VertexColors->None], 
        PolygonBox[{{7630, 7170, 7169, 8039, 3356}, {5675, 4654, 4653, 5676, 
         1609}, {5780, 6104, 1851, 6103, 5779}, {6631, 8008, 8007, 6632, 
         2213}, {5671, 5497, 5496, 7703, 1607}, {5684, 4849, 977, 7805, 
         5683}, {5400, 6046, 1831, 6045, 5399}, {6606, 7400, 2959, 7713, 
         6605}, {5856, 5654, 5653, 7723, 1701}, {6579, 5400, 5399, 7709, 
         2191}, {5972, 5264, 5263, 7664, 1798}, {6010, 5387, 5386, 6008, 
         1816}, {4841, 5641, 5640, 7802, 973}, {5473, 4405, 4404, 7983, 
         1512}, {7814, 4657, 1512, 7815, 7813}, {6081, 6971, 2562, 6970, 
         6080}, {5387, 6545, 2171, 7706, 5386}, {8115, 7628, 3356, 7631, 
         8114}, {6537, 6532, 6531, 7704, 2168}, {5436, 6091, 1843, 6090, 
         5435}, {5267, 5977, 1799, 7665, 5266}, {7995, 4166, 2358, 6804, 
         7994}, {4642, 7852, 7851, 7853, 1506}, {6727, 6064, 6063, 7734, 
         2296}, {4641, 5644, 1604, 5648, 4640}, {7845, 5444, 1506, 7850, 
         7844}},
         VertexColors->None]}]}, 
     {RGBColor[0.431995476591195, 0.298356684325451, 0.724202218725286], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l2uQlmUZx2/28Oy77lu5z3vY93l3XzZQ8YAi4CaRLciEQEwuyiJZgjoM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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl31wlNUVxi8kWZKimN1k3913STZCRwkIGQcQiIKIVb6miAQEZipgGVtb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         "],
         VertexColors->None], 
        PolygonBox[{{5427, 5642, 1603, 4841, 5426}, {4643, 5646, 5645, 5644, 
         727}, {7629, 4651, 2762, 7630, 7628}, {4660, 5680, 1610, 5684, 
         4659}, {5639, 4637, 4636, 5641, 1603}, {5726, 5723, 727, 4642, 
         5725}, {4750, 8063, 8062, 7240, 2827}, {5971, 5265, 1410, 5972, 
         5970}, {5678, 4655, 733, 5675, 5677}, {5793, 5798, 5797, 4657, 
         733}, {4608, 6544, 6543, 6545, 1484}, {5681, 5502, 5501, 4849, 
         1610}, {6578, 4617, 1487, 6579, 6577}, {5268, 5975, 5974, 5977, 
         1411}},
         VertexColors->None]}]}, 
     {RGBColor[0.521151490364231, 0.453374914357713, 0.849521781554604], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mXmU1MURxxt2d2b2IGFndtg5dhDiASgCUQ4PBOSZeHAZbjWiIYo+ZQFR
1BgMagw8fN6yycuDqE8UNAkGMSKnRh83LCKXAooXiImCiTGKoJjvx2/7R2/X
9K+6urqq+lvVve3HThw6oWUIoZP+lKkfXAphkNqB6hCaGkLYlQ5htOi95SFs
qQhhmfhGqt+qdqvoB/OaJJ4XRReyITxUMt+INiEkM+oTIYzS3BdSISzQAnMk
a6HoS1qEsKkQwga1GZUhHCnz+J/V/682hMN1IayVnAn6fblkb9Ayt4p+WGPX
6Pe5mtNFMnZo/HXxblV7Vt8GJ0NoURPCdeL5hXS7Uu1qyT0oXX5V8rcNkv9V
nfVvbBXCeLVN0uvxaus5T3Kb9f2qeu93hvb1GHvRPn6r/QzRGmvEM1y/r9Wa
L4lnkMYGqq1u4R490OFTzT2k1k3zPpQu+9SeTPn7wCinu9Y5Xe2QeK5sHcIt
amu0r0rtd7TkT5WcOzVvmtoUzd1XFcLYGuuJrXulrOcifR8lOUtF/yMXwstq
H2qN+yTvjHr7rbPGDkqfrlqrXHRZzroPiTqjz03a+zmy0U3i/4++L6jzWrM1
b6R8/ZXGt6n/RustlI4LRLeXH0+RHv9Muu+u8Rvlo5NFb9VeHtXcIeL7WroN
SHpv7AsbjK+x3abLxl9L5hLNmSNfXSW9byZm5J/ZaterLRFfhead2sKxVsza
BneInqaWlKzdir1ObUOYqz3OKDku4ZmUdBxjq9kanyd9Jkn+UslKaKyr+kbN
n6DW2NKxsDjGLbFH3G3XXlZq7CW1ReKfKZ3LC/59mtZ7Wf3fxPu4bNZP5+de
rduj3HPgnyybdBT9uuQ8hV3rHNPMWxnn3qI2TmttE0+fcuuEPszrFOe+mLKd
hkjmebLL5hrb6pWs45vYLpabD55sK9uZmMSG2K+z2kTNGaOxjZLZocxrbdf4
w9pTb+k2sdxxPk62O6rxupRpYv5S0ZepFct8NogpbEW8/7jgmP+3fHFANlqi
71/Kt5vTPuNz9XtQwrp9LP5pis9T9fsvZe7hwfbdoswryr0ea+2WjCF5r10S
ndQaO1sap+CpFj1Y8+YnvA4Y9AxNdA/ZobfoGvF8o7k921iP7qIXKmb2ary7
eMaWey32yv7Z72fS879Z+xnb9kg4/l/SGVmptl+8N2qvi9sYJzpGvOBMjZEt
7416ThB9dxuvhS4zE/bzsHrjKVgKHp0lXyyTX9pJ5kHxH9ZadaJniOcW7fNj
xdeUjNf5QnpdWLROi8qsI7FE7J0e6c/F073g399qv59K5sWifyd506PMHhq/
MerWVvQ1UefbiP+kz3WNxktZ54AvwGKNh5bGmsakf49X6xXHt2lfO+ptsxO0
xolqrwVjGFgGH/a+rcI2r5Uu6bzjHZwYEHH1S+33zoxzyFHRd2eM2UuEE580
GIuvTVpPYrVE7hDdRTqMSZomtldJ7oUVHl+d8jfGl0jH5Wpd9HteyuuCUTvr
bV9su6rcc+A/SX0HtS3BspGLTPA7mTeGt9NYe7Vm0Z8pRnrXGgewMXGAnScK
E34kns1gvuZV5T2vWn1N3t9ox0ee1RrLyAdvaQ+Pygb18umWlPe9JWLvpErb
Gjv/UPyt89a3Ip7/dWBLmf2Hjz6vMN6Dz/iceMXvlWnnFXJKK/U/yFvuhErr
yL7AD3B0k+hftja28nus6DeKxhiwd0CVz+ZMjd1T9O/10n+hbPtAuXGeXHxd
meMfer1kniV527THeyuNieMiDl8qW04pGrf4DT5TD7Qtc9wQM31LrgOoAXop
Ri5L+9vGqDc6NysOb2hl2WAv9NX6lk24/kCfG8jXVcaN5mrXDd/r2Bh1Zt7k
OJfY+06vFjGf1ER8lZy+VbY5OW1OnMs6syN9B3bOONdfH3Mf9c8U+eSxrP20
UntJZ1w7HZMd7soZN1aIfqtoG4H3baMdiM9S1Acd0ZV9z5Q9ZmYdM8s0d1fR
+jN3YKxhxsfciy+Gi+fMBsv9teb2bbBczu4VETPJRZOj/L4tHG/kmp6t7EMw
7xzt8QHNHZAyNg+P+LxLe7qkYHqt+una1/wyn71CufH2eHjqXDOSM8E48I16
sGusCcl7xcjfv9L1IvEBpuI39AF79qsdaukald/UOVXaV6rBMQ827Ys8Z2tu
vxZe54kq1wTYGd5U2vxvJPydsw8Oo9fh4Bqja5yLzEPx3O2pcM77MjgPgC/k
AvLpgjjeVO6chG3HRpo4/Fw2PJx33dxB66elxx6NbxF9Xj7KTTn2l8Tc1zPm
v09iriXP4hPGWed8zXtd84elvE6PuNbBBuc28hm4syjuq2fkYS759uKYc8mF
+AV8OUXymkvWjTPUFPMvPO2rzEccTU07lu6J+Za8Sa56IPr3VcXee0XXQtQF
90cbPSnZWyM+XJJxvsH3+7WXxozrbWLwq4h7TYr3oWlj3hla98HWrrOXKy5m
JRzH72udD9Seln7XJx0nxAh1Ir7cGRzn58XzPidpXuousOK7uo3coXUG5G2v
ldLx3aLP1BeiD6vNEd9oxfhS7e0PmjdC9GLRs5K+90yMWNVF40ty1uVPmvdo
wXHdVWOLSs634AQ4siHG25Go51x9P1n8+1O+x5ycc3yNQqbW+j01jugXRD8i
+q9p19/Uk9Sv+IS8NhKMEU+TeI7o/F1Q5ztFQfY+QfJ3UheJTuV9Dpo0tiLn
PEO80xPz90n+tOMUO2WOi78f59hgDwdiPXCi/HJSg3/De3/a/I80uF6kRiQ/
56uMbxnJSSOr2n7G32DPVNn7drVz4lnfF/14ucbGFD2/yB2hZP9T78FL/fBT
rbk85ximtugY45I71qw6n/fxEcPBR+yN3cEIauE+ca1ZDa4dqcmojZBHDVDS
mk9nfKaps6mxwOFFsvHOovNTvygT3NiqsedqHRfgzq0x7+HzpiqPbxPP9qJ/
Uw8gk71crRh/u+j8hh0+jJj287TzIjmR+9buov3erY1rYuoT7nCMcY8jPyyv
dcxzb+lRbVwl5i6P9whi/JVaxzmx2S9t3z4vulsu1ogNzt8dYt5EL/Iv+36+
1nun5m2fcd17Q6XrF2qthMb6tHHOAMemVxon729wziBfrFO/vuBvD9W5tiY/
nprzWeIc1UmfrNoL1bbH/njW10n+6QXjDneHodXWAawBc1iL79Qu8KxR363g
bxvk5/VZ1w6cs1PiWeukvmPO9WmD1pyvOSsk982iaybqpQ3a07yM8XFwxFHu
R0Mle0fGv1dK9vaC8ZZ71YE2xvZe6o+lPe+o1rk77btafcq1F3decvSyauPb
uJSxmrmdCsYI8AEs7x7xnPNMnlwaXH+Bs2DscMkYlHLupkFjnyDdWtbHc501
FoPD1Dvj413gmLDhaN75mbxFDuct6Py044PY4J3gj1nXor3zrhVY59x4v0DO
zbLZiQXfj8gN+IF8xDkh15N/56e8J/LJbLBWrZ++bSy4fqJ2ek065rPG4b6x
TqHO4f1rRKxJ8O3ajP37/dsTNQax3z/WFZ3jnRpbFWX/Qs73Cnj7R33OVBxe
1Np3j1FRNntvV+t3FmqP5zK+e4MHxAe5hDwyP+6DnLhK39tl/Xud+uUZ24H7
ejHe2Q/GegmbdCx4Dvz4/NuUY6kq4djnfktNu7na9ecFismt9Z6/p2js4Hzy
hnRhxHxy2o608xrvPawJdvFmAuaxF7AY3ER+n3i2+EZ8g3nUAJWSd2fB7zLo
QG3GXrjHE6fcF9ATGeAYeRWb1MS3u+ao82+k29R6xxPvYXNizFNfUENQY4yX
nT6Q3nNTrpe/rTUmDNP6wwu2C3dO3mjeSvh+wz3nTdGTiq59qXvBIfBoT8J3
Ie5au0XnFL/5ks8Y9zXudbs0/myd735gPvXLqwX7dHHOOZK8eJr62rTrQWq3
19Kuz6jDebthXXCYN7W3E8aJtiXbkjcv7qTUjsQhNiSGb8r4jeD7vNUxxk/v
+N7wnQ1rTHMv2FH0nY2a491q146cixelZ9+08wW5C1uyl3fEv7foWviYeGak
jTf9hUWpjGOcOyu1DPdWfAwW4VNiizqS+Hw4aRtvijVwosZ7wR4/ydsmm2pc
f1NX3K59/6ZkPu4onI01MTZWxb3cHO8h5CzmMX9tcH2DT7i3bqzxfWBnrCVZ
B2znjY1ajHc27vfUR+SdjzJ+zwIzj6p/Nu38ioyN8a3mZznXQ8i8o63fp7hH
8/ZzXKSprT+Jb1zc4wfmbQv0bY46F+IZ5v5CHMCPbrwRM47deO/mnYI3isnx
DZC8vBFsSPvcfJT1+xH4jE7o2jnWKGdHm3A/GBfvCJw5amB8hA8vLdiPT4m+
q+Bv4Ba5F+zCH8gBd6ln+5QcM+TMATEvrND4U9KnsdIYQ27kzI4o+A2O9zfO
Lvc6zm/X+D8D8i225yxif+KIc0Ys8aaCL/Ejb2k9Y61Cbcq55N2DvESuoh6o
lB2a06aJa+Kbff8r6Tdrcg0+52zhd+rLI/F+RJ4BZ/HvMxnXbeAXGDk6Y1+R
v4ljYrhQ5/ggNnjrQif0IW+fWXJuxY57I75dJxnvKgae4F1JOl4keqToverf
ieNgZKrOc1YrxlblrDuxAC9xMizn+hufsDb+BzPfk4z3I+7xLjU053z0fyaR
las=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHeU1dURxy/sY9/borBv9+2+sm+BgBRBqUrgUA0WRMAsRRBBQoSoiRSP
BZWiQkBKgChrNMcYNXEpKkGUXoyIisCqQUFpJjGh6BHwRBQUxXy+5/v+mPOb
+7tzZ+bOnTvlNh07sXpC/RDCVfVCiPBdWBpC17IQ+jUIYXsshMvLQ9idCGEQ
8wPyQ2iQDOEENPWKQxgYDSGdDeF5xkuY21QUwnPQLwVqgWeBOPPrG4VwK/xe
Zf5QPIQt/J8LfXdgEWsz8BwNrzeRN4vxd6kQ1oA/A31PaJejzwjkD4E+kg5h
JePVjLdC80kmhPHwn5KH7EJ0hX931vdnrpr1L5eEsBeaicyPYqOLK9kjsJTx
EOY/RL+N0Ixjru8FIbzDXn8BvwnMJ5CXD+03yHwK4+yC//yqEBpB3xCYB17N
Nyke8LqfPc5D/zzotyD/NWA/+gxEnxvBh0NzjP30ZP4M4/Xw3MnaSehXJXnI
7wG/P6LDt/C6C+gH7eoK9gFcA14F/XJkjGVtDfq9ge0GIuN79P8MG7aG/wOs
vx9oBd6LubXQ9IT/SWhuhMd+1i9n/Q2s783+HoAmy/wC5J1F/pX86wucAY/F
bQPtfQPrm8C3If+2gs+DR4pxNDcvG2U4mzRwP/wmaj5pn5IvjUK/BeyjP2uu
BeaDz8KGPcF7ADPBY6ydwx7fR5dPIuZdELdsyejJXG/gX0WWJ13OIaMsZp26
wWMpa2qBruBXJSxTsq4E/whbr2Zfo+vbJxZV2ifkC/KZ36LrKejaY5u1jHtA
XwF9OdAd/Fl4foV//A94Brw+8tuicxugHvg72Hc2689wl2YXcGbQvIHsbcDV
4Bnm1kLXJeY99kn7jHW2vYGbOLNx8LoFGKm7lNuDdK8FnydfAS9C//7YoyM0
MxhPBzqAfwokgQrg30BLbPM0e3ofeb/C/kvBO/NvMvhm9vwk695k/HnUPqS7
OQ375hf7ju5A5kn2egJ4G3wi883RvxkwAbya711l9tXTQAVrM1nHgps5n73I
G5p27PgL4ybl9lH5ZmMgxt3YCv1u5H0ETR12+obx1/oHvhaafPQbhH4zmW8K
r5dL7Vtt2NMIxgOhPVZkn74XfpvQZyNwD/go1tZpzN6egsd90G5hze31HcM2
w2tnwnf9XXh0lm2RWQh0Av8C37gLmlYRx7ABrO/F3NB8yxwB75cbOT59l2ff
vpn50eX28W3Y7CPm9wGvg/8Ve/0J+VfgG5exPgvNLnxrCvrsgf/DzBWU2fcV
U08wP475npx1O8b3KX7yr0Z3Lc+xQT4vX1eM0N1/FfyVKseAp+E3BtlvBctc
zP/W8GsFLKpyrJpb6liqmPUe/B9jz5cg6wX4PwGP1tjwVmx3jj1OZb4P8y3z
HDN0145ikyNZ37kKIALkAeXAL1nfBVmXA2Nze9WZ6Cy05xLWlWadG4ZE7FsN
sd2F5faxzui3A/0WMdcJnYYwrk7bl35E3y+hGSObA6fAZ8H/9/BfDMwEfwiI
MpcPPAjegbVvwW9hxHd8MP+Ps+4YUA1+FtvXQfMItnqb8/gAGzVnXTNgD/hw
1r6JXx1iLh2xruKhtdJ5C3u5B3tvxN678K+7oT9Rad+VD41Ezk8ZD2d9AfZ7
Bb4fc6cn5TkmTWf9VGB7xHfwFs70PHupiNmHD0O7mTXjwe9lzTZ0rcz6Lt/B
vwbwL0WXOBAB3wssQV5H5K+Gfm7COUO5ojPjh9nLbnjMYb93w+M1aMvQ+d6Y
x9cy/wE8VkE7jH8BvCDh/LkOee3Yc3v+tQMuBX8SGx1i/weBJ8CvwZ5fl9iW
w4BN4Acz1l05921kdUT+wQY+k6aKF7n7dRaahxifRodVyH4KfaYxdzs8bwOm
KhalbXPZeh9rWpY5hyl3tQBf3jiEA8zvB5aBT1btwv77s/9aeJ6D92z+rQdf
F3OtcabSsnSnlZsUkxSLlKPOQn8GWJFnnRR75YPyPcXgNcjNQrsfXR6L2jdl
I9lGPnonslqj8xHWLgXOs+644jz0A/NdyzyPDo82cE3TAl2+RN8u8DpW6Nyg
GKzYqxwxmrlPseeyQt+pIxW+c7pr/wWfzfz5Ep+VzuwA/y5h3BbYDx5Fn89U
Y+Xb5jpL2Vi21ZnOTfoO6e48Ah5n7y/wvzW6t4o5l43O3WfltFehq4Tvx/B6
lH9rGVcxPsB4SdR7WcFZjC32nlTrKecq16rmU25VzlGuUY7twNodaefSL+DR
j71ek/Hdu4xxY+YbwqMFaw8ybsK4JGXdDileppwTlAumpJz75rP+ukLnwG66
v2nHkuuh78E4As0A1aOc/2WK3azbq7XgG9hPU2QchvYP0KwrsQ6SXcM40th3
QL6fB/54uW0uW9eUm9dhxY8czzrs15vvgJjPZ32J9yDdH4+adhewM7fmW878
uzLfJcXPjtB+GPfdPKEcBn41dINj9tF/xG1D2U7/VLu+i251Va5hL2bvrdKu
5eSTK9hjl3L7omp+nfXwpPeqM38J2ecqXZvX1vNdfC5X6+tOroD+hqR1b6k7
C+/rGW8gdPTmDK9Et/fjzi26841SXiNanWFzeK9LulY9WuhcpRis2KuctUX1
rs6AuSPIaJN1DlfurityLr6i3LWt7u8seLdgzfioa8TXwK/m3x2Mj6oGYnwV
42/qu0beznhbLj6qJpKvNinxXuWz6g0+wH9qCt0jqPauSbj2Uf20XGeRtC9c
hLxljIcm7fvNGI/O2MfkWyl4dIf3Sc6nT9Q9TW/oL6r0Xf8N/9qzdjprehVa
506M52Zc+02KuhZRz6NeR/f3Ouy5L+5YrxyVyDrHKreuKXLsG5WxbMVAnc3P
k46dOqO/sZfO6HNS8Te4llFNOjJX01yY8h61t+Yx125TVBsG13BLmRuSdOxr
yvxtCcckxaJbwefEvQfprpxWDT446dpPNUpxyjaTrX4Scy58EIgWOycWpixD
vJsAO/GvhY2cr5XDBqVcI6k2Gsl8HrzrA9dFfadVC/yAzb8vcU2g2uoS5n8d
dY2l3KkaQrWDcujrJe7R1JupZuyLHx7gfPYDPwM/g8//rpHvo3Kczqpd0men
M7sz5Rik2DNZuSblnKvcqhwrXz6dcG0jn34RWdtKnMsnFNu2m9njHQW2sXoN
5XjldvUcikWl8Ls45pi0p8w5TrltZQPH4oKUbaWY/CH67cm4F5YPK/f8GHfs
Uw5aCb4LfQrz3cPVxh3TFctVo8zIumdXr64zUSzdWe5eVDFVtlHPo15HNhrE
dzNxcBMwEHxElWOiYuHwXG+kHku9lXqkTaW+07rLqqF0VsrpyuU6s/VJxwjF
Bp3ZIdb9M+PeXzWReq85wNCIe7A20LdNunbWP/VONZXuxdVDdQW/Ke5aTD34
gYzfBPQWcE+ec2N+qd8elCO1F+1BumtPehupAzIRx8uvEn4DUO+vmutwridT
L3Yo1/u/V+reVW8AqpXVQ6p3VM0sX1WNoNpAPqterh2yLq1yT9epwjFfsV53
9PuUY7Zkq4Y5WuU3Cr1NHAH2QruvwrlSOspXXox7b/KZfti1OO7eQz6s2k09
i3oV1XB/Vg+RcGxTj6fY+FLcvZdipGqdopTvqmoe9Wp6I9LbkHo25f4LUo4V
qgFqy9wDqfdRjbMq4ZijWKMav0L9SNy1qXrWVNY9pXpJvbHoLeVA3HdbbyrL
Sv0Go7cXvYko1k9VjC10zFduPZ5wLakcq7eDXsC4mN8QPo+7BpD/j+ffmJT/
CReN3rIUwxS79KbVKumeWr20eqJ00m8cetvQG9Ym8K1J5yblFMX2vyedaxTj
96T9Bqa3rwWquTO+87rr6qmGMXd3rp/WG9B/mH894VyvGu8H9Dufcq2qmly9
i3pW9arqYU5VucdTb3cSmIH86RXuTdXTdUVWt6xlq4eclnGPp95ONpsHj7Ks
c4VigHqhXbn+QDH2FDY4Xuq3K9lMvqkaW7W1fFSxWDFRsVD08VL3FIp34vF/
TEfaTA==
         "],
         VertexColors->None], 
        PolygonBox[{{4874, 6528, 2165, 6527, 4873}, {4878, 6514, 6513, 6529, 
         2165}, {7886, 4363, 1838, 6075, 7885}, {7237, 5376, 822, 4750, 
         7236}, {6535, 4874, 4873, 6533, 2167}, {5643, 4638, 726, 5639, 
         5642}, {4973, 6608, 6607, 6630, 2212}, {6603, 4970, 2210, 6623, 
         6602}, {6608, 4972, 2211, 6626, 6607}, {4966, 6629, 2212, 6628, 
         4965}, {6289, 4618, 697, 5268, 6288}, {5846, 7841, 7840, 5850, 
         1699}, {6624, 4966, 4965, 6622, 2210}, {4607, 6281, 6280, 5265, 
         695}, {7860, 4661, 734, 7856, 7859}, {6627, 4416, 4415, 6625, 
         2211}, {4662, 5682, 5681, 5680, 734}, {7186, 7191, 7190, 4651, 
         731}, {4416, 5531, 1529, 5530, 4415}, {4639, 7812, 7811, 7808, 726}},
         
         VertexColors->None]}]}, 
     {RGBColor[0.597999299830477, 0.582480667085392, 0.910277904308702], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgmUlNWVx7/e6O7q7khVdXdVdXVjXBKjmRlkUzQGEcdMkjGKtuwo4IKy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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHd8ltUVx58sSN5EzTsy3pEgFVerIkgFFFFoUUAUZIQpuw5EooRArQHU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         "],
         VertexColors->None], 
        PolygonBox[{{6279, 4482, 4481, 6281, 1983}, {5429, 7671, 7670, 6093, 
         1505}, {5702, 4879, 4878, 6528, 1624}, {5380, 5160, 5159, 4605, 
         1483}, {5758, 5227, 5226, 5757, 1653}, {5765, 5768, 1514, 4662, 
         5764}, {5773, 5776, 1505, 4639, 5772}, {6515, 4877, 2164, 6521, 
         6514}, {5728, 5222, 5221, 5724, 1641}, {5222, 5744, 1647, 5743, 
         5221}, {5165, 5396, 1486, 4613, 5164}, {6277, 6275, 6274, 4606, 
         1982}, {5393, 4485, 4484, 5395, 1486}, {5750, 5748, 5747, 4661, 
         1513}, {7527, 7387, 7386, 7748, 3067}, {5737, 5736, 5735, 4638, 
         1504}, {4648, 7187, 2776, 7186, 4647}, {4482, 5379, 1483, 5383, 
         4481}, {4485, 6286, 1985, 6289, 4484}, {5452, 4912, 1641, 5727, 
         5451}, {4967, 6604, 6603, 6621, 2209}, {4959, 5482, 5481, 5799, 
         1662}, {4971, 5804, 1664, 6624, 4970}, {6522, 5308, 5307, 6519, 
         2164}, {5227, 5795, 1662, 5794, 5226}, {5665, 5485, 1513, 5673, 
         5664}, {5392, 7173, 7172, 7191, 2776}, {4150, 6615, 2209, 6614, 
         4149}, {6275, 6282, 1983, 4607, 6274}},
         VertexColors->None]}]}, 
     {RGBColor[0.663549599932092, 0.687801759783682, 0.911772249253335], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgeUlUWWx7/O3a+7l9f5dX8PRWecXUFQMTA6u4IeddaASE4C0hgQJSpJ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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHd0llUSxt+Q/gU0+dK+FnaxrVgQVMCGQaz03hIgEMUCCggICEhREUSB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         "],
         VertexColors->None], 
        PolygonBox[{{4275, 5700, 5699, 5985, 1801}, {5242, 5532, 1530, 5533, 
         5241}, {5811, 5242, 5241, 5812, 1666}, {5391, 5166, 5165, 4611, 
         1485}, {5313, 6523, 6522, 4877, 1001}, {5802, 4420, 1863, 6138, 
         5801}, {6139, 5524, 5523, 6137, 1863}, {5461, 6039, 1829, 6042, 
         5460}, {5161, 5378, 1482, 4601, 5160}, {6616, 5150, 1058, 4967, 
         6615}, {6050, 5469, 5468, 6051, 1835}, {6057, 4360, 410, 5500, 
         6056}, {5232, 5766, 1656, 5765, 5231}, {4348, 6037, 6036, 5422, 
         404}, {5424, 4921, 1645, 5737, 5423}, {6130, 6134, 6133, 5804, 
         1058}, {5980, 5978, 1001, 5702, 5979}, {5738, 5216, 5215, 5736, 
         1645}, {4941, 5505, 5504, 5768, 1656}, {7188, 5464, 1485, 5392, 
         7187}, {5154, 5381, 5380, 5379, 541}, {5397, 5162, 542, 5393, 
         5396}, {5894, 5892, 5891, 5377, 1482}, {5524, 5813, 1666, 4974, 
         5523}},
         VertexColors->None]}]}, 
     {RGBColor[0.729099900033708, 0.793122852481972, 0.913266594197968], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxVm3eYldW1xr8pZ2bOOTM6Z870c0CUJoiCERRBLKgwVAFRMIn3pgjRqIAF
Czawp4gNGyqCDcVCFLvGEjBiVBCjQTSAJfgoAmKJN7El72/eNQ/P/WM/3z77
298ua6+91rvevc+uv5g+YVppkiTbypOkTM+JxSR5sDVJDlbhwJYkOUX5tqok
ebEySRaowvMq71GSJMuVPlH9VJnzfZWvrE+SbxqTZL3aGq30mco3qfxy5W9W
vRf0++lOSVKreh+p7Ji6JPlxwW2sUvs9Uv7my0yS5NTPLspX6F261H0trE6S
3VSnWb9vrUiS7WrjQqVr1Obo2iQ5Xflrle+rcQ/VmLfp++1KH+nbrSVus7fy
l6nPV1RvhPp5Ss/v80nyur59QvknlD9T+f1S/ob6jJvx76ZnN/U7HzkgA43/
9k7+fZj62xoy+ns6SW7Qc6O+PbTKY7lVvzfp2+uj/Isy16lXO51Tfr9V5euV
f1LpLxrrdZpTnfrIlriPsuh3cInnxryY07YY5yKN5QWN/zKNv5/aKA95Pqry
C9TO7vp+tt5dwPqoPK21ziqtkhymq50Po82LNP61Kc/lAX3791ySzNX7yZL/
JKWzVW+jvlmOLijNziZJf83xB9X/qea4RO1vU75V9WYofaA2X0s73y2x7Nfl
LP9jatSu0llqN69nndKRKl+jds9TmqZvnpFchyhtL/UcGCvrih5OVuqnNjep
/fV697/6/ZbaP1w6NlFzqNFaj9DvtXq/s9reSek51Vmnd6eUew7zVHat0rh4
j4yfVeqkdKqStkDSVfO6uNxrdq3Gnm6Snunba1T/aqWR0Qa6sofqP6n661T/
7XLryJxar2GuxuMo0bevS/bvq3xGynqdV6pU+Vat1VMNeq/6H2vcl+t5vNrt
qfdlSjOVX6zyM2MPvqj6W3JeF8bM+17okso2a/5Xqs3FGsMi9bVQ4zlAOnKc
9mlW+Qk1XndkcoHGc5HSMK3nm/pm71L3sUVr86nSY+rzHaV1Sj31blfV3UXp
Pa3X63q/WmmuxvqNfp/FXMr8xB5UhJ3gyZibMn6fCp1Gt5E5vyuj7piUf2Nb
GGN5mcfZS2lIzHEyezDvd7doLMs15/n67v/U/oVp6/DNFd7TZyjNrvN+QI8q
VOfA0KuRei7Ud6Uq/y5lm8WYPlD5U1Hnthr3OxB7qXSg8gfpWaixvqKrr6nu
0pR/z5fsx0nmQ1XnCI1tvFKDZHuTxnCQ9LNN7R+uNFzpR6pziL4ZjS1R/hbV
Oaro3/skrkedm6SMm/TuMP3uqjbulJ4cov6G69sJKhupOk/ouzr1vT7tffuG
UmeN7VWNbWPKc8krf7/yq9nDGlP3rL9vqbHtmar6N9VYD9CB5ZrH1oLbukzt
z9MY5ktGR1dbDuzBWSo/V+lQtbW7Uk+lI9XmFn33qdLDkvdvyqzPqpa0lfr9
KOVf1vOlMtuKe9O2j9hGbMlnZd6DRa1jocJtML98zHGQ+jkh7A+6uS3qT1P5
yVn3V1O0vcPWvVbhvX+eyvvpu72U1il/h+R5pOY5Vt+O0Ngmqmy08m9Jxk9q
vkeXeP/+JsY/WN8tSlnnu8sePKLvr1A+q3FllDYof53el6iv3+vbh1T2oNJJ
GsPTGud/Kr3Hx2iww/T928rvq/H2ifGUao9urLPuV6qdipTrIKeV9Jm4LKW0
tsxyWhtzx/a+FHWOV3u/qnJf2NeXQ87Hoz/yldP0/UTtiaOVvlD/o7SfnlF5
ncbdG3umdDDzVfm9LbYbH4S9LSvxc0Pkv5FsD6lwH4PU1/5Kn6vNfNY6OwQ9
qbbdxg48KjlfoTSJfjSO3kpN7KNy/yZ/meS0l/L7qn5Lyvn9Ej/7Rnmv+Bb/
gh3dU6lOaX+lA0gqv1Vj6aP8gMT+sUf4+E/je77FZ/aL8tZovyXGQZ19Qua7
h9x7Rn5T+GLaBLd0vMMWl0WeOn1ibIyB8TLHgSUeK+/Y+8/Kht3RYt1ZWm5b
ix/annYZutSmOpd2+v92Ftv6t9D/I1VnqfRslMr76/vWGu/tNRnrDjYS3eD9
rfhC1RlX9B5A/3vr2SC9HxryG6I0OLGuo/OnxVz7BcaYJF2dmzMe2FntXKX8
7srfrHls0J66qMp9nt/Rr8pmq4+uyg+VbrQhl1LbL9YMmzBUfQ1MGRf9odb7
kD3IPnu2znuNvYhNYI//CKzSYF+5Xs/9Otlvf8ma6Pk9epbzvmJPYWN4j0+v
0DjLlYoa5x/V9tsN/gaf0KXCff0g/Z+l/bum3PsLvUFnjlI/ffSutNz6QXl/
pRL1lVNfN4I31N47DW7rwPAf+A4wDPm+YQPZO+zbVfr2e9WfpTF3KzfuxE/u
mzI2Be/1T1k+rMsBpV6nwVE+GF1VGhT5jvL2smTHO+Q9pKNeYln3jzojot7I
wM/0O1LPD9Pe/+Cz32p+K3PWhxVao2s6a8wlbvOA2H8jY9z47S5KA2L8PPeN
PGPsH2PoFXX2T+y3JoWvf07y2LfeevVv9XOC0g96d2GVMfN3kttcreHhsqV3
qM50rcuJSt9ljWfBg8Qv4KFHw+aAxy8vNSYvk51ZojoP6ffL2icPp1zv68A2
YEzKwNcdNosnmGv3avsM/MWvpP+Pt/r3HtKLfzTbB7wRfTMnfOGj8fvBjH3e
PUrv5oy58dvsyblR/zm183m9Mehmtf+nOuvEANXdW+nNrPEHa4IdXpU25h5E
zCN59Glx/JGrdwxG/JXRmKdXGqdOCiyAvuFTiWGQyxWq+3ulRtX9QunzatuY
vmrnibAPo2VXRtUYq4LLwefEEdiVjnn0j+cWlU9V3SlKB2vM71XYpqA/YPbf
NXqdVkgO1+fdVrewWxeWGmudXW3svVVzuqbB+/tclZ1Tbcw6UPIerjRTc/tB
7Y2vt2/MgFuko1X4M7V9lt6dqv6P0Pze0e8Hy73/2/2F2vmP3h9V7329XW1/
prRCc7xZYxvb7Dr4xQNLvZcHhZ1E58H1tzUa2w9RGwOKxrOHqHxZyO1z6e8U
pXtLjE95jx1ARyeGja2tMbZtjxf07QPhry+udZxDvZtkk25W+p+MdXNBhf0F
NnR42NR23JOxfT5Rcv911j57jtoo0bd/TtsXdKwV9hjst2f4HnwQuAI92Dvt
2Hu/2L/s7500v1qlN9THsrTbwEfj/0bG/m1TOkzlw8O2HF7qMsY3rNRld0qu
1U1eR+odqucw6gY+xj8epPYPTJujGB04krlSb2ip6xY1v4LSGM2xs56dlMaW
uZ/xZe5rs9r4JG1/cXnEWuA6yj6O8lu01qkWrzUx44YqY0d0nnoXlToWzEQ8
+GM9f6pUJd1brnWuaTK+Tym/W72x+jjpxVO1jlWxpf9IO39aYCXsTLPWpKXg
d9jaD6MOWOuDyO+i910K9mPYqI/StntnZF0fW/CJ+v+4yfEzPgqdRp+xkZtz
rt9D8+veYjx7ruR/XrNjHjiR1yvt35tkb+5Q+epKczU8wTk36bsbW2yDa9Xm
CbXG1+jPG5XWoVLl31LZ3uCutPPwECeq/vO1jkX6Vvk7MPlJKp+hVK/yxrz3
MPuX+W2Kud+gsVzfbF5qboPxNz56TbVjUezKZSq7RGmXSu9X1pJ1XKT8wmbH
aqX6tlesy5MaS6Pk+X7wN9hA8AZ2kDw+olbvc0rvRizME6wFBuuIcam7Pr4F
Q+1V7/3+oNpPE0Pp3epy7zmw3+4lxpfEd+uiXdocrHkvrXUe2wuHcUGp8d26
qHNW1va4KvAp2AMMclLW7bBvSdRn/9LG3+JbbNqL4SPwt/hmfC7jejHGhs3D
j4Bz6rXODS2OT8CAyOn54GnQybKI418I/qRBdeqV1pZb/4i3iT3h97YHh4W/
RR7LSs0P0dfweK6K/JCI+QcGZl4R42GMK2KcrDH4GGzcP/wM9oc2Vne0o/21
qNq+b3nG75h7SmtSUXC9VGB2fDpYFR4HDgesuyp0/s8S5Iut5hfKIlbAxs3S
Oi9rNM5cVO5YjXjs1znjFbBKv5ztPjZ/mvIrG23bN0gfNzY7Jrxfz0tDb99S
3X8qLVH9qdqDa/TuS5Wfm7Ofmxn+Gz8Od8RzWuThlMjDl36ouu8pJVXGHGAX
cMXLKvuL0jbVy+xiDAd+A/dSBh9ymvo9vsVje1TjnRc+d4zybzVa5nB24A90
4AW1sVnl00vsS9t9amJ/z75iX3yp8d/XbKz1UnCFxKT4zJPr7TeZ/9uVrvO9
2txpF2NpMOb3gTPhMz4IfgbOZ2uMeara3xgyZ91PV/kmyekl9bmy2fVW6/l6
yBNeDJ4IjmiG1vZPsju/h7urMdcMzzwHflvlq8rdNutK+8h4Zsj5PwXPjTHj
J4ldiU+/1bebay2rRYFD8e/NkmtlwRwEc4GjAYcdKxnf3uQYnHkTSzD3u1W2
GDyHbdV8X4n6nYhdWszDrsK2KX2hd/+SPC8tWI9fD9uNPYf3ejXktjJjjpU9
eIG+O1/p6eC9nok6z8Rv6mxQ/xuVDtDvu8uNI/BLtPNSxnv9+uC7wZNVGvu9
MeaPKlyOLR0m7HGI0vtZ+/x5Ofv9zcp/2uQxDtHzoCbb4MY6c6/4WbDaN8Ez
fKI9/XG1Zf0E+FZy/nmJZZMP+SSa07CceT50qiz0ChkiB/r6UN8+V2vuCx57
50rzT39U2fFN/v2w8seGf3864gVkAn+N/cLOPJJ27I0dguMG34Pt4SvARtgl
no8EToKbgQ+Cn4FrfTxtLveJtPPdSxwL47uIj4gR7087juf9Y1HnC63zLRpf
Eb+s5yetrjezxn0tC9yGXqKTD6mvntXGUO9K317Ked8fkTaeOiAw7f4RA2Yj
Fic2vJp4X+mcCseII6IcXofxwAcep/6nKFVHbEOMA6c3IuTBuQ7cIRwT+Pk6
yfU7jbub5Pq+9tnP9G06bW6vKm1+b2Z5cK/oT5XPptinAzSWV6Qfd8GnMadq
8030AVcO13RcjfOM4coa40XWAp4HjgfcuDjGSp1fZowfwZRwM3PKjT/3D/wK
dr2HNmuMVburz2Mz5nvhcw4NHuBOje2ksGm/yJjTBctOVX5cmXHw+UXzp3Cn
nNUsrTdH/Vje51ucbc0pmqOHn/864/fbI6bmTIhzBzhd9h77bqrqniZ59sr6
bIM6xGXboj5xN/wBuoVedVO9rlnjY8bE2JjjbirbNevf4Pcjyjxf5IJ8kBt+
uHdwWV1Ud5es64Hf23G36tyHPiqNTZsHr886dgIPUrZ3yA1sj+xubDXfzToe
l3E7tPeDdHVkvWPWKRn3w7iIB/iWNQIHonfvEI9nPCew/8MqH5c2D3ki6xu6
9K84L8B30MZBMYb7Gsyzgw+bsy6nH7DqgLRjAdpjz7BfsLkXp62TP834HeXs
J+qw1+iHMzbOJq6Xzb5Babb0+Pmi+Ys7wibA264uc2wPj03826o9/kLRWPgr
6dXZBWNJeKlzgpu6pcFYBBzypfbUUO3rwzWuX6ns542OHyfHORs+99/EwTnv
lYkZl+PHOY/jN378WrU9T2mSfl+hutcof1TGtoQybC91j4r6P8s4HkWGxJoT
o81b9d3RRe8Dzplvy1me7I8LIl6GO1mYM39yc63tGjYN3vzkWDN4+j8UzFVS
zlqODU6N/IHxPCnqL1J7Swv+vjeYv8FnrdjPRzK2txtUZ1vBv8Gk+DJs+1c5
+3X8xcaIo/Ev+XrzKeDJ98B1+Fm9q8t67Vl3+BLqg89pb2W0Cf/zcnBA4Fi+
GxR+dmX40GNDhkPDjvAbbE/ZsSFb9G/vKsdNc9TvnCpjAOzFoXHuPLbW5+Id
59A827nVrM8/wPN7Su/2Ujq4yjaEJ3akSWW/bjE+oX7f6KtFZa0t7nuKnlNb
dtjpE0JvOdP4ps44GH4OHYejw2Zju7HVxG+cnbMX+quNAS1+R3/9oq8+kedM
5Cit24F5n0HAO/ZsMY7iDPqiaJ8zDbgS9PxnGkPvvPk3eOiuBdfjHOOAaGem
9O7M4IIYfzp8zTmNPgsBg53S6P1Dm39V2Tjp6Hdq59sqP5nLCWpzft53Hyao
7ht5xwFbJIO6Vvv3BzT+5YEtkcecGPPwaIt2Pst6HMjw+yhn7idkfF4G33F8
xud18Dv4XHhkfNzzant8J3NA2Ff2AHuCM9qNobevRR4uaIL24nyNrynrc2nO
t+BArqqxj8Q/Yg+wF+D7Szr5ngdnuuCyx4vGZsRonI9uiW/JE6/1UZ09moz7
FtQYT4OlWzTOFfr2nKzjA/YM++VFlf2Zc8Ssx/he3DN4Oc6upkc8SD+9gquh
DXgY6n4Q9eFr4VPgC3ieXmNfwHlBLs7fiZ1nZR1Pw7HVxt0A+slHX8yd39hJ
bFg+7Ca814DgtJFbbbQJ9uxStJyzEVPjl8EPnD+BIZADec6AuNNCTEpsQtzM
HQJiZ/Y3e77dB6lsSeAMzo5oCz/ZvpfLjMn4bl58Oz7y+HzwFXgJPPapdPjd
4DmJc8BS3UqsR5z/4h8Zy+0RI98eY2su3eHL8fuM/+6Yw12RZ03hUVJxHk3M
xFozL94viDqFlPEWctgUskAOHW1RDgd2WqwX+Ore0KWrIo9e0s5d0Sa4En2B
B+PdPYHHWJsl8S2/kV9byPOeKO8Bd9Rgbu8RFD9v7oQzpRlxdswZwrQ4R/iW
s+yc+YMx0usHah1LEGuzlswFmS0MuU3Qd+/lvafnKX+dUrdq82fprPkE+Oxj
Ou7AZP3+sMD2W+LeBdiyR7XvAaAb/MYXYPOxfdiQ/twX0F7+Z8bnEWB7fB94
8+DgTumrEHuZuy7nhc6Pjzz606va3/MtdqZH3A2grFecc3AfZEvcBcImcdbf
zjXHHRpEuVPcdSF/Ro3jEOK0JfU+4+Qsk9jtjCivjfqMZ0xgZLDluLhbwz7K
BX+0LTgi+Cn85qzg/4mDuK/Ab+whdq0hcCZYDPmC/YgzqX9mzH1C9HtMnC8g
n7GB/cGuxBOjqv3t5Gifvthn40NuEyIPxsbewEO+EzgEWww+YRzkscmsK3Jk
bx4pId1cZ4yJnJAJmKcNjlM6s1n13pSe/rXB9yC+ylgO6A+2+ZhYU+TI98R6
6At6An54JOJA2kTPJodN6xnzAi/Vh6wY56S488P6fhhzY17I7NyYO/Njntha
zn+4C8X6c79sj4jrro5y7PMlmuOlSqOyPidojXMd+jo65MC5EHEa8Re2i3La
OS9kyxpxN4c2uJPH+B+KdVmbM19weaw1WB/MDV/1bZM5q4vV/4o6f8t3D8e3
n8bdNsYwosZ57sgRQ6wJPpmyyVF+kvb9pKLPGHaKeXM+i3xmhV5xhjAq9L9f
4CfwDGWjQyZzhQsa6s2LI6dRUc6enhP36jgvOyTrsxhi0mKca1AGpwafxp0d
zvc5G6Wcbzr4Np7Is2+MATyFjeVuBrwNHA55zgVmcC5RdBxIzNU5zk2IVXfr
iAHLvB+Q2/jwM+jGaM1jet7n1eM4i8/7/sLJavOYos9gpin/k6Ljw+u1Jtc2
Od7Hv1DWES9Sl733ierOiDanw70UHYsOr/EY8F/Y2yHha4jjwSzsWWLDLhGH
np21v68K/EOcjY9GVkNDtshgUMjhQs3llJw5YOZMn4cF7wQWARtwV4b6yHKN
6p5XND9/o3zErTnHAHD/O8d530fKzy6aX0Lvh0VMBzfJ+PG5o8JuDwlsg56g
R8x1TMyX/cHdLHRsAuebjear2E/sK3SA9/NrPC+eUyL/Zrwjv1xjacpbNryf
GuWLA2/Ac4CV0UXwMPfaOFuC7we3zgm/Ax+HzYT7+q3W/XdKDdWOudEjuATw
AGXwT1NibMyDuJb49viSHdiR9YOfGBc2n/MDzjW6B8eCD9wn1vjK8PXsTfYt
9gKMcFX4d/bl1bE3kQ1y5z4tnEC34DpYB8pZl2sazdHDz8NncKbC2Qz6d3Xs
Tc78T40zAu68VBeNpTtr3TsVfK7I/am2iB2YI2fYF8YebY19Sp+UMx54p+Ni
TdtqPBfszKiwLcXw3WeFnIkXuCtGXEA7tMv44a4WB7eGjcA+4UexI4NiHbkX
171mx7i6xxjAg8NqrGPoIXn8wqvBNcOjvhJ5+FLiqrGNjq3YT+wr9P9r7ekv
msw5oLfs1VFxb+CswNu3SE4LcuYJsNEPBQ8JlwxfAFdA/8NjPPiUtpDJwaGv
2LQZ4c/wZaw9dTr8xU7hl3sGnqF9xrgq4nHOdMATW0P3OA8hpiBmYE9jGz+X
fd7eav/JGSTxHGc6azX36sIO28lzfZz3oBetocNdgmfbqeC7yJy/DZYdGFPr
8/Y3JIP+nawbxItjW90He49v4VRZn26xXsQIu0VMQYxPDMBveJ/Zca8bPo0z
V34/qzb37bTj7jJPuPf1edto7PPi2Otg46/U/5et5p4LBfNNHwWnBjYHj3Hf
ZJ+4cwIOB4PDJ4P3F4QdvlLr/xul3SrN8R8WPD+xALgdvL8m73vJnL0MjjtI
cMmchzQF57AiMF63kAO6i64ep/eLiubIuCvIGWrXJO4axDpeXvBdf/hm/BK+
hH0M9kJHDk7c3vRos012+t7O8knK3y3ctbjZZ9is2Rehv9gA2sCecH8XPEc7
H0tmH9SZk4ff4ywKLnGF2jwi7gDzPXwQugd/jMxZ37bATIypRON8rOgxgVG4
Y8v6Vqf8P4Gtqr9M7x8u+h4H+Ou0wGCc1/0r+sV+Iwf64KyL8cCxcI8UfmJT
4Jy2sJkXax0u6uQ7QYyR+bKXOQeDs4CvgNccFnw7+lWS8ri76n03pbf1e7zk
8GbevMXE4CrYd9yDRhZDg7OiLnF6z8CexBqMb22cjY3M+wwM+/mq9sisZp+1
7NHiu3Hw28RmJ4fv4NwG/4oN5D4R8oBH5XySszfO3X6pb3/RYm61g+NmHfDj
7Hew+qdaw8mN5l4Gxp00ZI7sWQPWgrv5cDrwOYvU3m1Kl1WZ88DvYEvg9bgr
hq+AY8A/Y/e4X9M57E0Hn86+O6fosyswye5qr0eTMeca9fVGg+PR/vW+Z4mv
+VrzfTx0FbsMZ4dM/qo6b9bvuIPOE389vs68MJwwfNLw4JTAL8wfzHN1g+9U
gZP5rwL34DnP37/F/wWCt4Nz3xh3xbhnS9zbHr+XWUbIB5s9LGw+318e3Abx
DrETsQNy4a4SfnR2rf+7wu9pEUtzfs3Z+PSceZX99ZzS4HPw9+p87x/OZg+V
9VHakHK8Pi1idnigdaFjFxZtZ7GxbZ2M1dDtI4M/g5uHn6QNcPR+muu+LZYR
d7X6xv2No+tt97H1T+p5Y52xyIQ4W+CMjHuv3FPEv9/QZL4SjpF7+kNqzY1g
z7ZH3MoaEY+DoZAZPrg9FktZvnBAe0YeOXM2AfeDPc4HD0QduEHu3DMn7pGA
WdoxkvZNXb25CHARvAeYaaHs4m0FxxO367moYLy/RM97C47779bzroKx/516
3lEwps632v5iexcUzOnD54PT6mM88wOjtsdyKd8FYU1/orrDc/7/RzUcavz3
qsPG4de4c71XnMnhc1rjbK5vcEf4Gp6FyGdjb24NmdRHX6dwDlw0t8UdDsbA
GPE/hWj7fcnndK0j9yI418eX4EfwJ+SR4z0a8+KCMSPt0AZYlLOXs+L8hbZ5
R7/cA4IfBYMtDG6PtcPuMlfO35k3/z17PbAtbSI3znbxIdyJIL5eExwCOIc7
EvhBznlWNdrnc+5CzI+8KurNz9I3/AHcCvE+Z2VX1nrvnh/jZPzwRF8Fh0Cs
tqDeeIB5IwvO8uCo/hl17le/9xWsa1/Gt9tj3bKxdvDOS2NfMy/GTF/0uS7k
c4nauLjg38Q+xAabos/V0S9j3xzjZ37L4vy8S/Cq+E10Ah0hDngAPayzz5kU
2BwMAN8/v8VxDOcs7DswBbaYs31wGmekU4o+J8XmInd8COvE/wHwlZxhcO8f
fMd9f+7zd/zvgif9cReI+uBJ9hk8I9iKew2tdeacuB8GV889T/YA/5Xi7hiy
/DrkuWvB99e7xhkjvhKfOVDrM6LWd+sWBofbLXA7edqE66V9eIzH8/5PI3dL
ube4d9xdpM7MqN/+/4jENhCscXrsRdo7M+qgt+AGZIDPx/dzVst/F16L9YJX
5h4t8TF74tu81xJsuD3wITiSe4rga/zz1+GjwRC0C2e0B7alzueoV3L/Nu87
Bg8Hz0OsMDvwB9+BbbkbDa49VbL5ZdFcJGtUEWu3oM53suEtKauMcmKBzwPn
oDesP3hlSawd8WPH/zdGhi6Uxbf/BX+6WVM=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHeYVtURxu8uu8vufhj2q7tfWTrYsIAUBZXehAUWUVFMpAjSpBiNiqg0
QSNiovQmRVCKglTRSEAEWwRBjICABLEAViR5lJb83rz8Mc89c2fOnJk558zM
mep9hnUbmh0EwaysIMjhm0gHwT3FQbCZn/8qCILppUEwLxIEHcAvrRQET4M/
BfwEcxy8RyIIuoH/GAqCnRWCoFksCG4UwN8e/GfkzQoHQRPwjYVBMC0aBLeB
f8l6w/i3IRMErwMHWetJ8CLmPgL9/opB8HWO555BxtZCy6gK743ocwT8MLAO
PAuZw1h/KPAyuiwpCoJOyO+Bfu9A74jMccx9BPqz0K6IB8EXuegBrIc+lX+h
LMtYyfh3rPcZ+tzMv7tS+AH5BeD5QC3mNkTeVuTtZf6jJcgF1oC/gc6rmPsa
MATdOuPPMuS9Bv9ceDsCHcCXwL8b3vbgd8DbEyiGPxd/nWS9Q9i8FnwD6x2H
9h2wGvxZ1vgb9kVj9s1C7KsMrQj4HN79BdatAVAn2zpux76q0E8iexT2zUoG
wRj29yz4uPwgqI8u9YCh6DMMaAi9PrAYelvoPyGrLvxf5+Ez7DnLOID/Jniz
4bkY3kuAw9D/yHozOQ8H4TkAzGDcnLVT2JMEmjH+AdjG/j2cZRsnoN94YDay
OqLfeOjjsbEQ2/bl+CzsRM7cPJ+JdqzdFihhrQfAz7IfFeHJ0zlh3Bmoz37V
A8oYH8ffE9GlKryTWPNbxk3Ez9o38G8hsorRZyfjHcBfWf8Z6LdA7w70Yz+O
Ims/ZlfCv3nQ4/C3Q9ZO8A7Mfwd9j6HvROaPRNfFrPEi8DDjTqx/Nf5phS/v
x562yF6PT+fn2oe70TEb+cOxPY2NGeQnoz6rx5DfD/o3yLoe3mWsOZ/1PmH+
SuZ/xL/lrNEGma2BZYz3QIsz/08h87xX4j3TXn0Pf2N0LwOvwHgv8AH07cCv
2PoDeMD6h8O+q9tYP4yst5G5BShivARb52JTLXQpq2TfdOffyZB99BGynoQ+
nrknkZeDvNy0fbUDmKbzhj9a449t0BeDv6h/7OeebO/1n0sdW7TnO8DfYo3R
+G4XMAjdBwNR5n4InIb+G1DA3IPQq6LnQPgHAFUYb0T2qBLfzSPAAWzbin67
4Z8MlER8BrT3HwMfIWsDcx9E1mzWr4f/m4BfB1zNOBfd84AM+l/P/LHIeiLj
s/skcwai+0HwA8AAxguZN5Q1s+DNYQ+Ws9aKEp/H1/j3Uol9INsVEzZU4Z5j
Xw3Gz2f5rOxj3Wp5PjOKJZ+Hrbtiykrwd8KOpZcg/13G75d4L8W/FXwsPI8x
ngX8HPOd1l0ej75vo2cJOo5E/4eAA6xVhf06zl4NYP1l0I9hx7fAUsZvYG8a
+tfQ74K+QT4ucq5YgPxR+GYT/95SHGd8hO80vqPx10boR8G/BPoz9wN0LkBW
Ofa+y3nbjYxIzDFOsU13vAb6jEd+d+Z+BjSA1hDYg65joU+BthW9HgbPR2Yx
8kqAo8j6EtiJvCtYvznrr2D+l/jjcmQeyrU+Efb/d8zfXegcsIL7/k/m1MM/
nZn/KePRiiH4ajX8O8BfLbKuy8DPg1dE/zzgHOPL+V4GfJXnmPlKkeeIV3eu
Pvu7oirnAKjHeCR7dSrssyAeycoFci7ITALLUxd0yXOueRx4s6JzjnL19BLf
JeXsgazXDGgI/0fwr8JXSWysjW2j8OmUtGOWYtVt2Hyi2HdKd+lG4DFo/whb
F60RgragxLFmF/Ln48te/MvCHxPxaTds+Du2bALKGffl/pxh/dNAH8Zr+bbh
2xpYw3gb+szmm0Gf4+jTG9mfhZ37p3F+Z0HLhbcFup8GprNehPXG5PsMnYv6
zuqufpzj2Nu+xLIUgzcXec+114oR1djb6hnXCr1ZcziyCtF1JOMY9C/AP63i
2KoY2wVZs8O+2y3R5znOylusVxVdfkHmMfbiW+A9aCvw8TrGy/DpAOS3Y07d
uM+4zrbOWEPWvj3i3F4G/jr63xDzWDGmC/pOw4Y66N6SM7egyDFIsWc+9CLm
VwYuyfYZvQxZcfAYcGnEtVAd1tyX65poAngDaP9mXMCdKAMfHXFs+E+hY/12
dB5b4JjfCN722PsQ80+Dd4L3Gv6dKrSMLei7GZiX5zvwBfTDEccy1XCdkLUO
H64FOqZ8Fu7Enz2r+EyMK/Id1t0dV+Dc0CDp2kI5YlvKPKJJp+PYfgJ4lbWG
If80aw2EvxP4XtYcje/GADvAa+KvW9C1O9Ac/3SCPhVbnk/7bNcr8F07iH8P
lPrOtUCX1tBbAc0Zdytyjavatizw3akZd22nO6Ra8nzUuUc15aRSryHZCebE
Y76juptX828E9gwHJsHfHhtvRbc5EevWB53mMu6vvWNvuisno8fBsGs75aQT
4AH09wtd8/VjvB557bM9RzTFJMUi8byi2MC/KLSurH+M+d/wbynjV6G/Cr4A
+fcWuiZN4cuO6Psoa9dDvwGMb8bfy9C3ckWfrduxv0fcZ6wr+k5m/Az859Bh
IrydVVsBExLWbQVrDCy0jorlx4pdWymmnwi7BlDuVw3/FXPSQAo4CrRHzses
M1yxGB1egP9m5aSQ93Q6689g/p3MjYRs6xT2oFYl21wuHTOuteOqb+HvkvG4
GAgxLsw4N+xAxmzos9C5WYHX0FulW8a8erNUY63qQM0818zLGd+t+xeyjUvB
+4DXCfnO38L8W4El6J4NpCKOuYq1qmnKJR9YAO1H5NXB3tlJ197nwTfB/3nc
uVo+roFuyaT35hBwHH88yJ2dDG0R8n5J+Y2gt8HrBa7FdkUdK1STKVaWMr9B
vmPmjKRznnLdWPBK6H5Rxr7QGyGKPauQcWuW32DzGR9ivf+yf2+CV4IeAg5V
sI2zWKtSyrFXd/Icup+P+y01Enmladewql1VQ1yLvH3osBdozDgr7RpTteV2
4BX+N0VmCFlDkbEI/PKo88tU8F4p+0y+0htsDWdmXcKxWOexdtI1iGqPptjX
J2kbpPs94IPAz+Djfcy/EnwRsvagb4b9fYp/A6B/r3xSwTZnwNeCNwnZh4vR
9Q/4qwZ4f3xWGf8WFTu3XpXv2lg1j2od1ciN+K5ifiP420GvK3uS9o1qAr0F
OqNfy3y/CVQLv1vi2lw1cWNkXIZ+B3OdQxbp7LN+NeT1Y/2XwHuB1wK/B7xc
9SY2rcxxjL4V/JZSn0XV5Ncwrl/qWk41k2LDtozfgooRtZC3LGZf/wR+Bllj
Sr03O5FxDfQH0Od+vasYN4a2KeraUXdEsbQxtEZxx1TdbdU4qm10x4/gizkZ
157KmcPC3gP5XjWx3uadgFo5fqO3TjmnKJe0UmwDylKO/bpDe5jbBfyMagGg
g/I/8Hi23+xXJl1TqJZQzbe92G9QvT23KfcXu6ZRLXMVsID/d6BfFfxxN/7c
F3YMVezsoHzK+Im036IbsbdvqWt81fZ9gMNR9wjUG1AP5AV4eyAvw7hvod+a
x4tdW+nNOQ98ps4U417KB2HHcMVuxTi9LRMR66Y35rhSv9H1NtebeAJ4Xsxv
HeXsRjGfGZ0V1Qjtws7pyuXqKcxW/yXt2kJrjuHszWevzuo9gI/2w9805t7E
Stlb7DOhs6A3Sld0a5hwP+As/gxDa5pwb0Q9h5qMhyFvKFAj4dhazhqtAsfY
4fjnuM5rnvdYvYeZScci9SBU+2yEp00F10Dz5Y+0c6N6To8j86aoc4NyRE7S
OUG5QG+wJLxdE36LqObXXS9P+Wzozr8f8xtWb9f3Yo6ldZKOFYqpvfk/BN0H
A72izo0lSccK5cjR6D4GaBvym+Uv8JVHHHsUr/fGnSOFq0acwnh91G/9WcCj
zH0MaBXyGZ0BfStz2lWwzcq1FwGVLuTcBfCeiLiXNgAdntZ7OOHeit5AEWyL
pkxTzOqJrn2TjnWao95N46Rjj/bsQ2Rdl3QtIvwo9i9IunZXjNXb4FTKuURv
BOX2segxJu4cr96KehrqZajHMgL4NeG7oDflBvgm8m+C+hqMn1XvChuGYO/F
6LwK2fPTvgstwQsZr4E+OOScsj/qml+1vmq+eTHL0FzFtJ9SPqM6m2vR8T69
FdK+m3rzq3c1KuxekHpYa+F/Oe3Y2Bb6VM7XDP61ruCaYTC692aNXsAgxiuh
zUu7NmsB/2vgC9OOBa2yfZbnpH1XdabVC5AMzVVPoDPfsoR7S/LnzGK/gfT2
mcG4XP2LItdWd+a51kpEXQuo5lIvUj0K9SbUk7w07jez8rVyQO24awLVAqrx
VzN+Me1c0Br91oAvSTs3tQF/jvGWItfO6mGtTLvGVW2rGlC1uXp06s2pRh8R
c02nWm444znw/pyyr/VG091WDlDs1x1XbuzH+RmY7xyp3K6ei3otyvHKlcOQ
UT3knKlcGON/3XznxK3YfnnKvSHVyHpr6I2it4neHG8wvjbm3mjLkHPfUORV
DTkHqha7D/zikGuy1eCT2P9BIZ8p5cbhquFDzpGq1UaA1w65Zgui7pmqV6oz
qrnq+anXJxmj4H8k47ei7uxp+E8lnAv15lCuuBd5pSHnjN4ZnzmdNa1xI/wj
Eq5lVNM8Ueyem3ptiqc9Mz5jOluySb069SzUq1DP7q6M91R7KRv6ZvzG1NtS
Nv8+4zOgvZePlWuGqCcTcs5RL1E9cfXC1VPsn3SMUGzQnql3/0yp3y7/7+En
XdOoltEevYOuEzOOXerJ3p7xHdbdlc1bwDdnXIuqBzSO8diMezGKkXWQdXfK
vVL1hB/Dv0s5Ny8Dj4aduz+JOpcoh++PO6YqlqrH9V3YPXz17tUjflvxMuJc
pRyi3sJXemPH3WNQb3Byym8v9Qg3qreMPi1Crmk/gW9X/EJvFSiOuuelXpd6
Rup9dUv4bqoH9lXEPU71NhUzJEtnUmdRMidjX/u4e3Pq0V2VdM9AvQLVdLdl
HFMUS7QnyrXqEao3qJyr3sbMIvcO1ONQr3Ii531CzD3LRSV+w+vtrp60aqvf
0OfXUtdY/wP5Gn29
         "],
         VertexColors->None], 
        PolygonBox[{{4487, 6369, 2048, 6368, 4486}, {6025, 5454, 5453, 6030, 
         1826}, {7492, 7338, 7337, 7740, 3041}, {5545, 5547, 1345, 5154, 
         5544}, {4708, 6273, 6272, 6350, 2034}, {5752, 5233, 5232, 5749, 
         1650}, {6559, 4276, 4275, 6560, 2183}, {4157, 5374, 5373, 5378, 
         1345}, {5229, 4961, 4960, 5796, 1392}, {6353, 4478, 4477, 6351, 
         2035}, {4418, 5803, 5802, 6134, 1861}, {5649, 5861, 5860, 5855, 
         408}, {5605, 6038, 1828, 4348, 5604}, {6055, 5628, 5627, 4360, 
         1836}, {6053, 5755, 1042, 6050, 6052}, {5217, 5775, 1659, 5774, 
         5216}, {6109, 5778, 425, 4399, 6108}, {4949, 5441, 5440, 5777, 
         1659}, {5255, 6131, 1861, 6130, 5254}, {6285, 4723, 2047, 6367, 
         6284}, {4421, 5521, 1523, 6139, 4420}, {5732, 6041, 6040, 6039, 
         1035}, {7534, 6086, 6085, 7754, 3068}, {6069, 7494, 3041, 7740, 
         6068}, {5493, 4928, 1650, 5751, 5492}, {7389, 7535, 3068, 7754, 
         7388}, {5981, 5321, 5320, 5978, 1800}, {4914, 5224, 1390, 5729, 
         4913}, {5701, 4274, 1800, 5980, 5700}, {6035, 5425, 5424, 6037, 
         1828}, {5484, 6110, 1852, 6119, 5483}, {5389, 4161, 1346, 5391, 
         5388}, {6273, 4710, 2035, 6352, 6272}, {5560, 5559, 5558, 5162, 
         1346}, {5506, 6054, 1836, 6057, 5505}, {4724, 6285, 6284, 6371, 
         2048}},
         VertexColors->None]}]}, 
     {RGBColor[0.791386414898811, 0.85658716465359, 0.901148599893998], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmneYlFWWxj+gU3VXQ1dXdXWFLhGQoKCOuK4B1DEiihh2nRnDYM5hFXNc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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHu4zlUWx3+Ow3HOQe973ve857w3EhU5TcU0nULlrpKo0TSVni5o3ELG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         "],
         VertexColors->None], 
        PolygonBox[{{5262, 6354, 6353, 4710, 782}, {7897, 6112, 6111, 6110, 
         1053}, {4911, 6565, 6564, 5224, 1032}, {6570, 6575, 2189, 4924, 
         6569}, {5808, 5256, 5255, 4969, 1665}, {5322, 5708, 1625, 4881, 
         5321}, {5563, 5661, 1606, 4844, 5562}, {5218, 4950, 4949, 5775, 
         1389}, {5168, 4721, 1542, 5560, 5167}, {4354, 7970, 1605, 5649, 
         4353}, {6725, 6058, 1837, 6732, 6724}, {4305, 6571, 2188, 6573, 
         4304}, {5550, 6700, 2278, 5059, 5549}, {5792, 4955, 1053, 5229, 
         5791}, {4851, 7490, 7489, 7494, 1837}, {6592, 6589, 6588, 4939, 
         2198}, {5841, 5550, 5549, 5058, 1695}, {5706, 5315, 5314, 4881, 
         1625}, {6132, 5253, 444, 4418, 6131}, {6589, 7377, 2951, 4936, 
         6588}, {4479, 5546, 1538, 5545, 4478}, {6572, 6570, 6569, 4923, 
         2188}, {7375, 4322, 4321, 7376, 2951}, {6370, 5271, 791, 4724, 
         6369}, {6032, 7867, 1032, 6025, 6031}, {4705, 5156, 5155, 5547, 
         1538}, {6078, 4379, 4378, 6976, 1842}, {7980, 4401, 4400, 5778, 
         1660}, {7700, 7731, 7730, 5659, 1605}, {5463, 5390, 5389, 5465, 
         1509}, {6503, 5563, 5562, 4845, 2154}, {7532, 4946, 1842, 7534, 
         7531}, {7773, 7710, 1660, 5785, 7772}, {5561, 4488, 4487, 5559, 
         1542}, {5317, 5982, 5981, 4274, 346}, {5375, 4160, 1732, 5895, 
         5374}, {4929, 5234, 1393, 5752, 4928}, {5152, 5809, 1665, 4969, 
         5151}},
         VertexColors->None]}]}, 
     {RGBColor[0.850255033358898, 0.876218280300141, 0.874775511577969], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgmUlNWVxz/s7uqqXrCrq7q7uqoL0SgurDM5Y1wTlxgdFTE4LnNE4+4g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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXuczeUWxn/MjJkxjmZm75m9Z+89M+6XyqV0QTqFkg85Fen2QS5JQieU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         "],
         VertexColors->None], 
        PolygonBox[{{5806, 7689, 1408, 5808, 5805}, {4722, 5272, 1412, 5561, 
         4721}, {7965, 6566, 2186, 4911, 7964}, {5733, 4298, 4297, 5734, 
         1644}, {5542, 5539, 2, 4158, 5541}, {5261, 4706, 4705, 5546, 1409}, {
         5553, 5557, 5556, 4162, 3}, {4544, 6377, 2051, 6376, 4543}, {4944, 
         7533, 7532, 7536, 2953}, {7525, 7379, 2953, 7530, 7524}, {7491, 4850,
          2918, 7493, 7490}, {7330, 7659, 7658, 7339, 2918}, {5820, 4544, 
         4543, 5819, 1672}, {4796, 6635, 2217, 6634, 4795}, {4328, 5760, 1654,
          5761, 4327}, {6640, 4796, 4795, 6638, 2219}, {7695, 5704, 5703, 
         5708, 1447}, {5789, 7795, 7794, 4955, 1661}},
         VertexColors->None]}]}, 
     {RGBColor[0.909123651818984, 0.895849395946693, 0.84840242326194], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgmUVdWVhm8V9YriFQU1vKp6NV4MkAQ0oivdtgHsFguiQpgcozFGmSEd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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmGd4lFUWx9+ENGaAZJhJMplkZkAI9rYr+AjsBxZRsFDERV1XwUSkqZRA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         "],
         VertexColors->None], 
        PolygonBox[{{8058, 7230, 2816, 4726, 8057}, {7228, 5987, 5986, 7229, 
         2816}, {5149, 5807, 5806, 5810, 1344}, {4164, 5554, 1541, 5553, 
         4163}, {4362, 7975, 7974, 6059, 414}, {8076, 7341, 7340, 4850, 
         978}, {5543, 7798, 7797, 5539, 1537}, {7978, 4381, 418, 6079, 
         7977}, {8053, 8055, 8054, 5272, 790}, {7382, 8087, 1048, 4944, 
         7381}, {4987, 7682, 7681, 6152, 1068}, {7677, 5434, 5433, 6982, 
         2563}, {7684, 7436, 2992, 7438, 7683}, {7755, 6089, 6088, 7539, 
         3069}, {6062, 7744, 3066, 7519, 6061}, {7018, 8058, 8057, 7017, 
         2596}, {6020, 4324, 4323, 5353, 1470}, {8051, 8049, 781, 5261, 
         8050}, {7411, 8047, 8046, 4984, 2970}, {8047, 7009, 2587, 7008, 
         8046}, {4303, 6004, 1464, 5343, 4302}, {5490, 7667, 2557, 6965, 
         5489}, {5705, 7694, 1446, 5707, 5704}, {6136, 7410, 2970, 7412, 
         6135}},
         VertexColors->None]}]}, 
     {RGBColor[0.941175999999999, 0.906537999999999, 0.834043], EdgeForm[
      None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlEdoVVEQhscSS563vJfE90xuFEmiGAsKKpgoomBbKGIDO4hIECwLyVKx
IFjAhSAqViwRjG3hwg6ujIKCq7g09oJGUWOJid/4X7jDOXfOzJx//pk5Q9ds
WrCxp5ntRnohVyOza8jnYrPa2CwTosNgYaVZW4lZe8ZsMvoD/D/qYzYN28lI
rp9ZHn3BfQj0DF0tvtvZn2F/FrlDzDGcV4SyqWE/DDlJ/IaC2T1itg4wu4Ht
rcDsCPoqzqtj6aeE8nH7Tmz+IB3gqc8RB2lFX8r5A3y39jC7P8jsHf972I9g
vRsol7bErJn/+eivoesgDp8Vo+uPdBPzJeuuvNngvmZ7sX+cKObzrNn+RNj8
npuR9E2lZheQg0XiozwWJ3/KzY6DYzf7dvB/CcWb31+eCEOMriwW/p/w0FGQ
bzV+VUgd+znkNzpRXS4Fwu2Yd5aZzY61d87Gh8Lm3B9O+e+sMHudFW+vy5SD
22yB7wv4zgXDJgLUYD+zP/jBXI98595v+DYmqt1UzudFyuVgKNyO+QbrYqSh
t9nlSvm4fTP9MqEgvXPzY6D48Z7yengtnJsTKT/3iD2Ks7Xwv4r9ilAYstxf
k9b3OfsXyD5sOsl3HHEmoD9G/K9ZxVyNbV2iHtvA/XMHqQec+ymR+O9m3+W8
U9/z5Ho9J65+w8+blKtZxF7CP5T8z29RmmNDTnd4fI99P43vXF4piM9u1tK8
sHmM+lhxHNeq1PcSWJqRT3DVN1Tfe13OguccMhuHU9ifTMRJC+cPI8X5ALcr
4fpXRrV13I7Z58D5cq4SbFrYb8uotmNj1dc5+xsI2xXWTIrtKWtdTv3supb0
rmH4bo6EZxl3vi/R3P1F9yRQ7j4f7u++61mPYzeJmd3hdaM2teRbhL5P2m9b
4OZJLP59Di6m89jEOicvmyEF9ZBz3ki8jyWaTee4KY0zHQwjQ83Idu76XtBd
/q70C8XJ7UB3u73nPTxU7v6GhXn1Qxc9+yXtn7dZ9bH38CiwzcipRt5fbuc2
jf6eBcLcXqG59Zl1XWsk/atE/eq9Ws2do0Nh8744lBWGz4HOXN+W1Xx6D3ge
zp3r/b3Mp++qsfaIVfd38LEUnD8yem+KQmHw9+xn+qZ5X79M1Nu9URRFetP2
Y1sVaR4fB6ql19Hfy+WV2jvGo6XC2RXIx+1P05unytVLPt8T0xlf57NLnGL0
/wBQfODM
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHmw1mUVx38ssgjv77nAZfMuLyiJYGNOjZpAjAbuGltqjRQIsonsIKCV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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllElIlGEYxx9LHXWc7xvHrHFyoTQDl+rQgrlVUGRgRFSHmjyIkARplA52
KQoJ0iLKFixzKSVotaiocDlVhJG38tBBvJQpjhWNuOT0e3kOf+Z9/u//2d9v
VlTU7K1eJCLFIArsTxf5kSDSFyfSZYucBG3JIq2gjHOJJXI+RmRkiUjtMpEk
h8gC3HVQ4MYH/3h+n7pEYok3kCryBTzHzoAfjhdZ5RGpTxO5ik8zGKaA4HKR
KeAhdhRcO7lOoTmKTz4+Fr834dtSRDpApVMkF7sfXa1XJJP6NuObA5cLdxHN
JdDH2QHXQo6N6DYZLdwbuKpIkQCaOvAa7p6tfQ/T21dwBU2QurMXi0wkck9v
DuqIA2Hyv8Suohcn9164ZFBHr7WgLEIkGjsGNDCnceLdIF4kOdKYmZ8Z34dr
ZugZcFPkqUJbCAajRYrgeuC+oRlN0PrX438NTNNDPrm3oNlq68yE/sPwG9Ct
RlMCnwE3hm8s9jZb59Ph0zwmdg3cDpaUD1cI/nLvR+uHf2d68+q+MtGvBEPg
FTv5iCZs6e7zmF0CXDR2D35B5vePPc6DdmqJge+GbyBeqUfvn2E/AU34NoLT
zOotdi94aGaGbz3nANjDXTuaNvgX1Dxg6+6rqe0YuMD9EHwOfAj7rEf3lWfe
I1yB6Q0uCbvc1h5vM9NW0EN9/fg2cbcdzTlqfIDmMZikzsvYKez9DPk+wQ2C
EeqoIGYcc6s0HP4W+40AQeJMWbq/0FJygQnsBZfu+SexOok5g988mHaqPQYf
4jxr691h3k8JMz2Cr5Bvhru76MYT9RwBt2Bi0G+nT3e4Dq4YbhTNHbS/Of8x
7wp9KbXtAiHi9br0bX7nXUwygxa4Ikt3Vc4MPuC7llhr3PquzTvrIsdOchy3
9c11+/S9mTeWZendLNycT/8bdsOfAIfoww/CnD+7dFe3TE7QiN+8S9+r6fVg
qs5jzta+nXC5KbqHR3BzaH9R83vqyaG2bLfuLwtdIFW/x1i4A/g64NK9+n3v
w57E9z9hCbXh
         "],
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4361, 7954, 4362, 7975, 6062, 7744, 7520, 8041, 8040, 4853, 
         8076, 7341, 7331, 7660}],
        "1.2`"],
       Annotation[#, 1.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5149, 5807, 7690, 8137, 5258, 6136, 7410, 7411, 8047, 7009, 
         7679, 5590, 7678, 7007, 8045, 7407, 7406, 5185, 5877, 5878, 5288, 
         5287, 4444, 7945, 8091, 8092, 6717, 8016, 8015, 4668, 6715, 6716, 
         6713, 7722, 6714, 7843, 6199, 6198, 6197, 5036, 6175, 7687, 5335, 
         5336, 4738, 6389, 4737, 6390, 4254, 7327, 7328, 7326, 8075, 8074, 
         4783, 8071, 8072, 6815, 8101, 4199, 7800, 4645, 7185, 4646, 4667, 
         7601, 4666, 4306, 7374, 7306, 7307, 8073, 7309, 7308, 4577, 5606, 
         4578, 5340, 7963, 4299, 8017, 4296, 7793, 4948, 8043, 6977, 7677, 
         5434, 7676}],
        "1.2`"],
       Annotation[#, 1.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7648, 8111, 7733, 7702, 5652, 7972, 4356, 7953, 4352}],
        "1.2`"],
       Annotation[#, 1.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7694, 5705, 7696, 5319, 5987, 7228, 7230, 8058, 7018, 7686, 
         5291, 7685, 7016, 8056, 7421, 7420, 6663, 6260, 6436, 6435, 4585, 
         7958, 7791, 7792, 4727, 8023, 8022, 8021, 4584, 7598, 7156, 7286, 
         7285, 5275, 5276, 4594, 7166, 4593, 8134, 6905, 6906, 6907, 6557, 
         6558, 6556, 8006, 8005, 4905, 8018, 8019, 6755, 8096, 8095, 7801, 
         4202, 7581, 6822, 4789, 7396, 7397, 7393, 7395, 7394, 4268, 7194, 
         4267, 6920, 8024, 7165, 7164, 4582, 5626, 4583, 5358, 7968, 4326, 
         7876, 4325, 7967, 4931, 8042, 6966, 7667, 5490, 5670}],
        "1.2`"],
       Annotation[#, 1.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7776, 7912, 4381, 7978, 6089, 7755, 7537, 8038, 8037, 4945, 
         8087, 7382, 7380, 7526}],
        "1.2`"],
       Annotation[#, 1.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{7779, 7915, 4452, 7902, 4449}],
        "1.2`"],
       Annotation[#, 1.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7784, 7924, 4403, 7982, 5788, 7712, 7775, 8130, 7765}],
        "1.2`"],
       Annotation[#, 1.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{7788, 7932, 4461, 7906, 4457}],
        "1.2`"],
       Annotation[#, 1.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7798, 5543, 7799, 4707, 8048, 8049, 8051, 5260, 7682, 4987, 
         8088, 7414, 7413, 7715, 4986, 8118, 4985, 5363, 5104, 8131, 5105, 
         7716, 4992, 8119, 4991, 7680, 4711, 8117, 4712, 4703, 7226, 4702, 
         8135, 6396, 6817, 6816, 4200, 4156, 7567, 5902, 5889, 7691, 7212, 
         4677, 8066, 4676, 8067, 7649, 8082, 4894, 8081, 4895, 8083, 7705, 
         8080, 4893, 8079, 4892, 7369, 4167, 5462, 4155, 8100, 5042, 7718, 
         7542, 5100, 8099, 7541, 7540, 4264, 6319, 4263, 5961, 5962, 8060, 
         7155, 8059, 8002, 8077, 8078, 5344, 6004, 4303, 7862, 4301, 6567, 
         7966, 4917, 7869, 6034, 7866, 4345}],
        "1.2`"],
       Annotation[#, 1.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7928, 7896, 6114, 7899, 4958, 7796, 5790, 4320, 6754, 4324, 
         6020, 5355, 8004, 8003, 7962, 7961, 6254, 6253, 6477, 6594, 4329, 
         7515, 7516, 8098, 5099, 7517, 7743, 7514, 5098, 8097, 5097, 7513, 
         5507, 4168, 7507, 5090, 8093, 5091, 8094, 7707, 8086, 4904, 8084, 
         4903, 8085, 7650, 8069, 4680, 8068, 4681, 7213, 7697, 7151, 7152, 
         6392, 6391, 7993, 6820, 6821, 6400, 6399, 5908, 4502, 5274, 5273, 
         7688, 6251, 6252, 7984, 6249, 8133, 6248, 7615, 7638, 5121, 8132, 
         5122, 7717, 7439, 7440, 8089, 7437, 7436, 7684, 5270, 8055, 8053, 
         8052, 4720, 7780, 5554, 4164}],
        "1.2`"],
       Annotation[#, 1.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{7936, 7829, 4295, 7949, 6003, 5999}],
        "1.2`"],
       Annotation[#, 1.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{7944, 7837, 4472, 7957, 4469}],
        "1.2`"],
       Annotation[#, 1.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4163, 5553, 5557, 5169, 4722, 5272, 8054, 5269, 7683, 7438, 
         6168, 5021, 5564, 6177, 6178, 5828, 4445, 6176, 5123, 6780, 6779, 
         6778, 6250, 4818, 6472, 4580, 5466, 5198, 5199, 4739, 6201, 4489, 
         6202, 7056, 7055, 6203, 5993, 6682, 7446, 5028, 7041, 7042, 7043, 
         5833, 4464, 7040, 7039, 7215, 7214, 4682, 7216, 4683, 6337, 7028, 
         4440, 5824, 5825, 5113, 7609, 5112, 4234, 7619, 7617, 7618, 7616, 
         6219, 6218, 6221, 6220, 4260, 5959, 5960, 5941, 5942, 4236, 6247, 
         5281, 5282, 4564, 5948, 6312, 7589, 4246, 6313, 5279, 5842, 5843, 
         5142, 5885, 5066, 5844, 6678, 6677, 6784, 6783, 5038, 5888, 5039, 
         7464, 7463, 5145, 7566, 5251, 5252, 5135, 7054, 7053, 7052, 5040, 
         6181, 4446, 6179, 6180, 5896, 5909, 7568, 4165, 4203, 6823, 6824, 
         6255, 6257, 6256, 4432, 6261, 6262, 6239, 6259, 7582, 6258, 7584, 
         4219, 6664, 5003, 5188, 5004, 5820, 4544, 6377, 5292, 7017, 8057, 
         4726, 7229, 5986, 5318, 7695, 5704, 5707, 5316, 6526, 5312}],
        "1.1`"],
       Annotation[#, 1.1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4380, 6079, 7977, 6088, 7539, 4947, 7533, 4944, 7381, 7379, 
         7525}],
        "1.1`"],
       Annotation[#, 1.1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4154, 6619, 5153, 5810, 5806, 7689, 8136, 5257, 6135, 7412, 
         4984, 8046, 7008, 5591, 6640, 4796, 6635, 4983, 5923, 4982, 6633, 
         4217, 7554, 5119, 6775, 5120, 6777, 5019, 6672, 6673, 6669, 6671, 
         6670, 4370, 7461, 7462, 6685, 6687, 6686, 5035, 7459, 7460, 7456, 
         7458, 7457, 6684, 6387, 6388, 6243, 6245, 7624, 6244, 7625, 4437, 
         6688, 5037, 7595, 4474, 5836, 4473, 7305, 4808, 7304, 4807, 5598, 
         4806, 7435, 5020, 7432, 7434, 7433, 5277, 7368, 4242, 6872, 6871, 
         4829, 5934, 4230, 5582, 6486, 6487, 6485, 6489, 6488, 4243, 5946, 
         5947, 5935, 5936, 4231, 6246, 6382, 5009, 7607, 5010, 5823, 5822, 
         4438, 7211, 4675, 7210, 4674, 7543, 7544, 6992, 6993, 4411, 5800, 
         6996, 6995, 6994, 4962, 7398, 5211, 6643, 4990, 6642, 7010, 7011, 
         5610, 6702, 5060, 6701, 5061, 6703, 4704, 6466, 6467, 6465, 7314, 
         7313, 5365, 4427, 6156, 5364, 4590, 5875, 4589, 5816, 5817, 4989, 
         6153, 4426, 5815, 6155, 6154, 5548, 4988, 6152, 7681, 5259, 8050, 
         5261, 4706, 5157, 5542, 5539, 7797}],
        "1.1`"],
       Annotation[#, 1.1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4344, 7865, 6033, 7868, 4916, 7965, 6566, 4300, 7861, 4302, 
         5343, 6568, 5345, 4918, 5342, 6761, 5341, 5362, 6576, 4229, 5337, 
         6760, 5338, 4810, 5339, 5603, 5601, 5733, 4298, 5219, 4951, 5443, 
         6982, 5433, 7675}],
        "1.1`"],
       Annotation[#, 1.1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4351, 7952, 4355, 7971, 5651, 7701, 7732, 8110, 7647}],
        "1.1`"],
       Annotation[#, 1.1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4448, 7901, 4451, 7914, 7778}],
        "1.1`"],
       Annotation[#, 1.1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4456, 7905, 4460, 7931, 7787}],
        "1.1`"],
       Annotation[#, 1.1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4468, 7956, 4471, 7836, 7943}],
        "1.1`"],
       Annotation[#, 1.1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5669, 5489, 6965, 5495, 4930, 5235, 4328, 5760, 5623, 5624, 
         5359, 4823, 5357, 6583, 5356, 5366, 6593, 4235, 5351, 6582, 5352, 
         4933, 5354, 6590, 5353, 4323, 6753, 4319, 5789, 7795, 4957, 7898, 
         6113, 7895, 7927}],
        "1.1`"],
       Annotation[#, 1.1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{5998, 6002, 7948, 4294, 7828, 7935}],
        "1.1`"],
       Annotation[#, 1.1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6726, 6059, 7974, 6061, 7519, 4852, 7491, 4850, 7340, 7330, 
         7659}],
        "1.1`"],
       Annotation[#, 1.1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7764, 8129, 7774, 7711, 5787, 7981, 4402, 7923, 7783}],
        "1.1`"],
       Annotation[#, 1.1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4160, 5375, 4158, 5541, 5156, 4705, 5546, 4479, 6354, 5262, 
         6151, 6641, 4709, 6700, 5550, 5841, 5840, 5873, 5874, 5103, 6770, 
         5102, 7546, 5818, 4860, 5203, 4265, 6357, 4713, 6356, 6355, 5964, 
         4591, 6322, 6323, 6320, 4669, 6321, 5415, 5416, 5191, 5190, 5609, 
         4553, 6441, 4799, 5927, 5928, 7370, 7371, 6949, 6950, 6951, 5721, 
         6954, 6953, 6952, 4909, 7372, 5212, 5213, 5107, 6771, 5108, 6772, 
         5106, 5245, 5244, 5912, 5911, 5171, 5170, 5884, 4792, 5584, 4755, 
         5570, 6909, 6908, 4854, 7342, 6874, 6873, 4560, 7142, 5045, 7325, 
         4836, 6893, 6894, 6895, 5583, 6892, 6891, 6890, 4835, 7367, 4890, 
         7560, 5178, 4891, 7593, 4290, 7244, 4754, 7243, 7345, 7344, 4857, 
         4259, 5200, 5143, 5600, 5599, 5835, 6788, 6789, 6787, 6791, 6790, 
         5070, 7483, 7484, 6869, 6870, 4241, 6381, 6206, 6207, 6205, 6209, 
         7622, 6208, 6596, 6595, 7378, 4943, 6968, 6969, 4372, 5769, 4371, 
         6077, 6076, 7196, 7197, 7198, 7195, 6967, 5301, 4550, 5826, 5827, 
         5299, 6776, 5298, 4218, 5517, 5924, 5922, 6634, 4795, 6638, 6639, 
         6636, 7409, 7408, 4419, 5253, 6132, 5256, 5808, 5805, 5809, 5152, 
         6618, 4153}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4447, 7900, 4450, 7913, 7777}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4467, 7955, 4470, 7835, 7942}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5463, 5390, 4162, 5556, 5168, 4721, 5561, 4488, 6370, 5271, 
         6167, 6676, 4725, 6503, 5563, 5661, 5660, 5829, 5830, 5125, 6781, 
         5124, 6782, 5879, 4901, 5617, 5616, 5349, 6019, 6018, 6016, 4652, 
         5197, 4258, 6298, 6299, 6297, 6296, 5955, 4581, 6442, 4800, 5929, 
         6758, 7511, 7512, 6955, 6956, 6957, 5722, 6960, 6959, 6958, 4910, 
         7373, 5207, 5208, 5133, 5134, 5130, 6794, 5132, 6792, 5131, 6793, 
         7635, 5034, 7455, 6683, 7429, 5015, 7430, 5016, 6667, 4855, 5072, 
         6911, 6910, 4856, 7343, 6876, 6875, 4563, 7143, 4757, 7144, 4565, 
         6877, 6878, 6879, 4575, 6882, 6881, 6880, 4566, 7245, 4758, 6806, 
         6807, 5296, 4549, 7321, 4833, 6883, 6884, 4247, 5635, 4248, 6886, 
         6885, 7323, 7322, 4503, 7161, 7162, 6914, 6915, 4261, 7235, 6393, 
         6394, 6210, 6212, 7623, 6211, 6666, 6665, 7422, 5005, 7020, 7021, 
         4433, 5631, 6711, 6712, 6380, 4728, 6379, 7019, 6240, 4557, 7140, 
         7141, 6265, 7583, 6264, 6314, 7192, 7193, 5187, 5186, 5819, 4543, 
         6376, 6378, 6373, 6375, 6374, 4277, 5317, 5982, 5322, 5708, 5703, 
         5706, 5315, 6525, 5311}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4343, 7864, 6032, 7867, 4915, 7964, 4911, 6565, 4305, 6571, 
         6572, 6570, 6575, 6574, 4919, 6764, 6765, 6762, 5093, 6759, 5094, 
         6763, 4809, 5740, 5741, 5602, 4920, 5734, 4297, 5218, 4950, 5442, 
         6981, 5432, 7674}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4350, 7951, 4354, 7970, 5650, 7700, 7731, 8109, 7646}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4379, 6078, 7976, 6087, 7538, 4946, 7532, 7536, 7390, 7530, 
         7524}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4455, 7904, 4459, 7930, 7786}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5668, 5488, 6964, 5494, 4929, 5234, 4327, 5761, 4940, 5625, 
         5763, 5762, 4824, 6587, 4935, 6584, 4934, 6581, 6586, 6585, 4932, 
         6591, 6592, 6589, 7377, 7375, 4322, 5792, 4955, 7794, 4956, 7897, 
         6112, 7894, 7926}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{5997, 6001, 7947, 4293, 7827, 7934}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6725, 6058, 7973, 6060, 7518, 4851, 7490, 7493, 7339, 7658}],
        
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7763, 8128, 7773, 7710, 5786, 7980, 4401, 7922, 7782}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4342, 7863, 6031, 6025, 5454, 4914, 5224, 6564, 4304, 6573, 
         4923, 6569, 4924, 5732, 6041, 5731, 4347, 5605, 6038, 6035, 5425, 
         4922, 5739, 5217, 5775, 4949, 5441, 6980, 5431, 7673}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4349, 7950, 4353, 5649, 5861, 5659, 7730, 8108, 7645}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4454, 7903, 4458, 7929, 7785}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5893, 5895, 5374, 4157, 5540, 5155, 5547, 5545, 4478, 6353, 
         4710, 6273, 4708, 6699, 5059, 5549, 5058, 6768, 6769, 6456, 6457, 
         4811, 5685, 6736, 5075, 6735, 5076, 6737, 4859, 6506, 6423, 6919, 
         6424, 5963, 6426, 6425, 6690, 5413, 5414, 4670, 7199, 7201, 7200, 
         4283, 5304, 7291, 7292, 7290, 7294, 7293, 4561, 7496, 7497, 6925, 
         6926, 4271, 5691, 6929, 6928, 6927, 4864, 7348, 4495, 5278, 5084, 
         7504, 5085, 7505, 5056, 5057, 7585, 4224, 5333, 7168, 7147, 7148, 
         7146, 4573, 7149, 4291, 4572, 7597, 4571, 5297, 4173, 5179, 4570, 
         6896, 6897, 4252, 7154, 4251, 7621, 6216, 7620, 6217, 7060, 7059, 
         4501, 7564, 7565, 7561, 7563, 7562, 5839, 4475, 5136, 7611, 5137, 
         5139, 7612, 5138, 6214, 6215, 6200, 4476, 6193, 6194, 7555, 7556, 
         7044, 7045, 7046, 5880, 4465, 5250, 4547, 7324, 4834, 6888, 6889, 
         4249, 5637, 4250, 5082, 7503, 5083, 5867, 5866, 4289, 7058, 4493, 
         7057, 4492, 7346, 7347, 6922, 6923, 6924, 5079, 5206, 5205, 5887, 
         4908, 7509, 7510, 7508, 5092, 6757, 6756, 5926, 6440, 6439, 4552, 
         5770, 5771, 5189, 7637, 4228, 5410, 4227, 6853, 6854, 6342, 6346, 
         6345, 4551, 5595, 4798, 5300, 5925, 5518, 4688, 5592, 4797, 5522, 
         6637, 5521, 4421, 5803, 4418, 6131, 5255, 4969, 5151, 6617, 4152}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{5996, 6000, 7946, 4292, 7826, 7933}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4378, 6976, 6086, 7534, 7531, 7535, 7389, 7529, 7523}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4650, 7189, 5465, 5389, 4161, 5555, 5167, 5560, 5559, 4487, 
         6369, 4724, 6285, 4723, 6504, 4845, 5562, 4844, 6674, 6675, 6500, 
         7329, 4843, 5720, 7506, 5088, 6751, 5089, 6752, 4902, 6555, 4318, 
         6947, 6554, 6017, 6553, 6552, 4579, 5419, 5420, 5348, 5347, 4287, 
         5350, 7296, 7297, 7295, 7299, 7298, 4562, 7476, 7477, 7473, 7475, 
         7474, 5596, 6942, 6941, 6940, 4889, 7364, 5195, 5196, 4975, 7401, 
         4976, 7402, 4802, 4803, 7586, 4225, 5536, 4226, 7301, 7302, 7300, 
         4804, 7303, 4756, 5046, 7570, 4172, 6448, 4174, 7571, 6447, 6223, 
         4507, 6222, 4508, 6405, 6406, 6404, 4759, 7064, 4509, 6829, 7246, 
         7572, 7573, 6808, 6809, 4837, 7590, 4253, 5073, 7591, 4257, 5837, 
         5047, 7608, 5048, 5181, 7221, 4697, 7002, 7003, 4423, 7222, 4424, 
         7558, 5126, 7557, 5127, 5882, 5881, 4466, 7048, 7047, 7627, 4569, 
         7145, 6887, 7365, 7366, 6943, 6944, 6945, 5597, 7479, 5054, 7478, 
         5055, 5361, 5360, 5932, 5931, 5930, 6444, 6443, 4558, 5629, 5630, 
         5194, 4239, 5421, 6329, 6268, 6269, 6267, 6271, 6270, 4556, 6266, 
         4596, 7167, 4595, 6315, 6316, 6022, 6948, 5290, 4542, 6563, 4907, 
         6372, 6561, 6559, 4276, 5701, 4274, 5981, 5321, 4881, 5314, 6524, 
         5310}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5667, 5487, 6963, 5493, 4928, 5752, 5233, 5767, 4942, 5506, 
         6054, 6055, 5628, 4359, 5754, 6053, 5755, 4939, 6588, 4936, 7376, 
         4321, 5791, 5229, 4961, 5484, 6110, 6111, 7893, 7925}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{6724, 6732, 6069, 7494, 7489, 7492, 7338, 7657}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7762, 8127, 7772, 5785, 6109, 5778, 4400, 7921, 7781}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4171, 5248, 5249, 5114, 5876, 7033, 7032, 5115, 7553, 6913, 
         6912, 4576, 7153, 4506, 7163, 4587, 6916, 6917, 6918, 4629, 4630, 
         4499, 5897, 5898, 5899, 6305, 6304, 5331, 5332, 4885, 6935, 6936, 
         6937, 5712, 4282, 6939, 6938, 7361, 7360, 6542, 5957, 4586, 6263, 
         6438, 6437, 5303, 4281, 6934, 5991, 6295, 6294, 6449, 6343, 6344, 
         6140, 6144, 4422, 5302, 5593, 5594, 5520, 4689, 5532, 5242, 5811, 
         5813, 5524, 6139, 4420, 5802, 6134, 6130, 5254, 4968, 5150, 6616, 
         4151}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4399, 6108, 5784, 7771, 8126, 7761}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4409, 5477, 6119, 5483, 4960, 5796, 5228, 5759, 4938, 5469, 
         6050, 6052, 5753, 4358, 5627, 4360, 6057, 5505, 4941, 5766, 5232, 
         5749, 5751, 5492, 6962, 5486, 5666}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4761, 5183, 5182, 7250, 4762, 7247, 7249, 7248, 5283, 4179, 
         7088, 7089, 7086, 4513, 7087, 4178, 7575, 4766, 7271, 6839, 4512, 
         7085, 4765, 7270, 4211, 7269, 6838, 7084, 7083, 7268, 4210, 7267, 
         6837, 7082, 7081, 7266, 4209, 7265, 6836, 7080, 7079, 7264, 4208, 
         7263, 6835, 7078, 7077, 7262, 4207, 7261, 6834, 7076, 7075, 7260, 
         4206, 7259, 6833, 7074, 7073, 7258, 4205, 7257, 6832, 7072, 7071, 
         7256, 4204, 7255, 6831, 7070, 7069, 7254, 4764, 7253, 7252, 6830, 
         4511, 7251, 4763, 6810, 4177, 7068, 4510, 7065, 7067, 7066, 4176, 
         5572, 4175, 7574, 5049, 4760, 5571, 5901}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5334, 6828, 6827, 5913, 5141, 6798, 5053, 5838, 7035, 7034, 
         5118, 4262, 7592, 4588, 4805, 7150, 4574, 6898, 6899, 6900, 4633, 
         7600, 4634, 4500, 5900, 6308, 6309, 6311, 6310, 4169, 5176, 4794, 
         7289, 4793, 5589, 4272, 6931, 6930, 7352, 7351, 5951, 5949, 4567, 
         6241, 6446, 6445, 5327, 4288, 5995, 5994, 6123, 6122, 4410, 6120, 
         6121, 5969, 6921, 4270, 5326, 4269, 5965, 4663, 6021, 6023, 4330, 
         5371, 5845, 5709, 5710, 4906, 5984, 6560, 4275, 5700, 5980, 5978, 
         5320, 4880, 5313, 6523, 5309}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4377, 6975, 6085, 7754, 7388, 7528, 7522}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4649, 7188, 5464, 5388, 5391, 5166, 5397, 5162, 5558, 4486, 
         6368, 6371, 6284, 6367, 6366, 4256, 6498, 6499, 6491, 6502, 6501, 
         4788, 6428, 6429, 5906, 6551, 6550, 5346, 5417, 5418, 5175, 5174, 
         5567, 4496, 7183, 7184, 7182, 4626, 4245, 7350, 4865, 7349, 4866, 
         5586, 5585, 5587, 5588, 5027, 4463, 5832, 4462, 5026, 4696, 4832, 
         4831, 5634, 4439, 5014, 4548, 5295, 4735, 7605, 4736, 4685, 7219, 
         4684, 7220, 4742, 6307, 4631, 6306, 4632, 5117, 7610, 5116, 6668, 
         5018, 6505, 4858, 5958, 6733, 6734, 5074, 5202, 5201, 5886, 4886, 
         5715, 5992, 4285, 5713, 5714, 4888, 7362, 4887, 7363, 4244, 7178, 
         7179, 7177, 7181, 7180, 4494, 5719, 5172, 5173, 5412, 5411, 4159, 
         4201, 5904, 5903, 6421, 6420, 4784, 6454, 6455, 6450, 6453, 6452, 
         4232, 6349, 6350, 6272, 6352, 6351, 4477, 5544, 5154, 5381, 5161, 
         5378, 5373, 5894, 5892}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{5855, 5860, 5658, 7729, 8107, 7644}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{6723, 6731, 6068, 7740, 7337, 7656}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7672, 5430, 6979, 5440, 5777, 5774, 5216, 5738, 4921, 5424, 
         6037, 4348, 5604, 4346, 5730, 6040, 6039, 5461, 4926, 5745, 5223, 
         5729, 4913, 5453, 6030, 5448, 7849}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4180, 7090, 4514, 6840, 7465, 4212, 7466, 5573, 5574, 5050, 
         7576, 4181, 5575, 4182, 7094, 7095, 7093, 7097, 7096, 4183, 7099, 
         4515, 7098, 4516, 7100, 4184, 7102, 4517, 7101, 4518, 7103, 4185, 
         7105, 4519, 7104, 4520, 7106, 4186, 7577, 4769, 4521, 6842, 7278, 
         7279, 4770, 7107, 4522, 6843, 7280, 4771, 7578, 4187, 7109, 4523, 
         7108, 4524, 7110, 4188, 7112, 4525, 7111, 4526, 7113, 4189, 7115, 
         4527, 7114, 4528, 7116, 4190, 7118, 7119, 7117, 7121, 7120, 4191, 
         5284, 7274, 7275, 7273, 4767, 5184, 4213, 7272, 7091, 7092, 6841, 
         7276, 7277, 4768}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4312, 7875, 4317, 7834, 7941}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4335, 7881, 4340, 7842, 5847}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4364, 7887, 4369, 7820, 7911}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4389, 7892, 4394, 7825, 7920}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4441, 7063, 4505, 7061, 4504, 7062, 4741, 6999, 6998, 6997, 
         7218, 7217, 7485, 5636, 4443, 7031, 7030, 5017, 7431, 4801, 6242, 
         4568, 5952, 5953, 5954, 4730, 6213, 4497, 5950, 4498, 6302, 6303, 
         6300, 4628, 6301, 6432, 7287, 7288, 6403, 6402, 4753, 5968, 4752, 
         6401, 5323, 5967, 5966, 6317, 4598, 5372, 5067, 5711, 7358, 4883, 
         6562, 5983, 5985, 5699, 5979, 5702, 4879, 6515, 4877, 6522, 5308}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7241, 7242, 7207, 4673, 6986, 6987, 6988, 4744, 6991, 6990, 
         6989, 7209, 7208, 7320, 5633, 4435, 7023, 7022, 5008, 7423, 6125, 
         7599, 6124, 7158, 7159, 7160, 7157, 6290, 6291, 4622, 6204, 4490, 
         5956, 4491, 6292, 6293, 5140, 6795, 4624, 5409, 4701, 6796, 6797, 
         6348, 6347, 4693, 6141, 7000, 7001, 5514, 6143, 6142, 5519, 4695, 
         5533, 5241, 5812, 4974, 5523, 6137, 6138, 5801, 6133, 5804, 4971, 
         6604, 4967, 6615, 4150}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{7521, 7527, 7387, 7753, 6084, 6974, 4376}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4398, 6107, 5783, 7770, 8125, 7760}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4408, 5476, 6118, 5482, 4959, 5795, 5227, 5758, 4937, 5468, 
         6051, 5467, 5674, 5500, 6056, 5504, 5768, 5765, 5231, 5748, 5750, 
         5491, 6961, 5485, 5665}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4648, 7187, 5392, 7173, 4611, 5165, 5396, 5393, 4485, 6286, 
         6287, 6283, 6903, 6901, 4255, 6492, 6493, 6490, 6495, 6494, 4787, 
         7282, 6427, 6431, 7283, 7284, 6430, 5907, 6691, 5044, 6100, 5043, 
         5568, 4751, 6599, 4954, 6598, 7392, 7391, 4286, 6661, 6662, 6658, 
         4999, 6657, 5000, 6848, 6849, 4223, 7547, 4222, 7425, 7426, 7424, 
         7428, 7427, 5011, 5013, 5012, 7027, 7026, 7025, 4734, 7234, 4830, 
         6383, 4733, 6172, 6173, 6174, 5110, 6773, 5111, 6774, 5109, 5247, 
         5246, 4221, 7416, 4220, 6847, 6846, 4995, 7606, 4994, 7634, 6649, 
         7418, 7417, 4284, 6547, 6548, 6546, 4900, 6549, 4898, 5718, 6013, 
         6011, 5087, 6750, 4869, 6512, 7356, 7355, 6511, 6422, 7281, 4785, 
         6462, 6463, 6451, 6459, 6458, 4233, 6276, 6277, 6275, 6282, 6279, 
         4482, 5379, 5380, 5160, 4601, 7238, 5377, 5891}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{5854, 5859, 5657, 7728, 8106, 7643}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{6722, 6730, 6067, 7739, 7336, 7655}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7671, 5429, 6978, 5439, 5776, 5773, 5215, 5736, 5737, 5423, 
         6036, 5422, 5638, 5456, 6042, 5460, 4925, 5744, 5222, 5728, 4912, 
         5452, 6029, 5447, 7848}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4240, 7224, 4699, 7223, 4700, 7225, 4436, 7024, 7626, 4545, 
         7136, 6845, 7545, 5101, 6149, 6150, 5814, 4979, 7405, 4981, 7403, 
         4980, 7404, 4280, 7442, 7443, 7441, 7445, 7444, 4746, 5579, 4782, 
         5883, 5146, 5147, 5180, 6802, 5041, 6689, 4781, 6338, 6340, 6341, 
         5529, 4687, 5534, 5535, 5237, 4694, 5531, 4416, 6627, 4972, 6608, 
         4973, 6629, 4966, 6624, 4970, 6603, 6621, 6614, 4149}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4647, 7186, 7191, 7172, 4610, 5164, 4613, 5395, 4484, 6289, 
         4618, 7176, 4616, 7174, 6902, 6904, 7486, 7488, 7487, 6497, 6496, 
         4842, 5690, 6739, 6740, 6738, 5077, 6741, 4861, 5686, 5580, 5581, 
         4953, 6099, 6101, 6102, 5622, 6985, 6984, 6098, 4952, 6597, 4627, 
         6476, 4822, 6475, 4821, 7316, 5618, 5619, 5002, 6659, 5001, 6660, 
         5294, 6386, 4412, 6126, 6336, 6335, 4679, 7603, 6192, 7038, 6191, 
         7602, 4672, 7205, 7206, 6384, 7594, 4384, 6385, 5293, 7419, 4996, 
         6650, 4997, 5615, 5614, 6705, 5062, 6704, 5063, 6706, 4625, 6469, 
         4816, 6468, 4815, 7315, 5611, 6015, 6014, 6012, 4899, 5209, 4273, 
         5698, 4872, 6746, 5081, 6745, 7502, 7501, 5695, 4812, 6460, 6461, 
         7311, 7312, 7310, 6855, 6278, 4606, 6274, 4607, 6281, 4481, 5383, 
         4605, 5159, 4600, 7237, 5376, 5890}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4773, 6844, 4216, 7614, 6408, 5915, 6227, 6226, 6407, 4215, 
         4192, 6814, 6813, 4772, 5286, 5285, 4198, 7134, 7135, 7132, 4540, 
         7133, 4197, 7131, 4539, 7129, 4538, 7636, 7130, 4196, 7580, 4780, 
         6419, 5921, 4537, 6232, 4779, 6418, 6417, 5920, 4536, 6231, 4778, 
         6416, 6415, 5919, 4535, 6230, 4777, 6414, 6413, 5918, 4534, 6229, 
         4776, 6412, 6411, 5917, 4533, 6228, 4775, 6410, 6409, 5916, 4532, 
         4774, 7579, 4195, 7128, 4531, 7126, 4530, 7127, 4194, 7125, 4529, 
         7122, 7124, 7123, 4193, 5577, 5578, 5052, 7467, 5051, 5576, 6693, 
         4214, 7613, 6692, 5914, 6225, 6224, 6812, 6811}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5280, 7232, 4731, 7231, 4732, 7233, 4442, 7029, 7596, 4546, 
         7137, 6850, 7452, 5031, 6196, 7051, 5834, 5030, 7454, 5033, 7453, 
         5032, 4434, 7448, 7449, 7447, 7451, 7450, 5029, 6786, 5129, 6785, 
         5128, 7559, 5402, 7569, 5403, 4790, 6238, 7138, 7139, 5569, 4554, 
         5369, 5370, 5192, 4597, 5368, 6861, 6859, 7357, 4882, 7359, 4884, 
         6535, 4874, 6528, 4878, 6514, 6521, 6519, 5307}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{5846, 7841, 4339, 7880, 4334}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4311, 7874, 4316, 7833, 7940}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4363, 7886, 4368, 7819, 7910}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4375, 6973, 6083, 7752, 7386, 7748}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4388, 7891, 4393, 7824, 7919}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4397, 6106, 5782, 7769, 8124, 7759}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4407, 5475, 6117, 5481, 5799, 5794, 5226, 5757, 4656, 5679, 
         5472, 4848, 5503, 5682, 4662, 5764, 5230, 5747, 4661, 7860, 5499, 
         5673, 5664}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{5853, 5858, 5656, 7727, 8105, 7642}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{6721, 6729, 6066, 7738, 7335, 7654}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7670, 6093, 5438, 7812, 4639, 5772, 5214, 5735, 4638, 5643, 
         5428, 4840, 5459, 5647, 4644, 5743, 5221, 5724, 5727, 5451, 6028, 
         5446, 7847}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4148, 6613, 6620, 6602, 6623, 6622, 4965, 6628, 6630, 6607, 
         6626, 6625, 4415, 5530, 4413, 5236, 4690, 5525, 4686, 6339, 5513, 
         4745, 6679, 5022, 6183, 6184, 6185, 5528, 7037, 7036, 6182, 4740, 
         6395, 4623, 5408, 6852, 6696, 6698, 7587, 6697, 4978, 6146, 6147, 
         6148, 5693, 7006, 7005, 6145, 4977, 5330, 5329}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4170, 5177, 5006, 6169, 6170, 6171, 5007, 7551, 7552, 7548, 
         7550, 7549, 5821, 4828, 6866, 7588, 6867, 7482, 7481, 6868, 5565, 
         4729, 6479, 4826, 6478, 4825, 7317, 5406, 7050, 7049, 6195, 4743, 
         6398, 5988, 5325, 6237, 4555, 5405, 4620, 5193, 5944, 4237, 5367, 
         4238, 6858, 6860, 6530, 6534, 6533, 4873, 6527, 6529, 6513, 6520, 
         6518, 5306}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4749, 8063, 4750, 7236, 4599, 5158, 4604, 5382, 4480, 6280, 
         5265, 5971, 6544, 4608, 5385, 4813, 6464, 5608, 4896, 5869, 4897, 
         5717, 4871, 5865, 4870, 5694, 5289, 7415, 4993, 6644, 6648, 6647, 
         4814, 6471, 4817, 5937, 6856, 6857, 5510, 5511, 5023, 6186, 6187, 
         6188, 5613, 4453, 6189, 6190, 6328, 7204, 6327, 4671, 6326, 6805, 
         6332, 4678, 6331, 6334, 6333, 4430, 5620, 6708, 5064, 6707, 5065, 
         5552, 5551, 5940, 5939, 5938, 4820, 6474, 4819, 6653, 6654, 6651, 
         4998, 6652, 4266, 5687, 4862, 5864, 4863, 5871, 5096, 5872, 5095, 
         5863, 6718, 5071, 5401, 7175, 4617, 6578, 5975, 5268, 6288, 4483, 
         5394, 4612, 5163, 4609, 7171, 7190, 4651, 7629, 8116}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{6072, 6075, 7885, 4367, 7818, 7909}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4310, 7873, 4315, 7832, 7939}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4333, 7879, 4338, 7840, 5850, 7721}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4374, 6972, 6082, 7751, 7385, 7747}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4387, 7890, 4392, 7823, 7918}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4396, 6105, 5781, 7768, 8123, 7758}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4406, 5474, 6116, 5480, 5798, 5793, 5225, 5756, 4655, 5678, 
         5471, 4847, 5502, 5681, 5680, 4660, 7856, 7859, 5498, 5672, 5663}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{5852, 5857, 5655, 7726, 8104, 7641}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{6720, 6728, 6065, 7737, 7334, 7653}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7669, 6092, 5437, 7811, 7808, 4637, 5639, 5642, 5427, 4839, 
         5458, 5646, 4643, 5742, 5220, 5723, 5726, 5450, 6027, 5445, 7846}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4147, 7498, 5080, 6742, 6744, 6743, 4867, 6509, 6510, 6507, 
         4868, 6508, 6851, 5933, 6695, 6694, 4692, 5537, 5538, 5243, 4417, 
         5831, 5566, 5512, 6129, 6128, 5516, 4691, 5240, 4414, 7399, 7400, 
         6606, 6612, 6610, 4964, 8012, 8014, 6601, 8010, 8008, 6631}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4166, 7995, 7997, 6517, 8001, 7999, 4876, 6539, 6541, 6532, 
         6537, 6536, 6863, 6862, 5943, 6710, 6709, 4619, 6318, 5989, 5990, 
         5324, 4278, 6397, 4279, 5210, 5509, 5508, 4621, 6483, 6484, 5945, 
         6865, 6864, 7318, 4827, 7319, 6480, 6482, 6481, 4791, 6433, 6434, 
         5910, 7472, 6825, 6826, 5328}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5662, 5671, 5497, 7858, 7855, 4659, 5684, 4849, 5501, 4846, 
         5470, 5677, 5675, 4654, 7814, 4657, 5797, 5479, 6115, 5473, 4405}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{5851, 5856, 5654, 7725, 8103, 7640}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{6719, 6727, 6064, 7736, 7333, 7652}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4309, 7872, 4314, 7831, 7938}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4332, 7878, 4337, 7839, 5849, 7720}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4373, 6971, 6081, 7750, 7384, 7746}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4386, 7889, 4391, 7822, 7917}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4395, 6104, 5780, 7767, 8122, 7757}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4748, 8062, 7240, 4603, 8028, 8030, 8032, 5264, 5972, 5970, 
         6543, 6545, 5387, 6010, 5384, 5607, 5716, 4307, 6946, 6007, 6749, 
         6748, 5086, 5697, 5696, 4541, 6645, 6646, 6160, 6162, 4429, 5612, 
         6470, 6324, 6325, 6094, 6096, 6097, 5024, 6680, 5025, 6681, 4786, 
         5905, 6818, 6819, 5305, 6359, 4714, 6330, 4715, 6364, 4718, 7227, 
         4717, 7632, 7633, 7604, 6363, 6158, 6361, 6360, 6473, 5621, 4431, 
         6166, 6164, 6656, 6655, 5204, 5688, 5689, 4927, 6766, 6767, 6048, 
         6049, 4357, 5870, 5862, 5398, 6046, 5400, 6579, 6577, 5974, 5977, 
         5267, 8036, 8034, 8065, 4615, 7170, 7630, 7628, 8115}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{6071, 6074, 7884, 4366, 7817, 7908}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7668, 6091, 5436, 7810, 7807, 4636, 5641, 4841, 5426, 4838, 
         5457, 5645, 5644, 4641, 7852, 4642, 5725, 5449, 6026, 5444, 7845}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4559, 7470, 7471, 8090, 7469, 7468, 7495, 7661, 8112, 5078, 
         7741, 6801, 5144, 8020, 6800, 6799, 5632, 5407, 4341, 6024, 7969, 
         4665, 7985, 7693, 4664, 8113, 7666, 5404, 5068, 8120, 5069, 7704, 
         6531, 6540, 6538, 4875, 7998, 8000, 6516, 7996, 7994, 6804, 6803}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5148, 7499, 7500, 8025, 6932, 7662, 5692, 7663, 6933, 8026, 
         7354, 7353, 7480, 5527, 4425, 7004, 8044, 4698, 8070, 6127, 5515, 
         7699, 5526, 5238, 5239, 7713, 6605, 6611, 6609, 4963, 8011, 8013, 
         6600, 8009, 8007, 6632, 7714}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6090, 5435, 7809, 7806, 4635, 5640, 7802, 7959, 7803, 5648, 
         4640, 7851, 7853, 5455, 7850, 7844}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{6103, 5779, 7766, 8121, 7756}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{6970, 6080, 7749, 7383, 7745}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7703, 5496, 7857, 7854, 4658, 5683, 7805, 7960, 7804, 5676, 
         4653, 7813, 7815, 5478, 7983, 4404}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{7719, 5848, 7838, 4336, 7877, 4331}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{7723, 5653, 7724, 8102, 7639}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{7734, 6063, 7735, 7332, 7651}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{7907, 7816, 4365, 7883, 6073, 6070}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{7916, 7821, 4390, 7888, 4385}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{7937, 7830, 4313, 7871, 4308}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8114, 7631, 8039, 7169, 4614, 8064, 8033, 8035, 5266, 7665, 
         5976, 7709, 5399, 6045, 6047, 7882, 6044, 6043, 6580, 7708, 5746, 
         4592, 6365, 4719, 6163, 7015, 6165, 7692, 6235, 6236, 6234, 7013, 
         6233, 7992, 4428, 7012, 7991, 6157, 7990, 7989, 7790, 7986, 7987, 
         6095, 7979, 4383, 7988, 4382, 6983, 6358, 7203, 7202, 7698, 6159, 
         7014, 6161, 4716, 6362, 7789, 5868, 7742, 6747, 6005, 6006, 7870, 
         6009, 6008, 5386, 7706, 5973, 7664, 5263, 8031, 8029, 8027, 4602, 
         7239, 8061, 4747}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ]}, {}, {}}}],
  Frame->True,
  FrameTicks->True,
  Method->{},
  PlotRange->{{-1, 1}, {0.01, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->757830051]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->743262399],

Cell["The modular discriminant:", "ExampleText",
 CellID->98765394],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "[", "q_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "Pi"}], ")"}], "^", "12"}], " ", 
   RowBox[{"NSum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"RamanujanTau", "[", "n", "]"}], " ", 
      RowBox[{"E", "^", 
       RowBox[{"(", 
        RowBox[{"2", "Pi", " ", "I", " ", "n", " ", "q"}], ")"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2092601474],

Cell[TextData[{
 "Relation with ",
 Cell[BoxData[
  ButtonBox["DedekindEta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DedekindEta"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1013286599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"DedekindEta", "[", 
    RowBox[{"1", "+", "I"}], "]"}], "24"], " ", "\[Equal]", " ", 
  RowBox[{
   RowBox[{"m", "[", 
    RowBox[{"1", "+", "I"}], "]"}], "/", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", " ", "Pi"}], ")"}], "^", "12"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->762548683],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->598424920]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29247],

Cell["\<\
Machine-precision input is insufficient to give a correct answer:\
\>", "ExampleText",
 CellID->164544974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DedekindEta", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"10.", "^", "22"}], " ", "Pi"}], "+", " ", "I"}], " ", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->72618323],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.7512211849322606`"}], "-", 
  RowBox[{"0.16073901460758755`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{148, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->727660751]
}, Open  ]],

Cell["With exact input, the answer is correct:", "ExampleText",
 CellID->508970487],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"DedekindEta", "[", 
    RowBox[{
     RowBox[{"10", "^", "22"}], "+", " ", "I"}], " ", "]"}], ",", "20"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->457662945],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.38411271116302832950129708978763273437`19.84948500216801"}],
   "-", 
  RowBox[{
  "0.66530273156739412621249681390808341856`20.088045629527844", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{344, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->428764100]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->84923975],

Cell[TextData[{
 "Because ",
 Cell[BoxData[
  ButtonBox["DedekindEta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DedekindEta"]], "InlineFormula"],
 " is a numerical function with numeric arguments, it might be considered a \
numeric quantity but because of its boundary of analyticity, it might not be \
a evaluatable to a number:"
}], "ExampleText",
 CellID->19632094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DedekindEta", "[", "Pi", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->239598225],

Cell[BoxData[
 RowBox[{"DedekindEta", "[", "\[Pi]", "]"}]], "Output",
 ImageSize->{103, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5144721]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->695412471],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->61026648]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->179455966],

Cell[BoxData[
 RowBox[{"DedekindEta", "[", "3.141592653589793`", "]"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->219430236]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9770],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ModularLambda",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ModularLambda"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["KleinInvariantJ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KleinInvariantJ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipticTheta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticTheta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PartitionsP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PartitionsP"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19297]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26119],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->29132]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->23340],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/DedekindEtaFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/EllipticFunctions/DedekindEta/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
DedekindEta"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->273767341],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->33315319],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->523738045],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->94700402]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DedekindEta - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 43.8806898}", "context" -> "System`", 
    "keywords" -> {
     "Dedekind elliptic function", "Dedekind eta", "elliptic functions", 
      "modular forms"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DedekindEta[\\[Tau]] gives the Dedekind eta modular elliptic function \
\\[Eta] (\\[Tau]). ", "synonyms" -> {"dedekind eta"}, "title" -> 
    "DedekindEta", "type" -> "Symbol", "uri" -> "ref/DedekindEta"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6474, 218, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->646483597]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 270515, 5152}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2474, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3097, 86, 49, 1, 70, "ObjectName",
 CellID->16349],
Cell[3149, 89, 598, 19, 70, "Usage",
 CellID->28947]
}, Open  ]],
Cell[CellGroupData[{
Cell[3784, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4262, 130, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4385, 136, 356, 11, 70, "Notes",
 CellID->29299],
Cell[4744, 149, 276, 10, 70, "Notes",
 CellID->21448],
Cell[5023, 161, 720, 24, 70, "Notes",
 CellID->684],
Cell[5746, 187, 254, 8, 70, "Notes",
 CellID->185371836],
Cell[6003, 197, 224, 7, 70, "Notes",
 CellID->31226],
Cell[6230, 206, 207, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6474, 218, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->646483597],
Cell[CellGroupData[{
Cell[6859, 232, 148, 5, 70, "ExampleSection",
 CellID->943846495],
Cell[7010, 239, 201, 5, 70, "ExampleText",
 CellID->276493448],
Cell[CellGroupData[{
Cell[7236, 248, 150, 5, 28, "Input",
 CellID->171814419],
Cell[7389, 255, 273, 7, 36, "Output",
 CellID->68573264]
}, Open  ]],
Cell[7677, 265, 125, 3, 70, "ExampleDelimiter",
 CellID->487240653],
Cell[CellGroupData[{
Cell[7827, 272, 325, 11, 28, "Input",
 CellID->219862329],
Cell[8155, 285, 8561, 144, 158, "Output",
 Evaluatable->False,
 CellID->595965147]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16765, 435, 215, 7, 70, "ExampleSection",
 CellID->5540],
Cell[16983, 444, 206, 5, 70, "ExampleText",
 CellID->16593189],
Cell[CellGroupData[{
Cell[17214, 453, 205, 7, 70, "Input",
 CellID->92267335],
Cell[17422, 462, 398, 11, 54, "Output",
 CellID->866861072]
}, Open  ]],
Cell[17835, 476, 123, 3, 70, "ExampleDelimiter",
 CellID->6267416],
Cell[17961, 481, 112, 3, 70, "ExampleText",
 CellID->47874911],
Cell[CellGroupData[{
Cell[18098, 488, 178, 5, 70, "Input",
 CellID->351838579],
Cell[18279, 495, 337, 9, 36, "Output",
 CellID->16753032]
}, Open  ]],
Cell[18631, 507, 124, 3, 70, "ExampleDelimiter",
 CellID->75711896],
Cell[18758, 512, 353, 11, 70, "ExampleText",
 CellID->663211150],
Cell[CellGroupData[{
Cell[19136, 527, 286, 10, 70, "Input",
 CellID->57578442],
Cell[19425, 539, 574, 14, 36, "Output",
 CellID->559094449]
}, Open  ]],
Cell[20014, 556, 125, 3, 70, "ExampleDelimiter",
 CellID->275011245],
Cell[20142, 561, 342, 11, 70, "ExampleText",
 CellID->308166577],
Cell[CellGroupData[{
Cell[20509, 576, 152, 5, 70, "Input",
 CellID->52777769],
Cell[20664, 583, 407, 15, 50, "Output",
 CellID->228992310]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21120, 604, 223, 7, 70, "ExampleSection",
 CellID->21082],
Cell[21346, 613, 238, 8, 70, "ExampleText",
 CellID->177217333],
Cell[CellGroupData[{
Cell[21609, 625, 463, 14, 70, "Input",
 CellID->775141684],
Cell[22075, 641, 238810, 4142, 70, "Output",
 CellID->757830051]
}, Open  ]],
Cell[260900, 4786, 125, 3, 70, "ExampleDelimiter",
 CellID->743262399],
Cell[261028, 4791, 67, 1, 70, "ExampleText",
 CellID->98765394],
Cell[261098, 4794, 524, 17, 70, "Input",
 CellID->2092601474],
Cell[261625, 4813, 204, 8, 70, "ExampleText",
 CellID->1013286599],
Cell[CellGroupData[{
Cell[261854, 4825, 352, 12, 70, "Input",
 CellID->762548683],
Cell[262209, 4839, 161, 5, 36, "Output",
 CellID->598424920]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[262419, 4850, 233, 7, 70, "ExampleSection",
 CellID->29247],
Cell[262655, 4859, 116, 3, 70, "ExampleText",
 CellID->164544974],
Cell[CellGroupData[{
Cell[262796, 4866, 195, 7, 70, "Input",
 CellID->72618323],
Cell[262994, 4875, 271, 8, 36, "Output",
 CellID->727660751]
}, Open  ]],
Cell[263280, 4886, 83, 1, 70, "ExampleText",
 CellID->508970487],
Cell[CellGroupData[{
Cell[263388, 4891, 226, 8, 70, "Input",
 CellID->457662945],
Cell[263617, 4901, 359, 11, 36, "Output",
 CellID->428764100]
}, Open  ]],
Cell[263991, 4915, 124, 3, 70, "ExampleDelimiter",
 CellID->84923975],
Cell[264118, 4920, 376, 10, 70, "ExampleText",
 CellID->19632094],
Cell[CellGroupData[{
Cell[264519, 4934, 108, 3, 70, "Input",
 CellID->239598225],
Cell[264630, 4939, 198, 6, 36, "Output",
 CellID->5144721]
}, Open  ]],
Cell[CellGroupData[{
Cell[264865, 4950, 104, 3, 70, "Input",
 CellID->695412471],
Cell[264972, 4955, 160, 5, 36, "Output",
 CellID->61026648]
}, Open  ]],
Cell[CellGroupData[{
Cell[265169, 4965, 98, 3, 70, "Input",
 CellID->179455966],
Cell[265270, 4970, 213, 6, 36, "Output",
 CellID->219430236]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[265544, 4983, 310, 9, 70, "SeeAlsoSection",
 CellID->9770],
Cell[265857, 4994, 981, 35, 70, "SeeAlso",
 CellID->19297]
}, Open  ]],
Cell[CellGroupData[{
Cell[266875, 5034, 314, 9, 70, "TutorialsSection",
 CellID->26119],
Cell[267192, 5045, 192, 4, 70, "Tutorials",
 CellID->29132]
}, Open  ]],
Cell[CellGroupData[{
Cell[267421, 5054, 321, 9, 70, "RelatedLinksSection",
 CellID->23340],
Cell[267745, 5065, 190, 4, 70, "RelatedLinks"],
Cell[267938, 5071, 201, 4, 70, "RelatedLinks"],
Cell[268142, 5077, 389, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[268568, 5095, 319, 9, 70, "MoreAboutSection",
 CellID->273767341],
Cell[268890, 5106, 161, 3, 70, "MoreAbout",
 CellID->33315319],
Cell[269054, 5111, 137, 3, 70, "MoreAbout",
 CellID->523738045],
Cell[269194, 5116, 144, 3, 70, "MoreAbout",
 CellID->94700402]
}, Open  ]],
Cell[269353, 5122, 27, 0, 70, "History"],
Cell[269383, 5124, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

