(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14376,        527]
NotebookOptionsPosition[     10773,        408]
NotebookOutlinePosition[     12300,        448]
CellTagsIndexPosition[     12215,        443]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns and Transformation Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PatternsAndTransformationRules"], 
          "Optional and Default Arguments" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OptionalAndDefaultArguments"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Patterns and Transformation Rules\"\>", 
       2->"\<\"Optional and Default Arguments\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options" :> Documentation`HelpLookup["paclet:ref/Options"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Options\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns" :> 
          Documentation`HelpLookup["paclet:guide/Patterns"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Default", "ObjectName",
 CellID->4728],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Default",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Default"], "[", 
       StyleBox["f", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the default value for arguments of the function ",
     
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " obtained with a ",
     Cell[BoxData["_."], "InlineFormula"],
     " pattern object. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Default",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Default"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["i", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the default value to use when ",
     Cell[BoxData["_."], "InlineFormula"],
     " appears as the ",
     Cell[BoxData[
      FormBox[
       SuperscriptBox[
        StyleBox["i", "TI"], "th"], TraditionalForm]]],
     " argument of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Default",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Default"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["i", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the default value for the ",
     Cell[BoxData[
      FormBox[
       SuperscriptBox[
        StyleBox["i", "TI"], "th"], TraditionalForm]]],
     " argument out of a total of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " arguments. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{"Default", "[", 
        RowBox[{
         StyleBox["f", "TI"], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "]"}], "=", 
       StyleBox["val", "TI"]}]], "InlineFormula"],
     " \[LineSeparator]defines default values for arguments of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->3029]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["_."], "InlineFormula"],
 " represents an optional argument to a function, with a default value \
specified by ",
 Cell[BoxData[
  ButtonBox["Default",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Default"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9921],

Cell[TextData[{
 "The necessary values for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Default",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Default"], "[", 
   StyleBox["f", "TI"], "]"}]], "InlineFormula"],
 " must always be defined before ",
 Cell[BoxData["_."], "InlineFormula"],
 " is used as an argument of ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5987],

Cell[TextData[{
 "Values defined for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Default",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Default"], "[", 
   StyleBox["f", "TI"], "]"}]], "InlineFormula"],
 " are stored in ",
 Cell[BoxData[
  RowBox[{"DefaultValues", "[", 
   StyleBox["f", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15863]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->134437028],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->754078410],

Cell[TextData[{
 "Define 0 to be the default argument for a function ",
 Cell[BoxData["f"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->12619],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Default", "[", "f", "]"}], "=", "0"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24169],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19647]
}, Open  ]],

Cell["_. represents an argument that can be omitted:", "ExampleText",
 CellID->19362],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_.", ",", "y_."}], "]"}], "=", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12406],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24560]
}, Open  ]],

Cell["\<\
If the second argument is omitted, the default value of 0 is used instead:\
\>", "ExampleText",
 CellID->28752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "a", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->30905],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->12561]
}, Open  ]],

Cell["\<\
If both arguments are omitted, both are taken to have the default value 0:\
\>", "ExampleText",
 CellID->22720],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->24380],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->17441]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->846],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Options",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Options"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->30475]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27327],

Cell[TextData[ButtonBox["Patterns and Transformation Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsAndTransformationRules"]], "Tutorials",
 CellID->244552785],

Cell[TextData[ButtonBox["Optional and Default Arguments",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionalAndDefaultArguments"]], "Tutorials",
 CellID->102082052]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->529566433],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "MoreAbout",
 CellID->222615193]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Default - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 58.9279500}", "context" -> "System`", 
    "keywords" -> {"default arguments", "default values"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Default[f] gives the default value for arguments of the function f \
obtained with a _. pattern object. Default[f, i] gives the default value to \
use when _. appears as the i^th argument of f. Default[f, i, n] gives the \
default value for the i^th argument out of a total of n arguments. Default[f, \
...] = val defines default values for arguments of f.", 
    "synonyms" -> {":", "_."}, "title" -> "Default", "type" -> "Symbol", 
    "uri" -> "ref/Default"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6526, 225, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->134437028]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12072, 436}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1931, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2554, 77, 44, 1, 70, "ObjectName",
 CellID->4728],
Cell[2601, 80, 2302, 75, 70, "Usage",
 CellID->3029]
}, Open  ]],
Cell[CellGroupData[{
Cell[4940, 160, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5418, 177, 294, 10, 70, "Notes",
 CellID->9921],
Cell[5715, 189, 411, 15, 70, "Notes",
 CellID->5987],
Cell[6129, 206, 360, 14, 70, "Notes",
 CellID->15863]
}, Closed]],
Cell[CellGroupData[{
Cell[6526, 225, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->134437028],
Cell[CellGroupData[{
Cell[6911, 239, 148, 5, 70, "ExampleSection",
 CellID->754078410],
Cell[7062, 246, 149, 5, 70, "ExampleText",
 CellID->12619],
Cell[CellGroupData[{
Cell[7236, 255, 122, 4, 28, "Input",
 CellID->24169],
Cell[7361, 261, 154, 5, 36, "Output",
 CellID->19647]
}, Open  ]],
Cell[7530, 269, 85, 1, 70, "ExampleText",
 CellID->19362],
Cell[CellGroupData[{
Cell[7640, 274, 191, 7, 28, "Input",
 CellID->12406],
Cell[7834, 283, 199, 7, 36, "Output",
 CellID->24560]
}, Open  ]],
Cell[8048, 293, 121, 3, 70, "ExampleText",
 CellID->28752],
Cell[CellGroupData[{
Cell[8194, 300, 93, 3, 70, "Input",
 CellID->30905],
Cell[8290, 305, 199, 7, 36, "Output",
 CellID->12561]
}, Open  ]],
Cell[8504, 315, 121, 3, 70, "ExampleText",
 CellID->22720],
Cell[CellGroupData[{
Cell[8650, 322, 88, 3, 70, "Input",
 CellID->24380],
Cell[8741, 327, 199, 7, 36, "Output",
 CellID->17441]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9001, 341, 309, 9, 70, "SeeAlsoSection",
 CellID->846],
Cell[9313, 352, 194, 6, 70, "SeeAlso",
 CellID->30475]
}, Open  ]],
Cell[CellGroupData[{
Cell[9544, 363, 314, 9, 70, "TutorialsSection",
 CellID->27327],
Cell[9861, 374, 178, 3, 70, "Tutorials",
 CellID->244552785],
Cell[10042, 379, 172, 3, 70, "Tutorials",
 CellID->102082052]
}, Open  ]],
Cell[CellGroupData[{
Cell[10251, 387, 319, 9, 70, "MoreAboutSection",
 CellID->529566433],
Cell[10573, 398, 128, 3, 70, "MoreAbout",
 CellID->222615193]
}, Open  ]],
Cell[10716, 404, 27, 0, 70, "History"],
Cell[10746, 406, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

