(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28858,        857]
NotebookOptionsPosition[     23999,        700]
NotebookOutlinePosition[     26008,        755]
CellTagsIndexPosition[     25890,        749]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Button" :> Documentation`HelpLookup["paclet:ref/Button"], 
          "CancelButton" :> 
          Documentation`HelpLookup["paclet:ref/CancelButton"], "PasteButton" :> 
          Documentation`HelpLookup["paclet:ref/PasteButton"], "DialogReturn" :> 
          Documentation`HelpLookup["paclet:ref/DialogReturn"], "DialogInput" :> 
          Documentation`HelpLookup["paclet:ref/DialogInput"], "CreateDialog" :> 
          Documentation`HelpLookup["paclet:ref/CreateDialog"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Button\"\>", 
       2->"\<\"CancelButton\"\>", 3->"\<\"PasteButton\"\>", 
       4->"\<\"DialogReturn\"\>", 5->"\<\"DialogInput\"\>", 
       6->"\<\"CreateDialog\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dialog Boxes" :> 
          Documentation`HelpLookup["paclet:guide/DialogBoxes"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Dialog Boxes\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["DefaultButton", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DefaultButton",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DefaultButton"], "[", "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]represents an OK button that closes a dialog, and is \
the default when ",
     StyleBox["Enter", "KeyEvent"],
     " is pressed in the dialog."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DefaultButton",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DefaultButton"], "[", 
       StyleBox["action", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a button that is labeled ",
     StyleBox["OK", "DialogElementName"],
     ", and whose action is to evaluate ",
     Cell[BoxData[
      StyleBox["action", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DefaultButton",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DefaultButton"], "[", 
       RowBox[{
        StyleBox["label", "TI"], ",", 
        StyleBox["action", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]uses ",
     Cell[BoxData[
      StyleBox["label", "TI"]], "InlineFormula"],
     " as the label for the button."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DefaultButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DefaultButton"], "[", "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DefaultButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DefaultButton"], "[", 
   RowBox[{
    ButtonBox["DialogReturn",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DialogReturn"], "[", "]"}], "]"}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->6334],

Cell[TextData[{
 "In dialogs created with ",
 Cell[BoxData[
  ButtonBox["DialogInput",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DialogInput"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["CreateDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateDialog"]], "InlineFormula"],
 ", pressing ",
 StyleBox["Enter", "KeyEvent"],
 " is effectively equivalent to pressing the OK button."
}], "Notes",
 CellID->26500],

Cell[TextData[{
 "If there are several default buttons in a single dialog, ",
 StyleBox["Enter", "KeyEvent"],
 " will use the first one in the dialog."
}], "Notes",
 CellID->19169]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->241901823],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->525472530],

Cell[TextData[{
 "Create dialog input and use ",
 Cell[BoxData[
  ButtonBox["DefaultButton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DefaultButton"]], "InlineFormula"],
 " to dismiss dialog: "
}], "ExampleText",
 CellID->15931009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DialogInput", "[", 
  RowBox[{"DefaultButton", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->471235],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztl8tPG1cUh5H6P3TfRdVtt5W6arulkaqoi1ZqABUTEkVVqy5aVc0CBdLE
JaoD2EDABQeTQCDUvAKmQKDBGGwcwIAf+AV+YGwMfo1jhOntuXPNZWobFVsz
MlKxPo7O3Dm/O58HIw/vVHzzWcVbJSUlH8DP+/CDe5Ho9kXjKHV8QaA+T3sm
ik6GT3F/Rzl9XE53TrZcHp/XvxfcD4ej0Wg8FstB8k2Sy8k6E48zDJOIxxiv
x3/W/vQzc04fu83p2Xb9JOt79/M7JR9+nxdvl96+KVZGIqFoJMaXj9Vsqazt
fK+0tvTnmeqa/XyBYPX9xwcHEb58zOsb8Dbv9XsKBuLBQIg/n3W487AtQmhJ
78wLiEAQ4v6dAL8+YtZndcWTFxARD3ghvuPb5dfnwYAPNt8w7eQFROqF8ZGo
8OYW6w6h5OTFXcnuISJR+YTwaRz2U5+cl85uiE/TsF8In+axAGzucO7B5aBy
ISvcSoFI89iuED5tE9jH7Q3DFaFyISvk15dxCiJtE0EhfDqm8JvdDTJwUahc
yArxyTgFkc6pPSF8lDMh2DwcScFFoXIhK9xKgYhydl8In565A9g8zhwDcFHS
cPvsBoAIBIXw6dfiD0PizTGB/r1zV7J7iPTNh4XwUemisHkydZwXEFHpo0L4
DC/FYPPjPF8QGTHEhPB5sRwvzGdsmYG4jz8f05oRNlQbmcJ81MYExL1e3p4P
4f7Ak+Gfa4mCgfjWlodHnx8ae+Axz7CDCgCCPzb2OuwuvnwsG2bnpgmUCnt+
FtV1uhwW26aNLx94a6AEn6IN45msGnRc6Dqk4PZCnMf7IzSXPpc+lz7/T5+b
t8SqIe19cVfR0WhN334nEd2qt9tcFouj6FAf9iEiVVz+Pk5Rn6OjFJNIAgm2
shyme+Zf65wBPMNwZughO3PY3NbTfvWj7isfK698kg2sw1mYYVM4mEweUp9I
lNkLRfZCYbZmNfv0kKyEOTPhM2Yig1c/TTU0og4Fkstz0KGAszBDI6H9KPXx
+UPbnuC2e3fbHUg3HiCAcbON+wS8uHuOmcBmVTkaHUEDvWcyOgIz6R08Abc3
SH1sTp9l052FJ91YOX268WQOWzOC21ZRORpUoWdPEHlBQ6CHgyqYYYcxVpuH
+hjXnStGO2H5pMnoc3L2gCPTB/8bxulPfGhkdc1OfXQG8+KSaQHQm7U684Le
tKiHamariW1MuNGd1kX2LBlLz7DB9MyS2SoqQ4MDqFeJyXh1/46UcvS8B3wW
dGQHM0SozyuN8S/MKq5zxllo5gCyaEw3c1xW01UDw9ln8aLl62vYRPEIKVpR
Z8upjFyK2hvRo4egZKm8Nsvuw26yOj2zQnymXr4mTM6wzYxh6qUBH7L19Cyu
ZCVdMwa4M9inqx21SFCzJPP+NNSjh7+i9hbw4WaHR7XEZ0y9MD6xyGUMoxsH
1Lhhe9KQAd1Jj9fJzLiaO6OzVJYheUvqNzG1OHxw2ifu3UWyJmtlGbkWrurF
p71TxGdoVDPyQpsP8/85gz8/sqbo3ToiEP+lLspCDg9qa1FTI8xwI23yIeIz
oJqHr1R+sV8vR1LpXk3NQe2dbGAdyaT2qjI6/8egVtLQS3z6nr163q/hF0P1
F6hVhmSANAdSKWpt09/4is7392ngK574KDonu7um+QW+m15XfumorrBVlWfj
uF5uqCqHGTqvfDwlqE++XPqc36dLMfmke7q4dCtPfeyOgN2xW3Soz8UBfP4B
rPNlzg==
   "], {{0, 0}, {48, 57}}, {0, 255}],
  ImageSize->{48 0.75, 57 0.75},
  PlotRange->{{0, 48}, {0, 57}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->573678847]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->91005894],

Cell[TextData[{
 "Create a dialog with a ",
 Cell[BoxData[
  ButtonBox["Locator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locator"]], "InlineFormula"],
 ", and return the last location: "
}], "ExampleText",
 CellID->739402437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DialogInput", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"LocatorPane", "[", 
     RowBox[{
      RowBox[{"Dynamic", "[", "coord", "]"}], ",", 
      RowBox[{"Framed", "@", 
       RowBox[{"Graphics", "[", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "]"}]}]}], "]"}], ",", 
    RowBox[{"Dynamic", "[", "coord", "]"}], ",", 
    RowBox[{"DefaultButton", "[", 
     RowBox[{"DialogReturn", "[", "coord", "]"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1680529057],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", "0.`"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->100702567],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnFtMG+kVxy31IW95S1/yVG1Xu0kfNn3Yais1L221fSKRqnQfGrUbokI2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   "], {{0, 0}, {134, 212}}, {0, 255}],
  ImageSize->{134 0.75, 212 0.75},
  PlotRange->{{0, 134}, {0, 212}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->194626654]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->243251750],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DefaultButton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DefaultButton"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["Button",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Button"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1385754336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefaultButton", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->912973437],

Cell[BoxData[
 ButtonBox["\<\"OK\"\>",
  Appearance->"DefaultButton",
  ButtonData->"paclet:ref/OK",
  ButtonFrame->"DefaultButton",
  ButtonFunction:>DialogReturn[],
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{28, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->573897844]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Button", "[", 
  RowBox[{"\"\<OK\>\"", ",", 
   RowBox[{"DialogReturn", "[", "]"}], ",", 
   RowBox[{"Appearance", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<DialogBox\>\"", ",", "\"\<Pressed\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->692896157],

Cell[BoxData[
 ButtonBox["\<\"OK\"\>",
  Appearance->{"DialogBox", "Pressed"},
  ButtonData->"paclet:ref/OK",
  ButtonFrame->"DialogBox",
  ButtonFunction:>{},
  Evaluator->None,
  Method->"Preemptive"]], "Output",
 ImageSize->{28, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1942785624]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->868786143],

Cell["\<\
Create a dialog with a OK button, the window is dismissed with a click or \
keyboard return:\
\>", "ExampleText",
 CellID->237458103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDialog", "[", 
   RowBox[{"DefaultButton", "[", "]"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1251346509],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztl8tPG1cUh5H6P3TfRdVtt5W6arulkaqoi1ZqABUTEkVVqy5aVc0CBdLE
JaoD2EDABQeTQCDUvAKmQKDBGGwcwIAf+AV+YGwMfo1jhOntuXPNZWobFVsz
MlKxPo7O3Dm/O58HIw/vVHzzWcVbJSUlH8DP+/CDe5Ho9kXjKHV8QaA+T3sm
ik6GT3F/Rzl9XE53TrZcHp/XvxfcD4ej0Wg8FstB8k2Sy8k6E48zDJOIxxiv
x3/W/vQzc04fu83p2Xb9JOt79/M7JR9+nxdvl96+KVZGIqFoJMaXj9Vsqazt
fK+0tvTnmeqa/XyBYPX9xwcHEb58zOsb8Dbv9XsKBuLBQIg/n3W487AtQmhJ
78wLiEAQ4v6dAL8+YtZndcWTFxARD3ghvuPb5dfnwYAPNt8w7eQFROqF8ZGo
8OYW6w6h5OTFXcnuISJR+YTwaRz2U5+cl85uiE/TsF8In+axAGzucO7B5aBy
ISvcSoFI89iuED5tE9jH7Q3DFaFyISvk15dxCiJtE0EhfDqm8JvdDTJwUahc
yArxyTgFkc6pPSF8lDMh2DwcScFFoXIhK9xKgYhydl8In565A9g8zhwDcFHS
cPvsBoAIBIXw6dfiD0PizTGB/r1zV7J7iPTNh4XwUemisHkydZwXEFHpo0L4
DC/FYPPjPF8QGTHEhPB5sRwvzGdsmYG4jz8f05oRNlQbmcJ81MYExL1e3p4P
4f7Ak+Gfa4mCgfjWlodHnx8ae+Axz7CDCgCCPzb2OuwuvnwsG2bnpgmUCnt+
FtV1uhwW26aNLx94a6AEn6IN45msGnRc6Dqk4PZCnMf7IzSXPpc+lz7/T5+b
t8SqIe19cVfR0WhN334nEd2qt9tcFouj6FAf9iEiVVz+Pk5Rn6OjFJNIAgm2
shyme+Zf65wBPMNwZughO3PY3NbTfvWj7isfK698kg2sw1mYYVM4mEweUp9I
lNkLRfZCYbZmNfv0kKyEOTPhM2Yig1c/TTU0og4Fkstz0KGAszBDI6H9KPXx
+UPbnuC2e3fbHUg3HiCAcbON+wS8uHuOmcBmVTkaHUEDvWcyOgIz6R08Abc3
SH1sTp9l052FJ91YOX268WQOWzOC21ZRORpUoWdPEHlBQ6CHgyqYYYcxVpuH
+hjXnStGO2H5pMnoc3L2gCPTB/8bxulPfGhkdc1OfXQG8+KSaQHQm7U684Le
tKiHamariW1MuNGd1kX2LBlLz7DB9MyS2SoqQ4MDqFeJyXh1/46UcvS8B3wW
dGQHM0SozyuN8S/MKq5zxllo5gCyaEw3c1xW01UDw9ln8aLl62vYRPEIKVpR
Z8upjFyK2hvRo4egZKm8Nsvuw26yOj2zQnymXr4mTM6wzYxh6qUBH7L19Cyu
ZCVdMwa4M9inqx21SFCzJPP+NNSjh7+i9hbw4WaHR7XEZ0y9MD6xyGUMoxsH
1Lhhe9KQAd1Jj9fJzLiaO6OzVJYheUvqNzG1OHxw2ifu3UWyJmtlGbkWrurF
p71TxGdoVDPyQpsP8/85gz8/sqbo3ToiEP+lLspCDg9qa1FTI8xwI23yIeIz
oJqHr1R+sV8vR1LpXk3NQe2dbGAdyaT2qjI6/8egVtLQS3z6nr163q/hF0P1
F6hVhmSANAdSKWpt09/4is7392ngK574KDonu7um+QW+m15XfumorrBVlWfj
uF5uqCqHGTqvfDwlqE++XPqc36dLMfmke7q4dCtPfeyOgN2xW3Soz8UBfP4B
rPNlzg==
   "], {{0, 0}, {48, 57}}, {0, 255}],
  ImageSize->{48 0.75, 57 0.75},
  PlotRange->{{0, 48}, {0, 57}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->110152945]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->89452001],

Cell["\<\
Create a dialog that holds evaluations until it is dismissed:\
\>", "ExampleText",
 CellID->2135742644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DialogInput", "[", 
  RowBox[{"DefaultButton", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->848524908],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztl8tPG1cUh5H6P3TfRdVtt5W6arulkaqoi1ZqABUTEkVVqy5aVc0CBdLE
JaoD2EDABQeTQCDUvAKmQKDBGGwcwIAf+AV+YGwMfo1jhOntuXPNZWobFVsz
MlKxPo7O3Dm/O58HIw/vVHzzWcVbJSUlH8DP+/CDe5Ho9kXjKHV8QaA+T3sm
ik6GT3F/Rzl9XE53TrZcHp/XvxfcD4ej0Wg8FstB8k2Sy8k6E48zDJOIxxiv
x3/W/vQzc04fu83p2Xb9JOt79/M7JR9+nxdvl96+KVZGIqFoJMaXj9Vsqazt
fK+0tvTnmeqa/XyBYPX9xwcHEb58zOsb8Dbv9XsKBuLBQIg/n3W487AtQmhJ
78wLiEAQ4v6dAL8+YtZndcWTFxARD3ghvuPb5dfnwYAPNt8w7eQFROqF8ZGo
8OYW6w6h5OTFXcnuISJR+YTwaRz2U5+cl85uiE/TsF8In+axAGzucO7B5aBy
ISvcSoFI89iuED5tE9jH7Q3DFaFyISvk15dxCiJtE0EhfDqm8JvdDTJwUahc
yArxyTgFkc6pPSF8lDMh2DwcScFFoXIhK9xKgYhydl8In565A9g8zhwDcFHS
cPvsBoAIBIXw6dfiD0PizTGB/r1zV7J7iPTNh4XwUemisHkydZwXEFHpo0L4
DC/FYPPjPF8QGTHEhPB5sRwvzGdsmYG4jz8f05oRNlQbmcJ81MYExL1e3p4P
4f7Ak+Gfa4mCgfjWlodHnx8ae+Axz7CDCgCCPzb2OuwuvnwsG2bnpgmUCnt+
FtV1uhwW26aNLx94a6AEn6IN45msGnRc6Dqk4PZCnMf7IzSXPpc+lz7/T5+b
t8SqIe19cVfR0WhN334nEd2qt9tcFouj6FAf9iEiVVz+Pk5Rn6OjFJNIAgm2
shyme+Zf65wBPMNwZughO3PY3NbTfvWj7isfK698kg2sw1mYYVM4mEweUp9I
lNkLRfZCYbZmNfv0kKyEOTPhM2Yig1c/TTU0og4Fkstz0KGAszBDI6H9KPXx
+UPbnuC2e3fbHUg3HiCAcbON+wS8uHuOmcBmVTkaHUEDvWcyOgIz6R08Abc3
SH1sTp9l052FJ91YOX268WQOWzOC21ZRORpUoWdPEHlBQ6CHgyqYYYcxVpuH
+hjXnStGO2H5pMnoc3L2gCPTB/8bxulPfGhkdc1OfXQG8+KSaQHQm7U684Le
tKiHamariW1MuNGd1kX2LBlLz7DB9MyS2SoqQ4MDqFeJyXh1/46UcvS8B3wW
dGQHM0SozyuN8S/MKq5zxllo5gCyaEw3c1xW01UDw9ln8aLl62vYRPEIKVpR
Z8upjFyK2hvRo4egZKm8Nsvuw26yOj2zQnymXr4mTM6wzYxh6qUBH7L19Cyu
ZCVdMwa4M9inqx21SFCzJPP+NNSjh7+i9hbw4WaHR7XEZ0y9MD6xyGUMoxsH
1Lhhe9KQAd1Jj9fJzLiaO6OzVJYheUvqNzG1OHxw2ifu3UWyJmtlGbkWrurF
p71TxGdoVDPyQpsP8/85gz8/sqbo3ToiEP+lLspCDg9qa1FTI8xwI23yIeIz
oJqHr1R+sV8vR1LpXk3NQe2dbGAdyaT2qjI6/8egVtLQS3z6nr163q/hF0P1
F6hVhmSANAdSKWpt09/4is7392ngK574KDonu7um+QW+m15XfumorrBVlWfj
uF5uqCqHGTqvfDwlqE++XPqc36dLMfmke7q4dCtPfeyOgN2xW3Soz8UBfP4B
rPNlzg==
   "], {{0, 0}, {48, 57}}, {0, 255}],
  ImageSize->{48 0.75, 57 0.75},
  PlotRange->{{0, 48}, {0, 57}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->210746672]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Button",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Button"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CancelButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CancelButton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PasteButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PasteButton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DialogReturn",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DialogReturn"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DialogInput",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DialogInput"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreateDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDialog"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->5941347],

Cell[TextData[ButtonBox["Dialog Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DialogBoxes"]], "MoreAbout",
 CellID->114399726]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DefaultButton - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 44.8338392}", "context" -> "System`", 
    "keywords" -> {
     "dialog return button", "default button", "dismiss a dialog", 
      "ok button"}, "index" -> True, "label" -> "Built-in Mathematica Symbol",
     "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "DefaultButton[] represents an OK button that closes a dialog, and is the \
default when Enter is pressed in the dialog. DefaultButton[action] represents \
a button that is labeled OK, and whose action is to evaluate action. \
DefaultButton[label, action] uses label as the label for the button.", 
    "synonyms" -> {"default button"}, "title" -> "DefaultButton", "type" -> 
    "Symbol", "uri" -> "ref/DefaultButton"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7070, 220, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->241901823]},
 "Notebook Image"->{
  Cell[8012, 259, 2005, 36, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->573678847],
  Cell[11345, 350, 3536, 61, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->194626654],
  Cell[17153, 510, 2005, 36, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->110152945],
  Cell[19583, 567, 2005, 36, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->210746672]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25310, 729},
 {"Notebook Image", 25451, 733}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1684, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2307, 65, 1578, 37, 70, "ObjectNameGrid"],
Cell[3888, 104, 1497, 46, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5422, 155, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5900, 172, 508, 19, 70, "Notes",
 CellID->6334],
Cell[6411, 193, 439, 15, 70, "Notes",
 CellID->26500],
Cell[6853, 210, 180, 5, 70, "Notes",
 CellID->19169]
}, Closed]],
Cell[CellGroupData[{
Cell[7070, 220, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->241901823],
Cell[CellGroupData[{
Cell[7455, 234, 148, 5, 70, "ExampleSection",
 CellID->525472530],
Cell[7606, 241, 239, 8, 70, "ExampleText",
 CellID->15931009],
Cell[CellGroupData[{
Cell[7870, 253, 139, 4, 70, "Input",
 CellID->471235],
Cell[8012, 259, 2005, 36, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->573678847]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10066, 301, 226, 7, 70, "ExampleSection",
 CellID->91005894],
Cell[10295, 310, 235, 8, 70, "ExampleText",
 CellID->739402437],
Cell[CellGroupData[{
Cell[10555, 322, 577, 17, 70, "Input",
 CellID->1680529057],
Cell[11135, 341, 207, 7, 36, "Output",
 CellID->100702567],
Cell[11345, 350, 3536, 61, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->194626654]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14930, 417, 237, 7, 70, "ExampleSection",
 CellID->243251750],
Cell[15170, 426, 331, 12, 70, "ExampleText",
 CellID->1385754336],
Cell[CellGroupData[{
Cell[15526, 442, 104, 3, 70, "Input",
 CellID->912973437],
Cell[15633, 447, 356, 12, 70, "Output",
 CellID->573897844]
}, Open  ]],
Cell[CellGroupData[{
Cell[16026, 464, 302, 9, 70, "Input",
 CellID->692896157],
Cell[16331, 475, 345, 12, 70, "Output",
 CellID->1942785624]
}, Open  ]],
Cell[16691, 490, 125, 3, 70, "ExampleDelimiter",
 CellID->868786143],
Cell[16819, 495, 143, 4, 70, "ExampleText",
 CellID->237458103],
Cell[CellGroupData[{
Cell[16987, 503, 163, 5, 70, "Input",
 CellID->1251346509],
Cell[17153, 510, 2005, 36, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->110152945]
}, Open  ]],
Cell[19173, 549, 124, 3, 70, "ExampleDelimiter",
 CellID->89452001],
Cell[19300, 554, 113, 3, 70, "ExampleText",
 CellID->2135742644],
Cell[CellGroupData[{
Cell[19438, 561, 142, 4, 70, "Input",
 CellID->848524908],
Cell[19583, 567, 2005, 36, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->210746672]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21649, 610, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[21968, 621, 1467, 53, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[23472, 679, 317, 9, 70, "MoreAboutSection",
 CellID->5941347],
Cell[23792, 690, 135, 3, 70, "MoreAbout",
 CellID->114399726]
}, Open  ]],
Cell[23942, 696, 27, 0, 70, "History"],
Cell[23972, 698, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

