(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16844,        479]
NotebookOptionsPosition[     13683,        380]
NotebookOutlinePosition[     15411,        428]
CellTagsIndexPosition[     15293,        422]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Notebooks" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForNotebooks"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Options for Notebooks\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DefaultNewCellStyle" :> 
          Documentation`HelpLookup["paclet:ref/DefaultNewCellStyle"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"DefaultNewCellStyle\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DefaultDuplicateCellStyle", "ObjectName",
 CellID->5450],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["DefaultDuplicateCellStyle",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DefaultDuplicateCellStyle"]], "InlineFormula"],
     
     "\[LineSeparator]is a notebook option which specifies the default style \
to use for cells created by automatic duplication of other cells in the \
notebook. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19149]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A typical default setting for ",
 Cell[BoxData[
  ButtonBox["DefaultDuplicateCellStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DefaultDuplicateCellStyle"]], "InlineFormula"],
 " is ",
 Cell[BoxData["\"\<Input\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1951],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DefaultDuplicateCellStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DefaultDuplicateCellStyle"]], "InlineFormula"],
 " determines the style for new cells created from cells with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CellEditDuplicate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellEditDuplicate"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CellEvaluationDuplicate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellEvaluationDuplicate"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32581]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->321175169],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->213378452],

Cell[TextData[{
 "Create a document in which ",
 Cell[BoxData["\"\<Output\>\""], "InlineFormula"],
 " cells are duplicated as ",
 Cell[BoxData["\"\<MyDuplicate\>\""], "InlineFormula"],
 " cells:"
}], "ExampleText",
 CellID->475455820],

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDocument", "[", 
   RowBox[{
    RowBox[{"ExpressionCell", "[", 
     RowBox[{
      RowBox[{"2", "+", "a"}], ",", "\"\<Output\>\""}], "]"}], ",", 
    RowBox[{"DefaultDuplicateCellStyle", "\[Rule]", "\"\<MyDuplicate\>\""}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"StyleDefinitions", "\[Rule]", 
     RowBox[{"Notebook", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Cell", "[", 
         RowBox[{
          RowBox[{"StyleData", "[", "\"\<Output\>\"", "]"}], ",", 
          RowBox[{"CellEditDuplicate", "\[Rule]", "True"}], ",", 
          RowBox[{"CellEditDuplicateMakesCopy", "\[Rule]", "True"}], ",", 
          RowBox[{"CellMargins", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"66", ",", "10"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"10", ",", "5"}], "}"}]}], "}"}]}]}], "]"}], ",", 
        RowBox[{"Cell", "[", 
         RowBox[{
          RowBox[{"StyleData", "[", "\"\<MyDuplicate\>\"", "]"}], ",", 
          RowBox[{"CellEditDuplicate", "\[Rule]", "False"}], ",", 
          RowBox[{"CellMargins", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"66", ",", "10"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"10", ",", "5"}], "}"}]}], "}"}]}], ",", 
          RowBox[{"CellFrame", "\[Rule]", "True"}]}], "]"}]}], "}"}], 
      "]"}]}]}], "]"}], ";"}]], "Input",
 ShowSyntaxStyles->False,
 CellLabel->"In[1]:=",
 CellID->813396349],

Cell[TextData[{
 "Position the insertion point at the end of an ",
 Cell[BoxData["\"\<Output\>\""], "InlineFormula"],
 " cell's contents:"
}], "ExampleText",
 CellID->632838807],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnFtPlEcch7fpfeNX6Ffp4aI3mjbetE2qmIq2jTE2vWjSpBemaqu1qSfw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   "], {{0, 0}, {458, 73}}, {0, 255}],
  ImageSize->{458 0.75, 73 0.75},
  PlotRange->{{0, 458}, {0, 73}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->187223629],

Cell[TextData[{
 "When you type something in the cell, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " makes a new copy in ",
 Cell[BoxData["\"\<MyDuplicate\>\""], "InlineFormula"],
 " style:"
}], "ExampleText",
 CellID->75727345],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3d9TlNcdx3E6vfGqk0tv+68k7a1OMrlJOtOIU9G04zh2cpGZzPQiU5M2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   "], {{0, 0}, {458, 109}}, {0, 255}],
  ImageSize->{458 0.75, 109 0.75},
  PlotRange->{{0, 458}, {0, 109}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->729210102]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31584],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["DefaultNewCellStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DefaultNewCellStyle"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->21433]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31598],

Cell[TextData[ButtonBox["Options for Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForNotebooks"]], "Tutorials",
 CellID->21845]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DefaultDuplicateCellStyle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 45.5838584}", "context" -> "System`", 
    "keywords" -> {
     "automatic cell duplication", "automatic cell copying", 
      "automatic cell style"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DefaultDuplicateCellStyle is a notebook option which specifies the \
default style to use for cells created by automatic duplication of other \
cells in the notebook. ", "synonyms" -> {"default duplicate cell style"}, 
    "title" -> "DefaultDuplicateCellStyle", "type" -> "Symbol", "uri" -> 
    "ref/DefaultDuplicateCellStyle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4069, 141, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->321175169]},
 "Notebook Image"->{
  Cell[6584, 220, 2553, 45, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->187223629],
  Cell[9380, 277, 3145, 54, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->729210102]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14922, 408},
 {"Notebook Image", 15063, 412}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1197, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1820, 58, 62, 1, 70, "ObjectName",
 CellID->5450],
Cell[1885, 61, 564, 16, 70, "Usage",
 CellID->19149]
}, Open  ]],
Cell[CellGroupData[{
Cell[2486, 82, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2964, 99, 296, 10, 70, "Notes",
 CellID->1951],
Cell[3263, 111, 769, 25, 70, "Notes",
 CellID->32581]
}, Closed]],
Cell[CellGroupData[{
Cell[4069, 141, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->321175169],
Cell[CellGroupData[{
Cell[4454, 155, 148, 5, 70, "ExampleSection",
 CellID->213378452],
Cell[4605, 162, 234, 7, 70, "ExampleText",
 CellID->475455820],
Cell[4842, 171, 1559, 40, 70, "Input",
 CellID->813396349],
Cell[6404, 213, 177, 5, 70, "ExampleText",
 CellID->632838807],
Cell[6584, 220, 2553, 45, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->187223629],
Cell[9140, 267, 237, 8, 70, "ExampleText",
 CellID->75727345],
Cell[9380, 277, 3145, 54, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->729210102]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12574, 337, 311, 9, 70, "SeeAlsoSection",
 CellID->31584],
Cell[12888, 348, 218, 6, 70, "SeeAlso",
 CellID->21433]
}, Open  ]],
Cell[CellGroupData[{
Cell[13143, 359, 314, 9, 70, "TutorialsSection",
 CellID->31598],
Cell[13460, 370, 151, 3, 70, "Tutorials",
 CellID->21845]
}, Open  ]],
Cell[13626, 376, 27, 0, 70, "History"],
Cell[13656, 378, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

