(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16282,        556]
NotebookOptionsPosition[     13080,        454]
NotebookOutlinePosition[     14571,        494]
CellTagsIndexPosition[     14486,        489]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Style" :> Documentation`HelpLookup["paclet:ref/Style"], 
          "BaseStyle" :> Documentation`HelpLookup["paclet:ref/BaseStyle"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Style\"\>", 
       2->"\<\"BaseStyle\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Controls Options" :> 
          Documentation`HelpLookup["paclet:guide/ControlsOptions"], 
          "New in 6.0: Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FormattingAndStyling"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Controls Options\"\>", 
       2->"\<\"New in 6.0: Formatting & Styling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["DefaultOptions", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["DefaultOptions",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DefaultOptions"]], "InlineFormula"],
     "\[LineSeparator]is a style option which allows default options to be \
specified for particular formatting and related constructs. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6287]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A typical setting is ",
 Cell[BoxData[
  RowBox[{"DefaultOptions", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox[
       StyleBox["obj", "TI"], 
       StyleBox["1", "TR"]], "->", 
      SubscriptBox[
       StyleBox["opts", "TI"], 
       StyleBox["1", "TR"]]}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 ", where the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["obj", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are symbols such as ",
 Cell[BoxData[
  ButtonBox["Button",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Button"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Pane",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pane"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31863],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"DefaultOptions", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox[
         StyleBox["obj", "TI"], 
         StyleBox["1", "TR"]], "->", 
        SubscriptBox[
         StyleBox["opts", "TI"], 
         StyleBox["1", "TR"]]}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]}], "]"}]], "InlineFormula"],
 " specifies that when ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["obj", "TI"], 
    StyleBox["i", "TI"]], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 " appears in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", it should be given the default options ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["opt", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16979]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->628060149],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->176289875],

Cell[TextData[{
 "Locally set ",
 Cell[BoxData[
  ButtonBox["DefaultOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DefaultOptions"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->105572740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"Slider", "[", ".5", "]"}]}], "}"}], ",", 
   RowBox[{"DefaultOptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Graphics", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ImageSize", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"90", ",", "90"}], "}"}]}], ",", 
         RowBox[{"Background", "\[Rule]", "LightBlue"}]}], "}"}]}], ",", 
      RowBox[{"Slider", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Appearance", "\[Rule]", "Small"}], ",", 
         RowBox[{"Background", "\[Rule]", "LightGreen"}]}], "}"}]}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12412063],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{
    GraphicsBox[CircleBox[{0, 0}]], ",", 
    SliderBox[0.5]}], "}"}],
  StripOnInput->False,
  SliderBoxOptions->{Appearance->Small,
  Background->RGBColor[0.88, 1, 0.88]},
  GraphicsBoxOptions->{Background->RGBColor[0.87, 0.94, 1],
  ImageSize->{90, 90}}]], "Output",
 ImageSize->{320, 92},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->78069277]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->256549],

Cell["\<\
Explicit option settings in an object override default options for that type \
of object:\
\>", "ExampleText",
 CellID->807970789],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Circle", "[", "]"}], ",", 
       RowBox[{"Background", "\[Rule]", "Pink"}]}], "]"}], ",", 
     RowBox[{"Slider", "[", 
      RowBox[{".5", ",", 
       RowBox[{"Appearance", "\[Rule]", "Large"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"DefaultOptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Graphics", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ImageSize", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"90", ",", "90"}], "}"}]}], ",", 
         RowBox[{"Background", "\[Rule]", "LightBlue"}]}], "}"}]}], ",", 
      RowBox[{"Slider", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Appearance", "\[Rule]", "Small"}], ",", 
         RowBox[{"Background", "\[Rule]", "LightGreen"}]}], "}"}]}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->358337721],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{
    GraphicsBox[CircleBox[{0, 0}],
     Background->RGBColor[1, 0.5, 0.5]], ",", 
    SliderBox[0.5,
     Appearance->Large]}], "}"}],
  StripOnInput->False,
  SliderBoxOptions->{Appearance->Small,
  Background->RGBColor[0.88, 1, 0.88]},
  GraphicsBoxOptions->{Background->RGBColor[0.87, 0.94, 1],
  ImageSize->{90, 90}}]], "Output",
 ImageSize->{320, 92},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73033120]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18886],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BaseStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BaseStyle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24906]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22966],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->444657240]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->478420],

Cell[TextData[ButtonBox["Controls Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlsOptions"]], "MoreAbout",
 CellID->238675882],

Cell[TextData[ButtonBox["New in 6.0: Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FormattingAndStyling"]], "MoreAbout",
 CellID->939758027]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DefaultOptions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 59.9436010}", "context" -> "System`", 
    "keywords" -> {
     "default options", "scoping of options", "inheritance of options", 
      "cascading options", "cascading styles", "hierarchical options", 
      "hierarchical styles", "style default options"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DefaultOptions is a style option which allows default options to be \
specified for particular formatting and related constructs. ", 
    "synonyms" -> {"default options"}, "title" -> "DefaultOptions", "type" -> 
    "Symbol", "uri" -> "ref/DefaultOptions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7144, 230, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->628060149]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14343, 482}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1981, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2604, 76, 1579, 37, 70, "ObjectNameGrid"],
Cell[4186, 115, 509, 14, 70, "Usage",
 CellID->6287]
}, Open  ]],
Cell[CellGroupData[{
Cell[4732, 134, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5210, 151, 918, 36, 70, "Notes",
 CellID->31863],
Cell[6131, 189, 976, 36, 70, "Notes",
 CellID->16979]
}, Closed]],
Cell[CellGroupData[{
Cell[7144, 230, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->628060149],
Cell[CellGroupData[{
Cell[7529, 244, 148, 5, 70, "ExampleSection",
 CellID->176289875],
Cell[7680, 251, 208, 8, 70, "ExampleText",
 CellID->105572740],
Cell[CellGroupData[{
Cell[7913, 263, 836, 25, 65, "Input",
 CellID->12412063],
Cell[8752, 290, 452, 15, 113, "Output",
 CellID->78069277]
}, Open  ]],
Cell[9219, 308, 122, 3, 70, "ExampleDelimiter",
 CellID->256549],
Cell[9344, 313, 140, 4, 70, "ExampleText",
 CellID->807970789],
Cell[CellGroupData[{
Cell[9509, 321, 985, 29, 70, "Input",
 CellID->358337721],
Cell[10497, 352, 516, 17, 70, "Output",
 CellID->73033120]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11074, 376, 311, 9, 70, "SeeAlsoSection",
 CellID->18886],
Cell[11388, 387, 447, 17, 70, "SeeAlso",
 CellID->24906]
}, Open  ]],
Cell[CellGroupData[{
Cell[11872, 409, 314, 9, 70, "TutorialsSection",
 CellID->22966],
Cell[12189, 420, 146, 3, 70, "Tutorials",
 CellID->444657240]
}, Open  ]],
Cell[CellGroupData[{
Cell[12372, 428, 316, 9, 70, "MoreAboutSection",
 CellID->478420],
Cell[12691, 439, 143, 3, 70, "MoreAbout",
 CellID->238675882],
Cell[12837, 444, 171, 3, 70, "MoreAbout",
 CellID->939758027]
}, Open  ]],
Cell[13023, 450, 27, 0, 70, "History"],
Cell[13053, 452, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

