(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     50435,       1485]
NotebookOptionsPosition[     42895,       1221]
NotebookOutlinePosition[     44455,       1264]
CellTagsIndexPosition[     44319,       1258]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Some Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SomeMathematicalFunctions"], 
          "Elementary Transcendental Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ElementaryTranscendentalFunctions"], 
          "Mathematical Constants" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicalConstants"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Some Mathematical Functions\"\>", 
       2->"\<\"Elementary Transcendental Functions\"\>", 
       3->"\<\"Mathematical Constants\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Pi" :> Documentation`HelpLookup["paclet:ref/Pi"], "Sin" :> 
          Documentation`HelpLookup["paclet:ref/Sin"], "ArcSin" :> 
          Documentation`HelpLookup["paclet:ref/ArcSin"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Pi\"\>", 2->"\<\"Sin\"\>", 
       3->"\<\"ArcSin\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elementary Functions" :> 
          Documentation`HelpLookup["paclet:guide/ElementaryFunctions"], 
          "Mathematical Constants" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalConstants"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Trigonometric Functions" :> 
          Documentation`HelpLookup["paclet:guide/TrigonometricFunctions"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Elementary Functions\"\>", 
       2->"\<\"Mathematical Constants\"\>", 
       3->"\<\"Mathematical Functions\"\>", 
       4->"\<\"Trigonometric Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Degree", "ObjectName",
 CellID->9365],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Degree",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Degree"]], "InlineFormula"],
     "\[LineSeparator]gives the number of radians in one degree. It has a \
numerical value of ",
     Cell[BoxData[
      FormBox[
       FractionBox["\[Pi]", "180"], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26756]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You can multiply by ",
 Cell[BoxData[
  ButtonBox["Degree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Degree"]], "InlineFormula"],
 " to convert from degrees to radians, so that ",
 Cell[BoxData[
  RowBox[{"30", "Degree"}]], "InlineFormula"],
 " represents ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["30", "\[EmptySmallCircle]"], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->7184],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Degree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Degree"]], "InlineFormula"],
 " can be entered in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " as ",
 Cell[BoxData["\[Degree]"], "InlineFormula"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]deg\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 Cell[TextData[ButtonBox["\\[Degree]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Degree"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->25106],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Degree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Degree"]], "InlineFormula"],
 " is printed in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " as\[NonBreakingSpace]",
 Cell[BoxData["\[Degree]"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9265]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->80413085],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->901894669],

Cell["Use in arguments of trigonometric functions:", "ExampleText",
 CellID->259679139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cos", "[", 
  RowBox[{"30", " ", "Degree"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->316935378],

Cell[BoxData[
 FractionBox[
  SqrtBox["3"], "2"]], "Output",
 ImageSize->{32, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->531496557]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->118326536],

Cell["Evaluate to any precision:", "ExampleText",
 CellID->5672255],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Degree", ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68201518],

Cell[BoxData["0.\
0174532925199432957692369076848861271344287188854172545609719144017`50."], \
"Output",
 ImageSize->{375, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9306397]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->291395277],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Degree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Degree"]], "InlineFormula"],
 " can be entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]deg\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ":"
}], "ExampleText",
 CellID->160355370],

Cell[CellGroupData[{

Cell[BoxData["\[Degree]"], "Input",
 CellLabel->"In[1]:=",
 CellID->228889552],

Cell[BoxData["\[Degree]"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->370122322]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5035],

Cell["Do an exact numerical computation:", "ExampleText",
 CellID->15404041],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Round", "[", 
  RowBox[{"Pi", "/", 
   RowBox[{"Degree", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->363457285],

Cell[BoxData["10313"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->98659920]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10677],

Cell["Plot a triangle with angles specified in degrees:", "ExampleText",
 CellID->41712219],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Alpha]", "=", 
      RowBox[{"30", " ", "\[Degree]"}]}], ",", 
     RowBox[{"\[Beta]", "=", 
      RowBox[{"75", "\[Degree]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Polygon", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Cos", "[", "\[Alpha]", "]"}], " ", 
          RowBox[{"Csc", "[", 
           RowBox[{"\[Alpha]", "+", "\[Beta]"}], "]"}], " ", 
          RowBox[{"Sin", "[", "\[Beta]", "]"}]}], ",", 
         RowBox[{
          RowBox[{"Csc", "[", 
           RowBox[{"\[Alpha]", "+", "\[Beta]"}], "]"}], " ", 
          RowBox[{"Sin", "[", "\[Alpha]", "]"}], " ", 
          RowBox[{"Sin", "[", "\[Beta]", "]"}]}]}], "}"}]}], "}"}], "]"}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->209741049],

Cell[BoxData[
 GraphicsBox[
  PolygonBox[
   NCache[{{0, 0}, {1, 
     0}, {((Rational[-1, 4] 3^Rational[1, 2]) (1 - 3^Rational[1, 2])) (1 + 
       3^Rational[1, 2]), (Rational[-1, 4] (1 - 3^Rational[1, 2])) (1 + 
       3^Rational[1, 2])}}, {{0, 0}, {1, 0}, {0.866025403784438, 0.5}}]],
  ImageMargins->0.,
  ImageSize->Small]], "Output",
 ImageSize->{184, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->216697196]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17049],

Cell[TextData[{
 "Evaluate symbolic relations involving ",
 Cell[BoxData[
  ButtonBox["Degree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Degree"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->367290157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Pi", "/", "4"}], "<", 
  RowBox[{"60", "Degree"}], "<", "Pi"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->100111542],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->251100275]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->329238512],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify expressions containing ",
 Cell[BoxData[
  ButtonBox["Degree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Degree"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->275042338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"Pi", "/", "Degree"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29392964],

Cell[BoxData["180"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13085890]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"Degree", " ", "-", " ", 
   RowBox[{"4", 
    RowBox[{"ArcTan", "[", 
     RowBox[{"1", "/", "5"}], "]"}]}], "+", " ", 
   RowBox[{"ArcTan", "[", 
    RowBox[{"1", "/", "239"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->318114960],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"11", " ", "\[Pi]"}], "45"]}]], "Output",
 ImageSize->{41, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1048580997]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->634054345],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Degree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Degree"]], "InlineFormula"],
 " is not an algebraic number:"
}], "ExampleText",
 CellID->96651630],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{"Degree", ",", "Algebraics"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->481054784],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->294166165]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1206],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Degree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Degree"]], "InlineFormula"],
 " is typically not generated as output:"
}], "ExampleText",
 CellID->156902562],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcSin", "[", "1", "]"}], "/", "90"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->230588711],

Cell[BoxData[
 FractionBox["\[Pi]", "180"]], "Output",
 ImageSize->{30, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->174442233]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " does not transform expressions to ",
 Cell[BoxData[
  ButtonBox["Degree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Degree"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->259487002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->320788211],

Cell[BoxData[
 FractionBox["\[Pi]", "180"]], "Output",
 ImageSize->{30, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->316905946]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21435],

Cell["Form degree graphics of various degrees of complexity: ", "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->82459453],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Nest", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"#", ",", 
       RowBox[{"#", "^", "#"}]}], "]"}], "&"}], ",", "Degree", ",", "3"}], 
   "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->331090578],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{110, 191},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->12725298]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->367371453],

Cell[BoxData["0.6945806361142162`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->116604852]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Nest", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Subscript", "[", 
       RowBox[{"#", ",", "#"}], "]"}], "^", "#"}], "&"}], ",", "Degree", ",", 
    "6"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->319385513],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{449, 386},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TraditionalForm=",
 CellID->168912979]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Nest", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", 
        RowBox[{
         RowBox[{"(", "#", ")"}], "^", "#"}]}], "&"}], ",", "Degree", ",", 
      RowBox[{"RandomInteger", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], "]"}]}], "]"}], ",", 
    RowBox[{"{", "4", "}"}], ",", 
    RowBox[{"{", "4", "}"}]}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->5204498],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW01ME0EU3rVgQAGNQUW8VIkJJyUeDIkeSBThYMWERKMRA0JJQYgNkkg0
ykmqJ+TEkSOJF6IeiMHQxGh60RBP9dZjjz1yXN+b7cLyuryZ/aOtloTZmdnv
vTfz3tvtfrM7sZHZRHx6ZHZidCTaNzOSTEyMPovefDoDXRFd0/TvmqYttWlQ
N6Am/vHvB/ybVVqLYBlZWVnJZrNYxTNfRN/29nYqlYLSxGiHLOTa2pqF3BB9
uVwumUxiVWBMpfl8vr+/X6A2BWpubm59fR2r+i5qfn4ejNhQmUymp6eHoKAH
hidQafjXo9GoDgOzEIVCwZyoVg/FIahP73OcROnu7m4d5mBJb21tgT5s1InC
8hmefOKpZwKtDA8P64uLi5aVdDrd2dkZihXwoWUFplX0npInUBIiZ0lDbIvS
jSIWu9amXLbjlnYcX4n2BhsaSjFWu3QraccIfkrSpvoesaOhc62TjOa2S19Q
ffxoWqCoh64TxSOKXC7WeckmEfYdO0VfRIj1446oAZU5SXU/YMd3lERJ3CsO
2zPaLGn0GhVxNE4XiT1Z1qiOZ1AeBRuaStNsaJacp7O6pBIpF/b52Zwx9maj
PSvPFuu8htOGSub4yV08qlkZYEd6yobm8qFJEec1j7FoVrRxR+57JheCzlUs
WiQ6+RhcNUrzLMFKnCf6W5UyQS3fsDhJ+m6xozlH4tZK2kHnFBY0V2Lu/RVg
jjjlAO+zIVush1jkDU+xxuI+q/e6x6hhg//Ncxwx4035WBGRZhHjDjrvshJx
Ml+UuBewDfm4a4hyIJR5gqN0oFymzFb8eeJgGZOM8YxJzssYlj8GJWNAccl5
GeNyx6heGebvy6Sx99li0FBmVa6Z0JgSiuFiAXMtr1znoUe5oDhbOJzMLUca
con3y+n8cba3hnO+W8drhgpvWzCCy3M/7K5bSZZnFW9saC6r6F2zXAxQ9Srg
2d8C0cr9RjidD5odyrKcjyFC2o29mfyOlVgi+ulVHyRTvELaPON5T+JL785h
s0aaXzxjVPJjgHlE84T3JUKsO9prKbLDUw68kOq1s2o3EXzpbcSMN+VjTUsR
vUTnc6mEnefifOdCsCEfdw1RY4819hg+e6Tnx33NzS07pOf5uVP294tFh8n2
6PPWY3Yk5WZwVG7Uvd9CZFgUz/uSMqJvLDpI5rPJWgqal6Tl8/LBB/i5IIS3
L3uO3GClZc/MX0O0LZ9bDVEORO3poxqfPsJeq/aL73Plq7DXtv3i+dlYXxvt
tza+X5vXqrZmEv4aefCyvey8vX7hVC2r7NVi7wIbJbfrUZW2+l9p+nlvW1+Q
yd5GqPbz1tS+A6uUtxaVbaGD9bTq13LV9k7lfxlHOxtd2ZeDlfbuqNrtOUVj
dXW1GI0Phrunsx1tiUSidP8B/QLwIN+LVYtuvLsJ79n2VuzuE6FfeZb7/d2/
Zu+YUbp/Jp/PNzQIKqmUvwFeu/ReUG36hTfhTqLDDcXyJhy6urpyuZz209j7
fGYdhVRbW5teKBRsUnA9LC8va5+dxiy9qmIHKHVEtLPZbOluMujEnWmfbBJu
spquJ4QtZ7JKcDz8PO/OxNyNl0qlMpkMVj86eYnJEkevBog310kgeeA6xqq5
MzBizQVSD6sI3dltCN24k8/cbWhmMVz1RX2/iX61fS+gDxSLqtCaJT6X7QkS
15r2x6VtETHRMPdYavpfLR46tg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{452, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//TraditionalForm=",
 CellID->61624803]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", "%", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->8211936],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{462, 158},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->66456507]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->746302882],

Cell[BoxData[
 RowBox[{"-", "1.5333996261867942`*^-7"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->44068197]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31807],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pi"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sin"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcSin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcSin"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32662]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12000],

Cell[TextData[ButtonBox["Some Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeMathematicalFunctions"]], "Tutorials",
 CellID->5984],

Cell[TextData[ButtonBox["Elementary Transcendental Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ElementaryTranscendentalFunctions"]], "Tutorials",
 CellID->4389],

Cell[TextData[ButtonBox["Mathematical Constants",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MathematicalConstants"]], "Tutorials",
 CellID->25402]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->25411],

Cell[TextData[{
 ButtonBox["Demonstrations with Degree",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Degree"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/Degree.html"], 
   None}], "IT"]], "RelatedLinks",
 CellID->24389631],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/Constants/Degree/"], 
   None}]], "RelatedLinks",
 CellID->114631470]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->42080385],

Cell[TextData[ButtonBox["Elementary Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementaryFunctions"]], "MoreAbout",
 CellID->297772140],

Cell[TextData[ButtonBox["Mathematical Constants",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalConstants"]], "MoreAbout",
 CellID->157312431],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->349368528],

Cell[TextData[ButtonBox["Trigonometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TrigonometricFunctions"]], "MoreAbout",
 CellID->101064390]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Degree - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 37, 7.7406756}", "context" -> "System`", 
    "keywords" -> {
     "angle", "angular measure", "angle measure", "angle measurement", 
      "radian", "degree of arc", "arc", "degree", "arcdegree", "plane angle"},
     "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Degree gives the number of radians in one degree. It has a numerical \
value of \\[Pi]/180. ", "synonyms" -> {}, "title" -> "Degree", "type" -> 
    "Symbol", "uri" -> "ref/Degree"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6133, 199, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->80413085]},
 "XRef-2005-4-26-23-37-1.8558342"->{
  Cell[15718, 606, 142, 2, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->82459453]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 44024, 1247},
 {"XRef-2005-4-26-23-37-1.8558342", 44180, 1251}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2761, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3384, 90, 43, 1, 70, "ObjectName",
 CellID->9365],
Cell[3430, 93, 567, 18, 70, "Usage",
 CellID->26756]
}, Open  ]],
Cell[CellGroupData[{
Cell[4034, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4512, 133, 429, 16, 70, "Notes",
 CellID->7184],
Cell[4944, 151, 765, 27, 70, "Notes",
 CellID->25106],
Cell[5712, 180, 384, 14, 70, "Notes",
 CellID->9265]
}, Closed]],
Cell[CellGroupData[{
Cell[6133, 199, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->80413085],
Cell[CellGroupData[{
Cell[6517, 213, 148, 5, 70, "ExampleSection",
 CellID->901894669],
Cell[6668, 220, 87, 1, 70, "ExampleText",
 CellID->259679139],
Cell[CellGroupData[{
Cell[6780, 225, 128, 4, 28, "Input",
 CellID->316935378],
Cell[6911, 231, 190, 7, 56, "Output",
 CellID->531496557]
}, Open  ]],
Cell[7116, 241, 125, 3, 70, "ExampleDelimiter",
 CellID->118326536],
Cell[7244, 246, 67, 1, 70, "ExampleText",
 CellID->5672255],
Cell[CellGroupData[{
Cell[7336, 251, 125, 4, 70, "Input",
 CellID->68201518],
Cell[7464, 257, 233, 7, 36, "Output",
 CellID->9306397]
}, Open  ]],
Cell[7712, 267, 125, 3, 70, "ExampleDelimiter",
 CellID->291395277],
Cell[7840, 272, 314, 11, 70, "ExampleText",
 CellID->160355370],
Cell[CellGroupData[{
Cell[8179, 287, 78, 2, 70, "Input",
 CellID->228889552],
Cell[8260, 291, 166, 5, 36, "Output",
 CellID->370122322]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8475, 302, 215, 7, 70, "ExampleSection",
 CellID->5035],
Cell[8693, 311, 76, 1, 70, "ExampleText",
 CellID->15404041],
Cell[CellGroupData[{
Cell[8794, 316, 154, 5, 70, "Input",
 CellID->363457285],
Cell[8951, 323, 161, 5, 36, "Output",
 CellID->98659920]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9161, 334, 223, 7, 70, "ExampleSection",
 CellID->10677],
Cell[9387, 343, 91, 1, 70, "ExampleText",
 CellID->41712219],
Cell[CellGroupData[{
Cell[9503, 348, 1062, 31, 70, "Input",
 CellID->209741049],
Cell[10568, 381, 471, 13, 115, "Output",
 CellID->216697196]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11088, 400, 233, 7, 70, "ExampleSection",
 CellID->17049],
Cell[11324, 409, 217, 8, 70, "ExampleText",
 CellID->367290157],
Cell[CellGroupData[{
Cell[11566, 421, 151, 5, 70, "Input",
 CellID->100111542],
Cell[11720, 428, 161, 5, 36, "Output",
 CellID->251100275]
}, Open  ]],
Cell[11896, 436, 125, 3, 70, "ExampleDelimiter",
 CellID->329238512],
Cell[12024, 441, 351, 13, 70, "ExampleText",
 CellID->275042338],
Cell[CellGroupData[{
Cell[12400, 458, 136, 4, 70, "Input",
 CellID->29392964],
Cell[12539, 464, 159, 5, 36, "Output",
 CellID->13085890]
}, Open  ]],
Cell[CellGroupData[{
Cell[12735, 474, 302, 9, 70, "Input",
 CellID->318114960],
Cell[13040, 485, 227, 8, 51, "Output",
 CellID->1048580997]
}, Open  ]],
Cell[13282, 496, 125, 3, 70, "ExampleDelimiter",
 CellID->634054345],
Cell[13410, 501, 200, 7, 70, "ExampleText",
 CellID->96651630],
Cell[CellGroupData[{
Cell[13635, 512, 140, 4, 70, "Input",
 CellID->481054784],
Cell[13778, 518, 162, 5, 36, "Output",
 CellID->294166165]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13989, 529, 225, 7, 70, "ExampleSection",
 CellID->1206],
Cell[14217, 538, 211, 7, 70, "ExampleText",
 CellID->156902562],
Cell[CellGroupData[{
Cell[14453, 549, 126, 4, 70, "Input",
 CellID->230588711],
Cell[14582, 555, 184, 6, 49, "Output",
 CellID->174442233]
}, Open  ]],
Cell[14781, 564, 341, 12, 70, "ExampleText",
 CellID->259487002],
Cell[CellGroupData[{
Cell[15147, 580, 108, 3, 70, "Input",
 CellID->320788211],
Cell[15258, 585, 184, 6, 49, "Output",
 CellID->316905946]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15491, 597, 224, 7, 70, "ExampleSection",
 CellID->21435],
Cell[15718, 606, 142, 2, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->82459453],
Cell[CellGroupData[{
Cell[15885, 612, 294, 10, 70, "Input",
 CellID->331090578],
Cell[16182, 624, 3840, 67, 70, "Output",
 Evaluatable->False,
 CellID->12725298]
}, Open  ]],
Cell[CellGroupData[{
Cell[20059, 696, 97, 3, 70, "Input",
 CellID->367371453],
Cell[20159, 701, 176, 5, 36, "Output",
 CellID->116604852]
}, Open  ]],
Cell[CellGroupData[{
Cell[20372, 711, 296, 10, 70, "Input",
 CellID->319385513],
Cell[20671, 723, 12527, 209, 70, "Output",
 Evaluatable->False,
 CellID->168912979]
}, Open  ]],
Cell[CellGroupData[{
Cell[33235, 937, 505, 16, 70, "Input",
 CellID->5204498],
Cell[33743, 955, 1965, 36, 70, "Output",
 Evaluatable->False,
 CellID->61624803]
}, Open  ]],
Cell[CellGroupData[{
Cell[35745, 996, 97, 3, 70, "Input",
 CellID->8211936],
Cell[35845, 1001, 2607, 47, 70, "Output",
 Evaluatable->False,
 CellID->66456507]
}, Open  ]],
Cell[CellGroupData[{
Cell[38489, 1053, 97, 3, 70, "Input",
 CellID->746302882],
Cell[38589, 1058, 196, 6, 36, "Output",
 CellID->44068197]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[38846, 1071, 311, 9, 70, "SeeAlsoSection",
 CellID->31807],
Cell[39160, 1082, 670, 26, 70, "SeeAlso",
 CellID->32662]
}, Open  ]],
Cell[CellGroupData[{
Cell[39867, 1113, 314, 9, 70, "TutorialsSection",
 CellID->12000],
Cell[40184, 1124, 162, 3, 70, "Tutorials",
 CellID->5984],
Cell[40349, 1129, 181, 4, 70, "Tutorials",
 CellID->4389],
Cell[40533, 1135, 154, 3, 70, "Tutorials",
 CellID->25402]
}, Open  ]],
Cell[CellGroupData[{
Cell[40724, 1143, 321, 9, 70, "RelatedLinksSection",
 CellID->25411],
Cell[41048, 1154, 357, 12, 70, "RelatedLinks"],
Cell[41408, 1168, 196, 5, 70, "RelatedLinks",
 CellID->24389631],
Cell[41607, 1175, 208, 5, 70, "RelatedLinks",
 CellID->114631470]
}, Open  ]],
Cell[CellGroupData[{
Cell[41852, 1185, 318, 9, 70, "MoreAboutSection",
 CellID->42080385],
Cell[42173, 1196, 151, 3, 70, "MoreAbout",
 CellID->297772140],
Cell[42327, 1201, 155, 3, 70, "MoreAbout",
 CellID->157312431],
Cell[42485, 1206, 155, 3, 70, "MoreAbout",
 CellID->349368528],
Cell[42643, 1211, 157, 3, 70, "MoreAbout",
 CellID->101064390]
}, Open  ]],
Cell[42815, 1217, 50, 0, 70, "History"],
Cell[42868, 1219, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

