(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     72202,       1614]
NotebookOptionsPosition[     66793,       1441]
NotebookOutlinePosition[     69040,       1503]
CellTagsIndexPosition[     68920,       1497]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Initialization" :> 
          Documentation`HelpLookup["paclet:ref/Initialization"], "Clear" :> 
          Documentation`HelpLookup["paclet:ref/Clear"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Initialization\"\>", 
       2->"\<\"Clear\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options & Styling for Interactive Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/OptionsAndStylingForInteractiveManipulation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Options & Styling for Interactive Manipulation\"\>"}, \
"\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Deinitialization", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Deinitialization",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Deinitialization"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Dynamic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["DynamicModule",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Manipulate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
     " and related constructs, which specifies an expression to be evaluated \
when the construct can no longer be displayed or used. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29440]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The typical usage is ",
 Cell[BoxData[
  RowBox[{"Deinitialization", ":>", 
   StyleBox["expr", "TI"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->20017],

Cell["\<\
Deinitialization is typically done when the cell containing a construct is \
deleted, or when the notebook containing it is closed.\
\>", "Notes",
 CellID->30402],

Cell["\<\
Deinitialization will never be performed unless initialization has previously \
been performed.\
\>", "Notes",
 CellID->22869],

Cell["\<\
Deinitialization may be delayed if, for example, a construct appears in an \
invisible location such as the clipboard.\
\>", "Notes",
 CellID->15543]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->155062082],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->99058760],

Cell["\<\
Choose a color and create the colored disk when the window is closed:\
\>", "ExampleText",
 CellID->1190925018],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDialog", "[", 
   RowBox[{"DynamicModule", "[", 
    RowBox[{
     RowBox[{"{", "c", "}"}], ",", 
     RowBox[{"ColorSlider", "[", 
      RowBox[{"Dynamic", "[", "c", "]"}], "]"}], ",", 
     RowBox[{"Initialization", "\[RuleDelayed]", 
      RowBox[{"(", 
       RowBox[{"c", "=", "Pink"}], ")"}]}], ",", 
     RowBox[{"Deinitialization", "\[RuleDelayed]", 
      RowBox[{"(", 
       RowBox[{"CreateDialog", "[", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{"c", ",", 
           RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], "]"}], ")"}]}]}], 
    "]"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->540113453],

Cell[BoxData[
 RowBox[{
  GraphicsBox[RasterBox[CompressedData["
1:eJztm3u4T2X+998hhxxXCknKKomR0lLySBrdpdHoYNwdTEnJHT+PDqO6x5hS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    "], {{0, 0}, {184, 71}}, {0, 255}],
   ImageSize->{184 0.75, 71 0.75},
   PlotRange->{{0, 184}, {0, 71}}], 
  GraphicsBox[RasterBox[CompressedData["
1:eJztnflTE1ccwJ3pX9J/pe3PdabjT+1MFaeCtuN02p87HUcqFsFWQAIIhJJy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    "], {{0, 0}, {124, 134}}, {0, 255}],
   ImageSize->{124 0.75, 134 0.75},
   PlotRange->{{0, 124}, {0, 134}}]}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->592883347]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1925951899],

Cell["Temporarily change the backgound of a notebook:", "ExampleText",
 CellID->1529181108],

Cell[BoxData[
 RowBox[{
  RowBox[{"changeBackground", "[", "nb_", "]"}], ":=", 
  RowBox[{"Manipulate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"SetOptions", "[", 
      RowBox[{"nb", ",", 
       RowBox[{"Background", "\[Rule]", "c"}], ",", 
       RowBox[{"WindowOpacity", "\[Rule]", "s"}]}], "]"}], ";", 
     RowBox[{"Column", "@", 
      RowBox[{"{", 
       RowBox[{"c", ",", "s"}], "}"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "ColorSlider"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"s", ",", "1"}], "}"}], ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"Deinitialization", "\[RuleDelayed]", 
     RowBox[{"(", 
      RowBox[{"SetOptions", "[", 
       RowBox[{"nb", ",", 
        RowBox[{"Background", "\[Rule]", "Inherited"}], ",", 
        RowBox[{"WindowOpacity", "\[Rule]", "Inherited"}]}], "]"}], ")"}]}]}],
    "]"}]}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->1441236886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDocument", "[", 
   RowBox[{"Button", "[", 
    RowBox[{"\"\<Preview Background Changes\>\"", ",", 
     RowBox[{"CreateDialog", "[", 
      RowBox[{"changeBackground", "[", 
       RowBox[{"ButtonNotebook", "[", "]"}], "]"}], "]"}]}], "]"}], "]"}], 
  ";"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[2]:=",
 CellID->1400288489],

Cell[BoxData[Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  ImageSize->{206.66666666666666`, 218.66666666666666`},
  ImageMargins->0]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->588288117]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->452555262],

Cell["Track and display how long a window was viewed:", "ExampleText",
 CellID->2010078507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDialog", "[", 
   RowBox[{"DynamicModule", "[", 
    RowBox[{
     RowBox[{"{", "t", "}"}], ",", 
     RowBox[{"ProgressIndicator", "[", 
      RowBox[{
       RowBox[{"Dynamic", "[", 
        RowBox[{"Clock", "[", "Infinity", "]"}], "]"}], ",", 
       "Indeterminate"}], "]"}], ",", 
     RowBox[{"Initialization", "\[RuleDelayed]", 
      RowBox[{"(", 
       RowBox[{"t", "=", 
        RowBox[{"AbsoluteTime", "[", "]"}]}], ")"}]}], ",", 
     RowBox[{"Deinitialization", "\[RuleDelayed]", 
      RowBox[{"(", 
       RowBox[{"CreateDialog", "[", 
        RowBox[{"ToString", "@", 
         RowBox[{"StringForm", "[", 
          RowBox[{"\"\<Viewed for `1` seconds\>\"", ",", 
           RowBox[{
            RowBox[{"AbsoluteTime", "[", "]"}], "-", "t"}]}], "]"}]}], "]"}], 
       ")"}]}]}], "]"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->972015584],

Cell[BoxData[
 RowBox[{
  GraphicsBox[RasterBox[CompressedData["
1:eJztnG1PWmcYx032SfYd9gm2vV6Tpa+2ZBUzH9qlWbYs9dW66Ga71epmVXyo
spYp1odqlWmdVVRUegDFB1ABQR2gmc/IitGBu3edc3MeBGFROeWEXP/8PLmu
c1+HNL1+IVhN38378uO8d3Jyct6Dr3X4YuuCgrsIomQi0VMEUSCCn8/aXyGI
oojzM+Nv4wgicK6f62t+BMk4BfxnTvQTUSAX9ZMQ0tWp++7ut0UYzJUDInV1
toFU6fITXq24uPgAg0lTQCd4x0uXnyC8wWCgr0wwmKuFigRSpctPeE+mfsKL
1zMPgSgXWieS6b8AjJhkO0q9QflOw+Ew4RQFqeTw8+fhUiDChdaJZHonGDHJ
dpR6g/KdhkIhIqef33ffAU640DqRTO8EIybZjlJvUL5TapHcfh5xQT+Vn2Q7
Sr1B+U6DwSCR0887ulvA31xo/Q13lZLpnWDExK1GWJZ0g2/5lMjpZ8VwKXDI
hdaJZHonGDHJdpR6g/Kdyv39UYujHnjDhdaJZHonGDHJdpR6g/KdHh8fE/n9
pJ+B0U/lJ9mOUm9QvlP41p7I6WcDUwnQf+OidSKZ3glGTLIdpd6gfKey+gmp
1VcC9M9A60QyvROMmGQ7Sr1B+U4J//OjNPpJf74pKIrBXDHgUklJSbr87OrU
FRcXGzCYNAXePPV6fbr8JOzv17Xh79dh0hh4F02XnwjyNkE/ESWDfiJKBv1E
lAz6iSgZ9BNRMugnomTQT0TJSP384na517Peq2celLcgiEKI/BMxMctffV1V
cLsC/ARcrlUEUQhSP11OPyGnp6dRBFEC/55GpX4uLfoikWj46Bg44ojVYbie
CG04HBuAm8KwUEs5wjar20tYUd/U3nz9fd21D1qvfZgI3IdTmKEPHh+fhMMn
gp8L82uHofDu3uHuXpC7HvJ1ML7elw4I88LN0NlTbLOyvYwVfdc/ilbXkCda
otGcwxMtnMIMfXBvn31E8HN21rP5154vsOPzb/n82yy0DlC2Y/i52i8hdrTF
zgeEOzuxAtusbP2XsWKlUEUG+klPR1IG+mGGPuvf2PEHdgU/rdNuz9qma8Uf
hztWBMSb7rMtW/skMz73mVfANovbi1nhLlCRvl7C/bd1bKCgCG1fL8xwjwTc
nsCKd1PwkzE77Ytr83YvMOfgrnbxKi3OY1WYkc5jm8XtJayI95P9lWJJzftJ
n1pweB1Lfwp+QmG1OS0zy+aZZcv0snnayVidZraAFgonvXJ3oF620FMrO2Ce
ccaKae5Zrmawzd7WwvtwISvcBbmkr4d0tLLERfcradWQ7nbw00xfc8Zpm/MI
fk6ZFidN9gmWhYmpBbaYshtNtIA77JGRDkzxVx5jrF3gB9h5I7ZZ3V7CCtfn
N1gztY+JtpE8bRDl1KhJcw15/AgUdeXf4B9ZYCzO0fF56uekadEwNiswMs4V
4zauZa8jYzbpQGyMP6VjI2fuYJvl7UWtYP1saSYNVaS+Kv79s7qCPHpImhvA
T+F1Jk2O3wcY6ufElGNwyPzHKwuHlS9YBlmssZtDbM22Q1buCGph3spPWrDN
7nZQrC9ghSs/l2gaor+UC1aeVIr10U/3SV2tOz93kFo3ZBkzzj3rMMT8nHTo
B0z9L5kr8FpyjbuJbba2/4toBfv5s642dP8eFfLNj/dCHLQ9KCsjtTUwIzw7
Mmpr0uh5Pxd7el/36hkEkQlvkYqo1bulpQdlPyQC90md2luYS4df9DFDw7NV
1R0xPyeWujonu5+bEEQmbDc/IY11pA5Qn4NaTRqbpm99Roefd5leDtgelLdQ
P8fG7NqnI7qWUQSRifqm9tn8T1dv5nkKVYmsFqlshSqYocOtvxle9DDoJ6JM
0E9EyaCfiJKJ89M4YW/RjrTpRhFECehaDX29op/+wL53ddu7uoUgCmFjIyj4
iSDKBPz8D8BJZ9E=
    "], {{0, 0}, {224, 52}}, {0, 255}],
   ImageSize->{224 0.75, 52 0.75},
   PlotRange->{{0, 224}, {0, 52}}], 
  GraphicsBox[RasterBox[CompressedData["
1:eJztl+tOG0cUx5H6JH2CvkPbz41U5VMrNRgVk7SKqvYB+iEqSRqaqgQwl4Cb
uEACISE2hVBSczHYWdtgwDZgG9uktkHhGkA1gmIynd3ZXZa9eb02jtCe1Y/R
OWfO3M78d2U+rPru86oPKioqPsJ/ffiPts3mHwHgOHcCGBZeA497XgIGRKSB
9/45AsqMrAZer6QBg2DmfgOABgyLPg3gfyKkdgX3qKcpZUqDolHSgaJe9fnV
j6C0H1FExyrSgQWtqFRe9SsgEaXVz0kDSlvSElQpo7qiZE+Xd9GS7EfLKury
UF8x71S6y1gSDYhWVLoOYVzaaqxVqTSgklZQMQvaf96dCF9Y9VWK0UDeT0EJ
NSD9ECm1spnl0YCW1ZXeceGoIjUgmkd9V7o1kPf2S64B9YSCNq9dA+q3rKIQ
9csVRZSWVpeExnPlrUkxGsgrAB0aUL9r2bqplD3vxUnnlC6hXl6lI8jelL6C
69BA3qNpObuWMioJtbQaKC2FXqiWSWQTVA5S/CumNKpsFLRcCb8D57F53ZPn
Fb/sB0fkankr+aA0IjtPeThXDZR/8++lhhedC60BoPyABgDQAAAaAEADAGgA
AA0AoAEANACABgChBr69XpeIv7YPUHfqOgFDcfzfsYda+v6HevP1u1gDmGg0
CRgKoQaikTRCJycnOcA4vDvJCTWwuJA6Ps5lDw4xBwysncXtEe9ms2wCDvLJ
vC3kANwSuAVXvqW9p+Pyx92XPum69KkUHMe9OIcMPDw8ymaPeA0E51f29rNb
23tb27tMu8fZu2J7R5jA5/PB/bO94Op29VTecfmzXEMjemBDVqsMD2y4F+eQ
gds79BBeA7Oz8bU326nMZiq9nkpv0BA7Q9hgSTN2WgDbtU7nZ/jIJmuAq9/V
U/nlGhMaGkT9vYoMDeIcMja9upnObPEa8E/H4itr0eW0iBhrZE6DsbMubacE
OanYmRnA1e3qqXzMbEIOO3ryCJEHGwTeddhxDjMkE4tnlhNrvAYobyS0sDIf
SmDmwkwbOm2FhhxJPkeYD24x7rzA1V55sQbw0yewOQ2QUcFwIrz4D68BbPgD
Ed/MkndmyTe95J2OUP6Ilzawi40IaZkItpd8pNdPJ3hnIqwxzYxlbArcYt2I
jsrHzJXI0Y96u2hET/fvqMuKnvVgDXjJnDORwFyc14DbszDlCU3SBCfdQdpw
h1weYuAI3eUiCW6u5XCxbpBLoPNd4BbpuvVUPvr1Ffr2bfeRrQ09bD0VgNWC
OhrR/XtYBtHqK9yQIOWLjE3MEw1MeRZGx2d5nBOMMRFgXLp1jgeECWwa10vS
nGci4Bbl6qs8rYHODtRaj1rqxd+Bhrvo3i+ooxVrgJ9nyhP+c4giGph0h4dH
vH+99DH4OYNmmMbPBkdom3ZH/EwXtvl8P5fpA7ckro7KR6srkbU191sdf/NH
v57aBz/fQs1NserKYXKzI75x19zj3lFWA1PhgSHP4AuqCF4JWlEQXB2unsrT
vweam/Zv3SSX/u/tm/sMxH1bW4uaGnEOP9Y5Fmi3DnAaWOi3v7IPUMCFJnHV
hCyWrRs33tb+JAXHUbMlUVNJkp87qJG/Z+sbelkNTC72PZl69tQDXGgC175A
bc2oGWORwWJBbe3T33xFkp/2eV4MBe7UdRINjI+HbA+d3Z1jwIWmpb1ntvrL
5LWqeI1JSvKqKVBjwjkkueuP0ef9FGjAyIAGANAAINKAazLUaXM+6h4DjEN3
16jDfqqBdGYnkdxIJNcBQ7G6ustrADAyWAP/A9Ln97Q=
    "], {{0, 0}, {172, 47}}, {0, 255}],
   ImageSize->{172 0.75, 47 0.75},
   PlotRange->{{0, 172}, {0, 47}}]}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->197839522]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12610],

Cell["\<\
Track the mouse position while the window is open and display a plot when it \
is closed:\
\>", "ExampleText",
 CellID->1324216192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDialog", "[", 
   RowBox[{"DynamicModule", "[", 
    RowBox[{
     RowBox[{"{", "pos", "}"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{
       RowBox[{"AppendTo", "[", 
        RowBox[{"pos", ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "1"}]}], "}"}], 
          RowBox[{"MousePosition", "[", "]"}]}]}], "]"}], ";", 
       RowBox[{"MousePosition", "[", "]"}]}], "]"}], ",", 
     RowBox[{"Initialization", "\[RuleDelayed]", 
      RowBox[{"(", 
       RowBox[{"pos", "=", 
        RowBox[{"{", "}"}]}], ")"}]}], ",", 
     RowBox[{"Deinitialization", "\[RuleDelayed]", 
      RowBox[{"(", 
       RowBox[{"CreateDialog", "[", 
        RowBox[{"ListPlot", "[", 
         RowBox[{
          RowBox[{"Union", "@", "pos"}], ",", 
          RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}], "]"}], ")"}]}]}], 
    "]"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->796423421],

Cell[BoxData[
 RowBox[{
  GraphicsBox[RasterBox[CompressedData["
1:eJztl2tTGlcYx53pJ+kn6Hdo+7qZdvKqnWnEqZi0k+m0H6AvMjVpa9OpUSEa
pQkREo2JASuxpChyy3IRlIssCJiy6NRr1CmOFujpOXt2DyusK4uXDJedv2ee
5zn/c5797WFV3m37+pO2d1paWt6DPx/DHxQrld81oHL5QuOIID8eedkIKkF+
6x+285Yo8utlRkLwxZc2yNIZ7lbJVuT9rRz5bHkvnvqUyC38VZKKFiXuSrRS
vqqkIrr2vJHLn4D086kQuXyVRJfzRpb7kI+7VekbOw3yiZuf7SlXjnl6ZNGX
6DxOuRJkYVHW6Qinyn8hHPcQ3u67XF6vGvnEcxdtcQHIEh+qE5FlUUt0uQDk
E89O+o/Lce+gaBeJfSq5mTNErmk1kZvIdakmchO5LtVEbiLXpRoc+avrXcnE
a8ME9VPXcH0r92/ORUW/+bZbef02RIaKxVL1LSFyjGYAKBQK+TrWf4W8EHkx
ks7l8tn9A6h9VlycheMhSbNZzgCLxExiofarSWU3ujs4MnT5ff2lD3SXPiwX
rMNZ6MELDw4Os9lDghxcWN7dy25u7W5u7bDjLh/vlMbbQgPxk+Le0dnK02oa
GS9/lO/pBfe1QKMR0X0tnIUevHBrGy0hyIFAYvXvrXRmI82spZl1JBxnsNY5
MWzMCMRNrSF/hlQ2uKDylKmm0VKHApgmwfjosTJNQg9ey6xsMJlNguz1xRPL
q7ElpkRxLsgUi/GjKYrTAk86fmQHWansRnGlAhgN4MkjgC8YYJHUaIAedkkm
nsgsJVcJMuWmQ5HlhVASaj7MjqHiKAzElCIeoV9WulBVo1JkeI0JYh4ZrwqG
k+HFvwgyDLx+2jMXdc9FPb6o20dTXtqNApjCgMYjW4Fx1INnvcjgnqO5wMeu
ZWNKZurhW8hqFFe2AuM4GNUhlVz634BOA56NQGQ33nOO9s8nCLLTFXG4Qnak
oN0ZRIEzZHPhAFbQlA0bnPzIy8alQd6A/DaZKd5BbqPYF1cQrPYe0A6AB/1F
Xo0KDPWCe3cgdaz9Cr8kSHnomdkFjOxwRaatASLLLBvM+tkUjRarX2jgbPws
tlmOVOSl1TVCyMNDoL8b3O0uPeWe2+DOz2CoHyKTfRyu8O8mCiPbneEps/uP
lx5WXj5AmkLyckUzilFq9rJTMCZ+L+/0VJV6q2gUa28Fmv78r10E9PCXYrz/
4y2g7ou3t05hELPHapt/PDrNITvCEybX5AvqFHolGEuKFaayG6F3Wd23d+sm
Zvznh5t7rHD6prMT9PVCD1lrmfEPaiZ45Mi44RX8ZlFbSl5VAJVq88aNN53f
lwvWgVqV7GjF5udGyvxnoLtnlEO2L449cTx76qot+a99CgbUQA2lEpFKBQYG
fV9+js1Px1wvTH74fQojW60h7QOLfnimtgT/fw60f5a61pboUJQrdVXh71BA
DzbrHk4/H6dqHVmWmsgNiGyzh4a1lkf6mTqWXjdtNBSRmcx2MrWeTK3Vt1ZW
dghyQwki/w99+Od3
    "], {{0, 0}, {81, 47}}, {0, 255}],
   ImageSize->{81 0.75, 47 0.75},
   PlotRange->{{0, 81}, {0, 47}}], 
  GraphicsBox[RasterBox[CompressedData["
1:eJztnP1TE0cYx53pX9I/REDAcfoyMr611HYqMCX4UttpO/2lVdtxilqpnSIS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    "], {{0, 0}, {124, 96}}, {0, 255}],
   ImageSize->{124 0.75, 96 0.75},
   PlotRange->{{0, 124}, {0, 96}}]}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->388799631]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1300078811],

Cell["Temporarily change the notebook font size setting:", "ExampleText",
 CellID->1329187486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"nb", "=", 
      RowBox[{"EvaluationNotebook", "[", "]"}]}], "}"}], ",", 
    RowBox[{"CreateDialog", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Slider", "[", 
        RowBox[{
         RowBox[{"Dynamic", "[", 
          RowBox[{"CurrentValue", "[", 
           RowBox[{"nb", ",", "FontSize"}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "15"}], "}"}]}], "]"}], ",", 
       RowBox[{"Dynamic", "[", 
        RowBox[{
         RowBox[{"CurrentValue", "[", 
          RowBox[{"nb", ",", "FontSize"}], "]"}], ",", 
         RowBox[{"Deinitialization", "\[RuleDelayed]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"CurrentValue", "[", 
             RowBox[{"nb", ",", "FontSize"}], "]"}], "=", "Inherited"}], 
           ")"}]}]}], "]"}]}], "}"}], "]"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->132102234],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3PtPU2ccx3GS/Rfztu1P2YwxSzaTxR+WmUxAKbrFuPmD2y/uBzdFZZoh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   "], {{0, 0}, {224, 88}}, {0, 255}],
  ImageSize->{224 0.75, 88 0.75},
  PlotRange->{{0, 224}, {0, 88}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->290759562]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8875],

Cell["\<\
Display the current time and create a graphical representation when window is \
closed:\
\>", "ExampleText",
 CellID->13683662],

Cell[BoxData[
 RowBox[{
  RowBox[{"clock", "[", 
   RowBox[{"{", 
    RowBox[{"h_", ",", "m_", ",", "s_"}], "}"}], "]"}], ":=", 
  RowBox[{"Graphics", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Text", "[", 
        RowBox[{"t", ",", 
         RowBox[{"0.9", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Sin", "[", 
             RowBox[{"t", " ", 
              RowBox[{"Pi", "/", "6"}]}], "]"}], ",", 
            RowBox[{"Cos", "[", 
             RowBox[{"t", " ", 
              RowBox[{"Pi", "/", "6"}]}], "]"}]}], "}"}]}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "1", ",", "12"}], "}"}]}], "]"}], ",", 
     RowBox[{"Circle", "[", "]"}], ",", "Green", ",", 
     RowBox[{"Rotate", "[", 
      RowBox[{
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0.9"}], "}"}]}], "}"}], "]"}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "Pi"}], ")"}], 
        RowBox[{"s", "/", "60"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", "Blue", ",", 
     RowBox[{"Rotate", "[", 
      RowBox[{
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0.6"}], "}"}]}], "}"}], "]"}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "Pi"}], ")"}], 
        RowBox[{"m", "/", "60"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
     RowBox[{"Rotate", "[", 
      RowBox[{
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0.3"}], "}"}]}], "}"}], "]"}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "Pi"}], ")"}], 
        RowBox[{
         RowBox[{"Mod", "[", 
          RowBox[{"h", ",", "12"}], "]"}], "/", "12"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], "}"}], "]"}]}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->1286393284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDialog", "[", 
   RowBox[{"Dynamic", "[", 
    RowBox[{
     RowBox[{"DateString", "[", "]"}], ",", 
     RowBox[{"UpdateInterval", "\[Rule]", "1"}], ",", 
     RowBox[{"Deinitialization", "\[RuleDelayed]", 
      RowBox[{"CreateDialog", "[", 
       RowBox[{"clock", "@", 
        RowBox[{"Take", "[", 
         RowBox[{
          RowBox[{"DateList", "[", "]"}], ",", 
          RowBox[{"-", "3"}]}], "]"}]}], "]"}]}]}], "]"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1517666061],

Cell[BoxData[
 RowBox[{
  GraphicsBox[RasterBox[CompressedData["
1:eJztmO1O21YYgJF2JbuC3cO236s09dcmrQSN0G6qpu0C9qMa7VbWaRRIgELW
ZkALpaUJgzK68BFI6nyQQBIgCUno4oDGZwEtCEro2bGPfXBskzgeNNg51sPR
+x6/xz5+n8SReL/mm09r3quqqvoA/pnhHxMbjd8TdMBR7pigXbDER70vCFpE
JLHsLwRCqchKfLVMX0zgb3fZ93DRMPK/g0SidlEnUdhJ2bhKcEjXiuZly6S+
UCq98mlrZStlb33a4yjceYFuqLidkpl3ILFoTxROniaxwIzCqxXYZ+GOKdyk
wkbpT6JsB6RfKIUSlfSzaIdVSCypUWdyiwsiUaRJtlL2o1tYoup9lkWi7Me1
QGculMSij6ZEopK2l7RPhd/uoguVv06VBOcqUfRpOW+Jsrcr6vGCS1S4z/OT
WLhYurak91jRl4nCHZb6xjjtjad8b6U+qYpbqJNYlX+okChdIvpmnYlE2csW
nZE+nRKzZ/Wk6m6hQqKSmxLeMZr7jw1BCpGoA4hEHUAk6gAiUQcQiTqASNQB
RKIOIBJ1AJGoA4QSv77ekEy8sg1Stxu6CNri6M2Rm1r89rtG4/U7UCIkFksR
tIVQYixKA3B8fJwjaIi3xzmhxIX59NFRLrt/ANln4eIsHA9xms1yBXASF+NY
yD5J99W0rrWjt/Pyhz2XPuq+9LEUOA/Pwhq08ODgMJs9xBJDc8u7e9nNrd3N
rR123OXjHXG8LSzA9XhyL/9sJadqWme//EmuqRnctwKLRYb7VngW1qCFW9vM
EiwxGEys/rOVzmyk6bU0vc6A4gxinYNmY1oAd2qNqc/gmQ0uqOSUVtO6pToD
GB4CA32nMjwEa9BaemWDzmxiiT5/PLG8GluiRcS5IHMyGc9PmTgtqEnH865Q
4WnJrYsbDcBuA48fAnTAAIFTuw3WsEsy8URmKbmKJVKeaHh+eS6chMxG2DF8
MgoDOVK4Rlhf4emcXFy0dWKJ8OgXxLxEtCoUSUYW/sYSYeALRL0zi56ZRa9/
0eOPUr6ohwlgCoMoGtkZGC960VkfU+CZiXKBn13LxlTFp16+aSW1Lm6sBvYB
0NfNIDp6fgPdFvC0F0r0oGvORAOzCSzR5Z6fdoenGEJTrhATuMJONwrgDHPK
iQpc/Mjj5NIQX8DUOys+RT0ptXWxL68w+qz3gLUdPGg7MWgxgc5mcO8u9Bir
vcIvCVHe6PjkHJI47Z4fmwhiHJNsMBlgU2Z0TASEBVwZfxaVOfJmKj1V1zpG
YlcnaGsErY3ib2LTHXD3Z9DZBiXi60y7I38MU0jilCsyMur584WXxccHDCMM
Pm5ylImZdNTHnoIxrvfxlV6SsqlPRetitdXA0pb7tQGrO/zlJN7/6RYwt8Rr
q0eQmlHvhHP2Ud8YJ3E6MjjsHnpO/Q9eCkbRZMWmJbeO+U00t+zduoms/fvj
zT0WlL6urwctzbAGr3WMBzosg7zE+QHbS9sgRSgvyasGYDJt3rjxuv4HKXAe
mE3JumpU/MxOjf4VbGzq4yROLfQ/nn76xE0oL4Frn4F2MzBDTDKYTKC9w//V
F6j4Sb/7+XDgdkMXkjgxEbY+cPR0jRPKS2tHb7D289S1mkSdQUrqqiFQZ4A1
qLj797FnAxSRqGmIRB1AJOoAkUTnVLjL6njYM07QED3dY3bbiUQ6s51MrSdT
awRtsbKygyUSNA2U+B+Gq4rT
    "], {{0, 0}, {151, 47}}, {0, 255}],
   ImageSize->{151 0.75, 47 0.75},
   PlotRange->{{0, 151}, {0, 47}}], 
  GraphicsBox[RasterBox[CompressedData["
1:eJztnUlQFFkax4mYA7e61a3mMIEnvDReBk8YMxP2CTtiorwM4bQQLl1DdKhz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    "], {{0, 0}, {124, 134}}, {0, 255}],
   ImageSize->{124 0.75, 134 0.75},
   PlotRange->{{0, 124}, {0, 134}}]}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->875959160]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18863],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Initialization",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Initialization"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Clear",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Clear"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25646]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Options & Styling for Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/OptionsAndStylingForInteractiveManipulation"]], "MoreAbout",
 CellID->263198958]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Deinitialization - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 37, 8.1938122}", "context" -> "System`", 
    "keywords" -> {
     "reset initialzation", "undo initialization", 
      "evaluation after deletion", "window close event", 
      "deinitialize dynamic objects", "dynamc initialization", "finalization",
       "after effect"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Deinitialization is an option for Dynamic, DynamicModule, Manipulate and \
related constructs, which specifies an expression to be evaluated when the \
construct can no longer be displayed or used. ", "synonyms" -> {}, "title" -> 
    "Deinitialization", "type" -> "Symbol", "uri" -> 
    "ref/Deinitialization"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5759, 181, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->155062082]},
 "Notebook Image"->{
  Cell[7137, 231, 15952, 267, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->592883347],
  Cell[24704, 554, 15862, 263, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->588288117],
  Cell[41740, 857, 4184, 74, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->197839522],
  Cell[47350, 985, 4507, 80, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->388799631],
  Cell[53097, 1108, 2410, 42, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->290759562],
  Cell[58910, 1269, 6436, 111, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->875959160]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 68125, 1471},
 {"Notebook Image", 68266, 1475}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1356, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1979, 61, 1581, 37, 70, "ObjectNameGrid"],
Cell[3563, 100, 993, 29, 70, "Usage",
 CellID->29440]
}, Open  ]],
Cell[CellGroupData[{
Cell[4593, 134, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5071, 151, 175, 7, 70, "Notes",
 CellID->20017],
Cell[5249, 160, 172, 4, 70, "Notes",
 CellID->30402],
Cell[5424, 166, 136, 4, 70, "Notes",
 CellID->22869],
Cell[5563, 172, 159, 4, 70, "Notes",
 CellID->15543]
}, Closed]],
Cell[CellGroupData[{
Cell[5759, 181, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->155062082],
Cell[CellGroupData[{
Cell[6144, 195, 147, 5, 70, "ExampleSection",
 CellID->99058760],
Cell[6294, 202, 121, 3, 70, "ExampleText",
 CellID->1190925018],
Cell[CellGroupData[{
Cell[6440, 209, 694, 20, 70, "Input",
 CellID->540113453],
Cell[7137, 231, 15952, 267, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->592883347]
}, Open  ]],
Cell[23104, 501, 126, 3, 70, "ExampleDelimiter",
 CellID->1925951899],
Cell[23233, 506, 91, 1, 70, "ExampleText",
 CellID->1529181108],
Cell[23327, 509, 970, 28, 70, "Input",
 CellID->1441236886],
Cell[CellGroupData[{
Cell[24322, 541, 379, 11, 70, "Input",
 CellID->1400288489],
Cell[24704, 554, 15862, 263, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->588288117]
}, Open  ]],
Cell[40581, 820, 125, 3, 70, "ExampleDelimiter",
 CellID->452555262],
Cell[40709, 825, 91, 1, 70, "ExampleText",
 CellID->2010078507],
Cell[CellGroupData[{
Cell[40825, 830, 912, 25, 70, "Input",
 CellID->972015584],
Cell[41740, 857, 4184, 74, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->197839522]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[45973, 937, 216, 7, 70, "ExampleSection",
 CellID->12610],
Cell[46192, 946, 141, 4, 70, "ExampleText",
 CellID->1324216192],
Cell[CellGroupData[{
Cell[46358, 954, 989, 29, 70, "Input",
 CellID->796423421],
Cell[47350, 985, 4507, 80, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->388799631]
}, Open  ]],
Cell[51872, 1068, 126, 3, 70, "ExampleDelimiter",
 CellID->1300078811],
Cell[52001, 1073, 94, 1, 70, "ExampleText",
 CellID->1329187486],
Cell[CellGroupData[{
Cell[52120, 1078, 974, 28, 70, "Input",
 CellID->132102234],
Cell[53097, 1108, 2410, 42, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->290759562]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[55556, 1156, 223, 7, 70, "ExampleSection",
 CellID->8875],
Cell[55782, 1165, 137, 4, 70, "ExampleText",
 CellID->13683662],
Cell[55922, 1171, 2420, 76, 70, "Input",
 CellID->1286393284],
Cell[CellGroupData[{
Cell[58367, 1251, 540, 16, 70, "Input",
 CellID->1517666061],
Cell[58910, 1269, 6436, 111, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->875959160]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[65407, 1387, 311, 9, 70, "SeeAlsoSection",
 CellID->18863],
Cell[65721, 1398, 457, 17, 70, "SeeAlso",
 CellID->25646]
}, Open  ]],
Cell[CellGroupData[{
Cell[66215, 1420, 299, 8, 70, "MoreAboutSection"],
Cell[66517, 1430, 204, 4, 70, "MoreAbout",
 CellID->263198958]
}, Open  ]],
Cell[66736, 1437, 27, 0, 70, "History"],
Cell[66766, 1439, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

