(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20720,        737]
NotebookOptionsPosition[     16642,        604]
NotebookOutlinePosition[     18140,        643]
CellTagsIndexPosition[     18055,        638]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Finding Expressions That Match a Pattern" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FindingExpressionsThatMatchAPattern"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Finding Expressions That Match a Pattern\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cases" :> Documentation`HelpLookup["paclet:ref/Cases"], 
          "ReplaceAll" :> Documentation`HelpLookup["paclet:ref/ReplaceAll"], 
          "Delete" :> Documentation`HelpLookup["paclet:ref/Delete"], "Except" :> 
          Documentation`HelpLookup["paclet:ref/Except"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Cases\"\>", 2->"\<\"ReplaceAll\"\>", 
       3->"\<\"Delete\"\>", 4->"\<\"Except\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "Parts of Expressions" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfExpressions"], 
          "Pattern Matching Functions" :> 
          Documentation`HelpLookup["paclet:guide/PatternMatchingFunctions"], 
          "Rules & Patterns" :> 
          Documentation`HelpLookup["paclet:guide/RulesAndPatterns"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Elements of Lists\"\>", 
       2->"\<\"Handling Arrays of Data\"\>", 
       3->"\<\"Parts of Expressions\"\>", 
       4->"\<\"Pattern Matching Functions\"\>", 
       5->"\<\"Rules & Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DeleteCases", "ObjectName",
 CellID->4001],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DeleteCases",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DeleteCases"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["pattern", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]removes all elements of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " which match ",
     Cell[BoxData[
      StyleBox["pattern", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DeleteCases",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DeleteCases"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["pattern", "TI"], ",", 
        StyleBox["levelspec", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]removes all parts of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " on levels specified by ",
     Cell[BoxData[
      StyleBox["levelspec", "TI"]], "InlineFormula"],
     " which match ",
     Cell[BoxData[
      StyleBox["pattern", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DeleteCases",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DeleteCases"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["pattern", "TI"], ",", 
        StyleBox["levelspec", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]removes the first ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " parts of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " which match ",
     Cell[BoxData[
      StyleBox["pattern", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->13485]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Heads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Heads"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", you can delete heads with ",
 Cell[BoxData[
  ButtonBox["DeleteCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DeleteCases"]], "InlineFormula"],
 ". Deleting the head of a particular element in an expression is equivalent \
to applying ",
 Cell[BoxData[
  ButtonBox["FlattenAt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FlattenAt"]], "InlineFormula"],
 " to the expression at that point. "
}], "Notes",
 CellID->11619],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DeleteCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DeleteCases"]], "InlineFormula"],
 " uses standard level specifications:"
}], "Notes",
 CellID->22946],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["n", "TI"], Cell[TextData[{
     "levels ",
     Cell[BoxData["1"], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[TextData[{
     "levels ",
     Cell[BoxData["1"], "InlineFormula"],
     " through ",
     Cell[BoxData[
      ButtonBox["Infinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Infinity"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     StyleBox["n", "TI"], "}"}], Cell[TextData[{
     "level ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " only"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]}], "}"}], Cell[TextData[{
     "levels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->26613],

Cell[TextData[{
 "The default value for ",
 Cell[BoxData[
  StyleBox["levelspec", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["DeleteCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DeleteCases"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"{", "1", "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16696],

Cell[TextData[{
 "A positive level ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " consists of all parts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " specified by ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " indices."
}], "Notes",
 CellID->12389],

Cell[TextData[{
 "A negative level ",
 Cell[BoxData[
  RowBox[{"-", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " consists of all parts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with depth ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->6894],

Cell[TextData[{
 "Level ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 " consists of numbers, symbols and other objects that do not have subparts."
}], "Notes",
 CellID->30804],

Cell[TextData[{
 "Level ",
 Cell[BoxData["0"], "InlineFormula"],
 " corresponds to the whole expression."
}], "Notes",
 CellID->31119],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DeleteCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DeleteCases"]], "InlineFormula"],
 " traverses the parts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " in a depth-first order, with leaves visited before roots."
}], "Notes",
 CellID->6219]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->4477707],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->25055138],

Cell["Delete cases that match integers:", "ExampleText",
 CellID->1124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeleteCases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "x", ",", "2", ",", "3", ",", "y", ",", "9", ",", 
     "y"}], "}"}], ",", "_Integer"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30284],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", "y"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32525]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12197],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Heads",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->497],

Cell[TextData[{
 "Deleting the head ",
 Cell[BoxData["f"], "InlineFormula"],
 " effectively flattens:"
}], "ExampleText",
 CellID->20805],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeleteCases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"f", "[", 
      RowBox[{"2", ",", "3"}], "]"}], ",", "4"}], "}"}], ",", "f", ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"Heads", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4112],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3856]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32652],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplaceAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplaceAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Delete",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Delete"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Except",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Except"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23643]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18627],

Cell[TextData[ButtonBox["Finding Expressions That Match a Pattern",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FindingExpressionsThatMatchAPattern"]], "Tutorials",
 CellID->30088]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->16398293],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->504084191],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->23399690],

Cell[TextData[ButtonBox["Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfExpressions"]], "MoreAbout",
 CellID->143291439],

Cell[TextData[ButtonBox["Pattern Matching Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PatternMatchingFunctions"]], "MoreAbout",
 CellID->463109314],

Cell[TextData[ButtonBox["Rules & Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RulesAndPatterns"]], "MoreAbout",
 CellID->76939694]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with DeleteCases",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=DeleteCases"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
DeleteCases"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 2  |  Last modified in 4.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DeleteCases - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 37, 9.5844728}", "context" -> "System`", 
    "keywords" -> {"patterns", "removing elements that match a pattern"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "DeleteCases[expr, pattern] removes all elements of expr which match \
pattern. DeleteCases[expr, pattern, levelspec] removes all parts of expr on \
levels specified by levelspec which match pattern. DeleteCases[expr, pattern, \
levelspec, n] removes the first n parts of expr which match pattern. ", 
    "synonyms" -> {"delete cases"}, "title" -> "DeleteCases", "type" -> 
    "Symbol", "uri" -> "ref/DeleteCases"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10147, 345, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->4477707]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17913, 631}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2675, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3298, 88, 48, 1, 70, "ObjectName",
 CellID->4001],
Cell[3349, 91, 2055, 66, 70, "Usage",
 CellID->13485]
}, Open  ]],
Cell[CellGroupData[{
Cell[5441, 162, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5919, 179, 692, 23, 70, "Notes",
 CellID->11619],
Cell[6614, 204, 209, 7, 70, "Notes",
 CellID->22946],
Cell[6826, 213, 1664, 55, 70, "2ColumnTableMod",
 CellID->26613],
Cell[8493, 270, 346, 14, 70, "Notes",
 CellID->16696],
Cell[8842, 286, 303, 12, 70, "Notes",
 CellID->12389],
Cell[9148, 300, 311, 13, 70, "Notes",
 CellID->6894],
Cell[9462, 315, 189, 6, 70, "Notes",
 CellID->30804],
Cell[9654, 323, 134, 5, 70, "Notes",
 CellID->31119],
Cell[9791, 330, 319, 10, 70, "Notes",
 CellID->6219]
}, Closed]],
Cell[CellGroupData[{
Cell[10147, 345, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->4477707],
Cell[CellGroupData[{
Cell[10530, 359, 147, 5, 70, "ExampleSection",
 CellID->25055138],
Cell[10680, 366, 71, 1, 70, "ExampleText",
 CellID->1124],
Cell[CellGroupData[{
Cell[10776, 371, 253, 8, 28, "Input",
 CellID->30284],
Cell[11032, 381, 209, 7, 36, "Output",
 CellID->32525]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11290, 394, 218, 7, 70, "ExampleSection",
 CellID->12197],
Cell[CellGroupData[{
Cell[11533, 405, 220, 7, 70, "ExampleSubsection",
 CellID->497],
Cell[11756, 414, 137, 5, 70, "ExampleText",
 CellID->20805],
Cell[CellGroupData[{
Cell[11918, 423, 318, 10, 70, "Input",
 CellID->4112],
Cell[12239, 435, 218, 7, 36, "Output",
 CellID->3856]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12530, 450, 311, 9, 70, "SeeAlsoSection",
 CellID->32652],
Cell[12844, 461, 931, 35, 70, "SeeAlso",
 CellID->23643]
}, Open  ]],
Cell[CellGroupData[{
Cell[13812, 501, 314, 9, 70, "TutorialsSection",
 CellID->18627],
Cell[14129, 512, 189, 4, 70, "Tutorials",
 CellID->30088]
}, Open  ]],
Cell[CellGroupData[{
Cell[14355, 521, 318, 9, 70, "MoreAboutSection",
 CellID->16398293],
Cell[14676, 532, 144, 3, 70, "MoreAbout",
 CellID->504084191],
Cell[14823, 537, 154, 3, 70, "MoreAbout",
 CellID->23399690],
Cell[14980, 542, 150, 3, 70, "MoreAbout",
 CellID->143291439],
Cell[15133, 547, 162, 3, 70, "MoreAbout",
 CellID->463109314],
Cell[15298, 552, 143, 3, 70, "MoreAbout",
 CellID->76939694]
}, Open  ]],
Cell[CellGroupData[{
Cell[15478, 560, 305, 8, 70, "RelatedLinksSection"],
Cell[15786, 570, 367, 12, 70, "RelatedLinks"],
Cell[16156, 584, 389, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[16560, 600, 52, 0, 70, "History"],
Cell[16615, 602, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

