(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10768,        393]
NotebookOptionsPosition[      7465,        283]
NotebookOutlinePosition[      8856,        322]
CellTagsIndexPosition[      8772,        317]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"DeleteFile" :> 
         Documentation`HelpLookup["paclet:ref/DeleteFile"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"DeleteFile\"\>"}, "\<\"see also\"\>",
       
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DeleteContents", "ObjectName",
 CellID->77],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["DeleteContents",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DeleteContents"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["DeleteDirectory",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DeleteDirectory"]], "InlineFormula"],
     " that specifies whether the contents of directories should \
automatically be deleted."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29559]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"DeleteContents", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["DeleteDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DeleteDirectory"]], "InlineFormula"],
 " will only delete directories that contain no files."
}], "Notes",
 CellID->12959]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->745865372],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->113693013],

Cell["Copy a directory:", "ExampleText",
 CellID->71715340],

Cell[BoxData[
 RowBox[{
  RowBox[{"dir", "=", 
   RowBox[{
   "$InstallationDirectory", "<>", 
    "\"\</SystemFiles/Kernel/TextResources/English\>\""}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->270696185],

Cell[BoxData[
 RowBox[{
  RowBox[{"cdir", "=", 
   RowBox[{"$TemporaryPrefix", "<>", "\"\<test123\>\""}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->39535821],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CopyDirectory", "[", 
  RowBox[{"dir", ",", "cdir"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->168042096],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\test123\"\>"], "Output",
 ImageSize->{417, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->436747188]
}, Open  ]],

Cell["List of files in the directory:", "ExampleText",
 CellID->8710499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileNames", "[", 
  RowBox[{"\"\<*\>\"", ",", "cdir"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->809522726],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\test123\\\\FunctionInformation.m\"\>", 
   ",", "\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\test123\\\\Messages.m\"\>", 
   ",", "\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\test123\\\\Usage.m\"\>"}], "}"}]], "Output",
 ImageSize->{585, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->45649438]
}, Open  ]],

Cell["The contents of the directory can't be deleted:", "ExampleText",
 CellID->339208545],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeleteDirectory", "[", "cdir", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->804254513],

Cell[BoxData[
 RowBox[{
  RowBox[{"DeleteDirectory", "::", "\<\"dirne\"\>"}], ":", 
  " ", "\<\"Directory \\!\\(\\\"C:\\\\\\\\Documents and Settings\\\\\\\\roger\
\\\\\\\\Local Settings\\\\\\\\Temp\\\\\\\\test123\\\"\\) not empty. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/DeleteDirectory/dirne\\\
\", ButtonNote -> \\\"DeleteDirectory::dirne\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->1430766],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->129080510]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  RowBox[{"DeleteContents", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " to automatically delete the contents:"
}], "ExampleText",
 CellID->181266568],

Cell[BoxData[
 RowBox[{"DeleteDirectory", "[", 
  RowBox[{"cdir", ",", 
   RowBox[{"DeleteContents", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->336192175],

Cell["The directory is no longer there: ", "ExampleText",
 CellID->328443058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileNames", "[", 
  RowBox[{"\"\<*\>\"", ",", "cdir"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->187463474],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->540275430]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10638],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["DeleteFile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DeleteFile"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->4391]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DeleteContents - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 37, 9.8188538}", "context" -> "System`", 
    "keywords" -> {
     "remove directory", "delete directory", "file operations", 
      "file utilities"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DeleteContents is an option for DeleteDirectory that specifies whether \
the contents of directories should automatically be deleted.", 
    "synonyms" -> {"delete contents", "rmdir"}, "title" -> "DeleteContents", 
    "type" -> "Symbol", "uri" -> "ref/DeleteContents"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2878, 105, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->745865372]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8629, 310}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 571, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1194, 42, 49, 1, 70, "ObjectName",
 CellID->77],
Cell[1246, 45, 657, 19, 70, "Usage",
 CellID->29559]
}, Open  ]],
Cell[CellGroupData[{
Cell[1940, 69, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2418, 86, 423, 14, 70, "Notes",
 CellID->12959]
}, Closed]],
Cell[CellGroupData[{
Cell[2878, 105, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->745865372],
Cell[CellGroupData[{
Cell[3263, 119, 148, 5, 70, "ExampleSection",
 CellID->113693013],
Cell[3414, 126, 59, 1, 70, "ExampleText",
 CellID->71715340],
Cell[3476, 129, 215, 7, 70, "Input",
 CellID->270696185],
Cell[3694, 138, 166, 5, 70, "Input",
 CellID->39535821],
Cell[CellGroupData[{
Cell[3885, 147, 137, 4, 28, "Input",
 CellID->168042096],
Cell[4025, 153, 242, 6, 36, "Output",
 CellID->436747188]
}, Open  ]],
Cell[4282, 162, 72, 1, 70, "ExampleText",
 CellID->8710499],
Cell[CellGroupData[{
Cell[4379, 167, 139, 4, 70, "Input",
 CellID->809522726],
Cell[4521, 173, 520, 12, 71, "Output",
 CellID->45649438]
}, Open  ]],
Cell[5056, 188, 90, 1, 70, "ExampleText",
 CellID->339208545],
Cell[CellGroupData[{
Cell[5171, 193, 114, 3, 70, "Input",
 CellID->804254513],
Cell[5288, 198, 485, 9, 70, "Message",
 CellID->1430766],
Cell[5776, 209, 164, 5, 36, "Output",
 CellID->129080510]
}, Open  ]],
Cell[5955, 217, 256, 9, 70, "ExampleText",
 CellID->181266568],
Cell[6214, 228, 183, 5, 70, "Input",
 CellID->336192175],
Cell[6400, 235, 77, 1, 70, "ExampleText",
 CellID->328443058],
Cell[CellGroupData[{
Cell[6502, 240, 139, 4, 70, "Input",
 CellID->187463474],
Cell[6644, 246, 175, 6, 36, "Output",
 CellID->540275430]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6880, 259, 311, 9, 70, "SeeAlsoSection",
 CellID->10638],
Cell[7194, 270, 199, 6, 70, "SeeAlso",
 CellID->4391]
}, Open  ]],
Cell[7408, 279, 27, 0, 70, "History"],
Cell[7438, 281, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

