(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13842,        494]
NotebookOptionsPosition[     10444,        379]
NotebookOutlinePosition[     11763,        417]
CellTagsIndexPosition[     11678,        412]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Files and Directories" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingFilesAndDirectories"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Files and Directories\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CreateDirectory" :> 
          Documentation`HelpLookup["paclet:ref/CreateDirectory"], 
          "DeleteFile" :> Documentation`HelpLookup["paclet:ref/DeleteFile"], 
          "CopyDirectory" :> 
          Documentation`HelpLookup["paclet:ref/CopyDirectory"], 
          "RenameDirectory" :> 
          Documentation`HelpLookup["paclet:ref/RenameDirectory"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CreateDirectory\"\>", 
       2->"\<\"DeleteFile\"\>", 3->"\<\"CopyDirectory\"\>", 
       4->"\<\"RenameDirectory\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Directories & Directory Operations" :> 
          Documentation`HelpLookup[
           "paclet:guide/DirectoriesAndDirectoryOperations"], 
          "File Operations" :> 
          Documentation`HelpLookup["paclet:guide/FileOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Directories & Directory Operations\"\>", 
       2->"\<\"File Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DeleteDirectory", "ObjectName",
 CellID->27930],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DeleteDirectory",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DeleteDirectory"], "[", "\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]deletes the specified directory. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24628]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DeleteDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DeleteDirectory"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\"", ",", 
    RowBox[{
     ButtonBox["DeleteContents",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DeleteContents"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}]}], "]"}]], "InlineFormula"],
 " deletes ",
 Cell[BoxData[
  StyleBox["dir", "TI"]], "InlineFormula"],
 " and all files and directories that it contains. "
}], "Notes",
 CellID->25395],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DeleteDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DeleteDirectory"], "[", "\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " deletes the directory ",
 Cell[BoxData[
  StyleBox["dir", "TI"]], "InlineFormula"],
 " only if it contains no files. "
}], "Notes",
 CellID->583],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DeleteDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DeleteDirectory"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 " if it succeeds in deleting a directory, and ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 " if it fails. "
}], "Notes",
 CellID->13833]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->25525959],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->59138644],

Cell["Create a directory:", "ExampleText",
 CellID->598993908],

Cell[BoxData[
 RowBox[{
  RowBox[{"dir", "=", 
   RowBox[{"$TemporaryPrefix", "<>", " ", "\"\<test\>\""}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->194619255],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CreateDirectory", "[", "dir", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18517641],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\test\"\>"], "Output",
 ImageSize->{396, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->51046597]
}, Open  ]],

Cell["Check the presense of the new directory: ", "ExampleText",
 CellID->108733167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileNames", "[", "dir", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->53533964],

Cell[BoxData[
 RowBox[{"{", "\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\test\"\>", "}"}]], "Output",
 ImageSize->{410, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->256360596]
}, Open  ]],

Cell["Delete the directory:", "ExampleText",
 CellID->180624214],

Cell[BoxData[
 RowBox[{"DeleteDirectory", "[", "dir", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->224760882],

Cell["The directory is no longer there: ", "ExampleText",
 CellID->183508161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileNames", "[", "dir", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->655248885],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->340278192]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31990],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreateDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeleteFile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DeleteFile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CopyDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CopyDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RenameDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RenameDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9772]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3127],

Cell[TextData[ButtonBox["Manipulating Files and Directories",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingFilesAndDirectories"]], "Tutorials",\

 CellID->2045]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->638343504],

Cell[TextData[ButtonBox["Directories & Directory Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DirectoriesAndDirectoryOperations"]], "MoreAbout",
 CellID->72948693],

Cell[TextData[ButtonBox["File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FileOperations"]], "MoreAbout",
 CellID->497206116]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DeleteDirectory - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 37, 10.0376094}", "context" -> "System`", 
    "keywords" -> {
     "directories", "purging directories", "file utilities", 
      "file operations"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DeleteDirectory[\"dir\"] deletes the specified directory. ", 
    "synonyms" -> {"delete directory", "rmdir"}, "title" -> "DeleteDirectory",
     "type" -> "Symbol", "uri" -> "ref/DeleteDirectory"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5578, 183, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->25525959]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11536, 405}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2370, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2993, 85, 53, 1, 70, "ObjectName",
 CellID->27930],
Cell[3049, 88, 506, 15, 70, "Usage",
 CellID->24628]
}, Open  ]],
Cell[CellGroupData[{
Cell[3592, 108, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4070, 125, 609, 20, 70, "Notes",
 CellID->25395],
Cell[4682, 147, 369, 12, 70, "Notes",
 CellID->583],
Cell[5054, 161, 487, 17, 70, "Notes",
 CellID->13833]
}, Closed]],
Cell[CellGroupData[{
Cell[5578, 183, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->25525959],
Cell[CellGroupData[{
Cell[5962, 197, 147, 5, 70, "ExampleSection",
 CellID->59138644],
Cell[6112, 204, 62, 1, 70, "ExampleText",
 CellID->598993908],
Cell[6177, 207, 170, 6, 70, "Input",
 CellID->194619255],
Cell[CellGroupData[{
Cell[6372, 217, 112, 3, 28, "Input",
 CellID->18517641],
Cell[6487, 222, 238, 6, 36, "Output",
 CellID->51046597]
}, Open  ]],
Cell[6740, 231, 84, 1, 70, "ExampleText",
 CellID->108733167],
Cell[CellGroupData[{
Cell[6849, 236, 106, 3, 70, "Input",
 CellID->53533964],
Cell[6958, 241, 261, 7, 36, "Output",
 CellID->256360596]
}, Open  ]],
Cell[7234, 251, 64, 1, 70, "ExampleText",
 CellID->180624214],
Cell[7301, 254, 113, 3, 70, "Input",
 CellID->224760882],
Cell[7417, 259, 77, 1, 70, "ExampleText",
 CellID->183508161],
Cell[CellGroupData[{
Cell[7519, 264, 107, 3, 70, "Input",
 CellID->655248885],
Cell[7629, 269, 175, 6, 36, "Output",
 CellID->340278192]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7865, 282, 311, 9, 70, "SeeAlsoSection",
 CellID->31990],
Cell[8179, 293, 982, 35, 70, "SeeAlso",
 CellID->9772]
}, Open  ]],
Cell[CellGroupData[{
Cell[9198, 333, 313, 9, 70, "TutorialsSection",
 CellID->3127],
Cell[9514, 344, 177, 4, 70, "Tutorials",
 CellID->2045]
}, Open  ]],
Cell[CellGroupData[{
Cell[9728, 353, 319, 9, 70, "MoreAboutSection",
 CellID->638343504],
Cell[10050, 364, 178, 3, 70, "MoreAbout",
 CellID->72948693],
Cell[10231, 369, 141, 3, 70, "MoreAbout",
 CellID->497206116]
}, Open  ]],
Cell[10387, 375, 27, 0, 70, "History"],
Cell[10417, 377, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

