(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37994,       1412]
NotebookOptionsPosition[     29781,       1118]
NotebookOutlinePosition[     31033,       1155]
CellTagsIndexPosition[     30947,       1150]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Picking Out Pieces of Algebraic Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PickingOutPiecesOfAlgebraicExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Picking Out Pieces of Algebraic Expressions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerator" :> Documentation`HelpLookup["paclet:ref/Numerator"],
           "ExpandDenominator" :> 
          Documentation`HelpLookup["paclet:ref/ExpandDenominator"], 
          "Rationals" :> Documentation`HelpLookup["paclet:ref/Rationals"], 
          "Rational" :> Documentation`HelpLookup["paclet:ref/Rational"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Numerator\"\>", 
       2->"\<\"ExpandDenominator\"\>", 3->"\<\"Rationals\"\>", 
       4->"\<\"Rational\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Formula Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/FormulaManipulation"], 
          "Rational Functions" :> 
          Documentation`HelpLookup["paclet:guide/RationalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Formula Manipulation\"\>", 
       2->"\<\"Rational Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Denominator", "ObjectName",
 CellID->11465],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Denominator",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Denominator"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the denominator of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12249]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Denominator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Denominator"]], "InlineFormula"],
 " picks out terms which have superficially negative exponents. ",
 Cell[BoxData[
  ButtonBox["Numerator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Numerator"]], "InlineFormula"],
 " picks out all remaining terms. "
}], "Notes",
 CellID->12158],

Cell["\<\
An exponent is \"superficially negative\" if it has a negative number as a \
factor. \
\>", "Notes",
 CellID->30148],

Cell[TextData[{
 "The standard representation of rational expressions as products of powers \
means that you cannot simply use ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " to extract denominators. "
}], "Notes",
 CellID->29766],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Denominator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Denominator"]], "InlineFormula"],
 " can be used on rational numbers. "
}], "Notes",
 CellID->25070]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->435079045],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->150604480],

Cell["Extract denominator of a rational number:", "ExampleText",
 CellID->290113945],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Denominator", "[", 
  RowBox[{"2", "/", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->458387881],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20548699]
}, Open  ]],

Cell["Extract denominator of a rational expression:", "ExampleText",
 CellID->52153719],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Denominator", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "-", "1"}], ")"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "2"}], ")"}], "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "3"}], ")"}], "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9136498],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "3"}], "+", "x"}], ")"}], "2"]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->497409056]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1667],

Cell["Rational numbers:", "ExampleText",
 CellID->303603321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Denominator", "[", 
  RowBox[{"3", "/", "7"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->660797967],

Cell[BoxData["7"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38728751]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->45153912],

Cell["Rational expressions:", "ExampleText",
 CellID->482547240],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Denominator", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "2"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "3"}], ")"}]}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94199317],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "3"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", "x"}], ")"}]}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->218870707]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->762649483],

Cell["Select terms with syntactically negative exponents:", "ExampleText",
 CellID->436957419],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{"a", " ", 
   RowBox[{"x", "^", "n"}], " ", 
   RowBox[{"y", "^", 
    RowBox[{"-", "m"}]}], " ", 
   RowBox[{"Exp", "[", 
    RowBox[{"a", "-", "b", "-", 
     RowBox[{"2", "c"}], "+", 
     RowBox[{"3", "d"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->220223837],

Cell[BoxData[
 RowBox[{"a", " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"a", "-", "b", "-", 
    RowBox[{"2", " ", "c"}], "+", 
    RowBox[{"3", " ", "d"}]}]], " ", 
  SuperscriptBox["x", "n"], " ", 
  SuperscriptBox["y", 
   RowBox[{"-", "m"}]]}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->536082049]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Denominator", "[", "expr", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->272874461],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"b", "+", 
    RowBox[{"2", " ", "c"}]}]], " ", 
  SuperscriptBox["y", "m"]}]], "Output",
 ImageSize->{50, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->643262071]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->86008629],

Cell["All exponents syntactically negative:", "ExampleText",
 CellID->79184396],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Denominator", "[", 
  RowBox[{
   RowBox[{"a", "^", 
    RowBox[{"-", "b"}]}], "/", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->62513214],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "b"], " ", "x"}]], "Output",
 ImageSize->{27, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59440805]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->434145890],

Cell["No syntactically negative exponents:", "ExampleText",
 CellID->177712008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Denominator", "[", 
  RowBox[{"2", 
   RowBox[{"x", "^", "y"}], " ", 
   RowBox[{"b", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28994944],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->211531973]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->919848036],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Denominator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Denominator"]], "InlineFormula"],
 " automatically threads over lists:"
}], "ExampleText",
 CellID->27341965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Denominator", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
   "/", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25086],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "3", ",", "1", ",", "3", ",", "3", ",", "1"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->737660081]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4246],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->5187],

Cell[TextData[{
 "Find denominators over integers modulo ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->487210857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Denominator", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "/", "3"}], " ", "x"}], "+", 
      RowBox[{
       RowBox[{"3", "/", "4"}], " ", "y"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"3", "/", "5"}], "x"}], "-", 
      RowBox[{
       RowBox[{"1", "/", "2"}], "y"}]}], ")"}]}], ",", 
   RowBox[{"Modulus", "\[Rule]", "7"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40258755],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "x"}], "+", 
  RowBox[{"3", " ", "y"}]}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->319018505]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Trig",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->13517],

Cell["Denominators of trigonometric functions:", "ExampleText",
 CellID->141797566],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Denominator", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}], ",", 
     RowBox[{"Tan", "[", "x", "]"}], ",", 
     RowBox[{"Csc", "[", "x", "]"}], ",", 
     RowBox[{"Sec", "[", "x", "]"}], ",", 
     RowBox[{"Cot", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"Trig", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->127976950],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", 
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"Sin", "[", "x", "]"}]}], "}"}]], "Output",
 ImageSize->{256, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->262427739]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2071],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Numerator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Numerator"]], "InlineFormula"],
 " gives the terms without negative exponents:"
}], "ExampleText",
 CellID->290280074],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Numerator", "[", 
  RowBox[{
   RowBox[{"2", "/", "3"}], "a", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"x", "-", "2"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64699991],

Cell[BoxData[
 RowBox[{"2", " ", "a", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], ")"}]}]], "Output",
 ImageSize->{73, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->649756081]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->114732552],

Cell["\<\
An expression is a quotient of its numerator and denominator:\
\>", "ExampleText",
 CellID->33907498],

Cell[BoxData[
 RowBox[{
  RowBox[{"expr", "=", 
   RowBox[{
    RowBox[{"5", "/", "7"}], 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "2"}], ")"}], "^", "3"}]}], 
    RowBox[{"a", "^", "b"}], " ", 
    RowBox[{"c", "^", 
     RowBox[{"-", "d"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49509921],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"num", "=", 
  RowBox[{"Numerator", "[", "expr", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->292824365],

Cell[BoxData[
 RowBox[{"5", " ", 
  SuperscriptBox["a", "b"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}], "2"]}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->199069418]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"den", "=", 
  RowBox[{"Denominator", "[", "expr", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->382232114],

Cell[BoxData[
 RowBox[{"7", " ", 
  SuperscriptBox["c", "d"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "x"}], ")"}], "3"]}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->15346609]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "===", 
  RowBox[{"num", "/", "den"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->146923493],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->246140677]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->429618857],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Cancel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cancel"]], "InlineFormula"],
 " to cancel common factors between the numerator and the denominator:"
}], "ExampleText",
 CellID->23999272],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cancel", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "-", "1"}], ")"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "2"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "1"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->876864933],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "2"}], "+", "x"}], 
  RowBox[{"1", "+", "x"}]]], "Output",
 ImageSize->{43, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->98590914]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->100840501],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Together",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Together"]], "InlineFormula"],
 " writes an expression as a fraction and cancels common terms:"
}], "ExampleText",
 CellID->348414279],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", 
  RowBox[{
   RowBox[{"x", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "2"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", "1"}], ")"}]}]}], "+", 
   RowBox[{"x", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "1"}], ")"}]}], "-", 
   RowBox[{"2", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "1"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->61962394],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "2"}], "+", "x"}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", "x"}]]], "Output",
 ImageSize->{43, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->338487131]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26631198],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ExpandDenominator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpandDenominator"]], "InlineFormula"],
 " to directly expand all denominators:"
}], "ExampleText",
 CellID->751907506],

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "1"}], ")"}], "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "2"}], ")"}], "^", "2"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->540100241],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandDenominator", "[", "r", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->701641134],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", "x"}], 
  RowBox[{"4", "+", 
   RowBox[{"4", " ", "x"}], "+", 
   SuperscriptBox["x", "2"]}]]], "Output",
 ImageSize->{70, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->303543365]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Numerator", "[", "r", "]"}], "/", 
  RowBox[{"Expand", "[", 
   RowBox[{"Denominator", "[", "r", "]"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->10700955],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", "x"}], 
  RowBox[{"4", "+", 
   RowBox[{"4", " ", "x"}], "+", 
   SuperscriptBox["x", "2"]}]]], "Output",
 ImageSize->{70, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->506490266]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17235],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Denominator", "[", 
     RowBox[{"i", "/", "j"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "30"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "30"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12625],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnTFM20AUhpOi6jy1YqhUpA6IkZWRFbULHRkZIlQEQ2lFkRhZWRlZGVkZ
WRlZM2Zgyciakd53ybOOixNixyEp/SOF2Hf3zp+XX/7fPR/fWycHP362Tg73
Wqvfjlu/Dw73/qx+/XXsm5aajUbjge/nhj9+8kf979LTEwd8Ov7b7J8u0Rc+
jY7/0+wPeIXWd/7Pp16v5x4fHz/ye3d35zqdjut2u47zq6urzPe5i4uL0Efb
7e2tOzo6Yky2u7tLbOjzY93m5ibxWbvdDjE3Nzfu/PzcZVlG7HtRiEIUFSnc
gCJcGQI/Q3Z/fx9m5orMdH19HYguLy/D7Mx8dnbmTk9PA9H+/n4g2tnZcdvb
225raysQbWxsZOvr625tbc2trKy45eXlcD2PICIRiWjeRB8YYZoDjR1DCQ16
Ag3t0NAHDfTQ+DGBhnGMMS3ydxVoiIGGOLTIx4pGNKJ5LZr8yvya5tiTA5pD
u2kO/aY5XN00x4/PNYc40xwfn2sO86A5EPn5RCQiEc2bKNciKEyLzGvEWsRT
iPkQtMi8hmkR1DxtmBb5p5NAQwxaZF5jMmUUjWhE8wZphhyOPx9yOPSnDofx
qcMhPnU4zB87HIj8/CISkYjmTfTFHI/pjGmTaRDnltGkDbo4o0lbnNHkjszx
cDf0QeHHiUIUoqhKMbNMJPMWZSIhaswlNyoiEYmovGewpwnTonGegfliz2AZ
yvocjGhEI5ryPjzNRHLOFaFLM5ED8lxzWG8wzSGuKBPJnRFfPTcqIhGJqFYi
0yJ+cx2y1Uf64tVH+uzJJNYhxsX5QAjbg+oidMh8ho8ViUhE8nZJanMwzDNJ
3dLreSoRiUhEY4msTvlZ1nKw3pBnLeNaZdrM1aBd5mrSWmVzNdypuZqxWUuR
iEQk1Uim1hXiy9Qez17pRCQiEZXL+A90J/cTnBfVJFt2kv60Jjn2E6xKxtlJ
8xPlK6RFIxrRVKYZykLy9BDXHtvaRFp7zPg0C0k/cXEWEkrLQprm+PlEJCIR
zZuocPXR6NIq4Pido6LVR2LTKmDTIuavthYqGtGI5o3QlHY4jC/7JjPzz85z
iUhEIqpENFTDbHSmQbTHGU1bleyOqGH28TVUUotCFKKoph04mElrj5lv9rlR
EYlIRFMRPfMMvaiKyDwD/bFnsCqi1DMQn74b3I6qiGwFcqJ6JtGIRjT10Axl
Itsz2nGEO1isPVBEJKL/nKjyCiTUi7MeKhrRiKacp6B9VCUR40d5CuYZVUlk
7xZVczkiEpGI3jjRyHrmOLNJf1E9s2U2x9Uzc0fTVVaLRCQiKbcq0Kt557D2
oH5pcfYyE5GIRDTe4UAxzuHYCuUoh5PuTz6d3xKNaERTiebFTCUUL2Uq4x1J
RmUq4/rk6XKnIhKRiGohKrUjeKxFRZXCRTuCpyuU9e1PLhrRiKb+6vtJKo0W
Y9cSEYlIRP8QUbX/F/zQ72v+BWGQICQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->632782702]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9947],

Cell[TextData[{
 "Cyclic addition [",
 ButtonBox["more info",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/page-950b-text"], None}],
 "]:"
}], "ExampleText",
 CellID->16006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Flatten", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"i", "/", "j"}], ",", 
        RowBox[{"Denominator", "[", 
         RowBox[{"i", "/", "j"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "20"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "20"}], "}"}]}], "]"}], ",", "1"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17388],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->653046188]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4683],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Numerator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Numerator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpandDenominator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpandDenominator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rationals",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rationals"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rational",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rational"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13460]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1496],

Cell[TextData[ButtonBox["Picking Out Pieces of Algebraic Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PickingOutPiecesOfAlgebraicExpressions"]], "Tutorials",
 CellID->6693]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->345841215],

Cell[TextData[ButtonBox["Formula Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormulaManipulation"]], "MoreAbout",
 CellID->252533326],

Cell[TextData[ButtonBox["Rational Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RationalFunctions"]], "MoreAbout",
 CellID->495886725]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Denominator - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 37, 22.9598152}", "context" -> "System`", 
    "keywords" -> {
     "aliquant", "denom", "denominator", "divide by", "dividend"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Denominator[expr] gives the denominator of expr. ", "synonyms" -> {}, 
    "title" -> "Denominator", "type" -> "Symbol", "uri" -> 
    "ref/Denominator"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5103, 167, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->435079045]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 30804, 1143}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2287, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2910, 81, 49, 1, 70, "ObjectName",
 CellID->11465],
Cell[2962, 84, 555, 18, 70, "Usage",
 CellID->12249]
}, Open  ]],
Cell[CellGroupData[{
Cell[3554, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4032, 124, 393, 12, 70, "Notes",
 CellID->12158],
Cell[4428, 138, 126, 4, 70, "Notes",
 CellID->30148],
Cell[4557, 144, 299, 9, 70, "Notes",
 CellID->29766],
Cell[4859, 155, 207, 7, 70, "Notes",
 CellID->25070]
}, Closed]],
Cell[CellGroupData[{
Cell[5103, 167, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->435079045],
Cell[CellGroupData[{
Cell[5488, 181, 148, 5, 70, "ExampleSection",
 CellID->150604480],
Cell[5639, 188, 84, 1, 70, "ExampleText",
 CellID->290113945],
Cell[CellGroupData[{
Cell[5748, 193, 130, 4, 28, "Input",
 CellID->458387881],
Cell[5881, 199, 157, 5, 36, "Output",
 CellID->20548699]
}, Open  ]],
Cell[6053, 207, 87, 1, 70, "ExampleText",
 CellID->52153719],
Cell[CellGroupData[{
Cell[6165, 212, 325, 12, 28, "Input",
 CellID->9136498],
Cell[6493, 226, 248, 9, 36, "Output",
 CellID->497409056]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6790, 241, 215, 7, 70, "ExampleSection",
 CellID->1667],
Cell[7008, 250, 60, 1, 70, "ExampleText",
 CellID->303603321],
Cell[CellGroupData[{
Cell[7093, 255, 130, 4, 70, "Input",
 CellID->660797967],
Cell[7226, 261, 157, 5, 36, "Output",
 CellID->38728751]
}, Open  ]],
Cell[7398, 269, 124, 3, 70, "ExampleDelimiter",
 CellID->45153912],
Cell[7525, 274, 64, 1, 70, "ExampleText",
 CellID->482547240],
Cell[CellGroupData[{
Cell[7614, 279, 354, 13, 70, "Input",
 CellID->94199317],
Cell[7971, 294, 315, 12, 36, "Output",
 CellID->218870707]
}, Open  ]],
Cell[8301, 309, 125, 3, 70, "ExampleDelimiter",
 CellID->762649483],
Cell[8429, 314, 94, 1, 70, "ExampleText",
 CellID->436957419],
Cell[CellGroupData[{
Cell[8548, 319, 324, 11, 70, "Input",
 CellID->220223837],
Cell[8875, 332, 400, 13, 36, "Output",
 CellID->536082049]
}, Open  ]],
Cell[CellGroupData[{
Cell[9312, 350, 110, 3, 70, "Input",
 CellID->272874461],
Cell[9425, 355, 291, 10, 36, "Output",
 CellID->643262071]
}, Open  ]],
Cell[9731, 368, 124, 3, 70, "ExampleDelimiter",
 CellID->86008629],
Cell[9858, 373, 79, 1, 70, "ExampleText",
 CellID->79184396],
Cell[CellGroupData[{
Cell[9962, 378, 173, 6, 70, "Input",
 CellID->62513214],
Cell[10138, 386, 203, 7, 36, "Output",
 CellID->59440805]
}, Open  ]],
Cell[10356, 396, 125, 3, 70, "ExampleDelimiter",
 CellID->434145890],
Cell[10484, 401, 79, 1, 70, "ExampleText",
 CellID->177712008],
Cell[CellGroupData[{
Cell[10588, 406, 182, 6, 70, "Input",
 CellID->28994944],
Cell[10773, 414, 158, 5, 36, "Output",
 CellID->211531973]
}, Open  ]],
Cell[10946, 422, 125, 3, 70, "ExampleDelimiter",
 CellID->919848036],
Cell[11074, 427, 216, 7, 70, "ExampleText",
 CellID->27341965],
Cell[CellGroupData[{
Cell[11315, 438, 219, 7, 70, "Input",
 CellID->25086],
Cell[11537, 447, 247, 8, 36, "Output",
 CellID->737660081]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11833, 461, 217, 7, 70, "ExampleSection",
 CellID->4246],
Cell[CellGroupData[{
Cell[12075, 472, 223, 7, 70, "ExampleSubsection",
 CellID->5187],
Cell[12301, 481, 160, 6, 70, "ExampleText",
 CellID->487210857],
Cell[CellGroupData[{
Cell[12486, 491, 501, 18, 70, "Input",
 CellID->40258755],
Cell[12990, 511, 226, 8, 36, "Output",
 CellID->319018505]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13265, 525, 221, 7, 70, "ExampleSubsection",
 CellID->13517],
Cell[13489, 534, 83, 1, 70, "ExampleText",
 CellID->141797566],
Cell[CellGroupData[{
Cell[13597, 539, 453, 13, 70, "Input",
 CellID->127976950],
Cell[14053, 554, 368, 11, 36, "Output",
 CellID->262427739]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[14482, 572, 232, 7, 70, "ExampleSection",
 CellID->2071],
Cell[14717, 581, 223, 7, 70, "ExampleText",
 CellID->290280074],
Cell[CellGroupData[{
Cell[14965, 592, 277, 10, 70, "Input",
 CellID->64699991],
Cell[15245, 604, 257, 9, 36, "Output",
 CellID->649756081]
}, Open  ]],
Cell[15517, 616, 125, 3, 70, "ExampleDelimiter",
 CellID->114732552],
Cell[15645, 621, 111, 3, 70, "ExampleText",
 CellID->33907498],
Cell[15759, 626, 429, 16, 70, "Input",
 CellID->49509921],
Cell[CellGroupData[{
Cell[16213, 646, 133, 4, 70, "Input",
 CellID->292824365],
Cell[16349, 652, 308, 11, 36, "Output",
 CellID->199069418]
}, Open  ]],
Cell[CellGroupData[{
Cell[16694, 668, 135, 4, 70, "Input",
 CellID->382232114],
Cell[16832, 674, 307, 11, 36, "Output",
 CellID->15346609]
}, Open  ]],
Cell[CellGroupData[{
Cell[17176, 690, 124, 4, 70, "Input",
 CellID->146923493],
Cell[17303, 696, 161, 5, 36, "Output",
 CellID->246140677]
}, Open  ]],
Cell[17479, 704, 125, 3, 70, "ExampleDelimiter",
 CellID->429618857],
Cell[17607, 709, 249, 8, 70, "ExampleText",
 CellID->23999272],
Cell[CellGroupData[{
Cell[17881, 721, 322, 12, 70, "Input",
 CellID->876864933],
Cell[18206, 735, 242, 9, 51, "Output",
 CellID->98590914]
}, Open  ]],
Cell[18463, 747, 125, 3, 70, "ExampleDelimiter",
 CellID->100840501],
Cell[18591, 752, 238, 7, 70, "ExampleText",
 CellID->348414279],
Cell[CellGroupData[{
Cell[18854, 763, 518, 19, 70, "Input",
 CellID->61962394],
Cell[19375, 784, 262, 10, 51, "Output",
 CellID->338487131]
}, Open  ]],
Cell[19652, 797, 124, 3, 70, "ExampleDelimiter",
 CellID->26631198],
Cell[19779, 802, 241, 8, 70, "ExampleText",
 CellID->751907506],
Cell[20023, 812, 263, 10, 70, "Input",
 CellID->540100241],
Cell[CellGroupData[{
Cell[20311, 826, 113, 3, 70, "Input",
 CellID->701641134],
Cell[20427, 831, 283, 10, 53, "Output",
 CellID->303543365]
}, Open  ]],
Cell[CellGroupData[{
Cell[20747, 846, 199, 6, 70, "Input",
 CellID->10700955],
Cell[20949, 854, 283, 10, 53, "Output",
 CellID->506490266]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21281, 870, 224, 7, 70, "ExampleSection",
 CellID->17235],
Cell[CellGroupData[{
Cell[21530, 881, 337, 11, 70, "Input",
 CellID->12625],
Cell[21870, 894, 1761, 33, 70, "Output",
 Evaluatable->False,
 CellID->632782702]
}, Open  ]],
Cell[23646, 930, 120, 3, 70, "ExampleDelimiter",
 CellID->9947],
Cell[23769, 935, 219, 8, 70, "ExampleText",
 CellID->16006],
Cell[CellGroupData[{
Cell[24013, 947, 501, 17, 70, "Input",
 CellID->17388],
Cell[24517, 966, 2648, 48, 70, "Output",
 Evaluatable->False,
 CellID->653046188]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27226, 1021, 310, 9, 70, "SeeAlsoSection",
 CellID->4683],
Cell[27539, 1032, 963, 35, 70, "SeeAlso",
 CellID->13460]
}, Open  ]],
Cell[CellGroupData[{
Cell[28539, 1072, 313, 9, 70, "TutorialsSection",
 CellID->1496],
Cell[28855, 1083, 194, 4, 70, "Tutorials",
 CellID->6693]
}, Open  ]],
Cell[CellGroupData[{
Cell[29086, 1092, 319, 9, 70, "MoreAboutSection",
 CellID->345841215],
Cell[29408, 1103, 151, 3, 70, "MoreAbout",
 CellID->252533326],
Cell[29562, 1108, 147, 3, 70, "MoreAbout",
 CellID->495886725]
}, Open  ]],
Cell[29724, 1114, 27, 0, 70, "History"],
Cell[29754, 1116, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

