(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21435,        698]
NotebookOptionsPosition[     17629,        570]
NotebookOutlinePosition[     19110,        611]
CellTagsIndexPosition[     19025,        606]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"NDSolve" :> Documentation`HelpLookup["paclet:ref/NDSolve"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"NDSolve\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DependentVariables", "ObjectName",
 CellID->24908],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["DependentVariables",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DependentVariables"]], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["NDSolve",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
     " which specifies the list of all objects that should be considered as \
dependent variables in the equations supplied."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3162]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NDSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NDSolve"], "[", 
   RowBox[{
    StyleBox["eqns", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " specifies that ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " should return solutions for the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["y", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "Notes",
 CellID->427828626],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"DependentVariables", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["u", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["u", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " specifies a complete list of dependent variables ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["u", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " representing functions that should be solved for, even if the solutions \
are not eventually returned."
}], "Notes",
 CellID->2050]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19528302],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->61139441],

Cell["Save only the solution for x[t]:", "ExampleText",
 CellID->507238825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xsol", " ", "=", " ", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{"y", "[", "t", "]"}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{"-", 
        RowBox[{"Sin", "[", 
         RowBox[{"x", "[", "t", "]"}], "]"}]}]}], ",", 
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], "\[Equal]", "3.1"}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", "x", 
    ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "20"}], "}"}], ",", 
    RowBox[{"DependentVariables", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29973561],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{316, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36520372]
}, Open  ]],

Cell["Plot the solution x[t] as a function of t:", "ExampleText",
 CellID->552829724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"First", "[", 
     RowBox[{
      RowBox[{"x", "[", "t", "]"}], " ", "/.", " ", "xsol"}], "]"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21967455],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->87125264]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->245492909],

Cell["Set up a very large system of equations:", "ExampleText",
 CellID->285735470],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", " ", "=", " ", "1000"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"vars", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["x", "i"], "[", "t", "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", " ", "n"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eqns", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"j", " ", "=", " ", 
       RowBox[{
        RowBox[{"Mod", "[", 
         RowBox[{"i", ",", " ", "n"}], "]"}], " ", "+", " ", "1"}]}], ";", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           SubscriptBox["x", "i"], "'"}], "[", "t", "]"}], " ", "\[Equal]", 
         " ", 
         RowBox[{"1", "/", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SubscriptBox["x", "i"], "[", "t", "]"}], " ", "+", " ", 
             RowBox[{
              SubscriptBox["x", "j"], "[", "t", "]"}]}], ")"}], "2"]}]}], ",",
         " ", 
        RowBox[{
         RowBox[{
          SubscriptBox["x", "i"], "[", "0", "]"}], " ", "\[Equal]", " ", 
         RowBox[{"1", "/", "i"}]}]}], "}"}]}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", " ", "n"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->136919303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{"eqns", ",", " ", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->468903557],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox[
         SubscriptBox["x", "1"], "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
       FractionBox["1", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SubscriptBox["x", "1"], "[", "t", "]"}], "+", 
           RowBox[{
            SubscriptBox["x", "2"], "[", "t", "]"}]}], ")"}], "2"]]}], ",", 
      RowBox[{
       RowBox[{
        SubscriptBox["x", "1"], "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], 
    ",", 
    RowBox[{"\[LeftSkeleton]", "998", "\[RightSkeleton]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox[
         SubscriptBox["x", "1000"], "\[Prime]",
         MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
       FractionBox["1", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SubscriptBox["x", "1"], "[", "t", "]"}], "+", 
           RowBox[{
            SubscriptBox["x", "1000"], "[", "t", "]"}]}], ")"}], "2"]]}], ",",
       
      RowBox[{
       RowBox[{
        SubscriptBox["x", "1000"], "[", "0", "]"}], "\[Equal]", 
       FractionBox["1", "1000"]}]}], "}"}]}], "}"}],
  Short[#, 3]& ]], "Output",
 ImageSize->{389, 66},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//Short=",
 CellID->368647351]
}, Open  ]],

Cell[TextData[{
 "Solve for all of the dependent variables, but save only the solution for ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["x", "1"], "."}]], "InlineFormula"]
}], "ExampleText",
 CellID->11419481],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"NDSolve", "[", 
   RowBox[{"eqns", ",", " ", 
    SubscriptBox["x", "1"], ",", " ", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", " ", 
    RowBox[{"DependentVariables", "\[Rule]", "vars"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->3202441],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["x", "1"], "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "100.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{328, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->97420985]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["x", "1"], "[", "t", "]"}], " ", "/.", " ", "sol"}], ",", 
   " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->211402592],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->500387660]
}, Open  ]],

Cell["This saves a lot of memory versus saving all the solutions:", \
"ExampleText",
 CellID->465639542],

Cell[BoxData[
 RowBox[{
  RowBox[{"allsol", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{"eqns", ",", "vars", ",", " ", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "100"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->85125647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ByteCount", "[", "sol", "]"}], ",", " ", 
   RowBox[{"ByteCount", "[", "allsol", "]"}]}], "}"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->990893065],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"14140", ",", "14144056"}], "}"}]], "Output",
 ImageSize->{127, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->26394259]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12455],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->132018549]
}, Open  ]],

Cell["New in 5.0", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DependentVariables - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 37, 56.8513078}", "context" -> "System`", 
    "keywords" -> {
     "output variables in differential equations", 
      "projecting differential equation solutions", 
      "solve variables for NDSolve"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DependentVariables is an option to NDSolve which specifies the list of \
all objects that should be considered as dependent variables in the equations \
supplied.", "synonyms" -> {"dependent variables"}, "title" -> 
    "DependentVariables", "type" -> "Symbol", "uri" -> 
    "ref/DependentVariables"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3894, 142, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->19528302]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18883, 599}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 553, 14, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1176, 41, 56, 1, 70, "ObjectName",
 CellID->24908],
Cell[1235, 44, 679, 19, 70, "Usage",
 CellID->3162]
}, Open  ]],
Cell[CellGroupData[{
Cell[1951, 68, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2429, 85, 808, 30, 70, "Notes",
 CellID->427828626],
Cell[3240, 117, 617, 20, 70, "Notes",
 CellID->2050]
}, Closed]],
Cell[CellGroupData[{
Cell[3894, 142, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19528302],
Cell[CellGroupData[{
Cell[4278, 156, 147, 5, 70, "ExampleSection",
 CellID->61139441],
Cell[4428, 163, 75, 1, 70, "ExampleText",
 CellID->507238825],
Cell[CellGroupData[{
Cell[4528, 168, 866, 27, 47, "Input",
 CellID->29973561],
Cell[5397, 197, 466, 17, 36, "Output",
 CellID->36520372]
}, Open  ]],
Cell[5878, 217, 85, 1, 70, "ExampleText",
 CellID->552829724],
Cell[CellGroupData[{
Cell[5988, 222, 328, 11, 28, "Input",
 CellID->21967455],
Cell[6319, 235, 2660, 48, 129, "Output",
 Evaluatable->False,
 CellID->87125264]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9028, 289, 227, 7, 70, "ExampleSection",
 CellID->245492909],
Cell[9258, 298, 83, 1, 70, "ExampleText",
 CellID->285735470],
Cell[9344, 301, 1365, 43, 70, "Input",
 CellID->136919303],
Cell[CellGroupData[{
Cell[10734, 348, 132, 4, 70, "Input",
 CellID->468903557],
Cell[10869, 354, 1492, 49, 87, "Output",
 CellID->368647351]
}, Open  ]],
Cell[12376, 406, 209, 6, 70, "ExampleText",
 CellID->11419481],
Cell[CellGroupData[{
Cell[12610, 416, 336, 9, 70, "Input",
 CellID->3202441],
Cell[12949, 427, 491, 18, 36, "Output",
 CellID->97420985]
}, Open  ]],
Cell[CellGroupData[{
Cell[13477, 450, 340, 11, 70, "Input",
 CellID->211402592],
Cell[13820, 463, 2327, 42, 70, "Output",
 Evaluatable->False,
 CellID->500387660]
}, Open  ]],
Cell[16162, 508, 104, 2, 70, "ExampleText",
 CellID->465639542],
Cell[16269, 512, 270, 8, 70, "Input",
 CellID->85125647],
Cell[CellGroupData[{
Cell[16564, 524, 201, 6, 70, "Input",
 CellID->990893065],
Cell[16768, 532, 214, 7, 36, "Output",
 CellID->26394259]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17043, 546, 311, 9, 70, "SeeAlsoSection",
 CellID->12455],
Cell[17357, 557, 198, 6, 70, "SeeAlso",
 CellID->132018549]
}, Open  ]],
Cell[17570, 566, 29, 0, 70, "History"],
Cell[17602, 568, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

